//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 9 materials and 111 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 08/29/2002    (29.08.2002)
//



/* // Scene Comment



*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.098039,0.098039,0.098039>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <     50.000,    -130.000,      80.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    0.74492,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         18.39614    // Vertical      24.528
  look_at   <     15.000,      -3.000,      35.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  fade_distance  50.0
  fade_power 1.0
  scale <7.0, 7.0, 1.0>
  translate  <30.0, 23.0, 100.0>
}



//
// ********  MATERIALS  *******
//

#include "js_num.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare SidewalkPanel01 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 0.25>
    translate  <24.125, 28.25, 2.25>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 0.25>
    translate  <-24.125, 28.25, 2.25>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 0.25>
    translate  <24.125, 76.5, 2.25>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 0.25>
    translate  <-24.125, 76.5, 2.25>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <48.125, 2.0, 1.25>
    translate  <0.0, 2.0, 1.25>
  }
  material {
    SidewalkTexture
  }
}


#declare Cube007 = object {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <36.0, 1.75, 0.5>
  }
}
#declare CSG001 = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <1.125, 1.125, 2.0>
    rotate 90.0*x
    translate  <0.0, 1.0, 1.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <1.3, 1.2, 0.75>
    translate  1.0*z
  }
}
#declare Sphere002 = object {
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <0.0, -7.75, 17.5>
  }
}
#declare BenchSeatSupport = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 26.5>
    rotate 90.0*x
    translate  <0.0, 13.25, 1.0>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale <1.0, 0.5, 1.0>
    translate  <0.0, -13.25, 1.0>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale <1.0, 0.5, 1.0>
    translate  <0.0, 13.25, 1.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 14.75>
    translate  1.0*z
  }
  object { CSG001 }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.875, 0.875, 1.5>
    translate  1.0*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 14.25>
    rotate 90.0*x
    translate  15.75*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.75, 0.25, 0.75>
    translate  <0.0, -14.25, 15.75>
  }
  object { Sphere002 }
  object { // Sphere003 -> Sphere002
    Sphere002
    translate  -4.5*y
  }
  object { // Sphere006 -> Sphere002
    Sphere002
    translate  4.5*y
  }
}
#declare Sphere007 = object {
  sphere { // Sphere007
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <0.0, -1.75, 13.0>
  }
}
#declare BenchBackSupport = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 19.5>
  }
  object { Sphere007 }
  object { // Sphere008 -> Sphere007
    Sphere007
    translate  <0.0, 0.0, 4.5>
  }
  object { // Sphere009 -> Sphere007
    Sphere007
    translate  <0.0, 0.0, -4.5>
  }
  sphere { // Sphere010
    <0,0,0>,1
    scale <0.75, 0.75, 0.25>
    translate  19.5*z
  }
}


#declare RndCube005 = merge {
  sphere { <3.7500, 2.7500, 1.2500>, 0.2500 }
  sphere { <3.7500, -2.7500, 1.2500>, 0.2500 }
  sphere { <-3.7500, -2.7500, 1.2500>, 0.2500 }
  sphere { <-3.7500, 2.7500, 1.2500>, 0.2500 }
  sphere { <3.7500, 2.7500, -1.2500>, 0.2500 }
  sphere { <3.7500, -2.7500, -1.2500>, 0.2500 }
  sphere { <-3.7500, -2.7500, -1.2500>, 0.2500 }
  sphere { <-3.7500, 2.7500, -1.2500>, 0.2500 }
  cylinder { <3.7500, 2.7500, 1.2500>, <-3.7500, 2.7500, 1.2500>, 0.2500 }
  cylinder { <3.7500, -2.7500, 1.2500>, <-3.7500, -2.7500, 1.2500>, 0.2500 }
  cylinder { <3.7500, -2.7500, -1.2500>, <-3.7500, -2.7500, -1.2500>, 0.2500 }
  cylinder { <3.7500, 2.7500, -1.2500>, <-3.7500, 2.7500, -1.2500>, 0.2500 }
  cylinder { <3.7500, 2.7500, -1.2500>, <3.7500, 2.7500, 1.2500>, 0.2500 }
  cylinder { <3.7500, -2.7500, -1.2500>, <3.7500, -2.7500, 1.2500>, 0.2500 }
  cylinder { <-3.7500, -2.7500, -1.2500>, <-3.7500, -2.7500, 1.2500>, 0.2500 }
  cylinder { <-3.7500, 2.7500, -1.2500>, <-3.7500, 2.7500, 1.2500>, 0.2500 }
  cylinder { <3.7500, 2.7500, 1.2500>, <3.7500, -2.7500, 1.2500>, 0.2500 }
  cylinder { <3.7500, 2.7500, -1.2500>, <3.7500, -2.7500, -1.2500>, 0.2500 }
  cylinder { <-3.7500, 2.7500, -1.2500>, <-3.7500, -2.7500, -1.2500>, 0.2500 }
  cylinder { <-3.7500, 2.7500, 1.2500>, <-3.7500, -2.7500, 1.2500>, 0.2500 }
  box { <-3.7500, -2.7500, -1.5000> <3.7500, 2.7500, 1.5000> }
  box { <-3.7500, -3.0000, -1.2500> <3.7500, 3.0000, 1.2500> }
  box { <-4.0000, -2.7500, -1.2500> <4.0000, 2.7500, 1.2500> }
  translate  <0.0, -3.0, 1.5>
}
#declare CSG004 = difference {
  object { RndCube005 }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, -1.0, 0.0>
    scale <2.0, 4.0, 1.6>
    rotate -30.0*z
    translate  1.5*z
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    scale <2.0, 4.0, 1.6>
    rotate 30.0*z
    translate  1.5*z
  }
  material {
    StreetLightTexture
  }
}
#declare RndCube006 = merge {
  sphere { <4.5000, 1.7500, 10.0000>, 1.0000 }
  sphere { <4.5000, -1.7500, 10.0000>, 1.0000 }
  sphere { <-4.5000, -1.7500, 10.0000>, 1.0000 }
  sphere { <-4.5000, 1.7500, 10.0000>, 1.0000 }
  sphere { <4.5000, 1.7500, -10.0000>, 1.0000 }
  sphere { <4.5000, -1.7500, -10.0000>, 1.0000 }
  sphere { <-4.5000, -1.7500, -10.0000>, 1.0000 }
  sphere { <-4.5000, 1.7500, -10.0000>, 1.0000 }
  cylinder { <4.5000, 1.7500, 10.0000>, <-4.5000, 1.7500, 10.0000>, 1.0000 }
  cylinder { <4.5000, -1.7500, 10.0000>, <-4.5000, -1.7500, 10.0000>, 1.0000 }
  cylinder { <4.5000, -1.7500, -10.0000>, <-4.5000, -1.7500, -10.0000>, 1.0000 }
  cylinder { <4.5000, 1.7500, -10.0000>, <-4.5000, 1.7500, -10.0000>, 1.0000 }
  cylinder { <4.5000, 1.7500, -10.0000>, <4.5000, 1.7500, 10.0000>, 1.0000 }
  cylinder { <4.5000, -1.7500, -10.0000>, <4.5000, -1.7500, 10.0000>, 1.0000 }
  cylinder { <-4.5000, -1.7500, -10.0000>, <-4.5000, -1.7500, 10.0000>, 1.0000 }
  cylinder { <-4.5000, 1.7500, -10.0000>, <-4.5000, 1.7500, 10.0000>, 1.0000 }
  cylinder { <4.5000, 1.7500, 10.0000>, <4.5000, -1.7500, 10.0000>, 1.0000 }
  cylinder { <4.5000, 1.7500, -10.0000>, <4.5000, -1.7500, -10.0000>, 1.0000 }
  cylinder { <-4.5000, 1.7500, -10.0000>, <-4.5000, -1.7500, -10.0000>, 1.0000 }
  cylinder { <-4.5000, 1.7500, 10.0000>, <-4.5000, -1.7500, 10.0000>, 1.0000 }
  box { <-4.5000, -1.7500, -11.0000> <4.5000, 1.7500, 11.0000> }
  box { <-4.5000, -2.7500, -10.0000> <4.5000, 2.7500, 10.0000> }
  box { <-5.5000, -1.7500, -10.0000> <5.5000, 1.7500, 10.0000> }
  translate  <0.0, -2.75, 11.0>
}
#declare CSG013 = union {
  object { RndCube006 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 8.0>
    rotate <0.0, -90.0, -0.0>
    translate  <4.0, -5.5, 20.0>
  }
}
#declare RndCube007 = merge {
  sphere { <2.3000, 0.3000, 7.5500>, 0.2000 }
  sphere { <2.3000, -0.3000, 7.5500>, 0.2000 }
  sphere { <-2.3000, -0.3000, 7.5500>, 0.2000 }
  sphere { <-2.3000, 0.3000, 7.5500>, 0.2000 }
  sphere { <2.3000, 0.3000, -7.5500>, 0.2000 }
  sphere { <2.3000, -0.3000, -7.5500>, 0.2000 }
  sphere { <-2.3000, -0.3000, -7.5500>, 0.2000 }
  sphere { <-2.3000, 0.3000, -7.5500>, 0.2000 }
  cylinder { <2.3000, 0.3000, 7.5500>, <-2.3000, 0.3000, 7.5500>, 0.2000 }
  cylinder { <2.3000, -0.3000, 7.5500>, <-2.3000, -0.3000, 7.5500>, 0.2000 }
  cylinder { <2.3000, -0.3000, -7.5500>, <-2.3000, -0.3000, -7.5500>, 0.2000 }
  cylinder { <2.3000, 0.3000, -7.5500>, <-2.3000, 0.3000, -7.5500>, 0.2000 }
  cylinder { <2.3000, 0.3000, -7.5500>, <2.3000, 0.3000, 7.5500>, 0.2000 }
  cylinder { <2.3000, -0.3000, -7.5500>, <2.3000, -0.3000, 7.5500>, 0.2000 }
  cylinder { <-2.3000, -0.3000, -7.5500>, <-2.3000, -0.3000, 7.5500>, 0.2000 }
  cylinder { <-2.3000, 0.3000, -7.5500>, <-2.3000, 0.3000, 7.5500>, 0.2000 }
  cylinder { <2.3000, 0.3000, 7.5500>, <2.3000, -0.3000, 7.5500>, 0.2000 }
  cylinder { <2.3000, 0.3000, -7.5500>, <2.3000, -0.3000, -7.5500>, 0.2000 }
  cylinder { <-2.3000, 0.3000, -7.5500>, <-2.3000, -0.3000, -7.5500>, 0.2000 }
  cylinder { <-2.3000, 0.3000, 7.5500>, <-2.3000, -0.3000, 7.5500>, 0.2000 }
  box { <-2.3000, -0.3000, -7.7500> <2.3000, 0.3000, 7.7500> }
  box { <-2.3000, -0.5000, -7.5500> <2.3000, 0.5000, 7.5500> }
  box { <-2.5000, -0.3000, -7.5500> <2.5000, 0.3000, 7.5500> }
  translate  <0.0, -0.5, 7.75>
  translate  <0.0, -5.3, 3.5>
}
#declare CSG011 = difference {
  object { CSG013 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, -1.0, 0.0>
    scale <2.5, 4.0, 11.1>
    rotate -30.0*z
    translate  11.0*z
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    scale <2.5, 4.0, 11.1>
    rotate 30.0*z
    translate  11.0*z
  }
  object { RndCube007 }
  material {
    StreetLightTexture
  }
}
#declare CSG020 = union {
  sphere { // Sphere011
    <0,0,0>,1
    translate  <0.0, -4.375, 17.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    translate  0.0*y
    scale <1.0, 1.0, 16.0>
    translate  <0.0, -4.375, 1.0>
  }
  sphere { // Sphere012
    <0,0,0>,1
    translate  <0.0, -4.375, 1.0>
  }
}
#declare Cylndr011 = object {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    translate  -1.0*y
    scale <1.5, 1.5, 46.0>
  }
}




//
// ********  OBJECTS  *******
//



#declare SidewalkMortar = union {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    scale <140.0, 50.0, 1.0>
    translate  <0.0, 0.75, 2.375>
  }
  material {
    SidewalkMortarTexture
  }
}
union { // Sidewalk
  object { SidewalkPanel01 }
  object { // SidewalkPanel02 -> SidewalkPanel01
    SidewalkPanel01
    translate  -96.5*x
  }
  object { // SidewalkPanel03 -> SidewalkPanel01
    SidewalkPanel01
    translate  96.5*x
  }
  object { SidewalkMortar }
}


#declare BenchSeatBoards = union {
  object { Cube007 }
  object { // Cube008 -> Cube007
    Cube007
    translate  4.5*y
  }
  object { // Cube009 -> Cube007
    Cube007
    translate  -4.5*y
  }
  material {
    BenchWoodTexture
  }
  translate  <0.0, -7.75, 17.0>
}
#declare BenchBackBoards = union {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <36.0, 1.75, 0.5>
  }
  object { // Cube012 -> Cube007
    Cube007
    translate  4.5*y
  }
  object { // Cube013 -> Cube007
    Cube007
    translate  -4.5*y
  }
  material {
    BenchWoodTexture
  }
  rotate -90.0*x
  translate  <0.0, -1.25, 13.0>
}
#declare BenchBack = union {
  object { BenchBackSupport }
  object { // Group008 -> BenchBackSupport
    BenchBackSupport
    translate  30.0*x
  }
  object { // Group009 -> BenchBackSupport
    BenchBackSupport
    translate  -30.0*x
  }
  object { BenchBackBoards }
  rotate -15.0*x
  translate  15.5*z
}
union { // Bench
  object { BenchSeatBoards }
  object { BenchSeatSupport }
  object { // Group005 -> BenchSeatSupport
    BenchSeatSupport
    translate  30.0*x
  }
  object { // Group006 -> BenchSeatSupport
    BenchSeatSupport
    translate  -30.0*x
  }
  object { BenchBack }
  material {
    BenchMetalTexture
  }
  translate  <-18.0, 33.0, 2.5>
}


#declare RndCube001 = merge {
  sphere { <11.7500, 3.2500, 3.2500>, 0.2500 }
  sphere { <11.7500, -3.2500, 3.2500>, 0.2500 }
  sphere { <-11.7500, -3.2500, 3.2500>, 0.2500 }
  sphere { <-11.7500, 3.2500, 3.2500>, 0.2500 }
  sphere { <11.7500, 3.2500, -3.2500>, 0.2500 }
  sphere { <11.7500, -3.2500, -3.2500>, 0.2500 }
  sphere { <-11.7500, -3.2500, -3.2500>, 0.2500 }
  sphere { <-11.7500, 3.2500, -3.2500>, 0.2500 }
  cylinder { <11.7500, 3.2500, 3.2500>, <-11.7500, 3.2500, 3.2500>, 0.2500 }
  cylinder { <11.7500, -3.2500, 3.2500>, <-11.7500, -3.2500, 3.2500>, 0.2500 }
  cylinder { <11.7500, -3.2500, -3.2500>, <-11.7500, -3.2500, -3.2500>, 0.2500 }
  cylinder { <11.7500, 3.2500, -3.2500>, <-11.7500, 3.2500, -3.2500>, 0.2500 }
  cylinder { <11.7500, 3.2500, -3.2500>, <11.7500, 3.2500, 3.2500>, 0.2500 }
  cylinder { <11.7500, -3.2500, -3.2500>, <11.7500, -3.2500, 3.2500>, 0.2500 }
  cylinder { <-11.7500, -3.2500, -3.2500>, <-11.7500, -3.2500, 3.2500>, 0.2500 }
  cylinder { <-11.7500, 3.2500, -3.2500>, <-11.7500, 3.2500, 3.2500>, 0.2500 }
  cylinder { <11.7500, 3.2500, 3.2500>, <11.7500, -3.2500, 3.2500>, 0.2500 }
  cylinder { <11.7500, 3.2500, -3.2500>, <11.7500, -3.2500, -3.2500>, 0.2500 }
  cylinder { <-11.7500, 3.2500, -3.2500>, <-11.7500, -3.2500, -3.2500>, 0.2500 }
  cylinder { <-11.7500, 3.2500, 3.2500>, <-11.7500, -3.2500, 3.2500>, 0.2500 }
  box { <-11.7500, -3.2500, -3.5000> <11.7500, 3.2500, 3.5000> }
  box { <-11.7500, -3.5000, -3.2500> <11.7500, 3.5000, 3.2500> }
  box { <-12.0000, -3.2500, -3.2500> <12.0000, 3.2500, 3.2500> }
  translate  3.5*z
}
#declare RndCube002 = merge {
  sphere { <2.5000, 3.2500, 7.7500>, 0.2500 }
  sphere { <2.5000, -3.2500, 7.7500>, 0.2500 }
  sphere { <-2.5000, -3.2500, 7.7500>, 0.2500 }
  sphere { <-2.5000, 3.2500, 7.7500>, 0.2500 }
  sphere { <2.5000, 3.2500, -7.7500>, 0.2500 }
  sphere { <2.5000, -3.2500, -7.7500>, 0.2500 }
  sphere { <-2.5000, -3.2500, -7.7500>, 0.2500 }
  sphere { <-2.5000, 3.2500, -7.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 7.7500>, <-2.5000, 3.2500, 7.7500>, 0.2500 }
  cylinder { <2.5000, -3.2500, 7.7500>, <-2.5000, -3.2500, 7.7500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -7.7500>, <-2.5000, -3.2500, -7.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -7.7500>, <-2.5000, 3.2500, -7.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -7.7500>, <2.5000, 3.2500, 7.7500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -7.7500>, <2.5000, -3.2500, 7.7500>, 0.2500 }
  cylinder { <-2.5000, -3.2500, -7.7500>, <-2.5000, -3.2500, 7.7500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -7.7500>, <-2.5000, 3.2500, 7.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 7.7500>, <2.5000, -3.2500, 7.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -7.7500>, <2.5000, -3.2500, -7.7500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -7.7500>, <-2.5000, -3.2500, -7.7500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, 7.7500>, <-2.5000, -3.2500, 7.7500>, 0.2500 }
  box { <-2.5000, -3.2500, -8.0000> <2.5000, 3.2500, 8.0000> }
  box { <-2.5000, -3.5000, -7.7500> <2.5000, 3.5000, 7.7500> }
  box { <-2.7500, -3.2500, -7.7500> <2.7500, 3.2500, 7.7500> }
  translate  14.0*z
}
#declare CSG002 = difference {
  object { RndCube002 }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <3.0, 4.0, 0.75>
    translate  21.0*z
  }
}
#declare RndDisc001 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <3.2500, 3.2500, 5.5000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <3.5000, 3.5000, 5.0000> translate 0.2500*z }
  torus { 3.2500, 0.2500  rotate -x*90 translate  5.2500*z bounded_by { box { <-3.5050, -3.5050, 4.9950>, <3.5050, 3.5050, 5.5050> } } }
  torus { 3.2500, 0.2500  rotate -x*90 translate  0.2500*z bounded_by { box { <-3.5050, -3.5050, -0.0050>, <3.5050, 3.5050, 0.5050> } } }
  rotate 90.0*y
  translate  -2.75*x
}
#declare RndCube003 = merge {
  sphere { <2.5000, 3.2500, 9.2500>, 0.2500 }
  sphere { <2.5000, -3.2500, 9.2500>, 0.2500 }
  sphere { <-2.5000, -3.2500, 9.2500>, 0.2500 }
  sphere { <-2.5000, 3.2500, 9.2500>, 0.2500 }
  sphere { <2.5000, 3.2500, -9.2500>, 0.2500 }
  sphere { <2.5000, -3.2500, -9.2500>, 0.2500 }
  sphere { <-2.5000, -3.2500, -9.2500>, 0.2500 }
  sphere { <-2.5000, 3.2500, -9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 9.2500>, <-2.5000, 3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, -3.2500, 9.2500>, <-2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -9.2500>, <-2.5000, -3.2500, -9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -9.2500>, <-2.5000, 3.2500, -9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -9.2500>, <2.5000, 3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -9.2500>, <2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <-2.5000, -3.2500, -9.2500>, <-2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -9.2500>, <-2.5000, 3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 9.2500>, <2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -9.2500>, <2.5000, -3.2500, -9.2500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -9.2500>, <-2.5000, -3.2500, -9.2500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, 9.2500>, <-2.5000, -3.2500, 9.2500>, 0.2500 }
  box { <-2.5000, -3.2500, -9.5000> <2.5000, 3.2500, 9.5000> }
  box { <-2.5000, -3.5000, -9.2500> <2.5000, 3.5000, 9.2500> }
  box { <-2.7500, -3.2500, -9.2500> <2.7500, 3.2500, 9.2500> }
  translate  9.0*z
}
#declare CSG003 = difference {
  object { RndCube003 }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <3.0, 4.0, 0.75>
    translate  18.0*z
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <3.0, 4.0, 0.75>
  }
}
#declare RndDisc002 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <3.2500, 3.2500, 5.5000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <3.5000, 3.5000, 5.0000> translate 0.2500*z }
  torus { 3.2500, 0.2500  rotate -x*90 translate  5.2500*z bounded_by { box { <-3.5050, -3.5050, 4.9950>, <3.5050, 3.5050, 5.5050> } } }
  torus { 3.2500, 0.2500  rotate -x*90 translate  0.2500*z bounded_by { box { <-3.5050, -3.5050, -0.0050>, <3.5050, 3.5050, 0.5050> } } }
  rotate 90.0*y
  translate  <-2.75, 0.0, -0.017583>
}
#declare RndCube004 = merge {
  sphere { <2.5000, 3.2500, 9.2500>, 0.2500 }
  sphere { <2.5000, -3.2500, 9.2500>, 0.2500 }
  sphere { <-2.5000, -3.2500, 9.2500>, 0.2500 }
  sphere { <-2.5000, 3.2500, 9.2500>, 0.2500 }
  sphere { <2.5000, 3.2500, -9.2500>, 0.2500 }
  sphere { <2.5000, -3.2500, -9.2500>, 0.2500 }
  sphere { <-2.5000, -3.2500, -9.2500>, 0.2500 }
  sphere { <-2.5000, 3.2500, -9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 9.2500>, <-2.5000, 3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, -3.2500, 9.2500>, <-2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -9.2500>, <-2.5000, -3.2500, -9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -9.2500>, <-2.5000, 3.2500, -9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -9.2500>, <2.5000, 3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -9.2500>, <2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <-2.5000, -3.2500, -9.2500>, <-2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -9.2500>, <-2.5000, 3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 9.2500>, <2.5000, -3.2500, 9.2500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -9.2500>, <2.5000, -3.2500, -9.2500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -9.2500>, <-2.5000, -3.2500, -9.2500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, 9.2500>, <-2.5000, -3.2500, 9.2500>, 0.2500 }
  box { <-2.5000, -3.2500, -9.5000> <2.5000, 3.2500, 9.5000> }
  box { <-2.5000, -3.5000, -9.2500> <2.5000, 3.5000, 9.2500> }
  box { <-2.7500, -3.2500, -9.2500> <2.7500, 3.2500, 9.2500> }
  translate  9.0*z
}
#declare CSG006 = difference {
  object { RndCube004 }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <3.0, 4.0, 0.75>
    translate  18.0*z
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <3.0, 4.0, 0.75>
  }
}
#declare RndDisc004 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <3.2500, 3.2500, 5.5000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <3.5000, 3.5000, 5.0000> translate 0.2500*z }
  torus { 3.2500, 0.2500  rotate -x*90 translate  5.2500*z bounded_by { box { <-3.5050, -3.5050, 4.9950>, <3.5050, 3.5050, 5.5050> } } }
  torus { 3.2500, 0.2500  rotate -x*90 translate  0.2500*z bounded_by { box { <-3.5050, -3.5050, -0.0050>, <3.5050, 3.5050, 0.5050> } } }
  rotate 90.0*y
  translate  -2.75*x
}
#declare RndCube008 = merge {
  sphere { <2.5000, 3.2500, 6.7500>, 0.2500 }
  sphere { <2.5000, -3.2500, 6.7500>, 0.2500 }
  sphere { <-2.5000, -3.2500, 6.7500>, 0.2500 }
  sphere { <-2.5000, 3.2500, 6.7500>, 0.2500 }
  sphere { <2.5000, 3.2500, -6.7500>, 0.2500 }
  sphere { <2.5000, -3.2500, -6.7500>, 0.2500 }
  sphere { <-2.5000, -3.2500, -6.7500>, 0.2500 }
  sphere { <-2.5000, 3.2500, -6.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 6.7500>, <-2.5000, 3.2500, 6.7500>, 0.2500 }
  cylinder { <2.5000, -3.2500, 6.7500>, <-2.5000, -3.2500, 6.7500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -6.7500>, <-2.5000, -3.2500, -6.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -6.7500>, <-2.5000, 3.2500, -6.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -6.7500>, <2.5000, 3.2500, 6.7500>, 0.2500 }
  cylinder { <2.5000, -3.2500, -6.7500>, <2.5000, -3.2500, 6.7500>, 0.2500 }
  cylinder { <-2.5000, -3.2500, -6.7500>, <-2.5000, -3.2500, 6.7500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -6.7500>, <-2.5000, 3.2500, 6.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, 6.7500>, <2.5000, -3.2500, 6.7500>, 0.2500 }
  cylinder { <2.5000, 3.2500, -6.7500>, <2.5000, -3.2500, -6.7500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, -6.7500>, <-2.5000, -3.2500, -6.7500>, 0.2500 }
  cylinder { <-2.5000, 3.2500, 6.7500>, <-2.5000, -3.2500, 6.7500>, 0.2500 }
  box { <-2.5000, -3.2500, -7.0000> <2.5000, 3.2500, 7.0000> }
  box { <-2.5000, -3.5000, -6.7500> <2.5000, 3.5000, 6.7500> }
  box { <-2.7500, -3.2500, -6.7500> <2.7500, 3.2500, 6.7500> }
  translate  6.0*z
}
#declare CSG012 = difference {
  object { RndCube008 }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <3.0, 4.0, 0.75>
  }
}
#declare RndCube010 = merge {
  sphere { <7.7500, 3.2500, 2.7500>, 0.2500 }
  sphere { <7.7500, -3.2500, 2.7500>, 0.2500 }
  sphere { <-7.7500, -3.2500, 2.7500>, 0.2500 }
  sphere { <-7.7500, 3.2500, 2.7500>, 0.2500 }
  sphere { <7.7500, 3.2500, -2.7500>, 0.2500 }
  sphere { <7.7500, -3.2500, -2.7500>, 0.2500 }
  sphere { <-7.7500, -3.2500, -2.7500>, 0.2500 }
  sphere { <-7.7500, 3.2500, -2.7500>, 0.2500 }
  cylinder { <7.7500, 3.2500, 2.7500>, <-7.7500, 3.2500, 2.7500>, 0.2500 }
  cylinder { <7.7500, -3.2500, 2.7500>, <-7.7500, -3.2500, 2.7500>, 0.2500 }
  cylinder { <7.7500, -3.2500, -2.7500>, <-7.7500, -3.2500, -2.7500>, 0.2500 }
  cylinder { <7.7500, 3.2500, -2.7500>, <-7.7500, 3.2500, -2.7500>, 0.2500 }
  cylinder { <7.7500, 3.2500, -2.7500>, <7.7500, 3.2500, 2.7500>, 0.2500 }
  cylinder { <7.7500, -3.2500, -2.7500>, <7.7500, -3.2500, 2.7500>, 0.2500 }
  cylinder { <-7.7500, -3.2500, -2.7500>, <-7.7500, -3.2500, 2.7500>, 0.2500 }
  cylinder { <-7.7500, 3.2500, -2.7500>, <-7.7500, 3.2500, 2.7500>, 0.2500 }
  cylinder { <7.7500, 3.2500, 2.7500>, <7.7500, -3.2500, 2.7500>, 0.2500 }
  cylinder { <7.7500, 3.2500, -2.7500>, <7.7500, -3.2500, -2.7500>, 0.2500 }
  cylinder { <-7.7500, 3.2500, -2.7500>, <-7.7500, -3.2500, -2.7500>, 0.2500 }
  cylinder { <-7.7500, 3.2500, 2.7500>, <-7.7500, -3.2500, 2.7500>, 0.2500 }
  box { <-7.7500, -3.2500, -3.0000> <7.7500, 3.2500, 3.0000> }
  box { <-7.7500, -3.5000, -2.7500> <7.7500, 3.5000, 2.7500> }
  box { <-8.0000, -3.2500, -2.7500> <8.0000, 3.2500, 2.7500> }
  translate  <-7.0, 0.0, -2.75>
}
#declare CSG014 = difference {
  object { RndCube010 }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*y
    translate  1.0*x
    scale <0.75, 4.0, 3.25>
    translate  -2.75*z
  }
  rotate -32.0*y
  translate  <-2.5, 0.0, 12.75>
}
#declare FigureHead = union {
  object { RndDisc004 }
  object { CSG012 }
  object { CSG014 }
  rotate 35.0*x
  translate  18.0*z
}
#declare FigureTorso = union {
  object { RndDisc002 }
  object { CSG006 }
  object { FigureHead }
  rotate 100.0*x
  translate  18.0*z
}
#declare FigureUpperLeg = union {
  object { RndDisc001 }
  object { CSG003 }
  object { FigureTorso }
  rotate -90.0*x
  translate  21.0*z
}
#declare FigureLowerLeg = union {
  object { RndCube001 }
  object { CSG002 }
  object { FigureUpperLeg }
}
union { // Figure
  object { FigureLowerLeg }
  material {
    FigureTexture
  }
  translate  <0.0, 10.0, 2.5>
}


plane { // Plane001
  z,0
  material {
    StreetTexture
  }
}


#declare Group001 = union {
  object { CSG004 }
  object { // CSG005 -> CSG004
    CSG004
    rotate -60.0*z
  }
  object { // CSG007 -> CSG004
    CSG004
    rotate -120.0*z
  }
  object { // CSG008 -> CSG004
    CSG004
    rotate 180.0*z
  }
  object { // CSG009 -> CSG004
    CSG004
    rotate 120.0*z
  }
  object { // CSG010 -> CSG004
    CSG004
    rotate 60.0*z
  }
}
#declare Group002 = union {
  object { CSG011 }
  object { // CSG015 -> CSG011
    CSG011
    rotate -60.0*z
  }
  object { // CSG016 -> CSG011
    CSG011
    rotate -120.0*z
  }
  object { // CSG017 -> CSG011
    CSG011
    rotate 180.0*z
  }
  object { // CSG018 -> CSG011
    CSG011
    rotate 120.0*z
  }
  object { // CSG019 -> CSG011
    CSG011
    rotate 60.0*z
  }
}
#declare CSG040 = difference {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <3.5, 3.5, 18.0>
  }
  object { CSG020 }
  object { // CSG021 -> CSG020
    CSG020
    rotate -20.0*z
  }
  object { // CSG022 -> CSG020
    CSG020
    rotate -40.0*z
  }
  object { // CSG023 -> CSG020
    CSG020
    rotate -60.0*z
  }
  object { // CSG024 -> CSG020
    CSG020
    rotate -80.0*z
  }
  object { // CSG025 -> CSG020
    CSG020
    rotate -100.0*z
  }
  object { // CSG026 -> CSG020
    CSG020
    rotate -120.0*z
  }
  object { // CSG027 -> CSG020
    CSG020
    rotate -140.0*z
  }
  object { // CSG028 -> CSG020
    CSG020
    rotate -160.0*z
  }
  object { // CSG029 -> CSG020
    CSG020
    rotate 180.0*z
  }
  object { // CSG030 -> CSG020
    CSG020
    rotate 160.0*z
  }
  object { // CSG031 -> CSG020
    CSG020
    rotate 140.0*z
  }
  object { // CSG032 -> CSG020
    CSG020
    rotate 120.0*z
  }
  object { // CSG033 -> CSG020
    CSG020
    rotate 100.0*z
  }
  object { // CSG034 -> CSG020
    CSG020
    rotate 80.0*z
  }
  object { // CSG035 -> CSG020
    CSG020
    rotate 60.0*z
  }
  object { // CSG036 -> CSG020
    CSG020
    rotate 40.0*z
  }
  object { // CSG037 -> CSG020
    CSG020
    rotate 20.0*z
  }
  object { // CSG038 -> CSG020
    CSG020
    rotate -0.0*z
  }
  object { // CSG039 -> CSG020
    CSG020
    rotate -20.0*z
  }
  translate  1.0*z
}
#declare CSG041 = difference {
  torus { // Torus002
    3.5, 0.5  rotate -x*90
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <4.1, 4.1, 0.6>
  }
  translate  19.5*z
}
#declare Group003 = union {
  torus { // Torus001
    3.5, 1.0  rotate -x*90
  }
  object { CSG040 }
  object { CSG041 }
  material {
    StreetLightTexture
  }
  translate  22.0*z
}
#declare Group007 = union {
  object { Cylndr011 }
  object { // Cylndr012 -> Cylndr011
    Cylndr011
    rotate -36.0*z
  }
  object { // Cylndr013 -> Cylndr011
    Cylndr011
    rotate -72.0*z
  }
  object { // Cylndr014 -> Cylndr011
    Cylndr011
    rotate -108.0*z
  }
  object { // Cylndr015 -> Cylndr011
    Cylndr011
    rotate -144.0*z
  }
  object { // Cylndr016 -> Cylndr011
    Cylndr011
    rotate 180.0*z
  }
  object { // Cylndr017 -> Cylndr011
    Cylndr011
    rotate 144.0*z
  }
  object { // Cylndr018 -> Cylndr011
    Cylndr011
    rotate 108.0*z
  }
  object { // Cylndr019 -> Cylndr011
    Cylndr011
    rotate 72.0*z
  }
  object { // Cylndr020 -> Cylndr011
    Cylndr011
    rotate 36.0*z
  }
  material {
    StreetLightTexture
  }
}
#declare Group004 = union {
  torus { // Torus003
    3.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.5>
  }
  torus { // Torus004
    3.0, 0.5  rotate -x*90
    translate  46.0*z
  }
  object { Group007 }
  material {
    StreetLightTexture
  }
  translate  41.5*z
}
union { // StreetLight
  object { Group001 }
  object { Group002 }
  object { Group003 }
  object { Group004 }
  translate  <30.0, 23.0, 2.5>
}


#declare BrickWallBricks = union {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    scale <50.0, 40.0, 0.25>
  }
  material {
    BrickTexture
  }
}
#declare BrickWallMortar = union {
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    scale <50.0, 40.0, 0.25>
    translate  -0.125*z
  }
  material {
    MortarTexture
  }
}
union { // BrickWall
  object { BrickWallBricks }
  object { BrickWallMortar }
  rotate 90.0*x
  translate  <-15.0, 100.8, 2.5>
}


