// Desc: Loneliness IRTC entry include file
// Date: 2002/08/13
// Auth: Joo Paulo Silva
// Desc: Generates lines parallel to an axis (x, y or z)

// NOTE to non Portuguese ppl
// Linhas = Lines
// Fundo  = Background
// Linha  = Line

#macro Linhas(_Fundo, _Linha, _Mult)
 #local l1 = 0.015*_Mult; //thickness of the line
 
 color_map {
    [ l1/2  color _Linha]
    [ l1/2  color _Fundo]  
    [ 1-l1/2  color _Fundo]
    [ 1-l1/2  color _Linha]     
 }

#end

#macro LinesX(_Fun, _Lin, _Mul) 
        pigment { gradient x  
                  Linhas(_Fun, _Lin, _Mul)
        }
#end        

#macro LinesY(_Fun, _Lin, _Mul) 
        pigment { gradient y
                  Linhas(_Fun, _Lin, _Mul)
        }
#end                    

#macro LinesZ(_Fun, _Lin, _Mul)                              
        pigment { gradient z
                  Linhas(_Fun, _Lin, _Mul)
        }
#end        
