// Persistence Of Vision raytracer version 3.5 beta
// Kite flying on the snowy day Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 /*max_trace_level 82*/ }


camera { location < 0, -0.1, -300 > look_at  < 0, -0.1, 0 > angle 60 
         focal_point < 0, 0, 300 > aperture 7 blur_samples 12 }


light_source { < 0, 0,-500 > color 1 fade_distance 500 fade_power 1 }


//**********************************************************************************
coordinate_color( 140, 0.7, 0.9, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
coordinate_color( 360, 0.00, 0.85, 1, 1 )
coordinate_color( 360, 0.00, 0.75, 1, 2 )
coordinate_color( 210, 0.13, 0.32, 1, 3 )
// sky
sky_sphere {
 pigment { bozo
           turbulence 0.7
           octaves 6
           omega 0.7
           lambda 2
           color_map { [ 0.0, 0.1 color rgb < R1, G1, B1 > color rgb < R2, G2, B2 > ]
                       [ 0.1, 0.5 color rgb < R2, G2, B2 > color rgb < R3, G3, B3 > ]
                       [ 0.5, 1.0 color rgb < R3, G3, B3 > color rgb < R3, G3, B3 > ] }
           rotate < 0,90,10 > }
}
//**********************************************************************************
#include "Space_line.mcr.inc"
//----------------------------------------------------------------------------------
#macro Line_function(Tp,Px,Py,Pz,Func_type)
 #switch(Func_type)
  #case(1) #local Px=0; #local Py=6*cos(Tp); #local Pz=-10*Tp; #break  // snow
  #case(2) #local Px=20*cos(Tp); #local Py=0; #local Pz=-10*Tp; #break //
  #case(3) #local Px=2*Tp; #local Py=0; #local Pz=1/12*pow(Px,2); #break   // kite thread
  #case(4) #local Px=12*Tp; #local Py=0; #local Pz=-1/24*pow(Px,2); #break //
  #case(5) #local Px=1.4*Rr*cos(Tp); #local Py=0; #local Pz=Rr*sin(Tp); #break // wood
  #case(6) #local Px=1.2*Rr*cos(Tp); #local Py=0; #local Pz=Rr*sin(Tp); #break //
  #case(7) #local Px=Rr*cos(Tp); #local Py=0; #local Pz=Rr*sin(Tp); #break // shrub
 #end
#end
//----------------------------------------------------------------------------------
#local C_pow = 3;
coordinate_color(360,0,1.00,1,1)
coordinate_color(360,0,0.99,1,2)
coordinate_color(360,0,0.93,1,3)
#local T_snow =
texture {
  pigment { wood
            scallop_wave
            color_map { [ 0.0 rgbt < R1, G1, B1, 0.98 > ]
                        [ 0.1 rgbt < R2, G2, B2, 0.95 >*C_pow ]
                        [ 0.2 rgbt < R3, G3, B3, 0.90 >*C_pow ]
                        [ 0.5 rgbt < R3, G3, B3, 0.90 >*C_pow ]
                        [ 0.6 rgbt < R2, G2, B2, 0.95 >*C_pow ]
                        [ 1.0 rgbt < R1, G1, B1, 1.0 > ] } }
  finish { ambient 0 diffuse 0 reflection 0.4 }
}
#local Obj_seg = disc { 0, x, 0.45 texture { T_snow rotate 90*y } }
#local Snow_Aorg =
union {
 Space_arrange(pi*<0,3,1/5>,1)
 Space_arrange(pi*<3,5,1/7>,2)
 Space_arrange(pi*<5,11,1/9>,1)
 rotate 19*x translate 5*x
}
#local Snow_Borg =
union {
 Space_arrange(pi*<0,3,1/5>,2)
 Space_arrange(pi*<3,5,1/7>,1)
 Space_arrange(pi*<5,11,1/9>,2)
 rotate 19*x translate 5*x
}
#local Snow_Corg =
union {
 Space_arrange(pi*<0,3,1/5>,2)
 Space_arrange(pi*<3,5,1/7>,1)
 Space_arrange(pi*<5,11,1/9>,1)
 rotate 19*x translate 5*x
}
//----------------------------------------------------------------------------------
// snowstorm
#local Snow_seg =
union { 
 #local Ei=19; #local Si=0; #while(Si<Ei)
  object { Snow_Aorg scale 1.4 rotate (10+360*Si/Ei)*z }
  object { Snow_Borg scale 1.2 rotate (14+360*Si/Ei)*z }
  object { Snow_Corg scale 1.0 rotate (18+360*Si/Ei)*z }
 #local Si=Si+1; #end
}
//
union {
 object { Snow_seg rotate -1*z rotate -26*y }
 #local Ei=3; #local Si=0; #while(Si<Ei)
  object { Snow_Corg rotate 220*z rotate Si*x }
  object { Snow_Aorg rotate 224*z rotate -(7+Si*1)*y }
 #local Si=Si+1; #end
 translate <-60,52,200> scale 24
}
//
#local Ei=3; #local Si=0; #while(Si<Ei)
 object { Obj_seg rotate 90*y translate < 2*Si, 0.2*(Si+2), 10*(Si+5) > scale 10 }
 object { Obj_seg rotate 90*y translate < -3-2*(Si+1), 0.2*(Si+1), 10*(Si+4) > scale 10 }
#local Si=Si+1; #end
//**********************************************************************************
// kite
coordinate_color(360,0.0,1.0,1,1)
#local T_kite = texture { pigment { color rgbf <R1,G1,B1,0.3> } finish { ambient 0.4 } }
coordinate_color(30,0.8,0.7,1,2) #local P_rib = pigment { color rgb <R2,G2,B2> }
#local P_thread = pigment { color rgb 1.6 }
//
#local Kh=64; #local Kr=50; #local Ra1=180+56; #local Ra2=-56;
#local Rw=1;
#local Kx=Kr*cos(radians(Ra2));
#local Kz=Kr*sin(radians(Ra2));
#local Kite_org =
cylinder { 0, Kh*y, Kr open
 clipped_by { plane { z,0 } rotate -(Ra1+180)*y }
 clipped_by { plane { z,0 } rotate -(Ra2)*y }
 texture { T_kite }
}
#local Rib_org =
cylinder { 0, Kh*y, Kr open
 clipped_by { plane { z,0 } rotate -(Ra1-2+180)*y }
 clipped_by { plane { z,0 } rotate -(Ra2+2)*y }
}
#local Trib_org = object { Rib_org clipped_by { plane { y,-(Kh-Rw*1.4) } rotate 180*x } pigment { P_rib } translate 1e-4*z }
#local Lrib_org =
cylinder { -Rw*2*y, (Kh+Rw*2)*y, Kr open
 clipped_by { plane { z,0 } rotate -(Ra2-1.64+180)*y }
 clipped_by { plane { z,0 } rotate -(Ra2)*y }
 pigment { P_rib }
 translate 1e-4*z
}
#local Rrib_org =
cylinder { -Rw*2*y, (Kh+Rw*2)*y, Kr open
 clipped_by { plane { z,0 } rotate -(Ra1+180)*y }
 clipped_by { plane { z,0 } rotate -(Ra1+1.64)*y }
 pigment { P_rib }
 translate 1e-4*z
}
#local Urib_org = object { Rib_org clipped_by { plane { y,Rw*1.4 } } pigment { P_rib } translate 1e-4*z }
#local Lcross_org =
cylinder { -Rw*2*y, (Kh+Rw*2)*y, Kr open
 clipped_by { plane { z,0 } }
 clipped_by { plane { y,0 } rotate 49*z translate (Kh/2+Rw)*y }
 clipped_by { plane { y,0 } rotate (180+49)*z translate (Kh/2-Rw)*y }
 pigment { P_rib }
 translate 1e-4*z
}
#local Rcross_org =
cylinder { -Rw*2*y, (Kh+Rw*2)*y, Kr open
 clipped_by { plane { z,0 } }
 clipped_by { plane { y,0 } rotate -49*z translate (Kh/2+Rw)*y }
 clipped_by { plane { y,0 } rotate (180-49)*z translate (Kh/2-Rw)*y }
 pigment { P_rib }
 translate 1e-4*z
}
//
#local Kite_seg =
union {
 object { Kite_org }
 object { Trib_org }
 object { Lrib_org }
 object { Rrib_org }
 object { Urib_org }
 object { Lcross_org }
 object { Rcross_org }
 object { Lrib_org rotate (90+Ra2-0.82)*y }
 object { Urib_org translate (Kh-Rw)/2*y }
 torus { 2, 0.2 pigment { P_thread } scale <1,1,0.1> rotate 26*z translate <0,Kh/2,-Kr> }
 torus { 2, 0.2 pigment { P_thread } scale <1,1,0.1> rotate -26*z translate <0,Kh/2,-Kr> }
 torus { 1, 0.2 pigment { P_thread } scale <1,1,0.3> rotate -45*z translate <Kx-0.5,Kh-0.5,Kz> }
 torus { 1, 0.2 pigment { P_thread } scale <1,1,0.3> rotate 45*z translate <-Kx+0.5,Kh-0.5,Kz> }
 cylinder { -Kx*x,Kx*x 0.2 pigment { P_thread } translate <0,Kh,Kz> }
}
//
#local Lw=0.2;
#local Tkite_line = union { Space_line(Lw,pi*<0,4.5,1/8>,3) }
#local Ukite_line = union { Space_line(Lw,pi*<0,4.0,1/8>,3) }
#local Bkite_line = union { Space_line(Lw,pi*<-6,0.0,1/8>,4) }
//
#local Kite_thread =
union {
 object { Tkite_line pigment { P_thread } rotate -21*x translate <0,38,-106> }
 object { Tkite_line pigment { P_thread } rotate 180*z rotate -21*x translate <0,38,-106> }
 object { Ukite_line pigment { P_thread } rotate -90*z rotate -20*x translate <0,38,-106> }
 object { Bkite_line pigment { P_thread } rotate 90*z rotate 28.8*x translate <0,38,-106> }
}
//
//**********************************************************************************
#include "Curved_ribon.mcr.inc"
//----------------------------------------------------------------------------------
#macro Curve_function(Tp,Px,Pz,Func_type)
 #switch(Func_type)
 #case(2) #local Px=Tp; #local Pz=1/3*pow(Px,3); #break
 #end
#end
//----------------------------------------------------------------------------------
#local Ltail_org = union { Curved_ribon(1,pi*<-1,1,1/8>,pow(-0.40*pi,2),2) translate -0.5*y scale 5 rotate <-90,90,0> }
#local Rtail_org = union { Curved_ribon(1,pi*<-1,1,1/8>,pow(-0.43*pi,2),2) translate -0.5*y scale 5 rotate <-90,90,0> }
//----------------------------------------------------------------------------------
#local Ryu_base =
union {
prism {
 linear_sweep
 bezier_spline 0,1,344
 <0.216,2.414><0.34,2.414><0.463,2.391><0.586,2.344>
 <0.586,2.344><0.71,2.298><0.771,2.238><0.771,2.166>
 <0.771,2.166><0.771,2.125><0.763,2.061><0.748,1.974>
 <0.748,1.974><0.732,1.888><0.724,1.833><0.724,1.809>
 <0.724,1.809><0.77,1.809><0.836,1.829><0.922,1.869>
 <0.922,1.869><1.007,1.909><1.063,1.928><1.087,1.928>
 <1.087,1.928><1.143,1.928><1.213,1.913><1.297,1.882>
 <1.297,1.882><1.381,1.851><1.423,1.812><1.423,1.767>
 <1.423,1.767><1.423,1.724><1.361,1.681><1.237,1.636>
 <1.237,1.636><1.112,1.592><1.012,1.57><0.935,1.57>
 <0.935,1.57><0.935,1.57><0.872,1.57><0.872,1.57>
 <0.872,1.57><0.84,1.57><0.81,1.57><0.782,1.57>
 <0.782,1.57><0.737,1.581><0.704,1.587><0.683,1.591>
 <0.683,1.591><0.683,1.58><0.674,1.513><0.655,1.39>
 <0.655,1.39><0.636,1.266><0.627,1.193><0.627,1.172>
 <0.627,1.172><0.651,1.186><0.767,1.218><0.975,1.266>
 <0.975,1.266><1.183,1.315><1.309,1.34><1.355,1.34>
 <1.355,1.34><1.45,1.34><1.541,1.322><1.628,1.287>
 <1.628,1.287><1.716,1.252><1.759,1.2><1.759,1.131>
 <1.759,1.131><1.759,1.057><1.719,0.959><1.64,0.837>
 <1.64,0.837><1.56,0.715><1.469,0.603><1.368,0.502>
 <1.368,0.502><1.395,0.474><1.409,0.453><1.409,0.439>
 <1.409,0.439><1.409,0.425><1.307,0.388><1.105,0.329>
 <1.105,0.329><0.903,0.27><0.69,0.21><0.466,0.151>
 <0.466,0.151><0.542,0.092><0.593,0.052><0.619,0.031>
 <0.619,0.031><0.645,0.01><0.658,-0.027><0.658,-0.08>
 <0.658,-0.08><0.921,0.029><1.118,0.083><1.251,0.083>
 <1.251,0.083><1.4,0.083><1.474,0.043><1.474,-0.037>
 <1.474,-0.037><1.474,-0.083><1.444,-0.124><1.383,-0.161>
 <1.383,-0.161><1.322,-0.197><1.259,-0.223><1.195,-0.237>
 <1.195,-0.237><1.13,-0.251><1.039,-0.285><0.922,-0.339>
 <0.922,-0.339><0.804,-0.393><0.735,-0.42><0.715,-0.42>
 <0.715,-0.42><0.728,-0.42><0.747,-0.412><0.771,-0.396>
 <0.771,-0.396><0.796,-0.381><0.833,-0.346><0.884,-0.29>
 <0.884,-0.29><0.857,-0.263><0.775,-0.249><0.637,-0.249>
 <0.637,-0.249><0.637,-0.252><0.63,-0.303><0.616,-0.401>
 <0.616,-0.401><0.603,-0.499><0.596,-0.56><0.596,-0.584>
 <0.596,-0.584><0.764,-0.522><0.902,-0.472><1.009,-0.435>
 <1.009,-0.435><1.116,-0.397><1.203,-0.378><1.271,-0.378>
 <1.271,-0.378><1.363,-0.378><1.409,-0.418><1.409,-0.497>
 <1.409,-0.497><1.409,-0.548><1.314,-0.639><1.126,-0.771>
 <1.126,-0.771><0.938,-0.902><0.844,-0.99><0.844,-1.035>
 <0.844,-1.035><0.844,-1.076><0.87,-1.096><0.921,-1.096>
 <0.921,-1.096><0.949,-1.096><1.023,-1.083><1.144,-1.057>
 <1.144,-1.057><1.264,-1.03><1.342,-1.017><1.376,-1.017>
 <1.376,-1.017><1.438,-1.017><1.503,-1.037><1.57,-1.078>
 <1.57,-1.078><1.637,-1.119><1.671,-1.161><1.671,-1.204>
 <1.671,-1.204><1.671,-1.254><1.629,-1.295><1.544,-1.327>
 <1.544,-1.327><1.46,-1.359><1.335,-1.375><1.169,-1.375>
 <1.169,-1.375><0.952,-1.375><0.811,-1.362><0.744,-1.335>
 <0.744,-1.335><0.678,-1.309><0.645,-1.258><0.645,-1.184>
 <0.645,-1.184><0.645,-1.131><0.677,-1.05><0.74,-0.942>
 <0.74,-0.942><0.804,-0.834><0.841,-0.766><0.851,-0.738>
 <0.851,-0.738><0.699,-0.738><0.601,-0.718><0.557,-0.677>
 <0.557,-0.677><0.55,-0.708><0.536,-0.806><0.516,-0.97>
 <0.516,-0.97><0.496,-1.135><0.486,-1.242><0.486,-1.291>
 <0.486,-1.291><0.486,-1.446><0.551,-1.571><0.683,-1.668>
 <0.683,-1.668><0.814,-1.764><1.031,-1.813><1.335,-1.813>
 <1.335,-1.813><1.591,-1.813><1.765,-1.788><1.858,-1.738>
 <1.858,-1.738><1.951,-1.688><1.998,-1.604><1.998,-1.488>
 <1.998,-1.488><1.998,-1.425><1.985,-1.323><1.959,-1.18>
 <1.959,-1.18><1.933,-1.037><1.914,-0.951><1.9,-0.923>
 <1.9,-0.923><2.045,-1.013><2.17,-1.156><2.276,-1.35>
 <2.276,-1.35><2.383,-1.545><2.436,-1.706><2.436,-1.833>
 <2.436,-1.833><2.436,-1.964><2.367,-2.06><2.229,-2.12>
 <2.229,-2.12><2.091,-2.181><1.795,-2.211><1.34,-2.211>
 <1.34,-2.211><0.896,-2.211><0.596,-2.123><0.441,-1.948>
 <0.441,-1.948><0.285,-1.772><0.207,-1.587><0.207,-1.393>
 <0.207,-1.393><0.207,-1.393><0.192,0.018><0.192,0.018>
 <0.192,0.018><0.192,0.067><0.167,0.121><0.117,0.182>
 <0.117,0.182><0.067,0.243><0.009,0.278><-0.057,0.289>
 <-0.057,0.289><-0.057,0.289><-0.057,0.335><-0.057,0.335>
 <-0.057,0.335><0.148,0.394><0.348,0.448><0.544,0.494>
 <0.544,0.494><0.74,0.541><0.9,0.572><1.025,0.585>
 <1.025,0.585><1.078,0.665><1.135,0.753><1.193,0.848>
 <1.193,0.848><1.252,0.944><1.282,1.009><1.282,1.044>
 <1.282,1.044><1.282,1.096><1.259,1.122><1.213,1.122>
 <1.213,1.122><1.199,1.122><1.068,1.071><0.821,0.968>
 <0.821,0.968><0.575,0.866><0.444,0.815><0.43,0.815>
 <0.43,0.815><0.409,0.815><0.371,0.847><0.317,0.911>
 <0.317,0.911><0.264,0.975><0.237,1.019><0.237,1.044>
 <0.237,1.044><0.272,1.158><0.302,1.284><0.328,1.421>
 <0.328,1.421><0.353,1.558><0.366,1.681><0.366,1.789>
 <0.366,1.789><0.366,2.002><0.346,2.154><0.305,2.243>
 <0.305,2.243><0.253,2.316><0.218,2.366><0.201,2.393>
 <0.201,2.393><0.201,2.393><0.216,2.414><0.216,2.414>
}
prism {
 linear_sweep
 bezier_spline 0,1,216
 <-0.89,1.24><-0.842,1.257><-0.773,1.276><-0.683,1.297>
 <-0.683,1.297><-0.594,1.317><-0.516,1.328><-0.451,1.328>
 <-0.451,1.328><-0.289,1.328><-0.208,1.302><-0.208,1.251>
 <-0.208,1.251><-0.208,1.223><-0.339,1.072><-0.601,0.797>
 <-0.601,0.797><-0.566,0.811><-0.504,0.83><-0.414,0.856>
 <-0.414,0.856><-0.325,0.881><-0.261,0.894><-0.223,0.894>
 <-0.223,0.894><-0.186,0.894><-0.121,0.871><-0.03,0.825>
 <-0.03,0.825><0.062,0.78><0.108,0.742><0.108,0.711>
 <0.108,0.711><0.108,0.684><0.084,0.664><0.038,0.65>
 <0.038,0.65><-0.008,0.637><-0.09,0.625><-0.208,0.615>
 <-0.208,0.615><-0.549,0.615><-0.881,0.558><-1.205,0.445>
 <-1.205,0.445><-1.485,0.32><-1.764,0.196><-2.043,0.072>
 <-2.043,0.072><-2.098,0.072><-2.165,0.101><-2.244,0.158>
 <-2.244,0.158><-2.324,0.215><-2.387,0.278><-2.436,0.346>
 <-2.436,0.346><-2.436,0.346><-2.42,0.367><-2.42,0.367>
 <-2.42,0.367><-2.417,0.367><-2.403,0.363><-2.379,0.357>
 <-2.379,0.357><-2.355,0.35><-2.332,0.346><-2.312,0.346>
 <-2.312,0.346><-2.284,0.346><-2.17,0.373><-1.97,0.426>
 <-1.97,0.426><-1.77,0.48><-1.657,0.515><-1.629,0.532>
 <-1.629,0.532><-1.688,0.604><-1.717,0.679><-1.717,0.757>
 <-1.717,0.757><-1.717,0.811><-1.641,0.897><-1.49,1.016>
 <-1.49,1.016><-1.338,1.134><-1.226,1.245><-1.154,1.349>
 <-1.154,1.349><-1.174,1.338><-1.205,1.329><-1.247,1.32>
 <-1.247,1.32><-1.288,1.312><-1.333,1.307><-1.381,1.307>
 <-1.381,1.307><-1.45,1.307><-1.524,1.325><-1.604,1.362>
 <-1.604,1.362><-1.683,1.398><-1.74,1.423><-1.774,1.437>
 <-1.774,1.437><-1.774,1.437><-1.774,1.478><-1.774,1.478>
 <-1.774,1.478><-1.75,1.495><-1.667,1.526><-1.524,1.571>
 <-1.524,1.571><-1.381,1.616><-1.232,1.66><-1.076,1.705>
 <-1.076,1.705><-1.076,1.712><-1.07,1.749><-1.056,1.816>
 <-1.056,1.816><-1.042,1.884><-1.035,1.941><-1.035,1.989>
 <-1.035,1.989><-1.035,2.038><-1.053,2.086><-1.089,2.135>
 <-1.089,2.135><-1.125,2.183><-1.183,2.24><-1.262,2.305>
 <-1.262,2.305><-1.262,2.305><-1.262,2.346><-1.262,2.346>
 <-1.262,2.346><-1.093,2.346><-0.941,2.32><-0.805,2.266>
 <-0.805,2.266><-0.669,2.213><-0.601,2.164><-0.601,2.119>
 <-0.601,2.119><-0.601,2.091><-0.609,2.047><-0.627,1.985>
 <-0.627,1.985><-0.644,1.923><-0.661,1.878><-0.678,1.85>
 <-0.678,1.85><-0.664,1.857><-0.643,1.862><-0.613,1.866>
 <-0.613,1.866><-0.584,1.869><-0.564,1.871><-0.554,1.871>
 <-0.554,1.871><-0.496,1.871><-0.423,1.857><-0.337,1.829>
 <-0.337,1.829><-0.251,1.802><-0.208,1.76><-0.208,1.705>
 <-0.208,1.705><-0.208,1.647><-0.29,1.588><-0.456,1.53>
 <-0.456,1.53><-0.621,1.471><-0.763,1.399><-0.88,1.313>
 <-0.88,1.313><-0.88,1.313><-0.89,1.24><-0.89,1.24>
 <-0.89,1.24><-0.89,1.24><-0.761,1.135><-0.761,1.135>
 <-0.761,1.135><-0.781,1.135><-0.866,1.079><-1.014,0.967>
 <-1.014,0.967><-1.162,0.855><-1.314,0.727><-1.469,0.582>
 <-1.469,0.582><-1.407,0.606><-1.328,0.632><-1.231,0.659>
 <-1.231,0.659><-1.135,0.687><-1.062,0.708><-1.014,0.721>
 <-1.014,0.721><-0.942,0.804><-0.874,0.885><-0.812,0.964>
 <-0.812,0.964><-0.75,1.044><-0.72,1.094><-0.72,1.114>
 <-0.72,1.114><-0.72,1.128><-0.733,1.135><-0.761,1.135>
 <-0.761,1.135><-0.761,1.135><-0.89,1.24><-0.89,1.24>
}
prism {
 linear_sweep
 bezier_spline 0,1,192
 <-1.086,-1.024><-0.97,-0.969><-0.868,-0.915><-0.778,-0.861>
 <-0.778,-0.861><-0.688,-0.808><-0.639,-0.771><-0.629,-0.75>
 <-0.629,-0.75><-0.629,-0.447><-0.638,-0.23><-0.656,-0.099>
 <-0.656,-0.099><-0.674,0.032><-0.703,0.098><-0.743,0.098>
 <-0.743,0.098><-0.743,0.098><-0.715,0.297><-0.715,0.297>
 <-0.715,0.297><-0.601,0.297><-0.498,0.274><-0.407,0.229>
 <-0.407,0.229><-0.316,0.183><-0.271,0.115><-0.271,0.024>
 <-0.271,0.024><-0.271,-0.311><-0.269,-0.634><-0.266,-0.945>
 <-0.266,-0.945><-0.262,-1.256><-0.257,-1.587><-0.25,-1.938>
 <-0.25,-1.938><-0.25,-2.128><-0.259,-2.255><-0.277,-2.318>
 <-0.277,-2.318><-0.296,-2.382><-0.334,-2.414><-0.393,-2.414>
 <-0.393,-2.414><-0.478,-2.414><-0.618,-2.307><-0.812,-2.094>
 <-0.812,-2.094><-1.007,-1.88><-1.11,-1.737><-1.12,-1.664>
 <-1.12,-1.664><-0.996,-1.744><-0.907,-1.798><-0.854,-1.827>
 <-0.854,-1.827><-0.8,-1.857><-0.751,-1.871><-0.706,-1.871>
 <-0.706,-1.871><-0.668,-1.871><-0.646,-1.832><-0.639,-1.752>
 <-0.639,-1.752><-0.632,-1.673><-0.629,-1.444><-0.629,-1.066>
 <-0.629,-1.066><-0.761,-1.157><-0.868,-1.231><-0.947,-1.289>
 <-0.947,-1.289><-1.027,-1.346><-1.073,-1.375><-1.086,-1.375>
 <-1.086,-1.375><-1.106,-1.375><-1.133,-1.363><-1.166,-1.338>
 <-1.166,-1.338><-1.199,-1.314><-1.219,-1.3><-1.226,-1.297>
 <-1.226,-1.297><-1.226,-1.617><-1.229,-1.846><-1.236,-1.982>
 <-1.236,-1.982><-1.243,-2.118><-1.294,-2.187><-1.387,-2.187>
 <-1.387,-2.187><-1.46,-2.187><-1.525,-2.127><-1.58,-2.008>
 <-1.58,-2.008><-1.636,-1.889><-1.664,-1.804><-1.664,-1.752>
 <-1.664,-1.752><-1.629,-1.553><-1.6,-1.314><-1.578,-1.037>
 <-1.578,-1.037><-1.555,-0.759><-1.544,-0.462><-1.544,-0.144>
 <-1.544,-0.144><-1.544,-0.144><-1.756,-0.055><-1.756,-0.055>
 <-1.756,-0.055><-1.756,-0.055><-1.756,-0.012><-1.756,-0.012>
 <-1.756,-0.012><-1.653,0.033><-1.481,0.096><-1.241,0.176>
 <-1.241,0.176><-1.002,0.256><-0.826,0.297><-0.715,0.297>
 <-0.715,0.297><-0.715,0.297><-0.743,0.098><-0.743,0.098>
 <-0.743,0.098><-0.776,0.098><-0.848,0.071><-0.957,0.017>
 <-0.957,0.017><-1.067,-0.036><-1.184,-0.094><-1.308,-0.156>
 <-1.308,-0.156><-1.291,-0.173><-1.273,-0.218><-1.254,-0.29>
 <-1.254,-0.29><-1.235,-0.362><-1.226,-0.414><-1.226,-0.445>
 <-1.226,-0.445><-1.139,-0.4><-1.056,-0.364><-0.974,-0.337>
 <-0.974,-0.337><-0.893,-0.309><-0.838,-0.295><-0.808,-0.295>
 <-0.808,-0.295><-0.758,-0.295><-0.719,-0.301><-0.691,-0.313>
 <-0.691,-0.313><-0.663,-0.325><-0.649,-0.349><-0.649,-0.383>
 <-0.649,-0.383><-0.649,-0.417><-0.709,-0.514><-0.83,-0.673>
 <-0.83,-0.673><-0.951,-0.831><-1.037,-0.948><-1.086,-1.024>
 <-1.086,-1.024><-1.086,-1.024><-1.226,-1.057><-1.226,-1.057>
 <-1.226,-1.057><-1.057,-0.861><-0.972,-0.716><-0.972,-0.622>
 <-0.972,-0.622><-0.993,-0.622><-1.029,-0.626><-1.081,-0.633>
 <-1.081,-0.633><-1.132,-0.64><-1.181,-0.644><-1.226,-0.644>
 <-1.226,-0.644><-1.226,-0.644><-1.226,-1.057><-1.226,-1.057>
 <-1.226,-1.057><-1.226,-1.057><-1.086,-1.024><-1.086,-1.024>
} }
//
coordinate_color( -30, 1.0, 0.5, 1, 2 )
#local P_ryu = pigment { color rgb <R2,G2,B2> }
#local Ryu_text =
cylinder { -Kh/2*y, Kh/2*y, Kr+0.01 open
 clipped_by { object { Ryu_base rotate -90*x scale <10,10,50> } }
 pigment { P_ryu } translate Kh/2*y
}
#local Kite_obj =
union {
 object { Kite_seg } object { Ryu_text }
 object { Rtail_org texture { T_kite } translate <-14,(-1/3*pow(pi,3)+0.2)*5,-31.5> }
 object { Ltail_org texture { T_kite } translate <14,(-1/3*pow(pi,3)+0.2)*5,-31.5> }
 object { Kite_thread }
}
object { Kite_obj scale <1.8,2.5,1.8> rotate <-40,35,30> translate <1200,800,2100> }
//**********************************************************************************
#include "Bird_wing.def.inc"
//----------------------------------------------------------------------------------
coordinate_color( 360, 0, 1, 1, 3 )
#local T_wing = texture { pigment { color rgbf <R3,G3,B3,0.3> } finish { ambient 0.4 } }
//
coordinate_color( 30, 1.0, 0.5, 1, 4 ) #local P_bill = pigment { color rgb <R4,G4,B4> }
coordinate_color( 30, 0.9, 0.7, 1, 5 ) #local P_eye = pigment { color rgb <R5,G5,B5> }
#local Head_seg =
union {
 disc { 0,z 3 }
 disc { 0,z, 4,3 clipped_by { cone { 0,1,-4*y,0.2 } } pigment { P_bill } }
 disc { 2*x,z 0.8 pigment { P_eye } translate -(1e-12)*z }
 disc {-2*x,z 0.8 pigment { P_eye } translate -(1e-12)*z }
}
//
#local Bird_kite =
union {
 object { Head_seg texture { T_wing } translate <0,Kh,-Kr>*1/4 }
 union { object { Kite_seg } object { Kite_thread } scale 1/4 }
 object { Wing_Rseg texture { T_wing } rotate <-90,180,0> rotate <-5,(Ra2+90),0> translate <-Kx,Kh,Kz>*1/4 }
 object { Wing_Lseg texture{ T_wing } rotate <-90,180,0> rotate <-5,-(Ra2+90),0> translate <Kx,Kh,Kz>*1/4 }
 object { Tail_seg texture { T_wing } rotate <-90,180,0> translate -Kr/4*z }
}
//
object { Bird_kite scale 6 rotate <-40,-20,0> translate <-700,760,2100> }
//**********************************************************************************
// definition
#local BL=-60;
//**********************************************************************************
// sled
#local F_sled =  finish { ambient 0.4 diffuse 0.4 reflection 0 phong 0.2 brilliance 0.5 }
coordinate_color(360,1.0,1.0,1,1)
#local P_sled = pigment { color rgb <R1,G1,B1> }
coordinate_color(150,1,0.9,1,3)
#local T_board = texture { pigment { P_sled } pigment { color rgbf <R3,G3,B3,0.3> } finish { F_sled } }
//
#local Board_base =
merge {
 sphere { -5*x 1 scale <5,1,1> translate 5*4*x }
 cylinder { -5*x,5*x 1 }
 sphere { 5*x 1 scale <3,1,1> translate -5*2*x }
}
#local Board_org = object { Board_base clipped_by { plane { y,0 } } }
#local Board_seg = object { Board_org clipped_by { Board_base scale <0.99,2,0.6> } texture { T_board } scale <1,2,1> }
//----------------------------------------------------------------------------------
coordinate_color(30,1,0.9,1,4)
#local T_bridge = texture { pigment { P_sled } pigment { color rgbf <R4,G4,B4,0.3> } finish { F_sled } }
#local Bridge_org =
torus { 4.1,0.2
 clipped_by { plane { z,0 rotate -(150-6+180)*y } }
 clipped_by { plane { z,0 rotate -(210+6)*y } }
 texture { T_bridge }
 rotate -90*z 
}
//----------------------------------------------------------------------------------
#local T_seat_t = texture { pigment { P_sled } pigment { color rgbf <R3,G3,B3,0.3> } finish { F_sled } }
coordinate_color(270,1,0.9,1,6)
#local T_seat_u = texture { pigment { P_sled } pigment { color rgbf <R6,G6,B6,0.3> } finish { F_sled } }
#local Seat_base = merge { sphere { -3*x 3 } cone { -3*x,3 4*x 4 } sphere { 4*x 4 } }
#local Lw=0.6;
#local Seat_Torg =
merge {
 torus { 3, Lw clipped_by { plane { x,0 } } translate -3*x }
 sphere { <-3,0,3> Lw } sphere { <4,0,4> Lw }
 cylinder { <-3,0, 3>,<4,0, 4> Lw open }
 cylinder { <-3,0,-3>,<4,0,-4> Lw open }
 sphere { <-3,0,-3> Lw } sphere { <4,0,-4> Lw }
 torus { 4, Lw clipped_by { plane { x,0 rotate 180*y } } translate 4*x }
}
#local Seat_org =
union {
 difference { object { Seat_Torg } object { Seat_base } texture { T_seat_t } translate Lw*y } 
 object { Seat_base clipped_by { plane { y,0 } } texture { T_seat_u } } 
 scale 0.8 rotate degrees(atan2(4-3,4+3))*z
}
//----------------------------------------------------------------------------------
#local Sled_seg =
union {
 object { Seat_org translate < -0.8,1.6,0 > }
 object { Bridge_org translate < -3.8,-5,0 > }
 object { Bridge_org translate < 3.2,-5,0 > }
 object { Board_seg translate  2*z }
 object { Board_seg translate -2*z }
 translate 2*y
}
//----------------------------------------------------------------------------------
object { Sled_seg scale 6 rotate 60*y translate < -8,BL,-205 > }
object { Sled_seg scale 6 rotate 110*y translate < -230,BL,700 > }
object { Sled_seg scale 6 rotate 110*y translate < 240,BL,900 > }
//**********************************************************************************
// mountain
coordinate_color( 60, 0.9, 0.6, 3, 1 )
#local P_mountain =
 pigment { granite
           turbulence 0.2
           color_map { [ 0.0 rgb < R1, G1, B1 > ]
                       [ 0.4 rgb < R2, G2, B2 > ]
                       [ 0.6 rgb < R2, G2, B2 > ]
                       [ 1.0 rgb < R1, G1, B1 > ] } }
//
coordinate_color( 29, 0.73, 0.93, 1, 2 )
#local T_mountain =
texture {
 pigment { P_mountain }
 pigment { color rgb < R2, G2, B2 > transmit 0.3 }
 normal { bumps 1.2 scale 4 }
 finish { ambient 0.6 }
}
//
merge {
 sphere { 450*y 50 }
 cone { <    0, 450, 4200 >, 50, <    0, 0, 4200 >, 1000 open }
 cone { < -400, 300, 4200 >,  0, < -400, 0, 4200 >, 1000 open }
 cone { < -800, 200, 4200 >,  0, < -800, 0, 4200 >, 1000 open }
 cone { <  800, 150, 4200 >,  0, <  800, 0, 4200 >,  800 open }
 cone { <    0, 300, 3800 >,  0, <    0, 0, 3800 >,  800 open }
 cone { <    0, 200, 3400 >,  0, <    0, 0, 3400 >,  800 open }
 texture { T_mountain scale 10 }
 translate < -500, BL+400, 0 >
}
//----------------------------------------------------------------------------------
// hill
coordinate_color( 30, 0.9, 0.6, 3, 1 )
#local P_hill =
 pigment { gradient x
           color_map { [ 0.00 rgb < R1, G1, B1 > ]
                       [ 0.45 rgb < R2, G2, B2 > ]
                       [ 0.55 rgb < R2, G2, B2 > ]
                       [ 1.00 rgb < R1, G1, B1 > ] } rotate 90*y scale 4 }
//
coordinate_color( 29, 0.73, 0.93, 1, 2 )
#local T_hill = 
texture { 
 pigment { P_hill }
 pigment { color rgb < R2, G2, B2 > transmit 0.3 }
 normal { bumps 1.2 scale 4 }
 finish { ambient 0.6 }
}
//
cone { < 0, 400, 7000 >, 3500, < 0, 0, 7000 >, 4500 texture { T_hill } translate <-800,BL,0> }
//----------------------------------------------------------------------------------
// conifer
coordinate_color(  70, 0.0, 0.7, 1, 1 )
coordinate_color( 190, 0.7, 0.3, 1, 2 )
coordinate_color( 310, 0.7, 0.3, 1, 3 )
#local T_conifer =
texture {
 pigment { wood
           turbulence 0.4
 color_map { [ 0.0, 0.1 color rgb < R1, G1, B1 > color rgb < R1, G1, B1 > ]
             [ 0.1, 0.5 color rgbt < R1, G1, B1, 0.4 > color rgbt< R3, G3, B3, 0.8 > ]
             [ 0.5, 1.0 color rgb < R1, G1, B1 > color rgb < R2, G2, B2 > ] } scale 3 }
}
//
coordinate_color( 20, 0.2, 0.4, 1, 4 )
#local P_conifer = pigment { color rgb < R4, G4, B4 > }
//
#local Conifer_base = 
torus { 30 ,1
 clipped_by { plane { z,0 } rotate -(180+180)*y }
 clipped_by { plane { z,0 } rotate -(180+45)*y }
 rotate -4*y translate 30*x rotate -90*x 
}
#local Conifer_org =
union {
 cone { < 0,130, 0 >,  5, < 0,150, 0 >, 2 }
#local Ei=32; #local Si=0; #while(Si<Ei)
 object { Conifer_base translate 3*x rotate 360*Si/Ei*y translate 130*y }
 object { Conifer_base translate 5*x rotate (10+360*Si/Ei)*y translate 110*y }
 object { Conifer_base translate 10*x rotate (8+360*Si/Ei)*y translate 90*y }
 object { Conifer_base translate 15*x rotate (6+360*Si/Ei)*y translate 70*y }
 object { Conifer_base translate 20*x rotate (4+360*Si/Ei)*y translate 50*y }
 object { Conifer_base translate 25*x rotate (2+360*Si/Ei)*y translate 30*y }
#local Si=Si+1; #end
 cone { < 0, 0, 0 >, 3, < 0, 150, 0 >, 2 pigment { P_conifer } }
 texture { T_conifer }
 translate BL*y
}
//
#local Sz=0; #local Ez=4; #while(Sz<Ez)
 #local Sx=0; #local Ex=5; #while(Sx<Ex)
  #if(mod(Sx,2)=0)
   object { Conifer_org scale 0.8 translate < 200+(50*Sx), 0, 300+(100*Sz) > }
  #else
   object { Conifer_org scale 0.8 translate < 200+(50*Sx), 0, 350+(100*Sz) > }
  #end
 #local Sx=Sx+1; #end
#local Sz=Sz+1; #end
//
#local Sz=0; #local Ez=3; #while(Sz<Ez)
 #local Sx=0; #local Ex=5; #while(Sx<Ex)
  object { Conifer_org translate < -800-(50*Sx) , 0, 1500+(100*Sz) > }
 #local Sx=Sx+1; #end
#local Sz=Sz+1; #end
//----------------------------------------------------------------------------------
// woods
#local Obj_seg =
union {
 cone { < 0,130, 0 >,  5, < 0,150, 0 >, 2 }
 cone { < 0,110, 0 >, 10, < 0,130, 0 >, 3 }
 cone { < 0, 90, 0 >, 15, < 0,110, 0 >, 5 }
 cone { < 0, 70, 0 >, 20, < 0, 90, 0 >,10 }
 cone { < 0, 50, 0 >, 25, < 0, 70, 0 >,15 }
 cone { < 0, 30, 0 >, 30, < 0, 50, 0 >,20 }
 difference {
  cone { < 0, 10, 0 >, 35, < 0, 30, 0 >,25 }
  #local Ei=20; #local Si=0; #while(Si<Ei)
   cone { -2*y,3 22*y,0 scale <24,1,1> rotate degrees(atan2(10,20))*z translate 35*x rotate 360*Si/Ei*y translate 10*y }
  #local Si=Si+1; #end }
 cone { < 0,  0, 0 >,  3, < 0,150, 0 >, 2 pigment { P_conifer } }
 texture { T_conifer }
 translate BL*y
}
#local Wood_seg =
union {
 #local Ei=13; #local Si=0; #while(Si<Ei)
  #local Rr=sqrt(pow(600,2)-pow(600*Si/Ei,2));
  union { Space_arrange(pi*<-1,1,1/8>,5) rotate 360*Si/Ei*y translate <-100,BL-60+0.3*600*Si/Ei,2000> }
  union { Space_arrange(pi*<-1,1,1/8>,6) rotate 360*Si/Ei*y translate < 200,BL-60+0.2*600*Si/Ei,2000> }
 #local Si=Si+1; #end
}
object { Wood_seg }
//**********************************************************************************
//#include "Normal_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(3) #local Pr=49.4;
          #local Px=Pr*cos(Se)*cos(Ss); #local Py=0.32*Pr*sin(Se); #local Pz=Pr*cos(Se)*sin(Ss); #break
 #end
#end
//----------------------------------------------------------------------------------
// shrub
coordinate_color( 70, 0.4, 0.7, 1, 1 )
coordinate_color( 70, 0.3, 0.8, 1, 2 )
coordinate_color( 70, 0.2, 0.9, 1, 3 )
#local P_shrub =
 pigment { gradient x
           turbulence 0.6
           color_map { [ 0.00 rgbt < R1, G1, B1, 0.20 > ]
                       [ 0.35 rgbt < R2, G2, B2, 0.40 > ]
                       [ 0.45 rgbt < R3, G3, B3, 0.95 > ]
                       [ 0.55 rgbt < R3, G3, B3, 0.95 > ]
                       [ 0.65 rgbt < R2, G2, B2, 0.40 > ]
                       [ 1.00 rgbt < R1, G1, B1, 0.20 > ] } scale 0.3 }
//
#local Leaf_base =
prism {
 linear_sweep
 bezier_spline 0,1,56
 <0,-0.012><-0.082,-0.012><-0.075,0.133><-0.158,0.245>
 <-0.158,0.245><-0.241,0.358><-0.453,0.582><-0.503,0.795>
 <-0.503,0.795><-0.552,1.007><-0.541,1.12><-0.549,1.338>
 <-0.549,1.338><-0.558,1.556><-0.577,1.677><-0.544,1.899>
 <-0.544,1.899><-0.51,2.121><-0.359,2.575><-0.304,2.7>
 <-0.304,2.7><-0.249,2.825><-0.186,2.885><-0.129,2.992>
 <-0.129,2.992><-0.072,3.099><-0.069,3.268><0,3.267>
 <0,3.267><0.069,3.266><0.066,3.095><0.123,2.986>
 <0.123,2.986><0.18,2.878><0.245,2.827><0.298,2.706>
 <0.298,2.706><0.351,2.585><0.479,2.145><0.514,1.923>
 <0.514,1.923><0.549,1.701><0.542,1.586><0.538,1.362>
 <0.538,1.362><0.533,1.137><0.541,1.017><0.491,0.795>
 <0.491,0.795><0.441,0.573><0.251,0.359><0.169,0.245>
 <0.169,0.245><0.088,0.132><0.082,-0.012><0,-0.012>
}
#local Leaf_org =
cone { -1*z,2 10*z,6 open
 clipped_by { object { Leaf_base scale <1,6,1> translate -6*y } }
 rotate -10*x translate <0,5.4,-0.3>
}
#local Handle_org =
torus { 3,0.04
 clipped_by { plane { z, 0 } rotate -(174+180)*y }
 clipped_by { plane { z, 0 } rotate -(190)*y }
 rotate-90*z 
}
#local Leaf_seg =
union {
 object { Leaf_org }
 object { Handle_org }
 cone { 0,0.04 0.5*z,0 translate 3*y rotate 6*x }
 pigment { P_shrub }
 translate <0,3*-cos(radians(10)),3*sin(radians(10))>
}
#local Obj_seg =
union {
 #local Ei=3; #local Si=0; #while(Si<Ei)
  object { Leaf_seg rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 scale 1.5 rotate <0,15,-90>
}
#local Shrub_org = union { Normal_rect(pi*<-1,1,1/16>,pi*<0,1/2,1/16>,3) }
//
#local Obj_seg =
union {
 #local Ei=3; #local Si=0; #while(Si<Ei)
  object { Leaf_seg rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 scale 1.5 rotate <-90,0,15>
}
//
#local Shrub_seg =
union {
 object { Shrub_org translate (BL+20)*y }
 #local Ei=7; #local Si=0; #while(Si<Ei)
  #local Rr=40+10*Si/Ei; union { Space_arrange(pi*<-1,1,1/16>,7) rotate (2+360*Si/Ei)*y translate (20*Si/Ei+BL)*y }
 #local Si=Si+1; #end
 scale 0.6
}
//
#local Si=0; #local Ei=5;
#while(Si<Ei)
 object { Shrub_seg translate < 40-(30*Si), 0, -190+(100*Si) > }
 #local Si=Si+1;
#end
//
#local Si=0; #local Ei=3;
#while(Si<Ei)
 object { Shrub_seg translate < -60-(50*Si), 0, -210+(100*Si) > }
 #local Si=Si+1;
#end
//**********************************************************************************
// water
coordinate_color(120,1,0.5,1,1)
#local P_water_a = pigment { color rgb <R1,G1,B1> }
//
coordinate_color(360,0.00,0.85,1,2)
coordinate_color(180,0.12,0.60,1,3)
coordinate_color(150,0.18,0.25,1,4)
coordinate_color(150,0.25,0.15,1,5)
#local P_water_b =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0,0.10 color rgb <R2,G2,B2> color rgb <R3,G3,B3> ]
                       [0.1,0.50 color rgb <R3,G3,B3> color rgb <R4,G4,B4> ]
                       [0.5,1.00 color rgb <R4,G4,B4> color rgb <R5,G5,B5> ] }
           scale <6,4,6>
 }
//
#local T_water =
texture {
 pigment { P_water_a filter 0.9 }
 pigment { P_water_b transmit 0.7 }
 normal { ripples 0.75 frequency 10 }
 finish { reflection 0.3 }
}
//
#local Water_seg =
union {
 plane { y,0 texture { T_water scale 46 } interior { ior 1.02 caustics 0.04 } }
 plane { y,-100 pigment { color rgb 1 } normal { bumps 0.3 scale 24 } }
}
//----------------------------------------------------------------------------------
// ground
coordinate_color( 360, 0.0, 0.70, 1, 1 )
coordinate_color( 29, 0.73, 0.93, 1, 2 )
#local T_ground_s = 
texture { 
 pigment { color rgb < R1, G1, B1 >*2.0 }
 pigment { color rgb < R2, G2, B2 >*1.2 transmit 0.1 }
 normal { bumps 1.2 scale 4 }
 finish { ambient 0.6 }
}
//
#local T_ground = 
texture { 
 pigment { color rgb < R2, G2, B2 >*1.2 transmit 0.3 }
 normal { bumps 1.2 scale 4 }
 finish { ambient 0.6 }
}
//
#local Effect_obj =
object { Water_seg
 clipped_by { plane { z.0 } rotate  88*y }
 clipped_by { plane { z.0 } rotate -88*y }
}
//
#local Ground_seg =
union {
 object { Effect_obj }
 plane { y, BL+0.2 texture { T_ground_s } }
 cone { < -1200, BL+60, 1500 >, 200, < -1200, BL, 1500 >, 1000 texture { T_ground_s } }
 sphere { < 320, BL*5-80, 460 >,150 scale <1,0.2,1> texture { T_ground_s } }
 plane { y, BL texture { T_ground } }
}
//
object { Ground_seg }
//**********************************************************************************