//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Bird wing defnition type 0.1b010702a include File
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
#include "Normal_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Pr=3; #local Px=Pr*cos(Se)*cos(Ss); #local Py=Pr*sin(Se); #local Pz=Pr*cos(Se)*sin(Ss); #break
 #case(1) #local Px= 80*cos(Se)*cos(Ss); #local Py=10*sin(Se); #local Pz=20*cos(Se)*sin(Ss); #break
 #case(2) #local Px=-80*cos(Se)*cos(Ss); #local Py=10*sin(Se); #local Pz=20*cos(Se)*sin(Ss); #break
 #end
#end
//----------------------------------------------------------------------------------
#local Rl=20;
#local Wing_Lorg =
union {
 sphere { 0,Rl }
 cone { 0,Rl, -5*Rl*z,0.7*Rl }
 sphere { -5*Rl*z,0.7*Rl }
 clipped_by { plane { x,0 } }
 scale < 1,0.1,1 >
}
#local Sr=1/3;
#local Wing_Rorg =
union {
 sphere { 0,Rl*Sr }
 cone { 0,Rl*Sr, -(Rl*(1-Sr)+5*Rl+0.7*Rl*(1-Sr))*z,0.7*Rl*Sr }
 sphere { -(Rl*(1-Sr)+5*Rl+0.7*Rl*(1-Sr))*z,0.7*Rl*Sr }
 clipped_by { plane { x,0 rotate 180*y } }
 scale < 1,0.1,1 >
 translate Rl*(1-Sr)*z
}
#local Wing_org =
union {
 object { Wing_Lorg  }
 object { Wing_Rorg  }
 cone { Rl*z,2, -(5*Rl+0.7*Rl-Rl*Sr/4)*z,0.8 }
 rotate -90*x rotate -90*y
 scale 0.1 
}
//----------------------------------------------------------------------------------
#local Vd1=38; #local Vd2=28; #local Vh=0.5;
//
#declare Wing_Rseg =
 union {
 #local Obj_seg = object { Wing_org scale 0.6 }
 union { Normal_rect(pi*<-0.70, 0.0,1/18>,pi*<0.5-1/Vd1,0.5,1/Vd1>,1) }
 #local Obj_seg = object { Wing_org scale 0.8 }
 union { Normal_rect(pi*<-0.60, 0.0,1/24>,pi*<0.5-2/Vd1,0.5-1/Vd1,1/Vd1>,1) }
 #local Obj_seg = object { Wing_org }
 union { Normal_rect(pi*<-0.52,-0.03,1/36>,pi*<0.5-3/Vd1,0.5-2/Vd1,1/Vd1>,1) }
 #local Obj_seg = object { Wing_org scale 0.9 }
 union { Normal_rect(pi*<-0.55,-0.52,1/36>,pi*<0.5-3/Vd1,0.5-2/Vd1,1/Vd1>,1) }
 //
 #local Obj_seg = object { Wing_org scale < 1,0.9,1 > }
 object{ Normal_rect(pi*<-0.20,-0.18,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,1) translate <-12,Vh,0 > }
 #local Obj_seg = object { Wing_org }
 union { Normal_rect(pi*<-0.18,-0.15,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,1) translate <-12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.2,1 > }
 union { Normal_rect(pi*<-0.15,-0.12,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,1) translate <-12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.4,1 > }
 object{ Normal_rect(pi*<-0.12,-0.10,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,1) translate <-12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.6,1 > }
 union { Normal_rect(pi*<-0.10,-0.08,1/62>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,1) translate <-12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.4,1 > }
 union { Normal_rect(pi*<-0.08,-0.05,1/62>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,1) translate <-12,Vh,0 > }
 translate < 4,-10,0 >
}
//
#declare Wing_Lseg =
 union {
 #local Obj_seg = object { Wing_org scale 0.6 }
 union { Normal_rect(pi*<-0.70, 0.0,1/18>,pi*<0.5-1/Vd1,0.5,1/Vd1>,2) }
 #local Obj_seg = object { Wing_org scale 0.8 }
 union { Normal_rect(pi*<-0.60, 0.0,1/24>,pi*<0.5-2/Vd1,0.5-1/Vd1,1/Vd1>,2) }
 #local Obj_seg = object { Wing_org }
 union { Normal_rect(pi*<-0.52,-0.03,1/36>,pi*<0.5-3/Vd1,0.5-2/Vd1,1/Vd1>,2) }
 #local Obj_seg = object { Wing_org scale 0.9 }
 union { Normal_rect(pi*<-0.55,-0.52,1/36>,pi*<0.5-3/Vd1,0.5-2/Vd1,1/Vd1>,2) }
 //
 #local Obj_seg = object { Wing_org scale < 1,0.9,1 > }
 object{ Normal_rect(pi*<-0.20,-0.18,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,2) translate < 12,Vh,0 > }
 #local Obj_seg = object { Wing_org }
 union { Normal_rect(pi*<-0.18,-0.15,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,2) translate < 12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.2,1 > }
 union { Normal_rect(pi*<-0.15,-0.12,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,2) translate < 12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.4,1 > }
 object{ Normal_rect(pi*<-0.12,-0.10,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,2) translate < 12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.6,1 > }
 union { Normal_rect(pi*<-0.10,-0.08,1/62>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,2) translate < 12,Vh,0 > }
 #local Obj_seg = object { Wing_org scale < 1,1.4,1 > }
 union { Normal_rect(pi*<-0.08,-0.05,1/62>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,2) translate < 12,Vh,0 > }
 translate <-4,-10,0 >
}
//**********************************************************************************
#local Rl=2;
#local Obj_seg =
union {
 sphere { 0,0.7*Rl }
 cone { 0,0.7*Rl, 5*Rl*z,Rl }
 sphere { 5*Rl*z,Rl }
 scale < 0.5,0.1,1 >
}
#declare Tail_seg =
union {
 #local Ei=12; #local Si=0; #while(Si<Ei)
  object { Obj_seg rotate (-150-60*Si/(Ei-1))*y }
 #local Si=Si+1; #end
}
//**********************************************************************************