
#if (CAMERA=1) camera		// Experimental Camera
{
  location  <526,198,406>
  direction 2.0*z
  up        y
  right     4/3*x
  look_at   <0.0, 85.0,  0>
  scale SCALEFACTOR
}
#end

#if (CAMERA=2) camera		// View scene from outside
{
  location  <1000.0, 200, 700>
  direction 2.0*z
  up        y
  right     4/3*x
  look_at   <0.0, 50.0,  0>
scale SCALEFACTOR
}
#end

#if(CAMERA=3) camera		// Final Camera View
{
  location  finalcameraposition // position of camera <X Y Z>
    direction 2.0*z            // which way are we looking <X Y Z> & zoom
  //direction 20*z
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  up        y                // which way is +up <X Y Z>
//  aperture 0.4               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point nearlamppos+<0,125,0>+<0,15.5,0>       // x,y,z point that is in focus
scale SCALEFACTOR
//rotate <0,0,2>
  look_at   finalcameralookat // point center of view at this point <X Y Z>
}
#end

#if (CAMERA=4) camera		// Birds eye Camera
{
  location  <-2201.0, 6000, -5000>
  direction 10*z
  up        -x
  right     4/3*x
  look_at   <-2200,0,-2600>
  scale SCALEFACTOR
}
cylinder {
	finalcameraposition+<0,50,0>
	finalcameralookat+<0,50,0>
	20
	pigment {
		color White
	}
	finish {
		ambient 20
	}
}
sphere {
	finalcameraposition+<0,50,0>
	25
	pigment {colour Red}
	finish {ambient 20}
}
	
#end

#if (CAMERA=5) camera		// Birds eye of Small world
{
  location  <200.0, 10000, 000> 
  direction 400*z
  up        -x
  right     4/3*x
  look_at   finalcameraposition +<-30,0,-20>
scale SCALEFACTOR
}
#end

#if(CAMERA=6) camera		// Middle street light
{
  location  finalcameraposition // position of camera <X Y Z>
  direction 3.00*z            // which way are we looking <X Y Z> & zoom
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <-10000+700*3.5,-200,-5000+700*-1> // point center of view at this point <X Y Z>
//  aperture 0.4               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point nearlamppos+<0,125,0>+<0,15.5,0>       // x,y,z point that is in focus
scale SCALEFACTOR
}
#end

#if(CAMERA=7) camera		// Left street light
{
  location  finalcameraposition // position of camera <X Y Z>
  direction 8.00*z            // which way are we looking <X Y Z> & zoom
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <-10000+5000,0,-5000> // point center of view at this point <X Y Z>
//  aperture 0.4               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point nearlamppos+<0,125,0>+<0,15.5,0>       // x,y,z point that is in focus
scale SCALEFACTOR
}
#end
