#declare POV35=1;

#if (POV35) 
#else
#version unofficial MegaPov 0.7;
#end

// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"


                                            // set viewer's position in the scene
#declare RADIOSITYSET=0;
#declare PHOTONS=0;
#declare AREALAMP=0;
#declare REFRACTION=1;


global_settings {
  adc_bailout 0.003922
  ambient_light <0.05,0.05,0.05>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
#if (RADIOSITYSET) 
  radiosity {
    brightness       6.3
    count            150
    distance_maximum 15.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
#end
#if (PHOTONS)  photons{
    count 2000000
    autostop 0
    jitter .4
}
#end
  }

/*#declare yaxisscale = transform {matrix
		<1,0,0,
		.3,1,.3
		0,0,1,
		0,0,0>}
*/		

camera
{
// (camera types)
//  perspective (default) | orthographic | fisheye |
//  ultra_wide_angle | omnimax | panoramic | cylinder 1
  location  <180.0, 180, 140> // position of camera <X Y Z>
  direction 12.0*z            // which way are we looking <X Y Z> & zoom
//  sky       y                // rarely used
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 15.0,  0> // point center of view at this point <X Y Z>
//  angle FLOAT                // overrides "direction" with specific angle
//  normal { ripples 0.2 }     // perturb the camera lens with a pattern
// (focal blur extras)
//  aperture 0.2               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point <VECTOR>       // x,y,z point that is in focus
}

/* media {
  intervals 10
  scattering {1, rgb 0.03}
  samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
} */

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color White * .8  // light's color
  translate <-200, 200, 200>
  rotate y*clock*360
}

/*light_source
{
  0*x // light's position (translated below)
  color Yellow *2 // light's color
  looks_like {
  	sphere {
  		<0,0,0>
  		2
  		pigment {color Yellow}
  		finish {ambient .9}
  	}
  }
  translate <0, 8, 0>
  	
} */

/*light_source
{
  
  0*x // light's position (translated below)
  color Yellow *1 // light's color
//  area_light <-3,-3,-3>, <3,3,3>,3,3
//  circular
  looks_like {
  	sphere {
  		<0,0,0>
  		2
  		pigment {color Yellow}
  		finish {ambient 2.5}
  	}
  }
  translate <0, 8, 0>
  	
} */

#include "lamp.inc"

intersection {
	plane {
		y,
		-250
		pigment {
			color rgb .4
		}
		finish {
			ambient .1
		}
	}        
	sphere {
		<0,250,0>
		5000
	}
}


object {
	lamp_h
//	transform {yaxisscale}
	rotate <0,-90,0>
	}

