#include "fgrass.inc"

#declare CamLoc = <0,-3.3,-30>;
   
#declare HF =
height_field { 
        png "hf6" smooth         
                translate -0.5
                scale <hfscalx,hfscaly,hfscalz>
                translate <0,-1.75,0>
}
   
#declare GrassMap = function(x,y,z) {(0.4+f_noise3d(x/5,y/5+3.6,z/5))}
   
#declare GrassNormal = normal {bumps 0.5 scale 0.02 turbulence 2}
   
object {
        HF
        hollow      
        material{
                texture {
                        fg_ground(1.0*0.1,<0.16,0.3,0.16>*0.13,<0.20,0.25,0.15>*0.1,"GrassMap")
                        normal {bumps 0.5 scale 0.01}
                }
                interior {ior 1.334}
        }
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.5-0.20,0.7-0.20,0.5-0.20>*0.2,0.2,2,"GrassMap") normal {GrassNormal}}interior{ior 1.334}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.6-0.20,0.7-0.20,0.3-0.20>*0.2,0.2,3,"GrassMap") normal {GrassNormal}}interior{ior 1.334}}       
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.5-0.20,0.7-0.20,0.5-0.20>*0.2,0.2,0,"GrassMap") normal {GrassNormal}}interior{ior 1.334}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.7-0.20,0.7-0.20,0.4-0.20>*0.2,0.2,4,"GrassMap") normal {GrassNormal}}interior{ior 1.334}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.6-0.20,0.8-0.20,0.4-0.20>*0.2,0.2,5,"GrassMap") normal {GrassNormal}}interior{ior 1.334}}       
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.5-0.20,0.6-0.20,0.4-0.20>*0.2,0.2,6,"GrassMap") normal {GrassNormal}}interior{ior 1.334}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.7-0.20,0.7-0.20,0.4-0.20>*0.2,0.2,7,"GrassMap") normal {GrassNormal}}interior{ior 1.334}} 
        //double_illuminate
}
   
object {
        HF translate 0.08*y*0.15
        hollow
        //no_shadow 
        interior_texture{pigment {color transmit 1}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.5-0.20,0.6-0.20,0.4-0.20>*0.2,0.2,1,"GrassMap") normal {GrassNormal}}interior{ior 1.33}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.7-0.20,0.7-0.20,0.4-0.20>*0.2,0.2,4,"GrassMap") normal {GrassNormal}}interior{ior 1.33}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.6-0.20,0.8-0.20,0.4-0.20>*0.2,0.2,5,"GrassMap") normal {GrassNormal}}interior{ior 1.33}}       
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.5-0.20,0.6-0.20,0.4-0.20>*0.2,0.2,6,"GrassMap") normal {GrassNormal}}interior{ior 1.33}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.7-0.20,0.7-0.20,0.4-0.20>*0.2,0.2,7,"GrassMap") normal {GrassNormal}}interior{ior 1.33}}
        material{texture{fg_grass(CamLoc,1.0*0.1,<0.6-0.20,0.8-0.20,0.4-0.20>*0.2,0.2,8,"GrassMap") normal {GrassNormal}}interior{ior 1.33}}
        //double_illuminate 
}
  