// Persistence of Vision Ray Tracer Scene Description File
// File: fokkerDR_Partes.inc
// Vers: 3.1
// Desc: Fokker DR.I (Red Baron)
// Date: Septiembre 2001
// Auth: J. F. Tuduri

// TEXTURAS 
#declare textSpandau = texture {
                                pigment {rgb .3}
                                finish {phong .9 phong_size 50 metallic}
                                normal {bumps scale .05}
                                }
                                
#declare text1Rojo = texture {
                        pigment {rgb <.8,.05,.05>}
                        finish {metallic 
                                specular .4 roughness .02
                                reflection .01}        
                        }
#declare textSucio = texture {
                              pigment {
                                       bozo
                                       frequency 4
                                       turbulence .6
                                       scale <.4,.4,10>                                      
                                       color_map{
                                       [0 rgbt <0,0,0,1>]
                                       [.4 rgbt <0,0,0,1>]
                                       [.5 rgbt <0,0,0,.85>]
                                       [.95 rgbt <0,0,0,.9>]
                                       }
                                       }
                             }                         
#declare text2Rojo = texture {
                        pigment {rgb <.8,.05,.05>}
                        finish {specular .2 roughness .02
                                reflection .01}        
                        }
#declare textTimon = texture {
                        pigment {rgb <.97,.97,.97>}
                        finish {specular .2 roughness .02
                                reflection .01}        
                        }                        
                                                 
#declare textBorde = texture {
                              pigment {rgb <1,.1,.1>}
                              finish {phong .7 phong_size 50}
                              normal {bumps scale .05 }
                                }
#declare textCubiertas = texture {pigment { rgb < 0.1, 0.1, 0.1 > }
	                          finish { phong 0.7 phong_size 70}
	                          normal {waves scale .5}
	                          }
#declare textSoportes= texture {text1Rojo}

#declare textHelice = texture {pigment{rgb <.4,.2,.2>}
                                 finish {phong .2}
                               }
#declare textMotor = texture {pigment {bozo
                                       scale .1
                                       turbulence .5
                                       color_map
                                       {[.4 rgb <.4,.4,.4>]
                                        [.6 rgb <.5,.3,.3>]
                                        }
                                        }
                              finish {metallic
                                      phong .6 phong_size 35
                                      reflection .4}
                              normal {agate}
                              }  


#declare textTrompa =texture {pigment {rgb <1,0,0>}
                              finish {metallic
                                      specular .6 roughness .03
                                      reflection .1}
                              normal {dents .5 scale .5}
                              } 

#declare textM_Cuerpo =texture {pigment {rgb <.4,.3,.2>}
                                normal {bumps scale .3}
                                }
#declare textM_Casco =texture {pigment {rgb <.4,.3,.2>}
                                normal {bumps scale .3}
                                }
#declare textM_Bufanda =texture {pigment {rgb <.85,.85,.75>}}
#declare textM_Cara =texture {pigment {rgb <.2,.2,.2>}
                              finish{phong .8 phong_size 40}
                              }
	                          

// Partes
// Alas,Aler_D,Aler_I,Borde_Cab,Cola_Fija,Cola_Movil,Timon,Cubiertas,
// Fuselaje,Helice,Llantas,Motor,Soportes,Trompa.
// M_Cuerpo,M_Bufanda,M_Cara,M_Casco

#declare Spandau=union{
 
difference{
union {
        cylinder {<0,-.07,0>,<0,-.07,.05>,.03}
        cylinder {<0,-.07,-.01>,<0,-.07,.05>,.02}
        torus {.02,.01 rotate x*90 translate y*(-.07)}
        torus {.02,.01 rotate x*90 translate <0,-.07,.05>}
        cylinder {<0,-.07,0>,<0,-.07,.8>,.02}
      }
        cylinder {<0,-.07,-.1>,<0,-.07,1>,.015}
      } 

difference{
        cylinder {<0,-.02,.05>,<0,-.02,.1>,.077}
        cylinder {<0,-.02,.056>,<0,-.02,.11>,.075}
        torus {.05,.003 rotate x*90 translate <0,-.047,.052> pigment {rgb .6}}
        }

difference{
        cylinder {<0,-.02,.05>,<0,-.02,.1>,.077}
        cylinder {<0,-.02,.045>,<0,-.02,.099>,.075}
        translate z*.7
        }
        
torus {.077,.003 rotate x*90 translate <0,-.02,.1>}
torus {.077,.003 rotate x*90 translate <0,-.02,.052>}

cylinder {<-.001,.055,.075>,<.001,.055,.075>,.01}

difference{
           cylinder {<0,0,0>,<0,0,.01>,.01}
           cylinder {<0,0,-.001>,<0,0,.011>,.008}
           translate <0,.065,.07>
           }
 
cylinder {<0,-.02,.1>,<0,-.02,.8>,.08 
          pigment {leopard
                   scale <.008,.008,.007>
                   color_map {[0 rgb .5]
                              [.05 rgb .5]
                              [.15 rgb .5 transmit 1]
                              [1 rgb .5 transmit 1]
                              }
                   }
          finish {phong .9 phong_size 50 metallic}
         }

sphere {<0,0,0>,.08 scale <1,1,.7> translate <0,-.02,.8>}
difference{
        box {<-.06,0,.8>,<.06,-.09,1>}
        sphere {<0,0,0>,.05 scale <1,1.1,1.4> translate <0,-.09,1>}
        cylinder {<.06,0,.8>,<.06,0,1.01>,.02}
        cylinder {<-.06,0,.8>,<-.06,0,1.01>,.02}    
        }
        
cylinder {<0,0,0>,<0,0,.18>,.01 translate <0,0,.8>} 
cylinder {<0,0,0>,<0,0,.18>,.01 translate <.02,0,.8>}
cylinder {<0,0,0>,<0,0,.18>,.01 translate <-.02,0,.8>}

cylinder {<0,0,0>,<0,-.15,0>,.01 translate <.06,-.05,.85>}
sphere {<0,0,0>,.01 translate <.06,-.05,.85>} 
cylinder {<0,0,0>,<0,-.15,0>,.01 translate <.06,-.05,.96>}
sphere {<0,0,0>,.01 translate <.06,-.05,.96>}
cylinder {<0,0,0>,<0,-.15,0>,.01 translate <-.06,-.05,.85>}
sphere {<0,0,0>,.01 translate <-.06,-.05,.85>} 
cylinder {<0,0,0>,<0,-.15,0>,.01 translate <-.06,-.05,.96>}
sphere {<0,0,0>,.01 translate <-.06,-.05,.96>}         
         
texture {textSpandau}
}        

#declare Ametralladoras = union {
                                object {Spandau translate <.2,.65,-.05>}
                                object {Spandau translate <-.2,.65,-.05>}
                                }

#declare Alas=
        union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.322, 0.970> <0.153, 1.322, 0.970> <0.233, 1.322, 0.970> <0.293, 1.322, 0.970> 
		<0.093, 1.329, 0.803> <0.153, 1.329, 0.803> <0.233, 1.329, 0.803> <0.293, 1.329, 0.803> 
		<0.093, 1.340, 0.872> <0.153, 1.340, 0.872> <0.233, 1.340, 0.872> <0.293, 1.340, 0.872> 
		<0.093, 1.347, 0.414> <0.153, 1.347, 0.414> <0.233, 1.347, 0.414> <0.293, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.322, 0.970> <0.093, 1.329, 0.803> <0.093, 1.340, 0.872> <0.093, 1.347, 0.414> 
		<0.033, 1.322, 0.970> <0.033, 1.329, 0.803> <0.033, 1.340, 0.872> <0.033, 1.347, 0.414> 
		<-0.047, 1.322, 0.970> <-0.047, 1.329, 0.803> <-0.047, 1.340, 0.872> <-0.047, 1.347, 0.414> 
		<-0.107, 1.322, 0.970> <-0.107, 1.329, 0.803> <-0.107, 1.340, 0.872> <-0.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.322, 0.970> <0.093, 1.349, 0.832> <0.093, 1.392, 0.650> <0.093, 1.413, 0.511> 
		<0.153, 1.322, 0.970> <0.153, 1.349, 0.832> <0.153, 1.392, 0.650> <0.153, 1.413, 0.511> 
		<0.233, 1.322, 0.970> <0.233, 1.349, 0.832> <0.233, 1.396, 0.650> <0.233, 1.417, 0.511> 
		<0.293, 1.322, 0.970> <0.293, 1.349, 0.832> <0.293, 1.392, 0.650> <0.293, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.322, 0.970> <0.033, 1.322, 0.970> <-0.047, 1.322, 0.970> <-0.107, 1.322, 0.970> 
		<0.093, 1.349, 0.832> <0.033, 1.349, 0.832> <-0.047, 1.349, 0.832> <-0.107, 1.349, 0.832> 
		<0.093, 1.392, 0.650> <0.033, 1.392, 0.650> <-0.047, 1.392, 0.650> <-0.107, 1.392, 0.650> 
		<0.093, 1.413, 0.511> <0.033, 1.413, 0.511> <-0.047, 1.413, 0.511> <-0.107, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.413, 0.511> <0.033, 1.413, 0.511> <-0.047, 1.413, 0.511> <-0.107, 1.413, 0.511> 
		<0.093, 1.426, 0.420> <0.033, 1.426, 0.420> <-0.047, 1.426, 0.420> <-0.107, 1.426, 0.420> 
		<0.093, 1.436, 0.296> <0.033, 1.436, 0.296> <-0.047, 1.436, 0.296> <-0.107, 1.436, 0.296> 
		<0.093, 1.434, 0.204> <0.033, 1.434, 0.204> <-0.047, 1.434, 0.204> <-0.107, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.413, 0.511> <0.093, 1.426, 0.420> <0.093, 1.436, 0.296> <0.093, 1.434, 0.204> 
		<0.153, 1.413, 0.511> <0.153, 1.426, 0.420> <0.153, 1.436, 0.296> <0.153, 1.434, 0.204> 
		<0.233, 1.417, 0.511> <0.233, 1.430, 0.420> <0.233, 1.440, 0.296> <0.233, 1.438, 0.204> 
		<0.293, 1.413, 0.511> <0.293, 1.426, 0.420> <0.293, 1.436, 0.296> <0.293, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.434, 0.204> <0.093, 1.433, 0.145> <0.093, 1.431, 0.081> <0.093, 1.402, 0.010> 
		<0.153, 1.434, 0.204> <0.153, 1.433, 0.145> <0.153, 1.431, 0.081> <0.153, 1.402, 0.010> 
		<0.233, 1.438, 0.204> <0.233, 1.437, 0.145> <0.233, 1.435, 0.081> <0.233, 1.406, 0.010> 
		<0.293, 1.434, 0.204> <0.293, 1.433, 0.145> <0.293, 1.431, 0.081> <0.293, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.434, 0.204> <0.033, 1.434, 0.204> <-0.047, 1.434, 0.204> <-0.107, 1.434, 0.204> 
		<0.093, 1.433, 0.145> <0.033, 1.433, 0.145> <-0.047, 1.433, 0.145> <-0.107, 1.433, 0.145> 
		<0.093, 1.431, 0.081> <0.033, 1.431, 0.081> <-0.047, 1.431, 0.081> <-0.107, 1.431, 0.081> 
		<0.093, 1.402, 0.010> <0.033, 1.402, 0.010> <-0.047, 1.402, 0.010> <-0.107, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.402, 0.010> <0.093, 1.391, -0.017> <0.093, 1.340, -0.050> <0.093, 1.337, -0.030> 
		<0.153, 1.402, 0.010> <0.153, 1.391, -0.017> <0.153, 1.340, -0.050> <0.153, 1.337, -0.030> 
		<0.233, 1.406, 0.010> <0.233, 1.394, -0.017> <0.233, 1.340, -0.050> <0.233, 1.337, -0.030> 
		<0.293, 1.402, 0.010> <0.293, 1.391, -0.017> <0.293, 1.340, -0.050> <0.293, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.402, 0.010> <0.033, 1.402, 0.010> <-0.047, 1.402, 0.010> <-0.107, 1.402, 0.010> 
		<0.093, 1.391, -0.017> <0.033, 1.391, -0.017> <-0.047, 1.391, -0.017> <-0.107, 1.391, -0.017> 
		<0.093, 1.340, -0.050> <0.033, 1.340, -0.050> <-0.047, 1.340, -0.050> <-0.107, 1.340, -0.050> 
		<0.093, 1.337, -0.030> <0.033, 1.337, -0.030> <-0.047, 1.337, -0.030> <-0.107, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.337, -0.030> <0.093, 1.322, 0.083> <0.093, 1.352, 0.048> <0.093, 1.347, 0.414> 
		<0.153, 1.337, -0.030> <0.153, 1.322, 0.083> <0.153, 1.352, 0.048> <0.153, 1.347, 0.414> 
		<0.233, 1.337, -0.030> <0.233, 1.322, 0.083> <0.233, 1.352, 0.048> <0.233, 1.347, 0.414> 
		<0.293, 1.337, -0.030> <0.293, 1.322, 0.083> <0.293, 1.352, 0.048> <0.293, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.337, -0.030> <0.033, 1.337, -0.030> <-0.047, 1.337, -0.030> <-0.107, 1.337, -0.030> 
		<0.093, 1.322, 0.083> <0.033, 1.322, 0.083> <-0.047, 1.322, 0.083> <-0.107, 1.322, 0.083> 
		<0.093, 1.352, 0.048> <0.033, 1.352, 0.048> <-0.047, 1.352, 0.048> <-0.107, 1.352, 0.048> 
		<0.093, 1.347, 0.414> <0.033, 1.347, 0.414> <-0.047, 1.347, 0.414> <-0.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 1.322, 0.970> <0.353, 1.322, 0.970> <0.433, 1.322, 0.970> <0.493, 1.322, 0.970> 
		<0.293, 1.329, 0.803> <0.353, 1.329, 0.803> <0.433, 1.329, 0.803> <0.493, 1.329, 0.803> 
		<0.293, 1.340, 0.872> <0.353, 1.340, 0.872> <0.433, 1.340, 0.872> <0.493, 1.340, 0.872> 
		<0.293, 1.347, 0.414> <0.353, 1.347, 0.414> <0.433, 1.347, 0.414> <0.493, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 1.322, 0.970> <0.293, 1.349, 0.832> <0.293, 1.392, 0.650> <0.293, 1.413, 0.511> 
		<0.353, 1.322, 0.970> <0.353, 1.349, 0.832> <0.353, 1.389, 0.650> <0.353, 1.409, 0.511> 
		<0.433, 1.322, 0.970> <0.433, 1.342, 0.832> <0.433, 1.372, 0.649> <0.433, 1.387, 0.511> 
		<0.493, 1.322, 0.970> <0.493, 1.342, 0.832> <0.493, 1.372, 0.649> <0.493, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 1.413, 0.511> <0.293, 1.426, 0.420> <0.293, 1.436, 0.296> <0.293, 1.434, 0.204> 
		<0.353, 1.409, 0.511> <0.353, 1.422, 0.420> <0.353, 1.432, 0.296> <0.353, 1.430, 0.204> 
		<0.433, 1.387, 0.511> <0.433, 1.398, 0.419> <0.433, 1.411, 0.296> <0.433, 1.409, 0.204> 
		<0.493, 1.387, 0.511> <0.493, 1.398, 0.419> <0.493, 1.411, 0.296> <0.493, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 1.434, 0.204> <0.293, 1.433, 0.145> <0.293, 1.431, 0.081> <0.293, 1.402, 0.010> 
		<0.353, 1.430, 0.204> <0.353, 1.429, 0.145> <0.353, 1.427, 0.081> <0.353, 1.398, 0.010> 
		<0.433, 1.409, 0.204> <0.433, 1.407, 0.145> <0.433, 1.399, 0.083> <0.433, 1.376, 0.010> 
		<0.493, 1.409, 0.204> <0.493, 1.407, 0.145> <0.493, 1.399, 0.083> <0.493, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 1.402, 0.010> <0.293, 1.391, -0.017> <0.293, 1.340, -0.050> <0.293, 1.337, -0.030> 
		<0.353, 1.398, 0.010> <0.353, 1.387, -0.017> <0.353, 1.340, -0.050> <0.353, 1.337, -0.030> 
		<0.433, 1.376, 0.010> <0.433, 1.370, -0.011> <0.433, 1.338, -0.045> <0.433, 1.337, -0.030> 
		<0.493, 1.376, 0.010> <0.493, 1.370, -0.011> <0.493, 1.338, -0.045> <0.493, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 1.337, -0.030> <0.293, 1.322, 0.083> <0.293, 1.352, 0.048> <0.293, 1.347, 0.414> 
		<0.353, 1.337, -0.030> <0.353, 1.322, 0.083> <0.353, 1.352, 0.048> <0.353, 1.347, 0.414> 
		<0.433, 1.337, -0.030> <0.433, 1.329, 0.084> <0.433, 1.352, 0.048> <0.433, 1.347, 0.414> 
		<0.493, 1.337, -0.030> <0.493, 1.329, 0.084> <0.493, 1.352, 0.048> <0.493, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 1.322, 0.970> <0.553, 1.322, 0.970> <0.633, 1.322, 0.970> <0.693, 1.322, 0.970> 
		<0.493, 1.329, 0.803> <0.553, 1.329, 0.803> <0.633, 1.329, 0.803> <0.693, 1.329, 0.803> 
		<0.493, 1.340, 0.872> <0.553, 1.340, 0.872> <0.633, 1.340, 0.872> <0.693, 1.340, 0.872> 
		<0.493, 1.347, 0.414> <0.553, 1.347, 0.414> <0.633, 1.347, 0.414> <0.693, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 1.322, 0.970> <0.493, 1.342, 0.832> <0.493, 1.372, 0.649> <0.493, 1.387, 0.511> 
		<0.553, 1.322, 0.970> <0.553, 1.342, 0.832> <0.554, 1.372, 0.649> <0.554, 1.387, 0.511> 
		<0.633, 1.322, 0.970> <0.633, 1.349, 0.832> <0.633, 1.392, 0.650> <0.633, 1.413, 0.511> 
		<0.693, 1.322, 0.970> <0.693, 1.349, 0.832> <0.693, 1.392, 0.650> <0.693, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 1.387, 0.511> <0.493, 1.398, 0.419> <0.493, 1.411, 0.296> <0.493, 1.409, 0.204> 
		<0.554, 1.387, 0.511> <0.554, 1.398, 0.419> <0.554, 1.411, 0.296> <0.554, 1.409, 0.204> 
		<0.633, 1.413, 0.511> <0.633, 1.426, 0.420> <0.633, 1.436, 0.296> <0.633, 1.434, 0.204> 
		<0.693, 1.413, 0.511> <0.693, 1.426, 0.420> <0.693, 1.436, 0.296> <0.693, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 1.409, 0.204> <0.493, 1.407, 0.145> <0.493, 1.399, 0.083> <0.493, 1.376, 0.010> 
		<0.554, 1.409, 0.204> <0.554, 1.407, 0.145> <0.554, 1.399, 0.083> <0.554, 1.376, 0.010> 
		<0.633, 1.434, 0.204> <0.633, 1.433, 0.145> <0.633, 1.431, 0.081> <0.633, 1.402, 0.010> 
		<0.693, 1.434, 0.204> <0.693, 1.433, 0.145> <0.693, 1.431, 0.081> <0.693, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 1.376, 0.010> <0.493, 1.370, -0.011> <0.493, 1.338, -0.045> <0.493, 1.337, -0.030> 
		<0.554, 1.376, 0.010> <0.554, 1.370, -0.011> <0.553, 1.338, -0.045> <0.553, 1.337, -0.030> 
		<0.633, 1.402, 0.010> <0.633, 1.391, -0.017> <0.633, 1.340, -0.050> <0.633, 1.337, -0.030> 
		<0.693, 1.402, 0.010> <0.693, 1.391, -0.017> <0.693, 1.340, -0.050> <0.693, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 1.337, -0.030> <0.493, 1.329, 0.084> <0.493, 1.352, 0.048> <0.493, 1.347, 0.414> 
		<0.553, 1.337, -0.030> <0.553, 1.329, 0.084> <0.553, 1.352, 0.048> <0.553, 1.347, 0.414> 
		<0.633, 1.337, -0.030> <0.633, 1.322, 0.083> <0.633, 1.352, 0.048> <0.633, 1.347, 0.414> 
		<0.693, 1.337, -0.030> <0.693, 1.322, 0.083> <0.693, 1.352, 0.048> <0.693, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.693, 1.322, 0.970> <0.753, 1.322, 0.970> <0.833, 1.322, 0.970> <0.893, 1.322, 0.970> 
		<0.693, 1.329, 0.803> <0.753, 1.329, 0.803> <0.833, 1.329, 0.803> <0.893, 1.329, 0.803> 
		<0.693, 1.340, 0.872> <0.753, 1.340, 0.872> <0.833, 1.340, 0.872> <0.893, 1.340, 0.872> 
		<0.693, 1.347, 0.414> <0.753, 1.347, 0.414> <0.833, 1.347, 0.414> <0.893, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.693, 1.322, 0.970> <0.693, 1.349, 0.832> <0.693, 1.392, 0.650> <0.693, 1.413, 0.511> 
		<0.753, 1.322, 0.970> <0.753, 1.349, 0.832> <0.754, 1.392, 0.650> <0.754, 1.413, 0.511> 
		<0.833, 1.322, 0.970> <0.833, 1.342, 0.832> <0.833, 1.372, 0.649> <0.833, 1.387, 0.511> 
		<0.893, 1.322, 0.970> <0.893, 1.342, 0.832> <0.893, 1.372, 0.649> <0.893, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.693, 1.413, 0.511> <0.693, 1.426, 0.420> <0.693, 1.436, 0.296> <0.693, 1.434, 0.204> 
		<0.754, 1.413, 0.511> <0.754, 1.426, 0.420> <0.754, 1.436, 0.296> <0.754, 1.434, 0.204> 
		<0.833, 1.387, 0.511> <0.833, 1.398, 0.419> <0.833, 1.411, 0.296> <0.833, 1.409, 0.204> 
		<0.893, 1.387, 0.511> <0.893, 1.398, 0.419> <0.893, 1.411, 0.296> <0.893, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.693, 1.434, 0.204> <0.693, 1.433, 0.145> <0.693, 1.431, 0.081> <0.693, 1.402, 0.010> 
		<0.754, 1.434, 0.204> <0.754, 1.433, 0.145> <0.754, 1.431, 0.081> <0.754, 1.402, 0.010> 
		<0.833, 1.409, 0.204> <0.833, 1.407, 0.145> <0.833, 1.399, 0.083> <0.833, 1.376, 0.010> 
		<0.893, 1.409, 0.204> <0.893, 1.407, 0.145> <0.893, 1.399, 0.083> <0.893, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.693, 1.402, 0.010> <0.693, 1.391, -0.017> <0.693, 1.340, -0.050> <0.693, 1.337, -0.030> 
		<0.754, 1.402, 0.010> <0.754, 1.391, -0.017> <0.753, 1.340, -0.050> <0.753, 1.337, -0.030> 
		<0.833, 1.376, 0.010> <0.833, 1.370, -0.011> <0.833, 1.338, -0.045> <0.833, 1.337, -0.030> 
		<0.893, 1.376, 0.010> <0.893, 1.370, -0.011> <0.893, 1.338, -0.045> <0.893, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.693, 1.337, -0.030> <0.693, 1.322, 0.083> <0.693, 1.352, 0.048> <0.693, 1.347, 0.414> 
		<0.753, 1.337, -0.030> <0.753, 1.322, 0.083> <0.753, 1.352, 0.048> <0.753, 1.347, 0.414> 
		<0.833, 1.337, -0.030> <0.833, 1.329, 0.084> <0.833, 1.352, 0.048> <0.833, 1.347, 0.414> 
		<0.893, 1.337, -0.030> <0.893, 1.329, 0.084> <0.893, 1.352, 0.048> <0.893, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, 1.322, 0.970> <0.953, 1.322, 0.970> <1.034, 1.322, 0.977> <1.093, 1.322, 0.970> 
		<0.893, 1.329, 0.803> <0.953, 1.329, 0.803> <1.034, 1.329, 0.811> <1.093, 1.329, 0.803> 
		<0.893, 1.340, 0.872> <0.953, 1.340, 0.872> <1.033, 1.340, 0.872> <1.093, 1.340, 0.872> 
		<0.893, 1.347, 0.414> <0.953, 1.347, 0.414> <1.033, 1.347, 0.414> <1.093, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, 1.322, 0.970> <0.893, 1.342, 0.832> <0.893, 1.372, 0.649> <0.893, 1.387, 0.511> 
		<0.953, 1.322, 0.970> <0.953, 1.342, 0.832> <0.954, 1.372, 0.649> <0.954, 1.387, 0.511> 
		<1.034, 1.322, 0.977> <1.034, 1.349, 0.840> <1.033, 1.392, 0.650> <1.033, 1.413, 0.511> 
		<1.093, 1.322, 0.970> <1.093, 1.349, 0.832> <1.093, 1.392, 0.650> <1.093, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, 1.387, 0.511> <0.893, 1.398, 0.419> <0.893, 1.411, 0.296> <0.893, 1.409, 0.204> 
		<0.954, 1.387, 0.511> <0.954, 1.398, 0.419> <0.954, 1.411, 0.296> <0.954, 1.409, 0.204> 
		<1.033, 1.413, 0.511> <1.033, 1.426, 0.420> <1.033, 1.436, 0.296> <1.033, 1.434, 0.204> 
		<1.093, 1.413, 0.511> <1.093, 1.426, 0.420> <1.093, 1.436, 0.296> <1.093, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, 1.409, 0.204> <0.893, 1.407, 0.145> <0.893, 1.399, 0.083> <0.893, 1.376, 0.010> 
		<0.954, 1.409, 0.204> <0.954, 1.407, 0.145> <0.954, 1.399, 0.083> <0.954, 1.376, 0.010> 
		<1.033, 1.434, 0.204> <1.033, 1.433, 0.145> <1.033, 1.431, 0.081> <1.033, 1.402, 0.010> 
		<1.093, 1.434, 0.204> <1.093, 1.433, 0.145> <1.093, 1.431, 0.081> <1.093, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, 1.376, 0.010> <0.893, 1.370, -0.011> <0.893, 1.338, -0.045> <0.893, 1.337, -0.030> 
		<0.954, 1.376, 0.010> <0.954, 1.370, -0.011> <0.953, 1.338, -0.045> <0.953, 1.337, -0.030> 
		<1.033, 1.402, 0.010> <1.033, 1.391, -0.017> <1.033, 1.340, -0.050> <1.033, 1.337, -0.030> 
		<1.093, 1.402, 0.010> <1.093, 1.391, -0.017> <1.093, 1.340, -0.050> <1.093, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, 1.337, -0.030> <0.893, 1.329, 0.084> <0.893, 1.352, 0.048> <0.893, 1.347, 0.414> 
		<0.953, 1.337, -0.030> <0.953, 1.329, 0.084> <0.953, 1.352, 0.048> <0.953, 1.347, 0.414> 
		<1.033, 1.337, -0.030> <1.033, 1.322, 0.083> <1.033, 1.352, 0.048> <1.033, 1.347, 0.414> 
		<1.093, 1.337, -0.030> <1.093, 1.322, 0.083> <1.093, 1.352, 0.048> <1.093, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.322, 0.970> <1.154, 1.322, 0.962> <1.232, 1.322, 0.928> <1.293, 1.322, 0.920> 
		<1.093, 1.329, 0.803> <1.154, 1.329, 0.796> <1.232, 1.329, 0.777> <1.293, 1.329, 0.768> 
		<1.093, 1.340, 0.872> <1.153, 1.340, 0.872> <1.233, 1.340, 0.831> <1.293, 1.340, 0.831> 
		<1.093, 1.347, 0.414> <1.153, 1.347, 0.414> <1.233, 1.347, 0.414> <1.293, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.322, 0.970> <1.093, 1.349, 0.832> <1.093, 1.392, 0.650> <1.093, 1.413, 0.511> 
		<1.154, 1.322, 0.962> <1.154, 1.349, 0.825> <1.154, 1.392, 0.650> <1.154, 1.413, 0.511> 
		<1.232, 1.322, 0.928> <1.232, 1.342, 0.806> <1.233, 1.372, 0.635> <1.233, 1.387, 0.511> 
		<1.293, 1.322, 0.920> <1.293, 1.342, 0.797> <1.293, 1.372, 0.635> <1.293, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.413, 0.511> <1.093, 1.426, 0.420> <1.093, 1.436, 0.296> <1.093, 1.434, 0.204> 
		<1.154, 1.413, 0.511> <1.154, 1.426, 0.420> <1.154, 1.436, 0.296> <1.154, 1.434, 0.204> 
		<1.233, 1.387, 0.511> <1.233, 1.398, 0.419> <1.233, 1.411, 0.296> <1.233, 1.409, 0.204> 
		<1.293, 1.387, 0.511> <1.293, 1.398, 0.419> <1.293, 1.411, 0.296> <1.293, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.434, 0.204> <1.093, 1.433, 0.145> <1.093, 1.431, 0.081> <1.093, 1.402, 0.010> 
		<1.154, 1.434, 0.204> <1.154, 1.433, 0.145> <1.154, 1.431, 0.081> <1.154, 1.402, 0.010> 
		<1.233, 1.409, 0.204> <1.233, 1.407, 0.145> <1.233, 1.399, 0.083> <1.233, 1.376, 0.010> 
		<1.293, 1.409, 0.204> <1.293, 1.407, 0.145> <1.293, 1.399, 0.083> <1.293, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.402, 0.010> <1.093, 1.391, -0.017> <1.093, 1.340, -0.050> <1.093, 1.337, -0.030> 
		<1.154, 1.402, 0.010> <1.154, 1.391, -0.017> <1.153, 1.340, -0.050> <1.153, 1.337, -0.030> 
		<1.233, 1.376, 0.010> <1.233, 1.370, -0.011> <1.233, 1.338, -0.045> <1.233, 1.337, -0.030> 
		<1.293, 1.376, 0.010> <1.293, 1.370, -0.011> <1.293, 1.338, -0.045> <1.293, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.337, -0.030> <1.093, 1.322, 0.083> <1.093, 1.352, 0.048> <1.093, 1.347, 0.414> 
		<1.153, 1.337, -0.030> <1.153, 1.322, 0.083> <1.153, 1.352, 0.048> <1.153, 1.347, 0.414> 
		<1.233, 1.337, -0.030> <1.233, 1.329, 0.084> <1.233, 1.353, 0.048> <1.233, 1.347, 0.414> 
		<1.293, 1.337, -0.030> <1.293, 1.329, 0.084> <1.293, 1.353, 0.048> <1.293, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.322, 0.920> <1.353, 1.322, 0.912> <1.433, 1.322, 0.917> <1.493, 1.322, 0.916> 
		<1.293, 1.329, 0.768> <1.353, 1.329, 0.760> <1.433, 1.329, 0.766> <1.493, 1.329, 0.765> 
		<1.293, 1.340, 0.831> <1.353, 1.340, 0.831> <1.433, 1.340, 0.828> <1.493, 1.340, 0.828> 
		<1.293, 1.347, 0.414> <1.353, 1.347, 0.414> <1.433, 1.347, 0.414> <1.493, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.322, 0.920> <1.293, 1.342, 0.797> <1.293, 1.372, 0.635> <1.293, 1.387, 0.511> 
		<1.353, 1.322, 0.912> <1.353, 1.342, 0.789> <1.354, 1.372, 0.635> <1.354, 1.387, 0.511> 
		<1.433, 1.322, 0.917> <1.433, 1.349, 0.795> <1.433, 1.393, 0.634> <1.433, 1.413, 0.511> 
		<1.493, 1.322, 0.916> <1.493, 1.349, 0.795> <1.493, 1.393, 0.634> <1.493, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.387, 0.511> <1.293, 1.398, 0.419> <1.293, 1.411, 0.296> <1.293, 1.409, 0.204> 
		<1.354, 1.387, 0.511> <1.354, 1.398, 0.419> <1.354, 1.411, 0.296> <1.354, 1.409, 0.204> 
		<1.433, 1.413, 0.511> <1.433, 1.427, 0.420> <1.433, 1.436, 0.296> <1.433, 1.434, 0.204> 
		<1.493, 1.413, 0.511> <1.493, 1.427, 0.420> <1.493, 1.436, 0.296> <1.493, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.409, 0.204> <1.293, 1.407, 0.145> <1.293, 1.399, 0.083> <1.293, 1.376, 0.010> 
		<1.354, 1.409, 0.204> <1.354, 1.407, 0.145> <1.354, 1.399, 0.083> <1.354, 1.376, 0.010> 
		<1.433, 1.434, 0.204> <1.433, 1.433, 0.145> <1.433, 1.431, 0.081> <1.433, 1.402, 0.010> 
		<1.493, 1.434, 0.204> <1.493, 1.433, 0.145> <1.493, 1.431, 0.081> <1.493, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.376, 0.010> <1.293, 1.370, -0.011> <1.293, 1.338, -0.045> <1.293, 1.337, -0.030> 
		<1.354, 1.376, 0.010> <1.354, 1.370, -0.011> <1.353, 1.338, -0.045> <1.353, 1.337, -0.030> 
		<1.433, 1.402, 0.010> <1.433, 1.391, -0.017> <1.433, 1.340, -0.050> <1.433, 1.337, -0.030> 
		<1.493, 1.402, 0.010> <1.493, 1.391, -0.017> <1.493, 1.340, -0.050> <1.493, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.337, -0.030> <1.293, 1.329, 0.084> <1.293, 1.353, 0.048> <1.293, 1.347, 0.414> 
		<1.353, 1.337, -0.030> <1.353, 1.329, 0.084> <1.353, 1.353, 0.048> <1.353, 1.347, 0.414> 
		<1.433, 1.337, -0.030> <1.433, 1.322, 0.083> <1.433, 1.353, 0.048> <1.433, 1.347, 0.414> 
		<1.493, 1.337, -0.030> <1.493, 1.322, 0.083> <1.493, 1.353, 0.048> <1.493, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.322, 0.916> <1.553, 1.322, 0.915> <1.633, 1.322, 0.916> <1.693, 1.322, 0.916> 
		<1.493, 1.329, 0.765> <1.553, 1.329, 0.765> <1.633, 1.329, 0.765> <1.693, 1.329, 0.765> 
		<1.493, 1.340, 0.828> <1.553, 1.340, 0.828> <1.633, 1.340, 0.828> <1.693, 1.340, 0.828> 
		<1.493, 1.347, 0.414> <1.553, 1.347, 0.414> <1.633, 1.347, 0.414> <1.693, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.322, 0.916> <1.493, 1.349, 0.795> <1.493, 1.393, 0.634> <1.493, 1.413, 0.511> 
		<1.553, 1.322, 0.915> <1.553, 1.349, 0.794> <1.554, 1.393, 0.634> <1.554, 1.413, 0.511> 
		<1.633, 1.322, 0.916> <1.633, 1.342, 0.795> <1.633, 1.372, 0.633> <1.633, 1.387, 0.511> 
		<1.693, 1.322, 0.916> <1.693, 1.342, 0.795> <1.693, 1.372, 0.633> <1.693, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.413, 0.511> <1.493, 1.427, 0.420> <1.493, 1.436, 0.296> <1.493, 1.434, 0.204> 
		<1.554, 1.413, 0.511> <1.554, 1.427, 0.420> <1.554, 1.436, 0.296> <1.554, 1.434, 0.204> 
		<1.633, 1.387, 0.511> <1.633, 1.398, 0.419> <1.633, 1.411, 0.296> <1.633, 1.409, 0.204> 
		<1.693, 1.387, 0.511> <1.693, 1.398, 0.419> <1.693, 1.411, 0.296> <1.693, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.434, 0.204> <1.493, 1.433, 0.145> <1.493, 1.431, 0.081> <1.493, 1.402, 0.010> 
		<1.554, 1.434, 0.204> <1.554, 1.433, 0.145> <1.554, 1.431, 0.081> <1.554, 1.402, 0.010> 
		<1.633, 1.409, 0.204> <1.633, 1.407, 0.145> <1.633, 1.399, 0.083> <1.633, 1.376, 0.010> 
		<1.693, 1.409, 0.204> <1.693, 1.407, 0.145> <1.693, 1.399, 0.083> <1.693, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.402, 0.010> <1.493, 1.391, -0.017> <1.493, 1.340, -0.050> <1.493, 1.337, -0.030> 
		<1.554, 1.402, 0.010> <1.554, 1.391, -0.017> <1.553, 1.340, -0.050> <1.553, 1.337, -0.030> 
		<1.633, 1.376, 0.010> <1.633, 1.370, -0.011> <1.633, 1.338, -0.045> <1.633, 1.337, -0.030> 
		<1.693, 1.376, 0.010> <1.693, 1.370, -0.011> <1.693, 1.338, -0.045> <1.693, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.337, -0.030> <1.493, 1.322, 0.083> <1.493, 1.353, 0.048> <1.493, 1.347, 0.414> 
		<1.553, 1.337, -0.030> <1.553, 1.322, 0.083> <1.553, 1.353, 0.048> <1.553, 1.347, 0.414> 
		<1.633, 1.337, -0.030> <1.633, 1.329, 0.084> <1.633, 1.353, 0.048> <1.633, 1.347, 0.414> 
		<1.693, 1.337, -0.030> <1.693, 1.329, 0.084> <1.693, 1.353, 0.048> <1.693, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.322, 0.916> <1.753, 1.322, 0.916> <1.833, 1.322, 0.916> <1.893, 1.322, 0.916> 
		<1.693, 1.329, 0.765> <1.753, 1.329, 0.765> <1.833, 1.329, 0.765> <1.893, 1.329, 0.765> 
		<1.693, 1.340, 0.828> <1.753, 1.340, 0.828> <1.833, 1.340, 0.828> <1.893, 1.340, 0.828> 
		<1.693, 1.347, 0.414> <1.753, 1.347, 0.414> <1.833, 1.347, 0.414> <1.893, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.322, 0.916> <1.693, 1.342, 0.795> <1.693, 1.372, 0.633> <1.693, 1.387, 0.511> 
		<1.753, 1.322, 0.916> <1.753, 1.342, 0.795> <1.754, 1.372, 0.633> <1.754, 1.387, 0.511> 
		<1.833, 1.322, 0.916> <1.833, 1.349, 0.795> <1.833, 1.393, 0.634> <1.833, 1.413, 0.511> 
		<1.893, 1.322, 0.916> <1.893, 1.349, 0.795> <1.893, 1.393, 0.634> <1.893, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.387, 0.511> <1.693, 1.398, 0.419> <1.693, 1.411, 0.296> <1.693, 1.409, 0.204> 
		<1.754, 1.387, 0.511> <1.754, 1.398, 0.419> <1.754, 1.411, 0.296> <1.754, 1.409, 0.204> 
		<1.833, 1.413, 0.511> <1.833, 1.427, 0.420> <1.833, 1.436, 0.296> <1.833, 1.434, 0.204> 
		<1.893, 1.413, 0.511> <1.893, 1.427, 0.420> <1.893, 1.436, 0.296> <1.893, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.409, 0.204> <1.693, 1.407, 0.145> <1.693, 1.399, 0.083> <1.693, 1.376, 0.010> 
		<1.754, 1.409, 0.204> <1.754, 1.407, 0.145> <1.754, 1.399, 0.083> <1.754, 1.376, 0.010> 
		<1.833, 1.434, 0.204> <1.833, 1.433, 0.145> <1.833, 1.431, 0.081> <1.833, 1.402, 0.010> 
		<1.893, 1.434, 0.204> <1.893, 1.433, 0.145> <1.893, 1.431, 0.081> <1.893, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.376, 0.010> <1.693, 1.370, -0.011> <1.693, 1.338, -0.045> <1.693, 1.337, -0.030> 
		<1.754, 1.376, 0.010> <1.754, 1.370, -0.011> <1.753, 1.338, -0.045> <1.753, 1.337, -0.030> 
		<1.833, 1.402, 0.010> <1.833, 1.391, -0.017> <1.833, 1.340, -0.050> <1.833, 1.337, -0.030> 
		<1.893, 1.402, 0.010> <1.893, 1.391, -0.017> <1.893, 1.340, -0.050> <1.893, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.337, -0.030> <1.693, 1.329, 0.084> <1.693, 1.353, 0.048> <1.693, 1.347, 0.414> 
		<1.753, 1.337, -0.030> <1.753, 1.329, 0.084> <1.753, 1.353, 0.048> <1.753, 1.347, 0.414> 
		<1.833, 1.337, -0.030> <1.833, 1.322, 0.083> <1.833, 1.353, 0.048> <1.833, 1.347, 0.414> 
		<1.893, 1.337, -0.030> <1.893, 1.322, 0.083> <1.893, 1.353, 0.048> <1.893, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.893, 1.322, 0.916> <1.953, 1.322, 0.916> <2.033, 1.322, 0.916> <2.093, 1.322, 0.916> 
		<1.893, 1.329, 0.765> <1.953, 1.329, 0.765> <2.033, 1.329, 0.765> <2.093, 1.329, 0.765> 
		<1.893, 1.340, 0.828> <1.953, 1.340, 0.828> <2.033, 1.340, 0.828> <2.093, 1.340, 0.828> 
		<1.893, 1.347, 0.414> <1.953, 1.347, 0.414> <2.033, 1.347, 0.414> <2.093, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.893, 1.322, 0.916> <1.893, 1.349, 0.795> <1.893, 1.393, 0.634> <1.893, 1.413, 0.511> 
		<1.953, 1.322, 0.916> <1.953, 1.349, 0.795> <1.954, 1.393, 0.634> <1.954, 1.413, 0.511> 
		<2.033, 1.322, 0.916> <2.033, 1.342, 0.795> <2.033, 1.372, 0.633> <2.033, 1.387, 0.511> 
		<2.093, 1.322, 0.916> <2.093, 1.342, 0.795> <2.093, 1.372, 0.633> <2.093, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.893, 1.413, 0.511> <1.893, 1.427, 0.420> <1.893, 1.436, 0.296> <1.893, 1.434, 0.204> 
		<1.954, 1.413, 0.511> <1.954, 1.427, 0.420> <1.954, 1.436, 0.296> <1.954, 1.434, 0.204> 
		<2.033, 1.387, 0.511> <2.033, 1.398, 0.419> <2.033, 1.411, 0.296> <2.033, 1.409, 0.204> 
		<2.093, 1.387, 0.511> <2.093, 1.398, 0.419> <2.093, 1.411, 0.296> <2.093, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.893, 1.434, 0.204> <1.893, 1.433, 0.145> <1.893, 1.431, 0.081> <1.893, 1.402, 0.010> 
		<1.954, 1.434, 0.204> <1.954, 1.433, 0.145> <1.954, 1.431, 0.081> <1.954, 1.402, 0.010> 
		<2.033, 1.409, 0.204> <2.033, 1.407, 0.145> <2.033, 1.399, 0.083> <2.033, 1.376, 0.010> 
		<2.093, 1.409, 0.204> <2.093, 1.407, 0.145> <2.093, 1.399, 0.083> <2.093, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.893, 1.402, 0.010> <1.893, 1.391, -0.017> <1.893, 1.340, -0.050> <1.893, 1.337, -0.030> 
		<1.954, 1.402, 0.010> <1.954, 1.391, -0.017> <1.953, 1.340, -0.050> <1.953, 1.337, -0.030> 
		<2.033, 1.376, 0.010> <2.033, 1.370, -0.011> <2.033, 1.338, -0.045> <2.033, 1.337, -0.030> 
		<2.093, 1.376, 0.010> <2.093, 1.370, -0.011> <2.093, 1.338, -0.045> <2.093, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.893, 1.337, -0.030> <1.893, 1.322, 0.083> <1.893, 1.353, 0.048> <1.893, 1.347, 0.414> 
		<1.953, 1.337, -0.030> <1.953, 1.322, 0.083> <1.953, 1.353, 0.048> <1.953, 1.347, 0.414> 
		<2.033, 1.337, -0.030> <2.033, 1.329, 0.084> <2.033, 1.353, 0.048> <2.033, 1.347, 0.414> 
		<2.093, 1.337, -0.030> <2.093, 1.329, 0.084> <2.093, 1.353, 0.048> <2.093, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.093, 1.322, 0.916> <2.153, 1.322, 0.916> <2.233, 1.322, 0.916> <2.293, 1.322, 0.916> 
		<2.093, 1.329, 0.765> <2.153, 1.329, 0.765> <2.233, 1.329, 0.765> <2.293, 1.329, 0.765> 
		<2.093, 1.340, 0.828> <2.153, 1.340, 0.828> <2.233, 1.340, 0.828> <2.293, 1.340, 0.828> 
		<2.093, 1.347, 0.414> <2.153, 1.347, 0.414> <2.233, 1.347, 0.414> <2.293, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.093, 1.322, 0.916> <2.093, 1.342, 0.795> <2.093, 1.372, 0.633> <2.093, 1.387, 0.511> 
		<2.153, 1.322, 0.916> <2.153, 1.342, 0.795> <2.154, 1.372, 0.633> <2.154, 1.387, 0.511> 
		<2.233, 1.322, 0.916> <2.233, 1.349, 0.795> <2.233, 1.393, 0.634> <2.233, 1.413, 0.511> 
		<2.293, 1.322, 0.916> <2.293, 1.349, 0.795> <2.293, 1.393, 0.634> <2.293, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.093, 1.387, 0.511> <2.093, 1.398, 0.419> <2.093, 1.411, 0.296> <2.093, 1.409, 0.204> 
		<2.154, 1.387, 0.511> <2.154, 1.398, 0.419> <2.154, 1.411, 0.296> <2.154, 1.409, 0.204> 
		<2.233, 1.413, 0.511> <2.233, 1.427, 0.420> <2.233, 1.436, 0.296> <2.233, 1.434, 0.204> 
		<2.293, 1.413, 0.511> <2.293, 1.427, 0.420> <2.293, 1.436, 0.296> <2.293, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.093, 1.409, 0.204> <2.093, 1.407, 0.145> <2.093, 1.399, 0.083> <2.093, 1.376, 0.010> 
		<2.154, 1.409, 0.204> <2.154, 1.407, 0.145> <2.154, 1.399, 0.083> <2.154, 1.376, 0.010> 
		<2.233, 1.434, 0.204> <2.233, 1.433, 0.145> <2.233, 1.431, 0.081> <2.233, 1.402, 0.010> 
		<2.293, 1.434, 0.204> <2.293, 1.433, 0.145> <2.293, 1.431, 0.081> <2.293, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.093, 1.376, 0.010> <2.093, 1.370, -0.011> <2.093, 1.338, -0.045> <2.093, 1.337, -0.030> 
		<2.154, 1.376, 0.010> <2.154, 1.370, -0.011> <2.153, 1.338, -0.045> <2.153, 1.337, -0.030> 
		<2.233, 1.402, 0.010> <2.233, 1.391, -0.017> <2.233, 1.340, -0.050> <2.233, 1.337, -0.030> 
		<2.293, 1.402, 0.010> <2.293, 1.391, -0.017> <2.293, 1.340, -0.050> <2.293, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.093, 1.337, -0.030> <2.093, 1.329, 0.084> <2.093, 1.353, 0.048> <2.093, 1.347, 0.414> 
		<2.153, 1.337, -0.030> <2.153, 1.329, 0.084> <2.153, 1.353, 0.048> <2.153, 1.347, 0.414> 
		<2.233, 1.337, -0.030> <2.233, 1.322, 0.083> <2.233, 1.353, 0.048> <2.233, 1.347, 0.414> 
		<2.293, 1.337, -0.030> <2.293, 1.322, 0.083> <2.293, 1.353, 0.048> <2.293, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.293, 1.322, 0.916> <2.353, 1.322, 0.916> <2.433, 1.322, 0.916> <2.493, 1.322, 0.916> 
		<2.293, 1.329, 0.765> <2.353, 1.329, 0.765> <2.433, 1.329, 0.765> <2.493, 1.329, 0.765> 
		<2.293, 1.340, 0.828> <2.353, 1.340, 0.828> <2.433, 1.340, 0.828> <2.493, 1.340, 0.828> 
		<2.293, 1.347, 0.414> <2.353, 1.347, 0.414> <2.433, 1.347, 0.414> <2.493, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.293, 1.322, 0.916> <2.293, 1.349, 0.795> <2.293, 1.393, 0.634> <2.293, 1.413, 0.511> 
		<2.353, 1.322, 0.916> <2.353, 1.349, 0.795> <2.354, 1.393, 0.634> <2.354, 1.413, 0.511> 
		<2.433, 1.322, 0.916> <2.433, 1.342, 0.795> <2.433, 1.372, 0.633> <2.433, 1.387, 0.511> 
		<2.493, 1.322, 0.916> <2.493, 1.342, 0.795> <2.493, 1.372, 0.633> <2.493, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.293, 1.413, 0.511> <2.293, 1.427, 0.420> <2.293, 1.436, 0.296> <2.293, 1.434, 0.204> 
		<2.354, 1.413, 0.511> <2.354, 1.427, 0.420> <2.354, 1.436, 0.296> <2.354, 1.434, 0.204> 
		<2.433, 1.387, 0.511> <2.433, 1.398, 0.419> <2.433, 1.411, 0.296> <2.433, 1.409, 0.204> 
		<2.493, 1.387, 0.511> <2.493, 1.398, 0.419> <2.493, 1.411, 0.296> <2.493, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.293, 1.434, 0.204> <2.293, 1.433, 0.145> <2.293, 1.431, 0.081> <2.293, 1.402, 0.010> 
		<2.354, 1.434, 0.204> <2.354, 1.433, 0.145> <2.354, 1.431, 0.081> <2.354, 1.402, 0.010> 
		<2.433, 1.409, 0.204> <2.433, 1.407, 0.145> <2.433, 1.399, 0.083> <2.433, 1.376, 0.010> 
		<2.493, 1.409, 0.204> <2.493, 1.407, 0.145> <2.493, 1.399, 0.083> <2.493, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.293, 1.402, 0.010> <2.293, 1.391, -0.017> <2.293, 1.340, -0.050> <2.293, 1.337, -0.030> 
		<2.354, 1.402, 0.010> <2.354, 1.391, -0.017> <2.353, 1.340, -0.050> <2.353, 1.337, -0.030> 
		<2.433, 1.376, 0.010> <2.433, 1.370, -0.011> <2.433, 1.338, -0.045> <2.433, 1.337, -0.030> 
		<2.493, 1.376, 0.010> <2.493, 1.370, -0.011> <2.493, 1.338, -0.045> <2.493, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.293, 1.337, -0.030> <2.293, 1.322, 0.083> <2.293, 1.353, 0.048> <2.293, 1.347, 0.414> 
		<2.353, 1.337, -0.030> <2.353, 1.322, 0.083> <2.353, 1.353, 0.048> <2.353, 1.347, 0.414> 
		<2.433, 1.337, -0.030> <2.433, 1.329, 0.084> <2.433, 1.353, 0.048> <2.433, 1.347, 0.414> 
		<2.493, 1.337, -0.030> <2.493, 1.329, 0.084> <2.493, 1.353, 0.048> <2.493, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.493, 1.322, 0.916> <2.553, 1.322, 0.916> <2.633, 1.322, 0.916> <2.693, 1.322, 0.916> 
		<2.493, 1.329, 0.765> <2.553, 1.329, 0.765> <2.633, 1.329, 0.765> <2.693, 1.329, 0.765> 
		<2.493, 1.340, 0.828> <2.553, 1.340, 0.828> <2.633, 1.340, 0.828> <2.693, 1.340, 0.828> 
		<2.493, 1.347, 0.414> <2.553, 1.347, 0.414> <2.633, 1.347, 0.414> <2.693, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.493, 1.322, 0.916> <2.493, 1.342, 0.795> <2.493, 1.372, 0.633> <2.493, 1.387, 0.511> 
		<2.553, 1.322, 0.916> <2.553, 1.342, 0.795> <2.554, 1.372, 0.633> <2.554, 1.387, 0.511> 
		<2.633, 1.322, 0.916> <2.633, 1.349, 0.795> <2.633, 1.393, 0.634> <2.633, 1.413, 0.511> 
		<2.693, 1.322, 0.916> <2.693, 1.349, 0.795> <2.693, 1.393, 0.634> <2.693, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.493, 1.387, 0.511> <2.493, 1.398, 0.419> <2.493, 1.411, 0.296> <2.493, 1.409, 0.204> 
		<2.554, 1.387, 0.511> <2.554, 1.398, 0.419> <2.554, 1.411, 0.296> <2.554, 1.409, 0.204> 
		<2.633, 1.413, 0.511> <2.633, 1.427, 0.420> <2.633, 1.436, 0.296> <2.633, 1.434, 0.204> 
		<2.693, 1.413, 0.511> <2.693, 1.427, 0.420> <2.693, 1.436, 0.296> <2.693, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.493, 1.409, 0.204> <2.493, 1.407, 0.145> <2.493, 1.399, 0.083> <2.493, 1.376, 0.010> 
		<2.554, 1.409, 0.204> <2.554, 1.407, 0.145> <2.554, 1.399, 0.083> <2.554, 1.376, 0.010> 
		<2.633, 1.434, 0.204> <2.633, 1.433, 0.145> <2.633, 1.431, 0.081> <2.633, 1.402, 0.010> 
		<2.693, 1.434, 0.204> <2.693, 1.433, 0.145> <2.693, 1.431, 0.081> <2.693, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.493, 1.376, 0.010> <2.493, 1.370, -0.011> <2.493, 1.338, -0.045> <2.493, 1.337, -0.030> 
		<2.554, 1.376, 0.010> <2.554, 1.370, -0.011> <2.553, 1.338, -0.045> <2.553, 1.337, -0.030> 
		<2.633, 1.402, 0.010> <2.633, 1.391, -0.017> <2.633, 1.340, -0.050> <2.633, 1.337, -0.030> 
		<2.693, 1.402, 0.010> <2.693, 1.391, -0.017> <2.693, 1.340, -0.050> <2.693, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.493, 1.337, -0.030> <2.493, 1.329, 0.084> <2.493, 1.353, 0.048> <2.493, 1.347, 0.414> 
		<2.553, 1.337, -0.030> <2.553, 1.329, 0.084> <2.553, 1.353, 0.048> <2.553, 1.347, 0.414> 
		<2.633, 1.337, -0.030> <2.633, 1.322, 0.083> <2.633, 1.353, 0.048> <2.633, 1.347, 0.414> 
		<2.693, 1.337, -0.030> <2.693, 1.322, 0.083> <2.693, 1.353, 0.048> <2.693, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.693, 1.322, 0.916> <2.753, 1.322, 0.916> <2.833, 1.322, 0.916> <2.893, 1.322, 0.916> 
		<2.693, 1.329, 0.765> <2.753, 1.329, 0.765> <2.833, 1.329, 0.765> <2.893, 1.329, 0.765> 
		<2.693, 1.340, 0.828> <2.753, 1.340, 0.828> <2.833, 1.340, 0.823> <2.893, 1.340, 0.828> 
		<2.693, 1.347, 0.414> <2.753, 1.347, 0.414> <2.833, 1.347, 0.409> <2.893, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.693, 1.322, 0.916> <2.693, 1.349, 0.795> <2.693, 1.393, 0.634> <2.693, 1.413, 0.511> 
		<2.753, 1.322, 0.916> <2.753, 1.349, 0.795> <2.754, 1.393, 0.634> <2.754, 1.413, 0.511> 
		<2.833, 1.322, 0.916> <2.833, 1.342, 0.795> <2.833, 1.372, 0.633> <2.833, 1.387, 0.511> 
		<2.893, 1.322, 0.916> <2.893, 1.342, 0.795> <2.893, 1.372, 0.633> <2.893, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.693, 1.413, 0.511> <2.693, 1.427, 0.420> <2.693, 1.436, 0.296> <2.693, 1.434, 0.204> 
		<2.754, 1.413, 0.511> <2.754, 1.427, 0.420> <2.754, 1.436, 0.296> <2.754, 1.434, 0.204> 
		<2.833, 1.387, 0.511> <2.833, 1.398, 0.419> <2.833, 1.411, 0.292> <2.833, 1.409, 0.200> 
		<2.893, 1.387, 0.511> <2.893, 1.398, 0.419> <2.893, 1.411, 0.296> <2.893, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.693, 1.434, 0.204> <2.693, 1.433, 0.145> <2.693, 1.431, 0.081> <2.693, 1.402, 0.010> 
		<2.754, 1.434, 0.204> <2.754, 1.433, 0.145> <2.754, 1.431, 0.081> <2.754, 1.402, 0.010> 
		<2.833, 1.409, 0.200> <2.833, 1.407, 0.141> <2.833, 1.399, 0.078> <2.833, 1.376, 0.004> 
		<2.893, 1.409, 0.204> <2.893, 1.407, 0.145> <2.893, 1.399, 0.083> <2.893, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.693, 1.402, 0.010> <2.693, 1.391, -0.017> <2.693, 1.340, -0.050> <2.693, 1.337, -0.030> 
		<2.754, 1.402, 0.010> <2.754, 1.391, -0.017> <2.753, 1.340, -0.050> <2.753, 1.337, -0.030> 
		<2.833, 1.376, 0.004> <2.833, 1.370, -0.017> <2.833, 1.338, -0.050> <2.833, 1.337, -0.036> 
		<2.893, 1.376, 0.010> <2.893, 1.370, -0.011> <2.893, 1.338, -0.045> <2.893, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.693, 1.337, -0.030> <2.693, 1.322, 0.083> <2.693, 1.353, 0.048> <2.693, 1.347, 0.414> 
		<2.753, 1.337, -0.030> <2.753, 1.322, 0.083> <2.753, 1.353, 0.048> <2.753, 1.347, 0.414> 
		<2.833, 1.337, -0.036> <2.833, 1.329, 0.078> <2.833, 1.353, 0.043> <2.833, 1.347, 0.409> 
		<2.893, 1.337, -0.030> <2.893, 1.329, 0.084> <2.893, 1.353, 0.048> <2.893, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.893, 1.322, 0.916> <2.953, 1.322, 0.916> <3.033, 1.322, 0.916> <3.093, 1.322, 0.916> 
		<2.893, 1.329, 0.765> <2.953, 1.329, 0.765> <3.033, 1.329, 0.776> <3.093, 1.329, 0.776> 
		<2.893, 1.340, 0.828> <2.954, 1.340, 0.834> <3.042, 1.340, 0.801> <3.093, 1.340, 0.834> 
		<2.893, 1.347, 0.414> <2.954, 1.347, 0.420> <3.042, 1.347, 0.418> <3.093, 1.347, 0.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.893, 1.322, 0.916> <2.893, 1.342, 0.795> <2.893, 1.372, 0.633> <2.893, 1.387, 0.511> 
		<2.953, 1.322, 0.916> <2.953, 1.342, 0.795> <2.954, 1.372, 0.633> <2.954, 1.387, 0.511> 
		<3.033, 1.322, 0.916> <3.033, 1.349, 0.795> <3.033, 1.395, 0.634> <3.033, 1.416, 0.511> 
		<3.093, 1.322, 0.916> <3.093, 1.349, 0.795> <3.093, 1.393, 0.634> <3.093, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.893, 1.387, 0.511> <2.893, 1.398, 0.419> <2.893, 1.411, 0.296> <2.893, 1.409, 0.204> 
		<2.954, 1.387, 0.511> <2.954, 1.398, 0.419> <2.954, 1.411, 0.300> <2.954, 1.409, 0.208> 
		<3.033, 1.416, 0.511> <3.033, 1.429, 0.428> <3.042, 1.441, 0.282> <3.042, 1.439, 0.198> 
		<3.093, 1.413, 0.511> <3.093, 1.426, 0.428> <3.093, 1.436, 0.315> <3.093, 1.434, 0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.893, 1.409, 0.204> <2.893, 1.407, 0.145> <2.893, 1.399, 0.083> <2.893, 1.376, 0.010> 
		<2.954, 1.409, 0.208> <2.954, 1.407, 0.149> <2.954, 1.399, 0.089> <2.954, 1.376, 0.016> 
		<3.042, 1.439, 0.198> <3.042, 1.438, 0.142> <3.041, 1.431, 0.082> <3.041, 1.402, 0.015> 
		<3.093, 1.434, 0.231> <3.093, 1.433, 0.175> <3.093, 1.431, 0.115> <3.093, 1.402, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.893, 1.376, 0.010> <2.893, 1.370, -0.011> <2.893, 1.338, -0.045> <2.893, 1.337, -0.030> 
		<2.954, 1.376, 0.016> <2.954, 1.370, -0.005> <2.954, 1.338, -0.039> <2.954, 1.337, -0.024> 
		<3.041, 1.402, 0.015> <3.041, 1.390, -0.012> <3.042, 1.336, -0.044> <3.042, 1.333, -0.025> 
		<3.093, 1.402, 0.048> <3.093, 1.390, 0.021> <3.093, 1.340, -0.011> <3.093, 1.337, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.893, 1.337, -0.030> <2.893, 1.329, 0.084> <2.893, 1.353, 0.048> <2.893, 1.347, 0.414> 
		<2.954, 1.337, -0.024> <2.954, 1.329, 0.090> <2.954, 1.353, 0.054> <2.954, 1.347, 0.420> 
		<3.042, 1.333, -0.025> <3.042, 1.318, 0.088> <3.042, 1.353, 0.053> <3.042, 1.347, 0.418> 
		<3.093, 1.337, 0.008> <3.093, 1.322, 0.121> <3.093, 1.353, 0.086> <3.093, 1.347, 0.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.322, 0.916> <3.153, 1.322, 0.916> <3.233, 1.322, 0.916> <3.293, 1.322, 0.916> 
		<3.093, 1.329, 0.776> <3.153, 1.329, 0.776> <3.233, 1.329, 0.843> <3.293, 1.329, 0.843> 
		<3.093, 1.340, 0.834> <3.168, 1.340, 0.883> <3.233, 1.332, 0.807> <3.293, 1.332, 0.873> 
		<3.093, 1.347, 0.451> <3.168, 1.347, 0.499> <3.233, 1.347, 0.606> <3.293, 1.347, 0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.322, 0.916> <3.093, 1.349, 0.795> <3.093, 1.393, 0.634> <3.093, 1.413, 0.511> 
		<3.153, 1.322, 0.916> <3.153, 1.349, 0.795> <3.155, 1.390, 0.634> <3.155, 1.410, 0.511> 
		<3.233, 1.322, 0.916> <3.233, 1.336, 0.795> <3.233, 1.369, 0.633> <3.233, 1.382, 0.511> 
		<3.293, 1.322, 0.916> <3.293, 1.336, 0.795> <3.293, 1.356, 0.633> <3.293, 1.368, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.413, 0.511> <3.093, 1.426, 0.428> <3.093, 1.436, 0.315> <3.093, 1.434, 0.231> 
		<3.155, 1.410, 0.511> <3.155, 1.423, 0.428> <3.172, 1.428, 0.366> <3.172, 1.426, 0.282> 
		<3.233, 1.382, 0.511> <3.233, 1.383, 0.496> <3.233, 1.388, 0.407> <3.233, 1.388, 0.392> 
		<3.293, 1.368, 0.511> <3.293, 1.370, 0.496> <3.293, 1.368, 0.476> <3.293, 1.368, 0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.434, 0.231> <3.093, 1.433, 0.175> <3.093, 1.431, 0.115> <3.093, 1.402, 0.048> 
		<3.172, 1.426, 0.282> <3.172, 1.425, 0.226> <3.168, 1.431, 0.163> <3.168, 1.402, 0.097> 
		<3.233, 1.388, 0.392> <3.233, 1.390, 0.334> <3.233, 1.382, 0.278> <3.233, 1.383, 0.202> 
		<3.293, 1.368, 0.461> <3.293, 1.370, 0.403> <3.293, 1.374, 0.344> <3.293, 1.375, 0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.402, 0.048> <3.093, 1.390, 0.021> <3.093, 1.340, -0.011> <3.093, 1.337, 0.008> 
		<3.168, 1.402, 0.097> <3.168, 1.390, 0.070> <3.168, 1.346, 0.037> <3.168, 1.344, 0.057> 
		<3.233, 1.383, 0.202> <3.233, 1.383, 0.186> <3.233, 1.361, 0.151> <3.233, 1.361, 0.162> 
		<3.293, 1.375, 0.268> <3.293, 1.375, 0.252> <3.293, 1.371, 0.217> <3.293, 1.371, 0.228> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.337, 0.008> <3.093, 1.322, 0.121> <3.093, 1.353, 0.086> <3.093, 1.347, 0.451> 
		<3.168, 1.344, 0.057> <3.168, 1.328, 0.169> <3.168, 1.353, 0.135> <3.168, 1.347, 0.499> 
		<3.233, 1.361, 0.162> <3.233, 1.353, 0.276> <3.233, 1.373, 0.240> <3.233, 1.347, 0.606> 
		<3.293, 1.371, 0.228> <3.293, 1.363, 0.342> <3.293, 1.373, 0.306> <3.293, 1.347, 0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.293, 1.322, 0.916> <3.293, 1.336, 0.795> <3.293, 1.356, 0.633> <3.293, 1.368, 0.511> 
		<3.293, 1.329, 0.843> <3.293, 1.343, 0.721> <3.293, 1.358, 0.618> <3.293, 1.370, 0.496> 
		<3.293, 1.332, 0.873> <3.293, 1.339, 0.810> <3.293, 1.361, 0.540> <3.293, 1.368, 0.476> 
		<3.293, 1.347, 0.672> <3.293, 1.353, 0.609> <3.293, 1.362, 0.525> <3.293, 1.368, 0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.293, 1.375, 0.268> <3.293, 1.375, 0.252> <3.293, 1.371, 0.217> <3.293, 1.371, 0.228> 
		<3.293, 1.374, 0.344> <3.293, 1.374, 0.328> <3.293, 1.363, 0.331> <3.293, 1.363, 0.342> 
		<3.293, 1.370, 0.403> <3.293, 1.363, 0.467> <3.293, 1.379, 0.243> <3.293, 1.373, 0.306> 
		<3.293, 1.368, 0.461> <3.293, 1.362, 0.525> <3.293, 1.353, 0.609> <3.293, 1.347, 0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.322, 0.917> <-3.247, 1.322, 0.917> <-3.167, 1.322, 0.917> <-3.107, 1.322, 0.917> 
		<-3.307, 1.329, 0.844> <-3.247, 1.329, 0.844> <-3.167, 1.329, 0.777> <-3.107, 1.329, 0.777> 
		<-3.307, 1.330, 0.875> <-3.247, 1.331, 0.808> <-3.182, 1.340, 0.884> <-3.107, 1.340, 0.836> 
		<-3.307, 1.344, 0.672> <-3.247, 1.345, 0.606> <-3.182, 1.346, 0.499> <-3.107, 1.347, 0.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.322, 0.917> <-3.307, 1.329, 0.844> <-3.307, 1.330, 0.875> <-3.307, 1.344, 0.672> 
		<-3.307, 1.334, 0.796> <-3.307, 1.341, 0.722> <-3.307, 1.336, 0.811> <-3.307, 1.351, 0.609> 
		<-3.307, 1.350, 0.633> <-3.307, 1.351, 0.618> <-3.307, 1.358, 0.540> <-3.307, 1.359, 0.525> 
		<-3.307, 1.361, 0.511> <-3.307, 1.363, 0.496> <-3.307, 1.364, 0.476> <-3.307, 1.365, 0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.322, 0.917> <-3.307, 1.334, 0.796> <-3.307, 1.350, 0.633> <-3.307, 1.361, 0.511> 
		<-3.247, 1.322, 0.917> <-3.247, 1.334, 0.796> <-3.247, 1.365, 0.633> <-3.247, 1.377, 0.511> 
		<-3.167, 1.322, 0.917> <-3.167, 1.349, 0.796> <-3.169, 1.388, 0.634> <-3.169, 1.409, 0.511> 
		<-3.107, 1.322, 0.917> <-3.107, 1.349, 0.796> <-3.107, 1.392, 0.634> <-3.107, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.361, 0.511> <-3.307, 1.363, 0.496> <-3.307, 1.364, 0.476> <-3.307, 1.365, 0.461> 
		<-3.247, 1.377, 0.511> <-3.247, 1.378, 0.496> <-3.247, 1.385, 0.410> <-3.247, 1.386, 0.395> 
		<-3.169, 1.409, 0.511> <-3.169, 1.422, 0.431> <-3.184, 1.428, 0.371> <-3.184, 1.426, 0.290> 
		<-3.107, 1.413, 0.511> <-3.107, 1.426, 0.431> <-3.107, 1.436, 0.322> <-3.107, 1.434, 0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.377, 0.268> <-3.307, 1.376, 0.344> <-3.307, 1.369, 0.403> <-3.307, 1.365, 0.461> 
		<-3.307, 1.378, 0.252> <-3.307, 1.376, 0.328> <-3.307, 1.363, 0.467> <-3.307, 1.359, 0.525> 
		<-3.307, 1.372, 0.217> <-3.307, 1.362, 0.331> <-3.307, 1.376, 0.243> <-3.307, 1.351, 0.609> 
		<-3.307, 1.371, 0.228> <-3.307, 1.361, 0.342> <-3.307, 1.370, 0.306> <-3.307, 1.344, 0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.377, 0.268> <-3.247, 1.385, 0.202> <-3.182, 1.402, 0.097> <-3.107, 1.402, 0.048> 
		<-3.307, 1.376, 0.344> <-3.247, 1.383, 0.278> <-3.182, 1.431, 0.167> <-3.107, 1.431, 0.119> 
		<-3.307, 1.369, 0.403> <-3.247, 1.390, 0.337> <-3.184, 1.425, 0.231> <-3.107, 1.433, 0.182> 
		<-3.307, 1.365, 0.461> <-3.247, 1.386, 0.395> <-3.184, 1.426, 0.290> <-3.107, 1.434, 0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.377, 0.268> <-3.307, 1.378, 0.252> <-3.307, 1.372, 0.217> <-3.307, 1.371, 0.228> 
		<-3.247, 1.385, 0.202> <-3.247, 1.385, 0.186> <-3.247, 1.362, 0.151> <-3.247, 1.361, 0.162> 
		<-3.182, 1.402, 0.097> <-3.182, 1.391, 0.069> <-3.182, 1.346, 0.037> <-3.182, 1.344, 0.057> 
		<-3.107, 1.402, 0.048> <-3.107, 1.390, 0.021> <-3.107, 1.340, -0.011> <-3.107, 1.337, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.307, 1.371, 0.228> <-3.307, 1.361, 0.342> <-3.307, 1.370, 0.306> <-3.307, 1.344, 0.672> 
		<-3.247, 1.361, 0.162> <-3.247, 1.351, 0.276> <-3.247, 1.371, 0.240> <-3.247, 1.345, 0.606> 
		<-3.182, 1.344, 0.057> <-3.182, 1.328, 0.169> <-3.182, 1.352, 0.135> <-3.182, 1.346, 0.499> 
		<-3.107, 1.337, 0.008> <-3.107, 1.322, 0.121> <-3.107, 1.353, 0.086> <-3.107, 1.347, 0.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.107, 1.322, 0.917> <-3.047, 1.322, 0.917> <-2.967, 1.322, 0.917> <-2.907, 1.322, 0.917> 
		<-3.107, 1.329, 0.777> <-3.047, 1.329, 0.777> <-2.967, 1.329, 0.766> <-2.907, 1.329, 0.766> 
		<-3.107, 1.340, 0.836> <-3.056, 1.340, 0.803> <-2.968, 1.340, 0.835> <-2.907, 1.340, 0.829> 
		<-3.107, 1.347, 0.451> <-3.056, 1.347, 0.418> <-2.968, 1.347, 0.420> <-2.907, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.107, 1.322, 0.917> <-3.107, 1.349, 0.796> <-3.107, 1.392, 0.634> <-3.107, 1.413, 0.511> 
		<-3.047, 1.322, 0.917> <-3.047, 1.349, 0.796> <-3.047, 1.396, 0.634> <-3.047, 1.417, 0.511> 
		<-2.967, 1.322, 0.917> <-2.967, 1.342, 0.796> <-2.967, 1.372, 0.634> <-2.967, 1.387, 0.511> 
		<-2.907, 1.322, 0.917> <-2.907, 1.342, 0.796> <-2.907, 1.372, 0.634> <-2.907, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.107, 1.413, 0.511> <-3.107, 1.426, 0.431> <-3.107, 1.436, 0.322> <-3.107, 1.434, 0.240> 
		<-3.047, 1.417, 0.511> <-3.047, 1.430, 0.431> <-3.055, 1.442, 0.289> <-3.055, 1.440, 0.207> 
		<-2.967, 1.387, 0.511> <-2.967, 1.398, 0.419> <-2.968, 1.411, 0.302> <-2.968, 1.409, 0.209> 
		<-2.907, 1.387, 0.511> <-2.907, 1.398, 0.419> <-2.907, 1.411, 0.296> <-2.907, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.107, 1.434, 0.240> <-3.107, 1.433, 0.182> <-3.107, 1.431, 0.119> <-3.107, 1.402, 0.048> 
		<-3.055, 1.440, 0.207> <-3.055, 1.439, 0.149> <-3.055, 1.431, 0.085> <-3.055, 1.402, 0.015> 
		<-2.968, 1.409, 0.209> <-2.968, 1.407, 0.150> <-2.968, 1.399, 0.089> <-2.968, 1.376, 0.016> 
		<-2.907, 1.409, 0.204> <-2.907, 1.407, 0.145> <-2.907, 1.399, 0.083> <-2.907, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.107, 1.402, 0.048> <-3.107, 1.390, 0.021> <-3.107, 1.340, -0.011> <-3.107, 1.337, 0.008> 
		<-3.055, 1.402, 0.015> <-3.055, 1.390, -0.012> <-3.056, 1.336, -0.044> <-3.056, 1.333, -0.025> 
		<-2.968, 1.376, 0.016> <-2.968, 1.370, -0.005> <-2.968, 1.338, -0.039> <-2.968, 1.337, -0.024> 
		<-2.907, 1.376, 0.010> <-2.907, 1.370, -0.011> <-2.907, 1.338, -0.045> <-2.907, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.107, 1.337, 0.008> <-3.107, 1.322, 0.121> <-3.107, 1.353, 0.086> <-3.107, 1.347, 0.451> 
		<-3.056, 1.333, -0.025> <-3.056, 1.318, 0.088> <-3.056, 1.353, 0.053> <-3.056, 1.347, 0.418> 
		<-2.968, 1.337, -0.024> <-2.968, 1.329, 0.090> <-2.968, 1.353, 0.054> <-2.968, 1.347, 0.420> 
		<-2.907, 1.337, -0.030> <-2.907, 1.329, 0.084> <-2.907, 1.353, 0.048> <-2.907, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.322, 0.917> <-2.847, 1.322, 0.917> <-2.767, 1.322, 0.917> <-2.707, 1.322, 0.917> 
		<-2.907, 1.329, 0.766> <-2.847, 1.329, 0.766> <-2.767, 1.329, 0.766> <-2.707, 1.329, 0.766> 
		<-2.907, 1.340, 0.829> <-2.847, 1.340, 0.824> <-2.767, 1.340, 0.829> <-2.707, 1.340, 0.829> 
		<-2.907, 1.347, 0.414> <-2.847, 1.347, 0.409> <-2.767, 1.347, 0.414> <-2.707, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.322, 0.917> <-2.907, 1.342, 0.796> <-2.907, 1.372, 0.634> <-2.907, 1.387, 0.511> 
		<-2.847, 1.322, 0.917> <-2.847, 1.342, 0.796> <-2.846, 1.372, 0.634> <-2.846, 1.387, 0.511> 
		<-2.767, 1.322, 0.917> <-2.767, 1.349, 0.796> <-2.767, 1.393, 0.635> <-2.767, 1.413, 0.511> 
		<-2.707, 1.322, 0.917> <-2.707, 1.349, 0.796> <-2.707, 1.393, 0.635> <-2.707, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.387, 0.511> <-2.907, 1.398, 0.419> <-2.907, 1.411, 0.296> <-2.907, 1.409, 0.204> 
		<-2.846, 1.387, 0.511> <-2.846, 1.398, 0.419> <-2.847, 1.411, 0.291> <-2.847, 1.409, 0.198> 
		<-2.767, 1.413, 0.511> <-2.767, 1.427, 0.420> <-2.767, 1.436, 0.296> <-2.767, 1.434, 0.204> 
		<-2.707, 1.413, 0.511> <-2.707, 1.427, 0.420> <-2.707, 1.436, 0.296> <-2.707, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.409, 0.204> <-2.907, 1.407, 0.145> <-2.907, 1.399, 0.083> <-2.907, 1.376, 0.010> 
		<-2.847, 1.409, 0.198> <-2.847, 1.407, 0.139> <-2.847, 1.399, 0.078> <-2.847, 1.376, 0.004> 
		<-2.767, 1.434, 0.204> <-2.767, 1.433, 0.145> <-2.767, 1.431, 0.081> <-2.767, 1.402, 0.010> 
		<-2.707, 1.434, 0.204> <-2.707, 1.433, 0.145> <-2.707, 1.431, 0.081> <-2.707, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.376, 0.010> <-2.907, 1.370, -0.011> <-2.907, 1.338, -0.045> <-2.907, 1.337, -0.030> 
		<-2.847, 1.376, 0.004> <-2.847, 1.370, -0.017> <-2.847, 1.338, -0.050> <-2.847, 1.337, -0.036> 
		<-2.767, 1.402, 0.010> <-2.767, 1.391, -0.017> <-2.767, 1.340, -0.050> <-2.767, 1.337, -0.030> 
		<-2.707, 1.402, 0.010> <-2.707, 1.391, -0.017> <-2.707, 1.340, -0.050> <-2.707, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.337, -0.030> <-2.907, 1.329, 0.084> <-2.907, 1.353, 0.048> <-2.907, 1.347, 0.414> 
		<-2.847, 1.337, -0.036> <-2.847, 1.329, 0.078> <-2.847, 1.353, 0.043> <-2.847, 1.347, 0.409> 
		<-2.767, 1.337, -0.030> <-2.767, 1.322, 0.083> <-2.767, 1.353, 0.048> <-2.767, 1.347, 0.414> 
		<-2.707, 1.337, -0.030> <-2.707, 1.322, 0.083> <-2.707, 1.353, 0.048> <-2.707, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.322, 0.917> <-2.647, 1.322, 0.917> <-2.567, 1.322, 0.917> <-2.507, 1.322, 0.917> 
		<-2.707, 1.329, 0.766> <-2.647, 1.329, 0.766> <-2.567, 1.329, 0.766> <-2.507, 1.329, 0.766> 
		<-2.707, 1.340, 0.829> <-2.647, 1.340, 0.829> <-2.567, 1.340, 0.829> <-2.507, 1.340, 0.829> 
		<-2.707, 1.347, 0.414> <-2.647, 1.347, 0.414> <-2.567, 1.347, 0.414> <-2.507, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.322, 0.917> <-2.707, 1.349, 0.796> <-2.707, 1.393, 0.635> <-2.707, 1.413, 0.511> 
		<-2.647, 1.322, 0.917> <-2.647, 1.349, 0.796> <-2.646, 1.393, 0.635> <-2.646, 1.413, 0.511> 
		<-2.567, 1.322, 0.917> <-2.567, 1.342, 0.796> <-2.567, 1.372, 0.634> <-2.567, 1.387, 0.511> 
		<-2.507, 1.322, 0.917> <-2.507, 1.342, 0.796> <-2.507, 1.372, 0.634> <-2.507, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.413, 0.511> <-2.707, 1.427, 0.420> <-2.707, 1.436, 0.296> <-2.707, 1.434, 0.204> 
		<-2.646, 1.413, 0.511> <-2.646, 1.427, 0.420> <-2.646, 1.436, 0.296> <-2.646, 1.434, 0.204> 
		<-2.567, 1.387, 0.511> <-2.567, 1.398, 0.419> <-2.567, 1.411, 0.296> <-2.567, 1.409, 0.204> 
		<-2.507, 1.387, 0.511> <-2.507, 1.398, 0.419> <-2.507, 1.411, 0.296> <-2.507, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.434, 0.204> <-2.707, 1.433, 0.145> <-2.707, 1.431, 0.081> <-2.707, 1.402, 0.010> 
		<-2.646, 1.434, 0.204> <-2.646, 1.433, 0.145> <-2.646, 1.431, 0.081> <-2.646, 1.402, 0.010> 
		<-2.567, 1.409, 0.204> <-2.567, 1.407, 0.145> <-2.567, 1.399, 0.083> <-2.567, 1.376, 0.010> 
		<-2.507, 1.409, 0.204> <-2.507, 1.407, 0.145> <-2.507, 1.399, 0.083> <-2.507, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.402, 0.010> <-2.707, 1.391, -0.017> <-2.707, 1.340, -0.050> <-2.707, 1.337, -0.030> 
		<-2.646, 1.402, 0.010> <-2.646, 1.391, -0.017> <-2.647, 1.340, -0.050> <-2.647, 1.337, -0.030> 
		<-2.567, 1.376, 0.010> <-2.567, 1.370, -0.011> <-2.567, 1.338, -0.045> <-2.567, 1.337, -0.030> 
		<-2.507, 1.376, 0.010> <-2.507, 1.370, -0.011> <-2.507, 1.338, -0.045> <-2.507, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.337, -0.030> <-2.707, 1.322, 0.083> <-2.707, 1.353, 0.048> <-2.707, 1.347, 0.414> 
		<-2.647, 1.337, -0.030> <-2.647, 1.322, 0.083> <-2.647, 1.353, 0.048> <-2.647, 1.347, 0.414> 
		<-2.567, 1.337, -0.030> <-2.567, 1.329, 0.084> <-2.567, 1.353, 0.048> <-2.567, 1.347, 0.414> 
		<-2.507, 1.337, -0.030> <-2.507, 1.329, 0.084> <-2.507, 1.353, 0.048> <-2.507, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.322, 0.917> <-2.447, 1.322, 0.917> <-2.367, 1.322, 0.917> <-2.307, 1.322, 0.917> 
		<-2.507, 1.329, 0.766> <-2.447, 1.329, 0.766> <-2.367, 1.329, 0.766> <-2.307, 1.329, 0.766> 
		<-2.507, 1.340, 0.829> <-2.447, 1.340, 0.829> <-2.367, 1.340, 0.829> <-2.307, 1.340, 0.829> 
		<-2.507, 1.347, 0.414> <-2.447, 1.347, 0.414> <-2.367, 1.347, 0.414> <-2.307, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.322, 0.917> <-2.507, 1.342, 0.796> <-2.507, 1.372, 0.634> <-2.507, 1.387, 0.511> 
		<-2.447, 1.322, 0.917> <-2.447, 1.342, 0.796> <-2.446, 1.372, 0.634> <-2.446, 1.387, 0.511> 
		<-2.367, 1.322, 0.917> <-2.367, 1.349, 0.796> <-2.367, 1.393, 0.635> <-2.367, 1.413, 0.511> 
		<-2.307, 1.322, 0.917> <-2.307, 1.349, 0.796> <-2.307, 1.393, 0.635> <-2.307, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.387, 0.511> <-2.507, 1.398, 0.419> <-2.507, 1.411, 0.296> <-2.507, 1.409, 0.204> 
		<-2.446, 1.387, 0.511> <-2.446, 1.398, 0.419> <-2.446, 1.411, 0.296> <-2.446, 1.409, 0.204> 
		<-2.367, 1.413, 0.511> <-2.367, 1.427, 0.420> <-2.367, 1.436, 0.296> <-2.367, 1.434, 0.204> 
		<-2.307, 1.413, 0.511> <-2.307, 1.427, 0.420> <-2.307, 1.436, 0.296> <-2.307, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.409, 0.204> <-2.507, 1.407, 0.145> <-2.507, 1.399, 0.083> <-2.507, 1.376, 0.010> 
		<-2.446, 1.409, 0.204> <-2.446, 1.407, 0.145> <-2.446, 1.399, 0.083> <-2.446, 1.376, 0.010> 
		<-2.367, 1.434, 0.204> <-2.367, 1.433, 0.145> <-2.367, 1.431, 0.081> <-2.367, 1.402, 0.010> 
		<-2.307, 1.434, 0.204> <-2.307, 1.433, 0.145> <-2.307, 1.431, 0.081> <-2.307, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.376, 0.010> <-2.507, 1.370, -0.011> <-2.507, 1.338, -0.045> <-2.507, 1.337, -0.030> 
		<-2.446, 1.376, 0.010> <-2.446, 1.370, -0.011> <-2.447, 1.338, -0.045> <-2.447, 1.337, -0.030> 
		<-2.367, 1.402, 0.010> <-2.367, 1.391, -0.017> <-2.367, 1.340, -0.050> <-2.367, 1.337, -0.030> 
		<-2.307, 1.402, 0.010> <-2.307, 1.391, -0.017> <-2.307, 1.340, -0.050> <-2.307, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.337, -0.030> <-2.507, 1.329, 0.084> <-2.507, 1.353, 0.048> <-2.507, 1.347, 0.414> 
		<-2.447, 1.337, -0.030> <-2.447, 1.329, 0.084> <-2.447, 1.353, 0.048> <-2.447, 1.347, 0.414> 
		<-2.367, 1.337, -0.030> <-2.367, 1.322, 0.083> <-2.367, 1.353, 0.048> <-2.367, 1.347, 0.414> 
		<-2.307, 1.337, -0.030> <-2.307, 1.322, 0.083> <-2.307, 1.353, 0.048> <-2.307, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.322, 0.917> <-2.247, 1.322, 0.917> <-2.167, 1.322, 0.917> <-2.107, 1.322, 0.917> 
		<-2.307, 1.329, 0.766> <-2.247, 1.329, 0.766> <-2.167, 1.329, 0.766> <-2.107, 1.329, 0.766> 
		<-2.307, 1.340, 0.829> <-2.247, 1.340, 0.829> <-2.167, 1.340, 0.829> <-2.107, 1.340, 0.829> 
		<-2.307, 1.347, 0.414> <-2.247, 1.347, 0.414> <-2.167, 1.347, 0.414> <-2.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.322, 0.917> <-2.307, 1.349, 0.796> <-2.307, 1.393, 0.635> <-2.307, 1.413, 0.511> 
		<-2.247, 1.322, 0.917> <-2.247, 1.349, 0.796> <-2.246, 1.393, 0.635> <-2.246, 1.413, 0.511> 
		<-2.167, 1.322, 0.917> <-2.167, 1.342, 0.796> <-2.167, 1.372, 0.634> <-2.167, 1.387, 0.511> 
		<-2.107, 1.322, 0.917> <-2.107, 1.342, 0.796> <-2.107, 1.372, 0.634> <-2.107, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.413, 0.511> <-2.307, 1.427, 0.420> <-2.307, 1.436, 0.296> <-2.307, 1.434, 0.204> 
		<-2.246, 1.413, 0.511> <-2.246, 1.427, 0.420> <-2.246, 1.436, 0.296> <-2.246, 1.434, 0.204> 
		<-2.167, 1.387, 0.511> <-2.167, 1.398, 0.419> <-2.167, 1.411, 0.296> <-2.167, 1.409, 0.204> 
		<-2.107, 1.387, 0.511> <-2.107, 1.398, 0.419> <-2.107, 1.411, 0.296> <-2.107, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.434, 0.204> <-2.307, 1.433, 0.145> <-2.307, 1.431, 0.081> <-2.307, 1.402, 0.010> 
		<-2.246, 1.434, 0.204> <-2.246, 1.433, 0.145> <-2.246, 1.431, 0.081> <-2.246, 1.402, 0.010> 
		<-2.167, 1.409, 0.204> <-2.167, 1.407, 0.145> <-2.167, 1.399, 0.083> <-2.167, 1.376, 0.010> 
		<-2.107, 1.409, 0.204> <-2.107, 1.407, 0.145> <-2.107, 1.399, 0.083> <-2.107, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.402, 0.010> <-2.307, 1.391, -0.017> <-2.307, 1.340, -0.050> <-2.307, 1.337, -0.030> 
		<-2.246, 1.402, 0.010> <-2.246, 1.391, -0.017> <-2.247, 1.340, -0.050> <-2.247, 1.337, -0.030> 
		<-2.167, 1.376, 0.010> <-2.167, 1.370, -0.011> <-2.167, 1.338, -0.045> <-2.167, 1.337, -0.030> 
		<-2.107, 1.376, 0.010> <-2.107, 1.370, -0.011> <-2.107, 1.338, -0.045> <-2.107, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.337, -0.030> <-2.307, 1.322, 0.083> <-2.307, 1.353, 0.048> <-2.307, 1.347, 0.414> 
		<-2.247, 1.337, -0.030> <-2.247, 1.322, 0.083> <-2.247, 1.353, 0.048> <-2.247, 1.347, 0.414> 
		<-2.167, 1.337, -0.030> <-2.167, 1.329, 0.084> <-2.167, 1.353, 0.048> <-2.167, 1.347, 0.414> 
		<-2.107, 1.337, -0.030> <-2.107, 1.329, 0.084> <-2.107, 1.353, 0.048> <-2.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.322, 0.917> <-2.047, 1.322, 0.917> <-1.967, 1.322, 0.917> <-1.907, 1.322, 0.917> 
		<-2.107, 1.329, 0.766> <-2.047, 1.329, 0.766> <-1.967, 1.329, 0.766> <-1.907, 1.329, 0.766> 
		<-2.107, 1.340, 0.829> <-2.047, 1.340, 0.829> <-1.967, 1.340, 0.829> <-1.907, 1.340, 0.829> 
		<-2.107, 1.347, 0.414> <-2.047, 1.347, 0.414> <-1.967, 1.347, 0.414> <-1.907, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.322, 0.917> <-2.107, 1.342, 0.796> <-2.107, 1.372, 0.634> <-2.107, 1.387, 0.511> 
		<-2.047, 1.322, 0.917> <-2.047, 1.342, 0.796> <-2.046, 1.372, 0.634> <-2.046, 1.387, 0.511> 
		<-1.967, 1.322, 0.917> <-1.967, 1.349, 0.796> <-1.967, 1.393, 0.635> <-1.967, 1.413, 0.511> 
		<-1.907, 1.322, 0.917> <-1.907, 1.349, 0.796> <-1.907, 1.393, 0.635> <-1.907, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.387, 0.511> <-2.107, 1.398, 0.419> <-2.107, 1.411, 0.296> <-2.107, 1.409, 0.204> 
		<-2.046, 1.387, 0.511> <-2.046, 1.398, 0.419> <-2.046, 1.411, 0.296> <-2.046, 1.409, 0.204> 
		<-1.967, 1.413, 0.511> <-1.967, 1.427, 0.420> <-1.967, 1.436, 0.296> <-1.967, 1.434, 0.204> 
		<-1.907, 1.413, 0.511> <-1.907, 1.427, 0.420> <-1.907, 1.436, 0.296> <-1.907, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.409, 0.204> <-2.107, 1.407, 0.145> <-2.107, 1.399, 0.083> <-2.107, 1.376, 0.010> 
		<-2.046, 1.409, 0.204> <-2.046, 1.407, 0.145> <-2.046, 1.399, 0.083> <-2.046, 1.376, 0.010> 
		<-1.967, 1.434, 0.204> <-1.967, 1.433, 0.145> <-1.967, 1.431, 0.081> <-1.967, 1.402, 0.010> 
		<-1.907, 1.434, 0.204> <-1.907, 1.433, 0.145> <-1.907, 1.431, 0.081> <-1.907, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.376, 0.010> <-2.107, 1.370, -0.011> <-2.107, 1.338, -0.045> <-2.107, 1.337, -0.030> 
		<-2.046, 1.376, 0.010> <-2.046, 1.370, -0.011> <-2.047, 1.338, -0.045> <-2.047, 1.337, -0.030> 
		<-1.967, 1.402, 0.010> <-1.967, 1.391, -0.017> <-1.967, 1.340, -0.050> <-1.967, 1.337, -0.030> 
		<-1.907, 1.402, 0.010> <-1.907, 1.391, -0.017> <-1.907, 1.340, -0.050> <-1.907, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.337, -0.030> <-2.107, 1.329, 0.084> <-2.107, 1.353, 0.048> <-2.107, 1.347, 0.414> 
		<-2.047, 1.337, -0.030> <-2.047, 1.329, 0.084> <-2.047, 1.353, 0.048> <-2.047, 1.347, 0.414> 
		<-1.967, 1.337, -0.030> <-1.967, 1.322, 0.083> <-1.967, 1.353, 0.048> <-1.967, 1.347, 0.414> 
		<-1.907, 1.337, -0.030> <-1.907, 1.322, 0.083> <-1.907, 1.353, 0.048> <-1.907, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.322, 0.917> <-1.847, 1.322, 0.917> <-1.767, 1.322, 0.917> <-1.707, 1.322, 0.917> 
		<-1.907, 1.329, 0.766> <-1.847, 1.329, 0.766> <-1.767, 1.329, 0.766> <-1.707, 1.329, 0.766> 
		<-1.907, 1.340, 0.829> <-1.847, 1.340, 0.829> <-1.767, 1.340, 0.829> <-1.707, 1.340, 0.829> 
		<-1.907, 1.347, 0.414> <-1.847, 1.347, 0.414> <-1.767, 1.347, 0.414> <-1.707, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.322, 0.917> <-1.907, 1.349, 0.796> <-1.907, 1.393, 0.635> <-1.907, 1.413, 0.511> 
		<-1.847, 1.322, 0.917> <-1.847, 1.349, 0.796> <-1.846, 1.393, 0.635> <-1.846, 1.413, 0.511> 
		<-1.767, 1.322, 0.917> <-1.767, 1.342, 0.796> <-1.767, 1.372, 0.634> <-1.767, 1.387, 0.511> 
		<-1.707, 1.322, 0.917> <-1.707, 1.342, 0.796> <-1.707, 1.372, 0.634> <-1.707, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.413, 0.511> <-1.907, 1.427, 0.420> <-1.907, 1.436, 0.296> <-1.907, 1.434, 0.204> 
		<-1.846, 1.413, 0.511> <-1.846, 1.427, 0.420> <-1.846, 1.436, 0.296> <-1.846, 1.434, 0.204> 
		<-1.767, 1.387, 0.511> <-1.767, 1.398, 0.419> <-1.767, 1.411, 0.296> <-1.767, 1.409, 0.204> 
		<-1.707, 1.387, 0.511> <-1.707, 1.398, 0.419> <-1.707, 1.411, 0.296> <-1.707, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.434, 0.204> <-1.907, 1.433, 0.145> <-1.907, 1.431, 0.081> <-1.907, 1.402, 0.010> 
		<-1.846, 1.434, 0.204> <-1.846, 1.433, 0.145> <-1.846, 1.431, 0.081> <-1.846, 1.402, 0.010> 
		<-1.767, 1.409, 0.204> <-1.767, 1.407, 0.145> <-1.767, 1.399, 0.083> <-1.767, 1.376, 0.010> 
		<-1.707, 1.409, 0.204> <-1.707, 1.407, 0.145> <-1.707, 1.399, 0.083> <-1.707, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.402, 0.010> <-1.907, 1.391, -0.017> <-1.907, 1.340, -0.050> <-1.907, 1.337, -0.030> 
		<-1.846, 1.402, 0.010> <-1.846, 1.391, -0.017> <-1.847, 1.340, -0.050> <-1.847, 1.337, -0.030> 
		<-1.767, 1.376, 0.010> <-1.767, 1.370, -0.011> <-1.767, 1.338, -0.045> <-1.767, 1.337, -0.030> 
		<-1.707, 1.376, 0.010> <-1.707, 1.370, -0.011> <-1.707, 1.338, -0.045> <-1.707, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.337, -0.030> <-1.907, 1.322, 0.083> <-1.907, 1.353, 0.048> <-1.907, 1.347, 0.414> 
		<-1.847, 1.337, -0.030> <-1.847, 1.322, 0.083> <-1.847, 1.353, 0.048> <-1.847, 1.347, 0.414> 
		<-1.767, 1.337, -0.030> <-1.767, 1.329, 0.084> <-1.767, 1.353, 0.048> <-1.767, 1.347, 0.414> 
		<-1.707, 1.337, -0.030> <-1.707, 1.329, 0.084> <-1.707, 1.353, 0.048> <-1.707, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.322, 0.917> <-1.647, 1.322, 0.917> <-1.567, 1.322, 0.917> <-1.507, 1.322, 0.917> 
		<-1.707, 1.329, 0.766> <-1.647, 1.329, 0.766> <-1.567, 1.329, 0.766> <-1.507, 1.329, 0.766> 
		<-1.707, 1.340, 0.829> <-1.647, 1.340, 0.829> <-1.567, 1.340, 0.829> <-1.507, 1.340, 0.829> 
		<-1.707, 1.347, 0.414> <-1.647, 1.347, 0.414> <-1.567, 1.347, 0.414> <-1.507, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.322, 0.917> <-1.707, 1.342, 0.796> <-1.707, 1.372, 0.634> <-1.707, 1.387, 0.511> 
		<-1.647, 1.322, 0.917> <-1.647, 1.342, 0.796> <-1.646, 1.372, 0.634> <-1.646, 1.387, 0.511> 
		<-1.567, 1.322, 0.917> <-1.567, 1.349, 0.796> <-1.567, 1.393, 0.635> <-1.567, 1.413, 0.511> 
		<-1.507, 1.322, 0.917> <-1.507, 1.349, 0.796> <-1.507, 1.393, 0.635> <-1.507, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.387, 0.511> <-1.707, 1.398, 0.419> <-1.707, 1.411, 0.296> <-1.707, 1.409, 0.204> 
		<-1.646, 1.387, 0.511> <-1.646, 1.398, 0.419> <-1.646, 1.411, 0.296> <-1.646, 1.409, 0.204> 
		<-1.567, 1.413, 0.511> <-1.567, 1.427, 0.420> <-1.567, 1.436, 0.296> <-1.567, 1.434, 0.204> 
		<-1.507, 1.413, 0.511> <-1.507, 1.427, 0.420> <-1.507, 1.436, 0.296> <-1.507, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.409, 0.204> <-1.707, 1.407, 0.145> <-1.707, 1.399, 0.083> <-1.707, 1.376, 0.010> 
		<-1.646, 1.409, 0.204> <-1.646, 1.407, 0.145> <-1.646, 1.399, 0.083> <-1.646, 1.376, 0.010> 
		<-1.567, 1.434, 0.204> <-1.567, 1.433, 0.145> <-1.567, 1.431, 0.081> <-1.567, 1.402, 0.010> 
		<-1.507, 1.434, 0.204> <-1.507, 1.433, 0.145> <-1.507, 1.431, 0.081> <-1.507, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.376, 0.010> <-1.707, 1.370, -0.011> <-1.707, 1.338, -0.045> <-1.707, 1.337, -0.030> 
		<-1.646, 1.376, 0.010> <-1.646, 1.370, -0.011> <-1.647, 1.338, -0.045> <-1.647, 1.337, -0.030> 
		<-1.567, 1.402, 0.010> <-1.567, 1.391, -0.017> <-1.567, 1.340, -0.050> <-1.567, 1.337, -0.030> 
		<-1.507, 1.402, 0.010> <-1.507, 1.391, -0.017> <-1.507, 1.340, -0.050> <-1.507, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.337, -0.030> <-1.707, 1.329, 0.084> <-1.707, 1.353, 0.048> <-1.707, 1.347, 0.414> 
		<-1.647, 1.337, -0.030> <-1.647, 1.329, 0.084> <-1.647, 1.353, 0.048> <-1.647, 1.347, 0.414> 
		<-1.567, 1.337, -0.030> <-1.567, 1.322, 0.083> <-1.567, 1.353, 0.048> <-1.567, 1.347, 0.414> 
		<-1.507, 1.337, -0.030> <-1.507, 1.322, 0.083> <-1.507, 1.353, 0.048> <-1.507, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.322, 0.917> <-1.447, 1.322, 0.917> <-1.366, 1.322, 0.910> <-1.307, 1.322, 0.917> 
		<-1.507, 1.329, 0.766> <-1.447, 1.329, 0.766> <-1.366, 1.329, 0.759> <-1.307, 1.329, 0.766> 
		<-1.507, 1.340, 0.829> <-1.447, 1.340, 0.829> <-1.367, 1.340, 0.829> <-1.307, 1.340, 0.829> 
		<-1.507, 1.347, 0.414> <-1.447, 1.347, 0.414> <-1.367, 1.347, 0.414> <-1.307, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.322, 0.917> <-1.507, 1.349, 0.796> <-1.507, 1.393, 0.635> <-1.507, 1.413, 0.511> 
		<-1.447, 1.322, 0.917> <-1.447, 1.349, 0.796> <-1.446, 1.393, 0.635> <-1.446, 1.413, 0.511> 
		<-1.366, 1.322, 0.910> <-1.366, 1.342, 0.788> <-1.367, 1.372, 0.634> <-1.367, 1.387, 0.511> 
		<-1.307, 1.322, 0.917> <-1.307, 1.342, 0.796> <-1.307, 1.372, 0.634> <-1.307, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.413, 0.511> <-1.507, 1.427, 0.420> <-1.507, 1.436, 0.296> <-1.507, 1.434, 0.204> 
		<-1.446, 1.413, 0.511> <-1.446, 1.427, 0.420> <-1.446, 1.436, 0.296> <-1.446, 1.434, 0.204> 
		<-1.367, 1.387, 0.511> <-1.367, 1.398, 0.419> <-1.367, 1.411, 0.296> <-1.367, 1.409, 0.204> 
		<-1.307, 1.387, 0.511> <-1.307, 1.398, 0.419> <-1.307, 1.411, 0.296> <-1.307, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.434, 0.204> <-1.507, 1.433, 0.145> <-1.507, 1.431, 0.081> <-1.507, 1.402, 0.010> 
		<-1.446, 1.434, 0.204> <-1.446, 1.433, 0.145> <-1.446, 1.431, 0.081> <-1.446, 1.402, 0.010> 
		<-1.367, 1.409, 0.204> <-1.367, 1.407, 0.145> <-1.367, 1.399, 0.083> <-1.367, 1.376, 0.010> 
		<-1.307, 1.409, 0.204> <-1.307, 1.407, 0.145> <-1.307, 1.399, 0.083> <-1.307, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.402, 0.010> <-1.507, 1.391, -0.017> <-1.507, 1.340, -0.050> <-1.507, 1.337, -0.030> 
		<-1.446, 1.402, 0.010> <-1.446, 1.391, -0.017> <-1.447, 1.340, -0.050> <-1.447, 1.337, -0.030> 
		<-1.367, 1.376, 0.010> <-1.367, 1.370, -0.011> <-1.367, 1.338, -0.045> <-1.367, 1.337, -0.030> 
		<-1.307, 1.376, 0.010> <-1.307, 1.370, -0.011> <-1.307, 1.338, -0.045> <-1.307, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.337, -0.030> <-1.507, 1.322, 0.083> <-1.507, 1.353, 0.048> <-1.507, 1.347, 0.414> 
		<-1.447, 1.337, -0.030> <-1.447, 1.322, 0.083> <-1.447, 1.353, 0.048> <-1.447, 1.347, 0.414> 
		<-1.367, 1.337, -0.030> <-1.367, 1.329, 0.084> <-1.367, 1.353, 0.048> <-1.367, 1.347, 0.414> 
		<-1.307, 1.337, -0.030> <-1.307, 1.329, 0.084> <-1.307, 1.353, 0.048> <-1.307, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.322, 0.917> <-1.245, 1.322, 0.925> <-1.168, 1.322, 0.962> <-1.107, 1.322, 0.970> 
		<-1.307, 1.329, 0.766> <-1.245, 1.329, 0.775> <-1.168, 1.329, 0.795> <-1.107, 1.329, 0.803> 
		<-1.307, 1.340, 0.829> <-1.247, 1.340, 0.829> <-1.167, 1.340, 0.872> <-1.107, 1.340, 0.872> 
		<-1.307, 1.347, 0.414> <-1.247, 1.347, 0.414> <-1.167, 1.347, 0.414> <-1.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.322, 0.917> <-1.307, 1.342, 0.796> <-1.307, 1.372, 0.634> <-1.307, 1.387, 0.511> 
		<-1.245, 1.322, 0.925> <-1.245, 1.342, 0.804> <-1.246, 1.372, 0.634> <-1.246, 1.387, 0.511> 
		<-1.168, 1.322, 0.962> <-1.168, 1.349, 0.824> <-1.167, 1.392, 0.650> <-1.167, 1.413, 0.511> 
		<-1.107, 1.322, 0.970> <-1.107, 1.349, 0.832> <-1.107, 1.392, 0.650> <-1.107, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.387, 0.511> <-1.307, 1.398, 0.419> <-1.307, 1.411, 0.296> <-1.307, 1.409, 0.204> 
		<-1.246, 1.387, 0.511> <-1.246, 1.398, 0.419> <-1.246, 1.411, 0.296> <-1.246, 1.409, 0.204> 
		<-1.167, 1.413, 0.511> <-1.167, 1.426, 0.420> <-1.167, 1.436, 0.296> <-1.167, 1.434, 0.204> 
		<-1.107, 1.413, 0.511> <-1.107, 1.426, 0.420> <-1.107, 1.436, 0.296> <-1.107, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.409, 0.204> <-1.307, 1.407, 0.145> <-1.307, 1.399, 0.083> <-1.307, 1.376, 0.010> 
		<-1.246, 1.409, 0.204> <-1.246, 1.407, 0.145> <-1.246, 1.399, 0.083> <-1.246, 1.376, 0.010> 
		<-1.167, 1.434, 0.204> <-1.167, 1.433, 0.145> <-1.167, 1.431, 0.081> <-1.167, 1.402, 0.010> 
		<-1.107, 1.434, 0.204> <-1.107, 1.433, 0.145> <-1.107, 1.431, 0.081> <-1.107, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.376, 0.010> <-1.307, 1.370, -0.011> <-1.307, 1.338, -0.045> <-1.307, 1.337, -0.030> 
		<-1.246, 1.376, 0.010> <-1.246, 1.370, -0.011> <-1.247, 1.338, -0.045> <-1.247, 1.337, -0.030> 
		<-1.167, 1.402, 0.010> <-1.167, 1.391, -0.017> <-1.167, 1.340, -0.050> <-1.167, 1.337, -0.030> 
		<-1.107, 1.402, 0.010> <-1.107, 1.391, -0.017> <-1.107, 1.340, -0.050> <-1.107, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.337, -0.030> <-1.307, 1.329, 0.084> <-1.307, 1.353, 0.048> <-1.307, 1.347, 0.414> 
		<-1.247, 1.337, -0.030> <-1.247, 1.329, 0.084> <-1.247, 1.353, 0.048> <-1.247, 1.347, 0.414> 
		<-1.167, 1.337, -0.030> <-1.167, 1.322, 0.083> <-1.167, 1.352, 0.048> <-1.167, 1.347, 0.414> 
		<-1.107, 1.337, -0.030> <-1.107, 1.322, 0.083> <-1.107, 1.352, 0.048> <-1.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.322, 0.970> <-1.047, 1.322, 0.978> <-0.967, 1.322, 0.970> <-0.907, 1.322, 0.970> 
		<-1.107, 1.329, 0.803> <-1.047, 1.329, 0.811> <-0.967, 1.329, 0.803> <-0.907, 1.329, 0.803> 
		<-1.107, 1.340, 0.872> <-1.047, 1.340, 0.872> <-0.967, 1.340, 0.872> <-0.907, 1.340, 0.872> 
		<-1.107, 1.347, 0.414> <-1.047, 1.347, 0.414> <-0.967, 1.347, 0.414> <-0.907, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.322, 0.970> <-1.107, 1.349, 0.832> <-1.107, 1.392, 0.650> <-1.107, 1.413, 0.511> 
		<-1.047, 1.322, 0.978> <-1.047, 1.349, 0.840> <-1.046, 1.392, 0.650> <-1.046, 1.413, 0.511> 
		<-0.967, 1.322, 0.970> <-0.967, 1.342, 0.832> <-0.967, 1.372, 0.649> <-0.967, 1.387, 0.511> 
		<-0.907, 1.322, 0.970> <-0.907, 1.342, 0.832> <-0.907, 1.372, 0.649> <-0.907, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.413, 0.511> <-1.107, 1.426, 0.420> <-1.107, 1.436, 0.296> <-1.107, 1.434, 0.204> 
		<-1.046, 1.413, 0.511> <-1.046, 1.426, 0.420> <-1.046, 1.436, 0.296> <-1.046, 1.434, 0.204> 
		<-0.967, 1.387, 0.511> <-0.967, 1.398, 0.419> <-0.967, 1.411, 0.296> <-0.967, 1.409, 0.204> 
		<-0.907, 1.387, 0.511> <-0.907, 1.398, 0.419> <-0.907, 1.411, 0.296> <-0.907, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.434, 0.204> <-1.107, 1.433, 0.145> <-1.107, 1.431, 0.081> <-1.107, 1.402, 0.010> 
		<-1.046, 1.434, 0.204> <-1.046, 1.433, 0.145> <-1.046, 1.431, 0.081> <-1.046, 1.402, 0.010> 
		<-0.967, 1.409, 0.204> <-0.967, 1.407, 0.145> <-0.967, 1.399, 0.083> <-0.967, 1.376, 0.010> 
		<-0.907, 1.409, 0.204> <-0.907, 1.407, 0.145> <-0.907, 1.399, 0.083> <-0.907, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.402, 0.010> <-1.107, 1.391, -0.017> <-1.107, 1.340, -0.050> <-1.107, 1.337, -0.030> 
		<-1.046, 1.402, 0.010> <-1.046, 1.391, -0.017> <-1.047, 1.340, -0.050> <-1.047, 1.337, -0.030> 
		<-0.967, 1.376, 0.010> <-0.967, 1.370, -0.011> <-0.967, 1.338, -0.045> <-0.967, 1.337, -0.030> 
		<-0.907, 1.376, 0.010> <-0.907, 1.370, -0.011> <-0.907, 1.338, -0.045> <-0.907, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.337, -0.030> <-1.107, 1.322, 0.083> <-1.107, 1.352, 0.048> <-1.107, 1.347, 0.414> 
		<-1.047, 1.337, -0.030> <-1.047, 1.322, 0.083> <-1.047, 1.352, 0.048> <-1.047, 1.347, 0.414> 
		<-0.967, 1.337, -0.030> <-0.967, 1.329, 0.084> <-0.967, 1.352, 0.048> <-0.967, 1.347, 0.414> 
		<-0.907, 1.337, -0.030> <-0.907, 1.329, 0.084> <-0.907, 1.352, 0.048> <-0.907, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.907, 1.322, 0.970> <-0.847, 1.322, 0.970> <-0.767, 1.322, 0.970> <-0.707, 1.322, 0.970> 
		<-0.907, 1.329, 0.803> <-0.847, 1.329, 0.803> <-0.767, 1.329, 0.803> <-0.707, 1.329, 0.803> 
		<-0.907, 1.340, 0.872> <-0.847, 1.340, 0.872> <-0.767, 1.340, 0.872> <-0.707, 1.340, 0.872> 
		<-0.907, 1.347, 0.414> <-0.847, 1.347, 0.414> <-0.767, 1.347, 0.414> <-0.707, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.907, 1.322, 0.970> <-0.907, 1.342, 0.832> <-0.907, 1.372, 0.649> <-0.907, 1.387, 0.511> 
		<-0.847, 1.322, 0.970> <-0.847, 1.342, 0.832> <-0.846, 1.372, 0.649> <-0.846, 1.387, 0.511> 
		<-0.767, 1.322, 0.970> <-0.767, 1.349, 0.832> <-0.767, 1.392, 0.650> <-0.767, 1.413, 0.511> 
		<-0.707, 1.322, 0.970> <-0.707, 1.349, 0.832> <-0.707, 1.392, 0.650> <-0.707, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.907, 1.387, 0.511> <-0.907, 1.398, 0.419> <-0.907, 1.411, 0.296> <-0.907, 1.409, 0.204> 
		<-0.846, 1.387, 0.511> <-0.846, 1.398, 0.419> <-0.846, 1.411, 0.296> <-0.846, 1.409, 0.204> 
		<-0.767, 1.413, 0.511> <-0.767, 1.426, 0.420> <-0.767, 1.436, 0.296> <-0.767, 1.434, 0.204> 
		<-0.707, 1.413, 0.511> <-0.707, 1.426, 0.420> <-0.707, 1.436, 0.296> <-0.707, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.907, 1.409, 0.204> <-0.907, 1.407, 0.145> <-0.907, 1.399, 0.083> <-0.907, 1.376, 0.010> 
		<-0.846, 1.409, 0.204> <-0.846, 1.407, 0.145> <-0.846, 1.399, 0.083> <-0.846, 1.376, 0.010> 
		<-0.767, 1.434, 0.204> <-0.767, 1.433, 0.145> <-0.767, 1.431, 0.081> <-0.767, 1.402, 0.010> 
		<-0.707, 1.434, 0.204> <-0.707, 1.433, 0.145> <-0.707, 1.431, 0.081> <-0.707, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.907, 1.376, 0.010> <-0.907, 1.370, -0.011> <-0.907, 1.338, -0.045> <-0.907, 1.337, -0.030> 
		<-0.846, 1.376, 0.010> <-0.846, 1.370, -0.011> <-0.847, 1.338, -0.045> <-0.847, 1.337, -0.030> 
		<-0.767, 1.402, 0.010> <-0.767, 1.391, -0.017> <-0.767, 1.340, -0.050> <-0.767, 1.337, -0.030> 
		<-0.707, 1.402, 0.010> <-0.707, 1.391, -0.017> <-0.707, 1.340, -0.050> <-0.707, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.907, 1.337, -0.030> <-0.907, 1.329, 0.084> <-0.907, 1.352, 0.048> <-0.907, 1.347, 0.414> 
		<-0.847, 1.337, -0.030> <-0.847, 1.329, 0.084> <-0.847, 1.352, 0.048> <-0.847, 1.347, 0.414> 
		<-0.767, 1.337, -0.030> <-0.767, 1.322, 0.083> <-0.767, 1.352, 0.048> <-0.767, 1.347, 0.414> 
		<-0.707, 1.337, -0.030> <-0.707, 1.322, 0.083> <-0.707, 1.352, 0.048> <-0.707, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 1.322, 0.970> <-0.647, 1.322, 0.970> <-0.567, 1.322, 0.970> <-0.507, 1.322, 0.970> 
		<-0.707, 1.329, 0.803> <-0.647, 1.329, 0.803> <-0.567, 1.329, 0.803> <-0.507, 1.329, 0.803> 
		<-0.707, 1.340, 0.872> <-0.647, 1.340, 0.872> <-0.567, 1.340, 0.872> <-0.507, 1.340, 0.872> 
		<-0.707, 1.347, 0.414> <-0.647, 1.347, 0.414> <-0.567, 1.347, 0.414> <-0.507, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 1.322, 0.970> <-0.707, 1.349, 0.832> <-0.707, 1.392, 0.650> <-0.707, 1.413, 0.511> 
		<-0.647, 1.322, 0.970> <-0.647, 1.349, 0.832> <-0.646, 1.392, 0.650> <-0.646, 1.413, 0.511> 
		<-0.567, 1.322, 0.970> <-0.567, 1.342, 0.832> <-0.567, 1.372, 0.649> <-0.567, 1.387, 0.511> 
		<-0.507, 1.322, 0.970> <-0.507, 1.342, 0.832> <-0.507, 1.372, 0.649> <-0.507, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 1.413, 0.511> <-0.707, 1.426, 0.420> <-0.707, 1.436, 0.296> <-0.707, 1.434, 0.204> 
		<-0.646, 1.413, 0.511> <-0.646, 1.426, 0.420> <-0.646, 1.436, 0.296> <-0.646, 1.434, 0.204> 
		<-0.567, 1.387, 0.511> <-0.567, 1.398, 0.419> <-0.567, 1.411, 0.296> <-0.567, 1.409, 0.204> 
		<-0.507, 1.387, 0.511> <-0.507, 1.398, 0.419> <-0.507, 1.411, 0.296> <-0.507, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 1.434, 0.204> <-0.707, 1.433, 0.145> <-0.707, 1.431, 0.081> <-0.707, 1.402, 0.010> 
		<-0.646, 1.434, 0.204> <-0.646, 1.433, 0.145> <-0.646, 1.431, 0.081> <-0.646, 1.402, 0.010> 
		<-0.567, 1.409, 0.204> <-0.567, 1.407, 0.145> <-0.567, 1.399, 0.083> <-0.567, 1.376, 0.010> 
		<-0.507, 1.409, 0.204> <-0.507, 1.407, 0.145> <-0.507, 1.399, 0.083> <-0.507, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 1.402, 0.010> <-0.707, 1.391, -0.017> <-0.707, 1.340, -0.050> <-0.707, 1.337, -0.030> 
		<-0.646, 1.402, 0.010> <-0.646, 1.391, -0.017> <-0.647, 1.340, -0.050> <-0.647, 1.337, -0.030> 
		<-0.567, 1.376, 0.010> <-0.567, 1.370, -0.011> <-0.567, 1.338, -0.045> <-0.567, 1.337, -0.030> 
		<-0.507, 1.376, 0.010> <-0.507, 1.370, -0.011> <-0.507, 1.338, -0.045> <-0.507, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 1.337, -0.030> <-0.707, 1.322, 0.083> <-0.707, 1.352, 0.048> <-0.707, 1.347, 0.414> 
		<-0.647, 1.337, -0.030> <-0.647, 1.322, 0.083> <-0.647, 1.352, 0.048> <-0.647, 1.347, 0.414> 
		<-0.567, 1.337, -0.030> <-0.567, 1.329, 0.084> <-0.567, 1.352, 0.048> <-0.567, 1.347, 0.414> 
		<-0.507, 1.337, -0.030> <-0.507, 1.329, 0.084> <-0.507, 1.352, 0.048> <-0.507, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 1.322, 0.970> <-0.447, 1.322, 0.970> <-0.367, 1.322, 0.970> <-0.307, 1.322, 0.970> 
		<-0.507, 1.329, 0.803> <-0.447, 1.329, 0.803> <-0.367, 1.329, 0.803> <-0.307, 1.329, 0.803> 
		<-0.507, 1.340, 0.872> <-0.447, 1.340, 0.872> <-0.367, 1.340, 0.872> <-0.307, 1.340, 0.872> 
		<-0.507, 1.347, 0.414> <-0.447, 1.347, 0.414> <-0.367, 1.347, 0.414> <-0.307, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 1.322, 0.970> <-0.507, 1.342, 0.832> <-0.507, 1.372, 0.649> <-0.507, 1.387, 0.511> 
		<-0.447, 1.322, 0.970> <-0.447, 1.342, 0.832> <-0.446, 1.372, 0.649> <-0.446, 1.387, 0.511> 
		<-0.367, 1.322, 0.970> <-0.367, 1.349, 0.832> <-0.367, 1.389, 0.650> <-0.367, 1.409, 0.511> 
		<-0.307, 1.322, 0.970> <-0.307, 1.349, 0.832> <-0.307, 1.392, 0.650> <-0.307, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 1.387, 0.511> <-0.507, 1.398, 0.419> <-0.507, 1.411, 0.296> <-0.507, 1.409, 0.204> 
		<-0.446, 1.387, 0.511> <-0.446, 1.398, 0.419> <-0.446, 1.411, 0.296> <-0.446, 1.409, 0.204> 
		<-0.367, 1.409, 0.511> <-0.367, 1.422, 0.420> <-0.367, 1.432, 0.296> <-0.367, 1.430, 0.204> 
		<-0.307, 1.413, 0.511> <-0.307, 1.426, 0.420> <-0.307, 1.436, 0.296> <-0.307, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 1.409, 0.204> <-0.507, 1.407, 0.145> <-0.507, 1.399, 0.083> <-0.507, 1.376, 0.010> 
		<-0.446, 1.409, 0.204> <-0.446, 1.407, 0.145> <-0.446, 1.399, 0.083> <-0.446, 1.376, 0.010> 
		<-0.367, 1.430, 0.204> <-0.367, 1.429, 0.145> <-0.367, 1.427, 0.081> <-0.367, 1.398, 0.010> 
		<-0.307, 1.434, 0.204> <-0.307, 1.433, 0.145> <-0.307, 1.431, 0.081> <-0.307, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 1.376, 0.010> <-0.507, 1.370, -0.011> <-0.507, 1.338, -0.045> <-0.507, 1.337, -0.030> 
		<-0.446, 1.376, 0.010> <-0.446, 1.370, -0.011> <-0.447, 1.338, -0.045> <-0.447, 1.337, -0.030> 
		<-0.367, 1.398, 0.010> <-0.367, 1.387, -0.017> <-0.367, 1.340, -0.050> <-0.367, 1.337, -0.030> 
		<-0.307, 1.402, 0.010> <-0.307, 1.391, -0.017> <-0.307, 1.340, -0.050> <-0.307, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 1.337, -0.030> <-0.507, 1.329, 0.084> <-0.507, 1.352, 0.048> <-0.507, 1.347, 0.414> 
		<-0.447, 1.337, -0.030> <-0.447, 1.329, 0.084> <-0.447, 1.352, 0.048> <-0.447, 1.347, 0.414> 
		<-0.367, 1.337, -0.030> <-0.367, 1.322, 0.083> <-0.367, 1.352, 0.048> <-0.367, 1.347, 0.414> 
		<-0.307, 1.337, -0.030> <-0.307, 1.322, 0.083> <-0.307, 1.352, 0.048> <-0.307, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.322, 0.970> <-0.247, 1.322, 0.970> <-0.167, 1.322, 0.970> <-0.107, 1.322, 0.970> 
		<-0.307, 1.329, 0.803> <-0.247, 1.329, 0.803> <-0.167, 1.329, 0.803> <-0.107, 1.329, 0.803> 
		<-0.307, 1.340, 0.872> <-0.247, 1.340, 0.872> <-0.167, 1.340, 0.872> <-0.107, 1.340, 0.872> 
		<-0.307, 1.347, 0.414> <-0.247, 1.347, 0.414> <-0.167, 1.347, 0.414> <-0.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.322, 0.970> <-0.307, 1.349, 0.832> <-0.307, 1.392, 0.650> <-0.307, 1.413, 0.511> 
		<-0.247, 1.322, 0.970> <-0.247, 1.349, 0.832> <-0.247, 1.396, 0.650> <-0.247, 1.417, 0.511> 
		<-0.167, 1.322, 0.970> <-0.167, 1.349, 0.832> <-0.167, 1.392, 0.650> <-0.167, 1.413, 0.511> 
		<-0.107, 1.322, 0.970> <-0.107, 1.349, 0.832> <-0.107, 1.392, 0.650> <-0.107, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.413, 0.511> <-0.307, 1.426, 0.420> <-0.307, 1.436, 0.296> <-0.307, 1.434, 0.204> 
		<-0.247, 1.417, 0.511> <-0.247, 1.430, 0.420> <-0.247, 1.440, 0.296> <-0.247, 1.438, 0.204> 
		<-0.167, 1.413, 0.511> <-0.167, 1.426, 0.420> <-0.167, 1.436, 0.296> <-0.167, 1.434, 0.204> 
		<-0.107, 1.413, 0.511> <-0.107, 1.426, 0.420> <-0.107, 1.436, 0.296> <-0.107, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.434, 0.204> <-0.307, 1.433, 0.145> <-0.307, 1.431, 0.081> <-0.307, 1.402, 0.010> 
		<-0.247, 1.438, 0.204> <-0.247, 1.437, 0.145> <-0.247, 1.435, 0.081> <-0.247, 1.406, 0.010> 
		<-0.167, 1.434, 0.204> <-0.167, 1.433, 0.145> <-0.167, 1.431, 0.081> <-0.167, 1.402, 0.010> 
		<-0.107, 1.434, 0.204> <-0.107, 1.433, 0.145> <-0.107, 1.431, 0.081> <-0.107, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.402, 0.010> <-0.307, 1.391, -0.017> <-0.307, 1.340, -0.050> <-0.307, 1.337, -0.030> 
		<-0.247, 1.406, 0.010> <-0.247, 1.394, -0.017> <-0.247, 1.340, -0.050> <-0.247, 1.337, -0.030> 
		<-0.167, 1.402, 0.010> <-0.167, 1.391, -0.017> <-0.167, 1.340, -0.050> <-0.167, 1.337, -0.030> 
		<-0.107, 1.402, 0.010> <-0.107, 1.391, -0.017> <-0.107, 1.340, -0.050> <-0.107, 1.337, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.337, -0.030> <-0.307, 1.322, 0.083> <-0.307, 1.352, 0.048> <-0.307, 1.347, 0.414> 
		<-0.247, 1.337, -0.030> <-0.247, 1.322, 0.083> <-0.247, 1.352, 0.048> <-0.247, 1.347, 0.414> 
		<-0.167, 1.337, -0.030> <-0.167, 1.322, 0.083> <-0.167, 1.352, 0.048> <-0.167, 1.347, 0.414> 
		<-0.107, 1.337, -0.030> <-0.107, 1.322, 0.083> <-0.107, 1.352, 0.048> <-0.107, 1.347, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.467, 0.982> <0.060, 0.467, 0.982> <0.141, 0.467, 0.982> <0.201, 0.467, 0.982> 
		<0.000, 0.475, 0.923> <0.060, 0.475, 0.923> <0.141, 0.475, 0.923> <0.201, 0.475, 0.923> 
		<0.000, 0.488, 0.949> <0.060, 0.488, 0.949> <0.141, 0.488, 0.949> <0.201, 0.488, 0.949> 
		<0.000, 0.492, 0.786> <0.060, 0.492, 0.786> <0.141, 0.492, 0.786> <0.201, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.467, 0.982> <0.000, 0.475, 0.923> <0.000, 0.488, 0.949> <0.000, 0.492, 0.786> 
		<-0.060, 0.467, 0.982> <-0.060, 0.475, 0.923> <-0.060, 0.488, 0.949> <-0.060, 0.492, 0.786> 
		<-0.140, 0.467, 0.982> <-0.140, 0.475, 0.923> <-0.140, 0.488, 0.949> <-0.140, 0.492, 0.786> 
		<-0.200, 0.467, 0.982> <-0.200, 0.475, 0.923> <-0.200, 0.488, 0.949> <-0.200, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.467, 0.982> <0.000, 0.485, 0.952> <0.000, 0.519, 0.917> <0.000, 0.527, 0.883> 
		<0.060, 0.467, 0.982> <0.060, 0.485, 0.952> <0.060, 0.519, 0.917> <0.060, 0.527, 0.883> 
		<0.141, 0.467, 0.982> <0.141, 0.483, 0.952> <0.141, 0.512, 0.916> <0.141, 0.519, 0.883> 
		<0.201, 0.467, 0.982> <0.201, 0.483, 0.952> <0.201, 0.512, 0.916> <0.201, 0.519, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.467, 0.982> <-0.060, 0.467, 0.982> <-0.140, 0.467, 0.982> <-0.200, 0.467, 0.982> 
		<0.000, 0.485, 0.952> <-0.060, 0.485, 0.952> <-0.140, 0.483, 0.952> <-0.200, 0.483, 0.952> 
		<0.000, 0.519, 0.917> <-0.060, 0.519, 0.917> <-0.140, 0.512, 0.916> <-0.200, 0.512, 0.916> 
		<0.000, 0.527, 0.883> <-0.060, 0.527, 0.883> <-0.140, 0.519, 0.883> <-0.200, 0.519, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.527, 0.883> <0.000, 0.548, 0.792> <0.000, 0.560, 0.668> <0.000, 0.564, 0.575> 
		<0.060, 0.527, 0.883> <0.060, 0.548, 0.792> <0.060, 0.560, 0.668> <0.060, 0.564, 0.575> 
		<0.141, 0.519, 0.883> <0.141, 0.539, 0.792> <0.141, 0.550, 0.668> <0.141, 0.555, 0.575> 
		<0.201, 0.519, 0.883> <0.201, 0.539, 0.792> <0.201, 0.551, 0.668> <0.201, 0.556, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.527, 0.883> <-0.060, 0.527, 0.883> <-0.140, 0.519, 0.883> <-0.200, 0.519, 0.883> 
		<0.000, 0.548, 0.792> <-0.060, 0.548, 0.792> <-0.140, 0.539, 0.792> <-0.200, 0.539, 0.792> 
		<0.000, 0.560, 0.668> <-0.060, 0.560, 0.668> <-0.140, 0.550, 0.668> <-0.200, 0.551, 0.668> 
		<0.000, 0.564, 0.575> <-0.060, 0.564, 0.575> <-0.140, 0.555, 0.575> <-0.200, 0.556, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.564, 0.575> <0.000, 0.566, 0.517> <0.000, 0.572, 0.453> <0.000, 0.547, 0.382> 
		<0.060, 0.564, 0.575> <0.060, 0.566, 0.517> <0.060, 0.572, 0.453> <0.060, 0.547, 0.382> 
		<0.141, 0.555, 0.575> <0.141, 0.558, 0.517> <0.141, 0.570, 0.454> <0.141, 0.547, 0.382> 
		<0.201, 0.556, 0.575> <0.201, 0.559, 0.517> <0.201, 0.570, 0.454> <0.201, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.564, 0.575> <-0.060, 0.564, 0.575> <-0.140, 0.555, 0.575> <-0.200, 0.556, 0.575> 
		<0.000, 0.566, 0.517> <-0.060, 0.566, 0.517> <-0.140, 0.558, 0.517> <-0.200, 0.559, 0.517> 
		<0.000, 0.572, 0.453> <-0.060, 0.572, 0.453> <-0.140, 0.570, 0.454> <-0.200, 0.570, 0.454> 
		<0.000, 0.547, 0.382> <-0.060, 0.547, 0.382> <-0.140, 0.547, 0.382> <-0.200, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.547, 0.382> <0.000, 0.538, 0.354> <0.000, 0.485, 0.322> <0.000, 0.483, 0.341> 
		<0.060, 0.547, 0.382> <0.060, 0.538, 0.354> <0.060, 0.485, 0.322> <0.060, 0.483, 0.341> 
		<0.141, 0.547, 0.382> <0.141, 0.538, 0.353> <0.141, 0.485, 0.322> <0.141, 0.483, 0.341> 
		<0.201, 0.547, 0.382> <0.201, 0.538, 0.353> <0.201, 0.485, 0.322> <0.201, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.547, 0.382> <-0.060, 0.547, 0.382> <-0.140, 0.547, 0.382> <-0.200, 0.547, 0.382> 
		<0.000, 0.538, 0.354> <-0.060, 0.538, 0.354> <-0.140, 0.538, 0.353> <-0.200, 0.538, 0.353> 
		<0.000, 0.485, 0.322> <-0.060, 0.485, 0.322> <-0.140, 0.485, 0.322> <-0.200, 0.485, 0.322> 
		<0.000, 0.483, 0.341> <-0.060, 0.483, 0.341> <-0.140, 0.483, 0.341> <-0.200, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.483, 0.341> <0.000, 0.467, 0.455> <0.000, 0.501, 0.420> <0.000, 0.492, 0.786> 
		<0.060, 0.483, 0.341> <0.060, 0.467, 0.455> <0.060, 0.501, 0.420> <0.060, 0.492, 0.786> 
		<0.141, 0.483, 0.341> <0.141, 0.467, 0.455> <0.141, 0.501, 0.420> <0.141, 0.492, 0.786> 
		<0.201, 0.483, 0.341> <0.201, 0.467, 0.455> <0.201, 0.501, 0.420> <0.201, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.483, 0.341> <-0.060, 0.483, 0.341> <-0.140, 0.483, 0.341> <-0.200, 0.483, 0.341> 
		<0.000, 0.467, 0.455> <-0.060, 0.467, 0.455> <-0.140, 0.467, 0.455> <-0.200, 0.467, 0.455> 
		<0.000, 0.501, 0.420> <-0.060, 0.501, 0.420> <-0.140, 0.501, 0.420> <-0.200, 0.501, 0.420> 
		<0.000, 0.492, 0.786> <-0.060, 0.492, 0.786> <-0.140, 0.492, 0.786> <-0.200, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.467, 0.982> <0.261, 0.467, 0.982> <0.341, 0.467, 0.982> <0.401, 0.467, 0.982> 
		<0.201, 0.475, 0.923> <0.261, 0.475, 0.923> <0.341, 0.475, 0.923> <0.401, 0.475, 0.923> 
		<0.201, 0.488, 0.949> <0.261, 0.488, 0.949> <0.341, 0.488, 0.949> <0.401, 0.488, 0.949> 
		<0.201, 0.492, 0.786> <0.261, 0.492, 0.786> <0.341, 0.492, 0.786> <0.401, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.467, 0.982> <0.201, 0.483, 0.952> <0.201, 0.512, 0.916> <0.201, 0.519, 0.883> 
		<0.261, 0.467, 0.982> <0.261, 0.483, 0.952> <0.261, 0.512, 0.916> <0.261, 0.519, 0.883> 
		<0.341, 0.467, 0.982> <0.341, 0.485, 0.952> <0.341, 0.516, 0.916> <0.341, 0.524, 0.883> 
		<0.401, 0.467, 0.982> <0.401, 0.485, 0.952> <0.401, 0.518, 0.916> <0.401, 0.527, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.519, 0.883> <0.201, 0.539, 0.792> <0.201, 0.551, 0.668> <0.201, 0.556, 0.575> 
		<0.261, 0.519, 0.883> <0.261, 0.539, 0.792> <0.261, 0.552, 0.668> <0.261, 0.557, 0.575> 
		<0.341, 0.524, 0.883> <0.341, 0.548, 0.792> <0.341, 0.564, 0.668> <0.341, 0.568, 0.575> 
		<0.401, 0.527, 0.883> <0.401, 0.550, 0.792> <0.401, 0.568, 0.668> <0.401, 0.572, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.556, 0.575> <0.201, 0.559, 0.517> <0.201, 0.570, 0.454> <0.201, 0.547, 0.382> 
		<0.261, 0.557, 0.575> <0.261, 0.561, 0.517> <0.261, 0.570, 0.454> <0.261, 0.547, 0.382> 
		<0.341, 0.568, 0.575> <0.341, 0.571, 0.517> <0.341, 0.574, 0.453> <0.341, 0.547, 0.382> 
		<0.401, 0.572, 0.575> <0.401, 0.574, 0.517> <0.401, 0.574, 0.453> <0.401, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.547, 0.382> <0.201, 0.538, 0.353> <0.201, 0.485, 0.322> <0.201, 0.483, 0.341> 
		<0.261, 0.547, 0.382> <0.261, 0.538, 0.353> <0.261, 0.485, 0.322> <0.261, 0.483, 0.341> 
		<0.341, 0.547, 0.382> <0.341, 0.537, 0.354> <0.341, 0.485, 0.322> <0.341, 0.483, 0.341> 
		<0.401, 0.547, 0.382> <0.401, 0.537, 0.354> <0.401, 0.485, 0.322> <0.401, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.483, 0.341> <0.201, 0.467, 0.455> <0.201, 0.501, 0.420> <0.201, 0.492, 0.786> 
		<0.261, 0.483, 0.341> <0.261, 0.467, 0.455> <0.261, 0.501, 0.420> <0.261, 0.492, 0.786> 
		<0.341, 0.483, 0.341> <0.341, 0.467, 0.455> <0.341, 0.501, 0.420> <0.341, 0.492, 0.786> 
		<0.401, 0.483, 0.341> <0.401, 0.467, 0.455> <0.401, 0.501, 0.420> <0.401, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, 0.467, 0.982> <0.461, 0.467, 0.982> <0.541, 0.467, 0.978> <0.601, 0.467, 0.982> 
		<0.401, 0.475, 0.923> <0.461, 0.475, 0.923> <0.541, 0.475, 0.919> <0.601, 0.475, 0.923> 
		<0.401, 0.488, 0.949> <0.461, 0.488, 0.949> <0.541, 0.488, 0.949> <0.601, 0.488, 0.949> 
		<0.401, 0.492, 0.786> <0.461, 0.492, 0.786> <0.541, 0.492, 0.786> <0.601, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, 0.467, 0.982> <0.401, 0.485, 0.952> <0.401, 0.518, 0.916> <0.401, 0.527, 0.883> 
		<0.461, 0.467, 0.982> <0.461, 0.485, 0.952> <0.461, 0.520, 0.916> <0.461, 0.529, 0.883> 
		<0.541, 0.467, 0.978> <0.541, 0.488, 0.948> <0.541, 0.520, 0.917> <0.541, 0.530, 0.883> 
		<0.601, 0.467, 0.982> <0.601, 0.488, 0.952> <0.601, 0.525, 0.917> <0.601, 0.535, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, 0.527, 0.883> <0.401, 0.550, 0.792> <0.401, 0.568, 0.668> <0.401, 0.572, 0.575> 
		<0.461, 0.529, 0.883> <0.461, 0.552, 0.792> <0.461, 0.572, 0.668> <0.461, 0.575, 0.575> 
		<0.541, 0.530, 0.883> <0.541, 0.555, 0.793> <0.541, 0.576, 0.668> <0.541, 0.579, 0.575> 
		<0.601, 0.535, 0.883> <0.601, 0.559, 0.793> <0.601, 0.577, 0.668> <0.601, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, 0.572, 0.575> <0.401, 0.574, 0.517> <0.401, 0.574, 0.453> <0.401, 0.547, 0.382> 
		<0.461, 0.575, 0.575> <0.461, 0.578, 0.517> <0.461, 0.574, 0.453> <0.461, 0.547, 0.382> 
		<0.541, 0.579, 0.575> <0.541, 0.580, 0.516> <0.541, 0.577, 0.452> <0.541, 0.547, 0.382> 
		<0.601, 0.580, 0.575> <0.601, 0.581, 0.516> <0.601, 0.577, 0.452> <0.601, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, 0.547, 0.382> <0.401, 0.537, 0.354> <0.401, 0.485, 0.322> <0.401, 0.483, 0.341> 
		<0.461, 0.547, 0.382> <0.461, 0.537, 0.354> <0.461, 0.485, 0.322> <0.461, 0.483, 0.341> 
		<0.541, 0.547, 0.382> <0.541, 0.536, 0.354> <0.541, 0.485, 0.322> <0.541, 0.483, 0.341> 
		<0.601, 0.547, 0.382> <0.601, 0.536, 0.354> <0.601, 0.485, 0.322> <0.601, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, 0.483, 0.341> <0.401, 0.467, 0.455> <0.401, 0.501, 0.420> <0.401, 0.492, 0.786> 
		<0.461, 0.483, 0.341> <0.461, 0.467, 0.455> <0.461, 0.501, 0.420> <0.461, 0.492, 0.786> 
		<0.541, 0.483, 0.341> <0.541, 0.467, 0.455> <0.541, 0.501, 0.420> <0.541, 0.492, 0.786> 
		<0.601, 0.483, 0.341> <0.601, 0.467, 0.455> <0.601, 0.501, 0.420> <0.601, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.601, 0.467, 0.982> <0.661, 0.467, 0.986> <0.744, 0.467, 0.986> <0.801, 0.467, 1.007> 
		<0.601, 0.475, 0.923> <0.661, 0.475, 0.927> <0.744, 0.475, 0.919> <0.801, 0.475, 0.941> 
		<0.601, 0.488, 0.949> <0.661, 0.488, 0.949> <0.741, 0.488, 0.969> <0.801, 0.488, 0.969> 
		<0.601, 0.492, 0.786> <0.661, 0.492, 0.786> <0.741, 0.492, 0.786> <0.801, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.601, 0.467, 0.982> <0.601, 0.488, 0.952> <0.601, 0.525, 0.917> <0.601, 0.535, 0.883> 
		<0.661, 0.467, 0.986> <0.661, 0.488, 0.956> <0.661, 0.530, 0.917> <0.661, 0.539, 0.883> 
		<0.744, 0.467, 0.986> <0.744, 0.495, 0.948> <0.741, 0.543, 0.927> <0.741, 0.555, 0.883> 
		<0.801, 0.467, 1.007> <0.801, 0.495, 0.970> <0.801, 0.547, 0.927> <0.801, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.601, 0.535, 0.883> <0.601, 0.559, 0.793> <0.601, 0.577, 0.668> <0.601, 0.580, 0.575> 
		<0.661, 0.539, 0.883> <0.661, 0.564, 0.793> <0.661, 0.579, 0.668> <0.661, 0.581, 0.575> 
		<0.741, 0.555, 0.883> <0.741, 0.578, 0.793> <0.741, 0.582, 0.668> <0.741, 0.580, 0.575> 
		<0.801, 0.558, 0.883> <0.801, 0.581, 0.793> <0.801, 0.582, 0.668> <0.801, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.601, 0.580, 0.575> <0.601, 0.581, 0.516> <0.601, 0.577, 0.452> <0.601, 0.547, 0.382> 
		<0.661, 0.581, 0.575> <0.661, 0.582, 0.516> <0.661, 0.577, 0.452> <0.661, 0.547, 0.382> 
		<0.741, 0.580, 0.575> <0.741, 0.578, 0.516> <0.741, 0.577, 0.452> <0.741, 0.547, 0.382> 
		<0.801, 0.580, 0.575> <0.801, 0.578, 0.516> <0.801, 0.577, 0.452> <0.801, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.601, 0.547, 0.382> <0.601, 0.536, 0.354> <0.601, 0.485, 0.322> <0.601, 0.483, 0.341> 
		<0.661, 0.547, 0.382> <0.661, 0.536, 0.354> <0.661, 0.485, 0.322> <0.661, 0.483, 0.341> 
		<0.741, 0.547, 0.382> <0.741, 0.536, 0.354> <0.741, 0.485, 0.322> <0.741, 0.483, 0.341> 
		<0.801, 0.547, 0.382> <0.801, 0.536, 0.354> <0.801, 0.485, 0.322> <0.801, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.601, 0.483, 0.341> <0.601, 0.467, 0.455> <0.601, 0.501, 0.420> <0.601, 0.492, 0.786> 
		<0.661, 0.483, 0.341> <0.661, 0.467, 0.455> <0.661, 0.501, 0.420> <0.661, 0.492, 0.786> 
		<0.741, 0.483, 0.341> <0.741, 0.467, 0.455> <0.741, 0.500, 0.420> <0.741, 0.492, 0.786> 
		<0.801, 0.483, 0.341> <0.801, 0.467, 0.455> <0.801, 0.500, 0.420> <0.801, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.801, 0.467, 1.007> <0.867, 0.467, 1.032> <0.945, 0.467, 1.088> <1.001, 0.467, 1.132> 
		<0.801, 0.475, 0.941> <0.867, 0.475, 0.966> <0.945, 0.475, 0.984> <1.001, 0.475, 1.028> 
		<0.801, 0.488, 0.969> <0.861, 0.488, 0.969> <0.941, 0.486, 1.072> <1.001, 0.486, 1.072> 
		<0.801, 0.492, 0.786> <0.861, 0.492, 0.786> <0.941, 0.492, 0.786> <1.001, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.801, 0.467, 1.007> <0.801, 0.495, 0.970> <0.801, 0.547, 0.927> <0.801, 0.558, 0.883> 
		<0.867, 0.467, 1.032> <0.867, 0.495, 0.995> <0.861, 0.550, 0.927> <0.861, 0.562, 0.883> 
		<0.945, 0.467, 1.088> <0.945, 0.495, 1.013> <0.941, 0.546, 0.961> <0.941, 0.562, 0.883> 
		<1.001, 0.467, 1.132> <1.001, 0.495, 1.057> <1.001, 0.542, 0.961> <1.001, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.801, 0.558, 0.883> <0.801, 0.581, 0.793> <0.801, 0.582, 0.668> <0.801, 0.580, 0.575> 
		<0.861, 0.562, 0.883> <0.861, 0.585, 0.793> <0.861, 0.582, 0.668> <0.861, 0.580, 0.575> 
		<0.941, 0.562, 0.883> <0.941, 0.580, 0.792> <0.941, 0.586, 0.668> <0.941, 0.584, 0.575> 
		<1.001, 0.558, 0.883> <1.001, 0.576, 0.792> <1.001, 0.582, 0.668> <1.001, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.801, 0.580, 0.575> <0.801, 0.578, 0.516> <0.801, 0.577, 0.452> <0.801, 0.547, 0.382> 
		<0.861, 0.580, 0.575> <0.861, 0.578, 0.516> <0.861, 0.577, 0.452> <0.861, 0.547, 0.382> 
		<0.941, 0.584, 0.575> <0.941, 0.582, 0.516> <0.941, 0.580, 0.452> <0.941, 0.551, 0.382> 
		<1.001, 0.580, 0.575> <1.001, 0.578, 0.516> <1.001, 0.577, 0.452> <1.001, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.801, 0.547, 0.382> <0.801, 0.536, 0.354> <0.801, 0.485, 0.322> <0.801, 0.483, 0.341> 
		<0.861, 0.547, 0.382> <0.861, 0.536, 0.354> <0.861, 0.485, 0.322> <0.861, 0.483, 0.341> 
		<0.941, 0.551, 0.382> <0.941, 0.540, 0.354> <0.941, 0.485, 0.322> <0.941, 0.483, 0.341> 
		<1.001, 0.547, 0.382> <1.001, 0.536, 0.354> <1.001, 0.485, 0.322> <1.001, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.801, 0.483, 0.341> <0.801, 0.467, 0.455> <0.801, 0.500, 0.420> <0.801, 0.492, 0.786> 
		<0.861, 0.483, 0.341> <0.861, 0.467, 0.455> <0.861, 0.500, 0.420> <0.861, 0.492, 0.786> 
		<0.941, 0.483, 0.341> <0.941, 0.467, 0.455> <0.941, 0.499, 0.420> <0.941, 0.492, 0.786> 
		<1.001, 0.483, 0.341> <1.001, 0.467, 0.455> <1.001, 0.499, 0.420> <1.001, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.001, 0.467, 1.132> <1.066, 0.467, 1.184> <1.127, 0.467, 1.286> <1.201, 0.467, 1.325> 
		<1.001, 0.475, 1.028> <1.066, 0.475, 1.080> <1.127, 0.475, 1.124> <1.201, 0.475, 1.163> 
		<1.001, 0.486, 1.072> <1.061, 0.486, 1.072> <1.141, 0.485, 1.230> <1.201, 0.485, 1.230> 
		<1.001, 0.492, 0.786> <1.061, 0.492, 0.786> <1.141, 0.492, 0.786> <1.201, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.001, 0.467, 1.132> <1.001, 0.495, 1.057> <1.001, 0.542, 0.961> <1.001, 0.558, 0.883> 
		<1.066, 0.467, 1.184> <1.066, 0.495, 1.109> <1.061, 0.539, 0.961> <1.061, 0.554, 0.883> 
		<1.127, 0.467, 1.286> <1.127, 0.487, 1.154> <1.140, 0.517, 1.016> <1.140, 0.533, 0.883> 
		<1.201, 0.467, 1.325> <1.201, 0.487, 1.192> <1.201, 0.517, 1.016> <1.201, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.001, 0.558, 0.883> <1.001, 0.576, 0.792> <1.001, 0.582, 0.668> <1.001, 0.580, 0.575> 
		<1.061, 0.554, 0.883> <1.061, 0.573, 0.792> <1.061, 0.578, 0.668> <1.061, 0.576, 0.575> 
		<1.140, 0.533, 0.883> <1.140, 0.543, 0.791> <1.140, 0.556, 0.668> <1.140, 0.554, 0.575> 
		<1.201, 0.533, 0.883> <1.201, 0.543, 0.791> <1.201, 0.556, 0.668> <1.201, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.001, 0.580, 0.575> <1.001, 0.578, 0.516> <1.001, 0.577, 0.452> <1.001, 0.547, 0.382> 
		<1.061, 0.576, 0.575> <1.061, 0.575, 0.516> <1.061, 0.573, 0.452> <1.061, 0.543, 0.382> 
		<1.140, 0.554, 0.575> <1.140, 0.553, 0.516> <1.140, 0.544, 0.455> <1.140, 0.522, 0.382> 
		<1.201, 0.554, 0.575> <1.201, 0.553, 0.516> <1.201, 0.544, 0.455> <1.201, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.001, 0.547, 0.382> <1.001, 0.536, 0.354> <1.001, 0.485, 0.322> <1.001, 0.483, 0.341> 
		<1.061, 0.543, 0.382> <1.061, 0.532, 0.354> <1.061, 0.485, 0.322> <1.061, 0.483, 0.341> 
		<1.140, 0.522, 0.382> <1.140, 0.515, 0.361> <1.141, 0.484, 0.327> <1.141, 0.483, 0.341> 
		<1.201, 0.522, 0.382> <1.201, 0.515, 0.361> <1.201, 0.484, 0.327> <1.201, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.001, 0.483, 0.341> <1.001, 0.467, 0.455> <1.001, 0.499, 0.420> <1.001, 0.492, 0.786> 
		<1.061, 0.483, 0.341> <1.061, 0.467, 0.455> <1.061, 0.499, 0.420> <1.061, 0.492, 0.786> 
		<1.141, 0.483, 0.341> <1.141, 0.474, 0.455> <1.141, 0.498, 0.420> <1.141, 0.492, 0.786> 
		<1.201, 0.483, 0.341> <1.201, 0.474, 0.455> <1.201, 0.498, 0.420> <1.201, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, 0.467, 1.325> <1.254, 0.467, 1.352> <1.341, 0.467, 1.341> <1.401, 0.467, 1.341> 
		<1.201, 0.475, 1.163> <1.254, 0.475, 1.191> <1.341, 0.475, 1.175> <1.401, 0.475, 1.175> 
		<1.201, 0.485, 1.230> <1.261, 0.485, 1.230> <1.341, 0.485, 1.244> <1.401, 0.485, 1.244> 
		<1.201, 0.492, 0.786> <1.261, 0.492, 0.786> <1.341, 0.492, 0.786> <1.401, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, 0.467, 1.325> <1.201, 0.487, 1.192> <1.201, 0.517, 1.016> <1.201, 0.533, 0.883> 
		<1.254, 0.467, 1.352> <1.254, 0.487, 1.220> <1.261, 0.517, 1.016> <1.261, 0.533, 0.883> 
		<1.341, 0.467, 1.341> <1.341, 0.495, 1.204> <1.340, 0.538, 1.022> <1.340, 0.558, 0.883> 
		<1.401, 0.467, 1.341> <1.401, 0.495, 1.204> <1.401, 0.538, 1.022> <1.401, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, 0.533, 0.883> <1.201, 0.543, 0.791> <1.201, 0.556, 0.668> <1.201, 0.554, 0.575> 
		<1.261, 0.533, 0.883> <1.261, 0.543, 0.791> <1.261, 0.556, 0.668> <1.261, 0.554, 0.575> 
		<1.340, 0.558, 0.883> <1.340, 0.572, 0.791> <1.340, 0.582, 0.668> <1.340, 0.580, 0.575> 
		<1.401, 0.558, 0.883> <1.401, 0.572, 0.791> <1.401, 0.582, 0.668> <1.401, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, 0.554, 0.575> <1.201, 0.553, 0.516> <1.201, 0.544, 0.455> <1.201, 0.522, 0.382> 
		<1.261, 0.554, 0.575> <1.261, 0.553, 0.516> <1.261, 0.544, 0.455> <1.261, 0.522, 0.382> 
		<1.340, 0.580, 0.575> <1.340, 0.578, 0.516> <1.340, 0.577, 0.452> <1.340, 0.547, 0.382> 
		<1.401, 0.580, 0.575> <1.401, 0.578, 0.516> <1.401, 0.577, 0.452> <1.401, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, 0.522, 0.382> <1.201, 0.515, 0.361> <1.201, 0.484, 0.327> <1.201, 0.483, 0.341> 
		<1.261, 0.522, 0.382> <1.261, 0.515, 0.361> <1.261, 0.484, 0.327> <1.261, 0.483, 0.341> 
		<1.340, 0.547, 0.382> <1.340, 0.536, 0.354> <1.341, 0.485, 0.322> <1.341, 0.483, 0.341> 
		<1.401, 0.547, 0.382> <1.401, 0.536, 0.354> <1.401, 0.485, 0.322> <1.401, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.201, 0.483, 0.341> <1.201, 0.474, 0.455> <1.201, 0.498, 0.420> <1.201, 0.492, 0.786> 
		<1.261, 0.483, 0.341> <1.261, 0.474, 0.455> <1.261, 0.498, 0.420> <1.261, 0.492, 0.786> 
		<1.341, 0.483, 0.341> <1.341, 0.467, 0.455> <1.341, 0.498, 0.420> <1.341, 0.492, 0.786> 
		<1.401, 0.483, 0.341> <1.401, 0.467, 0.455> <1.401, 0.498, 0.420> <1.401, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 0.467, 1.341> <1.461, 0.467, 1.341> <1.541, 0.467, 1.324> <1.601, 0.467, 1.324> 
		<1.401, 0.475, 1.175> <1.461, 0.475, 1.175> <1.541, 0.475, 1.163> <1.601, 0.475, 1.163> 
		<1.401, 0.485, 1.244> <1.461, 0.485, 1.244> <1.541, 0.485, 1.230> <1.601, 0.485, 1.230> 
		<1.401, 0.492, 0.786> <1.461, 0.492, 0.786> <1.541, 0.492, 0.786> <1.601, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 0.467, 1.341> <1.401, 0.495, 1.204> <1.401, 0.538, 1.022> <1.401, 0.558, 0.883> 
		<1.461, 0.467, 1.341> <1.461, 0.495, 1.204> <1.461, 0.538, 1.022> <1.461, 0.558, 0.883> 
		<1.541, 0.467, 1.324> <1.541, 0.487, 1.192> <1.540, 0.517, 1.016> <1.540, 0.533, 0.883> 
		<1.601, 0.467, 1.324> <1.601, 0.487, 1.192> <1.601, 0.517, 1.016> <1.601, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 0.558, 0.883> <1.401, 0.572, 0.791> <1.401, 0.582, 0.668> <1.401, 0.580, 0.575> 
		<1.461, 0.558, 0.883> <1.461, 0.572, 0.791> <1.461, 0.582, 0.668> <1.461, 0.580, 0.575> 
		<1.540, 0.533, 0.883> <1.540, 0.543, 0.791> <1.540, 0.556, 0.668> <1.540, 0.554, 0.575> 
		<1.601, 0.533, 0.883> <1.601, 0.543, 0.791> <1.601, 0.556, 0.668> <1.601, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 0.580, 0.575> <1.401, 0.578, 0.516> <1.401, 0.577, 0.452> <1.401, 0.547, 0.382> 
		<1.461, 0.580, 0.575> <1.461, 0.578, 0.516> <1.461, 0.577, 0.452> <1.461, 0.547, 0.382> 
		<1.540, 0.554, 0.575> <1.540, 0.553, 0.516> <1.540, 0.544, 0.455> <1.540, 0.522, 0.382> 
		<1.601, 0.554, 0.575> <1.601, 0.553, 0.516> <1.601, 0.544, 0.455> <1.601, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 0.547, 0.382> <1.401, 0.536, 0.354> <1.401, 0.485, 0.322> <1.401, 0.483, 0.341> 
		<1.461, 0.547, 0.382> <1.461, 0.536, 0.354> <1.461, 0.485, 0.322> <1.461, 0.483, 0.341> 
		<1.540, 0.522, 0.382> <1.540, 0.515, 0.361> <1.541, 0.484, 0.327> <1.541, 0.483, 0.341> 
		<1.601, 0.522, 0.382> <1.601, 0.515, 0.361> <1.601, 0.484, 0.327> <1.601, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 0.483, 0.341> <1.401, 0.467, 0.455> <1.401, 0.498, 0.420> <1.401, 0.492, 0.786> 
		<1.461, 0.483, 0.341> <1.461, 0.467, 0.455> <1.461, 0.498, 0.420> <1.461, 0.492, 0.786> 
		<1.541, 0.483, 0.341> <1.541, 0.474, 0.455> <1.541, 0.498, 0.420> <1.541, 0.492, 0.786> 
		<1.601, 0.483, 0.341> <1.601, 0.474, 0.455> <1.601, 0.498, 0.420> <1.601, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.601, 0.467, 1.324> <1.661, 0.467, 1.324> <1.741, 0.467, 1.341> <1.801, 0.467, 1.341> 
		<1.601, 0.475, 1.163> <1.661, 0.475, 1.163> <1.741, 0.475, 1.175> <1.801, 0.475, 1.175> 
		<1.601, 0.485, 1.230> <1.661, 0.485, 1.230> <1.741, 0.485, 1.244> <1.801, 0.485, 1.244> 
		<1.601, 0.492, 0.786> <1.661, 0.492, 0.786> <1.741, 0.492, 0.786> <1.801, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.601, 0.467, 1.324> <1.601, 0.487, 1.192> <1.601, 0.517, 1.016> <1.601, 0.533, 0.883> 
		<1.661, 0.467, 1.324> <1.661, 0.487, 1.192> <1.661, 0.517, 1.016> <1.661, 0.533, 0.883> 
		<1.741, 0.467, 1.341> <1.741, 0.495, 1.204> <1.740, 0.538, 1.022> <1.740, 0.558, 0.883> 
		<1.801, 0.467, 1.341> <1.801, 0.495, 1.204> <1.801, 0.538, 1.022> <1.801, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.601, 0.533, 0.883> <1.601, 0.543, 0.791> <1.601, 0.556, 0.668> <1.601, 0.554, 0.575> 
		<1.661, 0.533, 0.883> <1.661, 0.543, 0.791> <1.661, 0.556, 0.668> <1.661, 0.554, 0.575> 
		<1.740, 0.558, 0.883> <1.740, 0.572, 0.791> <1.740, 0.582, 0.668> <1.740, 0.580, 0.575> 
		<1.801, 0.558, 0.883> <1.801, 0.572, 0.791> <1.801, 0.582, 0.668> <1.801, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.601, 0.554, 0.575> <1.601, 0.553, 0.516> <1.601, 0.544, 0.455> <1.601, 0.522, 0.382> 
		<1.661, 0.554, 0.575> <1.661, 0.553, 0.516> <1.661, 0.544, 0.455> <1.661, 0.522, 0.382> 
		<1.740, 0.580, 0.575> <1.740, 0.578, 0.516> <1.740, 0.577, 0.452> <1.740, 0.547, 0.382> 
		<1.801, 0.580, 0.575> <1.801, 0.578, 0.516> <1.801, 0.577, 0.452> <1.801, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.601, 0.522, 0.382> <1.601, 0.515, 0.361> <1.601, 0.484, 0.327> <1.601, 0.483, 0.341> 
		<1.661, 0.522, 0.382> <1.661, 0.515, 0.361> <1.661, 0.484, 0.327> <1.661, 0.483, 0.341> 
		<1.740, 0.547, 0.382> <1.740, 0.536, 0.354> <1.741, 0.485, 0.322> <1.741, 0.483, 0.341> 
		<1.801, 0.547, 0.382> <1.801, 0.536, 0.354> <1.801, 0.485, 0.322> <1.801, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.601, 0.483, 0.341> <1.601, 0.474, 0.455> <1.601, 0.498, 0.420> <1.601, 0.492, 0.786> 
		<1.661, 0.483, 0.341> <1.661, 0.474, 0.455> <1.661, 0.498, 0.420> <1.661, 0.492, 0.786> 
		<1.741, 0.483, 0.341> <1.741, 0.467, 0.455> <1.741, 0.498, 0.420> <1.741, 0.492, 0.786> 
		<1.801, 0.483, 0.341> <1.801, 0.467, 0.455> <1.801, 0.498, 0.420> <1.801, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.801, 0.467, 1.341> <1.861, 0.467, 1.341> <1.941, 0.467, 1.324> <2.001, 0.467, 1.324> 
		<1.801, 0.475, 1.175> <1.861, 0.475, 1.175> <1.941, 0.475, 1.163> <2.001, 0.475, 1.163> 
		<1.801, 0.485, 1.244> <1.861, 0.485, 1.244> <1.941, 0.485, 1.230> <2.001, 0.485, 1.230> 
		<1.801, 0.492, 0.786> <1.861, 0.492, 0.786> <1.941, 0.492, 0.786> <2.001, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.801, 0.467, 1.341> <1.801, 0.495, 1.204> <1.801, 0.538, 1.022> <1.801, 0.558, 0.883> 
		<1.861, 0.467, 1.341> <1.861, 0.495, 1.204> <1.861, 0.538, 1.022> <1.861, 0.558, 0.883> 
		<1.941, 0.467, 1.324> <1.941, 0.487, 1.192> <1.940, 0.517, 1.016> <1.940, 0.533, 0.883> 
		<2.001, 0.467, 1.324> <2.001, 0.487, 1.192> <2.001, 0.517, 1.016> <2.001, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.801, 0.558, 0.883> <1.801, 0.572, 0.791> <1.801, 0.582, 0.668> <1.801, 0.580, 0.575> 
		<1.861, 0.558, 0.883> <1.861, 0.572, 0.791> <1.861, 0.582, 0.668> <1.861, 0.580, 0.575> 
		<1.940, 0.533, 0.883> <1.940, 0.543, 0.791> <1.940, 0.556, 0.668> <1.940, 0.554, 0.575> 
		<2.001, 0.533, 0.883> <2.001, 0.543, 0.791> <2.001, 0.556, 0.668> <2.001, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.801, 0.580, 0.575> <1.801, 0.578, 0.516> <1.801, 0.577, 0.452> <1.801, 0.547, 0.382> 
		<1.861, 0.580, 0.575> <1.861, 0.578, 0.516> <1.861, 0.577, 0.452> <1.861, 0.547, 0.382> 
		<1.940, 0.554, 0.575> <1.940, 0.553, 0.516> <1.940, 0.544, 0.455> <1.940, 0.522, 0.382> 
		<2.001, 0.554, 0.575> <2.001, 0.553, 0.516> <2.001, 0.544, 0.455> <2.001, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.801, 0.547, 0.382> <1.801, 0.536, 0.354> <1.801, 0.485, 0.322> <1.801, 0.483, 0.341> 
		<1.861, 0.547, 0.382> <1.861, 0.536, 0.354> <1.861, 0.485, 0.322> <1.861, 0.483, 0.341> 
		<1.940, 0.522, 0.382> <1.940, 0.515, 0.361> <1.941, 0.484, 0.327> <1.941, 0.483, 0.341> 
		<2.001, 0.522, 0.382> <2.001, 0.515, 0.361> <2.001, 0.484, 0.327> <2.001, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.801, 0.483, 0.341> <1.801, 0.467, 0.455> <1.801, 0.498, 0.420> <1.801, 0.492, 0.786> 
		<1.861, 0.483, 0.341> <1.861, 0.467, 0.455> <1.861, 0.498, 0.420> <1.861, 0.492, 0.786> 
		<1.941, 0.483, 0.341> <1.941, 0.474, 0.455> <1.941, 0.498, 0.420> <1.941, 0.492, 0.786> 
		<2.001, 0.483, 0.341> <2.001, 0.474, 0.455> <2.001, 0.498, 0.420> <2.001, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.001, 0.467, 1.324> <2.061, 0.467, 1.324> <2.141, 0.467, 1.341> <2.201, 0.467, 1.341> 
		<2.001, 0.475, 1.163> <2.061, 0.475, 1.163> <2.141, 0.475, 1.175> <2.201, 0.475, 1.175> 
		<2.001, 0.485, 1.230> <2.061, 0.485, 1.230> <2.141, 0.485, 1.244> <2.201, 0.485, 1.244> 
		<2.001, 0.492, 0.786> <2.061, 0.492, 0.786> <2.141, 0.492, 0.786> <2.201, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.001, 0.467, 1.324> <2.001, 0.487, 1.192> <2.001, 0.517, 1.016> <2.001, 0.533, 0.883> 
		<2.061, 0.467, 1.324> <2.061, 0.487, 1.192> <2.061, 0.517, 1.016> <2.061, 0.533, 0.883> 
		<2.141, 0.467, 1.341> <2.141, 0.495, 1.204> <2.140, 0.538, 1.022> <2.140, 0.558, 0.883> 
		<2.201, 0.467, 1.341> <2.201, 0.495, 1.204> <2.201, 0.538, 1.022> <2.201, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.001, 0.533, 0.883> <2.001, 0.543, 0.791> <2.001, 0.556, 0.668> <2.001, 0.554, 0.575> 
		<2.061, 0.533, 0.883> <2.061, 0.543, 0.791> <2.061, 0.556, 0.668> <2.061, 0.554, 0.575> 
		<2.140, 0.558, 0.883> <2.140, 0.572, 0.791> <2.140, 0.582, 0.668> <2.140, 0.580, 0.575> 
		<2.201, 0.558, 0.883> <2.201, 0.572, 0.791> <2.201, 0.582, 0.668> <2.201, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.001, 0.554, 0.575> <2.001, 0.553, 0.516> <2.001, 0.544, 0.455> <2.001, 0.522, 0.382> 
		<2.061, 0.554, 0.575> <2.061, 0.553, 0.516> <2.061, 0.544, 0.455> <2.061, 0.522, 0.382> 
		<2.140, 0.580, 0.575> <2.140, 0.578, 0.516> <2.140, 0.577, 0.452> <2.140, 0.547, 0.382> 
		<2.201, 0.580, 0.575> <2.201, 0.578, 0.516> <2.201, 0.577, 0.452> <2.201, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.001, 0.522, 0.382> <2.001, 0.515, 0.361> <2.001, 0.484, 0.327> <2.001, 0.483, 0.341> 
		<2.061, 0.522, 0.382> <2.061, 0.515, 0.361> <2.061, 0.484, 0.327> <2.061, 0.483, 0.341> 
		<2.140, 0.547, 0.382> <2.140, 0.536, 0.354> <2.141, 0.485, 0.322> <2.141, 0.483, 0.341> 
		<2.201, 0.547, 0.382> <2.201, 0.536, 0.354> <2.201, 0.485, 0.322> <2.201, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.001, 0.483, 0.341> <2.001, 0.474, 0.455> <2.001, 0.498, 0.420> <2.001, 0.492, 0.786> 
		<2.061, 0.483, 0.341> <2.061, 0.474, 0.455> <2.061, 0.498, 0.420> <2.061, 0.492, 0.786> 
		<2.141, 0.483, 0.341> <2.141, 0.467, 0.455> <2.141, 0.498, 0.420> <2.141, 0.492, 0.786> 
		<2.201, 0.483, 0.341> <2.201, 0.467, 0.455> <2.201, 0.498, 0.420> <2.201, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, 0.467, 1.341> <2.261, 0.467, 1.341> <2.341, 0.467, 1.324> <2.401, 0.467, 1.324> 
		<2.201, 0.475, 1.175> <2.261, 0.475, 1.175> <2.341, 0.475, 1.163> <2.401, 0.475, 1.163> 
		<2.201, 0.485, 1.244> <2.261, 0.485, 1.244> <2.341, 0.485, 1.230> <2.401, 0.485, 1.230> 
		<2.201, 0.492, 0.786> <2.261, 0.492, 0.786> <2.341, 0.492, 0.786> <2.401, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, 0.467, 1.341> <2.201, 0.495, 1.204> <2.201, 0.538, 1.022> <2.201, 0.558, 0.883> 
		<2.261, 0.467, 1.341> <2.261, 0.495, 1.204> <2.261, 0.538, 1.022> <2.261, 0.558, 0.883> 
		<2.341, 0.467, 1.324> <2.341, 0.487, 1.192> <2.340, 0.517, 1.016> <2.340, 0.533, 0.883> 
		<2.401, 0.467, 1.324> <2.401, 0.487, 1.192> <2.401, 0.517, 1.016> <2.401, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, 0.558, 0.883> <2.201, 0.572, 0.791> <2.201, 0.582, 0.668> <2.201, 0.580, 0.575> 
		<2.261, 0.558, 0.883> <2.261, 0.572, 0.791> <2.261, 0.582, 0.668> <2.261, 0.580, 0.575> 
		<2.340, 0.533, 0.883> <2.340, 0.543, 0.791> <2.340, 0.556, 0.668> <2.340, 0.554, 0.575> 
		<2.401, 0.533, 0.883> <2.401, 0.543, 0.791> <2.401, 0.556, 0.668> <2.401, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, 0.580, 0.575> <2.201, 0.578, 0.516> <2.201, 0.577, 0.452> <2.201, 0.547, 0.382> 
		<2.261, 0.580, 0.575> <2.261, 0.578, 0.516> <2.261, 0.577, 0.452> <2.261, 0.547, 0.382> 
		<2.340, 0.554, 0.575> <2.340, 0.553, 0.516> <2.340, 0.544, 0.455> <2.340, 0.522, 0.382> 
		<2.401, 0.554, 0.575> <2.401, 0.553, 0.516> <2.401, 0.544, 0.455> <2.401, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, 0.547, 0.382> <2.201, 0.536, 0.354> <2.201, 0.485, 0.322> <2.201, 0.483, 0.341> 
		<2.261, 0.547, 0.382> <2.261, 0.536, 0.354> <2.261, 0.485, 0.322> <2.261, 0.483, 0.341> 
		<2.340, 0.522, 0.382> <2.340, 0.515, 0.361> <2.341, 0.484, 0.327> <2.341, 0.483, 0.341> 
		<2.401, 0.522, 0.382> <2.401, 0.515, 0.361> <2.401, 0.484, 0.327> <2.401, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, 0.483, 0.341> <2.201, 0.467, 0.455> <2.201, 0.498, 0.420> <2.201, 0.492, 0.786> 
		<2.261, 0.483, 0.341> <2.261, 0.467, 0.455> <2.261, 0.498, 0.420> <2.261, 0.492, 0.786> 
		<2.341, 0.483, 0.341> <2.341, 0.474, 0.455> <2.341, 0.498, 0.420> <2.341, 0.492, 0.786> 
		<2.401, 0.483, 0.341> <2.401, 0.474, 0.455> <2.401, 0.498, 0.420> <2.401, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.401, 0.467, 1.324> <2.461, 0.467, 1.324> <2.541, 0.467, 1.341> <2.601, 0.467, 1.341> 
		<2.401, 0.475, 1.163> <2.461, 0.475, 1.163> <2.541, 0.475, 1.175> <2.601, 0.475, 1.175> 
		<2.401, 0.485, 1.230> <2.461, 0.485, 1.230> <2.541, 0.485, 1.244> <2.601, 0.485, 1.244> 
		<2.401, 0.492, 0.786> <2.461, 0.492, 0.786> <2.541, 0.492, 0.786> <2.601, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.401, 0.467, 1.324> <2.401, 0.487, 1.192> <2.401, 0.517, 1.016> <2.401, 0.533, 0.883> 
		<2.461, 0.467, 1.324> <2.461, 0.487, 1.192> <2.461, 0.517, 1.016> <2.461, 0.533, 0.883> 
		<2.541, 0.467, 1.341> <2.541, 0.495, 1.204> <2.540, 0.538, 1.022> <2.540, 0.558, 0.883> 
		<2.601, 0.467, 1.341> <2.601, 0.495, 1.204> <2.601, 0.538, 1.022> <2.601, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.401, 0.533, 0.883> <2.401, 0.543, 0.791> <2.401, 0.556, 0.668> <2.401, 0.554, 0.575> 
		<2.461, 0.533, 0.883> <2.461, 0.543, 0.791> <2.461, 0.556, 0.668> <2.461, 0.554, 0.575> 
		<2.540, 0.558, 0.883> <2.540, 0.572, 0.791> <2.540, 0.582, 0.668> <2.540, 0.580, 0.575> 
		<2.601, 0.558, 0.883> <2.601, 0.572, 0.791> <2.601, 0.582, 0.668> <2.601, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.401, 0.554, 0.575> <2.401, 0.553, 0.516> <2.401, 0.544, 0.455> <2.401, 0.522, 0.382> 
		<2.461, 0.554, 0.575> <2.461, 0.553, 0.516> <2.461, 0.544, 0.455> <2.461, 0.522, 0.382> 
		<2.540, 0.580, 0.575> <2.540, 0.578, 0.516> <2.540, 0.577, 0.452> <2.540, 0.547, 0.382> 
		<2.601, 0.580, 0.575> <2.601, 0.578, 0.516> <2.601, 0.577, 0.452> <2.601, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.401, 0.522, 0.382> <2.401, 0.515, 0.361> <2.401, 0.484, 0.327> <2.401, 0.483, 0.341> 
		<2.461, 0.522, 0.382> <2.461, 0.515, 0.361> <2.461, 0.484, 0.327> <2.461, 0.483, 0.341> 
		<2.540, 0.547, 0.382> <2.540, 0.536, 0.354> <2.541, 0.485, 0.322> <2.541, 0.483, 0.341> 
		<2.601, 0.547, 0.382> <2.601, 0.536, 0.354> <2.601, 0.485, 0.322> <2.601, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.401, 0.483, 0.341> <2.401, 0.474, 0.455> <2.401, 0.498, 0.420> <2.401, 0.492, 0.786> 
		<2.461, 0.483, 0.341> <2.461, 0.474, 0.455> <2.461, 0.498, 0.420> <2.461, 0.492, 0.786> 
		<2.541, 0.483, 0.341> <2.541, 0.467, 0.455> <2.541, 0.498, 0.420> <2.541, 0.492, 0.786> 
		<2.601, 0.483, 0.341> <2.601, 0.467, 0.455> <2.601, 0.498, 0.420> <2.601, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.601, 0.467, 1.341> <2.661, 0.467, 1.341> <2.741, 0.467, 1.327> <2.801, 0.467, 1.324> 
		<2.601, 0.475, 1.175> <2.661, 0.475, 1.175> <2.741, 0.475, 1.165> <2.801, 0.475, 1.163> 
		<2.601, 0.485, 1.244> <2.661, 0.485, 1.244> <2.741, 0.485, 1.230> <2.801, 0.485, 1.230> 
		<2.601, 0.492, 0.786> <2.661, 0.492, 0.786> <2.741, 0.492, 0.786> <2.801, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.601, 0.467, 1.341> <2.601, 0.495, 1.204> <2.601, 0.538, 1.022> <2.601, 0.558, 0.883> 
		<2.661, 0.467, 1.341> <2.661, 0.495, 1.204> <2.661, 0.538, 1.022> <2.661, 0.558, 0.883> 
		<2.741, 0.467, 1.327> <2.741, 0.487, 1.194> <2.740, 0.517, 1.016> <2.740, 0.533, 0.883> 
		<2.801, 0.467, 1.324> <2.801, 0.487, 1.192> <2.801, 0.517, 1.016> <2.801, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.601, 0.558, 0.883> <2.601, 0.572, 0.791> <2.601, 0.582, 0.668> <2.601, 0.580, 0.575> 
		<2.661, 0.558, 0.883> <2.661, 0.572, 0.791> <2.661, 0.582, 0.668> <2.661, 0.580, 0.575> 
		<2.740, 0.533, 0.883> <2.740, 0.543, 0.791> <2.740, 0.556, 0.668> <2.740, 0.554, 0.575> 
		<2.801, 0.533, 0.883> <2.801, 0.543, 0.791> <2.801, 0.556, 0.668> <2.801, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.601, 0.580, 0.575> <2.601, 0.578, 0.516> <2.601, 0.577, 0.452> <2.601, 0.547, 0.382> 
		<2.661, 0.580, 0.575> <2.661, 0.578, 0.516> <2.661, 0.577, 0.452> <2.661, 0.547, 0.382> 
		<2.740, 0.554, 0.575> <2.740, 0.553, 0.516> <2.740, 0.544, 0.451> <2.740, 0.522, 0.378> 
		<2.801, 0.554, 0.575> <2.801, 0.553, 0.516> <2.801, 0.544, 0.455> <2.801, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.601, 0.547, 0.382> <2.601, 0.536, 0.354> <2.601, 0.485, 0.322> <2.601, 0.483, 0.341> 
		<2.661, 0.547, 0.382> <2.661, 0.536, 0.354> <2.661, 0.485, 0.322> <2.661, 0.483, 0.341> 
		<2.740, 0.522, 0.378> <2.740, 0.515, 0.357> <2.741, 0.484, 0.324> <2.741, 0.483, 0.339> 
		<2.801, 0.522, 0.382> <2.801, 0.515, 0.361> <2.801, 0.484, 0.327> <2.801, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.601, 0.483, 0.341> <2.601, 0.467, 0.455> <2.601, 0.498, 0.420> <2.601, 0.492, 0.786> 
		<2.661, 0.483, 0.341> <2.661, 0.467, 0.455> <2.661, 0.498, 0.420> <2.661, 0.492, 0.786> 
		<2.741, 0.483, 0.339> <2.741, 0.474, 0.453> <2.741, 0.498, 0.420> <2.741, 0.492, 0.786> 
		<2.801, 0.483, 0.341> <2.801, 0.474, 0.455> <2.801, 0.498, 0.420> <2.801, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.801, 0.467, 1.324> <2.861, 0.467, 1.322> <2.945, 0.467, 1.345> <3.001, 0.467, 1.325> 
		<2.801, 0.475, 1.163> <2.861, 0.475, 1.160> <2.945, 0.475, 1.184> <3.001, 0.475, 1.163> 
		<2.801, 0.485, 1.230> <2.861, 0.485, 1.230> <2.941, 0.485, 1.230> <3.001, 0.485, 1.230> 
		<2.801, 0.492, 0.786> <2.861, 0.492, 0.786> <2.941, 0.492, 0.786> <3.001, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.801, 0.467, 1.324> <2.801, 0.487, 1.192> <2.801, 0.517, 1.016> <2.801, 0.533, 0.883> 
		<2.861, 0.467, 1.322> <2.861, 0.487, 1.189> <2.861, 0.517, 1.016> <2.861, 0.533, 0.883> 
		<2.945, 0.467, 1.345> <2.945, 0.495, 1.213> <2.940, 0.537, 1.017> <2.940, 0.557, 0.883> 
		<3.001, 0.467, 1.325> <3.001, 0.495, 1.192> <3.001, 0.538, 1.017> <3.001, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.801, 0.533, 0.883> <2.801, 0.543, 0.791> <2.801, 0.556, 0.668> <2.801, 0.554, 0.575> 
		<2.861, 0.533, 0.883> <2.861, 0.543, 0.791> <2.861, 0.556, 0.668> <2.861, 0.554, 0.575> 
		<2.940, 0.557, 0.883> <2.940, 0.571, 0.791> <2.942, 0.584, 0.656> <2.942, 0.582, 0.563> 
		<3.001, 0.558, 0.883> <3.001, 0.572, 0.791> <3.001, 0.582, 0.668> <3.001, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.801, 0.554, 0.575> <2.801, 0.553, 0.516> <2.801, 0.544, 0.455> <2.801, 0.522, 0.382> 
		<2.861, 0.554, 0.575> <2.861, 0.553, 0.516> <2.862, 0.544, 0.459> <2.862, 0.522, 0.385> 
		<2.942, 0.582, 0.563> <2.942, 0.581, 0.512> <2.945, 0.575, 0.444> <2.945, 0.548, 0.383> 
		<3.001, 0.580, 0.575> <3.001, 0.579, 0.524> <3.001, 0.575, 0.468> <3.001, 0.547, 0.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.801, 0.522, 0.382> <2.801, 0.515, 0.361> <2.801, 0.484, 0.327> <2.801, 0.483, 0.341> 
		<2.862, 0.522, 0.385> <2.862, 0.515, 0.365> <2.861, 0.484, 0.329> <2.861, 0.483, 0.344> 
		<2.945, 0.548, 0.383> <2.945, 0.535, 0.354> <2.943, 0.486, 0.319> <2.943, 0.483, 0.340> 
		<3.001, 0.547, 0.407> <3.001, 0.534, 0.378> <3.001, 0.486, 0.337> <3.001, 0.483, 0.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.801, 0.483, 0.341> <2.801, 0.474, 0.455> <2.801, 0.498, 0.420> <2.801, 0.492, 0.786> 
		<2.861, 0.483, 0.344> <2.861, 0.474, 0.458> <2.861, 0.498, 0.420> <2.861, 0.492, 0.786> 
		<2.943, 0.483, 0.340> <2.943, 0.467, 0.449> <2.941, 0.498, 0.433> <2.941, 0.492, 0.786> 
		<3.001, 0.483, 0.358> <3.001, 0.467, 0.467> <3.001, 0.498, 0.433> <3.001, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.001, 0.467, 1.325> <3.041, 0.467, 1.310> <3.074, 0.466, 1.254> <3.093, 0.467, 1.216> 
		<3.001, 0.475, 1.163> <3.041, 0.475, 1.148> <3.074, 0.473, 1.125> <3.093, 0.475, 1.087> 
		<3.001, 0.485, 1.230> <3.028, 0.485, 1.230> <3.065, 0.485, 1.141> <3.093, 0.485, 1.141> 
		<3.001, 0.492, 0.786> <3.028, 0.492, 0.786> <3.065, 0.492, 0.786> <3.093, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.001, 0.467, 1.325> <3.001, 0.495, 1.192> <3.001, 0.538, 1.017> <3.001, 0.558, 0.883> 
		<3.041, 0.467, 1.310> <3.041, 0.495, 1.177> <3.029, 0.538, 1.017> <3.029, 0.559, 0.883> 
		<3.074, 0.466, 1.254> <3.074, 0.486, 1.155> <3.066, 0.533, 0.985> <3.066, 0.546, 0.884> 
		<3.093, 0.467, 1.216> <3.093, 0.488, 1.116> <3.093, 0.524, 0.984> <3.093, 0.537, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.001, 0.558, 0.883> <3.001, 0.572, 0.791> <3.001, 0.582, 0.668> <3.001, 0.580, 0.575> 
		<3.029, 0.559, 0.883> <3.029, 0.572, 0.791> <3.035, 0.580, 0.674> <3.035, 0.578, 0.582> 
		<3.066, 0.546, 0.884> <3.066, 0.555, 0.810> <3.066, 0.558, 0.690> <3.066, 0.554, 0.615> 
		<3.093, 0.537, 0.883> <3.093, 0.546, 0.809> <3.093, 0.545, 0.708> <3.093, 0.542, 0.634> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.001, 0.580, 0.575> <3.001, 0.579, 0.524> <3.001, 0.575, 0.468> <3.001, 0.547, 0.407> 
		<3.035, 0.578, 0.582> <3.035, 0.577, 0.531> <3.039, 0.574, 0.484> <3.039, 0.547, 0.423> 
		<3.066, 0.554, 0.615> <3.066, 0.553, 0.577> <3.067, 0.543, 0.523> <3.067, 0.528, 0.475> 
		<3.093, 0.542, 0.634> <3.093, 0.541, 0.595> <3.093, 0.535, 0.555> <3.093, 0.521, 0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.001, 0.547, 0.407> <3.001, 0.534, 0.378> <3.001, 0.486, 0.337> <3.001, 0.483, 0.358> 
		<3.039, 0.547, 0.423> <3.039, 0.534, 0.394> <3.035, 0.486, 0.348> <3.035, 0.483, 0.369> 
		<3.067, 0.528, 0.475> <3.067, 0.519, 0.444> <3.070, 0.485, 0.385> <3.070, 0.483, 0.406> 
		<3.093, 0.521, 0.507> <3.093, 0.511, 0.476> <3.093, 0.485, 0.412> <3.093, 0.483, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.001, 0.483, 0.358> <3.001, 0.467, 0.467> <3.001, 0.498, 0.433> <3.001, 0.492, 0.786> 
		<3.035, 0.483, 0.369> <3.035, 0.467, 0.478> <3.028, 0.498, 0.433> <3.028, 0.492, 0.786> 
		<3.070, 0.483, 0.406> <3.070, 0.474, 0.496> <3.065, 0.497, 0.495> <3.065, 0.492, 0.786> 
		<3.093, 0.483, 0.433> <3.093, 0.474, 0.524> <3.093, 0.498, 0.495> <3.093, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.160, 0.483, 0.990> <3.170, 0.487, 0.929> <3.196, 0.495, 0.957> <3.193, 0.495, 0.786> 
		<3.140, 0.479, 1.058> <3.150, 0.482, 0.997> <3.166, 0.494, 0.957> <3.163, 0.494, 0.786> 
		<3.123, 0.470, 1.152> <3.123, 0.478, 1.023> <3.123, 0.485, 1.141> <3.123, 0.492, 0.786> 
		<3.093, 0.467, 1.216> <3.093, 0.475, 1.087> <3.093, 0.485, 1.141> <3.093, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.160, 0.483, 0.990> <3.140, 0.479, 1.058> <3.123, 0.470, 1.152> <3.093, 0.467, 1.216> 
		<3.167, 0.487, 0.956> <3.147, 0.483, 1.023> <3.123, 0.491, 1.052> <3.093, 0.488, 1.116> 
		<3.182, 0.495, 0.910> <3.154, 0.507, 0.913> <3.121, 0.514, 0.983> <3.093, 0.524, 0.984> 
		<3.185, 0.497, 0.874> <3.157, 0.509, 0.877> <3.121, 0.527, 0.881> <3.093, 0.537, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.185, 0.497, 0.874> <3.157, 0.509, 0.877> <3.121, 0.527, 0.881> <3.093, 0.537, 0.883> 
		<3.189, 0.499, 0.823> <3.162, 0.511, 0.825> <3.121, 0.537, 0.807> <3.093, 0.546, 0.809> 
		<3.186, 0.497, 0.753> <3.159, 0.511, 0.733> <3.121, 0.533, 0.728> <3.093, 0.545, 0.708> 
		<3.185, 0.497, 0.701> <3.157, 0.510, 0.680> <3.121, 0.529, 0.653> <3.093, 0.542, 0.634> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.185, 0.497, 0.701> <3.157, 0.510, 0.680> <3.121, 0.529, 0.653> <3.093, 0.542, 0.634> 
		<3.184, 0.496, 0.677> <3.156, 0.510, 0.657> <3.121, 0.528, 0.615> <3.093, 0.541, 0.595> 
		<3.182, 0.496, 0.653> <3.157, 0.504, 0.618> <3.120, 0.527, 0.589> <3.093, 0.535, 0.555> 
		<3.176, 0.494, 0.624> <3.151, 0.502, 0.589> <3.120, 0.512, 0.541> <3.093, 0.521, 0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.176, 0.494, 0.624> <3.151, 0.502, 0.589> <3.120, 0.512, 0.541> <3.093, 0.521, 0.507> 
		<3.169, 0.491, 0.588> <3.144, 0.499, 0.553> <3.120, 0.503, 0.510> <3.093, 0.511, 0.476> 
		<3.149, 0.483, 0.509> <3.131, 0.483, 0.479> <3.115, 0.485, 0.438> <3.093, 0.485, 0.412> 
		<3.151, 0.483, 0.534> <3.134, 0.483, 0.503> <3.115, 0.483, 0.460> <3.093, 0.483, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.151, 0.483, 0.534> <3.134, 0.483, 0.503> <3.115, 0.483, 0.460> <3.093, 0.483, 0.433> 
		<3.158, 0.483, 0.599> <3.141, 0.483, 0.569> <3.115, 0.474, 0.550> <3.093, 0.474, 0.524> 
		<3.189, 0.494, 0.575> <3.159, 0.494, 0.575> <3.123, 0.498, 0.495> <3.093, 0.498, 0.495> 
		<3.193, 0.495, 0.786> <3.163, 0.494, 0.786> <3.123, 0.492, 0.786> <3.093, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.467, 0.982> <-0.200, 0.475, 0.923> <-0.200, 0.488, 0.949> <-0.200, 0.492, 0.786> 
		<-0.260, 0.467, 0.982> <-0.260, 0.475, 0.923> <-0.260, 0.488, 0.949> <-0.260, 0.492, 0.786> 
		<-0.340, 0.467, 0.982> <-0.340, 0.475, 0.923> <-0.340, 0.488, 0.949> <-0.340, 0.492, 0.786> 
		<-0.400, 0.467, 0.982> <-0.400, 0.475, 0.923> <-0.400, 0.488, 0.949> <-0.400, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.467, 0.982> <-0.260, 0.467, 0.982> <-0.340, 0.467, 0.982> <-0.400, 0.467, 0.982> 
		<-0.200, 0.483, 0.952> <-0.260, 0.483, 0.952> <-0.340, 0.485, 0.952> <-0.400, 0.485, 0.952> 
		<-0.200, 0.512, 0.916> <-0.260, 0.512, 0.916> <-0.340, 0.516, 0.916> <-0.400, 0.518, 0.916> 
		<-0.200, 0.519, 0.883> <-0.260, 0.519, 0.883> <-0.340, 0.524, 0.883> <-0.400, 0.527, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.519, 0.883> <-0.260, 0.519, 0.883> <-0.340, 0.524, 0.883> <-0.400, 0.527, 0.883> 
		<-0.200, 0.539, 0.792> <-0.260, 0.539, 0.792> <-0.340, 0.548, 0.792> <-0.400, 0.550, 0.792> 
		<-0.200, 0.551, 0.668> <-0.260, 0.552, 0.668> <-0.340, 0.564, 0.668> <-0.400, 0.568, 0.668> 
		<-0.200, 0.556, 0.575> <-0.260, 0.557, 0.575> <-0.340, 0.568, 0.575> <-0.400, 0.572, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.556, 0.575> <-0.260, 0.557, 0.575> <-0.340, 0.568, 0.575> <-0.400, 0.572, 0.575> 
		<-0.200, 0.559, 0.517> <-0.260, 0.561, 0.517> <-0.340, 0.571, 0.517> <-0.400, 0.574, 0.517> 
		<-0.200, 0.570, 0.454> <-0.260, 0.570, 0.454> <-0.340, 0.574, 0.453> <-0.400, 0.574, 0.453> 
		<-0.200, 0.547, 0.382> <-0.260, 0.547, 0.382> <-0.340, 0.547, 0.382> <-0.400, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.547, 0.382> <-0.260, 0.547, 0.382> <-0.340, 0.547, 0.382> <-0.400, 0.547, 0.382> 
		<-0.200, 0.538, 0.353> <-0.260, 0.538, 0.353> <-0.340, 0.537, 0.354> <-0.400, 0.537, 0.354> 
		<-0.200, 0.485, 0.322> <-0.260, 0.485, 0.322> <-0.340, 0.485, 0.322> <-0.400, 0.485, 0.322> 
		<-0.200, 0.483, 0.341> <-0.260, 0.483, 0.341> <-0.340, 0.483, 0.341> <-0.400, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.483, 0.341> <-0.260, 0.483, 0.341> <-0.340, 0.483, 0.341> <-0.400, 0.483, 0.341> 
		<-0.200, 0.467, 0.455> <-0.260, 0.467, 0.455> <-0.340, 0.467, 0.455> <-0.400, 0.467, 0.455> 
		<-0.200, 0.501, 0.420> <-0.260, 0.501, 0.420> <-0.340, 0.501, 0.420> <-0.400, 0.501, 0.420> 
		<-0.200, 0.492, 0.786> <-0.260, 0.492, 0.786> <-0.340, 0.492, 0.786> <-0.400, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.467, 0.982> <-0.400, 0.475, 0.923> <-0.400, 0.488, 0.949> <-0.400, 0.492, 0.786> 
		<-0.460, 0.467, 0.982> <-0.460, 0.475, 0.923> <-0.460, 0.488, 0.949> <-0.460, 0.492, 0.786> 
		<-0.540, 0.467, 0.978> <-0.540, 0.475, 0.919> <-0.540, 0.488, 0.949> <-0.540, 0.492, 0.786> 
		<-0.600, 0.467, 0.982> <-0.600, 0.475, 0.923> <-0.600, 0.488, 0.949> <-0.600, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.467, 0.982> <-0.460, 0.467, 0.982> <-0.540, 0.467, 0.978> <-0.600, 0.467, 0.982> 
		<-0.400, 0.485, 0.952> <-0.460, 0.485, 0.952> <-0.540, 0.488, 0.948> <-0.600, 0.488, 0.952> 
		<-0.400, 0.518, 0.916> <-0.460, 0.520, 0.916> <-0.540, 0.520, 0.917> <-0.600, 0.525, 0.917> 
		<-0.400, 0.527, 0.883> <-0.460, 0.529, 0.883> <-0.540, 0.530, 0.883> <-0.600, 0.535, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.527, 0.883> <-0.460, 0.529, 0.883> <-0.540, 0.530, 0.883> <-0.600, 0.535, 0.883> 
		<-0.400, 0.550, 0.792> <-0.460, 0.552, 0.792> <-0.540, 0.555, 0.793> <-0.600, 0.559, 0.793> 
		<-0.400, 0.568, 0.668> <-0.460, 0.572, 0.668> <-0.540, 0.576, 0.668> <-0.600, 0.577, 0.668> 
		<-0.400, 0.572, 0.575> <-0.460, 0.575, 0.575> <-0.540, 0.579, 0.575> <-0.600, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.572, 0.575> <-0.460, 0.575, 0.575> <-0.540, 0.579, 0.575> <-0.600, 0.580, 0.575> 
		<-0.400, 0.574, 0.517> <-0.460, 0.578, 0.517> <-0.540, 0.580, 0.516> <-0.600, 0.581, 0.516> 
		<-0.400, 0.574, 0.453> <-0.460, 0.574, 0.453> <-0.540, 0.577, 0.452> <-0.600, 0.577, 0.452> 
		<-0.400, 0.547, 0.382> <-0.460, 0.547, 0.382> <-0.540, 0.547, 0.382> <-0.600, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.547, 0.382> <-0.460, 0.547, 0.382> <-0.540, 0.547, 0.382> <-0.600, 0.547, 0.382> 
		<-0.400, 0.537, 0.354> <-0.460, 0.537, 0.354> <-0.540, 0.536, 0.354> <-0.600, 0.536, 0.354> 
		<-0.400, 0.485, 0.322> <-0.460, 0.485, 0.322> <-0.540, 0.485, 0.322> <-0.600, 0.485, 0.322> 
		<-0.400, 0.483, 0.341> <-0.460, 0.483, 0.341> <-0.540, 0.483, 0.341> <-0.600, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.483, 0.341> <-0.460, 0.483, 0.341> <-0.540, 0.483, 0.341> <-0.600, 0.483, 0.341> 
		<-0.400, 0.467, 0.455> <-0.460, 0.467, 0.455> <-0.540, 0.467, 0.455> <-0.600, 0.467, 0.455> 
		<-0.400, 0.501, 0.420> <-0.460, 0.501, 0.420> <-0.540, 0.501, 0.420> <-0.600, 0.501, 0.420> 
		<-0.400, 0.492, 0.786> <-0.460, 0.492, 0.786> <-0.540, 0.492, 0.786> <-0.600, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.467, 0.982> <-0.600, 0.475, 0.923> <-0.600, 0.488, 0.949> <-0.600, 0.492, 0.786> 
		<-0.660, 0.467, 0.986> <-0.660, 0.475, 0.927> <-0.660, 0.488, 0.949> <-0.660, 0.492, 0.786> 
		<-0.743, 0.467, 0.986> <-0.743, 0.475, 0.919> <-0.740, 0.488, 0.969> <-0.740, 0.492, 0.786> 
		<-0.800, 0.467, 1.007> <-0.800, 0.475, 0.941> <-0.800, 0.488, 0.969> <-0.800, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.467, 0.982> <-0.660, 0.467, 0.986> <-0.743, 0.467, 0.986> <-0.800, 0.467, 1.007> 
		<-0.600, 0.488, 0.952> <-0.660, 0.488, 0.956> <-0.743, 0.495, 0.948> <-0.800, 0.495, 0.970> 
		<-0.600, 0.525, 0.917> <-0.660, 0.530, 0.917> <-0.740, 0.543, 0.927> <-0.800, 0.547, 0.927> 
		<-0.600, 0.535, 0.883> <-0.660, 0.539, 0.883> <-0.740, 0.555, 0.883> <-0.800, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.535, 0.883> <-0.660, 0.539, 0.883> <-0.740, 0.555, 0.883> <-0.800, 0.558, 0.883> 
		<-0.600, 0.559, 0.793> <-0.660, 0.564, 0.793> <-0.740, 0.578, 0.793> <-0.800, 0.581, 0.793> 
		<-0.600, 0.577, 0.668> <-0.660, 0.579, 0.668> <-0.740, 0.582, 0.668> <-0.800, 0.582, 0.668> 
		<-0.600, 0.580, 0.575> <-0.660, 0.581, 0.575> <-0.740, 0.580, 0.575> <-0.800, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.580, 0.575> <-0.660, 0.581, 0.575> <-0.740, 0.580, 0.575> <-0.800, 0.580, 0.575> 
		<-0.600, 0.581, 0.516> <-0.660, 0.582, 0.516> <-0.740, 0.578, 0.516> <-0.800, 0.578, 0.516> 
		<-0.600, 0.577, 0.452> <-0.660, 0.577, 0.452> <-0.740, 0.577, 0.452> <-0.800, 0.577, 0.452> 
		<-0.600, 0.547, 0.382> <-0.660, 0.547, 0.382> <-0.740, 0.547, 0.382> <-0.800, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.547, 0.382> <-0.660, 0.547, 0.382> <-0.740, 0.547, 0.382> <-0.800, 0.547, 0.382> 
		<-0.600, 0.536, 0.354> <-0.660, 0.536, 0.354> <-0.740, 0.536, 0.354> <-0.800, 0.536, 0.354> 
		<-0.600, 0.485, 0.322> <-0.660, 0.485, 0.322> <-0.740, 0.485, 0.322> <-0.800, 0.485, 0.322> 
		<-0.600, 0.483, 0.341> <-0.660, 0.483, 0.341> <-0.740, 0.483, 0.341> <-0.800, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.483, 0.341> <-0.660, 0.483, 0.341> <-0.740, 0.483, 0.341> <-0.800, 0.483, 0.341> 
		<-0.600, 0.467, 0.455> <-0.660, 0.467, 0.455> <-0.740, 0.467, 0.455> <-0.800, 0.467, 0.455> 
		<-0.600, 0.501, 0.420> <-0.660, 0.501, 0.420> <-0.740, 0.500, 0.420> <-0.800, 0.500, 0.420> 
		<-0.600, 0.492, 0.786> <-0.660, 0.492, 0.786> <-0.740, 0.492, 0.786> <-0.800, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, 0.467, 1.007> <-0.800, 0.475, 0.941> <-0.800, 0.488, 0.969> <-0.800, 0.492, 0.786> 
		<-0.866, 0.467, 1.032> <-0.866, 0.475, 0.966> <-0.860, 0.488, 0.969> <-0.860, 0.492, 0.786> 
		<-0.944, 0.467, 1.088> <-0.944, 0.475, 0.984> <-0.940, 0.486, 1.072> <-0.940, 0.492, 0.786> 
		<-1.000, 0.467, 1.132> <-1.000, 0.475, 1.028> <-1.000, 0.486, 1.072> <-1.000, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, 0.467, 1.007> <-0.866, 0.467, 1.032> <-0.944, 0.467, 1.088> <-1.000, 0.467, 1.132> 
		<-0.800, 0.495, 0.970> <-0.866, 0.495, 0.995> <-0.944, 0.495, 1.013> <-1.000, 0.495, 1.057> 
		<-0.800, 0.547, 0.927> <-0.860, 0.550, 0.927> <-0.940, 0.546, 0.961> <-1.000, 0.542, 0.961> 
		<-0.800, 0.558, 0.883> <-0.860, 0.562, 0.883> <-0.940, 0.562, 0.883> <-1.000, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, 0.558, 0.883> <-0.860, 0.562, 0.883> <-0.940, 0.562, 0.883> <-1.000, 0.558, 0.883> 
		<-0.800, 0.581, 0.793> <-0.860, 0.585, 0.793> <-0.940, 0.580, 0.792> <-1.000, 0.576, 0.792> 
		<-0.800, 0.582, 0.668> <-0.860, 0.582, 0.668> <-0.940, 0.586, 0.668> <-1.000, 0.582, 0.668> 
		<-0.800, 0.580, 0.575> <-0.860, 0.580, 0.575> <-0.940, 0.584, 0.575> <-1.000, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, 0.580, 0.575> <-0.860, 0.580, 0.575> <-0.940, 0.584, 0.575> <-1.000, 0.580, 0.575> 
		<-0.800, 0.578, 0.516> <-0.860, 0.578, 0.516> <-0.940, 0.582, 0.516> <-1.000, 0.578, 0.516> 
		<-0.800, 0.577, 0.452> <-0.860, 0.577, 0.452> <-0.940, 0.580, 0.452> <-1.000, 0.577, 0.452> 
		<-0.800, 0.547, 0.382> <-0.860, 0.547, 0.382> <-0.940, 0.551, 0.382> <-1.000, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, 0.547, 0.382> <-0.860, 0.547, 0.382> <-0.940, 0.551, 0.382> <-1.000, 0.547, 0.382> 
		<-0.800, 0.536, 0.354> <-0.860, 0.536, 0.354> <-0.940, 0.540, 0.354> <-1.000, 0.536, 0.354> 
		<-0.800, 0.485, 0.322> <-0.860, 0.485, 0.322> <-0.940, 0.485, 0.322> <-1.000, 0.485, 0.322> 
		<-0.800, 0.483, 0.341> <-0.860, 0.483, 0.341> <-0.940, 0.483, 0.341> <-1.000, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, 0.483, 0.341> <-0.860, 0.483, 0.341> <-0.940, 0.483, 0.341> <-1.000, 0.483, 0.341> 
		<-0.800, 0.467, 0.455> <-0.860, 0.467, 0.455> <-0.940, 0.467, 0.455> <-1.000, 0.467, 0.455> 
		<-0.800, 0.500, 0.420> <-0.860, 0.500, 0.420> <-0.940, 0.499, 0.420> <-1.000, 0.499, 0.420> 
		<-0.800, 0.492, 0.786> <-0.860, 0.492, 0.786> <-0.940, 0.492, 0.786> <-1.000, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.000, 0.467, 1.132> <-1.000, 0.475, 1.028> <-1.000, 0.486, 1.072> <-1.000, 0.492, 0.786> 
		<-1.065, 0.467, 1.184> <-1.065, 0.475, 1.080> <-1.060, 0.486, 1.072> <-1.060, 0.492, 0.786> 
		<-1.126, 0.467, 1.286> <-1.126, 0.475, 1.124> <-1.140, 0.485, 1.230> <-1.140, 0.492, 0.786> 
		<-1.200, 0.467, 1.325> <-1.200, 0.475, 1.163> <-1.200, 0.485, 1.230> <-1.200, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.000, 0.467, 1.132> <-1.065, 0.467, 1.184> <-1.126, 0.467, 1.286> <-1.200, 0.467, 1.325> 
		<-1.000, 0.495, 1.057> <-1.065, 0.495, 1.109> <-1.126, 0.487, 1.154> <-1.200, 0.487, 1.192> 
		<-1.000, 0.542, 0.961> <-1.060, 0.539, 0.961> <-1.139, 0.517, 1.016> <-1.200, 0.517, 1.016> 
		<-1.000, 0.558, 0.883> <-1.060, 0.554, 0.883> <-1.139, 0.533, 0.883> <-1.200, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.000, 0.558, 0.883> <-1.060, 0.554, 0.883> <-1.139, 0.533, 0.883> <-1.200, 0.533, 0.883> 
		<-1.000, 0.576, 0.792> <-1.060, 0.573, 0.792> <-1.139, 0.543, 0.791> <-1.200, 0.543, 0.791> 
		<-1.000, 0.582, 0.668> <-1.060, 0.578, 0.668> <-1.139, 0.556, 0.668> <-1.200, 0.556, 0.668> 
		<-1.000, 0.580, 0.575> <-1.060, 0.576, 0.575> <-1.139, 0.554, 0.575> <-1.200, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.000, 0.580, 0.575> <-1.060, 0.576, 0.575> <-1.139, 0.554, 0.575> <-1.200, 0.554, 0.575> 
		<-1.000, 0.578, 0.516> <-1.060, 0.575, 0.516> <-1.139, 0.553, 0.516> <-1.200, 0.553, 0.516> 
		<-1.000, 0.577, 0.452> <-1.060, 0.573, 0.452> <-1.139, 0.544, 0.455> <-1.200, 0.544, 0.455> 
		<-1.000, 0.547, 0.382> <-1.060, 0.543, 0.382> <-1.139, 0.522, 0.382> <-1.200, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.000, 0.547, 0.382> <-1.060, 0.543, 0.382> <-1.139, 0.522, 0.382> <-1.200, 0.522, 0.382> 
		<-1.000, 0.536, 0.354> <-1.060, 0.532, 0.354> <-1.139, 0.515, 0.361> <-1.200, 0.515, 0.361> 
		<-1.000, 0.485, 0.322> <-1.060, 0.485, 0.322> <-1.140, 0.484, 0.327> <-1.200, 0.484, 0.327> 
		<-1.000, 0.483, 0.341> <-1.060, 0.483, 0.341> <-1.140, 0.483, 0.341> <-1.200, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.000, 0.483, 0.341> <-1.060, 0.483, 0.341> <-1.140, 0.483, 0.341> <-1.200, 0.483, 0.341> 
		<-1.000, 0.467, 0.455> <-1.060, 0.467, 0.455> <-1.140, 0.474, 0.455> <-1.200, 0.474, 0.455> 
		<-1.000, 0.499, 0.420> <-1.060, 0.499, 0.420> <-1.140, 0.498, 0.420> <-1.200, 0.498, 0.420> 
		<-1.000, 0.492, 0.786> <-1.060, 0.492, 0.786> <-1.140, 0.492, 0.786> <-1.200, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.200, 0.467, 1.325> <-1.200, 0.475, 1.163> <-1.200, 0.485, 1.230> <-1.200, 0.492, 0.786> 
		<-1.253, 0.467, 1.352> <-1.253, 0.475, 1.191> <-1.260, 0.485, 1.230> <-1.260, 0.492, 0.786> 
		<-1.340, 0.467, 1.341> <-1.340, 0.475, 1.175> <-1.340, 0.485, 1.244> <-1.340, 0.492, 0.786> 
		<-1.400, 0.467, 1.341> <-1.400, 0.475, 1.175> <-1.400, 0.485, 1.244> <-1.400, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.200, 0.467, 1.325> <-1.253, 0.467, 1.352> <-1.340, 0.467, 1.341> <-1.400, 0.467, 1.341> 
		<-1.200, 0.487, 1.192> <-1.253, 0.487, 1.220> <-1.340, 0.495, 1.204> <-1.400, 0.495, 1.204> 
		<-1.200, 0.517, 1.016> <-1.260, 0.517, 1.016> <-1.339, 0.538, 1.022> <-1.400, 0.538, 1.022> 
		<-1.200, 0.533, 0.883> <-1.260, 0.533, 0.883> <-1.339, 0.558, 0.883> <-1.400, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.200, 0.533, 0.883> <-1.260, 0.533, 0.883> <-1.339, 0.558, 0.883> <-1.400, 0.558, 0.883> 
		<-1.200, 0.543, 0.791> <-1.260, 0.543, 0.791> <-1.339, 0.572, 0.791> <-1.400, 0.572, 0.791> 
		<-1.200, 0.556, 0.668> <-1.260, 0.556, 0.668> <-1.339, 0.582, 0.668> <-1.400, 0.582, 0.668> 
		<-1.200, 0.554, 0.575> <-1.260, 0.554, 0.575> <-1.339, 0.580, 0.575> <-1.400, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.200, 0.554, 0.575> <-1.260, 0.554, 0.575> <-1.339, 0.580, 0.575> <-1.400, 0.580, 0.575> 
		<-1.200, 0.553, 0.516> <-1.260, 0.553, 0.516> <-1.339, 0.578, 0.516> <-1.400, 0.578, 0.516> 
		<-1.200, 0.544, 0.455> <-1.260, 0.544, 0.455> <-1.339, 0.577, 0.452> <-1.400, 0.577, 0.452> 
		<-1.200, 0.522, 0.382> <-1.260, 0.522, 0.382> <-1.339, 0.547, 0.382> <-1.400, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.200, 0.522, 0.382> <-1.260, 0.522, 0.382> <-1.339, 0.547, 0.382> <-1.400, 0.547, 0.382> 
		<-1.200, 0.515, 0.361> <-1.260, 0.515, 0.361> <-1.339, 0.536, 0.354> <-1.400, 0.536, 0.354> 
		<-1.200, 0.484, 0.327> <-1.260, 0.484, 0.327> <-1.340, 0.485, 0.322> <-1.400, 0.485, 0.322> 
		<-1.200, 0.483, 0.341> <-1.260, 0.483, 0.341> <-1.340, 0.483, 0.341> <-1.400, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.200, 0.483, 0.341> <-1.260, 0.483, 0.341> <-1.340, 0.483, 0.341> <-1.400, 0.483, 0.341> 
		<-1.200, 0.474, 0.455> <-1.260, 0.474, 0.455> <-1.340, 0.467, 0.455> <-1.400, 0.467, 0.455> 
		<-1.200, 0.498, 0.420> <-1.260, 0.498, 0.420> <-1.340, 0.498, 0.420> <-1.400, 0.498, 0.420> 
		<-1.200, 0.492, 0.786> <-1.260, 0.492, 0.786> <-1.340, 0.492, 0.786> <-1.400, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.400, 0.467, 1.341> <-1.400, 0.475, 1.175> <-1.400, 0.485, 1.244> <-1.400, 0.492, 0.786> 
		<-1.460, 0.467, 1.341> <-1.460, 0.475, 1.175> <-1.460, 0.485, 1.244> <-1.460, 0.492, 0.786> 
		<-1.540, 0.467, 1.324> <-1.540, 0.475, 1.163> <-1.540, 0.485, 1.230> <-1.540, 0.492, 0.786> 
		<-1.600, 0.467, 1.324> <-1.600, 0.475, 1.163> <-1.600, 0.485, 1.230> <-1.600, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.400, 0.467, 1.341> <-1.460, 0.467, 1.341> <-1.540, 0.467, 1.324> <-1.600, 0.467, 1.324> 
		<-1.400, 0.495, 1.204> <-1.460, 0.495, 1.204> <-1.540, 0.487, 1.192> <-1.600, 0.487, 1.192> 
		<-1.400, 0.538, 1.022> <-1.460, 0.538, 1.022> <-1.539, 0.517, 1.016> <-1.600, 0.517, 1.016> 
		<-1.400, 0.558, 0.883> <-1.460, 0.558, 0.883> <-1.539, 0.533, 0.883> <-1.600, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.400, 0.558, 0.883> <-1.460, 0.558, 0.883> <-1.539, 0.533, 0.883> <-1.600, 0.533, 0.883> 
		<-1.400, 0.572, 0.791> <-1.460, 0.572, 0.791> <-1.539, 0.543, 0.791> <-1.600, 0.543, 0.791> 
		<-1.400, 0.582, 0.668> <-1.460, 0.582, 0.668> <-1.539, 0.556, 0.668> <-1.600, 0.556, 0.668> 
		<-1.400, 0.580, 0.575> <-1.460, 0.580, 0.575> <-1.539, 0.554, 0.575> <-1.600, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.400, 0.580, 0.575> <-1.460, 0.580, 0.575> <-1.539, 0.554, 0.575> <-1.600, 0.554, 0.575> 
		<-1.400, 0.578, 0.516> <-1.460, 0.578, 0.516> <-1.539, 0.553, 0.516> <-1.600, 0.553, 0.516> 
		<-1.400, 0.577, 0.452> <-1.460, 0.577, 0.452> <-1.539, 0.544, 0.455> <-1.600, 0.544, 0.455> 
		<-1.400, 0.547, 0.382> <-1.460, 0.547, 0.382> <-1.539, 0.522, 0.382> <-1.600, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.400, 0.547, 0.382> <-1.460, 0.547, 0.382> <-1.539, 0.522, 0.382> <-1.600, 0.522, 0.382> 
		<-1.400, 0.536, 0.354> <-1.460, 0.536, 0.354> <-1.539, 0.515, 0.361> <-1.600, 0.515, 0.361> 
		<-1.400, 0.485, 0.322> <-1.460, 0.485, 0.322> <-1.540, 0.484, 0.327> <-1.600, 0.484, 0.327> 
		<-1.400, 0.483, 0.341> <-1.460, 0.483, 0.341> <-1.540, 0.483, 0.341> <-1.600, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.400, 0.483, 0.341> <-1.460, 0.483, 0.341> <-1.540, 0.483, 0.341> <-1.600, 0.483, 0.341> 
		<-1.400, 0.467, 0.455> <-1.460, 0.467, 0.455> <-1.540, 0.474, 0.455> <-1.600, 0.474, 0.455> 
		<-1.400, 0.498, 0.420> <-1.460, 0.498, 0.420> <-1.540, 0.498, 0.420> <-1.600, 0.498, 0.420> 
		<-1.400, 0.492, 0.786> <-1.460, 0.492, 0.786> <-1.540, 0.492, 0.786> <-1.600, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.600, 0.467, 1.324> <-1.600, 0.475, 1.163> <-1.600, 0.485, 1.230> <-1.600, 0.492, 0.786> 
		<-1.660, 0.467, 1.324> <-1.660, 0.475, 1.163> <-1.660, 0.485, 1.230> <-1.660, 0.492, 0.786> 
		<-1.740, 0.467, 1.341> <-1.740, 0.475, 1.175> <-1.740, 0.485, 1.244> <-1.740, 0.492, 0.786> 
		<-1.800, 0.467, 1.341> <-1.800, 0.475, 1.175> <-1.800, 0.485, 1.244> <-1.800, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.600, 0.467, 1.324> <-1.660, 0.467, 1.324> <-1.740, 0.467, 1.341> <-1.800, 0.467, 1.341> 
		<-1.600, 0.487, 1.192> <-1.660, 0.487, 1.192> <-1.740, 0.495, 1.204> <-1.800, 0.495, 1.204> 
		<-1.600, 0.517, 1.016> <-1.660, 0.517, 1.016> <-1.739, 0.538, 1.022> <-1.800, 0.538, 1.022> 
		<-1.600, 0.533, 0.883> <-1.660, 0.533, 0.883> <-1.739, 0.558, 0.883> <-1.800, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.600, 0.533, 0.883> <-1.660, 0.533, 0.883> <-1.739, 0.558, 0.883> <-1.800, 0.558, 0.883> 
		<-1.600, 0.543, 0.791> <-1.660, 0.543, 0.791> <-1.739, 0.572, 0.791> <-1.800, 0.572, 0.791> 
		<-1.600, 0.556, 0.668> <-1.660, 0.556, 0.668> <-1.739, 0.582, 0.668> <-1.800, 0.582, 0.668> 
		<-1.600, 0.554, 0.575> <-1.660, 0.554, 0.575> <-1.739, 0.580, 0.575> <-1.800, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.600, 0.554, 0.575> <-1.660, 0.554, 0.575> <-1.739, 0.580, 0.575> <-1.800, 0.580, 0.575> 
		<-1.600, 0.553, 0.516> <-1.660, 0.553, 0.516> <-1.739, 0.578, 0.516> <-1.800, 0.578, 0.516> 
		<-1.600, 0.544, 0.455> <-1.660, 0.544, 0.455> <-1.739, 0.577, 0.452> <-1.800, 0.577, 0.452> 
		<-1.600, 0.522, 0.382> <-1.660, 0.522, 0.382> <-1.739, 0.547, 0.382> <-1.800, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.600, 0.522, 0.382> <-1.660, 0.522, 0.382> <-1.739, 0.547, 0.382> <-1.800, 0.547, 0.382> 
		<-1.600, 0.515, 0.361> <-1.660, 0.515, 0.361> <-1.739, 0.536, 0.354> <-1.800, 0.536, 0.354> 
		<-1.600, 0.484, 0.327> <-1.660, 0.484, 0.327> <-1.740, 0.485, 0.322> <-1.800, 0.485, 0.322> 
		<-1.600, 0.483, 0.341> <-1.660, 0.483, 0.341> <-1.740, 0.483, 0.341> <-1.800, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.600, 0.483, 0.341> <-1.660, 0.483, 0.341> <-1.740, 0.483, 0.341> <-1.800, 0.483, 0.341> 
		<-1.600, 0.474, 0.455> <-1.660, 0.474, 0.455> <-1.740, 0.467, 0.455> <-1.800, 0.467, 0.455> 
		<-1.600, 0.498, 0.420> <-1.660, 0.498, 0.420> <-1.740, 0.498, 0.420> <-1.800, 0.498, 0.420> 
		<-1.600, 0.492, 0.786> <-1.660, 0.492, 0.786> <-1.740, 0.492, 0.786> <-1.800, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.800, 0.467, 1.341> <-1.800, 0.475, 1.175> <-1.800, 0.485, 1.244> <-1.800, 0.492, 0.786> 
		<-1.860, 0.467, 1.341> <-1.860, 0.475, 1.175> <-1.860, 0.485, 1.244> <-1.860, 0.492, 0.786> 
		<-1.940, 0.467, 1.324> <-1.940, 0.475, 1.163> <-1.940, 0.485, 1.230> <-1.940, 0.492, 0.786> 
		<-2.000, 0.467, 1.324> <-2.000, 0.475, 1.163> <-2.000, 0.485, 1.230> <-2.000, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.800, 0.467, 1.341> <-1.860, 0.467, 1.341> <-1.940, 0.467, 1.324> <-2.000, 0.467, 1.324> 
		<-1.800, 0.495, 1.204> <-1.860, 0.495, 1.204> <-1.940, 0.487, 1.192> <-2.000, 0.487, 1.192> 
		<-1.800, 0.538, 1.022> <-1.860, 0.538, 1.022> <-1.939, 0.517, 1.016> <-2.000, 0.517, 1.016> 
		<-1.800, 0.558, 0.883> <-1.860, 0.558, 0.883> <-1.939, 0.533, 0.883> <-2.000, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.800, 0.558, 0.883> <-1.860, 0.558, 0.883> <-1.939, 0.533, 0.883> <-2.000, 0.533, 0.883> 
		<-1.800, 0.572, 0.791> <-1.860, 0.572, 0.791> <-1.939, 0.543, 0.791> <-2.000, 0.543, 0.791> 
		<-1.800, 0.582, 0.668> <-1.860, 0.582, 0.668> <-1.939, 0.556, 0.668> <-2.000, 0.556, 0.668> 
		<-1.800, 0.580, 0.575> <-1.860, 0.580, 0.575> <-1.939, 0.554, 0.575> <-2.000, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.800, 0.580, 0.575> <-1.860, 0.580, 0.575> <-1.939, 0.554, 0.575> <-2.000, 0.554, 0.575> 
		<-1.800, 0.578, 0.516> <-1.860, 0.578, 0.516> <-1.939, 0.553, 0.516> <-2.000, 0.553, 0.516> 
		<-1.800, 0.577, 0.452> <-1.860, 0.577, 0.452> <-1.939, 0.544, 0.455> <-2.000, 0.544, 0.455> 
		<-1.800, 0.547, 0.382> <-1.860, 0.547, 0.382> <-1.939, 0.522, 0.382> <-2.000, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.800, 0.547, 0.382> <-1.860, 0.547, 0.382> <-1.939, 0.522, 0.382> <-2.000, 0.522, 0.382> 
		<-1.800, 0.536, 0.354> <-1.860, 0.536, 0.354> <-1.939, 0.515, 0.361> <-2.000, 0.515, 0.361> 
		<-1.800, 0.485, 0.322> <-1.860, 0.485, 0.322> <-1.940, 0.484, 0.327> <-2.000, 0.484, 0.327> 
		<-1.800, 0.483, 0.341> <-1.860, 0.483, 0.341> <-1.940, 0.483, 0.341> <-2.000, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.800, 0.483, 0.341> <-1.860, 0.483, 0.341> <-1.940, 0.483, 0.341> <-2.000, 0.483, 0.341> 
		<-1.800, 0.467, 0.455> <-1.860, 0.467, 0.455> <-1.940, 0.474, 0.455> <-2.000, 0.474, 0.455> 
		<-1.800, 0.498, 0.420> <-1.860, 0.498, 0.420> <-1.940, 0.498, 0.420> <-2.000, 0.498, 0.420> 
		<-1.800, 0.492, 0.786> <-1.860, 0.492, 0.786> <-1.940, 0.492, 0.786> <-2.000, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.000, 0.467, 1.324> <-2.000, 0.475, 1.163> <-2.000, 0.485, 1.230> <-2.000, 0.492, 0.786> 
		<-2.060, 0.467, 1.324> <-2.060, 0.475, 1.163> <-2.060, 0.485, 1.230> <-2.060, 0.492, 0.786> 
		<-2.140, 0.467, 1.341> <-2.140, 0.475, 1.175> <-2.140, 0.485, 1.244> <-2.140, 0.492, 0.786> 
		<-2.200, 0.467, 1.341> <-2.200, 0.475, 1.175> <-2.200, 0.485, 1.244> <-2.200, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.000, 0.467, 1.324> <-2.060, 0.467, 1.324> <-2.140, 0.467, 1.341> <-2.200, 0.467, 1.341> 
		<-2.000, 0.487, 1.192> <-2.060, 0.487, 1.192> <-2.140, 0.495, 1.204> <-2.200, 0.495, 1.204> 
		<-2.000, 0.517, 1.016> <-2.060, 0.517, 1.016> <-2.139, 0.538, 1.022> <-2.200, 0.538, 1.022> 
		<-2.000, 0.533, 0.883> <-2.060, 0.533, 0.883> <-2.139, 0.558, 0.883> <-2.200, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.000, 0.533, 0.883> <-2.060, 0.533, 0.883> <-2.139, 0.558, 0.883> <-2.200, 0.558, 0.883> 
		<-2.000, 0.543, 0.791> <-2.060, 0.543, 0.791> <-2.139, 0.572, 0.791> <-2.200, 0.572, 0.791> 
		<-2.000, 0.556, 0.668> <-2.060, 0.556, 0.668> <-2.139, 0.582, 0.668> <-2.200, 0.582, 0.668> 
		<-2.000, 0.554, 0.575> <-2.060, 0.554, 0.575> <-2.139, 0.580, 0.575> <-2.200, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.000, 0.554, 0.575> <-2.060, 0.554, 0.575> <-2.139, 0.580, 0.575> <-2.200, 0.580, 0.575> 
		<-2.000, 0.553, 0.516> <-2.060, 0.553, 0.516> <-2.139, 0.578, 0.516> <-2.200, 0.578, 0.516> 
		<-2.000, 0.544, 0.455> <-2.060, 0.544, 0.455> <-2.139, 0.577, 0.452> <-2.200, 0.577, 0.452> 
		<-2.000, 0.522, 0.382> <-2.060, 0.522, 0.382> <-2.139, 0.547, 0.382> <-2.200, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.000, 0.522, 0.382> <-2.060, 0.522, 0.382> <-2.139, 0.547, 0.382> <-2.200, 0.547, 0.382> 
		<-2.000, 0.515, 0.361> <-2.060, 0.515, 0.361> <-2.139, 0.536, 0.354> <-2.200, 0.536, 0.354> 
		<-2.000, 0.484, 0.327> <-2.060, 0.484, 0.327> <-2.140, 0.485, 0.322> <-2.200, 0.485, 0.322> 
		<-2.000, 0.483, 0.341> <-2.060, 0.483, 0.341> <-2.140, 0.483, 0.341> <-2.200, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.000, 0.483, 0.341> <-2.060, 0.483, 0.341> <-2.140, 0.483, 0.341> <-2.200, 0.483, 0.341> 
		<-2.000, 0.474, 0.455> <-2.060, 0.474, 0.455> <-2.140, 0.467, 0.455> <-2.200, 0.467, 0.455> 
		<-2.000, 0.498, 0.420> <-2.060, 0.498, 0.420> <-2.140, 0.498, 0.420> <-2.200, 0.498, 0.420> 
		<-2.000, 0.492, 0.786> <-2.060, 0.492, 0.786> <-2.140, 0.492, 0.786> <-2.200, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.200, 0.467, 1.341> <-2.200, 0.475, 1.175> <-2.200, 0.485, 1.244> <-2.200, 0.492, 0.786> 
		<-2.260, 0.467, 1.341> <-2.260, 0.475, 1.175> <-2.260, 0.485, 1.244> <-2.260, 0.492, 0.786> 
		<-2.340, 0.467, 1.324> <-2.340, 0.475, 1.163> <-2.340, 0.485, 1.230> <-2.340, 0.492, 0.786> 
		<-2.400, 0.467, 1.324> <-2.400, 0.475, 1.163> <-2.400, 0.485, 1.230> <-2.400, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.200, 0.467, 1.341> <-2.260, 0.467, 1.341> <-2.340, 0.467, 1.324> <-2.400, 0.467, 1.324> 
		<-2.200, 0.495, 1.204> <-2.260, 0.495, 1.204> <-2.340, 0.487, 1.192> <-2.400, 0.487, 1.192> 
		<-2.200, 0.538, 1.022> <-2.260, 0.538, 1.022> <-2.339, 0.517, 1.016> <-2.400, 0.517, 1.016> 
		<-2.200, 0.558, 0.883> <-2.260, 0.558, 0.883> <-2.339, 0.533, 0.883> <-2.400, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.200, 0.558, 0.883> <-2.260, 0.558, 0.883> <-2.339, 0.533, 0.883> <-2.400, 0.533, 0.883> 
		<-2.200, 0.572, 0.791> <-2.260, 0.572, 0.791> <-2.339, 0.543, 0.791> <-2.400, 0.543, 0.791> 
		<-2.200, 0.582, 0.668> <-2.260, 0.582, 0.668> <-2.339, 0.556, 0.668> <-2.400, 0.556, 0.668> 
		<-2.200, 0.580, 0.575> <-2.260, 0.580, 0.575> <-2.339, 0.554, 0.575> <-2.400, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.200, 0.580, 0.575> <-2.260, 0.580, 0.575> <-2.339, 0.554, 0.575> <-2.400, 0.554, 0.575> 
		<-2.200, 0.578, 0.516> <-2.260, 0.578, 0.516> <-2.339, 0.553, 0.516> <-2.400, 0.553, 0.516> 
		<-2.200, 0.577, 0.452> <-2.260, 0.577, 0.452> <-2.339, 0.544, 0.455> <-2.400, 0.544, 0.455> 
		<-2.200, 0.547, 0.382> <-2.260, 0.547, 0.382> <-2.339, 0.522, 0.382> <-2.400, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.200, 0.547, 0.382> <-2.260, 0.547, 0.382> <-2.339, 0.522, 0.382> <-2.400, 0.522, 0.382> 
		<-2.200, 0.536, 0.354> <-2.260, 0.536, 0.354> <-2.339, 0.515, 0.361> <-2.400, 0.515, 0.361> 
		<-2.200, 0.485, 0.322> <-2.260, 0.485, 0.322> <-2.340, 0.484, 0.327> <-2.400, 0.484, 0.327> 
		<-2.200, 0.483, 0.341> <-2.260, 0.483, 0.341> <-2.340, 0.483, 0.341> <-2.400, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.200, 0.483, 0.341> <-2.260, 0.483, 0.341> <-2.340, 0.483, 0.341> <-2.400, 0.483, 0.341> 
		<-2.200, 0.467, 0.455> <-2.260, 0.467, 0.455> <-2.340, 0.474, 0.455> <-2.400, 0.474, 0.455> 
		<-2.200, 0.498, 0.420> <-2.260, 0.498, 0.420> <-2.340, 0.498, 0.420> <-2.400, 0.498, 0.420> 
		<-2.200, 0.492, 0.786> <-2.260, 0.492, 0.786> <-2.340, 0.492, 0.786> <-2.400, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.400, 0.467, 1.324> <-2.400, 0.475, 1.163> <-2.400, 0.485, 1.230> <-2.400, 0.492, 0.786> 
		<-2.460, 0.467, 1.324> <-2.460, 0.475, 1.163> <-2.460, 0.485, 1.230> <-2.460, 0.492, 0.786> 
		<-2.540, 0.467, 1.341> <-2.540, 0.475, 1.175> <-2.540, 0.485, 1.244> <-2.540, 0.492, 0.786> 
		<-2.600, 0.467, 1.341> <-2.600, 0.475, 1.175> <-2.600, 0.485, 1.244> <-2.600, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.400, 0.467, 1.324> <-2.460, 0.467, 1.324> <-2.540, 0.467, 1.341> <-2.600, 0.467, 1.341> 
		<-2.400, 0.487, 1.192> <-2.460, 0.487, 1.192> <-2.540, 0.495, 1.204> <-2.600, 0.495, 1.204> 
		<-2.400, 0.517, 1.016> <-2.460, 0.517, 1.016> <-2.539, 0.538, 1.022> <-2.600, 0.538, 1.022> 
		<-2.400, 0.533, 0.883> <-2.460, 0.533, 0.883> <-2.539, 0.558, 0.883> <-2.600, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.400, 0.533, 0.883> <-2.460, 0.533, 0.883> <-2.539, 0.558, 0.883> <-2.600, 0.558, 0.883> 
		<-2.400, 0.543, 0.791> <-2.460, 0.543, 0.791> <-2.539, 0.572, 0.791> <-2.600, 0.572, 0.791> 
		<-2.400, 0.556, 0.668> <-2.460, 0.556, 0.668> <-2.539, 0.582, 0.668> <-2.600, 0.582, 0.668> 
		<-2.400, 0.554, 0.575> <-2.460, 0.554, 0.575> <-2.539, 0.580, 0.575> <-2.600, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.400, 0.554, 0.575> <-2.460, 0.554, 0.575> <-2.539, 0.580, 0.575> <-2.600, 0.580, 0.575> 
		<-2.400, 0.553, 0.516> <-2.460, 0.553, 0.516> <-2.539, 0.578, 0.516> <-2.600, 0.578, 0.516> 
		<-2.400, 0.544, 0.455> <-2.460, 0.544, 0.455> <-2.539, 0.577, 0.452> <-2.600, 0.577, 0.452> 
		<-2.400, 0.522, 0.382> <-2.460, 0.522, 0.382> <-2.539, 0.547, 0.382> <-2.600, 0.547, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.400, 0.522, 0.382> <-2.460, 0.522, 0.382> <-2.539, 0.547, 0.382> <-2.600, 0.547, 0.382> 
		<-2.400, 0.515, 0.361> <-2.460, 0.515, 0.361> <-2.539, 0.536, 0.354> <-2.600, 0.536, 0.354> 
		<-2.400, 0.484, 0.327> <-2.460, 0.484, 0.327> <-2.540, 0.485, 0.322> <-2.600, 0.485, 0.322> 
		<-2.400, 0.483, 0.341> <-2.460, 0.483, 0.341> <-2.540, 0.483, 0.341> <-2.600, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.400, 0.483, 0.341> <-2.460, 0.483, 0.341> <-2.540, 0.483, 0.341> <-2.600, 0.483, 0.341> 
		<-2.400, 0.474, 0.455> <-2.460, 0.474, 0.455> <-2.540, 0.467, 0.455> <-2.600, 0.467, 0.455> 
		<-2.400, 0.498, 0.420> <-2.460, 0.498, 0.420> <-2.540, 0.498, 0.420> <-2.600, 0.498, 0.420> 
		<-2.400, 0.492, 0.786> <-2.460, 0.492, 0.786> <-2.540, 0.492, 0.786> <-2.600, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.600, 0.467, 1.341> <-2.600, 0.475, 1.175> <-2.600, 0.485, 1.244> <-2.600, 0.492, 0.786> 
		<-2.660, 0.467, 1.341> <-2.660, 0.475, 1.175> <-2.660, 0.485, 1.244> <-2.660, 0.492, 0.786> 
		<-2.740, 0.467, 1.327> <-2.740, 0.475, 1.165> <-2.740, 0.485, 1.230> <-2.740, 0.492, 0.786> 
		<-2.800, 0.467, 1.324> <-2.800, 0.475, 1.163> <-2.800, 0.485, 1.230> <-2.800, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.600, 0.467, 1.341> <-2.660, 0.467, 1.341> <-2.740, 0.467, 1.327> <-2.800, 0.467, 1.324> 
		<-2.600, 0.495, 1.204> <-2.660, 0.495, 1.204> <-2.740, 0.487, 1.194> <-2.800, 0.487, 1.192> 
		<-2.600, 0.538, 1.022> <-2.660, 0.538, 1.022> <-2.739, 0.517, 1.016> <-2.800, 0.517, 1.016> 
		<-2.600, 0.558, 0.883> <-2.660, 0.558, 0.883> <-2.739, 0.533, 0.883> <-2.800, 0.533, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.600, 0.558, 0.883> <-2.660, 0.558, 0.883> <-2.739, 0.533, 0.883> <-2.800, 0.533, 0.883> 
		<-2.600, 0.572, 0.791> <-2.660, 0.572, 0.791> <-2.739, 0.543, 0.791> <-2.800, 0.543, 0.791> 
		<-2.600, 0.582, 0.668> <-2.660, 0.582, 0.668> <-2.739, 0.556, 0.668> <-2.800, 0.556, 0.668> 
		<-2.600, 0.580, 0.575> <-2.660, 0.580, 0.575> <-2.739, 0.554, 0.575> <-2.800, 0.554, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.600, 0.580, 0.575> <-2.660, 0.580, 0.575> <-2.739, 0.554, 0.575> <-2.800, 0.554, 0.575> 
		<-2.600, 0.578, 0.516> <-2.660, 0.578, 0.516> <-2.739, 0.553, 0.516> <-2.800, 0.553, 0.516> 
		<-2.600, 0.577, 0.452> <-2.660, 0.577, 0.452> <-2.740, 0.544, 0.451> <-2.800, 0.544, 0.455> 
		<-2.600, 0.547, 0.382> <-2.660, 0.547, 0.382> <-2.740, 0.522, 0.378> <-2.800, 0.522, 0.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.600, 0.547, 0.382> <-2.660, 0.547, 0.382> <-2.740, 0.522, 0.378> <-2.800, 0.522, 0.382> 
		<-2.600, 0.536, 0.354> <-2.660, 0.536, 0.354> <-2.740, 0.515, 0.357> <-2.800, 0.515, 0.361> 
		<-2.600, 0.485, 0.322> <-2.660, 0.485, 0.322> <-2.740, 0.484, 0.324> <-2.800, 0.484, 0.327> 
		<-2.600, 0.483, 0.341> <-2.660, 0.483, 0.341> <-2.740, 0.483, 0.339> <-2.800, 0.483, 0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.600, 0.483, 0.341> <-2.660, 0.483, 0.341> <-2.740, 0.483, 0.339> <-2.800, 0.483, 0.341> 
		<-2.600, 0.467, 0.455> <-2.660, 0.467, 0.455> <-2.740, 0.474, 0.453> <-2.800, 0.474, 0.455> 
		<-2.600, 0.498, 0.420> <-2.660, 0.498, 0.420> <-2.740, 0.498, 0.420> <-2.800, 0.498, 0.420> 
		<-2.600, 0.492, 0.786> <-2.660, 0.492, 0.786> <-2.740, 0.492, 0.786> <-2.800, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.800, 0.467, 1.324> <-2.800, 0.475, 1.163> <-2.800, 0.485, 1.230> <-2.800, 0.492, 0.786> 
		<-2.860, 0.467, 1.322> <-2.860, 0.475, 1.160> <-2.860, 0.485, 1.230> <-2.860, 0.492, 0.786> 
		<-2.944, 0.467, 1.345> <-2.944, 0.475, 1.184> <-2.940, 0.485, 1.230> <-2.940, 0.492, 0.786> 
		<-3.000, 0.467, 1.325> <-3.000, 0.475, 1.163> <-3.000, 0.485, 1.230> <-3.000, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.800, 0.467, 1.324> <-2.860, 0.467, 1.322> <-2.944, 0.467, 1.345> <-3.000, 0.467, 1.325> 
		<-2.800, 0.487, 1.192> <-2.860, 0.487, 1.189> <-2.944, 0.495, 1.213> <-3.000, 0.495, 1.192> 
		<-2.800, 0.517, 1.016> <-2.860, 0.517, 1.016> <-2.939, 0.537, 1.017> <-3.000, 0.538, 1.017> 
		<-2.800, 0.533, 0.883> <-2.860, 0.533, 0.883> <-2.939, 0.557, 0.883> <-3.000, 0.558, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.800, 0.533, 0.883> <-2.860, 0.533, 0.883> <-2.939, 0.557, 0.883> <-3.000, 0.558, 0.883> 
		<-2.800, 0.543, 0.791> <-2.860, 0.543, 0.791> <-2.939, 0.571, 0.791> <-3.000, 0.572, 0.791> 
		<-2.800, 0.556, 0.668> <-2.860, 0.556, 0.668> <-2.941, 0.584, 0.656> <-3.000, 0.582, 0.668> 
		<-2.800, 0.554, 0.575> <-2.860, 0.554, 0.575> <-2.941, 0.582, 0.563> <-3.000, 0.580, 0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.800, 0.554, 0.575> <-2.860, 0.554, 0.575> <-2.941, 0.582, 0.563> <-3.000, 0.580, 0.575> 
		<-2.800, 0.553, 0.516> <-2.860, 0.553, 0.516> <-2.941, 0.581, 0.512> <-3.000, 0.579, 0.524> 
		<-2.800, 0.544, 0.455> <-2.861, 0.544, 0.459> <-2.944, 0.575, 0.444> <-3.000, 0.575, 0.468> 
		<-2.800, 0.522, 0.382> <-2.861, 0.522, 0.385> <-2.944, 0.548, 0.383> <-3.000, 0.547, 0.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.800, 0.522, 0.382> <-2.861, 0.522, 0.385> <-2.944, 0.548, 0.383> <-3.000, 0.547, 0.407> 
		<-2.800, 0.515, 0.361> <-2.861, 0.515, 0.365> <-2.944, 0.535, 0.354> <-3.000, 0.534, 0.378> 
		<-2.800, 0.484, 0.327> <-2.860, 0.484, 0.329> <-2.942, 0.486, 0.319> <-3.000, 0.486, 0.337> 
		<-2.800, 0.483, 0.341> <-2.860, 0.483, 0.344> <-2.942, 0.483, 0.340> <-3.000, 0.483, 0.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.800, 0.483, 0.341> <-2.860, 0.483, 0.344> <-2.942, 0.483, 0.340> <-3.000, 0.483, 0.358> 
		<-2.800, 0.474, 0.455> <-2.860, 0.474, 0.458> <-2.942, 0.467, 0.449> <-3.000, 0.467, 0.467> 
		<-2.800, 0.498, 0.420> <-2.860, 0.498, 0.420> <-2.940, 0.498, 0.433> <-3.000, 0.498, 0.433> 
		<-2.800, 0.492, 0.786> <-2.860, 0.492, 0.786> <-2.940, 0.492, 0.786> <-3.000, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.000, 0.467, 1.325> <-3.000, 0.475, 1.163> <-3.000, 0.485, 1.230> <-3.000, 0.492, 0.786> 
		<-3.040, 0.467, 1.310> <-3.040, 0.475, 1.148> <-3.027, 0.485, 1.230> <-3.027, 0.492, 0.786> 
		<-3.074, 0.466, 1.254> <-3.074, 0.473, 1.125> <-3.064, 0.485, 1.141> <-3.064, 0.492, 0.786> 
		<-3.092, 0.467, 1.216> <-3.092, 0.475, 1.087> <-3.092, 0.485, 1.141> <-3.092, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.000, 0.467, 1.325> <-3.040, 0.467, 1.310> <-3.074, 0.466, 1.254> <-3.092, 0.467, 1.216> 
		<-3.000, 0.495, 1.192> <-3.040, 0.495, 1.177> <-3.074, 0.486, 1.155> <-3.092, 0.488, 1.116> 
		<-3.000, 0.538, 1.017> <-3.028, 0.538, 1.017> <-3.065, 0.533, 0.985> <-3.092, 0.524, 0.984> 
		<-3.000, 0.558, 0.883> <-3.028, 0.559, 0.883> <-3.065, 0.546, 0.884> <-3.092, 0.537, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.000, 0.558, 0.883> <-3.028, 0.559, 0.883> <-3.065, 0.546, 0.884> <-3.092, 0.537, 0.883> 
		<-3.000, 0.572, 0.791> <-3.028, 0.572, 0.791> <-3.065, 0.555, 0.810> <-3.092, 0.546, 0.809> 
		<-3.000, 0.582, 0.668> <-3.034, 0.580, 0.674> <-3.065, 0.558, 0.690> <-3.092, 0.545, 0.708> 
		<-3.000, 0.580, 0.575> <-3.034, 0.578, 0.582> <-3.065, 0.554, 0.615> <-3.092, 0.542, 0.634> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.000, 0.580, 0.575> <-3.034, 0.578, 0.582> <-3.065, 0.554, 0.615> <-3.092, 0.542, 0.634> 
		<-3.000, 0.579, 0.524> <-3.034, 0.577, 0.531> <-3.065, 0.553, 0.577> <-3.092, 0.541, 0.595> 
		<-3.000, 0.575, 0.468> <-3.038, 0.574, 0.484> <-3.066, 0.543, 0.523> <-3.092, 0.535, 0.555> 
		<-3.000, 0.547, 0.407> <-3.038, 0.547, 0.423> <-3.066, 0.528, 0.475> <-3.092, 0.521, 0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.000, 0.547, 0.407> <-3.038, 0.547, 0.423> <-3.066, 0.528, 0.475> <-3.092, 0.521, 0.507> 
		<-3.000, 0.534, 0.378> <-3.038, 0.534, 0.394> <-3.066, 0.519, 0.444> <-3.092, 0.511, 0.476> 
		<-3.000, 0.486, 0.337> <-3.034, 0.486, 0.348> <-3.069, 0.485, 0.385> <-3.092, 0.485, 0.412> 
		<-3.000, 0.483, 0.358> <-3.034, 0.483, 0.369> <-3.069, 0.483, 0.406> <-3.092, 0.483, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.000, 0.483, 0.358> <-3.034, 0.483, 0.369> <-3.069, 0.483, 0.406> <-3.092, 0.483, 0.433> 
		<-3.000, 0.467, 0.467> <-3.034, 0.467, 0.478> <-3.069, 0.474, 0.496> <-3.092, 0.474, 0.524> 
		<-3.000, 0.498, 0.433> <-3.027, 0.498, 0.433> <-3.064, 0.497, 0.495> <-3.092, 0.498, 0.495> 
		<-3.000, 0.492, 0.786> <-3.027, 0.492, 0.786> <-3.064, 0.492, 0.786> <-3.092, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.159, 0.483, 0.990> <-3.139, 0.479, 1.058> <-3.122, 0.470, 1.152> <-3.092, 0.467, 1.216> 
		<-3.169, 0.487, 0.929> <-3.149, 0.482, 0.997> <-3.122, 0.478, 1.023> <-3.092, 0.475, 1.087> 
		<-3.195, 0.495, 0.957> <-3.165, 0.494, 0.957> <-3.122, 0.485, 1.141> <-3.092, 0.485, 1.141> 
		<-3.192, 0.495, 0.786> <-3.162, 0.494, 0.786> <-3.122, 0.492, 0.786> <-3.092, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.159, 0.483, 0.990> <-3.166, 0.487, 0.956> <-3.181, 0.495, 0.910> <-3.184, 0.497, 0.874> 
		<-3.139, 0.479, 1.058> <-3.146, 0.483, 1.023> <-3.153, 0.507, 0.913> <-3.156, 0.509, 0.877> 
		<-3.122, 0.470, 1.152> <-3.122, 0.491, 1.052> <-3.120, 0.514, 0.983> <-3.120, 0.527, 0.881> 
		<-3.092, 0.467, 1.216> <-3.092, 0.488, 1.116> <-3.092, 0.524, 0.984> <-3.092, 0.537, 0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.184, 0.497, 0.874> <-3.188, 0.499, 0.823> <-3.186, 0.497, 0.753> <-3.184, 0.497, 0.701> 
		<-3.156, 0.509, 0.877> <-3.161, 0.511, 0.825> <-3.158, 0.511, 0.733> <-3.156, 0.510, 0.680> 
		<-3.120, 0.527, 0.881> <-3.120, 0.537, 0.807> <-3.120, 0.533, 0.728> <-3.120, 0.529, 0.653> 
		<-3.092, 0.537, 0.883> <-3.092, 0.546, 0.809> <-3.092, 0.545, 0.708> <-3.092, 0.542, 0.634> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.184, 0.497, 0.701> <-3.183, 0.496, 0.677> <-3.181, 0.496, 0.653> <-3.175, 0.494, 0.624> 
		<-3.156, 0.510, 0.680> <-3.155, 0.510, 0.657> <-3.156, 0.504, 0.618> <-3.150, 0.502, 0.589> 
		<-3.120, 0.529, 0.653> <-3.120, 0.528, 0.615> <-3.119, 0.527, 0.589> <-3.119, 0.512, 0.541> 
		<-3.092, 0.542, 0.634> <-3.092, 0.541, 0.595> <-3.092, 0.535, 0.555> <-3.092, 0.521, 0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.175, 0.494, 0.624> <-3.168, 0.491, 0.588> <-3.148, 0.483, 0.509> <-3.150, 0.483, 0.534> 
		<-3.150, 0.502, 0.589> <-3.143, 0.499, 0.553> <-3.130, 0.483, 0.479> <-3.133, 0.483, 0.503> 
		<-3.119, 0.512, 0.541> <-3.119, 0.503, 0.510> <-3.115, 0.485, 0.438> <-3.115, 0.483, 0.460> 
		<-3.092, 0.521, 0.507> <-3.092, 0.511, 0.476> <-3.092, 0.485, 0.412> <-3.092, 0.483, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.150, 0.483, 0.534> <-3.157, 0.483, 0.599> <-3.188, 0.494, 0.575> <-3.192, 0.495, 0.786> 
		<-3.133, 0.483, 0.503> <-3.140, 0.483, 0.569> <-3.158, 0.494, 0.575> <-3.162, 0.494, 0.786> 
		<-3.115, 0.483, 0.460> <-3.115, 0.474, 0.550> <-3.122, 0.498, 0.495> <-3.122, 0.492, 0.786> 
		<-3.092, 0.483, 0.433> <-3.092, 0.474, 0.524> <-3.092, 0.498, 0.495> <-3.092, 0.492, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.447, 1.199> <0.086, -0.447, 1.199> <0.216, -0.447, 1.164> <0.282, -0.447, 1.216> 
		<0.001, -0.440, 1.148> <0.086, -0.440, 1.148> <0.192, -0.440, 1.107> <0.258, -0.440, 1.160> 
		<0.001, -0.426, 1.171> <0.061, -0.426, 1.171> <0.163, -0.427, 1.197> <0.222, -0.427, 1.197> 
		<0.001, -0.423, 1.028> <0.061, -0.423, 1.028> <0.141, -0.423, 1.028> <0.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.447, 1.199> <0.001, -0.440, 1.148> <0.001, -0.426, 1.171> <0.001, -0.423, 1.028> 
		<-0.084, -0.447, 1.199> <-0.084, -0.440, 1.148> <-0.059, -0.426, 1.171> <-0.059, -0.423, 1.028> 
		<-0.214, -0.447, 1.163> <-0.190, -0.440, 1.107> <-0.161, -0.427, 1.197> <-0.139, -0.423, 1.028> 
		<-0.281, -0.447, 1.216> <-0.256, -0.440, 1.160> <-0.221, -0.427, 1.197> <-0.199, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.447, 1.199> <0.001, -0.420, 1.177> <0.001, -0.367, 1.159> <0.001, -0.357, 1.125> 
		<0.086, -0.447, 1.199> <0.086, -0.420, 1.177> <0.061, -0.367, 1.159> <0.061, -0.357, 1.125> 
		<0.216, -0.447, 1.164> <0.192, -0.420, 1.136> <0.150, -0.369, 1.168> <0.141, -0.357, 1.125> 
		<0.282, -0.447, 1.216> <0.258, -0.420, 1.189> <0.209, -0.369, 1.168> <0.200, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.447, 1.199> <-0.084, -0.447, 1.199> <-0.214, -0.447, 1.163> <-0.281, -0.447, 1.216> 
		<0.001, -0.420, 1.177> <-0.084, -0.420, 1.177> <-0.190, -0.420, 1.136> <-0.256, -0.420, 1.189> 
		<0.001, -0.367, 1.159> <-0.059, -0.367, 1.159> <-0.148, -0.369, 1.168> <-0.208, -0.369, 1.168> 
		<0.001, -0.357, 1.125> <-0.059, -0.357, 1.125> <-0.139, -0.357, 1.125> <-0.199, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.357, 1.125> <-0.059, -0.357, 1.125> <-0.139, -0.357, 1.125> <-0.199, -0.357, 1.125> 
		<0.001, -0.331, 1.036> <-0.059, -0.331, 1.036> <-0.121, -0.332, 1.038> <-0.181, -0.332, 1.038> 
		<0.001, -0.333, 0.910> <-0.059, -0.333, 0.910> <-0.139, -0.333, 0.910> <-0.199, -0.333, 0.910> 
		<0.001, -0.335, 0.818> <-0.059, -0.335, 0.818> <-0.139, -0.335, 0.818> <-0.199, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.357, 1.125> <0.001, -0.331, 1.036> <0.001, -0.333, 0.910> <0.001, -0.335, 0.818> 
		<0.061, -0.357, 1.125> <0.061, -0.331, 1.036> <0.061, -0.333, 0.910> <0.061, -0.335, 0.818> 
		<0.141, -0.357, 1.125> <0.123, -0.332, 1.038> <0.141, -0.333, 0.910> <0.141, -0.335, 0.818> 
		<0.200, -0.357, 1.125> <0.182, -0.332, 1.038> <0.200, -0.333, 0.910> <0.200, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.335, 0.818> <0.001, -0.336, 0.759> <0.001, -0.338, 0.695> <0.001, -0.368, 0.624> 
		<0.061, -0.335, 0.818> <0.061, -0.336, 0.759> <0.061, -0.338, 0.695> <0.061, -0.368, 0.624> 
		<0.141, -0.335, 0.818> <0.141, -0.336, 0.759> <0.141, -0.338, 0.695> <0.141, -0.368, 0.624> 
		<0.200, -0.335, 0.818> <0.200, -0.336, 0.759> <0.200, -0.338, 0.695> <0.200, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.335, 0.818> <-0.059, -0.335, 0.818> <-0.139, -0.335, 0.818> <-0.199, -0.335, 0.818> 
		<0.001, -0.336, 0.759> <-0.059, -0.336, 0.759> <-0.139, -0.336, 0.759> <-0.199, -0.336, 0.759> 
		<0.001, -0.338, 0.695> <-0.059, -0.338, 0.695> <-0.139, -0.338, 0.695> <-0.199, -0.338, 0.695> 
		<0.001, -0.368, 0.624> <-0.059, -0.368, 0.624> <-0.139, -0.368, 0.624> <-0.199, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.368, 0.624> <0.001, -0.379, 0.597> <0.001, -0.429, 0.564> <0.001, -0.432, 0.584> 
		<0.061, -0.368, 0.624> <0.061, -0.379, 0.597> <0.061, -0.429, 0.564> <0.061, -0.432, 0.584> 
		<0.141, -0.368, 0.624> <0.141, -0.379, 0.597> <0.141, -0.429, 0.564> <0.141, -0.432, 0.584> 
		<0.200, -0.368, 0.624> <0.200, -0.379, 0.597> <0.200, -0.429, 0.564> <0.200, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.368, 0.624> <-0.059, -0.368, 0.624> <-0.139, -0.368, 0.624> <-0.199, -0.368, 0.624> 
		<0.001, -0.379, 0.597> <-0.059, -0.379, 0.597> <-0.139, -0.379, 0.597> <-0.199, -0.379, 0.597> 
		<0.001, -0.429, 0.564> <-0.059, -0.429, 0.564> <-0.139, -0.429, 0.564> <-0.199, -0.429, 0.564> 
		<0.001, -0.432, 0.584> <-0.059, -0.432, 0.584> <-0.139, -0.432, 0.584> <-0.199, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.432, 0.584> <0.001, -0.448, 0.697> <0.001, -0.414, 0.662> <0.001, -0.423, 1.028> 
		<0.061, -0.432, 0.584> <0.061, -0.448, 0.697> <0.061, -0.414, 0.662> <0.061, -0.423, 1.028> 
		<0.141, -0.432, 0.584> <0.141, -0.448, 0.697> <0.094, -0.414, 0.665> <0.141, -0.423, 1.028> 
		<0.200, -0.432, 0.584> <0.200, -0.448, 0.697> <0.153, -0.414, 0.665> <0.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, -0.432, 0.584> <-0.059, -0.432, 0.584> <-0.139, -0.432, 0.584> <-0.199, -0.432, 0.584> 
		<0.001, -0.448, 0.697> <-0.059, -0.448, 0.697> <-0.139, -0.448, 0.697> <-0.199, -0.448, 0.697> 
		<0.001, -0.414, 0.662> <-0.059, -0.414, 0.662> <-0.092, -0.414, 0.665> <-0.152, -0.414, 0.665> 
		<0.001, -0.423, 1.028> <-0.059, -0.423, 1.028> <-0.139, -0.423, 1.028> <-0.199, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.282, -0.447, 1.216> <0.358, -0.447, 1.276> <0.337, -0.447, 1.444> <0.400, -0.447, 1.517> 
		<0.258, -0.440, 1.160> <0.334, -0.440, 1.220> <0.337, -0.440, 1.297> <0.400, -0.440, 1.370> 
		<0.222, -0.427, 1.197> <0.282, -0.427, 1.197> <0.340, -0.429, 1.431> <0.400, -0.429, 1.431> 
		<0.200, -0.423, 1.028> <0.260, -0.423, 1.028> <0.340, -0.423, 1.028> <0.400, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.282, -0.447, 1.216> <0.258, -0.420, 1.189> <0.209, -0.369, 1.168> <0.200, -0.357, 1.125> 
		<0.358, -0.447, 1.276> <0.334, -0.420, 1.249> <0.269, -0.369, 1.168> <0.260, -0.357, 1.125> 
		<0.337, -0.447, 1.444> <0.337, -0.420, 1.326> <0.341, -0.372, 1.244> <0.341, -0.353, 1.125> 
		<0.400, -0.447, 1.517> <0.400, -0.420, 1.399> <0.400, -0.376, 1.244> <0.400, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, -0.357, 1.125> <0.182, -0.332, 1.038> <0.200, -0.333, 0.910> <0.200, -0.335, 0.818> 
		<0.260, -0.357, 1.125> <0.242, -0.332, 1.038> <0.260, -0.333, 0.910> <0.260, -0.335, 0.818> 
		<0.341, -0.353, 1.125> <0.341, -0.338, 1.034> <0.341, -0.329, 0.910> <0.341, -0.331, 0.818> 
		<0.400, -0.357, 1.125> <0.400, -0.342, 1.034> <0.400, -0.333, 0.910> <0.400, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, -0.335, 0.818> <0.200, -0.336, 0.759> <0.200, -0.338, 0.695> <0.200, -0.368, 0.624> 
		<0.260, -0.335, 0.818> <0.260, -0.336, 0.759> <0.260, -0.338, 0.695> <0.260, -0.368, 0.624> 
		<0.341, -0.331, 0.818> <0.341, -0.333, 0.759> <0.341, -0.334, 0.695> <0.341, -0.364, 0.624> 
		<0.400, -0.335, 0.818> <0.400, -0.336, 0.759> <0.400, -0.338, 0.695> <0.400, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, -0.368, 0.624> <0.200, -0.379, 0.597> <0.200, -0.429, 0.564> <0.200, -0.432, 0.584> 
		<0.260, -0.368, 0.624> <0.260, -0.379, 0.597> <0.260, -0.429, 0.564> <0.260, -0.432, 0.584> 
		<0.341, -0.364, 0.624> <0.341, -0.375, 0.597> <0.340, -0.429, 0.564> <0.340, -0.432, 0.584> 
		<0.400, -0.368, 0.624> <0.400, -0.379, 0.597> <0.400, -0.429, 0.564> <0.400, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, -0.432, 0.584> <0.200, -0.448, 0.697> <0.153, -0.414, 0.665> <0.200, -0.423, 1.028> 
		<0.260, -0.432, 0.584> <0.260, -0.448, 0.697> <0.213, -0.414, 0.665> <0.260, -0.423, 1.028> 
		<0.340, -0.432, 0.584> <0.340, -0.448, 0.697> <0.340, -0.417, 0.662> <0.340, -0.423, 1.028> 
		<0.400, -0.432, 0.584> <0.400, -0.448, 0.697> <0.400, -0.417, 0.662> <0.400, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.447, 1.517> <0.442, -0.447, 1.565> <0.538, -0.447, 1.576> <0.600, -0.447, 1.584> 
		<0.400, -0.440, 1.370> <0.442, -0.440, 1.418> <0.538, -0.440, 1.409> <0.600, -0.440, 1.417> 
		<0.400, -0.429, 1.431> <0.460, -0.429, 1.431> <0.540, -0.430, 1.486> <0.600, -0.430, 1.486> 
		<0.400, -0.423, 1.028> <0.460, -0.423, 1.028> <0.540, -0.423, 1.028> <0.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.447, 1.517> <0.400, -0.420, 1.399> <0.400, -0.376, 1.244> <0.400, -0.357, 1.125> 
		<0.442, -0.447, 1.565> <0.442, -0.420, 1.447> <0.461, -0.380, 1.244> <0.461, -0.361, 1.125> 
		<0.538, -0.447, 1.576> <0.538, -0.428, 1.438> <0.540, -0.398, 1.263> <0.540, -0.382, 1.125> 
		<0.600, -0.447, 1.584> <0.600, -0.428, 1.446> <0.600, -0.398, 1.263> <0.600, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.357, 1.125> <0.400, -0.342, 1.034> <0.400, -0.333, 0.910> <0.400, -0.335, 0.818> 
		<0.461, -0.361, 1.125> <0.461, -0.346, 1.034> <0.461, -0.337, 0.910> <0.461, -0.339, 0.818> 
		<0.540, -0.382, 1.125> <0.540, -0.372, 1.033> <0.540, -0.359, 0.910> <0.540, -0.361, 0.818> 
		<0.600, -0.382, 1.125> <0.600, -0.372, 1.033> <0.600, -0.359, 0.910> <0.600, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.335, 0.818> <0.400, -0.336, 0.759> <0.400, -0.338, 0.695> <0.400, -0.368, 0.624> 
		<0.461, -0.339, 0.818> <0.461, -0.340, 0.759> <0.461, -0.342, 0.695> <0.461, -0.371, 0.624> 
		<0.540, -0.361, 0.818> <0.540, -0.362, 0.759> <0.540, -0.371, 0.697> <0.540, -0.393, 0.624> 
		<0.600, -0.361, 0.818> <0.600, -0.362, 0.759> <0.600, -0.371, 0.697> <0.600, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.368, 0.624> <0.400, -0.379, 0.597> <0.400, -0.429, 0.564> <0.400, -0.432, 0.584> 
		<0.461, -0.371, 0.624> <0.461, -0.383, 0.597> <0.460, -0.429, 0.564> <0.460, -0.432, 0.584> 
		<0.540, -0.393, 0.624> <0.540, -0.399, 0.603> <0.540, -0.431, 0.569> <0.540, -0.432, 0.584> 
		<0.600, -0.393, 0.624> <0.600, -0.399, 0.603> <0.600, -0.431, 0.569> <0.600, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.432, 0.584> <0.400, -0.448, 0.697> <0.400, -0.417, 0.662> <0.400, -0.423, 1.028> 
		<0.460, -0.432, 0.584> <0.460, -0.448, 0.697> <0.460, -0.417, 0.662> <0.460, -0.423, 1.028> 
		<0.540, -0.432, 0.584> <0.540, -0.440, 0.698> <0.540, -0.417, 0.662> <0.540, -0.423, 1.028> 
		<0.600, -0.432, 0.584> <0.600, -0.440, 0.698> <0.600, -0.417, 0.662> <0.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.447, 1.584> <0.660, -0.447, 1.591> <0.740, -0.447, 1.567> <0.800, -0.447, 1.567> 
		<0.600, -0.440, 1.417> <0.660, -0.440, 1.424> <0.740, -0.440, 1.405> <0.800, -0.440, 1.405> 
		<0.600, -0.430, 1.486> <0.660, -0.430, 1.486> <0.740, -0.430, 1.472> <0.800, -0.430, 1.472> 
		<0.600, -0.423, 1.028> <0.660, -0.423, 1.028> <0.740, -0.423, 1.028> <0.800, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.447, 1.584> <0.600, -0.428, 1.446> <0.600, -0.398, 1.263> <0.600, -0.382, 1.125> 
		<0.660, -0.447, 1.591> <0.660, -0.428, 1.454> <0.661, -0.398, 1.263> <0.661, -0.382, 1.125> 
		<0.740, -0.447, 1.567> <0.740, -0.420, 1.434> <0.740, -0.377, 1.259> <0.740, -0.357, 1.125> 
		<0.800, -0.447, 1.567> <0.800, -0.420, 1.434> <0.800, -0.377, 1.259> <0.800, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.382, 1.125> <0.600, -0.372, 1.033> <0.600, -0.359, 0.910> <0.600, -0.361, 0.818> 
		<0.661, -0.382, 1.125> <0.661, -0.372, 1.033> <0.661, -0.359, 0.910> <0.661, -0.361, 0.818> 
		<0.740, -0.357, 1.125> <0.740, -0.343, 1.034> <0.740, -0.333, 0.910> <0.740, -0.335, 0.818> 
		<0.800, -0.357, 1.125> <0.800, -0.343, 1.034> <0.800, -0.333, 0.910> <0.800, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.361, 0.818> <0.600, -0.362, 0.759> <0.600, -0.371, 0.697> <0.600, -0.393, 0.624> 
		<0.661, -0.361, 0.818> <0.661, -0.362, 0.759> <0.661, -0.371, 0.697> <0.661, -0.393, 0.624> 
		<0.740, -0.335, 0.818> <0.740, -0.336, 0.759> <0.740, -0.338, 0.695> <0.740, -0.368, 0.624> 
		<0.800, -0.335, 0.818> <0.800, -0.336, 0.759> <0.800, -0.338, 0.695> <0.800, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.393, 0.624> <0.600, -0.399, 0.603> <0.600, -0.431, 0.569> <0.600, -0.432, 0.584> 
		<0.661, -0.393, 0.624> <0.661, -0.399, 0.603> <0.660, -0.431, 0.569> <0.660, -0.432, 0.584> 
		<0.740, -0.368, 0.624> <0.740, -0.379, 0.597> <0.740, -0.429, 0.564> <0.740, -0.432, 0.584> 
		<0.800, -0.368, 0.624> <0.800, -0.379, 0.597> <0.800, -0.429, 0.564> <0.800, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.432, 0.584> <0.600, -0.440, 0.698> <0.600, -0.417, 0.662> <0.600, -0.423, 1.028> 
		<0.660, -0.432, 0.584> <0.660, -0.440, 0.698> <0.660, -0.417, 0.662> <0.660, -0.423, 1.028> 
		<0.740, -0.432, 0.584> <0.740, -0.448, 0.697> <0.740, -0.417, 0.662> <0.740, -0.423, 1.028> 
		<0.800, -0.432, 0.584> <0.800, -0.448, 0.697> <0.800, -0.417, 0.662> <0.800, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -0.447, 1.567> <0.861, -0.447, 1.567> <0.940, -0.447, 1.584> <1.000, -0.447, 1.584> 
		<0.800, -0.440, 1.405> <0.861, -0.440, 1.405> <0.940, -0.440, 1.417> <1.000, -0.440, 1.417> 
		<0.800, -0.430, 1.472> <0.860, -0.430, 1.472> <0.940, -0.430, 1.486> <1.000, -0.430, 1.486> 
		<0.800, -0.423, 1.028> <0.860, -0.423, 1.028> <0.940, -0.423, 1.028> <1.000, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -0.447, 1.567> <0.800, -0.420, 1.434> <0.800, -0.377, 1.259> <0.800, -0.357, 1.125> 
		<0.861, -0.447, 1.567> <0.861, -0.420, 1.434> <0.861, -0.377, 1.259> <0.861, -0.357, 1.125> 
		<0.940, -0.447, 1.584> <0.940, -0.428, 1.446> <0.940, -0.398, 1.263> <0.940, -0.382, 1.125> 
		<1.000, -0.447, 1.584> <1.000, -0.428, 1.446> <1.000, -0.398, 1.263> <1.000, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -0.357, 1.125> <0.800, -0.343, 1.034> <0.800, -0.333, 0.910> <0.800, -0.335, 0.818> 
		<0.861, -0.357, 1.125> <0.861, -0.343, 1.034> <0.861, -0.333, 0.910> <0.861, -0.335, 0.818> 
		<0.940, -0.382, 1.125> <0.940, -0.372, 1.033> <0.940, -0.359, 0.910> <0.940, -0.361, 0.818> 
		<1.000, -0.382, 1.125> <1.000, -0.372, 1.033> <1.000, -0.359, 0.910> <1.000, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -0.335, 0.818> <0.800, -0.336, 0.759> <0.800, -0.338, 0.695> <0.800, -0.368, 0.624> 
		<0.861, -0.335, 0.818> <0.861, -0.336, 0.759> <0.861, -0.338, 0.695> <0.861, -0.368, 0.624> 
		<0.940, -0.361, 0.818> <0.940, -0.362, 0.759> <0.940, -0.371, 0.697> <0.940, -0.393, 0.624> 
		<1.000, -0.361, 0.818> <1.000, -0.362, 0.759> <1.000, -0.371, 0.697> <1.000, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -0.368, 0.624> <0.800, -0.379, 0.597> <0.800, -0.429, 0.564> <0.800, -0.432, 0.584> 
		<0.861, -0.368, 0.624> <0.861, -0.379, 0.597> <0.860, -0.429, 0.564> <0.860, -0.432, 0.584> 
		<0.940, -0.393, 0.624> <0.940, -0.399, 0.603> <0.940, -0.431, 0.569> <0.940, -0.432, 0.584> 
		<1.000, -0.393, 0.624> <1.000, -0.399, 0.603> <1.000, -0.431, 0.569> <1.000, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -0.432, 0.584> <0.800, -0.448, 0.697> <0.800, -0.417, 0.662> <0.800, -0.423, 1.028> 
		<0.860, -0.432, 0.584> <0.860, -0.448, 0.697> <0.860, -0.417, 0.662> <0.860, -0.423, 1.028> 
		<0.940, -0.432, 0.584> <0.940, -0.440, 0.698> <0.940, -0.417, 0.662> <0.940, -0.423, 1.028> 
		<1.000, -0.432, 0.584> <1.000, -0.440, 0.698> <1.000, -0.417, 0.662> <1.000, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, -0.447, 1.584> <1.061, -0.447, 1.584> <1.140, -0.447, 1.567> <1.200, -0.447, 1.567> 
		<1.000, -0.440, 1.417> <1.061, -0.440, 1.417> <1.140, -0.440, 1.405> <1.200, -0.440, 1.405> 
		<1.000, -0.430, 1.486> <1.060, -0.430, 1.486> <1.140, -0.430, 1.472> <1.200, -0.430, 1.472> 
		<1.000, -0.423, 1.028> <1.060, -0.423, 1.028> <1.140, -0.423, 1.028> <1.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, -0.447, 1.584> <1.000, -0.428, 1.446> <1.000, -0.398, 1.263> <1.000, -0.382, 1.125> 
		<1.061, -0.447, 1.584> <1.061, -0.428, 1.446> <1.061, -0.398, 1.263> <1.061, -0.382, 1.125> 
		<1.140, -0.447, 1.567> <1.140, -0.420, 1.434> <1.140, -0.377, 1.259> <1.140, -0.357, 1.125> 
		<1.200, -0.447, 1.567> <1.200, -0.420, 1.434> <1.200, -0.377, 1.259> <1.200, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, -0.382, 1.125> <1.000, -0.372, 1.033> <1.000, -0.359, 0.910> <1.000, -0.361, 0.818> 
		<1.061, -0.382, 1.125> <1.061, -0.372, 1.033> <1.061, -0.359, 0.910> <1.061, -0.361, 0.818> 
		<1.140, -0.357, 1.125> <1.140, -0.343, 1.034> <1.140, -0.333, 0.910> <1.140, -0.335, 0.818> 
		<1.200, -0.357, 1.125> <1.200, -0.343, 1.034> <1.200, -0.333, 0.910> <1.200, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, -0.361, 0.818> <1.000, -0.362, 0.759> <1.000, -0.371, 0.697> <1.000, -0.393, 0.624> 
		<1.061, -0.361, 0.818> <1.061, -0.362, 0.759> <1.061, -0.371, 0.697> <1.061, -0.393, 0.624> 
		<1.140, -0.335, 0.818> <1.140, -0.336, 0.759> <1.140, -0.338, 0.695> <1.140, -0.368, 0.624> 
		<1.200, -0.335, 0.818> <1.200, -0.336, 0.759> <1.200, -0.338, 0.695> <1.200, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, -0.393, 0.624> <1.000, -0.399, 0.603> <1.000, -0.431, 0.569> <1.000, -0.432, 0.584> 
		<1.061, -0.393, 0.624> <1.061, -0.399, 0.603> <1.060, -0.431, 0.569> <1.060, -0.432, 0.584> 
		<1.140, -0.368, 0.624> <1.140, -0.379, 0.597> <1.140, -0.429, 0.564> <1.140, -0.432, 0.584> 
		<1.200, -0.368, 0.624> <1.200, -0.379, 0.597> <1.200, -0.429, 0.564> <1.200, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, -0.432, 0.584> <1.000, -0.440, 0.698> <1.000, -0.417, 0.662> <1.000, -0.423, 1.028> 
		<1.060, -0.432, 0.584> <1.060, -0.440, 0.698> <1.060, -0.417, 0.662> <1.060, -0.423, 1.028> 
		<1.140, -0.432, 0.584> <1.140, -0.448, 0.697> <1.140, -0.417, 0.662> <1.140, -0.423, 1.028> 
		<1.200, -0.432, 0.584> <1.200, -0.448, 0.697> <1.200, -0.417, 0.662> <1.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.200, -0.447, 1.567> <1.261, -0.447, 1.567> <1.340, -0.447, 1.584> <1.400, -0.447, 1.584> 
		<1.200, -0.440, 1.405> <1.261, -0.440, 1.405> <1.340, -0.440, 1.417> <1.400, -0.440, 1.417> 
		<1.200, -0.430, 1.472> <1.260, -0.430, 1.472> <1.340, -0.430, 1.486> <1.400, -0.430, 1.486> 
		<1.200, -0.423, 1.028> <1.260, -0.423, 1.028> <1.340, -0.423, 1.028> <1.400, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.200, -0.447, 1.567> <1.200, -0.420, 1.434> <1.200, -0.377, 1.259> <1.200, -0.357, 1.125> 
		<1.261, -0.447, 1.567> <1.261, -0.420, 1.434> <1.261, -0.377, 1.259> <1.261, -0.357, 1.125> 
		<1.340, -0.447, 1.584> <1.340, -0.428, 1.446> <1.340, -0.398, 1.263> <1.340, -0.382, 1.125> 
		<1.400, -0.447, 1.584> <1.400, -0.428, 1.446> <1.400, -0.398, 1.263> <1.400, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.200, -0.357, 1.125> <1.200, -0.343, 1.034> <1.200, -0.333, 0.910> <1.200, -0.335, 0.818> 
		<1.261, -0.357, 1.125> <1.261, -0.343, 1.034> <1.261, -0.333, 0.910> <1.261, -0.335, 0.818> 
		<1.340, -0.382, 1.125> <1.340, -0.372, 1.033> <1.340, -0.359, 0.910> <1.340, -0.361, 0.818> 
		<1.400, -0.382, 1.125> <1.400, -0.372, 1.033> <1.400, -0.359, 0.910> <1.400, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.200, -0.335, 0.818> <1.200, -0.336, 0.759> <1.200, -0.338, 0.695> <1.200, -0.368, 0.624> 
		<1.261, -0.335, 0.818> <1.261, -0.336, 0.759> <1.261, -0.338, 0.695> <1.261, -0.368, 0.624> 
		<1.340, -0.361, 0.818> <1.340, -0.362, 0.759> <1.340, -0.371, 0.697> <1.340, -0.393, 0.624> 
		<1.400, -0.361, 0.818> <1.400, -0.362, 0.759> <1.400, -0.371, 0.697> <1.400, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.200, -0.368, 0.624> <1.200, -0.379, 0.597> <1.200, -0.429, 0.564> <1.200, -0.432, 0.584> 
		<1.261, -0.368, 0.624> <1.261, -0.379, 0.597> <1.260, -0.429, 0.564> <1.260, -0.432, 0.584> 
		<1.340, -0.393, 0.624> <1.340, -0.399, 0.603> <1.340, -0.431, 0.569> <1.340, -0.432, 0.584> 
		<1.400, -0.393, 0.624> <1.400, -0.399, 0.603> <1.400, -0.431, 0.569> <1.400, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.200, -0.432, 0.584> <1.200, -0.448, 0.697> <1.200, -0.417, 0.662> <1.200, -0.423, 1.028> 
		<1.260, -0.432, 0.584> <1.260, -0.448, 0.697> <1.260, -0.417, 0.662> <1.260, -0.423, 1.028> 
		<1.340, -0.432, 0.584> <1.340, -0.440, 0.698> <1.340, -0.417, 0.662> <1.340, -0.423, 1.028> 
		<1.400, -0.432, 0.584> <1.400, -0.440, 0.698> <1.400, -0.417, 0.662> <1.400, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.447, 1.584> <1.461, -0.447, 1.584> <1.540, -0.447, 1.567> <1.600, -0.447, 1.567> 
		<1.400, -0.440, 1.417> <1.461, -0.440, 1.417> <1.540, -0.440, 1.405> <1.600, -0.440, 1.405> 
		<1.400, -0.430, 1.486> <1.460, -0.430, 1.486> <1.540, -0.430, 1.472> <1.600, -0.430, 1.472> 
		<1.400, -0.423, 1.028> <1.460, -0.423, 1.028> <1.540, -0.423, 1.028> <1.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.447, 1.584> <1.400, -0.428, 1.446> <1.400, -0.398, 1.263> <1.400, -0.382, 1.125> 
		<1.461, -0.447, 1.584> <1.461, -0.428, 1.446> <1.461, -0.398, 1.263> <1.461, -0.382, 1.125> 
		<1.540, -0.447, 1.567> <1.540, -0.420, 1.434> <1.540, -0.377, 1.259> <1.540, -0.357, 1.125> 
		<1.600, -0.447, 1.567> <1.600, -0.420, 1.434> <1.600, -0.377, 1.259> <1.600, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.382, 1.125> <1.400, -0.372, 1.033> <1.400, -0.359, 0.910> <1.400, -0.361, 0.818> 
		<1.461, -0.382, 1.125> <1.461, -0.372, 1.033> <1.461, -0.359, 0.910> <1.461, -0.361, 0.818> 
		<1.540, -0.357, 1.125> <1.540, -0.343, 1.034> <1.540, -0.333, 0.910> <1.540, -0.335, 0.818> 
		<1.600, -0.357, 1.125> <1.600, -0.343, 1.034> <1.600, -0.333, 0.910> <1.600, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.361, 0.818> <1.400, -0.362, 0.759> <1.400, -0.371, 0.697> <1.400, -0.393, 0.624> 
		<1.461, -0.361, 0.818> <1.461, -0.362, 0.759> <1.461, -0.371, 0.697> <1.461, -0.393, 0.624> 
		<1.540, -0.335, 0.818> <1.540, -0.336, 0.759> <1.540, -0.338, 0.695> <1.540, -0.368, 0.624> 
		<1.600, -0.335, 0.818> <1.600, -0.336, 0.759> <1.600, -0.338, 0.695> <1.600, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.393, 0.624> <1.400, -0.399, 0.603> <1.400, -0.431, 0.569> <1.400, -0.432, 0.584> 
		<1.461, -0.393, 0.624> <1.461, -0.399, 0.603> <1.460, -0.431, 0.569> <1.460, -0.432, 0.584> 
		<1.540, -0.368, 0.624> <1.540, -0.379, 0.597> <1.540, -0.429, 0.564> <1.540, -0.432, 0.584> 
		<1.600, -0.368, 0.624> <1.600, -0.379, 0.597> <1.600, -0.429, 0.564> <1.600, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.432, 0.584> <1.400, -0.440, 0.698> <1.400, -0.417, 0.662> <1.400, -0.423, 1.028> 
		<1.460, -0.432, 0.584> <1.460, -0.440, 0.698> <1.460, -0.417, 0.662> <1.460, -0.423, 1.028> 
		<1.540, -0.432, 0.584> <1.540, -0.448, 0.697> <1.540, -0.417, 0.662> <1.540, -0.423, 1.028> 
		<1.600, -0.432, 0.584> <1.600, -0.448, 0.697> <1.600, -0.417, 0.662> <1.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.447, 1.567> <1.661, -0.447, 1.567> <1.740, -0.447, 1.584> <1.800, -0.447, 1.584> 
		<1.600, -0.440, 1.405> <1.661, -0.440, 1.405> <1.740, -0.440, 1.417> <1.800, -0.440, 1.417> 
		<1.600, -0.430, 1.472> <1.660, -0.430, 1.472> <1.740, -0.430, 1.486> <1.800, -0.430, 1.486> 
		<1.600, -0.423, 1.028> <1.660, -0.423, 1.028> <1.740, -0.423, 1.028> <1.800, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.447, 1.567> <1.600, -0.420, 1.434> <1.600, -0.377, 1.259> <1.600, -0.357, 1.125> 
		<1.661, -0.447, 1.567> <1.661, -0.420, 1.434> <1.661, -0.377, 1.259> <1.661, -0.357, 1.125> 
		<1.740, -0.447, 1.584> <1.740, -0.428, 1.446> <1.740, -0.398, 1.263> <1.740, -0.382, 1.125> 
		<1.800, -0.447, 1.584> <1.800, -0.428, 1.446> <1.800, -0.398, 1.263> <1.800, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.357, 1.125> <1.600, -0.343, 1.034> <1.600, -0.333, 0.910> <1.600, -0.335, 0.818> 
		<1.661, -0.357, 1.125> <1.661, -0.343, 1.034> <1.661, -0.333, 0.910> <1.661, -0.335, 0.818> 
		<1.740, -0.382, 1.125> <1.740, -0.372, 1.033> <1.740, -0.359, 0.910> <1.740, -0.361, 0.818> 
		<1.800, -0.382, 1.125> <1.800, -0.372, 1.033> <1.800, -0.359, 0.910> <1.800, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.335, 0.818> <1.600, -0.336, 0.759> <1.600, -0.338, 0.695> <1.600, -0.368, 0.624> 
		<1.661, -0.335, 0.818> <1.661, -0.336, 0.759> <1.661, -0.338, 0.695> <1.661, -0.368, 0.624> 
		<1.740, -0.361, 0.818> <1.740, -0.362, 0.759> <1.740, -0.371, 0.697> <1.740, -0.393, 0.624> 
		<1.800, -0.361, 0.818> <1.800, -0.362, 0.759> <1.800, -0.371, 0.697> <1.800, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.368, 0.624> <1.600, -0.379, 0.597> <1.600, -0.429, 0.564> <1.600, -0.432, 0.584> 
		<1.661, -0.368, 0.624> <1.661, -0.379, 0.597> <1.660, -0.429, 0.564> <1.660, -0.432, 0.584> 
		<1.740, -0.393, 0.624> <1.740, -0.399, 0.603> <1.740, -0.431, 0.569> <1.740, -0.432, 0.584> 
		<1.800, -0.393, 0.624> <1.800, -0.399, 0.603> <1.800, -0.431, 0.569> <1.800, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.432, 0.584> <1.600, -0.448, 0.697> <1.600, -0.417, 0.662> <1.600, -0.423, 1.028> 
		<1.660, -0.432, 0.584> <1.660, -0.448, 0.697> <1.660, -0.417, 0.662> <1.660, -0.423, 1.028> 
		<1.740, -0.432, 0.584> <1.740, -0.440, 0.698> <1.740, -0.417, 0.662> <1.740, -0.423, 1.028> 
		<1.800, -0.432, 0.584> <1.800, -0.440, 0.698> <1.800, -0.417, 0.662> <1.800, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.447, 1.584> <1.861, -0.447, 1.584> <1.940, -0.447, 1.567> <2.000, -0.447, 1.567> 
		<1.800, -0.440, 1.417> <1.861, -0.440, 1.417> <1.940, -0.440, 1.405> <2.000, -0.440, 1.405> 
		<1.800, -0.430, 1.486> <1.860, -0.430, 1.486> <1.940, -0.430, 1.472> <2.000, -0.430, 1.472> 
		<1.800, -0.423, 1.028> <1.860, -0.423, 1.028> <1.940, -0.423, 1.028> <2.000, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.447, 1.584> <1.800, -0.428, 1.446> <1.800, -0.398, 1.263> <1.800, -0.382, 1.125> 
		<1.861, -0.447, 1.584> <1.861, -0.428, 1.446> <1.861, -0.398, 1.263> <1.861, -0.382, 1.125> 
		<1.940, -0.447, 1.567> <1.940, -0.420, 1.434> <1.940, -0.377, 1.259> <1.940, -0.357, 1.125> 
		<2.000, -0.447, 1.567> <2.000, -0.420, 1.434> <2.000, -0.377, 1.259> <2.000, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.382, 1.125> <1.800, -0.372, 1.033> <1.800, -0.359, 0.910> <1.800, -0.361, 0.818> 
		<1.861, -0.382, 1.125> <1.861, -0.372, 1.033> <1.861, -0.359, 0.910> <1.861, -0.361, 0.818> 
		<1.940, -0.357, 1.125> <1.940, -0.343, 1.034> <1.940, -0.333, 0.910> <1.940, -0.335, 0.818> 
		<2.000, -0.357, 1.125> <2.000, -0.343, 1.034> <2.000, -0.333, 0.910> <2.000, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.361, 0.818> <1.800, -0.362, 0.759> <1.800, -0.371, 0.697> <1.800, -0.393, 0.624> 
		<1.861, -0.361, 0.818> <1.861, -0.362, 0.759> <1.861, -0.371, 0.697> <1.861, -0.393, 0.624> 
		<1.940, -0.335, 0.818> <1.940, -0.336, 0.759> <1.940, -0.338, 0.695> <1.940, -0.368, 0.624> 
		<2.000, -0.335, 0.818> <2.000, -0.336, 0.759> <2.000, -0.338, 0.695> <2.000, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.393, 0.624> <1.800, -0.399, 0.603> <1.800, -0.431, 0.569> <1.800, -0.432, 0.584> 
		<1.861, -0.393, 0.624> <1.861, -0.399, 0.603> <1.860, -0.431, 0.569> <1.860, -0.432, 0.584> 
		<1.940, -0.368, 0.624> <1.940, -0.379, 0.597> <1.940, -0.429, 0.564> <1.940, -0.432, 0.584> 
		<2.000, -0.368, 0.624> <2.000, -0.379, 0.597> <2.000, -0.429, 0.564> <2.000, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.432, 0.584> <1.800, -0.440, 0.698> <1.800, -0.417, 0.662> <1.800, -0.423, 1.028> 
		<1.860, -0.432, 0.584> <1.860, -0.440, 0.698> <1.860, -0.417, 0.662> <1.860, -0.423, 1.028> 
		<1.940, -0.432, 0.584> <1.940, -0.448, 0.697> <1.940, -0.417, 0.662> <1.940, -0.423, 1.028> 
		<2.000, -0.432, 0.584> <2.000, -0.448, 0.697> <2.000, -0.417, 0.662> <2.000, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.447, 1.567> <2.061, -0.447, 1.567> <2.140, -0.447, 1.584> <2.200, -0.447, 1.584> 
		<2.000, -0.440, 1.405> <2.061, -0.440, 1.405> <2.140, -0.440, 1.417> <2.200, -0.440, 1.417> 
		<2.000, -0.430, 1.472> <2.060, -0.430, 1.472> <2.140, -0.430, 1.486> <2.200, -0.430, 1.486> 
		<2.000, -0.423, 1.028> <2.060, -0.423, 1.028> <2.140, -0.423, 1.028> <2.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.447, 1.567> <2.000, -0.420, 1.434> <2.000, -0.377, 1.259> <2.000, -0.357, 1.125> 
		<2.061, -0.447, 1.567> <2.061, -0.420, 1.434> <2.061, -0.377, 1.259> <2.061, -0.357, 1.125> 
		<2.140, -0.447, 1.584> <2.140, -0.428, 1.446> <2.140, -0.398, 1.263> <2.140, -0.382, 1.125> 
		<2.200, -0.447, 1.584> <2.200, -0.428, 1.446> <2.200, -0.398, 1.263> <2.200, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.357, 1.125> <2.000, -0.343, 1.034> <2.000, -0.333, 0.910> <2.000, -0.335, 0.818> 
		<2.061, -0.357, 1.125> <2.061, -0.343, 1.034> <2.061, -0.333, 0.910> <2.061, -0.335, 0.818> 
		<2.140, -0.382, 1.125> <2.140, -0.372, 1.033> <2.140, -0.359, 0.910> <2.140, -0.361, 0.818> 
		<2.200, -0.382, 1.125> <2.200, -0.372, 1.033> <2.200, -0.359, 0.910> <2.200, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.335, 0.818> <2.000, -0.336, 0.759> <2.000, -0.338, 0.695> <2.000, -0.368, 0.624> 
		<2.061, -0.335, 0.818> <2.061, -0.336, 0.759> <2.061, -0.338, 0.695> <2.061, -0.368, 0.624> 
		<2.140, -0.361, 0.818> <2.140, -0.362, 0.759> <2.140, -0.371, 0.697> <2.140, -0.393, 0.624> 
		<2.200, -0.361, 0.818> <2.200, -0.362, 0.759> <2.200, -0.371, 0.697> <2.200, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.368, 0.624> <2.000, -0.379, 0.597> <2.000, -0.429, 0.564> <2.000, -0.432, 0.584> 
		<2.061, -0.368, 0.624> <2.061, -0.379, 0.597> <2.060, -0.429, 0.564> <2.060, -0.432, 0.584> 
		<2.140, -0.393, 0.624> <2.140, -0.399, 0.603> <2.140, -0.431, 0.569> <2.140, -0.432, 0.584> 
		<2.200, -0.393, 0.624> <2.200, -0.399, 0.603> <2.200, -0.431, 0.569> <2.200, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.432, 0.584> <2.000, -0.448, 0.697> <2.000, -0.417, 0.662> <2.000, -0.423, 1.028> 
		<2.060, -0.432, 0.584> <2.060, -0.448, 0.697> <2.060, -0.417, 0.662> <2.060, -0.423, 1.028> 
		<2.140, -0.432, 0.584> <2.140, -0.440, 0.698> <2.140, -0.417, 0.662> <2.140, -0.423, 1.028> 
		<2.200, -0.432, 0.584> <2.200, -0.440, 0.698> <2.200, -0.417, 0.662> <2.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.200, -0.447, 1.584> <2.261, -0.447, 1.584> <2.340, -0.447, 1.567> <2.400, -0.447, 1.567> 
		<2.200, -0.440, 1.417> <2.261, -0.440, 1.417> <2.340, -0.440, 1.405> <2.400, -0.440, 1.405> 
		<2.200, -0.430, 1.486> <2.260, -0.430, 1.486> <2.340, -0.430, 1.472> <2.400, -0.430, 1.472> 
		<2.200, -0.423, 1.028> <2.260, -0.423, 1.028> <2.340, -0.423, 1.028> <2.400, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.200, -0.447, 1.584> <2.200, -0.428, 1.446> <2.200, -0.398, 1.263> <2.200, -0.382, 1.125> 
		<2.261, -0.447, 1.584> <2.261, -0.428, 1.446> <2.261, -0.398, 1.263> <2.261, -0.382, 1.125> 
		<2.340, -0.447, 1.567> <2.340, -0.420, 1.434> <2.340, -0.377, 1.259> <2.340, -0.357, 1.125> 
		<2.400, -0.447, 1.567> <2.400, -0.420, 1.434> <2.400, -0.377, 1.259> <2.400, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.200, -0.382, 1.125> <2.200, -0.372, 1.033> <2.200, -0.359, 0.910> <2.200, -0.361, 0.818> 
		<2.261, -0.382, 1.125> <2.261, -0.372, 1.033> <2.261, -0.359, 0.910> <2.261, -0.361, 0.818> 
		<2.340, -0.357, 1.125> <2.340, -0.343, 1.034> <2.340, -0.333, 0.909> <2.340, -0.335, 0.817> 
		<2.400, -0.357, 1.125> <2.400, -0.343, 1.034> <2.400, -0.333, 0.910> <2.400, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.200, -0.361, 0.818> <2.200, -0.362, 0.759> <2.200, -0.371, 0.697> <2.200, -0.393, 0.624> 
		<2.261, -0.361, 0.818> <2.261, -0.362, 0.759> <2.261, -0.371, 0.697> <2.261, -0.393, 0.624> 
		<2.340, -0.335, 0.817> <2.340, -0.336, 0.758> <2.340, -0.338, 0.695> <2.340, -0.368, 0.624> 
		<2.400, -0.335, 0.818> <2.400, -0.336, 0.759> <2.400, -0.338, 0.695> <2.400, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.200, -0.393, 0.624> <2.200, -0.399, 0.603> <2.200, -0.431, 0.569> <2.200, -0.432, 0.584> 
		<2.261, -0.393, 0.624> <2.261, -0.399, 0.603> <2.260, -0.431, 0.569> <2.260, -0.432, 0.584> 
		<2.340, -0.368, 0.624> <2.340, -0.379, 0.597> <2.340, -0.429, 0.564> <2.340, -0.432, 0.584> 
		<2.400, -0.368, 0.624> <2.400, -0.379, 0.597> <2.400, -0.429, 0.564> <2.400, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.200, -0.432, 0.584> <2.200, -0.440, 0.698> <2.200, -0.417, 0.662> <2.200, -0.423, 1.028> 
		<2.260, -0.432, 0.584> <2.260, -0.440, 0.698> <2.260, -0.417, 0.662> <2.260, -0.423, 1.028> 
		<2.340, -0.432, 0.584> <2.340, -0.448, 0.697> <2.340, -0.417, 0.662> <2.340, -0.423, 1.028> 
		<2.400, -0.432, 0.584> <2.400, -0.448, 0.697> <2.400, -0.417, 0.662> <2.400, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.400, -0.447, 1.567> <2.461, -0.447, 1.567> <2.540, -0.447, 1.587> <2.600, -0.447, 1.584> 
		<2.400, -0.440, 1.405> <2.461, -0.440, 1.405> <2.540, -0.440, 1.421> <2.600, -0.440, 1.417> 
		<2.400, -0.430, 1.472> <2.460, -0.430, 1.472> <2.540, -0.430, 1.486> <2.600, -0.430, 1.486> 
		<2.400, -0.423, 1.028> <2.460, -0.423, 1.028> <2.540, -0.422, 1.028> <2.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.400, -0.447, 1.567> <2.400, -0.420, 1.434> <2.400, -0.377, 1.259> <2.400, -0.357, 1.125> 
		<2.461, -0.447, 1.567> <2.461, -0.420, 1.434> <2.461, -0.377, 1.259> <2.461, -0.357, 1.125> 
		<2.540, -0.447, 1.587> <2.540, -0.428, 1.449> <2.540, -0.398, 1.265> <2.540, -0.382, 1.126> 
		<2.600, -0.447, 1.584> <2.600, -0.428, 1.445> <2.600, -0.398, 1.262> <2.600, -0.382, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.400, -0.357, 1.125> <2.400, -0.343, 1.034> <2.400, -0.333, 0.910> <2.400, -0.335, 0.818> 
		<2.461, -0.357, 1.125> <2.461, -0.343, 1.033> <2.461, -0.333, 0.911> <2.461, -0.335, 0.819> 
		<2.540, -0.382, 1.126> <2.540, -0.372, 1.037> <2.540, -0.359, 0.906> <2.540, -0.361, 0.816> 
		<2.600, -0.382, 1.123> <2.600, -0.372, 1.034> <2.600, -0.359, 0.914> <2.600, -0.361, 0.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.400, -0.335, 0.818> <2.400, -0.336, 0.759> <2.400, -0.338, 0.695> <2.400, -0.368, 0.624> 
		<2.461, -0.335, 0.819> <2.461, -0.336, 0.760> <2.461, -0.338, 0.695> <2.461, -0.368, 0.624> 
		<2.540, -0.361, 0.816> <2.540, -0.362, 0.755> <2.540, -0.371, 0.695> <2.540, -0.393, 0.619> 
		<2.600, -0.361, 0.824> <2.600, -0.362, 0.763> <2.600, -0.371, 0.700> <2.600, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.400, -0.368, 0.624> <2.400, -0.379, 0.597> <2.400, -0.429, 0.564> <2.400, -0.432, 0.584> 
		<2.461, -0.368, 0.624> <2.461, -0.379, 0.597> <2.460, -0.429, 0.564> <2.460, -0.432, 0.584> 
		<2.540, -0.393, 0.619> <2.540, -0.399, 0.598> <2.541, -0.431, 0.564> <2.541, -0.432, 0.579> 
		<2.600, -0.393, 0.624> <2.600, -0.399, 0.603> <2.600, -0.431, 0.569> <2.600, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.400, -0.432, 0.584> <2.400, -0.448, 0.697> <2.400, -0.417, 0.662> <2.400, -0.423, 1.028> 
		<2.460, -0.432, 0.584> <2.460, -0.448, 0.697> <2.460, -0.417, 0.662> <2.460, -0.423, 1.028> 
		<2.541, -0.432, 0.579> <2.541, -0.440, 0.693> <2.540, -0.417, 0.662> <2.540, -0.422, 1.028> 
		<2.600, -0.432, 0.584> <2.600, -0.440, 0.698> <2.600, -0.417, 0.662> <2.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.600, -0.447, 1.584> <2.662, -0.447, 1.580> <2.760, -0.452, 1.589> <2.800, -0.447, 1.543> 
		<2.600, -0.440, 1.417> <2.662, -0.440, 1.413> <2.760, -0.445, 1.435> <2.800, -0.441, 1.388> 
		<2.600, -0.430, 1.486> <2.660, -0.430, 1.486> <2.740, -0.436, 1.453> <2.800, -0.432, 1.453> 
		<2.600, -0.423, 1.028> <2.660, -0.423, 1.028> <2.740, -0.428, 1.028> <2.800, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.600, -0.447, 1.584> <2.600, -0.428, 1.445> <2.600, -0.398, 1.262> <2.600, -0.382, 1.123> 
		<2.662, -0.447, 1.580> <2.662, -0.428, 1.442> <2.661, -0.398, 1.258> <2.661, -0.382, 1.120> 
		<2.760, -0.452, 1.589> <2.760, -0.425, 1.457> <2.741, -0.376, 1.251> <2.741, -0.354, 1.119> 
		<2.800, -0.447, 1.543> <2.800, -0.420, 1.411> <2.800, -0.379, 1.237> <2.800, -0.357, 1.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.600, -0.382, 1.123> <2.600, -0.372, 1.034> <2.600, -0.359, 0.914> <2.600, -0.361, 0.824> 
		<2.661, -0.382, 1.120> <2.661, -0.372, 1.031> <2.662, -0.359, 0.922> <2.662, -0.361, 0.833> 
		<2.741, -0.354, 1.119> <2.741, -0.342, 1.050> <2.745, -0.327, 0.915> <2.745, -0.329, 0.844> 
		<2.800, -0.357, 1.105> <2.800, -0.345, 1.036> <2.800, -0.333, 0.942> <2.800, -0.335, 0.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.600, -0.361, 0.824> <2.600, -0.362, 0.763> <2.600, -0.371, 0.700> <2.600, -0.393, 0.624> 
		<2.662, -0.361, 0.833> <2.662, -0.362, 0.772> <2.662, -0.371, 0.705> <2.662, -0.393, 0.629> 
		<2.745, -0.329, 0.844> <2.745, -0.330, 0.780> <2.745, -0.337, 0.711> <2.745, -0.367, 0.632> 
		<2.800, -0.335, 0.872> <2.800, -0.337, 0.807> <2.800, -0.337, 0.737> <2.800, -0.368, 0.658> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.600, -0.393, 0.624> <2.600, -0.399, 0.603> <2.600, -0.431, 0.569> <2.600, -0.432, 0.584> 
		<2.662, -0.393, 0.629> <2.662, -0.399, 0.608> <2.661, -0.431, 0.574> <2.661, -0.432, 0.589> 
		<2.745, -0.367, 0.632> <2.745, -0.378, 0.604> <2.745, -0.434, 0.573> <2.745, -0.437, 0.593> 
		<2.800, -0.368, 0.658> <2.800, -0.378, 0.630> <2.800, -0.429, 0.598> <2.800, -0.432, 0.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.600, -0.432, 0.584> <2.600, -0.440, 0.698> <2.600, -0.417, 0.662> <2.600, -0.423, 1.028> 
		<2.661, -0.432, 0.589> <2.661, -0.440, 0.703> <2.660, -0.417, 0.662> <2.660, -0.423, 1.028> 
		<2.745, -0.437, 0.593> <2.745, -0.453, 0.697> <2.740, -0.423, 0.690> <2.740, -0.428, 1.028> 
		<2.800, -0.432, 0.618> <2.800, -0.448, 0.722> <2.800, -0.419, 0.690> <2.800, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.412, 1.237> <2.902, -0.408, 1.181> <2.902, -0.402, 1.106> <2.902, -0.398, 1.050> 
		<2.902, -0.410, 1.174> <2.902, -0.406, 1.118> <2.902, -0.400, 1.084> <2.902, -0.397, 1.027> 
		<2.902, -0.408, 1.200> <2.902, -0.405, 1.184> <2.902, -0.399, 1.013> <2.902, -0.396, 0.997> 
		<2.902, -0.405, 1.028> <2.902, -0.403, 1.012> <2.902, -0.399, 0.990> <2.902, -0.396, 0.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.412, 1.237> <2.902, -0.410, 1.174> <2.902, -0.408, 1.200> <2.902, -0.405, 1.028> 
		<2.872, -0.423, 1.329> <2.872, -0.421, 1.266> <2.872, -0.413, 1.200> <2.872, -0.411, 1.028> 
		<2.864, -0.440, 1.470> <2.864, -0.433, 1.315> <2.831, -0.430, 1.453> <2.831, -0.423, 1.028> 
		<2.800, -0.447, 1.543> <2.800, -0.441, 1.388> <2.800, -0.432, 1.453> <2.800, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.412, 1.237> <2.872, -0.423, 1.329> <2.864, -0.440, 1.470> <2.800, -0.447, 1.543> 
		<2.902, -0.408, 1.181> <2.872, -0.419, 1.273> <2.864, -0.413, 1.338> <2.800, -0.420, 1.411> 
		<2.902, -0.402, 1.106> <2.872, -0.389, 1.123> <2.836, -0.381, 1.229> <2.800, -0.379, 1.237> 
		<2.902, -0.398, 1.050> <2.872, -0.386, 1.067> <2.836, -0.359, 1.096> <2.800, -0.357, 1.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.398, 1.050> <2.872, -0.386, 1.067> <2.836, -0.359, 1.096> <2.800, -0.357, 1.105> 
		<2.902, -0.397, 1.027> <2.872, -0.384, 1.044> <2.836, -0.347, 1.027> <2.800, -0.345, 1.036> 
		<2.902, -0.396, 0.997> <2.872, -0.378, 0.966> <2.842, -0.338, 0.963> <2.800, -0.333, 0.942> 
		<2.902, -0.396, 0.974> <2.872, -0.378, 0.943> <2.842, -0.340, 0.893> <2.800, -0.335, 0.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.396, 0.767> <2.902, -0.393, 0.848> <2.902, -0.396, 0.912> <2.902, -0.396, 0.974> 
		<2.872, -0.387, 0.734> <2.872, -0.384, 0.815> <2.872, -0.377, 0.881> <2.872, -0.378, 0.943> 
		<2.842, -0.368, 0.677> <2.842, -0.338, 0.756> <2.842, -0.342, 0.828> <2.842, -0.340, 0.893> 
		<2.800, -0.368, 0.658> <2.800, -0.337, 0.737> <2.800, -0.337, 0.807> <2.800, -0.335, 0.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.396, 0.767> <2.902, -0.397, 0.748> <2.902, -0.405, 0.707> <2.902, -0.406, 0.720> 
		<2.902, -0.393, 0.848> <2.902, -0.394, 0.829> <2.902, -0.408, 0.787> <2.902, -0.409, 0.799> 
		<2.902, -0.396, 0.912> <2.902, -0.399, 0.928> <2.902, -0.399, 0.758> <2.902, -0.402, 0.774> 
		<2.902, -0.396, 0.974> <2.902, -0.399, 0.990> <2.902, -0.403, 1.012> <2.902, -0.405, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.396, 0.767> <2.872, -0.387, 0.734> <2.842, -0.368, 0.677> <2.800, -0.368, 0.658> 
		<2.902, -0.397, 0.748> <2.872, -0.388, 0.715> <2.842, -0.378, 0.650> <2.800, -0.378, 0.630> 
		<2.902, -0.405, 0.707> <2.872, -0.413, 0.677> <2.840, -0.426, 0.616> <2.800, -0.429, 0.598> 
		<2.902, -0.406, 0.720> <2.872, -0.414, 0.689> <2.840, -0.429, 0.636> <2.800, -0.432, 0.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.902, -0.406, 0.720> <2.872, -0.414, 0.689> <2.840, -0.429, 0.636> <2.800, -0.432, 0.618> 
		<2.902, -0.409, 0.799> <2.872, -0.417, 0.768> <2.840, -0.445, 0.740> <2.800, -0.448, 0.722> 
		<2.902, -0.402, 0.774> <2.872, -0.408, 0.774> <2.831, -0.418, 0.690> <2.800, -0.419, 0.690> 
		<2.902, -0.405, 1.028> <2.872, -0.411, 1.028> <2.831, -0.423, 1.028> <2.800, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.281, -0.447, 1.216> <-0.256, -0.440, 1.160> <-0.221, -0.427, 1.197> <-0.199, -0.423, 1.028> 
		<-0.357, -0.447, 1.276> <-0.332, -0.440, 1.220> <-0.281, -0.427, 1.197> <-0.259, -0.423, 1.028> 
		<-0.335, -0.447, 1.444> <-0.335, -0.440, 1.297> <-0.339, -0.429, 1.431> <-0.339, -0.423, 1.028> 
		<-0.399, -0.447, 1.517> <-0.399, -0.440, 1.370> <-0.399, -0.429, 1.431> <-0.399, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.281, -0.447, 1.216> <-0.357, -0.447, 1.276> <-0.335, -0.447, 1.444> <-0.399, -0.447, 1.517> 
		<-0.256, -0.420, 1.189> <-0.332, -0.420, 1.249> <-0.335, -0.420, 1.326> <-0.399, -0.420, 1.399> 
		<-0.208, -0.369, 1.168> <-0.268, -0.369, 1.168> <-0.339, -0.372, 1.244> <-0.399, -0.376, 1.244> 
		<-0.199, -0.357, 1.125> <-0.259, -0.357, 1.125> <-0.339, -0.353, 1.125> <-0.399, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.199, -0.357, 1.125> <-0.259, -0.357, 1.125> <-0.339, -0.353, 1.125> <-0.399, -0.357, 1.125> 
		<-0.181, -0.332, 1.038> <-0.241, -0.332, 1.038> <-0.339, -0.338, 1.034> <-0.399, -0.342, 1.034> 
		<-0.199, -0.333, 0.910> <-0.259, -0.333, 0.910> <-0.339, -0.329, 0.910> <-0.399, -0.333, 0.910> 
		<-0.199, -0.335, 0.818> <-0.259, -0.335, 0.818> <-0.339, -0.331, 0.818> <-0.399, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.199, -0.335, 0.818> <-0.259, -0.335, 0.818> <-0.339, -0.331, 0.818> <-0.399, -0.335, 0.818> 
		<-0.199, -0.336, 0.759> <-0.259, -0.336, 0.759> <-0.339, -0.333, 0.759> <-0.399, -0.336, 0.759> 
		<-0.199, -0.338, 0.695> <-0.259, -0.338, 0.695> <-0.339, -0.334, 0.695> <-0.399, -0.338, 0.695> 
		<-0.199, -0.368, 0.624> <-0.259, -0.368, 0.624> <-0.339, -0.364, 0.624> <-0.399, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.199, -0.368, 0.624> <-0.259, -0.368, 0.624> <-0.339, -0.364, 0.624> <-0.399, -0.368, 0.624> 
		<-0.199, -0.379, 0.597> <-0.259, -0.379, 0.597> <-0.339, -0.375, 0.597> <-0.399, -0.379, 0.597> 
		<-0.199, -0.429, 0.564> <-0.259, -0.429, 0.564> <-0.339, -0.429, 0.564> <-0.399, -0.429, 0.564> 
		<-0.199, -0.432, 0.584> <-0.259, -0.432, 0.584> <-0.339, -0.432, 0.584> <-0.399, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.199, -0.432, 0.584> <-0.259, -0.432, 0.584> <-0.339, -0.432, 0.584> <-0.399, -0.432, 0.584> 
		<-0.199, -0.448, 0.697> <-0.259, -0.448, 0.697> <-0.339, -0.448, 0.697> <-0.399, -0.448, 0.697> 
		<-0.152, -0.414, 0.665> <-0.212, -0.414, 0.665> <-0.339, -0.417, 0.662> <-0.399, -0.417, 0.662> 
		<-0.199, -0.423, 1.028> <-0.259, -0.423, 1.028> <-0.339, -0.423, 1.028> <-0.399, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.399, -0.447, 1.517> <-0.399, -0.440, 1.370> <-0.399, -0.429, 1.431> <-0.399, -0.423, 1.028> 
		<-0.440, -0.447, 1.565> <-0.440, -0.440, 1.418> <-0.459, -0.429, 1.431> <-0.459, -0.423, 1.028> 
		<-0.536, -0.447, 1.576> <-0.536, -0.440, 1.409> <-0.539, -0.430, 1.486> <-0.539, -0.423, 1.028> 
		<-0.599, -0.447, 1.584> <-0.599, -0.440, 1.417> <-0.599, -0.430, 1.486> <-0.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.399, -0.447, 1.517> <-0.440, -0.447, 1.565> <-0.536, -0.447, 1.576> <-0.599, -0.447, 1.584> 
		<-0.399, -0.420, 1.399> <-0.440, -0.420, 1.447> <-0.536, -0.428, 1.438> <-0.599, -0.428, 1.446> 
		<-0.399, -0.376, 1.244> <-0.459, -0.380, 1.244> <-0.538, -0.398, 1.263> <-0.599, -0.398, 1.263> 
		<-0.399, -0.357, 1.125> <-0.459, -0.361, 1.125> <-0.538, -0.382, 1.125> <-0.599, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.399, -0.357, 1.125> <-0.459, -0.361, 1.125> <-0.538, -0.382, 1.125> <-0.599, -0.382, 1.125> 
		<-0.399, -0.342, 1.034> <-0.459, -0.346, 1.034> <-0.538, -0.372, 1.033> <-0.599, -0.372, 1.033> 
		<-0.399, -0.333, 0.910> <-0.459, -0.337, 0.910> <-0.538, -0.359, 0.910> <-0.599, -0.359, 0.910> 
		<-0.399, -0.335, 0.818> <-0.459, -0.339, 0.818> <-0.538, -0.361, 0.818> <-0.599, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.399, -0.335, 0.818> <-0.459, -0.339, 0.818> <-0.538, -0.361, 0.818> <-0.599, -0.361, 0.818> 
		<-0.399, -0.336, 0.759> <-0.459, -0.340, 0.759> <-0.538, -0.362, 0.759> <-0.599, -0.362, 0.759> 
		<-0.399, -0.338, 0.695> <-0.459, -0.342, 0.695> <-0.538, -0.371, 0.697> <-0.599, -0.371, 0.697> 
		<-0.399, -0.368, 0.624> <-0.459, -0.371, 0.624> <-0.538, -0.393, 0.624> <-0.599, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.399, -0.368, 0.624> <-0.459, -0.371, 0.624> <-0.538, -0.393, 0.624> <-0.599, -0.393, 0.624> 
		<-0.399, -0.379, 0.597> <-0.459, -0.383, 0.597> <-0.538, -0.399, 0.603> <-0.599, -0.399, 0.603> 
		<-0.399, -0.429, 0.564> <-0.459, -0.429, 0.564> <-0.539, -0.431, 0.569> <-0.599, -0.431, 0.569> 
		<-0.399, -0.432, 0.584> <-0.459, -0.432, 0.584> <-0.539, -0.432, 0.584> <-0.599, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.399, -0.432, 0.584> <-0.459, -0.432, 0.584> <-0.539, -0.432, 0.584> <-0.599, -0.432, 0.584> 
		<-0.399, -0.448, 0.697> <-0.459, -0.448, 0.697> <-0.539, -0.440, 0.698> <-0.599, -0.440, 0.698> 
		<-0.399, -0.417, 0.662> <-0.459, -0.417, 0.662> <-0.539, -0.417, 0.662> <-0.599, -0.417, 0.662> 
		<-0.399, -0.423, 1.028> <-0.459, -0.423, 1.028> <-0.539, -0.423, 1.028> <-0.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.599, -0.447, 1.584> <-0.599, -0.440, 1.417> <-0.599, -0.430, 1.486> <-0.599, -0.423, 1.028> 
		<-0.659, -0.447, 1.591> <-0.659, -0.440, 1.424> <-0.659, -0.430, 1.486> <-0.659, -0.423, 1.028> 
		<-0.739, -0.447, 1.567> <-0.739, -0.440, 1.405> <-0.739, -0.430, 1.472> <-0.739, -0.423, 1.028> 
		<-0.799, -0.447, 1.567> <-0.799, -0.440, 1.405> <-0.799, -0.430, 1.472> <-0.799, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.599, -0.447, 1.584> <-0.659, -0.447, 1.591> <-0.739, -0.447, 1.567> <-0.799, -0.447, 1.567> 
		<-0.599, -0.428, 1.446> <-0.659, -0.428, 1.454> <-0.739, -0.420, 1.434> <-0.799, -0.420, 1.434> 
		<-0.599, -0.398, 1.263> <-0.659, -0.398, 1.263> <-0.738, -0.377, 1.259> <-0.799, -0.377, 1.259> 
		<-0.599, -0.382, 1.125> <-0.659, -0.382, 1.125> <-0.738, -0.357, 1.125> <-0.799, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.599, -0.382, 1.125> <-0.659, -0.382, 1.125> <-0.738, -0.357, 1.125> <-0.799, -0.357, 1.125> 
		<-0.599, -0.372, 1.033> <-0.659, -0.372, 1.033> <-0.738, -0.343, 1.034> <-0.799, -0.343, 1.034> 
		<-0.599, -0.359, 0.910> <-0.659, -0.359, 0.910> <-0.738, -0.333, 0.910> <-0.799, -0.333, 0.910> 
		<-0.599, -0.361, 0.818> <-0.659, -0.361, 0.818> <-0.738, -0.335, 0.818> <-0.799, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.599, -0.361, 0.818> <-0.659, -0.361, 0.818> <-0.738, -0.335, 0.818> <-0.799, -0.335, 0.818> 
		<-0.599, -0.362, 0.759> <-0.659, -0.362, 0.759> <-0.738, -0.336, 0.759> <-0.799, -0.336, 0.759> 
		<-0.599, -0.371, 0.697> <-0.659, -0.371, 0.697> <-0.738, -0.338, 0.695> <-0.799, -0.338, 0.695> 
		<-0.599, -0.393, 0.624> <-0.659, -0.393, 0.624> <-0.738, -0.368, 0.624> <-0.799, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.599, -0.393, 0.624> <-0.659, -0.393, 0.624> <-0.738, -0.368, 0.624> <-0.799, -0.368, 0.624> 
		<-0.599, -0.399, 0.603> <-0.659, -0.399, 0.603> <-0.738, -0.379, 0.597> <-0.799, -0.379, 0.597> 
		<-0.599, -0.431, 0.569> <-0.659, -0.431, 0.569> <-0.739, -0.429, 0.564> <-0.799, -0.429, 0.564> 
		<-0.599, -0.432, 0.584> <-0.659, -0.432, 0.584> <-0.739, -0.432, 0.584> <-0.799, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.599, -0.432, 0.584> <-0.659, -0.432, 0.584> <-0.739, -0.432, 0.584> <-0.799, -0.432, 0.584> 
		<-0.599, -0.440, 0.698> <-0.659, -0.440, 0.698> <-0.739, -0.448, 0.697> <-0.799, -0.448, 0.697> 
		<-0.599, -0.417, 0.662> <-0.659, -0.417, 0.662> <-0.739, -0.417, 0.662> <-0.799, -0.417, 0.662> 
		<-0.599, -0.423, 1.028> <-0.659, -0.423, 1.028> <-0.739, -0.423, 1.028> <-0.799, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.447, 1.567> <-0.799, -0.440, 1.405> <-0.799, -0.430, 1.472> <-0.799, -0.423, 1.028> 
		<-0.859, -0.447, 1.567> <-0.859, -0.440, 1.405> <-0.859, -0.430, 1.472> <-0.859, -0.423, 1.028> 
		<-0.939, -0.447, 1.584> <-0.939, -0.440, 1.417> <-0.939, -0.430, 1.486> <-0.939, -0.423, 1.028> 
		<-0.999, -0.447, 1.584> <-0.999, -0.440, 1.417> <-0.999, -0.430, 1.486> <-0.999, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.447, 1.567> <-0.859, -0.447, 1.567> <-0.939, -0.447, 1.584> <-0.999, -0.447, 1.584> 
		<-0.799, -0.420, 1.434> <-0.859, -0.420, 1.434> <-0.939, -0.428, 1.446> <-0.999, -0.428, 1.446> 
		<-0.799, -0.377, 1.259> <-0.859, -0.377, 1.259> <-0.938, -0.398, 1.263> <-0.999, -0.398, 1.263> 
		<-0.799, -0.357, 1.125> <-0.859, -0.357, 1.125> <-0.938, -0.382, 1.125> <-0.999, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.357, 1.125> <-0.859, -0.357, 1.125> <-0.938, -0.382, 1.125> <-0.999, -0.382, 1.125> 
		<-0.799, -0.343, 1.034> <-0.859, -0.343, 1.034> <-0.938, -0.372, 1.033> <-0.999, -0.372, 1.033> 
		<-0.799, -0.333, 0.910> <-0.859, -0.333, 0.910> <-0.938, -0.359, 0.910> <-0.999, -0.359, 0.910> 
		<-0.799, -0.335, 0.818> <-0.859, -0.335, 0.818> <-0.938, -0.361, 0.818> <-0.999, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.335, 0.818> <-0.859, -0.335, 0.818> <-0.938, -0.361, 0.818> <-0.999, -0.361, 0.818> 
		<-0.799, -0.336, 0.759> <-0.859, -0.336, 0.759> <-0.938, -0.362, 0.759> <-0.999, -0.362, 0.759> 
		<-0.799, -0.338, 0.695> <-0.859, -0.338, 0.695> <-0.938, -0.371, 0.697> <-0.999, -0.371, 0.697> 
		<-0.799, -0.368, 0.624> <-0.859, -0.368, 0.624> <-0.938, -0.393, 0.624> <-0.999, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.368, 0.624> <-0.859, -0.368, 0.624> <-0.938, -0.393, 0.624> <-0.999, -0.393, 0.624> 
		<-0.799, -0.379, 0.597> <-0.859, -0.379, 0.597> <-0.938, -0.399, 0.603> <-0.999, -0.399, 0.603> 
		<-0.799, -0.429, 0.564> <-0.859, -0.429, 0.564> <-0.939, -0.431, 0.569> <-0.999, -0.431, 0.569> 
		<-0.799, -0.432, 0.584> <-0.859, -0.432, 0.584> <-0.939, -0.432, 0.584> <-0.999, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.432, 0.584> <-0.859, -0.432, 0.584> <-0.939, -0.432, 0.584> <-0.999, -0.432, 0.584> 
		<-0.799, -0.448, 0.697> <-0.859, -0.448, 0.697> <-0.939, -0.440, 0.698> <-0.999, -0.440, 0.698> 
		<-0.799, -0.417, 0.662> <-0.859, -0.417, 0.662> <-0.939, -0.417, 0.662> <-0.999, -0.417, 0.662> 
		<-0.799, -0.423, 1.028> <-0.859, -0.423, 1.028> <-0.939, -0.423, 1.028> <-0.999, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.999, -0.447, 1.584> <-0.999, -0.440, 1.417> <-0.999, -0.430, 1.486> <-0.999, -0.423, 1.028> 
		<-1.059, -0.447, 1.584> <-1.059, -0.440, 1.417> <-1.059, -0.430, 1.486> <-1.059, -0.423, 1.028> 
		<-1.139, -0.447, 1.567> <-1.139, -0.440, 1.405> <-1.139, -0.430, 1.472> <-1.139, -0.423, 1.028> 
		<-1.199, -0.447, 1.567> <-1.199, -0.440, 1.405> <-1.199, -0.430, 1.472> <-1.199, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.999, -0.447, 1.584> <-1.059, -0.447, 1.584> <-1.139, -0.447, 1.567> <-1.199, -0.447, 1.567> 
		<-0.999, -0.428, 1.446> <-1.059, -0.428, 1.446> <-1.139, -0.420, 1.434> <-1.199, -0.420, 1.434> 
		<-0.999, -0.398, 1.263> <-1.059, -0.398, 1.263> <-1.138, -0.377, 1.259> <-1.199, -0.377, 1.259> 
		<-0.999, -0.382, 1.125> <-1.059, -0.382, 1.125> <-1.138, -0.357, 1.125> <-1.199, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.999, -0.382, 1.125> <-1.059, -0.382, 1.125> <-1.138, -0.357, 1.125> <-1.199, -0.357, 1.125> 
		<-0.999, -0.372, 1.033> <-1.059, -0.372, 1.033> <-1.138, -0.343, 1.034> <-1.199, -0.343, 1.034> 
		<-0.999, -0.359, 0.910> <-1.059, -0.359, 0.910> <-1.138, -0.333, 0.910> <-1.199, -0.333, 0.910> 
		<-0.999, -0.361, 0.818> <-1.059, -0.361, 0.818> <-1.138, -0.335, 0.818> <-1.199, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.999, -0.361, 0.818> <-1.059, -0.361, 0.818> <-1.138, -0.335, 0.818> <-1.199, -0.335, 0.818> 
		<-0.999, -0.362, 0.759> <-1.059, -0.362, 0.759> <-1.138, -0.336, 0.759> <-1.199, -0.336, 0.759> 
		<-0.999, -0.371, 0.697> <-1.059, -0.371, 0.697> <-1.138, -0.338, 0.695> <-1.199, -0.338, 0.695> 
		<-0.999, -0.393, 0.624> <-1.059, -0.393, 0.624> <-1.138, -0.368, 0.624> <-1.199, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.999, -0.393, 0.624> <-1.059, -0.393, 0.624> <-1.138, -0.368, 0.624> <-1.199, -0.368, 0.624> 
		<-0.999, -0.399, 0.603> <-1.059, -0.399, 0.603> <-1.138, -0.379, 0.597> <-1.199, -0.379, 0.597> 
		<-0.999, -0.431, 0.569> <-1.059, -0.431, 0.569> <-1.139, -0.429, 0.564> <-1.199, -0.429, 0.564> 
		<-0.999, -0.432, 0.584> <-1.059, -0.432, 0.584> <-1.139, -0.432, 0.584> <-1.199, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.999, -0.432, 0.584> <-1.059, -0.432, 0.584> <-1.139, -0.432, 0.584> <-1.199, -0.432, 0.584> 
		<-0.999, -0.440, 0.698> <-1.059, -0.440, 0.698> <-1.139, -0.448, 0.697> <-1.199, -0.448, 0.697> 
		<-0.999, -0.417, 0.662> <-1.059, -0.417, 0.662> <-1.139, -0.417, 0.662> <-1.199, -0.417, 0.662> 
		<-0.999, -0.423, 1.028> <-1.059, -0.423, 1.028> <-1.139, -0.423, 1.028> <-1.199, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.199, -0.447, 1.567> <-1.199, -0.440, 1.405> <-1.199, -0.430, 1.472> <-1.199, -0.423, 1.028> 
		<-1.259, -0.447, 1.567> <-1.259, -0.440, 1.405> <-1.259, -0.430, 1.472> <-1.259, -0.423, 1.028> 
		<-1.339, -0.447, 1.584> <-1.339, -0.440, 1.417> <-1.339, -0.430, 1.486> <-1.339, -0.423, 1.028> 
		<-1.399, -0.447, 1.584> <-1.399, -0.440, 1.417> <-1.399, -0.430, 1.486> <-1.399, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.199, -0.447, 1.567> <-1.259, -0.447, 1.567> <-1.339, -0.447, 1.584> <-1.399, -0.447, 1.584> 
		<-1.199, -0.420, 1.434> <-1.259, -0.420, 1.434> <-1.339, -0.428, 1.446> <-1.399, -0.428, 1.446> 
		<-1.199, -0.377, 1.259> <-1.259, -0.377, 1.259> <-1.338, -0.398, 1.263> <-1.399, -0.398, 1.263> 
		<-1.199, -0.357, 1.125> <-1.259, -0.357, 1.125> <-1.338, -0.382, 1.125> <-1.399, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.199, -0.357, 1.125> <-1.259, -0.357, 1.125> <-1.338, -0.382, 1.125> <-1.399, -0.382, 1.125> 
		<-1.199, -0.343, 1.034> <-1.259, -0.343, 1.034> <-1.338, -0.372, 1.033> <-1.399, -0.372, 1.033> 
		<-1.199, -0.333, 0.910> <-1.259, -0.333, 0.910> <-1.338, -0.359, 0.910> <-1.399, -0.359, 0.910> 
		<-1.199, -0.335, 0.818> <-1.259, -0.335, 0.818> <-1.338, -0.361, 0.818> <-1.399, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.199, -0.335, 0.818> <-1.259, -0.335, 0.818> <-1.338, -0.361, 0.818> <-1.399, -0.361, 0.818> 
		<-1.199, -0.336, 0.759> <-1.259, -0.336, 0.759> <-1.338, -0.362, 0.759> <-1.399, -0.362, 0.759> 
		<-1.199, -0.338, 0.695> <-1.259, -0.338, 0.695> <-1.338, -0.371, 0.697> <-1.399, -0.371, 0.697> 
		<-1.199, -0.368, 0.624> <-1.259, -0.368, 0.624> <-1.338, -0.393, 0.624> <-1.399, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.199, -0.368, 0.624> <-1.259, -0.368, 0.624> <-1.338, -0.393, 0.624> <-1.399, -0.393, 0.624> 
		<-1.199, -0.379, 0.597> <-1.259, -0.379, 0.597> <-1.338, -0.399, 0.603> <-1.399, -0.399, 0.603> 
		<-1.199, -0.429, 0.564> <-1.259, -0.429, 0.564> <-1.339, -0.431, 0.569> <-1.399, -0.431, 0.569> 
		<-1.199, -0.432, 0.584> <-1.259, -0.432, 0.584> <-1.339, -0.432, 0.584> <-1.399, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.199, -0.432, 0.584> <-1.259, -0.432, 0.584> <-1.339, -0.432, 0.584> <-1.399, -0.432, 0.584> 
		<-1.199, -0.448, 0.697> <-1.259, -0.448, 0.697> <-1.339, -0.440, 0.698> <-1.399, -0.440, 0.698> 
		<-1.199, -0.417, 0.662> <-1.259, -0.417, 0.662> <-1.339, -0.417, 0.662> <-1.399, -0.417, 0.662> 
		<-1.199, -0.423, 1.028> <-1.259, -0.423, 1.028> <-1.339, -0.423, 1.028> <-1.399, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.447, 1.584> <-1.399, -0.440, 1.417> <-1.399, -0.430, 1.486> <-1.399, -0.423, 1.028> 
		<-1.459, -0.447, 1.584> <-1.459, -0.440, 1.417> <-1.459, -0.430, 1.486> <-1.459, -0.423, 1.028> 
		<-1.539, -0.447, 1.567> <-1.539, -0.440, 1.405> <-1.539, -0.430, 1.472> <-1.539, -0.423, 1.028> 
		<-1.599, -0.447, 1.567> <-1.599, -0.440, 1.405> <-1.599, -0.430, 1.472> <-1.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.447, 1.584> <-1.459, -0.447, 1.584> <-1.539, -0.447, 1.567> <-1.599, -0.447, 1.567> 
		<-1.399, -0.428, 1.446> <-1.459, -0.428, 1.446> <-1.539, -0.420, 1.434> <-1.599, -0.420, 1.434> 
		<-1.399, -0.398, 1.263> <-1.459, -0.398, 1.263> <-1.538, -0.377, 1.259> <-1.599, -0.377, 1.259> 
		<-1.399, -0.382, 1.125> <-1.459, -0.382, 1.125> <-1.538, -0.357, 1.125> <-1.599, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.382, 1.125> <-1.459, -0.382, 1.125> <-1.538, -0.357, 1.125> <-1.599, -0.357, 1.125> 
		<-1.399, -0.372, 1.033> <-1.459, -0.372, 1.033> <-1.538, -0.343, 1.034> <-1.599, -0.343, 1.034> 
		<-1.399, -0.359, 0.910> <-1.459, -0.359, 0.910> <-1.538, -0.333, 0.910> <-1.599, -0.333, 0.910> 
		<-1.399, -0.361, 0.818> <-1.459, -0.361, 0.818> <-1.538, -0.335, 0.818> <-1.599, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.361, 0.818> <-1.459, -0.361, 0.818> <-1.538, -0.335, 0.818> <-1.599, -0.335, 0.818> 
		<-1.399, -0.362, 0.759> <-1.459, -0.362, 0.759> <-1.538, -0.336, 0.759> <-1.599, -0.336, 0.759> 
		<-1.399, -0.371, 0.697> <-1.459, -0.371, 0.697> <-1.538, -0.338, 0.695> <-1.599, -0.338, 0.695> 
		<-1.399, -0.393, 0.624> <-1.459, -0.393, 0.624> <-1.538, -0.368, 0.624> <-1.599, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.393, 0.624> <-1.459, -0.393, 0.624> <-1.538, -0.368, 0.624> <-1.599, -0.368, 0.624> 
		<-1.399, -0.399, 0.603> <-1.459, -0.399, 0.603> <-1.538, -0.379, 0.597> <-1.599, -0.379, 0.597> 
		<-1.399, -0.431, 0.569> <-1.459, -0.431, 0.569> <-1.539, -0.429, 0.564> <-1.599, -0.429, 0.564> 
		<-1.399, -0.432, 0.584> <-1.459, -0.432, 0.584> <-1.539, -0.432, 0.584> <-1.599, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.432, 0.584> <-1.459, -0.432, 0.584> <-1.539, -0.432, 0.584> <-1.599, -0.432, 0.584> 
		<-1.399, -0.440, 0.698> <-1.459, -0.440, 0.698> <-1.539, -0.448, 0.697> <-1.599, -0.448, 0.697> 
		<-1.399, -0.417, 0.662> <-1.459, -0.417, 0.662> <-1.539, -0.417, 0.662> <-1.599, -0.417, 0.662> 
		<-1.399, -0.423, 1.028> <-1.459, -0.423, 1.028> <-1.539, -0.423, 1.028> <-1.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.447, 1.567> <-1.599, -0.440, 1.405> <-1.599, -0.430, 1.472> <-1.599, -0.423, 1.028> 
		<-1.659, -0.447, 1.567> <-1.659, -0.440, 1.405> <-1.659, -0.430, 1.472> <-1.659, -0.423, 1.028> 
		<-1.739, -0.447, 1.584> <-1.739, -0.440, 1.417> <-1.739, -0.430, 1.486> <-1.739, -0.423, 1.028> 
		<-1.799, -0.447, 1.584> <-1.799, -0.440, 1.417> <-1.799, -0.430, 1.486> <-1.799, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.447, 1.567> <-1.659, -0.447, 1.567> <-1.739, -0.447, 1.584> <-1.799, -0.447, 1.584> 
		<-1.599, -0.420, 1.434> <-1.659, -0.420, 1.434> <-1.739, -0.428, 1.446> <-1.799, -0.428, 1.446> 
		<-1.599, -0.377, 1.259> <-1.659, -0.377, 1.259> <-1.738, -0.398, 1.263> <-1.799, -0.398, 1.263> 
		<-1.599, -0.357, 1.125> <-1.659, -0.357, 1.125> <-1.738, -0.382, 1.125> <-1.799, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.357, 1.125> <-1.659, -0.357, 1.125> <-1.738, -0.382, 1.125> <-1.799, -0.382, 1.125> 
		<-1.599, -0.343, 1.034> <-1.659, -0.343, 1.034> <-1.738, -0.372, 1.033> <-1.799, -0.372, 1.033> 
		<-1.599, -0.333, 0.910> <-1.659, -0.333, 0.910> <-1.738, -0.359, 0.910> <-1.799, -0.359, 0.910> 
		<-1.599, -0.335, 0.818> <-1.659, -0.335, 0.818> <-1.738, -0.361, 0.818> <-1.799, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.335, 0.818> <-1.659, -0.335, 0.818> <-1.738, -0.361, 0.818> <-1.799, -0.361, 0.818> 
		<-1.599, -0.336, 0.759> <-1.659, -0.336, 0.759> <-1.738, -0.362, 0.759> <-1.799, -0.362, 0.759> 
		<-1.599, -0.338, 0.695> <-1.659, -0.338, 0.695> <-1.738, -0.371, 0.697> <-1.799, -0.371, 0.697> 
		<-1.599, -0.368, 0.624> <-1.659, -0.368, 0.624> <-1.738, -0.393, 0.624> <-1.799, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.368, 0.624> <-1.659, -0.368, 0.624> <-1.738, -0.393, 0.624> <-1.799, -0.393, 0.624> 
		<-1.599, -0.379, 0.597> <-1.659, -0.379, 0.597> <-1.738, -0.399, 0.603> <-1.799, -0.399, 0.603> 
		<-1.599, -0.429, 0.564> <-1.659, -0.429, 0.564> <-1.739, -0.431, 0.569> <-1.799, -0.431, 0.569> 
		<-1.599, -0.432, 0.584> <-1.659, -0.432, 0.584> <-1.739, -0.432, 0.584> <-1.799, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.432, 0.584> <-1.659, -0.432, 0.584> <-1.739, -0.432, 0.584> <-1.799, -0.432, 0.584> 
		<-1.599, -0.448, 0.697> <-1.659, -0.448, 0.697> <-1.739, -0.440, 0.698> <-1.799, -0.440, 0.698> 
		<-1.599, -0.417, 0.662> <-1.659, -0.417, 0.662> <-1.739, -0.417, 0.662> <-1.799, -0.417, 0.662> 
		<-1.599, -0.423, 1.028> <-1.659, -0.423, 1.028> <-1.739, -0.423, 1.028> <-1.799, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.447, 1.584> <-1.799, -0.440, 1.417> <-1.799, -0.430, 1.486> <-1.799, -0.423, 1.028> 
		<-1.859, -0.447, 1.584> <-1.859, -0.440, 1.417> <-1.859, -0.430, 1.486> <-1.859, -0.423, 1.028> 
		<-1.939, -0.447, 1.567> <-1.939, -0.440, 1.405> <-1.939, -0.430, 1.472> <-1.939, -0.423, 1.028> 
		<-1.999, -0.447, 1.567> <-1.999, -0.440, 1.405> <-1.999, -0.430, 1.472> <-1.999, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.447, 1.584> <-1.859, -0.447, 1.584> <-1.939, -0.447, 1.567> <-1.999, -0.447, 1.567> 
		<-1.799, -0.428, 1.446> <-1.859, -0.428, 1.446> <-1.939, -0.420, 1.434> <-1.999, -0.420, 1.434> 
		<-1.799, -0.398, 1.263> <-1.859, -0.398, 1.263> <-1.938, -0.377, 1.259> <-1.999, -0.377, 1.259> 
		<-1.799, -0.382, 1.125> <-1.859, -0.382, 1.125> <-1.938, -0.357, 1.125> <-1.999, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.382, 1.125> <-1.859, -0.382, 1.125> <-1.938, -0.357, 1.125> <-1.999, -0.357, 1.125> 
		<-1.799, -0.372, 1.033> <-1.859, -0.372, 1.033> <-1.938, -0.343, 1.034> <-1.999, -0.343, 1.034> 
		<-1.799, -0.359, 0.910> <-1.859, -0.359, 0.910> <-1.938, -0.333, 0.910> <-1.999, -0.333, 0.910> 
		<-1.799, -0.361, 0.818> <-1.859, -0.361, 0.818> <-1.938, -0.335, 0.818> <-1.999, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.361, 0.818> <-1.859, -0.361, 0.818> <-1.938, -0.335, 0.818> <-1.999, -0.335, 0.818> 
		<-1.799, -0.362, 0.759> <-1.859, -0.362, 0.759> <-1.938, -0.336, 0.759> <-1.999, -0.336, 0.759> 
		<-1.799, -0.371, 0.697> <-1.859, -0.371, 0.697> <-1.938, -0.338, 0.695> <-1.999, -0.338, 0.695> 
		<-1.799, -0.393, 0.624> <-1.859, -0.393, 0.624> <-1.938, -0.368, 0.624> <-1.999, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.393, 0.624> <-1.859, -0.393, 0.624> <-1.938, -0.368, 0.624> <-1.999, -0.368, 0.624> 
		<-1.799, -0.399, 0.603> <-1.859, -0.399, 0.603> <-1.938, -0.379, 0.597> <-1.999, -0.379, 0.597> 
		<-1.799, -0.431, 0.569> <-1.859, -0.431, 0.569> <-1.939, -0.429, 0.564> <-1.999, -0.429, 0.564> 
		<-1.799, -0.432, 0.584> <-1.859, -0.432, 0.584> <-1.939, -0.432, 0.584> <-1.999, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.432, 0.584> <-1.859, -0.432, 0.584> <-1.939, -0.432, 0.584> <-1.999, -0.432, 0.584> 
		<-1.799, -0.440, 0.698> <-1.859, -0.440, 0.698> <-1.939, -0.448, 0.697> <-1.999, -0.448, 0.697> 
		<-1.799, -0.417, 0.662> <-1.859, -0.417, 0.662> <-1.939, -0.417, 0.662> <-1.999, -0.417, 0.662> 
		<-1.799, -0.423, 1.028> <-1.859, -0.423, 1.028> <-1.939, -0.423, 1.028> <-1.999, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.447, 1.567> <-1.999, -0.440, 1.405> <-1.999, -0.430, 1.472> <-1.999, -0.423, 1.028> 
		<-2.059, -0.447, 1.567> <-2.059, -0.440, 1.405> <-2.059, -0.430, 1.472> <-2.059, -0.423, 1.028> 
		<-2.139, -0.447, 1.584> <-2.139, -0.440, 1.417> <-2.139, -0.430, 1.486> <-2.139, -0.423, 1.028> 
		<-2.199, -0.447, 1.584> <-2.199, -0.440, 1.417> <-2.199, -0.430, 1.486> <-2.199, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.447, 1.567> <-2.059, -0.447, 1.567> <-2.139, -0.447, 1.584> <-2.199, -0.447, 1.584> 
		<-1.999, -0.420, 1.434> <-2.059, -0.420, 1.434> <-2.139, -0.428, 1.446> <-2.199, -0.428, 1.446> 
		<-1.999, -0.377, 1.259> <-2.059, -0.377, 1.259> <-2.138, -0.398, 1.263> <-2.199, -0.398, 1.263> 
		<-1.999, -0.357, 1.125> <-2.059, -0.357, 1.125> <-2.138, -0.382, 1.125> <-2.199, -0.382, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.357, 1.125> <-2.059, -0.357, 1.125> <-2.138, -0.382, 1.125> <-2.199, -0.382, 1.125> 
		<-1.999, -0.343, 1.034> <-2.059, -0.343, 1.034> <-2.138, -0.372, 1.033> <-2.199, -0.372, 1.033> 
		<-1.999, -0.333, 0.910> <-2.059, -0.333, 0.910> <-2.138, -0.359, 0.910> <-2.199, -0.359, 0.910> 
		<-1.999, -0.335, 0.818> <-2.059, -0.335, 0.818> <-2.138, -0.361, 0.818> <-2.199, -0.361, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.335, 0.818> <-2.059, -0.335, 0.818> <-2.138, -0.361, 0.818> <-2.199, -0.361, 0.818> 
		<-1.999, -0.336, 0.759> <-2.059, -0.336, 0.759> <-2.138, -0.362, 0.759> <-2.199, -0.362, 0.759> 
		<-1.999, -0.338, 0.695> <-2.059, -0.338, 0.695> <-2.138, -0.371, 0.697> <-2.199, -0.371, 0.697> 
		<-1.999, -0.368, 0.624> <-2.059, -0.368, 0.624> <-2.138, -0.393, 0.624> <-2.199, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.368, 0.624> <-2.059, -0.368, 0.624> <-2.138, -0.393, 0.624> <-2.199, -0.393, 0.624> 
		<-1.999, -0.379, 0.597> <-2.059, -0.379, 0.597> <-2.138, -0.399, 0.603> <-2.199, -0.399, 0.603> 
		<-1.999, -0.429, 0.564> <-2.059, -0.429, 0.564> <-2.139, -0.431, 0.569> <-2.199, -0.431, 0.569> 
		<-1.999, -0.432, 0.584> <-2.059, -0.432, 0.584> <-2.139, -0.432, 0.584> <-2.199, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.432, 0.584> <-2.059, -0.432, 0.584> <-2.139, -0.432, 0.584> <-2.199, -0.432, 0.584> 
		<-1.999, -0.448, 0.697> <-2.059, -0.448, 0.697> <-2.139, -0.440, 0.698> <-2.199, -0.440, 0.698> 
		<-1.999, -0.417, 0.662> <-2.059, -0.417, 0.662> <-2.139, -0.417, 0.662> <-2.199, -0.417, 0.662> 
		<-1.999, -0.423, 1.028> <-2.059, -0.423, 1.028> <-2.139, -0.423, 1.028> <-2.199, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.199, -0.447, 1.584> <-2.199, -0.440, 1.417> <-2.199, -0.430, 1.486> <-2.199, -0.423, 1.028> 
		<-2.259, -0.447, 1.584> <-2.259, -0.440, 1.417> <-2.259, -0.430, 1.486> <-2.259, -0.423, 1.028> 
		<-2.339, -0.447, 1.567> <-2.339, -0.440, 1.405> <-2.339, -0.430, 1.472> <-2.339, -0.423, 1.028> 
		<-2.399, -0.447, 1.567> <-2.399, -0.440, 1.405> <-2.399, -0.430, 1.472> <-2.399, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.199, -0.447, 1.584> <-2.259, -0.447, 1.584> <-2.339, -0.447, 1.567> <-2.399, -0.447, 1.567> 
		<-2.199, -0.428, 1.446> <-2.259, -0.428, 1.446> <-2.339, -0.420, 1.434> <-2.399, -0.420, 1.434> 
		<-2.199, -0.398, 1.263> <-2.259, -0.398, 1.263> <-2.338, -0.377, 1.259> <-2.399, -0.377, 1.259> 
		<-2.199, -0.382, 1.125> <-2.259, -0.382, 1.125> <-2.338, -0.357, 1.125> <-2.399, -0.357, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.199, -0.382, 1.125> <-2.259, -0.382, 1.125> <-2.338, -0.357, 1.125> <-2.399, -0.357, 1.125> 
		<-2.199, -0.372, 1.033> <-2.259, -0.372, 1.033> <-2.338, -0.343, 1.034> <-2.399, -0.343, 1.034> 
		<-2.199, -0.359, 0.910> <-2.259, -0.359, 0.910> <-2.338, -0.333, 0.909> <-2.399, -0.333, 0.910> 
		<-2.199, -0.361, 0.818> <-2.259, -0.361, 0.818> <-2.338, -0.335, 0.817> <-2.399, -0.335, 0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.199, -0.361, 0.818> <-2.259, -0.361, 0.818> <-2.338, -0.335, 0.817> <-2.399, -0.335, 0.818> 
		<-2.199, -0.362, 0.759> <-2.259, -0.362, 0.759> <-2.338, -0.336, 0.758> <-2.399, -0.336, 0.759> 
		<-2.199, -0.371, 0.697> <-2.259, -0.371, 0.697> <-2.338, -0.338, 0.695> <-2.399, -0.338, 0.695> 
		<-2.199, -0.393, 0.624> <-2.259, -0.393, 0.624> <-2.338, -0.368, 0.624> <-2.399, -0.368, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.199, -0.393, 0.624> <-2.259, -0.393, 0.624> <-2.338, -0.368, 0.624> <-2.399, -0.368, 0.624> 
		<-2.199, -0.399, 0.603> <-2.259, -0.399, 0.603> <-2.338, -0.379, 0.597> <-2.399, -0.379, 0.597> 
		<-2.199, -0.431, 0.569> <-2.259, -0.431, 0.569> <-2.339, -0.429, 0.564> <-2.399, -0.429, 0.564> 
		<-2.199, -0.432, 0.584> <-2.259, -0.432, 0.584> <-2.339, -0.432, 0.584> <-2.399, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.199, -0.432, 0.584> <-2.259, -0.432, 0.584> <-2.339, -0.432, 0.584> <-2.399, -0.432, 0.584> 
		<-2.199, -0.440, 0.698> <-2.259, -0.440, 0.698> <-2.339, -0.448, 0.697> <-2.399, -0.448, 0.697> 
		<-2.199, -0.417, 0.662> <-2.259, -0.417, 0.662> <-2.339, -0.417, 0.662> <-2.399, -0.417, 0.662> 
		<-2.199, -0.423, 1.028> <-2.259, -0.423, 1.028> <-2.339, -0.423, 1.028> <-2.399, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.399, -0.447, 1.567> <-2.399, -0.440, 1.405> <-2.399, -0.430, 1.472> <-2.399, -0.423, 1.028> 
		<-2.459, -0.447, 1.567> <-2.459, -0.440, 1.405> <-2.459, -0.430, 1.472> <-2.459, -0.423, 1.028> 
		<-2.539, -0.447, 1.587> <-2.539, -0.440, 1.421> <-2.539, -0.430, 1.486> <-2.539, -0.422, 1.028> 
		<-2.599, -0.447, 1.584> <-2.599, -0.440, 1.417> <-2.599, -0.430, 1.486> <-2.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.399, -0.447, 1.567> <-2.459, -0.447, 1.567> <-2.539, -0.447, 1.587> <-2.599, -0.447, 1.584> 
		<-2.399, -0.420, 1.434> <-2.459, -0.420, 1.434> <-2.539, -0.428, 1.449> <-2.599, -0.428, 1.445> 
		<-2.399, -0.377, 1.259> <-2.459, -0.377, 1.259> <-2.538, -0.398, 1.265> <-2.599, -0.398, 1.262> 
		<-2.399, -0.357, 1.125> <-2.459, -0.357, 1.125> <-2.538, -0.382, 1.126> <-2.599, -0.382, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.399, -0.357, 1.125> <-2.459, -0.357, 1.125> <-2.538, -0.382, 1.126> <-2.599, -0.382, 1.123> 
		<-2.399, -0.343, 1.034> <-2.459, -0.343, 1.033> <-2.538, -0.372, 1.037> <-2.599, -0.372, 1.034> 
		<-2.399, -0.333, 0.910> <-2.459, -0.333, 0.911> <-2.539, -0.359, 0.906> <-2.599, -0.359, 0.914> 
		<-2.399, -0.335, 0.818> <-2.459, -0.335, 0.819> <-2.539, -0.361, 0.816> <-2.599, -0.361, 0.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.399, -0.335, 0.818> <-2.459, -0.335, 0.819> <-2.539, -0.361, 0.816> <-2.599, -0.361, 0.824> 
		<-2.399, -0.336, 0.759> <-2.459, -0.336, 0.760> <-2.539, -0.362, 0.755> <-2.599, -0.362, 0.763> 
		<-2.399, -0.338, 0.695> <-2.459, -0.338, 0.695> <-2.538, -0.371, 0.695> <-2.599, -0.371, 0.700> 
		<-2.399, -0.368, 0.624> <-2.459, -0.368, 0.624> <-2.538, -0.393, 0.619> <-2.599, -0.393, 0.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.399, -0.368, 0.624> <-2.459, -0.368, 0.624> <-2.538, -0.393, 0.619> <-2.599, -0.393, 0.624> 
		<-2.399, -0.379, 0.597> <-2.459, -0.379, 0.597> <-2.538, -0.399, 0.598> <-2.599, -0.399, 0.603> 
		<-2.399, -0.429, 0.564> <-2.459, -0.429, 0.564> <-2.539, -0.431, 0.564> <-2.599, -0.431, 0.569> 
		<-2.399, -0.432, 0.584> <-2.459, -0.432, 0.584> <-2.539, -0.432, 0.579> <-2.599, -0.432, 0.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.399, -0.432, 0.584> <-2.459, -0.432, 0.584> <-2.539, -0.432, 0.579> <-2.599, -0.432, 0.584> 
		<-2.399, -0.448, 0.697> <-2.459, -0.448, 0.697> <-2.539, -0.440, 0.693> <-2.599, -0.440, 0.698> 
		<-2.399, -0.417, 0.662> <-2.459, -0.417, 0.662> <-2.539, -0.417, 0.662> <-2.599, -0.417, 0.662> 
		<-2.399, -0.423, 1.028> <-2.459, -0.423, 1.028> <-2.539, -0.422, 1.028> <-2.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.599, -0.447, 1.584> <-2.599, -0.440, 1.417> <-2.599, -0.430, 1.486> <-2.599, -0.423, 1.028> 
		<-2.660, -0.447, 1.580> <-2.660, -0.440, 1.413> <-2.659, -0.430, 1.486> <-2.659, -0.423, 1.028> 
		<-2.759, -0.452, 1.589> <-2.759, -0.445, 1.435> <-2.739, -0.436, 1.453> <-2.739, -0.428, 1.028> 
		<-2.799, -0.447, 1.543> <-2.799, -0.441, 1.388> <-2.799, -0.432, 1.453> <-2.799, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.599, -0.447, 1.584> <-2.660, -0.447, 1.580> <-2.759, -0.452, 1.589> <-2.799, -0.447, 1.543> 
		<-2.599, -0.428, 1.445> <-2.660, -0.428, 1.442> <-2.759, -0.425, 1.457> <-2.799, -0.420, 1.411> 
		<-2.599, -0.398, 1.262> <-2.659, -0.398, 1.258> <-2.740, -0.376, 1.251> <-2.799, -0.379, 1.237> 
		<-2.599, -0.382, 1.123> <-2.659, -0.382, 1.120> <-2.740, -0.354, 1.119> <-2.799, -0.357, 1.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.599, -0.382, 1.123> <-2.659, -0.382, 1.120> <-2.740, -0.354, 1.119> <-2.799, -0.357, 1.105> 
		<-2.599, -0.372, 1.034> <-2.659, -0.372, 1.031> <-2.740, -0.342, 1.050> <-2.799, -0.345, 1.036> 
		<-2.599, -0.359, 0.914> <-2.660, -0.359, 0.922> <-2.743, -0.327, 0.915> <-2.799, -0.333, 0.942> 
		<-2.599, -0.361, 0.824> <-2.660, -0.361, 0.833> <-2.743, -0.329, 0.844> <-2.799, -0.335, 0.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.599, -0.361, 0.824> <-2.660, -0.361, 0.833> <-2.743, -0.329, 0.844> <-2.799, -0.335, 0.872> 
		<-2.599, -0.362, 0.763> <-2.660, -0.362, 0.772> <-2.743, -0.330, 0.780> <-2.799, -0.337, 0.807> 
		<-2.599, -0.371, 0.700> <-2.660, -0.371, 0.705> <-2.743, -0.337, 0.711> <-2.799, -0.337, 0.737> 
		<-2.599, -0.393, 0.624> <-2.660, -0.393, 0.629> <-2.743, -0.367, 0.632> <-2.799, -0.368, 0.658> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.599, -0.393, 0.624> <-2.660, -0.393, 0.629> <-2.743, -0.367, 0.632> <-2.799, -0.368, 0.658> 
		<-2.599, -0.399, 0.603> <-2.660, -0.399, 0.608> <-2.743, -0.378, 0.604> <-2.799, -0.378, 0.630> 
		<-2.599, -0.431, 0.569> <-2.659, -0.431, 0.574> <-2.743, -0.434, 0.573> <-2.799, -0.429, 0.598> 
		<-2.599, -0.432, 0.584> <-2.659, -0.432, 0.589> <-2.743, -0.437, 0.593> <-2.799, -0.432, 0.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.599, -0.432, 0.584> <-2.659, -0.432, 0.589> <-2.743, -0.437, 0.593> <-2.799, -0.432, 0.618> 
		<-2.599, -0.440, 0.698> <-2.659, -0.440, 0.703> <-2.743, -0.453, 0.697> <-2.799, -0.448, 0.722> 
		<-2.599, -0.417, 0.662> <-2.659, -0.417, 0.662> <-2.739, -0.423, 0.690> <-2.799, -0.419, 0.690> 
		<-2.599, -0.423, 1.028> <-2.659, -0.423, 1.028> <-2.739, -0.428, 1.028> <-2.799, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.412, 1.237> <-2.870, -0.423, 1.329> <-2.862, -0.440, 1.470> <-2.799, -0.447, 1.543> 
		<-2.901, -0.410, 1.174> <-2.870, -0.421, 1.266> <-2.862, -0.433, 1.315> <-2.799, -0.441, 1.388> 
		<-2.901, -0.408, 1.200> <-2.870, -0.413, 1.200> <-2.830, -0.430, 1.453> <-2.799, -0.432, 1.453> 
		<-2.901, -0.405, 1.028> <-2.870, -0.411, 1.028> <-2.830, -0.423, 1.028> <-2.799, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.412, 1.237> <-2.901, -0.410, 1.174> <-2.901, -0.408, 1.200> <-2.901, -0.405, 1.028> 
		<-2.901, -0.408, 1.181> <-2.901, -0.406, 1.118> <-2.901, -0.405, 1.184> <-2.901, -0.403, 1.012> 
		<-2.901, -0.402, 1.106> <-2.901, -0.400, 1.084> <-2.901, -0.399, 1.013> <-2.901, -0.399, 0.990> 
		<-2.901, -0.398, 1.050> <-2.901, -0.397, 1.027> <-2.901, -0.396, 0.997> <-2.901, -0.396, 0.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.412, 1.237> <-2.901, -0.408, 1.181> <-2.901, -0.402, 1.106> <-2.901, -0.398, 1.050> 
		<-2.870, -0.423, 1.329> <-2.870, -0.419, 1.273> <-2.870, -0.389, 1.123> <-2.870, -0.386, 1.067> 
		<-2.862, -0.440, 1.470> <-2.862, -0.413, 1.338> <-2.835, -0.381, 1.229> <-2.835, -0.359, 1.096> 
		<-2.799, -0.447, 1.543> <-2.799, -0.420, 1.411> <-2.799, -0.379, 1.237> <-2.799, -0.357, 1.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.398, 1.050> <-2.901, -0.397, 1.027> <-2.901, -0.396, 0.997> <-2.901, -0.396, 0.974> 
		<-2.870, -0.386, 1.067> <-2.870, -0.384, 1.044> <-2.870, -0.378, 0.966> <-2.870, -0.378, 0.943> 
		<-2.835, -0.359, 1.096> <-2.835, -0.347, 1.027> <-2.841, -0.338, 0.963> <-2.841, -0.340, 0.893> 
		<-2.799, -0.357, 1.105> <-2.799, -0.345, 1.036> <-2.799, -0.333, 0.942> <-2.799, -0.335, 0.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.396, 0.767> <-2.901, -0.393, 0.848> <-2.901, -0.396, 0.912> <-2.901, -0.396, 0.974> 
		<-2.901, -0.397, 0.748> <-2.901, -0.394, 0.829> <-2.901, -0.399, 0.928> <-2.901, -0.399, 0.990> 
		<-2.901, -0.405, 0.707> <-2.901, -0.408, 0.787> <-2.901, -0.399, 0.758> <-2.901, -0.403, 1.012> 
		<-2.901, -0.406, 0.720> <-2.901, -0.409, 0.799> <-2.901, -0.402, 0.774> <-2.901, -0.405, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.396, 0.767> <-2.870, -0.387, 0.734> <-2.840, -0.368, 0.677> <-2.799, -0.368, 0.658> 
		<-2.901, -0.393, 0.848> <-2.870, -0.384, 0.815> <-2.840, -0.338, 0.756> <-2.799, -0.337, 0.737> 
		<-2.901, -0.396, 0.912> <-2.870, -0.377, 0.881> <-2.841, -0.342, 0.828> <-2.799, -0.337, 0.807> 
		<-2.901, -0.396, 0.974> <-2.870, -0.378, 0.943> <-2.841, -0.340, 0.893> <-2.799, -0.335, 0.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.396, 0.767> <-2.901, -0.397, 0.748> <-2.901, -0.405, 0.707> <-2.901, -0.406, 0.720> 
		<-2.870, -0.387, 0.734> <-2.870, -0.388, 0.715> <-2.870, -0.413, 0.677> <-2.870, -0.414, 0.689> 
		<-2.840, -0.368, 0.677> <-2.840, -0.378, 0.650> <-2.839, -0.426, 0.616> <-2.839, -0.429, 0.636> 
		<-2.799, -0.368, 0.658> <-2.799, -0.378, 0.630> <-2.799, -0.429, 0.598> <-2.799, -0.432, 0.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.901, -0.406, 0.720> <-2.901, -0.409, 0.799> <-2.901, -0.402, 0.774> <-2.901, -0.405, 1.028> 
		<-2.870, -0.414, 0.689> <-2.870, -0.417, 0.768> <-2.870, -0.408, 0.774> <-2.870, -0.411, 1.028> 
		<-2.839, -0.429, 0.636> <-2.839, -0.445, 0.740> <-2.830, -0.418, 0.690> <-2.830, -0.423, 1.028> 
		<-2.799, -0.432, 0.618> <-2.799, -0.448, 0.722> <-2.799, -0.419, 0.690> <-2.799, -0.425, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.200, 0.963> <0.800, -1.170, 0.863> <0.800, -1.121, 0.732> <0.800, -1.100, 0.630> 
		<0.800, -1.196, 0.833> <0.800, -1.166, 0.734> <0.800, -1.103, 0.644> <0.800, -1.082, 0.542> 
		<0.800, -1.186, 0.661> <0.800, -1.151, 0.600> <0.800, -1.099, 0.481> <0.800, -1.064, 0.421> 
		<0.800, -1.186, 0.531> <0.800, -1.151, 0.471> <0.800, -1.104, 0.391> <0.800, -1.068, 0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.200, 0.963> <0.800, -1.196, 0.833> <0.800, -1.186, 0.661> <0.800, -1.186, 0.531> 
		<0.320, -1.200, 0.963> <0.320, -1.196, 0.833> <0.320, -1.186, 0.661> <0.320, -1.186, 0.531> 
		<-0.320, -1.200, 0.963> <-0.320, -1.196, 0.833> <-0.320, -1.186, 0.661> <-0.320, -1.186, 0.531> 
		<-0.800, -1.200, 0.963> <-0.800, -1.196, 0.833> <-0.800, -1.186, 0.661> <-0.800, -1.186, 0.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.200, 0.963> <0.320, -1.200, 0.963> <-0.320, -1.200, 0.963> <-0.800, -1.200, 0.963> 
		<0.800, -1.170, 0.863> <0.320, -1.170, 0.863> <-0.320, -1.170, 0.863> <-0.800, -1.170, 0.863> 
		<0.800, -1.121, 0.732> <0.320, -1.121, 0.732> <-0.320, -1.121, 0.732> <-0.800, -1.121, 0.732> 
		<0.800, -1.100, 0.630> <0.320, -1.100, 0.630> <-0.320, -1.100, 0.630> <-0.800, -1.100, 0.630> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.100, 0.630> <0.320, -1.100, 0.630> <-0.320, -1.100, 0.630> <-0.800, -1.100, 0.630> 
		<0.800, -1.082, 0.542> <0.320, -1.082, 0.542> <-0.320, -1.082, 0.542> <-0.800, -1.082, 0.542> 
		<0.800, -1.064, 0.421> <0.320, -1.064, 0.421> <-0.320, -1.064, 0.421> <-0.800, -1.064, 0.421> 
		<0.800, -1.068, 0.330> <0.320, -1.068, 0.330> <-0.320, -1.068, 0.330> <-0.800, -1.068, 0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.123, 0.149> <0.800, -1.088, 0.194> <0.800, -1.071, 0.274> <0.800, -1.068, 0.330> 
		<0.320, -1.123, 0.149> <0.320, -1.088, 0.194> <0.320, -1.071, 0.274> <0.320, -1.068, 0.330> 
		<-0.320, -1.123, 0.149> <-0.320, -1.088, 0.194> <-0.320, -1.071, 0.274> <-0.320, -1.068, 0.330> 
		<-0.800, -1.123, 0.149> <-0.800, -1.088, 0.194> <-0.800, -1.071, 0.274> <-0.800, -1.068, 0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.123, 0.149> <0.800, -1.137, 0.130> <0.800, -1.196, 0.139> <0.800, -1.200, 0.163> 
		<0.800, -1.088, 0.194> <0.800, -1.102, 0.175> <0.800, -1.214, 0.249> <0.800, -1.218, 0.272> 
		<0.800, -1.071, 0.274> <0.800, -1.106, 0.334> <0.800, -1.151, 0.360> <0.800, -1.186, 0.420> 
		<0.800, -1.068, 0.330> <0.800, -1.104, 0.391> <0.800, -1.151, 0.471> <0.800, -1.186, 0.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.123, 0.149> <0.320, -1.123, 0.149> <-0.320, -1.123, 0.149> <-0.800, -1.123, 0.149> 
		<0.800, -1.137, 0.130> <0.320, -1.137, 0.130> <-0.320, -1.137, 0.130> <-0.800, -1.137, 0.130> 
		<0.800, -1.196, 0.139> <0.320, -1.196, 0.139> <-0.320, -1.196, 0.139> <-0.800, -1.196, 0.139> 
		<0.800, -1.200, 0.163> <0.320, -1.200, 0.163> <-0.320, -1.200, 0.163> <-0.800, -1.200, 0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -1.200, 0.163> <0.320, -1.200, 0.163> <-0.320, -1.200, 0.163> <-0.800, -1.200, 0.163> 
		<0.800, -1.218, 0.272> <0.320, -1.218, 0.272> <-0.320, -1.218, 0.272> <-0.800, -1.218, 0.272> 
		<0.800, -1.186, 0.420> <0.320, -1.186, 0.420> <-0.320, -1.186, 0.420> <-0.800, -1.186, 0.420> 
		<0.800, -1.186, 0.531> <0.320, -1.186, 0.531> <-0.320, -1.186, 0.531> <-0.800, -1.186, 0.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, -1.200, 0.963> <-0.800, -1.196, 0.833> <-0.800, -1.186, 0.661> <-0.800, -1.186, 0.531> 
		<-0.800, -1.170, 0.863> <-0.800, -1.166, 0.734> <-0.800, -1.151, 0.600> <-0.800, -1.151, 0.471> 
		<-0.800, -1.121, 0.732> <-0.800, -1.103, 0.644> <-0.800, -1.099, 0.481> <-0.800, -1.104, 0.391> 
		<-0.800, -1.100, 0.630> <-0.800, -1.082, 0.542> <-0.800, -1.064, 0.421> <-0.800, -1.068, 0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, -1.123, 0.149> <-0.800, -1.088, 0.194> <-0.800, -1.071, 0.274> <-0.800, -1.068, 0.330> 
		<-0.800, -1.137, 0.130> <-0.800, -1.102, 0.175> <-0.800, -1.106, 0.334> <-0.800, -1.104, 0.391> 
		<-0.800, -1.196, 0.139> <-0.800, -1.214, 0.249> <-0.800, -1.151, 0.360> <-0.800, -1.151, 0.471> 
		<-0.800, -1.200, 0.163> <-0.800, -1.218, 0.272> <-0.800, -1.186, 0.420> <-0.800, -1.186, 0.531> 
	}
	union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.322, 0.970> <1.154, 1.322, 0.962> <1.232, 1.322, 0.928> <1.293, 1.322, 0.920> 
		<1.093, 1.349, 0.832> <1.154, 1.349, 0.825> <1.232, 1.342, 0.806> <1.293, 1.342, 0.797> 
		<1.093, 1.392, 0.650> <1.154, 1.392, 0.650> <1.233, 1.372, 0.635> <1.293, 1.372, 0.635> 
		<1.093, 1.413, 0.511> <1.154, 1.413, 0.511> <1.233, 1.387, 0.511> <1.293, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.413, 0.511> <1.154, 1.413, 0.511> <1.233, 1.387, 0.511> <1.293, 1.387, 0.511> 
		<1.093, 1.426, 0.420> <1.154, 1.426, 0.420> <1.233, 1.398, 0.419> <1.293, 1.398, 0.419> 
		<1.093, 1.436, 0.296> <1.154, 1.436, 0.296> <1.233, 1.411, 0.296> <1.293, 1.411, 0.296> 
		<1.093, 1.434, 0.204> <1.154, 1.434, 0.204> <1.233, 1.409, 0.204> <1.293, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.093, 1.434, 0.204> <1.154, 1.434, 0.204> <1.233, 1.409, 0.204> <1.293, 1.409, 0.204> 
		<1.093, 1.433, 0.145> <1.154, 1.433, 0.145> <1.233, 1.407, 0.145> <1.293, 1.407, 0.145> 
		<1.093, 1.431, 0.081> <1.154, 1.431, 0.081> <1.233, 1.399, 0.083> <1.293, 1.399, 0.083> 
		<1.093, 1.402, 0.010> <1.154, 1.402, 0.010> <1.233, 1.376, 0.010> <1.293, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.322, 0.920> <1.353, 1.322, 0.912> <1.433, 1.322, 0.917> <1.493, 1.322, 0.916> 
		<1.293, 1.342, 0.797> <1.353, 1.342, 0.789> <1.433, 1.349, 0.795> <1.493, 1.349, 0.795> 
		<1.293, 1.372, 0.635> <1.354, 1.372, 0.635> <1.433, 1.393, 0.634> <1.493, 1.393, 0.634> 
		<1.293, 1.387, 0.511> <1.354, 1.387, 0.511> <1.433, 1.413, 0.511> <1.493, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.387, 0.511> <1.354, 1.387, 0.511> <1.433, 1.413, 0.511> <1.493, 1.413, 0.511> 
		<1.293, 1.398, 0.419> <1.354, 1.398, 0.419> <1.433, 1.427, 0.420> <1.493, 1.427, 0.420> 
		<1.293, 1.411, 0.296> <1.354, 1.411, 0.296> <1.433, 1.436, 0.296> <1.493, 1.436, 0.296> 
		<1.293, 1.409, 0.204> <1.354, 1.409, 0.204> <1.433, 1.434, 0.204> <1.493, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 1.409, 0.204> <1.354, 1.409, 0.204> <1.433, 1.434, 0.204> <1.493, 1.434, 0.204> 
		<1.293, 1.407, 0.145> <1.354, 1.407, 0.145> <1.433, 1.433, 0.145> <1.493, 1.433, 0.145> 
		<1.293, 1.399, 0.083> <1.354, 1.399, 0.083> <1.433, 1.431, 0.081> <1.493, 1.431, 0.081> 
		<1.293, 1.376, 0.010> <1.354, 1.376, 0.010> <1.433, 1.402, 0.010> <1.493, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.322, 0.916> <1.553, 1.322, 0.915> <1.633, 1.322, 0.916> <1.693, 1.322, 0.916> 
		<1.493, 1.349, 0.795> <1.553, 1.349, 0.794> <1.633, 1.342, 0.795> <1.693, 1.342, 0.795> 
		<1.493, 1.393, 0.634> <1.554, 1.393, 0.634> <1.633, 1.372, 0.633> <1.693, 1.372, 0.633> 
		<1.493, 1.413, 0.511> <1.554, 1.413, 0.511> <1.633, 1.387, 0.511> <1.693, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.413, 0.511> <1.554, 1.413, 0.511> <1.633, 1.387, 0.511> <1.693, 1.387, 0.511> 
		<1.493, 1.427, 0.420> <1.554, 1.427, 0.420> <1.633, 1.398, 0.419> <1.693, 1.398, 0.419> 
		<1.493, 1.436, 0.296> <1.554, 1.436, 0.296> <1.633, 1.411, 0.296> <1.693, 1.411, 0.296> 
		<1.493, 1.434, 0.204> <1.554, 1.434, 0.204> <1.633, 1.409, 0.204> <1.693, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 1.434, 0.204> <1.554, 1.434, 0.204> <1.633, 1.409, 0.204> <1.693, 1.409, 0.204> 
		<1.493, 1.433, 0.145> <1.554, 1.433, 0.145> <1.633, 1.407, 0.145> <1.693, 1.407, 0.145> 
		<1.493, 1.431, 0.081> <1.554, 1.431, 0.081> <1.633, 1.399, 0.083> <1.693, 1.399, 0.083> 
		<1.493, 1.402, 0.010> <1.554, 1.402, 0.010> <1.633, 1.376, 0.010> <1.693, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.322, 0.916> <1.753, 1.322, 0.916> <1.833, 1.322, 0.916> <1.893, 1.322, 0.916> 
		<1.693, 1.342, 0.795> <1.753, 1.342, 0.795> <1.833, 1.349, 0.795> <1.893, 1.349, 0.795> 
		<1.693, 1.372, 0.633> <1.754, 1.372, 0.633> <1.833, 1.393, 0.634> <1.893, 1.393, 0.634> 
		<1.693, 1.387, 0.511> <1.754, 1.387, 0.511> <1.833, 1.413, 0.511> <1.893, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.387, 0.511> <1.754, 1.387, 0.511> <1.833, 1.413, 0.511> <1.893, 1.413, 0.511> 
		<1.693, 1.398, 0.419> <1.754, 1.398, 0.419> <1.833, 1.427, 0.420> <1.893, 1.427, 0.420> 
		<1.693, 1.411, 0.296> <1.754, 1.411, 0.296> <1.833, 1.436, 0.296> <1.893, 1.436, 0.296> 
		<1.693, 1.409, 0.204> <1.754, 1.409, 0.204> <1.833, 1.434, 0.204> <1.893, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.693, 1.409, 0.204> <1.754, 1.409, 0.204> <1.833, 1.434, 0.204> <1.893, 1.434, 0.204> 
		<1.693, 1.407, 0.145> <1.754, 1.407, 0.145> <1.833, 1.433, 0.145> <1.893, 1.433, 0.145> 
		<1.693, 1.399, 0.083> <1.754, 1.399, 0.083> <1.833, 1.431, 0.081> <1.893, 1.431, 0.081> 
		<1.693, 1.376, 0.010> <1.754, 1.376, 0.010> <1.833, 1.402, 0.010> <1.893, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.322, 0.917> <-1.847, 1.322, 0.917> <-1.767, 1.322, 0.917> <-1.707, 1.322, 0.917> 
		<-1.907, 1.349, 0.796> <-1.847, 1.349, 0.796> <-1.767, 1.342, 0.796> <-1.707, 1.342, 0.796> 
		<-1.907, 1.393, 0.635> <-1.846, 1.393, 0.635> <-1.767, 1.372, 0.634> <-1.707, 1.372, 0.634> 
		<-1.907, 1.413, 0.511> <-1.846, 1.413, 0.511> <-1.767, 1.387, 0.511> <-1.707, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.413, 0.511> <-1.846, 1.413, 0.511> <-1.767, 1.387, 0.511> <-1.707, 1.387, 0.511> 
		<-1.907, 1.427, 0.420> <-1.846, 1.427, 0.420> <-1.767, 1.398, 0.419> <-1.707, 1.398, 0.419> 
		<-1.907, 1.436, 0.296> <-1.846, 1.436, 0.296> <-1.767, 1.411, 0.296> <-1.707, 1.411, 0.296> 
		<-1.907, 1.434, 0.204> <-1.846, 1.434, 0.204> <-1.767, 1.409, 0.204> <-1.707, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.434, 0.204> <-1.846, 1.434, 0.204> <-1.767, 1.409, 0.204> <-1.707, 1.409, 0.204> 
		<-1.907, 1.433, 0.145> <-1.846, 1.433, 0.145> <-1.767, 1.407, 0.145> <-1.707, 1.407, 0.145> 
		<-1.907, 1.431, 0.081> <-1.846, 1.431, 0.081> <-1.767, 1.399, 0.083> <-1.707, 1.399, 0.083> 
		<-1.907, 1.402, 0.010> <-1.846, 1.402, 0.010> <-1.767, 1.376, 0.010> <-1.707, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.322, 0.917> <-1.647, 1.322, 0.917> <-1.567, 1.322, 0.917> <-1.507, 1.322, 0.917> 
		<-1.707, 1.342, 0.796> <-1.647, 1.342, 0.796> <-1.567, 1.349, 0.796> <-1.507, 1.349, 0.796> 
		<-1.707, 1.372, 0.634> <-1.646, 1.372, 0.634> <-1.567, 1.393, 0.635> <-1.507, 1.393, 0.635> 
		<-1.707, 1.387, 0.511> <-1.646, 1.387, 0.511> <-1.567, 1.413, 0.511> <-1.507, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.387, 0.511> <-1.646, 1.387, 0.511> <-1.567, 1.413, 0.511> <-1.507, 1.413, 0.511> 
		<-1.707, 1.398, 0.419> <-1.646, 1.398, 0.419> <-1.567, 1.427, 0.420> <-1.507, 1.427, 0.420> 
		<-1.707, 1.411, 0.296> <-1.646, 1.411, 0.296> <-1.567, 1.436, 0.296> <-1.507, 1.436, 0.296> 
		<-1.707, 1.409, 0.204> <-1.646, 1.409, 0.204> <-1.567, 1.434, 0.204> <-1.507, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.409, 0.204> <-1.646, 1.409, 0.204> <-1.567, 1.434, 0.204> <-1.507, 1.434, 0.204> 
		<-1.707, 1.407, 0.145> <-1.646, 1.407, 0.145> <-1.567, 1.433, 0.145> <-1.507, 1.433, 0.145> 
		<-1.707, 1.399, 0.083> <-1.646, 1.399, 0.083> <-1.567, 1.431, 0.081> <-1.507, 1.431, 0.081> 
		<-1.707, 1.376, 0.010> <-1.646, 1.376, 0.010> <-1.567, 1.402, 0.010> <-1.507, 1.402, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.322, 0.917> <-1.447, 1.322, 0.917> <-1.366, 1.322, 0.910> <-1.307, 1.322, 0.917> 
		<-1.507, 1.349, 0.796> <-1.447, 1.349, 0.796> <-1.366, 1.342, 0.788> <-1.307, 1.342, 0.796> 
		<-1.507, 1.393, 0.635> <-1.446, 1.393, 0.635> <-1.367, 1.372, 0.634> <-1.307, 1.372, 0.634> 
		<-1.507, 1.413, 0.511> <-1.446, 1.413, 0.511> <-1.367, 1.387, 0.511> <-1.307, 1.387, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.413, 0.511> <-1.446, 1.413, 0.511> <-1.367, 1.387, 0.511> <-1.307, 1.387, 0.511> 
		<-1.507, 1.427, 0.420> <-1.446, 1.427, 0.420> <-1.367, 1.398, 0.419> <-1.307, 1.398, 0.419> 
		<-1.507, 1.436, 0.296> <-1.446, 1.436, 0.296> <-1.367, 1.411, 0.296> <-1.307, 1.411, 0.296> 
		<-1.507, 1.434, 0.204> <-1.446, 1.434, 0.204> <-1.367, 1.409, 0.204> <-1.307, 1.409, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.434, 0.204> <-1.446, 1.434, 0.204> <-1.367, 1.409, 0.204> <-1.307, 1.409, 0.204> 
		<-1.507, 1.433, 0.145> <-1.446, 1.433, 0.145> <-1.367, 1.407, 0.145> <-1.307, 1.407, 0.145> 
		<-1.507, 1.431, 0.081> <-1.446, 1.431, 0.081> <-1.367, 1.399, 0.083> <-1.307, 1.399, 0.083> 
		<-1.507, 1.402, 0.010> <-1.446, 1.402, 0.010> <-1.367, 1.376, 0.010> <-1.307, 1.376, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.322, 0.917> <-1.245, 1.322, 0.925> <-1.168, 1.322, 0.962> <-1.107, 1.322, 0.970> 
		<-1.307, 1.342, 0.796> <-1.245, 1.342, 0.804> <-1.168, 1.349, 0.824> <-1.107, 1.349, 0.832> 
		<-1.307, 1.372, 0.634> <-1.246, 1.372, 0.634> <-1.167, 1.392, 0.650> <-1.107, 1.392, 0.650> 
		<-1.307, 1.387, 0.511> <-1.246, 1.387, 0.511> <-1.167, 1.413, 0.511> <-1.107, 1.413, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.387, 0.511> <-1.246, 1.387, 0.511> <-1.167, 1.413, 0.511> <-1.107, 1.413, 0.511> 
		<-1.307, 1.398, 0.419> <-1.246, 1.398, 0.419> <-1.167, 1.426, 0.420> <-1.107, 1.426, 0.420> 
		<-1.307, 1.411, 0.296> <-1.246, 1.411, 0.296> <-1.167, 1.436, 0.296> <-1.107, 1.436, 0.296> 
		<-1.307, 1.409, 0.204> <-1.246, 1.409, 0.204> <-1.167, 1.434, 0.204> <-1.107, 1.434, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.307, 1.409, 0.204> <-1.246, 1.409, 0.204> <-1.167, 1.434, 0.204> <-1.107, 1.434, 0.204> 
		<-1.307, 1.407, 0.145> <-1.246, 1.407, 0.145> <-1.167, 1.433, 0.145> <-1.107, 1.433, 0.145> 
		<-1.307, 1.399, 0.083> <-1.246, 1.399, 0.083> <-1.167, 1.431, 0.081> <-1.107, 1.431, 0.081> 
		<-1.307, 1.376, 0.010> <-1.246, 1.376, 0.010> <-1.167, 1.402, 0.010> <-1.107, 1.402, 0.010> 
	}
	translate y*(.0001) 
	texture{pigment{image_map {png "CruzdeMalta01.png" once}}
                scale .75
                rotate x*90 translate <1.125,1.45,.1>}
        texture{pigment{image_map {png "CruzdeMalta01.png" once}}
                scale .75
                rotate x*90 translate <-1.88,1.45,.1>}
}
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.447, 1.584> <1.461, -0.447, 1.584> <1.540, -0.447, 1.567> <1.600, -0.447, 1.567> 
		<1.400, -0.440, 1.417> <1.461, -0.440, 1.417> <1.540, -0.440, 1.405> <1.600, -0.440, 1.405> 
		<1.400, -0.430, 1.486> <1.460, -0.430, 1.486> <1.540, -0.430, 1.472> <1.600, -0.430, 1.472> 
		<1.400, -0.423, 1.028> <1.460, -0.423, 1.028> <1.540, -0.423, 1.028> <1.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, -0.432, 0.584> <1.400, -0.440, 0.698> <1.400, -0.417, 0.662> <1.400, -0.423, 1.028> 
		<1.460, -0.432, 0.584> <1.460, -0.440, 0.698> <1.460, -0.417, 0.662> <1.460, -0.423, 1.028> 
		<1.540, -0.432, 0.584> <1.540, -0.448, 0.697> <1.540, -0.417, 0.662> <1.540, -0.423, 1.028> 
		<1.600, -0.432, 0.584> <1.600, -0.448, 0.697> <1.600, -0.417, 0.662> <1.600, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.447, 1.567> <1.661, -0.447, 1.567> <1.740, -0.447, 1.584> <1.800, -0.447, 1.584> 
		<1.600, -0.440, 1.405> <1.661, -0.440, 1.405> <1.740, -0.440, 1.417> <1.800, -0.440, 1.417> 
		<1.600, -0.430, 1.472> <1.660, -0.430, 1.472> <1.740, -0.430, 1.486> <1.800, -0.430, 1.486> 
		<1.600, -0.423, 1.028> <1.660, -0.423, 1.028> <1.740, -0.423, 1.028> <1.800, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.600, -0.432, 0.584> <1.600, -0.448, 0.697> <1.600, -0.417, 0.662> <1.600, -0.423, 1.028> 
		<1.660, -0.432, 0.584> <1.660, -0.448, 0.697> <1.660, -0.417, 0.662> <1.660, -0.423, 1.028> 
		<1.740, -0.432, 0.584> <1.740, -0.440, 0.698> <1.740, -0.417, 0.662> <1.740, -0.423, 1.028> 
		<1.800, -0.432, 0.584> <1.800, -0.440, 0.698> <1.800, -0.417, 0.662> <1.800, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.447, 1.584> <1.861, -0.447, 1.584> <1.940, -0.447, 1.567> <2.000, -0.447, 1.567> 
		<1.800, -0.440, 1.417> <1.861, -0.440, 1.417> <1.940, -0.440, 1.405> <2.000, -0.440, 1.405> 
		<1.800, -0.430, 1.486> <1.860, -0.430, 1.486> <1.940, -0.430, 1.472> <2.000, -0.430, 1.472> 
		<1.800, -0.423, 1.028> <1.860, -0.423, 1.028> <1.940, -0.423, 1.028> <2.000, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, -0.432, 0.584> <1.800, -0.440, 0.698> <1.800, -0.417, 0.662> <1.800, -0.423, 1.028> 
		<1.860, -0.432, 0.584> <1.860, -0.440, 0.698> <1.860, -0.417, 0.662> <1.860, -0.423, 1.028> 
		<1.940, -0.432, 0.584> <1.940, -0.448, 0.697> <1.940, -0.417, 0.662> <1.940, -0.423, 1.028> 
		<2.000, -0.432, 0.584> <2.000, -0.448, 0.697> <2.000, -0.417, 0.662> <2.000, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.447, 1.567> <2.061, -0.447, 1.567> <2.140, -0.447, 1.584> <2.200, -0.447, 1.584> 
		<2.000, -0.440, 1.405> <2.061, -0.440, 1.405> <2.140, -0.440, 1.417> <2.200, -0.440, 1.417> 
		<2.000, -0.430, 1.472> <2.060, -0.430, 1.472> <2.140, -0.430, 1.486> <2.200, -0.430, 1.486> 
		<2.000, -0.423, 1.028> <2.060, -0.423, 1.028> <2.140, -0.423, 1.028> <2.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.000, -0.432, 0.584> <2.000, -0.448, 0.697> <2.000, -0.417, 0.662> <2.000, -0.423, 1.028> 
		<2.060, -0.432, 0.584> <2.060, -0.448, 0.697> <2.060, -0.417, 0.662> <2.060, -0.423, 1.028> 
		<2.140, -0.432, 0.584> <2.140, -0.440, 0.698> <2.140, -0.417, 0.662> <2.140, -0.423, 1.028> 
		<2.200, -0.432, 0.584> <2.200, -0.440, 0.698> <2.200, -0.417, 0.662> <2.200, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.447, 1.584> <-1.459, -0.447, 1.584> <-1.539, -0.447, 1.567> <-1.599, -0.447, 1.567> 
		<-1.399, -0.440, 1.417> <-1.459, -0.440, 1.417> <-1.539, -0.440, 1.405> <-1.599, -0.440, 1.405> 
		<-1.399, -0.430, 1.486> <-1.459, -0.430, 1.486> <-1.539, -0.430, 1.472> <-1.599, -0.430, 1.472> 
		<-1.399, -0.423, 1.028> <-1.459, -0.423, 1.028> <-1.539, -0.423, 1.028> <-1.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.399, -0.432, 0.584> <-1.399, -0.440, 0.698> <-1.399, -0.417, 0.662> <-1.399, -0.423, 1.028> 
		<-1.459, -0.432, 0.584> <-1.459, -0.440, 0.698> <-1.459, -0.417, 0.662> <-1.459, -0.423, 1.028> 
		<-1.539, -0.432, 0.584> <-1.539, -0.448, 0.697> <-1.539, -0.417, 0.662> <-1.539, -0.423, 1.028> 
		<-1.599, -0.432, 0.584> <-1.599, -0.448, 0.697> <-1.599, -0.417, 0.662> <-1.599, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.447, 1.567> <-1.659, -0.447, 1.567> <-1.739, -0.447, 1.584> <-1.799, -0.447, 1.584> 
		<-1.599, -0.440, 1.405> <-1.659, -0.440, 1.405> <-1.739, -0.440, 1.417> <-1.799, -0.440, 1.417> 
		<-1.599, -0.430, 1.472> <-1.659, -0.430, 1.472> <-1.739, -0.430, 1.486> <-1.799, -0.430, 1.486> 
		<-1.599, -0.423, 1.028> <-1.659, -0.423, 1.028> <-1.739, -0.423, 1.028> <-1.799, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.599, -0.432, 0.584> <-1.599, -0.448, 0.697> <-1.599, -0.417, 0.662> <-1.599, -0.423, 1.028> 
		<-1.659, -0.432, 0.584> <-1.659, -0.448, 0.697> <-1.659, -0.417, 0.662> <-1.659, -0.423, 1.028> 
		<-1.739, -0.432, 0.584> <-1.739, -0.440, 0.698> <-1.739, -0.417, 0.662> <-1.739, -0.423, 1.028> 
		<-1.799, -0.432, 0.584> <-1.799, -0.440, 0.698> <-1.799, -0.417, 0.662> <-1.799, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.447, 1.584> <-1.859, -0.447, 1.584> <-1.939, -0.447, 1.567> <-1.999, -0.447, 1.567> 
		<-1.799, -0.440, 1.417> <-1.859, -0.440, 1.417> <-1.939, -0.440, 1.405> <-1.999, -0.440, 1.405> 
		<-1.799, -0.430, 1.486> <-1.859, -0.430, 1.486> <-1.939, -0.430, 1.472> <-1.999, -0.430, 1.472> 
		<-1.799, -0.423, 1.028> <-1.859, -0.423, 1.028> <-1.939, -0.423, 1.028> <-1.999, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.799, -0.432, 0.584> <-1.799, -0.440, 0.698> <-1.799, -0.417, 0.662> <-1.799, -0.423, 1.028> 
		<-1.859, -0.432, 0.584> <-1.859, -0.440, 0.698> <-1.859, -0.417, 0.662> <-1.859, -0.423, 1.028> 
		<-1.939, -0.432, 0.584> <-1.939, -0.448, 0.697> <-1.939, -0.417, 0.662> <-1.939, -0.423, 1.028> 
		<-1.999, -0.432, 0.584> <-1.999, -0.448, 0.697> <-1.999, -0.417, 0.662> <-1.999, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.447, 1.567> <-2.059, -0.447, 1.567> <-2.139, -0.447, 1.584> <-2.199, -0.447, 1.584> 
		<-1.999, -0.440, 1.405> <-2.059, -0.440, 1.405> <-2.139, -0.440, 1.417> <-2.199, -0.440, 1.417> 
		<-1.999, -0.430, 1.472> <-2.059, -0.430, 1.472> <-2.139, -0.430, 1.486> <-2.199, -0.430, 1.486> 
		<-1.999, -0.423, 1.028> <-2.059, -0.423, 1.028> <-2.139, -0.423, 1.028> <-2.199, -0.423, 1.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, -0.432, 0.584> <-1.999, -0.448, 0.697> <-1.999, -0.417, 0.662> <-1.999, -0.423, 1.028> 
		<-2.059, -0.432, 0.584> <-2.059, -0.448, 0.697> <-2.059, -0.417, 0.662> <-2.059, -0.423, 1.028> 
		<-2.139, -0.432, 0.584> <-2.139, -0.440, 0.698> <-2.139, -0.417, 0.662> <-2.139, -0.423, 1.028> 
		<-2.199, -0.432, 0.584> <-2.199, -0.440, 0.698> <-2.199, -0.417, 0.662> <-2.199, -0.423, 1.028> 
	}
	translate y*(-.00001)
	texture {text2Rojo}
	texture {pigment{image_map {png "CruzdeMalta01.png" once}}
                 scale .8 rotate x*90 translate <1.41,-.5,.7>}
        texture {pigment{image_map {png "CruzdeMalta01.png" once}}
                 scale .8 rotate x*90 translate <-1.41-.8,-.5,.7>}
                          
}

	texture {text2Rojo}
	texture {textSucio translate z*40}
}     

#declare Aler_D =  union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.313, 0.915> <-3.171, 1.313, 0.915> <-3.252, 1.313, 0.915> <-3.313, 1.313, 0.915> 
		<-3.111, 1.315, 0.905> <-3.171, 1.315, 0.905> <-3.252, 1.314, 0.925> <-3.312, 1.314, 0.925> 
		<-3.111, 1.317, 0.938> <-3.171, 1.317, 0.938> <-3.251, 1.317, 0.938> <-3.312, 1.317, 0.938> 
		<-3.111, 1.316, 0.948> <-3.171, 1.316, 0.948> <-3.251, 1.316, 0.948> <-3.312, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.313, 0.915> <-3.111, 1.315, 0.905> <-3.111, 1.317, 0.938> <-3.111, 1.316, 0.948> 
		<-3.049, 1.313, 0.915> <-3.049, 1.315, 0.905> <-3.049, 1.317, 0.938> <-3.049, 1.316, 0.948> 
		<-2.968, 1.313, 0.915> <-2.968, 1.315, 0.905> <-2.968, 1.318, 0.938> <-2.968, 1.316, 0.948> 
		<-2.907, 1.313, 0.915> <-2.907, 1.315, 0.905> <-2.907, 1.318, 0.938> <-2.907, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.313, 0.915> <-3.049, 1.313, 0.915> <-2.968, 1.313, 0.915> <-2.907, 1.313, 0.915> 
		<-3.111, 1.304, 0.955> <-3.049, 1.304, 0.955> <-2.968, 1.304, 0.955> <-2.907, 1.304, 0.955> 
		<-3.111, 1.299, 1.010> <-3.049, 1.299, 1.010> <-2.968, 1.299, 1.010> <-2.907, 1.299, 1.010> 
		<-3.111, 1.294, 1.050> <-3.049, 1.294, 1.050> <-2.968, 1.294, 1.050> <-2.907, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.313, 0.915> <-3.111, 1.304, 0.955> <-3.111, 1.299, 1.010> <-3.111, 1.294, 1.050> 
		<-3.171, 1.313, 0.915> <-3.171, 1.304, 0.955> <-3.171, 1.299, 1.010> <-3.171, 1.294, 1.050> 
		<-3.252, 1.313, 0.915> <-3.252, 1.307, 0.956> <-3.252, 1.299, 1.010> <-3.252, 1.294, 1.050> 
		<-3.313, 1.313, 0.915> <-3.313, 1.307, 0.956> <-3.312, 1.299, 1.010> <-3.313, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.294, 1.050> <-3.111, 1.285, 1.118> <-3.111, 1.274, 1.209> <-3.111, 1.265, 1.278> 
		<-3.171, 1.294, 1.050> <-3.171, 1.285, 1.118> <-3.172, 1.274, 1.209> <-3.172, 1.265, 1.278> 
		<-3.252, 1.294, 1.050> <-3.253, 1.286, 1.117> <-3.254, 1.274, 1.207> <-3.255, 1.266, 1.274> 
		<-3.313, 1.294, 1.050> <-3.314, 1.286, 1.117> <-3.316, 1.275, 1.206> <-3.317, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.294, 1.050> <-3.049, 1.294, 1.050> <-2.968, 1.294, 1.050> <-2.907, 1.294, 1.050> 
		<-3.111, 1.285, 1.118> <-3.049, 1.285, 1.118> <-2.968, 1.286, 1.117> <-2.907, 1.286, 1.117> 
		<-3.111, 1.274, 1.209> <-3.049, 1.274, 1.209> <-2.968, 1.275, 1.206> <-2.907, 1.275, 1.206> 
		<-3.111, 1.265, 1.278> <-3.049, 1.265, 1.278> <-2.968, 1.267, 1.273> <-2.907, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.265, 1.278> <-3.111, 1.275, 1.238> <-3.111, 1.290, 1.186> <-3.111, 1.297, 1.146> 
		<-3.172, 1.265, 1.278> <-3.172, 1.275, 1.238> <-3.172, 1.292, 1.187> <-3.172, 1.298, 1.147> 
		<-3.255, 1.266, 1.274> <-3.255, 1.275, 1.236> <-3.255, 1.288, 1.184> <-3.255, 1.297, 1.146> 
		<-3.317, 1.267, 1.273> <-3.317, 1.276, 1.235> <-3.317, 1.288, 1.184> <-3.317, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.265, 1.278> <-3.049, 1.265, 1.278> <-2.968, 1.267, 1.273> <-2.907, 1.267, 1.273> 
		<-3.111, 1.275, 1.238> <-3.049, 1.275, 1.238> <-2.968, 1.273, 1.235> <-2.907, 1.273, 1.235> 
		<-3.111, 1.290, 1.186> <-3.049, 1.289, 1.186> <-2.968, 1.282, 1.184> <-2.907, 1.282, 1.184> 
		<-3.111, 1.297, 1.146> <-3.049, 1.295, 1.146> <-2.968, 1.287, 1.145> <-2.907, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.297, 1.146> <-3.111, 1.306, 1.087> <-3.111, 1.312, 1.008> <-3.111, 1.316, 0.948> 
		<-3.172, 1.298, 1.147> <-3.172, 1.307, 1.087> <-3.171, 1.312, 1.008> <-3.171, 1.316, 0.948> 
		<-3.255, 1.297, 1.146> <-3.253, 1.303, 1.087> <-3.252, 1.312, 1.008> <-3.251, 1.316, 0.948> 
		<-3.317, 1.297, 1.146> <-3.315, 1.303, 1.087> <-3.313, 1.312, 1.008> <-3.312, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.111, 1.297, 1.146> <-3.049, 1.295, 1.146> <-2.968, 1.287, 1.145> <-2.907, 1.287, 1.145> 
		<-3.111, 1.306, 1.087> <-3.049, 1.305, 1.087> <-2.968, 1.297, 1.086> <-2.907, 1.297, 1.086> 
		<-3.111, 1.312, 1.008> <-3.049, 1.312, 1.008> <-2.968, 1.310, 1.008> <-2.907, 1.310, 1.008> 
		<-3.111, 1.316, 0.948> <-3.049, 1.316, 0.948> <-2.968, 1.316, 0.948> <-2.907, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.313, 0.915> <-2.907, 1.315, 0.905> <-2.907, 1.318, 0.938> <-2.907, 1.316, 0.948> 
		<-2.847, 1.313, 0.915> <-2.847, 1.315, 0.905> <-2.847, 1.318, 0.938> <-2.847, 1.316, 0.948> 
		<-2.767, 1.313, 0.915> <-2.767, 1.315, 0.905> <-2.767, 1.317, 0.938> <-2.767, 1.316, 0.948> 
		<-2.707, 1.313, 0.915> <-2.707, 1.315, 0.905> <-2.707, 1.317, 0.938> <-2.707, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.313, 0.915> <-2.847, 1.313, 0.915> <-2.767, 1.313, 0.915> <-2.707, 1.313, 0.915> 
		<-2.907, 1.304, 0.955> <-2.847, 1.304, 0.955> <-2.767, 1.304, 0.955> <-2.707, 1.304, 0.955> 
		<-2.907, 1.299, 1.010> <-2.847, 1.299, 1.010> <-2.767, 1.299, 1.010> <-2.707, 1.299, 1.010> 
		<-2.907, 1.294, 1.050> <-2.847, 1.294, 1.050> <-2.767, 1.294, 1.050> <-2.707, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.294, 1.050> <-2.847, 1.294, 1.050> <-2.767, 1.294, 1.050> <-2.707, 1.294, 1.050> 
		<-2.907, 1.286, 1.117> <-2.847, 1.286, 1.117> <-2.767, 1.285, 1.118> <-2.707, 1.285, 1.118> 
		<-2.907, 1.275, 1.206> <-2.847, 1.275, 1.206> <-2.767, 1.274, 1.209> <-2.707, 1.274, 1.209> 
		<-2.907, 1.267, 1.273> <-2.847, 1.267, 1.273> <-2.767, 1.265, 1.278> <-2.707, 1.265, 1.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.267, 1.273> <-2.847, 1.267, 1.273> <-2.767, 1.265, 1.278> <-2.707, 1.265, 1.278> 
		<-2.907, 1.273, 1.235> <-2.847, 1.273, 1.235> <-2.767, 1.275, 1.238> <-2.707, 1.275, 1.238> 
		<-2.907, 1.282, 1.184> <-2.847, 1.282, 1.184> <-2.767, 1.290, 1.186> <-2.707, 1.290, 1.186> 
		<-2.907, 1.287, 1.145> <-2.847, 1.287, 1.145> <-2.767, 1.297, 1.146> <-2.707, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.907, 1.287, 1.145> <-2.847, 1.287, 1.145> <-2.767, 1.297, 1.146> <-2.707, 1.297, 1.146> 
		<-2.907, 1.297, 1.086> <-2.847, 1.297, 1.086> <-2.767, 1.306, 1.087> <-2.707, 1.306, 1.087> 
		<-2.907, 1.310, 1.008> <-2.847, 1.310, 1.008> <-2.767, 1.312, 1.008> <-2.707, 1.312, 1.008> 
		<-2.907, 1.316, 0.948> <-2.847, 1.316, 0.948> <-2.767, 1.316, 0.948> <-2.707, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.313, 0.915> <-2.707, 1.315, 0.905> <-2.707, 1.317, 0.938> <-2.707, 1.316, 0.948> 
		<-2.647, 1.313, 0.915> <-2.647, 1.315, 0.905> <-2.647, 1.317, 0.938> <-2.647, 1.316, 0.948> 
		<-2.567, 1.313, 0.915> <-2.567, 1.315, 0.905> <-2.567, 1.318, 0.938> <-2.567, 1.316, 0.948> 
		<-2.507, 1.313, 0.915> <-2.507, 1.315, 0.905> <-2.507, 1.318, 0.938> <-2.507, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.313, 0.915> <-2.647, 1.313, 0.915> <-2.567, 1.313, 0.915> <-2.507, 1.313, 0.915> 
		<-2.707, 1.304, 0.955> <-2.647, 1.304, 0.955> <-2.567, 1.304, 0.955> <-2.507, 1.304, 0.955> 
		<-2.707, 1.299, 1.010> <-2.647, 1.299, 1.010> <-2.567, 1.299, 1.010> <-2.507, 1.299, 1.010> 
		<-2.707, 1.294, 1.050> <-2.647, 1.294, 1.050> <-2.567, 1.294, 1.050> <-2.507, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.294, 1.050> <-2.647, 1.294, 1.050> <-2.567, 1.294, 1.050> <-2.507, 1.294, 1.050> 
		<-2.707, 1.285, 1.118> <-2.647, 1.285, 1.118> <-2.567, 1.286, 1.117> <-2.507, 1.286, 1.117> 
		<-2.707, 1.274, 1.209> <-2.647, 1.274, 1.209> <-2.567, 1.275, 1.206> <-2.507, 1.275, 1.206> 
		<-2.707, 1.265, 1.278> <-2.647, 1.265, 1.278> <-2.567, 1.267, 1.273> <-2.507, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.265, 1.278> <-2.647, 1.265, 1.278> <-2.567, 1.267, 1.273> <-2.507, 1.267, 1.273> 
		<-2.707, 1.275, 1.238> <-2.647, 1.275, 1.238> <-2.567, 1.273, 1.235> <-2.507, 1.273, 1.235> 
		<-2.707, 1.290, 1.186> <-2.647, 1.290, 1.186> <-2.567, 1.282, 1.184> <-2.507, 1.282, 1.184> 
		<-2.707, 1.297, 1.146> <-2.647, 1.297, 1.146> <-2.567, 1.287, 1.145> <-2.507, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.707, 1.297, 1.146> <-2.647, 1.297, 1.146> <-2.567, 1.287, 1.145> <-2.507, 1.287, 1.145> 
		<-2.707, 1.306, 1.087> <-2.647, 1.306, 1.087> <-2.567, 1.297, 1.086> <-2.507, 1.297, 1.086> 
		<-2.707, 1.312, 1.008> <-2.647, 1.312, 1.008> <-2.567, 1.310, 1.008> <-2.507, 1.310, 1.008> 
		<-2.707, 1.316, 0.948> <-2.647, 1.316, 0.948> <-2.567, 1.316, 0.948> <-2.507, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.313, 0.915> <-2.507, 1.315, 0.905> <-2.507, 1.318, 0.938> <-2.507, 1.316, 0.948> 
		<-2.447, 1.313, 0.915> <-2.447, 1.315, 0.905> <-2.447, 1.318, 0.938> <-2.447, 1.316, 0.948> 
		<-2.367, 1.313, 0.915> <-2.367, 1.315, 0.905> <-2.367, 1.317, 0.938> <-2.367, 1.316, 0.948> 
		<-2.307, 1.313, 0.915> <-2.307, 1.315, 0.905> <-2.307, 1.317, 0.938> <-2.307, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.313, 0.915> <-2.447, 1.313, 0.915> <-2.367, 1.313, 0.915> <-2.307, 1.313, 0.915> 
		<-2.507, 1.304, 0.955> <-2.447, 1.304, 0.955> <-2.367, 1.304, 0.955> <-2.307, 1.304, 0.955> 
		<-2.507, 1.299, 1.010> <-2.447, 1.299, 1.010> <-2.367, 1.299, 1.010> <-2.307, 1.299, 1.010> 
		<-2.507, 1.294, 1.050> <-2.447, 1.294, 1.050> <-2.367, 1.294, 1.050> <-2.307, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.294, 1.050> <-2.447, 1.294, 1.050> <-2.367, 1.294, 1.050> <-2.307, 1.294, 1.050> 
		<-2.507, 1.286, 1.117> <-2.447, 1.286, 1.117> <-2.367, 1.285, 1.118> <-2.307, 1.285, 1.118> 
		<-2.507, 1.275, 1.206> <-2.447, 1.275, 1.206> <-2.367, 1.274, 1.209> <-2.307, 1.274, 1.209> 
		<-2.507, 1.267, 1.273> <-2.447, 1.267, 1.273> <-2.367, 1.265, 1.278> <-2.307, 1.265, 1.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.267, 1.273> <-2.447, 1.267, 1.273> <-2.367, 1.265, 1.278> <-2.307, 1.265, 1.278> 
		<-2.507, 1.273, 1.235> <-2.447, 1.273, 1.235> <-2.367, 1.275, 1.238> <-2.307, 1.275, 1.238> 
		<-2.507, 1.282, 1.184> <-2.447, 1.282, 1.184> <-2.367, 1.290, 1.186> <-2.307, 1.290, 1.186> 
		<-2.507, 1.287, 1.145> <-2.447, 1.287, 1.145> <-2.367, 1.297, 1.146> <-2.307, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 1.287, 1.145> <-2.447, 1.287, 1.145> <-2.367, 1.297, 1.146> <-2.307, 1.297, 1.146> 
		<-2.507, 1.297, 1.086> <-2.447, 1.297, 1.086> <-2.367, 1.306, 1.087> <-2.307, 1.306, 1.087> 
		<-2.507, 1.310, 1.008> <-2.447, 1.310, 1.008> <-2.367, 1.312, 1.008> <-2.307, 1.312, 1.008> 
		<-2.507, 1.316, 0.948> <-2.447, 1.316, 0.948> <-2.367, 1.316, 0.948> <-2.307, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.313, 0.915> <-2.307, 1.315, 0.905> <-2.307, 1.317, 0.938> <-2.307, 1.316, 0.948> 
		<-2.247, 1.313, 0.915> <-2.247, 1.315, 0.905> <-2.247, 1.317, 0.938> <-2.247, 1.316, 0.948> 
		<-2.167, 1.313, 0.915> <-2.167, 1.315, 0.905> <-2.167, 1.318, 0.938> <-2.167, 1.316, 0.948> 
		<-2.107, 1.313, 0.915> <-2.107, 1.315, 0.905> <-2.107, 1.318, 0.938> <-2.107, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.313, 0.915> <-2.247, 1.313, 0.915> <-2.167, 1.313, 0.915> <-2.107, 1.313, 0.915> 
		<-2.307, 1.304, 0.955> <-2.247, 1.304, 0.955> <-2.167, 1.304, 0.955> <-2.107, 1.304, 0.955> 
		<-2.307, 1.299, 1.010> <-2.247, 1.299, 1.010> <-2.167, 1.299, 1.010> <-2.107, 1.299, 1.010> 
		<-2.307, 1.294, 1.050> <-2.247, 1.294, 1.050> <-2.167, 1.294, 1.050> <-2.107, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.294, 1.050> <-2.247, 1.294, 1.050> <-2.167, 1.294, 1.050> <-2.107, 1.294, 1.050> 
		<-2.307, 1.285, 1.118> <-2.247, 1.285, 1.118> <-2.167, 1.286, 1.117> <-2.107, 1.286, 1.117> 
		<-2.307, 1.274, 1.209> <-2.247, 1.274, 1.209> <-2.167, 1.275, 1.206> <-2.107, 1.275, 1.206> 
		<-2.307, 1.265, 1.278> <-2.247, 1.265, 1.278> <-2.167, 1.267, 1.273> <-2.107, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.265, 1.278> <-2.247, 1.265, 1.278> <-2.167, 1.267, 1.273> <-2.107, 1.267, 1.273> 
		<-2.307, 1.275, 1.238> <-2.247, 1.275, 1.238> <-2.167, 1.273, 1.235> <-2.107, 1.273, 1.235> 
		<-2.307, 1.290, 1.186> <-2.247, 1.290, 1.186> <-2.167, 1.282, 1.184> <-2.107, 1.282, 1.184> 
		<-2.307, 1.297, 1.146> <-2.247, 1.297, 1.146> <-2.167, 1.287, 1.145> <-2.107, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.307, 1.297, 1.146> <-2.247, 1.297, 1.146> <-2.167, 1.287, 1.145> <-2.107, 1.287, 1.145> 
		<-2.307, 1.306, 1.087> <-2.247, 1.306, 1.087> <-2.167, 1.297, 1.086> <-2.107, 1.297, 1.086> 
		<-2.307, 1.312, 1.008> <-2.247, 1.312, 1.008> <-2.167, 1.310, 1.008> <-2.107, 1.310, 1.008> 
		<-2.307, 1.316, 0.948> <-2.247, 1.316, 0.948> <-2.167, 1.316, 0.948> <-2.107, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.313, 0.915> <-2.107, 1.315, 0.905> <-2.107, 1.318, 0.938> <-2.107, 1.316, 0.948> 
		<-2.047, 1.313, 0.915> <-2.047, 1.315, 0.905> <-2.047, 1.318, 0.938> <-2.047, 1.316, 0.948> 
		<-1.967, 1.313, 0.915> <-1.967, 1.315, 0.905> <-1.967, 1.317, 0.938> <-1.967, 1.316, 0.948> 
		<-1.907, 1.313, 0.915> <-1.907, 1.315, 0.905> <-1.907, 1.317, 0.938> <-1.907, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.313, 0.915> <-2.047, 1.313, 0.915> <-1.967, 1.313, 0.915> <-1.907, 1.313, 0.915> 
		<-2.107, 1.304, 0.955> <-2.047, 1.304, 0.955> <-1.967, 1.304, 0.955> <-1.907, 1.304, 0.955> 
		<-2.107, 1.299, 1.010> <-2.047, 1.299, 1.010> <-1.967, 1.299, 1.010> <-1.907, 1.299, 1.010> 
		<-2.107, 1.294, 1.050> <-2.047, 1.294, 1.050> <-1.967, 1.294, 1.050> <-1.907, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.294, 1.050> <-2.047, 1.294, 1.050> <-1.967, 1.294, 1.050> <-1.907, 1.294, 1.050> 
		<-2.107, 1.286, 1.117> <-2.047, 1.286, 1.117> <-1.967, 1.285, 1.118> <-1.907, 1.285, 1.118> 
		<-2.107, 1.275, 1.206> <-2.047, 1.275, 1.206> <-1.967, 1.274, 1.209> <-1.907, 1.274, 1.209> 
		<-2.107, 1.267, 1.273> <-2.047, 1.267, 1.273> <-1.967, 1.265, 1.278> <-1.907, 1.265, 1.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.267, 1.273> <-2.047, 1.267, 1.273> <-1.967, 1.265, 1.278> <-1.907, 1.265, 1.278> 
		<-2.107, 1.273, 1.235> <-2.047, 1.273, 1.235> <-1.967, 1.275, 1.238> <-1.907, 1.275, 1.238> 
		<-2.107, 1.282, 1.184> <-2.047, 1.282, 1.184> <-1.967, 1.290, 1.186> <-1.907, 1.290, 1.186> 
		<-2.107, 1.287, 1.145> <-2.047, 1.287, 1.145> <-1.967, 1.297, 1.146> <-1.907, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.287, 1.145> <-2.047, 1.287, 1.145> <-1.967, 1.297, 1.146> <-1.907, 1.297, 1.146> 
		<-2.107, 1.297, 1.086> <-2.047, 1.297, 1.086> <-1.967, 1.306, 1.087> <-1.907, 1.306, 1.087> 
		<-2.107, 1.310, 1.008> <-2.047, 1.310, 1.008> <-1.967, 1.312, 1.008> <-1.907, 1.312, 1.008> 
		<-2.107, 1.316, 0.948> <-2.047, 1.316, 0.948> <-1.967, 1.316, 0.948> <-1.907, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.313, 0.915> <-1.907, 1.315, 0.905> <-1.907, 1.317, 0.938> <-1.907, 1.316, 0.948> 
		<-1.847, 1.313, 0.915> <-1.847, 1.315, 0.905> <-1.847, 1.317, 0.938> <-1.847, 1.316, 0.948> 
		<-1.767, 1.313, 0.915> <-1.767, 1.315, 0.905> <-1.767, 1.318, 0.938> <-1.767, 1.316, 0.948> 
		<-1.707, 1.313, 0.915> <-1.707, 1.315, 0.905> <-1.707, 1.318, 0.938> <-1.707, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.313, 0.915> <-1.847, 1.313, 0.915> <-1.767, 1.313, 0.915> <-1.707, 1.313, 0.915> 
		<-1.907, 1.304, 0.955> <-1.847, 1.304, 0.955> <-1.767, 1.304, 0.955> <-1.707, 1.304, 0.955> 
		<-1.907, 1.299, 1.010> <-1.847, 1.299, 1.010> <-1.767, 1.299, 1.010> <-1.707, 1.299, 1.010> 
		<-1.907, 1.294, 1.050> <-1.847, 1.294, 1.050> <-1.767, 1.294, 1.050> <-1.707, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.294, 1.050> <-1.847, 1.294, 1.050> <-1.767, 1.294, 1.050> <-1.707, 1.294, 1.050> 
		<-1.907, 1.285, 1.118> <-1.847, 1.285, 1.118> <-1.767, 1.286, 1.117> <-1.707, 1.286, 1.117> 
		<-1.907, 1.274, 1.209> <-1.847, 1.274, 1.209> <-1.767, 1.275, 1.208> <-1.707, 1.275, 1.206> 
		<-1.907, 1.265, 1.278> <-1.847, 1.265, 1.278> <-1.767, 1.266, 1.275> <-1.707, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.265, 1.278> <-1.847, 1.265, 1.278> <-1.767, 1.266, 1.275> <-1.707, 1.267, 1.273> 
		<-1.907, 1.275, 1.238> <-1.847, 1.275, 1.238> <-1.767, 1.273, 1.237> <-1.707, 1.273, 1.235> 
		<-1.907, 1.290, 1.186> <-1.847, 1.290, 1.186> <-1.767, 1.282, 1.184> <-1.707, 1.282, 1.184> 
		<-1.907, 1.297, 1.146> <-1.847, 1.297, 1.146> <-1.767, 1.287, 1.145> <-1.707, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.907, 1.297, 1.146> <-1.847, 1.297, 1.146> <-1.767, 1.287, 1.145> <-1.707, 1.287, 1.145> 
		<-1.907, 1.306, 1.087> <-1.847, 1.306, 1.087> <-1.767, 1.297, 1.086> <-1.707, 1.297, 1.086> 
		<-1.907, 1.312, 1.008> <-1.847, 1.312, 1.008> <-1.767, 1.310, 1.008> <-1.707, 1.310, 1.008> 
		<-1.907, 1.316, 0.948> <-1.847, 1.316, 0.948> <-1.767, 1.316, 0.948> <-1.707, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.313, 0.915> <-1.707, 1.315, 0.905> <-1.707, 1.318, 0.938> <-1.707, 1.316, 0.948> 
		<-1.647, 1.313, 0.915> <-1.647, 1.315, 0.905> <-1.647, 1.318, 0.938> <-1.647, 1.316, 0.948> 
		<-1.567, 1.313, 0.914> <-1.567, 1.315, 0.905> <-1.567, 1.317, 0.938> <-1.567, 1.316, 0.948> 
		<-1.507, 1.313, 0.915> <-1.507, 1.315, 0.905> <-1.507, 1.317, 0.938> <-1.507, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.313, 0.915> <-1.647, 1.313, 0.915> <-1.567, 1.313, 0.914> <-1.507, 1.313, 0.915> 
		<-1.707, 1.304, 0.955> <-1.647, 1.304, 0.955> <-1.567, 1.304, 0.954> <-1.507, 1.304, 0.955> 
		<-1.707, 1.299, 1.010> <-1.647, 1.299, 1.010> <-1.567, 1.299, 1.010> <-1.507, 1.300, 1.010> 
		<-1.707, 1.294, 1.050> <-1.647, 1.294, 1.050> <-1.567, 1.294, 1.051> <-1.507, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.294, 1.050> <-1.647, 1.294, 1.050> <-1.567, 1.294, 1.051> <-1.507, 1.294, 1.050> 
		<-1.707, 1.286, 1.117> <-1.647, 1.286, 1.117> <-1.567, 1.286, 1.114> <-1.507, 1.286, 1.114> 
		<-1.707, 1.275, 1.206> <-1.647, 1.275, 1.204> <-1.566, 1.274, 1.210> <-1.507, 1.275, 1.198> 
		<-1.707, 1.267, 1.273> <-1.647, 1.267, 1.270> <-1.566, 1.266, 1.273> <-1.507, 1.267, 1.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.267, 1.273> <-1.647, 1.267, 1.270> <-1.566, 1.266, 1.273> <-1.507, 1.267, 1.262> 
		<-1.707, 1.273, 1.235> <-1.647, 1.273, 1.232> <-1.566, 1.275, 1.239> <-1.507, 1.276, 1.227> 
		<-1.707, 1.282, 1.184> <-1.647, 1.282, 1.184> <-1.567, 1.291, 1.185> <-1.507, 1.291, 1.182> 
		<-1.707, 1.287, 1.145> <-1.647, 1.287, 1.145> <-1.567, 1.296, 1.150> <-1.507, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.707, 1.287, 1.145> <-1.647, 1.287, 1.145> <-1.567, 1.296, 1.150> <-1.507, 1.297, 1.146> 
		<-1.707, 1.297, 1.086> <-1.647, 1.297, 1.086> <-1.567, 1.306, 1.091> <-1.507, 1.306, 1.087> 
		<-1.707, 1.310, 1.008> <-1.647, 1.310, 1.008> <-1.567, 1.312, 1.008> <-1.507, 1.312, 1.008> 
		<-1.707, 1.316, 0.948> <-1.647, 1.316, 0.948> <-1.567, 1.316, 0.948> <-1.507, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.313, 0.915> <-1.507, 1.315, 0.905> <-1.507, 1.317, 0.938> <-1.507, 1.316, 0.948> 
		<-1.447, 1.313, 0.916> <-1.447, 1.315, 0.906> <-1.447, 1.317, 0.938> <-1.447, 1.316, 0.948> 
		<-1.366, 1.313, 0.913> <-1.366, 1.315, 0.905> <-1.366, 1.319, 0.933> <-1.366, 1.318, 0.941> 
		<-1.307, 1.312, 0.921> <-1.307, 1.314, 0.913> <-1.307, 1.317, 0.940> <-1.307, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.313, 0.915> <-1.447, 1.313, 0.916> <-1.366, 1.313, 0.913> <-1.307, 1.312, 0.921> 
		<-1.507, 1.304, 0.955> <-1.447, 1.304, 0.956> <-1.366, 1.305, 0.949> <-1.307, 1.304, 0.958> 
		<-1.507, 1.300, 1.010> <-1.447, 1.300, 1.009> <-1.366, 1.299, 1.013> <-1.307, 1.300, 1.008> 
		<-1.507, 1.294, 1.050> <-1.447, 1.294, 1.049> <-1.366, 1.294, 1.050> <-1.307, 1.295, 1.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.294, 1.050> <-1.447, 1.294, 1.049> <-1.366, 1.294, 1.050> <-1.307, 1.295, 1.045> 
		<-1.507, 1.286, 1.114> <-1.447, 1.286, 1.113> <-1.366, 1.288, 1.095> <-1.307, 1.289, 1.090> 
		<-1.507, 1.275, 1.198> <-1.445, 1.276, 1.186> <-1.367, 1.278, 1.170> <-1.307, 1.281, 1.150> 
		<-1.507, 1.267, 1.262> <-1.445, 1.268, 1.250> <-1.367, 1.272, 1.215> <-1.307, 1.275, 1.194> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.267, 1.262> <-1.445, 1.268, 1.250> <-1.367, 1.272, 1.215> <-1.307, 1.275, 1.194> 
		<-1.507, 1.276, 1.227> <-1.445, 1.277, 1.215> <-1.367, 1.277, 1.193> <-1.307, 1.279, 1.173> 
		<-1.507, 1.291, 1.182> <-1.446, 1.291, 1.178> <-1.365, 1.286, 1.160> <-1.307, 1.286, 1.145> 
		<-1.507, 1.297, 1.146> <-1.446, 1.297, 1.143> <-1.365, 1.289, 1.139> <-1.307, 1.290, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.507, 1.297, 1.146> <-1.446, 1.297, 1.143> <-1.365, 1.289, 1.139> <-1.307, 1.290, 1.123> 
		<-1.507, 1.306, 1.087> <-1.446, 1.306, 1.084> <-1.365, 1.298, 1.086> <-1.307, 1.299, 1.071> 
		<-1.507, 1.312, 1.008> <-1.447, 1.312, 1.008> <-1.366, 1.312, 0.994> <-1.307, 1.311, 1.001> 
		<-1.507, 1.316, 0.948> <-1.447, 1.316, 0.948> <-1.366, 1.318, 0.941> <-1.307, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.307, 0.973> <-1.112, 1.301, 0.985> <-1.112, 1.300, 1.002> <-1.112, 1.298, 1.014> 
		<-1.112, 1.309, 0.967> <-1.112, 1.304, 0.979> <-1.112, 1.301, 1.010> <-1.112, 1.298, 1.023> 
		<-1.112, 1.308, 0.988> <-1.112, 1.306, 1.002> <-1.104, 1.303, 1.024> <-1.104, 1.300, 1.038> 
		<-1.112, 1.307, 0.994> <-1.112, 1.306, 1.008> <-1.112, 1.303, 1.028> <-1.112, 1.299, 1.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.307, 0.973> <-1.112, 1.309, 0.967> <-1.112, 1.308, 0.988> <-1.112, 1.307, 0.994> 
		<-1.170, 1.308, 0.958> <-1.170, 1.311, 0.952> <-1.170, 1.311, 0.974> <-1.170, 1.310, 0.980> 
		<-1.247, 1.311, 0.930> <-1.247, 1.313, 0.922> <-1.247, 1.316, 0.947> <-1.247, 1.315, 0.955> 
		<-1.307, 1.312, 0.921> <-1.307, 1.314, 0.913> <-1.307, 1.317, 0.940> <-1.307, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.307, 0.973> <-1.112, 1.301, 0.985> <-1.112, 1.300, 1.002> <-1.112, 1.298, 1.014> 
		<-1.170, 1.308, 0.958> <-1.170, 1.303, 0.969> <-1.170, 1.299, 1.011> <-1.170, 1.297, 1.024> 
		<-1.247, 1.311, 0.930> <-1.247, 1.303, 0.967> <-1.248, 1.300, 1.003> <-1.248, 1.295, 1.040> 
		<-1.307, 1.312, 0.921> <-1.307, 1.304, 0.958> <-1.307, 1.300, 1.008> <-1.307, 1.295, 1.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.287, 1.073> <-1.112, 1.287, 1.073> <-1.112, 1.287, 1.073> <-1.112, 1.287, 1.073> 
		<-1.112, 1.290, 1.056> <-1.112, 1.294, 1.046> <-1.112, 1.294, 1.046> <-1.112, 1.291, 1.064> 
		<-1.112, 1.294, 1.032> <-1.112, 1.295, 1.040> <-1.104, 1.297, 1.048> <-1.112, 1.297, 1.052> 
		<-1.112, 1.298, 1.014> <-1.112, 1.298, 1.023> <-1.104, 1.300, 1.038> <-1.112, 1.299, 1.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.287, 1.073> <-1.112, 1.290, 1.056> <-1.112, 1.294, 1.032> <-1.112, 1.298, 1.014> 
		<-1.170, 1.283, 1.110> <-1.170, 1.287, 1.092> <-1.170, 1.293, 1.041> <-1.170, 1.297, 1.024> 
		<-1.248, 1.278, 1.158> <-1.248, 1.284, 1.113> <-1.248, 1.289, 1.084> <-1.248, 1.295, 1.040> 
		<-1.307, 1.275, 1.194> <-1.307, 1.281, 1.150> <-1.307, 1.289, 1.090> <-1.307, 1.295, 1.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.287, 1.073> <-1.112, 1.291, 1.064> <-1.112, 1.297, 1.052> <-1.112, 1.299, 1.042> 
		<-1.170, 1.283, 1.110> <-1.170, 1.287, 1.100> <-1.167, 1.295, 1.082> <-1.167, 1.297, 1.073> 
		<-1.248, 1.278, 1.158> <-1.248, 1.283, 1.137> <-1.245, 1.287, 1.128> <-1.245, 1.290, 1.107> 
		<-1.307, 1.275, 1.194> <-1.307, 1.279, 1.173> <-1.307, 1.286, 1.145> <-1.307, 1.290, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.307, 0.994> <-1.112, 1.306, 1.008> <-1.112, 1.303, 1.028> <-1.112, 1.299, 1.042> 
		<-1.170, 1.310, 0.980> <-1.170, 1.308, 0.995> <-1.167, 1.301, 1.059> <-1.167, 1.297, 1.073> 
		<-1.247, 1.315, 0.955> <-1.247, 1.309, 1.008> <-1.245, 1.299, 1.055> <-1.245, 1.290, 1.107> 
		<-1.307, 1.316, 0.948> <-1.307, 1.311, 1.001> <-1.307, 1.299, 1.071> <-1.307, 1.290, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.313, 1.313, 0.915> <-3.314, 1.320, 0.841> <-3.316, 1.330, 0.743> <-3.317, 1.338, 0.670> 
		<-3.312, 1.314, 0.925> <-3.314, 1.321, 0.851> <-3.316, 1.331, 0.757> <-3.317, 1.339, 0.684> 
		<-3.312, 1.317, 0.938> <-3.313, 1.325, 0.868> <-3.315, 1.333, 0.772> <-3.317, 1.340, 0.702> 
		<-3.312, 1.316, 0.948> <-3.313, 1.324, 0.878> <-3.315, 1.334, 0.786> <-3.317, 1.341, 0.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.313, 1.313, 0.915> <-3.313, 1.307, 0.956> <-3.312, 1.299, 1.010> <-3.313, 1.294, 1.050> 
		<-3.314, 1.320, 0.841> <-3.314, 1.315, 0.882> <-3.314, 1.307, 0.936> <-3.314, 1.302, 0.977> 
		<-3.316, 1.330, 0.743> <-3.316, 1.325, 0.784> <-3.316, 1.317, 0.838> <-3.316, 1.312, 0.878> 
		<-3.317, 1.338, 0.670> <-3.317, 1.332, 0.710> <-3.317, 1.325, 0.764> <-3.317, 1.319, 0.805> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.313, 1.294, 1.050> <-3.313, 1.294, 1.050> <-3.313, 1.294, 1.050> <-3.313, 1.294, 1.050> 
		<-3.314, 1.302, 0.977> <-3.315, 1.293, 1.043> <-3.315, 1.293, 1.043> <-3.314, 1.286, 1.117> 
		<-3.316, 1.312, 0.878> <-3.316, 1.296, 1.019> <-3.316, 1.291, 1.066> <-3.316, 1.275, 1.206> 
		<-3.317, 1.319, 0.805> <-3.317, 1.304, 0.945> <-3.317, 1.282, 1.132> <-3.317, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.317, 1.267, 1.273> <-3.367, 1.267, 1.271> <-3.436, 1.266, 1.283> <-3.483, 1.267, 1.265> 
		<-3.317, 1.282, 1.132> <-3.367, 1.283, 1.130> <-3.436, 1.281, 1.150> <-3.483, 1.282, 1.132> 
		<-3.317, 1.304, 0.945> <-3.367, 1.303, 0.951> <-3.434, 1.304, 0.946> <-3.483, 1.303, 0.955> 
		<-3.317, 1.319, 0.805> <-3.367, 1.319, 0.810> <-3.434, 1.319, 0.813> <-3.483, 1.318, 0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.317, 1.267, 1.273> <-3.317, 1.276, 1.235> <-3.317, 1.288, 1.184> <-3.317, 1.297, 1.146> 
		<-3.367, 1.267, 1.271> <-3.367, 1.276, 1.233> <-3.367, 1.288, 1.181> <-3.367, 1.297, 1.144> 
		<-3.436, 1.266, 1.283> <-3.436, 1.275, 1.244> <-3.435, 1.289, 1.188> <-3.435, 1.298, 1.149> 
		<-3.483, 1.267, 1.265> <-3.483, 1.276, 1.227> <-3.483, 1.289, 1.175> <-3.483, 1.298, 1.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.317, 1.297, 1.146> <-3.317, 1.297, 1.146> <-3.317, 1.297, 1.146> <-3.317, 1.297, 1.146> 
		<-3.317, 1.310, 1.017> <-3.315, 1.316, 0.958> <-3.315, 1.316, 0.958> <-3.315, 1.303, 1.087> 
		<-3.317, 1.328, 0.845> <-3.315, 1.320, 0.915> <-3.314, 1.320, 0.938> <-3.313, 1.312, 1.008> 
		<-3.317, 1.341, 0.716> <-3.315, 1.334, 0.786> <-3.313, 1.324, 0.878> <-3.312, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.317, 1.297, 1.146> <-3.317, 1.310, 1.017> <-3.317, 1.328, 0.845> <-3.317, 1.341, 0.716> 
		<-3.367, 1.297, 1.144> <-3.367, 1.310, 1.014> <-3.367, 1.327, 0.851> <-3.367, 1.341, 0.721> 
		<-3.435, 1.298, 1.149> <-3.435, 1.310, 1.029> <-3.435, 1.329, 0.841> <-3.435, 1.342, 0.720> 
		<-3.483, 1.298, 1.137> <-3.483, 1.310, 1.016> <-3.483, 1.327, 0.855> <-3.483, 1.339, 0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.317, 1.338, 0.670> <-3.367, 1.338, 0.670> <-3.434, 1.339, 0.661> <-3.483, 1.338, 0.670> 
		<-3.317, 1.339, 0.684> <-3.367, 1.339, 0.684> <-3.434, 1.339, 0.681> <-3.483, 1.338, 0.689> 
		<-3.317, 1.340, 0.702> <-3.367, 1.340, 0.708> <-3.435, 1.341, 0.701> <-3.483, 1.339, 0.715> 
		<-3.317, 1.341, 0.716> <-3.367, 1.341, 0.721> <-3.435, 1.342, 0.720> <-3.483, 1.339, 0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.317, 1.338, 0.670> <-3.317, 1.332, 0.710> <-3.317, 1.325, 0.764> <-3.317, 1.319, 0.805> 
		<-3.367, 1.338, 0.670> <-3.367, 1.332, 0.710> <-3.367, 1.324, 0.770> <-3.367, 1.319, 0.810> 
		<-3.434, 1.339, 0.661> <-3.434, 1.333, 0.707> <-3.434, 1.325, 0.767> <-3.434, 1.319, 0.813> 
		<-3.483, 1.338, 0.670> <-3.483, 1.332, 0.716> <-3.483, 1.324, 0.777> <-3.483, 1.318, 0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.483, 1.338, 0.670> <-3.520, 1.337, 0.676> <-3.563, 1.334, 0.703> <-3.598, 1.333, 0.718> 
		<-3.483, 1.338, 0.689> <-3.520, 1.338, 0.695> <-3.563, 1.333, 0.727> <-3.598, 1.331, 0.742> 
		<-3.483, 1.339, 0.715> <-3.521, 1.337, 0.726> <-3.563, 1.333, 0.755> <-3.598, 1.329, 0.774> 
		<-3.483, 1.339, 0.734> <-3.521, 1.338, 0.745> <-3.563, 1.331, 0.779> <-3.598, 1.328, 0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.483, 1.338, 0.670> <-3.483, 1.332, 0.716> <-3.483, 1.324, 0.777> <-3.483, 1.318, 0.823> 
		<-3.520, 1.337, 0.676> <-3.520, 1.331, 0.722> <-3.519, 1.323, 0.784> <-3.519, 1.317, 0.830> 
		<-3.563, 1.334, 0.703> <-3.563, 1.329, 0.746> <-3.563, 1.321, 0.807> <-3.563, 1.315, 0.850> 
		<-3.598, 1.333, 0.718> <-3.598, 1.327, 0.761> <-3.598, 1.319, 0.818> <-3.598, 1.314, 0.862> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.483, 1.318, 0.823> <-3.483, 1.303, 0.955> <-3.483, 1.282, 1.132> <-3.483, 1.267, 1.265> 
		<-3.519, 1.317, 0.830> <-3.519, 1.302, 0.963> <-3.525, 1.284, 1.117> <-3.525, 1.269, 1.250> 
		<-3.563, 1.315, 0.850> <-3.563, 1.304, 0.942> <-3.563, 1.285, 1.106> <-3.563, 1.274, 1.198> 
		<-3.598, 1.314, 0.862> <-3.598, 1.303, 0.954> <-3.598, 1.288, 1.077> <-3.598, 1.277, 1.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.483, 1.267, 1.265> <-3.483, 1.276, 1.227> <-3.483, 1.289, 1.175> <-3.483, 1.298, 1.137> 
		<-3.525, 1.269, 1.250> <-3.525, 1.278, 1.211> <-3.521, 1.289, 1.166> <-3.521, 1.298, 1.127> 
		<-3.563, 1.274, 1.198> <-3.563, 1.280, 1.169> <-3.563, 1.291, 1.121> <-3.563, 1.297, 1.093> 
		<-3.598, 1.277, 1.169> <-3.598, 1.283, 1.140> <-3.598, 1.291, 1.102> <-3.598, 1.296, 1.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.483, 1.298, 1.137> <-3.483, 1.310, 1.016> <-3.483, 1.327, 0.855> <-3.483, 1.339, 0.734> 
		<-3.521, 1.298, 1.127> <-3.521, 1.310, 1.006> <-3.521, 1.325, 0.866> <-3.521, 1.338, 0.745> 
		<-3.563, 1.297, 1.093> <-3.563, 1.306, 1.010> <-3.563, 1.322, 0.861> <-3.563, 1.331, 0.779> 
		<-3.598, 1.296, 1.074> <-3.598, 1.306, 0.991> <-3.598, 1.318, 0.880> <-3.598, 1.328, 0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.598, 1.333, 0.718> <-3.598, 1.327, 0.761> <-3.598, 1.319, 0.818> <-3.598, 1.314, 0.862> 
		<-3.598, 1.331, 0.742> <-3.598, 1.326, 0.785> <-3.598, 1.314, 0.882> <-3.598, 1.308, 0.925> 
		<-3.598, 1.329, 0.774> <-3.598, 1.320, 0.856> <-3.598, 1.311, 0.927> <-3.598, 1.302, 1.010> 
		<-3.598, 1.328, 0.798> <-3.598, 1.318, 0.880> <-3.598, 1.306, 0.991> <-3.598, 1.296, 1.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.598, 1.314, 0.862> <-3.598, 1.314, 0.862> <-3.598, 1.314, 0.862> <-3.598, 1.314, 0.862> 
		<-3.598, 1.308, 0.925> <-3.598, 1.298, 1.017> <-3.598, 1.298, 1.017> <-3.598, 1.303, 0.954> 
		<-3.598, 1.302, 1.010> <-3.598, 1.296, 1.039> <-3.598, 1.294, 1.048> <-3.598, 1.288, 1.077> 
		<-3.598, 1.296, 1.074> <-3.598, 1.291, 1.102> <-3.598, 1.283, 1.140> <-3.598, 1.277, 1.169> 
	}
	texture {text2Rojo}
	texture {textSucio translate z*40}
}  


#declare Aler_I = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.313, 0.915> <3.154, 1.313, 0.915> <3.235, 1.313, 0.915> <3.295, 1.313, 0.915> 
		<3.093, 1.315, 0.905> <3.154, 1.315, 0.905> <3.234, 1.314, 0.925> <3.295, 1.314, 0.925> 
		<3.093, 1.317, 0.938> <3.153, 1.317, 0.938> <3.234, 1.317, 0.938> <3.294, 1.317, 0.938> 
		<3.093, 1.316, 0.948> <3.153, 1.316, 0.948> <3.234, 1.316, 0.948> <3.294, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.313, 0.915> <3.093, 1.315, 0.905> <3.093, 1.317, 0.938> <3.093, 1.316, 0.948> 
		<3.032, 1.313, 0.915> <3.032, 1.315, 0.905> <3.032, 1.317, 0.938> <3.032, 1.316, 0.948> 
		<2.950, 1.313, 0.915> <2.950, 1.315, 0.905> <2.950, 1.318, 0.938> <2.950, 1.316, 0.948> 
		<2.889, 1.313, 0.915> <2.889, 1.315, 0.905> <2.889, 1.318, 0.938> <2.889, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.313, 0.915> <3.032, 1.313, 0.915> <2.950, 1.313, 0.915> <2.889, 1.313, 0.915> 
		<3.093, 1.304, 0.955> <3.032, 1.304, 0.955> <2.950, 1.304, 0.955> <2.889, 1.304, 0.955> 
		<3.093, 1.299, 1.010> <3.032, 1.299, 1.010> <2.950, 1.299, 1.010> <2.889, 1.299, 1.010> 
		<3.093, 1.294, 1.050> <3.032, 1.294, 1.050> <2.950, 1.294, 1.050> <2.889, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.313, 0.915> <3.093, 1.304, 0.955> <3.093, 1.299, 1.010> <3.093, 1.294, 1.050> 
		<3.154, 1.313, 0.915> <3.154, 1.304, 0.955> <3.154, 1.299, 1.010> <3.154, 1.294, 1.050> 
		<3.235, 1.313, 0.915> <3.235, 1.307, 0.956> <3.234, 1.299, 1.010> <3.235, 1.294, 1.050> 
		<3.295, 1.313, 0.915> <3.295, 1.307, 0.956> <3.295, 1.299, 1.010> <3.295, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.294, 1.050> <3.093, 1.285, 1.118> <3.093, 1.274, 1.209> <3.093, 1.265, 1.278> 
		<3.154, 1.294, 1.050> <3.154, 1.285, 1.118> <3.155, 1.274, 1.209> <3.155, 1.265, 1.278> 
		<3.235, 1.294, 1.050> <3.235, 1.286, 1.117> <3.236, 1.274, 1.207> <3.237, 1.266, 1.274> 
		<3.295, 1.294, 1.050> <3.296, 1.286, 1.117> <3.298, 1.275, 1.206> <3.299, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.294, 1.050> <3.032, 1.294, 1.050> <2.950, 1.294, 1.050> <2.889, 1.294, 1.050> 
		<3.093, 1.285, 1.118> <3.032, 1.285, 1.118> <2.950, 1.286, 1.117> <2.889, 1.286, 1.117> 
		<3.093, 1.274, 1.209> <3.032, 1.274, 1.209> <2.950, 1.275, 1.206> <2.889, 1.275, 1.206> 
		<3.093, 1.265, 1.278> <3.032, 1.265, 1.278> <2.950, 1.267, 1.273> <2.889, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.265, 1.278> <3.093, 1.275, 1.238> <3.093, 1.290, 1.186> <3.093, 1.297, 1.146> 
		<3.155, 1.265, 1.278> <3.155, 1.275, 1.238> <3.155, 1.292, 1.187> <3.155, 1.298, 1.147> 
		<3.237, 1.266, 1.274> <3.237, 1.275, 1.236> <3.237, 1.288, 1.184> <3.237, 1.297, 1.146> 
		<3.299, 1.267, 1.273> <3.299, 1.276, 1.235> <3.299, 1.288, 1.184> <3.299, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.265, 1.278> <3.032, 1.265, 1.278> <2.950, 1.267, 1.273> <2.889, 1.267, 1.273> 
		<3.093, 1.275, 1.238> <3.032, 1.275, 1.238> <2.950, 1.273, 1.235> <2.889, 1.273, 1.235> 
		<3.093, 1.290, 1.186> <3.032, 1.289, 1.186> <2.950, 1.282, 1.184> <2.889, 1.282, 1.184> 
		<3.093, 1.297, 1.146> <3.032, 1.295, 1.146> <2.950, 1.287, 1.145> <2.889, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.297, 1.146> <3.093, 1.306, 1.087> <3.093, 1.312, 1.008> <3.093, 1.316, 0.948> 
		<3.155, 1.298, 1.147> <3.155, 1.307, 1.087> <3.153, 1.312, 1.008> <3.153, 1.316, 0.948> 
		<3.237, 1.297, 1.146> <3.236, 1.303, 1.087> <3.235, 1.312, 1.008> <3.234, 1.316, 0.948> 
		<3.299, 1.297, 1.146> <3.298, 1.303, 1.087> <3.295, 1.312, 1.008> <3.294, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.093, 1.297, 1.146> <3.032, 1.295, 1.146> <2.950, 1.287, 1.145> <2.889, 1.287, 1.145> 
		<3.093, 1.306, 1.087> <3.032, 1.305, 1.087> <2.950, 1.297, 1.086> <2.889, 1.297, 1.086> 
		<3.093, 1.312, 1.008> <3.032, 1.312, 1.008> <2.950, 1.310, 1.008> <2.889, 1.310, 1.008> 
		<3.093, 1.316, 0.948> <3.032, 1.316, 0.948> <2.950, 1.316, 0.948> <2.889, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.889, 1.313, 0.915> <2.889, 1.315, 0.905> <2.889, 1.318, 0.938> <2.889, 1.316, 0.948> 
		<2.829, 1.313, 0.915> <2.829, 1.315, 0.905> <2.829, 1.318, 0.938> <2.829, 1.316, 0.948> 
		<2.749, 1.313, 0.915> <2.749, 1.315, 0.905> <2.749, 1.317, 0.938> <2.749, 1.316, 0.948> 
		<2.689, 1.313, 0.915> <2.689, 1.315, 0.905> <2.689, 1.317, 0.938> <2.689, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.889, 1.313, 0.915> <2.829, 1.313, 0.915> <2.749, 1.313, 0.915> <2.689, 1.313, 0.915> 
		<2.889, 1.304, 0.955> <2.829, 1.304, 0.955> <2.749, 1.304, 0.955> <2.689, 1.304, 0.955> 
		<2.889, 1.299, 1.010> <2.829, 1.299, 1.010> <2.749, 1.299, 1.010> <2.689, 1.299, 1.010> 
		<2.889, 1.294, 1.050> <2.829, 1.294, 1.050> <2.749, 1.294, 1.050> <2.689, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.889, 1.294, 1.050> <2.829, 1.294, 1.050> <2.749, 1.294, 1.050> <2.689, 1.294, 1.050> 
		<2.889, 1.286, 1.117> <2.829, 1.286, 1.117> <2.749, 1.285, 1.118> <2.689, 1.285, 1.118> 
		<2.889, 1.275, 1.206> <2.829, 1.275, 1.206> <2.749, 1.274, 1.209> <2.689, 1.274, 1.209> 
		<2.889, 1.267, 1.273> <2.829, 1.267, 1.273> <2.749, 1.265, 1.278> <2.689, 1.265, 1.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.889, 1.267, 1.273> <2.829, 1.267, 1.273> <2.749, 1.265, 1.278> <2.689, 1.265, 1.278> 
		<2.889, 1.273, 1.235> <2.829, 1.273, 1.235> <2.749, 1.275, 1.238> <2.689, 1.275, 1.238> 
		<2.889, 1.282, 1.184> <2.829, 1.282, 1.184> <2.749, 1.290, 1.186> <2.689, 1.290, 1.186> 
		<2.889, 1.287, 1.145> <2.829, 1.287, 1.145> <2.749, 1.297, 1.146> <2.689, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.889, 1.287, 1.145> <2.829, 1.287, 1.145> <2.749, 1.297, 1.146> <2.689, 1.297, 1.146> 
		<2.889, 1.297, 1.086> <2.829, 1.297, 1.086> <2.749, 1.306, 1.087> <2.689, 1.306, 1.087> 
		<2.889, 1.310, 1.008> <2.829, 1.310, 1.008> <2.749, 1.312, 1.008> <2.689, 1.312, 1.008> 
		<2.889, 1.316, 0.948> <2.829, 1.316, 0.948> <2.749, 1.316, 0.948> <2.689, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.689, 1.313, 0.915> <2.689, 1.315, 0.905> <2.689, 1.317, 0.938> <2.689, 1.316, 0.948> 
		<2.629, 1.313, 0.915> <2.629, 1.315, 0.905> <2.629, 1.317, 0.938> <2.629, 1.316, 0.948> 
		<2.549, 1.313, 0.915> <2.549, 1.315, 0.905> <2.549, 1.318, 0.938> <2.549, 1.316, 0.948> 
		<2.489, 1.313, 0.915> <2.489, 1.315, 0.905> <2.489, 1.318, 0.938> <2.489, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.689, 1.313, 0.915> <2.629, 1.313, 0.915> <2.549, 1.313, 0.915> <2.489, 1.313, 0.915> 
		<2.689, 1.304, 0.955> <2.629, 1.304, 0.955> <2.549, 1.304, 0.955> <2.489, 1.304, 0.955> 
		<2.689, 1.299, 1.010> <2.629, 1.299, 1.010> <2.549, 1.299, 1.010> <2.489, 1.299, 1.010> 
		<2.689, 1.294, 1.050> <2.629, 1.294, 1.050> <2.549, 1.294, 1.050> <2.489, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.689, 1.294, 1.050> <2.629, 1.294, 1.050> <2.549, 1.294, 1.050> <2.489, 1.294, 1.050> 
		<2.689, 1.285, 1.118> <2.629, 1.285, 1.118> <2.549, 1.286, 1.117> <2.489, 1.286, 1.117> 
		<2.689, 1.274, 1.209> <2.629, 1.274, 1.209> <2.549, 1.275, 1.206> <2.489, 1.275, 1.206> 
		<2.689, 1.265, 1.278> <2.629, 1.265, 1.278> <2.549, 1.267, 1.273> <2.489, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.689, 1.265, 1.278> <2.629, 1.265, 1.278> <2.549, 1.267, 1.273> <2.489, 1.267, 1.273> 
		<2.689, 1.275, 1.238> <2.629, 1.275, 1.238> <2.549, 1.273, 1.235> <2.489, 1.273, 1.235> 
		<2.689, 1.290, 1.186> <2.629, 1.290, 1.186> <2.549, 1.282, 1.184> <2.489, 1.282, 1.184> 
		<2.689, 1.297, 1.146> <2.629, 1.297, 1.146> <2.549, 1.287, 1.145> <2.489, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.689, 1.297, 1.146> <2.629, 1.297, 1.146> <2.549, 1.287, 1.145> <2.489, 1.287, 1.145> 
		<2.689, 1.306, 1.087> <2.629, 1.306, 1.087> <2.549, 1.297, 1.086> <2.489, 1.297, 1.086> 
		<2.689, 1.312, 1.008> <2.629, 1.312, 1.008> <2.549, 1.310, 1.008> <2.489, 1.310, 1.008> 
		<2.689, 1.316, 0.948> <2.629, 1.316, 0.948> <2.549, 1.316, 0.948> <2.489, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.489, 1.313, 0.915> <2.489, 1.315, 0.905> <2.489, 1.318, 0.938> <2.489, 1.316, 0.948> 
		<2.429, 1.313, 0.915> <2.429, 1.315, 0.905> <2.429, 1.318, 0.938> <2.429, 1.316, 0.948> 
		<2.349, 1.313, 0.915> <2.349, 1.315, 0.905> <2.349, 1.317, 0.938> <2.349, 1.316, 0.948> 
		<2.289, 1.313, 0.915> <2.289, 1.315, 0.905> <2.289, 1.317, 0.938> <2.289, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.489, 1.313, 0.915> <2.429, 1.313, 0.915> <2.349, 1.313, 0.915> <2.289, 1.313, 0.915> 
		<2.489, 1.304, 0.955> <2.429, 1.304, 0.955> <2.349, 1.304, 0.955> <2.289, 1.304, 0.955> 
		<2.489, 1.299, 1.010> <2.429, 1.299, 1.010> <2.349, 1.299, 1.010> <2.289, 1.299, 1.010> 
		<2.489, 1.294, 1.050> <2.429, 1.294, 1.050> <2.349, 1.294, 1.050> <2.289, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.489, 1.294, 1.050> <2.429, 1.294, 1.050> <2.349, 1.294, 1.050> <2.289, 1.294, 1.050> 
		<2.489, 1.286, 1.117> <2.429, 1.286, 1.117> <2.349, 1.285, 1.118> <2.289, 1.285, 1.118> 
		<2.489, 1.275, 1.206> <2.429, 1.275, 1.206> <2.349, 1.274, 1.209> <2.289, 1.274, 1.209> 
		<2.489, 1.267, 1.273> <2.429, 1.267, 1.273> <2.349, 1.265, 1.278> <2.289, 1.265, 1.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.489, 1.267, 1.273> <2.429, 1.267, 1.273> <2.349, 1.265, 1.278> <2.289, 1.265, 1.278> 
		<2.489, 1.273, 1.235> <2.429, 1.273, 1.235> <2.349, 1.275, 1.238> <2.289, 1.275, 1.238> 
		<2.489, 1.282, 1.184> <2.429, 1.282, 1.184> <2.349, 1.290, 1.186> <2.289, 1.290, 1.186> 
		<2.489, 1.287, 1.145> <2.429, 1.287, 1.145> <2.349, 1.297, 1.146> <2.289, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.489, 1.287, 1.145> <2.429, 1.287, 1.145> <2.349, 1.297, 1.146> <2.289, 1.297, 1.146> 
		<2.489, 1.297, 1.086> <2.429, 1.297, 1.086> <2.349, 1.306, 1.087> <2.289, 1.306, 1.087> 
		<2.489, 1.310, 1.008> <2.429, 1.310, 1.008> <2.349, 1.312, 1.008> <2.289, 1.312, 1.008> 
		<2.489, 1.316, 0.948> <2.429, 1.316, 0.948> <2.349, 1.316, 0.948> <2.289, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.289, 1.313, 0.915> <2.289, 1.315, 0.905> <2.289, 1.317, 0.938> <2.289, 1.316, 0.948> 
		<2.229, 1.313, 0.915> <2.229, 1.315, 0.905> <2.229, 1.317, 0.938> <2.229, 1.316, 0.948> 
		<2.149, 1.313, 0.915> <2.149, 1.315, 0.905> <2.149, 1.318, 0.938> <2.149, 1.316, 0.948> 
		<2.089, 1.313, 0.915> <2.089, 1.315, 0.905> <2.089, 1.318, 0.938> <2.089, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.289, 1.313, 0.915> <2.229, 1.313, 0.915> <2.149, 1.313, 0.915> <2.089, 1.313, 0.915> 
		<2.289, 1.304, 0.955> <2.229, 1.304, 0.955> <2.149, 1.304, 0.955> <2.089, 1.304, 0.955> 
		<2.289, 1.299, 1.010> <2.229, 1.299, 1.010> <2.149, 1.299, 1.010> <2.089, 1.299, 1.010> 
		<2.289, 1.294, 1.050> <2.229, 1.294, 1.050> <2.149, 1.294, 1.050> <2.089, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.289, 1.294, 1.050> <2.229, 1.294, 1.050> <2.149, 1.294, 1.050> <2.089, 1.294, 1.050> 
		<2.289, 1.285, 1.118> <2.229, 1.285, 1.118> <2.149, 1.286, 1.117> <2.089, 1.286, 1.117> 
		<2.289, 1.274, 1.209> <2.229, 1.274, 1.209> <2.149, 1.275, 1.206> <2.089, 1.275, 1.206> 
		<2.289, 1.265, 1.278> <2.229, 1.265, 1.278> <2.149, 1.267, 1.273> <2.089, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.289, 1.265, 1.278> <2.229, 1.265, 1.278> <2.149, 1.267, 1.273> <2.089, 1.267, 1.273> 
		<2.289, 1.275, 1.238> <2.229, 1.275, 1.238> <2.149, 1.273, 1.235> <2.089, 1.273, 1.235> 
		<2.289, 1.290, 1.186> <2.229, 1.290, 1.186> <2.149, 1.282, 1.184> <2.089, 1.282, 1.184> 
		<2.289, 1.297, 1.146> <2.229, 1.297, 1.146> <2.149, 1.287, 1.145> <2.089, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.289, 1.297, 1.146> <2.229, 1.297, 1.146> <2.149, 1.287, 1.145> <2.089, 1.287, 1.145> 
		<2.289, 1.306, 1.087> <2.229, 1.306, 1.087> <2.149, 1.297, 1.086> <2.089, 1.297, 1.086> 
		<2.289, 1.312, 1.008> <2.229, 1.312, 1.008> <2.149, 1.310, 1.008> <2.089, 1.310, 1.008> 
		<2.289, 1.316, 0.948> <2.229, 1.316, 0.948> <2.149, 1.316, 0.948> <2.089, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.089, 1.313, 0.915> <2.089, 1.315, 0.905> <2.089, 1.318, 0.938> <2.089, 1.316, 0.948> 
		<2.029, 1.313, 0.915> <2.029, 1.315, 0.905> <2.029, 1.318, 0.938> <2.029, 1.316, 0.948> 
		<1.949, 1.313, 0.915> <1.949, 1.315, 0.905> <1.949, 1.317, 0.938> <1.949, 1.316, 0.948> 
		<1.889, 1.313, 0.915> <1.889, 1.315, 0.905> <1.889, 1.317, 0.938> <1.889, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.089, 1.313, 0.915> <2.029, 1.313, 0.915> <1.949, 1.313, 0.915> <1.889, 1.313, 0.915> 
		<2.089, 1.304, 0.955> <2.029, 1.304, 0.955> <1.949, 1.304, 0.955> <1.889, 1.304, 0.955> 
		<2.089, 1.299, 1.010> <2.029, 1.299, 1.010> <1.949, 1.299, 1.010> <1.889, 1.299, 1.010> 
		<2.089, 1.294, 1.050> <2.029, 1.294, 1.050> <1.949, 1.294, 1.050> <1.889, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.089, 1.294, 1.050> <2.029, 1.294, 1.050> <1.949, 1.294, 1.050> <1.889, 1.294, 1.050> 
		<2.089, 1.286, 1.117> <2.029, 1.286, 1.117> <1.949, 1.285, 1.118> <1.889, 1.285, 1.118> 
		<2.089, 1.275, 1.206> <2.029, 1.275, 1.206> <1.949, 1.274, 1.209> <1.889, 1.274, 1.209> 
		<2.089, 1.267, 1.273> <2.029, 1.267, 1.273> <1.949, 1.265, 1.278> <1.889, 1.265, 1.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.089, 1.267, 1.273> <2.029, 1.267, 1.273> <1.949, 1.265, 1.278> <1.889, 1.265, 1.278> 
		<2.089, 1.273, 1.235> <2.029, 1.273, 1.235> <1.949, 1.275, 1.238> <1.889, 1.275, 1.238> 
		<2.089, 1.282, 1.184> <2.029, 1.282, 1.184> <1.949, 1.290, 1.186> <1.889, 1.290, 1.186> 
		<2.089, 1.287, 1.145> <2.029, 1.287, 1.145> <1.949, 1.297, 1.146> <1.889, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.089, 1.287, 1.145> <2.029, 1.287, 1.145> <1.949, 1.297, 1.146> <1.889, 1.297, 1.146> 
		<2.089, 1.297, 1.086> <2.029, 1.297, 1.086> <1.949, 1.306, 1.087> <1.889, 1.306, 1.087> 
		<2.089, 1.310, 1.008> <2.029, 1.310, 1.008> <1.949, 1.312, 1.008> <1.889, 1.312, 1.008> 
		<2.089, 1.316, 0.948> <2.029, 1.316, 0.948> <1.949, 1.316, 0.948> <1.889, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.889, 1.313, 0.915> <1.889, 1.315, 0.905> <1.889, 1.317, 0.938> <1.889, 1.316, 0.948> 
		<1.829, 1.313, 0.915> <1.829, 1.315, 0.905> <1.829, 1.317, 0.938> <1.829, 1.316, 0.948> 
		<1.749, 1.313, 0.915> <1.749, 1.315, 0.905> <1.749, 1.318, 0.938> <1.749, 1.316, 0.948> 
		<1.689, 1.313, 0.915> <1.689, 1.315, 0.905> <1.689, 1.318, 0.938> <1.689, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.889, 1.313, 0.915> <1.829, 1.313, 0.915> <1.749, 1.313, 0.915> <1.689, 1.313, 0.915> 
		<1.889, 1.304, 0.955> <1.829, 1.304, 0.955> <1.749, 1.304, 0.955> <1.689, 1.304, 0.955> 
		<1.889, 1.299, 1.010> <1.829, 1.299, 1.010> <1.749, 1.299, 1.010> <1.689, 1.299, 1.010> 
		<1.889, 1.294, 1.050> <1.829, 1.294, 1.050> <1.749, 1.294, 1.050> <1.689, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.889, 1.294, 1.050> <1.829, 1.294, 1.050> <1.749, 1.294, 1.050> <1.689, 1.294, 1.050> 
		<1.889, 1.285, 1.118> <1.829, 1.285, 1.118> <1.749, 1.286, 1.117> <1.689, 1.286, 1.117> 
		<1.889, 1.274, 1.209> <1.829, 1.274, 1.209> <1.749, 1.275, 1.208> <1.689, 1.275, 1.206> 
		<1.889, 1.265, 1.278> <1.829, 1.265, 1.278> <1.749, 1.266, 1.275> <1.689, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.889, 1.265, 1.278> <1.829, 1.265, 1.278> <1.749, 1.266, 1.275> <1.689, 1.267, 1.273> 
		<1.889, 1.275, 1.238> <1.829, 1.275, 1.238> <1.749, 1.273, 1.237> <1.689, 1.273, 1.235> 
		<1.889, 1.290, 1.186> <1.829, 1.290, 1.186> <1.749, 1.282, 1.184> <1.689, 1.282, 1.184> 
		<1.889, 1.297, 1.146> <1.829, 1.297, 1.146> <1.749, 1.287, 1.145> <1.689, 1.287, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.889, 1.297, 1.146> <1.829, 1.297, 1.146> <1.749, 1.287, 1.145> <1.689, 1.287, 1.145> 
		<1.889, 1.306, 1.087> <1.829, 1.306, 1.087> <1.749, 1.297, 1.086> <1.689, 1.297, 1.086> 
		<1.889, 1.312, 1.008> <1.829, 1.312, 1.008> <1.749, 1.310, 1.008> <1.689, 1.310, 1.008> 
		<1.889, 1.316, 0.948> <1.829, 1.316, 0.948> <1.749, 1.316, 0.948> <1.689, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.689, 1.313, 0.915> <1.689, 1.315, 0.905> <1.689, 1.318, 0.938> <1.689, 1.316, 0.948> 
		<1.629, 1.313, 0.915> <1.629, 1.315, 0.905> <1.629, 1.318, 0.938> <1.629, 1.316, 0.948> 
		<1.549, 1.313, 0.914> <1.549, 1.315, 0.905> <1.549, 1.317, 0.938> <1.549, 1.316, 0.948> 
		<1.489, 1.313, 0.915> <1.489, 1.315, 0.905> <1.489, 1.317, 0.938> <1.489, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.689, 1.313, 0.915> <1.629, 1.313, 0.915> <1.549, 1.313, 0.914> <1.489, 1.313, 0.915> 
		<1.689, 1.304, 0.955> <1.629, 1.304, 0.955> <1.549, 1.304, 0.954> <1.489, 1.304, 0.955> 
		<1.689, 1.299, 1.010> <1.629, 1.299, 1.010> <1.549, 1.299, 1.010> <1.489, 1.300, 1.010> 
		<1.689, 1.294, 1.050> <1.629, 1.294, 1.050> <1.549, 1.294, 1.051> <1.489, 1.294, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.689, 1.294, 1.050> <1.629, 1.294, 1.050> <1.549, 1.294, 1.051> <1.489, 1.294, 1.050> 
		<1.689, 1.286, 1.117> <1.629, 1.286, 1.117> <1.549, 1.286, 1.114> <1.489, 1.286, 1.114> 
		<1.689, 1.275, 1.206> <1.629, 1.275, 1.204> <1.548, 1.274, 1.210> <1.489, 1.275, 1.198> 
		<1.689, 1.267, 1.273> <1.629, 1.267, 1.270> <1.548, 1.266, 1.273> <1.489, 1.267, 1.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.689, 1.267, 1.273> <1.629, 1.267, 1.270> <1.548, 1.266, 1.273> <1.489, 1.267, 1.262> 
		<1.689, 1.273, 1.235> <1.629, 1.273, 1.232> <1.548, 1.275, 1.239> <1.489, 1.276, 1.227> 
		<1.689, 1.282, 1.184> <1.629, 1.282, 1.184> <1.549, 1.291, 1.185> <1.489, 1.291, 1.182> 
		<1.689, 1.287, 1.145> <1.629, 1.287, 1.145> <1.549, 1.296, 1.150> <1.489, 1.297, 1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.689, 1.287, 1.145> <1.629, 1.287, 1.145> <1.549, 1.296, 1.150> <1.489, 1.297, 1.146> 
		<1.689, 1.297, 1.086> <1.629, 1.297, 1.086> <1.549, 1.306, 1.091> <1.489, 1.306, 1.087> 
		<1.689, 1.310, 1.008> <1.629, 1.310, 1.008> <1.549, 1.312, 1.008> <1.489, 1.312, 1.008> 
		<1.689, 1.316, 0.948> <1.629, 1.316, 0.948> <1.549, 1.316, 0.948> <1.489, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.489, 1.313, 0.915> <1.489, 1.315, 0.905> <1.489, 1.317, 0.938> <1.489, 1.316, 0.948> 
		<1.429, 1.313, 0.916> <1.429, 1.315, 0.906> <1.429, 1.317, 0.938> <1.429, 1.316, 0.948> 
		<1.348, 1.313, 0.913> <1.348, 1.315, 0.905> <1.349, 1.319, 0.933> <1.349, 1.318, 0.941> 
		<1.289, 1.312, 0.921> <1.289, 1.314, 0.913> <1.289, 1.317, 0.940> <1.289, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.489, 1.313, 0.915> <1.429, 1.313, 0.916> <1.348, 1.313, 0.913> <1.289, 1.312, 0.921> 
		<1.489, 1.304, 0.955> <1.429, 1.304, 0.956> <1.348, 1.305, 0.949> <1.289, 1.304, 0.958> 
		<1.489, 1.300, 1.010> <1.429, 1.300, 1.009> <1.349, 1.299, 1.013> <1.289, 1.300, 1.008> 
		<1.489, 1.294, 1.050> <1.429, 1.294, 1.049> <1.349, 1.294, 1.050> <1.289, 1.295, 1.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.489, 1.294, 1.050> <1.429, 1.294, 1.049> <1.349, 1.294, 1.050> <1.289, 1.295, 1.045> 
		<1.489, 1.286, 1.114> <1.429, 1.286, 1.113> <1.349, 1.288, 1.095> <1.289, 1.289, 1.090> 
		<1.489, 1.275, 1.198> <1.427, 1.276, 1.186> <1.349, 1.278, 1.170> <1.289, 1.281, 1.150> 
		<1.489, 1.267, 1.262> <1.427, 1.268, 1.250> <1.349, 1.272, 1.215> <1.289, 1.275, 1.194> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.489, 1.267, 1.262> <1.427, 1.268, 1.250> <1.349, 1.272, 1.215> <1.289, 1.275, 1.194> 
		<1.489, 1.276, 1.227> <1.427, 1.277, 1.215> <1.349, 1.277, 1.193> <1.289, 1.279, 1.173> 
		<1.489, 1.291, 1.182> <1.429, 1.291, 1.178> <1.348, 1.286, 1.160> <1.289, 1.286, 1.145> 
		<1.489, 1.297, 1.146> <1.429, 1.297, 1.143> <1.348, 1.289, 1.139> <1.289, 1.290, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.489, 1.297, 1.146> <1.429, 1.297, 1.143> <1.348, 1.289, 1.139> <1.289, 1.290, 1.123> 
		<1.489, 1.306, 1.087> <1.429, 1.306, 1.084> <1.348, 1.298, 1.086> <1.289, 1.299, 1.071> 
		<1.489, 1.312, 1.008> <1.429, 1.312, 1.008> <1.349, 1.312, 0.994> <1.289, 1.311, 1.001> 
		<1.489, 1.316, 0.948> <1.429, 1.316, 0.948> <1.349, 1.318, 0.941> <1.289, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 1.307, 0.973> <1.094, 1.301, 0.985> <1.094, 1.300, 1.002> <1.094, 1.298, 1.014> 
		<1.094, 1.309, 0.967> <1.094, 1.304, 0.979> <1.094, 1.301, 1.010> <1.094, 1.298, 1.023> 
		<1.094, 1.308, 0.988> <1.094, 1.306, 1.002> <1.087, 1.303, 1.024> <1.087, 1.300, 1.038> 
		<1.094, 1.307, 0.994> <1.094, 1.306, 1.008> <1.094, 1.303, 1.028> <1.094, 1.299, 1.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 1.307, 0.973> <1.094, 1.309, 0.967> <1.094, 1.308, 0.988> <1.094, 1.307, 0.994> 
		<1.152, 1.308, 0.958> <1.152, 1.311, 0.952> <1.152, 1.311, 0.974> <1.152, 1.310, 0.980> 
		<1.229, 1.311, 0.930> <1.229, 1.313, 0.922> <1.229, 1.316, 0.947> <1.229, 1.315, 0.955> 
		<1.289, 1.312, 0.921> <1.289, 1.314, 0.913> <1.289, 1.317, 0.940> <1.289, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 1.307, 0.973> <1.094, 1.301, 0.985> <1.094, 1.300, 1.002> <1.094, 1.298, 1.014> 
		<1.152, 1.308, 0.958> <1.152, 1.303, 0.969> <1.152, 1.299, 1.011> <1.152, 1.297, 1.024> 
		<1.229, 1.311, 0.930> <1.229, 1.303, 0.967> <1.230, 1.300, 1.003> <1.230, 1.295, 1.040> 
		<1.289, 1.312, 0.921> <1.289, 1.304, 0.958> <1.289, 1.300, 1.008> <1.289, 1.295, 1.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 1.287, 1.073> <1.094, 1.287, 1.073> <1.094, 1.287, 1.073> <1.094, 1.287, 1.073> 
		<1.094, 1.290, 1.056> <1.094, 1.294, 1.046> <1.094, 1.294, 1.046> <1.094, 1.291, 1.064> 
		<1.094, 1.294, 1.032> <1.094, 1.295, 1.040> <1.087, 1.297, 1.048> <1.094, 1.297, 1.052> 
		<1.094, 1.298, 1.014> <1.094, 1.298, 1.023> <1.087, 1.300, 1.038> <1.094, 1.299, 1.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 1.287, 1.073> <1.094, 1.290, 1.056> <1.094, 1.294, 1.032> <1.094, 1.298, 1.014> 
		<1.152, 1.283, 1.110> <1.152, 1.287, 1.092> <1.152, 1.293, 1.041> <1.152, 1.297, 1.024> 
		<1.231, 1.278, 1.158> <1.231, 1.284, 1.113> <1.230, 1.289, 1.084> <1.230, 1.295, 1.040> 
		<1.289, 1.275, 1.194> <1.289, 1.281, 1.150> <1.289, 1.289, 1.090> <1.289, 1.295, 1.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 1.287, 1.073> <1.094, 1.291, 1.064> <1.094, 1.297, 1.052> <1.094, 1.299, 1.042> 
		<1.152, 1.283, 1.110> <1.152, 1.287, 1.100> <1.149, 1.295, 1.082> <1.149, 1.297, 1.073> 
		<1.231, 1.278, 1.158> <1.231, 1.283, 1.137> <1.228, 1.287, 1.128> <1.228, 1.290, 1.107> 
		<1.289, 1.275, 1.194> <1.289, 1.279, 1.173> <1.289, 1.286, 1.145> <1.289, 1.290, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 1.307, 0.994> <1.094, 1.306, 1.008> <1.094, 1.303, 1.028> <1.094, 1.299, 1.042> 
		<1.152, 1.310, 0.980> <1.152, 1.308, 0.995> <1.149, 1.301, 1.059> <1.149, 1.297, 1.073> 
		<1.229, 1.315, 0.955> <1.229, 1.309, 1.008> <1.228, 1.299, 1.055> <1.228, 1.290, 1.107> 
		<1.289, 1.316, 0.948> <1.289, 1.311, 1.001> <1.289, 1.299, 1.071> <1.289, 1.290, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.295, 1.313, 0.915> <3.296, 1.320, 0.841> <3.298, 1.330, 0.743> <3.299, 1.338, 0.670> 
		<3.295, 1.314, 0.925> <3.296, 1.321, 0.851> <3.298, 1.331, 0.757> <3.299, 1.339, 0.684> 
		<3.294, 1.317, 0.938> <3.296, 1.325, 0.868> <3.298, 1.333, 0.772> <3.299, 1.340, 0.702> 
		<3.294, 1.316, 0.948> <3.296, 1.324, 0.878> <3.298, 1.334, 0.786> <3.299, 1.341, 0.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.295, 1.313, 0.915> <3.295, 1.307, 0.956> <3.295, 1.299, 1.010> <3.295, 1.294, 1.050> 
		<3.296, 1.320, 0.841> <3.296, 1.315, 0.882> <3.296, 1.307, 0.936> <3.296, 1.302, 0.977> 
		<3.298, 1.330, 0.743> <3.298, 1.325, 0.784> <3.298, 1.317, 0.838> <3.298, 1.312, 0.878> 
		<3.299, 1.338, 0.670> <3.299, 1.332, 0.710> <3.299, 1.325, 0.764> <3.299, 1.319, 0.805> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.295, 1.294, 1.050> <3.295, 1.294, 1.050> <3.295, 1.294, 1.050> <3.295, 1.294, 1.050> 
		<3.296, 1.302, 0.977> <3.297, 1.293, 1.043> <3.297, 1.293, 1.043> <3.296, 1.286, 1.117> 
		<3.298, 1.312, 0.878> <3.298, 1.296, 1.019> <3.298, 1.291, 1.066> <3.298, 1.275, 1.206> 
		<3.299, 1.319, 0.805> <3.299, 1.304, 0.945> <3.299, 1.282, 1.132> <3.299, 1.267, 1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.299, 1.267, 1.273> <3.349, 1.267, 1.271> <3.419, 1.266, 1.283> <3.465, 1.267, 1.265> 
		<3.299, 1.282, 1.132> <3.349, 1.283, 1.130> <3.419, 1.281, 1.150> <3.465, 1.282, 1.132> 
		<3.299, 1.304, 0.945> <3.349, 1.303, 0.951> <3.416, 1.304, 0.946> <3.465, 1.303, 0.955> 
		<3.299, 1.319, 0.805> <3.349, 1.319, 0.810> <3.416, 1.319, 0.813> <3.465, 1.318, 0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.299, 1.267, 1.273> <3.299, 1.276, 1.235> <3.299, 1.288, 1.184> <3.299, 1.297, 1.146> 
		<3.349, 1.267, 1.271> <3.349, 1.276, 1.233> <3.349, 1.288, 1.181> <3.349, 1.297, 1.144> 
		<3.419, 1.266, 1.283> <3.419, 1.275, 1.244> <3.417, 1.289, 1.188> <3.417, 1.298, 1.149> 
		<3.465, 1.267, 1.265> <3.465, 1.276, 1.227> <3.465, 1.289, 1.175> <3.465, 1.298, 1.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.299, 1.297, 1.146> <3.299, 1.297, 1.146> <3.299, 1.297, 1.146> <3.299, 1.297, 1.146> 
		<3.299, 1.310, 1.017> <3.298, 1.316, 0.958> <3.298, 1.316, 0.958> <3.298, 1.303, 1.087> 
		<3.299, 1.328, 0.845> <3.298, 1.320, 0.915> <3.297, 1.320, 0.938> <3.295, 1.312, 1.008> 
		<3.299, 1.341, 0.716> <3.298, 1.334, 0.786> <3.296, 1.324, 0.878> <3.294, 1.316, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.299, 1.297, 1.146> <3.299, 1.310, 1.017> <3.299, 1.328, 0.845> <3.299, 1.341, 0.716> 
		<3.349, 1.297, 1.144> <3.349, 1.310, 1.014> <3.349, 1.327, 0.851> <3.349, 1.341, 0.721> 
		<3.417, 1.298, 1.149> <3.417, 1.310, 1.029> <3.417, 1.329, 0.841> <3.417, 1.342, 0.720> 
		<3.465, 1.298, 1.137> <3.465, 1.310, 1.016> <3.465, 1.327, 0.855> <3.465, 1.339, 0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.299, 1.338, 0.670> <3.349, 1.338, 0.670> <3.416, 1.339, 0.661> <3.465, 1.338, 0.670> 
		<3.299, 1.339, 0.684> <3.349, 1.339, 0.684> <3.416, 1.339, 0.681> <3.465, 1.338, 0.689> 
		<3.299, 1.340, 0.702> <3.349, 1.340, 0.708> <3.417, 1.341, 0.701> <3.465, 1.339, 0.715> 
		<3.299, 1.341, 0.716> <3.349, 1.341, 0.721> <3.417, 1.342, 0.720> <3.465, 1.339, 0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.299, 1.338, 0.670> <3.299, 1.332, 0.710> <3.299, 1.325, 0.764> <3.299, 1.319, 0.805> 
		<3.349, 1.338, 0.670> <3.349, 1.332, 0.710> <3.349, 1.324, 0.770> <3.349, 1.319, 0.810> 
		<3.416, 1.339, 0.661> <3.416, 1.333, 0.707> <3.416, 1.325, 0.767> <3.416, 1.319, 0.813> 
		<3.465, 1.338, 0.670> <3.465, 1.332, 0.716> <3.465, 1.324, 0.777> <3.465, 1.318, 0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.465, 1.338, 0.670> <3.502, 1.337, 0.676> <3.546, 1.334, 0.703> <3.580, 1.333, 0.718> 
		<3.465, 1.338, 0.689> <3.502, 1.338, 0.695> <3.546, 1.333, 0.727> <3.580, 1.331, 0.742> 
		<3.465, 1.339, 0.715> <3.503, 1.337, 0.726> <3.546, 1.333, 0.755> <3.580, 1.329, 0.774> 
		<3.465, 1.339, 0.734> <3.503, 1.338, 0.745> <3.546, 1.331, 0.779> <3.580, 1.328, 0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.465, 1.338, 0.670> <3.465, 1.332, 0.716> <3.465, 1.324, 0.777> <3.465, 1.318, 0.823> 
		<3.502, 1.337, 0.676> <3.502, 1.331, 0.722> <3.501, 1.323, 0.784> <3.501, 1.317, 0.830> 
		<3.546, 1.334, 0.703> <3.546, 1.329, 0.746> <3.546, 1.321, 0.807> <3.546, 1.315, 0.850> 
		<3.580, 1.333, 0.718> <3.580, 1.327, 0.761> <3.580, 1.319, 0.818> <3.580, 1.314, 0.862> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.465, 1.318, 0.823> <3.465, 1.303, 0.955> <3.465, 1.282, 1.132> <3.465, 1.267, 1.265> 
		<3.501, 1.317, 0.830> <3.501, 1.302, 0.963> <3.508, 1.284, 1.117> <3.508, 1.269, 1.250> 
		<3.546, 1.315, 0.850> <3.546, 1.304, 0.942> <3.546, 1.285, 1.106> <3.546, 1.274, 1.198> 
		<3.580, 1.314, 0.862> <3.580, 1.303, 0.954> <3.580, 1.288, 1.077> <3.580, 1.277, 1.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.465, 1.267, 1.265> <3.465, 1.276, 1.227> <3.465, 1.289, 1.175> <3.465, 1.298, 1.137> 
		<3.508, 1.269, 1.250> <3.508, 1.278, 1.211> <3.503, 1.289, 1.166> <3.503, 1.298, 1.127> 
		<3.546, 1.274, 1.198> <3.546, 1.280, 1.169> <3.546, 1.291, 1.121> <3.546, 1.297, 1.093> 
		<3.580, 1.277, 1.169> <3.580, 1.283, 1.140> <3.580, 1.291, 1.102> <3.580, 1.296, 1.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.465, 1.298, 1.137> <3.465, 1.310, 1.016> <3.465, 1.327, 0.855> <3.465, 1.339, 0.734> 
		<3.503, 1.298, 1.127> <3.503, 1.310, 1.006> <3.503, 1.325, 0.866> <3.503, 1.338, 0.745> 
		<3.546, 1.297, 1.093> <3.546, 1.306, 1.010> <3.546, 1.322, 0.861> <3.546, 1.331, 0.779> 
		<3.580, 1.296, 1.074> <3.580, 1.306, 0.991> <3.580, 1.318, 0.880> <3.580, 1.328, 0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.580, 1.333, 0.718> <3.580, 1.327, 0.761> <3.580, 1.319, 0.818> <3.580, 1.314, 0.862> 
		<3.580, 1.331, 0.742> <3.580, 1.326, 0.785> <3.580, 1.314, 0.882> <3.580, 1.308, 0.925> 
		<3.580, 1.329, 0.774> <3.580, 1.320, 0.856> <3.580, 1.311, 0.927> <3.580, 1.302, 1.010> 
		<3.580, 1.328, 0.798> <3.580, 1.318, 0.880> <3.580, 1.306, 0.991> <3.580, 1.296, 1.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.580, 1.314, 0.862> <3.580, 1.314, 0.862> <3.580, 1.314, 0.862> <3.580, 1.314, 0.862> 
		<3.580, 1.308, 0.925> <3.580, 1.298, 1.017> <3.580, 1.298, 1.017> <3.580, 1.303, 0.954> 
		<3.580, 1.302, 1.010> <3.580, 1.296, 1.039> <3.580, 1.294, 1.048> <3.580, 1.288, 1.077> 
		<3.580, 1.296, 1.074> <3.580, 1.291, 1.102> <3.580, 1.283, 1.140> <3.580, 1.277, 1.169> 
	}
	texture {text2Rojo}
	texture {textSucio translate z*40}
}

#declare Borde_Cab = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.245, 0.487, 1.407> <0.245, 0.495, 1.283> <0.124, 0.623, 1.100> <-0.001, 0.623, 1.100> 
		<0.245, 0.475, 1.407> <0.245, 0.483, 1.283> <0.124, 0.612, 1.100> <-0.001, 0.612, 1.100> 
		<0.254, 0.466, 1.407> <0.254, 0.474, 1.274> <0.132, 0.603, 1.091> <-0.001, 0.603, 1.091> 
		<0.265, 0.466, 1.407> <0.265, 0.474, 1.274> <0.132, 0.603, 1.080> <-0.001, 0.603, 1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.245, 0.487, 1.407> <0.245, 0.475, 1.407> <0.254, 0.466, 1.407> <0.265, 0.466, 1.407> 
		<0.245, 0.479, 1.524> <0.245, 0.468, 1.524> <0.254, 0.458, 1.533> <0.266, 0.458, 1.533> 
		<0.117, 0.585, 1.695> <0.117, 0.573, 1.695> <0.126, 0.564, 1.705> <0.126, 0.564, 1.716> 
		<0.000, 0.585, 1.695> <0.000, 0.573, 1.695> <0.000, 0.564, 1.704> <0.000, 0.564, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.245, 0.487, 1.407> <0.245, 0.498, 1.407> <0.254, 0.507, 1.407> <0.265, 0.507, 1.407> 
		<0.245, 0.495, 1.283> <0.245, 0.506, 1.283> <0.254, 0.515, 1.274> <0.265, 0.515, 1.274> 
		<0.124, 0.623, 1.100> <0.124, 0.634, 1.100> <0.132, 0.644, 1.091> <0.132, 0.644, 1.080> 
		<-0.001, 0.623, 1.100> <-0.001, 0.634, 1.100> <-0.001, 0.644, 1.091> <-0.001, 0.644, 1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.245, 0.487, 1.407> <0.245, 0.479, 1.524> <0.117, 0.585, 1.695> <0.000, 0.585, 1.695> 
		<0.245, 0.498, 1.407> <0.245, 0.490, 1.524> <0.117, 0.596, 1.695> <0.000, 0.596, 1.695> 
		<0.254, 0.507, 1.407> <0.254, 0.500, 1.533> <0.126, 0.605, 1.705> <0.000, 0.605, 1.704> 
		<0.265, 0.507, 1.407> <0.266, 0.500, 1.533> <0.126, 0.605, 1.716> <0.000, 0.605, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.507, 1.407> <0.277, 0.507, 1.407> <0.286, 0.498, 1.407> <0.286, 0.487, 1.407> 
		<0.265, 0.515, 1.274> <0.276, 0.515, 1.274> <0.286, 0.506, 1.266> <0.286, 0.495, 1.266> 
		<0.132, 0.644, 1.080> <0.132, 0.644, 1.068> <0.140, 0.634, 1.059> <0.140, 0.623, 1.059> 
		<-0.001, 0.644, 1.079> <-0.001, 0.644, 1.068> <-0.001, 0.634, 1.059> <-0.001, 0.623, 1.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.507, 1.407> <0.266, 0.500, 1.533> <0.126, 0.605, 1.716> <0.000, 0.605, 1.715> 
		<0.277, 0.507, 1.407> <0.277, 0.500, 1.533> <0.126, 0.605, 1.727> <0.000, 0.605, 1.727> 
		<0.286, 0.498, 1.407> <0.286, 0.490, 1.541> <0.134, 0.596, 1.736> <0.000, 0.596, 1.736> 
		<0.286, 0.487, 1.407> <0.286, 0.479, 1.541> <0.134, 0.585, 1.736> <0.000, 0.585, 1.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.286, 0.487, 1.407> <0.286, 0.475, 1.407> <0.277, 0.466, 1.407> <0.265, 0.466, 1.407> 
		<0.286, 0.495, 1.266> <0.286, 0.483, 1.266> <0.276, 0.474, 1.274> <0.265, 0.474, 1.274> 
		<0.140, 0.623, 1.059> <0.140, 0.612, 1.059> <0.132, 0.603, 1.068> <0.132, 0.603, 1.080> 
		<-0.001, 0.623, 1.059> <-0.001, 0.612, 1.059> <-0.001, 0.603, 1.068> <-0.001, 0.603, 1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.286, 0.487, 1.407> <0.286, 0.479, 1.541> <0.134, 0.585, 1.736> <0.000, 0.585, 1.736> 
		<0.286, 0.475, 1.407> <0.286, 0.468, 1.541> <0.134, 0.573, 1.736> <0.000, 0.573, 1.736> 
		<0.277, 0.466, 1.407> <0.277, 0.458, 1.533> <0.126, 0.564, 1.727> <0.000, 0.564, 1.727> 
		<0.265, 0.466, 1.407> <0.266, 0.458, 1.533> <0.126, 0.564, 1.716> <0.000, 0.564, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.585, 1.695> <0.000, 0.573, 1.695> <0.000, 0.564, 1.704> <0.000, 0.564, 1.715> 
		<-0.116, 0.585, 1.695> <-0.116, 0.573, 1.695> <-0.125, 0.564, 1.704> <-0.125, 0.564, 1.715> 
		<-0.239, 0.479, 1.522> <-0.239, 0.468, 1.522> <-0.248, 0.458, 1.530> <-0.259, 0.458, 1.530> 
		<-0.239, 0.487, 1.406> <-0.239, 0.475, 1.406> <-0.249, 0.466, 1.406> <-0.260, 0.466, 1.406> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.585, 1.695> <-0.116, 0.585, 1.695> <-0.239, 0.479, 1.522> <-0.239, 0.487, 1.406> 
		<0.000, 0.596, 1.695> <-0.116, 0.596, 1.695> <-0.239, 0.490, 1.522> <-0.239, 0.498, 1.406> 
		<0.000, 0.605, 1.704> <-0.125, 0.605, 1.704> <-0.248, 0.500, 1.530> <-0.249, 0.507, 1.406> 
		<0.000, 0.605, 1.715> <-0.125, 0.605, 1.715> <-0.259, 0.500, 1.530> <-0.260, 0.507, 1.406> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 0.487, 1.406> <-0.239, 0.475, 1.406> <-0.249, 0.466, 1.406> <-0.260, 0.466, 1.406> 
		<-0.239, 0.494, 1.283> <-0.239, 0.483, 1.283> <-0.249, 0.474, 1.275> <-0.260, 0.474, 1.275> 
		<-0.125, 0.623, 1.100> <-0.125, 0.612, 1.100> <-0.133, 0.603, 1.090> <-0.133, 0.603, 1.079> 
		<-0.001, 0.623, 1.100> <-0.001, 0.612, 1.100> <-0.001, 0.603, 1.091> <-0.001, 0.603, 1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 0.487, 1.406> <-0.239, 0.494, 1.283> <-0.125, 0.623, 1.100> <-0.001, 0.623, 1.100> 
		<-0.239, 0.498, 1.406> <-0.239, 0.506, 1.283> <-0.125, 0.634, 1.100> <-0.001, 0.634, 1.100> 
		<-0.249, 0.507, 1.406> <-0.249, 0.515, 1.275> <-0.133, 0.644, 1.090> <-0.001, 0.644, 1.091> 
		<-0.260, 0.507, 1.406> <-0.260, 0.515, 1.275> <-0.133, 0.644, 1.079> <-0.001, 0.644, 1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.605, 1.715> <-0.125, 0.605, 1.715> <-0.259, 0.500, 1.530> <-0.260, 0.507, 1.406> 
		<0.000, 0.605, 1.727> <-0.125, 0.605, 1.726> <-0.271, 0.500, 1.530> <-0.271, 0.507, 1.406> 
		<0.000, 0.596, 1.736> <-0.133, 0.596, 1.736> <-0.280, 0.490, 1.539> <-0.280, 0.498, 1.406> 
		<0.000, 0.585, 1.736> <-0.133, 0.585, 1.736> <-0.280, 0.479, 1.539> <-0.280, 0.487, 1.406> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.260, 0.507, 1.406> <-0.260, 0.515, 1.275> <-0.133, 0.644, 1.079> <-0.001, 0.644, 1.079> 
		<-0.271, 0.507, 1.406> <-0.271, 0.515, 1.275> <-0.133, 0.644, 1.068> <-0.001, 0.644, 1.068> 
		<-0.280, 0.498, 1.406> <-0.281, 0.506, 1.266> <-0.141, 0.634, 1.058> <-0.001, 0.634, 1.059> 
		<-0.280, 0.487, 1.406> <-0.281, 0.494, 1.266> <-0.141, 0.623, 1.058> <-0.001, 0.623, 1.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.585, 1.736> <-0.133, 0.585, 1.736> <-0.280, 0.479, 1.539> <-0.280, 0.487, 1.406> 
		<0.000, 0.573, 1.736> <-0.133, 0.573, 1.736> <-0.280, 0.468, 1.539> <-0.280, 0.475, 1.406> 
		<0.000, 0.564, 1.727> <-0.125, 0.564, 1.726> <-0.271, 0.458, 1.530> <-0.271, 0.466, 1.406> 
		<0.000, 0.564, 1.715> <-0.125, 0.564, 1.715> <-0.259, 0.458, 1.530> <-0.260, 0.466, 1.406> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.280, 0.487, 1.406> <-0.281, 0.494, 1.266> <-0.141, 0.623, 1.058> <-0.001, 0.623, 1.059> 
		<-0.280, 0.475, 1.406> <-0.281, 0.483, 1.266> <-0.141, 0.612, 1.058> <-0.001, 0.612, 1.059> 
		<-0.271, 0.466, 1.406> <-0.271, 0.474, 1.275> <-0.133, 0.603, 1.068> <-0.001, 0.603, 1.068> 
		<-0.260, 0.466, 1.406> <-0.260, 0.474, 1.275> <-0.133, 0.603, 1.079> <-0.001, 0.603, 1.079> 
	}
	texture {textBorde}
}


#declare Cola_Fija = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.892, 0.403, 4.649> <-0.662, 0.403, 4.471> <-0.357, 0.403, 4.234> <-0.127, 0.403, 4.056> 
		<-0.892, 0.403, 4.722> <-0.662, 0.403, 4.544> <-0.357, 0.403, 4.316> <-0.127, 0.403, 4.138> 
		<-0.891, 0.403, 4.820> <-0.662, 0.403, 4.651> <-0.357, 0.403, 4.417> <-0.128, 0.403, 4.248> 
		<-0.891, 0.403, 4.893> <-0.662, 0.403, 4.724> <-0.357, 0.403, 4.499> <-0.128, 0.403, 4.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.892, 0.403, 4.649> <-0.892, 0.403, 4.722> <-0.891, 0.403, 4.820> <-0.891, 0.403, 4.893> 
		<-0.892, 0.412, 4.649> <-0.892, 0.412, 4.722> <-0.891, 0.412, 4.820> <-0.891, 0.412, 4.893> 
		<-0.892, 0.424, 4.649> <-0.892, 0.424, 4.722> <-0.891, 0.424, 4.820> <-0.891, 0.424, 4.893> 
		<-0.892, 0.434, 4.649> <-0.892, 0.434, 4.722> <-0.891, 0.434, 4.820> <-0.891, 0.434, 4.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.892, 0.403, 4.649> <-0.892, 0.412, 4.649> <-0.892, 0.424, 4.649> <-0.892, 0.434, 4.649> 
		<-0.662, 0.403, 4.471> <-0.662, 0.412, 4.471> <-0.662, 0.424, 4.471> <-0.662, 0.433, 4.471> 
		<-0.357, 0.403, 4.234> <-0.357, 0.412, 4.234> <-0.357, 0.424, 4.234> <-0.357, 0.433, 4.234> 
		<-0.127, 0.403, 4.056> <-0.127, 0.412, 4.056> <-0.127, 0.424, 4.056> <-0.127, 0.433, 4.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.127, 0.403, 4.056> <-0.127, 0.412, 4.056> <-0.127, 0.424, 4.056> <-0.127, 0.433, 4.056> 
		<-0.127, 0.403, 4.138> <-0.127, 0.412, 4.138> <-0.127, 0.424, 4.138> <-0.127, 0.433, 4.138> 
		<-0.128, 0.403, 4.248> <-0.128, 0.412, 4.248> <-0.128, 0.424, 4.248> <-0.128, 0.433, 4.248> 
		<-0.128, 0.403, 4.330> <-0.128, 0.412, 4.330> <-0.128, 0.424, 4.330> <-0.128, 0.433, 4.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.403, 4.060> <0.125, 0.412, 4.060> <0.125, 0.424, 4.060> <0.125, 0.433, 4.060> 
		<0.125, 0.403, 4.141> <0.125, 0.412, 4.141> <0.125, 0.424, 4.141> <0.125, 0.433, 4.141> 
		<0.125, 0.403, 4.249> <0.125, 0.412, 4.249> <0.125, 0.424, 4.249> <0.125, 0.433, 4.249> 
		<0.125, 0.403, 4.330> <0.125, 0.412, 4.330> <0.125, 0.424, 4.330> <0.125, 0.433, 4.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.403, 4.060> <0.125, 0.403, 4.141> <0.125, 0.403, 4.249> <0.125, 0.403, 4.330> 
		<0.359, 0.403, 4.239> <0.359, 0.403, 4.320> <0.359, 0.403, 4.418> <0.359, 0.403, 4.499> 
		<0.670, 0.403, 4.477> <0.670, 0.403, 4.548> <0.670, 0.403, 4.653> <0.671, 0.403, 4.724> 
		<0.903, 0.403, 4.656> <0.904, 0.403, 4.727> <0.904, 0.403, 4.822> <0.904, 0.403, 4.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.403, 4.060> <0.359, 0.403, 4.239> <0.670, 0.403, 4.477> <0.903, 0.403, 4.656> 
		<0.125, 0.412, 4.060> <0.359, 0.412, 4.239> <0.670, 0.412, 4.477> <0.903, 0.412, 4.656> 
		<0.125, 0.424, 4.060> <0.359, 0.424, 4.239> <0.670, 0.424, 4.477> <0.903, 0.424, 4.656> 
		<0.125, 0.433, 4.060> <0.359, 0.433, 4.239> <0.670, 0.433, 4.477> <0.903, 0.434, 4.656> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.903, 0.403, 4.656> <0.904, 0.403, 4.727> <0.904, 0.403, 4.822> <0.904, 0.403, 4.893> 
		<0.903, 0.412, 4.656> <0.904, 0.412, 4.727> <0.904, 0.412, 4.822> <0.904, 0.412, 4.893> 
		<0.903, 0.424, 4.656> <0.904, 0.424, 4.727> <0.904, 0.424, 4.822> <0.904, 0.424, 4.893> 
		<0.903, 0.434, 4.656> <0.904, 0.434, 4.727> <0.904, 0.434, 4.822> <0.904, 0.434, 4.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.892, 0.434, 4.649> <-0.892, 0.434, 4.722> <-0.891, 0.434, 4.820> <-0.891, 0.434, 4.893> 
		<-0.662, 0.433, 4.471> <-0.662, 0.433, 4.544> <-0.662, 0.433, 4.651> <-0.662, 0.433, 4.724> 
		<-0.357, 0.433, 4.234> <-0.357, 0.433, 4.316> <-0.357, 0.433, 4.417> <-0.357, 0.433, 4.499> 
		<-0.127, 0.433, 4.056> <-0.127, 0.433, 4.138> <-0.128, 0.433, 4.248> <-0.128, 0.433, 4.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.433, 4.060> <0.359, 0.433, 4.239> <0.670, 0.433, 4.477> <0.903, 0.434, 4.656> 
		<0.125, 0.433, 4.141> <0.359, 0.433, 4.320> <0.670, 0.433, 4.548> <0.904, 0.434, 4.727> 
		<0.125, 0.433, 4.249> <0.359, 0.433, 4.418> <0.670, 0.433, 4.653> <0.904, 0.434, 4.822> 
		<0.125, 0.433, 4.330> <0.359, 0.433, 4.499> <0.671, 0.433, 4.724> <0.904, 0.434, 4.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 0.433, 4.330> <-0.052, 0.433, 4.330> <0.049, 0.433, 4.330> <0.125, 0.433, 4.330> 
		<-0.357, 0.433, 4.499> <-0.281, 0.433, 4.499> <0.283, 0.433, 4.499> <0.359, 0.433, 4.499> 
		<-0.662, 0.433, 4.724> <-0.124, 0.433, 4.724> <0.132, 0.433, 4.724> <0.671, 0.433, 4.724> 
		<-0.891, 0.434, 4.893> <-0.353, 0.434, 4.893> <0.366, 0.434, 4.893> <0.904, 0.434, 4.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 0.433, 4.330> <-0.052, 0.433, 4.330> <0.049, 0.433, 4.330> <0.125, 0.433, 4.330> 
		<-0.128, 0.424, 4.330> <-0.052, 0.424, 4.330> <0.049, 0.424, 4.330> <0.125, 0.424, 4.330> 
		<-0.128, 0.412, 4.330> <-0.052, 0.412, 4.330> <0.049, 0.412, 4.330> <0.125, 0.412, 4.330> 
		<-0.128, 0.403, 4.330> <-0.052, 0.403, 4.330> <0.049, 0.403, 4.330> <0.125, 0.403, 4.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.891, 0.434, 4.893> <-0.353, 0.434, 4.893> <0.366, 0.434, 4.893> <0.904, 0.434, 4.893> 
		<-0.891, 0.424, 4.893> <-0.353, 0.424, 4.893> <0.366, 0.424, 4.893> <0.904, 0.424, 4.893> 
		<-0.891, 0.412, 4.893> <-0.353, 0.412, 4.893> <0.366, 0.412, 4.893> <0.904, 0.412, 4.893> 
		<-0.891, 0.403, 4.893> <-0.353, 0.403, 4.893> <0.366, 0.403, 4.893> <0.904, 0.403, 4.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 0.403, 4.330> <-0.357, 0.403, 4.499> <-0.662, 0.403, 4.724> <-0.891, 0.403, 4.893> 
		<-0.052, 0.403, 4.330> <-0.281, 0.403, 4.499> <-0.124, 0.403, 4.724> <-0.353, 0.403, 4.893> 
		<0.049, 0.403, 4.330> <0.283, 0.403, 4.499> <0.132, 0.403, 4.724> <0.366, 0.403, 4.893> 
		<0.125, 0.403, 4.330> <0.359, 0.403, 4.499> <0.671, 0.403, 4.724> <0.904, 0.403, 4.893> 
	}
	texture {text1Rojo}
	texture {textSucio}
}


#declare Cola_Movil = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.900, 0.404, 4.656> <-0.932, 0.404, 4.693> <-1.121, 0.404, 4.807> <-1.180, 0.404, 4.988> 
		<-0.900, 0.404, 4.684> <-0.932, 0.404, 4.722> <-1.151, 0.404, 4.900> <-1.210, 0.404, 5.081> 
		<-0.900, 0.404, 4.830> <-0.952, 0.404, 4.914> <-1.086, 0.395, 5.051> <-1.137, 0.404, 5.134> 
		<-0.900, 0.404, 4.905> <-0.952, 0.404, 4.989> <-1.021, 0.395, 5.100> <-1.072, 0.404, 5.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.900, 0.404, 4.656> <-0.900, 0.404, 4.684> <-0.900, 0.404, 4.830> <-0.900, 0.404, 4.905> 
		<-0.900, 0.413, 4.656> <-0.900, 0.413, 4.684> <-0.900, 0.413, 4.830> <-0.900, 0.413, 4.905> 
		<-0.900, 0.424, 4.656> <-0.900, 0.424, 4.684> <-0.900, 0.424, 4.830> <-0.900, 0.424, 4.905> 
		<-0.900, 0.433, 4.656> <-0.900, 0.433, 4.684> <-0.900, 0.433, 4.830> <-0.900, 0.433, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.900, 0.404, 4.656> <-0.900, 0.413, 4.656> <-0.900, 0.424, 4.656> <-0.900, 0.433, 4.656> 
		<-0.932, 0.404, 4.693> <-0.932, 0.413, 4.693> <-0.932, 0.424, 4.693> <-0.932, 0.433, 4.693> 
		<-1.121, 0.404, 4.807> <-1.121, 0.413, 4.807> <-1.121, 0.424, 4.807> <-1.121, 0.433, 4.807> 
		<-1.180, 0.404, 4.988> <-1.180, 0.413, 4.988> <-1.180, 0.424, 4.988> <-1.180, 0.433, 4.988> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.180, 0.404, 4.988> <-1.180, 0.413, 4.988> <-1.180, 0.424, 4.988> <-1.180, 0.433, 4.988> 
		<-1.210, 0.404, 5.081> <-1.210, 0.413, 5.081> <-1.210, 0.424, 5.081> <-1.210, 0.433, 5.081> 
		<-1.137, 0.404, 5.134> <-1.142, 0.404, 5.141> <-1.142, 0.432, 5.141> <-1.137, 0.433, 5.134> 
		<-1.072, 0.404, 5.183> <-1.077, 0.404, 5.191> <-1.077, 0.432, 5.191> <-1.072, 0.433, 5.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.885, 0.404, 5.214> <-0.744, 0.404, 5.213> <-0.555, 0.404, 5.213> <-0.413, 0.404, 5.213> 
		<-0.941, 0.404, 5.205> <-0.800, 0.404, 5.204> <-0.701, 0.404, 5.121> <-0.560, 0.404, 5.121> 
		<-1.017, 0.404, 5.226> <-0.966, 0.395, 5.142> <-0.806, 0.404, 5.081> <-0.754, 0.404, 4.997> 
		<-1.072, 0.404, 5.183> <-1.021, 0.395, 5.100> <-0.952, 0.404, 4.989> <-0.900, 0.404, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.885, 0.404, 5.214> <-0.941, 0.404, 5.205> <-1.017, 0.404, 5.226> <-1.072, 0.404, 5.183> 
		<-0.885, 0.413, 5.214> <-0.941, 0.413, 5.205> <-1.022, 0.404, 5.233> <-1.077, 0.404, 5.191> 
		<-0.885, 0.424, 5.214> <-0.941, 0.424, 5.205> <-1.022, 0.432, 5.233> <-1.077, 0.432, 5.191> 
		<-0.885, 0.433, 5.214> <-0.941, 0.433, 5.205> <-1.017, 0.433, 5.226> <-1.072, 0.433, 5.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.885, 0.404, 5.214> <-0.885, 0.413, 5.214> <-0.885, 0.424, 5.214> <-0.885, 0.433, 5.214> 
		<-0.744, 0.404, 5.213> <-0.744, 0.413, 5.213> <-0.744, 0.424, 5.213> <-0.744, 0.433, 5.213> 
		<-0.555, 0.404, 5.213> <-0.555, 0.413, 5.213> <-0.555, 0.424, 5.213> <-0.555, 0.433, 5.213> 
		<-0.413, 0.404, 5.213> <-0.413, 0.413, 5.213> <-0.413, 0.424, 5.213> <-0.413, 0.433, 5.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, 0.404, 5.214> <0.937, 0.404, 5.205> <1.013, 0.404, 5.226> <1.068, 0.404, 5.183> 
		<0.739, 0.404, 5.213> <0.795, 0.404, 5.204> <0.966, 0.395, 5.143> <1.021, 0.395, 5.100> 
		<0.551, 0.404, 5.213> <0.701, 0.404, 5.121> <0.808, 0.404, 5.081> <0.959, 0.404, 4.989> 
		<0.409, 0.404, 5.213> <0.560, 0.404, 5.121> <0.761, 0.404, 4.997> <0.912, 0.404, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, 0.404, 5.214> <0.739, 0.404, 5.213> <0.551, 0.404, 5.213> <0.409, 0.404, 5.213> 
		<0.881, 0.413, 5.214> <0.739, 0.413, 5.213> <0.551, 0.413, 5.213> <0.409, 0.413, 5.213> 
		<0.881, 0.424, 5.214> <0.739, 0.424, 5.213> <0.551, 0.424, 5.213> <0.409, 0.424, 5.213> 
		<0.881, 0.433, 5.214> <0.739, 0.433, 5.213> <0.551, 0.433, 5.213> <0.409, 0.433, 5.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, 0.404, 5.214> <0.881, 0.413, 5.214> <0.881, 0.424, 5.214> <0.881, 0.433, 5.214> 
		<0.937, 0.404, 5.205> <0.937, 0.413, 5.205> <0.937, 0.424, 5.205> <0.937, 0.433, 5.205> 
		<1.013, 0.404, 5.226> <1.017, 0.405, 5.233> <1.017, 0.432, 5.233> <1.013, 0.433, 5.226> 
		<1.068, 0.404, 5.183> <1.072, 0.405, 5.191> <1.072, 0.432, 5.191> <1.068, 0.433, 5.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.176, 0.404, 4.988> <1.123, 0.404, 4.813> <0.941, 0.404, 4.702> <0.911, 0.404, 4.666> 
		<1.204, 0.404, 5.082> <1.151, 0.404, 4.907> <0.941, 0.404, 4.729> <0.911, 0.404, 4.693> 
		<1.133, 0.404, 5.134> <1.086, 0.395, 5.051> <0.959, 0.404, 4.917> <0.912, 0.404, 4.833> 
		<1.068, 0.404, 5.183> <1.021, 0.395, 5.100> <0.959, 0.404, 4.989> <0.912, 0.404, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.176, 0.404, 4.988> <1.204, 0.404, 5.082> <1.133, 0.404, 5.134> <1.068, 0.404, 5.183> 
		<1.176, 0.413, 4.988> <1.204, 0.413, 5.082> <1.137, 0.405, 5.141> <1.072, 0.405, 5.191> 
		<1.176, 0.424, 4.988> <1.204, 0.424, 5.082> <1.137, 0.432, 5.141> <1.072, 0.432, 5.191> 
		<1.176, 0.433, 4.988> <1.204, 0.433, 5.082> <1.133, 0.433, 5.134> <1.068, 0.433, 5.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.176, 0.404, 4.988> <1.176, 0.413, 4.988> <1.176, 0.424, 4.988> <1.176, 0.433, 4.988> 
		<1.123, 0.404, 4.813> <1.123, 0.413, 4.813> <1.123, 0.424, 4.813> <1.123, 0.433, 4.813> 
		<0.941, 0.404, 4.702> <0.941, 0.413, 4.702> <0.941, 0.424, 4.702> <0.941, 0.433, 4.702> 
		<0.911, 0.404, 4.666> <0.911, 0.413, 4.666> <0.911, 0.424, 4.666> <0.911, 0.433, 4.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.911, 0.404, 4.666> <0.911, 0.413, 4.666> <0.911, 0.424, 4.666> <0.911, 0.433, 4.666> 
		<0.911, 0.404, 4.693> <0.911, 0.413, 4.693> <0.911, 0.424, 4.693> <0.911, 0.433, 4.693> 
		<0.912, 0.404, 4.833> <0.912, 0.413, 4.833> <0.912, 0.424, 4.833> <0.912, 0.433, 4.833> 
		<0.912, 0.404, 4.905> <0.912, 0.413, 4.905> <0.912, 0.424, 4.905> <0.912, 0.433, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.900, 0.433, 4.656> <-0.900, 0.433, 4.684> <-0.900, 0.433, 4.830> <-0.900, 0.433, 4.905> 
		<-0.932, 0.433, 4.693> <-0.932, 0.433, 4.722> <-0.952, 0.433, 4.914> <-0.952, 0.433, 4.989> 
		<-1.121, 0.433, 4.807> <-1.151, 0.433, 4.900> <-1.086, 0.442, 5.051> <-1.021, 0.442, 5.100> 
		<-1.180, 0.433, 4.988> <-1.210, 0.433, 5.081> <-1.137, 0.433, 5.134> <-1.072, 0.433, 5.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.885, 0.433, 5.214> <-0.941, 0.433, 5.205> <-1.017, 0.433, 5.226> <-1.072, 0.433, 5.183> 
		<-0.744, 0.433, 5.213> <-0.800, 0.433, 5.204> <-0.966, 0.442, 5.142> <-1.021, 0.442, 5.100> 
		<-0.555, 0.433, 5.213> <-0.701, 0.433, 5.121> <-0.806, 0.433, 5.081> <-0.952, 0.433, 4.989> 
		<-0.413, 0.433, 5.213> <-0.560, 0.433, 5.121> <-0.754, 0.433, 4.997> <-0.900, 0.433, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, 0.433, 5.214> <0.739, 0.433, 5.213> <0.551, 0.433, 5.213> <0.409, 0.433, 5.213> 
		<0.937, 0.433, 5.205> <0.795, 0.433, 5.204> <0.701, 0.433, 5.121> <0.560, 0.433, 5.121> 
		<1.013, 0.433, 5.226> <0.966, 0.442, 5.143> <0.808, 0.433, 5.081> <0.761, 0.433, 4.997> 
		<1.068, 0.433, 5.183> <1.021, 0.442, 5.100> <0.959, 0.433, 4.989> <0.912, 0.433, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.176, 0.433, 4.988> <1.204, 0.433, 5.082> <1.133, 0.433, 5.134> <1.068, 0.433, 5.183> 
		<1.123, 0.433, 4.813> <1.151, 0.433, 4.907> <1.086, 0.442, 5.051> <1.021, 0.442, 5.100> 
		<0.941, 0.433, 4.702> <0.941, 0.433, 4.729> <0.959, 0.433, 4.917> <0.959, 0.433, 4.989> 
		<0.911, 0.433, 4.666> <0.911, 0.433, 4.693> <0.912, 0.433, 4.833> <0.912, 0.433, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.912, 0.433, 4.905> <0.761, 0.433, 4.997> <0.560, 0.433, 5.121> <0.409, 0.433, 5.213> 
		<0.638, 0.433, 4.905> <0.487, 0.433, 4.997> <0.437, 0.433, 5.033> <0.286, 0.433, 5.125> 
		<0.272, 0.433, 4.904> <0.272, 0.433, 4.909> <0.122, 0.433, 5.003> <0.122, 0.433, 5.008> 
		<-0.002, 0.433, 4.904> <-0.001, 0.433, 4.909> <-0.001, 0.433, 4.916> <-0.001, 0.433, 4.920> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.912, 0.433, 4.905> <0.638, 0.433, 4.905> <0.272, 0.433, 4.904> <-0.002, 0.433, 4.904> 
		<0.912, 0.424, 4.905> <0.638, 0.424, 4.905> <0.272, 0.424, 4.904> <-0.002, 0.424, 4.904> 
		<0.912, 0.413, 4.905> <0.638, 0.413, 4.905> <0.272, 0.413, 4.904> <-0.002, 0.413, 4.904> 
		<0.912, 0.404, 4.905> <0.638, 0.404, 4.905> <0.272, 0.404, 4.904> <-0.002, 0.404, 4.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.409, 0.433, 5.213> <0.409, 0.424, 5.213> <0.409, 0.413, 5.213> <0.409, 0.404, 5.213> 
		<0.286, 0.433, 5.125> <0.286, 0.424, 5.125> <0.286, 0.413, 5.125> <0.286, 0.404, 5.125> 
		<0.122, 0.433, 5.008> <0.122, 0.424, 5.008> <0.122, 0.413, 5.008> <0.122, 0.404, 5.008> 
		<-0.001, 0.433, 4.920> <-0.001, 0.424, 4.920> <-0.001, 0.413, 4.920> <-0.001, 0.404, 4.920> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.433, 4.920> <-0.001, 0.424, 4.920> <-0.001, 0.413, 4.920> <-0.001, 0.404, 4.920> 
		<-0.125, 0.433, 5.008> <-0.125, 0.424, 5.008> <-0.125, 0.413, 5.008> <-0.125, 0.404, 5.008> 
		<-0.290, 0.433, 5.125> <-0.290, 0.424, 5.125> <-0.290, 0.413, 5.125> <-0.290, 0.404, 5.125> 
		<-0.413, 0.433, 5.213> <-0.413, 0.424, 5.213> <-0.413, 0.413, 5.213> <-0.413, 0.404, 5.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.433, 4.920> <-0.125, 0.433, 5.008> <-0.290, 0.433, 5.125> <-0.413, 0.433, 5.213> 
		<-0.001, 0.433, 4.916> <-0.125, 0.433, 5.003> <-0.436, 0.433, 5.033> <-0.560, 0.433, 5.121> 
		<-0.001, 0.433, 4.909> <-0.271, 0.433, 4.909> <-0.485, 0.433, 4.997> <-0.754, 0.433, 4.997> 
		<-0.002, 0.433, 4.904> <-0.271, 0.433, 4.904> <-0.631, 0.433, 4.905> <-0.900, 0.433, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.433, 4.904> <-0.271, 0.433, 4.904> <-0.631, 0.433, 4.905> <-0.900, 0.433, 4.905> 
		<-0.002, 0.424, 4.904> <-0.271, 0.424, 4.904> <-0.631, 0.424, 4.905> <-0.900, 0.424, 4.905> 
		<-0.002, 0.413, 4.904> <-0.271, 0.413, 4.904> <-0.631, 0.413, 4.905> <-0.900, 0.413, 4.905> 
		<-0.002, 0.404, 4.904> <-0.271, 0.404, 4.904> <-0.631, 0.404, 4.905> <-0.900, 0.404, 4.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.413, 0.404, 5.213> <-0.290, 0.404, 5.125> <-0.125, 0.404, 5.008> <-0.001, 0.404, 4.920> 
		<-0.560, 0.404, 5.121> <-0.436, 0.404, 5.033> <-0.125, 0.404, 5.003> <-0.001, 0.404, 4.916> 
		<-0.754, 0.404, 4.997> <-0.485, 0.404, 4.997> <-0.271, 0.404, 4.909> <-0.001, 0.404, 4.909> 
		<-0.900, 0.404, 4.905> <-0.631, 0.404, 4.905> <-0.271, 0.404, 4.904> <-0.002, 0.404, 4.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.409, 0.404, 5.213> <0.560, 0.404, 5.121> <0.761, 0.404, 4.997> <0.912, 0.404, 4.905> 
		<0.286, 0.404, 5.125> <0.437, 0.404, 5.033> <0.487, 0.404, 4.997> <0.638, 0.404, 4.905> 
		<0.122, 0.404, 5.008> <0.122, 0.404, 5.003> <0.272, 0.404, 4.909> <0.272, 0.404, 4.904> 
		<-0.001, 0.404, 4.920> <-0.001, 0.404, 4.916> <-0.001, 0.404, 4.909> <-0.002, 0.404, 4.904> 
	}
	texture {text1Rojo}
	texture {textSucio}
}        
      


#declare Timon = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.055, 0.291, 4.935> <0.052, 0.307, 4.974> <0.049, 0.317, 5.033> <0.046, 0.344, 5.065> 
		<0.049, 0.323, 4.935> <0.047, 0.339, 4.974> <0.047, 0.333, 5.012> <0.044, 0.360, 5.044> 
		<0.042, 0.366, 4.934> <0.042, 0.366, 4.953> <0.040, 0.382, 4.997> <0.040, 0.383, 5.016> 
		<0.037, 0.398, 4.933> <0.037, 0.399, 4.952> <0.037, 0.399, 4.977> <0.038, 0.399, 4.995> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.055, 0.291, 4.935> <0.049, 0.323, 4.935> <0.042, 0.366, 4.934> <0.037, 0.398, 4.933> 
		<0.025, 0.291, 4.935> <0.019, 0.323, 4.935> <0.021, 0.367, 4.934> <0.016, 0.399, 4.933> 
		<-0.015, 0.291, 4.935> <-0.012, 0.323, 4.935> <-0.016, 0.367, 4.934> <-0.012, 0.399, 4.933> 
		<-0.045, 0.291, 4.935> <-0.042, 0.323, 4.935> <-0.037, 0.367, 4.934> <-0.033, 0.400, 4.933> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.055, 0.291, 4.935> <0.025, 0.291, 4.935> <-0.015, 0.291, 4.935> <-0.045, 0.291, 4.935> 
		<0.052, 0.307, 4.974> <0.022, 0.307, 4.974> <-0.014, 0.307, 4.974> <-0.044, 0.306, 4.974> 
		<0.049, 0.317, 5.033> <0.023, 0.317, 5.033> <-0.016, 0.317, 5.033> <-0.042, 0.317, 5.033> 
		<0.046, 0.344, 5.065> <0.020, 0.344, 5.065> <-0.014, 0.344, 5.065> <-0.040, 0.344, 5.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 1.300, 4.889> <0.010, 1.300, 4.889> <-0.010, 1.300, 4.889> <-0.025, 1.300, 4.889> 
		<0.025, 1.300, 4.988> <0.010, 1.300, 4.988> <-0.010, 1.300, 4.988> <-0.025, 1.300, 4.988> 
		<0.025, 1.243, 5.124> <0.010, 1.243, 5.124> <-0.010, 1.243, 5.124> <-0.025, 1.243, 5.124> 
		<0.025, 1.173, 5.195> <0.010, 1.173, 5.195> <-0.010, 1.173, 5.195> <-0.025, 1.173, 5.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 1.300, 4.889> <0.025, 1.300, 4.889> <0.025, 1.300, 4.889> <0.025, 1.300, 4.889> 
		<0.025, 1.300, 4.789> <0.025, 1.300, 4.889> <0.025, 1.300, 4.889> <0.025, 1.300, 4.988> 
		<0.025, 1.243, 4.653> <0.025, 1.243, 4.837> <0.025, 1.243, 4.941> <0.025, 1.243, 5.124> 
		<0.025, 1.173, 4.583> <0.025, 1.173, 4.766> <0.025, 1.173, 5.011> <0.025, 1.173, 5.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 1.300, 4.889> <0.025, 1.300, 4.789> <0.025, 1.243, 4.653> <0.025, 1.173, 4.583> 
		<0.010, 1.300, 4.889> <0.010, 1.300, 4.789> <0.010, 1.243, 4.653> <0.010, 1.173, 4.583> 
		<-0.010, 1.300, 4.889> <-0.010, 1.300, 4.789> <-0.010, 1.243, 4.653> <-0.010, 1.173, 4.583> 
		<-0.025, 1.300, 4.889> <-0.025, 1.300, 4.789> <-0.025, 1.243, 4.653> <-0.025, 1.173, 4.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.449, 4.857> <0.032, 0.437, 4.897> <0.031, 0.442, 4.953> <0.031, 0.438, 4.995> 
		<0.030, 0.475, 4.772> <0.031, 0.463, 4.812> <0.029, 0.474, 5.026> <0.029, 0.470, 5.067> 
		<0.026, 0.497, 4.644> <0.026, 0.492, 4.840> <0.027, 0.518, 4.967> <0.027, 0.513, 5.163> 
		<0.025, 0.561, 4.583> <0.025, 0.556, 4.779> <0.025, 0.550, 5.040> <0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.449, 4.857> <0.030, 0.475, 4.772> <0.026, 0.497, 4.644> <0.025, 0.561, 4.583> 
		<0.013, 0.449, 4.857> <0.012, 0.475, 4.772> <0.011, 0.497, 4.644> <0.010, 0.561, 4.583> 
		<-0.011, 0.449, 4.857> <-0.009, 0.475, 4.772> <-0.011, 0.497, 4.644> <-0.010, 0.561, 4.583> 
		<-0.029, 0.449, 4.857> <-0.027, 0.475, 4.772> <-0.026, 0.497, 4.644> <-0.025, 0.561, 4.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.449, 4.857> <0.013, 0.449, 4.857> <-0.011, 0.449, 4.857> <-0.029, 0.449, 4.857> 
		<0.032, 0.437, 4.897> <0.014, 0.437, 4.897> <-0.011, 0.438, 4.897> <-0.029, 0.438, 4.897> 
		<0.031, 0.442, 4.953> <0.012, 0.442, 4.953> <-0.012, 0.442, 4.953> <-0.030, 0.442, 4.953> 
		<0.031, 0.438, 4.995> <0.012, 0.438, 4.995> <-0.012, 0.439, 4.995> <-0.031, 0.439, 4.995> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.037, 0.398, 4.933> <0.037, 0.399, 4.952> <0.037, 0.399, 4.977> <0.038, 0.399, 4.995> 
		<0.016, 0.399, 4.933> <0.016, 0.399, 4.952> <0.016, 0.399, 4.977> <0.016, 0.400, 4.995> 
		<-0.012, 0.399, 4.933> <-0.012, 0.399, 4.952> <-0.012, 0.400, 4.977> <-0.012, 0.400, 4.995> 
		<-0.033, 0.400, 4.933> <-0.033, 0.400, 4.952> <-0.033, 0.400, 4.977> <-0.033, 0.400, 4.995> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 0.291, 4.935> <-0.042, 0.323, 4.935> <-0.037, 0.367, 4.934> <-0.033, 0.400, 4.933> 
		<-0.044, 0.306, 4.974> <-0.040, 0.339, 4.974> <-0.037, 0.367, 4.953> <-0.033, 0.400, 4.952> 
		<-0.042, 0.317, 5.033> <-0.040, 0.334, 5.012> <-0.035, 0.383, 4.997> <-0.033, 0.400, 4.977> 
		<-0.040, 0.344, 5.065> <-0.038, 0.361, 5.044> <-0.035, 0.383, 5.016> <-0.033, 0.400, 4.995> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 1.300, 4.889> <-0.025, 1.300, 4.889> <-0.025, 1.300, 4.889> <-0.025, 1.300, 4.889> 
		<-0.025, 1.300, 4.988> <-0.025, 1.300, 4.889> <-0.025, 1.300, 4.889> <-0.025, 1.300, 4.789> 
		<-0.025, 1.243, 5.124> <-0.025, 1.243, 4.941> <-0.025, 1.243, 4.837> <-0.025, 1.243, 4.653> 
		<-0.025, 1.173, 5.195> <-0.025, 1.173, 5.011> <-0.025, 1.173, 4.766> <-0.025, 1.173, 4.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.029, 0.449, 4.857> <-0.027, 0.475, 4.772> <-0.026, 0.497, 4.644> <-0.025, 0.561, 4.583> 
		<-0.029, 0.438, 4.897> <-0.028, 0.463, 4.812> <-0.026, 0.492, 4.840> <-0.025, 0.556, 4.779> 
		<-0.030, 0.442, 4.953> <-0.029, 0.474, 5.026> <-0.027, 0.518, 4.967> <-0.025, 0.550, 5.040> 
		<-0.031, 0.439, 4.995> <-0.029, 0.471, 5.067> <-0.027, 0.514, 5.163> <-0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 0.867, 4.456> <0.025, 0.966, 4.456> <0.025, 1.103, 4.512> <0.025, 1.173, 4.583> 
		<0.025, 0.867, 4.716> <0.025, 0.966, 4.716> <0.025, 1.103, 4.696> <0.025, 1.173, 4.766> 
		<0.025, 0.867, 5.062> <0.025, 0.966, 5.055> <0.025, 1.103, 5.081> <0.025, 1.173, 5.011> 
		<0.025, 0.867, 5.321> <0.025, 0.966, 5.315> <0.025, 1.103, 5.265> <0.025, 1.173, 5.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 0.867, 4.456> <0.010, 0.867, 4.456> <-0.010, 0.867, 4.456> <-0.025, 0.867, 4.456> 
		<0.025, 0.966, 4.456> <0.010, 0.966, 4.456> <-0.010, 0.966, 4.456> <-0.025, 0.966, 4.456> 
		<0.025, 1.103, 4.512> <0.010, 1.103, 4.512> <-0.010, 1.103, 4.512> <-0.025, 1.103, 4.512> 
		<0.025, 1.173, 4.583> <0.010, 1.173, 4.583> <-0.010, 1.173, 4.583> <-0.025, 1.173, 4.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 0.867, 4.456> <0.025, 0.768, 4.456> <0.024, 0.633, 4.514> <0.025, 0.561, 4.583> 
		<0.025, 0.867, 4.716> <0.025, 0.768, 4.716> <0.024, 0.628, 4.710> <0.025, 0.556, 4.779> 
		<0.025, 0.867, 5.062> <0.025, 0.767, 5.068> <0.018, 0.726, 5.126> <0.025, 0.550, 5.040> 
		<0.025, 0.867, 5.321> <0.025, 0.767, 5.328> <0.018, 0.722, 5.322> <0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 0.867, 4.456> <0.025, 0.768, 4.456> <0.024, 0.633, 4.514> <0.025, 0.561, 4.583> 
		<0.010, 0.867, 4.456> <0.010, 0.768, 4.456> <0.009, 0.633, 4.514> <0.010, 0.561, 4.583> 
		<-0.010, 0.867, 4.456> <-0.010, 0.768, 4.456> <-0.009, 0.633, 4.514> <-0.010, 0.561, 4.583> 
		<-0.025, 0.867, 4.456> <-0.025, 0.768, 4.456> <-0.024, 0.633, 4.514> <-0.025, 0.561, 4.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 0.867, 5.321> <0.025, 0.767, 5.328> <0.018, 0.722, 5.322> <0.025, 0.546, 5.236> 
		<0.010, 0.867, 5.321> <0.010, 0.767, 5.328> <0.003, 0.722, 5.322> <0.010, 0.546, 5.236> 
		<-0.010, 0.867, 5.321> <-0.010, 0.767, 5.328> <-0.005, 0.722, 5.322> <-0.010, 0.546, 5.236> 
		<-0.025, 0.867, 5.321> <-0.025, 0.767, 5.328> <-0.020, 0.722, 5.322> <-0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.025, 0.867, 5.321> <0.025, 0.966, 5.315> <0.025, 1.103, 5.265> <0.025, 1.173, 5.195> 
		<0.010, 0.867, 5.321> <0.010, 0.966, 5.315> <0.010, 1.103, 5.265> <0.010, 1.173, 5.195> 
		<-0.010, 0.867, 5.321> <-0.010, 0.966, 5.315> <-0.010, 1.103, 5.265> <-0.010, 1.173, 5.195> 
		<-0.025, 0.867, 5.321> <-0.025, 0.966, 5.315> <-0.025, 1.103, 5.265> <-0.025, 1.173, 5.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.038, 0.399, 4.995> <0.036, 0.411, 4.995> <0.033, 0.427, 4.995> <0.031, 0.438, 4.995> 
		<0.016, 0.400, 4.995> <0.014, 0.411, 4.995> <0.014, 0.427, 4.995> <0.012, 0.438, 4.995> 
		<-0.012, 0.400, 4.995> <-0.011, 0.412, 4.995> <-0.013, 0.427, 4.995> <-0.012, 0.439, 4.995> 
		<-0.033, 0.400, 4.995> <-0.033, 0.412, 4.995> <-0.032, 0.427, 4.995> <-0.031, 0.439, 4.995> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.038, 0.399, 4.995> <0.040, 0.383, 5.016> <0.044, 0.360, 5.044> <0.046, 0.344, 5.065> 
		<0.036, 0.411, 4.995> <0.038, 0.394, 5.016> <0.038, 0.412, 5.104> <0.040, 0.395, 5.125> 
		<0.033, 0.427, 4.995> <0.031, 0.459, 5.067> <0.033, 0.373, 5.094> <0.031, 0.405, 5.167> 
		<0.031, 0.438, 4.995> <0.029, 0.470, 5.067> <0.027, 0.513, 5.163> <0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.046, 0.344, 5.065> <0.020, 0.344, 5.065> <-0.014, 0.344, 5.065> <-0.040, 0.344, 5.065> 
		<0.040, 0.395, 5.125> <0.014, 0.395, 5.125> <-0.010, 0.395, 5.125> <-0.036, 0.395, 5.125> 
		<0.031, 0.405, 5.167> <0.016, 0.405, 5.167> <-0.014, 0.405, 5.167> <-0.029, 0.405, 5.167> 
		<0.025, 0.546, 5.236> <0.010, 0.546, 5.236> <-0.010, 0.546, 5.236> <-0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.438, 4.995> <0.012, 0.438, 4.995> <-0.012, 0.439, 4.995> <-0.031, 0.439, 4.995> 
		<0.029, 0.470, 5.067> <0.011, 0.471, 5.067> <-0.011, 0.471, 5.067> <-0.029, 0.471, 5.067> 
		<0.027, 0.513, 5.163> <0.012, 0.513, 5.163> <-0.012, 0.514, 5.163> <-0.027, 0.514, 5.163> 
		<0.025, 0.546, 5.236> <0.010, 0.546, 5.236> <-0.010, 0.546, 5.236> <-0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 1.173, 4.583> <-0.025, 1.103, 4.512> <-0.025, 0.966, 4.456> <-0.025, 0.867, 4.456> 
		<-0.025, 1.173, 4.766> <-0.025, 1.103, 4.696> <-0.025, 0.966, 4.716> <-0.025, 0.867, 4.716> 
		<-0.025, 1.173, 5.011> <-0.025, 1.103, 5.081> <-0.025, 0.966, 5.055> <-0.025, 0.867, 5.062> 
		<-0.025, 1.173, 5.195> <-0.025, 1.103, 5.265> <-0.025, 0.966, 5.315> <-0.025, 0.867, 5.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 0.867, 4.456> <-0.025, 0.867, 4.716> <-0.025, 0.867, 5.062> <-0.025, 0.867, 5.321> 
		<-0.025, 0.768, 4.456> <-0.025, 0.768, 4.716> <-0.025, 0.767, 5.068> <-0.025, 0.767, 5.328> 
		<-0.024, 0.633, 4.514> <-0.024, 0.628, 4.710> <-0.020, 0.726, 5.126> <-0.020, 0.722, 5.322> 
		<-0.025, 0.561, 4.583> <-0.025, 0.556, 4.779> <-0.025, 0.550, 5.040> <-0.025, 0.546, 5.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.031, 0.439, 4.995> <-0.029, 0.471, 5.067> <-0.027, 0.514, 5.163> <-0.025, 0.546, 5.236> 
		<-0.032, 0.427, 4.995> <-0.030, 0.459, 5.067> <-0.031, 0.373, 5.094> <-0.029, 0.405, 5.167> 
		<-0.033, 0.412, 4.995> <-0.035, 0.395, 5.016> <-0.034, 0.412, 5.104> <-0.036, 0.395, 5.125> 
		<-0.033, 0.400, 4.995> <-0.035, 0.383, 5.016> <-0.038, 0.361, 5.044> <-0.040, 0.344, 5.065> 
	}
	texture {textTimon}
	texture {pigment{image_map {png "CruzdeMalta01.png" once}}
                        scale .65
                        translate <4.58,2.05,0>
                        rotate y*(-90) translate y*-1.5
                 }
        texture {textSucio}
}     

#declare Cubiertas = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.468, 0.436> <0.893, -1.468, 0.361> <0.893, -1.425, 0.259> <0.893, -1.372, 0.206> 
		<0.871, -1.468, 0.436> <0.871, -1.468, 0.361> <0.871, -1.425, 0.259> <0.871, -1.372, 0.206> 
		<0.855, -1.449, 0.436> <0.855, -1.449, 0.371> <0.855, -1.405, 0.266> <0.855, -1.359, 0.219> 
		<0.855, -1.428, 0.436> <0.855, -1.428, 0.371> <0.855, -1.390, 0.281> <0.855, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.468, 0.436> <0.871, -1.468, 0.436> <0.855, -1.449, 0.436> <0.855, -1.428, 0.436> 
		<0.893, -1.468, 0.511> <0.871, -1.468, 0.511> <0.855, -1.449, 0.502> <0.855, -1.428, 0.502> 
		<0.893, -1.425, 0.614> <0.871, -1.425, 0.614> <0.855, -1.405, 0.607> <0.855, -1.390, 0.592> 
		<0.893, -1.372, 0.667> <0.871, -1.372, 0.667> <0.855, -1.359, 0.653> <0.855, -1.344, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.468, 0.436> <0.914, -1.468, 0.436> <0.930, -1.449, 0.436> <0.930, -1.428, 0.436> 
		<0.893, -1.468, 0.361> <0.914, -1.468, 0.361> <0.930, -1.449, 0.371> <0.930, -1.428, 0.371> 
		<0.893, -1.425, 0.259> <0.914, -1.425, 0.259> <0.930, -1.405, 0.266> <0.930, -1.390, 0.281> 
		<0.893, -1.372, 0.206> <0.914, -1.372, 0.206> <0.930, -1.359, 0.219> <0.930, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.468, 0.436> <0.893, -1.468, 0.511> <0.893, -1.425, 0.614> <0.893, -1.372, 0.667> 
		<0.914, -1.468, 0.436> <0.914, -1.468, 0.511> <0.914, -1.425, 0.614> <0.914, -1.372, 0.667> 
		<0.930, -1.449, 0.436> <0.930, -1.449, 0.502> <0.930, -1.405, 0.607> <0.930, -1.359, 0.653> 
		<0.930, -1.428, 0.436> <0.930, -1.428, 0.502> <0.930, -1.390, 0.592> <0.930, -1.344, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -1.428, 0.436> <0.930, -1.406, 0.436> <0.914, -1.387, 0.436> <0.893, -1.387, 0.436> 
		<0.930, -1.428, 0.371> <0.930, -1.406, 0.371> <0.914, -1.387, 0.380> <0.893, -1.387, 0.380> 
		<0.930, -1.390, 0.281> <0.930, -1.375, 0.296> <0.914, -1.355, 0.303> <0.893, -1.355, 0.303> 
		<0.930, -1.344, 0.234> <0.930, -1.329, 0.249> <0.914, -1.316, 0.263> <0.893, -1.316, 0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -1.428, 0.436> <0.930, -1.428, 0.502> <0.930, -1.390, 0.592> <0.930, -1.344, 0.638> 
		<0.930, -1.406, 0.436> <0.930, -1.406, 0.502> <0.930, -1.375, 0.577> <0.930, -1.329, 0.623> 
		<0.914, -1.387, 0.436> <0.914, -1.387, 0.493> <0.914, -1.355, 0.570> <0.914, -1.316, 0.610> 
		<0.893, -1.387, 0.436> <0.893, -1.387, 0.493> <0.893, -1.355, 0.570> <0.893, -1.316, 0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.387, 0.436> <0.871, -1.387, 0.436> <0.855, -1.406, 0.436> <0.855, -1.428, 0.436> 
		<0.893, -1.387, 0.380> <0.871, -1.387, 0.380> <0.855, -1.406, 0.371> <0.855, -1.428, 0.371> 
		<0.893, -1.355, 0.303> <0.871, -1.355, 0.303> <0.855, -1.375, 0.296> <0.855, -1.390, 0.281> 
		<0.893, -1.316, 0.263> <0.871, -1.316, 0.263> <0.855, -1.329, 0.249> <0.855, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.387, 0.436> <0.893, -1.387, 0.493> <0.893, -1.355, 0.570> <0.893, -1.316, 0.610> 
		<0.871, -1.387, 0.436> <0.871, -1.387, 0.493> <0.871, -1.355, 0.570> <0.871, -1.316, 0.610> 
		<0.855, -1.406, 0.436> <0.855, -1.406, 0.502> <0.855, -1.375, 0.577> <0.855, -1.329, 0.623> 
		<0.855, -1.428, 0.436> <0.855, -1.428, 0.502> <0.855, -1.390, 0.592> <0.855, -1.344, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.372, 0.667> <0.871, -1.372, 0.667> <0.855, -1.359, 0.653> <0.855, -1.344, 0.638> 
		<0.893, -1.319, 0.720> <0.871, -1.319, 0.720> <0.855, -1.313, 0.700> <0.855, -1.298, 0.685> 
		<0.893, -1.217, 0.762> <0.871, -1.217, 0.762> <0.855, -1.208, 0.743> <0.855, -1.208, 0.722> 
		<0.893, -1.142, 0.762> <0.871, -1.142, 0.762> <0.855, -1.142, 0.743> <0.855, -1.142, 0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.372, 0.667> <0.893, -1.319, 0.720> <0.893, -1.217, 0.762> <0.893, -1.142, 0.762> 
		<0.914, -1.372, 0.667> <0.914, -1.319, 0.720> <0.914, -1.217, 0.762> <0.914, -1.142, 0.762> 
		<0.930, -1.359, 0.653> <0.930, -1.313, 0.700> <0.930, -1.208, 0.743> <0.930, -1.142, 0.743> 
		<0.930, -1.344, 0.638> <0.930, -1.298, 0.685> <0.930, -1.208, 0.722> <0.930, -1.142, 0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.142, 0.762> <0.871, -1.142, 0.762> <0.855, -1.142, 0.743> <0.855, -1.142, 0.722> 
		<0.893, -1.067, 0.762> <0.871, -1.067, 0.762> <0.855, -1.076, 0.743> <0.855, -1.076, 0.722> 
		<0.893, -0.965, 0.720> <0.871, -0.965, 0.720> <0.855, -0.971, 0.700> <0.855, -0.986, 0.685> 
		<0.893, -0.912, 0.667> <0.871, -0.912, 0.667> <0.855, -0.925, 0.653> <0.855, -0.940, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.142, 0.762> <0.893, -1.067, 0.762> <0.893, -0.965, 0.720> <0.893, -0.912, 0.667> 
		<0.914, -1.142, 0.762> <0.914, -1.067, 0.762> <0.914, -0.965, 0.720> <0.914, -0.912, 0.667> 
		<0.930, -1.142, 0.743> <0.930, -1.076, 0.743> <0.930, -0.971, 0.700> <0.930, -0.925, 0.653> 
		<0.930, -1.142, 0.722> <0.930, -1.076, 0.722> <0.930, -0.986, 0.685> <0.930, -0.940, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.912, 0.667> <0.871, -0.912, 0.667> <0.855, -0.925, 0.653> <0.855, -0.940, 0.638> 
		<0.893, -0.859, 0.614> <0.871, -0.859, 0.614> <0.855, -0.879, 0.607> <0.855, -0.894, 0.592> 
		<0.893, -0.816, 0.511> <0.871, -0.816, 0.511> <0.855, -0.835, 0.502> <0.855, -0.856, 0.502> 
		<0.893, -0.816, 0.436> <0.871, -0.816, 0.436> <0.855, -0.835, 0.436> <0.855, -0.856, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.912, 0.667> <0.893, -0.859, 0.614> <0.893, -0.816, 0.511> <0.893, -0.816, 0.436> 
		<0.914, -0.912, 0.667> <0.914, -0.859, 0.614> <0.914, -0.816, 0.511> <0.914, -0.816, 0.436> 
		<0.930, -0.925, 0.653> <0.930, -0.879, 0.607> <0.930, -0.835, 0.502> <0.930, -0.835, 0.436> 
		<0.930, -0.940, 0.638> <0.930, -0.894, 0.592> <0.930, -0.856, 0.502> <0.930, -0.856, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.816, 0.436> <0.871, -0.816, 0.436> <0.855, -0.835, 0.436> <0.855, -0.856, 0.436> 
		<0.893, -0.816, 0.361> <0.871, -0.816, 0.361> <0.855, -0.835, 0.371> <0.855, -0.856, 0.371> 
		<0.893, -0.859, 0.259> <0.871, -0.859, 0.259> <0.855, -0.879, 0.266> <0.855, -0.894, 0.281> 
		<0.893, -0.912, 0.206> <0.871, -0.912, 0.206> <0.855, -0.925, 0.219> <0.855, -0.940, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.816, 0.436> <0.893, -0.816, 0.361> <0.893, -0.859, 0.259> <0.893, -0.912, 0.206> 
		<0.914, -0.816, 0.436> <0.914, -0.816, 0.361> <0.914, -0.859, 0.259> <0.914, -0.912, 0.206> 
		<0.930, -0.835, 0.436> <0.930, -0.835, 0.371> <0.930, -0.879, 0.266> <0.930, -0.925, 0.219> 
		<0.930, -0.856, 0.436> <0.930, -0.856, 0.371> <0.930, -0.894, 0.281> <0.930, -0.940, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.912, 0.206> <0.871, -0.912, 0.206> <0.855, -0.925, 0.219> <0.855, -0.940, 0.234> 
		<0.893, -0.965, 0.153> <0.871, -0.965, 0.153> <0.855, -0.971, 0.173> <0.855, -0.986, 0.188> 
		<0.893, -1.067, 0.111> <0.871, -1.067, 0.111> <0.855, -1.076, 0.129> <0.855, -1.076, 0.151> 
		<0.893, -1.142, 0.111> <0.871, -1.142, 0.111> <0.855, -1.142, 0.129> <0.855, -1.142, 0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.912, 0.206> <0.893, -0.965, 0.153> <0.893, -1.067, 0.111> <0.893, -1.142, 0.111> 
		<0.914, -0.912, 0.206> <0.914, -0.965, 0.153> <0.914, -1.067, 0.111> <0.914, -1.142, 0.111> 
		<0.930, -0.925, 0.219> <0.930, -0.971, 0.173> <0.930, -1.076, 0.129> <0.930, -1.142, 0.129> 
		<0.930, -0.940, 0.234> <0.930, -0.986, 0.188> <0.930, -1.076, 0.151> <0.930, -1.142, 0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.142, 0.111> <0.871, -1.142, 0.111> <0.855, -1.142, 0.129> <0.855, -1.142, 0.151> 
		<0.893, -1.217, 0.111> <0.871, -1.217, 0.111> <0.855, -1.208, 0.129> <0.855, -1.208, 0.151> 
		<0.893, -1.319, 0.153> <0.871, -1.319, 0.153> <0.855, -1.313, 0.173> <0.855, -1.298, 0.188> 
		<0.893, -1.372, 0.206> <0.871, -1.372, 0.206> <0.855, -1.359, 0.219> <0.855, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.142, 0.111> <0.893, -1.217, 0.111> <0.893, -1.319, 0.153> <0.893, -1.372, 0.206> 
		<0.914, -1.142, 0.111> <0.914, -1.217, 0.111> <0.914, -1.319, 0.153> <0.914, -1.372, 0.206> 
		<0.930, -1.142, 0.129> <0.930, -1.208, 0.129> <0.930, -1.313, 0.173> <0.930, -1.359, 0.219> 
		<0.930, -1.142, 0.151> <0.930, -1.208, 0.151> <0.930, -1.298, 0.188> <0.930, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -1.344, 0.638> <0.930, -1.298, 0.685> <0.930, -1.208, 0.722> <0.930, -1.142, 0.722> 
		<0.930, -1.329, 0.623> <0.930, -1.283, 0.670> <0.930, -1.208, 0.701> <0.930, -1.142, 0.701> 
		<0.914, -1.316, 0.610> <0.914, -1.276, 0.650> <0.914, -1.198, 0.682> <0.914, -1.142, 0.682> 
		<0.893, -1.316, 0.610> <0.893, -1.276, 0.650> <0.893, -1.198, 0.682> <0.893, -1.142, 0.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -1.142, 0.722> <0.930, -1.076, 0.722> <0.930, -0.986, 0.685> <0.930, -0.940, 0.638> 
		<0.930, -1.142, 0.701> <0.930, -1.076, 0.701> <0.930, -1.001, 0.670> <0.930, -0.955, 0.623> 
		<0.914, -1.142, 0.682> <0.914, -1.086, 0.682> <0.914, -1.008, 0.650> <0.914, -0.968, 0.610> 
		<0.893, -1.142, 0.682> <0.893, -1.086, 0.682> <0.893, -1.008, 0.650> <0.893, -0.968, 0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -0.940, 0.638> <0.930, -0.894, 0.592> <0.930, -0.856, 0.502> <0.930, -0.856, 0.436> 
		<0.930, -0.955, 0.623> <0.930, -0.909, 0.577> <0.930, -0.878, 0.502> <0.930, -0.878, 0.436> 
		<0.914, -0.968, 0.610> <0.914, -0.929, 0.570> <0.914, -0.896, 0.493> <0.914, -0.896, 0.436> 
		<0.893, -0.968, 0.610> <0.893, -0.929, 0.570> <0.893, -0.896, 0.493> <0.893, -0.896, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -0.856, 0.436> <0.930, -0.856, 0.371> <0.930, -0.894, 0.281> <0.930, -0.940, 0.234> 
		<0.930, -0.878, 0.436> <0.930, -0.878, 0.371> <0.930, -0.909, 0.296> <0.930, -0.955, 0.249> 
		<0.914, -0.896, 0.436> <0.914, -0.896, 0.380> <0.914, -0.929, 0.303> <0.914, -0.968, 0.263> 
		<0.893, -0.896, 0.436> <0.893, -0.896, 0.380> <0.893, -0.929, 0.303> <0.893, -0.968, 0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -0.940, 0.234> <0.930, -0.986, 0.188> <0.930, -1.076, 0.151> <0.930, -1.142, 0.151> 
		<0.930, -0.955, 0.249> <0.930, -1.001, 0.203> <0.930, -1.076, 0.172> <0.930, -1.142, 0.172> 
		<0.914, -0.968, 0.263> <0.914, -1.008, 0.223> <0.914, -1.086, 0.191> <0.914, -1.142, 0.191> 
		<0.893, -0.968, 0.263> <0.893, -1.008, 0.223> <0.893, -1.086, 0.191> <0.893, -1.142, 0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.930, -1.142, 0.151> <0.930, -1.208, 0.151> <0.930, -1.298, 0.188> <0.930, -1.344, 0.234> 
		<0.930, -1.142, 0.172> <0.930, -1.208, 0.172> <0.930, -1.283, 0.203> <0.930, -1.329, 0.249> 
		<0.914, -1.142, 0.191> <0.914, -1.198, 0.191> <0.914, -1.276, 0.223> <0.914, -1.316, 0.263> 
		<0.893, -1.142, 0.191> <0.893, -1.198, 0.191> <0.893, -1.276, 0.223> <0.893, -1.316, 0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.316, 0.610> <0.893, -1.276, 0.650> <0.893, -1.198, 0.682> <0.893, -1.142, 0.682> 
		<0.871, -1.316, 0.610> <0.871, -1.276, 0.650> <0.871, -1.198, 0.682> <0.871, -1.142, 0.682> 
		<0.855, -1.329, 0.623> <0.855, -1.283, 0.670> <0.855, -1.208, 0.701> <0.855, -1.142, 0.701> 
		<0.855, -1.344, 0.638> <0.855, -1.298, 0.685> <0.855, -1.208, 0.722> <0.855, -1.142, 0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.142, 0.682> <0.893, -1.086, 0.682> <0.893, -1.008, 0.650> <0.893, -0.968, 0.610> 
		<0.871, -1.142, 0.682> <0.871, -1.086, 0.682> <0.871, -1.008, 0.650> <0.871, -0.968, 0.610> 
		<0.855, -1.142, 0.701> <0.855, -1.076, 0.701> <0.855, -1.001, 0.670> <0.855, -0.955, 0.623> 
		<0.855, -1.142, 0.722> <0.855, -1.076, 0.722> <0.855, -0.986, 0.685> <0.855, -0.940, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.968, 0.610> <0.893, -0.929, 0.570> <0.893, -0.896, 0.493> <0.893, -0.896, 0.436> 
		<0.871, -0.968, 0.610> <0.871, -0.929, 0.570> <0.871, -0.896, 0.493> <0.871, -0.896, 0.436> 
		<0.855, -0.955, 0.623> <0.855, -0.909, 0.577> <0.855, -0.878, 0.502> <0.855, -0.878, 0.436> 
		<0.855, -0.940, 0.638> <0.855, -0.894, 0.592> <0.855, -0.856, 0.502> <0.855, -0.856, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.896, 0.436> <0.893, -0.896, 0.380> <0.893, -0.929, 0.303> <0.893, -0.968, 0.263> 
		<0.871, -0.896, 0.436> <0.871, -0.896, 0.380> <0.871, -0.929, 0.303> <0.871, -0.968, 0.263> 
		<0.855, -0.878, 0.436> <0.855, -0.878, 0.371> <0.855, -0.909, 0.296> <0.855, -0.955, 0.249> 
		<0.855, -0.856, 0.436> <0.855, -0.856, 0.371> <0.855, -0.894, 0.281> <0.855, -0.940, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -0.968, 0.263> <0.893, -1.008, 0.223> <0.893, -1.086, 0.191> <0.893, -1.142, 0.191> 
		<0.871, -0.968, 0.263> <0.871, -1.008, 0.223> <0.871, -1.086, 0.191> <0.871, -1.142, 0.191> 
		<0.855, -0.955, 0.249> <0.855, -1.001, 0.203> <0.855, -1.076, 0.172> <0.855, -1.142, 0.172> 
		<0.855, -0.940, 0.234> <0.855, -0.986, 0.188> <0.855, -1.076, 0.151> <0.855, -1.142, 0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.893, -1.142, 0.191> <0.893, -1.198, 0.191> <0.893, -1.276, 0.223> <0.893, -1.316, 0.263> 
		<0.871, -1.142, 0.191> <0.871, -1.198, 0.191> <0.871, -1.276, 0.223> <0.871, -1.316, 0.263> 
		<0.855, -1.142, 0.172> <0.855, -1.208, 0.172> <0.855, -1.283, 0.203> <0.855, -1.329, 0.249> 
		<0.855, -1.142, 0.151> <0.855, -1.208, 0.151> <0.855, -1.298, 0.188> <0.855, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.468, 0.436> <-0.894, -1.468, 0.361> <-0.894, -1.425, 0.259> <-0.894, -1.372, 0.206> 
		<-0.873, -1.468, 0.436> <-0.873, -1.468, 0.361> <-0.873, -1.425, 0.259> <-0.873, -1.372, 0.206> 
		<-0.856, -1.449, 0.436> <-0.856, -1.449, 0.371> <-0.856, -1.405, 0.266> <-0.856, -1.359, 0.219> 
		<-0.856, -1.428, 0.436> <-0.856, -1.428, 0.371> <-0.856, -1.390, 0.281> <-0.856, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.468, 0.436> <-0.873, -1.468, 0.436> <-0.856, -1.449, 0.436> <-0.856, -1.428, 0.436> 
		<-0.894, -1.468, 0.511> <-0.873, -1.468, 0.511> <-0.856, -1.449, 0.502> <-0.856, -1.428, 0.502> 
		<-0.894, -1.425, 0.614> <-0.873, -1.425, 0.614> <-0.856, -1.405, 0.607> <-0.856, -1.390, 0.592> 
		<-0.894, -1.372, 0.667> <-0.873, -1.372, 0.667> <-0.856, -1.359, 0.653> <-0.856, -1.344, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.468, 0.436> <-0.915, -1.468, 0.436> <-0.932, -1.449, 0.436> <-0.932, -1.428, 0.436> 
		<-0.894, -1.468, 0.361> <-0.915, -1.468, 0.361> <-0.932, -1.449, 0.371> <-0.932, -1.428, 0.371> 
		<-0.894, -1.425, 0.259> <-0.915, -1.425, 0.259> <-0.932, -1.405, 0.266> <-0.932, -1.390, 0.281> 
		<-0.894, -1.372, 0.206> <-0.915, -1.372, 0.206> <-0.932, -1.359, 0.219> <-0.932, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.468, 0.436> <-0.894, -1.468, 0.511> <-0.894, -1.425, 0.614> <-0.894, -1.372, 0.667> 
		<-0.915, -1.468, 0.436> <-0.915, -1.468, 0.511> <-0.915, -1.425, 0.614> <-0.915, -1.372, 0.667> 
		<-0.932, -1.449, 0.436> <-0.932, -1.449, 0.502> <-0.932, -1.405, 0.607> <-0.932, -1.359, 0.653> 
		<-0.932, -1.428, 0.436> <-0.932, -1.428, 0.502> <-0.932, -1.390, 0.592> <-0.932, -1.344, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -1.428, 0.436> <-0.932, -1.406, 0.436> <-0.915, -1.387, 0.436> <-0.894, -1.387, 0.436> 
		<-0.932, -1.428, 0.371> <-0.932, -1.406, 0.371> <-0.915, -1.387, 0.380> <-0.894, -1.387, 0.380> 
		<-0.932, -1.390, 0.281> <-0.932, -1.375, 0.296> <-0.915, -1.355, 0.303> <-0.894, -1.355, 0.303> 
		<-0.932, -1.344, 0.234> <-0.932, -1.329, 0.249> <-0.915, -1.316, 0.263> <-0.894, -1.316, 0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -1.428, 0.436> <-0.932, -1.428, 0.502> <-0.932, -1.390, 0.592> <-0.932, -1.344, 0.638> 
		<-0.932, -1.406, 0.436> <-0.932, -1.406, 0.502> <-0.932, -1.375, 0.577> <-0.932, -1.329, 0.623> 
		<-0.915, -1.387, 0.436> <-0.915, -1.387, 0.493> <-0.915, -1.355, 0.570> <-0.915, -1.316, 0.610> 
		<-0.894, -1.387, 0.436> <-0.894, -1.387, 0.493> <-0.894, -1.355, 0.570> <-0.894, -1.316, 0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.387, 0.436> <-0.873, -1.387, 0.436> <-0.856, -1.406, 0.436> <-0.856, -1.428, 0.436> 
		<-0.894, -1.387, 0.380> <-0.873, -1.387, 0.380> <-0.856, -1.406, 0.371> <-0.856, -1.428, 0.371> 
		<-0.894, -1.355, 0.303> <-0.873, -1.355, 0.303> <-0.856, -1.375, 0.296> <-0.856, -1.390, 0.281> 
		<-0.894, -1.316, 0.263> <-0.873, -1.316, 0.263> <-0.856, -1.329, 0.249> <-0.856, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.387, 0.436> <-0.894, -1.387, 0.493> <-0.894, -1.355, 0.570> <-0.894, -1.316, 0.610> 
		<-0.873, -1.387, 0.436> <-0.873, -1.387, 0.493> <-0.873, -1.355, 0.570> <-0.873, -1.316, 0.610> 
		<-0.856, -1.406, 0.436> <-0.856, -1.406, 0.502> <-0.856, -1.375, 0.577> <-0.856, -1.329, 0.623> 
		<-0.856, -1.428, 0.436> <-0.856, -1.428, 0.502> <-0.856, -1.390, 0.592> <-0.856, -1.344, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.372, 0.667> <-0.873, -1.372, 0.667> <-0.856, -1.359, 0.653> <-0.856, -1.344, 0.638> 
		<-0.894, -1.319, 0.720> <-0.873, -1.319, 0.720> <-0.856, -1.313, 0.700> <-0.856, -1.298, 0.685> 
		<-0.894, -1.217, 0.762> <-0.873, -1.217, 0.762> <-0.856, -1.208, 0.743> <-0.856, -1.208, 0.722> 
		<-0.894, -1.142, 0.762> <-0.873, -1.142, 0.762> <-0.856, -1.142, 0.743> <-0.856, -1.142, 0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.372, 0.667> <-0.894, -1.319, 0.720> <-0.894, -1.217, 0.762> <-0.894, -1.142, 0.762> 
		<-0.915, -1.372, 0.667> <-0.915, -1.319, 0.720> <-0.915, -1.217, 0.762> <-0.915, -1.142, 0.762> 
		<-0.932, -1.359, 0.653> <-0.932, -1.313, 0.700> <-0.932, -1.208, 0.743> <-0.932, -1.142, 0.743> 
		<-0.932, -1.344, 0.638> <-0.932, -1.298, 0.685> <-0.932, -1.208, 0.722> <-0.932, -1.142, 0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.142, 0.762> <-0.873, -1.142, 0.762> <-0.856, -1.142, 0.743> <-0.856, -1.142, 0.722> 
		<-0.894, -1.067, 0.762> <-0.873, -1.067, 0.762> <-0.856, -1.076, 0.743> <-0.856, -1.076, 0.722> 
		<-0.894, -0.965, 0.720> <-0.873, -0.965, 0.720> <-0.856, -0.971, 0.700> <-0.856, -0.986, 0.685> 
		<-0.894, -0.912, 0.667> <-0.873, -0.912, 0.667> <-0.856, -0.925, 0.653> <-0.856, -0.940, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.142, 0.762> <-0.894, -1.067, 0.762> <-0.894, -0.965, 0.720> <-0.894, -0.912, 0.667> 
		<-0.915, -1.142, 0.762> <-0.915, -1.067, 0.762> <-0.915, -0.965, 0.720> <-0.915, -0.912, 0.667> 
		<-0.932, -1.142, 0.743> <-0.932, -1.076, 0.743> <-0.932, -0.971, 0.700> <-0.932, -0.925, 0.653> 
		<-0.932, -1.142, 0.722> <-0.932, -1.076, 0.722> <-0.932, -0.986, 0.685> <-0.932, -0.940, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.912, 0.667> <-0.873, -0.912, 0.667> <-0.856, -0.925, 0.653> <-0.856, -0.940, 0.638> 
		<-0.894, -0.859, 0.614> <-0.873, -0.859, 0.614> <-0.856, -0.879, 0.607> <-0.856, -0.894, 0.592> 
		<-0.894, -0.816, 0.511> <-0.873, -0.816, 0.511> <-0.856, -0.835, 0.502> <-0.856, -0.856, 0.502> 
		<-0.894, -0.816, 0.436> <-0.873, -0.816, 0.436> <-0.856, -0.835, 0.436> <-0.856, -0.856, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.912, 0.667> <-0.894, -0.859, 0.614> <-0.894, -0.816, 0.511> <-0.894, -0.816, 0.436> 
		<-0.915, -0.912, 0.667> <-0.915, -0.859, 0.614> <-0.915, -0.816, 0.511> <-0.915, -0.816, 0.436> 
		<-0.932, -0.925, 0.653> <-0.932, -0.879, 0.607> <-0.932, -0.835, 0.502> <-0.932, -0.835, 0.436> 
		<-0.932, -0.940, 0.638> <-0.932, -0.894, 0.592> <-0.932, -0.856, 0.502> <-0.932, -0.856, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.816, 0.436> <-0.873, -0.816, 0.436> <-0.856, -0.835, 0.436> <-0.856, -0.856, 0.436> 
		<-0.894, -0.816, 0.361> <-0.873, -0.816, 0.361> <-0.856, -0.835, 0.371> <-0.856, -0.856, 0.371> 
		<-0.894, -0.859, 0.259> <-0.873, -0.859, 0.259> <-0.856, -0.879, 0.266> <-0.856, -0.894, 0.281> 
		<-0.894, -0.912, 0.206> <-0.873, -0.912, 0.206> <-0.856, -0.925, 0.219> <-0.856, -0.940, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.816, 0.436> <-0.894, -0.816, 0.361> <-0.894, -0.859, 0.259> <-0.894, -0.912, 0.206> 
		<-0.915, -0.816, 0.436> <-0.915, -0.816, 0.361> <-0.915, -0.859, 0.259> <-0.915, -0.912, 0.206> 
		<-0.932, -0.835, 0.436> <-0.932, -0.835, 0.371> <-0.932, -0.879, 0.266> <-0.932, -0.925, 0.219> 
		<-0.932, -0.856, 0.436> <-0.932, -0.856, 0.371> <-0.932, -0.894, 0.281> <-0.932, -0.940, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.912, 0.206> <-0.873, -0.912, 0.206> <-0.856, -0.925, 0.219> <-0.856, -0.940, 0.234> 
		<-0.894, -0.965, 0.153> <-0.873, -0.965, 0.153> <-0.856, -0.971, 0.173> <-0.856, -0.986, 0.188> 
		<-0.894, -1.067, 0.111> <-0.873, -1.067, 0.111> <-0.856, -1.076, 0.129> <-0.856, -1.076, 0.151> 
		<-0.894, -1.142, 0.111> <-0.873, -1.142, 0.111> <-0.856, -1.142, 0.129> <-0.856, -1.142, 0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.912, 0.206> <-0.894, -0.965, 0.153> <-0.894, -1.067, 0.111> <-0.894, -1.142, 0.111> 
		<-0.915, -0.912, 0.206> <-0.915, -0.965, 0.153> <-0.915, -1.067, 0.111> <-0.915, -1.142, 0.111> 
		<-0.932, -0.925, 0.219> <-0.932, -0.971, 0.173> <-0.932, -1.076, 0.129> <-0.932, -1.142, 0.129> 
		<-0.932, -0.940, 0.234> <-0.932, -0.986, 0.188> <-0.932, -1.076, 0.151> <-0.932, -1.142, 0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.142, 0.111> <-0.873, -1.142, 0.111> <-0.856, -1.142, 0.129> <-0.856, -1.142, 0.151> 
		<-0.894, -1.217, 0.111> <-0.873, -1.217, 0.111> <-0.856, -1.208, 0.129> <-0.856, -1.208, 0.151> 
		<-0.894, -1.319, 0.153> <-0.873, -1.319, 0.153> <-0.856, -1.313, 0.173> <-0.856, -1.298, 0.188> 
		<-0.894, -1.372, 0.206> <-0.873, -1.372, 0.206> <-0.856, -1.359, 0.219> <-0.856, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.142, 0.111> <-0.894, -1.217, 0.111> <-0.894, -1.319, 0.153> <-0.894, -1.372, 0.206> 
		<-0.915, -1.142, 0.111> <-0.915, -1.217, 0.111> <-0.915, -1.319, 0.153> <-0.915, -1.372, 0.206> 
		<-0.932, -1.142, 0.129> <-0.932, -1.208, 0.129> <-0.932, -1.313, 0.173> <-0.932, -1.359, 0.219> 
		<-0.932, -1.142, 0.151> <-0.932, -1.208, 0.151> <-0.932, -1.298, 0.188> <-0.932, -1.344, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -1.344, 0.638> <-0.932, -1.298, 0.685> <-0.932, -1.208, 0.722> <-0.932, -1.142, 0.722> 
		<-0.932, -1.329, 0.623> <-0.932, -1.283, 0.670> <-0.932, -1.208, 0.701> <-0.932, -1.142, 0.701> 
		<-0.915, -1.316, 0.610> <-0.915, -1.276, 0.650> <-0.915, -1.198, 0.682> <-0.915, -1.142, 0.682> 
		<-0.894, -1.316, 0.610> <-0.894, -1.276, 0.650> <-0.894, -1.198, 0.682> <-0.894, -1.142, 0.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -1.142, 0.722> <-0.932, -1.076, 0.722> <-0.932, -0.986, 0.685> <-0.932, -0.940, 0.638> 
		<-0.932, -1.142, 0.701> <-0.932, -1.076, 0.701> <-0.932, -1.001, 0.670> <-0.932, -0.955, 0.623> 
		<-0.915, -1.142, 0.682> <-0.915, -1.086, 0.682> <-0.915, -1.008, 0.650> <-0.915, -0.968, 0.610> 
		<-0.894, -1.142, 0.682> <-0.894, -1.086, 0.682> <-0.894, -1.008, 0.650> <-0.894, -0.968, 0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -0.940, 0.638> <-0.932, -0.894, 0.592> <-0.932, -0.856, 0.502> <-0.932, -0.856, 0.436> 
		<-0.932, -0.955, 0.623> <-0.932, -0.909, 0.577> <-0.932, -0.878, 0.502> <-0.932, -0.878, 0.436> 
		<-0.915, -0.968, 0.610> <-0.915, -0.929, 0.570> <-0.915, -0.896, 0.493> <-0.915, -0.896, 0.436> 
		<-0.894, -0.968, 0.610> <-0.894, -0.929, 0.570> <-0.894, -0.896, 0.493> <-0.894, -0.896, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -0.856, 0.436> <-0.932, -0.856, 0.371> <-0.932, -0.894, 0.281> <-0.932, -0.940, 0.234> 
		<-0.932, -0.878, 0.436> <-0.932, -0.878, 0.371> <-0.932, -0.909, 0.296> <-0.932, -0.955, 0.249> 
		<-0.915, -0.896, 0.436> <-0.915, -0.896, 0.380> <-0.915, -0.929, 0.303> <-0.915, -0.968, 0.263> 
		<-0.894, -0.896, 0.436> <-0.894, -0.896, 0.380> <-0.894, -0.929, 0.303> <-0.894, -0.968, 0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -0.940, 0.234> <-0.932, -0.986, 0.188> <-0.932, -1.076, 0.151> <-0.932, -1.142, 0.151> 
		<-0.932, -0.955, 0.249> <-0.932, -1.001, 0.203> <-0.932, -1.076, 0.172> <-0.932, -1.142, 0.172> 
		<-0.915, -0.968, 0.263> <-0.915, -1.008, 0.223> <-0.915, -1.086, 0.191> <-0.915, -1.142, 0.191> 
		<-0.894, -0.968, 0.263> <-0.894, -1.008, 0.223> <-0.894, -1.086, 0.191> <-0.894, -1.142, 0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -1.142, 0.151> <-0.932, -1.208, 0.151> <-0.932, -1.298, 0.188> <-0.932, -1.344, 0.234> 
		<-0.932, -1.142, 0.172> <-0.932, -1.208, 0.172> <-0.932, -1.283, 0.203> <-0.932, -1.329, 0.249> 
		<-0.915, -1.142, 0.191> <-0.915, -1.198, 0.191> <-0.915, -1.276, 0.223> <-0.915, -1.316, 0.263> 
		<-0.894, -1.142, 0.191> <-0.894, -1.198, 0.191> <-0.894, -1.276, 0.223> <-0.894, -1.316, 0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.316, 0.610> <-0.894, -1.276, 0.650> <-0.894, -1.198, 0.682> <-0.894, -1.142, 0.682> 
		<-0.873, -1.316, 0.610> <-0.873, -1.276, 0.650> <-0.873, -1.198, 0.682> <-0.873, -1.142, 0.682> 
		<-0.856, -1.329, 0.623> <-0.856, -1.283, 0.670> <-0.856, -1.208, 0.701> <-0.856, -1.142, 0.701> 
		<-0.856, -1.344, 0.638> <-0.856, -1.298, 0.685> <-0.856, -1.208, 0.722> <-0.856, -1.142, 0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.142, 0.682> <-0.894, -1.086, 0.682> <-0.894, -1.008, 0.650> <-0.894, -0.968, 0.610> 
		<-0.873, -1.142, 0.682> <-0.873, -1.086, 0.682> <-0.873, -1.008, 0.650> <-0.873, -0.968, 0.610> 
		<-0.856, -1.142, 0.701> <-0.856, -1.076, 0.701> <-0.856, -1.001, 0.670> <-0.856, -0.955, 0.623> 
		<-0.856, -1.142, 0.722> <-0.856, -1.076, 0.722> <-0.856, -0.986, 0.685> <-0.856, -0.940, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.968, 0.610> <-0.894, -0.929, 0.570> <-0.894, -0.896, 0.493> <-0.894, -0.896, 0.436> 
		<-0.873, -0.968, 0.610> <-0.873, -0.929, 0.570> <-0.873, -0.896, 0.493> <-0.873, -0.896, 0.436> 
		<-0.856, -0.955, 0.623> <-0.856, -0.909, 0.577> <-0.856, -0.878, 0.502> <-0.856, -0.878, 0.436> 
		<-0.856, -0.940, 0.638> <-0.856, -0.894, 0.592> <-0.856, -0.856, 0.502> <-0.856, -0.856, 0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.896, 0.436> <-0.894, -0.896, 0.380> <-0.894, -0.929, 0.303> <-0.894, -0.968, 0.263> 
		<-0.873, -0.896, 0.436> <-0.873, -0.896, 0.380> <-0.873, -0.929, 0.303> <-0.873, -0.968, 0.263> 
		<-0.856, -0.878, 0.436> <-0.856, -0.878, 0.371> <-0.856, -0.909, 0.296> <-0.856, -0.955, 0.249> 
		<-0.856, -0.856, 0.436> <-0.856, -0.856, 0.371> <-0.856, -0.894, 0.281> <-0.856, -0.940, 0.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -0.968, 0.263> <-0.894, -1.008, 0.223> <-0.894, -1.086, 0.191> <-0.894, -1.142, 0.191> 
		<-0.873, -0.968, 0.263> <-0.873, -1.008, 0.223> <-0.873, -1.086, 0.191> <-0.873, -1.142, 0.191> 
		<-0.856, -0.955, 0.249> <-0.856, -1.001, 0.203> <-0.856, -1.076, 0.172> <-0.856, -1.142, 0.172> 
		<-0.856, -0.940, 0.234> <-0.856, -0.986, 0.188> <-0.856, -1.076, 0.151> <-0.856, -1.142, 0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, -1.142, 0.191> <-0.894, -1.198, 0.191> <-0.894, -1.276, 0.223> <-0.894, -1.316, 0.263> 
		<-0.873, -1.142, 0.191> <-0.873, -1.198, 0.191> <-0.873, -1.276, 0.223> <-0.873, -1.316, 0.263> 
		<-0.856, -1.142, 0.172> <-0.856, -1.208, 0.172> <-0.856, -1.283, 0.203> <-0.856, -1.329, 0.249> 
		<-0.856, -1.142, 0.151> <-0.856, -1.208, 0.151> <-0.856, -1.298, 0.188> <-0.856, -1.344, 0.234> 
	}
        
        texture {textCubiertas}
} 


#declare Fuselaje = union {
                           bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.605, 0.000> <0.128, 0.605, 0.000> <0.306, 0.538, 0.000> <0.399, 0.449, 0.000> 
		<-0.000, 0.613, 0.323> <0.128, 0.613, 0.323> <0.305, 0.520, 0.323> <0.397, 0.431, 0.323> 
		<-0.000, 0.624, 0.740> <0.001, 0.623, 0.737> <0.306, 0.514, 0.754> <0.395, 0.407, 0.754> 
		<-0.000, 0.633, 1.077> <0.001, 0.632, 1.074> <0.304, 0.495, 1.077> <0.393, 0.388, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.605, 0.000> <-0.000, 0.613, 0.323> <-0.000, 0.624, 0.740> <-0.000, 0.633, 1.077> 
		<-0.128, 0.605, 0.000> <-0.128, 0.613, 0.323> <-0.007, 0.616, 0.720> <-0.007, 0.625, 1.057> 
		<-0.304, 0.537, 0.000> <-0.298, 0.515, 0.323> <-0.293, 0.499, 0.754> <-0.287, 0.480, 1.077> 
		<-0.396, 0.448, 0.000> <-0.390, 0.426, 0.323> <-0.381, 0.395, 0.754> <-0.375, 0.376, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.399, 0.449, 0.000> <0.490, 0.360, 0.000> <0.562, 0.186, 0.000> <0.562, 0.059, 0.000> 
		<0.397, 0.431, 0.323> <0.488, 0.342, 0.323> <0.551, 0.168, 0.323> <0.552, 0.041, 0.323> 
		<0.395, 0.407, 0.754> <0.474, 0.312, 0.754> <0.540, 0.137, 0.754> <0.538, 0.014, 0.754> 
		<0.393, 0.388, 1.077> <0.472, 0.294, 1.077> <0.530, 0.123, 1.077> <0.527, 0.000, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.562, 0.059, 0.000> <0.563, -0.064, 0.000> <0.493, -0.236, 0.000> <0.401, -0.317, 0.000> 
		<0.552, 0.041, 0.323> <0.552, -0.081, 0.323> <0.485, -0.261, 0.323> <0.393, -0.342, 0.323> 
		<0.538, 0.014, 0.754> <0.535, -0.115, 0.754> <0.477, -0.295, 0.753> <0.381, -0.380, 0.753> 
		<0.527, 0.000, 1.077> <0.524, -0.128, 1.077> <0.471, -0.316, 1.077> <0.375, -0.400, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, -0.317, 0.000> <0.308, -0.399, 0.000> <-0.012, -0.438, 0.000> <0.004, -0.433, 0.000> 
		<0.393, -0.342, 0.323> <0.300, -0.424, 0.323> <-0.012, -0.438, 0.045> <0.004, -0.433, 0.045> 
		<0.381, -0.380, 0.753> <0.295, -0.455, 0.753> <0.115, -0.455, 0.754> <0.001, -0.455, 0.754> 
		<0.375, -0.400, 1.077> <0.289, -0.475, 1.077> <0.114, -0.460, 1.077> <-0.000, -0.460, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.401, -0.317, 0.000> <0.308, -0.399, 0.000> <-0.012, -0.438, 0.000> <0.004, -0.433, 0.000> 
		<0.393, -0.342, 0.323> <0.300, -0.424, 0.323> <-0.012, -0.438, 0.045> <0.004, -0.433, 0.045> 
		<0.381, -0.380, 0.753> <0.295, -0.455, 0.753> <0.115, -0.455, 0.754> <0.001, -0.455, 0.754> 
		<0.375, -0.400, 1.077> <0.289, -0.475, 1.077> <0.114, -0.460, 1.077> <-0.000, -0.460, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, -0.433, 0.000> <0.021, -0.438, 0.000> <-0.308, -0.407, 0.000> <-0.403, -0.323, 0.000> 
		<0.004, -0.433, 0.045> <0.021, -0.438, 0.045> <-0.300, -0.430, 0.323> <-0.395, -0.346, 0.323> 
		<0.001, -0.455, 0.754> <-0.113, -0.455, 0.754> <-0.295, -0.457, 0.753> <-0.381, -0.383, 0.753> 
		<-0.000, -0.460, 1.077> <-0.114, -0.460, 1.077> <-0.288, -0.474, 1.077> <-0.375, -0.400, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, -0.433, 0.000> <0.021, -0.438, 0.000> <-0.308, -0.407, 0.000> <-0.403, -0.323, 0.000> 
		<0.004, -0.433, 0.045> <0.021, -0.438, 0.045> <-0.300, -0.430, 0.323> <-0.395, -0.346, 0.323> 
		<0.001, -0.455, 0.754> <-0.113, -0.455, 0.754> <-0.295, -0.457, 0.753> <-0.381, -0.383, 0.753> 
		<-0.000, -0.460, 1.077> <-0.114, -0.460, 1.077> <-0.288, -0.474, 1.077> <-0.375, -0.400, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.393, 0.388, 1.077> <0.392, 0.383, 1.175> <0.389, 0.372, 1.322> <0.387, 0.367, 1.404> 
		<0.304, 0.495, 1.077> <0.303, 0.489, 1.175> <0.369, 0.412, 1.322> <0.367, 0.407, 1.405> 
		<0.001, 0.632, 1.074> <-0.000, 0.633, 1.077> <0.288, 0.487, 1.155> <0.288, 0.472, 1.405> 
		<-0.000, 0.633, 1.077> <-0.001, 0.633, 1.080> <0.265, 0.513, 1.156> <0.264, 0.497, 1.405> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.393, 0.388, 1.077> <0.472, 0.294, 1.077> <0.530, 0.123, 1.077> <0.527, 0.000, 1.077> 
		<0.392, 0.383, 1.175> <0.471, 0.288, 1.175> <0.527, 0.119, 1.175> <0.524, -0.004, 1.175> 
		<0.389, 0.372, 1.322> <0.433, 0.285, 1.322> <0.524, 0.117, 1.306> <0.523, 0.000, 1.306> 
		<0.387, 0.367, 1.404> <0.432, 0.280, 1.404> <0.519, 0.117, 1.404> <0.517, 0.000, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.527, 0.000, 1.077> <0.524, -0.128, 1.077> <0.471, -0.316, 1.077> <0.375, -0.400, 1.077> 
		<0.524, -0.004, 1.175> <0.521, -0.133, 1.175> <0.470, -0.322, 1.175> <0.373, -0.406, 1.175> 
		<0.523, 0.000, 1.306> <0.520, -0.129, 1.306> <0.418, -0.283, 1.306> <0.375, -0.404, 1.306> 
		<0.517, 0.000, 1.404> <0.515, -0.129, 1.404> <0.418, -0.284, 1.404> <0.375, -0.406, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, -0.400, 1.077> <0.289, -0.475, 1.077> <0.114, -0.460, 1.077> <-0.000, -0.460, 1.077> 
		<0.373, -0.406, 1.175> <0.287, -0.481, 1.175> <0.113, -0.461, 1.175> <-0.000, -0.461, 1.175> 
		<0.375, -0.404, 1.306> <0.262, -0.419, 1.306> <0.113, -0.463, 1.306> <-0.000, -0.462, 1.306> 
		<0.375, -0.406, 1.404> <0.263, -0.421, 1.404> <0.113, -0.455, 1.404> <-0.000, -0.454, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, -0.400, 1.077> <0.289, -0.475, 1.077> <0.114, -0.460, 1.077> <-0.000, -0.460, 1.077> 
		<0.373, -0.406, 1.175> <0.287, -0.481, 1.175> <0.113, -0.461, 1.175> <-0.000, -0.461, 1.175> 
		<0.375, -0.404, 1.306> <0.262, -0.419, 1.306> <0.113, -0.463, 1.306> <-0.000, -0.462, 1.306> 
		<0.375, -0.406, 1.404> <0.263, -0.421, 1.404> <0.113, -0.455, 1.404> <-0.000, -0.454, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, -0.460, 1.077> <-0.114, -0.460, 1.077> <-0.288, -0.474, 1.077> <-0.375, -0.400, 1.077> 
		<-0.000, -0.461, 1.175> <-0.114, -0.461, 1.175> <-0.286, -0.480, 1.175> <-0.373, -0.406, 1.175> 
		<-0.000, -0.462, 1.306> <-0.114, -0.461, 1.306> <-0.263, -0.416, 1.306> <-0.375, -0.399, 1.306> 
		<-0.000, -0.454, 1.404> <-0.114, -0.453, 1.404> <-0.263, -0.415, 1.404> <-0.375, -0.399, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, -0.460, 1.077> <-0.114, -0.460, 1.077> <-0.288, -0.474, 1.077> <-0.375, -0.400, 1.077> 
		<-0.000, -0.461, 1.175> <-0.114, -0.461, 1.175> <-0.286, -0.480, 1.175> <-0.373, -0.406, 1.175> 
		<-0.000, -0.462, 1.306> <-0.114, -0.461, 1.306> <-0.263, -0.416, 1.306> <-0.375, -0.399, 1.306> 
		<-0.000, -0.454, 1.404> <-0.114, -0.453, 1.404> <-0.263, -0.415, 1.404> <-0.375, -0.399, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.387, 0.367, 1.404> <0.386, 0.362, 1.482> <0.386, 0.349, 1.622> <0.380, 0.351, 1.715> 
		<0.367, 0.407, 1.405> <0.365, 0.402, 1.482> <0.300, 0.453, 1.622> <0.293, 0.455, 1.715> 
		<0.288, 0.472, 1.405> <0.288, 0.458, 1.641> <-0.000, 0.593, 1.718> <0.012, 0.578, 1.749> 
		<0.264, 0.497, 1.405> <0.264, 0.483, 1.642> <-0.013, 0.609, 1.684> <-0.001, 0.594, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.387, 0.367, 1.404> <0.432, 0.280, 1.404> <0.519, 0.117, 1.404> <0.517, 0.000, 1.404> 
		<0.386, 0.362, 1.482> <0.430, 0.275, 1.482> <0.514, 0.117, 1.498> <0.513, 0.000, 1.498> 
		<0.386, 0.349, 1.622> <0.457, 0.264, 1.622> <0.508, 0.101, 1.622> <0.504, -0.009, 1.622> 
		<0.380, 0.351, 1.715> <0.451, 0.266, 1.714> <0.498, 0.111, 1.715> <0.494, 0.000, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 0.000, 1.404> <0.515, -0.129, 1.404> <0.418, -0.284, 1.404> <0.375, -0.406, 1.404> 
		<0.513, 0.000, 1.498> <0.511, -0.129, 1.498> <0.412, -0.264, 1.497> <0.370, -0.386, 1.497> 
		<0.504, -0.009, 1.622> <0.500, -0.119, 1.622> <0.403, -0.257, 1.622> <0.362, -0.359, 1.622> 
		<0.494, 0.000, 1.715> <0.490, -0.110, 1.715> <0.398, -0.237, 1.715> <0.357, -0.339, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, -0.406, 1.404> <0.263, -0.421, 1.404> <0.113, -0.455, 1.404> <-0.000, -0.454, 1.404> 
		<0.370, -0.386, 1.497> <0.257, -0.400, 1.497> <0.113, -0.448, 1.498> <-0.000, -0.447, 1.498> 
		<0.362, -0.359, 1.622> <0.255, -0.380, 1.622> <0.109, -0.427, 1.622> <-0.000, -0.428, 1.622> 
		<0.357, -0.339, 1.715> <0.250, -0.360, 1.715> <0.109, -0.408, 1.715> <-0.000, -0.409, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, -0.406, 1.404> <0.263, -0.421, 1.404> <0.113, -0.455, 1.404> <-0.000, -0.454, 1.404> 
		<0.370, -0.386, 1.497> <0.257, -0.400, 1.497> <0.113, -0.448, 1.498> <-0.000, -0.447, 1.498> 
		<0.362, -0.359, 1.622> <0.255, -0.380, 1.622> <0.109, -0.427, 1.622> <-0.000, -0.428, 1.622> 
		<0.357, -0.339, 1.715> <0.250, -0.360, 1.715> <0.109, -0.408, 1.715> <-0.000, -0.409, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, -0.454, 1.404> <-0.114, -0.453, 1.404> <-0.263, -0.415, 1.404> <-0.375, -0.399, 1.404> 
		<-0.000, -0.447, 1.498> <-0.114, -0.446, 1.498> <-0.257, -0.399, 1.497> <-0.370, -0.382, 1.497> 
		<-0.000, -0.428, 1.622> <-0.109, -0.428, 1.622> <-0.255, -0.380, 1.622> <-0.362, -0.361, 1.622> 
		<-0.000, -0.409, 1.715> <-0.109, -0.410, 1.715> <-0.250, -0.364, 1.715> <-0.357, -0.344, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, -0.454, 1.404> <-0.114, -0.453, 1.404> <-0.263, -0.415, 1.404> <-0.375, -0.399, 1.404> 
		<-0.000, -0.447, 1.498> <-0.114, -0.446, 1.498> <-0.257, -0.399, 1.497> <-0.370, -0.382, 1.497> 
		<-0.000, -0.428, 1.622> <-0.109, -0.428, 1.622> <-0.255, -0.380, 1.622> <-0.362, -0.361, 1.622> 
		<-0.000, -0.409, 1.715> <-0.109, -0.410, 1.715> <-0.250, -0.364, 1.715> <-0.357, -0.344, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.380, 0.351, 1.715> <0.451, 0.266, 1.714> <0.498, 0.111, 1.715> <0.494, 0.000, 1.715> 
		<0.326, 0.364, 2.489> <0.397, 0.279, 2.489> <0.415, 0.189, 2.490> <0.412, 0.078, 2.490> 
		<0.244, 0.396, 3.520> <0.251, 0.359, 3.520> <0.306, 0.247, 3.521> <0.306, 0.209, 3.521> 
		<0.186, 0.416, 4.294> <0.193, 0.378, 4.294> <0.210, 0.329, 4.294> <0.210, 0.291, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.380, 0.351, 1.715> <0.326, 0.364, 2.489> <0.244, 0.396, 3.520> <0.186, 0.416, 4.294> 
		<0.293, 0.455, 1.715> <0.239, 0.468, 2.489> <0.188, 0.406, 3.520> <0.130, 0.425, 4.294> 
		<0.012, 0.578, 1.749> <0.012, 0.498, 3.154> <0.057, 0.488, 3.520> <0.057, 0.447, 4.294> 
		<-0.001, 0.594, 1.715> <-0.000, 0.514, 3.121> <-0.000, 0.488, 3.520> <-0.000, 0.447, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.494, 0.000, 1.715> <0.490, -0.110, 1.715> <0.398, -0.237, 1.715> <0.357, -0.339, 1.715> 
		<0.412, 0.078, 2.490> <0.408, -0.032, 2.490> <0.347, -0.085, 2.488> <0.305, -0.187, 2.488> 
		<0.306, 0.209, 3.521> <0.306, 0.171, 3.521> <0.244, 0.053, 3.520> <0.237, 0.016, 3.520> 
		<0.210, 0.291, 4.294> <0.210, 0.253, 4.294> <0.193, 0.205, 4.294> <0.186, 0.168, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.357, -0.339, 1.715> <0.250, -0.360, 1.715> <0.109, -0.408, 1.715> <-0.000, -0.409, 1.715> 
		<0.305, -0.187, 2.488> <0.198, -0.208, 2.488> <0.109, -0.255, 2.489> <-0.000, -0.256, 2.489> 
		<0.237, 0.016, 3.520> <0.181, 0.001, 3.520> <0.058, -0.040, 3.520> <-0.000, -0.040, 3.520> 
		<0.186, 0.168, 4.294> <0.130, 0.153, 4.294> <0.058, 0.118, 4.294> <-0.000, 0.118, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.357, -0.339, 1.715> <0.250, -0.360, 1.715> <0.109, -0.408, 1.715> <-0.000, -0.409, 1.715> 
		<0.305, -0.187, 2.488> <0.198, -0.208, 2.488> <0.109, -0.255, 2.489> <-0.000, -0.256, 2.489> 
		<0.237, 0.016, 3.520> <0.181, 0.001, 3.520> <0.058, -0.042, 3.521> <-0.000, -0.043, 3.521> 
		<0.186, 0.168, 4.294> <0.130, 0.153, 4.294> <0.058, 0.118, 4.294> <-0.000, 0.118, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, -0.409, 1.715> <-0.109, -0.410, 1.715> <-0.250, -0.364, 1.715> <-0.357, -0.344, 1.715> 
		<-0.000, -0.256, 2.489> <-0.109, -0.257, 2.489> <-0.199, -0.211, 2.488> <-0.305, -0.191, 2.488> 
		<-0.000, -0.040, 3.520> <-0.058, -0.041, 3.520> <-0.181, -0.001, 3.520> <-0.237, 0.013, 3.520> 
		<-0.000, 0.118, 4.294> <-0.058, 0.118, 4.294> <-0.130, 0.152, 4.294> <-0.186, 0.166, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, -0.409, 1.715> <-0.109, -0.410, 1.715> <-0.250, -0.364, 1.715> <-0.357, -0.344, 1.715> 
		<-0.000, -0.256, 2.489> <-0.109, -0.257, 2.489> <-0.199, -0.211, 2.488> <-0.305, -0.191, 2.488> 
		<-0.000, -0.043, 3.521> <-0.058, -0.043, 3.521> <-0.181, -0.001, 3.520> <-0.237, 0.013, 3.520> 
		<-0.000, 0.118, 4.294> <-0.058, 0.118, 4.294> <-0.130, 0.152, 4.294> <-0.186, 0.166, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.594, 1.715> <0.001, 0.597, 1.709> <-0.273, 0.449, 1.715> <-0.357, 0.351, 1.715> 
		<-0.003, 0.591, 1.721> <-0.001, 0.594, 1.715> <-0.279, 0.447, 1.622> <-0.363, 0.349, 1.622> 
		<-0.256, 0.484, 1.634> <-0.290, 0.444, 1.634> <-0.341, 0.411, 1.498> <-0.367, 0.362, 1.498> 
		<-0.256, 0.497, 1.405> <-0.290, 0.458, 1.405> <-0.344, 0.415, 1.405> <-0.370, 0.365, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.594, 1.715> <-0.000, 0.514, 3.121> <-0.000, 0.488, 3.520> <-0.000, 0.447, 4.294> 
		<0.001, 0.597, 1.709> <0.002, 0.517, 3.115> <-0.057, 0.488, 3.520> <-0.057, 0.447, 4.294> 
		<-0.273, 0.449, 1.715> <-0.224, 0.463, 2.489> <-0.181, 0.406, 3.520> <-0.130, 0.425, 4.294> 
		<-0.357, 0.351, 1.715> <-0.307, 0.364, 2.489> <-0.237, 0.396, 3.520> <-0.186, 0.416, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.633, 1.077> <0.007, 0.640, 1.096> <-0.255, 0.512, 1.163> <-0.256, 0.497, 1.405> 
		<-0.007, 0.625, 1.057> <-0.000, 0.632, 1.076> <-0.290, 0.473, 1.163> <-0.290, 0.458, 1.405> 
		<-0.287, 0.480, 1.077> <-0.285, 0.474, 1.175> <-0.347, 0.419, 1.306> <-0.344, 0.415, 1.405> 
		<-0.375, 0.376, 1.077> <-0.373, 0.370, 1.175> <-0.373, 0.369, 1.306> <-0.370, 0.365, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.396, 0.448, 0.000> <-0.390, 0.426, 0.323> <-0.381, 0.395, 0.754> <-0.375, 0.376, 1.077> 
		<-0.486, 0.360, 0.000> <-0.479, 0.339, 0.323> <-0.460, 0.301, 0.754> <-0.454, 0.282, 1.077> 
		<-0.555, 0.188, 0.000> <-0.549, 0.169, 0.323> <-0.543, 0.137, 0.754> <-0.535, 0.123, 1.077> 
		<-0.556, 0.063, 0.000> <-0.550, 0.044, 0.323> <-0.543, 0.014, 0.754> <-0.535, 0.000, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.556, 0.063, 0.000> <-0.550, 0.044, 0.323> <-0.543, 0.014, 0.754> <-0.535, 0.000, 1.077> 
		<-0.558, -0.062, 0.000> <-0.551, -0.081, 0.323> <-0.543, -0.115, 0.754> <-0.535, -0.129, 1.077> 
		<-0.497, -0.241, 0.000> <-0.488, -0.264, 0.323> <-0.479, -0.299, 0.753> <-0.473, -0.316, 1.077> 
		<-0.403, -0.323, 0.000> <-0.395, -0.346, 0.323> <-0.381, -0.383, 0.753> <-0.375, -0.400, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.375, 0.376, 1.077> <-0.373, 0.370, 1.175> <-0.373, 0.369, 1.306> <-0.370, 0.365, 1.404> 
		<-0.454, 0.282, 1.077> <-0.452, 0.277, 1.175> <-0.432, 0.258, 1.306> <-0.429, 0.254, 1.404> 
		<-0.535, 0.123, 1.077> <-0.532, 0.118, 1.175> <-0.522, 0.118, 1.306> <-0.518, 0.118, 1.404> 
		<-0.535, 0.000, 1.077> <-0.532, -0.004, 1.175> <-0.523, 0.000, 1.306> <-0.519, 0.000, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.535, 0.000, 1.077> <-0.532, -0.004, 1.175> <-0.523, 0.000, 1.306> <-0.519, 0.000, 1.404> 
		<-0.535, -0.129, 1.077> <-0.532, -0.134, 1.175> <-0.524, -0.127, 1.306> <-0.520, -0.127, 1.404> 
		<-0.473, -0.316, 1.077> <-0.471, -0.321, 1.175> <-0.418, -0.279, 1.306> <-0.418, -0.279, 1.404> 
		<-0.375, -0.400, 1.077> <-0.373, -0.406, 1.175> <-0.375, -0.399, 1.306> <-0.375, -0.399, 1.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.370, 0.365, 1.404> <-0.367, 0.362, 1.498> <-0.363, 0.349, 1.622> <-0.357, 0.351, 1.715> 
		<-0.429, 0.254, 1.404> <-0.426, 0.250, 1.497> <-0.437, 0.262, 1.621> <-0.431, 0.264, 1.714> 
		<-0.518, 0.118, 1.404> <-0.514, 0.118, 1.497> <-0.517, 0.105, 1.622> <-0.507, 0.114, 1.715> 
		<-0.519, 0.000, 1.404> <-0.515, 0.000, 1.497> <-0.517, -0.009, 1.622> <-0.507, 0.000, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.519, 0.000, 1.404> <-0.515, 0.000, 1.497> <-0.517, -0.009, 1.622> <-0.507, 0.000, 1.715> 
		<-0.520, -0.127, 1.404> <-0.516, -0.127, 1.497> <-0.517, -0.122, 1.622> <-0.507, -0.113, 1.715> 
		<-0.418, -0.279, 1.404> <-0.413, -0.263, 1.497> <-0.407, -0.257, 1.622> <-0.402, -0.241, 1.715> 
		<-0.375, -0.399, 1.404> <-0.370, -0.382, 1.497> <-0.362, -0.361, 1.622> <-0.357, -0.344, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.357, 0.351, 1.715> <-0.307, 0.364, 2.489> <-0.237, 0.396, 3.520> <-0.186, 0.416, 4.294> 
		<-0.431, 0.264, 1.714> <-0.382, 0.277, 2.489> <-0.244, 0.359, 3.520> <-0.193, 0.378, 4.294> 
		<-0.507, 0.114, 1.715> <-0.424, 0.193, 2.490> <-0.307, 0.246, 3.521> <-0.210, 0.329, 4.294> 
		<-0.507, 0.000, 1.715> <-0.424, 0.078, 2.490> <-0.307, 0.208, 3.521> <-0.210, 0.291, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 0.000, 1.715> <-0.424, 0.078, 2.490> <-0.307, 0.208, 3.521> <-0.210, 0.291, 4.294> 
		<-0.507, -0.113, 1.715> <-0.424, -0.035, 2.490> <-0.307, 0.170, 3.521> <-0.210, 0.253, 4.294> 
		<-0.402, -0.241, 1.715> <-0.351, -0.088, 2.488> <-0.244, 0.050, 3.520> <-0.193, 0.204, 4.294> 
		<-0.357, -0.344, 1.715> <-0.305, -0.191, 2.488> <-0.237, 0.013, 3.520> <-0.186, 0.166, 4.294> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.118, 4.294> <-0.058, 0.118, 4.294> <-0.130, 0.152, 4.294> <-0.186, 0.166, 4.294> 
		<-0.000, 0.153, 4.464> <-0.058, 0.153, 4.464> <-0.101, 0.183, 4.464> <-0.157, 0.197, 4.464> 
		<0.001, 0.198, 4.691> <-0.027, 0.199, 4.691> <-0.104, 0.220, 4.691> <-0.125, 0.237, 4.691> 
		<0.001, 0.243, 4.859> <-0.027, 0.244, 4.859> <-0.067, 0.253, 4.859> <-0.088, 0.270, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.118, 4.294> <-0.000, 0.153, 4.464> <0.001, 0.198, 4.691> <0.001, 0.243, 4.859> 
		<0.058, 0.118, 4.294> <0.058, 0.153, 4.464> <0.025, 0.197, 4.691> <0.025, 0.243, 4.859> 
		<0.130, 0.153, 4.294> <0.098, 0.182, 4.464> <0.095, 0.217, 4.690> <0.060, 0.249, 4.859> 
		<0.186, 0.168, 4.294> <0.154, 0.197, 4.464> <0.113, 0.233, 4.690> <0.078, 0.265, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.168, 4.294> <0.154, 0.197, 4.464> <0.113, 0.233, 4.690> <0.078, 0.265, 4.859> 
		<0.193, 0.205, 4.294> <0.161, 0.234, 4.464> <0.129, 0.247, 4.690> <0.094, 0.280, 4.859> 
		<0.210, 0.253, 4.294> <0.189, 0.271, 4.465> <0.145, 0.298, 4.692> <0.101, 0.312, 4.859> 
		<0.210, 0.291, 4.294> <0.189, 0.309, 4.465> <0.145, 0.320, 4.692> <0.102, 0.334, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.210, 0.291, 4.294> <0.189, 0.309, 4.465> <0.145, 0.320, 4.692> <0.102, 0.334, 4.859> 
		<0.210, 0.329, 4.294> <0.189, 0.347, 4.465> <0.146, 0.344, 4.692> <0.103, 0.358, 4.859> 
		<0.193, 0.378, 4.294> <0.162, 0.377, 4.464> <0.140, 0.400, 4.691> <0.100, 0.396, 4.859> 
		<0.186, 0.416, 4.294> <0.155, 0.415, 4.464> <0.121, 0.416, 4.691> <0.082, 0.413, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.416, 4.294> <0.155, 0.415, 4.464> <0.121, 0.416, 4.691> <0.082, 0.413, 4.859> 
		<0.130, 0.425, 4.294> <0.099, 0.424, 4.464> <0.103, 0.433, 4.691> <0.063, 0.430, 4.859> 
		<0.057, 0.447, 4.294> <0.057, 0.438, 4.463> <0.024, 0.439, 4.690> <0.024, 0.427, 4.859> 
		<-0.000, 0.447, 4.294> <-0.000, 0.438, 4.463> <-0.001, 0.438, 4.690> <-0.001, 0.427, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.447, 4.294> <-0.000, 0.438, 4.463> <-0.001, 0.438, 4.690> <-0.001, 0.427, 4.859> 
		<-0.057, 0.447, 4.294> <-0.057, 0.438, 4.463> <-0.027, 0.438, 4.690> <-0.026, 0.426, 4.859> 
		<-0.130, 0.425, 4.294> <-0.100, 0.424, 4.464> <-0.105, 0.430, 4.691> <-0.064, 0.426, 4.859> 
		<-0.186, 0.416, 4.294> <-0.156, 0.414, 4.464> <-0.124, 0.414, 4.691> <-0.084, 0.410, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.186, 0.416, 4.294> <-0.156, 0.414, 4.464> <-0.124, 0.414, 4.691> <-0.084, 0.410, 4.859> 
		<-0.193, 0.378, 4.294> <-0.163, 0.377, 4.464> <-0.143, 0.399, 4.691> <-0.103, 0.395, 4.859> 
		<-0.210, 0.329, 4.294> <-0.189, 0.347, 4.464> <-0.156, 0.346, 4.693> <-0.112, 0.360, 4.859> 
		<-0.210, 0.291, 4.294> <-0.189, 0.309, 4.464> <-0.157, 0.322, 4.693> <-0.113, 0.336, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, 0.291, 4.294> <-0.189, 0.309, 4.464> <-0.157, 0.322, 4.693> <-0.113, 0.336, 4.859> 
		<-0.210, 0.253, 4.294> <-0.189, 0.271, 4.464> <-0.158, 0.301, 4.693> <-0.114, 0.315, 4.859> 
		<-0.193, 0.204, 4.294> <-0.164, 0.235, 4.464> <-0.141, 0.251, 4.691> <-0.105, 0.284, 4.859> 
		<-0.186, 0.166, 4.294> <-0.157, 0.197, 4.464> <-0.125, 0.237, 4.691> <-0.088, 0.270, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.243, 4.859> <-0.027, 0.244, 4.859> <-0.067, 0.253, 4.859> <-0.088, 0.270, 4.859> 
		<0.001, 0.250, 4.883> <-0.027, 0.251, 4.883> <-0.061, 0.258, 4.883> <-0.083, 0.275, 4.883> 
		<0.000, 0.276, 4.908> <-0.014, 0.276, 4.908> <-0.045, 0.285, 4.908> <-0.059, 0.285, 4.908> 
		<-0.000, 0.289, 4.929> <-0.014, 0.290, 4.929> <-0.032, 0.291, 4.929> <-0.046, 0.292, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.243, 4.859> <0.001, 0.250, 4.883> <0.000, 0.276, 4.908> <-0.000, 0.289, 4.929> 
		<0.025, 0.243, 4.859> <0.025, 0.249, 4.883> <0.016, 0.276, 4.908> <0.016, 0.290, 4.929> 
		<0.060, 0.249, 4.859> <0.055, 0.254, 4.881> <0.045, 0.283, 4.908> <0.037, 0.291, 4.929> 
		<0.078, 0.265, 4.859> <0.073, 0.270, 4.881> <0.061, 0.284, 4.908> <0.053, 0.292, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.078, 0.265, 4.859> <0.073, 0.270, 4.881> <0.061, 0.284, 4.908> <0.053, 0.292, 4.929> 
		<0.094, 0.280, 4.859> <0.089, 0.285, 4.881> <0.058, 0.300, 4.908> <0.051, 0.308, 4.929> 
		<0.101, 0.312, 4.859> <0.095, 0.314, 4.885> <0.065, 0.325, 4.908> <0.048, 0.329, 4.929> 
		<0.102, 0.334, 4.859> <0.095, 0.336, 4.885> <0.063, 0.341, 4.908> <0.046, 0.344, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.334, 4.859> <0.095, 0.336, 4.885> <0.063, 0.341, 4.908> <0.046, 0.344, 4.929> 
		<0.103, 0.358, 4.859> <0.096, 0.361, 4.885> <0.060, 0.359, 4.909> <0.043, 0.362, 4.930> 
		<0.100, 0.396, 4.859> <0.094, 0.396, 4.884> <0.053, 0.389, 4.909> <0.039, 0.386, 4.930> 
		<0.082, 0.413, 4.859> <0.076, 0.412, 4.884> <0.050, 0.406, 4.909> <0.037, 0.404, 4.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.413, 4.859> <0.076, 0.412, 4.884> <0.050, 0.406, 4.909> <0.037, 0.404, 4.931> 
		<0.063, 0.430, 4.859> <0.057, 0.429, 4.884> <0.040, 0.406, 4.909> <0.026, 0.404, 4.930> 
		<0.024, 0.427, 4.859> <0.024, 0.426, 4.881> <0.011, 0.411, 4.909> <0.012, 0.404, 4.930> 
		<-0.001, 0.427, 4.859> <-0.001, 0.425, 4.881> <0.001, 0.411, 4.908> <0.002, 0.404, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.427, 4.859> <-0.001, 0.425, 4.881> <0.001, 0.411, 4.908> <0.002, 0.404, 4.929> 
		<-0.026, 0.426, 4.859> <-0.026, 0.425, 4.881> <-0.009, 0.410, 4.908> <-0.009, 0.403, 4.929> 
		<-0.064, 0.426, 4.859> <-0.058, 0.426, 4.884> <-0.038, 0.405, 4.908> <-0.023, 0.402, 4.929> 
		<-0.084, 0.410, 4.859> <-0.078, 0.410, 4.884> <-0.048, 0.404, 4.908> <-0.033, 0.401, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 0.410, 4.859> <-0.078, 0.410, 4.884> <-0.048, 0.404, 4.908> <-0.033, 0.401, 4.929> 
		<-0.103, 0.395, 4.859> <-0.097, 0.395, 4.884> <-0.051, 0.387, 4.908> <-0.035, 0.384, 4.929> 
		<-0.112, 0.360, 4.859> <-0.104, 0.362, 4.888> <-0.060, 0.359, 4.908> <-0.038, 0.361, 4.929> 
		<-0.113, 0.336, 4.859> <-0.105, 0.338, 4.888> <-0.062, 0.341, 4.908> <-0.041, 0.343, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.113, 0.336, 4.859> <-0.105, 0.338, 4.888> <-0.062, 0.341, 4.908> <-0.041, 0.343, 4.929> 
		<-0.114, 0.315, 4.859> <-0.106, 0.317, 4.888> <-0.064, 0.326, 4.908> <-0.042, 0.328, 4.929> 
		<-0.105, 0.284, 4.859> <-0.099, 0.289, 4.883> <-0.057, 0.301, 4.908> <-0.045, 0.307, 4.929> 
		<-0.088, 0.270, 4.859> <-0.083, 0.275, 4.883> <-0.059, 0.285, 4.908> <-0.046, 0.292, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 0.343, 4.929> <-0.041, 0.343, 4.929> <-0.041, 0.343, 4.929> <-0.041, 0.343, 4.929> 
		<-0.042, 0.328, 4.929> <-0.040, 0.345, 4.929> <-0.040, 0.345, 4.929> <-0.038, 0.361, 4.929> 
		<-0.045, 0.307, 4.929> <-0.041, 0.340, 4.929> <-0.039, 0.351, 4.929> <-0.035, 0.384, 4.929> 
		<-0.046, 0.292, 4.929> <-0.042, 0.325, 4.929> <-0.037, 0.369, 4.929> <-0.033, 0.401, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.046, 0.344, 4.929> <0.046, 0.344, 4.929> <0.046, 0.344, 4.929> <0.046, 0.344, 4.929> 
		<0.043, 0.362, 4.930> <0.045, 0.346, 4.930> <0.045, 0.346, 4.930> <0.048, 0.329, 4.929> 
		<0.039, 0.386, 4.930> <0.044, 0.352, 4.930> <0.046, 0.341, 4.930> <0.051, 0.308, 4.929> 
		<0.037, 0.404, 4.931> <0.042, 0.370, 4.930> <0.048, 0.325, 4.930> <0.053, 0.292, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.037, 0.404, 4.931> <0.042, 0.370, 4.930> <0.048, 0.325, 4.930> <0.053, 0.292, 4.929> 
		<0.026, 0.404, 4.930> <0.031, 0.370, 4.930> <0.032, 0.325, 4.930> <0.037, 0.291, 4.929> 
		<0.012, 0.404, 4.930> <0.012, 0.369, 4.930> <0.016, 0.324, 4.929> <0.016, 0.290, 4.929> 
		<0.002, 0.404, 4.929> <0.001, 0.370, 4.929> <0.000, 0.324, 4.929> <-0.000, 0.289, 4.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.033, 0.401, 4.929> <-0.023, 0.402, 4.929> <-0.009, 0.403, 4.929> <0.002, 0.404, 4.929> 
		<-0.037, 0.369, 4.929> <-0.027, 0.369, 4.929> <-0.009, 0.369, 4.929> <0.001, 0.370, 4.929> 
		<-0.042, 0.325, 4.929> <-0.028, 0.324, 4.929> <-0.013, 0.324, 4.929> <0.000, 0.324, 4.929> 
		<-0.046, 0.292, 4.929> <-0.032, 0.291, 4.929> <-0.014, 0.290, 4.929> <-0.000, 0.289, 4.929> 
	}
	texture {text1Rojo}
	texture {pigment{image_map {png "CruzdeMalta01.png" once}}
                 scale .45
                 translate <2.8,1.43,-1>
                 rotate y*(-90) translate y*-1.5}
        texture {textSucio}
        texture {pigment{image_map {png "agujeros.png" once}}
                 scale .8
                 translate <1.5,1.2,-1>
                 rotate y*(-90) translate y*-1.5}
        texture {pigment{image_map {png "agujeros.png" once}}
                 scale .8
                 translate <2.525,.9,-1>
                 rotate z*5
                 rotate y*(-90) translate y*-1.5}                                  
}


#declare Helice = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.015, 0.009, -0.454> <-0.034, -0.041, -0.443> <-0.091, -0.114, -0.422> <-0.146, -0.158, -0.419> 
		<-0.001, 0.029, -0.473> <-0.049, -0.021, -0.462> <-0.083, -0.124, -0.448> <-0.138, -0.167, -0.444> 
		<-0.018, 0.050, -0.449> <-0.065, -0.001, -0.449> <-0.120, -0.078, -0.431> <-0.173, -0.123, -0.431> 
		<-0.034, 0.070, -0.431> <-0.081, 0.019, -0.430> <-0.138, -0.056, -0.429> <-0.191, -0.101, -0.429> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.015, 0.009, -0.454> <0.027, -0.007, -0.439> <0.008, 0.018, -0.411> <-0.005, 0.034, -0.396> 
		<-0.034, -0.041, -0.443> <-0.021, -0.057, -0.428> <-0.052, -0.018, -0.410> <-0.064, -0.002, -0.394> 
		<-0.091, -0.114, -0.422> <-0.101, -0.101, -0.389> <-0.124, -0.073, -0.392> <-0.147, -0.045, -0.390> 
		<-0.146, -0.158, -0.419> <-0.156, -0.145, -0.385> <-0.180, -0.115, -0.393> <-0.203, -0.086, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 0.034, -0.396> <-0.021, 0.054, -0.377> <-0.038, 0.075, -0.354> <-0.054, 0.095, -0.373> 
		<-0.064, -0.002, -0.394> <-0.080, 0.018, -0.376> <-0.098, 0.040, -0.365> <-0.113, 0.059, -0.383> 
		<-0.147, -0.045, -0.390> <-0.167, -0.020, -0.388> <-0.206, 0.031, -0.376> <-0.197, 0.020, -0.404> 
		<-0.203, -0.086, -0.391> <-0.222, -0.061, -0.389> <-0.261, -0.012, -0.380> <-0.252, -0.023, -0.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.054, 0.095, -0.373> <-0.066, 0.111, -0.388> <-0.047, 0.086, -0.416> <-0.034, 0.070, -0.431> 
		<-0.113, 0.059, -0.383> <-0.126, 0.075, -0.399> <-0.094, 0.035, -0.415> <-0.081, 0.019, -0.430> 
		<-0.197, 0.020, -0.404> <-0.187, 0.007, -0.439> <-0.162, -0.025, -0.427> <-0.138, -0.056, -0.429> 
		<-0.252, -0.023, -0.408> <-0.242, -0.037, -0.443> <-0.215, -0.070, -0.427> <-0.191, -0.101, -0.429> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.146, -0.158, -0.419> <-0.349, -0.321, -0.405> <-0.633, -0.525, -0.403> <-0.844, -0.680, -0.395> 
		<-0.138, -0.167, -0.444> <-0.342, -0.331, -0.430> <-0.624, -0.537, -0.421> <-0.835, -0.692, -0.414> 
		<-0.173, -0.123, -0.431> <-0.373, -0.292, -0.430> <-0.655, -0.497, -0.422> <-0.862, -0.658, -0.420> 
		<-0.191, -0.101, -0.429> <-0.391, -0.270, -0.429> <-0.669, -0.480, -0.430> <-0.875, -0.641, -0.428> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.146, -0.158, -0.419> <-0.156, -0.145, -0.385> <-0.180, -0.115, -0.393> <-0.203, -0.086, -0.391> 
		<-0.349, -0.321, -0.405> <-0.360, -0.309, -0.372> <-0.389, -0.271, -0.394> <-0.412, -0.242, -0.392> 
		<-0.633, -0.525, -0.403> <-0.643, -0.512, -0.381> <-0.666, -0.483, -0.391> <-0.682, -0.463, -0.400> 
		<-0.844, -0.680, -0.395> <-0.854, -0.667, -0.374> <-0.872, -0.645, -0.393> <-0.888, -0.625, -0.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.203, -0.086, -0.391> <-0.222, -0.061, -0.389> <-0.261, -0.012, -0.380> <-0.252, -0.023, -0.408> 
		<-0.412, -0.242, -0.392> <-0.432, -0.218, -0.390> <-0.466, -0.174, -0.396> <-0.458, -0.185, -0.424> 
		<-0.682, -0.463, -0.400> <-0.697, -0.445, -0.409> <-0.729, -0.404, -0.414> <-0.720, -0.415, -0.433> 
		<-0.888, -0.625, -0.403> <-0.902, -0.607, -0.411> <-0.928, -0.574, -0.421> <-0.919, -0.586, -0.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.252, -0.023, -0.408> <-0.242, -0.037, -0.443> <-0.215, -0.070, -0.427> <-0.191, -0.101, -0.429> 
		<-0.458, -0.185, -0.424> <-0.447, -0.198, -0.459> <-0.415, -0.239, -0.426> <-0.391, -0.270, -0.429> 
		<-0.720, -0.415, -0.433> <-0.710, -0.429, -0.454> <-0.685, -0.460, -0.439> <-0.669, -0.480, -0.430> 
		<-0.919, -0.586, -0.440> <-0.908, -0.599, -0.461> <-0.891, -0.620, -0.438> <-0.875, -0.641, -0.428> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.844, -0.680, -0.395> <-0.868, -0.698, -0.394> <-0.900, -0.723, -0.388> <-0.928, -0.732, -0.392> 
		<-0.835, -0.692, -0.414> <-0.859, -0.709, -0.413> <-0.893, -0.731, -0.406> <-0.921, -0.740, -0.411> 
		<-0.862, -0.658, -0.420> <-0.885, -0.676, -0.420> <-0.919, -0.696, -0.417> <-0.943, -0.712, -0.416> 
		<-0.875, -0.641, -0.428> <-0.898, -0.659, -0.428> <-0.931, -0.680, -0.426> <-0.955, -0.697, -0.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.844, -0.680, -0.395> <-0.854, -0.667, -0.374> <-0.872, -0.645, -0.393> <-0.888, -0.625, -0.403> 
		<-0.868, -0.698, -0.394> <-0.878, -0.684, -0.373> <-0.895, -0.663, -0.393> <-0.911, -0.643, -0.403> 
		<-0.900, -0.723, -0.388> <-0.906, -0.715, -0.368> <-0.929, -0.683, -0.387> <-0.942, -0.667, -0.396> 
		<-0.928, -0.732, -0.392> <-0.934, -0.724, -0.372> <-0.951, -0.703, -0.390> <-0.963, -0.687, -0.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.888, -0.625, -0.403> <-0.902, -0.607, -0.411> <-0.928, -0.574, -0.421> <-0.919, -0.586, -0.440> 
		<-0.911, -0.643, -0.403> <-0.925, -0.625, -0.411> <-0.950, -0.593, -0.422> <-0.941, -0.605, -0.441> 
		<-0.942, -0.667, -0.396> <-0.954, -0.652, -0.405> <-0.980, -0.622, -0.420> <-0.974, -0.630, -0.439> 
		<-0.963, -0.687, -0.399> <-0.975, -0.672, -0.408> <-0.995, -0.647, -0.417> <-0.989, -0.655, -0.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.919, -0.586, -0.440> <-0.908, -0.599, -0.461> <-0.891, -0.620, -0.438> <-0.875, -0.641, -0.428> 
		<-0.941, -0.605, -0.441> <-0.931, -0.618, -0.462> <-0.914, -0.639, -0.438> <-0.898, -0.659, -0.428> 
		<-0.974, -0.630, -0.439> <-0.968, -0.637, -0.458> <-0.943, -0.665, -0.434> <-0.931, -0.680, -0.426> 
		<-0.989, -0.655, -0.435> <-0.983, -0.663, -0.454> <-0.967, -0.682, -0.433> <-0.955, -0.697, -0.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.955, -0.697, -0.424> <-0.970, -0.708, -0.423> <-1.000, -0.738, -0.435> <-1.005, -0.731, -0.419> 
		<-0.967, -0.682, -0.433> <-0.982, -0.692, -0.432> <-1.005, -0.731, -0.418> <-1.010, -0.724, -0.402> 
		<-0.983, -0.663, -0.454> <-0.989, -0.655, -0.436> <-0.989, -0.685, -0.410> <-0.977, -0.700, -0.401> 
		<-0.989, -0.655, -0.435> <-0.995, -0.647, -0.417> <-0.975, -0.672, -0.408> <-0.963, -0.687, -0.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.955, -0.697, -0.424> <-0.955, -0.697, -0.424> <-0.955, -0.697, -0.424> <-0.955, -0.697, -0.424> 
		<-0.970, -0.708, -0.423> <-0.982, -0.692, -0.432> <-0.982, -0.692, -0.432> <-0.967, -0.682, -0.433> 
		<-1.000, -0.738, -0.435> <-1.013, -0.721, -0.445> <-0.995, -0.683, -0.451> <-0.983, -0.663, -0.454> 
		<-1.005, -0.731, -0.419> <-1.018, -0.714, -0.429> <-1.001, -0.675, -0.433> <-0.989, -0.655, -0.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.955, -0.697, -0.424> <-0.943, -0.712, -0.416> <-0.921, -0.740, -0.411> <-0.928, -0.732, -0.392> 
		<-0.967, -0.682, -0.433> <-0.955, -0.697, -0.424> <-0.945, -0.747, -0.414> <-0.951, -0.739, -0.395> 
		<-0.983, -0.663, -0.454> <-0.995, -0.683, -0.451> <-1.004, -0.732, -0.419> <-0.991, -0.749, -0.409> 
		<-0.989, -0.655, -0.435> <-1.001, -0.675, -0.433> <-1.018, -0.714, -0.429> <-1.005, -0.731, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.955, -0.697, -0.424> <-0.943, -0.712, -0.416> <-0.921, -0.740, -0.411> <-0.928, -0.732, -0.392> 
		<-0.970, -0.708, -0.423> <-0.958, -0.723, -0.415> <-0.928, -0.732, -0.391> <-0.934, -0.724, -0.372> 
		<-1.000, -0.738, -0.435> <-1.005, -0.731, -0.418> <-0.965, -0.716, -0.392> <-0.951, -0.703, -0.390> 
		<-1.005, -0.731, -0.419> <-1.010, -0.724, -0.402> <-0.977, -0.700, -0.401> <-0.963, -0.687, -0.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.955, -0.697, -0.424> <-0.955, -0.697, -0.424> <-0.955, -0.697, -0.424> <-0.955, -0.697, -0.424> 
		<-0.970, -0.708, -0.423> <-0.958, -0.723, -0.415> <-0.958, -0.723, -0.415> <-0.943, -0.712, -0.416> 
		<-1.000, -0.738, -0.435> <-0.986, -0.755, -0.425> <-0.945, -0.747, -0.414> <-0.921, -0.740, -0.411> 
		<-1.005, -0.731, -0.419> <-0.991, -0.749, -0.409> <-0.951, -0.739, -0.395> <-0.928, -0.732, -0.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.963, -0.687, -0.399> <-0.963, -0.687, -0.399> <-0.963, -0.687, -0.399> <-0.963, -0.687, -0.399> 
		<-0.951, -0.703, -0.390> <-0.965, -0.716, -0.392> <-0.965, -0.716, -0.392> <-0.977, -0.700, -0.401> 
		<-0.934, -0.724, -0.372> <-0.957, -0.731, -0.376> <-0.996, -0.742, -0.392> <-1.010, -0.724, -0.402> 
		<-0.928, -0.732, -0.392> <-0.951, -0.739, -0.395> <-0.991, -0.749, -0.409> <-1.005, -0.731, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.963, -0.687, -0.399> <-0.951, -0.703, -0.390> <-0.934, -0.724, -0.372> <-0.928, -0.732, -0.392> 
		<-0.975, -0.672, -0.408> <-0.963, -0.688, -0.399> <-0.957, -0.731, -0.376> <-0.951, -0.739, -0.395> 
		<-0.995, -0.647, -0.417> <-1.007, -0.667, -0.414> <-1.004, -0.732, -0.419> <-0.991, -0.749, -0.409> 
		<-0.989, -0.655, -0.435> <-1.001, -0.675, -0.433> <-1.018, -0.714, -0.429> <-1.005, -0.731, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.963, -0.687, -0.399> <-0.963, -0.687, -0.399> <-0.963, -0.687, -0.399> <-0.963, -0.687, -0.399> 
		<-0.977, -0.700, -0.401> <-0.989, -0.685, -0.410> <-0.989, -0.685, -0.410> <-0.975, -0.672, -0.408> 
		<-1.010, -0.724, -0.402> <-1.024, -0.707, -0.412> <-1.007, -0.667, -0.414> <-0.995, -0.647, -0.417> 
		<-1.005, -0.731, -0.419> <-1.018, -0.714, -0.429> <-1.001, -0.675, -0.433> <-0.989, -0.655, -0.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 0.124, -0.454> <0.032, 0.174, -0.443> <0.089, 0.247, -0.423> <0.144, 0.291, -0.419> 
		<-0.000, 0.104, -0.473> <0.048, 0.154, -0.462> <0.085, 0.252, -0.455> <0.140, 0.296, -0.451> 
		<0.017, 0.083, -0.449> <0.065, 0.132, -0.452> <0.122, 0.208, -0.442> <0.175, 0.252, -0.442> 
		<0.032, 0.063, -0.431> <0.081, 0.112, -0.433> <0.142, 0.182, -0.440> <0.195, 0.227, -0.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 0.124, -0.454> <-0.029, 0.140, -0.439> <-0.009, 0.116, -0.411> <0.003, 0.100, -0.396> 
		<0.032, 0.174, -0.443> <0.019, 0.190, -0.428> <0.050, 0.152, -0.410> <0.063, 0.136, -0.395> 
		<0.089, 0.247, -0.423> <0.094, 0.241, -0.387> <0.122, 0.207, -0.394> <0.145, 0.178, -0.392> 
		<0.144, 0.291, -0.419> <0.149, 0.285, -0.383> <0.178, 0.248, -0.395> <0.201, 0.220, -0.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.100, -0.396> <0.019, 0.080, -0.377> <0.036, 0.058, -0.354> <0.052, 0.038, -0.373> 
		<0.063, 0.136, -0.395> <0.078, 0.116, -0.376> <0.096, 0.094, -0.365> <0.112, 0.074, -0.383> 
		<0.145, 0.178, -0.392> <0.165, 0.153, -0.390> <0.200, 0.108, -0.373> <0.196, 0.113, -0.404> 
		<0.201, 0.220, -0.392> <0.220, 0.195, -0.390> <0.255, 0.152, -0.377> <0.251, 0.157, -0.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.052, 0.038, -0.373> <0.065, 0.022, -0.388> <0.045, 0.047, -0.416> <0.032, 0.063, -0.431> 
		<0.112, 0.074, -0.383> <0.124, 0.058, -0.399> <0.094, 0.096, -0.418> <0.081, 0.112, -0.433> 
		<0.196, 0.113, -0.404> <0.191, 0.119, -0.440> <0.165, 0.153, -0.438> <0.142, 0.182, -0.440> 
		<0.251, 0.157, -0.408> <0.246, 0.162, -0.444> <0.218, 0.198, -0.437> <0.195, 0.227, -0.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.144, 0.291, -0.419> <0.348, 0.454, -0.403> <0.632, 0.658, -0.394> <0.843, 0.813, -0.387> 
		<0.140, 0.296, -0.451> <0.344, 0.459, -0.435> <0.621, 0.671, -0.412> <0.832, 0.826, -0.405> 
		<0.175, 0.252, -0.442> <0.374, 0.422, -0.441> <0.654, 0.630, -0.422> <0.858, 0.793, -0.420> 
		<0.195, 0.227, -0.440> <0.394, 0.396, -0.439> <0.668, 0.613, -0.432> <0.872, 0.776, -0.429> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.144, 0.291, -0.419> <0.149, 0.285, -0.383> <0.178, 0.248, -0.395> <0.201, 0.220, -0.392> 
		<0.348, 0.454, -0.403> <0.352, 0.449, -0.367> <0.388, 0.404, -0.396> <0.411, 0.376, -0.394> 
		<0.632, 0.658, -0.394> <0.644, 0.643, -0.373> <0.665, 0.616, -0.389> <0.681, 0.596, -0.400> 
		<0.843, 0.813, -0.387> <0.855, 0.798, -0.366> <0.871, 0.777, -0.391> <0.887, 0.757, -0.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.220, -0.392> <0.220, 0.195, -0.390> <0.255, 0.152, -0.377> <0.251, 0.157, -0.408> 
		<0.411, 0.376, -0.394> <0.430, 0.351, -0.392> <0.460, 0.313, -0.393> <0.456, 0.318, -0.424> 
		<0.681, 0.596, -0.400> <0.694, 0.579, -0.410> <0.728, 0.536, -0.415> <0.718, 0.549, -0.433> 
		<0.887, 0.757, -0.403> <0.901, 0.740, -0.412> <0.927, 0.706, -0.423> <0.917, 0.719, -0.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.251, 0.157, -0.408> <0.246, 0.162, -0.444> <0.218, 0.198, -0.437> <0.195, 0.227, -0.440> 
		<0.456, 0.318, -0.424> <0.451, 0.324, -0.460> <0.417, 0.368, -0.437> <0.394, 0.396, -0.439> 
		<0.718, 0.549, -0.433> <0.706, 0.564, -0.453> <0.684, 0.592, -0.444> <0.668, 0.613, -0.432> 
		<0.917, 0.719, -0.440> <0.905, 0.734, -0.461> <0.888, 0.756, -0.441> <0.872, 0.776, -0.429> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.843, 0.813, -0.387> <0.866, 0.830, -0.386> <0.898, 0.856, -0.386> <0.926, 0.865, -0.392> 
		<0.832, 0.826, -0.405> <0.856, 0.843, -0.404> <0.890, 0.867, -0.404> <0.918, 0.876, -0.409> 
		<0.858, 0.793, -0.420> <0.881, 0.812, -0.419> <0.915, 0.831, -0.422> <0.940, 0.848, -0.421> 
		<0.872, 0.776, -0.429> <0.895, 0.794, -0.429> <0.928, 0.816, -0.431> <0.952, 0.832, -0.429> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.843, 0.813, -0.387> <0.855, 0.798, -0.366> <0.871, 0.777, -0.391> <0.887, 0.757, -0.403> 
		<0.866, 0.830, -0.386> <0.878, 0.815, -0.365> <0.894, 0.795, -0.392> <0.910, 0.775, -0.403> 
		<0.898, 0.856, -0.386> <0.908, 0.845, -0.367> <0.930, 0.813, -0.388> <0.944, 0.795, -0.398> 
		<0.926, 0.865, -0.392> <0.935, 0.853, -0.372> <0.951, 0.833, -0.391> <0.965, 0.815, -0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.887, 0.757, -0.403> <0.901, 0.740, -0.412> <0.927, 0.706, -0.423> <0.917, 0.719, -0.440> 
		<0.910, 0.775, -0.403> <0.924, 0.758, -0.413> <0.949, 0.726, -0.424> <0.940, 0.738, -0.441> 
		<0.944, 0.795, -0.398> <0.955, 0.782, -0.406> <0.979, 0.754, -0.424> <0.972, 0.763, -0.439> 
		<0.965, 0.815, -0.401> <0.976, 0.802, -0.409> <0.994, 0.779, -0.421> <0.987, 0.788, -0.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.917, 0.719, -0.440> <0.905, 0.734, -0.461> <0.888, 0.756, -0.441> <0.872, 0.776, -0.429> 
		<0.940, 0.738, -0.441> <0.928, 0.753, -0.461> <0.911, 0.774, -0.441> <0.895, 0.794, -0.429> 
		<0.972, 0.763, -0.439> <0.964, 0.773, -0.456> <0.940, 0.800, -0.440> <0.928, 0.816, -0.431> 
		<0.987, 0.788, -0.435> <0.979, 0.798, -0.453> <0.965, 0.816, -0.438> <0.952, 0.832, -0.429> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.952, 0.832, -0.429> <0.967, 0.842, -0.428> <0.996, 0.873, -0.434> <1.003, 0.864, -0.419> 
		<0.965, 0.816, -0.438> <0.980, 0.827, -0.437> <1.004, 0.864, -0.419> <1.010, 0.855, -0.404> 
		<0.979, 0.798, -0.453> <0.986, 0.789, -0.438> <0.990, 0.815, -0.411> <0.980, 0.828, -0.403> 
		<0.987, 0.788, -0.435> <0.994, 0.779, -0.421> <0.976, 0.802, -0.409> <0.965, 0.815, -0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.952, 0.832, -0.429> <0.952, 0.832, -0.429> <0.952, 0.832, -0.429> <0.952, 0.832, -0.429> 
		<0.967, 0.842, -0.428> <0.980, 0.827, -0.437> <0.980, 0.827, -0.437> <0.965, 0.816, -0.438> 
		<0.996, 0.873, -0.434> <1.010, 0.856, -0.444> <0.991, 0.819, -0.450> <0.979, 0.798, -0.453> 
		<1.003, 0.864, -0.419> <1.017, 0.847, -0.429> <0.999, 0.808, -0.433> <0.987, 0.788, -0.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.952, 0.832, -0.429> <0.940, 0.848, -0.421> <0.918, 0.876, -0.409> <0.926, 0.865, -0.392> 
		<0.965, 0.816, -0.438> <0.952, 0.832, -0.429> <0.941, 0.883, -0.414> <0.949, 0.873, -0.397> 
		<0.979, 0.798, -0.453> <0.991, 0.819, -0.450> <1.003, 0.865, -0.419> <0.989, 0.882, -0.409> 
		<0.987, 0.788, -0.435> <0.999, 0.808, -0.433> <1.017, 0.847, -0.429> <1.003, 0.864, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.952, 0.832, -0.429> <0.940, 0.848, -0.421> <0.918, 0.876, -0.409> <0.926, 0.865, -0.392> 
		<0.967, 0.842, -0.428> <0.955, 0.858, -0.419> <0.927, 0.864, -0.390> <0.935, 0.853, -0.372> 
		<0.996, 0.873, -0.434> <1.004, 0.864, -0.419> <0.965, 0.846, -0.393> <0.951, 0.833, -0.391> 
		<1.003, 0.864, -0.419> <1.010, 0.855, -0.404> <0.980, 0.828, -0.403> <0.965, 0.815, -0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.952, 0.832, -0.429> <0.952, 0.832, -0.429> <0.952, 0.832, -0.429> <0.952, 0.832, -0.429> 
		<0.967, 0.842, -0.428> <0.955, 0.858, -0.419> <0.955, 0.858, -0.419> <0.940, 0.848, -0.421> 
		<0.996, 0.873, -0.434> <0.982, 0.891, -0.424> <0.941, 0.883, -0.414> <0.918, 0.876, -0.409> 
		<1.003, 0.864, -0.419> <0.989, 0.882, -0.409> <0.949, 0.873, -0.397> <0.926, 0.865, -0.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.965, 0.815, -0.401> <0.965, 0.815, -0.401> <0.965, 0.815, -0.401> <0.965, 0.815, -0.401> 
		<0.951, 0.833, -0.391> <0.965, 0.846, -0.393> <0.965, 0.846, -0.393> <0.980, 0.828, -0.403> 
		<0.935, 0.853, -0.372> <0.958, 0.861, -0.377> <0.996, 0.873, -0.394> <1.010, 0.855, -0.404> 
		<0.926, 0.865, -0.392> <0.949, 0.873, -0.397> <0.989, 0.882, -0.409> <1.003, 0.864, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.965, 0.815, -0.401> <0.951, 0.833, -0.391> <0.935, 0.853, -0.372> <0.926, 0.865, -0.392> 
		<0.976, 0.802, -0.409> <0.962, 0.820, -0.399> <0.958, 0.861, -0.377> <0.949, 0.873, -0.397> 
		<0.994, 0.779, -0.421> <1.006, 0.800, -0.418> <1.003, 0.865, -0.419> <0.989, 0.882, -0.409> 
		<0.987, 0.788, -0.435> <0.999, 0.808, -0.433> <1.017, 0.847, -0.429> <1.003, 0.864, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.965, 0.815, -0.401> <0.965, 0.815, -0.401> <0.965, 0.815, -0.401> <0.965, 0.815, -0.401> 
		<0.980, 0.828, -0.403> <0.990, 0.815, -0.411> <0.990, 0.815, -0.411> <0.976, 0.802, -0.409> 
		<1.010, 0.855, -0.404> <1.024, 0.838, -0.414> <1.006, 0.800, -0.418> <0.994, 0.779, -0.421> 
		<1.003, 0.864, -0.419> <1.017, 0.847, -0.429> <0.999, 0.808, -0.433> <0.987, 0.788, -0.435> 
	}
	texture {textHelice}
}                                 


#declare Llantas = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.957, -1.147, 0.427> <0.945, -1.062, 0.427> <0.928, -0.950, 0.427> <0.916, -0.866, 0.427> 
		<0.957, -1.147, 0.427> <0.945, -1.062, 0.427> <0.928, -0.950, 0.268> <0.916, -0.866, 0.268> 
		<0.957, -1.147, 0.427> <0.945, -1.147, 0.337> <0.928, -0.989, 0.218> <0.916, -0.989, 0.128> 
		<0.957, -1.147, 0.427> <0.945, -1.147, 0.337> <0.928, -1.147, 0.218> <0.916, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.957, -1.147, 0.427> <0.957, -1.147, 0.427> <0.957, -1.147, 0.427> <0.957, -1.147, 0.427> 
		<0.945, -1.062, 0.427> <0.945, -1.062, 0.427> <0.945, -1.147, 0.516> <0.945, -1.147, 0.516> 
		<0.928, -0.950, 0.427> <0.928, -0.950, 0.585> <0.928, -0.989, 0.635> <0.928, -1.147, 0.635> 
		<0.916, -0.866, 0.427> <0.916, -0.866, 0.585> <0.916, -0.989, 0.725> <0.916, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.957, -1.147, 0.427> <0.945, -1.231, 0.427> <0.928, -1.343, 0.427> <0.916, -1.428, 0.427> 
		<0.957, -1.147, 0.427> <0.945, -1.231, 0.427> <0.928, -1.343, 0.585> <0.916, -1.428, 0.585> 
		<0.957, -1.147, 0.427> <0.945, -1.147, 0.516> <0.928, -1.305, 0.635> <0.916, -1.305, 0.725> 
		<0.957, -1.147, 0.427> <0.945, -1.147, 0.516> <0.928, -1.147, 0.635> <0.916, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.957, -1.147, 0.427> <0.957, -1.147, 0.427> <0.957, -1.147, 0.427> <0.957, -1.147, 0.427> 
		<0.945, -1.231, 0.427> <0.945, -1.231, 0.427> <0.945, -1.147, 0.337> <0.945, -1.147, 0.337> 
		<0.928, -1.343, 0.427> <0.928, -1.343, 0.268> <0.928, -1.305, 0.218> <0.928, -1.147, 0.218> 
		<0.916, -1.428, 0.427> <0.916, -1.428, 0.268> <0.916, -1.305, 0.128> <0.916, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.916, -0.866, 0.427> <0.916, -0.866, 0.427> <0.916, -0.866, 0.427> <0.916, -0.866, 0.427> 
		<0.916, -0.866, 0.268> <0.916, -0.866, 0.427> <0.916, -0.866, 0.427> <0.916, -0.866, 0.585> 
		<0.916, -0.989, 0.128> <0.916, -0.989, 0.307> <0.916, -0.989, 0.546> <0.916, -0.989, 0.725> 
		<0.916, -1.147, 0.128> <0.916, -1.147, 0.307> <0.916, -1.147, 0.546> <0.916, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.916, -1.428, 0.427> <0.916, -1.428, 0.427> <0.916, -1.428, 0.427> <0.916, -1.428, 0.427> 
		<0.916, -1.428, 0.585> <0.916, -1.428, 0.427> <0.916, -1.428, 0.427> <0.916, -1.428, 0.268> 
		<0.916, -1.305, 0.725> <0.916, -1.305, 0.546> <0.916, -1.305, 0.307> <0.916, -1.305, 0.128> 
		<0.916, -1.147, 0.725> <0.916, -1.147, 0.546> <0.916, -1.147, 0.307> <0.916, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.817, -1.147, 0.427> <0.829, -1.062, 0.427> <0.845, -0.950, 0.427> <0.858, -0.866, 0.427> 
		<0.817, -1.147, 0.427> <0.829, -1.062, 0.427> <0.845, -0.950, 0.268> <0.858, -0.866, 0.268> 
		<0.817, -1.147, 0.427> <0.829, -1.147, 0.337> <0.845, -0.989, 0.218> <0.858, -0.989, 0.128> 
		<0.817, -1.147, 0.427> <0.829, -1.147, 0.337> <0.845, -1.147, 0.218> <0.858, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.817, -1.147, 0.427> <0.817, -1.147, 0.427> <0.817, -1.147, 0.427> <0.817, -1.147, 0.427> 
		<0.829, -1.062, 0.427> <0.829, -1.062, 0.427> <0.829, -1.147, 0.516> <0.829, -1.147, 0.516> 
		<0.845, -0.950, 0.427> <0.845, -0.950, 0.585> <0.845, -0.989, 0.635> <0.845, -1.147, 0.635> 
		<0.858, -0.866, 0.427> <0.858, -0.866, 0.585> <0.858, -0.989, 0.725> <0.858, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.817, -1.147, 0.427> <0.829, -1.231, 0.427> <0.845, -1.343, 0.427> <0.858, -1.428, 0.427> 
		<0.817, -1.147, 0.427> <0.829, -1.231, 0.427> <0.845, -1.343, 0.585> <0.858, -1.428, 0.585> 
		<0.817, -1.147, 0.427> <0.829, -1.147, 0.516> <0.845, -1.305, 0.635> <0.858, -1.305, 0.725> 
		<0.817, -1.147, 0.427> <0.829, -1.147, 0.516> <0.845, -1.147, 0.635> <0.858, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.817, -1.147, 0.427> <0.817, -1.147, 0.427> <0.817, -1.147, 0.427> <0.817, -1.147, 0.427> 
		<0.829, -1.231, 0.427> <0.829, -1.231, 0.427> <0.829, -1.147, 0.337> <0.829, -1.147, 0.337> 
		<0.845, -1.343, 0.427> <0.845, -1.343, 0.268> <0.845, -1.305, 0.218> <0.845, -1.147, 0.218> 
		<0.858, -1.428, 0.427> <0.858, -1.428, 0.268> <0.858, -1.305, 0.128> <0.858, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.858, -0.866, 0.427> <0.858, -0.866, 0.427> <0.858, -0.866, 0.427> <0.858, -0.866, 0.427> 
		<0.858, -0.866, 0.268> <0.858, -0.866, 0.427> <0.858, -0.866, 0.427> <0.858, -0.866, 0.585> 
		<0.858, -0.989, 0.128> <0.858, -0.989, 0.307> <0.858, -0.989, 0.546> <0.858, -0.989, 0.725> 
		<0.858, -1.147, 0.128> <0.858, -1.147, 0.307> <0.858, -1.147, 0.546> <0.858, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.858, -1.428, 0.427> <0.858, -1.428, 0.427> <0.858, -1.428, 0.427> <0.858, -1.428, 0.427> 
		<0.858, -1.428, 0.585> <0.858, -1.428, 0.427> <0.858, -1.428, 0.427> <0.858, -1.428, 0.268> 
		<0.858, -1.305, 0.725> <0.858, -1.305, 0.546> <0.858, -1.305, 0.307> <0.858, -1.305, 0.128> 
		<0.858, -1.147, 0.725> <0.858, -1.147, 0.546> <0.858, -1.147, 0.307> <0.858, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.958, -1.147, 0.427> <-0.946, -1.062, 0.427> <-0.930, -0.950, 0.427> <-0.917, -0.866, 0.427> 
		<-0.958, -1.147, 0.427> <-0.946, -1.062, 0.427> <-0.930, -0.950, 0.268> <-0.917, -0.866, 0.268> 
		<-0.958, -1.147, 0.427> <-0.946, -1.147, 0.337> <-0.930, -0.989, 0.218> <-0.917, -0.989, 0.128> 
		<-0.958, -1.147, 0.427> <-0.946, -1.147, 0.337> <-0.930, -1.147, 0.218> <-0.917, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.958, -1.147, 0.427> <-0.958, -1.147, 0.427> <-0.958, -1.147, 0.427> <-0.958, -1.147, 0.427> 
		<-0.946, -1.062, 0.427> <-0.946, -1.062, 0.427> <-0.946, -1.147, 0.516> <-0.946, -1.147, 0.516> 
		<-0.930, -0.950, 0.427> <-0.930, -0.950, 0.585> <-0.930, -0.989, 0.635> <-0.930, -1.147, 0.635> 
		<-0.917, -0.866, 0.427> <-0.917, -0.866, 0.585> <-0.917, -0.989, 0.725> <-0.917, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.958, -1.147, 0.427> <-0.946, -1.231, 0.427> <-0.930, -1.343, 0.427> <-0.917, -1.428, 0.427> 
		<-0.958, -1.147, 0.427> <-0.946, -1.231, 0.427> <-0.930, -1.343, 0.585> <-0.917, -1.428, 0.585> 
		<-0.958, -1.147, 0.427> <-0.946, -1.147, 0.516> <-0.930, -1.305, 0.635> <-0.917, -1.305, 0.725> 
		<-0.958, -1.147, 0.427> <-0.946, -1.147, 0.516> <-0.930, -1.147, 0.635> <-0.917, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.958, -1.147, 0.427> <-0.958, -1.147, 0.427> <-0.958, -1.147, 0.427> <-0.958, -1.147, 0.427> 
		<-0.946, -1.231, 0.427> <-0.946, -1.231, 0.427> <-0.946, -1.147, 0.337> <-0.946, -1.147, 0.337> 
		<-0.930, -1.343, 0.427> <-0.930, -1.343, 0.268> <-0.930, -1.305, 0.218> <-0.930, -1.147, 0.218> 
		<-0.917, -1.428, 0.427> <-0.917, -1.428, 0.268> <-0.917, -1.305, 0.128> <-0.917, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.917, -0.866, 0.427> <-0.917, -0.866, 0.427> <-0.917, -0.866, 0.427> <-0.917, -0.866, 0.427> 
		<-0.917, -0.866, 0.268> <-0.917, -0.866, 0.427> <-0.917, -0.866, 0.427> <-0.917, -0.866, 0.585> 
		<-0.917, -0.989, 0.128> <-0.917, -0.989, 0.307> <-0.917, -0.989, 0.546> <-0.917, -0.989, 0.725> 
		<-0.917, -1.147, 0.128> <-0.917, -1.147, 0.307> <-0.917, -1.147, 0.546> <-0.917, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.917, -1.428, 0.427> <-0.917, -1.428, 0.427> <-0.917, -1.428, 0.427> <-0.917, -1.428, 0.427> 
		<-0.917, -1.428, 0.585> <-0.917, -1.428, 0.427> <-0.917, -1.428, 0.427> <-0.917, -1.428, 0.268> 
		<-0.917, -1.305, 0.725> <-0.917, -1.305, 0.546> <-0.917, -1.305, 0.307> <-0.917, -1.305, 0.128> 
		<-0.917, -1.147, 0.725> <-0.917, -1.147, 0.546> <-0.917, -1.147, 0.307> <-0.917, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.818, -1.147, 0.427> <-0.830, -1.062, 0.427> <-0.847, -0.950, 0.427> <-0.859, -0.866, 0.427> 
		<-0.818, -1.147, 0.427> <-0.830, -1.062, 0.427> <-0.847, -0.950, 0.268> <-0.859, -0.866, 0.268> 
		<-0.818, -1.147, 0.427> <-0.830, -1.147, 0.337> <-0.847, -0.989, 0.218> <-0.859, -0.989, 0.128> 
		<-0.818, -1.147, 0.427> <-0.830, -1.147, 0.337> <-0.847, -1.147, 0.218> <-0.859, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.818, -1.147, 0.427> <-0.818, -1.147, 0.427> <-0.818, -1.147, 0.427> <-0.818, -1.147, 0.427> 
		<-0.830, -1.062, 0.427> <-0.830, -1.062, 0.427> <-0.830, -1.147, 0.516> <-0.830, -1.147, 0.516> 
		<-0.847, -0.950, 0.427> <-0.847, -0.950, 0.585> <-0.847, -0.989, 0.635> <-0.847, -1.147, 0.635> 
		<-0.859, -0.866, 0.427> <-0.859, -0.866, 0.585> <-0.859, -0.989, 0.725> <-0.859, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.818, -1.147, 0.427> <-0.830, -1.231, 0.427> <-0.847, -1.343, 0.427> <-0.859, -1.428, 0.427> 
		<-0.818, -1.147, 0.427> <-0.830, -1.231, 0.427> <-0.847, -1.343, 0.585> <-0.859, -1.428, 0.585> 
		<-0.818, -1.147, 0.427> <-0.830, -1.147, 0.516> <-0.847, -1.305, 0.635> <-0.859, -1.305, 0.725> 
		<-0.818, -1.147, 0.427> <-0.830, -1.147, 0.516> <-0.847, -1.147, 0.635> <-0.859, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.818, -1.147, 0.427> <-0.818, -1.147, 0.427> <-0.818, -1.147, 0.427> <-0.818, -1.147, 0.427> 
		<-0.830, -1.231, 0.427> <-0.830, -1.231, 0.427> <-0.830, -1.147, 0.337> <-0.830, -1.147, 0.337> 
		<-0.847, -1.343, 0.427> <-0.847, -1.343, 0.268> <-0.847, -1.305, 0.218> <-0.847, -1.147, 0.218> 
		<-0.859, -1.428, 0.427> <-0.859, -1.428, 0.268> <-0.859, -1.305, 0.128> <-0.859, -1.147, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.859, -0.866, 0.427> <-0.859, -0.866, 0.427> <-0.859, -0.866, 0.427> <-0.859, -0.866, 0.427> 
		<-0.859, -0.866, 0.268> <-0.859, -0.866, 0.427> <-0.859, -0.866, 0.427> <-0.859, -0.866, 0.585> 
		<-0.859, -0.989, 0.128> <-0.859, -0.989, 0.307> <-0.859, -0.989, 0.546> <-0.859, -0.989, 0.725> 
		<-0.859, -1.147, 0.128> <-0.859, -1.147, 0.307> <-0.859, -1.147, 0.546> <-0.859, -1.147, 0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.859, -1.428, 0.427> <-0.859, -1.428, 0.427> <-0.859, -1.428, 0.427> <-0.859, -1.428, 0.427> 
		<-0.859, -1.428, 0.585> <-0.859, -1.428, 0.427> <-0.859, -1.428, 0.427> <-0.859, -1.428, 0.268> 
		<-0.859, -1.305, 0.725> <-0.859, -1.305, 0.546> <-0.859, -1.305, 0.307> <-0.859, -1.305, 0.128> 
		<-0.859, -1.147, 0.725> <-0.859, -1.147, 0.546> <-0.859, -1.147, 0.307> <-0.859, -1.147, 0.128> 
	}
	texture {text1Rojo}
	texture {textSucio}
}
 

#declare Motor = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.309, -0.057, -0.019> <-0.217, -0.057, -0.013> <-0.093, -0.057, -0.005> <0.000, -0.057, 0.001> 
		<-0.326, -0.119, -0.013> <-0.234, -0.119, -0.007> <-0.093, -0.147, -0.005> <0.000, -0.147, 0.001> 
		<-0.349, -0.202, -0.005> <-0.239, -0.230, -0.005> <-0.110, -0.239, 0.001> <0.000, -0.267, 0.001> 
		<-0.367, -0.263, 0.001> <-0.257, -0.292, 0.001> <-0.110, -0.329, 0.001> <0.000, -0.357, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.057, 0.001> <0.093, -0.057, -0.003> <0.217, -0.057, -0.007> <0.309, -0.057, -0.011> 
		<0.000, -0.147, 0.001> <0.093, -0.147, -0.003> <0.239, -0.119, -0.004> <0.332, -0.119, -0.007> 
		<0.000, -0.267, 0.001> <0.116, -0.239, 0.001> <0.247, -0.230, -0.003> <0.363, -0.202, -0.003> 
		<0.000, -0.357, 0.000> <0.116, -0.329, 0.001> <0.270, -0.292, 0.001> <0.386, -0.263, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.367, -0.263, 0.001> <-0.257, -0.292, 0.001> <-0.110, -0.329, 0.001> <0.000, -0.357, 0.000> 
		<-0.378, -0.281, 0.001> <-0.268, -0.310, 0.001> <-0.110, -0.352, 0.001> <0.000, -0.380, 0.000> 
		<-0.393, -0.305, 0.001> <-0.299, -0.389, 0.001> <-0.126, -0.411, 0.000> <0.000, -0.411, 0.000> 
		<-0.404, -0.323, 0.000> <-0.310, -0.407, 0.000> <-0.126, -0.434, 0.000> <0.000, -0.434, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.357, 0.000> <0.116, -0.329, 0.001> <0.270, -0.292, 0.001> <0.386, -0.263, 0.001> 
		<0.000, -0.380, 0.000> <0.116, -0.352, 0.001> <0.274, -0.309, 0.001> <0.389, -0.281, 0.001> 
		<0.000, -0.411, 0.000> <0.124, -0.411, 0.000> <0.301, -0.386, 0.001> <0.394, -0.304, 0.001> 
		<0.000, -0.434, 0.000> <0.124, -0.434, 0.000> <0.304, -0.403, 0.000> <0.398, -0.322, 0.000> 
	}

	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.296, -0.228, 0.000> <-0.295, -0.196, -0.031> <-0.300, -0.155, -0.076> <-0.295, -0.121, -0.104> 
		<-0.296, -0.261, 0.000> <-0.295, -0.229, -0.031> <-0.304, -0.181, -0.097> <-0.299, -0.146, -0.124> 
		<-0.268, -0.289, 0.000> <-0.270, -0.256, -0.043> <-0.281, -0.214, -0.108> <-0.276, -0.172, -0.142> 
		<-0.235, -0.289, 0.000> <-0.237, -0.256, -0.043> <-0.248, -0.220, -0.108> <-0.243, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.296, -0.228, 0.000> <-0.296, -0.194, 0.000> <-0.268, -0.167, 0.000> <-0.235, -0.167, 0.000> 
		<-0.295, -0.196, -0.031> <-0.295, -0.162, -0.031> <-0.266, -0.142, -0.020> <-0.232, -0.142, -0.020> 
		<-0.300, -0.155, -0.076> <-0.295, -0.130, -0.055> <-0.263, -0.101, -0.043> <-0.230, -0.107, -0.043> 
		<-0.295, -0.121, -0.104> <-0.290, -0.095, -0.083> <-0.259, -0.079, -0.065> <-0.226, -0.084, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, -0.167, 0.000> <-0.201, -0.167, 0.000> <-0.174, -0.194, 0.000> <-0.174, -0.228, 0.000> 
		<-0.232, -0.142, -0.020> <-0.199, -0.142, -0.020> <-0.174, -0.169, -0.031> <-0.174, -0.202, -0.031> 
		<-0.230, -0.107, -0.043> <-0.198, -0.112, -0.043> <-0.174, -0.146, -0.055> <-0.179, -0.171, -0.076> 
		<-0.226, -0.084, -0.065> <-0.194, -0.090, -0.065> <-0.170, -0.116, -0.083> <-0.174, -0.142, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.174, -0.228, 0.000> <-0.174, -0.261, 0.000> <-0.201, -0.289, 0.000> <-0.235, -0.289, 0.000> 
		<-0.174, -0.202, -0.031> <-0.174, -0.235, -0.031> <-0.204, -0.256, -0.043> <-0.237, -0.256, -0.043> 
		<-0.179, -0.171, -0.076> <-0.183, -0.197, -0.097> <-0.215, -0.226, -0.108> <-0.248, -0.220, -0.108> 
		<-0.174, -0.142, -0.104> <-0.179, -0.167, -0.124> <-0.210, -0.184, -0.142> <-0.243, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.259, 0.029, -0.207> <-0.256, 0.043, -0.237> <-0.226, 0.049, -0.262> <-0.193, 0.040, -0.262> 
		<-0.270, -0.016, -0.176> <-0.266, -0.002, -0.206> <-0.241, -0.017, -0.226> <-0.208, -0.025, -0.226> 
		<-0.289, -0.078, -0.138> <-0.293, -0.103, -0.159> <-0.268, -0.113, -0.189> <-0.235, -0.119, -0.189> 
		<-0.295, -0.121, -0.104> <-0.299, -0.146, -0.124> <-0.276, -0.172, -0.142> <-0.243, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.259, 0.029, -0.207> <-0.270, -0.016, -0.176> <-0.289, -0.078, -0.138> <-0.295, -0.121, -0.104> 
		<-0.263, 0.014, -0.177> <-0.274, -0.031, -0.146> <-0.284, -0.052, -0.117> <-0.290, -0.095, -0.083> 
		<-0.239, -0.005, -0.152> <-0.245, -0.026, -0.126> <-0.255, -0.054, -0.089> <-0.259, -0.079, -0.065> 
		<-0.207, -0.013, -0.152> <-0.213, -0.034, -0.126> <-0.222, -0.060, -0.089> <-0.226, -0.084, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.207, -0.013, -0.152> <-0.213, -0.034, -0.126> <-0.222, -0.060, -0.089> <-0.226, -0.084, -0.065> 
		<-0.174, -0.021, -0.152> <-0.180, -0.042, -0.126> <-0.189, -0.066, -0.089> <-0.194, -0.090, -0.065> 
		<-0.144, -0.016, -0.177> <-0.155, -0.058, -0.146> <-0.164, -0.077, -0.118> <-0.170, -0.116, -0.083> 
		<-0.141, -0.001, -0.207> <-0.151, -0.043, -0.176> <-0.169, -0.102, -0.139> <-0.174, -0.142, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.141, -0.001, -0.207> <-0.151, -0.043, -0.176> <-0.169, -0.102, -0.139> <-0.174, -0.142, -0.104> 
		<-0.137, 0.014, -0.237> <-0.147, -0.029, -0.206> <-0.173, -0.128, -0.160> <-0.179, -0.167, -0.124> 
		<-0.161, 0.032, -0.262> <-0.176, -0.033, -0.226> <-0.203, -0.124, -0.189> <-0.210, -0.184, -0.142> 
		<-0.193, 0.040, -0.262> <-0.208, -0.025, -0.226> <-0.235, -0.119, -0.189> <-0.243, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.291, -0.228, 0.000> <0.291, -0.196, -0.031> <0.295, -0.155, -0.076> <0.290, -0.121, -0.104> 
		<0.291, -0.261, 0.000> <0.291, -0.229, -0.031> <0.300, -0.181, -0.097> <0.295, -0.146, -0.124> 
		<0.263, -0.289, 0.000> <0.266, -0.256, -0.043> <0.276, -0.214, -0.108> <0.271, -0.172, -0.142> 
		<0.230, -0.289, 0.000> <0.233, -0.256, -0.043> <0.244, -0.220, -0.108> <0.238, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.291, -0.228, 0.000> <0.291, -0.194, 0.000> <0.263, -0.167, 0.000> <0.230, -0.167, 0.000> 
		<0.291, -0.196, -0.031> <0.291, -0.162, -0.031> <0.261, -0.142, -0.020> <0.228, -0.142, -0.020> 
		<0.295, -0.155, -0.076> <0.291, -0.130, -0.055> <0.259, -0.101, -0.043> <0.226, -0.107, -0.043> 
		<0.290, -0.121, -0.104> <0.286, -0.095, -0.083> <0.255, -0.079, -0.065> <0.222, -0.084, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.230, -0.167, 0.000> <0.197, -0.167, 0.000> <0.169, -0.194, 0.000> <0.169, -0.228, 0.000> 
		<0.228, -0.142, -0.020> <0.194, -0.142, -0.020> <0.169, -0.169, -0.031> <0.169, -0.202, -0.031> 
		<0.226, -0.107, -0.043> <0.193, -0.112, -0.043> <0.170, -0.146, -0.055> <0.174, -0.171, -0.076> 
		<0.222, -0.084, -0.065> <0.189, -0.090, -0.065> <0.165, -0.116, -0.083> <0.170, -0.142, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.169, -0.228, 0.000> <0.169, -0.261, 0.000> <0.197, -0.289, 0.000> <0.230, -0.289, 0.000> 
		<0.169, -0.202, -0.031> <0.169, -0.235, -0.031> <0.199, -0.256, -0.043> <0.233, -0.256, -0.043> 
		<0.174, -0.171, -0.076> <0.179, -0.197, -0.097> <0.211, -0.226, -0.108> <0.244, -0.220, -0.108> 
		<0.170, -0.142, -0.104> <0.174, -0.167, -0.124> <0.205, -0.184, -0.142> <0.238, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.255, 0.029, -0.207> <0.251, 0.043, -0.237> <0.221, 0.049, -0.262> <0.189, 0.040, -0.262> 
		<0.266, -0.016, -0.176> <0.262, -0.002, -0.206> <0.236, -0.017, -0.226> <0.204, -0.025, -0.226> 
		<0.284, -0.078, -0.138> <0.289, -0.103, -0.159> <0.264, -0.113, -0.189> <0.231, -0.119, -0.189> 
		<0.290, -0.121, -0.104> <0.295, -0.146, -0.124> <0.271, -0.172, -0.142> <0.238, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.255, 0.029, -0.207> <0.266, -0.016, -0.176> <0.284, -0.078, -0.138> <0.290, -0.121, -0.104> 
		<0.259, 0.014, -0.177> <0.269, -0.031, -0.146> <0.280, -0.052, -0.117> <0.286, -0.095, -0.083> 
		<0.235, -0.005, -0.152> <0.241, -0.026, -0.126> <0.250, -0.054, -0.089> <0.255, -0.079, -0.065> 
		<0.202, -0.013, -0.152> <0.208, -0.034, -0.126> <0.218, -0.060, -0.089> <0.222, -0.084, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.202, -0.013, -0.152> <0.208, -0.034, -0.126> <0.218, -0.060, -0.089> <0.222, -0.084, -0.065> 
		<0.170, -0.021, -0.152> <0.176, -0.042, -0.126> <0.185, -0.066, -0.089> <0.189, -0.090, -0.065> 
		<0.140, -0.016, -0.177> <0.150, -0.058, -0.146> <0.160, -0.077, -0.118> <0.165, -0.116, -0.083> 
		<0.136, -0.001, -0.207> <0.146, -0.043, -0.176> <0.164, -0.102, -0.139> <0.170, -0.142, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.136, -0.001, -0.207> <0.146, -0.043, -0.176> <0.164, -0.102, -0.139> <0.170, -0.142, -0.104> 
		<0.133, 0.014, -0.237> <0.143, -0.029, -0.206> <0.169, -0.128, -0.160> <0.174, -0.167, -0.124> 
		<0.157, 0.032, -0.262> <0.171, -0.033, -0.226> <0.198, -0.124, -0.189> <0.205, -0.184, -0.142> 
		<0.189, 0.040, -0.262> <0.204, -0.025, -0.226> <0.231, -0.119, -0.189> <0.238, -0.178, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, -0.248, 0.000> <-0.081, -0.241, -0.026> <-0.081, -0.238, -0.062> <-0.081, -0.226, -0.086> 
		<-0.081, -0.290, 0.000> <-0.081, -0.284, -0.026> <-0.081, -0.280, -0.072> <-0.081, -0.268, -0.095> 
		<-0.046, -0.325, 0.000> <-0.046, -0.318, -0.031> <-0.046, -0.315, -0.074> <-0.046, -0.302, -0.103> 
		<-0.004, -0.325, 0.000> <-0.004, -0.318, -0.031> <-0.004, -0.315, -0.074> <-0.004, -0.302, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, -0.248, 0.000> <-0.081, -0.206, 0.000> <-0.046, -0.170, 0.000> <-0.004, -0.170, 0.000> 
		<-0.081, -0.241, -0.026> <-0.081, -0.199, -0.026> <-0.046, -0.164, -0.021> <-0.004, -0.164, -0.021> 
		<-0.081, -0.238, -0.062> <-0.081, -0.197, -0.053> <-0.046, -0.162, -0.051> <-0.004, -0.162, -0.051> 
		<-0.081, -0.226, -0.086> <-0.081, -0.185, -0.077> <-0.046, -0.151, -0.069> <-0.004, -0.151, -0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, -0.170, 0.000> <0.039, -0.170, 0.000> <0.074, -0.206, 0.000> <0.074, -0.248, 0.000> 
		<-0.004, -0.164, -0.021> <0.039, -0.164, -0.021> <0.074, -0.199, -0.026> <0.074, -0.241, -0.026> 
		<-0.004, -0.162, -0.051> <0.039, -0.162, -0.051> <0.074, -0.197, -0.053> <0.074, -0.238, -0.062> 
		<-0.004, -0.151, -0.069> <0.039, -0.151, -0.069> <0.074, -0.185, -0.077> <0.074, -0.226, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, -0.248, 0.000> <0.074, -0.290, 0.000> <0.039, -0.325, 0.000> <-0.004, -0.325, 0.000> 
		<0.074, -0.241, -0.026> <0.074, -0.284, -0.026> <0.039, -0.318, -0.031> <-0.004, -0.318, -0.031> 
		<0.074, -0.238, -0.062> <0.074, -0.280, -0.072> <0.039, -0.315, -0.074> <-0.004, -0.315, -0.074> 
		<0.074, -0.226, -0.086> <0.074, -0.268, -0.095> <0.039, -0.302, -0.103> <-0.004, -0.302, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, -0.226, -0.086> <-0.081, -0.215, -0.108> <-0.081, -0.191, -0.132> <-0.081, -0.172, -0.147> 
		<-0.081, -0.268, -0.095> <-0.081, -0.256, -0.117> <-0.081, -0.229, -0.151> <-0.081, -0.210, -0.167> 
		<-0.046, -0.302, -0.103> <-0.046, -0.289, -0.130> <-0.046, -0.263, -0.162> <-0.046, -0.241, -0.183> 
		<-0.004, -0.302, -0.103> <-0.004, -0.289, -0.130> <-0.004, -0.263, -0.162> <-0.004, -0.241, -0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, -0.226, -0.086> <-0.081, -0.185, -0.077> <-0.046, -0.151, -0.069> <-0.004, -0.151, -0.069> 
		<-0.081, -0.215, -0.108> <-0.081, -0.174, -0.099> <-0.046, -0.141, -0.086> <-0.004, -0.141, -0.086> 
		<-0.081, -0.191, -0.132> <-0.081, -0.154, -0.112> <-0.046, -0.119, -0.101> <-0.004, -0.119, -0.101> 
		<-0.081, -0.172, -0.147> <-0.081, -0.135, -0.128> <-0.046, -0.103, -0.112> <-0.004, -0.103, -0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, -0.151, -0.069> <0.039, -0.151, -0.069> <0.074, -0.185, -0.077> <0.074, -0.226, -0.086> 
		<-0.004, -0.141, -0.086> <0.039, -0.141, -0.086> <0.074, -0.174, -0.099> <0.074, -0.215, -0.108> 
		<-0.004, -0.119, -0.101> <0.039, -0.119, -0.101> <0.074, -0.154, -0.112> <0.074, -0.191, -0.132> 
		<-0.004, -0.103, -0.112> <0.039, -0.103, -0.112> <0.074, -0.135, -0.128> <0.074, -0.172, -0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, -0.226, -0.086> <0.074, -0.268, -0.095> <0.039, -0.302, -0.103> <-0.004, -0.302, -0.103> 
		<0.074, -0.215, -0.108> <0.074, -0.256, -0.117> <0.039, -0.289, -0.130> <-0.004, -0.289, -0.130> 
		<0.074, -0.191, -0.132> <0.074, -0.229, -0.151> <0.039, -0.263, -0.162> <-0.004, -0.263, -0.162> 
		<0.074, -0.172, -0.147> <0.074, -0.210, -0.167> <0.039, -0.241, -0.183> <-0.004, -0.241, -0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, -0.172, -0.147> <-0.081, -0.158, -0.159> <-0.083, -0.136, -0.169> <-0.081, -0.119, -0.176> 
		<-0.081, -0.210, -0.167> <-0.081, -0.196, -0.178> <-0.083, -0.171, -0.192> <-0.081, -0.154, -0.199> 
		<-0.046, -0.241, -0.183> <-0.046, -0.227, -0.197> <-0.046, -0.202, -0.211> <-0.046, -0.183, -0.218> 
		<-0.004, -0.241, -0.183> <-0.004, -0.227, -0.197> <-0.004, -0.202, -0.211> <-0.004, -0.183, -0.218> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, -0.172, -0.147> <-0.081, -0.135, -0.128> <-0.046, -0.103, -0.112> <-0.004, -0.103, -0.112> 
		<-0.081, -0.158, -0.159> <-0.081, -0.121, -0.140> <-0.046, -0.090, -0.121> <-0.004, -0.090, -0.121> 
		<-0.083, -0.136, -0.169> <-0.083, -0.100, -0.146> <-0.046, -0.069, -0.129> <-0.004, -0.069, -0.129> 
		<-0.081, -0.119, -0.176> <-0.081, -0.083, -0.153> <-0.046, -0.054, -0.134> <-0.004, -0.054, -0.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, -0.103, -0.112> <0.039, -0.103, -0.112> <0.074, -0.135, -0.128> <0.074, -0.172, -0.147> 
		<-0.004, -0.090, -0.121> <0.039, -0.090, -0.121> <0.074, -0.121, -0.140> <0.074, -0.158, -0.159> 
		<-0.004, -0.069, -0.129> <0.038, -0.069, -0.129> <0.075, -0.100, -0.146> <0.075, -0.136, -0.169> 
		<-0.004, -0.054, -0.134> <0.039, -0.054, -0.134> <0.074, -0.083, -0.153> <0.074, -0.119, -0.176> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, -0.172, -0.147> <0.074, -0.210, -0.167> <0.039, -0.241, -0.183> <-0.004, -0.241, -0.183> 
		<0.074, -0.158, -0.159> <0.074, -0.196, -0.178> <0.039, -0.227, -0.197> <-0.004, -0.227, -0.197> 
		<0.075, -0.136, -0.169> <0.075, -0.171, -0.192> <0.039, -0.202, -0.211> <-0.004, -0.202, -0.211> 
		<0.074, -0.119, -0.176> <0.074, -0.154, -0.199> <0.039, -0.183, -0.218> <-0.004, -0.183, -0.218> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.067, -0.032, -0.201> <-0.067, -0.033, -0.237> <-0.037, -0.033, -0.266> <-0.002, -0.033, -0.266> 
		<-0.071, -0.058, -0.194> <-0.071, -0.059, -0.229> <-0.038, -0.078, -0.252> <-0.002, -0.078, -0.252> 
		<-0.078, -0.093, -0.186> <-0.078, -0.128, -0.209> <-0.045, -0.140, -0.236> <-0.003, -0.140, -0.236> 
		<-0.081, -0.119, -0.176> <-0.081, -0.154, -0.199> <-0.046, -0.183, -0.218> <-0.004, -0.183, -0.218> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.067, -0.032, -0.201> <-0.071, -0.058, -0.194> <-0.078, -0.093, -0.186> <-0.081, -0.119, -0.176> 
		<-0.067, -0.031, -0.166> <-0.071, -0.057, -0.158> <-0.078, -0.058, -0.163> <-0.081, -0.083, -0.153> 
		<-0.037, -0.030, -0.136> <-0.038, -0.037, -0.135> <-0.046, -0.047, -0.136> <-0.046, -0.054, -0.134> 
		<-0.002, -0.030, -0.136> <-0.002, -0.037, -0.135> <-0.003, -0.047, -0.136> <-0.004, -0.054, -0.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, -0.030, -0.136> <-0.002, -0.037, -0.135> <-0.003, -0.047, -0.136> <-0.004, -0.054, -0.134> 
		<0.034, -0.030, -0.136> <0.033, -0.037, -0.135> <0.039, -0.047, -0.136> <0.039, -0.054, -0.134> 
		<0.063, -0.031, -0.166> <0.066, -0.057, -0.158> <0.072, -0.058, -0.163> <0.074, -0.083, -0.153> 
		<0.063, -0.032, -0.201> <0.066, -0.058, -0.194> <0.072, -0.093, -0.186> <0.074, -0.119, -0.176> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, -0.032, -0.201> <0.066, -0.058, -0.194> <0.072, -0.093, -0.186> <0.074, -0.119, -0.176> 
		<0.063, -0.033, -0.237> <0.066, -0.059, -0.229> <0.072, -0.129, -0.209> <0.074, -0.154, -0.199> 
		<0.034, -0.033, -0.266> <0.033, -0.078, -0.252> <0.039, -0.140, -0.236> <0.039, -0.183, -0.218> 
		<-0.002, -0.033, -0.266> <-0.002, -0.078, -0.252> <-0.003, -0.140, -0.236> <-0.004, -0.183, -0.218> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.357, -0.083, 0.000> <-0.351, -0.083, -0.015> <-0.351, -0.083, -0.041> <-0.338, -0.083, -0.051> 
		<-0.357, -0.097, 0.000> <-0.351, -0.097, -0.015> <-0.351, -0.096, -0.041> <-0.338, -0.096, -0.051> 
		<-0.345, -0.109, 0.000> <-0.343, -0.109, -0.010> <-0.341, -0.109, -0.036> <-0.333, -0.109, -0.042> 
		<-0.330, -0.109, 0.000> <-0.328, -0.109, -0.010> <-0.331, -0.109, -0.027> <-0.323, -0.109, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.357, -0.083, 0.000> <-0.357, -0.068, 0.000> <-0.345, -0.056, 0.000> <-0.330, -0.056, 0.000> 
		<-0.351, -0.083, -0.015> <-0.351, -0.068, -0.015> <-0.343, -0.056, -0.010> <-0.328, -0.056, -0.010> 
		<-0.351, -0.083, -0.041> <-0.351, -0.069, -0.041> <-0.341, -0.056, -0.036> <-0.331, -0.056, -0.027> 
		<-0.338, -0.083, -0.051> <-0.338, -0.069, -0.051> <-0.333, -0.056, -0.042> <-0.323, -0.056, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.330, -0.056, 0.000> <-0.316, -0.056, 0.000> <-0.304, -0.068, 0.000> <-0.304, -0.083, 0.000> 
		<-0.328, -0.056, -0.010> <-0.314, -0.056, -0.010> <-0.303, -0.068, -0.004> <-0.303, -0.083, -0.004> 
		<-0.331, -0.056, -0.027> <-0.321, -0.056, -0.016> <-0.305, -0.068, -0.012> <-0.305, -0.083, -0.012> 
		<-0.323, -0.056, -0.032> <-0.313, -0.056, -0.022> <-0.301, -0.068, -0.014> <-0.301, -0.083, -0.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.304, -0.083, 0.000> <-0.304, -0.097, 0.000> <-0.316, -0.109, 0.000> <-0.330, -0.109, 0.000> 
		<-0.303, -0.083, -0.004> <-0.303, -0.097, -0.004> <-0.314, -0.109, -0.010> <-0.328, -0.109, -0.010> 
		<-0.305, -0.083, -0.012> <-0.305, -0.098, -0.012> <-0.321, -0.109, -0.016> <-0.331, -0.109, -0.027> 
		<-0.301, -0.083, -0.014> <-0.301, -0.098, -0.014> <-0.313, -0.109, -0.022> <-0.323, -0.109, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.083, -0.051> <-0.322, -0.083, -0.063> <-0.293, -0.083, -0.065> <-0.273, -0.083, -0.066> 
		<-0.338, -0.096, -0.051> <-0.322, -0.096, -0.063> <-0.293, -0.097, -0.065> <-0.273, -0.097, -0.066> 
		<-0.333, -0.109, -0.042> <-0.320, -0.109, -0.051> <-0.288, -0.109, -0.054> <-0.273, -0.109, -0.054> 
		<-0.323, -0.109, -0.032> <-0.311, -0.109, -0.041> <-0.288, -0.109, -0.039> <-0.273, -0.109, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.338, -0.083, -0.051> <-0.338, -0.069, -0.051> <-0.333, -0.056, -0.042> <-0.323, -0.056, -0.032> 
		<-0.322, -0.083, -0.063> <-0.322, -0.069, -0.063> <-0.320, -0.056, -0.051> <-0.311, -0.056, -0.041> 
		<-0.293, -0.083, -0.065> <-0.293, -0.068, -0.065> <-0.288, -0.056, -0.054> <-0.288, -0.056, -0.039> 
		<-0.273, -0.083, -0.066> <-0.273, -0.068, -0.066> <-0.273, -0.056, -0.054> <-0.273, -0.056, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.323, -0.056, -0.032> <-0.313, -0.056, -0.022> <-0.301, -0.068, -0.014> <-0.301, -0.083, -0.014> 
		<-0.311, -0.056, -0.041> <-0.300, -0.056, -0.030> <-0.294, -0.068, -0.017> <-0.294, -0.083, -0.017> 
		<-0.288, -0.056, -0.039> <-0.288, -0.056, -0.025> <-0.282, -0.068, -0.013> <-0.282, -0.083, -0.013> 
		<-0.273, -0.056, -0.040> <-0.273, -0.056, -0.025> <-0.273, -0.068, -0.013> <-0.273, -0.083, -0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.301, -0.083, -0.014> <-0.301, -0.098, -0.014> <-0.313, -0.109, -0.022> <-0.323, -0.109, -0.032> 
		<-0.294, -0.083, -0.017> <-0.294, -0.098, -0.017> <-0.300, -0.109, -0.030> <-0.311, -0.109, -0.041> 
		<-0.282, -0.083, -0.013> <-0.282, -0.097, -0.013> <-0.288, -0.109, -0.025> <-0.288, -0.109, -0.039> 
		<-0.273, -0.083, -0.013> <-0.273, -0.097, -0.013> <-0.273, -0.109, -0.025> <-0.273, -0.109, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.273, -0.083, -0.066> <-0.108, -0.083, -0.070> <0.112, -0.083, -0.072> <0.277, -0.083, -0.066> 
		<-0.273, -0.097, -0.066> <-0.108, -0.097, -0.070> <0.112, -0.097, -0.072> <0.277, -0.097, -0.066> 
		<-0.273, -0.109, -0.054> <-0.108, -0.109, -0.056> <0.112, -0.109, -0.056> <0.277, -0.109, -0.054> 
		<-0.273, -0.109, -0.040> <-0.108, -0.109, -0.041> <0.112, -0.109, -0.041> <0.277, -0.109, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.273, -0.083, -0.066> <-0.273, -0.068, -0.066> <-0.273, -0.056, -0.054> <-0.273, -0.056, -0.040> 
		<-0.108, -0.083, -0.070> <-0.108, -0.068, -0.070> <-0.108, -0.056, -0.056> <-0.108, -0.056, -0.041> 
		<0.112, -0.083, -0.072> <0.112, -0.068, -0.072> <0.112, -0.056, -0.055> <0.112, -0.056, -0.040> 
		<0.277, -0.083, -0.066> <0.277, -0.068, -0.066> <0.277, -0.056, -0.054> <0.277, -0.056, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.273, -0.056, -0.040> <-0.273, -0.056, -0.025> <-0.273, -0.068, -0.013> <-0.273, -0.083, -0.013> 
		<-0.108, -0.056, -0.041> <-0.108, -0.056, -0.027> <-0.108, -0.068, -0.013> <-0.108, -0.083, -0.013> 
		<0.112, -0.056, -0.040> <0.112, -0.056, -0.026> <0.111, -0.068, -0.012> <0.111, -0.083, -0.012> 
		<0.277, -0.056, -0.040> <0.276, -0.056, -0.025> <0.276, -0.068, -0.013> <0.276, -0.083, -0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.273, -0.083, -0.013> <-0.273, -0.097, -0.013> <-0.273, -0.109, -0.025> <-0.273, -0.109, -0.040> 
		<-0.108, -0.083, -0.013> <-0.108, -0.097, -0.013> <-0.108, -0.109, -0.027> <-0.108, -0.109, -0.041> 
		<0.111, -0.083, -0.012> <0.111, -0.097, -0.012> <0.112, -0.109, -0.027> <0.112, -0.109, -0.041> 
		<0.276, -0.083, -0.013> <0.276, -0.097, -0.013> <0.276, -0.109, -0.025> <0.277, -0.109, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.277, -0.083, -0.066> <0.302, -0.083, -0.065> <0.336, -0.083, -0.054> <0.358, -0.083, -0.042> 
		<0.277, -0.097, -0.066> <0.302, -0.097, -0.065> <0.337, -0.097, -0.053> <0.359, -0.097, -0.041> 
		<0.277, -0.109, -0.054> <0.294, -0.109, -0.054> <0.329, -0.109, -0.047> <0.346, -0.109, -0.041> 
		<0.277, -0.109, -0.040> <0.294, -0.109, -0.039> <0.318, -0.109, -0.038> <0.334, -0.109, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.277, -0.083, -0.066> <0.277, -0.068, -0.066> <0.277, -0.056, -0.054> <0.277, -0.056, -0.040> 
		<0.302, -0.083, -0.065> <0.302, -0.068, -0.065> <0.293, -0.056, -0.054> <0.293, -0.056, -0.039> 
		<0.336, -0.083, -0.054> <0.335, -0.068, -0.055> <0.327, -0.056, -0.050> <0.315, -0.056, -0.042> 
		<0.358, -0.083, -0.042> <0.357, -0.068, -0.043> <0.343, -0.056, -0.044> <0.330, -0.056, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.277, -0.056, -0.040> <0.276, -0.056, -0.025> <0.276, -0.068, -0.013> <0.276, -0.083, -0.013> 
		<0.293, -0.056, -0.039> <0.293, -0.056, -0.025> <0.290, -0.068, -0.013> <0.290, -0.083, -0.013> 
		<0.315, -0.056, -0.042> <0.304, -0.056, -0.034> <0.307, -0.069, -0.018> <0.307, -0.083, -0.017> 
		<0.330, -0.056, -0.036> <0.319, -0.056, -0.028> <0.320, -0.069, -0.017> <0.321, -0.083, -0.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.276, -0.083, -0.013> <0.276, -0.097, -0.013> <0.276, -0.109, -0.025> <0.277, -0.109, -0.040> 
		<0.290, -0.083, -0.013> <0.290, -0.097, -0.013> <0.294, -0.109, -0.025> <0.294, -0.109, -0.039> 
		<0.307, -0.083, -0.017> <0.308, -0.096, -0.016> <0.307, -0.109, -0.031> <0.318, -0.109, -0.038> 
		<0.321, -0.083, -0.016> <0.322, -0.096, -0.015> <0.323, -0.109, -0.025> <0.334, -0.109, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.083, -0.001> <0.400, -0.097, -0.001> <0.388, -0.109, -0.002> <0.374, -0.109, -0.004> 
		<0.387, -0.083, -0.013> <0.387, -0.097, -0.013> <0.376, -0.109, -0.011> <0.362, -0.109, -0.012> 
		<0.374, -0.083, -0.034> <0.374, -0.097, -0.033> <0.359, -0.109, -0.035> <0.348, -0.109, -0.027> 
		<0.358, -0.083, -0.042> <0.359, -0.097, -0.041> <0.346, -0.109, -0.041> <0.334, -0.109, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.083, -0.001> <0.387, -0.083, -0.013> <0.374, -0.083, -0.034> <0.358, -0.083, -0.042> 
		<0.400, -0.068, -0.001> <0.387, -0.068, -0.013> <0.373, -0.068, -0.035> <0.357, -0.068, -0.043> 
		<0.388, -0.056, -0.002> <0.375, -0.056, -0.012> <0.358, -0.056, -0.039> <0.343, -0.056, -0.044> 
		<0.374, -0.056, -0.004> <0.361, -0.056, -0.013> <0.346, -0.056, -0.030> <0.330, -0.056, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.374, -0.056, -0.004> <0.361, -0.056, -0.013> <0.346, -0.056, -0.030> <0.330, -0.056, -0.036> 
		<0.359, -0.056, -0.005> <0.346, -0.056, -0.015> <0.335, -0.056, -0.023> <0.319, -0.056, -0.028> 
		<0.347, -0.068, -0.006> <0.339, -0.068, -0.009> <0.328, -0.069, -0.016> <0.320, -0.069, -0.017> 
		<0.347, -0.083, -0.006> <0.339, -0.083, -0.009> <0.329, -0.083, -0.015> <0.321, -0.083, -0.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.347, -0.083, -0.006> <0.339, -0.083, -0.009> <0.329, -0.083, -0.015> <0.321, -0.083, -0.016> 
		<0.347, -0.097, -0.006> <0.339, -0.097, -0.009> <0.330, -0.096, -0.014> <0.322, -0.096, -0.015> 
		<0.359, -0.109, -0.005> <0.347, -0.109, -0.013> <0.337, -0.109, -0.020> <0.323, -0.109, -0.025> 
		<0.374, -0.109, -0.004> <0.362, -0.109, -0.012> <0.348, -0.109, -0.027> <0.334, -0.109, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.368, -0.262, 0.000> <-0.347, -0.241, 0.000> <-0.323, -0.241, 0.000> 
		<-0.385, -0.287, -0.013> <-0.385, -0.262, -0.013> <-0.347, -0.269, 0.021> <-0.323, -0.269, 0.021> 
		<-0.344, -0.287, -0.034> <-0.344, -0.308, -0.034> <-0.323, -0.322, 0.008> <-0.323, -0.304, 0.021> 
		<-0.323, -0.287, -0.034> <-0.323, -0.308, -0.034> <-0.323, -0.349, -0.013> <-0.323, -0.332, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.385, -0.287, -0.013> <-0.344, -0.287, -0.034> <-0.323, -0.287, -0.034> 
		<-0.340, -0.287, 0.021> <-0.358, -0.287, 0.008> <-0.344, -0.308, -0.034> <-0.323, -0.308, -0.034> 
		<-0.305, -0.287, 0.021> <-0.305, -0.311, 0.021> <-0.298, -0.349, -0.013> <-0.323, -0.349, -0.013> 
		<-0.277, -0.287, 0.000> <-0.277, -0.311, 0.000> <-0.298, -0.332, 0.000> <-0.323, -0.332, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> 
		<-0.368, -0.311, 0.000> <-0.385, -0.311, -0.013> <-0.385, -0.311, -0.013> <-0.385, -0.287, -0.013> 
		<-0.347, -0.332, 0.000> <-0.347, -0.349, -0.013> <-0.344, -0.308, -0.034> <-0.344, -0.287, -0.034> 
		<-0.323, -0.332, 0.000> <-0.323, -0.349, -0.013> <-0.323, -0.308, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.385, -0.287, -0.013> <-0.344, -0.287, -0.034> <-0.323, -0.287, -0.034> 
		<-0.368, -0.311, 0.000> <-0.385, -0.311, -0.013> <-0.344, -0.265, -0.034> <-0.323, -0.265, -0.034> 
		<-0.347, -0.332, 0.000> <-0.347, -0.304, 0.021> <-0.323, -0.252, 0.008> <-0.323, -0.224, -0.013> 
		<-0.323, -0.332, 0.000> <-0.323, -0.304, 0.021> <-0.323, -0.269, 0.021> <-0.323, -0.241, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> 
		<-0.368, -0.262, 0.000> <-0.385, -0.262, -0.013> <-0.385, -0.262, -0.013> <-0.385, -0.287, -0.013> 
		<-0.347, -0.241, 0.000> <-0.347, -0.224, -0.013> <-0.344, -0.265, -0.034> <-0.344, -0.287, -0.034> 
		<-0.323, -0.241, 0.000> <-0.323, -0.224, -0.013> <-0.323, -0.265, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.385, -0.287, -0.013> <-0.344, -0.287, -0.034> <-0.323, -0.287, -0.034> 
		<-0.340, -0.287, 0.021> <-0.358, -0.287, 0.008> <-0.344, -0.265, -0.034> <-0.323, -0.265, -0.034> 
		<-0.305, -0.287, 0.021> <-0.305, -0.262, 0.021> <-0.298, -0.224, -0.013> <-0.323, -0.224, -0.013> 
		<-0.277, -0.287, 0.000> <-0.277, -0.262, 0.000> <-0.298, -0.241, 0.000> <-0.323, -0.241, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.385, -0.287, -0.013> <-0.344, -0.287, -0.034> <-0.323, -0.287, -0.034> 
		<-0.368, -0.262, 0.000> <-0.385, -0.262, -0.013> <-0.323, -0.287, -0.034> <-0.301, -0.287, -0.034> 
		<-0.347, -0.241, 0.000> <-0.323, -0.241, 0.000> <-0.260, -0.262, -0.013> <-0.260, -0.287, -0.013> 
		<-0.323, -0.241, 0.000> <-0.298, -0.241, 0.000> <-0.277, -0.262, 0.000> <-0.277, -0.287, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.385, -0.287, -0.013> <-0.344, -0.287, -0.034> <-0.323, -0.287, -0.034> 
		<-0.368, -0.311, 0.000> <-0.385, -0.311, -0.013> <-0.323, -0.287, -0.034> <-0.301, -0.287, -0.034> 
		<-0.347, -0.332, 0.000> <-0.323, -0.332, 0.000> <-0.260, -0.311, -0.013> <-0.260, -0.287, -0.013> 
		<-0.323, -0.332, 0.000> <-0.298, -0.332, 0.000> <-0.277, -0.311, 0.000> <-0.277, -0.287, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.340, -0.287, 0.021> <-0.305, -0.287, 0.021> <-0.277, -0.287, 0.000> 
		<-0.368, -0.311, 0.000> <-0.340, -0.311, 0.021> <-0.288, -0.287, 0.008> <-0.260, -0.287, -0.013> 
		<-0.347, -0.332, 0.000> <-0.347, -0.349, -0.013> <-0.301, -0.308, -0.034> <-0.301, -0.287, -0.034> 
		<-0.323, -0.332, 0.000> <-0.323, -0.349, -0.013> <-0.323, -0.308, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.340, -0.287, 0.021> <-0.305, -0.287, 0.021> <-0.277, -0.287, 0.000> 
		<-0.368, -0.262, 0.000> <-0.340, -0.262, 0.021> <-0.288, -0.287, 0.008> <-0.260, -0.287, -0.013> 
		<-0.347, -0.241, 0.000> <-0.347, -0.224, -0.013> <-0.301, -0.265, -0.034> <-0.301, -0.287, -0.034> 
		<-0.323, -0.241, 0.000> <-0.323, -0.224, -0.013> <-0.323, -0.265, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.340, -0.287, 0.021> <-0.305, -0.287, 0.021> <-0.277, -0.287, 0.000> 
		<-0.368, -0.311, 0.000> <-0.340, -0.311, 0.021> <-0.305, -0.262, 0.021> <-0.277, -0.262, 0.000> 
		<-0.347, -0.332, 0.000> <-0.347, -0.304, 0.021> <-0.298, -0.269, 0.021> <-0.298, -0.241, 0.000> 
		<-0.323, -0.332, 0.000> <-0.323, -0.304, 0.021> <-0.323, -0.269, 0.021> <-0.323, -0.241, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> 
		<-0.368, -0.262, 0.000> <-0.340, -0.262, 0.021> <-0.340, -0.262, 0.021> <-0.340, -0.287, 0.021> 
		<-0.347, -0.241, 0.000> <-0.323, -0.241, 0.000> <-0.305, -0.262, 0.021> <-0.305, -0.287, 0.021> 
		<-0.323, -0.241, 0.000> <-0.298, -0.241, 0.000> <-0.277, -0.262, 0.000> <-0.277, -0.287, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.340, -0.287, 0.021> <-0.305, -0.287, 0.021> <-0.277, -0.287, 0.000> 
		<-0.368, -0.262, 0.000> <-0.340, -0.262, 0.021> <-0.305, -0.311, 0.021> <-0.277, -0.311, 0.000> 
		<-0.347, -0.241, 0.000> <-0.347, -0.269, 0.021> <-0.298, -0.304, 0.021> <-0.298, -0.332, 0.000> 
		<-0.323, -0.241, 0.000> <-0.323, -0.269, 0.021> <-0.323, -0.304, 0.021> <-0.323, -0.332, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> 
		<-0.368, -0.311, 0.000> <-0.340, -0.311, 0.021> <-0.340, -0.311, 0.021> <-0.340, -0.287, 0.021> 
		<-0.347, -0.332, 0.000> <-0.323, -0.332, 0.000> <-0.305, -0.311, 0.021> <-0.305, -0.287, 0.021> 
		<-0.323, -0.332, 0.000> <-0.298, -0.332, 0.000> <-0.277, -0.311, 0.000> <-0.277, -0.287, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> 
		<-0.368, -0.262, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.287, 0.000> <-0.368, -0.311, 0.000> 
		<-0.347, -0.241, 0.000> <-0.347, -0.269, 0.021> <-0.347, -0.304, 0.021> <-0.347, -0.332, 0.000> 
		<-0.323, -0.241, 0.000> <-0.323, -0.269, 0.021> <-0.323, -0.304, 0.021> <-0.323, -0.332, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, -0.287, 0.000> <-0.368, -0.311, 0.000> <-0.347, -0.332, 0.000> <-0.323, -0.332, 0.000> 
		<-0.368, -0.262, 0.000> <-0.368, -0.287, 0.000> <-0.347, -0.349, -0.013> <-0.323, -0.349, -0.013> 
		<-0.347, -0.241, 0.000> <-0.347, -0.224, -0.013> <-0.323, -0.287, -0.034> <-0.323, -0.308, -0.034> 
		<-0.323, -0.241, 0.000> <-0.323, -0.224, -0.013> <-0.323, -0.265, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, -0.287, 0.000> <-0.260, -0.287, -0.013> <-0.301, -0.287, -0.034> <-0.323, -0.287, -0.034> 
		<-0.277, -0.262, 0.000> <-0.260, -0.262, -0.013> <-0.301, -0.308, -0.034> <-0.323, -0.308, -0.034> 
		<-0.298, -0.241, 0.000> <-0.298, -0.269, 0.021> <-0.323, -0.322, 0.008> <-0.323, -0.349, -0.013> 
		<-0.323, -0.241, 0.000> <-0.323, -0.269, 0.021> <-0.323, -0.304, 0.021> <-0.323, -0.332, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> 
		<-0.277, -0.311, 0.000> <-0.260, -0.311, -0.013> <-0.260, -0.311, -0.013> <-0.260, -0.287, -0.013> 
		<-0.298, -0.332, 0.000> <-0.298, -0.349, -0.013> <-0.301, -0.308, -0.034> <-0.301, -0.287, -0.034> 
		<-0.323, -0.332, 0.000> <-0.323, -0.349, -0.013> <-0.323, -0.308, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, -0.287, 0.000> <-0.260, -0.287, -0.013> <-0.301, -0.287, -0.034> <-0.323, -0.287, -0.034> 
		<-0.277, -0.311, 0.000> <-0.260, -0.311, -0.013> <-0.301, -0.265, -0.034> <-0.323, -0.265, -0.034> 
		<-0.298, -0.332, 0.000> <-0.298, -0.304, 0.021> <-0.323, -0.252, 0.008> <-0.323, -0.224, -0.013> 
		<-0.323, -0.332, 0.000> <-0.323, -0.304, 0.021> <-0.323, -0.269, 0.021> <-0.323, -0.241, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> 
		<-0.277, -0.262, 0.000> <-0.260, -0.262, -0.013> <-0.260, -0.262, -0.013> <-0.260, -0.287, -0.013> 
		<-0.298, -0.241, 0.000> <-0.298, -0.224, -0.013> <-0.301, -0.265, -0.034> <-0.301, -0.287, -0.034> 
		<-0.323, -0.241, 0.000> <-0.323, -0.224, -0.013> <-0.323, -0.265, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, -0.287, 0.000> <-0.277, -0.262, 0.000> <-0.298, -0.241, 0.000> <-0.323, -0.241, 0.000> 
		<-0.277, -0.311, 0.000> <-0.277, -0.287, 0.000> <-0.298, -0.224, -0.013> <-0.323, -0.224, -0.013> 
		<-0.298, -0.332, 0.000> <-0.298, -0.349, -0.013> <-0.323, -0.287, -0.034> <-0.323, -0.265, -0.034> 
		<-0.323, -0.332, 0.000> <-0.323, -0.349, -0.013> <-0.323, -0.308, -0.034> <-0.323, -0.287, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> 
		<-0.277, -0.311, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.287, 0.000> <-0.277, -0.262, 0.000> 
		<-0.298, -0.332, 0.000> <-0.298, -0.304, 0.021> <-0.298, -0.269, 0.021> <-0.298, -0.241, 0.000> 
		<-0.323, -0.332, 0.000> <-0.323, -0.304, 0.021> <-0.323, -0.269, 0.021> <-0.323, -0.241, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, -0.345, 0.000> <0.194, -0.324, -0.014> <0.145, -0.307, -0.039> <0.120, -0.276, -0.047> 
		<0.226, -0.362, 0.000> <0.194, -0.341, -0.014> <0.135, -0.313, -0.049> <0.110, -0.282, -0.057> 
		<0.240, -0.376, 0.000> <0.200, -0.354, -0.022> <0.140, -0.334, -0.053> <0.110, -0.296, -0.069> 
		<0.257, -0.376, 0.000> <0.217, -0.354, -0.022> <0.151, -0.342, -0.058> <0.122, -0.304, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, -0.345, 0.000> <0.226, -0.328, 0.000> <0.240, -0.314, 0.000> <0.257, -0.314, 0.000> 
		<0.194, -0.324, -0.014> <0.194, -0.307, -0.014> <0.210, -0.304, -0.011> <0.227, -0.304, -0.011> 
		<0.145, -0.307, -0.039> <0.154, -0.301, -0.029> <0.168, -0.296, -0.023> <0.180, -0.304, -0.028> 
		<0.120, -0.276, -0.047> <0.129, -0.270, -0.037> <0.146, -0.273, -0.031> <0.157, -0.281, -0.037> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.257, -0.314, 0.000> <0.274, -0.314, 0.000> <0.288, -0.328, 0.000> <0.288, -0.345, 0.000> 
		<0.227, -0.304, -0.011> <0.244, -0.304, -0.011> <0.250, -0.316, -0.020> <0.250, -0.333, -0.020> 
		<0.180, -0.304, -0.028> <0.191, -0.312, -0.033> <0.198, -0.330, -0.040> <0.189, -0.336, -0.050> 
		<0.157, -0.281, -0.037> <0.168, -0.289, -0.041> <0.170, -0.299, -0.056> <0.161, -0.304, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.288, -0.345, 0.000> <0.288, -0.362, 0.000> <0.274, -0.376, 0.000> <0.257, -0.376, 0.000> 
		<0.250, -0.333, -0.020> <0.250, -0.349, -0.020> <0.233, -0.354, -0.022> <0.217, -0.354, -0.022> 
		<0.189, -0.336, -0.050> <0.179, -0.342, -0.060> <0.163, -0.351, -0.063> <0.151, -0.342, -0.058> 
		<0.161, -0.304, -0.065> <0.151, -0.311, -0.075> <0.134, -0.313, -0.079> <0.122, -0.304, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, -0.276, -0.047> <0.105, -0.257, -0.053> <0.110, -0.216, -0.053> <0.106, -0.195, -0.041> 
		<0.110, -0.282, -0.057> <0.095, -0.263, -0.063> <0.098, -0.212, -0.066> <0.095, -0.191, -0.054> 
		<0.110, -0.296, -0.069> <0.088, -0.268, -0.081> <0.097, -0.219, -0.089> <0.094, -0.186, -0.072> 
		<0.122, -0.304, -0.074> <0.100, -0.277, -0.086> <0.109, -0.215, -0.101> <0.105, -0.182, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, -0.276, -0.047> <0.129, -0.270, -0.037> <0.146, -0.273, -0.031> <0.157, -0.281, -0.037> 
		<0.105, -0.257, -0.053> <0.114, -0.251, -0.042> <0.128, -0.255, -0.038> <0.140, -0.264, -0.043> 
		<0.110, -0.216, -0.053> <0.119, -0.220, -0.043> <0.137, -0.224, -0.041> <0.147, -0.221, -0.051> 
		<0.106, -0.195, -0.041> <0.115, -0.199, -0.031> <0.133, -0.201, -0.032> <0.143, -0.198, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.157, -0.281, -0.037> <0.168, -0.289, -0.041> <0.170, -0.299, -0.056> <0.161, -0.304, -0.065> 
		<0.140, -0.264, -0.043> <0.151, -0.271, -0.048> <0.146, -0.273, -0.068> <0.137, -0.278, -0.078> 
		<0.147, -0.221, -0.051> <0.157, -0.218, -0.062> <0.156, -0.221, -0.083> <0.146, -0.216, -0.094> 
		<0.143, -0.198, -0.042> <0.153, -0.194, -0.053> <0.152, -0.187, -0.068> <0.142, -0.183, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, -0.304, -0.065> <0.151, -0.311, -0.075> <0.134, -0.313, -0.079> <0.122, -0.304, -0.074> 
		<0.137, -0.278, -0.078> <0.128, -0.285, -0.088> <0.112, -0.285, -0.091> <0.100, -0.277, -0.086> 
		<0.146, -0.216, -0.094> <0.137, -0.213, -0.104> <0.119, -0.212, -0.111> <0.109, -0.215, -0.101> 
		<0.142, -0.183, -0.079> <0.133, -0.179, -0.089> <0.115, -0.179, -0.094> <0.105, -0.182, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, -0.192, 0.000> <0.096, -0.182, 0.001> <0.095, -0.166, 0.002> <0.105, -0.155, 0.002> 
		<0.106, -0.193, -0.012> <0.096, -0.183, -0.011> <0.095, -0.174, -0.023> <0.105, -0.163, -0.024> 
		<0.104, -0.184, -0.035> <0.093, -0.180, -0.047> <0.091, -0.162, -0.059> <0.103, -0.158, -0.071> 
		<0.106, -0.195, -0.041> <0.095, -0.191, -0.054> <0.094, -0.186, -0.072> <0.105, -0.182, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, -0.192, 0.000> <0.106, -0.193, -0.012> <0.104, -0.184, -0.035> <0.106, -0.195, -0.041> 
		<0.116, -0.202, -0.001> <0.116, -0.203, -0.013> <0.113, -0.188, -0.025> <0.115, -0.199, -0.031> 
		<0.133, -0.202, -0.002> <0.133, -0.203, -0.014> <0.131, -0.190, -0.028> <0.133, -0.201, -0.032> 
		<0.143, -0.191, -0.002> <0.143, -0.193, -0.014> <0.141, -0.186, -0.038> <0.143, -0.198, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.143, -0.191, -0.002> <0.143, -0.193, -0.014> <0.141, -0.186, -0.038> <0.143, -0.198, -0.042> 
		<0.153, -0.181, -0.002> <0.153, -0.183, -0.014> <0.151, -0.183, -0.049> <0.153, -0.194, -0.053> 
		<0.152, -0.164, -0.001> <0.152, -0.173, -0.025> <0.149, -0.164, -0.058> <0.152, -0.187, -0.068> 
		<0.142, -0.154, -0.000> <0.142, -0.163, -0.024> <0.139, -0.160, -0.069> <0.142, -0.183, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, -0.154, -0.000> <0.142, -0.163, -0.024> <0.139, -0.160, -0.069> <0.142, -0.183, -0.079> 
		<0.132, -0.145, 0.001> <0.132, -0.153, -0.023> <0.130, -0.156, -0.079> <0.133, -0.179, -0.089> 
		<0.115, -0.145, 0.002> <0.115, -0.153, -0.024> <0.112, -0.155, -0.081> <0.115, -0.179, -0.094> 
		<0.105, -0.155, 0.002> <0.105, -0.163, -0.024> <0.103, -0.158, -0.071> <0.105, -0.182, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.057, -0.144, -0.002> <-0.083, -0.164, -0.016> <-0.119, -0.187, -0.039> <-0.143, -0.211, -0.050> 
		<-0.057, -0.127, -0.002> <-0.083, -0.147, -0.016> <-0.128, -0.181, -0.049> <-0.153, -0.205, -0.060> 
		<-0.043, -0.113, -0.002> <-0.078, -0.134, -0.024> <-0.124, -0.160, -0.053> <-0.153, -0.191, -0.071> 
		<-0.026, -0.113, -0.002> <-0.061, -0.134, -0.024> <-0.113, -0.152, -0.058> <-0.142, -0.182, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.057, -0.144, -0.002> <-0.057, -0.161, -0.002> <-0.043, -0.175, -0.002> <-0.026, -0.175, -0.002> 
		<-0.083, -0.164, -0.016> <-0.083, -0.181, -0.016> <-0.067, -0.184, -0.013> <-0.050, -0.184, -0.013> 
		<-0.119, -0.187, -0.039> <-0.109, -0.193, -0.029> <-0.096, -0.199, -0.024> <-0.084, -0.191, -0.029> 
		<-0.143, -0.211, -0.050> <-0.134, -0.217, -0.039> <-0.118, -0.214, -0.034> <-0.106, -0.206, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.026, -0.175, -0.002> <-0.009, -0.175, -0.002> <0.005, -0.161, -0.002> <0.005, -0.144, -0.002> 
		<-0.050, -0.184, -0.013> <-0.033, -0.184, -0.013> <-0.028, -0.172, -0.022> <-0.028, -0.155, -0.022> 
		<-0.084, -0.191, -0.029> <-0.073, -0.183, -0.034> <-0.067, -0.165, -0.041> <-0.076, -0.159, -0.050> 
		<-0.106, -0.206, -0.039> <-0.095, -0.198, -0.043> <-0.094, -0.188, -0.058> <-0.103, -0.182, -0.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, -0.144, -0.002> <0.005, -0.127, -0.002> <-0.009, -0.113, -0.002> <-0.026, -0.113, -0.002> 
		<-0.028, -0.155, -0.022> <-0.028, -0.139, -0.022> <-0.044, -0.134, -0.024> <-0.061, -0.134, -0.024> 
		<-0.076, -0.159, -0.050> <-0.085, -0.153, -0.061> <-0.101, -0.143, -0.063> <-0.113, -0.152, -0.058> 
		<-0.103, -0.182, -0.067> <-0.112, -0.176, -0.078> <-0.130, -0.174, -0.082> <-0.142, -0.182, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, -0.211, -0.050> <-0.150, -0.218, -0.052> <-0.155, -0.235, -0.052> <-0.157, -0.241, -0.044> 
		<-0.153, -0.205, -0.060> <-0.160, -0.212, -0.062> <-0.166, -0.240, -0.064> <-0.168, -0.245, -0.056> 
		<-0.153, -0.191, -0.071> <-0.167, -0.205, -0.080> <-0.167, -0.232, -0.087> <-0.170, -0.250, -0.074> 
		<-0.142, -0.182, -0.076> <-0.156, -0.197, -0.085> <-0.155, -0.236, -0.099> <-0.158, -0.254, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, -0.211, -0.050> <-0.134, -0.217, -0.039> <-0.118, -0.214, -0.034> <-0.106, -0.206, -0.039> 
		<-0.150, -0.218, -0.052> <-0.141, -0.224, -0.042> <-0.126, -0.219, -0.037> <-0.114, -0.211, -0.042> 
		<-0.155, -0.235, -0.052> <-0.146, -0.231, -0.041> <-0.127, -0.227, -0.041> <-0.118, -0.230, -0.051> 
		<-0.157, -0.241, -0.044> <-0.148, -0.237, -0.033> <-0.130, -0.235, -0.034> <-0.121, -0.238, -0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, -0.206, -0.039> <-0.095, -0.198, -0.043> <-0.094, -0.188, -0.058> <-0.103, -0.182, -0.067> 
		<-0.114, -0.211, -0.042> <-0.103, -0.204, -0.047> <-0.109, -0.201, -0.067> <-0.118, -0.196, -0.077> 
		<-0.118, -0.230, -0.051> <-0.107, -0.234, -0.062> <-0.108, -0.231, -0.082> <-0.118, -0.235, -0.093> 
		<-0.121, -0.238, -0.044> <-0.110, -0.242, -0.055> <-0.111, -0.249, -0.070> <-0.121, -0.253, -0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.103, -0.182, -0.067> <-0.112, -0.176, -0.078> <-0.130, -0.174, -0.082> <-0.142, -0.182, -0.076> 
		<-0.118, -0.196, -0.077> <-0.128, -0.189, -0.087> <-0.144, -0.189, -0.090> <-0.156, -0.197, -0.085> 
		<-0.118, -0.235, -0.093> <-0.127, -0.239, -0.104> <-0.146, -0.240, -0.109> <-0.155, -0.236, -0.099> 
		<-0.121, -0.253, -0.081> <-0.131, -0.257, -0.091> <-0.148, -0.257, -0.096> <-0.158, -0.254, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.157, -0.244, -0.002> <-0.168, -0.253, -0.001> <-0.168, -0.270, 0.000> <-0.158, -0.280, -0.000> 
		<-0.157, -0.243, -0.014> <-0.168, -0.252, -0.013> <-0.168, -0.262, -0.026> <-0.158, -0.272, -0.026> 
		<-0.160, -0.247, -0.033> <-0.171, -0.252, -0.046> <-0.173, -0.271, -0.057> <-0.162, -0.275, -0.069> 
		<-0.157, -0.241, -0.044> <-0.168, -0.245, -0.056> <-0.170, -0.250, -0.074> <-0.158, -0.254, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.157, -0.244, -0.002> <-0.157, -0.243, -0.014> <-0.160, -0.247, -0.033> <-0.157, -0.241, -0.044> 
		<-0.147, -0.234, -0.003> <-0.147, -0.233, -0.016> <-0.151, -0.244, -0.023> <-0.148, -0.237, -0.033> 
		<-0.130, -0.234, -0.004> <-0.130, -0.232, -0.016> <-0.133, -0.244, -0.027> <-0.130, -0.235, -0.034> 
		<-0.121, -0.244, -0.004> <-0.121, -0.243, -0.016> <-0.124, -0.247, -0.037> <-0.121, -0.238, -0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, -0.244, -0.004> <-0.121, -0.243, -0.016> <-0.124, -0.247, -0.037> <-0.121, -0.238, -0.044> 
		<-0.111, -0.255, -0.004> <-0.111, -0.253, -0.016> <-0.114, -0.251, -0.047> <-0.110, -0.242, -0.055> 
		<-0.111, -0.271, -0.004> <-0.111, -0.263, -0.027> <-0.115, -0.270, -0.057> <-0.111, -0.249, -0.070> 
		<-0.121, -0.281, -0.002> <-0.121, -0.273, -0.026> <-0.125, -0.274, -0.068> <-0.121, -0.253, -0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, -0.281, -0.002> <-0.121, -0.273, -0.026> <-0.125, -0.274, -0.068> <-0.121, -0.253, -0.081> 
		<-0.132, -0.291, -0.001> <-0.132, -0.283, -0.025> <-0.134, -0.278, -0.078> <-0.131, -0.257, -0.091> 
		<-0.148, -0.291, -0.000> <-0.148, -0.283, -0.026> <-0.152, -0.278, -0.079> <-0.148, -0.257, -0.096> 
		<-0.158, -0.280, -0.000> <-0.158, -0.272, -0.026> <-0.162, -0.275, -0.069> <-0.158, -0.254, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, -0.329, -0.001> <-0.216, -0.329, -0.012> <-0.213, -0.329, -0.031> <-0.201, -0.329, -0.036> 
		<-0.223, -0.338, -0.001> <-0.216, -0.338, -0.012> <-0.213, -0.338, -0.031> <-0.201, -0.338, -0.036> 
		<-0.215, -0.346, -0.001> <-0.210, -0.346, -0.008> <-0.202, -0.346, -0.029> <-0.194, -0.346, -0.032> 
		<-0.206, -0.346, -0.001> <-0.201, -0.346, -0.008> <-0.196, -0.346, -0.022> <-0.188, -0.346, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, -0.329, -0.001> <-0.223, -0.320, -0.001> <-0.215, -0.313, -0.001> <-0.206, -0.313, -0.001> 
		<-0.216, -0.329, -0.012> <-0.216, -0.320, -0.012> <-0.210, -0.313, -0.008> <-0.201, -0.313, -0.008> 
		<-0.213, -0.329, -0.031> <-0.213, -0.320, -0.031> <-0.202, -0.313, -0.029> <-0.196, -0.313, -0.022> 
		<-0.201, -0.329, -0.036> <-0.201, -0.320, -0.036> <-0.194, -0.313, -0.032> <-0.188, -0.313, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.206, -0.313, -0.001> <-0.197, -0.313, -0.001> <-0.189, -0.320, -0.001> <-0.189, -0.329, -0.001> 
		<-0.201, -0.313, -0.008> <-0.192, -0.313, -0.008> <-0.187, -0.320, -0.004> <-0.187, -0.329, -0.004> 
		<-0.196, -0.313, -0.022> <-0.191, -0.313, -0.015> <-0.185, -0.321, -0.010> <-0.185, -0.329, -0.010> 
		<-0.188, -0.313, -0.025> <-0.183, -0.313, -0.018> <-0.182, -0.321, -0.011> <-0.182, -0.329, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.189, -0.329, -0.001> <-0.189, -0.338, -0.001> <-0.197, -0.346, -0.001> <-0.206, -0.346, -0.001> 
		<-0.187, -0.329, -0.004> <-0.187, -0.338, -0.004> <-0.192, -0.346, -0.008> <-0.201, -0.346, -0.008> 
		<-0.185, -0.329, -0.010> <-0.185, -0.338, -0.010> <-0.191, -0.346, -0.015> <-0.196, -0.346, -0.022> 
		<-0.182, -0.329, -0.011> <-0.182, -0.338, -0.011> <-0.183, -0.346, -0.018> <-0.188, -0.346, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.201, -0.329, -0.036> <-0.181, -0.329, -0.046> <-0.150, -0.327, -0.043> <-0.128, -0.329, -0.045> 
		<-0.201, -0.338, -0.036> <-0.181, -0.338, -0.046> <-0.150, -0.336, -0.043> <-0.128, -0.338, -0.045> 
		<-0.194, -0.346, -0.032> <-0.177, -0.346, -0.038> <-0.146, -0.344, -0.036> <-0.128, -0.346, -0.037> 
		<-0.188, -0.346, -0.025> <-0.171, -0.346, -0.031> <-0.146, -0.344, -0.027> <-0.128, -0.346, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.201, -0.329, -0.036> <-0.201, -0.320, -0.036> <-0.194, -0.313, -0.032> <-0.188, -0.313, -0.025> 
		<-0.181, -0.329, -0.046> <-0.181, -0.320, -0.046> <-0.177, -0.313, -0.038> <-0.171, -0.313, -0.031> 
		<-0.150, -0.327, -0.043> <-0.150, -0.318, -0.043> <-0.146, -0.311, -0.036> <-0.146, -0.311, -0.027> 
		<-0.128, -0.329, -0.045> <-0.128, -0.320, -0.045> <-0.128, -0.313, -0.037> <-0.128, -0.313, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.188, -0.313, -0.025> <-0.183, -0.313, -0.018> <-0.182, -0.321, -0.011> <-0.182, -0.329, -0.011> 
		<-0.171, -0.313, -0.031> <-0.165, -0.313, -0.024> <-0.165, -0.321, -0.016> <-0.165, -0.329, -0.016> 
		<-0.146, -0.311, -0.027> <-0.145, -0.311, -0.019> <-0.142, -0.320, -0.016> <-0.142, -0.327, -0.016> 
		<-0.128, -0.313, -0.028> <-0.127, -0.313, -0.021> <-0.125, -0.321, -0.017> <-0.125, -0.329, -0.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.182, -0.329, -0.011> <-0.182, -0.338, -0.011> <-0.183, -0.346, -0.018> <-0.188, -0.346, -0.025> 
		<-0.165, -0.329, -0.016> <-0.165, -0.338, -0.016> <-0.165, -0.346, -0.024> <-0.171, -0.346, -0.031> 
		<-0.142, -0.327, -0.016> <-0.142, -0.335, -0.016> <-0.145, -0.344, -0.019> <-0.146, -0.344, -0.027> 
		<-0.125, -0.329, -0.017> <-0.125, -0.337, -0.017> <-0.127, -0.346, -0.021> <-0.128, -0.346, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, -0.329, -0.045> <-0.101, -0.331, -0.048> <-0.065, -0.339, -0.054> <-0.038, -0.343, -0.054> 
		<-0.128, -0.338, -0.045> <-0.101, -0.341, -0.048> <-0.070, -0.346, -0.054> <-0.043, -0.351, -0.054> 
		<-0.128, -0.346, -0.037> <-0.104, -0.348, -0.040> <-0.072, -0.353, -0.047> <-0.048, -0.357, -0.047> 
		<-0.128, -0.346, -0.028> <-0.103, -0.348, -0.031> <-0.071, -0.354, -0.038> <-0.047, -0.357, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, -0.329, -0.045> <-0.128, -0.320, -0.045> <-0.128, -0.313, -0.037> <-0.128, -0.313, -0.028> 
		<-0.101, -0.331, -0.048> <-0.101, -0.322, -0.048> <-0.099, -0.316, -0.040> <-0.098, -0.316, -0.031> 
		<-0.065, -0.339, -0.054> <-0.061, -0.331, -0.054> <-0.060, -0.324, -0.047> <-0.059, -0.324, -0.038> 
		<-0.038, -0.343, -0.054> <-0.034, -0.336, -0.054> <-0.030, -0.329, -0.047> <-0.029, -0.329, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, -0.313, -0.028> <-0.127, -0.313, -0.021> <-0.125, -0.321, -0.017> <-0.125, -0.329, -0.017> 
		<-0.098, -0.316, -0.031> <-0.097, -0.316, -0.023> <-0.098, -0.324, -0.020> <-0.098, -0.332, -0.020> 
		<-0.059, -0.324, -0.038> <-0.058, -0.325, -0.030> <-0.059, -0.334, -0.026> <-0.063, -0.340, -0.026> 
		<-0.029, -0.329, -0.038> <-0.029, -0.330, -0.030> <-0.032, -0.338, -0.026> <-0.036, -0.345, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, -0.329, -0.017> <-0.125, -0.337, -0.017> <-0.127, -0.346, -0.021> <-0.128, -0.346, -0.028> 
		<-0.098, -0.332, -0.020> <-0.098, -0.340, -0.020> <-0.103, -0.348, -0.023> <-0.103, -0.348, -0.031> 
		<-0.063, -0.340, -0.026> <-0.067, -0.347, -0.026> <-0.071, -0.354, -0.030> <-0.071, -0.354, -0.038> 
		<-0.036, -0.345, -0.026> <-0.040, -0.351, -0.026> <-0.046, -0.358, -0.030> <-0.047, -0.357, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.038, -0.343, -0.054> <0.005, -0.350, -0.054> <0.062, -0.362, -0.048> <0.106, -0.368, -0.045> 
		<-0.043, -0.351, -0.054> <-0.000, -0.358, -0.054> <0.064, -0.371, -0.048> <0.108, -0.376, -0.045> 
		<-0.048, -0.357, -0.047> <-0.001, -0.365, -0.047> <0.062, -0.378, -0.041> <0.109, -0.384, -0.037> 
		<-0.047, -0.357, -0.038> <0.000, -0.365, -0.038> <0.062, -0.378, -0.032> <0.110, -0.384, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.038, -0.343, -0.054> <-0.034, -0.336, -0.054> <-0.030, -0.329, -0.047> <-0.029, -0.329, -0.038> 
		<0.005, -0.350, -0.054> <0.010, -0.343, -0.054> <0.010, -0.336, -0.047> <0.010, -0.336, -0.038> 
		<0.062, -0.362, -0.048> <0.060, -0.353, -0.048> <0.062, -0.346, -0.039> <0.063, -0.346, -0.030> 
		<0.106, -0.368, -0.045> <0.104, -0.359, -0.045> <0.101, -0.352, -0.037> <0.102, -0.351, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.029, -0.329, -0.038> <-0.029, -0.330, -0.030> <-0.032, -0.338, -0.026> <-0.036, -0.345, -0.026> 
		<0.010, -0.336, -0.038> <0.011, -0.337, -0.030> <0.011, -0.345, -0.026> <0.007, -0.352, -0.026> 
		<0.063, -0.346, -0.030> <0.063, -0.346, -0.023> <0.063, -0.354, -0.020> <0.065, -0.362, -0.020> 
		<0.102, -0.351, -0.028> <0.103, -0.351, -0.021> <0.106, -0.359, -0.017> <0.108, -0.367, -0.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.036, -0.345, -0.026> <-0.040, -0.351, -0.026> <-0.046, -0.358, -0.030> <-0.047, -0.357, -0.038> 
		<0.007, -0.352, -0.026> <0.003, -0.358, -0.026> <0.001, -0.365, -0.030> <0.000, -0.365, -0.038> 
		<0.065, -0.362, -0.020> <0.066, -0.369, -0.020> <0.063, -0.378, -0.024> <0.062, -0.378, -0.032> 
		<0.108, -0.367, -0.017> <0.110, -0.375, -0.017> <0.110, -0.384, -0.021> <0.110, -0.384, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, -0.368, -0.045> <0.121, -0.370, -0.044> <0.144, -0.367, -0.046> <0.158, -0.368, -0.039> 
		<0.108, -0.376, -0.045> <0.123, -0.378, -0.044> <0.146, -0.375, -0.044> <0.161, -0.376, -0.037> 
		<0.109, -0.384, -0.037> <0.122, -0.386, -0.036> <0.146, -0.382, -0.034> <0.159, -0.383, -0.030> 
		<0.110, -0.384, -0.028> <0.123, -0.385, -0.027> <0.141, -0.382, -0.026> <0.154, -0.383, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, -0.368, -0.045> <0.104, -0.359, -0.045> <0.101, -0.352, -0.037> <0.102, -0.351, -0.028> 
		<0.121, -0.370, -0.044> <0.119, -0.361, -0.044> <0.114, -0.353, -0.037> <0.115, -0.353, -0.028> 
		<0.144, -0.367, -0.046> <0.141, -0.358, -0.047> <0.136, -0.352, -0.040> <0.132, -0.351, -0.032> 
		<0.158, -0.368, -0.039> <0.155, -0.359, -0.041> <0.148, -0.353, -0.037> <0.144, -0.352, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, -0.351, -0.028> <0.103, -0.351, -0.021> <0.106, -0.359, -0.017> <0.108, -0.367, -0.017> 
		<0.115, -0.353, -0.028> <0.115, -0.353, -0.020> <0.117, -0.361, -0.017> <0.119, -0.368, -0.017> 
		<0.132, -0.351, -0.032> <0.128, -0.351, -0.026> <0.131, -0.359, -0.019> <0.134, -0.366, -0.017> 
		<0.144, -0.352, -0.029> <0.140, -0.352, -0.022> <0.142, -0.360, -0.017> <0.144, -0.367, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.108, -0.367, -0.017> <0.110, -0.375, -0.017> <0.110, -0.384, -0.021> <0.110, -0.384, -0.028> 
		<0.119, -0.368, -0.017> <0.121, -0.376, -0.017> <0.124, -0.385, -0.020> <0.123, -0.385, -0.027> 
		<0.134, -0.366, -0.017> <0.136, -0.373, -0.016> <0.138, -0.382, -0.019> <0.141, -0.382, -0.026> 
		<0.144, -0.367, -0.015> <0.147, -0.374, -0.013> <0.150, -0.383, -0.015> <0.154, -0.383, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.216, -0.376, 0.003> <0.215, -0.385, 0.003> <0.208, -0.392, 0.001> <0.199, -0.391, 0.000> 
		<0.199, -0.374, -0.009> <0.198, -0.383, -0.009> <0.194, -0.389, -0.005> <0.185, -0.389, -0.006> 
		<0.178, -0.369, -0.030> <0.181, -0.378, -0.029> <0.173, -0.384, -0.025> <0.168, -0.384, -0.017> 
		<0.158, -0.368, -0.039> <0.161, -0.376, -0.037> <0.159, -0.383, -0.030> <0.154, -0.383, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.216, -0.376, 0.003> <0.199, -0.374, -0.009> <0.178, -0.369, -0.030> <0.158, -0.368, -0.039> 
		<0.217, -0.367, 0.004> <0.200, -0.364, -0.009> <0.175, -0.361, -0.032> <0.155, -0.359, -0.041> 
		<0.210, -0.359, 0.002> <0.193, -0.357, -0.007> <0.167, -0.354, -0.031> <0.148, -0.353, -0.037> 
		<0.201, -0.358, 0.001> <0.184, -0.356, -0.008> <0.162, -0.353, -0.023> <0.144, -0.352, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, -0.358, 0.001> <0.184, -0.356, -0.008> <0.162, -0.353, -0.023> <0.144, -0.352, -0.029> 
		<0.194, -0.357, -0.000> <0.176, -0.356, -0.009> <0.159, -0.353, -0.017> <0.140, -0.352, -0.022> 
		<0.189, -0.366, 0.001> <0.176, -0.364, -0.004> <0.156, -0.361, -0.014> <0.142, -0.360, -0.017> 
		<0.189, -0.374, 0.000> <0.175, -0.372, -0.004> <0.158, -0.368, -0.012> <0.144, -0.367, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.189, -0.374, 0.000> <0.175, -0.372, -0.004> <0.158, -0.368, -0.012> <0.144, -0.367, -0.015> 
		<0.188, -0.381, 0.000> <0.175, -0.379, -0.004> <0.161, -0.375, -0.010> <0.147, -0.374, -0.013> 
		<0.191, -0.390, -0.001> <0.178, -0.388, -0.007> <0.165, -0.384, -0.010> <0.150, -0.383, -0.015> 
		<0.199, -0.391, 0.000> <0.185, -0.389, -0.006> <0.168, -0.384, -0.017> <0.154, -0.383, -0.022> 
	}
	texture {textMotor}
}


#declare Soportes = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, -0.361, 0.053> <0.357, -0.602, 0.121> <0.531, -0.923, 0.213> <0.661, -1.164, 0.281> 
		<0.226, -0.369, 0.041> <0.356, -0.610, 0.109> <0.530, -0.931, 0.201> <0.660, -1.171, 0.269> 
		<0.238, -0.372, 0.028> <0.368, -0.613, 0.096> <0.542, -0.934, 0.188> <0.672, -1.175, 0.256> 
		<0.251, -0.368, 0.026> <0.381, -0.609, 0.095> <0.555, -0.930, 0.186> <0.685, -1.171, 0.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, -0.361, 0.053> <0.228, -0.353, 0.067> <0.240, -0.343, 0.075> <0.255, -0.339, 0.074> 
		<0.357, -0.602, 0.121> <0.358, -0.594, 0.135> <0.370, -0.584, 0.144> <0.385, -0.580, 0.142> 
		<0.531, -0.923, 0.213> <0.532, -0.915, 0.226> <0.543, -0.905, 0.235> <0.559, -0.901, 0.234> 
		<0.661, -1.164, 0.281> <0.662, -1.156, 0.295> <0.673, -1.146, 0.304> <0.689, -1.141, 0.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.255, -0.339, 0.074> <0.268, -0.335, 0.072> <0.280, -0.338, 0.059> <0.279, -0.345, 0.047> 
		<0.385, -0.580, 0.142> <0.399, -0.575, 0.141> <0.410, -0.579, 0.128> <0.409, -0.586, 0.116> 
		<0.559, -0.901, 0.234> <0.572, -0.896, 0.232> <0.584, -0.900, 0.219> <0.583, -0.907, 0.207> 
		<0.689, -1.141, 0.302> <0.702, -1.137, 0.301> <0.714, -1.141, 0.288> <0.713, -1.148, 0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.279, -0.345, 0.047> <0.278, -0.354, 0.034> <0.267, -0.363, 0.025> <0.251, -0.368, 0.026> 
		<0.409, -0.586, 0.116> <0.408, -0.595, 0.102> <0.397, -0.604, 0.093> <0.381, -0.609, 0.095> 
		<0.583, -0.907, 0.207> <0.582, -0.916, 0.193> <0.570, -0.925, 0.185> <0.555, -0.930, 0.186> 
		<0.713, -1.148, 0.276> <0.712, -1.156, 0.262> <0.700, -1.166, 0.253> <0.685, -1.171, 0.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.236, -0.381, 1.055> <0.363, -0.617, 0.953> <0.533, -0.931, 0.816> <0.661, -1.167, 0.714> 
		<0.235, -0.381, 1.041> <0.363, -0.617, 0.939> <0.533, -0.931, 0.802> <0.660, -1.167, 0.700> 
		<0.247, -0.377, 1.027> <0.374, -0.613, 0.925> <0.544, -0.927, 0.788> <0.672, -1.163, 0.686> 
		<0.260, -0.373, 1.029> <0.388, -0.609, 0.927> <0.558, -0.923, 0.790> <0.685, -1.159, 0.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.236, -0.381, 1.055> <0.237, -0.381, 1.072> <0.248, -0.378, 1.086> <0.264, -0.373, 1.088> 
		<0.363, -0.617, 0.953> <0.364, -0.617, 0.970> <0.375, -0.614, 0.984> <0.391, -0.609, 0.986> 
		<0.533, -0.931, 0.816> <0.534, -0.931, 0.833> <0.545, -0.928, 0.847> <0.561, -0.923, 0.849> 
		<0.661, -1.167, 0.714> <0.662, -1.167, 0.731> <0.673, -1.164, 0.745> <0.689, -1.159, 0.747> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.264, -0.373, 1.088> <0.277, -0.369, 1.090> <0.289, -0.365, 1.076> <0.288, -0.365, 1.062> 
		<0.391, -0.609, 0.986> <0.405, -0.605, 0.987> <0.416, -0.601, 0.974> <0.415, -0.601, 0.960> 
		<0.561, -0.923, 0.849> <0.574, -0.919, 0.851> <0.586, -0.915, 0.837> <0.585, -0.915, 0.823> 
		<0.689, -1.159, 0.747> <0.702, -1.155, 0.748> <0.714, -1.151, 0.734> <0.713, -1.151, 0.720> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.288, -0.365, 1.062> <0.287, -0.365, 1.045> <0.276, -0.368, 1.031> <0.260, -0.373, 1.029> 
		<0.415, -0.601, 0.960> <0.414, -0.601, 0.943> <0.404, -0.604, 0.929> <0.388, -0.609, 0.927> 
		<0.585, -0.915, 0.823> <0.584, -0.915, 0.806> <0.574, -0.918, 0.792> <0.558, -0.923, 0.790> 
		<0.713, -1.151, 0.720> <0.712, -1.151, 0.704> <0.701, -1.154, 0.690> <0.685, -1.159, 0.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.226, -0.361, 0.053> <-0.356, -0.602, 0.121> <-0.530, -0.923, 0.213> <-0.660, -1.164, 0.281> 
		<-0.225, -0.369, 0.041> <-0.355, -0.610, 0.109> <-0.529, -0.931, 0.201> <-0.659, -1.171, 0.269> 
		<-0.237, -0.372, 0.028> <-0.367, -0.613, 0.096> <-0.540, -0.934, 0.188> <-0.670, -1.175, 0.256> 
		<-0.250, -0.368, 0.026> <-0.380, -0.609, 0.095> <-0.554, -0.930, 0.186> <-0.684, -1.171, 0.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.226, -0.361, 0.053> <-0.227, -0.353, 0.067> <-0.239, -0.343, 0.075> <-0.254, -0.339, 0.074> 
		<-0.356, -0.602, 0.121> <-0.357, -0.594, 0.135> <-0.369, -0.584, 0.144> <-0.384, -0.580, 0.142> 
		<-0.530, -0.923, 0.213> <-0.531, -0.915, 0.226> <-0.542, -0.905, 0.235> <-0.557, -0.901, 0.234> 
		<-0.660, -1.164, 0.281> <-0.661, -1.156, 0.295> <-0.672, -1.146, 0.304> <-0.687, -1.141, 0.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.254, -0.339, 0.074> <-0.267, -0.335, 0.072> <-0.279, -0.338, 0.059> <-0.278, -0.345, 0.047> 
		<-0.384, -0.580, 0.142> <-0.397, -0.575, 0.141> <-0.409, -0.579, 0.128> <-0.408, -0.586, 0.116> 
		<-0.557, -0.901, 0.234> <-0.571, -0.896, 0.232> <-0.582, -0.900, 0.219> <-0.582, -0.907, 0.207> 
		<-0.687, -1.141, 0.302> <-0.701, -1.137, 0.301> <-0.713, -1.141, 0.288> <-0.712, -1.148, 0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.278, -0.345, 0.047> <-0.277, -0.354, 0.034> <-0.266, -0.363, 0.025> <-0.250, -0.368, 0.026> 
		<-0.408, -0.586, 0.116> <-0.407, -0.595, 0.102> <-0.396, -0.604, 0.093> <-0.380, -0.609, 0.095> 
		<-0.582, -0.907, 0.207> <-0.581, -0.916, 0.193> <-0.569, -0.925, 0.185> <-0.554, -0.930, 0.186> 
		<-0.712, -1.148, 0.276> <-0.711, -1.156, 0.262> <-0.699, -1.166, 0.253> <-0.684, -1.171, 0.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.230, -0.381, 1.055> <-0.359, -0.617, 0.953> <-0.531, -0.931, 0.816> <-0.660, -1.167, 0.714> 
		<-0.229, -0.381, 1.041> <-0.358, -0.617, 0.939> <-0.530, -0.931, 0.802> <-0.659, -1.167, 0.700> 
		<-0.240, -0.377, 1.027> <-0.369, -0.613, 0.925> <-0.541, -0.927, 0.788> <-0.671, -1.163, 0.686> 
		<-0.254, -0.373, 1.029> <-0.383, -0.609, 0.927> <-0.555, -0.923, 0.790> <-0.684, -1.159, 0.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.230, -0.381, 1.055> <-0.231, -0.381, 1.072> <-0.241, -0.378, 1.086> <-0.257, -0.373, 1.088> 
		<-0.359, -0.617, 0.953> <-0.360, -0.617, 0.970> <-0.370, -0.614, 0.984> <-0.386, -0.609, 0.986> 
		<-0.531, -0.931, 0.816> <-0.532, -0.931, 0.833> <-0.542, -0.928, 0.847> <-0.558, -0.923, 0.849> 
		<-0.660, -1.167, 0.714> <-0.661, -1.167, 0.731> <-0.671, -1.164, 0.745> <-0.687, -1.159, 0.747> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, -0.373, 1.088> <-0.271, -0.369, 1.090> <-0.282, -0.365, 1.076> <-0.281, -0.365, 1.062> 
		<-0.386, -0.609, 0.986> <-0.400, -0.605, 0.987> <-0.411, -0.601, 0.974> <-0.411, -0.601, 0.960> 
		<-0.558, -0.923, 0.849> <-0.572, -0.919, 0.851> <-0.583, -0.915, 0.837> <-0.583, -0.915, 0.823> 
		<-0.687, -1.159, 0.747> <-0.701, -1.155, 0.748> <-0.712, -1.151, 0.734> <-0.712, -1.151, 0.720> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.281, -0.365, 1.062> <-0.280, -0.365, 1.045> <-0.270, -0.368, 1.031> <-0.254, -0.373, 1.029> 
		<-0.411, -0.601, 0.960> <-0.409, -0.601, 0.943> <-0.399, -0.604, 0.929> <-0.383, -0.609, 0.927> 
		<-0.583, -0.915, 0.823> <-0.582, -0.915, 0.806> <-0.571, -0.918, 0.792> <-0.555, -0.923, 0.790> 
		<-0.712, -1.151, 0.720> <-0.711, -1.151, 0.704> <-0.700, -1.154, 0.690> <-0.684, -1.159, 0.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.501, -0.363, 1.096> <2.506, -0.347, 1.087> <2.517, -0.325, 1.074> <2.517, -0.308, 1.066> 
		<2.501, -0.357, 1.041> <2.506, -0.340, 1.032> <2.517, -0.321, 1.039> <2.517, -0.304, 1.030> 
		<2.500, -0.351, 0.960> <2.500, -0.335, 0.966> <2.519, -0.314, 0.988> <2.519, -0.298, 0.981> 
		<2.555, -0.353, 0.964> <2.555, -0.337, 0.969> <2.555, -0.314, 0.990> <2.555, -0.298, 0.982> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.501, -0.363, 1.096> <2.501, -0.369, 1.149> <2.501, -0.381, 1.218> <2.555, -0.383, 1.221> 
		<2.506, -0.347, 1.087> <2.506, -0.353, 1.140> <2.501, -0.362, 1.199> <2.555, -0.363, 1.203> 
		<2.517, -0.325, 1.074> <2.517, -0.330, 1.113> <2.516, -0.342, 1.170> <2.555, -0.342, 1.172> 
		<2.517, -0.308, 1.066> <2.517, -0.313, 1.104> <2.516, -0.318, 1.157> <2.555, -0.318, 1.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.555, -0.383, 1.221> <2.605, -0.384, 1.225> <2.608, -0.372, 1.153> <2.608, -0.366, 1.103> 
		<2.555, -0.363, 1.203> <2.605, -0.365, 1.206> <2.603, -0.355, 1.143> <2.603, -0.349, 1.092> 
		<2.555, -0.342, 1.172> <2.592, -0.342, 1.173> <2.592, -0.331, 1.116> <2.592, -0.327, 1.078> 
		<2.555, -0.318, 1.159> <2.592, -0.318, 1.161> <2.592, -0.312, 1.107> <2.592, -0.308, 1.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.608, -0.366, 1.103> <2.608, -0.360, 1.045> <2.612, -0.355, 0.967> <2.555, -0.353, 0.964> 
		<2.603, -0.349, 1.092> <2.603, -0.342, 1.035> <2.612, -0.338, 0.973> <2.555, -0.337, 0.969> 
		<2.592, -0.327, 1.078> <2.592, -0.322, 1.042> <2.591, -0.314, 0.991> <2.555, -0.314, 0.990> 
		<2.592, -0.308, 1.069> <2.592, -0.304, 1.032> <2.591, -0.298, 0.984> <2.555, -0.298, 0.982> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.517, -0.308, 1.066> <2.523, 0.180, 0.816> <2.524, 0.830, 0.482> <2.521, 1.320, 0.236> 
		<2.517, -0.304, 1.030> <2.523, 0.184, 0.781> <2.524, 0.830, 0.451> <2.521, 1.320, 0.206> 
		<2.519, -0.298, 0.981> <2.519, 0.193, 0.746> <2.524, 0.839, 0.418> <2.524, 1.320, 0.165> 
		<2.555, -0.298, 0.982> <2.555, 0.193, 0.748> <2.555, 0.839, 0.418> <2.555, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.517, -0.308, 1.066> <2.517, -0.313, 1.104> <2.516, -0.318, 1.157> <2.555, -0.318, 1.159> 
		<2.523, 0.180, 0.816> <2.523, 0.176, 0.855> <2.516, 0.170, 0.897> <2.555, 0.170, 0.899> 
		<2.524, 0.830, 0.482> <2.524, 0.830, 0.514> <2.522, 0.822, 0.553> <2.555, 0.822, 0.553> 
		<2.521, 1.320, 0.236> <2.521, 1.320, 0.269> <2.522, 1.320, 0.313> <2.555, 1.320, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.555, -0.318, 1.159> <2.592, -0.318, 1.161> <2.592, -0.312, 1.107> <2.592, -0.308, 1.069> 
		<2.555, 0.170, 0.899> <2.592, 0.170, 0.900> <2.586, 0.176, 0.856> <2.586, 0.180, 0.818> 
		<2.555, 0.822, 0.553> <2.587, 0.822, 0.553> <2.585, 0.829, 0.513> <2.585, 0.829, 0.480> 
		<2.555, 1.320, 0.313> <2.587, 1.320, 0.313> <2.588, 1.320, 0.269> <2.588, 1.320, 0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.592, -0.308, 1.069> <2.592, -0.304, 1.032> <2.591, -0.298, 0.984> <2.555, -0.298, 0.982> 
		<2.586, 0.180, 0.818> <2.586, 0.184, 0.782> <2.591, 0.193, 0.750> <2.555, 0.193, 0.748> 
		<2.585, 0.829, 0.480> <2.585, 0.829, 0.450> <2.585, 0.839, 0.418> <2.555, 0.839, 0.418> 
		<2.588, 1.320, 0.236> <2.588, 1.320, 0.206> <2.585, 1.320, 0.165> <2.555, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.507, 1.358, 0.231> <2.507, 1.357, 0.183> <2.507, 1.353, 0.110> <2.555, 1.353, 0.115> 
		<2.511, 1.347, 0.233> <2.511, 1.346, 0.184> <2.507, 1.343, 0.125> <2.555, 1.343, 0.130> 
		<2.521, 1.331, 0.231> <2.521, 1.331, 0.200> <2.524, 1.336, 0.157> <2.555, 1.336, 0.157> 
		<2.521, 1.320, 0.236> <2.521, 1.320, 0.206> <2.524, 1.320, 0.165> <2.555, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.507, 1.358, 0.231> <2.511, 1.347, 0.233> <2.521, 1.331, 0.231> <2.521, 1.320, 0.236> 
		<2.507, 1.359, 0.281> <2.511, 1.348, 0.283> <2.521, 1.331, 0.263> <2.521, 1.320, 0.269> 
		<2.505, 1.358, 0.346> <2.505, 1.347, 0.335> <2.522, 1.335, 0.306> <2.522, 1.320, 0.313> 
		<2.555, 1.358, 0.352> <2.555, 1.347, 0.340> <2.555, 1.335, 0.306> <2.555, 1.320, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.555, 1.358, 0.352> <2.555, 1.347, 0.340> <2.555, 1.335, 0.306> <2.555, 1.320, 0.313> 
		<2.601, 1.358, 0.357> <2.601, 1.347, 0.345> <2.587, 1.335, 0.306> <2.587, 1.320, 0.313> 
		<2.602, 1.359, 0.288> <2.598, 1.348, 0.286> <2.588, 1.331, 0.263> <2.588, 1.320, 0.269> 
		<2.602, 1.358, 0.242> <2.598, 1.347, 0.240> <2.588, 1.331, 0.231> <2.588, 1.320, 0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.602, 1.358, 0.242> <2.598, 1.347, 0.240> <2.588, 1.331, 0.231> <2.588, 1.320, 0.236> 
		<2.602, 1.357, 0.190> <2.598, 1.346, 0.188> <2.588, 1.331, 0.200> <2.588, 1.320, 0.206> 
		<2.606, 1.353, 0.121> <2.606, 1.343, 0.136> <2.585, 1.336, 0.157> <2.585, 1.320, 0.165> 
		<2.555, 1.353, 0.115> <2.555, 1.343, 0.130> <2.555, 1.336, 0.157> <2.555, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.632, -0.363, 1.096> <-2.627, -0.347, 1.087> <-2.616, -0.325, 1.074> <-2.616, -0.308, 1.066> 
		<-2.632, -0.357, 1.041> <-2.627, -0.340, 1.032> <-2.616, -0.321, 1.039> <-2.616, -0.304, 1.030> 
		<-2.634, -0.351, 0.960> <-2.634, -0.335, 0.966> <-2.614, -0.314, 0.988> <-2.614, -0.298, 0.981> 
		<-2.579, -0.353, 0.964> <-2.579, -0.337, 0.969> <-2.579, -0.314, 0.990> <-2.579, -0.298, 0.982> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.632, -0.363, 1.096> <-2.632, -0.369, 1.149> <-2.632, -0.381, 1.218> <-2.579, -0.383, 1.221> 
		<-2.627, -0.347, 1.087> <-2.627, -0.353, 1.140> <-2.632, -0.362, 1.199> <-2.579, -0.363, 1.203> 
		<-2.616, -0.325, 1.074> <-2.616, -0.330, 1.113> <-2.618, -0.342, 1.170> <-2.579, -0.342, 1.172> 
		<-2.616, -0.308, 1.066> <-2.616, -0.313, 1.104> <-2.618, -0.318, 1.157> <-2.579, -0.318, 1.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.579, -0.383, 1.221> <-2.528, -0.384, 1.225> <-2.526, -0.372, 1.153> <-2.526, -0.366, 1.103> 
		<-2.579, -0.363, 1.203> <-2.528, -0.365, 1.206> <-2.530, -0.355, 1.143> <-2.530, -0.349, 1.092> 
		<-2.579, -0.342, 1.172> <-2.541, -0.342, 1.173> <-2.541, -0.331, 1.116> <-2.541, -0.327, 1.078> 
		<-2.579, -0.318, 1.159> <-2.541, -0.318, 1.161> <-2.541, -0.312, 1.107> <-2.541, -0.308, 1.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.526, -0.366, 1.103> <-2.526, -0.360, 1.045> <-2.521, -0.355, 0.967> <-2.579, -0.353, 0.964> 
		<-2.530, -0.349, 1.092> <-2.530, -0.342, 1.035> <-2.521, -0.338, 0.973> <-2.579, -0.337, 0.969> 
		<-2.541, -0.327, 1.078> <-2.541, -0.322, 1.042> <-2.542, -0.314, 0.991> <-2.579, -0.314, 0.990> 
		<-2.541, -0.308, 1.069> <-2.541, -0.304, 1.032> <-2.542, -0.298, 0.984> <-2.579, -0.298, 0.982> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.616, -0.308, 1.066> <-2.611, 0.180, 0.816> <-2.609, 0.830, 0.482> <-2.612, 1.320, 0.236> 
		<-2.616, -0.304, 1.030> <-2.611, 0.184, 0.781> <-2.609, 0.830, 0.451> <-2.612, 1.320, 0.206> 
		<-2.614, -0.298, 0.981> <-2.614, 0.193, 0.746> <-2.609, 0.839, 0.418> <-2.609, 1.320, 0.165> 
		<-2.579, -0.298, 0.982> <-2.579, 0.193, 0.748> <-2.579, 0.839, 0.418> <-2.579, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.616, -0.308, 1.066> <-2.616, -0.313, 1.104> <-2.618, -0.318, 1.157> <-2.579, -0.318, 1.159> 
		<-2.611, 0.180, 0.816> <-2.611, 0.176, 0.855> <-2.618, 0.170, 0.897> <-2.579, 0.170, 0.899> 
		<-2.609, 0.830, 0.482> <-2.609, 0.830, 0.514> <-2.611, 0.822, 0.553> <-2.579, 0.822, 0.553> 
		<-2.612, 1.320, 0.236> <-2.612, 1.320, 0.269> <-2.611, 1.320, 0.313> <-2.579, 1.320, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.579, -0.318, 1.159> <-2.541, -0.318, 1.161> <-2.541, -0.312, 1.107> <-2.541, -0.308, 1.069> 
		<-2.579, 0.170, 0.899> <-2.541, 0.170, 0.900> <-2.547, 0.176, 0.856> <-2.547, 0.180, 0.818> 
		<-2.579, 0.822, 0.553> <-2.546, 0.822, 0.553> <-2.548, 0.829, 0.513> <-2.548, 0.829, 0.480> 
		<-2.579, 1.320, 0.313> <-2.546, 1.320, 0.313> <-2.545, 1.320, 0.269> <-2.545, 1.320, 0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.541, -0.308, 1.069> <-2.541, -0.304, 1.032> <-2.542, -0.298, 0.984> <-2.579, -0.298, 0.982> 
		<-2.547, 0.180, 0.818> <-2.547, 0.184, 0.782> <-2.542, 0.193, 0.750> <-2.579, 0.193, 0.748> 
		<-2.548, 0.829, 0.480> <-2.548, 0.829, 0.450> <-2.548, 0.839, 0.418> <-2.579, 0.839, 0.418> 
		<-2.545, 1.320, 0.236> <-2.545, 1.320, 0.206> <-2.548, 1.320, 0.165> <-2.579, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.626, 1.358, 0.231> <-2.626, 1.357, 0.183> <-2.627, 1.353, 0.110> <-2.579, 1.353, 0.115> 
		<-2.622, 1.347, 0.233> <-2.622, 1.346, 0.184> <-2.627, 1.343, 0.125> <-2.579, 1.343, 0.130> 
		<-2.612, 1.331, 0.231> <-2.612, 1.331, 0.200> <-2.609, 1.336, 0.157> <-2.579, 1.336, 0.157> 
		<-2.612, 1.320, 0.236> <-2.612, 1.320, 0.206> <-2.609, 1.320, 0.165> <-2.579, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.626, 1.358, 0.231> <-2.622, 1.347, 0.233> <-2.612, 1.331, 0.231> <-2.612, 1.320, 0.236> 
		<-2.626, 1.359, 0.281> <-2.622, 1.348, 0.283> <-2.612, 1.331, 0.263> <-2.612, 1.320, 0.269> 
		<-2.629, 1.358, 0.346> <-2.629, 1.347, 0.335> <-2.611, 1.335, 0.306> <-2.611, 1.320, 0.313> 
		<-2.579, 1.358, 0.352> <-2.579, 1.347, 0.340> <-2.579, 1.335, 0.306> <-2.579, 1.320, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.579, 1.358, 0.352> <-2.579, 1.347, 0.340> <-2.579, 1.335, 0.306> <-2.579, 1.320, 0.313> 
		<-2.533, 1.358, 0.357> <-2.533, 1.347, 0.345> <-2.546, 1.335, 0.306> <-2.546, 1.320, 0.313> 
		<-2.531, 1.359, 0.288> <-2.535, 1.348, 0.286> <-2.545, 1.331, 0.263> <-2.545, 1.320, 0.269> 
		<-2.531, 1.358, 0.242> <-2.535, 1.347, 0.240> <-2.545, 1.331, 0.231> <-2.545, 1.320, 0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.531, 1.358, 0.242> <-2.535, 1.347, 0.240> <-2.545, 1.331, 0.231> <-2.545, 1.320, 0.236> 
		<-2.531, 1.357, 0.190> <-2.535, 1.346, 0.188> <-2.545, 1.331, 0.200> <-2.545, 1.320, 0.206> 
		<-2.527, 1.353, 0.121> <-2.527, 1.343, 0.136> <-2.548, 1.336, 0.157> <-2.548, 1.320, 0.165> 
		<-2.579, 1.353, 0.115> <-2.579, 1.343, 0.130> <-2.579, 1.336, 0.157> <-2.579, 1.320, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 0.436, 0.191> <-0.451, 0.714, 0.281> <-0.643, 1.085, 0.401> <-0.787, 1.364, 0.491> 
		<-0.307, 0.436, 0.173> <-0.451, 0.714, 0.264> <-0.643, 1.085, 0.384> <-0.787, 1.364, 0.474> 
		<-0.293, 0.436, 0.159> <-0.437, 0.714, 0.249> <-0.629, 1.085, 0.369> <-0.773, 1.364, 0.460> 
		<-0.276, 0.436, 0.159> <-0.420, 0.714, 0.249> <-0.612, 1.085, 0.369> <-0.756, 1.364, 0.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 0.436, 0.191> <-0.307, 0.436, 0.208> <-0.293, 0.436, 0.222> <-0.276, 0.436, 0.222> 
		<-0.451, 0.714, 0.281> <-0.451, 0.714, 0.298> <-0.437, 0.714, 0.312> <-0.420, 0.714, 0.312> 
		<-0.643, 1.085, 0.401> <-0.643, 1.085, 0.418> <-0.629, 1.085, 0.433> <-0.612, 1.085, 0.433> 
		<-0.787, 1.364, 0.491> <-0.787, 1.364, 0.509> <-0.773, 1.364, 0.523> <-0.756, 1.364, 0.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.276, 0.436, 0.222> <-0.258, 0.436, 0.222> <-0.244, 0.436, 0.208> <-0.244, 0.436, 0.191> 
		<-0.420, 0.714, 0.312> <-0.402, 0.714, 0.312> <-0.388, 0.714, 0.298> <-0.388, 0.714, 0.281> 
		<-0.612, 1.085, 0.433> <-0.594, 1.085, 0.433> <-0.580, 1.085, 0.418> <-0.580, 1.085, 0.401> 
		<-0.756, 1.364, 0.523> <-0.738, 1.364, 0.523> <-0.724, 1.364, 0.509> <-0.724, 1.364, 0.491> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, 0.436, 0.191> <-0.244, 0.436, 0.173> <-0.258, 0.436, 0.159> <-0.276, 0.436, 0.159> 
		<-0.388, 0.714, 0.281> <-0.388, 0.714, 0.264> <-0.402, 0.714, 0.249> <-0.420, 0.714, 0.249> 
		<-0.580, 1.085, 0.401> <-0.580, 1.085, 0.384> <-0.594, 1.085, 0.369> <-0.612, 1.085, 0.369> 
		<-0.724, 1.364, 0.491> <-0.724, 1.364, 0.474> <-0.738, 1.364, 0.460> <-0.756, 1.364, 0.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.294, 0.426, 1.074> <-0.442, 0.698, 1.015> <-0.639, 1.061, 0.936> <-0.787, 1.333, 0.877> 
		<-0.294, 0.426, 1.091> <-0.442, 0.698, 1.032> <-0.639, 1.061, 0.953> <-0.787, 1.333, 0.894> 
		<-0.279, 0.426, 1.106> <-0.427, 0.698, 1.046> <-0.625, 1.061, 0.967> <-0.773, 1.333, 0.908> 
		<-0.262, 0.426, 1.106> <-0.410, 0.698, 1.046> <-0.608, 1.061, 0.967> <-0.756, 1.333, 0.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.294, 0.426, 1.074> <-0.294, 0.426, 1.057> <-0.279, 0.426, 1.042> <-0.262, 0.426, 1.042> 
		<-0.442, 0.698, 1.015> <-0.442, 0.698, 0.997> <-0.427, 0.698, 0.983> <-0.410, 0.698, 0.983> 
		<-0.639, 1.061, 0.936> <-0.639, 1.061, 0.919> <-0.625, 1.061, 0.904> <-0.608, 1.061, 0.904> 
		<-0.787, 1.333, 0.877> <-0.787, 1.333, 0.859> <-0.773, 1.333, 0.845> <-0.756, 1.333, 0.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.262, 0.426, 1.042> <-0.245, 0.426, 1.042> <-0.230, 0.426, 1.057> <-0.230, 0.426, 1.074> 
		<-0.410, 0.698, 0.983> <-0.393, 0.698, 0.983> <-0.378, 0.698, 0.997> <-0.378, 0.698, 1.015> 
		<-0.608, 1.061, 0.904> <-0.590, 1.061, 0.904> <-0.576, 1.061, 0.919> <-0.576, 1.061, 0.936> 
		<-0.756, 1.333, 0.845> <-0.738, 1.333, 0.845> <-0.724, 1.333, 0.859> <-0.724, 1.333, 0.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.230, 0.426, 1.074> <-0.230, 0.426, 1.091> <-0.245, 0.426, 1.106> <-0.262, 0.426, 1.106> 
		<-0.378, 0.698, 1.015> <-0.378, 0.698, 1.032> <-0.393, 0.698, 1.046> <-0.410, 0.698, 1.046> 
		<-0.576, 1.061, 0.936> <-0.576, 1.061, 0.953> <-0.590, 1.061, 0.967> <-0.608, 1.061, 0.967> 
		<-0.724, 1.333, 0.877> <-0.724, 1.333, 0.894> <-0.738, 1.333, 0.908> <-0.756, 1.333, 0.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, 0.436, 0.191> <0.447, 0.714, 0.281> <0.639, 1.085, 0.401> <0.783, 1.364, 0.491> 
		<0.303, 0.436, 0.173> <0.447, 0.714, 0.264> <0.639, 1.085, 0.384> <0.783, 1.364, 0.474> 
		<0.288, 0.436, 0.159> <0.432, 0.714, 0.249> <0.624, 1.085, 0.369> <0.768, 1.364, 0.460> 
		<0.271, 0.436, 0.159> <0.415, 0.714, 0.249> <0.607, 1.085, 0.369> <0.751, 1.364, 0.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, 0.436, 0.191> <0.303, 0.436, 0.208> <0.288, 0.436, 0.222> <0.271, 0.436, 0.222> 
		<0.447, 0.714, 0.281> <0.447, 0.714, 0.298> <0.432, 0.714, 0.312> <0.415, 0.714, 0.312> 
		<0.639, 1.085, 0.401> <0.639, 1.085, 0.418> <0.624, 1.085, 0.433> <0.607, 1.085, 0.433> 
		<0.783, 1.364, 0.491> <0.783, 1.364, 0.509> <0.768, 1.364, 0.523> <0.751, 1.364, 0.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.271, 0.436, 0.222> <0.254, 0.436, 0.222> <0.239, 0.436, 0.208> <0.239, 0.436, 0.191> 
		<0.415, 0.714, 0.312> <0.398, 0.714, 0.312> <0.383, 0.714, 0.298> <0.383, 0.714, 0.281> 
		<0.607, 1.085, 0.433> <0.590, 1.085, 0.433> <0.575, 1.085, 0.418> <0.575, 1.085, 0.401> 
		<0.751, 1.364, 0.523> <0.734, 1.364, 0.523> <0.719, 1.364, 0.509> <0.719, 1.364, 0.491> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.239, 0.436, 0.191> <0.239, 0.436, 0.173> <0.254, 0.436, 0.159> <0.271, 0.436, 0.159> 
		<0.383, 0.714, 0.281> <0.383, 0.714, 0.264> <0.398, 0.714, 0.249> <0.415, 0.714, 0.249> 
		<0.575, 1.085, 0.401> <0.575, 1.085, 0.384> <0.590, 1.085, 0.369> <0.607, 1.085, 0.369> 
		<0.719, 1.364, 0.491> <0.719, 1.364, 0.474> <0.734, 1.364, 0.460> <0.751, 1.364, 0.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.289, 0.426, 1.074> <0.437, 0.698, 1.015> <0.634, 1.061, 0.936> <0.783, 1.333, 0.877> 
		<0.289, 0.426, 1.091> <0.437, 0.698, 1.032> <0.634, 1.061, 0.953> <0.783, 1.333, 0.894> 
		<0.275, 0.426, 1.106> <0.423, 0.698, 1.046> <0.620, 1.061, 0.967> <0.768, 1.333, 0.908> 
		<0.257, 0.426, 1.106> <0.405, 0.698, 1.046> <0.603, 1.061, 0.967> <0.751, 1.333, 0.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.289, 0.426, 1.074> <0.289, 0.426, 1.057> <0.275, 0.426, 1.042> <0.257, 0.426, 1.042> 
		<0.437, 0.698, 1.015> <0.437, 0.698, 0.997> <0.423, 0.698, 0.983> <0.405, 0.698, 0.983> 
		<0.634, 1.061, 0.936> <0.634, 1.061, 0.919> <0.620, 1.061, 0.904> <0.603, 1.061, 0.904> 
		<0.783, 1.333, 0.877> <0.783, 1.333, 0.859> <0.768, 1.333, 0.845> <0.751, 1.333, 0.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.257, 0.426, 1.042> <0.240, 0.426, 1.042> <0.226, 0.426, 1.057> <0.226, 0.426, 1.074> 
		<0.405, 0.698, 0.983> <0.388, 0.698, 0.983> <0.374, 0.698, 0.997> <0.374, 0.698, 1.015> 
		<0.603, 1.061, 0.904> <0.586, 1.061, 0.904> <0.571, 1.061, 0.919> <0.571, 1.061, 0.936> 
		<0.751, 1.333, 0.845> <0.734, 1.333, 0.845> <0.719, 1.333, 0.859> <0.719, 1.333, 0.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, 0.426, 1.074> <0.226, 0.426, 1.091> <0.240, 0.426, 1.106> <0.257, 0.426, 1.106> 
		<0.374, 0.698, 1.015> <0.374, 0.698, 1.032> <0.388, 0.698, 1.046> <0.405, 0.698, 1.046> 
		<0.571, 1.061, 0.936> <0.571, 1.061, 0.953> <0.586, 1.061, 0.967> <0.603, 1.061, 0.967> 
		<0.719, 1.333, 0.877> <0.719, 1.333, 0.894> <0.734, 1.333, 0.908> <0.751, 1.333, 0.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.874, -1.104, 0.451> <0.874, -1.104, 0.451> <0.874, -1.104, 0.451> <0.874, -1.104, 0.451> 
		<0.874, -1.104, 0.431> <0.874, -1.104, 0.451> <0.874, -1.104, 0.451> <0.874, -1.104, 0.472> 
		<0.874, -1.116, 0.409> <0.874, -1.116, 0.434> <0.874, -1.116, 0.468> <0.874, -1.116, 0.493> 
		<0.874, -1.136, 0.409> <0.874, -1.136, 0.434> <0.874, -1.136, 0.468> <0.874, -1.136, 0.493> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.874, -1.104, 0.451> <0.874, -1.104, 0.431> <0.874, -1.116, 0.409> <0.874, -1.136, 0.409> 
		<0.350, -1.104, 0.451> <0.350, -1.104, 0.431> <0.350, -1.116, 0.409> <0.350, -1.136, 0.409> 
		<-0.350, -1.104, 0.451> <-0.350, -1.104, 0.431> <-0.350, -1.116, 0.409> <-0.350, -1.136, 0.409> 
		<-0.874, -1.104, 0.451> <-0.874, -1.104, 0.431> <-0.874, -1.116, 0.409> <-0.874, -1.136, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.874, -1.104, 0.451> <0.350, -1.104, 0.451> <-0.350, -1.104, 0.451> <-0.874, -1.104, 0.451> 
		<0.874, -1.104, 0.472> <0.350, -1.104, 0.472> <-0.350, -1.104, 0.472> <-0.874, -1.104, 0.472> 
		<0.874, -1.116, 0.493> <0.350, -1.116, 0.493> <-0.350, -1.116, 0.493> <-0.874, -1.116, 0.493> 
		<0.874, -1.136, 0.493> <0.350, -1.136, 0.493> <-0.350, -1.136, 0.493> <-0.874, -1.136, 0.493> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.874, -1.168, 0.451> <0.874, -1.168, 0.472> <0.874, -1.157, 0.493> <0.874, -1.136, 0.493> 
		<0.350, -1.168, 0.451> <0.350, -1.168, 0.472> <0.350, -1.157, 0.493> <0.350, -1.136, 0.493> 
		<-0.350, -1.168, 0.451> <-0.350, -1.168, 0.472> <-0.350, -1.157, 0.493> <-0.350, -1.136, 0.493> 
		<-0.874, -1.168, 0.451> <-0.874, -1.168, 0.472> <-0.874, -1.157, 0.493> <-0.874, -1.136, 0.493> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.874, -1.168, 0.451> <0.874, -1.168, 0.451> <0.874, -1.168, 0.451> <0.874, -1.168, 0.451> 
		<0.874, -1.168, 0.472> <0.874, -1.168, 0.451> <0.874, -1.168, 0.451> <0.874, -1.168, 0.431> 
		<0.874, -1.157, 0.493> <0.874, -1.157, 0.468> <0.874, -1.157, 0.434> <0.874, -1.157, 0.409> 
		<0.874, -1.136, 0.493> <0.874, -1.136, 0.468> <0.874, -1.136, 0.434> <0.874, -1.136, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.874, -1.168, 0.451> <0.350, -1.168, 0.451> <-0.350, -1.168, 0.451> <-0.874, -1.168, 0.451> 
		<0.874, -1.168, 0.431> <0.350, -1.168, 0.431> <-0.350, -1.168, 0.431> <-0.874, -1.168, 0.431> 
		<0.874, -1.157, 0.409> <0.350, -1.157, 0.409> <-0.350, -1.157, 0.409> <-0.874, -1.157, 0.409> 
		<0.874, -1.136, 0.409> <0.350, -1.136, 0.409> <-0.350, -1.136, 0.409> <-0.874, -1.136, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.874, -1.104, 0.451> <-0.874, -1.104, 0.451> <-0.874, -1.104, 0.451> <-0.874, -1.104, 0.451> 
		<-0.874, -1.104, 0.472> <-0.874, -1.104, 0.451> <-0.874, -1.104, 0.451> <-0.874, -1.104, 0.431> 
		<-0.874, -1.116, 0.493> <-0.874, -1.116, 0.468> <-0.874, -1.116, 0.434> <-0.874, -1.116, 0.409> 
		<-0.874, -1.136, 0.493> <-0.874, -1.136, 0.468> <-0.874, -1.136, 0.434> <-0.874, -1.136, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.874, -1.168, 0.451> <-0.874, -1.168, 0.451> <-0.874, -1.168, 0.451> <-0.874, -1.168, 0.451> 
		<-0.874, -1.168, 0.431> <-0.874, -1.168, 0.451> <-0.874, -1.168, 0.451> <-0.874, -1.168, 0.472> 
		<-0.874, -1.157, 0.409> <-0.874, -1.157, 0.434> <-0.874, -1.157, 0.468> <-0.874, -1.157, 0.493> 
		<-0.874, -1.136, 0.409> <-0.874, -1.136, 0.434> <-0.874, -1.136, 0.468> <-0.874, -1.136, 0.493> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 0.296, 4.750> <-0.017, 0.248, 4.765> <-0.017, 0.183, 4.783> <-0.017, 0.136, 4.802> 
		<-0.017, 0.292, 4.743> <-0.017, 0.243, 4.758> <-0.017, 0.177, 4.777> <-0.017, 0.130, 4.795> 
		<-0.008, 0.284, 4.732> <-0.008, 0.235, 4.747> <-0.009, 0.168, 4.765> <-0.009, 0.119, 4.784> 
		<0.000, 0.284, 4.732> <0.000, 0.235, 4.747> <0.000, 0.168, 4.765> <0.000, 0.119, 4.784> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 0.296, 4.750> <-0.017, 0.301, 4.757> <-0.008, 0.308, 4.768> <0.000, 0.308, 4.768> 
		<-0.017, 0.248, 4.765> <-0.017, 0.253, 4.772> <-0.008, 0.261, 4.783> <0.000, 0.261, 4.783> 
		<-0.017, 0.183, 4.783> <-0.017, 0.189, 4.790> <-0.009, 0.198, 4.801> <0.000, 0.198, 4.801> 
		<-0.017, 0.136, 4.802> <-0.017, 0.142, 4.808> <-0.009, 0.152, 4.819> <0.000, 0.152, 4.819> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.308, 4.768> <0.008, 0.308, 4.768> <0.017, 0.301, 4.757> <0.017, 0.296, 4.750> 
		<0.000, 0.261, 4.783> <0.008, 0.261, 4.783> <0.017, 0.253, 4.772> <0.017, 0.248, 4.765> 
		<0.000, 0.198, 4.801> <0.009, 0.198, 4.801> <0.017, 0.189, 4.789> <0.017, 0.183, 4.783> 
		<0.000, 0.152, 4.819> <0.009, 0.152, 4.819> <0.017, 0.142, 4.808> <0.017, 0.136, 4.802> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, 0.296, 4.750> <0.017, 0.292, 4.743> <0.008, 0.284, 4.732> <0.000, 0.284, 4.732> 
		<0.017, 0.248, 4.765> <0.017, 0.243, 4.758> <0.008, 0.235, 4.747> <0.000, 0.235, 4.747> 
		<0.017, 0.183, 4.783> <0.017, 0.177, 4.776> <0.009, 0.168, 4.765> <0.000, 0.168, 4.765> 
		<0.017, 0.136, 4.802> <0.017, 0.130, 4.795> <0.009, 0.119, 4.784> <0.000, 0.119, 4.784> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 0.136, 4.802> <-0.017, 0.115, 4.809> <-0.019, 0.090, 4.825> <-0.017, 0.072, 4.837> 
		<-0.017, 0.130, 4.795> <-0.017, 0.109, 4.803> <-0.019, 0.086, 4.818> <-0.017, 0.068, 4.829> 
		<-0.009, 0.119, 4.784> <-0.009, 0.101, 4.791> <-0.008, 0.079, 4.807> <-0.008, 0.062, 4.818> 
		<0.000, 0.119, 4.784> <0.000, 0.101, 4.791> <0.000, 0.079, 4.808> <0.000, 0.062, 4.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 0.136, 4.802> <-0.017, 0.142, 4.808> <-0.009, 0.152, 4.819> <0.000, 0.152, 4.819> 
		<-0.017, 0.115, 4.809> <-0.017, 0.121, 4.816> <-0.009, 0.130, 4.828> <0.000, 0.130, 4.828> 
		<-0.019, 0.090, 4.825> <-0.019, 0.095, 4.833> <-0.009, 0.105, 4.846> <0.000, 0.105, 4.847> 
		<-0.017, 0.072, 4.837> <-0.017, 0.077, 4.844> <-0.009, 0.085, 4.858> <0.000, 0.085, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.152, 4.819> <0.009, 0.152, 4.819> <0.017, 0.142, 4.808> <0.017, 0.136, 4.802> 
		<0.000, 0.130, 4.828> <0.009, 0.130, 4.828> <0.017, 0.121, 4.816> <0.017, 0.115, 4.810> 
		<0.000, 0.105, 4.847> <0.009, 0.105, 4.847> <0.020, 0.095, 4.835> <0.020, 0.091, 4.828> 
		<0.000, 0.085, 4.859> <0.009, 0.085, 4.859> <0.017, 0.076, 4.847> <0.017, 0.072, 4.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, 0.136, 4.802> <0.017, 0.130, 4.795> <0.009, 0.119, 4.784> <0.000, 0.119, 4.784> 
		<0.017, 0.115, 4.810> <0.017, 0.109, 4.803> <0.009, 0.101, 4.791> <0.000, 0.101, 4.791> 
		<0.020, 0.091, 4.828> <0.020, 0.086, 4.820> <0.009, 0.079, 4.808> <0.000, 0.079, 4.808> 
		<0.017, 0.072, 4.840> <0.017, 0.068, 4.832> <0.009, 0.062, 4.819> <0.000, 0.062, 4.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.034, 4.865> <-0.008, 0.032, 4.858> <-0.007, 0.027, 4.844> <0.000, 0.026, 4.844> 
		<-0.011, 0.046, 4.857> <-0.011, 0.043, 4.850> <-0.007, 0.038, 4.836> <0.000, 0.037, 4.836> 
		<-0.016, 0.060, 4.844> <-0.016, 0.056, 4.837> <-0.008, 0.051, 4.825> <0.000, 0.051, 4.826> 
		<-0.017, 0.072, 4.837> <-0.017, 0.068, 4.829> <-0.008, 0.062, 4.818> <0.000, 0.062, 4.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.034, 4.865> <-0.011, 0.046, 4.857> <-0.016, 0.060, 4.844> <-0.017, 0.072, 4.837> 
		<-0.008, 0.037, 4.872> <-0.011, 0.048, 4.863> <-0.016, 0.064, 4.852> <-0.017, 0.077, 4.844> 
		<-0.007, 0.042, 4.885> <-0.007, 0.055, 4.877> <-0.009, 0.071, 4.866> <-0.009, 0.085, 4.858> 
		<0.000, 0.040, 4.885> <0.000, 0.054, 4.877> <0.000, 0.071, 4.866> <0.000, 0.085, 4.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.040, 4.885> <0.000, 0.054, 4.877> <0.000, 0.071, 4.866> <0.000, 0.085, 4.859> 
		<0.006, 0.039, 4.885> <0.006, 0.052, 4.877> <0.009, 0.071, 4.867> <0.009, 0.085, 4.859> 
		<0.002, 0.035, 4.871> <0.007, 0.046, 4.864> <0.015, 0.064, 4.855> <0.017, 0.076, 4.847> 
		<0.002, 0.032, 4.865> <0.007, 0.044, 4.857> <0.015, 0.060, 4.847> <0.017, 0.072, 4.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.032, 4.865> <0.007, 0.044, 4.857> <0.015, 0.060, 4.847> <0.017, 0.072, 4.840> 
		<0.002, 0.030, 4.859> <0.007, 0.042, 4.851> <0.015, 0.055, 4.840> <0.017, 0.068, 4.832> 
		<0.007, 0.025, 4.844> <0.007, 0.035, 4.836> <0.009, 0.051, 4.826> <0.009, 0.062, 4.819> 
		<0.000, 0.026, 4.844> <0.000, 0.037, 4.836> <0.000, 0.051, 4.826> <0.000, 0.062, 4.818> 
	}
	texture {textSoportes}
	texture {textSucio}
}                   



#declare Trompa = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.563, 0.057, 0.000> <0.562, -0.067, 0.000> <0.491, -0.240, 0.000> <0.398, -0.322, 0.000> 
		<0.549, 0.058, -0.061> <0.549, -0.066, -0.061> <0.487, -0.223, 0.001> <0.394, -0.304, 0.001> 
		<0.543, 0.060, -0.147> <0.543, -0.057, -0.113> <0.429, -0.184, -0.061> <0.389, -0.281, 0.001> 
		<0.518, 0.060, -0.205> <0.518, -0.057, -0.171> <0.425, -0.166, -0.061> <0.386, -0.263, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.563, 0.057, 0.000> <0.549, 0.058, -0.061> <0.543, 0.060, -0.147> <0.518, 0.060, -0.205> 
		<0.563, 0.184, 0.000> <0.550, 0.185, -0.061> <0.543, 0.174, -0.181> <0.518, 0.175, -0.239> 
		<0.492, 0.359, 0.000> <0.487, 0.356, -0.061> <0.485, 0.365, -0.147> <0.469, 0.351, -0.205> 
		<0.401, 0.448, 0.000> <0.396, 0.444, -0.061> <0.402, 0.450, -0.147> <0.386, 0.436, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.518, 0.060, -0.205> <0.518, -0.057, -0.171> <0.425, -0.166, -0.061> <0.386, -0.263, 0.001> 
		<0.504, 0.061, -0.238> <0.504, -0.056, -0.203> <0.402, -0.104, -0.064> <0.363, -0.202, -0.003> 
		<0.471, 0.060, -0.279> <0.471, -0.019, -0.221> <0.371, -0.084, -0.091> <0.332, -0.119, -0.007> 
		<0.437, 0.060, -0.290> <0.437, -0.019, -0.232> <0.348, -0.022, -0.095> <0.309, -0.057, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.518, 0.060, -0.205> <0.504, 0.061, -0.238> <0.471, 0.060, -0.279> <0.437, 0.060, -0.290> 
		<0.518, 0.175, -0.239> <0.504, 0.175, -0.271> <0.471, 0.142, -0.339> <0.437, 0.142, -0.350> 
		<0.469, 0.351, -0.205> <0.457, 0.340, -0.249> <0.413, 0.329, -0.304> <0.381, 0.298, -0.319> 
		<0.386, 0.436, -0.205> <0.373, 0.426, -0.249> <0.341, 0.401, -0.310> <0.309, 0.370, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.060, -0.348> <0.201, 0.060, -0.331> <0.340, 0.060, -0.324> <0.437, 0.060, -0.290> 
		<0.100, 0.037, -0.348> <0.201, 0.037, -0.331> <0.340, -0.019, -0.265> <0.437, -0.019, -0.232> 
		<0.086, 0.006, -0.348> <0.158, -0.008, -0.247> <0.276, -0.008, -0.196> <0.348, -0.022, -0.095> 
		<0.071, -0.010, -0.348> <0.142, -0.024, -0.247> <0.238, -0.043, -0.112> <0.309, -0.057, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.060, -0.348> <0.100, 0.083, -0.348> <0.087, 0.115, -0.348> <0.071, 0.131, -0.348> 
		<0.201, 0.060, -0.331> <0.201, 0.083, -0.331> <0.159, 0.186, -0.341> <0.142, 0.203, -0.341> 
		<0.340, 0.060, -0.324> <0.340, 0.142, -0.383> <0.311, 0.231, -0.350> <0.240, 0.302, -0.356> 
		<0.437, 0.060, -0.290> <0.437, 0.142, -0.350> <0.381, 0.298, -0.319> <0.309, 0.370, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.071, 0.131, -0.348> <0.054, 0.147, -0.348> <0.023, 0.160, -0.348> <0.000, 0.160, -0.348> 
		<0.142, 0.203, -0.341> <0.126, 0.219, -0.341> <0.023, 0.262, -0.341> <0.000, 0.262, -0.341> 
		<0.240, 0.302, -0.356> <0.169, 0.373, -0.361> <0.100, 0.401, -0.356> <0.000, 0.401, -0.356> 
		<0.309, 0.370, -0.324> <0.238, 0.441, -0.330> <0.100, 0.498, -0.324> <0.000, 0.498, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.160, -0.348> <-0.023, 0.160, -0.348> <-0.054, 0.147, -0.348> <-0.071, 0.131, -0.348> 
		<0.000, 0.262, -0.341> <-0.023, 0.262, -0.341> <-0.126, 0.219, -0.341> <-0.142, 0.203, -0.341> 
		<0.000, 0.401, -0.356> <-0.100, 0.401, -0.356> <-0.171, 0.371, -0.362> <-0.242, 0.300, -0.357> 
		<0.000, 0.498, -0.324> <-0.100, 0.498, -0.324> <-0.238, 0.441, -0.330> <-0.309, 0.370, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.071, 0.131, -0.348> <-0.087, 0.115, -0.348> <-0.100, 0.083, -0.348> <-0.100, 0.060, -0.348> 
		<-0.142, 0.203, -0.341> <-0.159, 0.186, -0.341> <-0.201, 0.083, -0.331> <-0.201, 0.060, -0.331> 
		<-0.242, 0.300, -0.357> <-0.314, 0.229, -0.351> <-0.340, 0.142, -0.382> <-0.340, 0.060, -0.323> 
		<-0.309, 0.370, -0.324> <-0.381, 0.298, -0.319> <-0.437, 0.142, -0.349> <-0.437, 0.060, -0.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.060, -0.348> <-0.100, 0.037, -0.348> <-0.086, 0.006, -0.348> <-0.071, -0.010, -0.348> 
		<-0.201, 0.060, -0.331> <-0.201, 0.037, -0.331> <-0.158, -0.008, -0.249> <-0.142, -0.024, -0.249> 
		<-0.340, 0.060, -0.323> <-0.340, -0.018, -0.267> <-0.276, -0.008, -0.199> <-0.238, -0.043, -0.118> 
		<-0.437, 0.060, -0.290> <-0.437, -0.018, -0.234> <-0.348, -0.022, -0.101> <-0.309, -0.057, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.071, -0.010, -0.348> <-0.054, -0.028, -0.348> <-0.024, -0.046, -0.348> <0.000, -0.046, -0.348> 
		<-0.142, -0.024, -0.249> <-0.126, -0.042, -0.249> <-0.024, -0.049, -0.243> <0.000, -0.049, -0.243> 
		<-0.238, -0.043, -0.118> <-0.145, -0.043, -0.112> <-0.093, -0.053, -0.110> <0.000, -0.053, -0.104> 
		<-0.309, -0.057, -0.019> <-0.217, -0.057, -0.013> <-0.093, -0.057, -0.005> <0.000, -0.057, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.046, -0.348> <0.024, -0.046, -0.348> <0.054, -0.028, -0.348> <0.071, -0.010, -0.348> 
		<0.000, -0.049, -0.243> <0.024, -0.049, -0.243> <0.126, -0.042, -0.247> <0.142, -0.024, -0.247> 
		<0.000, -0.053, -0.104> <0.093, -0.053, -0.107> <0.145, -0.043, -0.108> <0.238, -0.043, -0.112> 
		<0.000, -0.057, 0.001> <0.093, -0.057, -0.003> <0.217, -0.057, -0.007> <0.309, -0.057, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.309, 0.370, -0.324> <0.238, 0.441, -0.330> <0.100, 0.498, -0.324> <0.000, 0.498, -0.324> 
		<0.341, 0.401, -0.310> <0.270, 0.472, -0.315> <0.100, 0.541, -0.310> <0.000, 0.541, -0.310> 
		<0.373, 0.426, -0.249> <0.286, 0.515, -0.249> <0.125, 0.578, -0.249> <0.000, 0.578, -0.249> 
		<0.386, 0.436, -0.205> <0.299, 0.526, -0.205> <0.125, 0.592, -0.205> <0.000, 0.592, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.498, -0.324> <-0.100, 0.498, -0.324> <-0.238, 0.441, -0.330> <-0.309, 0.370, -0.324> 
		<0.000, 0.541, -0.310> <-0.100, 0.541, -0.310> <-0.268, 0.471, -0.316> <-0.339, 0.400, -0.310> 
		<0.000, 0.578, -0.249> <-0.119, 0.578, -0.249> <-0.271, 0.512, -0.247> <-0.355, 0.427, -0.247> 
		<0.000, 0.592, -0.205> <-0.119, 0.592, -0.205> <-0.283, 0.522, -0.205> <-0.367, 0.436, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.309, 0.370, -0.324> <-0.381, 0.298, -0.319> <-0.437, 0.142, -0.349> <-0.437, 0.060, -0.290> 
		<-0.339, 0.400, -0.310> <-0.410, 0.329, -0.305> <-0.472, 0.142, -0.338> <-0.472, 0.060, -0.279> 
		<-0.355, 0.427, -0.247> <-0.441, 0.340, -0.247> <-0.509, 0.177, -0.273> <-0.509, 0.060, -0.239> 
		<-0.367, 0.436, -0.205> <-0.452, 0.349, -0.205> <-0.522, 0.177, -0.240> <-0.522, 0.060, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.437, 0.060, -0.290> <-0.437, -0.018, -0.234> <-0.348, -0.022, -0.101> <-0.309, -0.057, -0.019> 
		<-0.472, 0.060, -0.279> <-0.472, -0.018, -0.223> <-0.365, -0.084, -0.095> <-0.326, -0.119, -0.013> 
		<-0.509, 0.060, -0.239> <-0.509, -0.059, -0.204> <-0.396, -0.104, -0.067> <-0.349, -0.202, -0.005> 
		<-0.522, 0.060, -0.205> <-0.522, -0.059, -0.170> <-0.413, -0.166, -0.061> <-0.367, -0.263, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.386, 0.436, -0.205> <0.299, 0.526, -0.205> <0.125, 0.592, -0.205> <0.000, 0.592, -0.205> 
		<0.402, 0.450, -0.147> <0.315, 0.540, -0.147> <0.125, 0.612, -0.147> <0.000, 0.612, -0.147> 
		<0.396, 0.444, -0.061> <0.304, 0.535, -0.061> <0.129, 0.602, -0.061> <0.000, 0.601, -0.061> 
		<0.401, 0.448, 0.000> <0.308, 0.538, 0.000> <0.129, 0.606, 0.000> <0.000, 0.605, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.592, -0.205> <-0.119, 0.592, -0.205> <-0.283, 0.522, -0.205> <-0.367, 0.436, -0.205> 
		<0.000, 0.612, -0.147> <-0.119, 0.612, -0.147> <-0.299, 0.535, -0.147> <-0.383, 0.450, -0.147> 
		<0.000, 0.601, -0.061> <-0.129, 0.601, -0.061> <-0.297, 0.532, -0.061> <-0.390, 0.442, -0.061> 
		<0.000, 0.605, 0.000> <-0.129, 0.605, 0.000> <-0.307, 0.535, 0.000> <-0.400, 0.445, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.367, 0.436, -0.205> <-0.452, 0.349, -0.205> <-0.522, 0.177, -0.240> <-0.522, 0.060, -0.205> 
		<-0.383, 0.450, -0.147> <-0.468, 0.363, -0.147> <-0.546, 0.177, -0.182> <-0.546, 0.060, -0.147> 
		<-0.390, 0.442, -0.061> <-0.479, 0.355, -0.061> <-0.546, 0.185, -0.061> <-0.547, 0.060, -0.061> 
		<-0.400, 0.445, 0.000> <-0.489, 0.357, 0.000> <-0.556, 0.185, 0.000> <-0.557, 0.060, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.522, 0.060, -0.205> <-0.522, -0.059, -0.170> <-0.413, -0.166, -0.061> <-0.367, -0.263, 0.001> 
		<-0.546, 0.060, -0.147> <-0.546, -0.059, -0.112> <-0.425, -0.184, -0.061> <-0.378, -0.281, 0.001> 
		<-0.547, 0.060, -0.061> <-0.547, -0.063, -0.061> <-0.486, -0.223, 0.001> <-0.393, -0.305, 0.001> 
		<-0.557, 0.060, 0.000> <-0.558, -0.063, 0.000> <-0.497, -0.241, 0.000> <-0.404, -0.323, 0.000> 
	}
        //-----------
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.019, 0.072, -0.486> <0.019, 0.065, -0.486> <0.012, 0.056, -0.486> <0.006, 0.054, -0.486> 
		<0.011, 0.072, -0.486> <0.011, 0.065, -0.486> <0.010, 0.063, -0.486> <0.003, 0.061, -0.486> 
		<0.008, 0.072, -0.471> <0.008, 0.071, -0.471> <0.004, 0.065, -0.471> <0.002, 0.064, -0.471> 
		<0.003, 0.072, -0.465> <0.003, 0.071, -0.465> <0.002, 0.069, -0.465> <0.001, 0.069, -0.465> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.019, 0.072, -0.486> <0.011, 0.072, -0.486> <0.008, 0.072, -0.471> <0.003, 0.072, -0.465> 
		<0.019, 0.079, -0.486> <0.011, 0.079, -0.486> <0.008, 0.073, -0.471> <0.003, 0.073, -0.465> 
		<0.012, 0.088, -0.486> <0.010, 0.081, -0.486> <0.004, 0.079, -0.471> <0.002, 0.075, -0.465> 
		<0.006, 0.090, -0.486> <0.003, 0.083, -0.486> <0.002, 0.080, -0.471> <0.001, 0.075, -0.465> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.019, 0.072, -0.486> <0.044, 0.072, -0.487> <0.086, 0.072, -0.490> <0.100, 0.072, -0.470> 
		<0.019, 0.065, -0.486> <0.044, 0.065, -0.487> <0.086, 0.037, -0.490> <0.100, 0.037, -0.470> 
		<0.012, 0.056, -0.486> <0.020, 0.032, -0.487> <0.060, 0.001, -0.490> <0.064, -0.012, -0.470> 
		<0.006, 0.054, -0.486> <0.014, 0.030, -0.487> <0.027, -0.010, -0.490> <0.031, -0.023, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.019, 0.072, -0.486> <0.019, 0.079, -0.486> <0.012, 0.088, -0.486> <0.006, 0.090, -0.486> 
		<0.044, 0.072, -0.487> <0.044, 0.079, -0.487> <0.020, 0.112, -0.487> <0.014, 0.114, -0.487> 
		<0.086, 0.072, -0.490> <0.086, 0.107, -0.490> <0.060, 0.143, -0.490> <0.027, 0.154, -0.490> 
		<0.100, 0.072, -0.470> <0.100, 0.107, -0.470> <0.064, 0.156, -0.470> <0.031, 0.167, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.072, -0.470> <0.123, 0.072, -0.436> <0.116, 0.072, -0.376> <0.123, 0.072, -0.336> 
		<0.100, 0.037, -0.470> <0.123, 0.037, -0.436> <0.116, 0.030, -0.376> <0.123, 0.030, -0.336> 
		<0.064, -0.012, -0.470> <0.072, -0.033, -0.436> <0.076, -0.022, -0.376> <0.078, -0.028, -0.336> 
		<0.031, -0.023, -0.470> <0.038, -0.044, -0.436> <0.036, -0.036, -0.376> <0.038, -0.041, -0.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.072, -0.470> <0.100, 0.107, -0.470> <0.064, 0.156, -0.470> <0.031, 0.167, -0.470> 
		<0.123, 0.072, -0.436> <0.123, 0.107, -0.436> <0.072, 0.178, -0.436> <0.038, 0.189, -0.436> 
		<0.116, 0.072, -0.376> <0.116, 0.115, -0.376> <0.077, 0.169, -0.376> <0.036, 0.182, -0.376> 
		<0.123, 0.072, -0.336> <0.123, 0.115, -0.336> <0.079, 0.176, -0.336> <0.038, 0.189, -0.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.075, -0.465> <-0.000, 0.075, -0.465> <-0.002, 0.075, -0.465> <-0.003, 0.074, -0.465> 
		<0.002, 0.080, -0.471> <0.001, 0.080, -0.471> <-0.006, 0.078, -0.471> <-0.006, 0.077, -0.471> 
		<0.003, 0.083, -0.486> <-0.003, 0.085, -0.486> <-0.005, 0.084, -0.486> <-0.009, 0.079, -0.486> 
		<0.006, 0.090, -0.486> <-0.001, 0.092, -0.486> <-0.012, 0.089, -0.486> <-0.016, 0.083, -0.486> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, 0.074, -0.465> <-0.003, 0.073, -0.465> <-0.003, 0.071, -0.465> <-0.003, 0.070, -0.465> 
		<-0.006, 0.077, -0.471> <-0.007, 0.076, -0.471> <-0.007, 0.068, -0.471> <-0.006, 0.067, -0.471> 
		<-0.009, 0.079, -0.486> <-0.013, 0.073, -0.486> <-0.013, 0.071, -0.486> <-0.009, 0.065, -0.486> 
		<-0.016, 0.083, -0.486> <-0.020, 0.078, -0.486> <-0.020, 0.066, -0.486> <-0.016, 0.061, -0.486> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, 0.070, -0.465> <-0.002, 0.069, -0.465> <-0.000, 0.069, -0.465> <0.001, 0.069, -0.465> 
		<-0.006, 0.067, -0.471> <-0.006, 0.066, -0.471> <0.001, 0.064, -0.471> <0.002, 0.064, -0.471> 
		<-0.009, 0.065, -0.486> <-0.005, 0.060, -0.486> <-0.003, 0.059, -0.486> <0.003, 0.061, -0.486> 
		<-0.016, 0.061, -0.486> <-0.012, 0.055, -0.486> <-0.001, 0.052, -0.486> <0.006, 0.054, -0.486> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.006, 0.090, -0.486> <-0.001, 0.092, -0.486> <-0.012, 0.089, -0.486> <-0.016, 0.083, -0.486> 
		<0.014, 0.114, -0.487> <0.007, 0.116, -0.487> <-0.032, 0.103, -0.487> <-0.036, 0.098, -0.487> 
		<0.027, 0.154, -0.490> <-0.007, 0.165, -0.490> <-0.049, 0.151, -0.490> <-0.070, 0.123, -0.490> 
		<0.031, 0.167, -0.470> <-0.003, 0.178, -0.470> <-0.060, 0.159, -0.470> <-0.081, 0.131, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 0.083, -0.486> <-0.020, 0.078, -0.486> <-0.020, 0.066, -0.486> <-0.016, 0.061, -0.486> 
		<-0.036, 0.098, -0.487> <-0.040, 0.092, -0.487> <-0.040, 0.052, -0.487> <-0.036, 0.046, -0.487> 
		<-0.070, 0.123, -0.490> <-0.090, 0.094, -0.490> <-0.090, 0.050, -0.490> <-0.070, 0.022, -0.490> 
		<-0.081, 0.131, -0.470> <-0.102, 0.102, -0.470> <-0.102, 0.042, -0.470> <-0.081, 0.013, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 0.061, -0.486> <-0.012, 0.055, -0.486> <-0.001, 0.052, -0.486> <0.006, 0.054, -0.486> 
		<-0.036, 0.046, -0.487> <-0.032, 0.041, -0.487> <0.007, 0.028, -0.487> <0.014, 0.030, -0.487> 
		<-0.070, 0.022, -0.490> <-0.049, -0.007, -0.490> <-0.007, -0.021, -0.490> <0.027, -0.010, -0.490> 
		<-0.081, 0.013, -0.470> <-0.060, -0.015, -0.470> <-0.003, -0.034, -0.470> <0.031, -0.023, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.167, -0.470> <-0.003, 0.178, -0.470> <-0.060, 0.159, -0.470> <-0.081, 0.131, -0.470> 
		<0.038, 0.189, -0.436> <0.005, 0.200, -0.436> <-0.079, 0.173, -0.436> <-0.100, 0.144, -0.436> 
		<0.036, 0.182, -0.376> <-0.005, 0.196, -0.376> <-0.068, 0.175, -0.376> <-0.094, 0.140, -0.376> 
		<0.038, 0.189, -0.336> <-0.003, 0.202, -0.336> <-0.074, 0.179, -0.336> <-0.099, 0.144, -0.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, 0.131, -0.470> <-0.102, 0.102, -0.470> <-0.102, 0.042, -0.470> <-0.081, 0.013, -0.470> 
		<-0.100, 0.144, -0.436> <-0.120, 0.116, -0.436> <-0.120, 0.028, -0.436> <-0.100, -0.000, -0.436> 
		<-0.094, 0.140, -0.376> <-0.119, 0.105, -0.376> <-0.120, 0.039, -0.376> <-0.094, 0.004, -0.376> 
		<-0.099, 0.144, -0.336> <-0.125, 0.109, -0.336> <-0.125, 0.035, -0.336> <-0.099, -0.000, -0.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, 0.013, -0.470> <-0.060, -0.015, -0.470> <-0.003, -0.034, -0.470> <0.031, -0.023, -0.470> 
		<-0.100, -0.000, -0.436> <-0.079, -0.029, -0.436> <0.005, -0.055, -0.436> <0.038, -0.044, -0.436> 
		<-0.094, 0.004, -0.376> <-0.068, -0.031, -0.376> <-0.005, -0.049, -0.376> <0.036, -0.036, -0.376> 
		<-0.099, -0.000, -0.336> <-0.074, -0.035, -0.336> <-0.003, -0.054, -0.336> <0.038, -0.041, -0.336> 
	}

        texture {textTrompa}
        texture {textSucio}

}   


#declare M_Cuerpo = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.049, 0.223, 1.331> <-0.033, 0.219, 1.326> <-0.013, 0.200, 1.332> <0.004, 0.201, 1.332> 
		<-0.047, 0.289, 1.325> <-0.031, 0.285, 1.320> <-0.014, 0.232, 1.327> <0.003, 0.233, 1.327> 
		<-0.065, 0.377, 1.325> <-0.039, 0.371, 1.315> <-0.015, 0.351, 1.300> <0.013, 0.350, 1.296> 
		<-0.068, 0.443, 1.329> <-0.042, 0.437, 1.318> <-0.012, 0.416, 1.300> <0.016, 0.416, 1.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.049, 0.223, 1.331> <-0.047, 0.289, 1.325> <-0.065, 0.377, 1.325> <-0.068, 0.443, 1.329> 
		<-0.073, 0.229, 1.337> <-0.071, 0.295, 1.332> <-0.077, 0.380, 1.330> <-0.080, 0.445, 1.334> 
		<-0.107, 0.231, 1.350> <-0.104, 0.294, 1.342> <-0.100, 0.383, 1.340> <-0.100, 0.447, 1.338> 
		<-0.123, 0.233, 1.369> <-0.120, 0.296, 1.361> <-0.109, 0.380, 1.350> <-0.110, 0.444, 1.347> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.049, 0.223, 1.331> <-0.073, 0.229, 1.337> <-0.107, 0.231, 1.350> <-0.123, 0.233, 1.369> 
		<-0.051, 0.152, 1.337> <-0.075, 0.158, 1.343> <-0.110, 0.158, 1.359> <-0.127, 0.161, 1.378> 
		<-0.058, 0.054, 1.346> <-0.064, 0.036, 1.351> <-0.118, 0.064, 1.378> <-0.129, 0.065, 1.394> 
		<-0.081, -0.011, 1.367> <-0.087, -0.028, 1.372> <-0.121, -0.008, 1.389> <-0.131, -0.007, 1.405> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.049, 0.223, 1.331> <-0.051, 0.152, 1.337> <-0.058, 0.054, 1.346> <-0.081, -0.011, 1.367> 
		<-0.033, 0.219, 1.326> <-0.035, 0.148, 1.332> <-0.027, 0.050, 1.343> <-0.051, -0.014, 1.364> 
		<-0.013, 0.200, 1.332> <-0.013, 0.168, 1.336> <0.033, 0.012, 1.352> <0.009, -0.050, 1.362> 
		<0.004, 0.201, 1.332> <0.004, 0.168, 1.336> <0.044, 0.040, 1.347> <0.020, -0.022, 1.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.110, 0.444, 1.347> <-0.132, 0.436, 1.371> <-0.169, 0.412, 1.400> <-0.169, 0.410, 1.433> 
		<-0.109, 0.380, 1.350> <-0.132, 0.373, 1.373> <-0.164, 0.361, 1.403> <-0.164, 0.359, 1.436> 
		<-0.120, 0.296, 1.361> <-0.137, 0.299, 1.379> <-0.155, 0.292, 1.419> <-0.155, 0.292, 1.444> 
		<-0.123, 0.233, 1.369> <-0.140, 0.236, 1.387> <-0.151, 0.241, 1.421> <-0.151, 0.241, 1.446> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.110, 0.444, 1.347> <-0.100, 0.447, 1.338> <-0.080, 0.445, 1.334> <-0.068, 0.443, 1.329> 
		<-0.110, 0.469, 1.346> <-0.100, 0.472, 1.337> <-0.082, 0.481, 1.335> <-0.070, 0.478, 1.330> 
		<-0.123, 0.501, 1.352> <-0.111, 0.513, 1.341> <-0.090, 0.524, 1.341> <-0.070, 0.525, 1.338> 
		<-0.125, 0.525, 1.357> <-0.112, 0.538, 1.347> <-0.086, 0.558, 1.350> <-0.066, 0.559, 1.347> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.110, 0.444, 1.347> <-0.110, 0.469, 1.346> <-0.123, 0.501, 1.352> <-0.125, 0.525, 1.357> 
		<-0.132, 0.436, 1.371> <-0.132, 0.461, 1.370> <-0.145, 0.479, 1.370> <-0.146, 0.503, 1.375> 
		<-0.169, 0.412, 1.400> <-0.171, 0.424, 1.400> <-0.172, 0.440, 1.399> <-0.173, 0.452, 1.401> 
		<-0.169, 0.410, 1.433> <-0.171, 0.422, 1.433> <-0.171, 0.438, 1.435> <-0.172, 0.451, 1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.068, 0.443, 1.329> <-0.042, 0.437, 1.318> <-0.012, 0.416, 1.300> <0.016, 0.416, 1.297> 
		<-0.070, 0.478, 1.330> <-0.044, 0.472, 1.320> <-0.009, 0.454, 1.301> <0.019, 0.453, 1.298> 
		<-0.070, 0.525, 1.338> <-0.042, 0.527, 1.334> <-0.002, 0.500, 1.320> <0.026, 0.500, 1.322> 
		<-0.066, 0.559, 1.347> <-0.038, 0.561, 1.343> <-0.005, 0.535, 1.335> <0.023, 0.535, 1.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.066, 0.559, 1.347> <-0.062, 0.592, 1.357> <-0.044, 0.643, 1.362> <-0.044, 0.663, 1.391> 
		<-0.086, 0.558, 1.350> <-0.083, 0.591, 1.359> <-0.067, 0.648, 1.364> <-0.067, 0.668, 1.392> 
		<-0.112, 0.538, 1.347> <-0.115, 0.579, 1.357> <-0.100, 0.637, 1.367> <-0.099, 0.666, 1.399> 
		<-0.125, 0.525, 1.357> <-0.127, 0.566, 1.367> <-0.123, 0.633, 1.366> <-0.122, 0.662, 1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.066, 0.559, 1.347> <-0.038, 0.561, 1.343> <-0.005, 0.535, 1.335> <0.023, 0.535, 1.337> 
		<-0.062, 0.592, 1.357> <-0.035, 0.594, 1.353> <-0.007, 0.567, 1.348> <0.021, 0.567, 1.350> 
		<-0.044, 0.643, 1.362> <-0.029, 0.640, 1.362> <0.010, 0.620, 1.384> <0.016, 0.607, 1.378> 
		<-0.044, 0.663, 1.391> <-0.028, 0.660, 1.390> <-0.006, 0.649, 1.396> <0.001, 0.636, 1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.241, 1.446> <-0.155, 0.292, 1.444> <-0.164, 0.359, 1.436> <-0.169, 0.410, 1.433> 
		<-0.151, 0.241, 1.474> <-0.155, 0.292, 1.472> <-0.164, 0.356, 1.473> <-0.169, 0.407, 1.471> 
		<-0.140, 0.238, 1.514> <-0.140, 0.297, 1.519> <-0.134, 0.368, 1.512> <-0.134, 0.427, 1.514> 
		<-0.122, 0.233, 1.535> <-0.121, 0.292, 1.540> <-0.110, 0.371, 1.541> <-0.110, 0.430, 1.543> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.241, 1.446> <-0.145, 0.167, 1.449> <-0.141, 0.068, 1.450> <-0.137, -0.006, 1.452> 
		<-0.151, 0.241, 1.421> <-0.146, 0.167, 1.424> <-0.144, 0.068, 1.436> <-0.140, -0.006, 1.438> 
		<-0.140, 0.236, 1.387> <-0.143, 0.164, 1.396> <-0.137, 0.066, 1.406> <-0.139, -0.006, 1.417> 
		<-0.123, 0.233, 1.369> <-0.127, 0.161, 1.378> <-0.129, 0.065, 1.394> <-0.131, -0.007, 1.405> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.241, 1.446> <-0.151, 0.241, 1.474> <-0.140, 0.238, 1.514> <-0.122, 0.233, 1.535> 
		<-0.145, 0.167, 1.449> <-0.145, 0.167, 1.477> <-0.141, 0.165, 1.509> <-0.122, 0.161, 1.529> 
		<-0.141, 0.068, 1.450> <-0.138, 0.068, 1.468> <-0.127, 0.071, 1.504> <-0.116, 0.065, 1.517> 
		<-0.137, -0.006, 1.452> <-0.134, -0.006, 1.470> <-0.125, -0.001, 1.496> <-0.114, -0.007, 1.510> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.067, 0.223, 1.540> <-0.073, 0.146, 1.530> <-0.065, 0.041, 1.530> <-0.080, -0.034, 1.520> 
		<-0.083, 0.225, 1.534> <-0.088, 0.148, 1.525> <-0.068, 0.028, 1.528> <-0.083, -0.047, 1.518> 
		<-0.111, 0.231, 1.547> <-0.111, 0.159, 1.542> <-0.108, 0.061, 1.527> <-0.106, -0.011, 1.519> 
		<-0.122, 0.233, 1.535> <-0.122, 0.161, 1.529> <-0.116, 0.065, 1.517> <-0.114, -0.007, 1.510> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.067, 0.223, 1.540> <-0.044, 0.219, 1.548> <-0.019, 0.211, 1.577> <0.006, 0.216, 1.579> 
		<-0.073, 0.146, 1.530> <-0.049, 0.143, 1.538> <-0.021, 0.136, 1.571> <0.003, 0.140, 1.573> 
		<-0.065, 0.041, 1.530> <-0.041, 0.041, 1.537> <0.015, 0.013, 1.556> <0.023, 0.036, 1.562> 
		<-0.080, -0.034, 1.520> <-0.056, -0.034, 1.527> <-0.009, -0.057, 1.540> <-0.001, -0.033, 1.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.067, 0.223, 1.540> <-0.083, 0.225, 1.534> <-0.111, 0.231, 1.547> <-0.122, 0.233, 1.535> 
		<-0.063, 0.285, 1.547> <-0.078, 0.287, 1.542> <-0.110, 0.290, 1.552> <-0.121, 0.292, 1.540> 
		<-0.044, 0.365, 1.569> <-0.064, 0.363, 1.563> <-0.096, 0.373, 1.557> <-0.110, 0.371, 1.541> 
		<-0.047, 0.427, 1.577> <-0.068, 0.425, 1.570> <-0.096, 0.432, 1.559> <-0.110, 0.430, 1.543> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.067, 0.223, 1.540> <-0.063, 0.285, 1.547> <-0.044, 0.365, 1.569> <-0.047, 0.427, 1.577> 
		<-0.044, 0.219, 1.548> <-0.039, 0.281, 1.555> <-0.026, 0.367, 1.575> <-0.030, 0.429, 1.582> 
		<-0.019, 0.211, 1.577> <-0.017, 0.279, 1.582> <-0.007, 0.374, 1.592> <-0.006, 0.442, 1.585> 
		<0.006, 0.216, 1.579> <0.008, 0.284, 1.584> <0.011, 0.375, 1.590> <0.013, 0.443, 1.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.110, 0.430, 1.543> <-0.134, 0.427, 1.514> <-0.169, 0.407, 1.471> <-0.169, 0.410, 1.433> 
		<-0.110, 0.456, 1.544> <-0.134, 0.453, 1.515> <-0.171, 0.419, 1.471> <-0.171, 0.422, 1.433> 
		<-0.120, 0.491, 1.550> <-0.139, 0.470, 1.520> <-0.171, 0.437, 1.476> <-0.171, 0.438, 1.435> 
		<-0.121, 0.517, 1.546> <-0.140, 0.496, 1.516> <-0.172, 0.449, 1.478> <-0.172, 0.451, 1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.110, 0.430, 1.543> <-0.110, 0.456, 1.544> <-0.120, 0.491, 1.550> <-0.121, 0.517, 1.546> 
		<-0.096, 0.432, 1.559> <-0.096, 0.458, 1.560> <-0.112, 0.500, 1.563> <-0.113, 0.526, 1.559> 
		<-0.068, 0.425, 1.570> <-0.069, 0.463, 1.575> <-0.099, 0.511, 1.588> <-0.102, 0.548, 1.579> 
		<-0.047, 0.427, 1.577> <-0.049, 0.465, 1.581> <-0.081, 0.512, 1.588> <-0.084, 0.549, 1.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, 0.427, 1.577> <-0.049, 0.465, 1.581> <-0.081, 0.512, 1.588> <-0.084, 0.549, 1.579> 
		<-0.030, 0.429, 1.582> <-0.032, 0.467, 1.587> <-0.050, 0.513, 1.588> <-0.052, 0.550, 1.579> 
		<-0.006, 0.442, 1.585> <-0.005, 0.468, 1.582> <-0.018, 0.501, 1.553> <-0.019, 0.527, 1.546> 
		<0.013, 0.443, 1.582> <0.013, 0.469, 1.579> <0.014, 0.497, 1.552> <0.012, 0.523, 1.546> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 0.549, 1.579> <-0.102, 0.548, 1.579> <-0.113, 0.526, 1.559> <-0.121, 0.517, 1.546> 
		<-0.086, 0.591, 1.570> <-0.104, 0.590, 1.570> <-0.115, 0.570, 1.553> <-0.123, 0.561, 1.540> 
		<-0.071, 0.656, 1.556> <-0.089, 0.654, 1.554> <-0.103, 0.634, 1.547> <-0.119, 0.630, 1.542> 
		<-0.064, 0.678, 1.519> <-0.081, 0.676, 1.518> <-0.103, 0.665, 1.515> <-0.119, 0.661, 1.510> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 0.549, 1.579> <-0.086, 0.591, 1.570> <-0.071, 0.656, 1.556> <-0.064, 0.678, 1.519> 
		<-0.052, 0.550, 1.579> <-0.055, 0.592, 1.570> <-0.052, 0.658, 1.557> <-0.044, 0.680, 1.521> 
		<-0.019, 0.527, 1.546> <-0.021, 0.571, 1.534> <0.005, 0.666, 1.521> <-0.002, 0.680, 1.518> 
		<0.012, 0.523, 1.546> <0.010, 0.567, 1.533> <0.008, 0.660, 1.522> <0.001, 0.674, 1.519> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, 0.451, 1.436> <-0.174, 0.466, 1.439> <-0.179, 0.488, 1.455> <-0.177, 0.501, 1.447> 
		<-0.172, 0.449, 1.478> <-0.173, 0.464, 1.480> <-0.178, 0.503, 1.471> <-0.177, 0.517, 1.463> 
		<-0.140, 0.496, 1.516> <-0.159, 0.507, 1.502> <-0.168, 0.531, 1.513> <-0.184, 0.532, 1.494> 
		<-0.121, 0.517, 1.546> <-0.140, 0.528, 1.532> <-0.166, 0.553, 1.519> <-0.182, 0.553, 1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, 0.451, 1.436> <-0.173, 0.452, 1.401> <-0.146, 0.503, 1.375> <-0.125, 0.525, 1.357> 
		<-0.174, 0.466, 1.439> <-0.174, 0.467, 1.403> <-0.158, 0.507, 1.384> <-0.137, 0.529, 1.366> 
		<-0.179, 0.488, 1.455> <-0.177, 0.507, 1.444> <-0.152, 0.519, 1.397> <-0.150, 0.539, 1.388> 
		<-0.177, 0.501, 1.447> <-0.176, 0.521, 1.436> <-0.167, 0.519, 1.394> <-0.165, 0.540, 1.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.064, 0.678, 1.519> <-0.081, 0.676, 1.518> <-0.103, 0.665, 1.515> <-0.119, 0.661, 1.510> 
		<-0.057, 0.698, 1.486> <-0.074, 0.696, 1.485> <-0.103, 0.689, 1.491> <-0.120, 0.684, 1.486> 
		<-0.043, 0.685, 1.423> <-0.066, 0.690, 1.424> <-0.098, 0.688, 1.424> <-0.121, 0.684, 1.423> 
		<-0.044, 0.663, 1.391> <-0.067, 0.668, 1.392> <-0.099, 0.666, 1.399> <-0.122, 0.662, 1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, 0.517, 1.546> <-0.140, 0.528, 1.532> <-0.166, 0.553, 1.519> <-0.182, 0.553, 1.500> 
		<-0.123, 0.561, 1.540> <-0.142, 0.572, 1.526> <-0.163, 0.581, 1.528> <-0.180, 0.581, 1.508> 
		<-0.119, 0.630, 1.542> <-0.133, 0.626, 1.538> <-0.160, 0.639, 1.523> <-0.168, 0.632, 1.513> 
		<-0.119, 0.661, 1.510> <-0.133, 0.657, 1.506> <-0.155, 0.658, 1.500> <-0.163, 0.650, 1.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 0.661, 1.510> <-0.133, 0.657, 1.506> <-0.155, 0.658, 1.500> <-0.163, 0.650, 1.490> 
		<-0.120, 0.684, 1.486> <-0.133, 0.680, 1.482> <-0.150, 0.677, 1.476> <-0.158, 0.669, 1.466> 
		<-0.121, 0.684, 1.423> <-0.134, 0.682, 1.423> <-0.152, 0.675, 1.414> <-0.159, 0.666, 1.408> 
		<-0.122, 0.662, 1.398> <-0.135, 0.659, 1.397> <-0.153, 0.653, 1.392> <-0.159, 0.643, 1.386> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.122, 0.662, 1.398> <-0.135, 0.659, 1.397> <-0.153, 0.653, 1.392> <-0.159, 0.643, 1.386> 
		<-0.123, 0.633, 1.366> <-0.136, 0.631, 1.365> <-0.153, 0.630, 1.371> <-0.159, 0.620, 1.365> 
		<-0.127, 0.566, 1.367> <-0.139, 0.571, 1.375> <-0.146, 0.568, 1.376> <-0.161, 0.568, 1.373> 
		<-0.125, 0.525, 1.357> <-0.137, 0.529, 1.366> <-0.150, 0.539, 1.388> <-0.165, 0.540, 1.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.643, 1.386> <-0.159, 0.666, 1.408> <-0.158, 0.669, 1.466> <-0.163, 0.650, 1.490> 
		<-0.168, 0.629, 1.378> <-0.168, 0.651, 1.399> <-0.177, 0.651, 1.443> <-0.182, 0.632, 1.467> 
		<-0.172, 0.603, 1.367> <-0.182, 0.615, 1.378> <-0.197, 0.614, 1.420> <-0.204, 0.603, 1.433> 
		<-0.170, 0.588, 1.354> <-0.180, 0.600, 1.366> <-0.198, 0.591, 1.393> <-0.205, 0.580, 1.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.643, 1.386> <-0.168, 0.629, 1.378> <-0.172, 0.603, 1.367> <-0.170, 0.588, 1.354> 
		<-0.159, 0.620, 1.365> <-0.169, 0.606, 1.356> <-0.162, 0.592, 1.355> <-0.160, 0.577, 1.342> 
		<-0.161, 0.568, 1.373> <-0.172, 0.568, 1.371> <-0.157, 0.549, 1.349> <-0.155, 0.542, 1.341> 
		<-0.165, 0.540, 1.385> <-0.176, 0.540, 1.383> <-0.160, 0.533, 1.359> <-0.157, 0.525, 1.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.165, 0.540, 1.385> <-0.176, 0.540, 1.383> <-0.160, 0.533, 1.359> <-0.157, 0.525, 1.351> 
		<-0.167, 0.519, 1.394> <-0.178, 0.520, 1.392> <-0.163, 0.510, 1.374> <-0.161, 0.503, 1.366> 
		<-0.176, 0.521, 1.436> <-0.176, 0.514, 1.429> <-0.173, 0.487, 1.409> <-0.171, 0.481, 1.401> 
		<-0.177, 0.501, 1.447> <-0.178, 0.494, 1.440> <-0.187, 0.485, 1.432> <-0.186, 0.479, 1.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.177, 0.501, 1.447> <-0.178, 0.494, 1.440> <-0.187, 0.485, 1.432> <-0.186, 0.479, 1.424> 
		<-0.177, 0.517, 1.463> <-0.177, 0.510, 1.456> <-0.195, 0.484, 1.444> <-0.194, 0.478, 1.436> 
		<-0.184, 0.532, 1.494> <-0.199, 0.532, 1.477> <-0.210, 0.517, 1.460> <-0.210, 0.504, 1.442> 
		<-0.182, 0.553, 1.500> <-0.197, 0.553, 1.483> <-0.213, 0.532, 1.458> <-0.212, 0.518, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.182, 0.553, 1.500> <-0.197, 0.553, 1.483> <-0.213, 0.532, 1.458> <-0.212, 0.518, 1.439> 
		<-0.180, 0.581, 1.508> <-0.194, 0.582, 1.491> <-0.217, 0.552, 1.454> <-0.216, 0.539, 1.436> 
		<-0.168, 0.632, 1.513> <-0.187, 0.614, 1.490> <-0.212, 0.591, 1.448> <-0.212, 0.568, 1.422> 
		<-0.163, 0.650, 1.490> <-0.182, 0.632, 1.467> <-0.204, 0.603, 1.433> <-0.205, 0.580, 1.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.170, 0.588, 1.354> <-0.180, 0.600, 1.366> <-0.198, 0.591, 1.393> <-0.205, 0.580, 1.407> 
		<-0.164, 0.548, 1.320> <-0.174, 0.560, 1.331> <-0.200, 0.547, 1.343> <-0.206, 0.536, 1.357> 
		<-0.144, 0.497, 1.274> <-0.157, 0.504, 1.271> <-0.176, 0.485, 1.292> <-0.183, 0.472, 1.296> 
		<-0.132, 0.464, 1.233> <-0.145, 0.471, 1.231> <-0.164, 0.445, 1.240> <-0.171, 0.432, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.170, 0.588, 1.354> <-0.164, 0.548, 1.320> <-0.144, 0.497, 1.274> <-0.132, 0.464, 1.233> 
		<-0.160, 0.577, 1.342> <-0.154, 0.537, 1.308> <-0.128, 0.488, 1.277> <-0.117, 0.455, 1.236> 
		<-0.155, 0.542, 1.341> <-0.146, 0.509, 1.309> <-0.136, 0.454, 1.284> <-0.125, 0.425, 1.248> 
		<-0.157, 0.525, 1.351> <-0.148, 0.493, 1.319> <-0.138, 0.437, 1.288> <-0.127, 0.408, 1.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.157, 0.525, 1.351> <-0.148, 0.493, 1.319> <-0.138, 0.437, 1.288> <-0.127, 0.408, 1.253> 
		<-0.161, 0.503, 1.366> <-0.151, 0.470, 1.333> <-0.140, 0.424, 1.292> <-0.129, 0.396, 1.256> 
		<-0.171, 0.481, 1.401> <-0.163, 0.446, 1.352> <-0.143, 0.405, 1.309> <-0.133, 0.374, 1.257> 
		<-0.186, 0.479, 1.424> <-0.177, 0.444, 1.375> <-0.155, 0.399, 1.311> <-0.144, 0.368, 1.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.186, 0.479, 1.424> <-0.177, 0.444, 1.375> <-0.155, 0.399, 1.311> <-0.144, 0.368, 1.260> 
		<-0.194, 0.478, 1.436> <-0.185, 0.444, 1.387> <-0.164, 0.394, 1.313> <-0.154, 0.363, 1.262> 
		<-0.210, 0.504, 1.442> <-0.208, 0.464, 1.387> <-0.185, 0.409, 1.321> <-0.173, 0.373, 1.265> 
		<-0.212, 0.518, 1.439> <-0.211, 0.479, 1.384> <-0.189, 0.419, 1.318> <-0.177, 0.382, 1.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.212, 0.518, 1.439> <-0.211, 0.479, 1.384> <-0.189, 0.419, 1.318> <-0.177, 0.382, 1.263> 
		<-0.216, 0.539, 1.436> <-0.215, 0.499, 1.381> <-0.195, 0.434, 1.315> <-0.183, 0.397, 1.259> 
		<-0.212, 0.568, 1.422> <-0.214, 0.523, 1.372> <-0.191, 0.459, 1.301> <-0.178, 0.419, 1.249> 
		<-0.205, 0.580, 1.407> <-0.206, 0.536, 1.357> <-0.183, 0.472, 1.296> <-0.171, 0.432, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.110, 0.416, 1.145> <-0.116, 0.430, 1.171> <-0.125, 0.445, 1.210> <-0.132, 0.464, 1.233> 
		<-0.123, 0.418, 1.140> <-0.130, 0.433, 1.167> <-0.138, 0.452, 1.208> <-0.145, 0.471, 1.231> 
		<-0.136, 0.394, 1.149> <-0.145, 0.409, 1.177> <-0.157, 0.425, 1.214> <-0.164, 0.445, 1.240> 
		<-0.143, 0.381, 1.150> <-0.151, 0.397, 1.178> <-0.164, 0.412, 1.218> <-0.171, 0.432, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.110, 0.416, 1.145> <-0.096, 0.414, 1.149> <-0.097, 0.388, 1.162> <-0.100, 0.374, 1.164> 
		<-0.116, 0.430, 1.171> <-0.103, 0.428, 1.176> <-0.105, 0.398, 1.189> <-0.108, 0.384, 1.190> 
		<-0.125, 0.445, 1.210> <-0.110, 0.436, 1.213> <-0.118, 0.407, 1.226> <-0.121, 0.390, 1.230> 
		<-0.132, 0.464, 1.233> <-0.117, 0.455, 1.236> <-0.125, 0.425, 1.248> <-0.127, 0.408, 1.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.374, 1.164> <-0.104, 0.355, 1.165> <-0.115, 0.330, 1.156> <-0.130, 0.318, 1.153> 
		<-0.108, 0.384, 1.190> <-0.112, 0.366, 1.192> <-0.119, 0.345, 1.188> <-0.134, 0.333, 1.185> 
		<-0.121, 0.390, 1.230> <-0.122, 0.378, 1.234> <-0.126, 0.356, 1.227> <-0.138, 0.350, 1.230> 
		<-0.127, 0.408, 1.253> <-0.129, 0.396, 1.256> <-0.133, 0.374, 1.257> <-0.144, 0.368, 1.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 0.318, 1.153> <-0.137, 0.313, 1.152> <-0.153, 0.322, 1.154> <-0.155, 0.331, 1.153> 
		<-0.134, 0.333, 1.185> <-0.141, 0.328, 1.184> <-0.160, 0.338, 1.187> <-0.161, 0.346, 1.186> 
		<-0.138, 0.350, 1.230> <-0.147, 0.345, 1.232> <-0.167, 0.353, 1.235> <-0.171, 0.362, 1.232> 
		<-0.144, 0.368, 1.260> <-0.154, 0.363, 1.262> <-0.173, 0.373, 1.265> <-0.177, 0.382, 1.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.155, 0.331, 1.153> <-0.158, 0.346, 1.152> <-0.150, 0.367, 1.151> <-0.143, 0.381, 1.150> 
		<-0.161, 0.346, 1.186> <-0.165, 0.361, 1.185> <-0.159, 0.383, 1.180> <-0.151, 0.397, 1.178> 
		<-0.171, 0.362, 1.232> <-0.177, 0.377, 1.229> <-0.172, 0.399, 1.223> <-0.164, 0.412, 1.218> 
		<-0.177, 0.382, 1.263> <-0.183, 0.397, 1.259> <-0.178, 0.419, 1.249> <-0.171, 0.432, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.636, 1.391> <0.016, 0.607, 1.378> <0.021, 0.567, 1.350> <0.023, 0.535, 1.337> 
		<0.024, 0.643, 1.391> <0.039, 0.614, 1.378> <0.041, 0.568, 1.352> <0.043, 0.536, 1.338> 
		<0.053, 0.656, 1.390> <0.052, 0.638, 1.365> <0.059, 0.593, 1.366> <0.060, 0.564, 1.355> 
		<0.076, 0.659, 1.391> <0.075, 0.641, 1.366> <0.079, 0.591, 1.369> <0.080, 0.563, 1.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, -0.022, 1.357> <0.041, -0.020, 1.355> <0.070, -0.016, 1.352> <0.092, -0.013, 1.350> 
		<0.044, 0.040, 1.347> <0.066, 0.043, 1.345> <0.052, 0.052, 1.331> <0.074, 0.054, 1.329> 
		<0.004, 0.168, 1.336> <0.033, 0.170, 1.337> <0.069, 0.151, 1.332> <0.096, 0.157, 1.338> 
		<0.004, 0.201, 1.332> <0.033, 0.202, 1.332> <0.068, 0.224, 1.325> <0.096, 0.230, 1.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.096, 0.230, 1.332> <0.115, 0.234, 1.337> <0.142, 0.232, 1.352> <0.154, 0.233, 1.369> 
		<0.095, 0.293, 1.326> <0.115, 0.297, 1.331> <0.139, 0.295, 1.344> <0.151, 0.296, 1.361> 
		<0.090, 0.377, 1.305> <0.108, 0.381, 1.312> <0.127, 0.384, 1.336> <0.139, 0.380, 1.350> 
		<0.087, 0.441, 1.310> <0.105, 0.445, 1.317> <0.127, 0.447, 1.333> <0.140, 0.444, 1.347> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.096, 0.230, 1.332> <0.095, 0.293, 1.326> <0.090, 0.377, 1.305> <0.087, 0.441, 1.310> 
		<0.068, 0.224, 1.325> <0.067, 0.287, 1.320> <0.069, 0.373, 1.296> <0.066, 0.436, 1.301> 
		<0.033, 0.202, 1.332> <0.032, 0.234, 1.328> <0.035, 0.350, 1.293> <0.039, 0.415, 1.294> 
		<0.004, 0.201, 1.332> <0.003, 0.233, 1.327> <0.013, 0.350, 1.296> <0.016, 0.416, 1.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.096, 0.230, 1.332> <0.096, 0.157, 1.338> <0.074, 0.054, 1.329> <0.092, -0.013, 1.350> 
		<0.115, 0.234, 1.337> <0.116, 0.161, 1.343> <0.080, 0.030, 1.336> <0.099, -0.038, 1.357> 
		<0.142, 0.232, 1.352> <0.145, 0.159, 1.361> <0.143, 0.064, 1.373> <0.146, -0.009, 1.384> 
		<0.154, 0.233, 1.369> <0.157, 0.161, 1.378> <0.159, 0.065, 1.394> <0.161, -0.007, 1.405> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.444, 1.347> <0.139, 0.380, 1.350> <0.151, 0.296, 1.361> <0.154, 0.233, 1.369> 
		<0.162, 0.438, 1.371> <0.161, 0.374, 1.374> <0.165, 0.298, 1.380> <0.168, 0.235, 1.388> 
		<0.199, 0.412, 1.400> <0.193, 0.361, 1.403> <0.181, 0.292, 1.419> <0.177, 0.241, 1.422> 
		<0.199, 0.410, 1.433> <0.193, 0.359, 1.436> <0.180, 0.292, 1.444> <0.176, 0.241, 1.446> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.444, 1.347> <0.162, 0.438, 1.371> <0.199, 0.412, 1.400> <0.199, 0.410, 1.433> 
		<0.140, 0.469, 1.346> <0.162, 0.463, 1.370> <0.201, 0.424, 1.400> <0.201, 0.422, 1.433> 
		<0.154, 0.501, 1.352> <0.178, 0.479, 1.367> <0.202, 0.440, 1.399> <0.201, 0.438, 1.435> 
		<0.155, 0.525, 1.357> <0.178, 0.503, 1.373> <0.203, 0.452, 1.401> <0.202, 0.451, 1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.444, 1.347> <0.140, 0.469, 1.346> <0.154, 0.501, 1.352> <0.155, 0.525, 1.357> 
		<0.127, 0.447, 1.333> <0.127, 0.472, 1.332> <0.137, 0.516, 1.341> <0.138, 0.540, 1.347> 
		<0.105, 0.445, 1.317> <0.103, 0.484, 1.320> <0.107, 0.524, 1.348> <0.105, 0.561, 1.362> 
		<0.087, 0.441, 1.310> <0.085, 0.480, 1.313> <0.082, 0.526, 1.345> <0.080, 0.563, 1.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.087, 0.441, 1.310> <0.085, 0.480, 1.313> <0.082, 0.526, 1.345> <0.080, 0.563, 1.358> 
		<0.066, 0.436, 1.301> <0.065, 0.475, 1.304> <0.062, 0.527, 1.341> <0.060, 0.564, 1.355> 
		<0.039, 0.415, 1.294> <0.041, 0.453, 1.295> <0.046, 0.501, 1.323> <0.043, 0.536, 1.338> 
		<0.016, 0.416, 1.297> <0.019, 0.453, 1.298> <0.026, 0.500, 1.322> <0.023, 0.535, 1.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.080, 0.563, 1.358> <0.105, 0.561, 1.362> <0.138, 0.540, 1.347> <0.155, 0.525, 1.357> 
		<0.079, 0.591, 1.369> <0.104, 0.589, 1.373> <0.139, 0.581, 1.356> <0.156, 0.566, 1.367> 
		<0.075, 0.641, 1.366> <0.096, 0.645, 1.367> <0.127, 0.634, 1.368> <0.148, 0.630, 1.367> 
		<0.076, 0.659, 1.391> <0.097, 0.662, 1.392> <0.125, 0.662, 1.399> <0.146, 0.658, 1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.674, 1.519> <0.010, 0.674, 1.519> <0.061, 0.679, 1.521> <0.087, 0.678, 1.519> 
		<0.008, 0.660, 1.522> <0.017, 0.660, 1.522> <0.059, 0.652, 1.561> <0.085, 0.651, 1.559> 
		<0.010, 0.567, 1.533> <0.029, 0.565, 1.533> <0.044, 0.579, 1.570> <0.063, 0.578, 1.571> 
		<0.012, 0.523, 1.546> <0.031, 0.521, 1.545> <0.046, 0.532, 1.578> <0.064, 0.531, 1.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, -0.033, 1.545> <0.023, 0.036, 1.562> <0.003, 0.140, 1.573> <0.006, 0.216, 1.579> 
		<0.031, -0.027, 1.547> <0.055, 0.043, 1.564> <0.030, 0.146, 1.575> <0.032, 0.221, 1.581> 
		<0.072, -0.018, 1.550> <0.055, 0.058, 1.562> <0.059, 0.169, 1.556> <0.058, 0.248, 1.557> 
		<0.104, -0.011, 1.552> <0.086, 0.065, 1.564> <0.085, 0.173, 1.549> <0.083, 0.252, 1.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 0.241, 1.446> <0.176, 0.241, 1.474> <0.171, 0.231, 1.516> <0.152, 0.233, 1.538> 
		<0.180, 0.292, 1.444> <0.180, 0.292, 1.472> <0.170, 0.290, 1.521> <0.151, 0.292, 1.542> 
		<0.193, 0.359, 1.436> <0.193, 0.356, 1.473> <0.164, 0.365, 1.509> <0.140, 0.371, 1.537> 
		<0.199, 0.410, 1.433> <0.199, 0.407, 1.471> <0.164, 0.424, 1.513> <0.140, 0.430, 1.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 0.241, 1.446> <0.177, 0.241, 1.422> <0.168, 0.235, 1.388> <0.154, 0.233, 1.369> 
		<0.171, 0.167, 1.449> <0.171, 0.167, 1.425> <0.171, 0.163, 1.398> <0.157, 0.161, 1.378> 
		<0.170, 0.068, 1.450> <0.172, 0.068, 1.436> <0.167, 0.066, 1.406> <0.159, 0.065, 1.394> 
		<0.167, -0.006, 1.452> <0.170, -0.006, 1.438> <0.170, -0.006, 1.416> <0.161, -0.007, 1.405> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 0.241, 1.446> <0.171, 0.167, 1.449> <0.170, 0.068, 1.450> <0.167, -0.006, 1.452> 
		<0.176, 0.241, 1.474> <0.170, 0.167, 1.478> <0.167, 0.068, 1.468> <0.164, -0.006, 1.470> 
		<0.171, 0.231, 1.516> <0.171, 0.159, 1.511> <0.156, 0.066, 1.502> <0.154, -0.006, 1.494> 
		<0.152, 0.233, 1.538> <0.152, 0.161, 1.532> <0.146, 0.065, 1.518> <0.144, -0.007, 1.510> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 0.252, 1.550> <0.104, 0.254, 1.544> <0.137, 0.235, 1.554> <0.152, 0.233, 1.538> 
		<0.085, 0.173, 1.549> <0.106, 0.175, 1.543> <0.138, 0.163, 1.548> <0.152, 0.161, 1.532> 
		<0.086, 0.065, 1.564> <0.090, 0.048, 1.562> <0.137, 0.064, 1.533> <0.146, 0.065, 1.518> 
		<0.104, -0.011, 1.552> <0.107, -0.028, 1.550> <0.134, -0.008, 1.525> <0.144, -0.007, 1.510> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 0.252, 1.550> <0.058, 0.248, 1.557> <0.032, 0.221, 1.581> <0.006, 0.216, 1.579> 
		<0.082, 0.307, 1.550> <0.056, 0.304, 1.558> <0.034, 0.289, 1.586> <0.008, 0.284, 1.584> 
		<0.098, 0.381, 1.551> <0.074, 0.383, 1.559> <0.037, 0.377, 1.586> <0.011, 0.375, 1.590> 
		<0.095, 0.436, 1.557> <0.070, 0.438, 1.565> <0.038, 0.445, 1.579> <0.013, 0.443, 1.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 0.252, 1.550> <0.082, 0.307, 1.550> <0.098, 0.381, 1.551> <0.095, 0.436, 1.557> 
		<0.104, 0.254, 1.544> <0.103, 0.309, 1.545> <0.112, 0.379, 1.547> <0.108, 0.434, 1.552> 
		<0.137, 0.235, 1.554> <0.137, 0.294, 1.558> <0.131, 0.373, 1.548> <0.131, 0.432, 1.552> 
		<0.152, 0.233, 1.538> <0.151, 0.292, 1.542> <0.140, 0.371, 1.537> <0.140, 0.430, 1.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.430, 1.541> <0.131, 0.432, 1.552> <0.108, 0.434, 1.552> <0.095, 0.436, 1.557> 
		<0.140, 0.457, 1.542> <0.130, 0.459, 1.553> <0.106, 0.465, 1.556> <0.092, 0.466, 1.560> 
		<0.151, 0.491, 1.558> <0.133, 0.501, 1.576> <0.093, 0.500, 1.585> <0.065, 0.501, 1.583> 
		<0.152, 0.517, 1.554> <0.134, 0.527, 1.572> <0.092, 0.530, 1.580> <0.064, 0.531, 1.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.430, 1.541> <0.140, 0.457, 1.542> <0.151, 0.491, 1.558> <0.152, 0.517, 1.554> 
		<0.164, 0.424, 1.513> <0.164, 0.451, 1.514> <0.179, 0.474, 1.529> <0.180, 0.501, 1.525> 
		<0.199, 0.407, 1.471> <0.201, 0.419, 1.470> <0.201, 0.437, 1.478> <0.202, 0.449, 1.480> 
		<0.199, 0.410, 1.433> <0.201, 0.422, 1.433> <0.201, 0.438, 1.435> <0.202, 0.451, 1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.436, 1.557> <0.070, 0.438, 1.565> <0.038, 0.445, 1.579> <0.013, 0.443, 1.582> 
		<0.092, 0.466, 1.560> <0.068, 0.469, 1.568> <0.039, 0.471, 1.576> <0.013, 0.469, 1.579> 
		<0.065, 0.501, 1.583> <0.047, 0.502, 1.582> <0.032, 0.495, 1.552> <0.014, 0.497, 1.552> 
		<0.064, 0.531, 1.579> <0.046, 0.532, 1.578> <0.031, 0.521, 1.545> <0.012, 0.523, 1.546> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 0.531, 1.579> <0.063, 0.578, 1.571> <0.085, 0.651, 1.559> <0.087, 0.678, 1.519> 
		<0.092, 0.530, 1.580> <0.090, 0.577, 1.573> <0.102, 0.649, 1.558> <0.105, 0.676, 1.518> 
		<0.134, 0.527, 1.572> <0.135, 0.573, 1.566> <0.128, 0.638, 1.549> <0.127, 0.669, 1.515> 
		<0.152, 0.517, 1.554> <0.152, 0.563, 1.548> <0.145, 0.633, 1.544> <0.143, 0.664, 1.510> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.202, 0.451, 1.436> <0.202, 0.449, 1.480> <0.180, 0.501, 1.525> <0.152, 0.517, 1.554> 
		<0.204, 0.466, 1.439> <0.203, 0.464, 1.482> <0.198, 0.511, 1.509> <0.170, 0.528, 1.538> 
		<0.209, 0.488, 1.455> <0.209, 0.503, 1.471> <0.200, 0.530, 1.515> <0.197, 0.551, 1.521> 
		<0.207, 0.501, 1.447> <0.207, 0.517, 1.463> <0.216, 0.532, 1.494> <0.212, 0.553, 1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.202, 0.451, 1.436> <0.204, 0.466, 1.439> <0.209, 0.488, 1.455> <0.207, 0.501, 1.447> 
		<0.203, 0.452, 1.401> <0.204, 0.467, 1.403> <0.207, 0.507, 1.444> <0.205, 0.520, 1.436> 
		<0.178, 0.503, 1.373> <0.189, 0.507, 1.381> <0.182, 0.525, 1.396> <0.195, 0.518, 1.394> 
		<0.155, 0.525, 1.357> <0.165, 0.529, 1.366> <0.178, 0.545, 1.387> <0.190, 0.538, 1.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.087, 0.678, 1.519> <0.089, 0.700, 1.487> <0.078, 0.682, 1.423> <0.076, 0.659, 1.391> 
		<0.105, 0.676, 1.518> <0.107, 0.698, 1.486> <0.098, 0.685, 1.424> <0.097, 0.662, 1.392> 
		<0.127, 0.669, 1.515> <0.126, 0.692, 1.490> <0.123, 0.684, 1.424> <0.125, 0.662, 1.399> 
		<0.143, 0.664, 1.510> <0.142, 0.686, 1.485> <0.144, 0.681, 1.423> <0.146, 0.658, 1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.517, 1.554> <0.152, 0.563, 1.548> <0.145, 0.633, 1.544> <0.143, 0.664, 1.510> 
		<0.170, 0.528, 1.538> <0.171, 0.573, 1.532> <0.157, 0.629, 1.540> <0.156, 0.660, 1.506> 
		<0.197, 0.551, 1.521> <0.192, 0.579, 1.530> <0.181, 0.636, 1.522> <0.174, 0.654, 1.499> 
		<0.212, 0.553, 1.500> <0.207, 0.581, 1.508> <0.189, 0.629, 1.513> <0.182, 0.647, 1.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.143, 0.664, 1.510> <0.142, 0.686, 1.485> <0.144, 0.681, 1.423> <0.146, 0.658, 1.398> 
		<0.156, 0.660, 1.506> <0.155, 0.682, 1.481> <0.155, 0.679, 1.422> <0.157, 0.657, 1.397> 
		<0.174, 0.654, 1.499> <0.167, 0.672, 1.476> <0.171, 0.675, 1.412> <0.173, 0.652, 1.391> 
		<0.182, 0.647, 1.490> <0.175, 0.666, 1.466> <0.176, 0.665, 1.408> <0.177, 0.643, 1.386> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.658, 1.398> <0.148, 0.630, 1.367> <0.156, 0.566, 1.367> <0.155, 0.525, 1.357> 
		<0.157, 0.657, 1.397> <0.159, 0.628, 1.366> <0.167, 0.570, 1.375> <0.165, 0.529, 1.366> 
		<0.173, 0.652, 1.391> <0.175, 0.629, 1.369> <0.172, 0.573, 1.375> <0.178, 0.545, 1.387> 
		<0.177, 0.643, 1.386> <0.179, 0.620, 1.364> <0.184, 0.566, 1.373> <0.190, 0.538, 1.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.177, 0.643, 1.386> <0.188, 0.622, 1.376> <0.193, 0.584, 1.371> <0.192, 0.565, 1.354> 
		<0.176, 0.665, 1.408> <0.186, 0.644, 1.398> <0.201, 0.601, 1.381> <0.199, 0.581, 1.365> 
		<0.175, 0.666, 1.466> <0.193, 0.649, 1.444> <0.218, 0.617, 1.416> <0.220, 0.594, 1.390> 
		<0.182, 0.647, 1.490> <0.201, 0.630, 1.468> <0.227, 0.609, 1.433> <0.229, 0.587, 1.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.177, 0.643, 1.386> <0.179, 0.620, 1.364> <0.184, 0.566, 1.373> <0.190, 0.538, 1.385> 
		<0.188, 0.622, 1.376> <0.190, 0.599, 1.354> <0.197, 0.559, 1.371> <0.203, 0.531, 1.383> 
		<0.193, 0.584, 1.371> <0.187, 0.570, 1.361> <0.191, 0.527, 1.350> <0.195, 0.514, 1.362> 
		<0.192, 0.565, 1.354> <0.185, 0.551, 1.344> <0.188, 0.518, 1.340> <0.192, 0.504, 1.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.190, 0.538, 1.385> <0.195, 0.518, 1.394> <0.205, 0.520, 1.436> <0.207, 0.501, 1.447> 
		<0.203, 0.531, 1.383> <0.207, 0.511, 1.392> <0.205, 0.513, 1.429> <0.208, 0.494, 1.440> 
		<0.195, 0.514, 1.362> <0.200, 0.495, 1.376> <0.207, 0.479, 1.411> <0.217, 0.485, 1.432> 
		<0.192, 0.504, 1.351> <0.197, 0.485, 1.366> <0.205, 0.473, 1.403> <0.216, 0.479, 1.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.207, 0.501, 1.447> <0.207, 0.517, 1.463> <0.216, 0.532, 1.494> <0.212, 0.553, 1.500> 
		<0.208, 0.494, 1.440> <0.207, 0.510, 1.456> <0.229, 0.534, 1.477> <0.225, 0.555, 1.483> 
		<0.217, 0.485, 1.432> <0.225, 0.489, 1.446> <0.235, 0.525, 1.459> <0.237, 0.542, 1.456> 
		<0.216, 0.479, 1.424> <0.223, 0.484, 1.438> <0.235, 0.513, 1.442> <0.237, 0.529, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.212, 0.553, 1.500> <0.207, 0.581, 1.508> <0.189, 0.629, 1.513> <0.182, 0.647, 1.490> 
		<0.225, 0.555, 1.483> <0.220, 0.583, 1.492> <0.208, 0.612, 1.490> <0.201, 0.630, 1.468> 
		<0.237, 0.542, 1.456> <0.240, 0.561, 1.453> <0.236, 0.602, 1.449> <0.227, 0.609, 1.433> 
		<0.237, 0.529, 1.439> <0.239, 0.549, 1.436> <0.238, 0.580, 1.424> <0.229, 0.587, 1.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, 0.565, 1.354> <0.189, 0.528, 1.323> <0.172, 0.491, 1.272> <0.162, 0.464, 1.233> 
		<0.199, 0.581, 1.365> <0.196, 0.545, 1.334> <0.185, 0.498, 1.269> <0.175, 0.471, 1.231> 
		<0.220, 0.594, 1.390> <0.224, 0.550, 1.339> <0.205, 0.487, 1.292> <0.194, 0.445, 1.240> 
		<0.229, 0.587, 1.407> <0.233, 0.543, 1.356> <0.212, 0.474, 1.297> <0.201, 0.432, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, 0.565, 1.354> <0.185, 0.551, 1.344> <0.188, 0.518, 1.340> <0.192, 0.504, 1.351> 
		<0.189, 0.528, 1.323> <0.182, 0.514, 1.313> <0.181, 0.488, 1.310> <0.185, 0.474, 1.322> 
		<0.172, 0.491, 1.272> <0.156, 0.483, 1.275> <0.167, 0.448, 1.282> <0.169, 0.432, 1.287> 
		<0.162, 0.464, 1.233> <0.147, 0.455, 1.236> <0.155, 0.425, 1.248> <0.157, 0.408, 1.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, 0.504, 1.351> <0.197, 0.485, 1.366> <0.205, 0.473, 1.403> <0.216, 0.479, 1.424> 
		<0.185, 0.474, 1.322> <0.190, 0.456, 1.336> <0.197, 0.438, 1.354> <0.207, 0.444, 1.375> 
		<0.169, 0.432, 1.287> <0.170, 0.419, 1.290> <0.173, 0.405, 1.309> <0.185, 0.399, 1.311> 
		<0.157, 0.408, 1.253> <0.159, 0.396, 1.256> <0.163, 0.375, 1.257> <0.174, 0.368, 1.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.216, 0.479, 1.424> <0.223, 0.484, 1.438> <0.235, 0.513, 1.442> <0.237, 0.529, 1.439> 
		<0.207, 0.444, 1.375> <0.215, 0.449, 1.389> <0.233, 0.472, 1.385> <0.235, 0.489, 1.383> 
		<0.185, 0.399, 1.311> <0.193, 0.394, 1.313> <0.211, 0.413, 1.321> <0.215, 0.422, 1.319> 
		<0.174, 0.368, 1.260> <0.183, 0.363, 1.262> <0.201, 0.373, 1.265> <0.205, 0.382, 1.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.237, 0.529, 1.439> <0.239, 0.549, 1.436> <0.238, 0.580, 1.424> <0.229, 0.587, 1.407> 
		<0.235, 0.489, 1.383> <0.237, 0.508, 1.380> <0.242, 0.536, 1.373> <0.233, 0.543, 1.356> 
		<0.215, 0.422, 1.319> <0.221, 0.436, 1.316> <0.219, 0.461, 1.302> <0.212, 0.474, 1.297> 
		<0.205, 0.382, 1.263> <0.211, 0.397, 1.259> <0.208, 0.419, 1.249> <0.201, 0.432, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.416, 1.145> <0.153, 0.418, 1.140> <0.166, 0.394, 1.149> <0.173, 0.381, 1.150> 
		<0.146, 0.430, 1.171> <0.160, 0.433, 1.167> <0.175, 0.409, 1.177> <0.181, 0.397, 1.178> 
		<0.156, 0.446, 1.209> <0.169, 0.453, 1.206> <0.188, 0.425, 1.214> <0.195, 0.412, 1.219> 
		<0.162, 0.464, 1.233> <0.175, 0.471, 1.231> <0.194, 0.445, 1.240> <0.201, 0.432, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.416, 1.145> <0.146, 0.430, 1.171> <0.156, 0.446, 1.209> <0.162, 0.464, 1.233> 
		<0.126, 0.414, 1.149> <0.133, 0.428, 1.176> <0.141, 0.438, 1.212> <0.147, 0.455, 1.236> 
		<0.127, 0.388, 1.162> <0.135, 0.398, 1.189> <0.148, 0.409, 1.224> <0.155, 0.425, 1.248> 
		<0.130, 0.374, 1.164> <0.138, 0.384, 1.190> <0.150, 0.392, 1.229> <0.157, 0.408, 1.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.130, 0.374, 1.164> <0.138, 0.384, 1.190> <0.150, 0.392, 1.229> <0.157, 0.408, 1.253> 
		<0.134, 0.355, 1.165> <0.142, 0.366, 1.192> <0.151, 0.379, 1.233> <0.159, 0.396, 1.256> 
		<0.145, 0.330, 1.156> <0.149, 0.345, 1.188> <0.157, 0.357, 1.227> <0.163, 0.375, 1.257> 
		<0.160, 0.318, 1.153> <0.164, 0.333, 1.185> <0.168, 0.350, 1.230> <0.174, 0.368, 1.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.318, 1.153> <0.164, 0.333, 1.185> <0.168, 0.350, 1.230> <0.174, 0.368, 1.260> 
		<0.167, 0.313, 1.152> <0.171, 0.328, 1.184> <0.177, 0.346, 1.231> <0.183, 0.363, 1.262> 
		<0.183, 0.322, 1.154> <0.189, 0.338, 1.187> <0.195, 0.352, 1.235> <0.201, 0.373, 1.265> 
		<0.185, 0.331, 1.153> <0.191, 0.346, 1.186> <0.199, 0.362, 1.233> <0.205, 0.382, 1.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.331, 1.153> <0.191, 0.346, 1.186> <0.199, 0.362, 1.233> <0.205, 0.382, 1.263> 
		<0.188, 0.346, 1.152> <0.194, 0.361, 1.185> <0.205, 0.376, 1.229> <0.211, 0.397, 1.259> 
		<0.180, 0.367, 1.151> <0.189, 0.383, 1.180> <0.202, 0.398, 1.224> <0.208, 0.419, 1.249> 
		<0.173, 0.381, 1.150> <0.181, 0.397, 1.178> <0.195, 0.412, 1.219> <0.201, 0.432, 1.244> 
	}
	texture {textM_Cuerpo}
} 


#declare M_Casco = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.009, 0.707, 1.543> <0.008, 0.730, 1.544> <0.006, 0.763, 1.558> <0.006, 0.785, 1.548> 
		<0.032, 0.708, 1.542> <0.031, 0.731, 1.543> <0.029, 0.763, 1.558> <0.028, 0.784, 1.548> 
		<0.060, 0.699, 1.529> <0.058, 0.724, 1.528> <0.058, 0.760, 1.540> <0.055, 0.782, 1.529> 
		<0.079, 0.697, 1.517> <0.078, 0.722, 1.517> <0.076, 0.758, 1.526> <0.074, 0.780, 1.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.009, 0.707, 1.543> <-0.012, 0.706, 1.544> <-0.038, 0.693, 1.535> <-0.056, 0.690, 1.525> 
		<0.008, 0.730, 1.544> <-0.013, 0.729, 1.546> <-0.041, 0.722, 1.532> <-0.059, 0.719, 1.522> 
		<0.006, 0.763, 1.558> <-0.017, 0.764, 1.558> <-0.046, 0.762, 1.542> <-0.065, 0.760, 1.529> 
		<0.006, 0.785, 1.548> <-0.018, 0.786, 1.548> <-0.046, 0.787, 1.529> <-0.065, 0.785, 1.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.697, 1.517> <0.078, 0.722, 1.517> <0.076, 0.758, 1.526> <0.074, 0.780, 1.516> 
		<0.088, 0.696, 1.512> <0.086, 0.721, 1.512> <0.087, 0.756, 1.518> <0.085, 0.779, 1.507> 
		<0.092, 0.697, 1.498> <0.093, 0.720, 1.495> <0.094, 0.766, 1.498> <0.095, 0.785, 1.484> 
		<0.097, 0.697, 1.490> <0.098, 0.720, 1.486> <0.098, 0.755, 1.491> <0.100, 0.774, 1.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.051, 0.772, 1.317> <0.040, 0.777, 1.312> <0.009, 0.782, 1.317> <0.008, 0.782, 1.317> 
		<0.051, 0.787, 1.331> <0.040, 0.793, 1.326> <0.009, 0.783, 1.318> <0.008, 0.783, 1.318> 
		<0.051, 0.813, 1.346> <0.039, 0.825, 1.343> <0.024, 0.844, 1.342> <0.006, 0.844, 1.342> 
		<0.053, 0.823, 1.364> <0.041, 0.835, 1.361> <0.024, 0.858, 1.365> <0.006, 0.858, 1.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.051, 0.772, 1.317> <0.051, 0.787, 1.331> <0.051, 0.813, 1.346> <0.053, 0.823, 1.364> 
		<0.061, 0.767, 1.322> <0.062, 0.782, 1.336> <0.065, 0.801, 1.348> <0.067, 0.810, 1.367> 
		<0.065, 0.756, 1.337> <0.071, 0.764, 1.348> <0.078, 0.790, 1.363> <0.082, 0.793, 1.377> 
		<0.071, 0.752, 1.347> <0.077, 0.760, 1.357> <0.086, 0.775, 1.369> <0.091, 0.778, 1.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.097, 0.697, 1.490> <0.097, 0.697, 1.490> <0.097, 0.697, 1.490> <0.097, 0.697, 1.490> 
		<0.100, 0.697, 1.483> <0.101, 0.720, 1.479> <0.101, 0.720, 1.479> <0.098, 0.720, 1.486> 
		<0.105, 0.697, 1.474> <0.104, 0.720, 1.477> <0.106, 0.736, 1.480> <0.098, 0.755, 1.491> 
		<0.106, 0.698, 1.466> <0.104, 0.721, 1.470> <0.107, 0.755, 1.466> <0.100, 0.774, 1.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.071, 0.752, 1.347> <0.071, 0.752, 1.347> <0.071, 0.752, 1.347> <0.071, 0.752, 1.347> 
		<0.081, 0.746, 1.361> <0.087, 0.754, 1.372> <0.087, 0.754, 1.372> <0.077, 0.760, 1.357> 
		<0.099, 0.746, 1.381> <0.095, 0.759, 1.377> <0.093, 0.764, 1.373> <0.086, 0.775, 1.369> 
		<0.104, 0.738, 1.396> <0.100, 0.750, 1.392> <0.098, 0.767, 1.387> <0.091, 0.778, 1.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.877, 1.464> <0.026, 0.877, 1.464> <0.050, 0.857, 1.453> <0.064, 0.842, 1.449> 
		<0.005, 0.863, 1.499> <0.026, 0.863, 1.499> <0.054, 0.850, 1.479> <0.068, 0.835, 1.475> 
		<0.005, 0.819, 1.532> <0.027, 0.818, 1.532> <0.053, 0.807, 1.517> <0.071, 0.805, 1.504> 
		<0.006, 0.785, 1.548> <0.028, 0.784, 1.548> <0.055, 0.782, 1.529> <0.074, 0.780, 1.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.877, 1.464> <0.026, 0.877, 1.464> <0.050, 0.857, 1.453> <0.064, 0.842, 1.449> 
		<0.005, 0.888, 1.436> <0.026, 0.889, 1.436> <0.047, 0.865, 1.428> <0.061, 0.849, 1.424> 
		<0.005, 0.875, 1.390> <0.023, 0.875, 1.390> <0.043, 0.847, 1.384> <0.056, 0.835, 1.387> 
		<0.006, 0.858, 1.365> <0.024, 0.858, 1.365> <0.041, 0.835, 1.361> <0.053, 0.823, 1.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.877, 1.464> <0.005, 0.863, 1.499> <0.005, 0.819, 1.532> <0.006, 0.785, 1.548> 
		<-0.017, 0.876, 1.464> <-0.017, 0.862, 1.499> <-0.019, 0.819, 1.532> <-0.018, 0.786, 1.548> 
		<-0.041, 0.855, 1.453> <-0.045, 0.849, 1.478> <-0.046, 0.810, 1.517> <-0.046, 0.787, 1.529> 
		<-0.056, 0.840, 1.449> <-0.059, 0.834, 1.474> <-0.065, 0.808, 1.504> <-0.065, 0.785, 1.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.877, 1.464> <-0.017, 0.876, 1.464> <-0.041, 0.855, 1.453> <-0.056, 0.840, 1.449> 
		<0.005, 0.888, 1.436> <-0.017, 0.888, 1.436> <-0.038, 0.861, 1.428> <-0.053, 0.846, 1.424> 
		<0.005, 0.875, 1.390> <-0.013, 0.875, 1.390> <-0.034, 0.846, 1.385> <-0.048, 0.834, 1.388> 
		<0.006, 0.858, 1.365> <-0.013, 0.858, 1.365> <-0.031, 0.835, 1.361> <-0.045, 0.823, 1.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 0.842, 1.449> <0.081, 0.825, 1.445> <0.097, 0.796, 1.439> <0.103, 0.773, 1.436> 
		<0.068, 0.835, 1.475> <0.084, 0.818, 1.471> <0.098, 0.796, 1.451> <0.104, 0.772, 1.449> 
		<0.071, 0.805, 1.504> <0.082, 0.804, 1.496> <0.096, 0.796, 1.477> <0.101, 0.784, 1.470> 
		<0.074, 0.780, 1.516> <0.085, 0.779, 1.507> <0.095, 0.785, 1.484> <0.100, 0.774, 1.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 0.842, 1.449> <0.061, 0.849, 1.424> <0.056, 0.835, 1.387> <0.053, 0.823, 1.364> 
		<0.081, 0.825, 1.445> <0.077, 0.832, 1.419> <0.069, 0.823, 1.390> <0.067, 0.810, 1.367> 
		<0.097, 0.796, 1.439> <0.095, 0.797, 1.422> <0.088, 0.797, 1.392> <0.082, 0.793, 1.377> 
		<0.103, 0.773, 1.436> <0.101, 0.774, 1.420> <0.097, 0.782, 1.398> <0.091, 0.778, 1.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 0.773, 1.436> <0.108, 0.752, 1.434> <0.102, 0.723, 1.434> <0.101, 0.702, 1.434> 
		<0.104, 0.772, 1.449> <0.109, 0.752, 1.446> <0.102, 0.718, 1.443> <0.102, 0.697, 1.442> 
		<0.101, 0.784, 1.470> <0.108, 0.765, 1.459> <0.105, 0.722, 1.460> <0.107, 0.699, 1.456> 
		<0.100, 0.774, 1.478> <0.107, 0.755, 1.466> <0.104, 0.721, 1.470> <0.106, 0.698, 1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 0.773, 1.436> <0.101, 0.774, 1.420> <0.097, 0.782, 1.398> <0.091, 0.778, 1.383> 
		<0.108, 0.752, 1.434> <0.107, 0.753, 1.417> <0.103, 0.771, 1.402> <0.098, 0.767, 1.387> 
		<0.102, 0.723, 1.434> <0.101, 0.731, 1.421> <0.105, 0.742, 1.405> <0.100, 0.750, 1.392> 
		<0.101, 0.702, 1.434> <0.101, 0.709, 1.420> <0.108, 0.730, 1.409> <0.104, 0.738, 1.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.008, 0.782, 1.317> <0.007, 0.781, 1.317> <-0.028, 0.781, 1.312> <-0.041, 0.778, 1.317> 
		<0.008, 0.783, 1.318> <0.008, 0.782, 1.317> <-0.029, 0.795, 1.326> <-0.042, 0.791, 1.331> 
		<0.006, 0.844, 1.342> <-0.012, 0.844, 1.342> <-0.029, 0.827, 1.344> <-0.043, 0.815, 1.346> 
		<0.006, 0.858, 1.365> <-0.013, 0.858, 1.365> <-0.031, 0.835, 1.361> <-0.045, 0.823, 1.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, 0.690, 1.525> <-0.068, 0.688, 1.518> <-0.076, 0.691, 1.500> <-0.083, 0.692, 1.489> 
		<-0.059, 0.719, 1.522> <-0.070, 0.717, 1.515> <-0.079, 0.716, 1.497> <-0.086, 0.717, 1.485> 
		<-0.065, 0.760, 1.529> <-0.077, 0.758, 1.520> <-0.088, 0.766, 1.498> <-0.091, 0.753, 1.491> 
		<-0.065, 0.785, 1.516> <-0.077, 0.784, 1.507> <-0.091, 0.787, 1.484> <-0.094, 0.774, 1.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 0.778, 1.317> <-0.054, 0.775, 1.322> <-0.064, 0.767, 1.338> <-0.071, 0.761, 1.349> 
		<-0.042, 0.791, 1.331> <-0.055, 0.788, 1.336> <-0.067, 0.772, 1.349> <-0.074, 0.766, 1.359> 
		<-0.043, 0.815, 1.346> <-0.057, 0.802, 1.349> <-0.071, 0.792, 1.366> <-0.080, 0.777, 1.371> 
		<-0.045, 0.823, 1.364> <-0.059, 0.811, 1.367> <-0.074, 0.794, 1.377> <-0.083, 0.778, 1.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.692, 1.489> <-0.083, 0.692, 1.489> <-0.083, 0.692, 1.489> <-0.083, 0.692, 1.489> 
		<-0.086, 0.717, 1.485> <-0.090, 0.718, 1.480> <-0.090, 0.718, 1.480> <-0.087, 0.693, 1.483> 
		<-0.091, 0.753, 1.491> <-0.097, 0.733, 1.480> <-0.090, 0.718, 1.477> <-0.089, 0.695, 1.474> 
		<-0.094, 0.774, 1.478> <-0.100, 0.754, 1.467> <-0.092, 0.720, 1.471> <-0.091, 0.697, 1.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.071, 0.761, 1.349> <-0.071, 0.761, 1.349> <-0.071, 0.761, 1.349> <-0.071, 0.761, 1.349> 
		<-0.074, 0.766, 1.359> <-0.083, 0.760, 1.372> <-0.083, 0.760, 1.372> <-0.080, 0.754, 1.362> 
		<-0.080, 0.777, 1.371> <-0.086, 0.766, 1.375> <-0.087, 0.759, 1.378> <-0.090, 0.746, 1.382> 
		<-0.083, 0.778, 1.383> <-0.089, 0.767, 1.387> <-0.091, 0.749, 1.392> <-0.095, 0.737, 1.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, 0.840, 1.449> <-0.059, 0.834, 1.474> <-0.065, 0.808, 1.504> <-0.065, 0.785, 1.516> 
		<-0.072, 0.823, 1.445> <-0.075, 0.817, 1.470> <-0.077, 0.807, 1.495> <-0.077, 0.784, 1.507> 
		<-0.088, 0.795, 1.439> <-0.089, 0.795, 1.452> <-0.092, 0.797, 1.478> <-0.091, 0.787, 1.484> 
		<-0.095, 0.773, 1.436> <-0.096, 0.772, 1.448> <-0.096, 0.784, 1.471> <-0.094, 0.774, 1.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, 0.840, 1.449> <-0.053, 0.846, 1.424> <-0.048, 0.834, 1.388> <-0.045, 0.823, 1.364> 
		<-0.072, 0.823, 1.445> <-0.069, 0.829, 1.420> <-0.061, 0.822, 1.390> <-0.059, 0.811, 1.367> 
		<-0.088, 0.795, 1.439> <-0.086, 0.796, 1.423> <-0.078, 0.796, 1.393> <-0.074, 0.794, 1.377> 
		<-0.095, 0.773, 1.436> <-0.093, 0.774, 1.420> <-0.087, 0.780, 1.398> <-0.083, 0.778, 1.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.095, 0.773, 1.436> <-0.096, 0.772, 1.448> <-0.096, 0.784, 1.471> <-0.094, 0.774, 1.478> 
		<-0.101, 0.754, 1.434> <-0.102, 0.754, 1.446> <-0.101, 0.764, 1.460> <-0.100, 0.754, 1.467> 
		<-0.097, 0.727, 1.433> <-0.096, 0.721, 1.443> <-0.095, 0.723, 1.460> <-0.092, 0.720, 1.471> 
		<-0.098, 0.707, 1.431> <-0.097, 0.701, 1.441> <-0.094, 0.699, 1.457> <-0.091, 0.697, 1.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.095, 0.773, 1.436> <-0.093, 0.774, 1.420> <-0.087, 0.780, 1.398> <-0.083, 0.778, 1.383> 
		<-0.101, 0.754, 1.434> <-0.099, 0.755, 1.417> <-0.094, 0.769, 1.402> <-0.089, 0.767, 1.387> 
		<-0.097, 0.727, 1.433> <-0.098, 0.734, 1.420> <-0.095, 0.742, 1.403> <-0.091, 0.749, 1.392> 
		<-0.098, 0.707, 1.431> <-0.099, 0.714, 1.419> <-0.099, 0.730, 1.407> <-0.095, 0.737, 1.396> 
	}
	texture {textM_Casco}
}


#declare M_Bufanda = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 0.649, 1.384> <0.077, 0.654, 1.387> <0.093, 0.663, 1.397> <0.104, 0.672, 1.400> 
		<0.069, 0.661, 1.377> <0.082, 0.667, 1.380> <0.097, 0.667, 1.398> <0.108, 0.676, 1.401> 
		<0.081, 0.678, 1.370> <0.095, 0.679, 1.373> <0.107, 0.684, 1.382> <0.111, 0.684, 1.397> 
		<0.081, 0.690, 1.360> <0.095, 0.691, 1.364> <0.109, 0.690, 1.383> <0.112, 0.690, 1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 0.649, 1.384> <0.069, 0.661, 1.377> <0.081, 0.678, 1.370> <0.081, 0.690, 1.360> 
		<0.046, 0.642, 1.380> <0.052, 0.654, 1.373> <0.059, 0.677, 1.364> <0.059, 0.689, 1.355> 
		<0.022, 0.629, 1.376> <0.023, 0.645, 1.375> <0.029, 0.668, 1.381> <0.029, 0.682, 1.373> 
		<0.003, 0.631, 1.377> <0.004, 0.646, 1.376> <0.006, 0.669, 1.380> <0.005, 0.683, 1.372> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.631, 1.377> <0.004, 0.646, 1.376> <0.006, 0.669, 1.380> <0.005, 0.683, 1.372> 
		<-0.016, 0.632, 1.378> <-0.015, 0.648, 1.376> <-0.010, 0.669, 1.379> <-0.010, 0.683, 1.372> 
		<-0.037, 0.651, 1.382> <-0.033, 0.661, 1.372> <-0.029, 0.679, 1.360> <-0.027, 0.691, 1.351> 
		<-0.054, 0.658, 1.388> <-0.050, 0.669, 1.378> <-0.043, 0.682, 1.365> <-0.041, 0.694, 1.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.054, 0.658, 1.388> <-0.050, 0.669, 1.378> <-0.043, 0.682, 1.365> <-0.041, 0.694, 1.356> 
		<-0.069, 0.665, 1.394> <-0.066, 0.676, 1.384> <-0.066, 0.686, 1.373> <-0.065, 0.698, 1.364> 
		<-0.090, 0.667, 1.410> <-0.095, 0.672, 1.413> <-0.095, 0.696, 1.385> <-0.095, 0.703, 1.387> 
		<-0.102, 0.678, 1.416> <-0.108, 0.683, 1.418> <-0.104, 0.695, 1.408> <-0.104, 0.703, 1.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 0.723, 1.340> <-0.044, 0.714, 1.345> <-0.040, 0.702, 1.350> <-0.041, 0.694, 1.356> 
		<-0.034, 0.724, 1.330> <-0.033, 0.715, 1.335> <-0.026, 0.699, 1.345> <-0.027, 0.691, 1.351> 
		<-0.012, 0.721, 1.331> <-0.011, 0.710, 1.343> <-0.010, 0.698, 1.364> <-0.010, 0.683, 1.372> 
		<0.003, 0.720, 1.329> <0.004, 0.709, 1.342> <0.005, 0.698, 1.364> <0.005, 0.683, 1.372> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 0.723, 1.340> <-0.067, 0.720, 1.360> <-0.081, 0.715, 1.400> <-0.100, 0.709, 1.423> 
		<-0.044, 0.714, 1.345> <-0.066, 0.711, 1.365> <-0.084, 0.714, 1.404> <-0.103, 0.708, 1.426> 
		<-0.040, 0.702, 1.350> <-0.064, 0.706, 1.358> <-0.094, 0.707, 1.388> <-0.104, 0.707, 1.411> 
		<-0.041, 0.694, 1.356> <-0.065, 0.698, 1.364> <-0.095, 0.703, 1.387> <-0.104, 0.703, 1.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.720, 1.329> <0.004, 0.709, 1.342> <0.005, 0.698, 1.364> <0.005, 0.683, 1.372> 
		<0.021, 0.719, 1.328> <0.022, 0.708, 1.341> <0.029, 0.697, 1.365> <0.029, 0.682, 1.373> 
		<0.045, 0.716, 1.332> <0.051, 0.709, 1.340> <0.059, 0.698, 1.347> <0.059, 0.689, 1.355> 
		<0.063, 0.715, 1.333> <0.069, 0.707, 1.341> <0.081, 0.700, 1.353> <0.081, 0.690, 1.360> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.715, 1.333> <0.069, 0.707, 1.341> <0.081, 0.700, 1.353> <0.081, 0.690, 1.360> 
		<0.079, 0.712, 1.355> <0.084, 0.704, 1.363> <0.095, 0.701, 1.356> <0.095, 0.691, 1.364> 
		<0.099, 0.712, 1.385> <0.102, 0.711, 1.389> <0.110, 0.694, 1.384> <0.109, 0.690, 1.383> 
		<0.115, 0.704, 1.406> <0.118, 0.703, 1.409> <0.114, 0.694, 1.398> <0.112, 0.690, 1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.709, 1.423> <-0.093, 0.705, 1.437> <-0.079, 0.703, 1.454> <-0.076, 0.698, 1.469> 
		<-0.103, 0.708, 1.426> <-0.096, 0.705, 1.440> <-0.078, 0.702, 1.459> <-0.075, 0.697, 1.474> 
		<-0.104, 0.707, 1.411> <-0.111, 0.707, 1.430> <-0.100, 0.696, 1.462> <-0.085, 0.694, 1.475> 
		<-0.104, 0.703, 1.410> <-0.111, 0.702, 1.429> <-0.104, 0.694, 1.462> <-0.089, 0.692, 1.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.104, 0.703, 1.410> <-0.111, 0.702, 1.429> <-0.104, 0.694, 1.462> <-0.089, 0.692, 1.475> 
		<-0.104, 0.695, 1.408> <-0.112, 0.695, 1.427> <-0.107, 0.692, 1.462> <-0.092, 0.690, 1.475> 
		<-0.108, 0.683, 1.418> <-0.106, 0.686, 1.434> <-0.100, 0.684, 1.457> <-0.096, 0.688, 1.472> 
		<-0.102, 0.678, 1.416> <-0.101, 0.681, 1.432> <-0.100, 0.683, 1.454> <-0.097, 0.687, 1.469> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 0.698, 1.469> <-0.044, 0.697, 1.484> <-0.001, 0.700, 1.503> <0.030, 0.695, 1.518> 
		<-0.075, 0.697, 1.474> <-0.043, 0.696, 1.488> <0.002, 0.699, 1.505> <0.033, 0.695, 1.520> 
		<-0.085, 0.694, 1.475> <-0.058, 0.690, 1.498> <-0.010, 0.691, 1.505> <0.023, 0.689, 1.518> 
		<-0.089, 0.692, 1.475> <-0.062, 0.688, 1.498> <-0.012, 0.687, 1.504> <0.020, 0.686, 1.517> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.089, 0.692, 1.475> <-0.062, 0.688, 1.498> <-0.012, 0.687, 1.504> <0.020, 0.686, 1.517> 
		<-0.092, 0.690, 1.475> <-0.065, 0.687, 1.498> <-0.015, 0.683, 1.503> <0.018, 0.681, 1.516> 
		<-0.096, 0.688, 1.472> <-0.063, 0.683, 1.485> <-0.014, 0.671, 1.500> <0.019, 0.670, 1.513> 
		<-0.097, 0.687, 1.469> <-0.064, 0.682, 1.482> <-0.019, 0.671, 1.498> <0.014, 0.670, 1.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.115, 0.704, 1.406> <0.118, 0.703, 1.409> <0.114, 0.694, 1.398> <0.112, 0.690, 1.398> 
		<0.111, 0.702, 1.415> <0.114, 0.701, 1.419> <0.119, 0.694, 1.416> <0.117, 0.690, 1.416> 
		<0.103, 0.701, 1.426> <0.102, 0.699, 1.433> <0.116, 0.695, 1.437> <0.116, 0.690, 1.443> 
		<0.101, 0.698, 1.436> <0.100, 0.696, 1.443> <0.106, 0.694, 1.453> <0.106, 0.690, 1.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.112, 0.690, 1.398> <0.111, 0.684, 1.397> <0.108, 0.676, 1.401> <0.104, 0.672, 1.400> 
		<0.117, 0.690, 1.416> <0.115, 0.684, 1.415> <0.107, 0.677, 1.421> <0.103, 0.674, 1.420> 
		<0.116, 0.690, 1.443> <0.116, 0.688, 1.447> <0.100, 0.673, 1.451> <0.100, 0.672, 1.447> 
		<0.106, 0.690, 1.459> <0.106, 0.687, 1.463> <0.101, 0.679, 1.470> <0.101, 0.677, 1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.101, 0.698, 1.436> <0.100, 0.696, 1.443> <0.106, 0.694, 1.453> <0.106, 0.690, 1.459> 
		<0.081, 0.697, 1.465> <0.080, 0.695, 1.472> <0.090, 0.693, 1.480> <0.090, 0.689, 1.486> 
		<0.055, 0.699, 1.505> <0.053, 0.698, 1.507> <0.050, 0.689, 1.507> <0.050, 0.686, 1.507> 
		<0.034, 0.695, 1.533> <0.032, 0.694, 1.535> <0.030, 0.688, 1.531> <0.030, 0.685, 1.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.690, 1.459> <0.106, 0.687, 1.463> <0.101, 0.679, 1.470> <0.101, 0.677, 1.466> 
		<0.090, 0.689, 1.486> <0.090, 0.686, 1.490> <0.081, 0.676, 1.491> <0.081, 0.675, 1.486> 
		<0.050, 0.686, 1.507> <0.051, 0.681, 1.507> <0.051, 0.667, 1.517> <0.055, 0.667, 1.514> 
		<0.030, 0.685, 1.531> <0.030, 0.680, 1.531> <0.031, 0.670, 1.536> <0.034, 0.669, 1.533> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.015, 0.688, 1.708> <-0.012, 0.690, 1.741> <0.007, 0.697, 1.781> <0.010, 0.696, 1.814> 
		<-0.015, 0.699, 1.710> <-0.012, 0.701, 1.742> <0.005, 0.708, 1.785> <0.009, 0.707, 1.817> 
		<-0.014, 0.715, 1.718> <-0.009, 0.725, 1.749> <-0.002, 0.732, 1.815> <0.006, 0.724, 1.845> 
		<-0.012, 0.718, 1.728> <-0.007, 0.728, 1.759> <-0.004, 0.734, 1.804> <0.004, 0.727, 1.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.015, 0.688, 1.708> <-0.015, 0.699, 1.710> <-0.014, 0.715, 1.718> <-0.012, 0.718, 1.728> 
		<-0.018, 0.687, 1.674> <-0.018, 0.698, 1.675> <-0.011, 0.713, 1.677> <-0.009, 0.716, 1.687> 
		<-0.017, 0.687, 1.627> <-0.017, 0.695, 1.626> <-0.003, 0.720, 1.624> <-0.003, 0.721, 1.632> 
		<-0.009, 0.686, 1.594> <-0.009, 0.694, 1.593> <-0.002, 0.710, 1.584> <-0.002, 0.712, 1.592> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.015, 0.688, 1.708> <-0.016, 0.678, 1.707> <-0.017, 0.659, 1.712> <-0.014, 0.655, 1.721> 
		<-0.012, 0.690, 1.741> <-0.013, 0.679, 1.740> <-0.009, 0.649, 1.736> <-0.006, 0.645, 1.745> 
		<0.007, 0.697, 1.781> <0.009, 0.683, 1.776> <0.013, 0.642, 1.796> <0.009, 0.636, 1.782> 
		<0.010, 0.696, 1.814> <0.013, 0.682, 1.809> <0.019, 0.653, 1.820> <0.016, 0.646, 1.806> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.015, 0.688, 1.708> <-0.018, 0.687, 1.674> <-0.017, 0.687, 1.627> <-0.009, 0.686, 1.594> 
		<-0.016, 0.678, 1.707> <-0.019, 0.676, 1.673> <-0.017, 0.676, 1.628> <-0.009, 0.676, 1.595> 
		<-0.017, 0.659, 1.712> <-0.013, 0.658, 1.675> <-0.003, 0.646, 1.625> <-0.002, 0.655, 1.590> 
		<-0.014, 0.655, 1.721> <-0.010, 0.654, 1.685> <-0.003, 0.644, 1.635> <-0.002, 0.653, 1.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.034, 0.695, 1.533> <0.032, 0.694, 1.535> <0.030, 0.688, 1.531> <0.030, 0.685, 1.531> 
		<0.023, 0.700, 1.550> <0.021, 0.700, 1.553> <0.016, 0.688, 1.548> <0.016, 0.685, 1.548> 
		<0.009, 0.707, 1.574> <0.009, 0.705, 1.566> <-0.003, 0.694, 1.571> <-0.003, 0.686, 1.572> 
		<-0.002, 0.712, 1.592> <-0.002, 0.710, 1.584> <-0.009, 0.694, 1.593> <-0.009, 0.686, 1.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 0.685, 1.531> <0.030, 0.680, 1.531> <0.031, 0.670, 1.536> <0.034, 0.669, 1.533> 
		<0.016, 0.685, 1.548> <0.016, 0.680, 1.548> <0.020, 0.665, 1.556> <0.023, 0.664, 1.553> 
		<-0.003, 0.686, 1.572> <-0.003, 0.676, 1.574> <0.009, 0.660, 1.570> <0.009, 0.658, 1.580> 
		<-0.009, 0.686, 1.594> <-0.009, 0.676, 1.595> <-0.002, 0.655, 1.590> <-0.002, 0.653, 1.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.727, 1.834> <0.006, 0.724, 1.845> <0.009, 0.707, 1.817> <0.010, 0.696, 1.814> 
		<0.002, 0.725, 1.870> <0.004, 0.722, 1.881> <0.013, 0.705, 1.857> <0.015, 0.695, 1.853> 
		<-0.002, 0.718, 1.918> <0.003, 0.706, 1.915> <0.014, 0.695, 1.907> <0.015, 0.682, 1.906> 
		<-0.003, 0.720, 1.953> <0.002, 0.708, 1.951> <0.011, 0.693, 1.946> <0.012, 0.680, 1.945> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.010, 0.696, 1.814> <0.013, 0.682, 1.809> <0.019, 0.653, 1.820> <0.016, 0.646, 1.806> 
		<0.015, 0.695, 1.853> <0.017, 0.681, 1.848> <0.015, 0.650, 1.862> <0.012, 0.644, 1.849> 
		<0.015, 0.682, 1.906> <0.016, 0.669, 1.905> <0.011, 0.649, 1.905> <0.008, 0.637, 1.905> 
		<0.012, 0.680, 1.945> <0.013, 0.667, 1.944> <0.005, 0.650, 1.947> <0.002, 0.638, 1.947> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, 0.720, 1.953> <0.002, 0.708, 1.951> <0.011, 0.693, 1.946> <0.012, 0.680, 1.945> 
		<-0.003, 0.722, 1.980> <0.001, 0.710, 1.977> <0.009, 0.692, 1.977> <0.010, 0.679, 1.976> 
		<-0.007, 0.745, 2.014> <-0.009, 0.729, 2.016> <-0.004, 0.706, 2.016> <-0.007, 0.690, 2.016> 
		<-0.001, 0.742, 2.040> <-0.003, 0.726, 2.042> <-0.005, 0.704, 2.047> <-0.008, 0.687, 2.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.638, 1.947> <-0.002, 0.638, 1.976> <-0.015, 0.653, 2.012> <-0.018, 0.652, 2.040> 
		<0.005, 0.650, 1.947> <0.001, 0.651, 1.975> <-0.012, 0.664, 2.014> <-0.015, 0.663, 2.042> 
		<0.013, 0.667, 1.944> <0.010, 0.666, 1.976> <-0.009, 0.679, 2.016> <-0.010, 0.676, 2.047> 
		<0.012, 0.680, 1.945> <0.010, 0.679, 1.976> <-0.007, 0.690, 2.016> <-0.008, 0.687, 2.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.742, 2.040> <-0.003, 0.726, 2.042> <-0.005, 0.704, 2.047> <-0.008, 0.687, 2.047> 
		<0.004, 0.739, 2.064> <0.002, 0.723, 2.066> <-0.005, 0.702, 2.072> <-0.008, 0.686, 2.072> 
		<0.030, 0.719, 2.087> <0.031, 0.710, 2.098> <0.011, 0.685, 2.101> <0.003, 0.674, 2.103> 
		<0.032, 0.703, 2.106> <0.033, 0.694, 2.117> <0.015, 0.679, 2.125> <0.007, 0.668, 2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 0.652, 2.040> <-0.020, 0.651, 2.063> <-0.022, 0.627, 2.093> <-0.015, 0.631, 2.116> 
		<-0.015, 0.663, 2.042> <-0.017, 0.662, 2.066> <-0.018, 0.630, 2.106> <-0.012, 0.634, 2.128> 
		<-0.010, 0.676, 2.047> <-0.010, 0.675, 2.072> <-0.004, 0.663, 2.104> <0.000, 0.657, 2.128> 
		<-0.008, 0.687, 2.047> <-0.008, 0.686, 2.072> <0.003, 0.674, 2.103> <0.007, 0.668, 2.126> 
	}
	texture {textM_Bufanda}
}



#declare M_Cara = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.018, 0.751, 1.343> <0.017, 0.751, 1.346> <0.017, 0.751, 1.355> <0.014, 0.751, 1.353> 
		<0.018, 0.740, 1.343> <0.017, 0.740, 1.346> <0.017, 0.737, 1.355> <0.014, 0.737, 1.353> 
		<0.028, 0.731, 1.343> <0.028, 0.728, 1.346> <0.029, 0.724, 1.352> <0.030, 0.723, 1.353> 
		<0.039, 0.731, 1.343> <0.039, 0.728, 1.346> <0.038, 0.724, 1.352> <0.039, 0.723, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.018, 0.751, 1.343> <0.018, 0.751, 1.343> <0.018, 0.751, 1.343> <0.018, 0.751, 1.343> 
		<0.018, 0.762, 1.343> <0.018, 0.751, 1.343> <0.018, 0.751, 1.343> <0.018, 0.740, 1.343> 
		<0.028, 0.772, 1.343> <0.028, 0.759, 1.343> <0.028, 0.743, 1.343> <0.028, 0.731, 1.343> 
		<0.039, 0.772, 1.343> <0.039, 0.759, 1.343> <0.039, 0.743, 1.343> <0.039, 0.731, 1.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.018, 0.751, 1.343> <0.018, 0.762, 1.343> <0.028, 0.772, 1.343> <0.039, 0.772, 1.343> 
		<0.017, 0.751, 1.346> <0.017, 0.762, 1.346> <0.028, 0.773, 1.346> <0.039, 0.773, 1.346> 
		<0.017, 0.751, 1.355> <0.017, 0.765, 1.355> <0.024, 0.776, 1.351> <0.037, 0.776, 1.351> 
		<0.014, 0.751, 1.353> <0.015, 0.765, 1.353> <0.026, 0.776, 1.353> <0.040, 0.776, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.751, 1.343> <0.059, 0.751, 1.343> <0.059, 0.751, 1.343> <0.059, 0.751, 1.343> 
		<0.059, 0.740, 1.343> <0.059, 0.751, 1.343> <0.059, 0.751, 1.343> <0.059, 0.762, 1.343> 
		<0.050, 0.731, 1.343> <0.050, 0.743, 1.343> <0.050, 0.759, 1.343> <0.050, 0.772, 1.343> 
		<0.039, 0.731, 1.343> <0.039, 0.743, 1.343> <0.039, 0.759, 1.343> <0.039, 0.772, 1.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.751, 1.343> <0.061, 0.751, 1.346> <0.062, 0.751, 1.350> <0.063, 0.751, 1.353> 
		<0.059, 0.762, 1.343> <0.061, 0.762, 1.346> <0.062, 0.764, 1.350> <0.063, 0.764, 1.353> 
		<0.050, 0.772, 1.343> <0.050, 0.773, 1.346> <0.051, 0.776, 1.351> <0.053, 0.776, 1.353> 
		<0.039, 0.772, 1.343> <0.039, 0.773, 1.346> <0.037, 0.776, 1.351> <0.040, 0.776, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.751, 1.343> <0.059, 0.740, 1.343> <0.050, 0.731, 1.343> <0.039, 0.731, 1.343> 
		<0.061, 0.751, 1.346> <0.061, 0.740, 1.346> <0.050, 0.728, 1.346> <0.039, 0.728, 1.346> 
		<0.062, 0.751, 1.350> <0.062, 0.737, 1.350> <0.047, 0.724, 1.352> <0.038, 0.724, 1.352> 
		<0.063, 0.751, 1.353> <0.063, 0.737, 1.353> <0.048, 0.723, 1.353> <0.039, 0.723, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.751, 1.353> <0.065, 0.751, 1.357> <0.068, 0.751, 1.363> <0.070, 0.750, 1.367> 
		<0.063, 0.764, 1.353> <0.065, 0.764, 1.357> <0.068, 0.758, 1.364> <0.070, 0.757, 1.368> 
		<0.053, 0.776, 1.353> <0.060, 0.776, 1.360> <0.065, 0.768, 1.364> <0.069, 0.767, 1.372> 
		<0.040, 0.776, 1.353> <0.047, 0.776, 1.360> <0.064, 0.775, 1.361> <0.069, 0.773, 1.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.751, 1.353> <0.063, 0.737, 1.353> <0.048, 0.723, 1.353> <0.039, 0.723, 1.353> 
		<0.065, 0.751, 1.357> <0.065, 0.737, 1.357> <0.052, 0.722, 1.355> <0.043, 0.722, 1.355> 
		<0.068, 0.751, 1.363> <0.068, 0.742, 1.362> <0.062, 0.729, 1.356> <0.061, 0.720, 1.357> 
		<0.070, 0.750, 1.367> <0.069, 0.741, 1.366> <0.067, 0.729, 1.363> <0.066, 0.719, 1.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.750, 1.367> <0.075, 0.746, 1.384> <0.082, 0.740, 1.406> <0.088, 0.736, 1.422> 
		<0.070, 0.757, 1.368> <0.076, 0.753, 1.384> <0.081, 0.748, 1.404> <0.087, 0.744, 1.421> 
		<0.069, 0.767, 1.372> <0.078, 0.764, 1.387> <0.079, 0.767, 1.418> <0.084, 0.757, 1.431> 
		<0.069, 0.773, 1.369> <0.077, 0.770, 1.384> <0.077, 0.771, 1.411> <0.082, 0.761, 1.425> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.750, 1.367> <0.069, 0.741, 1.366> <0.067, 0.729, 1.363> <0.066, 0.719, 1.364> 
		<0.075, 0.746, 1.384> <0.075, 0.737, 1.383> <0.078, 0.727, 1.381> <0.077, 0.718, 1.382> 
		<0.082, 0.740, 1.406> <0.083, 0.734, 1.407> <0.083, 0.712, 1.419> <0.081, 0.710, 1.413> 
		<0.088, 0.736, 1.422> <0.089, 0.730, 1.423> <0.091, 0.718, 1.438> <0.089, 0.716, 1.432> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.776, 1.336> <-0.019, 0.775, 1.340> <-0.034, 0.772, 1.348> <-0.044, 0.775, 1.353> 
		<-0.007, 0.781, 1.337> <-0.019, 0.780, 1.342> <-0.037, 0.773, 1.350> <-0.048, 0.776, 1.354> 
		<-0.009, 0.785, 1.344> <-0.021, 0.785, 1.346> <-0.034, 0.785, 1.351> <-0.046, 0.784, 1.352> 
		<-0.007, 0.789, 1.347> <-0.019, 0.788, 1.349> <-0.035, 0.789, 1.351> <-0.047, 0.787, 1.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.776, 1.336> <-0.007, 0.781, 1.337> <-0.009, 0.785, 1.344> <-0.007, 0.789, 1.347> 
		<-0.005, 0.776, 1.335> <-0.005, 0.781, 1.336> <-0.008, 0.787, 1.346> <-0.006, 0.791, 1.349> 
		<-0.001, 0.776, 1.335> <-0.001, 0.781, 1.337> <-0.001, 0.786, 1.344> <-0.001, 0.790, 1.348> 
		<0.002, 0.776, 1.336> <0.001, 0.781, 1.338> <0.002, 0.786, 1.345> <0.001, 0.790, 1.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.776, 1.336> <-0.005, 0.776, 1.335> <-0.001, 0.776, 1.335> <0.002, 0.776, 1.336> 
		<-0.008, 0.768, 1.334> <-0.005, 0.768, 1.333> <-0.000, 0.769, 1.332> <0.003, 0.769, 1.333> 
		<-0.009, 0.758, 1.335> <-0.006, 0.758, 1.333> <0.001, 0.758, 1.331> <0.005, 0.758, 1.333> 
		<-0.009, 0.750, 1.335> <-0.006, 0.750, 1.333> <0.001, 0.751, 1.330> <0.005, 0.751, 1.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.776, 1.336> <-0.008, 0.768, 1.334> <-0.009, 0.758, 1.335> <-0.009, 0.750, 1.335> 
		<-0.019, 0.775, 1.340> <-0.019, 0.768, 1.338> <-0.014, 0.758, 1.339> <-0.014, 0.750, 1.339> 
		<-0.034, 0.772, 1.348> <-0.020, 0.772, 1.348> <-0.014, 0.764, 1.350> <-0.015, 0.751, 1.350> 
		<-0.044, 0.775, 1.353> <-0.031, 0.775, 1.353> <-0.020, 0.764, 1.353> <-0.020, 0.751, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, 0.750, 1.335> <-0.006, 0.750, 1.333> <0.001, 0.751, 1.330> <0.005, 0.751, 1.332> 
		<-0.009, 0.742, 1.335> <-0.006, 0.742, 1.333> <0.001, 0.743, 1.329> <0.005, 0.743, 1.331> 
		<-0.006, 0.732, 1.334> <-0.003, 0.732, 1.332> <-0.000, 0.732, 1.326> <0.003, 0.732, 1.327> 
		<-0.007, 0.724, 1.336> <-0.004, 0.724, 1.334> <-0.001, 0.725, 1.328> <0.002, 0.725, 1.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, 0.750, 1.335> <-0.009, 0.742, 1.335> <-0.006, 0.732, 1.334> <-0.007, 0.724, 1.336> 
		<-0.014, 0.750, 1.339> <-0.014, 0.743, 1.339> <-0.017, 0.731, 1.340> <-0.018, 0.724, 1.342> 
		<-0.015, 0.751, 1.350> <-0.015, 0.736, 1.350> <-0.029, 0.726, 1.349> <-0.039, 0.726, 1.349> 
		<-0.020, 0.751, 1.353> <-0.020, 0.737, 1.353> <-0.035, 0.723, 1.353> <-0.046, 0.723, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.014, 0.751, 1.353> <0.014, 0.737, 1.353> <0.030, 0.723, 1.353> <0.039, 0.723, 1.353> 
		<0.009, 0.751, 1.349> <0.009, 0.737, 1.348> <0.025, 0.726, 1.349> <0.034, 0.726, 1.349> 
		<0.010, 0.751, 1.336> <0.010, 0.743, 1.335> <0.015, 0.732, 1.331> <0.015, 0.724, 1.334> 
		<0.005, 0.751, 1.332> <0.005, 0.743, 1.331> <0.003, 0.732, 1.327> <0.002, 0.725, 1.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.014, 0.751, 1.353> <0.015, 0.765, 1.353> <0.026, 0.776, 1.353> <0.040, 0.776, 1.353> 
		<0.009, 0.751, 1.349> <0.009, 0.765, 1.349> <0.015, 0.772, 1.349> <0.029, 0.772, 1.349> 
		<0.010, 0.751, 1.336> <0.010, 0.759, 1.337> <0.014, 0.769, 1.337> <0.014, 0.776, 1.340> 
		<0.005, 0.751, 1.332> <0.005, 0.758, 1.333> <0.003, 0.769, 1.333> <0.002, 0.776, 1.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.007, 0.724, 1.336> <-0.004, 0.724, 1.334> <-0.001, 0.725, 1.328> <0.002, 0.725, 1.329> 
		<-0.007, 0.719, 1.337> <-0.004, 0.719, 1.336> <-0.001, 0.718, 1.330> <0.002, 0.718, 1.331> 
		<-0.010, 0.714, 1.343> <-0.006, 0.714, 1.342> <-0.002, 0.713, 1.340> <0.003, 0.713, 1.341> 
		<-0.012, 0.709, 1.346> <-0.008, 0.709, 1.345> <-0.001, 0.708, 1.345> <0.003, 0.708, 1.346> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.007, 0.724, 1.336> <-0.007, 0.719, 1.337> <-0.010, 0.714, 1.343> <-0.012, 0.709, 1.346> 
		<-0.018, 0.724, 1.342> <-0.018, 0.718, 1.343> <-0.021, 0.713, 1.346> <-0.022, 0.708, 1.349> 
		<-0.039, 0.726, 1.349> <-0.042, 0.725, 1.351> <-0.036, 0.711, 1.352> <-0.036, 0.706, 1.354> 
		<-0.046, 0.723, 1.353> <-0.049, 0.722, 1.355> <-0.045, 0.711, 1.358> <-0.045, 0.706, 1.360> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 0.699, 1.437> <0.086, 0.700, 1.442> <0.087, 0.711, 1.434> <0.089, 0.716, 1.432> 
		<0.077, 0.696, 1.418> <0.079, 0.696, 1.423> <0.080, 0.705, 1.414> <0.081, 0.710, 1.413> 
		<0.075, 0.703, 1.389> <0.075, 0.708, 1.387> <0.077, 0.713, 1.383> <0.077, 0.718, 1.382> 
		<0.065, 0.705, 1.372> <0.065, 0.709, 1.369> <0.065, 0.715, 1.365> <0.066, 0.719, 1.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 0.705, 1.372> <0.065, 0.709, 1.369> <0.065, 0.715, 1.365> <0.066, 0.719, 1.364> 
		<0.061, 0.706, 1.364> <0.061, 0.710, 1.362> <0.061, 0.715, 1.357> <0.061, 0.720, 1.357> 
		<0.047, 0.705, 1.363> <0.047, 0.710, 1.361> <0.045, 0.720, 1.357> <0.043, 0.722, 1.355> 
		<0.039, 0.706, 1.360> <0.039, 0.711, 1.358> <0.041, 0.722, 1.355> <0.039, 0.723, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.039, 0.706, 1.360> <0.039, 0.711, 1.358> <0.041, 0.722, 1.355> <0.039, 0.723, 1.353> 
		<0.029, 0.706, 1.355> <0.029, 0.711, 1.353> <0.036, 0.724, 1.350> <0.034, 0.726, 1.349> 
		<0.014, 0.708, 1.349> <0.014, 0.712, 1.344> <0.014, 0.718, 1.336> <0.015, 0.724, 1.334> 
		<0.003, 0.708, 1.346> <0.003, 0.713, 1.341> <0.002, 0.718, 1.331> <0.002, 0.725, 1.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.078, 0.778, 1.360> <0.077, 0.780, 1.355> <0.070, 0.785, 1.354> <0.065, 0.786, 1.353> 
		<0.083, 0.772, 1.379> <0.082, 0.773, 1.374> <0.071, 0.781, 1.359> <0.066, 0.782, 1.358> 
		<0.081, 0.766, 1.406> <0.076, 0.776, 1.392> <0.077, 0.776, 1.382> <0.068, 0.779, 1.367> 
		<0.082, 0.761, 1.425> <0.077, 0.771, 1.411> <0.077, 0.770, 1.384> <0.069, 0.773, 1.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 0.786, 1.353> <0.058, 0.788, 1.351> <0.048, 0.788, 1.352> <0.041, 0.788, 1.351> 
		<0.066, 0.782, 1.358> <0.059, 0.784, 1.356> <0.048, 0.784, 1.352> <0.041, 0.784, 1.352> 
		<0.068, 0.779, 1.367> <0.063, 0.781, 1.359> <0.051, 0.777, 1.361> <0.043, 0.777, 1.354> 
		<0.069, 0.773, 1.369> <0.064, 0.775, 1.361> <0.047, 0.776, 1.360> <0.040, 0.776, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.041, 0.788, 1.351> <0.029, 0.789, 1.351> <0.013, 0.790, 1.349> <0.001, 0.790, 1.348> 
		<0.041, 0.784, 1.352> <0.029, 0.785, 1.351> <0.013, 0.785, 1.346> <0.002, 0.786, 1.345> 
		<0.043, 0.777, 1.354> <0.032, 0.773, 1.350> <0.013, 0.781, 1.342> <0.001, 0.781, 1.338> 
		<0.040, 0.776, 1.353> <0.029, 0.772, 1.349> <0.014, 0.776, 1.340> <0.002, 0.776, 1.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, 0.751, 1.343> <-0.023, 0.751, 1.346> <-0.023, 0.751, 1.354> <-0.020, 0.751, 1.353> 
		<-0.024, 0.740, 1.343> <-0.023, 0.740, 1.346> <-0.023, 0.737, 1.354> <-0.020, 0.737, 1.353> 
		<-0.033, 0.731, 1.343> <-0.034, 0.728, 1.346> <-0.034, 0.723, 1.351> <-0.035, 0.723, 1.353> 
		<-0.044, 0.731, 1.343> <-0.045, 0.728, 1.346> <-0.044, 0.723, 1.351> <-0.046, 0.723, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, 0.751, 1.343> <-0.024, 0.751, 1.343> <-0.024, 0.751, 1.343> <-0.024, 0.751, 1.343> 
		<-0.024, 0.762, 1.343> <-0.024, 0.751, 1.343> <-0.024, 0.751, 1.343> <-0.024, 0.740, 1.343> 
		<-0.033, 0.772, 1.343> <-0.033, 0.759, 1.343> <-0.033, 0.743, 1.343> <-0.033, 0.731, 1.343> 
		<-0.044, 0.772, 1.343> <-0.044, 0.759, 1.343> <-0.044, 0.743, 1.343> <-0.044, 0.731, 1.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, 0.751, 1.343> <-0.024, 0.762, 1.343> <-0.033, 0.772, 1.343> <-0.044, 0.772, 1.343> 
		<-0.023, 0.751, 1.346> <-0.023, 0.762, 1.346> <-0.033, 0.773, 1.346> <-0.044, 0.773, 1.346> 
		<-0.023, 0.751, 1.354> <-0.022, 0.765, 1.354> <-0.029, 0.775, 1.351> <-0.042, 0.775, 1.351> 
		<-0.020, 0.751, 1.353> <-0.020, 0.764, 1.353> <-0.031, 0.775, 1.353> <-0.044, 0.775, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.065, 0.751, 1.343> <-0.065, 0.751, 1.343> <-0.065, 0.751, 1.343> <-0.065, 0.751, 1.343> 
		<-0.065, 0.740, 1.343> <-0.065, 0.751, 1.343> <-0.065, 0.751, 1.343> <-0.065, 0.762, 1.343> 
		<-0.056, 0.731, 1.343> <-0.056, 0.743, 1.343> <-0.056, 0.759, 1.343> <-0.056, 0.772, 1.343> 
		<-0.044, 0.731, 1.343> <-0.044, 0.743, 1.343> <-0.044, 0.759, 1.343> <-0.044, 0.772, 1.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.065, 0.751, 1.343> <-0.066, 0.751, 1.346> <-0.068, 0.751, 1.350> <-0.069, 0.751, 1.353> 
		<-0.065, 0.762, 1.343> <-0.066, 0.762, 1.346> <-0.068, 0.764, 1.350> <-0.069, 0.764, 1.353> 
		<-0.056, 0.772, 1.343> <-0.056, 0.773, 1.346> <-0.055, 0.775, 1.351> <-0.058, 0.775, 1.353> 
		<-0.044, 0.772, 1.343> <-0.044, 0.773, 1.346> <-0.042, 0.775, 1.351> <-0.044, 0.775, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.065, 0.751, 1.343> <-0.065, 0.740, 1.343> <-0.056, 0.731, 1.343> <-0.044, 0.731, 1.343> 
		<-0.066, 0.751, 1.346> <-0.066, 0.740, 1.346> <-0.056, 0.728, 1.346> <-0.045, 0.728, 1.346> 
		<-0.068, 0.751, 1.350> <-0.068, 0.737, 1.350> <-0.054, 0.723, 1.351> <-0.044, 0.723, 1.351> 
		<-0.069, 0.751, 1.353> <-0.069, 0.737, 1.353> <-0.056, 0.723, 1.353> <-0.046, 0.723, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.069, 0.751, 1.353> <-0.070, 0.751, 1.357> <-0.071, 0.753, 1.363> <-0.073, 0.752, 1.367> 
		<-0.069, 0.764, 1.353> <-0.070, 0.765, 1.357> <-0.071, 0.758, 1.361> <-0.073, 0.757, 1.365> 
		<-0.058, 0.775, 1.353> <-0.064, 0.774, 1.358> <-0.064, 0.766, 1.359> <-0.070, 0.764, 1.364> 
		<-0.044, 0.775, 1.353> <-0.051, 0.774, 1.358> <-0.063, 0.771, 1.357> <-0.068, 0.769, 1.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.069, 0.751, 1.353> <-0.069, 0.737, 1.353> <-0.056, 0.723, 1.353> <-0.046, 0.723, 1.353> 
		<-0.070, 0.751, 1.357> <-0.071, 0.737, 1.357> <-0.060, 0.722, 1.358> <-0.050, 0.722, 1.358> 
		<-0.071, 0.753, 1.363> <-0.072, 0.744, 1.367> <-0.065, 0.731, 1.368> <-0.065, 0.722, 1.371> 
		<-0.073, 0.752, 1.367> <-0.074, 0.743, 1.370> <-0.072, 0.732, 1.377> <-0.072, 0.723, 1.380> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.752, 1.367> <-0.078, 0.749, 1.376> <-0.087, 0.743, 1.387> <-0.092, 0.740, 1.396> 
		<-0.073, 0.757, 1.365> <-0.078, 0.754, 1.374> <-0.086, 0.748, 1.384> <-0.091, 0.745, 1.392> 
		<-0.070, 0.764, 1.364> <-0.077, 0.761, 1.370> <-0.085, 0.761, 1.386> <-0.090, 0.755, 1.393> 
		<-0.068, 0.769, 1.362> <-0.076, 0.766, 1.368> <-0.082, 0.765, 1.381> <-0.087, 0.759, 1.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.752, 1.367> <-0.074, 0.743, 1.370> <-0.072, 0.732, 1.377> <-0.072, 0.723, 1.380> 
		<-0.078, 0.749, 1.376> <-0.079, 0.740, 1.380> <-0.079, 0.732, 1.386> <-0.079, 0.723, 1.389> 
		<-0.087, 0.743, 1.387> <-0.087, 0.738, 1.391> <-0.091, 0.723, 1.412> <-0.088, 0.721, 1.410> 
		<-0.092, 0.740, 1.396> <-0.093, 0.734, 1.400> <-0.094, 0.726, 1.415> <-0.092, 0.725, 1.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 0.703, 1.433> <-0.102, 0.707, 1.439> <-0.093, 0.721, 1.416> <-0.092, 0.725, 1.413> 
		<-0.089, 0.695, 1.422> <-0.093, 0.699, 1.428> <-0.089, 0.718, 1.413> <-0.088, 0.721, 1.410> 
		<-0.080, 0.704, 1.398> <-0.081, 0.710, 1.397> <-0.079, 0.718, 1.391> <-0.079, 0.723, 1.389> 
		<-0.071, 0.705, 1.385> <-0.071, 0.710, 1.383> <-0.071, 0.718, 1.382> <-0.072, 0.723, 1.380> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.071, 0.705, 1.385> <-0.071, 0.710, 1.383> <-0.071, 0.718, 1.382> <-0.072, 0.723, 1.380> 
		<-0.064, 0.705, 1.376> <-0.065, 0.711, 1.375> <-0.065, 0.717, 1.373> <-0.065, 0.722, 1.371> 
		<-0.054, 0.705, 1.366> <-0.054, 0.710, 1.364> <-0.053, 0.720, 1.360> <-0.050, 0.722, 1.358> 
		<-0.045, 0.706, 1.360> <-0.045, 0.711, 1.358> <-0.049, 0.722, 1.355> <-0.046, 0.723, 1.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.082, 0.778, 1.381> <-0.077, 0.783, 1.373> <-0.072, 0.780, 1.358> <-0.064, 0.783, 1.351> 
		<-0.085, 0.775, 1.386> <-0.080, 0.780, 1.378> <-0.073, 0.776, 1.361> <-0.065, 0.778, 1.354> 
		<-0.085, 0.765, 1.386> <-0.081, 0.770, 1.379> <-0.074, 0.770, 1.366> <-0.067, 0.773, 1.359> 
		<-0.087, 0.759, 1.388> <-0.082, 0.765, 1.381> <-0.076, 0.766, 1.368> <-0.068, 0.769, 1.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.064, 0.783, 1.351> <-0.060, 0.784, 1.348> <-0.052, 0.787, 1.352> <-0.047, 0.787, 1.352> 
		<-0.065, 0.778, 1.354> <-0.061, 0.779, 1.351> <-0.051, 0.783, 1.352> <-0.046, 0.784, 1.352> 
		<-0.067, 0.773, 1.359> <-0.061, 0.775, 1.355> <-0.054, 0.775, 1.359> <-0.048, 0.776, 1.354> 
		<-0.068, 0.769, 1.362> <-0.063, 0.771, 1.357> <-0.051, 0.774, 1.358> <-0.044, 0.775, 1.353> 
	}
	texture {textM_Cara}
}                 
