// Persistence of Vision Ray Tracer Scene Description File
// File: fokkerDR.pov
// Vers: 3.1
// Desc: Fokker DR.I (Red Baron)
// Date: Septiembre 2001
// Auth: J. F. Tuduri

#include "colors.inc"
#include "fokkerDR_Partes.inc" 


// Alas,Aler_D,Aler_I,Borde_Cab,Cola_Fija,Cola_Movil,Timon,Cubiertas,
// Fuselaje,Helice,Llantas,Motor,Soportes,Trompa.
// M_Cuerpo,M_Bufanda,M_Cara,M_Casco

	                          
#declare HeliceMov =
pigment {
  radial
  frequency 1
  rotate x*90
  scale 1.25
  color_map {
    [ 0.0   rgb .2 transmit .5]
    [ 0.092  rgb .4 transmit .99]
    //[ 0.5  rgb 0 transmit 1]
    //[ 0.5  rgb 0 transmit 1]
    [ 0.92  rgb .4 transmit .99]
    [ 1.0  rgb .2 transmit .5]
  }
}
	                          
#ifndef (RotAlerones) #local RotAlerones = 0; #end //-70 . 30
#ifndef (RotCola) #local RotCola =0; #end
#ifndef (RotTimon) #local RotTimon =0; #end
#ifndef (RotHelice) #local RotHelice =45;  #end
#ifndef (EstHelice) #local EstHelice =1; #end
                  
#declare RedBaron = union {
                        object {Aler_D  translate <0,-1.3,-.9> rotate x*RotAlerones translate <0,1.3,.9>}
                        object {Aler_I  translate <0,-1.3,-.9> rotate x*RotAlerones translate <0,1.3,.9>}
                        object {Cola_Movil translate <0,-.423,-4.88> rotate x*RotCola translate <0,.423,4.88>}
                        object {Timon translate z*(-4.98) rotate y*RotTimon translate z*(4.98)}
                          
                        #if (EstHelice = 1)
                       
                        cylinder {<0,0,-.01>,<0,0,.01>,1.25 
                                texture {pigment { HeliceMov }}
                                texture {pigment { HeliceMov scale <-1,1,1>}}
                                rotate z*RotHelice
                                translate <0,.065,-.4> }
                        #else
                         object {Helice translate y*(-.065) rotate z*RotHelice translate y*.065}
                        #end
                        
                        object {Ametralladoras}
                        object {Alas}      
                        object {Fuselaje}
                        object {Borde_Cab}
                        object {Cola_Fija}
                        object {Cubiertas}
                        object {Llantas}
                        object {Motor}
                        object {Soportes}
                        object {Trompa}    
                      
                        object {M_Cuerpo}
                        object {M_Bufanda}
                        object {M_Cara}
                        object {M_Casco}   
                    rotate y*(90) translate y*1.5
                    }




