// Persistence of Vision Ray Tracer Scene Description File
// File: woodmap.pov
// Date: 04/28/2001
// Auth: Bob Franke
//  

//Render to 700 x 700
// I used -ft switch for a tga file

#version 3.1

#include "colors.inc"


global_settings{
  assumed_gamma 2.2
}

camera{
  location  <0.0, 0.0, -25.0>
  direction 12.5*z  
  right     4/4*x
  look_at   <0.0, 0.0,  0.0>
}


light_source{
  0*x 
  color White*2 
  translate <-10, 10, -10>
}


#declare P_WoodGrain7A =
pigment {
    wood
    turbulence <0.15, 0.08, 1000>*3
    octaves 4  
    lambda 2
    scale <0.15, .15, 1>
}

#declare P_WoodGrain7B =
pigment {
    bozo
    scale <0.01, 0.01, 100000>
}  

#declare woodMap=
  normal {   
    wood
    turbulence <0.15, 0.08, 1000>*3
    octaves 4  
    lambda 2
    scale <0.15, .15, 1>
}

#declare M_Wood7A = 
color_map { 
    [0.0, 0.1 color Silver*.15
              color Silver*.15]
    [0.1, 0.9 color Silver*.15
              color Silver*1.5]
    [0.9, 1.0 color Silver*1.5
              color Silver*.15]
}  

#declare M_Wood7B = 
color_map { 
    [0.0, 0.1 color rgbf <0.90, 0.91, 0.98, 0.00>
              color rgbf <0.90, 0.91, 0.98, 0.30>]
    [0.1, 1.0 color rgbf <0.90, 0.91, 0.98, 0.30>
              color rgbf <1.00, 1.00, 1.00, 1.00> ] 
}
         
#declare T_Wood7   =         
    texture { pigment { P_WoodGrain7A  color_map { M_Wood7A }}} 
    texture { pigment { P_WoodGrain7B  color_map { M_Wood7B }}}


#declare t_mader2=
texture{
 T_Wood7
}
texture{
 pigment{
  wrinkles
  turbulence 0.4
  color_map{
   [0.0 DarkTan filter 0.5]
   [0.2 Clear]
   [1.0 Clear]
  }
 }
 scale <300,300,300>
}
   
box{<-1,-1,0>,<1,1,.01>
  texture{t_mader2 rotate <90,0,0> scale <.25,1,2>   
    finish {crand .2}
    rotate<0,0,90>
  } 
} 

    



