//Fake Plasteek Trees 1.0
//Simple, non-realistic, fast rendering trees include file for POV-Ray 3.1
//Luis Valoyes / Bogota / Colombia
//www.luisvaloyes.uni.cc
//luisvaloyes@malditasea.zzn.com
//
//These trees are not realistic, but I hope you find them useful for you outdoor scenes, 
//if you need to focus on other objects and the trees will be just backdrop objects.
//I created these trees just because sometimes the trees are not the most important objects in the scene,
//but they make it to take hours to render. These are simply fast rendering trees.
//
//-----------------------------------------------------------------------------------------------------
//The textures used for the trees
//

#declare treewood = texture {pigment{granite color_map{
[0.0 rgb <124/255,83/255,41/255>] [0.7 rgb <106/255,83/255,61/255>] [0.88 rgb <72/255,54/255,37/255>]}
scale <.5,2,.5>} normal {granite .75 scale <.25,2,.25>}}

#declare leaves1 = texture {pigment {granite color_map {
[0.25 rgbf <0.21, 0.47, 0.2, 0.0>] [0.25 rgbf <1, 1, 1, 1.0>]
[0.4 rgbf <1,1,1,1>] [0.4 rgbf <0.1, 0.57, 0.2, 0.0>]
[0.6 rgbf <0.1, 0.57, 0.2, 0.0>] [0.6 rgbf <1, 1, 1, 1.0>]
[0.75 rgbf <1, 1, 1, 1.0>] [0.75 rgbf <0.21, 0.47, 0.2, 0.0>] }
scale <1,4,1>} normal { crackle 1.25 scale .25}}

#declare leaves2 = texture {pigment {granite color_map {
[0.25 rgbf <0.1, 0.57, 0.2, 0.0>] [0.25 rgbf <1, 1, 1, 1.0>]
[0.4 rgbf <1,1,1,1>] [0.4 rgbf <0.21, 0.47, 0.2, 0.0>]
[0.6 rgbf <0.21, 0.47, 0.2, 0.0>] [0.6 rgbf <1, 1, 1, 1.0>]
[0.75 rgbf <1, 1, 1, 1.0>] [0.75 rgbf <0.2, 0.76, 0.2, 0.0>] }
scale <4,1,4>} normal { crackle 1.25 scale .25}}

//-------------------------------------------------------------
//The tree's parts

#declare rama04 = cylinder {  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>  rotate <0.0000,0.0000,-35.0000>  translate <0.5000,6.4000,0.0000>}

#declare rama03 = cylinder {  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>  rotate <0.0000,0.0000,35.0000>  translate <-0.7000,6.4000,-0.0000>}

#declare rama02 = cylinder {  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>  rotate <-35.0000,0.0000,0.0000>  translate <0.1000,6.3000,-0.5000>}

#declare rama01 = cylinder {  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>  rotate <35.0000,0.0000,0.0000>  translate <-0.0000,6.2000,0.6000>}

#declare tronco01 = lathe {  cubic_spline  11.0
  <0.0000,0.0000> , <0.1510,0.0080> , <0.1030,0.1910> , <0.1030,0.3000> , <0.1030,0.4250> , 
  <0.0960,0.5580> , <0.0820,0.6830> , <0.0960,0.7910> , <0.0890,0.9000> , <0.0620,0.9910> , <0.0060,1.0080>
  scale <4.0000,10.0000,4.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,0.0000,0.0000>}

#declare hojas02 = lathe {  cubic_spline  16.0
  <0.0000,0.0000> , <0.4340,0.0000> , <0.7170,0.1080> , <0.7310,0.2500> , 
  <1.0340,0.4410> , <1.0960,0.6410> , <0.9580,0.8250> ,<0.8890,0.7830> , 
  <0.5650,0.8250> ,  <0.5030,0.7830> ,  <0.4480,0.8250> ,  <0.4820,0.9160> , 
  <0.3860,0.9660> , <0.2620,0.9410> ,  <0.0890,0.9660> , <0.0000,0.9910>
  scale <4.5000,5.5000,4.5000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,7.0000,-0.0000>}

#declare hojas01 = lathe {  cubic_spline 16.0
  <0.0000,0.0000> , <0.4340,0.0000> , <0.7170,0.1080> , <0.7310,0.2500> , 
  <1.0340,0.4410> , <1.0960,0.6410> , <0.9580,0.8250> , <0.8890,0.7830> , 
  <0.5650,0.8250> , <0.5030,0.7830> , <0.4480,0.8250> , <0.4820,0.9160> , 
  <0.3860,0.9660> , <0.2620,0.9410> , <0.0890,0.9660> , <0.0000,0.9910>
  scale <5.0000,6.0000,5.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,6.8000,0.0000>}

#declare hojas11 = lathe {  cubic_spline  16.0
  <0.0060,-0.5250> ,   <0.4680,-0.4670> ,   <0.8680,-0.6170> ,   <1.1030,-0.3170> , 
  <1.0130,0.0750> ,   <0.9170,0.3000> ,   <0.8620,0.2410> ,   <0.7030,0.3410> , 
  <0.5930,0.5330> ,   <0.4550,0.6080> ,   <0.4060,0.6910> ,   <0.4270,0.8000> , 
  <0.3240,0.8410> ,   <0.2620,0.9830> ,   <0.0890,0.9660> , <0.0000,0.9910>
  scale <3.5000,6.0000,3.5000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,7.0000,0.0000>}

#declare hojas12 = lathe {  cubic_spline  16.0
  <0.0060,-0.5250> ,   <0.4680,-0.4670> ,   <0.8680,-0.6170> ,   <1.1030,-0.3170> , 
  <1.0130,0.0750> ,   <0.9170,0.3000> ,   <0.8620,0.2410> ,   <0.7030,0.3410> , 
  <0.5930,0.5330> ,   <0.4550,0.6080> ,   <0.4060,0.6910> ,   <0.4270,0.8000> , 
  <0.3240,0.8410> ,   <0.2620,0.9830> ,   <0.0890,0.9660> ,   <0.0000,0.9910>
  scale <3.000,5.5000,3.000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,7.2000,0.0000>}

#declare hojas22 = lathe {  cubic_spline  16.0
  <0.0060,-0.8250> ,   <0.4000,-0.5500> ,   <0.5930,-0.1170> ,   <0.5240,0.0410> , 
  <0.4890,0.2080> ,   <0.4410,0.2580> ,   <0.5170,0.3750> ,   <0.5310,0.4910> , 
  <0.4620,0.5910> ,   <0.4060,0.6160> ,   <0.4620,0.7660> ,   <0.3650,0.9080> , 
  <0.2680,0.8830> ,   <0.2750,1.0000> ,   <0.1030,1.0000> ,   <0.0000,0.9910>
  scale <5.5000,5.5000,5.5000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.1000,0.0000>}

#declare hojas21 = lathe {  cubic_spline  16.0
  <0.0060,-0.8250> ,   <0.4000,-0.5500> ,   <0.5930,-0.1170> ,   <0.5240,0.0410> ,
  <0.4890,0.2080> ,   <0.4410,0.2580> ,   <0.5170,0.3750> ,   <0.5310,0.4910> ,
  <0.4620,0.5910> ,   <0.4060,0.6160> ,   <0.4620,0.7660> ,   <0.3650,0.9080> , 
  <0.2680,0.8830> ,   <0.2750,1.0000> ,   <0.1030,1.0000> ,   <0.0000,0.9910>
  scale <6.0000,6.0000,6.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.0000,0.0000>}

#declare hojas32 = lathe {  cubic_spline  16.0
  <0.0060,-0.5250> ,   <0.3310,-0.3670> ,   <0.7510,-0.2670> ,   <1.2480,-0.3500> , 
  <1.4500,-0.5340> ,   <1.5410,-0.3340> ,   <1.4550,-0.1250> ,   <1.4340,0.1330> , 
  <1.0820,0.2750> ,   <1.0270,0.4330> ,   <0.7860,0.5160> ,   <0.3650,0.5000> , 
  <0.2060,0.5830> ,   <0.6960,0.6080> ,   <0.6270,0.8160> ,   <0.0060,0.9330>
  scale <4.0000,2.2500,4.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,8.0000,0.0000>}

#declare hojas31 = lathe {  cubic_spline  16.0
  <0.0060,-0.5250> ,   <0.3310,-0.3670> ,   <0.7510,-0.2670> ,   <1.2480,-0.3500> , 
  <1.4500,-0.5340> ,   <1.5410,-0.3340> ,   <1.4550,-0.1250> ,   <1.4340,0.1330> , 
  <1.0820,0.2750> ,   <1.0270,0.4330> ,   <0.7860,0.5160> ,   <0.3650,0.5000> , 
  <0.2060,0.5830> ,   <0.6960,0.6080> ,   <0.6270,0.8160> ,   <0.0060,0.9330>
  scale <5.0000,3.0000,5.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,7.7000,0.0000>}

#declare hojas42 = lathe {  cubic_spline  16.0
  <0.0060,-0.6670> ,   <0.5240,-0.9170> ,   <1.0680,-0.9750> ,   <0.6550,-0.4170> , 
  <0.8680,-0.6420> ,   <0.5370,-0.0340> ,   <0.7240,-0.2750> ,   <0.3790,0.3660> , 
  <0.5510,0.1500> ,   <0.2620,0.6830> ,   <0.4340,0.5160> ,   <0.2340,0.8330> , 
  <0.1510,0.9160> ,   <0.0890,0.9750> ,   <0.0410,0.9910> ,   <0.0060,1.0000>
  scale <3.0000,8.0000,3.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,11.5000,-0.1000>}

#declare hojas41 = lathe {  cubic_spline  16.0
  <0.0060,-0.6670> ,   <0.5240,-0.9170> ,   <1.0680,-0.9750> ,   <0.6550,-0.4170> , 
  <0.8680,-0.6420> ,   <0.5370,-0.0340> ,   <0.7240,-0.2750> ,   <0.3790,0.3660> , 
  <0.5510,0.1500> ,   <0.2620,0.6830> ,   <0.4340,0.5160> ,   <0.2340,0.8330> , 
  <0.1510,0.9160> ,   <0.0890,0.9750> ,   <0.0410,0.9910> ,   <0.0060,1.0000>
  scale <6.0000,9.0000,6.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,11.9000,-0.1000>}

#declare hojas52 = lathe {  cubic_spline  16.0
  <0.0000,-0.9090> ,   <0.5240,-0.9170> ,   <1.2000,-0.7090> ,   <1.3510,-0.5250> , 
  <1.2960,-0.2500> ,   <1.0480,-0.1250> ,   <1.0890,0.0580> ,   <0.7860,0.1750> , 
  <0.8200,0.2910> ,   <0.4960,0.4250> ,   <0.5440,0.5660> ,   <0.3240,0.6660> , 
  <0.3650,0.7660> ,   <0.2410,0.9750> ,   <0.0410,0.9830> ,   <0.0130,0.8500>
  scale <4.5000,4.5000,4.5000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,10.9000,0.0000>}

#declare hojas51 = lathe {  cubic_spline  16.0
  <0.0000,-0.9090> ,   <0.5240,-0.9170> ,   <1.2000,-0.7090> ,   <1.3510,-0.5250> , 
  <1.2960,-0.2500> ,   <1.0480,-0.1250> ,   <1.0890,0.0580> ,   <0.7860,0.1750> , 
  <0.8200,0.2910> ,   <0.4960,0.4250> ,   <0.5440,0.5660> ,   <0.3240,0.6660> , 
  <0.3650,0.7660> ,   <0.2410,0.9750> ,   <0.0410,0.9830> ,   <0.0130,0.8500>
  scale <5.0000,5.0000,5.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,11.0000,0.0000>}

#declare hojas62 = lathe {  cubic_spline  16.0
  <0.0000,-0.9090> ,   <0.5240,-0.9170> ,   <1.0000,-0.8420> ,   <1.2000,-0.6500> , 
  <1.2130,-0.3250> ,   <1.0480,-0.1250> ,   <0.7650,0.0410> ,   <0.5720,-0.1250> , 
  <0.8410,0.2160> ,   <0.7310,0.4330> ,   <0.5100,0.5410> ,   <0.3240,0.3410> , 
  <0.4820,0.6160> ,   <0.3510,0.8250> ,   <0.2060,0.9080> ,   <0.0060,0.9580>
  scale <4.5000,4.5000,4.5000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,10.9000,0.0000>}

#declare hojas61 = lathe {  cubic_spline  16.0
  <0.0000,-0.9090> ,   <0.5240,-0.9170> ,   <1.0000,-0.8420> ,   <1.2000,-0.6500> , 
  <1.2130,-0.3250> ,   <1.0480,-0.1250> ,   <0.7650,0.0410> ,   <0.5720,-0.1250> , 
  <0.8410,0.2160> ,   <0.7310,0.4330> ,   <0.5100,0.5410> ,   <0.3240,0.3410> , 
  <0.4820,0.6160> ,   <0.3510,0.8250> ,   <0.2060,0.9080> ,   <0.0060,0.9580>
  scale <5.0000,5.0000,5.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,11.0000,0.0000>}

#declare hojas72 = lathe {  cubic_spline  16.0
  <0.0000,-0.9090> ,   <0.5370,-0.8420> ,   <1.3100,-0.9000> ,   <1.5510,-0.8000> , 
  <1.5440,-0.2500> ,   <1.2130,-0.0920> ,   <0.0130,-0.1840> ,   <0.1100,-0.0750> , 
  <1.0480,0.0000> ,   <0.9510,0.4080> ,   <0.7790,0.6410> ,   <0.0340,0.4830> , 
  <0.3170,0.6750> ,   <0.3310,0.7830> ,   <0.1650,0.8410> ,   <0.0060,1.1580>
  scale <1.0000,6.0000,1.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.0000,0.0000>}

#declare hojas71 = lathe {  cubic_spline  16.0
  <0.0000,-0.9090> ,   <0.5370,-0.8420> ,   <1.3100,-0.9000> ,   <1.5510,-0.8000> , 
  <1.5440,-0.2500> ,   <1.2130,-0.0920> ,   <0.0130,-0.1840> ,   <0.1100,-0.0750> , 
  <1.0480,0.0000> ,   <0.9510,0.4080> ,   <0.7790,0.6410> ,   <0.0340,0.4830> ,
  <0.3170,0.6750> ,   <0.3310,0.7830> ,   <0.1650,0.8410> ,   <0.0060,1.1580>
  scale <2.0000,7.0000,2.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.0000,0.0000>}

#declare hojas105 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <0.7500,1.2000,0.7500>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,12.4000,0.0000>}

#declare hojas104 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <1.2000,1.6000,1.2000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,11.1000,-0.1000>}

#declare hojas103 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <2.2000,1.6000,2.2000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.7000,0.0000>}

#declare hojas102 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <3.0000,1.6000,3.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,8.2000,0.0000>}

#declare hojas101 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <3.5000,2.0000,3.5000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,6.5000,0.0000>}

#declare conopino = cone { <0,14,0>,  0.0, <0,0,0>,4.0 open texture{leaves1 scale 5.5}}

#declare ramax08 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <0.0000,0.0000,-15.0000>
  translate <1.3000,8.0000,0.0000>}

#declare ramax07 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <0.0000,0.0000,15.0000>
  translate <-1.4000,7.9000,0.0000>}

#declare ramax06 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <-15.0000,0.0000,0.0000>
  translate <0.0000,7.9000,-1.3000>}

#declare ramax05 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <15.0000,0.0000,0.0000>
  translate <0.0000,7.8000,1.4000>}

#declare troncox01 = lathe {  cubic_spline  11.0
  <0.0000,0.0000> ,   <0.1510,0.0080> ,   <0.1030,0.1910> , 
  <0.1030,0.3000> ,   <0.1030,0.4250> ,   <0.0960,0.5580> ,   <0.0820,0.6830> , 
  <0.0960,0.7910> ,   <0.0890,0.9000> ,   <0.0620,0.9910> ,   <0.0060,1.0080>
  scale <4.0000,13.0000,4.000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,0.0000,0.0000>}

#declare ramax01 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <35.0000,0.0000,0.0000>
  translate <0.0000,6.2000,0.6000>}

#declare ramax02 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <-35.0000,0.0000,0.0000>
  translate <0.1000,6.3000,-0.5000>}

#declare ramax03 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <0.0000,0.0000,35.0000>
  translate <-0.7000,6.4000,0.0000>}

#declare ramax04 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.2500,2.0000,0.2500>
  rotate <0.0000,0.0000,-35.0000>
  translate <0.5000,6.4000,0.0000>}

#declare hojas107 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <1.4200,1.2600,1.4200>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,5.1000,-0.1000>}

#declare hojas106 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <0.3500,1.2000,0.3500>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,13.0000,0.0000>}

#declare hojas101 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <2.5000,1.2500,2.5000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,6.5000,0.0000>}

#declare hojas102 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <2.6300,1.2500,2.6300>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,7.9000,0.0000>}

#declare hojas103 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <2.2000,1.2600,2.2000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.4000,0.0000>}

#declare hojas104 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <1.2000,1.2600,1.2000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,10.7000,-0.1000>}

#declare hojas105 = lathe {  quadratic_spline  12.0
  <0.0000,0.0000> ,   <0.3720,0.1410> ,   <1.0200,0.1830> ,   <1.6480,-0.0750> , 
  <1.7860,0.0410> ,   <1.7030,0.1580> ,   <1.6050,0.2330> ,   <1.5310,0.4080> , 
  <1.2270,0.5160> ,   <0.9240,0.5830> ,   <0.3240,0.5250> ,   <0.0130,0.5750>
  scale <0.7500,1.2000,0.7500>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,12.0000,0.0000>}

#declare hojasb01 = lathe {  quadratic_spline  11.0
  <0.0060,-0.4670> ,   <0.1930,-0.4340> ,   <0.3790,-0.2750> , 
  <0.4960,-0.0840> ,   <0.6750,0.1660> ,   <0.7240,0.3500> ,   <0.6820,0.5410> , 
  <0.5930,0.6660> ,   <0.4480,0.7750> ,   <0.2550,0.8160> ,   <0.0000,0.8160>
  scale <6.0000,8.0000,6.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,8.0000,0.1000> texture {leaves1}}

#declare hojasb11 = lathe {  quadratic_spline  11.0
  <0.0060,-0.4670> ,   <0.1930,-0.4340> ,   <0.3790,-0.2750> , 
  <0.8130,-0.1000> ,   <0.9170,0.0500> ,   <0.9580,0.2660> ,   <0.9240,0.4660> , 
  <0.7170,0.5750> ,   <0.4890,0.6410> ,   <0.2550,0.8160> ,   <0.0060,0.8750>
  scale <5.0000,10.0000,5.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,8.0000,0.1000> texture {leaves1}}

#declare hojasb21 = lathe {  quadratic_spline  11.0
  <0.0060,-0.4670> ,   <0.1930,-0.4340> ,   <0.3790,-0.2750> , 
  <0.8130,-0.1000> ,   <0.9170,0.0500> ,   <0.9580,0.2660> ,   <0.9240,0.4660> , 
  <0.7170,0.5750> ,   <0.4410,0.6750> ,   <0.2130,0.9160> ,   <0.0130,0.9910>
  scale <7.0000,5.0000,7.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,8.2000,0.1000> texture {leaves1}}

#declare hojasb31 = lathe {  quadratic_spline  13.0
  <0.0060,-0.4670> ,   <0.1930,-0.4340> ,   <0.3790,-0.2750> ,   <0.4000,-0.0840> , 
  <0.3440,0.0330> ,   <0.4000,0.1250> ,   <0.4820,0.3080> ,   <0.4480,0.4830> ,   <0.3370,0.6410> , 
  <0.3510,0.7750> ,   <0.2890,0.8660> ,   <0.1930,0.9580> ,   <0.0060,1.0080>
  scale <5.0000,7.0000,5.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,7.0000,0.0000> texture {leaves1}}

#declare hojasb41 = lathe {  quadratic_spline  13.0
  <0.0060,-0.4670> ,   <0.1930,-0.4340> ,   <0.5580,-0.2670> ,   <0.6750,-0.0750> , 
  <0.7650,0.0160> ,   <0.8130,0.1250> ,   <0.7930,0.2830> ,   <0.5240,0.4160> ,   <0.4820,0.5500> , 
  <0.5580,0.6580> ,   <0.5100,0.8750> ,   <0.4060,0.9750> ,   <0.0060,1.0080>
  scale <6.0000,7.0000,6.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,7.0000,0.0000> texture {leaves1}}

#declare hojasb51 = lathe {  quadratic_spline  13.0
  <0.0060,-0.7420> ,   <0.1170,-0.7340> ,   <0.2620,-0.6420> ,   <0.3170,-0.4920> , 
  <0.2820,-0.3250> ,   <0.3310,-0.2090> ,   <0.3860,-0.0170> ,   <0.4340,0.2160> ,   <0.4270,0.4330> , 
  <0.3790,0.6410> ,   <0.3100,0.8160> ,   <0.2130,0.9660> ,   <0.0060,1.0080>
  scale <6.0000,7.0000,6.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.6000,0.0000> texture {leaves1}}

#declare hojasb61 = lathe {  quadratic_spline  15.0
  <0.0060,-0.7420> ,   <0.1170,-0.7340> ,   <0.2620,-0.6420> ,   <0.3170,-0.4920> ,   <0.2820,-0.3250> , 
  <0.4000,-0.2500> ,   <0.5240,-0.1250> ,   <0.5650,0.0410> ,   <0.5370,0.2080> ,   <0.6060,0.3750> , 
  <0.6680,0.5750> ,   <0.6550,0.7160> ,   <0.5580,0.8580> ,   <0.4060,0.9500> ,   <0.0000,1.0080>
  scale <7.0000,7.0000,7.0000>  rotate <0.0000,0.0000,0.0000>  translate <0.0000,9.2000,0.1000> texture {leaves1}}

//------------------------------------------------------------------------
//The modules

#declare maderax1 = union{object {tronco01} object {rama04} object {rama03} object {rama02} object {rama01} texture {treewood}}
#declare hojasx1 = union{object {hojas01 texture {leaves1}} object {hojas02 texture {leaves2}}}
#declare hojasx2 = union{object {hojas11 texture {leaves1}} object {hojas12 texture {leaves2}}}
#declare hojasx3 = union{object {hojas21 texture {leaves1}} object {hojas22 texture {leaves2}}}
#declare hojasx4 = union{object {hojas31 texture {leaves1}} object {hojas32 texture {leaves2}}}
#declare hojasx5 = union{object {hojas41 texture {leaves1}} object {hojas42 texture {leaves2}}}
#declare hojasx6 = union{object {hojas51 texture {leaves1}} object {hojas52 texture {leaves2}}}
#declare hojasx7 = union{object {hojas61 texture {leaves1}} object {hojas62 texture {leaves2}}}
#declare hojasx8 = union{object {hojas71 texture {leaves1}} object {hojas72 texture {leaves2}}} 
#declare madera101 = union{object {troncox01} object {ramax01} object {ramax02} object {ramax03} object {ramax04}
object {ramax05} object {ramax06} object {ramax07} object {ramax08}texture {treewood}}
#declare follaje = union {object {hojas101 texture {leaves1}} object {hojas102 texture {leaves1}} object {hojas103 texture{leaves1}}
object {hojas104 texture{leaves1}} object {hojas105 texture{leaves1}}}
#declare follaje002 = union {
object {hojas102} object {hojas106} object {hojas107} object {hojas101} object {hojas103} object {hojas104} object {hojas105}
texture {leaves1} scale <.65,1.25,.65> translate<0,-3,0>}

//--------------------------------------------------------------------------
//...and the trees (finally)...

#declare treex01 = union { object {maderax1} object {hojasx1}}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
#declare treex02 = union { object {maderax1} object {hojasx2}}
#declare treex03 = union { object {maderax1} object {hojasx3}}
#declare treex04 = union { object {maderax1 scale<.72,1,.72>} object {hojasx4}}
#declare treex05 = union { object {maderax1 scale<2,2,2>} object {hojas41 texture{leaves1}}}
#declare treex06 = union { object {maderax1} object {hojasx6}}
#declare treex07 = union { object {maderax1} object {hojasx7}}
#declare treex08 = union { object {maderax1} object {hojasx8}}
#declare treex09 = union {object {madera101} object {follaje}}
#declare treex10 = union {object {madera101} object {follaje scale <1,2.25,1> translate<0,-7.5,0>} object{conopino translate <0,6.5,0>}}
#declare treex11 = union {object {madera101} object {follaje scale <1,2,1> translate<0,-10,0>} object{conopino translate <0,3,0>}}
#declare treex12 = union {object {troncox01} object {follaje002}}
#declare treex13 = union {object {madera101} object {hojasb01}}
#declare treex14 = union {object {madera101} object {hojasb11}}
#declare treex15 = union {object {madera101} object {hojasb21}}
#declare treex16 = union {object {madera101} object {hojasb31}}
#declare treex17 = union {object {madera101} object {hojasb41}}
#declare treex18 = union {object {madera101} object {hojasb51}}
#declare treex19 = union {object {madera101} object {hojasb61}}

//This is the first version of this include file
//I hope I'll make better trees in the future
//If you have any comments or suggestions, you can e-mail me:
//luisvaloyes@malditasea.zzn.com
//
//Thanx
//--------------------------------------------------------------------------------------