//------------------------------------------------------------FICHIER-CHATEAU
// Persistence Of Vision raytracer version 3.1
// Chateau
// 29 Mars 2001
// derniere modification : 29/03/01
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
//-----------------------------------------------------------------camera----
camera { location <0, 0, 0> up <0, 1, 0> right <1.33, 0, 0>
//rotate <100, 0, -40> translate <50, 80, 20> 
//rotate <90, 0, 0> translate <0, 40, 7> //devant la porte  
rotate <90, 0, -30> translate <20, 70, 14> //a cote de la porte
//rotate <90, 0, -90> translate <6, 22, 6> //a cote du cheval
//rotate <75, 0, 0> translate <5, 45, 2.5> //sous le pont
//rotate <180, 0, 0> translate <0, 0, 250> //pour voir de haut 
//rotate <180, 0, 0> translate <0, 0, 2000> //pour voir de tres tres haut 
//rotate <180, 0, 0> translate <50, 80, 100> //pour voir de haut au dessus de la camera
       }
//light_source {<0, 60, 200> color White}//pour la camera de dessus       
light_source {<50, 80, 200> color White}
light_source {<50, 80, 30> color White}
//---------------------------------------------------------------------------

//la spere represente la camera
//sphere{ <50, 80, 20> 2}
      
#include "Fenetre.inc"
#include "Herse.inc"
#include "Tours.inc"
#include "Socle.inc"
#declare Cote_S = union {
object {Facade_C translate <0, 15, 5>}
object {Tour_3 translate <-4, 15.5, 19>}
object {Tour_3 translate <4, 15.5, 19>}
                        }
#declare Cote_E = object { union {
object {Facade_A translate <0, 15, 5>}
object {Tour_3 translate <-4, 15.5, 19>}
object {Tour_3 translate <4, 15.5, 19>}
       } rotate <0, 0, -90> }
#declare Cote_N = object { union {
object {Facade_A translate <0, 15, 5>}
object {Tour_3 translate <-4, 15.5, 19>}
object {Tour_3 translate <4, 15.5, 19>}
       } rotate <0, 0, 180> }
#declare Cote_O = object { union {
object {Facade_A translate <0, 15, 5>}
object {Tour_3 translate <-4, 15.5, 19>}
object {Tour_3 translate <4, 15.5, 19>}
       } rotate <0, 0, 90> }
//---------------------------------------------------------------------------   
        
sky_sphere { S_Cloud2 rotate <90, 0, 90> }
           
object { plane {z, 2}       //mer
texture { pigment {Blue} finish {reflection 0.9} normal {waves 0.01} scale <0.2, 0.2, 1>}}   
                             
object { height_field { gif "montagne1.gif"  }   //  smooth  water_level 0.01
translate <-0.5, -0.5, -0.5> rotate <90, 0, 180> scale <250, 250, 5>
rotate <0, 0, 0>  translate <0, 25, 2.5>
 texture { pigment{granite color_map{[0.0 rgb <.45,.65,.25>] [0.7 rgb <.25,.35,.15>] [1.0 rgb <.25,.55,.15>]}scale .5}normal {granite 1 scale 2.5}}}    
          
object {Herse translate <0, 50, 5>}              //entree
object {Tour_1 translate <-7, 50, 5>}            //tour d'entree
object {Tour_1 translate <7, 50, 5>}             //tour d'entree 

object {Tour_2 translate <-15, -15, 5>}
object {Tour_2 translate <-15, 15, 5>}
object {Socle_central texture {T_Grnt18}} 
object { Cote_S }
object { Cote_E }
object { Cote_N }
object { Cote_O }
object {Tour_2 translate <15, 15, 5>} 
object {Tour_2 translate <15, -15, 5>} 
            
#include "xtree.inc"
object{xtree scale 1 rotate 90*x rotate 360 translate <49,49,2.5>}
#declare A = 0;
#declare R1 = seed(1007);
#while (A<=20)// 1 = 2 mn 47 s | 10 = 5 h 13 mn 45 s | 20 = 10 h 58 mn 56 s  | 20 + 200 fern = 15 h 19 mn 47 s
object{xtree scale 0.6 rotate 90*x rotate 360*rand(R1)*z translate <-50-25*rand(R1),100-175*rand(R1),2.5>}  
object{xtree scale 0.6 rotate 90*x rotate 360*rand(R1)*z translate <100-175*rand(R1),-50-25*rand(R1),2.5>}
#declare A=A+1;
#end       

#include "fktr01.inc"
#include "fkpalm01.inc"
#declare A = 0;
#declare R1 = seed(1007);//12345
#while (A<=200)// 200 = 34 s
object{treex05 scale 0.75 rotate 90*x rotate 360*rand(R1)*z translate <-75-75*rand(R1),100-200*rand(R1),2.5>}  
object{treex05 scale 0.75 rotate 90*x rotate 360*rand(R1)*z translate <100-200*rand(R1),-75-75*rand(R1),2.5>}
#declare A=A+1;
#end     
          /*  
//Scene contains 476815 frame level objects ; 1 infinite
// 15 h 58 mn 03 s          
#include "fern.inc" 
#declare A = 0;
#declare R1 = seed(1007);
#while (A<=200)//200     
object {PaquetFougere(3214) rotate 90*x rotate 360*rand(R1)*z translate <15-30*rand(R1), 5-10*rand(R1), 0>
rotate 10*x rotate <0,0,-30> translate <34, 66, 7.25>} 
#declare A=A+1;
#end 
         */ 
#declare MountainTexture =  texture {
pigment{granite color_map{[0.0 rgb <.45,.65,.25>] 
[0.7 rgb <.25,.35,.15>] [1.0 rgb <.25,.55,.15>]}scale .5}normal {granite 1 scale 2.5}}

#declare mountains = height_field
{tga "mountain.tga" smooth texture { MountainTexture } 
translate <-.5, -.5, -.5>}
object { mountains normal { bumps 50 scale 1} rotate -90*x rotate -45*z scale <1000,1000,100> translate <0,0,45>}
            
#include "horse.inc"  
object {horse rotate 90*x scale 0.01 translate <0,55,7>}    //20 55

#include "gina.inc"  
object {gina rotate 90*x rotate -90*z scale 5 translate <0,59,5>}    //24    59  

//472000 frame
// 8h 0mn 59s