//DBS_FORT
//BY DAVID BRIDGE. APRIL 2001
//IRTC COMPETITION - FORTRESS

#declare DBS_Rand=seed(75);

global_settings 
{
  max_trace_level 10
}

camera {  //  Camera Camera01
  location  <     30.000,     -25.000,      25.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35783,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.60000    // Vertical      29.700
  look_at   <      0.000,      25.000,      15.000>
}

fog
{
  fog_type 2    // Ground Fog
  distance     50.0
  color <0.6, 0.75, 0.6>
  turbulence   <2.0, 2.0, 5.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.25
  up           <0, 0, 1>
  fog_offset   -5.0
  fog_alt      10.0
}

// *******  L I G H T S *******
// THE TUNNEL LIGHTS

#declare y_axis=0;
#while (y_axis<10)
                      
  #declare gpig=rand(DBS_Rand);
                      
  #declare DBS_light1 = light_source
  {   // Light001
    <0.0, 0.0, 0.0>
    color rgb <1.00, gpig, 0.20>
  }

  #declare gpig=rand(DBS_Rand);

  #declare DBS_light2 = light_source
  {   // Light002
    <0.0, 0.0, 0.0>
    color rgb <1.00, gpig, 0.20>
  }
  
  object
  {
    DBS_light1      

    translate  <-75.0, y_axis*50, 30.0>
    
    #if(rand(DBS_Rand)<0.50)
      translate y*rand(DBS_Rand)*5
    #else
      translate y*rand(DBS_Rand)*-5
    #end
  
  }

  object
  {
    DBS_light2    
    
    translate  <-75.0, y_axis*50, 30.0>
        
    #if(rand(DBS_Rand)<0.50)
      translate y*rand(DBS_Rand)*5
    #else
      translate y*rand(DBS_Rand)*-5
    #end

  }
  
  #declare y_axis=y_axis+1;
#end                

/*
// THE MAIN CHAMBER LIGHT
light_source
{
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <20.0, -20.0, 45.0>
} 
*/

#declare RoughStone = 
material
{   
  texture
  {      
    pigment
    {
      granite
      color_map
      {
        [ 0.0     rgbft <0.499564, 0.499564, 0.499564, 0.0, 0.0> ]
        [ 0.25    rgbft <0.649707, 0.649707, 0.649707, 0.0, 0.0> ]
        [ 0.5     rgbft <0.499858, 0.499858, 0.499858, 0.0, 0.0> ]
        [ 0.75    rgbft <0.699587, 0.699587, 0.699587, 0.0, 0.0> ]
        [ 1.0     rgbft <0.499644, 0.499644, 0.499644, 0.0, 0.0> ]
      }
      frequency 100.0
      ramp_wave
    }      
    
    normal
    {
      crackle , 1.0
      warp
      {
        turbulence <0.500164, 0.500364, 0.499804>
        omega 0.500404
        lambda 1.999712
      }
    }      
    
    finish
    {
      ambient 0.1
      diffuse 0.549996
      specular 0.1000
      roughness 1.0
      reflection 0.100
    }      

    //  This texture was originally designed by Charles Fusner.

  }
}

#declare FloorTile = superellipsoid 
{
  <0.1, 0.25>    
}

#declare x_axis=0; 
#declare y_axis=0;
                  
#while (y_axis<50)                  
  
  #while (x_axis<15)  
  
    object
    {
    
      FloorTile    
      material 
      {
        RoughStone
        rotate z*rand(DBS_Rand)*360
        translate x*rand(DBS_Rand)*25
        translate y*rand(DBS_Rand)*25
      }
     
      #if(rand(DBS_Rand)<0.75)
        rotate x*rand(DBS_Rand)*5
      #else
        rotate -x*rand(DBS_Rand)*10
      #end

      #if(rand(DBS_Rand)<0.75)
        rotate y*rand(DBS_Rand)*5
      #else
        rotate -y*rand(DBS_Rand)*10
      #end

      scale <5.0, 5.0, 0.5>
      translate  <40.0, -45.0, 0.0>
      
      translate x*x_axis*-10.1
      translate y*y_axis*10.1

    }    

    #declare x_axis = x_axis+1;
    
  #end             
                          
  #declare y_axis = y_axis+1;  
  #declare x_axis=0;    
  
#end
  
#include "Grill.inc"

#declare GrillTxtr = 
texture
{      
   pigment
   {
      //colour rgb<0.1412, 0.0392, 0.4078>
      colour rgb<0.0, 0.0, 0.0>
   }      
   normal
   {
      crackle , 0.5
   }      
   finish
   {
      ambient 0.10
      specular 0.95
      roughness 0.025
      reflection 0.10
   }
}

#declare y_axis=0;
#while (y_axis<10)

  object
  {
    Dbs_Grill        
    texture{GrillTxtr}
    scale 2.1  
    rotate <90.0, 0.0, 0.0>
    rotate <0.0, 0.0, -90.0>
    translate  <-40.0, y_axis*50, 15.0>
  }
  
  #declare y_axis=y_axis+1;         
  
#end

merge { // The_Room
  cylinder { // Main_Chamber
    <0,0,1>, <0,0,0>, 1   
    hollow
    scale <40.0, 40.0, 550.0>
    rotate -90.0*x
    translate  <2.0, -50.0, 15.0>
  }
  cylinder { // Side_Chamber_001
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 0.0, 15.0>
  }
  cylinder { // Side_Chamber_002
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 50.0, 15.0>
  }
  cylinder { // Side_Chamber_003
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 100.0, 15.0>
  }
  cylinder { // Side_Chamber_004
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 150.0, 15.0>
  }
  cylinder { // Side_Chamber_005
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 200.0, 15.0>
  }
  cylinder { // Side_Chamber_006
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 250.0, 15.0>
  }
  cylinder { // Side_Chamber_007
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 300.0, 15.0>
  }
  cylinder { // Side_Chamber_008
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 350.0, 15.0>
  }
  cylinder { // Side_Chamber_009
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 400.0, 15.0>
  }
  cylinder { // Side_Chamber_010
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <20.0, 20.0, 100.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-130.0, 450.0, 15.0>
  }       
  
  material
  {
    RoughStone
  }
}




