#version unofficial MegaPov 0.6;
#include "colors.inc"
camera {location <100,100,100> direction z*1 look_at <0,50,0>}

light_source {<400,500,300> White*1}
light_source {<400,500,300> rgb <.9,.85,1>*.5 shadowless rotate y*180}

//========================= creation HF support ==========
#declare HF_Res = 150;
#declare BozoPig = pigment {bozo color_map {[0 Black][1 White]}}
#declare PigTraces = pigment {
 average
 pigment_map {
 [.3 BozoPig scale 1]
 [.3 BozoPig scale .3]
 [.3 BozoPig scale .1]
 }
 scale .01
}

#declare Traces_HF = 
height_field {pattern HF_Res,HF_Res
              {
              hf_gray_16 
              PigTraces
              }        
              smooth      
              //pigment {slope y color_map {[0 White][.5 White*.9][1 White]}}
              //finish {ambient <.8,.8,1>*.4}
              pigment {Yellow}

              translate <-1,0,-.5>
              scale <500,30,1000>
              //rotate <-10,0,5>
              //translate y*13
              
              translate x*100
              
              }
//===========================================
#include "clothutil.inc"

#macro v_debug(V)
concat("[",str(V.x,0,3),",",str(V.y,0,3),",",str(V.z,0,3),"]")
#end

//crer l'objet principal          
#declare Table = union {
              cylinder {<0,0,-10>,<0,80,-10>,5}
              cylinder {<0,0,10>,<0,80,10>,5}
              cylinder {<20,0,0>,<20,70,0>,8}
          }

#declare FaireCalcul=1;
#declare Materialise=1;

//#declare Traces_HF = plane {y,0}

object {Traces_HF pigment {Yellow}}

#if (FaireCalcul)

//crer la nappe              
#declare Unit = 3;
#declare LongX=50*1.8;
#declare LongY=80*1.8;
WriteClothFile("fmplaid.cth", LongX/Unit, LongY/Unit, Unit, 5, 40)

//lancer la simulation
#declare vect = clothsim(Traces_HF, -8*y, <0,0,0>, 0.0, .90, .1, 150, "fmplaid.cth", "fmplaid.cth");

//demander la valeur de vect
#debug v_debug (vect)

#end

//lire la nappe et la matrialiser
#if (Materialise)
ReadClothFile("fmplaid.cth")

          #declare Nappe = mesh {
                  //DrawSmoothTriangles(Points, n1, n2, on, off, "")
                  DrawSmoothTriangles(Points, n1, n2, on, on, "machin.msh")
                  DrawSmoothTriangles(Points, n1, n2, on, off, "machin.msh")
                  uv_mapping
                  texture {
                   //pigment {checker color OrangeRed color SteelBlue scale .05}
                   pigment {slope y}
                   normal {quilted .2 scale .01} 
                   }
          }

object {Nappe translate y*1}          
#end

//placer les objets
//object {Table pigment {Green}}          

