#include "macros.inc"
#include "ganesha_3ds_objects_trone_back.inc"
//#include "curveb.inc"


#declare GoldBase = <1.00, 0.875, 0.575>;
#declare myGoldPigment =
pigment
{
   color rgb GoldBase * 1.4 + <0.1,0.1,0>
}
#declare tGold = texture { pigment { myGoldPigment } finish { F_MetalE } }


#declare tTroneBack =
texture
{
   tGold
}                  

#declare tBackSeat =
texture
{
   pigment
   {
      color rgb <0.7,0.1,0.2>
   }                         
   finish
   {
      phong 0
      diffuse 0.8
      reflection 0
   }       
   normal
   {
      dents 0.6
      scale 0.01
   }
}


#declare oTroneBackCurl = 
object
{
   maxTroneBackCurl
   rotate <90,0,180>
   scale 1/120
   scale <-1,1,1.5>
}              

#declare oCircleArrayBackCurl =
union
{
   #declare iCounter = -80;           
   #while (iCounter < 91)
      object
      {                  
         oTroneBackCurl

         #if (iCounter >0)
            scale <-1,1,1>
         #end

         translate <0,20,0>

         #if (iCounter >0)
            rotate<0,0,-4+iCounter> 
         #else
            rotate<0,0,iCounter> 
         #end
      }
   
   #declare iCounter = iCounter + 11;
   #end

   #declare iCounter = 1;           
   #while (iCounter < 7)
      object
      {                  
         oTroneBackCurl
         rotate<0,0,-7>
         translate <0,20,0>
         rotate<0,0,-80>
         translate <0.5,-3.8 * iCounter,0> 
      }
   
   #declare iCounter = iCounter + 1;
   #end

   #declare iCounter = 1;           
   #while (iCounter < 7)
      object
      {                  
         oTroneBackCurl      
         scale <-1,1,1>
         rotate<0,0,7>
         translate <0,20,0>
         rotate<0,0,80>
         translate <-0.5,-3.8 * iCounter,0> 
      }
   
   #declare iCounter = iCounter + 1;
   #end
}    

#declare oSinePart1 =
union
{
   sphere
   {
      <0,1,0>, 0.2
   }              
   cylinder
   {
      <0,1,0>, <0,0,0>,0.2
   }                      
   translate <0,0,0.3>
}


#declare oSineArrayCircle1 =
union
{                      
   #declare iAngle = -90;
   #while (iAngle < 90)
      object
      {  
         oSinePart1
         scale <1,1 + 0.3 * sin(2*iAngle),1>
         translate <0,17.5,0>
         rotate <0,0,iAngle>
      }
   #declare iAngle = iAngle + 0.03;
   #end
}

#declare oSineArrayStraight1 =
union
{                      
   #declare iCounter = 0;
   #while (iCounter < 3.8*6)
      object
      {  
         oSinePart1
         scale <1,1.15 + 0.25 * sin(-90*2 + 6.7*iCounter),1>
         translate <0,17.5,0>
         rotate <0,0,-90>
         translate <0,-iCounter,0>
      }
   #declare iCounter = iCounter + 0.008;
   #end

   #declare iCounter = 0;
   #while (iCounter < 3.8*6)
      object
      {  
         oSinePart1
         scale <1,1 + 0.3 * sin(90*2 + 6.7*iCounter),1>
         translate <0,17.5,0>
         rotate <0,0,90>
         translate <0,-iCounter,0>
      }
   #declare iCounter = iCounter + 0.008;
   #end
}
                                                                                                              
#declare oOuterTorus =
difference
{
   torus
   {
      16.6, 0.8                 
      rotate <90,0,0>
      scale <1,1,0.5>
      translate <0,0,-0.2>
   }
   plane
   {
      <0,1,0>,0
   }
}                  

#declare oOuterCylinders =
union
{
   cylinder
   {
      <-16.6,0,-0.4>,<-16.6,-23,-0.4>,0.8
      scale <1,1,0.5>
   }   
   cylinder
   {
      <16.6,0,-0.4>,<16.6,-23,-0.4>,0.8
      scale <1,1,0.5>
   }   
}

#declare oShape1 = 
object
{
   maxShape1        
   translate <0,0,-0.5>
   rotate <90,0,0>
   scale 1/20
}            

#declare oShape1Circle =
union
{  
   #declare iAngle = -85;
   #while (iAngle < 85.1)  
   object
   {
      oShape1
      translate <0,16.45,-1>
      rotate <0,0,iAngle>
   }                     
   #declare iAngle = iAngle + 85/9.5;
   #end
}
                                                                                                              
#declare oShape1Straights =
union
{  
   #declare iCounter = 0.5;
   #while (iCounter < 8)  
   object
   {
      oShape1
      translate <0,16.45,-1>
      rotate <0,0,-90>
      translate <0, -iCounter * 2.8, 0>
   }                     
   #declare iCounter = iCounter + 1;
   #end

   #declare iCounter = 0.5;
   #while (iCounter < 8)  
   object
   {
      oShape1
      translate <0,16.45,-1>
      rotate <0,0,90>
      translate <0, -iCounter * 2.8, 0>
   }                     
   #declare iCounter = iCounter + 1;
   #end
}                         

#declare oSphereCircle1 =
union
{
   #declare iAngle = -90;
   #while (iAngle < 90.1)
      sphere
      {
         <0,16.45-0.65-0.2,-0.25>,0.2 
         rotate <0,0,iAngle>
      }
   #declare iAngle = iAngle + 1;
   #end
}             

#declare oSphereStraight1 =
union
{
   #declare iCounter = 1;
   #while (iCounter < 78)
      sphere
      {
         <0,16.45-0.65-0.2,-0.25>,0.2 
         rotate <0,0,-90>
         translate <0,-iCounter * 0.3,0>
      }
   #declare iCounter = iCounter + 1;
   #end

   #declare iCounter = 1;
   #while (iCounter < 78)
      sphere
      {
         <0,16.45-0.65-0.2,-0.25>,0.2 
         rotate <0,0,90>
         translate <0,-iCounter * 0.3,0>
      }
   #declare iCounter = iCounter + 1;
   #end
}             

#declare oInnerTorus =
difference
{
   torus
   {
      16.45-0.65-0.2-1.25, 1.25                 
      rotate <90,0,0>
      scale <1,1,0.5>
      translate <0,0,-0.1>
   }
   plane
   {
      <0,1,0>,0
   }
}                  

#declare oInnerCylinders =
union
{
   cylinder
   {
      <-16.45+0.65+0.2+1.25,0,-0.2>,<-16.45+0.65+0.2+1.25,-23,-0.2>,1.25
      scale <1,1,0.5>
   }   
   cylinder
   {
      <16.45-0.65-0.2-1.25,0,-0.2>,<16.45-0.65-0.2-1.25,-23,-0.2>,1.25
      //14.35
      scale <1,1,0.5>
   }   
}

#declare oSinePart2a =
difference
{
   union
   {
      sphere
      {
         <0,1,0>, 0.2
      }              
      cylinder
      {
         <0,1,0>, <0,-0.2,0>,0.2
      }                      
      translate <0,0,0.1>
   }       
   box
   {
      <-0.3,0.3,0.1>,<0.3,0.7,-0.1>
   }
   cylinder
   {
      <-0.3,0.3,-0.1>,<0.3,0.3,-0.10>,0.2
   }
   cylinder
   {
      <-0.3,0.7,-0.1>,<0.3,0.7,-0.1>,0.2
   }
}
          
#declare oSineArrayCircle2a =
union
{                      
   #declare iAngle = -90;
   #while (iAngle < 90)
      object
      {  
         oSinePart2a
         scale <1,1 + 0.13 * sin(3*iAngle),1>
         translate <0,14.35-1.2-1.25,0>
         rotate <0,0,iAngle>
      }
   #declare iAngle = iAngle + 0.03;
   #end
}

#declare oSineArrayStraight2a =
union
{                      
   #declare iCounter = 0;
   #while (iCounter < 3.8*6)
      object
      {  
         oSinePart2a
         scale <1,1 + 0.13 * sin(-90*3 + 10*iCounter),1>
         translate <0,14.35-1.2-1.25,0>
         rotate <0,0,-90>
         translate <0,-iCounter,0>
      }
   #declare iCounter = iCounter + 0.003;
   #end

   #declare iCounter = 0;
   #while (iCounter < 3.8*6)
      object
      {  
         oSinePart2a
         scale <1,1 + 0.13 * sin(90*3 + 10*iCounter),1>
         translate <0,14.35-1.2-1.25,0>
         rotate <0,0,90>
         translate <0,-iCounter,0>
      }
   #declare iCounter = iCounter + 0.003;
   #end
}
#declare oBackSeat = 
object
{
   maxBackSeat    
   rotate <-90,0,0>
   scale 1/260 
   scale <1,1,1>
   translate <0,-3.2,1>  
}
              
#declare oEdelStone =
intersection
{
   plane {<0,1,0>,1 rotate <0,0,36>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,2*72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,3*72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,4*72,0>}

   plane {<0,1,0>,1 rotate <0,0,2*36>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,2*72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,3*72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,4*72,0>}

   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,0+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,2*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,3*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,4*72+36,0>}

   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,0+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,2*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,3*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,4*72+36,0>}   
   
   bounded_by { sphere {<0,0,0>, 1.1}}

   translate <0,0.5,0>
   scale 0.2  
}

              
#declare oEdelStoneCircle2 =
union
{
   #declare iAngle = -90;
   #while (iAngle < 90.1)
      object
      {  
         oEdelStone  
         translate <0,12.23,-0.2>      
         rotate <0,0,iAngle> 
         texture
         {  
            pigment
            {    
               color rgbf <0.9, 0.1, 0.2, 0.5> 
//               color rgb <0.9, 0.1, 0.2> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection 0.75
                specular 1  
                roughness 0.0005
            }              
         }
         interior
         {
            ior 1.5
         }
      }
   #declare iAngle = iAngle + 3;

      object
      {  
         oEdelStone  
         translate <0,12.23,-0.2>      
         rotate <0,0,iAngle> 
         texture
         {  
            pigment
            {    
               color rgbf <0.2, 0.1, 0.9, 0.5> 
//               color rgb <0.2, 0.1, 0.9> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection 0.75
                specular 1
                roughness 0.0005
            }              
         }
         interior
         {
            ior 1.5
         }
      }
   #declare iAngle = iAngle + 3;
   #end        
}              

#declare oEdelStoneStraight2a =
union
{                      
   #declare iCounter = 0.8;
   #while (iCounter < 3.8*6)
      object
      {  
         oEdelStone  
         translate <0,12.23,-0.2>      
         rotate <0,0,90>        
         translate <0,-iCounter,0>
         texture
         {  
            pigment
            {    
               color rgbf <0.2, 0.1, 0.9, 0.5> 
//               color rgb <0.2, 0.1, 0.9> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection 0.75
                specular 1
                roughness 0.0005
            }              
         }
         interior
         {
            ior 1.5
         }
      }
      #declare iCounter = iCounter + 0.8;

      object
      {  
         oEdelStone  
         translate <0,12.23,-0.2>      
         rotate <0,0,90> 
         translate <0,-iCounter,0>
         texture
         {  
            pigment
            {    
               color rgbf <0.9, 0.1, 0.2, 0.5> 
//               color rgb <0.9, 0.1, 0.2> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection 0.75
                specular 1
                roughness 0.0005
            }              
         }
         interior
         {
            ior 1.5
         }
      }
      #declare iCounter = iCounter + 0.8;
   #end
}
                                                                       
#declare oEdelStoneStraight2b =
union
{                      
   #declare iCounter = 0.8;
   #while (iCounter < 3.8*6)
      object
      {  
         oEdelStone  
         translate <0,12.23,-0.2>      
         rotate <0,0,-90>        
         translate <0,-iCounter,0>
         texture
         {  
            pigment
            {    
               color rgbf <0.2, 0.1, 0.9, 0.5> 
//               color rgb <0.2, 0.1, 0.9> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection 0.75
                specular 1
                roughness 0.0005
            }              
         }
         interior
         {
            ior 1.5
         }
      }
      #declare iCounter = iCounter + 0.8;

      object
      {  
         oEdelStone  
         translate <0,12.23,-0.2>      
         rotate <0,0,-90> 
         translate <0,-iCounter,0>
         texture
         {  
            pigment
            {    
               color rgbf <0.9, 0.1, 0.2, 0.5> 
//               color rgb <0.9, 0.1, 0.2> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection 0.75
                specular 1
                roughness 0.0005
            }              
         }
         interior
         {
            ior 1.5
         }
      }
      #declare iCounter = iCounter + 0.8;
   #end
}        

#declare oCurveBottom =
object
{
   maxCurveBottom
   scale 1/60
   rotate <-90,180,0>  
}

#declare oCurveBottomArray =
union
{                        
   #declare iCounter = 0;
   #while (iCounter < 13)
      object
      {  
         oCurveBottom    
         translate <-0.65-1.7*iCounter,0,0>
      }   
      object
      {
         oCurveBottom
         scale <-1,1,1>  
         translate <0.65+1.7*iCounter,0,0>
      }
   #declare iCounter = iCounter + 1;
   #end                
}

#declare oCurveBottomArray1 = 
object
{
   oCurveBottomArray   
   scale <1,0.7,1.3>
   translate <0,-22.6,-1.4>
}
                   
#declare oBox1 =
object
{
   mBoxRounded(45,0.5,2,0.1)
   translate <0,-23.73,-1.7>
}                   
                   
#declare oCurveBottomArray2 = 
object
{
   oCurveBottomArray   
   scale <1,-1.35,0.7>
   translate <0,-25.6,-2.2>
}

#declare oBox2 =
object
{
   mBoxRounded(45,1,2,0.3)
   translate <0,-28.6,-1.2>
}                   

#declare oBox3 =
object
{
   mBoxRounded(42,2.6,1.5,0.3)
   translate <0,-29.6,-1.2>
}                   

#declare oBox4 =
object
{
   mBoxRounded(45,1,2,0.3)
   translate <0,-30.8,-1.2>
}                   

#declare oCurveBottomArray3 = 
object
{
   oCurveBottomArray   
   scale <1,0.7,1.3>
   scale 1.05
   translate <0,-32.7,-3.5>
}

#declare oBox5 =
object
{
   mBoxRounded(48,1,10,0.3)
   translate <0,-34.1,0.5>
}                   

#declare oBox6 =
object
{
   mBoxRounded(48,1,10,0.3)
   translate <0,-43,0.5>
}                   
              
#declare oBox7 =
object
{
   mBoxRounded(1,(43-34.1),10,0.3)
   translate <-24+0.5,(-34.1-43)/2,0.5>
}                   

#declare oBox8 =
object
{
   mBoxRounded(1,(43-34.1),10,0.3)
   translate <24-0.5,(-34.1-43)/2,0.5>
}                   

#declare oBox9 =
object
{
   mBoxRounded(48,(43-34.1)+1,10,0.3)
   translate <0,(-34.1-43)/2,0.75>
}                   

#declare oTroneBack=
union
{
   object{oCircleArrayBackCurl}
   object{oSineArrayCircle1 texture{tTroneBottom}}
   object{oSineArrayStraight1 texture{tTroneBottom}}
   object{oShape1Circle}
   object{oShape1Straights}
   object{oSphereCircle1}            
   object{oSphereStraight1}      
   object{oInnerTorus}
   object{oInnerCylinders}    

   object{oSineArrayCircle2a texture{tTroneBottom}}
   object{oSineArrayStraight2a texture{tTroneBottom}}

   object{oEdelStoneCircle2}   
   object{oEdelStoneStraight2a}
   object{oEdelStoneStraight2b}


   object{oOuterTorus texture{tTroneBottom}}
   object{oOuterCylinders texture{tTroneBottom}}    
  
   object{oBackSeat texture{tBackSeat}}
   object{oBox1}
   object{oCurveBottomArray1 texture{tTroneBottom}}                  
   object{oCurveBottomArray2 texture{tTroneBottom}}                  
   object{oBox2}     
   object{oBox3}
   object{oBox4}
   object{oCurveBottomArray3 texture{tTroneBottom}}                  
   object {oBox5 texture{tTroneBottom}}
   object {oBox6 texture{tTroneBottom}}
   object {oBox7 texture{tTroneBottom}}
   object {oBox8 texture{tTroneBottom}}
   object {oBox9 texture{tTroneBottom}}         
   
   translate <0,43.5,0>
   
   texture{tTroneBack}
}
