#include "ganesha_3ds_objects_pilaar.inc"
#include "macros.inc"   

#declare tChain =
texture
{
   pigment
   {
      color rgb<1,1.05,0.7>
//      color rgb <0.55,0.55,0.55>
   }                   
   finish
   {               
      reflection 0.37
      phong .9
      phong_size 200
   }
}

#declare tPilaar =
texture 
{
   pigment
   { 
      marble
      turbulence 1.1
      color_map          
      {  
         [0 color rgb <0.6,0.6,0.65>] 
         [0.05 color rgb <0.76,0.90,0.7>]
         [0.1 color rgb <0.76,0.90,0.9>]      
         [0.2 color rgb <0.9,0.9,0.9>]
         [1 color rgb <0.9,0.9,1>]
      }
   }
   finish
   {  
      ambient 0.2 
      diffuse 0.7 
      crand 0.02  
      reflection 0.25   
      phong 0.7
      phong_size 100
   }      
   scale <1, 3, 2> 
   rotate <0, 0, -30>
   scale 0.8
}

#declare oLeaf = 
object
{
   maxLeaf
   rotate <90,0,0>
   rotate <0,0,180>  
   rotate <55,0,0>
   translate <0,0,-4.5>
}                
      
#declare oLeafRingMain =
union
{
   #declare iCounter = 0;
   #while (iCounter < 12)
      object
      {
         oLeaf
         rotate <0,iCounter*360/12,0>
      }
      #declare iCounter = iCounter + 1;
   #end
}

#declare oLeafSmall =
object
{
   oLeaf
   translate <0,0,0.2>
   scale <0.6,1,1>
   rotate <0,0.5*360/12,0>
}

#declare oLeafRingSub =
union
{
   #declare iCounter = 0;
   #while (iCounter < 12)
      object
      {
         oLeafSmall
         rotate <0,iCounter*360/12,0>
      }
      #declare iCounter = iCounter + 1;
   #end
}               
                
#declare oSphereRing =
union
{
   #declare iCounter = 0;
   #while (iCounter < 100)
      sphere
      {
         <0,.7,-3.9>, 0.13
         rotate <0,iCounter*360/100,0>         
      }
      #declare iCounter = iCounter + 1;
   #end
}               

#declare oSphereRingBetweenLeafs =
union
{
   #declare iCounter = 0;
   #while (iCounter < 12)
      sphere
      {
         <0,-0.3,-5.15>, 0.165
         rotate <0,(iCounter+0.34)*360/12,0>         
      }
      sphere
      {
         <0,-0.3,-5.15>, 0.165
         rotate <0,(iCounter+1-0.34)*360/12,0>         
      }
      #declare iCounter = iCounter + 1;
   #end
}               

#declare oCylinderBottom = mCylinderRounded(2.5,5.55,0.14)
#declare oCylinderBottom =
object
{
   oCylinderBottom
   translate <0,-2.9,0>
}
                
#declare oPilaarLathe=
object 
{
   maxPilaarLathe
   rotate <180,0,0>  
   translate <0.336,0.29,-0.059>
   scale 8.9
}

#declare oCylinderBended=
object 
{
   maxCylinderBended
   scale 8.9
   rotate <180,0,0>  
   translate <-1.414,12.79,-0.059>
}

#declare oCylinderBendedRing=
union
{
   #declare iCounter = 0;
   #while (iCounter < 17)
      object
      {
         oCylinderBended
         rotate <0,iCounter*360/17,0>
      }
      #declare iCounter = iCounter + 1;
   #end
}               

#declare oCylinderMain =
cylinder
{
   <0,10.2,0>,<0,33,0>,2.7
}                    

#declare oCylinderSub1 =
cylinder
{
   <0,33,0>,<0,37,0>,3.05
}                    

#declare oTorusPilaar1=
torus
{
   2.7, .3  
   translate <0,10.2,0>
}

#declare oTorusPilaar2=
torus
{
   3.2, .1  
   translate <0,35.5,0>
}

#declare oTorusPilaar3=
torus
{
   3.2, .13  
   translate <0,35.73,0>
}

#declare oTorusPilaar4=
torus
{
   3.1, .2  
   translate <0,37,0>
}

#declare oTorusPilaar5=
torus
{
   2.6, .18  
   translate <0,38.4,0>
}
                             
#declare oTorusPilaar6=
torus
{
   3.5, .28  
   translate <0,40.2,0>
}

#declare oSShapeWithSpheres=
object
{
   maxSShapeWithSpheres 
   rotate <0,-180,0>
   rotate <100, 0, 0>
   scale 1/100
   translate <0,29.7,-2.7>                            
}            

#declare oSShapeWithSpheresRing=
union
{
   #declare iCounter = 0;
   #while (iCounter < 14)
      object
      {
         oSShapeWithSpheres
         rotate <0,iCounter*360/14,0>
      }
      #declare iCounter = iCounter + 1;
   #end
}               
                             
#declare oGolf =
object
{
   maxGolf
   scale 1/100  
   rotate <270,180,0>
   translate <0,34,-3.1>
}
 
#declare oGolfRing=
union
{
   #declare iCounter = 0;
   #while (iCounter < 8)
      object
      {
         oGolf
         rotate <0,iCounter*360/8,0>
      }
      #declare iCounter = iCounter + 1;
   #end                       
   scale 1.1  
   translate <0,-2.95,0>   
}          
 
#declare oCylinderRing=
union
{
   #declare iCounter = 0;
   #while (iCounter < 90)
      cylinder
      {
         <3.2,35.86,0>,<3.2,36.15,0>,0.13   
         rotate <0,iCounter*360/90,0>
      }
      sphere
      {
         <3.2,36.15,0>,0.13   
         rotate <0,iCounter*360/90,0>
      }
      #declare iCounter = iCounter + 1;
   #end                       
}          

#declare oBlad =
object
{
   maxBlad
   scale 1/150 
   rotate <-60,0,0>
   translate <0,37.4,-3>
}

#declare oLeafRingMain2=
union
{
   #declare iCounter = 0;
   #while (iCounter < 12)
      object
      {
         oBlad
         rotate <0,iCounter*360/12,0>
      }
      #declare iCounter = iCounter + 1;
   #end                       
}          

#declare oLeafRingSub2=
union
{
   #declare iCounter = 0;
   #while (iCounter < 12)
      object
      {
         oBlad  
         translate <0,0,0.05>
         scale <0.6,1,1>   
         rotate <0,(iCounter+0.5)*360/12,0>
      }
      #declare iCounter = iCounter + 1;
   #end                       
}      

#declare oConePilaar1 =
cone
{
   <0,38.6,0>,2.8,<0,39.1,0>,3.5
}                

#declare oCylinderSub2 =
cylinder
{
   <0,39.1,0>,<0,41.2,0>,3.5
}                         

#declare oLeaf3=
object
{
   maxLeaf
   scale 0.6      
   rotate <90,0,0>
   rotate <0,0,180>  
   translate <0,41.1,-3.5>
}

#declare oLeafRing3=
union
{
   #declare iCounter = 0;
   #while (iCounter < 17)
      object
      {
         oLeaf3  
         rotate <0,(iCounter+0.5)*360/17,0>
      }
      #declare iCounter = iCounter + 1;
   #end                       
}                        

#declare oTorusCarved=
difference
{     
   torus
   {
      3.5 .28
      scale <1,1.5,1>  
      translate <0,1.5*.28,0>
   }
   difference
   {
      cylinder
      {
         <0,.28,0>,<0,0.56,0>,4
      }                        
      cylinder
      {
         <0,0,0>,<0,1,0>,3.6
      }
   }
   translate <0,41.55,0>
}

#declare oConePilaar2 =
cone
{
   <0,42.4,0>,3.6,<0,42.9,0>,4.3
}                

#declare oCylinderSub3 =
cylinder
{
   <0,42.9,0>,<0,44.5,0>,4.3
}                    

#declare oCylinderSub4 =
cylinder
{
   <0,42.9,0>,<0,44.7,0>,4.1
}                    

#declare oTorusPilaar7=
torus
{                      
   4.1, 0.2
   translate <0,44.5,0>              
}     

#declare oCylinderCarved=
difference
{
   cylinder 
   {
      <0,44.6,0>,<0,45.8,0>,3.65
   }
   torus
   {
      3.65, 0.4
      translate <0,44.7+.4,0>      
   }
}

#declare oChain = 
union
{
   #declare iCounter = 0;
   #while (iCounter < 160)
      sphere
      {
         <4.4,0,0>,.13
         translate <0,43.25,0>
         translate <0,pow((mod(iCounter,20)/14)-20/28,2)*2,0>
         rotate <0,(iCounter+0.5)*360/160,0>
      }
      #declare iCounter = iCounter + 1;
   #end                              
   texture
   {
      tChain
   }
}                        

#declare oSting = 
union
{
   #declare iCounter = 0;
   #while (iCounter < 8)
      box
      {  
         <-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
         scale .4
         rotate <0,45,0>
         rotate <45,0,0>
         scale <1,1,1.3>
         translate <0,43.3,-4.2>
         rotate <0,(iCounter)*360/8,0>
      }
      #declare iCounter = iCounter + 1;
   #end                              
}                        
                    
#declare oLoftedLeaf =
object
{
    maxLoftedLeaf
    scale 1/90     
    rotate <-90,90,0>
    translate <0,46.3,-5>
}

                    
                    
#declare oLoftedLeafRing = 
union
{
   #declare iCounter = 0;
   #while (iCounter < 22)
      object
      {
         oLoftedLeaf
         rotate <0,(iCounter)*360/22,0>
      }
      #declare iCounter = iCounter + 1;
   #end                              
}                  

#declare oRoundedBoxPilaar1 = mBoxRounded(11.8,1.2,11.8,.15)
#declare oRoundedBoxPilaar1 = 
object
{
   oRoundedBoxPilaar1
   translate <0,47.4,0> 
}      

#declare oRoundedBoxPilaar2 = mBoxRounded(6,2.5,2.5,.1)
#declare oRoundedBoxPilaar2 = 
object
{
   oRoundedBoxPilaar2
   translate <0,48.6,0> 
}     

#declare oCurlMain =
object
{
   maxCurlMain
   scale 1/13
   rotate <-90,0,0>
   translate <10.65,54.7,.25>
   scale <1,1,-1>   
}      

#declare oCurlSub1 =
object
{
   maxCurlSub1
   scale 1/30
   rotate <-90,0,0>
   scale <1,1,-1> 
   rotate <0,0,8>
   translate <15.5,58,-.5>
}

#declare oPilaarPlane1 = 
box
{
   <-12.3/2,47.4+1.2/2,0>,<12.3/2+.3,61,0>
}

#declare oPilaarPlane2 = 
box
{
   <-12.3/2,47.4+1.2/2+.7,0>,<12.3/2+1.5,55,0>
}         

#declare oFlowerAtPilaar =
object
{
   maxFlowerAtPilaar
   scale 1/125
   rotate <-90,0,0>
   translate <-1,55.75,-.8>
}                  

#declare oCandle1 = 
object
{                     
   maxCandle1
   scale 1/85
   rotate <-90,0,0>
   scale <1,0.8,1>
   translate <23.25,58.2,0>
}                             

#declare oCandle1Torus = 
torus
{
   4.5,.44
   scale <1,2,1>
   translate <0,0.44,0>
   translate <23.55,60,0>
}


#declare oPilaar = 
union
{
   object {oPilaarLathe}     
   object {oGolfRing texture {tChain}}
   object {oLeafRingMain texture {tChain}}               
   object {oLeafRingSub texture {tChain}}    
   object {oCylinderBendedRing}
   object {oSShapeWithSpheresRing}
   object {oLeafRingMain2 texture {tChain}}
   object {oLeafRingSub2 texture {tChain}}
   object {oLeafRing3}
   object {oLoftedLeafRing texture {tChain}}
   object {oFlowerAtPilaar texture {tChain}}
   object {oCurlMain}                  
   object {oCurlSub1}
   object {oCandle1} 
 
   object {oCandle1Torus}
   object {oSphereRing}
   object {oSphereRingBetweenLeafs}
   object {oTorusPilaar1}
   object {oCylinderSub1}
   object {oTorusPilaar2}
   object {oTorusPilaar3}
   object {oTorusPilaar4}
   object {oCylinderRing}
   object {oTorusPilaar5}   
   object {oTorusPilaar6}
   object {oConePilaar1}
   object {oCylinderSub2}     
   object {oTorusCarved}
   object {oConePilaar2}
   object {oCylinderSub3} 
   object {oCylinderSub4}
   object {oTorusPilaar7}            
   object {oChain}             
   object {oSting}    
   object {oCylinderCarved}
   object {oCylinderBottom}  
   object {oCylinderMain} 
   object {oRoundedBoxPilaar1}
   object {oRoundedBoxPilaar2}
   object {oPilaarPlane1}
   object {oPilaarPlane2}
}