// Persistence of Vision Ray Tracer Scene Description File
// File: Placement.pov
// Vers: 3.1
// Desc: Testing weapon placement for manifest 
// Date: 17 Jan 2000 
// Auth: Gail Shaw

#version unofficial megapov 0.6;

#declare Testing=0;

#include "Manifest.inc" 
#include "kneeling.inc"

camera {
 location <1.05,1.55,-6.2>
 look_at <-0.75,1.0,0>
 angle 40
}

light_source {
 <2,2.9,-2>
 White*0.25  
 fade_distance 5
 fade_power 2
}

light_source {
 <-2,2.9,-2>
 White*0.25
 fade_distance 5
 fade_power 2
}

plane {
 y,0
 pigment {White}
}

box {
 <-2.6,-0.1,1.5>,<2.6,3.5,1.6>
 pigment {rgb <0.5,0.5,1>}
}

box {
 <-2.6,-0.1,1.6>,<-2.5,3.5,-5>      
 pigment {Red}
}

box {
 <2.6,-0.1,1.6>,<2.5,3.5,-5>      
 pigment {Red}
}

box {
 <-2.6,3.625,1.6>,<2.6,3.7,-5>
 pigment {rgb <0.9,0.9,1>}
}
/*
cylinder {
 <-1.25,0,0>,<-1.25,2.25,0>,0.2
 pigment {White}
}

torus {
 0.2,0.02
 translate <-1.25,2.25,0>
 pigment {White}
}

cylinder {
 <-1.25,0,-1.25>,<-1.25,2.25,-1.25>,0.2
 pigment {White}
}

torus {
 0.2,0.02
 translate <-1.25,2.25,-1.25>
 pigment {White}
}

cylinder {
 <-1.25,0,-2.5>,<-1.25,2.25,-2.5>,0.2
 pigment {White}
}

cylinder {
 <1.25,0,0>,<1.25,2.25,0>,0.2
 pigment {White}
}

cylinder {
 <1.25,0,-1.25>,<1.25,2.25,-1.25>,0.2
 pigment {White}
}

cylinder {
 <1.25,0,-2.5>,<1.25,2.25,-2.5>,0.2
 pigment {White}
}

object {
 HalfTorus(1.25,0.2)
 rotate y*-90
 rotate x*-90
 translate <0,2.25,0>
 pigment {White}
}

object {
 HalfTorus(1.25,0.2)
 rotate y*-90
 rotate x*-90
 translate <0,2.25,-1.25>
 pigment {White}
}

object {
 HalfTorus(1.25,0.2)
 rotate y*-90
 rotate x*-90   
 translate <0,2.25,-2.5>
 pigment {White}
}   

object {
 HalfTorus(1.25,0.2)
 rotate z*90
 translate <-1.25,2.25,-1.25>
 pigment {White}
}

object {
 HalfTorus(1.25,0.2)
 rotate z*90
 translate <-1.25,2.25,-2.5>
 pigment {White}
}*/

// weapons

union {
 object {SwordBlade rotate x*90 scale <0.0075,0.015,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt2 scale <1.1,1,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard4 texture {T_Gold_2D} }
 object {Pommel3 scale <1.1,1,0.85> translate y*0.21 texture {T_Gold_2D}} // was translate y*0.21
 texture {BladeTex}  
 scale 1.2
 rotate z*45 
 translate <0.7,1.2,1.46>
}

union {
 object {SwordBlade rotate x*90 scale <0.005,0.013,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt3 scale <1.1,0.75,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard5 texture {T_Gold_2D} }
 object {Pommel4 scale <1.1,1,0.85> translate y*0.17 texture {T_Gold_2D}} // was translate y*0.21
 texture {BladeTex}
 scale 1.2
 rotate z*-45 
 translate <1.3,1.2,1.48>
}

object {
 RoundMetalShield 
 texture {
  T_Silver_5C 
  normal{granite 1 scale 0.2}
 } 
 rotate x*2
 translate <1,0.8,1.44>
}

union {
 object {WaveBlade rotate z*-90 scale <-0.03,0.04,0.03> }
 object {Hilt1 scale <1.1,0.9,0.85> texture{Leather2}}
 object {Guard6 scale <1,1.1,1> texture {T_Copper_3D}}
 object {Pommel2 translate y*0.2 texture {T_Copper_3D}} 
 texture {BladeTex}
 scale 1.2
 rotate z*45
 translate <-1.5,1.2,1.48>
} 

union {
 object {SwordBlade rotate x*90 scale <0.0075,0.015,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt3 scale <1.1,1,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard3 texture {T_Gold_4D} }
 object {Pommel4 scale <1.1,1,0.85> translate y*0.21 texture {T_Gold_4D}} // was translate y*0.21
 texture {BladeTex} 
 scale 1.2
 rotate z*-45
 translate <-0.9,1.2,1.46>
}

union {
 object {WoodenShield texture {T_Chrome_2B}}
 object {Arrow rotate x*-20 translate <0.1,-0.15,0> pigment {Tan4}}
 object {Arrow rotate x*-5 rotate y*15 translate <-0.1,-0.05,0> pigment {Tan4}}
 translate <-1.2,0.75,1.44>
}

union {
 object {AxeHead1 translate y*0.77 texture {BladeTex}}
 object {Handle1 scale <1,0.85,1> texture {T_DarkWood scale 0.1}}
 rotate z*45
 rotate y*90
 translate <-2.4,0.4,-1.48>
}

union {
 object {AxeHead2 scale <1,1,1> translate y*0.77 texture {BladeTex}}
 object {Handle1 scale <1,0.85,1> texture {T_DarkWood scale 0.1}}
 rotate z*45
 rotate y*90
 translate <-2.4,0.4,-1.48>
}

object {
 Naginata
 rotate z*20
 translate <0.3,0,1.48>
} 

union {
 object {SpearHead2 texture {BladeTex} translate y*1.5}
 cylinder {
  <0,0,0>,<0,1.5,0>,0.025
  texture{T_LightWood scale 0.02}
 }
 rotate z*-20
 translate <-0.3,0,1.48>
}

object {
 KiteShield       
 scale 1.25
 rotate y*90
 translate <-2.35,0.4,-1.48>
} 

/*
object {
 TowerShield
 scale 1.25
 translate <1.96,0.1,1.48>
}

union {
 object {SpearHead2 texture {BladeTex} translate y*1.5}
 cylinder {
  <0,0,0>,<0,1.5,0>,0.025
  texture{T_LightWood scale 0.02}
 }
 translate <-1.4,0,1.49>
}

union {
 object {SpearHead1 texture {BladeTex} translate y*1.5}
 cylinder {
  <0,0,0>,<0,1.5,0>,0.025
  texture{T_LightWood scale 0.02}
 }
 translate <1.4,0,1.49>
}*/

union {
 object {SwordBlade rotate x*90 scale <0.0075,0.015,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt3 scale <1.1,1,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard3 texture {T_Gold_4D} }
 object {Pommel4 scale <1.1,1,0.85> translate y*0.21 texture {T_Gold_4D}} // was translate y*0.21
 texture {BladeTex} 
 rotate x*-88
 rotate y*-15
 translate <-2.0,0.02,-1.9>
} 