// Persistence of Vision Ray Tracer Scene Description File
// File: Manifest.pov
// Vers: 3.1
// Desc: God of war appears to his priests 
// Date: 8 Jan 2001 
// Auth: Gail Shaw

#version unofficial MegaPov 0.6;  

#declare Testing=0;
#declare Final=1;
#declare ShowWeapons=1;
#declare ShowAltar=1;    
#declare ShowAvatar=1;
#declare ShowColumns=1;
#declare ShowBricks=1;   
#declare ShowPeople=1;
 
#include "kolors.inc"
#include "ManifestTex.inc"  
//#include "macros.inc" 
#include "manifest.inc"   
 
global_settings { 
 assumed_gamma 1.0 
 #if (Final=1)
  max_trace_level 35
 #else
  max_trace_level 12
 #end
 //ambient_light rgb <1,1,1>
} 
 
camera {
 location <1.05,1.65,-6.2>
 look_at <-0.8,0.9,0>
 angle 40
}

/*light_source {
 <2,2.5,0>
 White*0.25  
 fade_distance 5
 fade_power 2
}

light_source {
 <-2,2.5,0>
 White*0.25
 fade_distance 5
 fade_power 2
}


light_source {
 <2,2.5,-2>
 White*0.25  
 fade_distance 5
 fade_power 2
}

light_source {
 <-2,2.5,-2>
 White*0.25
 fade_distance 5
 fade_power 2
}*/

object {Lamp translate <2.25,0,0>}
object {Lamp translate <-2.25,0,0>}
object {Lamp translate <2.25,0,-2>}
object {Lamp translate <-2.25,0,-2>}

light_source {
 <0,2.5,-4>
 White*0.15
 fade_distance 5
 fade_power 2
} 

plane {
 y,0
 texture {
  Black_Granite 
  finish {reflection 0.2}
  scale 0.1
 }
}   

#macro BrickFunc()
 function {x^8+y^8+z^8 - 0.7 - F_Granite((x+(rand(rnd)-0.5)*500)*0.75,(y+(rand(rnd)-0.5)*500)*0.75,(z+(rand(rnd)-0.5)*500)*0.75)*2.5}//+
#end

#macro BrickObj()
 isosurface {                                                
  function {x^8+y^8+z^8 - 1 }// - F_Granite(x*0.75,y*0.75,z*0.75)*2.5}//+(rand(rnd)-0.5)*500
  //BrickFunc()
  threshold 0
  //method 1
  method 2
  max_gradient 165
  //eval
  contained_by {box {-1.5,1.5}} 
  texture {
   BrickTextureArray[floor(rand(rnd)*4)]
   normal {granite 1.5 scale 0.75}
  }
 }
#end

#if (ShowBricks=1)

 union {
  #declare Up=0;
  #while (Up<11)
   #declare Along=0;
   #while (Along<13)
    object {
    BrickObj() 
     scale <0.2,0.1,0.1>*0.95 
     translate <Along*0.4,0.1+0.2*Up,0>   
    }
    #declare Along=Along+1;
   #end      
   #declare Up=Up+1;
   #declare Along=0;
   #while (Along<12)
    object {
     BrickObj() 
     scale <0.2,0.1,0.1>*0.95 
     translate <Along*0.4+0.2,0.1+0.2*Up,0>   
    }
    #declare Along=Along+1;
   #end
   #declare Up=Up+1;
  #end                  
  box {
   <-0.2,-0.1,-0.075>,<4.9,3,0.075>
   texture {Mortar}
  }
  translate <-2.4,0.01,1.6>
 }
 union {
  #declare Up=0;
  #while (Up<11)
   #declare Along=0;
   #while (Along<12)
    object {
     BrickObj() 
     scale <0.1,0.1,0.2>*0.95 
     translate <0,0.1+0.2*Up,-Along*0.4-0.2>
    }
    #declare Along=Along+1;
   #end      
   #declare Up=Up+1;
   #declare Along=0;
   #while (Along<13)
    object {
     BrickObj() 
     scale <0.1,0.1,0.2>*0.95 
     translate <0,0.1+0.2*Up,-Along*0.4>
    }
    #declare Along=Along+1;
   #end
   #declare Up=Up+1;
  #end
  box {
   <-0.075,-0.1,-5>,<0.075,3,-0.2>
   texture {Mortar}
  }
  translate <-2.5,0.01,1.45>
 } 
 union {
  #declare Up=0;
  #while (Up<11)
   #declare Along=0;
   #while (Along<12)
    object {
     BrickObj() 
     scale <0.1,0.1,0.2>*0.95 
     translate <0,0.1+0.2*Up,-Along*0.4-0.2>
    }
    #declare Along=Along+1;
   #end      
   #declare Up=Up+1;
  #declare Along=0;
   #while (Along<13)
    object {
     BrickObj() 
     scale <0.1,0.1,0.2>*0.95 
     translate <0,0.1+0.2*Up,-Along*0.4>
    }
    #declare Along=Along+1;
   #end
   #declare Up=Up+1;
  #end               
  box {
   <-0.075,-0.1,-5>,<0.075,3,-0.2>
   texture {Mortar}
  }
  translate <2.5,0.01,1.45>
 }
#else
 box {
  <-0.075,-0.1,-5>,<0.075,3,-0.2>
  texture {Mortar}             
  translate <2.5,0.01,1.45>
 }     
 box {
  <-0.075,-0.1,-5>,<0.075,3,-0.2>
  texture {Mortar}
  translate <-2.5,0.01,1.45>
 }
 box {
  <-0.2,-0.1,-0.075>,<4.9,3,0.075>
  texture {Mortar}         
  translate <-2.4,0.01,1.6>
 }                         
#end // ShowBricks

// testing
#if (Testing=1)
 box {
  <-2.5,1.5,1.49>,<2.5,1.51,1.52>
  pigment {Red}
 }
#end

box {
 <-2.5,2.225,1.5>,<2.5,3.75,1.7>
 texture {
  Black_Granite2 
  scale 0.1
 }
}

box {
 <-2.5,2.225,-5>,<-2.4,3.75,1.7>
 texture {
  Black_Granite2 
  scale 0.1
 }
}

box {
 <2.5,2.225,-5>,<2.4,3.75,1.7>
 texture {
  Black_Granite2 
  scale 0.1
 }
}

union {
 object {
  Knots
  translate <-0.75,3.7,1.5>
 }
 object {
  Knots
  translate <-2.3,3.7,1.5>
 }               
 object {
  Knots
  translate <0.8,3.7,1.5>
 }                                
 object {
  Knots
  rotate y*90
  translate <-2.4,3.7,1.4>
 }
 object {
  Knots
  rotate y*90
  translate <-2.4,3.7,-0.15>
 }                          
 object {
  Knots
  rotate y*90
  translate <-2.4,3.7,-1.7>
 }                         
 object {
  Knots
  rotate y*90
  translate <-2.4,3.7,-3.25>
 }
 texture {Black_Granite2 scale 0.1}
 //pigment {Red}
}
 

#if (ShowColumns=1)
 union {
  object {Column translate <-1.25,0,0>}
  object {Column translate <1.25,0,0>}                        
  object {Column translate <-1.25,0,-1.25>}
  object {Column translate <1.25,0,-1.25>}
  object {Column translate <-1.25,0,-2.5>}                                    
  object {Column translate <1.25,0,-2.5>}
  object {Arch translate <-1.25,0,-1.25>}
  object {Arch translate <1.25,0,-1.25>}
  object {Arch rotate y*90}
  object {Arch rotate y*90 translate <0,0,-1.25>}
  object {Arch rotate y*90 translate <0,0,-2.5>}
  texture {
   Black_Granite
   scale 0.1
  }                          
 }
#end

#if (ShowAltar=1)

 object {Altar}
 
#end

#if (ShowAvatar=1)
 
 object {Avatar scale 0.7 translate y*1.5 no_shadow}   
 object {AvatarFlame translate y*1.25}     
 light_source {
  <0,1.25,0>
  rgb <1,0.7,0>*0.15
  fade_distance 5
  fade_power 2
 }
                 
#end
                 
// weapons

#if (ShowWeapons=1)

union {
 object {SwordBlade rotate x*90 scale <0.0075,0.015,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt2 scale <1.1,1,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard4 texture {T_Gold_2D} }
 object {Pommel3 scale <1.1,1,0.85> translate y*0.21 texture {T_Gold_2D}} // was translate y*0.21
 texture {BladeTex}  
 scale 1.2
 rotate z*45 
 translate <0.7,1.2,1.46>
}

union {
 object {SwordBlade rotate x*90 scale <0.005,0.013,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt3 scale <1.1,0.75,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard5 texture {T_Gold_2D} }
 object {Pommel4 scale <1.1,1,0.85> translate y*0.17 texture {T_Gold_2D}} // was translate y*0.21
 texture {BladeTex}
 scale 1.2
 rotate z*-45 
 translate <1.3,1.2,1.48>
}

object {
 RoundMetalShield 
 texture {
  T_Silver_5C 
  normal{granite 1 scale 0.2}
 } 
 rotate x*2
 translate <1,0.8,1.44>
}

union {
 object {WaveBlade rotate z*-90 scale <-0.03,0.04,0.03> }
 object {Hilt1 scale <1.1,0.9,0.85> texture{Leather2}}
 object {Guard6 scale <1,1.1,1> texture {T_Copper_3D}}
 object {Pommel2 translate y*0.2 texture {T_Copper_3D}} 
 texture {BladeTex}
 scale 1.2
 rotate z*45
 translate <-1.5,1.2,1.48>
} 

union {
 object {SwordBlade rotate x*90 scale <0.0075,0.015,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt3 scale <1.1,1,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard3 texture {T_Gold_4D} }
 object {Pommel4 scale <1.1,1,0.85> translate y*0.21 texture {T_Gold_4D}} // was translate y*0.21
 texture {BladeTex} 
 scale 1.2
 rotate z*-45
 translate <-0.9,1.2,1.46>
}

union {
 object {WoodenShield texture {T_Chrome_2B}}
 object {Arrow rotate x*-20 translate <0.1,-0.15,0> pigment {Tan4}}
 object {Arrow rotate x*-5 rotate y*15 translate <-0.1,-0.05,0> pigment {Tan4}}
 translate <-1.2,0.75,1.44>
}

union {
 object {AxeHead1 translate y*0.77 texture {BladeTex}}
 object {Handle1 scale <1,0.85,1> texture {T_DarkWood scale 0.1}}
 rotate z*45
 rotate y*90
 translate <-2.4,0.4,-1.95>
}

union {
 object {AxeHead2 scale <1,1,1> translate y*0.77 texture {BladeTex}}
 object {Handle1 scale <1,0.85,1> texture {T_DarkWood scale 0.1}}
 rotate z*-45
 rotate y*90
 translate <-2.4,0.4,-1.95>
}

object {
 Naginata
 rotate z*20
 translate <0.3,0.1,1.48>
} 

union {
 object {SpearHead2 texture {BladeTex} translate y*1.5}
 cylinder {
  <0,0,0>,<0,1.5,0>,0.025
  texture{T_LightWood scale 0.02}
 }
 rotate z*-20
 translate <-0.3,0.1,1.48>
}

/*object {
 KiteShield       
 scale 1.25
 rotate y*90
 translate <-2.35,0.4,-1.48>
} 


object {
 TowerShield
 scale 1.25
 translate <1.96,0.1,1.48>
}

union {
 object {SpearHead2 texture {BladeTex} translate y*1.5}
 cylinder {
  <0,0,0>,<0,1.5,0>,0.025
  texture{T_LightWood scale 0.02}
 }
 translate <-1.4,0,1.49>
}

union {
 object {SpearHead1 texture {BladeTex} translate y*1.5}
 cylinder {
  <0,0,0>,<0,1.5,0>,0.025
  texture{T_LightWood scale 0.02}
 }
 translate <1.4,0,1.49>
}

union {
 object {SwordBlade rotate x*90 scale <0.0075,0.015,0.008> translate y*-0.54} // was x scale by 0.075
 object {Hilt3 scale <1.1,1,0.85> pigment {Brown*1.1}}    // was y scaled 1
 object {Guard3 texture {T_Gold_4D} }
 object {Pommel4 scale <1.1,1,0.85> translate y*0.21 texture {T_Gold_4D}} // was translate y*0.21
 texture {BladeTex} 
 rotate x*-88
 rotate y*-15
 translate <-2.0,0.02,-1.9>
}*/

#end

#if (ShowPeople=1)

object { Junior scale 2.4 rotate x*5 rotate y*135 translate <-1,0,-2.5>}

object { 
 Loincloth
 scale 0.1/4.5*2.4          
 rotate y*90     
 rotate z*90
 rotate x*5
 rotate y*135
 translate <-1,0,-2.5> 
}

object { KneelingPriest scale 2.4 rotate x*5 rotate y*25 translate <1.12,0,-1.75>}

/*object {
 Crown 
 scale 0.1/4.5*2.4*<1,1,-1>
 rotate y*90   
 rotate x*5                          
 
 rotate y*25 
 translate <1.12,0,-1.75>  
 texture{T_Silver_4E}
}*/  

object {
 Bracelet
 scale 0.1/4.5*2.4*<1,1,-1>
 rotate y*90
 rotate x*5 
 rotate y*25 
 translate <1.12,0,-1.75> 
 texture{T_Silver_4E}
}  

object {Cup scale 1.1 rotate x*90 rotate y*20 translate <-0.7,0.05,-1.4> texture{T_Silver_4E}}

height_field {
 png "Watersplash.png"
 scale <0.75,0.01,1>   
 rotate y*20
 translate <-0.71,-0.001,-1.37>
 pigment {rgbf<0.8,0,0,0.5>}
 finish {specular 0.8 roughness 0.002 reflection_min 0.0 reflection_max 0.4}
}

#end