//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 22 materials and 137 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 02/19/2000    (19.02.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.3 Beta For Windows.

*/ // End Scene Comment


// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     35.000,    -111.588,      34.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.36548,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         45.00000    // Vertical      33.750
  look_at   <     35.000,      24.000,      34.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera02
  location  <      9.507,     -29.706,      30.371>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     11.304,      24.552,      25.187>
}

*/

//
// *******  L I G H T S *******
//

/*light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate   <3.147737, -132.336588, 16.927407>
}

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <147.098657, -52.677882, 88.129195>
}                            */
  

//
// ********  MATERIALS  *******
//

#include "textures.inc"



// Scene Includes

#include "teclado.inc"
#include "escritorio.inc"
#include "torre.inc"
#include "monitor.inc"
#include "farol.inc"



//
// ********  OBJECTS  *******
//


/*
plane { // Pared
  z,0
  material {
    Starfield scale 8 rotate <85,20,3>
  }
  rotate -90.0*x
  translate  <0, 70.0, 0.0>
}


plane { // Pared
  x,-10
  material {
    Starfield scale 8 rotate <93,12,54>
  }
  rotate -90.0*x
  translate  <0, 70.0, 0.0>
}
  */

object {Monitor
        rotate -15.0*z
  translate  <53.0, 20.0, 6.0>}


object {Teclado
  rotate -4.0*z
  translate  <47.0, 1.0, 1.8>
}


object {Torre}   


object {Escritorio material {Tan_Wood}}


object {farol rotate 90*x rotate 180*z scale 2.4 translate <5,62.8,53> }
object {farol rotate 90*x rotate 180*z scale 2.4 translate <90,62.8,53> }

object {farol rotate 90*x scale 2.4 translate <39,-100,53> }
object {farol rotate 90*x rotate -90*z scale 2.4 translate <-2.8,-10,53> }
object {farol rotate 90*x  rotate -90*z  scale 2.4 translate <-2.8,-50,53> }
                             


#include "skies.inc"

//sphere {0,1 material {Starfield} scale 5000 }


declare a=0;
#declare pared=union{
#while (a<20)
        box {<a*10,1,0> <a*10+10,2,200>}
        box {<a*10,0,0> <a*10+7,0,200>}
        
        #declare a=a+1;
#end
}
        

object {pared translate <-8,70,0> material {T_Wood25 rotate 0*x scale 10}}
object {pared  material {T_Wood25 rotate 0*x scale 10} rotate -90*z translate <-10,90,0>}