
// POV-Ray Object File - Mouse
// created 30-Dec-00
// last update 30-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "Mouse1.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Mouse
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare MouseTex =
	texture {
		pigment {
				color rgb <0.649,0.653,0.626>
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 0.1 diffuse 0.3 specular 0.10 roughness 0.18 }
	}


//===============================================
//             Objects
//===============================================


#declare MouseBody =
	union {
		blob {
			threshold 0.64

			component 2.4000000, 1.155834, <-0.188622, 0.909810, -0.691615>
			component 2.4000000, 1.210705, <-0.276899, 0.593354, 1.015295>
			component 2.4000000, 1.242043, <-0.224156, 0.000000, 1.938291>
			component 2.4000000, 1.264255, <-0.354107, 0.803501, 0.225341>
			component 2.4000000, 1.345674, <0.000000, 0.432654, 1.462783>
			component 2.4000000, 0.961196, <0.354107, -0.350244, 2.414365>
			component 2.4000000, 1.157433, <0.000000, 0.144218, -0.185423>
			component 2.4000000, 1.394562, <0.000000, -0.061808, 0.515065>
//			component 2.4000000, 1.282395, <-0.314370, 1.916040, -1.545194>
//			component 2.4000000, 1.074650, <-0.440119, 2.039656, -2.163271>
//			component 2.4000000, 0.735173, <-0.943111, 2.204477, -2.740144>
//			component 2.4000000, 0.339834, <-1.446104, 2.245682, -3.358221> // nose
			rotate <90,0,90>
			scale 0.6
			translate <0.8,0,0.3>
		}
		texture { MouseTex }
	} // end union

#include "MouseEar.inc"
#declare MouseEar =
	object { MouseEarShape
		scale 0.13
		texture { MouseTex }
	}

#declare MouseEye =
	sphere {
		<0,0,0>,0.15
		texture {
			pigment { color rgb<0,0,0> }
			finish { specular 1.0 roughness 0.03 }
		}
	}

#declare MouseHead =
	union {
		blob {
			threshold 0.64
			sphere { <0,0,0>,1,1 }
			sphere { <-0.7,0,0>,0.45,1 }
			sphere { <-0.9,0,0>,0.20,1 }
		}
		object {
			MouseEar
			rotate z*-90
			translate <0,0,.55>
			rotate x*30
		}
		object {
			MouseEar
			rotate z*-90
			translate <0,0,.55>
			rotate x*-30
		}
		object { MouseEye translate <-0.5,-0.3,0.1> }
		object { MouseEye translate <-0.5, 0.3,0.1> }
		texture { MouseTex }
	} // end union

#declare MouseHindLeg =
	union {
		sphere {
			<0,0,0>,0.5
			scale <1,0.37,1>
			translate <0,0,0.3>
		}
		sphere_sweep {
			b_spline_sphere_sweep
			4,
			<1,0,0>,0.22,
			<0,0,0>,0.23,
			<-1.5,-0.2,0>,0.12
			<-2,-0.3,0>,0.06
			translate <0.1,0.1,0.1>
		}
		texture { MouseTex }
	}			

#declare MouseForeLeg =
	sphere_sweep {
		b_spline_sphere_sweep
		5,
		<0.5,0,0>,0.20
		<0,0,0>,0.17
		<-0.2,-0.14,-0.04>,0.16
		<-0.35,-0.08,-0.09>,0.14
		<-0.45,-0.08,-0.09>,0.14
		texture { MouseTex }
	}

#declare MouseTail =
	sphere_sweep {
		b_spline_sphere_sweep
		8,
		<-1,0,0>,0.2,
		<0,0,0>,0.16,
		<0.7,0.1,0>,0.15,
		<1.3,1.8,0.2>,0.10,
		<2.2,1.6,0.35>,0.08,
		<2.7,2.4,0.6>,0.05,
		<2.9,1.6,1.1>,0.035,
		<2.8,1.2,1.5>,0.020
		texture { MouseTex }
		scale 0.8
	}

#declare Mouse =
	union {
		object { MouseBody }
		object { MouseHead rotate <6,0,-30> translate <0,0,1.6> }
		object { MouseForeLeg translate <0,-0.7,0.9> }		
		object { MouseHindLeg translate <1.1,-0.8,0> }
		object { MouseTail rotate z*-60 translate <1,0,0.2> }
	}


