
// POV-Ray Object File - Front Door
// created 18-Dec-00
// last update 30-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "FrontDoor.inc" in another .pov file
// Required #include files: "DoorMech.inc"
//
// Objects:
// WindowShade(Xlength,Pulldown)
// FrontDoorAssy
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#version unofficial MegaPov 0.6;
#include "DoorMech.inc"

//===============================================
//             Variables
//===============================================

#declare RS = seed(23769); // random seed

//===============================================
//             Textures
//===============================================

#declare ShowroomDoorTex =
	texture {
		pigment {
			color rgb <0.963,0.988,0.989>*1.00
		}
		finish { ambient 0.15 diffuse 0.6 specular 0.4 roughness 0.05 }
	}

#declare OpaqueShadeTex =
	texture {
		pigment {
//			color rgbf <0.963,0.988,0.959,0.16>*1.0 // white
			color rgbf <0.663,0.688,0.959,0.16>*1.0
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.16 roughness 0.25 }
	}
#declare TranslucentShadeInt =
	interior { ior 1.5 }
#declare TranslucentShadeTex =
	texture {
		pigment {
//			color rgbf <0.963,0.988,0.959,0.36>*1.0 // white
			color rgbf <0.663,0.688,0.959,0.36>*1.0
		}
		normal { bumps 0.8 scale 0.3 }
		finish { ambient 0.1 diffuse 0.6 specular 0.16 roughness 0.25 }
	}
#declare TranslucentShadeMat =
	material {
		texture { TranslucentShadeTex }
		interior { TranslucentShadeInt }
	}

#declare SBracketTex = // windowshade bracket
	texture {
		pigment {
			color rgb <0.963,0.988,0.959>*1.0
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.6 roughness 0.05 }
	}

#declare DoorGlassInt =
	interior { ior 1.45 }
#declare DoorGlassTex = // high quality plate glass version
	texture {
		pigment {
			color rgbt <0.90,0.96,0.92,0.96>
		}
		normal { bumps 0.015 scale 16 }
		finish { ambient 0.1 diffuse 0.1 specular 0.999 roughness 0.00001 reflection 0.03 }
	}
#declare DoorGlassMat =
	material {
		texture { DoorGlassTex }
		interior { DoorGlassInt }
	}

#declare DoorHandleBrass =
	texture {
		pigment {
			color rgb <0.659,0.486,0.125>
		}
		finish { ambient 0.1 diffuse 0.3 specular 0.92 roughness 0.025 reflection 0.4}
	}

#declare KeyHoleTex =
	texture {
		pigment { color rgb <0.04,0.04,0.06> }
		finish { ambient 0.1 diffuse 0.3 specular 0.1 roughness 0.14 }
	}

#declare DirtyXBrassTex =
	texture {
		pigment {
			gradient x
			color_map {
			[ 0.00 color rgb <0.659,0.486,0.125>*0.5 ]
			[ 0.50 color rgb <0.659,0.486,0.125>*1.4 ]
			[ 1.00 color rgb <0.659,0.486,0.125>*0.5 ]
			}
			translate <-0.5,0,0> // center light area on origin
		}
		finish { ambient 0.1 diffuse 0.3 specular 0.84 roughness 0.065 reflection 0.14}
	}
#declare DirtyOBrassTex = // kickplate
	texture {
		pigment {
			onion
			color_map {
			[ 0.00 color rgb <0.659,0.486,0.125>*1.2 ]
			[ 0.80 color rgb <0.659,0.486,0.125>*0.08 ]
			}
			scale <21,11,5>
		}
		finish { ambient 0.1 diffuse 0.3 specular 0.84 roughness 0.065
			reflection .14
			reflection_blur 0.10
			reflection_samples 25
		}

	}

#declare DoorTextTex = // upper letters
	texture {
		pigment {
//			color rgb <0.659,0.486,0.125>*0.5 // brown gold
			color rgb <0.009,0.016,0.082>*0.1 // black
		}
		finish { ambient 0.1 diffuse 0.3 specular 0.02 roughness 0.025 reflection 0 }
	}
#declare DoorText2Tex = // lower letters
	texture {
		pigment {
			color rgb <0.090,0.086,0.082>*1.0 // grey
		}
		finish { ambient 0.1 diffuse 0.3 specular 0.92 roughness 0.025 reflection 0 }
	}

//===============================================
//             Macros
//===============================================

#macro WindowShade(Xlength,Pulldown)
	union {
		cylinder { // main
			<0,0,0>,<Xlength,0,0>,0.66
			translate <0,-1,0>
			texture { OpaqueShadeTex }
		}
		box { // hanging shade
			<0,0,-Pulldown>,<Xlength,0.05,0>
			translate <0,-1-0.66,0>
			material { TranslucentShadeMat }
		}
		box { // bottom edge
			<0,0,-0.81>,<Xlength,0.18,0>
			translate <0,-1-0.66,-Pulldown>
			texture { OpaqueShadeTex }
		}
		box { // left bracket
			<-0.6,-1.3,-0.6>,<-0.3,0,0.6>
			texture { SBracketTex }
		}
		box { // right bracket
			< 0.3,-1.3,-0.6>,<0.6,0,0.6>
			translate <Xlength,0,0>
			texture { SBracketTex }
		}
		cylinder { // pull string
			<0,0,0>,<0,0,-6>,0.07
			translate <Xlength/2,0.1,-Pulldown>
			texture { OpaqueShadeTex }
		}
		torus { // pull ring
			0.64,0.11
			rotate <0,0,-30+rand(RS)*60>
			translate <Xlength/2,0.1,-Pulldown-6-0.44>
			texture { OpaqueShadeTex }
		}
	} // end union
#end



//===============================================
//             Objects
//===============================================

//--------------- Front Door --------------------

#declare FrontDoor = // XZ plane
	union {
		difference {
			box { // main
				<0.5,-0.8,0.5>,<36,0.8,7*Feet-0.2>
			}
			box { // glass cutout
				<6,-3,18>,<30,3,6.9*Feet-8>
			}
		} // end difference
		#if (WindowGlass=1)
		box { // glass
			<5,-0.06,17>,<31,0.06,6.9*Feet-7>
			material { DoorGlassMat }
		}
		#end
		object { WindowShade(30-6+2,12)
			rotate z*180
			translate <36-5,0.8,6.9*Feet-6>

		}
		texture { ShowroomDoorTex }
	} // end union

#declare FrontDoorHandle =
	union {
		difference {
			box { // main plate
				<-1.7,-0.1,0>,<1.7,0.2,12>
			}
			cylinder { <0,-0.5,0>,<0,0.5,0>,0.5 translate <-1.7,0,0> }
			cylinder { <0,-0.5,0>,<0,0.5,0>,0.5 translate < 1.7,0,0> }
			cylinder { <0,-0.5,0>,<0,0.5,0>,0.5 translate <-1.7,0,12> }
			cylinder { <0,-0.5,0>,<0,0.5,0>,0.5 translate < 1.7,0,12> }
		} // end difference
		sphere { // lever
			<0,0,0>,1
			scale <1,1.2,0.13>
			translate <0,0,9>
		}
		sphere_sweep { // handle
			b_spline_sphere_sweep, 13,
			<0, -1.3, 7.3>, 0.10 // hidden
			<0, -0.7, 6.7>, 0.30 // top
			<0, -0.3, 7.0>, 0.20 // 
			<0, -0.3, 8.5>, 0.23 // 
			<0, -1.3, 8.8>, 0.34 // 
			<0, -2.0, 8.5>, 0.38 // 
			<0, -2.3, 6.0>, 0.33 // 
			<0, -1.0, 4.0>, 0.24 // 
			<0, -0.3, 2.4>, 0.20 // 
			<0, -0.2, 1.5>, 0.18 // 
			<0, -1.0, 0.5>, 0.14 // 
			<0, -1.4, 0.7>, 0.14 // 
			<0, -1.7, 1.2>, 0.04 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
			scale <1.9,1,1>
		}
		box { // striker plate
			<-0.06,1,-1.1>,<.14,-0.8,1.1>
			translate <-3.1,0,11>
		}
		object { DoorMech rotate y*180 translate <0,0,11> }
		texture { DoorHandleBrass }
	} // end union

#declare SimpleLock =
	union {
		cone { // outer
			<0,0,0>,1.33,<0,-0.3,0>,1.05
		}
		difference {
			cone { // main
				<0,0,0>,1.2,<0,-0.7,0>,0.91
			}
			box { // keyhole
				<0,-2,0>,<.1,1,0.45>
				translate <0,0,-0.4>
				texture { KeyHoleTex }
			}
		} // end difference
		box { // striker plate
			<-0.06,1,-1.1>,<.14,-0.8,1.1>
			translate <-3.1,0,0>
		}
		texture { DoorHandleBrass }
	} // end union

#local PBL = 27.4; // push bar length
#local PBR = 0.25; // radius
#declare HalfPushBar =
	union {
		cylinder { // main
			<0,0,0>,<PBL/2,0,0>,PBR
		}
		torus { // right end
			1,PBR
			rotate x*90
			translate <PBL/2,1,0>
			clipped_by { box { <PBL/2,-1,-1>,<PBL/2+3,1,1> } }
		}
		cylinder { // right end
			<0,1,0>,<0,3,0>,PBR
			translate <PBL/2,0,0>
		}
		sphere { // base
			<0,0,0>,0.8
			scale <1,0.25,1>
			translate <PBL/2,2,0>
		}
		texture { DirtyXBrassTex scale <PBL,1,1> }
		translate <0,-2,0>
	} // end union
#declare PushBar =
	union {
		object { HalfPushBar }
		object { HalfPushBar scale <-1,1,1> }
	} // end union

#declare KickPlate =
	box {
		<-12,-0.2,-4>,<12,0,4>
		texture { DirtyOBrassTex }
		translate <18,0.9,4+2.8>
	}

#declare OpenSign =
	union {
		difference {
			box { // sign
				//sits on xy plane, at z=0
				#local ImageWidth = 9.5;
				#local ImageHeight = 6.5;
				<0,0,0>,<ImageWidth,ImageHeight,0.21>
//				texture { ShowroomDoorTex } // test
				texture {
					pigment {
							image_map { // image is always projected from -z, with front facing +z
							png "OpenSign.png"
							once
							}
					}
					finish { ambient .9 }
					scale <ImageWidth,ImageHeight,1>
				}
				rotate <90,0,0> // set upright
			}
			cylinder { // hole
				<0,-1,0>,<0,1,0>,.12
				texture { ShowroomDoorTex }
				translate <0.8,0,ImageHeight-0.5>
			}
			cylinder { // hole
				<0,-1,0>,<0,1,0>,.12
				texture { ShowroomDoorTex }
				translate <ImageWidth-0.8,0,ImageHeight-0.5>
			}
		} // end difference
		cylinder { // string
			<0,0,0>,<0,0,4.8>,0.09
			rotate <2,29,0>
			translate <0.8,0,ImageHeight-0.5>
			texture { ShowroomDoorTex }
		}
		cylinder { // string
			<0,0,0>,<0,0,5.5>,0.09
			rotate <-2,-34,0>
			translate <ImageWidth-0.8,0,ImageHeight-0.5>
			texture { ShowroomDoorTex }
		}
	} // end union


//--------------- Lettering --------------------

// Reese & Son
// GLASS
// Craftsmen
// est. 1932

// NOTE: in RH coord. system, text FRONT is extruded
// into +Z.  Text faces +Z, words extend along +X

#declare DoorText =
	union {
		text {
//			ttf "MKBP____.TTF", // brush strokes
			ttf "TEMPSITC.TTF",
//			ttf "ARIAL.TTF",

			"Reese & Son"
			0.05,     // THICKNESS_FLOAT, extruded into +Z
			0       //OFFSET_VECTOR
			align_center
			scale 3
			rotate <90,0,0>
			translate <18,-0.06,61>
		}
		text {
//			ttf "TTARTSTA.TTF", // Artistic
			ttf "ANTQUABI.TTF", // Antiqua Bold Italic
//			ttf "ARIAL.TTF",
			"Glass",
			0.05,     // THICKNESS_FLOAT, extruded into +Z
			0       //OFFSET_VECTOR
			align_center
			scale <5,5,5>
			rotate <90,0,0>
			translate <18,-0.06,55>
		}
		text {
//			ttf "ALBERTA.TTF", // chiseled caps
			ttf "TEMPSITC.TTF",
			"Craftsmen"
			0.05,     // THICKNESS_FLOAT, extruded into +Z
			0       //OFFSET_VECTOR
			align_center
			scale 3
			rotate <90,0,0>
			translate <18,-0.06,51.2>
		}
		text {
//			ttf "MKBP____.TTF", // brush strokes
			ttf "TIMESBD.TTF", // 
//			ttf "ARIAL.TTF",
//			"(c) 2000",
			"(c) 2000",
			0.05,     // THICKNESS_FLOAT, extruded into +Z
			0       //OFFSET_VECTOR
			align_center
			scale 2
			rotate <90,0,0>
			translate <18,-0.06,27>
			texture { DoorText2Tex }
		}
		text {
//			ttf "MKBP____.TTF", // brush strokes
			ttf "TIMESBD.TTF", // 
//			ttf "ARIAL.TTF",
			"G. McCarter",
			0.05,     // THICKNESS_FLOAT, extruded into +Z
			0       //OFFSET_VECTOR
			align_center
			scale 2
			rotate <90,0,0>
			translate <18,-0.06,24>
			texture { DoorText2Tex }
		}
		texture { DoorTextTex }
	} // end union


//--------------- Assemblies --------------------

#declare FrontDoorAssy =
	union {
		object { FrontDoor }
		object { KickPlate }
		object { PushBar rotate z*180 translate <18,0.8,46> }
		object { PushBar rotate z*180 translate <18,0.8,48> }
		object { PushBar rotate z*180 translate <18,0.8,50> }
		object { DoorText }
		object { OpenSign rotate z*180 rotate y*-7 translate <20,2.8,46-8.6> }
		object { SimpleLock
			translate <0,-0.8,0>
			rotate z*180
//			translate <36-3,0,52>
			translate <36-3,0,36+18>
		}
		object { FrontDoorHandle
			translate <0,-0.8,0>
			rotate z*180
			translate <36-3,0,36-5>
		}
	} // end union

