
// POV-Ray Object File - The Diorama
// created 26-Nov-00
// last update 15-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "Diorama.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// DisplayTable
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare PlainTex =
	texture {
		pigment {
			color rgb <0.97,0.90,0.92>
		}
		finish { ambient 0.1 specular 0.7 roughness 0.05 }
	}

#declare TableTex =
	texture {
		pigment {
			color rgb <0.757,0.690,0.712>
		}
		finish { ambient 0.1 specular 0.3 roughness 0.05 }
	}

#declare GlassInt =
	interior { ior 1.5 }
#declare GlassFinish = finish { ambient 0.1 specular 0.99 roughness 0.015 }

#declare LightBlueGlassColor = color rgbf <0.84,0.84,0.97,0.96>;
#declare PinkGlassColor = color rgbf <0.98,0.72,0.72,0.92>;

#macro GlassMaterial(GlassColor)
	material {
		texture {
			pigment { GlassColor }
			finish { GlassFinish }
		}
		interior { GlassInt }
	}
#end


//===============================================
//             Objects
//===============================================

#declare DisplayTable =
	union {
		box { // tabletop
			<-18,-16,-1>,<0,0,0>
			texture { TableTex }
		}
		box { // base
			<-15,-15,-60>,<-1,-1,-0.99>
			texture { TableTex }
		}
	} // end union

#declare Glass1S =
	merge {
		cylinder {
			<0,0,0>,<0,0,3>,1.1
		}
		sphere {
			<0,0,0>,1.1
			scale <1,1,0.5>
			translate <0,0,3>
		}
		GlassMaterial(LightBlueGlassColor)
	} // end merge
#declare Glass2S =
	merge {
		cylinder {
			<0,0,0>,<0,0,2.1>,0.8
		}
 		sphere {
			<0,0,0>,0.8
			scale <1,1,1>
			translate <0,0,2.1>
		}
		GlassMaterial(PinkGlassColor)
	} // end merge

#declare TinyPedestal =
	merge {
		cone {
			<0,0,0>,1.6,<0,0,1.8>,1.1
		}
 		sphere {
			<0,0,0>,1.1
			scale <1,1,.3>
			translate <0,0,1.8>
		}
		GlassMaterial(PinkGlassColor)
	} // end merge



//--------------- Standing Glassblower Figurine --------------------

// NOTE figurine is modeled full-scale, then scaled down at the end.
// Figure faces -Y

#declare FigurinePipe =
	union {
		sphere_sweep { // pipe
			b_spline_sphere_sweep, 5,
			<   0,   8, 0>, 1.0 // hidden
			<   0,  -6, 0>, 1.0 // start
			< 0.2, -30, 2>, 0.95 // middle is a little crooked
			< -.6, -50, 0>, 0.90 // end
			<   0, -60, 0>, 0.80 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere_sweep { // glass end
			b_spline_sphere_sweep, 5,
			<  0, -45, 0>, 0.8 // hidden
			<  0, -48, 0>, 1.1 // start
			<  0, -50, 1>, 2.2 // middle
			<  0, -52, 0>, 1.5 // end
			<  0, -56, 0>, 0.8 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		texture { PlainTex } // test
//		GlassMaterial(PinkGlassColor)
	} // end union

#declare StandingFigurine =
	merge {
		sphere { // base
			<0,0,0>,1.5*Feet
			scale <1,.7,.15>
			rotate z*-6
			translate <0,0,(1.5*Feet*.15)>
		}
		sphere_sweep { // his left leg and foot
			b_spline_sphere_sweep, 6,
			< 8, -9-3-3, 9>, 1.3 // hidden
			< 8, -6-3, 5>, 1.8 // foot
			< 7,  0-3, 7>, 2 // heel
			< 5, -7, 18>, 3 // knee
			< 3,  0, 32>, 4 // hip
			< 3,  0, 38>, 4 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere_sweep { // his right leg and foot
			b_spline_sphere_sweep, 6,
			<-8, -9+7-3, 9>, 1.3 // hidden
			<-8, -6+7, 5>, 1.8 // foot
			<-7,  0+7, 7>, 2 // heel
			<-5, -5+4, 18>, 3 // knee
			<-3,  0+1, 32>, 4 // hip
			<-3,  0+1, 38>, 4 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere_sweep { // torso
			b_spline_sphere_sweep, 6,
			< 0, 0, 30>, 6 // hidden
			< 0, 0, 36>, 6 // hip
			< 0, 0, 44>, 7 // midsection
			< 0, 1, 54>, 8 // shoulder
			< 0, 2, 59>, 2.5 // neck
			< 0, 2, 62>, 2.5 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
			scale <1,.6,1>
			rotate z*4
		}
		sphere_sweep { // his left arm
			b_spline_sphere_sweep, 5,
			< 8,  2, 62>, 1.8 // hidden
			< 8,  2, 55>, 3.2 // shoulder
			< 9, -7, 48>, 2.5 // elbow
			< 0, -10, 62>, 1.8 // wrist
			<-2, -12, 65>, 1.8 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere { // left hand
			<0,0,0>,4
			scale <.5,1,.7>
			rotate <-72,-23,-4>
			translate <0,-10,62>
		}
		sphere_sweep { // his right arm
			b_spline_sphere_sweep, 5,
			<-8,  -3, 62>, 1.8 // hidden
			<-8,  -2, 55>, 3.2 // shoulder
			<-9, -10, 53>, 2.5 // elbow
			<-1, -18, 65>, 1.8 // wrist
			< 2, -26, 72>, 1.8 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere { // right hand
			<0,0,0>,4
			scale <.5,1,.7>
			rotate <22,43,34>
			translate <-1,-21,66>
		}
		sphere { // head
			<0,0,0>,5
			scale <.85,1,1>
			rotate <0,10,20>
			translate <0,2,64>
		}
//		texture { PlainTex } // test
		GlassMaterial(LightBlueGlassColor)
	} // end merge

//--------------- Furnace Figurine --------------------
// NOTE figurine is modeled full-scale, then scaled down at the end.

#declare FurnaceFigurine =
	merge {
		difference {
			object { RoundedBox(.2)
				scale <36,24,64>
				translate <0,12,32> // set on ground
			}
			object { RoundedBox(.1)
				scale <12,30,16>
				translate <0,0,44>
			}
		} // end difference
//		texture { PlainTex } // test
		GlassMaterial(PinkGlassColor)
	} // end merge

//--------------- Groups --------------------

#declare FScale = 0.12;
#declare DisplayTableGroup =
	union {
		object { DisplayTable }
//		object { Glass1S translate <-8,-2,0> }

//		object { StandingFigurine rotate z*-160 scale FScale translate <-5,-15,0> }
//		object { FigurinePipe rotate <-5,0,-3> translate <0,4,62> rotate z*-160 scale FScale translate <-5,-15,0> }
//		object { FurnaceFigurine rotate <0,0,0> translate <0,7*Feet,0> scale FScale translate <-5,-15,0> }
		object { StandingFigurine rotate z*-100 scale FScale translate <-5,-5,2> }
		object { FigurinePipe rotate <-5,0,-3> translate <0,4,62> rotate z*-100 scale FScale translate <-5,-5,2> }
		object { TinyPedestal translate <-5,-5,0> }
//		object { FurnaceFigurine rotate <0,0,180> translate <0,-5*Feet,0> scale FScale translate <-5,-5,0> }

		object { Glass2S translate <-12,-3,0> }
		object { Glass2S translate <-11,-12,0> }
	}
