
// POV-Ray Object File - Outside Buildings
// created 16-Dec-00
// last update 31-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "Buildings.inc" in another .pov file
// Required #include files: ("Shop.inc")
//
// Objects:
// NextBuilding
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================

#declare RS = seed(18163); // random seed


//===============================================
//             Textures
//===============================================

//--------------- Extra copies from other files --------------------

#declare ConcreteTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 color rgb <0.651,0.643,0.592> ]
				[ 0.5 color rgb <0.651,0.643,0.592>*.4 ]
				[ 1.0 color rgb <0.651,0.643,0.592> ]
			}
			scale .2
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.06 roughness 0.11 }
	}


#declare PlatformBoardTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.00 color rgb <0.361,0.329,0.306> ]
				[ 0.50 color rgb <0.361,0.329,0.306>*.6 ]
				[ 1.00 color rgb <0.361,0.329,0.306> ]
			}
			scale <60,60,1>
		}
		normal { bumps 0.2 scale 19 }
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.08 }
	}

#declare BrickWallTex =
	texture {
		pigment {
			brick
				color rgb <0.812,0.776,0.718> // mortar
//				color rgb <0.553,0.204,0.180> // red brick
				color rgb <0.253,0.204,0.180> // grey brick
				brick_size <8,3,4.5>
				mortar 0.4
				rotate x*90
		}
//		normal { bumps 0.1 scale 3}
		normal {
			brick .5
			brick_size <8,3,4.5>
			mortar 0.4
			rotate x*90
		}

		finish { ambient 0.1 specular 0.1 roughness 0.08 }
	}


#declare WindowFrameTex =
	texture {
		pigment {
			color rgb <0.963,0.988,0.959>*1.0
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.6 roughness 0.05 }
	}

#declare WindowGlassInt =
	interior { ior 1.45 }
#declare WindowGlassSTex = // simple version, no reflection
	texture {
		pigment {
			color rgbf <0.9,0.9,0.9,0.96>
		}
		normal { bumps 0.035 scale 5 }
		finish { ambient 0.1 specular 0.99 roughness 0.015 }
	}
#declare WindowGlassSMat =
	material {
		texture { WindowGlassSTex }
		interior { WindowGlassInt }
	}
#declare WindowGlassTex = // better version
	texture {
		pigment {
			color rgbf <0.9,0.9,0.9,0.96>
		}
		normal { bumps 0.035 scale 5 }
		finish { ambient 0.1 specular 0.99 roughness 0.015 reflection 0.17 }
	}
#declare WindowGlassMat =
	material {
		texture { WindowGlassTex }
		interior { WindowGlassInt }
	}
#declare ClearGlassTex = // high quality plate glass version
	texture {
		pigment {
			color rgbf <0.9,0.9,0.9,0.986>
		}
		normal { bumps 0.015 scale 16 }
		finish { ambient 0.1 specular 0.99 roughness 0.010 reflection 0.07 }
	}
#declare ClearGlassMat =
	material {
		texture { ClearGlassTex }
		interior { WindowGlassInt }
	}

//--------------- Original Textures --------------------

#declare ElecPanelTex =
	texture {
		pigment { color rgb <0.882,0.878,0.902> }
		finish { ambient 0.1 diffuse 0.6 specular 0.4 roughness 0.05 }
	}

#declare SnowTex =
	texture {
		pigment { color rgb <0.8,0.8,1.0>*1.8 }
		finish { ambient <33.0,33.0,37.0> diffuse 0.3 specular .65 roughness .225 }
	}


//===============================================
//             Objects
//===============================================

#declare SideWall =
	union {
		difference {
			box { // main
				<0,0,0>,<6,40*Feet,18*Feet>
			}
			box { // small window cutout
				<-1,0,0>,<7,24,24>
				translate <0,10*Feet,6*Feet>
			}
		} // end difference
		blob { // window snow
			threshold 0.6
			sphere { <0,0,0>,5.0,1 translate <0,0,3> }
			sphere { <0,0,0>,3.6,1 translate <1,2,0> }
			sphere { <0,0,0>,4.0,1 translate <0,4,0> }
			sphere { <0,0,0>,2.2,1 translate <0,6,0.5> }
			sphere { <0,0,0>,3.2,1 translate <0,8,0> }
			sphere { <0,0,0>,2.8,1 translate <1,10,0> }
			sphere { <0,0,0>,3.6,1 translate <0,11,1> }
			sphere { <0,0,0>,4.0,1 translate <0,14,0> }
			sphere { <0,0,0>,2.2,1 translate <-0.8,16.5,1> }
			sphere { <0,0,0>,3.2,1 translate <0,18,0> }
			sphere { <0,0,0>,3.8,1 translate <0,20,1> }
			sphere { <0,0,0>,5.2,1 translate <0,24,2.3> }
			translate <1,10*Feet,6*Feet+0>
			texture { SnowTex }
		}

		// TiledWindow(Xlength,Zheight,Xpanes,Zpanes,BarThickness,Quality)
		object { TiledWindow(24,24,2,2,0.55,true)
			rotate z*90
			translate <3,10*Feet,6*Feet>
		}
		texture { BrickWallTex rotate z*90 }
	} // end union

#declare ElecPanel = // faces -Y
	union {
		box { // panel
			<0,-5,0>,<12,0,12>
		}
		blob { // panel snow
			threshold 0.6
			sphere { <0,0,0>,3,1 translate <0,0,0> }
			sphere { <0,0,0>,3.6,1 translate <2,0,0> }
			sphere { <0,0,0>,4.0,1 translate <4,0,0> }
			sphere { <0,0,0>,2.2,1 translate <6,0,0> }
			sphere { <0,0,0>,3.2,1 translate <8,0,0> }
			sphere { <0,0,0>,2.8,1 translate <10,0,0> }
//			sphere { <0,0,0>,2.8,1 translate <5,-2,-2> }
			translate <2,-3,12.5>
			texture { SnowTex }
		}
		cone { // readout
			<0,0,0>,3,<0,-4,0>,2.5
			translate <6,-5,5>
		}
		blob { // readout snow
			threshold 0.6
			sphere { <0,0,0>,4,1 translate <0,0,3.6> }
			sphere { <0,0,0>,4,1 translate <2,0,3.6-1> }
			sphere { <0,0,0>,4,1 translate <-2,0,3.6-1> }
			translate <6,-5,5>
			texture { SnowTex }
		}
		cylinder { // upper conduit
			<0,0,0>,<0,0,13*Feet>,1
			translate <9,-1.3,0>
		}	
		cylinder { // lower conduit
			<0,0,0>,<0,0,-2*Feet>,1
			translate <9,-1.3,0>
		}
		torus {
			4,1
			rotate z*90
			clipped_by { box { <-3,-8,-8>,<3,0,0> } }
			translate <9,-1.3+4,-2*Feet>
		}
		blob {
			threshold 0.6
			sphere { <0,0,0>,1,1 }
			sphere { <0,0,0>,1,1 translate <0,0,0> }
		}
		texture { ElecPanelTex }	
	} // end union





//===============================================
//             Other Stuff
//===============================================




//===============================================
//             Assemblies
//===============================================


#declare NextBuilding =
	union {
		object { SideWall translate <0,0,0> }
		object { ElecPanel rotate z*-90 translate <0,14*Feet,5*Feet> }
	}


