//global_settings { assumed_gamma 1.5 } // 1 = home 1.5 = work
//
//#include "colors.inc"
//#include "textures.inc"
//#include "metals.inc"
//
//camera {
//       location <1,6,-3> // front view
//       look_at  <1,4.16,0>
//       
// //      location <-0,15,0>    // top view
//   //    look_at  <0,0,0>
//       }
//
////light_source {<-1000, 500, -100> White shadowless}
//light_source {<0, 1000, -1000> White shadowless}
//
//background {Tan}
////plane {<0,1,0>,-.31 pigment {Tan}}

     //object {Microscope_base rotate <0,0,0> texture { T_Microscope_Base }}

#include "M_base.inc" // don't comment out for inc file.

//=================== textures============


#local glass_tx = texture {
  pigment { color <0.9560784 , 0.9560784 , 0.9560784, .7>}  
  finish { 
    ambient 0.014
   reflection .1
  }
}

// >>> T_Chrome_3B (from file "metals.inc", line 219) <<<

// Constants from file "metals.inc"
#declare P_Chrome3 = color rgb <0.50, 0.50, 0.50>;
#declare F_MetalB = finish {
  ambient 0.3
  brilliance 3
  diffuse 0.4
  metallic
  specular 0.70
  roughness 1/60
  reflection 0.25
}

#declare T_Chrome_3B = texture {
  pigment {
    P_Chrome3 
  }
  finish {
    F_MetalB 
  }
}

// >>> Polished_Brass (from file "textures.inc", line 948) <<<
#declare Polished_Brass1 = texture {
  pigment {
    rgb <0.98,0.71,0.18> //rgb <0.578, 0.422, 0.195> 
  }
  normal {
    bumps 1     
    turbulence 4
    lambda .53
    scale 10
  }
  
  finish {
    metallic
    ambient 0.318
    diffuse 0.8
    brilliance 6.0
    reflection 0.32
    phong 0.8
    phong_size 120
  }
}

#declare Polished_Brass2 = texture {
  pigment {
    rgb <0.98,0.71,0.18> //rgb <0.882,0.639,0.162> 
  }
  normal {
    bumps 1.5
    turbulence 12
    lambda .53
    scale 15
  }

  finish {
    metallic
    ambient 0.25
    diffuse 0.73
    brilliance 6.0
    reflection 0.318
    phong 0.8
    phong_size 120
  }
}

#declare Polished_Brass3 = texture {
  pigment {
    rgb <0.98,0.71,0.18> //rgb <0.882,0.639,0.162> 
  }
  normal {
    bumps 1.5
    turbulence 12
    lambda .53
    scale 12
  }

  finish {
    metallic
    ambient 0.25
    diffuse 0.73
    brilliance 6.0
    reflection 0.318
    phong 0.8
    phong_size 120
  }
}


// microscope table
#declare radius_tool_1 = difference {
                     box {<-.125,-0.9,-.125> <.125,0.9,.125> }
                     cylinder {<.125,-1,.125> <.125,1,.125>,0.125}
                     }

#declare m_table = union {
              difference {
               box {<-.8,-.125,-1> <1.5,.125,1> }
               object{radius_tool_1 rotate <0,0,0> translate <-.8,0,-1>}
               object{radius_tool_1 rotate <0,-90,0> translate < 1.5,0,-1>}
               object{radius_tool_1 rotate <0,90,0> translate <-.8,0, 1>}
               object{radius_tool_1 rotate <0,-180,0> translate < 1.5,0, 1>}
               cylinder {<0.8,0.5,0> <0.8,-0.5,0>,0.25 }
              } 
               cylinder {<-1,-.125,0> <-1,.125,0>,0.4}
               box {<-0.25,-0.125,-0.3> <0.25,0.125,0.3>rotate <0,45,0> translate <-0.77,0,0.4>}
               box {<-0.3,-0.125,-0.25> <0.3,0.125,0.25>rotate <0,45,0> translate <-0.77,0,-0.4>}
               cylinder {<-1,0.12,0> <-1,0.7,0>,0.37 pigment {Black}}
               cylinder {<-1,0.19,0> <-1,0.5,0>,0.4}
             }
             
#declare m_adjuster = union{
                cylinder {<-1,0.55,0> <-1,2.7,0>,0.4}
                difference {
                    box {<-1,0.5,-0.125> <1,3.5,0.125> }
                    cylinder {<0.9,0.5,-2> <0.9,0.5,2>,1.25}
                    cylinder {<-0.1,2.7,-2> <-0.1,2.7,2>,0.5}
                    box {<-2,2.6,-2> <0.4,5.5,2>}
                }
                //set screw at bottom
                cylinder {<-1.5,0.7,0> <-1,0.7,0>,0.05 }
                cylinder {<-1.55,0.7,0> <-1.5,0.7,0>,0.1 }
                //top thumb screw
                difference {
                union {
                   cylinder {<-1,2.7,0> <-1,3.35,0>,0.55  }
                   torus {.55,.02 translate <-1,2.78,0>}
                   torus {.55,.02 translate <-1,2.73,0>}
                   }
                torus {.75,.6 translate <-1,3.4,0> } texture {Polished_Brass3}
                }
                //horizontal knob
                box {<0,2.7,-0.125> <0.8,3.25,0.125> }
                cylinder {<0.2,3,-0.5> <0.2,3,0.5>,0.1}
               }
               
#declare turn_knob = union {
                cylinder {<0,0,-0.05> <0,0,0.05>,0.45 }
                torus {0.45, 0.08 rotate <90,0,0>}
                sphere {<0,0,0>,0.2 scale <1,1,0.5>}
               }


#declare main_tube = union {
                cylinder {<0.8,2,0> <0.8,5.1,0>,0.35 }
                cylinder {<0.8,1.5,0> <0.8,2.1,0>,0.25 }
                cylinder {<0.8,1.5,0> <0.8,1.75,0>, 0.3}
                
                torus {0.25, 0.02 translate <0.8,1.8,0>  }
                torus {0.25, 0.02 translate <0.8,1.875,0>}
                torus {0.25, 0.02 translate <0.8,1.95,0> }
                
                cone {<0.8,1.6,0>,.25 <0.8,1.0,0>,.1 }
                sphere {<0.8,1.02,0>,.08} 
                //set screw on lens
                cylinder {<0.8,1.6,0> <1.25,1.6,0>,.05 }
                sphere {<1.25,1.6,0>,.08} 
                
                sphere {<0,0,0>,0.15 scale <1,.2,1> translate <0.8,6.15,0> pigment {Gray*.5}
                   finish { reflection 0.3 phong 0.9 phong_size 60 metallic}
                  }
                torus {0.23, 0.02 translate <0.8,6.15,0>}
                cylinder {<0.8,5.65,0> <0.8,6.15,0>,0.23}
                torus {0.25, 0.04 translate <0.8,5.65,0>}
                cylinder {<0.8,5.2,0> <0.8,5.65,0>,0.25}
                cone {<0.8,5.16,0>,0.35 <0.8,5.22,0>, 0.25}
                torus {0.35, 0.06 translate <0.8,5.1,0>}
                
                object {turn_knob translate <0.2,3.5,-0.5>texture {Polished_Brass2}}
                object {turn_knob translate <0.2,3.5, 0.5>texture {Polished_Brass2}}

                translate <0,-.5,0>
             }

#declare swivel = union {
                difference {
                        box {<-1.25,-0.5,-.15> <-0.5,1.75,.15>  }
                        box {<-1,-3,-1> <1,-1,1> rotate <0,0,45> translate <-3,.65,0>}
                        }
                box {<-1,0.95,-0.65> <-0.5,1.65,0.65> texture { T_Microscope_Base }}
                }

#declare mirror = union {
                box {<-0.5,1.5,-0.2> <-0.25,1.65,0.2> texture { T_Microscope_Base }}
                box {<-0.05,-1,-0.1> <0.05,1,0.1> translate <-0.2,.6,0> texture { T_Microscope_Base }}
                difference {
                     cylinder {<0,-0.05,0> <0,0.05,0>,.75 translate <0.5,-0.2,0>}
                     cylinder {<0,-0.11,0> <0,0.11,0>,.65 translate <0.5,-0.2,0>}
                     box {<0.65,-1,-5> <5,1,5> }
                     }
                difference {
                cylinder {<0,-0.11,0> <0,0.11,0>, 0.5 }
                cylinder {<0, 0.09,0> <0,0.12,0>, 0.45 pigment {White*.7}finish {reflection 0.31}} //pigment {Silver}finish {reflection 0.5}}
                rotate <-10,0,-45> translate <0.5,-0.2,0> }
                }


#declare hold_downs = merge {
                         difference {
                         difference {
                           cylinder {<0,0,0.2> <0,0,-.2>,.4 }
                           cylinder {<0,0,0.21> <0,0,-.21>,.37 }
                           }
                           box {<-2,-2,-1> <2,-.3,1> }
                           box {<.22,-2,-1> <1,2,1> }
                         }
                         box {<-.265,-.3,-.2> <.235,-.27,.2> }
                         box {<0,-0.015,-.2> <1.1,0.015,.2> rotate <0,0,-30> translate <.208,.324,0> }
                         difference {
                          difference {
                            cylinder {<1.37,0.1,-0.2>  <1.37,0.1,0.2>,0.4  }
                            cylinder {<1.37,0.1,-0.21> <1.37,0.1,0.21>,0.37}
                          }
                          box {<.15,-.209,-.3> <1.5,2,.3> } 
                          box {<1.37,-.5,-.3> <2,.5,.3> }
                        }
                        box {<1.37,-.3,-.2> <1.57,-.27,.2> }
                        difference {
                            cylinder {<1.57,-0.1,-0.2>  <1.57,-0.1,0.2>,0.2  }
                            cylinder {<1.57,-0.1,-0.21> <1.57,-0.1,0.21>,0.17}
                            box {<1,-1,-1> <1.57,1,1> }
                            box {<1.5,-0.1,-0.3> <2,1,0.3> }
                        }
                       //screws
                       merge{
                       cylinder {<0,-.3,0> <0,.1,0>, .1 }
                       cylinder {<0,-.53,0> <0,0,0>, .15 }
                       torus {.15, 0.01  translate <0,-0.01,0>}
                       torus {.15, 0.01  translate <0,-0.06,0>}
                       torus {.15, 0.01  translate <0,-0.11,0>}
                       torus {.15, 0.01  translate <0,-0.16,0>}
                       torus {.15, 0.01  translate <0,-0.21,0>}
                       torus {.15, 0.01  translate <0,-0.26,0>}
                       cylinder {<0,.1,0> <0,.2,0>, .2}
                       texture {T_Chrome_1B}} 
                     }
           
//slide on microscope
#local slide = union {
        box {<-1.5,0,-0.375> <1.5,0.2,0.375> texture{glass_tx}}
        box {<-.2,0.2,-0.3> <0.4,0.21,0.3> texture {Red_Marble scale .1}}
       }
           

#declare microscope_assy = union {
                object {m_table   translate <0,1.75,0> texture {T_Chrome_3A}}
                object {slide scale <.6,.6,1> rotate <0,90,0> translate <.9,1.8,0>}
                object {m_adjuster translate <0,1.75,0> texture {Polished_Brass2}}
                object {main_tube  translate <0,1.75,0> texture {Polished_Brass1}}
                object {swivel texture { T_Microscope_Base }}
                cylinder {<-0.95,1.25,-0.75> <-0.95,1.25,0.75>,0.05 }        
                object {turn_knob scale <.25,.25,.5> translate <-0.95,1.25,-0.75> texture {Polished_Brass2}}
                object {turn_knob scale <.25,.25,.5> translate <-0.95,1.25, 0.75> texture {Polished_Brass2}}
                object {mirror}
                object {hold_downs scale <.75,.75,.5> translate <-0.2,2.158,-.75> texture{T_Chrome_1D}}
                object {hold_downs scale <.75,.75,.5> translate <-0.2,2.158, .75> texture{T_Chrome_1D}}
               }   
#declare Microscope = union {
object {Microscope_base rotate <0,0,0> scale <1.25,1,1.25> texture { T_Microscope_Base }}
object {microscope_assy rotate <0,0,22.5> translate <0.25,2.35,0>}
}

//object {Microscope}
