/*****************************
 *         People.inc        *
 *****************************
 *    100 People standing    *
 *   outside in the lanes    *
 *     By David S Darrell    *
 *****************************/

//Define all Seeds needed 
#declare pclr1=seed(6487);
#declare pclr2=seed(4864);
#declare px=seed(4687);
#declare pz=seed(1378);
#declare pr=seed(3574);

//Two legs for the people to stand on
#declare Feet = union {
    object {
        cylinder {<-0.05, 0, 0>, <-0.05, 0.75,0>, 0.05}
    }
    object {
        cylinder {<0.05, 0, 0>, <0.05, 0.75, 0>, 0.05}
    }
}

//Chest, arms, and Shoulders
#declare Body = union {
    object {
        cylinder {<0, 0.75, 0>, <0, 1.4, 0>, 0.1}
    }
    object {
        cylinder {<-0.1, 1.4, 0>, <0.1, 1.4, 0>, 0.1}
    }
    object {
        sphere {<-0.1, 1.4, 0>, 0.1}
    }
    object {
        sphere {<0.1, 1.4, 0>, 0.1}
    }
    object {
        cylinder {<-0.15, 0.75, 0>, <-0.15, 1.4, 0>, 0.05}
    }
    object {
        cylinder {<0.15, 0.75, 0>, <0.15, 1.4, 0>, 0.05}
    }
}

//The Head (Of Course!)
#declare Head = sphere {<0, 1.6, 0>, 0.1}

//Combine feet, body and head
union {
    object {
        Feet
        //Color legs in any color (Pants)
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        //Color body in any color (Shirt)
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        //Decide what skin color to use for the head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    //Turn the person around and place it somewheres
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

//Repeat this process 99 more times

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}
union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}
union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}
union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

union {
    object {
        Feet
        pigment {rgb <rand(pclr1), rand(pclr1), rand(pclr1)>}
    }
    object {
        Body
        pigment {rgb <rand(pclr2), rand(pclr2), rand(pclr2)>}
    }
    object {
        Head
        #if (rand(pclr1)>0.5)
            pigment {rgb <0.5, 0.25, 0>}
        #else
            pigment {rgb <1, 0.75, 0.5>}
        #end
    }
    rotate <0, rand(pr)*360, 0>
    translate <(rand(px)-0.5)*8.7, 0, (rand(pz)-(18/41.5))*41.1>
}

///WHEWW!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!