
#include "reorient.mcr"

#macro Signature(String, Font, Obj, Sc, Rot, Tr, Rnd)

#local St = seed(Rnd);
#local l = strlen(String);

#local i = 0;

#while (i < l)

	#local Lettre = substr(String, i+1, 1)
	
	#local Start = <i*Sc.x, 0, 0>;
	#local Start = vaxis_rotate(Start, y, Rot.y);
	#local Start = Start + <Tr.x, 10, Tr.z>;
	#debug concat("\nStart = <", str(Start.x, 2, 3), ", ", str(Start.y, 5, 3), ",", str(Start.z, 2, 3), ">\n")
	
	#local Norm = <0,0,0>;
	#local Inter = trace(Obj, Start, -y, Norm);

	#if ((Norm.x!=0) | (Norm.y!=0) | (Norm.z!=0))

		object {
			text { ttf Font Lettre 1, 0 }
			translate -x*.62 -.5*y -.7*z
			scale Sc
			rotate x*90
			rotate y*(Rot.y - 5 + 10*rand(St))
		
			#if (vdot(y, vnormalize(Norm)) < 1)
				Reorient(y, Norm)
			#end

			translate Inter
		}
	#else
		#debug concat("\nPas d'intersection pour lettre ", Lettre, "\n")
	#end
	
	#local i = i + 1;	
#end

#end
