

#macro IsoCone(Rayon1, Rayon2, R, Taille, Noise)

#local tmp = (Rayon1-Rayon2)/(Taille-R);
#local tmp2 = Rayon2*Rayon2;
#local tmp3 = R*R;

union {
	isosurface {
		function { sqrt(x*x + z*z) - Rayon1 + tmp*y
					-noise3d(x*5, y*5, z*5)*Rayon2*Noise
		}
		bounded_by {box{<-Rayon1*1.1, 0, -Rayon1*1.1>, <Rayon1*1.1, Taille-R, Rayon1*1.1>}}
		max_trace 2
	}
	isosurface {
		function { sqrt(x*x/tmp2 + ((y-Taille+R)^2)/tmp3 + z*z/tmp2) - 1
					-noise3d(x*5, y*5, z*5)*Rayon2*Noise
		}
		bounded_by {box{<-Rayon2*1.1, Taille-R, -Rayon2*1.1>, <Rayon2*1.1, Taille*1.1, Rayon2*1.1>}}
		max_trace 2
	}
}
	

#end


#macro IsoWall(Longueur, Largeur, Exp, Taille, Noise)

/*
union {
	isosurface {
		function { abs(z) - Largeur1*.5 + tmp*y
					-noise3d(x*5, y*5, z*5)*Largeur2*Noise
		}
		bounded_by {box{<-Longueur/2, 0, -Largeur1*.6>, <Longueur/2, Taille-R, Largeur1*.6>}}
		max_trace 2
	}
	isosurface {
		function { sqrt(((y-Taille+R)^2)/tmp3 + z*z/tmp2) - 1
					-noise3d(x*5, y*5, z*5)*Largeur2*Noise
		}
		bounded_by {box{<-Longueur/2, Taille-R, Largeur2*.6>, <Longueur/2, Taille*1.1, Largeur2*.6>}}
		max_trace 2
	}
}
*/

	isosurface {
		function { y + (abs(z)*2/Largeur)^(Exp) - Taille
					-noise3d(x*5, y*5, z*5)*Largeur*Noise
		}
		bounded_by {box{<-Longueur/2, 0, -Largeur*.6>, <Longueur/2, Taille*1.1, Largeur*.6>}}
		max_trace 4
	}
	
#end

