///////////////////////////////
// Textures by Miroslav Hundak

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "stars.inc"
#include "metals.inc"

// Blank texture
#declare txBlank = texture {
	pigment { color <1, 1, 1> }
	finish { 
		specular 1
		roughness 0.005
	}
}

#ifndef(TEXTURE_PREVIEW)
	#declare TEXTURE_PREVIEW = 0;
#end

#if(TEXTURE_PREVIEW)
//****************************************************************************
// preview textures

#declare txCrystal_2 = texture { txBlank }
#declare txSteel_1 = texture { txBlank }
#declare txSteel_2 = texture { txBlank }
#declare txFloor_1 = texture { txBlank }
#declare txFloor_2 = texture { txBlank }
#declare txCrystal_1 = texture { txBlank }
#declare txSky_1 = texture { txBlank }
#declare txSky_2 = texture { txBlank }
#declare txWater_1 = texture { txBlank }
#declare txWater_2 = texture { txBlank }
#declare txWater_3 = texture { txBlank }
#declare txGround_1 = texture { txBlank }
#declare txWood_1 = texture { txBlank }
#declare txBrick_1 = texture { txBlank }
#declare txWire_1 = texture { txBlank }

#else
//****************************************************************************
// "real" textures

#declare txWire_1 =
texture {
	pigment { 
		bozo 
		color_map {
			[ 0 color rgb <0.6, 0.6, 0.7> ]
			[ 1 color rgb <0.7, 0.4, 0.3> ]
		}
		scale 1/50
	}
	normal {
		dents		
		scale 1/30
	}
	finish {
		brilliance 2
		phong 1
		phong_size 80
		reflection 0.1
	}
	scale <1.5, 1, 1>
}

#declare txBrick_1 =
texture {
	pigment {
		brick color rgb <0.7, 0.7, 0.7>, color rgb <1, 0.9, 0.9>
		scale 1/5
	}
	normal {
		average
		normal_map {
			[ 1.5 brick scale 1/5 ]
			[ 0.3 crackle scale 1/5 ]
		}
	}
	translate <0.1, 0.1, -0.2>
}

#declare txWood_1 =
texture {
	pigment {
		wood
		color_map {
			[ 0 color rgb <0.2, 0.1, 0> ]
			[ 0.1 color rgb <0.7, 0.6, 0.2> ]
			[ 0.7 color rgb <0.95, 0.85, 0.45> ]
			[ 1 color rgb <1, 0.9, 0.5> ]
		}
		translate <5, 2, 8>
		rotate <21, 13, 35>
		scale 1/8
		turbulence 0.02 
	}
	finish {
		phong 0.5
		phong_size 60
		reflection 0.1
	}
}
#declare txWater_3 =
texture {
	pigment { color rgb <0, 0, 0> }
	normal {
		ripples 0.5
		//frequency 5
		scale 1/4
		turbulence 0.2
	}
	finish {
		reflection 0.6
	}
}
#declare txSky_2 = 
texture { 
	pigment {
		gradient y
		color_map {
			[ 0 color rgb <0.4, 0.6, 1> ]
			[ 0.15 color rgb <0.3, 0.5, 0.8> ]
			[ 0.3 color rgb <0.2, 0.3, 0.6> ]
			[ 1 color rgb <0.2, 0.3, 0.6> ]
		}
	}
}
texture {
	pigment {
		bozo
		color_map {
			[ 0 color rgb <0.7, 0.7, 0.8> ]
			[ 0.5 color rgb <0.5, 0.6, 0.7> ]
			[ 0.8 color rgbt <0.5, 0.6, 0.7, 1> ]
			[ 1 color rgbt <1, 1, 1, 1> ]
		}
		turbulence 0.5
		scale 1000
	}
}

#declare txGround_1 = texture {
	pigment {
		gradient y
		color_map {
			[ 0 color rgb <0.25, 0.28, 0.15> ]
			[ 0.3 color rgb <0.25, 0.28, 0.15> ]
			[ 0.6 color rgb <0.6, 0.55, 0.15> ]
			[ 0.7 color rgb <0.1, 0.8, 0.1> ]
			[ 1 color rgb <0.9, 0.9, 0.1> ]
		}
	}
	finish {
		diffuse 0.6
		brilliance 0.5
	}
}

#declare txWater_2 = texture {
	pigment { color rgbt <0, 0, 0, 0.9> }
	normal {
		ripples 0.1
		frequency 5
		turbulence 0.1
	}
	finish {
		//diffuse 0
		//brilliance 10
		ambient 0
		phong 1
		phong_size 60
		reflection 0.5
	}
}

#declare txBlank = texture {
	pigment { color rgb 0.75 }
	finish {
		phong 1
		phong_size 60
	}
}

#declare txCrystal_1 = texture {
	pigment { color rgbt <1, 1, 1, 1> }
	finish {
		//phong 1
		//phong_size 40
		specular 1
		roughness 0.005
		//metallic
		reflection 0.2
	}
}

#declare txCrystal_2 = texture {
	pigment { color rgbf <1, .5, .5, 1> }
	finish {
		//phong 1
		//phong_size 40
		specular 1
		roughness 0.005
		//metallic
		reflection 0.2
	}
}

#declare txSteel_1 = texture {
	pigment { color rgb <0, 0, 0> }
	normal {
		wrinkles 0.5
		//turbulence 1
		scale 0.0001
	}
	finish {
		specular 1
		roughness 0.005
		metallic
		reflection 1.0
	}
}

#declare txSteel_2 = texture {
	pigment { color rgb <0.5, 0.5, 0.5> }
	finish {
  		brilliance 10
  		diffuse 1
  		specular 0.90
  		roughness 1/20
		ambient 0.99
		metallic
		reflection 0.01
	}
}

#declare txFloor_1 = texture {
	//checker
	//texture { 
		T_Stone14 
		finish { ambient 0.4 }
	//}
	//texture { T_Stone24 finish { ambient 0.4 } }
}

#declare txSky_1 =
texture {
	pigment { onion
		color_map {
			[0 color rgb <0.2, 0.9, 0.6>]
			[0.3 color rgb <0.1, 0.45, 0.5>]
			[0.7 color rgb <1, 0.7, 0.3>]
		}
		scale 20000
	}
	finish { ambient 1 }
}
texture {
	T_Cloud1
	finish { ambient 1 }
	scale 300 translate z*(-6000)
}

#declare txFloor_2 =
texture {
	checker
	texture { txFloor_1 scale <1/1000, 15, 1/1000> }
	texture { T_Gold_5A }
	scale <1000, 1/15, 1000>
	translate x*500
	rotate z*30
}

#declare txWater_1 =
texture {
	pigment {
		color rgb <0, 0.1, 0.5>
		//color rgb <1, 1, 1>
	}
	normal {
		average
		normal_map {
			[1 ripples 1 scale 5 turbulence 0.5 ]
			[1 bumps 0.5 scale 0.5 ]
		}
		translate z*2
		rotate y*30
	}
	finish {
		ambient 0
		phong 1
		phong_size 60
		reflection 0.5
	}
}

#end

		