/////////////////////////////////////
// Tree objects by Miroslav Hundak
// -> sPatch export!

// Textures - include of this .inc file should be put after the include of "x.inc" file
// Textures - include of this .inc file should be put after the include of "x.inc" file
#if(TEXTURE_PREVIEW)
#declare txTrunks = texture { txBlank }
#declare txLeaves = texture { txBlank }
#declare txFlowers = texture { txBlank }
#else
#declare txTrunks =
texture {
	pigment {
		bozo
		color_map {
			[ 0 color rgb <0.9, 0.85, 0.5> ]
			[ 0.7 color rgb <0.9, 0.85, 0.5> ]
			[ 0.975 color rgb <0.5, 0.5, 0.2> ]
			[ 0.995 color rgb <0.2, 0.2, 0> ]
		}
		scale <1, 3, 1>*1/10
	}
	finish {
		brilliance 0.7
		phong 0.05
		phong_size 50
		ambient 0.15
	}
}
texture {
	pigment {
		gradient y
		pigment_map {
			[ 0 color rgbt <0, 0, 0, 1> ]
			[ 0.6 color rgbt <0, 0, 0, 1> ]
			[ 0.61 wrinkles 
				color_map {
					[ 0 color rgbt <1, 1, 0.95, 0> ]
					[ 0.9 color rgb <1, 1, 0.95> ]
					[ 0.95 color rgb <0, 0, 0> ]
				}
				scale <1, 3, 1>*1/200   
				turbulence 0.5
			]
		}
		turbulence 0.2
	}
	finish {
		brilliance 0.6
		diffuse 0.9
		phong 0.05
		phong_size 50
		ambient 0.15
	}
	scale 15
}
#declare txLeaves = 
texture {
	pigment { color rgb <0.1, 0.9, 0.2> }
	finish {
		phong 0.2
		phong_size 60
	}
}
#declare txFlowers =
texture {
	pigment { color rgb <1, 0.8, 0.9> }
	finish {
		phong 0.05
		phong_size 40
		ambient 0.5
	}
}
#end

// Layer 1
#declare oTrunks =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.650, 1.951, -0.229> <-0.724, 1.363, -0.058> <-0.657, 0.569, 0.188> <-0.744, 0.000, 0.407> 
		<-0.677, 1.951, -0.283> <-0.751, 1.363, -0.112> <-0.736, 0.569, 0.189> <-0.823, 0.000, 0.409> 
		<-0.702, 1.951, -0.362> <-0.839, 1.358, -0.142> <-0.759, 0.540, 0.229> <-0.971, 0.000, 0.516> 
		<-0.703, 1.951, -0.422> <-0.841, 1.358, -0.203> <-0.794, 0.540, 0.158> <-1.006, 0.000, 0.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.650, 1.951, -0.229> <-0.677, 1.951, -0.283> <-0.702, 1.951, -0.362> <-0.703, 1.951, -0.422> 
		<-0.604, 2.320, -0.336> <-0.631, 2.320, -0.390> <-0.617, 2.317, -0.498> <-0.618, 2.317, -0.558> 
		<-0.439, 2.806, -0.428> <-0.440, 2.806, -0.497> <-0.470, 2.806, -0.685> <-0.431, 2.806, -0.742> 
		<-0.348, 3.172, -0.513> <-0.350, 3.172, -0.582> <-0.309, 3.172, -0.673> <-0.270, 3.172, -0.730> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.650, 1.951, -0.229> <-0.633, 1.951, -0.194> <-0.593, 1.951, -0.158> <-0.561, 1.951, -0.136> 
		<-0.724, 1.363, -0.058> <-0.707, 1.363, -0.024> <-0.620, 1.367, 0.017> <-0.588, 1.367, 0.038> 
		<-0.657, 0.569, 0.188> <-0.581, 0.569, 0.186> <-0.560, 0.571, 0.233> <-0.485, 0.571, 0.219> 
		<-0.744, 0.000, 0.407> <-0.668, 0.000, 0.405> <-0.566, 0.000, 0.447> <-0.491, 0.000, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.650, 1.951, -0.229> <-0.650, 1.951, -0.229> <-0.650, 1.951, -0.229> <-0.650, 1.951, -0.229> 
		<-0.633, 1.951, -0.194> <-0.587, 2.320, -0.301> <-0.587, 2.320, -0.301> <-0.604, 2.320, -0.336> 
		<-0.593, 1.951, -0.158> <-0.577, 2.323, -0.269> <-0.557, 2.437, -0.392> <-0.439, 2.806, -0.428> 
		<-0.561, 1.951, -0.136> <-0.544, 2.323, -0.247> <-0.466, 2.803, -0.477> <-0.348, 3.172, -0.513> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.561, 1.951, -0.136> <-0.494, 1.951, -0.091> <-0.397, 1.951, -0.041> <-0.323, 1.951, -0.009> 
		<-0.588, 1.367, 0.038> <-0.520, 1.367, 0.083> <-0.382, 1.365, 0.057> <-0.308, 1.365, 0.090> 
		<-0.485, 0.571, 0.219> <-0.386, 0.571, 0.201> <-0.286, 0.578, 0.211> <-0.195, 0.578, 0.166> 
		<-0.491, 0.000, 0.433> <-0.392, 0.000, 0.415> <-0.271, 0.000, 0.349> <-0.180, 0.000, 0.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.561, 1.951, -0.136> <-0.544, 2.323, -0.247> <-0.466, 2.803, -0.477> <-0.348, 3.172, -0.513> 
		<-0.494, 1.951, -0.091> <-0.477, 2.323, -0.202> <-0.464, 2.803, -0.388> <-0.346, 3.172, -0.424> 
		<-0.397, 1.951, -0.041> <-0.406, 2.318, -0.103> <-0.342, 2.806, -0.226> <-0.323, 3.172, -0.293> 
		<-0.323, 1.951, -0.009> <-0.332, 2.318, -0.071> <-0.279, 2.806, -0.164> <-0.260, 3.172, -0.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.323, 1.951, -0.009> <-0.323, 1.951, -0.009> <-0.323, 1.951, -0.009> <-0.323, 1.951, -0.009> 
		<-0.299, 1.951, 0.002> <-0.308, 2.318, -0.060> <-0.308, 2.318, -0.060> <-0.332, 2.318, -0.071> 
		<-0.261, 1.951, 0.017> <-0.282, 2.320, -0.037> <-0.320, 2.438, -0.117> <-0.279, 2.806, -0.164> 
		<-0.237, 1.951, 0.006> <-0.258, 2.320, -0.048> <-0.302, 2.804, -0.183> <-0.260, 3.172, -0.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.323, 1.951, -0.009> <-0.299, 1.951, 0.002> <-0.261, 1.951, 0.017> <-0.237, 1.951, 0.006> 
		<-0.308, 1.365, 0.090> <-0.284, 1.365, 0.100> <-0.227, 1.367, 0.102> <-0.203, 1.367, 0.091> 
		<-0.195, 0.578, 0.166> <-0.161, 0.578, 0.150> <-0.126, 0.580, 0.160> <-0.116, 0.580, 0.123> 
		<-0.180, 0.000, 0.304> <-0.146, 0.000, 0.288> <-0.087, 0.000, 0.268> <-0.077, 0.000, 0.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.237, 1.951, 0.006> <-0.164, 1.951, -0.027> <-0.073, 1.951, -0.089> <-0.018, 1.951, -0.147> 
		<-0.203, 1.367, 0.091> <-0.130, 1.367, 0.058> <-0.091, 1.366, -0.080> <-0.036, 1.366, -0.139> 
		<-0.116, 0.580, 0.123> <-0.090, 0.580, 0.028> <-0.062, 0.585, -0.010> <-0.056, 0.585, -0.109> 
		<-0.077, 0.000, 0.232> <-0.052, 0.000, 0.136> <-0.078, 0.000, 0.001> <-0.072, 0.000, -0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.237, 1.951, 0.006> <-0.258, 2.320, -0.048> <-0.302, 2.804, -0.183> <-0.260, 3.172, -0.230> 
		<-0.164, 1.951, -0.027> <-0.185, 2.320, -0.081> <-0.238, 2.804, -0.120> <-0.196, 3.172, -0.167> 
		<-0.073, 1.951, -0.089> <-0.062, 2.317, -0.094> <-0.065, 2.805, -0.152> <-0.064, 3.172, -0.146> 
		<-0.018, 1.951, -0.147> <-0.007, 2.317, -0.152> <0.024, 2.805, -0.149> <0.025, 3.172, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 1.951, -0.147> <0.003, 1.951, -0.170> <-0.011, 1.951, -0.221> <0.002, 1.951, -0.250> 
		<-0.036, 1.366, -0.139> <-0.015, 1.366, -0.162> <-0.053, 1.367, -0.245> <-0.040, 1.367, -0.274> 
		<-0.056, 0.585, -0.109> <-0.051, 0.585, -0.183> <-0.001, 0.582, -0.212> <-0.033, 0.582, -0.278> 
		<-0.072, 0.000, -0.098> <-0.067, 0.000, -0.172> <-0.009, 0.000, -0.277> <-0.042, 0.000, -0.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 1.951, -0.147> <-0.007, 2.317, -0.152> <0.024, 2.805, -0.149> <0.025, 3.172, -0.143> 
		<0.003, 1.951, -0.170> <0.014, 2.317, -0.175> <0.077, 2.805, -0.147> <0.078, 3.172, -0.141> 
		<-0.011, 1.951, -0.221> <0.016, 2.320, -0.206> <0.095, 2.806, -0.186> <0.150, 3.172, -0.175> 
		<0.002, 1.951, -0.250> <0.029, 2.320, -0.235> <0.130, 2.806, -0.225> <0.185, 3.172, -0.214> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 1.951, -0.250> <0.029, 2.320, -0.235> <0.130, 2.806, -0.225> <0.185, 3.172, -0.214> 
		<0.014, 1.951, -0.277> <0.041, 2.320, -0.262> <0.128, 2.435, -0.291> <0.182, 2.801, -0.280> 
		<0.060, 1.951, -0.297> <0.064, 1.951, -0.337> <0.111, 2.317, -0.374> <0.100, 2.317, -0.413> 
		<0.063, 1.951, -0.326> <0.067, 1.951, -0.366> <0.034, 1.951, -0.414> <0.023, 1.951, -0.453> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 1.951, -0.250> <0.014, 1.951, -0.277> <0.060, 1.951, -0.297> <0.063, 1.951, -0.326> 
		<-0.040, 1.367, -0.274> <-0.027, 1.367, -0.300> <-0.007, 1.365, -0.316> <-0.004, 1.365, -0.345> 
		<-0.033, 0.582, -0.278> <-0.052, 0.582, -0.316> <-0.060, 0.583, -0.265> <-0.098, 0.583, -0.283> 
		<-0.042, 0.000, -0.344> <-0.061, 0.000, -0.382> <-0.142, 0.000, -0.300> <-0.180, 0.000, -0.318> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 1.951, -0.250> <0.002, 1.951, -0.250> <0.002, 1.951, -0.250> <0.002, 1.951, -0.250> 
		<0.029, 2.320, -0.235> <0.041, 2.320, -0.262> <0.041, 2.320, -0.262> <0.014, 1.951, -0.277> 
		<0.130, 2.806, -0.225> <0.094, 2.439, -0.259> <0.102, 2.318, -0.285> <0.060, 1.951, -0.297> 
		<0.185, 3.172, -0.214> <0.148, 2.806, -0.248> <0.105, 2.318, -0.314> <0.063, 1.951, -0.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 1.951, -0.326> <0.063, 1.951, -0.326> <0.063, 1.951, -0.326> <0.063, 1.951, -0.326> 
		<0.105, 2.318, -0.314> <0.109, 2.318, -0.354> <0.109, 2.318, -0.354> <0.067, 1.951, -0.366> 
		<0.148, 2.806, -0.248> <0.146, 2.435, -0.314> <0.111, 2.317, -0.374> <0.034, 1.951, -0.414> 
		<0.185, 3.172, -0.214> <0.182, 2.801, -0.280> <0.100, 2.317, -0.413> <0.023, 1.951, -0.453> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 1.951, -0.326> <0.067, 1.951, -0.366> <0.034, 1.951, -0.414> <0.023, 1.951, -0.453> 
		<-0.004, 1.365, -0.345> <-0.000, 1.365, -0.385> <-0.089, 1.362, -0.479> <-0.100, 1.362, -0.517> 
		<-0.098, 0.583, -0.283> <-0.201, 0.583, -0.335> <-0.266, 0.586, -0.407> <-0.339, 0.586, -0.496> 
		<-0.180, 0.000, -0.318> <-0.283, 0.000, -0.370> <-0.404, 0.000, -0.472> <-0.477, 0.000, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.023, 1.951, -0.453> <0.011, 1.951, -0.497> <-0.005, 1.951, -0.557> <-0.016, 1.951, -0.602> 
		<-0.100, 1.362, -0.517> <-0.112, 1.362, -0.562> <-0.141, 1.368, -0.593> <-0.152, 1.368, -0.638> 
		<-0.339, 0.586, -0.496> <-0.356, 0.586, -0.516> <-0.254, 0.567, -0.555> <-0.278, 0.567, -0.546> 
		<-0.477, 0.000, -0.561> <-0.494, 0.000, -0.582> <-0.423, 0.000, -0.652> <-0.447, 0.000, -0.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.023, 1.951, -0.453> <0.100, 2.317, -0.413> <0.182, 2.801, -0.280> <0.185, 3.172, -0.214> 
		<0.011, 1.951, -0.497> <0.087, 2.317, -0.457> <0.233, 2.801, -0.337> <0.236, 3.172, -0.272> 
		<-0.005, 1.951, -0.557> <0.082, 2.321, -0.534> <0.198, 2.806, -0.415> <0.291, 3.172, -0.368> 
		<-0.016, 1.951, -0.602> <0.071, 2.321, -0.579> <0.202, 2.806, -0.492> <0.295, 3.172, -0.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 1.951, -0.602> <-0.022, 1.951, -0.629> <-0.013, 1.951, -0.677> <-0.036, 1.951, -0.692> 
		<-0.152, 1.368, -0.638> <-0.159, 1.368, -0.665> <-0.181, 1.362, -0.689> <-0.204, 1.362, -0.704> 
		<-0.278, 0.567, -0.546> <-0.337, 0.567, -0.525> <-0.365, 0.579, -0.600> <-0.417, 0.579, -0.564> 
		<-0.447, 0.000, -0.643> <-0.506, 0.000, -0.621> <-0.559, 0.000, -0.548> <-0.611, 0.000, -0.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 1.951, -0.602> <-0.016, 1.951, -0.602> <-0.016, 1.951, -0.602> <-0.016, 1.951, -0.602> 
		<-0.022, 1.951, -0.629> <0.064, 2.321, -0.606> <0.064, 2.321, -0.606> <0.071, 2.321, -0.579> 
		<-0.013, 1.951, -0.677> <0.093, 2.323, -0.669> <0.165, 2.437, -0.603> <0.202, 2.806, -0.492> 
		<-0.036, 1.951, -0.692> <0.070, 2.323, -0.684> <0.258, 2.803, -0.556> <0.295, 3.172, -0.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.036, 1.951, -0.692> <-0.109, 1.951, -0.737> <-0.223, 1.951, -0.768> <-0.307, 1.951, -0.785> 
		<-0.204, 1.362, -0.704> <-0.277, 1.362, -0.750> <-0.431, 1.363, -0.692> <-0.515, 1.363, -0.708> 
		<-0.417, 0.579, -0.564> <-0.505, 0.579, -0.504> <-0.535, 0.557, -0.445> <-0.634, 0.557, -0.403> 
		<-0.611, 0.000, -0.512> <-0.699, 0.000, -0.452> <-0.816, 0.000, -0.367> <-0.915, 0.000, -0.325> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.036, 1.951, -0.692> <0.070, 2.323, -0.684> <0.258, 2.803, -0.556> <0.295, 3.172, -0.445> 
		<-0.109, 1.951, -0.737> <-0.003, 2.323, -0.730> <0.262, 2.803, -0.648> <0.299, 3.172, -0.537> 
		<-0.223, 1.951, -0.768> <-0.091, 2.323, -0.817> <0.122, 2.806, -0.692> <0.277, 3.172, -0.678> 
		<-0.307, 1.951, -0.785> <-0.175, 2.323, -0.834> <0.053, 2.806, -0.753> <0.208, 3.172, -0.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.951, -0.785> <-0.337, 1.951, -0.791> <-0.377, 1.951, -0.774> <-0.405, 1.951, -0.764> 
		<-0.515, 1.363, -0.708> <-0.545, 1.363, -0.714> <-0.616, 1.367, -0.695> <-0.645, 1.367, -0.685> 
		<-0.634, 0.557, -0.403> <-0.684, 0.557, -0.382> <-0.772, 0.543, -0.440> <-0.774, 0.543, -0.386> 
		<-0.915, 0.000, -0.325> <-0.965, 0.000, -0.304> <-1.092, 0.000, -0.363> <-1.095, 0.000, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.307, 1.951, -0.785> <-0.307, 1.951, -0.785> <-0.307, 1.951, -0.785> <-0.307, 1.951, -0.785> 
		<-0.337, 1.951, -0.791> <-0.205, 2.323, -0.839> <-0.205, 2.323, -0.839> <-0.175, 2.323, -0.834> 
		<-0.377, 1.951, -0.774> <-0.222, 2.327, -0.825> <-0.068, 2.431, -0.868> <0.053, 2.806, -0.753> 
		<-0.405, 1.951, -0.764> <-0.251, 2.327, -0.815> <0.086, 2.798, -0.854> <0.208, 3.172, -0.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.405, 1.951, -0.764> <-0.449, 1.951, -0.750> <-0.509, 1.951, -0.730> <-0.549, 1.951, -0.706> 
		<-0.645, 1.367, -0.685> <-0.689, 1.367, -0.671> <-0.656, 1.361, -0.596> <-0.696, 1.361, -0.572> 
		<-0.774, 0.543, -0.386> <-0.778, 0.543, -0.307> <-0.827, 0.578, -0.367> <-0.792, 0.578, -0.295> 
		<-1.095, 0.000, -0.309> <-1.098, 0.000, -0.229> <-0.959, 0.000, -0.177> <-0.925, 0.000, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.405, 1.951, -0.764> <-0.251, 2.327, -0.815> <0.086, 2.798, -0.854> <0.208, 3.172, -0.739> 
		<-0.449, 1.951, -0.750> <-0.295, 2.327, -0.801> <0.007, 2.798, -0.924> <0.129, 3.172, -0.810> 
		<-0.509, 1.951, -0.730> <-0.418, 2.319, -0.814> <-0.152, 2.806, -0.793> <-0.028, 3.172, -0.829> 
		<-0.549, 1.951, -0.706> <-0.457, 2.319, -0.790> <-0.258, 2.806, -0.791> <-0.134, 3.172, -0.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.549, 1.951, -0.706> <-0.587, 1.951, -0.682> <-0.639, 1.951, -0.645> <-0.660, 1.951, -0.605> 
		<-0.696, 1.361, -0.572> <-0.734, 1.361, -0.548> <-0.778, 1.364, -0.468> <-0.799, 1.364, -0.429> 
		<-0.792, 0.578, -0.295> <-0.761, 0.578, -0.232> <-0.775, 0.587, -0.146> <-0.785, 0.587, -0.076> 
		<-0.925, 0.000, -0.105> <-0.894, 0.000, -0.042> <-0.874, 0.000, 0.057> <-0.884, 0.000, 0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.549, 1.951, -0.706> <-0.549, 1.951, -0.706> <-0.549, 1.951, -0.706> <-0.549, 1.951, -0.706> 
		<-0.587, 1.951, -0.682> <-0.495, 2.319, -0.766> <-0.495, 2.319, -0.766> <-0.457, 2.319, -0.790> 
		<-0.639, 1.951, -0.645> <-0.549, 2.329, -0.758> <-0.423, 2.440, -0.843> <-0.258, 2.806, -0.791> 
		<-0.660, 1.951, -0.605> <-0.571, 2.329, -0.719> <-0.298, 2.806, -0.880> <-0.134, 3.172, -0.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.660, 1.951, -0.605> <-0.687, 1.951, -0.556> <-0.705, 1.951, -0.479> <-0.703, 1.951, -0.422> 
		<-0.799, 1.364, -0.429> <-0.826, 1.364, -0.379> <-0.842, 1.358, -0.259> <-0.841, 1.358, -0.203> 
		<-0.785, 0.587, -0.076> <-0.800, 0.587, 0.025> <-0.840, 0.540, 0.067> <-0.794, 0.540, 0.158> 
		<-0.884, 0.000, 0.126> <-0.899, 0.000, 0.227> <-1.052, 0.000, 0.353> <-1.006, 0.000, 0.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.660, 1.951, -0.605> <-0.571, 2.329, -0.719> <-0.298, 2.806, -0.880> <-0.134, 3.172, -0.827> 
		<-0.687, 1.951, -0.556> <-0.598, 2.329, -0.669> <-0.349, 2.806, -0.879> <-0.184, 3.172, -0.826> 
		<-0.705, 1.951, -0.479> <-0.620, 2.317, -0.614> <-0.402, 2.806, -0.784> <-0.242, 3.172, -0.772> 
		<-0.703, 1.951, -0.422> <-0.618, 2.317, -0.558> <-0.431, 2.806, -0.742> <-0.270, 3.172, -0.730> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 1.951, -0.121> <0.457, 1.370, -0.252> <0.435, 0.586, -0.380> <0.411, 0.000, -0.481> 
		<0.487, 1.951, -0.102> <0.499, 1.370, -0.233> <0.534, 0.586, -0.397> <0.509, 0.000, -0.498> 
		<0.530, 1.951, -0.055> <0.602, 1.364, -0.200> <0.583, 0.581, -0.342> <0.644, 0.000, -0.514> 
		<0.562, 1.951, -0.022> <0.634, 1.364, -0.167> <0.677, 0.581, -0.378> <0.738, 0.000, -0.549> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 1.951, -0.121> <0.445, 1.951, -0.121> <0.445, 1.951, -0.121> <0.445, 1.951, -0.121> 
		<0.438, 2.324, -0.036> <0.480, 2.324, -0.018> <0.480, 2.324, -0.018> <0.487, 1.951, -0.102> 
		<0.446, 2.804, 0.199> <0.511, 2.438, 0.121> <0.485, 2.317, 0.036> <0.530, 1.951, -0.055> 
		<0.346, 3.172, 0.236> <0.411, 2.806, 0.159> <0.517, 2.317, 0.069> <0.562, 1.951, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 1.951, -0.121> <0.395, 1.951, -0.143> <0.320, 1.951, -0.153> <0.265, 1.951, -0.155> 
		<0.457, 1.370, -0.252> <0.407, 1.370, -0.274> <0.285, 1.362, -0.233> <0.231, 1.362, -0.235> 
		<0.435, 0.586, -0.380> <0.322, 0.586, -0.361> <0.193, 0.581, -0.373> <0.093, 0.581, -0.317> 
		<0.411, 0.000, -0.481> <0.297, 0.000, -0.462> <0.132, 0.000, -0.484> <0.031, 0.000, -0.428> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 1.951, -0.121> <0.438, 2.324, -0.036> <0.446, 2.804, 0.199> <0.346, 3.172, 0.236> 
		<0.395, 1.951, -0.143> <0.388, 2.324, -0.059> <0.434, 2.804, 0.120> <0.334, 3.172, 0.157> 
		<0.320, 1.951, -0.153> <0.342, 2.316, -0.103> <0.299, 2.806, 0.000> <0.285, 3.172, 0.048> 
		<0.265, 1.951, -0.155> <0.287, 2.316, -0.105> <0.233, 2.806, -0.045> <0.219, 3.172, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 1.951, -0.155> <0.265, 1.951, -0.155> <0.265, 1.951, -0.155> <0.265, 1.951, -0.155> 
		<0.233, 1.951, -0.156> <0.254, 2.316, -0.106> <0.254, 2.316, -0.106> <0.287, 2.316, -0.105> 
		<0.188, 1.951, -0.146> <0.205, 2.318, -0.112> <0.267, 2.439, -0.071> <0.233, 2.806, -0.045> 
		<0.159, 1.951, -0.131> <0.176, 2.318, -0.097> <0.253, 2.805, -0.023> <0.219, 3.172, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 1.951, -0.155> <0.233, 1.951, -0.156> <0.188, 1.951, -0.146> <0.159, 1.951, -0.131> 
		<0.231, 1.362, -0.235> <0.198, 1.362, -0.236> <0.160, 1.366, -0.201> <0.131, 1.366, -0.185> 
		<0.093, 0.581, -0.317> <0.056, 0.581, -0.297> <0.087, 0.584, -0.268> <0.089, 0.584, -0.226> 
		<0.031, 0.000, -0.428> <-0.006, 0.000, -0.407> <0.067, 0.000, -0.335> <0.070, 0.000, -0.292> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.159, 1.951, -0.131> <0.114, 1.951, -0.108> <0.061, 1.951, -0.065> <0.027, 1.951, -0.029> 
		<0.131, 1.366, -0.185> <0.087, 1.366, -0.162> <0.082, 1.366, -0.063> <0.047, 1.366, -0.026> 
		<0.089, 0.584, -0.226> <0.095, 0.584, -0.146> <0.055, 0.585, -0.112> <0.048, 0.585, -0.032> 
		<0.070, 0.000, -0.292> <0.076, 0.000, -0.212> <0.066, 0.000, -0.105> <0.060, 0.000, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.159, 1.951, -0.131> <0.176, 2.318, -0.097> <0.253, 2.805, -0.023> <0.219, 3.172, 0.002> 
		<0.114, 1.951, -0.108> <0.132, 2.318, -0.074> <0.185, 2.805, -0.070> <0.151, 3.172, -0.044> 
		<0.061, 1.951, -0.065> <0.048, 2.318, -0.067> <0.052, 2.806, -0.046> <0.028, 3.172, -0.049> 
		<0.027, 1.951, -0.029> <0.013, 2.318, -0.030> <-0.029, 2.806, -0.035> <-0.053, 3.172, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 1.951, -0.029> <0.004, 1.951, -0.005> <-0.012, 1.951, 0.038> <-0.026, 1.951, 0.067> 
		<0.047, 1.366, -0.026> <0.025, 1.366, -0.002> <0.004, 1.366, 0.065> <-0.010, 1.366, 0.094> 
		<0.048, 0.585, -0.032> <0.045, 0.585, 0.008> <-0.009, 0.585, 0.047> <0.011, 0.585, 0.082> 
		<0.060, 0.000, -0.025> <0.056, 0.000, 0.015> <0.015, 0.000, 0.073> <0.036, 0.000, 0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 1.951, -0.029> <0.027, 1.951, -0.029> <0.027, 1.951, -0.029> <0.027, 1.951, -0.029> 
		<0.004, 1.951, -0.005> <-0.009, 2.318, -0.006> <-0.009, 2.318, -0.006> <0.013, 2.318, -0.030> 
		<-0.012, 1.951, 0.038> <-0.023, 2.318, 0.021> <-0.026, 2.439, -0.004> <-0.029, 2.806, -0.035> 
		<-0.026, 1.951, 0.067> <-0.036, 2.318, 0.050> <-0.050, 2.806, -0.007> <-0.053, 3.172, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.026, 1.951, 0.067> <-0.036, 2.318, 0.050> <-0.050, 2.806, -0.007> <-0.053, 3.172, -0.038> 
		<-0.051, 1.951, 0.121> <-0.061, 2.318, 0.104> <-0.114, 2.806, 0.002> <-0.118, 3.172, -0.029> 
		<-0.097, 1.951, 0.190> <-0.154, 2.319, 0.163> <-0.194, 2.807, 0.096> <-0.198, 3.172, 0.018> 
		<-0.101, 1.951, 0.248> <-0.158, 2.319, 0.222> <-0.240, 2.807, 0.142> <-0.244, 3.172, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.026, 1.951, 0.067> <-0.051, 1.951, 0.121> <-0.097, 1.951, 0.190> <-0.101, 1.951, 0.248> 
		<-0.010, 1.366, 0.094> <-0.034, 1.366, 0.148> <-0.007, 1.365, 0.232> <-0.011, 1.365, 0.291> 
		<0.011, 0.585, 0.082> <0.053, 0.585, 0.155> <0.073, 0.584, 0.207> <0.142, 0.584, 0.255> 
		<0.036, 0.000, 0.109> <0.077, 0.000, 0.181> <0.174, 0.000, 0.247> <0.243, 0.000, 0.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.101, 1.951, 0.248> <-0.106, 1.951, 0.316> <-0.078, 1.951, 0.405> <-0.054, 1.951, 0.468> 
		<-0.011, 1.365, 0.291> <-0.016, 1.365, 0.358> <0.076, 1.364, 0.437> <0.101, 1.364, 0.500> 
		<0.142, 0.584, 0.255> <0.212, 0.584, 0.302> <0.232, 0.581, 0.419> <0.315, 0.581, 0.434> 
		<0.243, 0.000, 0.295> <0.313, 0.000, 0.343> <0.410, 0.000, 0.408> <0.493, 0.000, 0.423> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.101, 1.951, 0.248> <-0.158, 2.319, 0.222> <-0.240, 2.807, 0.142> <-0.244, 3.172, 0.064> 
		<-0.106, 1.951, 0.316> <-0.162, 2.319, 0.289> <-0.285, 2.807, 0.186> <-0.289, 3.172, 0.109> 
		<-0.078, 1.951, 0.405> <-0.175, 2.320, 0.385> <-0.250, 2.806, 0.253> <-0.337, 3.172, 0.187> 
		<-0.054, 1.951, 0.468> <-0.151, 2.320, 0.448> <-0.256, 2.806, 0.316> <-0.342, 3.172, 0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.054, 1.951, 0.468> <-0.034, 1.951, 0.519> <0.003, 1.951, 0.587> <0.045, 1.951, 0.623> 
		<0.101, 1.364, 0.500> <0.121, 1.364, 0.552> <0.232, 1.355, 0.617> <0.274, 1.355, 0.653> 
		<0.315, 0.581, 0.434> <0.428, 0.581, 0.455> <0.459, 0.564, 0.408> <0.574, 0.564, 0.411> 
		<0.493, 0.000, 0.423> <0.606, 0.000, 0.444> <0.761, 0.000, 0.409> <0.876, 0.000, 0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.054, 1.951, 0.468> <-0.054, 1.951, 0.468> <-0.054, 1.951, 0.468> <-0.054, 1.951, 0.468> 
		<-0.034, 1.951, 0.519> <-0.131, 2.320, 0.499> <-0.131, 2.320, 0.499> <-0.151, 2.320, 0.448> 
		<0.003, 1.951, 0.587> <-0.140, 2.324, 0.568> <-0.211, 2.434, 0.457> <-0.256, 2.806, 0.316> 
		<0.045, 1.951, 0.623> <-0.099, 2.324, 0.604> <-0.298, 2.800, 0.392> <-0.342, 3.172, 0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 1.951, 0.623> <0.081, 1.951, 0.654> <0.146, 1.951, 0.676> <0.194, 1.951, 0.681> 
		<0.274, 1.355, 0.653> <0.310, 1.355, 0.684> <0.383, 1.360, 0.657> <0.431, 1.360, 0.662> 
		<0.574, 0.564, 0.411> <0.609, 0.564, 0.411> <0.680, 0.560, 0.473> <0.687, 0.560, 0.439> 
		<0.876, 0.000, 0.412> <0.911, 0.000, 0.412> <0.984, 0.000, 0.467> <0.990, 0.000, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 1.951, 0.623> <-0.099, 2.324, 0.604> <-0.298, 2.800, 0.392> <-0.342, 3.172, 0.250> 
		<0.081, 1.951, 0.654> <-0.062, 2.324, 0.635> <-0.305, 2.800, 0.479> <-0.349, 3.172, 0.337> 
		<0.146, 1.951, 0.676> <-0.001, 2.318, 0.688> <-0.195, 2.806, 0.512> <-0.338, 3.172, 0.468> 
		<0.194, 1.951, 0.681> <0.047, 2.318, 0.693> <-0.139, 2.806, 0.579> <-0.282, 3.172, 0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.194, 1.951, 0.681> <0.241, 1.951, 0.686> <0.303, 1.951, 0.666> <0.348, 1.951, 0.654> 
		<0.431, 1.360, 0.662> <0.478, 1.360, 0.667> <0.523, 1.369, 0.602> <0.569, 1.369, 0.590> 
		<0.687, 0.560, 0.439> <0.701, 0.560, 0.363> <0.746, 0.592, 0.374> <0.750, 0.592, 0.297> 
		<0.990, 0.000, 0.433> <1.004, 0.000, 0.357> <0.914, 0.000, 0.264> <0.918, 0.000, 0.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.194, 1.951, 0.681> <0.194, 1.951, 0.681> <0.194, 1.951, 0.681> <0.194, 1.951, 0.681> 
		<0.241, 1.951, 0.686> <0.093, 2.318, 0.697> <0.093, 2.318, 0.697> <0.047, 2.318, 0.693> 
		<0.303, 1.951, 0.666> <0.157, 2.336, 0.708> <-0.021, 2.435, 0.719> <-0.139, 2.806, 0.579> 
		<0.348, 1.951, 0.654> <0.202, 2.336, 0.696> <-0.164, 2.801, 0.675> <-0.282, 3.172, 0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.348, 1.951, 0.654> <0.408, 1.951, 0.639> <0.490, 1.951, 0.622> <0.544, 1.951, 0.593> 
		<0.569, 1.369, 0.590> <0.628, 1.369, 0.575> <0.680, 1.360, 0.484> <0.734, 1.360, 0.454> 
		<0.750, 0.592, 0.297> <0.756, 0.592, 0.211> <0.798, 0.589, 0.152> <0.848, 0.589, 0.082> 
		<0.918, 0.000, 0.187> <0.924, 0.000, 0.101> <0.971, 0.000, -0.012> <1.022, 0.000, -0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.348, 1.951, 0.654> <0.202, 2.336, 0.696> <-0.164, 2.801, 0.675> <-0.282, 3.172, 0.535> 
		<0.408, 1.951, 0.639> <0.262, 2.336, 0.681> <-0.104, 2.801, 0.747> <-0.222, 3.172, 0.607> 
		<0.490, 1.951, 0.622> <0.371, 2.324, 0.710> <0.072, 2.806, 0.644> <-0.090, 3.172, 0.665> 
		<0.544, 1.951, 0.593> <0.425, 2.324, 0.680> <0.166, 2.806, 0.642> <0.004, 3.172, 0.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.544, 1.951, 0.593> <0.585, 1.951, 0.570> <0.638, 1.951, 0.528> <0.655, 1.951, 0.485> 
		<0.734, 1.360, 0.454> <0.774, 1.360, 0.432> <0.857, 1.369, 0.370> <0.874, 1.369, 0.327> 
		<0.848, 0.589, 0.082> <0.886, 0.589, 0.030> <0.962, 0.556, 0.040> <0.937, 0.556, -0.018> 
		<1.022, 0.000, -0.082> <1.059, 0.000, -0.134> <1.224, 0.000, -0.144> <1.198, 0.000, -0.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.544, 1.951, 0.593> <0.544, 1.951, 0.593> <0.544, 1.951, 0.593> <0.544, 1.951, 0.593> 
		<0.585, 1.951, 0.570> <0.465, 2.324, 0.658> <0.465, 2.324, 0.658> <0.425, 2.324, 0.680> 
		<0.638, 1.951, 0.528> <0.495, 2.330, 0.632> <0.341, 2.435, 0.727> <0.166, 2.806, 0.642> 
		<0.655, 1.951, 0.485> <0.512, 2.330, 0.589> <0.179, 2.802, 0.748> <0.004, 3.172, 0.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 1.951, 0.485> <0.675, 1.951, 0.436> <0.645, 1.951, 0.359> <0.657, 1.951, 0.307> 
		<0.874, 1.369, 0.327> <0.894, 1.369, 0.277> <0.757, 1.361, 0.198> <0.769, 1.361, 0.146> 
		<0.937, 0.556, -0.018> <0.897, 0.556, -0.108> <0.873, 0.587, -0.093> <0.809, 0.587, -0.166> 
		<1.198, 0.000, -0.203> <1.158, 0.000, -0.293> <0.969, 0.000, -0.274> <0.904, 0.000, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 1.951, 0.485> <0.512, 2.330, 0.589> <0.179, 2.802, 0.748> <0.004, 3.172, 0.663> 
		<0.675, 1.951, 0.436> <0.532, 2.330, 0.539> <0.278, 2.802, 0.746> <0.103, 3.172, 0.660> 
		<0.645, 1.951, 0.359> <0.575, 2.318, 0.459> <0.346, 2.806, 0.532> <0.239, 3.172, 0.596> 
		<0.657, 1.951, 0.307> <0.587, 2.318, 0.407> <0.408, 2.806, 0.455> <0.301, 3.172, 0.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.657, 1.951, 0.307> <0.668, 1.951, 0.263> <0.742, 1.951, 0.216> <0.729, 1.951, 0.172> 
		<0.769, 1.361, 0.146> <0.780, 1.361, 0.101> <0.838, 1.362, 0.002> <0.825, 1.362, -0.042> 
		<0.809, 0.587, -0.166> <0.749, 0.587, -0.234> <0.766, 0.565, -0.300> <0.709, 0.565, -0.370> 
		<0.904, 0.000, -0.348> <0.845, 0.000, -0.416> <0.875, 0.000, -0.566> <0.818, 0.000, -0.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.657, 1.951, 0.307> <0.657, 1.951, 0.307> <0.657, 1.951, 0.307> <0.657, 1.951, 0.307> 
		<0.668, 1.951, 0.263> <0.598, 2.318, 0.363> <0.598, 2.318, 0.363> <0.587, 2.318, 0.407> 
		<0.742, 1.951, 0.216> <0.681, 2.324, 0.352> <0.576, 2.441, 0.463> <0.408, 2.806, 0.455> 
		<0.729, 1.951, 0.172> <0.668, 2.324, 0.308> <0.469, 2.807, 0.526> <0.301, 3.172, 0.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.729, 1.951, 0.172> <0.708, 1.951, 0.099> <0.615, 1.951, 0.033> <0.562, 1.951, -0.022> 
		<0.825, 1.362, -0.042> <0.803, 1.362, -0.116> <0.688, 1.364, -0.112> <0.634, 1.364, -0.167> 
		<0.709, 0.565, -0.370> <0.686, 0.565, -0.397> <0.710, 0.581, -0.390> <0.677, 0.581, -0.378> 
		<0.818, 0.000, -0.635> <0.795, 0.000, -0.663> <0.771, 0.000, -0.562> <0.738, 0.000, -0.549> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.729, 1.951, 0.172> <0.668, 2.324, 0.308> <0.469, 2.807, 0.526> <0.301, 3.172, 0.518> 
		<0.708, 1.951, 0.099> <0.647, 2.324, 0.234> <0.523, 2.807, 0.460> <0.355, 3.172, 0.451> 
		<0.615, 1.951, 0.033> <0.570, 2.317, 0.124> <0.424, 2.806, 0.243> <0.360, 3.172, 0.321> 
		<0.562, 1.951, -0.022> <0.517, 2.317, 0.069> <0.411, 2.806, 0.159> <0.346, 3.172, 0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 3.172, -0.214> <0.150, 3.172, -0.175> <0.078, 3.172, -0.141> <0.025, 3.172, -0.143> 
		<0.188, 3.649, -0.130> <0.153, 3.649, -0.091> <0.079, 3.648, -0.133> <0.026, 3.648, -0.135> 
		<0.104, 4.278, 0.023> <0.071, 4.278, -0.011> <-0.001, 4.282, -0.057> <0.003, 4.282, -0.104> 
		<0.042, 4.758, 0.046> <0.009, 4.758, 0.013> <-0.017, 4.758, -0.054> <-0.012, 4.758, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 3.172, -0.214> <0.188, 3.649, -0.130> <0.104, 4.278, 0.023> <0.042, 4.758, 0.046> 
		<0.236, 3.172, -0.272> <0.239, 3.649, -0.187> <0.151, 4.278, 0.072> <0.090, 4.758, 0.095> 
		<0.291, 3.172, -0.368> <0.339, 3.657, -0.222> <0.269, 4.266, 0.059> <0.173, 4.758, 0.150> 
		<0.295, 3.172, -0.445> <0.343, 3.657, -0.298> <0.337, 4.266, 0.067> <0.240, 4.758, 0.157> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.295, 3.172, -0.445> <0.343, 3.657, -0.298> <0.337, 4.266, 0.067> <0.240, 4.758, 0.157> 
		<0.299, 3.172, -0.537> <0.347, 3.657, -0.390> <0.418, 4.266, 0.076> <0.322, 4.758, 0.166> 
		<0.277, 3.172, -0.678> <0.438, 3.670, -0.525> <0.523, 4.249, -0.027> <0.448, 4.758, 0.155> 
		<0.208, 3.172, -0.739> <0.370, 3.670, -0.586> <0.582, 4.249, -0.085> <0.507, 4.758, 0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.208, 3.172, -0.739> <0.370, 3.670, -0.586> <0.582, 4.249, -0.085> <0.507, 4.758, 0.098> 
		<0.129, 3.172, -0.810> <0.291, 3.670, -0.657> <0.649, 4.249, -0.151> <0.574, 4.758, 0.032> 
		<-0.028, 3.172, -0.829> <0.199, 3.676, -0.756> <0.573, 4.243, -0.320> <0.601, 4.758, -0.107> 
		<-0.134, 3.172, -0.827> <0.094, 3.676, -0.754> <0.578, 4.243, -0.414> <0.605, 4.758, -0.201> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.134, 3.172, -0.827> <0.094, 3.676, -0.754> <0.578, 4.243, -0.414> <0.605, 4.758, -0.201> 
		<-0.184, 3.172, -0.826> <0.043, 3.676, -0.754> <0.580, 4.243, -0.459> <0.608, 4.758, -0.245> 
		<-0.242, 3.172, -0.772> <-0.023, 3.672, -0.755> <0.493, 4.248, -0.483> <0.562, 4.758, -0.300> 
		<-0.270, 3.172, -0.730> <-0.051, 3.672, -0.713> <0.458, 4.248, -0.511> <0.527, 4.758, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.270, 3.172, -0.730> <-0.051, 3.672, -0.713> <0.458, 4.248, -0.511> <0.527, 4.758, -0.328> 
		<-0.309, 3.172, -0.673> <-0.090, 3.672, -0.656> <0.409, 4.248, -0.549> <0.479, 4.758, -0.366> 
		<-0.350, 3.172, -0.582> <-0.192, 3.664, -0.630> <0.309, 4.260, -0.522> <0.401, 4.758, -0.407> 
		<-0.348, 3.172, -0.513> <-0.190, 3.664, -0.561> <0.247, 4.260, -0.525> <0.339, 4.758, -0.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.348, 3.172, -0.513> <-0.190, 3.664, -0.561> <0.247, 4.260, -0.525> <0.339, 4.758, -0.410> 
		<-0.346, 3.172, -0.424> <-0.188, 3.664, -0.472> <0.168, 4.260, -0.528> <0.260, 4.758, -0.413> 
		<-0.323, 3.172, -0.293> <-0.268, 3.653, -0.353> <0.076, 4.275, -0.431> <0.141, 4.758, -0.401> 
		<-0.260, 3.172, -0.230> <-0.205, 3.653, -0.291> <0.017, 4.275, -0.378> <0.082, 4.758, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.260, 3.172, -0.230> <-0.205, 3.653, -0.291> <0.017, 4.275, -0.378> <0.082, 4.758, -0.348> 
		<-0.196, 3.172, -0.167> <-0.142, 3.653, -0.228> <-0.043, 4.275, -0.326> <0.022, 4.758, -0.296> 
		<-0.064, 3.172, -0.146> <-0.063, 3.648, -0.138> <0.012, 4.282, -0.183> <-0.004, 4.758, -0.179> 
		<0.025, 3.172, -0.143> <0.026, 3.648, -0.135> <0.003, 4.282, -0.104> <-0.012, 4.758, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 3.172, 0.518> <0.239, 3.172, 0.596> <0.103, 3.172, 0.660> <0.004, 3.172, 0.663> 
		<0.068, 3.677, 0.507> <0.006, 3.677, 0.584> <-0.138, 3.680, 0.543> <-0.237, 3.680, 0.545> 
		<-0.469, 4.246, 0.304> <-0.534, 4.246, 0.244> <-0.674, 4.237, 0.166> <-0.670, 4.237, 0.077> 
		<-0.566, 4.758, 0.110> <-0.631, 4.758, 0.050> <-0.681, 4.758, -0.075> <-0.677, 4.758, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 3.172, 0.518> <0.068, 3.677, 0.507> <-0.469, 4.246, 0.304> <-0.566, 4.758, 0.110> 
		<0.355, 3.172, 0.451> <0.122, 3.677, 0.440> <-0.412, 4.246, 0.356> <-0.510, 4.758, 0.161> 
		<0.360, 3.172, 0.321> <0.225, 3.668, 0.371> <-0.286, 4.264, 0.279> <-0.394, 4.758, 0.173> 
		<0.346, 3.172, 0.236> <0.211, 3.668, 0.287> <-0.210, 4.264, 0.272> <-0.318, 4.758, 0.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.346, 3.172, 0.236> <0.211, 3.668, 0.287> <-0.210, 4.264, 0.272> <-0.318, 4.758, 0.166> 
		<0.334, 3.172, 0.157> <0.199, 3.668, 0.208> <-0.139, 4.264, 0.265> <-0.247, 4.758, 0.160> 
		<0.285, 3.172, 0.048> <0.240, 3.655, 0.082> <-0.076, 4.278, 0.158> <-0.147, 4.758, 0.123> 
		<0.219, 3.172, 0.002> <0.174, 3.655, 0.036> <-0.032, 4.278, 0.103> <-0.103, 4.758, 0.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, 3.172, 0.002> <0.174, 3.655, 0.036> <-0.032, 4.278, 0.103> <-0.103, 4.758, 0.067> 
		<0.151, 3.172, -0.044> <0.106, 3.655, -0.010> <0.013, 4.278, 0.045> <-0.057, 4.758, 0.009> 
		<0.028, 3.172, -0.049> <0.024, 3.648, -0.090> <-0.053, 4.281, -0.076> <-0.046, 4.758, -0.099> 
		<-0.053, 3.172, -0.038> <-0.058, 3.648, -0.079> <-0.057, 4.281, -0.150> <-0.051, 4.758, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, 3.172, -0.038> <-0.058, 3.648, -0.079> <-0.057, 4.281, -0.150> <-0.051, 4.758, -0.173> 
		<-0.118, 3.172, -0.029> <-0.122, 3.648, -0.070> <-0.061, 4.281, -0.208> <-0.055, 4.758, -0.230> 
		<-0.198, 3.172, 0.018> <-0.203, 3.654, -0.084> <-0.154, 4.272, -0.253> <-0.092, 4.758, -0.305> 
		<-0.244, 3.172, 0.064> <-0.249, 3.654, -0.038> <-0.192, 4.272, -0.297> <-0.130, 4.758, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, 3.172, 0.064> <-0.249, 3.654, -0.038> <-0.192, 4.272, -0.297> <-0.130, 4.758, -0.348> 
		<-0.289, 3.172, 0.109> <-0.294, 3.654, 0.006> <-0.229, 4.272, -0.339> <-0.167, 4.758, -0.391> 
		<-0.337, 3.172, 0.187> <-0.395, 3.655, 0.004> <-0.328, 4.258, -0.330> <-0.235, 4.758, -0.438> 
		<-0.342, 3.172, 0.250> <-0.400, 3.655, 0.067> <-0.384, 4.258, -0.339> <-0.290, 4.758, -0.446> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, 3.172, 0.250> <-0.400, 3.655, 0.067> <-0.384, 4.258, -0.339> <-0.290, 4.758, -0.446> 
		<-0.349, 3.172, 0.337> <-0.407, 3.655, 0.153> <-0.460, 4.258, -0.350> <-0.367, 4.758, -0.458> 
		<-0.338, 3.172, 0.468> <-0.498, 3.673, 0.278> <-0.563, 4.241, -0.258> <-0.484, 4.758, -0.456> 
		<-0.282, 3.172, 0.535> <-0.442, 3.673, 0.345> <-0.626, 4.241, -0.212> <-0.546, 4.758, -0.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.282, 3.172, 0.535> <-0.442, 3.673, 0.345> <-0.626, 4.241, -0.212> <-0.546, 4.758, -0.410> 
		<-0.222, 3.172, 0.607> <-0.382, 3.673, 0.417> <-0.694, 4.241, -0.162> <-0.614, 4.758, -0.361> 
		<-0.090, 3.172, 0.665> <-0.331, 3.680, 0.548> <-0.667, 4.237, -0.006> <-0.674, 4.758, -0.247> 
		<0.004, 3.172, 0.663> <-0.237, 3.680, 0.545> <-0.670, 4.237, 0.077> <-0.677, 4.758, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 4.758, 0.046> <0.009, 4.758, 0.013> <-0.017, 4.758, -0.054> <-0.012, 4.758, -0.100> 
		<-0.014, 5.191, 0.067> <-0.046, 5.191, 0.034> <-0.031, 5.188, -0.050> <-0.026, 5.188, -0.097> 
		<-0.180, 5.757, -0.012> <-0.151, 5.757, -0.042> <-0.109, 5.760, -0.109> <-0.068, 5.760, -0.106> 
		<-0.203, 6.189, -0.067> <-0.174, 6.189, -0.097> <-0.116, 6.189, -0.122> <-0.075, 6.189, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 4.758, 0.046> <-0.014, 5.191, 0.067> <-0.180, 5.757, -0.012> <-0.203, 6.189, -0.067> 
		<0.090, 4.758, 0.095> <0.034, 5.191, 0.116> <-0.221, 5.757, 0.031> <-0.244, 6.189, -0.024> 
		<0.173, 4.758, 0.150> <0.086, 5.201, 0.231> <-0.208, 5.747, 0.139> <-0.291, 6.189, 0.051> 
		<0.240, 4.758, 0.157> <0.154, 5.201, 0.239> <-0.213, 5.747, 0.200> <-0.296, 6.189, 0.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.240, 4.758, 0.157> <0.154, 5.201, 0.239> <-0.213, 5.747, 0.200> <-0.296, 6.189, 0.111> 
		<0.322, 4.758, 0.166> <0.235, 5.201, 0.248> <-0.219, 5.747, 0.272> <-0.302, 6.189, 0.183> 
		<0.448, 4.758, 0.155> <0.381, 5.214, 0.319> <-0.123, 5.735, 0.367> <-0.288, 6.189, 0.294> 
		<0.507, 4.758, 0.098> <0.440, 5.214, 0.262> <-0.071, 5.735, 0.417> <-0.236, 6.189, 0.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.507, 4.758, 0.098> <0.440, 5.214, 0.262> <-0.071, 5.735, 0.417> <-0.236, 6.189, 0.344> 
		<0.574, 4.758, 0.032> <0.507, 5.214, 0.196> <-0.011, 5.735, 0.475> <-0.176, 6.189, 0.402> 
		<0.601, 4.758, -0.107> <0.626, 5.219, 0.084> <0.143, 5.731, 0.404> <-0.053, 6.189, 0.422> 
		<0.605, 4.758, -0.201> <0.630, 5.219, -0.010> <0.226, 5.731, 0.405> <0.030, 6.189, 0.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.605, 4.758, -0.201> <0.630, 5.219, -0.010> <0.226, 5.731, 0.405> <0.030, 6.189, 0.424> 
		<0.608, 4.758, -0.245> <0.633, 5.219, -0.055> <0.266, 5.731, 0.406> <0.070, 6.189, 0.424> 
		<0.562, 4.758, -0.300> <0.625, 5.215, -0.137> <0.288, 5.734, 0.326> <0.117, 6.189, 0.383> 
		<0.527, 4.758, -0.328> <0.589, 5.215, -0.164> <0.311, 5.734, 0.294> <0.140, 6.189, 0.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.527, 4.758, -0.328> <0.589, 5.215, -0.164> <0.311, 5.734, 0.294> <0.140, 6.189, 0.351> 
		<0.479, 4.758, -0.366> <0.541, 5.215, -0.202> <0.343, 5.734, 0.251> <0.173, 6.189, 0.308> 
		<0.401, 4.758, -0.407> <0.483, 5.205, -0.304> <0.318, 5.743, 0.158> <0.207, 6.189, 0.237> 
		<0.339, 4.758, -0.410> <0.422, 5.205, -0.307> <0.319, 5.743, 0.103> <0.208, 6.189, 0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, 4.758, -0.410> <0.422, 5.205, -0.307> <0.319, 5.743, 0.103> <0.208, 6.189, 0.183> 
		<0.260, 4.758, -0.413> <0.342, 5.205, -0.310> <0.320, 5.743, 0.033> <0.209, 6.189, 0.113> 
		<0.141, 4.758, -0.401> <0.200, 5.193, -0.374> <0.228, 5.755, -0.050> <0.194, 6.189, 0.009> 
		<0.082, 4.758, -0.348> <0.140, 5.193, -0.321> <0.180, 5.755, -0.102> <0.147, 6.189, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 4.758, -0.348> <0.140, 5.193, -0.321> <0.180, 5.755, -0.102> <0.147, 6.189, -0.042> 
		<0.022, 4.758, -0.296> <0.081, 5.193, -0.269> <0.132, 5.755, -0.153> <0.099, 6.189, -0.094> 
		<-0.004, 4.758, -0.179> <-0.018, 5.188, -0.176> <0.002, 5.760, -0.101> <-0.005, 6.189, -0.114> 
		<-0.012, 4.758, -0.100> <-0.026, 5.188, -0.097> <-0.068, 5.760, -0.106> <-0.075, 6.189, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.566, 4.758, 0.110> <-0.631, 4.758, 0.050> <-0.681, 4.758, -0.075> <-0.677, 4.758, -0.164> 
		<-0.653, 5.212, -0.063> <-0.718, 5.212, -0.123> <-0.687, 5.214, -0.286> <-0.683, 5.214, -0.375> 
		<-0.440, 5.738, -0.552> <-0.389, 5.738, -0.611> <-0.315, 5.736, -0.741> <-0.237, 5.736, -0.740> 
		<-0.275, 6.197, -0.631> <-0.224, 6.197, -0.690> <-0.115, 6.197, -0.737> <-0.037, 6.197, -0.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.566, 4.758, 0.110> <-0.653, 5.212, -0.063> <-0.440, 5.738, -0.552> <-0.275, 6.197, -0.631> 
		<-0.510, 4.758, 0.161> <-0.596, 5.212, -0.011> <-0.484, 5.738, -0.501> <-0.319, 6.197, -0.580> 
		<-0.394, 4.758, 0.173> <-0.492, 5.202, 0.078> <-0.414, 5.749, -0.384> <-0.327, 6.197, -0.477> 
		<-0.318, 4.758, 0.166> <-0.416, 5.202, 0.071> <-0.405, 5.749, -0.317> <-0.319, 6.197, -0.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.318, 4.758, 0.166> <-0.416, 5.202, 0.071> <-0.405, 5.749, -0.317> <-0.319, 6.197, -0.410> 
		<-0.247, 4.758, 0.160> <-0.345, 5.202, 0.065> <-0.398, 5.749, -0.254> <-0.311, 6.197, -0.348> 
		<-0.147, 4.758, 0.123> <-0.211, 5.194, 0.090> <-0.298, 5.760, -0.198> <-0.276, 6.197, -0.260> 
		<-0.103, 4.758, 0.067> <-0.167, 5.194, 0.034> <-0.248, 5.760, -0.161> <-0.225, 6.197, -0.223> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.103, 4.758, 0.067> <-0.167, 5.194, 0.034> <-0.248, 5.760, -0.161> <-0.225, 6.197, -0.223> 
		<-0.057, 4.758, 0.009> <-0.121, 5.194, -0.023> <-0.195, 5.760, -0.122> <-0.173, 6.197, -0.184> 
		<-0.046, 4.758, -0.099> <-0.040, 5.189, -0.120> <-0.085, 5.765, -0.185> <-0.077, 6.197, -0.177> 
		<-0.051, 4.758, -0.173> <-0.045, 5.189, -0.194> <-0.020, 5.765, -0.191> <-0.012, 6.197, -0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.051, 4.758, -0.173> <-0.045, 5.189, -0.194> <-0.020, 5.765, -0.191> <-0.012, 6.197, -0.183> 
		<-0.055, 4.758, -0.230> <-0.049, 5.189, -0.251> <0.031, 5.765, -0.196> <0.038, 6.197, -0.188> 
		<-0.092, 4.758, -0.305> <-0.037, 5.192, -0.351> <0.072, 5.762, -0.282> <0.103, 6.197, -0.223> 
		<-0.130, 4.758, -0.348> <-0.075, 5.192, -0.394> <0.110, 5.762, -0.316> <0.140, 6.197, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 4.758, -0.348> <-0.075, 5.192, -0.394> <0.110, 5.762, -0.316> <0.140, 6.197, -0.258> 
		<-0.167, 4.758, -0.391> <-0.112, 5.192, -0.437> <0.146, 5.762, -0.350> <0.177, 6.197, -0.292> 
		<-0.235, 4.758, -0.438> <-0.152, 5.199, -0.533> <0.138, 5.754, -0.441> <0.217, 6.197, -0.352> 
		<-0.290, 4.758, -0.446> <-0.208, 5.199, -0.541> <0.144, 5.754, -0.490> <0.223, 6.197, -0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.290, 4.758, -0.446> <-0.208, 5.199, -0.541> <0.144, 5.754, -0.490> <0.223, 6.197, -0.401> 
		<-0.367, 4.758, -0.458> <-0.285, 5.199, -0.553> <0.152, 5.754, -0.558> <0.231, 6.197, -0.470> 
		<-0.484, 4.758, -0.456> <-0.414, 5.209, -0.629> <0.068, 5.741, -0.652> <0.226, 6.197, -0.573> 
		<-0.546, 4.758, -0.410> <-0.477, 5.209, -0.583> <0.026, 5.741, -0.706> <0.184, 6.197, -0.627> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.546, 4.758, -0.410> <-0.477, 5.209, -0.583> <0.026, 5.741, -0.706> <0.184, 6.197, -0.627> 
		<-0.614, 4.758, -0.361> <-0.544, 5.209, -0.534> <-0.020, 5.741, -0.764> <0.139, 6.197, -0.685> 
		<-0.674, 4.758, -0.247> <-0.680, 5.214, -0.458> <-0.163, 5.736, -0.739> <0.037, 6.197, -0.735> 
		<-0.677, 4.758, -0.164> <-0.683, 5.214, -0.375> <-0.237, 5.736, -0.740> <-0.037, 6.197, -0.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.203, 6.189, -0.067> <-0.174, 6.189, -0.097> <-0.116, 6.189, -0.122> <-0.075, 6.189, -0.119> 
		<-0.223, 6.582, -0.117> <-0.195, 6.582, -0.147> <-0.122, 6.579, -0.134> <-0.081, 6.579, -0.131> 
		<-0.148, 7.093, -0.279> <-0.120, 7.093, -0.252> <-0.062, 7.097, -0.212> <-0.065, 7.097, -0.174> 
		<-0.102, 7.486, -0.301> <-0.075, 7.486, -0.274> <-0.053, 7.486, -0.220> <-0.056, 7.486, -0.181> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.203, 6.189, -0.067> <-0.223, 6.582, -0.117> <-0.148, 7.093, -0.279> <-0.102, 7.486, -0.301> 
		<-0.244, 6.189, -0.024> <-0.265, 6.582, -0.074> <-0.188, 7.093, -0.318> <-0.142, 7.486, -0.341> 
		<-0.291, 6.189, 0.051> <-0.366, 6.592, -0.030> <-0.284, 7.082, -0.310> <-0.211, 7.486, -0.385> 
		<-0.296, 6.189, 0.111> <-0.371, 6.592, 0.030> <-0.340, 7.082, -0.315> <-0.267, 7.486, -0.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.296, 6.189, 0.111> <-0.371, 6.592, 0.030> <-0.340, 7.082, -0.315> <-0.267, 7.486, -0.390> 
		<-0.302, 6.189, 0.183> <-0.376, 6.592, 0.102> <-0.407, 7.082, -0.322> <-0.334, 7.486, -0.397> 
		<-0.288, 6.189, 0.294> <-0.439, 6.604, 0.228> <-0.495, 7.068, -0.239> <-0.439, 7.486, -0.386> 
		<-0.236, 6.189, 0.344> <-0.387, 6.604, 0.278> <-0.542, 7.068, -0.191> <-0.486, 7.486, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.236, 6.189, 0.344> <-0.387, 6.604, 0.278> <-0.542, 7.068, -0.191> <-0.486, 7.486, -0.338> 
		<-0.176, 6.189, 0.402> <-0.327, 6.604, 0.336> <-0.597, 7.068, -0.136> <-0.541, 7.486, -0.282> 
		<-0.053, 6.189, 0.422> <-0.232, 6.607, 0.439> <-0.537, 7.065, 0.002> <-0.561, 7.486, -0.168> 
		<0.030, 6.189, 0.424> <-0.149, 6.607, 0.441> <-0.539, 7.065, 0.080> <-0.563, 7.486, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 6.189, 0.424> <-0.149, 6.607, 0.441> <-0.539, 7.065, 0.080> <-0.563, 7.486, -0.091> 
		<0.070, 6.189, 0.424> <-0.109, 6.607, 0.441> <-0.541, 7.065, 0.117> <-0.564, 7.486, -0.054> 
		<0.117, 6.189, 0.383> <-0.039, 6.603, 0.435> <-0.470, 7.069, 0.138> <-0.527, 7.486, -0.009> 
		<0.140, 6.189, 0.351> <-0.015, 6.603, 0.403> <-0.441, 7.069, 0.160> <-0.497, 7.486, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 6.189, 0.351> <-0.015, 6.603, 0.403> <-0.441, 7.069, 0.160> <-0.497, 7.486, 0.013> 
		<0.173, 6.189, 0.308> <0.017, 6.603, 0.359> <-0.401, 7.069, 0.191> <-0.457, 7.486, 0.044> 
		<0.207, 6.189, 0.237> <0.106, 6.594, 0.310> <-0.318, 7.079, 0.171> <-0.392, 7.486, 0.077> 
		<0.208, 6.189, 0.183> <0.107, 6.594, 0.256> <-0.268, 7.079, 0.172> <-0.341, 7.486, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.208, 6.189, 0.183> <0.107, 6.594, 0.256> <-0.268, 7.079, 0.172> <-0.341, 7.486, 0.078> 
		<0.209, 6.189, 0.113> <0.108, 6.594, 0.186> <-0.202, 7.079, 0.174> <-0.276, 7.486, 0.080> 
		<0.194, 6.189, 0.009> <0.164, 6.583, 0.063> <-0.126, 7.092, 0.096> <-0.178, 7.486, 0.068> 
		<0.147, 6.189, -0.042> <0.116, 6.583, 0.011> <-0.077, 7.092, 0.052> <-0.130, 7.486, 0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 6.189, -0.042> <0.116, 6.583, 0.011> <-0.077, 7.092, 0.052> <-0.130, 7.486, 0.024> 
		<0.099, 6.189, -0.094> <0.068, 6.583, -0.040> <-0.029, 7.092, 0.008> <-0.082, 7.486, -0.020> 
		<-0.005, 6.189, -0.114> <-0.011, 6.579, -0.126> <-0.071, 7.097, -0.109> <-0.061, 7.486, -0.116> 
		<-0.075, 6.189, -0.119> <-0.081, 6.579, -0.131> <-0.065, 7.097, -0.174> <-0.056, 7.486, -0.181> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.275, 6.197, -0.631> <-0.224, 6.197, -0.690> <-0.115, 6.197, -0.737> <-0.037, 6.197, -0.736> 
		<-0.126, 6.613, -0.702> <-0.074, 6.613, -0.762> <0.068, 6.617, -0.733> <0.146, 6.617, -0.732> 
		<0.344, 7.074, -0.506> <0.398, 7.074, -0.458> <0.511, 7.070, -0.390> <0.509, 7.070, -0.317> 
		<0.416, 7.492, -0.362> <0.471, 7.492, -0.314> <0.513, 7.492, -0.211> <0.511, 7.492, -0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.275, 6.197, -0.631> <-0.126, 6.613, -0.702> <0.344, 7.074, -0.506> <0.416, 7.492, -0.362> 
		<-0.319, 6.197, -0.580> <-0.170, 6.613, -0.652> <0.297, 7.074, -0.548> <0.369, 7.492, -0.404> 
		<-0.327, 6.197, -0.477> <-0.249, 6.600, -0.562> <0.192, 7.087, -0.488> <0.274, 7.492, -0.412> 
		<-0.319, 6.197, -0.410> <-0.241, 6.600, -0.495> <0.129, 7.087, -0.481> <0.211, 7.492, -0.405> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.319, 6.197, -0.410> <-0.241, 6.600, -0.495> <0.129, 7.087, -0.481> <0.211, 7.492, -0.405> 
		<-0.311, 6.197, -0.348> <-0.233, 6.600, -0.432> <0.071, 7.087, -0.475> <0.153, 7.492, -0.399> 
		<-0.276, 6.197, -0.260> <-0.256, 6.590, -0.316> <0.018, 7.099, -0.388> <0.071, 7.492, -0.367> 
		<-0.225, 6.197, -0.223> <-0.206, 6.590, -0.279> <-0.017, 7.099, -0.342> <0.035, 7.492, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.225, 6.197, -0.223> <-0.206, 6.590, -0.279> <-0.017, 7.099, -0.342> <0.035, 7.492, -0.321> 
		<-0.173, 6.197, -0.184> <-0.153, 6.590, -0.240> <-0.054, 7.099, -0.294> <-0.001, 7.492, -0.273> 
		<-0.077, 6.197, -0.177> <-0.071, 6.586, -0.170> <-0.002, 7.103, -0.194> <-0.009, 7.492, -0.183> 
		<-0.012, 6.197, -0.183> <-0.006, 6.586, -0.176> <0.003, 7.103, -0.133> <-0.004, 7.492, -0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.012, 6.197, -0.183> <-0.006, 6.586, -0.176> <0.003, 7.103, -0.133> <-0.004, 7.492, -0.123> 
		<0.038, 6.197, -0.188> <0.045, 6.586, -0.181> <0.007, 7.103, -0.086> <-0.000, 7.492, -0.075> 
		<0.103, 6.197, -0.223> <0.131, 6.590, -0.170> <0.082, 7.099, -0.047> <0.032, 7.492, -0.014> 
		<0.140, 6.197, -0.258> <0.168, 6.590, -0.205> <0.114, 7.099, -0.012> <0.063, 7.492, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 6.197, -0.258> <0.168, 6.590, -0.205> <0.114, 7.099, -0.012> <0.063, 7.492, 0.021> 
		<0.177, 6.197, -0.292> <0.205, 6.590, -0.238> <0.145, 7.099, 0.023> <0.094, 7.492, 0.055> 
		<0.217, 6.197, -0.352> <0.289, 6.599, -0.272> <0.225, 7.089, 0.018> <0.150, 7.492, 0.093> 
		<0.223, 6.197, -0.401> <0.295, 6.599, -0.321> <0.271, 7.089, 0.024> <0.196, 7.492, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.223, 6.197, -0.401> <0.295, 6.599, -0.321> <0.271, 7.089, 0.024> <0.196, 7.492, 0.100> 
		<0.231, 6.197, -0.470> <0.303, 6.599, -0.389> <0.334, 7.089, 0.033> <0.260, 7.492, 0.108> 
		<0.226, 6.197, -0.573> <0.371, 6.612, -0.500> <0.420, 7.076, -0.040> <0.356, 7.492, 0.105> 
		<0.184, 6.197, -0.627> <0.329, 6.612, -0.554> <0.471, 7.076, -0.078> <0.407, 7.492, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.184, 6.197, -0.627> <0.329, 6.612, -0.554> <0.471, 7.076, -0.078> <0.407, 7.492, 0.066> 
		<0.139, 6.197, -0.685> <0.284, 6.612, -0.613> <0.526, 7.076, -0.120> <0.462, 7.492, 0.025> 
		<0.037, 6.197, -0.735> <0.220, 6.617, -0.731> <0.508, 7.070, -0.248> <0.510, 7.492, -0.069> 
		<-0.037, 6.197, -0.736> <0.146, 6.617, -0.732> <0.509, 7.070, -0.317> <0.511, 7.492, -0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.416, 7.492, -0.362> <0.471, 7.492, -0.314> <0.513, 7.492, -0.211> <0.511, 7.492, -0.138> 
		<0.485, 7.887, -0.226> <0.540, 7.887, -0.177> <0.515, 7.890, -0.043> <0.513, 7.890, 0.030> 
		<0.305, 8.345, 0.185> <0.265, 8.345, 0.235> <0.206, 8.342, 0.343> <0.142, 8.342, 0.345> 
		<0.168, 8.741, 0.247> <0.128, 8.741, 0.297> <0.040, 8.741, 0.338> <-0.025, 8.741, 0.340> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.416, 7.492, -0.362> <0.485, 7.887, -0.226> <0.305, 8.345, 0.185> <0.168, 8.741, 0.247> 
		<0.369, 7.492, -0.404> <0.438, 7.887, -0.268> <0.339, 8.345, 0.142> <0.203, 8.741, 0.204> 
		<0.274, 7.492, -0.412> <0.352, 7.878, -0.340> <0.280, 8.354, 0.046> <0.206, 8.741, 0.119> 
		<0.211, 7.492, -0.405> <0.290, 7.878, -0.333> <0.271, 8.354, -0.009> <0.197, 8.741, 0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.211, 7.492, -0.405> <0.290, 7.878, -0.333> <0.271, 8.354, -0.009> <0.197, 8.741, 0.065> 
		<0.153, 7.492, -0.399> <0.231, 7.878, -0.327> <0.263, 8.354, -0.060> <0.189, 8.741, 0.014> 
		<0.071, 7.492, -0.367> <0.121, 7.870, -0.347> <0.180, 8.363, -0.105> <0.157, 8.741, -0.057> 
		<0.035, 7.492, -0.321> <0.086, 7.870, -0.301> <0.137, 8.363, -0.135> <0.115, 8.741, -0.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.035, 7.492, -0.321> <0.086, 7.870, -0.301> <0.137, 8.363, -0.135> <0.115, 8.741, -0.087> 
		<-0.001, 7.492, -0.273> <0.049, 7.870, -0.252> <0.093, 8.363, -0.165> <0.071, 8.741, -0.117> 
		<-0.009, 7.492, -0.183> <-0.016, 7.867, -0.173> <0.002, 8.366, -0.111> <-0.008, 8.741, -0.120> 
		<-0.004, 7.492, -0.123> <-0.011, 7.867, -0.112> <-0.051, 8.366, -0.104> <-0.061, 8.741, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, 7.492, -0.123> <-0.011, 7.867, -0.112> <-0.051, 8.366, -0.104> <-0.061, 8.741, -0.113> 
		<-0.000, 7.492, -0.075> <-0.008, 7.867, -0.065> <-0.092, 8.366, -0.099> <-0.103, 8.741, -0.107> 
		<0.032, 7.492, -0.014> <-0.017, 7.870, 0.017> <-0.125, 8.363, -0.027> <-0.155, 8.741, -0.076> 
		<0.063, 7.492, 0.021> <0.015, 7.870, 0.052> <-0.155, 8.363, 0.002> <-0.185, 8.741, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 7.492, 0.021> <0.015, 7.870, 0.052> <-0.155, 8.363, 0.002> <-0.185, 8.741, -0.047> 
		<0.094, 7.492, 0.055> <0.046, 7.870, 0.087> <-0.184, 8.363, 0.031> <-0.213, 8.741, -0.018> 
		<0.150, 7.492, 0.093> <0.079, 7.877, 0.165> <-0.176, 8.356, 0.106> <-0.245, 8.741, 0.033> 
		<0.196, 7.492, 0.100> <0.125, 7.877, 0.171> <-0.179, 8.356, 0.147> <-0.248, 8.741, 0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 7.492, 0.100> <0.125, 7.877, 0.171> <-0.179, 8.356, 0.147> <-0.248, 8.741, 0.074> 
		<0.260, 7.492, 0.108> <0.189, 7.877, 0.180> <-0.184, 8.356, 0.203> <-0.252, 8.741, 0.130> 
		<0.356, 7.492, 0.105> <0.295, 7.886, 0.242> <-0.113, 8.346, 0.280> <-0.246, 8.741, 0.214> 
		<0.407, 7.492, 0.066> <0.346, 7.886, 0.203> <-0.076, 8.346, 0.323> <-0.209, 8.741, 0.257> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.407, 7.492, 0.066> <0.346, 7.886, 0.203> <-0.076, 8.346, 0.323> <-0.209, 8.741, 0.257> 
		<0.462, 7.492, 0.025> <0.401, 7.886, 0.162> <-0.037, 8.346, 0.370> <-0.170, 8.741, 0.304> 
		<0.510, 7.492, -0.069> <0.512, 7.890, 0.099> <0.081, 8.342, 0.347> <-0.085, 8.741, 0.342> 
		<0.511, 7.492, -0.138> <0.513, 7.890, 0.030> <0.142, 8.342, 0.345> <-0.025, 8.741, 0.340> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.102, 7.486, -0.301> <-0.075, 7.486, -0.274> <-0.053, 7.486, -0.220> <-0.056, 7.486, -0.181> 
		<-0.059, 7.865, -0.323> <-0.031, 7.865, -0.296> <-0.043, 7.863, -0.227> <-0.047, 7.863, -0.189> 
		<0.073, 8.362, -0.257> <0.050, 8.362, -0.231> <0.017, 8.365, -0.175> <-0.017, 8.365, -0.176> 
		<0.091, 8.742, -0.214> <0.068, 8.742, -0.189> <0.022, 8.742, -0.166> <-0.012, 8.742, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.102, 7.486, -0.301> <-0.059, 7.865, -0.323> <0.073, 8.362, -0.257> <0.091, 8.742, -0.214> 
		<-0.142, 7.486, -0.341> <-0.099, 7.865, -0.363> <0.106, 8.362, -0.294> <0.124, 8.742, -0.251> 
		<-0.211, 7.486, -0.385> <-0.142, 7.871, -0.457> <0.094, 8.355, -0.383> <0.160, 8.742, -0.313> 
		<-0.267, 7.486, -0.390> <-0.198, 7.871, -0.462> <0.096, 8.355, -0.433> <0.162, 8.742, -0.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.267, 7.486, -0.390> <-0.198, 7.871, -0.462> <0.096, 8.355, -0.433> <0.162, 8.742, -0.363> 
		<-0.334, 7.486, -0.397> <-0.265, 7.871, -0.468> <0.099, 8.355, -0.492> <0.165, 8.742, -0.422> 
		<-0.439, 7.486, -0.386> <-0.386, 7.880, -0.524> <0.018, 8.346, -0.570> <0.150, 8.742, -0.513> 
		<-0.486, 7.486, -0.338> <-0.433, 7.880, -0.476> <-0.027, 8.346, -0.609> <0.106, 8.742, -0.553> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.486, 7.486, -0.338> <-0.433, 7.880, -0.476> <-0.027, 8.346, -0.609> <0.106, 8.742, -0.553> 
		<-0.541, 7.486, -0.282> <-0.488, 7.880, -0.421> <-0.078, 8.346, -0.655> <0.055, 8.742, -0.598> 
		<-0.561, 7.486, -0.168> <-0.583, 7.883, -0.329> <-0.204, 8.343, -0.594> <-0.046, 8.742, -0.611> 
		<-0.563, 7.486, -0.091> <-0.586, 7.883, -0.251> <-0.272, 8.343, -0.593> <-0.115, 8.742, -0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.563, 7.486, -0.091> <-0.586, 7.883, -0.251> <-0.272, 8.343, -0.593> <-0.115, 8.742, -0.610> 
		<-0.564, 7.486, -0.054> <-0.587, 7.883, -0.215> <-0.305, 8.343, -0.592> <-0.147, 8.742, -0.609> 
		<-0.527, 7.486, -0.009> <-0.580, 7.881, -0.148> <-0.322, 8.346, -0.526> <-0.185, 8.742, -0.574> 
		<-0.497, 7.486, 0.013> <-0.550, 7.881, -0.126> <-0.340, 8.346, -0.499> <-0.203, 8.742, -0.547> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.497, 7.486, 0.013> <-0.550, 7.881, -0.126> <-0.340, 8.346, -0.499> <-0.203, 8.742, -0.547> 
		<-0.457, 7.486, 0.044> <-0.510, 7.881, -0.095> <-0.365, 8.346, -0.462> <-0.228, 8.742, -0.510> 
		<-0.392, 7.486, 0.077> <-0.462, 7.874, -0.013> <-0.343, 8.352, -0.385> <-0.254, 8.742, -0.452> 
		<-0.341, 7.486, 0.078> <-0.411, 7.874, -0.012> <-0.342, 8.352, -0.341> <-0.253, 8.742, -0.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.341, 7.486, 0.078> <-0.411, 7.874, -0.012> <-0.342, 8.352, -0.341> <-0.253, 8.742, -0.407> 
		<-0.276, 7.486, 0.080> <-0.346, 7.874, -0.010> <-0.341, 8.352, -0.283> <-0.252, 8.742, -0.349> 
		<-0.178, 7.486, 0.068> <-0.230, 7.866, 0.041> <-0.264, 8.361, -0.215> <-0.237, 8.742, -0.264> 
		<-0.130, 7.486, 0.024> <-0.181, 7.866, -0.003> <-0.223, 8.361, -0.174> <-0.196, 8.742, -0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 7.486, 0.024> <-0.181, 7.866, -0.003> <-0.223, 8.361, -0.174> <-0.196, 8.742, -0.224> 
		<-0.082, 7.486, -0.020> <-0.133, 7.866, -0.047> <-0.182, 8.361, -0.133> <-0.155, 8.742, -0.183> 
		<-0.061, 7.486, -0.116> <-0.052, 7.863, -0.123> <-0.075, 8.365, -0.178> <-0.070, 8.742, -0.170> 
		<-0.056, 7.486, -0.181> <-0.047, 7.863, -0.189> <-0.017, 8.365, -0.176> <-0.012, 8.742, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.168, 8.741, 0.247> <0.128, 8.741, 0.297> <0.040, 8.741, 0.338> <-0.025, 8.741, 0.340> 
		<0.044, 9.098, 0.303> <0.004, 9.098, 0.353> <-0.111, 9.101, 0.334> <-0.175, 9.101, 0.336> 
		<-0.340, 9.495, 0.122> <-0.382, 9.495, 0.084> <-0.469, 9.490, 0.032> <-0.466, 9.490, -0.025> 
		<-0.401, 9.854, 0.007> <-0.443, 9.854, -0.031> <-0.474, 9.854, -0.111> <-0.472, 9.854, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.168, 8.741, 0.247> <0.044, 9.098, 0.303> <-0.340, 9.495, 0.122> <-0.401, 9.854, 0.007> 
		<0.203, 8.741, 0.204> <0.079, 9.098, 0.259> <-0.304, 9.495, 0.155> <-0.365, 9.854, 0.040> 
		<0.206, 8.741, 0.119> <0.139, 9.087, 0.185> <-0.223, 9.507, 0.109> <-0.291, 9.854, 0.048> 
		<0.197, 8.741, 0.065> <0.130, 9.087, 0.130> <-0.174, 9.507, 0.104> <-0.242, 9.854, 0.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.197, 8.741, 0.065> <0.130, 9.087, 0.130> <-0.174, 9.507, 0.104> <-0.242, 9.854, 0.043> 
		<0.189, 8.741, 0.014> <0.122, 9.087, 0.079> <-0.129, 9.507, 0.100> <-0.197, 9.854, 0.039> 
		<0.157, 8.741, -0.057> <0.137, 9.078, -0.014> <-0.088, 9.516, 0.034> <-0.132, 9.854, 0.016> 
		<0.115, 8.741, -0.087> <0.095, 9.078, -0.044> <-0.060, 9.516, -0.002> <-0.104, 9.854, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.115, 8.741, -0.087> <0.095, 9.078, -0.044> <-0.060, 9.516, -0.002> <-0.104, 9.854, -0.020> 
		<0.071, 8.741, -0.117> <0.051, 9.078, -0.074> <-0.031, 9.516, -0.039> <-0.075, 9.854, -0.057> 
		<-0.008, 8.741, -0.120> <-0.018, 9.075, -0.127> <-0.071, 9.519, -0.116> <-0.068, 9.854, -0.127> 
		<-0.061, 8.741, -0.113> <-0.071, 9.075, -0.120> <-0.074, 9.519, -0.163> <-0.071, 9.854, -0.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.061, 8.741, -0.113> <-0.071, 9.075, -0.120> <-0.074, 9.519, -0.163> <-0.071, 9.854, -0.174> 
		<-0.103, 8.741, -0.107> <-0.112, 9.075, -0.114> <-0.076, 9.519, -0.200> <-0.073, 9.854, -0.211> 
		<-0.155, 8.741, -0.076> <-0.181, 9.079, -0.120> <-0.134, 9.515, -0.230> <-0.097, 9.854, -0.259> 
		<-0.185, 8.741, -0.047> <-0.211, 9.079, -0.091> <-0.158, 9.515, -0.258> <-0.122, 9.854, -0.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.185, 8.741, -0.047> <-0.211, 9.079, -0.091> <-0.158, 9.515, -0.258> <-0.122, 9.854, -0.286> 
		<-0.213, 8.741, -0.018> <-0.240, 9.079, -0.062> <-0.182, 9.515, -0.285> <-0.145, 9.854, -0.314> 
		<-0.245, 8.741, 0.033> <-0.306, 9.086, -0.033> <-0.244, 9.506, -0.282> <-0.188, 9.854, -0.344> 
		<-0.248, 8.741, 0.074> <-0.309, 9.086, 0.008> <-0.280, 9.506, -0.287> <-0.224, 9.854, -0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.248, 8.741, 0.074> <-0.309, 9.086, 0.008> <-0.280, 9.506, -0.287> <-0.224, 9.854, -0.349> 
		<-0.252, 8.741, 0.130> <-0.314, 9.086, 0.064> <-0.329, 9.506, -0.294> <-0.273, 9.854, -0.357> 
		<-0.246, 8.741, 0.214> <-0.366, 9.097, 0.155> <-0.395, 9.494, -0.238> <-0.348, 9.854, -0.355> 
		<-0.209, 8.741, 0.257> <-0.329, 9.097, 0.198> <-0.435, 9.494, -0.209> <-0.388, 9.854, -0.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.209, 8.741, 0.257> <-0.329, 9.097, 0.198> <-0.435, 9.494, -0.209> <-0.388, 9.854, -0.326> 
		<-0.170, 8.741, 0.304> <-0.290, 9.097, 0.245> <-0.479, 9.494, -0.177> <-0.432, 9.854, -0.294> 
		<-0.085, 8.741, 0.342> <-0.236, 9.101, 0.338> <-0.464, 9.490, -0.078> <-0.470, 9.854, -0.222> 
		<-0.025, 8.741, 0.340> <-0.175, 9.101, 0.336> <-0.466, 9.490, -0.025> <-0.472, 9.854, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.091, 8.742, -0.214> <0.068, 8.742, -0.189> <0.022, 8.742, -0.166> <-0.012, 8.742, -0.168> 
		<0.107, 9.078, -0.176> <0.084, 9.078, -0.151> <0.026, 9.076, -0.159> <-0.008, 9.076, -0.160> 
		<0.048, 9.518, -0.051> <0.027, 9.518, -0.072> <-0.018, 9.521, -0.102> <-0.015, 9.521, -0.132> 
		<0.010, 9.855, -0.034> <-0.011, 9.855, -0.055> <-0.028, 9.855, -0.098> <-0.025, 9.855, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.091, 8.742, -0.214> <0.107, 9.078, -0.176> <0.048, 9.518, -0.051> <0.010, 9.855, -0.034> 
		<0.124, 8.742, -0.251> <0.140, 9.078, -0.213> <0.078, 9.518, -0.019> <0.040, 9.855, -0.002> 
		<0.160, 8.742, -0.313> <0.219, 9.086, -0.251> <0.152, 9.510, -0.025> <0.093, 9.855, 0.033> 
		<0.162, 8.742, -0.363> <0.221, 9.086, -0.301> <0.196, 9.510, -0.021> <0.137, 9.855, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.162, 8.742, -0.363> <0.221, 9.086, -0.301> <0.196, 9.510, -0.021> <0.137, 9.855, 0.038> 
		<0.165, 8.742, -0.422> <0.223, 9.086, -0.360> <0.248, 9.510, -0.015> <0.189, 9.855, 0.043> 
		<0.150, 8.742, -0.513> <0.269, 9.097, -0.463> <0.316, 9.498, -0.079> <0.270, 9.855, 0.036> 
		<0.106, 8.742, -0.553> <0.225, 9.097, -0.502> <0.353, 9.498, -0.115> <0.307, 9.855, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 8.742, -0.553> <0.225, 9.097, -0.502> <0.353, 9.498, -0.115> <0.307, 9.855, -0.001> 
		<0.055, 8.742, -0.598> <0.174, 9.097, -0.548> <0.396, 9.498, -0.158> <0.351, 9.855, -0.043> 
		<-0.046, 8.742, -0.611> <0.095, 9.100, -0.626> <0.350, 9.494, -0.265> <0.368, 9.855, -0.132> 
		<-0.115, 8.742, -0.610> <0.026, 9.100, -0.625> <0.353, 9.494, -0.325> <0.371, 9.855, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.115, 8.742, -0.610> <0.026, 9.100, -0.625> <0.353, 9.494, -0.325> <0.371, 9.855, -0.192> 
		<-0.147, 8.742, -0.609> <-0.006, 9.100, -0.625> <0.355, 9.494, -0.354> <0.372, 9.855, -0.221> 
		<-0.185, 8.742, -0.574> <-0.062, 9.097, -0.617> <0.300, 9.497, -0.370> <0.343, 9.855, -0.256> 
		<-0.203, 8.742, -0.547> <-0.081, 9.097, -0.590> <0.278, 9.497, -0.388> <0.320, 9.855, -0.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.203, 8.742, -0.547> <-0.081, 9.097, -0.590> <0.278, 9.497, -0.388> <0.320, 9.855, -0.273> 
		<-0.228, 8.742, -0.510> <-0.106, 9.097, -0.553> <0.247, 9.497, -0.412> <0.289, 9.855, -0.298> 
		<-0.254, 8.742, -0.452> <-0.175, 9.089, -0.511> <0.183, 9.505, -0.397> <0.239, 9.855, -0.324> 
		<-0.253, 8.742, -0.407> <-0.174, 9.089, -0.466> <0.144, 9.505, -0.399> <0.200, 9.855, -0.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.253, 8.742, -0.407> <-0.174, 9.089, -0.466> <0.144, 9.505, -0.399> <0.200, 9.855, -0.326> 
		<-0.252, 8.742, -0.349> <-0.173, 9.089, -0.409> <0.093, 9.505, -0.401> <0.149, 9.855, -0.328> 
		<-0.237, 8.742, -0.264> <-0.214, 9.080, -0.309> <0.034, 9.516, -0.341> <0.073, 9.855, -0.320> 
		<-0.196, 8.742, -0.224> <-0.173, 9.080, -0.268> <-0.004, 9.516, -0.307> <0.035, 9.855, -0.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.196, 8.742, -0.224> <-0.173, 9.080, -0.268> <-0.004, 9.516, -0.307> <0.035, 9.855, -0.286> 
		<-0.155, 8.742, -0.183> <-0.132, 9.080, -0.227> <-0.043, 9.516, -0.273> <-0.003, 9.855, -0.253> 
		<-0.070, 8.742, -0.170> <-0.066, 9.076, -0.162> <-0.010, 9.521, -0.183> <-0.020, 9.855, -0.178> 
		<-0.012, 8.742, -0.168> <-0.008, 9.076, -0.160> <-0.015, 9.521, -0.132> <-0.025, 9.855, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.010, 9.855, -0.034> <-0.011, 9.855, -0.055> <-0.028, 9.855, -0.098> <-0.025, 9.855, -0.127> 
		<-0.028, 10.185, -0.017> <-0.049, 10.185, -0.039> <-0.038, 10.183, -0.093> <-0.035, 10.183, -0.123> 
		<-0.141, 10.618, -0.068> <-0.123, 10.618, -0.087> <-0.097, 10.620, -0.130> <-0.071, 10.620, -0.128> 
		<-0.159, 10.948, -0.103> <-0.141, 10.948, -0.122> <-0.105, 10.948, -0.138> <-0.079, 10.948, -0.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.010, 9.855, -0.034> <-0.028, 10.185, -0.017> <-0.141, 10.618, -0.068> <-0.159, 10.948, -0.103> 
		<0.040, 9.855, -0.002> <0.003, 10.185, 0.014> <-0.167, 10.618, -0.040> <-0.185, 10.948, -0.076> 
		<0.093, 9.855, 0.033> <0.036, 10.190, 0.089> <-0.158, 10.613, 0.028> <-0.214, 10.948, -0.028> 
		<0.137, 9.855, 0.038> <0.079, 10.190, 0.094> <-0.161, 10.613, 0.066> <-0.217, 10.948, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.137, 9.855, 0.038> <0.079, 10.190, 0.094> <-0.161, 10.613, 0.066> <-0.217, 10.948, 0.010> 
		<0.189, 9.855, 0.043> <0.131, 10.190, 0.100> <-0.164, 10.613, 0.112> <-0.220, 10.948, 0.055> 
		<0.270, 9.855, 0.036> <0.226, 10.197, 0.146> <-0.103, 10.606, 0.171> <-0.211, 10.948, 0.126> 
		<0.307, 9.855, -0.001> <0.264, 10.197, 0.109> <-0.070, 10.606, 0.202> <-0.177, 10.948, 0.157> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.307, 9.855, -0.001> <0.264, 10.197, 0.109> <-0.070, 10.606, 0.202> <-0.177, 10.948, 0.157> 
		<0.351, 9.855, -0.043> <0.307, 10.197, 0.067> <-0.031, 10.606, 0.238> <-0.139, 10.948, 0.193> 
		<0.368, 9.855, -0.132> <0.384, 10.199, -0.004> <0.065, 10.604, 0.192> <-0.061, 10.948, 0.205> 
		<0.371, 9.855, -0.192> <0.387, 10.199, -0.065> <0.117, 10.604, 0.193> <-0.009, 10.948, 0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.371, 9.855, -0.192> <0.387, 10.199, -0.065> <0.117, 10.604, 0.193> <-0.009, 10.948, 0.205> 
		<0.372, 9.855, -0.221> <0.388, 10.199, -0.093> <0.142, 10.604, 0.193> <0.016, 10.948, 0.205> 
		<0.343, 9.855, -0.256> <0.384, 10.197, -0.146> <0.156, 10.606, 0.143> <0.046, 10.948, 0.179> 
		<0.320, 9.855, -0.273> <0.361, 10.197, -0.164> <0.170, 10.606, 0.122> <0.060, 10.948, 0.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 9.855, -0.273> <0.361, 10.197, -0.164> <0.170, 10.606, 0.122> <0.060, 10.948, 0.159> 
		<0.289, 9.855, -0.298> <0.330, 10.197, -0.188> <0.191, 10.606, 0.095> <0.080, 10.948, 0.131> 
		<0.239, 9.855, -0.324> <0.294, 10.192, -0.254> <0.174, 10.611, 0.036> <0.102, 10.948, 0.086> 
		<0.200, 9.855, -0.326> <0.254, 10.192, -0.256> <0.175, 10.611, 0.002> <0.102, 10.948, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 9.855, -0.326> <0.254, 10.192, -0.256> <0.175, 10.611, 0.002> <0.102, 10.948, 0.052> 
		<0.149, 9.855, -0.328> <0.203, 10.192, -0.258> <0.175, 10.611, -0.043> <0.102, 10.948, 0.008> 
		<0.073, 9.855, -0.320> <0.112, 10.185, -0.300> <0.116, 10.618, -0.095> <0.092, 10.948, -0.058> 
		<0.035, 9.855, -0.286> <0.074, 10.185, -0.266> <0.086, 10.618, -0.127> <0.062, 10.948, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.035, 9.855, -0.286> <0.074, 10.185, -0.266> <0.086, 10.618, -0.127> <0.062, 10.948, -0.090> 
		<-0.003, 9.855, -0.253> <0.036, 10.185, -0.233> <0.055, 10.618, -0.159> <0.031, 10.948, -0.122> 
		<-0.020, 9.855, -0.178> <-0.030, 10.183, -0.174> <-0.027, 10.620, -0.126> <-0.034, 10.948, -0.134> 
		<-0.025, 9.855, -0.127> <-0.035, 10.183, -0.123> <-0.071, 10.620, -0.128> <-0.079, 10.948, -0.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.401, 9.854, 0.007> <-0.443, 9.854, -0.031> <-0.474, 9.854, -0.111> <-0.472, 9.854, -0.168> 
		<-0.459, 10.195, -0.103> <-0.501, 10.195, -0.141> <-0.480, 10.197, -0.247> <-0.477, 10.197, -0.303> 
		<-0.314, 10.608, -0.413> <-0.282, 10.608, -0.450> <-0.236, 10.606, -0.533> <-0.187, 10.606, -0.533> 
		<-0.209, 10.952, -0.464> <-0.177, 10.952, -0.501> <-0.108, 10.952, -0.532> <-0.059, 10.952, -0.532> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.401, 9.854, 0.007> <-0.459, 10.195, -0.103> <-0.314, 10.608, -0.413> <-0.209, 10.952, -0.464> 
		<-0.365, 9.854, 0.040> <-0.423, 10.195, -0.070> <-0.341, 10.608, -0.380> <-0.236, 10.952, -0.431> 
		<-0.291, 9.854, 0.048> <-0.356, 10.190, -0.011> <-0.297, 10.614, -0.307> <-0.241, 10.952, -0.367> 
		<-0.242, 9.854, 0.043> <-0.308, 10.190, -0.016> <-0.291, 10.614, -0.264> <-0.235, 10.952, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.242, 9.854, 0.043> <-0.308, 10.190, -0.016> <-0.291, 10.614, -0.264> <-0.235, 10.952, -0.324> 
		<-0.197, 9.854, 0.039> <-0.262, 10.190, -0.020> <-0.286, 10.614, -0.225> <-0.230, 10.952, -0.285> 
		<-0.132, 9.854, 0.016> <-0.176, 10.185, -0.002> <-0.222, 10.620, -0.190> <-0.207, 10.952, -0.230> 
		<-0.104, 9.854, -0.020> <-0.147, 10.185, -0.038> <-0.190, 10.620, -0.167> <-0.175, 10.952, -0.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.104, 9.854, -0.020> <-0.147, 10.185, -0.038> <-0.190, 10.620, -0.167> <-0.175, 10.952, -0.207> 
		<-0.075, 9.854, -0.057> <-0.118, 10.185, -0.075> <-0.157, 10.620, -0.142> <-0.142, 10.952, -0.182> 
		<-0.068, 9.854, -0.127> <-0.065, 10.183, -0.137> <-0.087, 10.623, -0.183> <-0.081, 10.952, -0.179> 
		<-0.071, 9.854, -0.174> <-0.068, 10.183, -0.184> <-0.047, 10.623, -0.187> <-0.040, 10.952, -0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.071, 9.854, -0.174> <-0.068, 10.183, -0.184> <-0.047, 10.623, -0.187> <-0.040, 10.952, -0.183> 
		<-0.073, 9.854, -0.211> <-0.070, 10.183, -0.221> <-0.015, 10.623, -0.191> <-0.008, 10.952, -0.186> 
		<-0.097, 9.854, -0.259> <-0.061, 10.185, -0.286> <0.011, 10.621, -0.246> <0.033, 10.952, -0.209> 
		<-0.122, 9.854, -0.286> <-0.086, 10.185, -0.314> <0.034, 10.621, -0.268> <0.056, 10.952, -0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.122, 9.854, -0.286> <-0.086, 10.185, -0.314> <0.034, 10.621, -0.268> <0.056, 10.952, -0.231> 
		<-0.145, 9.854, -0.314> <-0.109, 10.185, -0.341> <0.057, 10.621, -0.289> <0.079, 10.952, -0.253> 
		<-0.188, 9.854, -0.344> <-0.135, 10.188, -0.404> <0.051, 10.616, -0.346> <0.104, 10.952, -0.291> 
		<-0.224, 9.854, -0.349> <-0.170, 10.188, -0.409> <0.055, 10.616, -0.377> <0.107, 10.952, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.224, 9.854, -0.349> <-0.170, 10.188, -0.409> <0.055, 10.616, -0.377> <0.107, 10.952, -0.322> 
		<-0.273, 9.854, -0.357> <-0.220, 10.188, -0.417> <0.060, 10.616, -0.420> <0.112, 10.952, -0.365> 
		<-0.348, 9.854, -0.355> <-0.303, 10.194, -0.466> <0.006, 10.610, -0.479> <0.108, 10.952, -0.430> 
		<-0.388, 9.854, -0.326> <-0.344, 10.194, -0.437> <-0.021, 10.610, -0.513> <0.081, 10.952, -0.464> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.388, 9.854, -0.326> <-0.344, 10.194, -0.437> <-0.021, 10.610, -0.513> <0.081, 10.952, -0.464> 
		<-0.432, 9.854, -0.294> <-0.387, 10.194, -0.405> <-0.050, 10.610, -0.549> <0.052, 10.952, -0.501> 
		<-0.470, 9.854, -0.222> <-0.475, 10.197, -0.357> <-0.140, 10.606, -0.533> <-0.012, 10.952, -0.532> 
		<-0.472, 9.854, -0.168> <-0.477, 10.197, -0.303> <-0.187, 10.606, -0.533> <-0.059, 10.952, -0.532> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 10.948, -0.103> <-0.141, 10.948, -0.122> <-0.105, 10.948, -0.138> <-0.079, 10.948, -0.137> 
		<-0.175, 11.241, -0.135> <-0.157, 11.241, -0.154> <-0.111, 11.239, -0.146> <-0.085, 11.239, -0.145> 
		<-0.121, 11.623, -0.240> <-0.103, 11.623, -0.224> <-0.076, 11.626, -0.196> <-0.077, 11.626, -0.172> 
		<-0.102, 11.916, -0.255> <-0.085, 11.916, -0.239> <-0.070, 11.916, -0.205> <-0.072, 11.916, -0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 10.948, -0.103> <-0.175, 11.241, -0.135> <-0.121, 11.623, -0.240> <-0.102, 11.916, -0.255> 
		<-0.185, 10.948, -0.076> <-0.201, 11.241, -0.107> <-0.146, 11.623, -0.264> <-0.128, 11.916, -0.279> 
		<-0.214, 10.948, -0.028> <-0.263, 11.246, -0.078> <-0.211, 11.620, -0.241> <-0.171, 11.916, -0.306> 
		<-0.217, 10.948, 0.010> <-0.266, 11.246, -0.040> <-0.245, 11.620, -0.244> <-0.206, 11.916, -0.308> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.217, 10.948, 0.010> <-0.266, 11.246, -0.040> <-0.245, 11.620, -0.244> <-0.206, 11.916, -0.308> 
		<-0.220, 10.948, 0.055> <-0.269, 11.246, 0.005> <-0.287, 11.620, -0.247> <-0.248, 11.916, -0.311> 
		<-0.211, 10.948, 0.126> <-0.306, 11.253, 0.085> <-0.346, 11.610, -0.212> <-0.312, 11.916, -0.303> 
		<-0.177, 10.948, 0.157> <-0.273, 11.253, 0.117> <-0.375, 11.610, -0.181> <-0.341, 11.916, -0.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.177, 10.948, 0.157> <-0.273, 11.253, 0.117> <-0.375, 11.610, -0.181> <-0.341, 11.916, -0.273> 
		<-0.139, 10.948, 0.193> <-0.235, 11.253, 0.153> <-0.408, 11.610, -0.146> <-0.374, 11.916, -0.238> 
		<-0.061, 10.948, 0.205> <-0.174, 11.254, 0.216> <-0.359, 11.608, -0.061> <-0.385, 11.916, -0.167> 
		<-0.009, 10.948, 0.205> <-0.121, 11.254, 0.216> <-0.360, 11.608, -0.013> <-0.385, 11.916, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, 10.948, 0.205> <-0.121, 11.254, 0.216> <-0.360, 11.608, -0.013> <-0.385, 11.916, -0.118> 
		<0.016, 10.948, 0.205> <-0.096, 11.254, 0.216> <-0.360, 11.608, 0.010> <-0.386, 11.916, -0.096> 
		<0.046, 10.948, 0.179> <-0.052, 11.252, 0.211> <-0.325, 11.612, 0.028> <-0.362, 11.916, -0.068> 
		<0.060, 10.948, 0.159> <-0.038, 11.252, 0.191> <-0.306, 11.612, 0.042> <-0.343, 11.916, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.060, 10.948, 0.159> <-0.038, 11.252, 0.191> <-0.306, 11.612, 0.042> <-0.343, 11.916, -0.055> 
		<0.080, 10.948, 0.131> <-0.017, 11.252, 0.163> <-0.281, 11.612, 0.060> <-0.318, 11.916, -0.036> 
		<0.102, 10.948, 0.086> <0.037, 11.247, 0.131> <-0.222, 11.616, 0.034> <-0.277, 11.916, -0.017> 
		<0.102, 10.948, 0.052> <0.037, 11.247, 0.097> <-0.191, 11.616, 0.034> <-0.245, 11.916, -0.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 10.948, 0.052> <0.037, 11.247, 0.097> <-0.191, 11.616, 0.034> <-0.245, 11.916, -0.017> 
		<0.102, 10.948, 0.008> <0.037, 11.247, 0.053> <-0.150, 11.616, 0.035> <-0.205, 11.916, -0.016> 
		<0.092, 10.948, -0.058> <0.071, 11.241, -0.025> <-0.098, 11.626, 0.002> <-0.145, 11.916, -0.025> 
		<0.062, 10.948, -0.090> <0.040, 11.241, -0.057> <-0.068, 11.626, -0.026> <-0.115, 11.916, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.062, 10.948, -0.090> <0.040, 11.241, -0.057> <-0.068, 11.626, -0.026> <-0.115, 11.916, -0.053> 
		<0.031, 10.948, -0.122> <0.010, 11.241, -0.089> <-0.039, 11.626, -0.054> <-0.086, 11.916, -0.081> 
		<-0.034, 10.948, -0.134> <-0.041, 11.239, -0.142> <-0.080, 11.626, -0.131> <-0.074, 11.916, -0.141> 
		<-0.079, 10.948, -0.137> <-0.085, 11.239, -0.145> <-0.077, 11.626, -0.172> <-0.072, 11.916, -0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.209, 10.952, -0.464> <-0.177, 10.952, -0.501> <-0.108, 10.952, -0.532> <-0.059, 10.952, -0.532> 
		<-0.116, 11.257, -0.509> <-0.084, 11.257, -0.547> <0.005, 11.260, -0.531> <0.054, 11.260, -0.531> 
		<0.192, 11.615, -0.400> <0.227, 11.615, -0.370> <0.279, 11.612, -0.320> <0.279, 11.612, -0.275> 
		<0.228, 11.920, -0.300> <0.262, 11.920, -0.271> <0.290, 11.920, -0.208> <0.290, 11.920, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.209, 10.952, -0.464> <-0.116, 11.257, -0.509> <0.192, 11.615, -0.400> <0.228, 11.920, -0.300> 
		<-0.236, 10.952, -0.431> <-0.143, 11.257, -0.477> <0.163, 11.615, -0.425> <0.198, 11.920, -0.325> 
		<-0.241, 10.952, -0.367> <-0.191, 11.251, -0.420> <0.092, 11.618, -0.366> <0.139, 11.920, -0.329> 
		<-0.235, 10.952, -0.324> <-0.186, 11.251, -0.378> <0.054, 11.618, -0.361> <0.100, 11.920, -0.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 10.952, -0.324> <-0.186, 11.251, -0.378> <0.054, 11.618, -0.361> <0.100, 11.920, -0.324> 
		<-0.230, 10.952, -0.285> <-0.180, 11.251, -0.338> <0.018, 11.618, -0.357> <0.064, 11.920, -0.320> 
		<-0.207, 10.952, -0.230> <-0.193, 11.245, -0.265> <-0.022, 11.627, -0.316> <0.014, 11.920, -0.299> 
		<-0.175, 10.952, -0.207> <-0.161, 11.245, -0.242> <-0.043, 11.627, -0.286> <-0.008, 11.920, -0.269> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.175, 10.952, -0.207> <-0.161, 11.245, -0.242> <-0.043, 11.627, -0.286> <-0.008, 11.920, -0.269> 
		<-0.142, 10.952, -0.182> <-0.128, 11.245, -0.218> <-0.066, 11.627, -0.256> <-0.030, 11.920, -0.239> 
		<-0.081, 10.952, -0.179> <-0.075, 11.243, -0.175> <-0.013, 11.630, -0.194> <-0.034, 11.920, -0.183> 
		<-0.040, 10.952, -0.183> <-0.034, 11.243, -0.179> <-0.009, 11.630, -0.156> <-0.030, 11.920, -0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, 10.952, -0.183> <-0.034, 11.243, -0.179> <-0.009, 11.630, -0.156> <-0.030, 11.920, -0.146> 
		<-0.008, 10.952, -0.186> <-0.002, 11.243, -0.182> <-0.006, 11.630, -0.127> <-0.027, 11.920, -0.117> 
		<0.033, 10.952, -0.209> <0.052, 11.245, -0.177> <0.031, 11.627, -0.097> <-0.006, 11.920, -0.079> 
		<0.056, 10.952, -0.231> <0.075, 11.245, -0.199> <0.051, 11.627, -0.076> <0.014, 11.920, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.056, 10.952, -0.231> <0.075, 11.245, -0.199> <0.051, 11.627, -0.076> <0.014, 11.920, -0.058> 
		<0.079, 10.952, -0.253> <0.098, 11.245, -0.220> <0.071, 11.627, -0.055> <0.034, 11.920, -0.037> 
		<0.104, 10.952, -0.291> <0.150, 11.250, -0.242> <0.121, 11.626, -0.076> <0.069, 11.920, -0.014> 
		<0.107, 10.952, -0.322> <0.153, 11.250, -0.274> <0.150, 11.626, -0.073> <0.098, 11.920, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.107, 10.952, -0.322> <0.153, 11.250, -0.274> <0.150, 11.626, -0.073> <0.098, 11.920, -0.011> 
		<0.112, 10.952, -0.365> <0.158, 11.250, -0.317> <0.189, 11.626, -0.068> <0.137, 11.920, -0.006> 
		<0.108, 10.952, -0.430> <0.199, 11.257, -0.387> <0.246, 11.615, -0.097> <0.197, 11.920, -0.010> 
		<0.081, 10.952, -0.464> <0.172, 11.257, -0.421> <0.278, 11.615, -0.122> <0.228, 11.920, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.081, 10.952, -0.464> <0.172, 11.257, -0.421> <0.278, 11.615, -0.122> <0.228, 11.920, -0.034> 
		<0.052, 10.952, -0.501> <0.143, 11.257, -0.458> <0.311, 11.615, -0.149> <0.261, 11.920, -0.061> 
		<-0.012, 10.952, -0.532> <0.101, 11.260, -0.531> <0.279, 11.612, -0.232> <0.290, 11.920, -0.120> 
		<-0.059, 10.952, -0.532> <0.054, 11.260, -0.531> <0.279, 11.612, -0.275> <0.290, 11.920, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.228, 11.920, -0.300> <0.228, 11.920, -0.300> <0.228, 11.920, -0.300> <0.228, 11.920, -0.300> 
		<0.261, 12.197, -0.209> <0.295, 12.197, -0.180> <0.295, 12.197, -0.180> <0.262, 11.920, -0.271> 
		<0.124, 12.508, 0.071> <0.210, 12.253, -0.017> <0.299, 12.185, -0.111> <0.290, 11.920, -0.208> 
		<0.005, 12.770, 0.130> <0.090, 12.515, 0.043> <0.299, 12.185, -0.066> <0.290, 11.920, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.228, 11.920, -0.300> <0.261, 12.197, -0.209> <0.124, 12.508, 0.071> <0.005, 12.770, 0.130> 
		<0.198, 11.920, -0.325> <0.231, 12.197, -0.235> <0.184, 12.508, 0.034> <0.065, 12.770, 0.093> 
		<0.139, 11.920, -0.329> <0.179, 12.179, -0.297> <0.103, 12.515, -0.111> <0.087, 12.770, -0.044> 
		<0.100, 11.920, -0.324> <0.140, 12.179, -0.292> <0.063, 12.515, -0.168> <0.046, 12.770, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 11.920, -0.324> <0.100, 11.920, -0.324> <0.100, 11.920, -0.324> <0.100, 11.920, -0.324> 
		<0.064, 11.920, -0.320> <0.104, 12.179, -0.288> <0.104, 12.179, -0.288> <0.140, 12.179, -0.292> 
		<0.014, 11.920, -0.299> <0.045, 12.178, -0.284> <0.122, 12.261, -0.181> <0.063, 12.515, -0.168> 
		<-0.008, 11.920, -0.269> <0.024, 12.178, -0.254> <0.106, 12.516, -0.114> <0.046, 12.770, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 11.920, -0.269> <0.024, 12.178, -0.254> <0.106, 12.516, -0.114> <0.046, 12.770, -0.101> 
		<-0.030, 11.920, -0.239> <0.001, 12.178, -0.224> <0.068, 12.516, -0.168> <0.008, 12.770, -0.155> 
		<-0.034, 11.920, -0.183> <-0.052, 12.177, -0.174> <-0.073, 12.515, -0.161> <-0.116, 12.770, -0.153> 
		<-0.030, 11.920, -0.146> <-0.049, 12.177, -0.137> <-0.129, 12.515, -0.127> <-0.172, 12.770, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.030, 11.920, -0.146> <-0.030, 11.920, -0.146> <-0.030, 11.920, -0.146> <-0.030, 11.920, -0.146> 
		<-0.027, 11.920, -0.117> <-0.045, 12.177, -0.107> <-0.045, 12.177, -0.107> <-0.049, 12.177, -0.137> 
		<-0.006, 11.920, -0.079> <-0.039, 12.179, -0.063> <-0.036, 12.273, -0.091> <-0.129, 12.515, -0.127> 
		<0.014, 11.920, -0.058> <-0.018, 12.179, -0.042> <-0.079, 12.528, -0.083> <-0.172, 12.770, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.014, 11.920, -0.058> <-0.018, 12.179, -0.042> <-0.079, 12.528, -0.083> <-0.172, 12.770, -0.119> 
		<0.034, 11.920, -0.037> <0.001, 12.179, -0.021> <-0.126, 12.528, -0.054> <-0.219, 12.770, -0.090> 
		<0.069, 11.920, -0.014> <0.022, 12.182, 0.041> <-0.154, 12.515, -0.006> <-0.248, 12.770, 0.015> 
		<0.098, 11.920, -0.011> <0.051, 12.182, 0.045> <-0.122, 12.515, 0.039> <-0.216, 12.770, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, 11.920, -0.011> <0.098, 11.920, -0.011> <0.098, 11.920, -0.011> <0.098, 11.920, -0.011> 
		<0.137, 11.920, -0.006> <0.090, 12.182, 0.049> <0.090, 12.182, 0.049> <0.051, 12.182, 0.045> 
		<0.197, 11.920, -0.010> <0.152, 12.194, 0.070> <0.030, 12.269, 0.050> <-0.122, 12.515, 0.039> 
		<0.228, 11.920, -0.034> <0.183, 12.194, 0.045> <-0.064, 12.524, 0.071> <-0.216, 12.770, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.228, 11.920, -0.034> <0.183, 12.194, 0.045> <-0.064, 12.524, 0.071> <-0.216, 12.770, 0.060> 
		<0.261, 11.920, -0.061> <0.217, 12.194, 0.019> <-0.024, 12.524, 0.128> <-0.176, 12.770, 0.117> 
		<0.290, 11.920, -0.120> <0.299, 12.185, -0.023> <0.031, 12.515, 0.079> <-0.054, 12.770, 0.167> 
		<0.290, 11.920, -0.163> <0.299, 12.185, -0.066> <0.090, 12.515, 0.043> <0.005, 12.770, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.102, 11.916, -0.255> <-0.102, 11.916, -0.255> <-0.102, 11.916, -0.255> <-0.102, 11.916, -0.255> 
		<-0.087, 12.171, -0.268> <-0.069, 12.171, -0.252> <-0.069, 12.171, -0.252> <-0.085, 11.916, -0.239> 
		<-0.111, 12.518, -0.226> <-0.118, 12.264, -0.221> <-0.066, 12.170, -0.214> <-0.070, 11.916, -0.205> 
		<-0.046, 12.763, -0.197> <-0.054, 12.509, -0.193> <-0.067, 12.170, -0.190> <-0.072, 11.916, -0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.102, 11.916, -0.255> <-0.087, 12.171, -0.268> <-0.111, 12.518, -0.226> <-0.046, 12.763, -0.197> 
		<-0.128, 11.916, -0.279> <-0.112, 12.171, -0.292> <-0.055, 12.518, -0.254> <0.009, 12.763, -0.225> 
		<-0.171, 11.916, -0.306> <-0.136, 12.176, -0.363> <-0.014, 12.515, -0.311> <0.056, 12.773, -0.335> 
		<-0.206, 11.916, -0.308> <-0.171, 12.176, -0.365> <-0.043, 12.518, -0.365> <0.027, 12.776, -0.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.206, 11.916, -0.308> <-0.206, 11.916, -0.308> <-0.206, 11.916, -0.308> <-0.206, 11.916, -0.308> 
		<-0.248, 11.916, -0.311> <-0.213, 12.176, -0.368> <-0.213, 12.176, -0.368> <-0.171, 12.176, -0.365> 
		<-0.312, 11.916, -0.303> <-0.282, 12.186, -0.384> <-0.176, 12.269, -0.357> <-0.043, 12.518, -0.365> 
		<-0.341, 11.916, -0.273> <-0.311, 12.186, -0.353> <-0.106, 12.527, -0.382> <0.027, 12.776, -0.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.341, 11.916, -0.273> <-0.311, 12.186, -0.353> <-0.106, 12.527, -0.382> <0.027, 12.776, -0.390> 
		<-0.374, 11.916, -0.238> <-0.344, 12.186, -0.318> <-0.133, 12.530, -0.433> <0.001, 12.780, -0.441> 
		<-0.385, 11.916, -0.167> <-0.407, 12.182, -0.258> <-0.178, 12.520, -0.357> <-0.111, 12.778, -0.448> 
		<-0.385, 11.916, -0.118> <-0.408, 12.182, -0.210> <-0.230, 12.520, -0.331> <-0.163, 12.778, -0.422> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.385, 11.916, -0.118> <-0.385, 11.916, -0.118> <-0.385, 11.916, -0.118> <-0.385, 11.916, -0.118> 
		<-0.386, 11.916, -0.096> <-0.408, 12.182, -0.187> <-0.408, 12.182, -0.187> <-0.408, 12.182, -0.210> 
		<-0.362, 11.916, -0.068> <-0.395, 12.187, -0.154> <-0.329, 12.258, -0.272> <-0.230, 12.520, -0.331> 
		<-0.343, 11.916, -0.055> <-0.376, 12.187, -0.141> <-0.263, 12.516, -0.363> <-0.163, 12.778, -0.422> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.343, 11.916, -0.055> <-0.376, 12.187, -0.141> <-0.263, 12.516, -0.363> <-0.163, 12.778, -0.422> 
		<-0.318, 11.916, -0.036> <-0.351, 12.187, -0.122> <-0.310, 12.516, -0.340> <-0.210, 12.778, -0.398> 
		<-0.277, 11.916, -0.017> <-0.325, 12.176, -0.061> <-0.261, 12.521, -0.234> <-0.257, 12.779, -0.306> 
		<-0.245, 11.916, -0.017> <-0.293, 12.176, -0.061> <-0.237, 12.518, -0.187> <-0.233, 12.776, -0.259> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.245, 11.916, -0.017> <-0.245, 11.916, -0.017> <-0.245, 11.916, -0.017> <-0.245, 11.916, -0.017> 
		<-0.205, 11.916, -0.016> <-0.253, 12.176, -0.061> <-0.253, 12.176, -0.061> <-0.293, 12.176, -0.061> 
		<-0.145, 11.916, -0.025> <-0.187, 12.179, -0.050> <-0.279, 12.255, -0.162> <-0.237, 12.518, -0.187> 
		<-0.115, 11.916, -0.053> <-0.158, 12.179, -0.077> <-0.275, 12.513, -0.235> <-0.233, 12.776, -0.259> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.115, 11.916, -0.053> <-0.158, 12.179, -0.077> <-0.275, 12.513, -0.235> <-0.233, 12.776, -0.259> 
		<-0.086, 11.916, -0.081> <-0.128, 12.179, -0.105> <-0.248, 12.510, -0.182> <-0.206, 12.773, -0.207> 
		<-0.074, 11.916, -0.141> <-0.070, 12.170, -0.149> <-0.107, 12.509, -0.166> <-0.099, 12.763, -0.171> 
		<-0.072, 11.916, -0.182> <-0.067, 12.170, -0.190> <-0.054, 12.509, -0.193> <-0.046, 12.763, -0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.046, 12.770, -0.101> <0.087, 12.770, -0.044> <0.065, 12.770, 0.093> <0.005, 12.770, 0.130> 
		<0.011, 12.920, -0.094> <0.052, 12.920, -0.036> <0.004, 12.903, 0.124> <-0.056, 12.903, 0.161> 
		<-0.162, 13.069, -0.179> <-0.141, 13.093, -0.134> <-0.159, 13.085, -0.013> <-0.191, 13.050, 0.016> 
		<-0.296, 13.142, -0.207> <-0.275, 13.166, -0.162> <-0.286, 13.153, -0.055> <-0.318, 13.118, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.046, 12.770, -0.101> <0.011, 12.920, -0.094> <-0.162, 13.069, -0.179> <-0.296, 13.142, -0.207> 
		<0.008, 12.770, -0.155> <-0.027, 12.920, -0.147> <-0.182, 13.047, -0.221> <-0.316, 13.120, -0.249> 
		<-0.116, 12.770, -0.153> <-0.154, 12.868, -0.168> <-0.288, 12.999, -0.223> <-0.381, 13.047, -0.247> 
		<-0.172, 12.770, -0.119> <-0.210, 12.868, -0.133> <-0.318, 12.967, -0.196> <-0.410, 13.015, -0.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, 12.770, -0.119> <-0.210, 12.868, -0.133> <-0.318, 12.967, -0.196> <-0.410, 13.015, -0.220> 
		<-0.219, 12.770, -0.090> <-0.257, 12.868, -0.104> <-0.342, 12.939, -0.173> <-0.434, 12.987, -0.198> 
		<-0.248, 12.770, 0.015> <-0.301, 12.856, 0.012> <-0.364, 12.927, -0.081> <-0.449, 12.971, -0.116> 
		<-0.216, 12.770, 0.060> <-0.269, 12.856, 0.057> <-0.347, 12.945, -0.046> <-0.432, 12.989, -0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.216, 12.770, 0.060> <-0.269, 12.856, 0.057> <-0.347, 12.945, -0.046> <-0.432, 12.989, -0.080> 
		<-0.176, 12.770, 0.117> <-0.229, 12.856, 0.113> <-0.326, 12.969, -0.002> <-0.412, 13.013, -0.036> 
		<-0.054, 12.770, 0.167> <-0.115, 12.903, 0.198> <-0.222, 13.015, 0.044> <-0.348, 13.083, 0.003> 
		<0.005, 12.770, 0.130> <-0.056, 12.903, 0.161> <-0.191, 13.050, 0.016> <-0.318, 13.118, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.296, 13.142, -0.207> <-0.275, 13.166, -0.162> <-0.286, 13.153, -0.055> <-0.318, 13.118, -0.026> 
		<-0.436, 13.218, -0.236> <-0.415, 13.242, -0.191> <-0.420, 13.225, -0.098> <-0.451, 13.190, -0.069> 
		<-0.664, 13.206, -0.274> <-0.664, 13.231, -0.239> <-0.669, 13.218, -0.148> <-0.668, 13.181, -0.126> 
		<-0.822, 13.240, -0.281> <-0.822, 13.265, -0.246> <-0.822, 13.251, -0.163> <-0.822, 13.215, -0.140> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.296, 13.142, -0.207> <-0.436, 13.218, -0.236> <-0.664, 13.206, -0.274> <-0.822, 13.240, -0.281> 
		<-0.316, 13.120, -0.249> <-0.456, 13.196, -0.278> <-0.664, 13.183, -0.307> <-0.822, 13.217, -0.314> 
		<-0.381, 13.047, -0.247> <-0.491, 13.105, -0.277> <-0.697, 13.111, -0.307> <-0.821, 13.141, -0.313> 
		<-0.410, 13.015, -0.220> <-0.520, 13.072, -0.250> <-0.696, 13.077, -0.287> <-0.821, 13.107, -0.292> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.410, 13.015, -0.220> <-0.520, 13.072, -0.250> <-0.696, 13.077, -0.287> <-0.821, 13.107, -0.292> 
		<-0.434, 12.987, -0.198> <-0.545, 13.045, -0.227> <-0.696, 13.048, -0.269> <-0.821, 13.079, -0.274> 
		<-0.449, 12.971, -0.116> <-0.553, 13.024, -0.157> <-0.701, 13.031, -0.200> <-0.821, 13.061, -0.210> 
		<-0.432, 12.989, -0.080> <-0.536, 13.043, -0.122> <-0.701, 13.051, -0.173> <-0.821, 13.081, -0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.432, 12.989, -0.080> <-0.536, 13.043, -0.122> <-0.701, 13.051, -0.173> <-0.821, 13.081, -0.183> 
		<-0.412, 13.013, -0.036> <-0.515, 13.066, -0.078> <-0.702, 13.075, -0.138> <-0.821, 13.105, -0.148> 
		<-0.348, 13.083, 0.003> <-0.482, 13.155, -0.041> <-0.668, 13.146, -0.103> <-0.822, 13.179, -0.118> 
		<-0.318, 13.118, -0.026> <-0.451, 13.190, -0.069> <-0.668, 13.181, -0.126> <-0.822, 13.215, -0.140> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.822, 13.240, -0.281> <-0.822, 13.265, -0.246> <-0.822, 13.251, -0.163> <-0.822, 13.215, -0.140> 
		<-0.998, 13.277, -0.289> <-0.998, 13.302, -0.254> <-0.999, 13.290, -0.180> <-0.998, 13.253, -0.157> 
		<-1.233, 13.325, -0.271> <-1.227, 13.346, -0.241> <-1.228, 13.333, -0.161> <-1.237, 13.302, -0.141> 
		<-1.404, 13.377, -0.254> <-1.398, 13.398, -0.223> <-1.401, 13.387, -0.150> <-1.410, 13.356, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.822, 13.240, -0.281> <-0.998, 13.277, -0.289> <-1.233, 13.325, -0.271> <-1.404, 13.377, -0.254> 
		<-0.822, 13.217, -0.314> <-0.997, 13.254, -0.321> <-1.239, 13.305, -0.300> <-1.409, 13.358, -0.283> 
		<-0.821, 13.141, -0.313> <-1.006, 13.186, -0.321> <-1.248, 13.232, -0.300> <-1.427, 13.293, -0.282> 
		<-0.821, 13.107, -0.292> <-1.006, 13.152, -0.300> <-1.256, 13.203, -0.281> <-1.436, 13.265, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.821, 13.107, -0.292> <-1.006, 13.152, -0.300> <-1.256, 13.203, -0.281> <-1.436, 13.265, -0.264> 
		<-0.821, 13.079, -0.274> <-1.006, 13.124, -0.282> <-1.263, 13.179, -0.266> <-1.442, 13.240, -0.248> 
		<-0.821, 13.061, -0.210> <-1.007, 13.108, -0.226> <-1.265, 13.163, -0.205> <-1.447, 13.226, -0.192> 
		<-0.821, 13.081, -0.183> <-1.007, 13.127, -0.199> <-1.260, 13.179, -0.180> <-1.442, 13.242, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.821, 13.081, -0.183> <-1.007, 13.127, -0.199> <-1.260, 13.179, -0.180> <-1.442, 13.242, -0.168> 
		<-0.821, 13.105, -0.148> <-1.007, 13.152, -0.165> <-1.255, 13.200, -0.150> <-1.436, 13.263, -0.137> 
		<-0.822, 13.179, -0.118> <-0.998, 13.217, -0.135> <-1.246, 13.271, -0.121> <-1.418, 13.325, -0.111> 
		<-0.822, 13.215, -0.140> <-0.998, 13.253, -0.157> <-1.237, 13.302, -0.141> <-1.410, 13.356, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 13.377, -0.254> <-1.398, 13.398, -0.223> <-1.401, 13.387, -0.150> <-1.410, 13.356, -0.130> 
		<-1.552, 13.423, -0.239> <-1.546, 13.444, -0.208> <-1.550, 13.434, -0.141> <-1.558, 13.403, -0.121> 
		<-1.753, 13.476, -0.180> <-1.743, 13.491, -0.155> <-1.749, 13.481, -0.085> <-1.762, 13.459, -0.069> 
		<-1.879, 13.566, -0.174> <-1.870, 13.581, -0.149> <-1.875, 13.573, -0.090> <-1.889, 13.550, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 13.377, -0.254> <-1.552, 13.423, -0.239> <-1.753, 13.476, -0.180> <-1.879, 13.566, -0.174> 
		<-1.409, 13.358, -0.283> <-1.557, 13.403, -0.268> <-1.761, 13.462, -0.203> <-1.888, 13.552, -0.197> 
		<-1.427, 13.293, -0.282> <-1.582, 13.346, -0.267> <-1.788, 13.403, -0.203> <-1.916, 13.505, -0.197> 
		<-1.436, 13.265, -0.264> <-1.590, 13.317, -0.248> <-1.800, 13.383, -0.188> <-1.928, 13.485, -0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.436, 13.265, -0.264> <-1.590, 13.317, -0.248> <-1.800, 13.383, -0.188> <-1.928, 13.485, -0.182> 
		<-1.442, 13.240, -0.248> <-1.597, 13.293, -0.233> <-1.811, 13.365, -0.176> <-1.939, 13.467, -0.169> 
		<-1.447, 13.226, -0.192> <-1.602, 13.279, -0.181> <-1.818, 13.352, -0.122> <-1.945, 13.456, -0.123> 
		<-1.442, 13.242, -0.168> <-1.597, 13.296, -0.157> <-1.811, 13.364, -0.102> <-1.938, 13.468, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.442, 13.242, -0.168> <-1.597, 13.296, -0.157> <-1.811, 13.364, -0.102> <-1.938, 13.468, -0.104> 
		<-1.436, 13.263, -0.137> <-1.591, 13.317, -0.126> <-1.801, 13.379, -0.078> <-1.929, 13.483, -0.079> 
		<-1.418, 13.325, -0.111> <-1.567, 13.372, -0.101> <-1.776, 13.437, -0.053> <-1.902, 13.528, -0.058> 
		<-1.410, 13.356, -0.130> <-1.558, 13.403, -0.121> <-1.762, 13.459, -0.069> <-1.889, 13.550, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.879, 13.566, -0.174> <-1.870, 13.581, -0.149> <-1.875, 13.573, -0.090> <-1.889, 13.550, -0.073> 
		<-2.003, 13.653, -0.168> <-1.993, 13.668, -0.143> <-2.000, 13.663, -0.094> <-2.014, 13.641, -0.078> 
		<-2.101, 13.839, -0.203> <-2.094, 13.845, -0.189> <-2.099, 13.839, -0.139> <-2.110, 13.830, -0.130> 
		<-2.207, 13.946, -0.216> <-2.199, 13.953, -0.203> <-2.204, 13.949, -0.169> <-2.215, 13.940, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.879, 13.566, -0.174> <-2.003, 13.653, -0.168> <-2.101, 13.839, -0.203> <-2.207, 13.946, -0.216> 
		<-1.888, 13.552, -0.197> <-2.011, 13.639, -0.192> <-2.108, 13.833, -0.216> <-2.214, 13.940, -0.229> 
		<-1.916, 13.505, -0.197> <-2.041, 13.605, -0.190> <-2.137, 13.796, -0.216> <-2.237, 13.921, -0.229> 
		<-1.928, 13.485, -0.182> <-2.054, 13.584, -0.175> <-2.147, 13.787, -0.208> <-2.247, 13.912, -0.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.928, 13.485, -0.182> <-2.054, 13.584, -0.175> <-2.147, 13.787, -0.208> <-2.247, 13.912, -0.221> 
		<-1.939, 13.467, -0.169> <-2.064, 13.567, -0.162> <-2.156, 13.780, -0.201> <-2.256, 13.904, -0.214> 
		<-1.945, 13.456, -0.123> <-2.072, 13.560, -0.125> <-2.162, 13.772, -0.162> <-2.261, 13.900, -0.188> 
		<-1.938, 13.468, -0.104> <-2.065, 13.571, -0.105> <-2.157, 13.777, -0.151> <-2.255, 13.905, -0.177> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.938, 13.468, -0.104> <-2.065, 13.571, -0.105> <-2.157, 13.777, -0.151> <-2.255, 13.905, -0.177> 
		<-1.929, 13.483, -0.079> <-2.056, 13.586, -0.081> <-2.149, 13.784, -0.137> <-2.248, 13.911, -0.164> 
		<-1.902, 13.528, -0.058> <-2.027, 13.619, -0.062> <-2.121, 13.820, -0.121> <-2.225, 13.930, -0.152> 
		<-1.889, 13.550, -0.073> <-2.014, 13.641, -0.078> <-2.110, 13.830, -0.130> <-2.215, 13.940, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.425, 14.107, -0.231> <-2.325, 13.995, -0.196> <-2.255, 13.905, -0.177> 
		<-2.410, 14.119, -0.242> <-2.338, 14.033, -0.220> <-2.330, 13.990, -0.207> <-2.261, 13.900, -0.188> 
		<-2.287, 14.028, -0.227> <-2.294, 14.022, -0.240> <-2.245, 13.913, -0.222> <-2.256, 13.904, -0.214> 
		<-2.207, 13.946, -0.216> <-2.214, 13.940, -0.229> <-2.237, 13.921, -0.229> <-2.247, 13.912, -0.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> 
		<-2.422, 14.109, -0.244> <-2.350, 14.022, -0.221> <-2.350, 14.022, -0.221> <-2.425, 14.107, -0.231> 
		<-2.318, 14.000, -0.230> <-2.326, 13.993, -0.223> <-2.330, 13.990, -0.207> <-2.325, 13.995, -0.196> 
		<-2.247, 13.912, -0.221> <-2.256, 13.904, -0.214> <-2.261, 13.900, -0.188> <-2.255, 13.905, -0.177> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.410, 14.119, -0.242> <-2.287, 14.028, -0.227> <-2.207, 13.946, -0.216> 
		<-2.425, 14.107, -0.231> <-2.338, 14.033, -0.220> <-2.280, 14.034, -0.213> <-2.199, 13.953, -0.203> 
		<-2.325, 13.995, -0.196> <-2.317, 14.001, -0.182> <-2.214, 13.940, -0.161> <-2.204, 13.949, -0.169> 
		<-2.255, 13.905, -0.177> <-2.248, 13.911, -0.164> <-2.225, 13.930, -0.152> <-2.215, 13.940, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> 
		<-2.425, 14.107, -0.231> <-2.340, 14.031, -0.203> <-2.340, 14.031, -0.203> <-2.413, 14.117, -0.226> 
		<-2.325, 13.995, -0.196> <-2.317, 14.001, -0.182> <-2.304, 14.014, -0.175> <-2.294, 14.023, -0.184> 
		<-2.255, 13.905, -0.177> <-2.248, 13.911, -0.164> <-2.225, 13.930, -0.152> <-2.215, 13.940, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.422, 14.109, -0.244> <-2.318, 14.000, -0.230> <-2.247, 13.912, -0.221> 
		<-2.413, 14.117, -0.226> <-2.338, 14.033, -0.216> <-2.308, 14.009, -0.238> <-2.237, 13.921, -0.229> 
		<-2.294, 14.023, -0.184> <-2.283, 14.033, -0.193> <-2.206, 13.947, -0.216> <-2.214, 13.940, -0.229> 
		<-2.215, 13.940, -0.161> <-2.204, 13.949, -0.169> <-2.199, 13.953, -0.203> <-2.207, 13.946, -0.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> 
		<-2.410, 14.119, -0.242> <-2.335, 14.035, -0.233> <-2.335, 14.035, -0.233> <-2.422, 14.109, -0.244> 
		<-2.287, 14.028, -0.227> <-2.294, 14.022, -0.240> <-2.308, 14.009, -0.238> <-2.318, 14.000, -0.230> 
		<-2.207, 13.946, -0.216> <-2.214, 13.940, -0.229> <-2.237, 13.921, -0.229> <-2.247, 13.912, -0.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.422, 14.109, -0.244> <-2.318, 14.000, -0.230> <-2.247, 13.912, -0.221> 
		<-2.413, 14.117, -0.226> <-2.338, 14.033, -0.216> <-2.326, 13.993, -0.223> <-2.256, 13.904, -0.214> 
		<-2.294, 14.023, -0.184> <-2.304, 14.014, -0.175> <-2.253, 13.906, -0.175> <-2.261, 13.900, -0.188> 
		<-2.215, 13.940, -0.161> <-2.225, 13.930, -0.152> <-2.248, 13.911, -0.164> <-2.255, 13.905, -0.177> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> <-2.498, 14.193, -0.253> 
		<-2.413, 14.117, -0.226> <-2.325, 14.043, -0.214> <-2.325, 14.043, -0.214> <-2.410, 14.119, -0.242> 
		<-2.294, 14.023, -0.184> <-2.283, 14.033, -0.193> <-2.280, 14.034, -0.213> <-2.287, 14.028, -0.227> 
		<-2.215, 13.940, -0.161> <-2.204, 13.949, -0.169> <-2.199, 13.953, -0.203> <-2.207, 13.946, -0.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 12.776, -0.259> <-0.257, 12.779, -0.306> <-0.210, 12.778, -0.398> <-0.163, 12.778, -0.422> 
		<-0.205, 12.949, -0.276> <-0.230, 12.952, -0.323> <-0.155, 12.923, -0.430> <-0.108, 12.923, -0.454> 
		<-0.045, 13.154, -0.192> <-0.059, 13.175, -0.239> <-0.014, 13.148, -0.337> <0.016, 13.111, -0.361> 
		<0.100, 13.253, -0.179> <0.087, 13.274, -0.226> <0.116, 13.237, -0.317> <0.146, 13.200, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 12.776, -0.259> <-0.205, 12.949, -0.276> <-0.045, 13.154, -0.192> <0.100, 13.253, -0.179> 
		<-0.206, 12.773, -0.207> <-0.178, 12.946, -0.223> <-0.031, 13.131, -0.140> <0.115, 13.230, -0.126> 
		<-0.099, 12.763, -0.171> <-0.066, 12.888, -0.156> <0.072, 13.064, -0.101> <0.175, 13.142, -0.090> 
		<-0.046, 12.763, -0.197> <-0.013, 12.888, -0.183> <0.106, 13.024, -0.128> <0.209, 13.101, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.046, 12.763, -0.197> <-0.013, 12.888, -0.183> <0.106, 13.024, -0.128> <0.209, 13.101, -0.117> 
		<0.009, 12.763, -0.225> <0.042, 12.888, -0.211> <0.141, 12.981, -0.156> <0.244, 13.058, -0.145> 
		<0.056, 12.773, -0.335> <0.109, 12.872, -0.338> <0.192, 12.963, -0.274> <0.281, 13.028, -0.254> 
		<0.027, 12.776, -0.390> <0.080, 12.875, -0.393> <0.176, 12.988, -0.328> <0.266, 13.053, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 12.776, -0.390> <0.080, 12.875, -0.393> <0.176, 12.988, -0.328> <0.266, 13.053, -0.309> 
		<0.001, 12.780, -0.441> <0.053, 12.879, -0.444> <0.162, 13.010, -0.380> <0.251, 13.075, -0.360> 
		<-0.111, 12.778, -0.448> <-0.056, 12.923, -0.480> <0.049, 13.072, -0.386> <0.179, 13.161, -0.367> 
		<-0.163, 12.778, -0.422> <-0.108, 12.923, -0.454> <0.016, 13.111, -0.361> <0.146, 13.200, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 13.253, -0.179> <0.087, 13.274, -0.226> <0.116, 13.237, -0.317> <0.146, 13.200, -0.341> 
		<0.207, 13.326, -0.169> <0.194, 13.347, -0.216> <0.208, 13.300, -0.304> <0.238, 13.263, -0.327> 
		<0.403, 13.282, -0.188> <0.411, 13.300, -0.225> <0.417, 13.265, -0.306> <0.406, 13.228, -0.325> 
		<0.532, 13.297, -0.190> <0.541, 13.315, -0.228> <0.528, 13.280, -0.301> <0.517, 13.243, -0.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 13.253, -0.179> <0.207, 13.326, -0.169> <0.403, 13.282, -0.188> <0.532, 13.297, -0.190> 
		<0.115, 13.230, -0.126> <0.222, 13.303, -0.117> <0.394, 13.262, -0.146> <0.523, 13.277, -0.148> 
		<0.175, 13.142, -0.090> <0.241, 13.191, -0.083> <0.409, 13.184, -0.115> <0.490, 13.198, -0.119> 
		<0.209, 13.101, -0.117> <0.275, 13.151, -0.110> <0.396, 13.143, -0.137> <0.478, 13.157, -0.140> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.209, 13.101, -0.117> <0.275, 13.151, -0.110> <0.396, 13.143, -0.137> <0.478, 13.157, -0.140> 
		<0.244, 13.058, -0.145> <0.310, 13.108, -0.137> <0.383, 13.101, -0.159> <0.465, 13.115, -0.163> 
		<0.281, 13.028, -0.254> <0.331, 13.065, -0.244> <0.399, 13.065, -0.253> <0.461, 13.077, -0.251> 
		<0.266, 13.053, -0.309> <0.316, 13.089, -0.298> <0.408, 13.086, -0.297> <0.470, 13.098, -0.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.266, 13.053, -0.309> <0.316, 13.089, -0.298> <0.408, 13.086, -0.297> <0.470, 13.098, -0.295> 
		<0.251, 13.075, -0.360> <0.301, 13.112, -0.350> <0.417, 13.106, -0.338> <0.479, 13.118, -0.336> 
		<0.179, 13.161, -0.367> <0.271, 13.224, -0.353> <0.393, 13.189, -0.346> <0.505, 13.204, -0.341> 
		<0.146, 13.200, -0.341> <0.238, 13.263, -0.327> <0.406, 13.228, -0.325> <0.517, 13.243, -0.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.532, 13.297, -0.190> <0.541, 13.315, -0.228> <0.528, 13.280, -0.301> <0.517, 13.243, -0.320> 
		<0.791, 13.328, -0.196> <0.799, 13.346, -0.233> <0.795, 13.316, -0.291> <0.783, 13.280, -0.310> 
		<1.140, 13.347, -0.222> <1.138, 13.360, -0.247> <1.139, 13.328, -0.314> <1.146, 13.303, -0.326> 
		<1.393, 13.408, -0.206> <1.391, 13.421, -0.231> <1.397, 13.397, -0.280> <1.404, 13.372, -0.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.532, 13.297, -0.190> <0.791, 13.328, -0.196> <1.140, 13.347, -0.222> <1.393, 13.408, -0.206> 
		<0.523, 13.277, -0.148> <0.782, 13.308, -0.154> <1.142, 13.333, -0.193> <1.395, 13.394, -0.177> 
		<0.490, 13.198, -0.119> <0.770, 13.247, -0.132> <1.133, 13.255, -0.167> <1.405, 13.337, -0.158> 
		<0.478, 13.157, -0.140> <0.758, 13.206, -0.153> <1.141, 13.228, -0.181> <1.413, 13.310, -0.172> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.478, 13.157, -0.140> <0.758, 13.206, -0.153> <1.141, 13.228, -0.181> <1.413, 13.310, -0.172> 
		<0.465, 13.115, -0.163> <0.744, 13.164, -0.176> <1.149, 13.199, -0.196> <1.421, 13.281, -0.187> 
		<0.461, 13.077, -0.251> <0.748, 13.132, -0.243> <1.156, 13.167, -0.276> <1.432, 13.259, -0.246> 
		<0.470, 13.098, -0.295> <0.758, 13.153, -0.287> <1.154, 13.182, -0.306> <1.430, 13.274, -0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.470, 13.098, -0.295> <0.758, 13.153, -0.287> <1.154, 13.182, -0.306> <1.430, 13.274, -0.276> 
		<0.479, 13.118, -0.336> <0.767, 13.172, -0.328> <1.151, 13.196, -0.333> <1.428, 13.288, -0.303> 
		<0.505, 13.204, -0.341> <0.771, 13.240, -0.331> <1.153, 13.276, -0.340> <1.411, 13.346, -0.306> 
		<0.517, 13.243, -0.320> <0.783, 13.280, -0.310> <1.146, 13.303, -0.326> <1.404, 13.372, -0.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.393, 13.408, -0.206> <1.391, 13.421, -0.231> <1.397, 13.397, -0.280> <1.404, 13.372, -0.293> 
		<1.490, 13.432, -0.199> <1.488, 13.445, -0.225> <1.500, 13.424, -0.266> <1.506, 13.400, -0.279> 
		<1.589, 13.513, -0.127> <1.585, 13.519, -0.142> <1.593, 13.501, -0.183> <1.602, 13.490, -0.190> 
		<1.669, 13.573, -0.118> <1.665, 13.579, -0.132> <1.674, 13.568, -0.160> <1.683, 13.557, -0.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.393, 13.408, -0.206> <1.490, 13.432, -0.199> <1.589, 13.513, -0.127> <1.669, 13.573, -0.118> 
		<1.395, 13.394, -0.177> <1.492, 13.417, -0.171> <1.594, 13.506, -0.112> <1.674, 13.566, -0.103> 
		<1.405, 13.337, -0.158> <1.511, 13.369, -0.155> <1.612, 13.462, -0.096> <1.692, 13.539, -0.092> 
		<1.413, 13.310, -0.172> <1.519, 13.342, -0.169> <1.622, 13.450, -0.104> <1.702, 13.527, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.413, 13.310, -0.172> <1.519, 13.342, -0.169> <1.622, 13.450, -0.104> <1.702, 13.527, -0.100> 
		<1.421, 13.281, -0.187> <1.527, 13.313, -0.184> <1.633, 13.437, -0.112> <1.713, 13.514, -0.108> 
		<1.432, 13.259, -0.246> <1.544, 13.295, -0.234> <1.644, 13.420, -0.162> <1.724, 13.505, -0.141> 
		<1.430, 13.274, -0.276> <1.541, 13.311, -0.263> <1.640, 13.428, -0.178> <1.719, 13.512, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.430, 13.274, -0.276> <1.541, 13.311, -0.263> <1.640, 13.428, -0.178> <1.719, 13.512, -0.158> 
		<1.428, 13.288, -0.303> <1.539, 13.325, -0.291> <1.635, 13.435, -0.194> <1.715, 13.519, -0.173> 
		<1.411, 13.346, -0.306> <1.514, 13.373, -0.293> <1.612, 13.478, -0.197> <1.693, 13.545, -0.175> 
		<1.404, 13.372, -0.293> <1.506, 13.400, -0.279> <1.602, 13.490, -0.190> <1.683, 13.557, -0.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.877, 13.727, -0.147> <1.796, 13.594, -0.138> <1.719, 13.512, -0.158> 
		<1.862, 13.745, -0.135> <1.794, 13.653, -0.140> <1.801, 13.587, -0.121> <1.724, 13.505, -0.141> 
		<1.758, 13.639, -0.108> <1.762, 13.632, -0.092> <1.703, 13.526, -0.100> <1.713, 13.514, -0.108> 
		<1.669, 13.573, -0.118> <1.674, 13.566, -0.103> <1.692, 13.539, -0.092> <1.702, 13.527, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> 
		<1.871, 13.732, -0.130> <1.804, 13.639, -0.134> <1.804, 13.639, -0.134> <1.877, 13.727, -0.147> 
		<1.785, 13.606, -0.095> <1.796, 13.593, -0.103> <1.801, 13.587, -0.121> <1.796, 13.594, -0.138> 
		<1.702, 13.527, -0.100> <1.713, 13.514, -0.108> <1.724, 13.505, -0.141> <1.719, 13.512, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.862, 13.745, -0.135> <1.758, 13.639, -0.108> <1.669, 13.573, -0.118> 
		<1.877, 13.727, -0.147> <1.794, 13.653, -0.140> <1.754, 13.645, -0.122> <1.665, 13.579, -0.132> 
		<1.796, 13.594, -0.138> <1.792, 13.601, -0.153> <1.684, 13.556, -0.168> <1.674, 13.568, -0.160> 
		<1.719, 13.512, -0.158> <1.715, 13.519, -0.173> <1.693, 13.545, -0.175> <1.683, 13.557, -0.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> 
		<1.877, 13.727, -0.147> <1.798, 13.648, -0.154> <1.798, 13.648, -0.154> <1.866, 13.741, -0.150> 
		<1.796, 13.594, -0.138> <1.792, 13.601, -0.153> <1.777, 13.614, -0.152> <1.767, 13.626, -0.144> 
		<1.719, 13.512, -0.158> <1.715, 13.519, -0.173> <1.693, 13.545, -0.175> <1.683, 13.557, -0.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> 
		<1.866, 13.741, -0.150> <1.783, 13.667, -0.143> <1.783, 13.667, -0.143> <1.862, 13.745, -0.135> 
		<1.767, 13.626, -0.144> <1.758, 13.637, -0.137> <1.754, 13.645, -0.122> <1.758, 13.639, -0.108> 
		<1.683, 13.557, -0.167> <1.674, 13.568, -0.160> <1.665, 13.579, -0.132> <1.669, 13.573, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> <1.944, 13.819, -0.142> 
		<1.871, 13.732, -0.130> <1.789, 13.658, -0.122> <1.789, 13.658, -0.122> <1.862, 13.745, -0.135> 
		<1.785, 13.606, -0.095> <1.775, 13.618, -0.087> <1.762, 13.632, -0.092> <1.758, 13.639, -0.108> 
		<1.702, 13.527, -0.100> <1.692, 13.539, -0.092> <1.674, 13.566, -0.103> <1.669, 13.573, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.866, 13.741, -0.150> <1.767, 13.626, -0.144> <1.683, 13.557, -0.167> 
		<1.871, 13.732, -0.130> <1.793, 13.653, -0.137> <1.777, 13.614, -0.152> <1.693, 13.545, -0.175> 
		<1.785, 13.606, -0.095> <1.796, 13.593, -0.103> <1.720, 13.512, -0.157> <1.715, 13.519, -0.173> 
		<1.702, 13.527, -0.100> <1.713, 13.514, -0.108> <1.724, 13.505, -0.141> <1.719, 13.512, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.944, 13.819, -0.142> <1.871, 13.732, -0.130> <1.785, 13.606, -0.095> <1.702, 13.527, -0.100> 
		<1.866, 13.741, -0.150> <1.793, 13.653, -0.137> <1.775, 13.618, -0.087> <1.692, 13.539, -0.092> 
		<1.767, 13.626, -0.144> <1.758, 13.637, -0.137> <1.670, 13.572, -0.117> <1.674, 13.566, -0.103> 
		<1.683, 13.557, -0.167> <1.674, 13.568, -0.160> <1.665, 13.579, -0.132> <1.669, 13.573, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.992, -0.287, 0.634> <-1.173, -0.287, 0.646> <-1.564, -0.287, 0.947> <-1.582, -0.287, 0.767> 
		<-0.918, -0.201, 0.566> <-1.099, -0.201, 0.578> <-1.391, -0.201, 0.851> <-1.409, -0.201, 0.670> 
		<-0.763, -0.123, 0.454> <-0.842, -0.123, 0.456> <-1.041, -0.180, 0.611> <-1.077, -0.180, 0.540> 
		<-0.744, 0.000, 0.407> <-0.823, 0.000, 0.409> <-0.971, 0.000, 0.516> <-1.006, 0.000, 0.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.992, -0.287, 0.634> <-0.918, -0.201, 0.566> <-0.763, -0.123, 0.454> <-0.744, 0.000, 0.407> 
		<-0.868, -0.287, 0.627> <-0.794, -0.201, 0.558> <-0.686, -0.123, 0.453> <-0.668, 0.000, 0.405> 
		<-0.707, -0.287, 0.722> <-0.679, -0.201, 0.641> <-0.567, -0.114, 0.490> <-0.566, 0.000, 0.447> 
		<-0.585, -0.287, 0.704> <-0.557, -0.201, 0.622> <-0.492, -0.114, 0.476> <-0.491, 0.000, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.585, -0.287, 0.704> <-0.557, -0.201, 0.622> <-0.492, -0.114, 0.476> <-0.491, 0.000, 0.433> 
		<-0.476, -0.287, 0.687> <-0.448, -0.201, 0.606> <-0.393, -0.114, 0.458> <-0.392, 0.000, 0.415> 
		<-0.359, -0.287, 0.580> <-0.334, -0.201, 0.513> <-0.268, -0.109, 0.375> <-0.271, 0.000, 0.349> 
		<-0.263, -0.287, 0.526> <-0.238, -0.201, 0.459> <-0.177, -0.109, 0.330> <-0.180, 0.000, 0.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.263, -0.287, 0.526> <-0.238, -0.201, 0.459> <-0.177, -0.109, 0.330> <-0.180, 0.000, 0.304> 
		<-0.210, -0.287, 0.496> <-0.185, -0.201, 0.430> <-0.143, -0.109, 0.314> <-0.146, 0.000, 0.288> 
		<-0.105, -0.287, 0.482> <-0.102, -0.201, 0.425> <-0.080, -0.102, 0.287> <-0.087, 0.000, 0.268> 
		<-0.088, -0.287, 0.424> <-0.085, -0.201, 0.366> <-0.070, -0.102, 0.251> <-0.077, 0.000, 0.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.088, -0.287, 0.424> <-0.085, -0.201, 0.366> <-0.070, -0.102, 0.251> <-0.077, 0.000, 0.232> 
		<-0.043, -0.287, 0.271> <-0.040, -0.201, 0.213> <-0.045, -0.102, 0.155> <-0.052, 0.000, 0.136> 
		<-0.089, -0.287, 0.052> <-0.087, -0.201, 0.055> <-0.080, -0.086, 0.002> <-0.078, 0.000, 0.001> 
		<-0.079, -0.287, -0.107> <-0.077, -0.201, -0.104> <-0.074, -0.086, -0.097> <-0.072, 0.000, -0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.079, -0.287, -0.107> <-0.077, -0.201, -0.104> <-0.074, -0.086, -0.097> <-0.072, 0.000, -0.098> 
		<-0.072, -0.287, -0.226> <-0.070, -0.201, -0.223> <-0.070, -0.086, -0.171> <-0.067, 0.000, -0.172> 
		<0.021, -0.287, -0.394> <0.018, -0.201, -0.347> <-0.011, -0.098, -0.288> <-0.009, 0.000, -0.277> 
		<-0.031, -0.287, -0.502> <-0.035, -0.201, -0.454> <-0.044, -0.098, -0.355> <-0.042, 0.000, -0.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.031, -0.287, -0.502> <-0.035, -0.201, -0.454> <-0.044, -0.098, -0.355> <-0.042, 0.000, -0.344> 
		<-0.061, -0.287, -0.562> <-0.064, -0.201, -0.515> <-0.062, -0.098, -0.393> <-0.061, 0.000, -0.382> 
		<-0.191, -0.287, -0.434> <-0.169, -0.201, -0.392> <-0.156, -0.098, -0.305> <-0.142, 0.000, -0.300> 
		<-0.253, -0.287, -0.461> <-0.231, -0.201, -0.418> <-0.194, -0.098, -0.324> <-0.180, 0.000, -0.318> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.253, -0.287, -0.461> <-0.231, -0.201, -0.418> <-0.194, -0.098, -0.324> <-0.180, 0.000, -0.318> 
		<-0.349, -0.287, -0.501> <-0.327, -0.201, -0.459> <-0.297, -0.098, -0.376> <-0.283, 0.000, -0.370> 
		<-0.437, -0.287, -0.621> <-0.429, -0.201, -0.579> <-0.426, -0.093, -0.483> <-0.404, 0.000, -0.472> 
		<-0.503, -0.287, -0.702> <-0.495, -0.201, -0.660> <-0.499, -0.093, -0.572> <-0.477, 0.000, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.503, -0.287, -0.702> <-0.495, -0.201, -0.660> <-0.499, -0.093, -0.572> <-0.477, 0.000, -0.561> 
		<-0.567, -0.287, -0.779> <-0.559, -0.201, -0.737> <-0.516, -0.093, -0.592> <-0.494, 0.000, -0.582> 
		<-0.602, -0.287, -1.042> <-0.532, -0.201, -0.940> <-0.465, -0.143, -0.676> <-0.423, 0.000, -0.652> 
		<-0.683, -0.287, -0.982> <-0.612, -0.201, -0.881> <-0.490, -0.143, -0.667> <-0.447, 0.000, -0.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.683, -0.287, -0.982> <-0.612, -0.201, -0.881> <-0.490, -0.143, -0.667> <-0.447, 0.000, -0.643> 
		<-0.803, -0.287, -0.892> <-0.733, -0.201, -0.790> <-0.548, -0.143, -0.645> <-0.506, 0.000, -0.621> 
		<-0.661, -0.287, -0.575> <-0.609, -0.201, -0.582> <-0.591, -0.096, -0.539> <-0.559, 0.000, -0.548> 
		<-0.786, -0.287, -0.490> <-0.734, -0.201, -0.497> <-0.643, -0.096, -0.504> <-0.611, 0.000, -0.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.786, -0.287, -0.490> <-0.734, -0.201, -0.497> <-0.643, -0.096, -0.504> <-0.611, 0.000, -0.512> 
		<-0.947, -0.287, -0.381> <-0.895, -0.201, -0.388> <-0.731, -0.096, -0.444> <-0.699, 0.000, -0.452> 
		<-1.241, -0.287, -0.481> <-1.085, -0.201, -0.437> <-0.898, -0.163, -0.344> <-0.816, 0.000, -0.367> 
		<-1.435, -0.287, -0.472> <-1.279, -0.201, -0.428> <-0.997, -0.163, -0.303> <-0.915, 0.000, -0.325> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.435, -0.287, -0.472> <-1.279, -0.201, -0.428> <-0.997, -0.163, -0.303> <-0.915, 0.000, -0.325> 
		<-1.522, -0.287, -0.468> <-1.366, -0.201, -0.424> <-1.047, -0.163, -0.282> <-0.965, 0.000, -0.304> 
		<-1.777, -0.287, -0.515> <-1.588, -0.201, -0.474> <-1.199, -0.181, -0.337> <-1.092, 0.000, -0.363> 
		<-1.725, -0.287, -0.445> <-1.536, -0.201, -0.404> <-1.201, -0.181, -0.283> <-1.095, 0.000, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.725, -0.287, -0.445> <-1.536, -0.201, -0.404> <-1.201, -0.181, -0.283> <-1.095, 0.000, -0.309> 
		<-1.579, -0.287, -0.249> <-1.390, -0.201, -0.208> <-1.205, -0.181, -0.203> <-1.098, 0.000, -0.229> 
		<-1.244, -0.287, -0.133> <-1.203, -0.201, -0.173> <-0.981, -0.096, -0.145> <-0.959, 0.000, -0.177> 
		<-1.062, -0.287, 0.030> <-1.021, -0.201, -0.010> <-0.947, -0.096, -0.074> <-0.925, 0.000, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.062, -0.287, 0.030> <-1.021, -0.201, -0.010> <-0.947, -0.096, -0.074> <-0.925, 0.000, -0.105> 
		<-1.031, -0.287, 0.058> <-0.990, -0.201, 0.017> <-0.916, -0.096, -0.010> <-0.894, 0.000, -0.042> 
		<-1.014, -0.287, 0.133> <-0.968, -0.201, 0.121> <-0.889, -0.092, 0.088> <-0.874, 0.000, 0.057> 
		<-1.038, -0.287, 0.167> <-0.992, -0.201, 0.155> <-0.900, -0.092, 0.158> <-0.884, 0.000, 0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.038, -0.287, 0.167> <-0.992, -0.201, 0.155> <-0.900, -0.092, 0.158> <-0.884, 0.000, 0.126> 
		<-1.178, -0.287, 0.365> <-1.132, -0.201, 0.353> <-0.915, -0.092, 0.259> <-0.899, 0.000, 0.227> 
		<-1.606, -0.287, 0.525> <-1.433, -0.201, 0.428> <-1.123, -0.180, 0.449> <-1.052, 0.000, 0.353> 
		<-1.582, -0.287, 0.767> <-1.409, -0.201, 0.670> <-1.077, -0.180, 0.540> <-1.006, 0.000, 0.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.353, -0.287, -0.505> <0.495, -0.287, -0.524> <0.666, -0.287, -0.622> <0.796, -0.287, -0.683> 
		<0.370, -0.201, -0.498> <0.512, -0.201, -0.517> <0.649, -0.201, -0.582> <0.779, -0.201, -0.643> 
		<0.407, -0.087, -0.496> <0.506, -0.087, -0.513> <0.654, -0.092, -0.541> <0.748, -0.092, -0.576> 
		<0.411, 0.000, -0.481> <0.509, 0.000, -0.498> <0.644, 0.000, -0.514> <0.738, 0.000, -0.549> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.353, -0.287, -0.505> <0.370, -0.201, -0.498> <0.407, -0.087, -0.496> <0.411, 0.000, -0.481> 
		<0.253, -0.287, -0.492> <0.271, -0.201, -0.485> <0.294, -0.087, -0.477> <0.297, 0.000, -0.462> 
		<0.119, -0.287, -0.621> <0.120, -0.201, -0.575> <0.122, -0.095, -0.502> <0.132, 0.000, -0.484> 
		<0.028, -0.287, -0.581> <0.029, -0.201, -0.535> <0.021, -0.095, -0.446> <0.031, 0.000, -0.428> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.028, -0.287, -0.581> <0.029, -0.201, -0.535> <0.021, -0.095, -0.446> <0.031, 0.000, -0.428> 
		<-0.027, -0.287, -0.556> <-0.026, -0.201, -0.510> <-0.016, -0.095, -0.426> <-0.006, 0.000, -0.407> 
		<0.080, -0.287, -0.446> <0.076, -0.201, -0.418> <0.064, -0.090, -0.345> <0.067, 0.000, -0.335> 
		<0.084, -0.287, -0.386> <0.080, -0.201, -0.358> <0.067, -0.090, -0.303> <0.070, 0.000, -0.292> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, -0.287, -0.386> <0.080, -0.201, -0.358> <0.067, -0.090, -0.303> <0.070, 0.000, -0.292> 
		<0.092, -0.287, -0.271> <0.088, -0.201, -0.243> <0.073, -0.090, -0.223> <0.076, 0.000, -0.212> 
		<0.072, -0.287, -0.117> <0.069, -0.201, -0.124> <0.068, -0.087, -0.104> <0.066, 0.000, -0.105> 
		<0.069, -0.287, -0.002> <0.066, -0.201, -0.009> <0.061, -0.087, -0.024> <0.060, 0.000, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.069, -0.287, -0.002> <0.066, -0.201, -0.009> <0.061, -0.087, -0.024> <0.060, 0.000, -0.025> 
		<0.067, -0.287, 0.049> <0.065, -0.201, 0.042> <0.058, -0.087, 0.017> <0.056, 0.000, 0.015> 
		<0.044, -0.287, 0.123> <0.034, -0.201, 0.105> <0.019, -0.088, 0.077> <0.015, 0.000, 0.073> 
		<0.068, -0.287, 0.168> <0.058, -0.201, 0.150> <0.039, -0.088, 0.113> <0.036, 0.000, 0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.068, -0.287, 0.168> <0.058, -0.201, 0.150> <0.039, -0.088, 0.113> <0.036, 0.000, 0.109> 
		<0.113, -0.287, 0.252> <0.104, -0.201, 0.235> <0.081, -0.088, 0.185> <0.077, 0.000, 0.181> 
		<0.198, -0.287, 0.362> <0.185, -0.201, 0.330> <0.190, -0.091, 0.254> <0.174, 0.000, 0.247> 
		<0.285, -0.287, 0.403> <0.273, -0.201, 0.370> <0.259, -0.091, 0.301> <0.243, 0.000, 0.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.285, -0.287, 0.403> <0.273, -0.201, 0.370> <0.259, -0.091, 0.301> <0.243, 0.000, 0.295> 
		<0.379, -0.287, 0.446> <0.367, -0.201, 0.414> <0.328, -0.091, 0.349> <0.313, 0.000, 0.343> 
		<0.529, -0.287, 0.402> <0.488, -0.201, 0.402> <0.438, -0.091, 0.406> <0.410, 0.000, 0.408> 
		<0.630, -0.287, 0.426> <0.589, -0.201, 0.425> <0.520, -0.091, 0.422> <0.493, 0.000, 0.423> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.630, -0.287, 0.426> <0.589, -0.201, 0.425> <0.520, -0.091, 0.422> <0.493, 0.000, 0.423> 
		<0.818, -0.287, 0.470> <0.777, -0.201, 0.469> <0.634, -0.091, 0.443> <0.606, 0.000, 0.444> 
		<1.058, -0.287, 0.571> <0.948, -0.201, 0.507> <0.834, -0.136, 0.410> <0.761, 0.000, 0.409> 
		<1.243, -0.287, 0.627> <1.133, -0.201, 0.562> <0.949, -0.136, 0.412> <0.876, 0.000, 0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.243, -0.287, 0.627> <1.133, -0.201, 0.562> <0.949, -0.136, 0.412> <0.876, 0.000, 0.412> 
		<1.291, -0.287, 0.641> <1.181, -0.201, 0.576> <0.984, -0.136, 0.412> <0.911, 0.000, 0.412> 
		<1.435, -0.287, 0.698> <1.310, -0.201, 0.631> <1.063, -0.146, 0.465> <0.984, 0.000, 0.467> 
		<1.407, -0.287, 0.657> <1.282, -0.201, 0.590> <1.069, -0.146, 0.431> <0.990, 0.000, 0.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.407, -0.287, 0.657> <1.282, -0.201, 0.590> <1.069, -0.146, 0.431> <0.990, 0.000, 0.433> 
		<1.308, -0.287, 0.508> <1.183, -0.201, 0.441> <1.084, -0.146, 0.356> <1.004, 0.000, 0.357> 
		<1.034, -0.287, 0.409> <1.015, -0.201, 0.394> <0.938, -0.085, 0.248> <0.914, 0.000, 0.264> 
		<0.983, -0.287, 0.238> <0.963, -0.201, 0.223> <0.942, -0.085, 0.171> <0.918, 0.000, 0.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.983, -0.287, 0.238> <0.963, -0.201, 0.223> <0.942, -0.085, 0.171> <0.918, 0.000, 0.187> 
		<0.953, -0.287, 0.138> <0.934, -0.201, 0.123> <0.948, -0.085, 0.085> <0.924, 0.000, 0.101> 
		<1.117, -0.287, 0.029> <1.063, -0.201, 0.014> <0.999, -0.096, -0.038> <0.971, 0.000, -0.012> 
		<1.203, -0.287, -0.029> <1.148, -0.201, -0.045> <1.050, -0.096, -0.108> <1.022, 0.000, -0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.203, -0.287, -0.029> <1.148, -0.201, -0.045> <1.050, -0.096, -0.108> <1.022, 0.000, -0.082> 
		<1.339, -0.287, -0.123> <1.285, -0.201, -0.139> <1.087, -0.096, -0.161> <1.059, 0.000, -0.134> 
		<1.781, -0.287, -0.109> <1.628, -0.201, -0.093> <1.295, -0.152, -0.195> <1.224, 0.000, -0.144> 
		<1.706, -0.287, -0.257> <1.554, -0.201, -0.241> <1.269, -0.152, -0.254> <1.198, 0.000, -0.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.706, -0.287, -0.257> <1.554, -0.201, -0.241> <1.269, -0.152, -0.254> <1.198, 0.000, -0.203> 
		<1.612, -0.287, -0.444> <1.460, -0.201, -0.427> <1.230, -0.152, -0.343> <1.158, 0.000, -0.293> 
		<1.161, -0.287, -0.229> <1.125, -0.201, -0.218> <0.984, -0.089, -0.302> <0.969, 0.000, -0.274> 
		<1.023, -0.287, -0.386> <0.987, -0.201, -0.374> <0.919, -0.089, -0.375> <0.904, 0.000, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.023, -0.287, -0.386> <0.987, -0.201, -0.374> <0.919, -0.089, -0.375> <0.904, 0.000, -0.348> 
		<0.921, -0.287, -0.501> <0.886, -0.201, -0.490> <0.859, -0.089, -0.443> <0.845, 0.000, -0.416> 
		<1.252, -0.287, -0.757> <1.150, -0.201, -0.684> <0.901, -0.136, -0.630> <0.875, 0.000, -0.566> 
		<1.159, -0.287, -0.879> <1.057, -0.201, -0.806> <0.844, -0.136, -0.699> <0.818, 0.000, -0.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.159, -0.287, -0.879> <1.057, -0.201, -0.806> <0.844, -0.136, -0.699> <0.818, 0.000, -0.635> 
		<1.084, -0.287, -0.978> <0.982, -0.201, -0.904> <0.821, -0.136, -0.726> <0.795, 0.000, -0.663> 
		<0.909, -0.287, -0.735> <0.891, -0.201, -0.695> <0.781, -0.092, -0.589> <0.771, 0.000, -0.562> 
		<0.796, -0.287, -0.683> <0.779, -0.201, -0.643> <0.748, -0.092, -0.576> <0.738, 0.000, -0.549> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, 5.416, 0.014> <0.881, 5.416, 0.014> <0.881, 5.416, 0.014> <0.881, 5.416, 0.014> 
		<0.865, 5.440, -0.117> <0.878, 5.421, -0.011> <0.878, 5.421, -0.011> <0.894, 5.397, 0.119> 
		<0.892, 5.413, -0.303> <0.909, 5.387, -0.164> <0.936, 5.327, 0.021> <0.953, 5.302, 0.160> 
		<0.913, 5.281, -0.303> <0.930, 5.255, -0.164> <0.953, 5.221, 0.021> <0.970, 5.195, 0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, 5.416, 0.014> <0.865, 5.440, -0.117> <0.892, 5.413, -0.303> <0.913, 5.281, -0.303> 
		<0.761, 5.348, -0.010> <0.745, 5.372, -0.140> <0.753, 5.254, -0.317> <0.774, 5.121, -0.317> 
		<0.601, 5.258, -0.041> <0.601, 5.256, -0.243> <0.641, 5.102, -0.302> <0.588, 4.909, -0.334> 
		<0.480, 5.190, -0.065> <0.480, 5.188, -0.267> <0.501, 4.942, -0.316> <0.448, 4.749, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.881, 5.416, 0.014> <0.761, 5.348, -0.010> <0.601, 5.258, -0.041> <0.480, 5.190, -0.065> 
		<0.894, 5.397, 0.119> <0.774, 5.329, 0.096> <0.601, 5.260, 0.146> <0.480, 5.192, 0.122> 
		<0.953, 5.302, 0.160> <0.796, 5.170, 0.156> <0.654, 5.065, 0.180> <0.497, 4.933, 0.176> 
		<0.970, 5.195, 0.160> <0.813, 5.063, 0.156> <0.605, 4.887, 0.150> <0.448, 4.755, 0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.927, 5.127, 0.014> <0.934, 5.115, 0.077> <0.980, 5.132, 0.160> <0.970, 5.195, 0.160> 
		<0.725, 4.899, -0.051> <0.733, 4.887, 0.012> <0.823, 4.999, 0.156> <0.813, 5.063, 0.156> 
		<0.456, 4.595, -0.137> <0.456, 4.597, 0.078> <0.549, 4.683, 0.116> <0.605, 4.887, 0.150> 
		<0.255, 4.367, -0.202> <0.255, 4.369, 0.013> <0.392, 4.550, 0.112> <0.448, 4.755, 0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.927, 5.127, 0.014> <0.927, 5.127, 0.014> <0.927, 5.127, 0.014> <0.927, 5.127, 0.014> 
		<0.934, 5.115, 0.077> <0.918, 5.140, -0.056> <0.918, 5.140, -0.056> <0.911, 5.151, -0.119> 
		<0.980, 5.132, 0.160> <0.963, 5.157, 0.021> <0.952, 5.121, -0.164> <0.935, 5.146, -0.303> 
		<0.970, 5.195, 0.160> <0.953, 5.221, 0.021> <0.930, 5.255, -0.164> <0.913, 5.281, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.927, 5.127, 0.014> <0.725, 4.899, -0.051> <0.456, 4.595, -0.137> <0.255, 4.367, -0.202> 
		<0.911, 5.151, -0.119> <0.709, 4.923, -0.184> <0.456, 4.593, -0.312> <0.255, 4.365, -0.377> 
		<0.935, 5.146, -0.303> <0.795, 4.987, -0.317> <0.542, 4.742, -0.362> <0.403, 4.583, -0.375> 
		<0.913, 5.281, -0.303> <0.774, 5.121, -0.317> <0.588, 4.909, -0.334> <0.448, 4.749, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.480, 5.190, -0.065> <0.480, 5.190, -0.065> <0.480, 5.190, -0.065> <0.480, 5.190, -0.065> 
		<0.480, 5.192, 0.122> <0.480, 5.190, -0.080> <0.480, 5.190, -0.080> <0.480, 5.188, -0.267> 
		<0.497, 4.933, 0.176> <0.497, 4.931, 0.028> <0.501, 4.944, -0.167> <0.501, 4.942, -0.316> 
		<0.448, 4.755, 0.146> <0.448, 4.753, -0.002> <0.448, 4.751, -0.200> <0.448, 4.749, -0.348> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.255, 4.367, -0.202> <0.255, 4.367, -0.202> <0.255, 4.367, -0.202> <0.255, 4.367, -0.202> 
		<0.255, 4.365, -0.377> <0.255, 4.367, -0.162> <0.255, 4.367, -0.162> <0.255, 4.369, 0.013> 
		<0.403, 4.583, -0.375> <0.403, 4.584, -0.227> <0.392, 4.549, -0.036> <0.392, 4.550, 0.112> 
		<0.448, 4.749, -0.348> <0.448, 4.751, -0.200> <0.448, 4.753, -0.002> <0.448, 4.755, 0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 5.586, -0.570> <-0.297, 5.685, -0.646> <-0.367, 5.833, -0.738> <-0.435, 5.918, -0.824> 
		<-0.105, 5.623, -0.701> <-0.163, 5.723, -0.777> <-0.287, 5.855, -0.815> <-0.355, 5.940, -0.901> 
		<-0.007, 5.816, -0.674> <-0.094, 5.861, -0.751> <-0.189, 6.000, -0.852> <-0.277, 6.045, -0.929> 
		<0.029, 5.998, -0.629> <-0.058, 6.043, -0.706> <-0.175, 6.103, -0.808> <-0.262, 6.149, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 5.586, -0.570> <-0.239, 5.586, -0.570> <-0.239, 5.586, -0.570> <-0.239, 5.586, -0.570> 
		<-0.347, 5.555, -0.464> <-0.213, 5.593, -0.595> <-0.213, 5.593, -0.595> <-0.105, 5.623, -0.701> 
		<-0.291, 5.769, -0.380> <-0.204, 5.793, -0.466> <-0.094, 5.791, -0.588> <-0.007, 5.816, -0.674> 
		<-0.262, 5.917, -0.344> <-0.175, 5.941, -0.430> <-0.058, 5.974, -0.544> <0.029, 5.998, -0.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 5.586, -0.570> <-0.347, 5.555, -0.464> <-0.291, 5.769, -0.380> <-0.262, 5.917, -0.344> 
		<-0.297, 5.685, -0.646> <-0.406, 5.655, -0.540> <-0.379, 5.814, -0.457> <-0.350, 5.962, -0.421> 
		<-0.367, 5.833, -0.738> <-0.447, 5.811, -0.660> <-0.481, 5.918, -0.567> <-0.466, 6.022, -0.523> 
		<-0.435, 5.918, -0.824> <-0.514, 5.896, -0.746> <-0.568, 5.964, -0.644> <-0.554, 6.067, -0.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.095, 6.316, -0.392> <-0.095, 6.316, -0.392> <-0.095, 6.316, -0.392> <-0.095, 6.316, -0.392> 
		<0.017, 6.347, -0.502> <-0.100, 6.314, -0.387> <-0.100, 6.314, -0.387> <-0.213, 6.283, -0.277> 
		<0.060, 6.151, -0.592> <-0.028, 6.127, -0.506> <-0.143, 6.101, -0.391> <-0.231, 6.077, -0.305> 
		<0.029, 5.998, -0.629> <-0.058, 5.974, -0.544> <-0.175, 5.941, -0.430> <-0.262, 5.917, -0.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.095, 6.316, -0.392> <-0.181, 6.310, -0.472> <-0.304, 6.294, -0.572> <-0.382, 6.297, -0.661> 
		<-0.213, 6.283, -0.277> <-0.299, 6.277, -0.357> <-0.384, 6.271, -0.494> <-0.461, 6.275, -0.583> 
		<-0.231, 6.077, -0.305> <-0.318, 6.122, -0.382> <-0.452, 6.125, -0.479> <-0.539, 6.170, -0.555> 
		<-0.262, 5.917, -0.344> <-0.350, 5.962, -0.421> <-0.466, 6.022, -0.523> <-0.554, 6.067, -0.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.095, 6.316, -0.392> <0.017, 6.347, -0.502> <0.060, 6.151, -0.592> <0.029, 5.998, -0.629> 
		<-0.181, 6.310, -0.472> <-0.069, 6.342, -0.582> <-0.028, 6.196, -0.668> <-0.058, 6.043, -0.706> 
		<-0.304, 6.294, -0.572> <-0.225, 6.316, -0.650> <-0.160, 6.207, -0.764> <-0.175, 6.103, -0.808> 
		<-0.382, 6.297, -0.661> <-0.302, 6.320, -0.739> <-0.248, 6.252, -0.840> <-0.262, 6.149, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.651, 6.105, -1.094> <-0.651, 6.105, -1.094> <-0.651, 6.105, -1.094> <-0.651, 6.105, -1.094> 
		<-0.602, 6.118, -1.142> <-0.651, 6.105, -1.094> <-0.651, 6.105, -1.094> <-0.701, 6.091, -1.046> 
		<-0.553, 6.184, -1.160> <-0.629, 6.192, -1.171> <-0.733, 6.158, -1.056> <-0.734, 6.133, -0.982> 
		<-0.544, 6.248, -1.132> <-0.620, 6.256, -1.144> <-0.724, 6.222, -1.028> <-0.725, 6.197, -0.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.651, 6.105, -1.094> <-0.602, 6.118, -1.142> <-0.553, 6.184, -1.160> <-0.544, 6.248, -1.132> 
		<-0.586, 6.049, -1.013> <-0.537, 6.062, -1.061> <-0.438, 6.171, -1.142> <-0.429, 6.236, -1.115> 
		<-0.492, 5.991, -0.897> <-0.413, 6.013, -0.974> <-0.361, 6.075, -1.003> <-0.347, 6.178, -0.959> 
		<-0.435, 5.918, -0.824> <-0.355, 5.940, -0.901> <-0.277, 6.045, -0.929> <-0.262, 6.149, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.651, 6.105, -1.094> <-0.586, 6.049, -1.013> <-0.492, 5.991, -0.897> <-0.435, 5.918, -0.824> 
		<-0.701, 6.091, -1.046> <-0.636, 6.035, -0.964> <-0.572, 5.968, -0.819> <-0.514, 5.896, -0.746> 
		<-0.734, 6.133, -0.982> <-0.737, 6.093, -0.864> <-0.620, 6.003, -0.751> <-0.568, 5.964, -0.644> 
		<-0.725, 6.197, -0.955> <-0.728, 6.157, -0.837> <-0.605, 6.106, -0.706> <-0.554, 6.067, -0.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.618, 6.341, -0.993> <-0.668, 6.327, -0.944> <-0.716, 6.262, -0.927> <-0.725, 6.197, -0.955> 
		<-0.547, 6.328, -0.893> <-0.597, 6.314, -0.845> <-0.719, 6.221, -0.809> <-0.728, 6.157, -0.837> 
		<-0.462, 6.301, -0.754> <-0.542, 6.279, -0.676> <-0.591, 6.209, -0.662> <-0.605, 6.106, -0.706> 
		<-0.382, 6.297, -0.661> <-0.461, 6.275, -0.583> <-0.539, 6.170, -0.555> <-0.554, 6.067, -0.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.618, 6.341, -0.993> <-0.618, 6.341, -0.993> <-0.618, 6.341, -0.993> <-0.618, 6.341, -0.993> 
		<-0.668, 6.327, -0.944> <-0.618, 6.341, -0.993> <-0.618, 6.341, -0.993> <-0.569, 6.354, -1.041> 
		<-0.716, 6.262, -0.927> <-0.715, 6.287, -1.001> <-0.611, 6.320, -1.116> <-0.535, 6.312, -1.104> 
		<-0.725, 6.197, -0.955> <-0.724, 6.222, -1.028> <-0.620, 6.256, -1.144> <-0.544, 6.248, -1.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.618, 6.341, -0.993> <-0.547, 6.328, -0.893> <-0.462, 6.301, -0.754> <-0.382, 6.297, -0.661> 
		<-0.569, 6.354, -1.041> <-0.498, 6.341, -0.942> <-0.383, 6.323, -0.831> <-0.302, 6.320, -0.739> 
		<-0.535, 6.312, -1.104> <-0.420, 6.300, -1.087> <-0.332, 6.282, -0.915> <-0.248, 6.252, -0.840> 
		<-0.544, 6.248, -1.132> <-0.429, 6.236, -1.115> <-0.347, 6.178, -0.959> <-0.262, 6.149, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 5.918, -0.824> <-0.435, 5.918, -0.824> <-0.435, 5.918, -0.824> <-0.435, 5.918, -0.824> 
		<-0.355, 5.940, -0.901> <-0.435, 5.918, -0.824> <-0.435, 5.918, -0.824> <-0.514, 5.896, -0.746> 
		<-0.277, 6.045, -0.929> <-0.364, 6.021, -0.844> <-0.481, 5.988, -0.730> <-0.568, 5.964, -0.644> 
		<-0.262, 6.149, -0.885> <-0.350, 6.124, -0.799> <-0.466, 6.091, -0.685> <-0.554, 6.067, -0.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 6.067, -0.600> <-0.554, 6.067, -0.600> <-0.554, 6.067, -0.600> <-0.554, 6.067, -0.600> 
		<-0.466, 6.091, -0.685> <-0.452, 6.195, -0.641> <-0.452, 6.195, -0.641> <-0.539, 6.170, -0.555> 
		<-0.350, 6.124, -0.799> <-0.335, 6.227, -0.755> <-0.382, 6.297, -0.661> <-0.461, 6.275, -0.583> 
		<-0.262, 6.149, -0.885> <-0.248, 6.252, -0.840> <-0.302, 6.320, -0.739> <-0.382, 6.297, -0.661> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 6.067, -0.600> <-0.466, 6.091, -0.685> <-0.350, 6.124, -0.799> <-0.262, 6.149, -0.885> 
		<-0.605, 6.106, -0.706> <-0.518, 6.130, -0.792> <-0.434, 6.154, -0.873> <-0.347, 6.178, -0.959> 
		<-0.728, 6.157, -0.837> <-0.726, 6.182, -0.910> <-0.506, 6.244, -1.126> <-0.429, 6.236, -1.115> 
		<-0.725, 6.197, -0.955> <-0.724, 6.222, -1.028> <-0.620, 6.256, -1.144> <-0.544, 6.248, -1.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 9.957, -0.225> <0.246, 9.907, -0.200> <0.290, 9.796, -0.156> <0.364, 9.792, -0.142> 
		<0.176, 10.023, -0.329> <0.226, 9.974, -0.304> <0.290, 9.796, -0.219> <0.364, 9.792, -0.205> 
		<0.203, 9.773, -0.315> <0.258, 9.782, -0.295> <0.316, 9.731, -0.278> <0.370, 9.740, -0.257> 
		<0.196, 9.648, -0.326> <0.251, 9.657, -0.305> <0.323, 9.669, -0.278> <0.378, 9.677, -0.257> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 9.957, -0.225> <0.196, 9.957, -0.225> <0.196, 9.957, -0.225> <0.196, 9.957, -0.225> 
		<0.223, 9.867, -0.084> <0.203, 9.933, -0.188> <0.203, 9.933, -0.188> <0.176, 10.023, -0.329> 
		<0.242, 9.697, -0.122> <0.231, 9.733, -0.179> <0.214, 9.737, -0.258> <0.203, 9.773, -0.315> 
		<0.233, 9.528, -0.137> <0.222, 9.564, -0.193> <0.207, 9.612, -0.269> <0.196, 9.648, -0.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 9.957, -0.225> <0.223, 9.867, -0.084> <0.242, 9.697, -0.122> <0.233, 9.528, -0.137> 
		<0.246, 9.907, -0.200> <0.273, 9.817, -0.059> <0.286, 9.741, -0.089> <0.276, 9.573, -0.104> 
		<0.290, 9.796, -0.156> <0.290, 9.796, -0.093> <0.327, 9.695, -0.059> <0.334, 9.633, -0.059> 
		<0.364, 9.792, -0.142> <0.364, 9.792, -0.079> <0.370, 9.740, -0.026> <0.378, 9.677, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 9.189, -0.290> <0.152, 9.189, -0.290> <0.152, 9.189, -0.290> <0.152, 9.189, -0.290> 
		<0.124, 9.283, -0.439> <0.147, 9.205, -0.317> <0.147, 9.205, -0.317> <0.176, 9.111, -0.168> 
		<0.186, 9.470, -0.341> <0.197, 9.434, -0.284> <0.214, 9.418, -0.206> <0.224, 9.381, -0.149> 
		<0.196, 9.648, -0.326> <0.207, 9.612, -0.269> <0.222, 9.564, -0.193> <0.233, 9.528, -0.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 9.189, -0.290> <0.224, 9.301, -0.246> <0.300, 9.458, -0.165> <0.392, 9.563, -0.142> 
		<0.176, 9.111, -0.168> <0.248, 9.223, -0.123> <0.300, 9.458, -0.102> <0.392, 9.563, -0.079> 
		<0.224, 9.381, -0.149> <0.268, 9.426, -0.116> <0.342, 9.570, -0.059> <0.385, 9.615, -0.026> 
		<0.233, 9.528, -0.137> <0.276, 9.573, -0.104> <0.334, 9.633, -0.059> <0.378, 9.677, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 9.189, -0.290> <0.124, 9.283, -0.439> <0.186, 9.470, -0.341> <0.196, 9.648, -0.326> 
		<0.224, 9.301, -0.246> <0.195, 9.395, -0.395> <0.241, 9.479, -0.320> <0.251, 9.657, -0.305> 
		<0.300, 9.458, -0.165> <0.300, 9.458, -0.228> <0.331, 9.606, -0.278> <0.323, 9.669, -0.278> 
		<0.392, 9.563, -0.142> <0.392, 9.563, -0.205> <0.385, 9.615, -0.257> <0.378, 9.677, -0.257> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.364, 9.792, -0.142> <0.364, 9.792, -0.142> <0.364, 9.792, -0.142> <0.364, 9.792, -0.142> 
		<0.364, 9.792, -0.205> <0.364, 9.792, -0.142> <0.364, 9.792, -0.142> <0.364, 9.792, -0.079> 
		<0.370, 9.740, -0.257> <0.370, 9.740, -0.188> <0.370, 9.740, -0.096> <0.370, 9.740, -0.026> 
		<0.378, 9.677, -0.257> <0.378, 9.677, -0.188> <0.378, 9.677, -0.096> <0.378, 9.677, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.364, 9.792, -0.142> <0.454, 9.788, -0.125> <0.557, 9.888, -0.142> <0.637, 9.935, -0.142> 
		<0.364, 9.792, -0.205> <0.454, 9.788, -0.188> <0.557, 9.888, -0.176> <0.637, 9.935, -0.176> 
		<0.370, 9.740, -0.257> <0.462, 9.804, -0.242> <0.567, 9.849, -0.218> <0.658, 9.915, -0.205> 
		<0.378, 9.677, -0.257> <0.469, 9.742, -0.242> <0.592, 9.826, -0.218> <0.683, 9.892, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.364, 9.792, -0.142> <0.364, 9.792, -0.079> <0.370, 9.740, -0.026> <0.378, 9.677, -0.026> 
		<0.454, 9.788, -0.125> <0.454, 9.788, -0.062> <0.462, 9.804, -0.042> <0.469, 9.742, -0.042> 
		<0.557, 9.888, -0.142> <0.557, 9.888, -0.108> <0.567, 9.849, -0.066> <0.592, 9.826, -0.066> 
		<0.637, 9.935, -0.142> <0.637, 9.935, -0.108> <0.658, 9.915, -0.079> <0.683, 9.892, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.378, 9.677, -0.026> <0.378, 9.677, -0.026> <0.378, 9.677, -0.026> <0.378, 9.677, -0.026> 
		<0.378, 9.677, -0.096> <0.385, 9.615, -0.096> <0.385, 9.615, -0.096> <0.385, 9.615, -0.026> 
		<0.378, 9.677, -0.188> <0.385, 9.615, -0.188> <0.392, 9.563, -0.142> <0.392, 9.563, -0.079> 
		<0.378, 9.677, -0.257> <0.385, 9.615, -0.257> <0.392, 9.563, -0.205> <0.392, 9.563, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.378, 9.677, -0.026> <0.385, 9.615, -0.026> <0.392, 9.563, -0.079> <0.392, 9.563, -0.142> 
		<0.469, 9.742, -0.042> <0.477, 9.679, -0.042> <0.478, 9.662, -0.057> <0.478, 9.662, -0.120> 
		<0.592, 9.826, -0.066> <0.617, 9.803, -0.066> <0.629, 9.762, -0.108> <0.629, 9.762, -0.142> 
		<0.683, 9.892, -0.079> <0.708, 9.869, -0.079> <0.729, 9.849, -0.108> <0.729, 9.849, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.392, 9.563, -0.142> <0.392, 9.563, -0.205> <0.385, 9.615, -0.257> <0.378, 9.677, -0.257> 
		<0.478, 9.662, -0.120> <0.478, 9.662, -0.183> <0.477, 9.679, -0.242> <0.469, 9.742, -0.242> 
		<0.629, 9.762, -0.142> <0.629, 9.762, -0.176> <0.617, 9.803, -0.218> <0.592, 9.826, -0.218> 
		<0.729, 9.849, -0.142> <0.729, 9.849, -0.176> <0.708, 9.869, -0.205> <0.683, 9.892, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.637, 9.935, -0.142> <0.720, 9.983, -0.142> <0.821, 10.067, -0.140> <0.909, 10.107, -0.142> 
		<0.637, 9.935, -0.176> <0.720, 9.983, -0.176> <0.821, 10.067, -0.159> <0.909, 10.107, -0.162> 
		<0.658, 9.915, -0.205> <0.730, 9.968, -0.194> <0.837, 10.047, -0.185> <0.915, 10.092, -0.178> 
		<0.683, 9.892, -0.205> <0.756, 9.945, -0.194> <0.844, 10.029, -0.185> <0.922, 10.074, -0.178> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.637, 9.935, -0.142> <0.637, 9.935, -0.108> <0.658, 9.915, -0.079> <0.683, 9.892, -0.079> 
		<0.720, 9.983, -0.142> <0.720, 9.983, -0.108> <0.730, 9.968, -0.090> <0.756, 9.945, -0.090> 
		<0.821, 10.067, -0.140> <0.821, 10.067, -0.120> <0.837, 10.047, -0.095> <0.844, 10.029, -0.095> 
		<0.909, 10.107, -0.142> <0.909, 10.107, -0.122> <0.915, 10.092, -0.106> <0.922, 10.074, -0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.683, 9.892, -0.079> <0.708, 9.869, -0.079> <0.729, 9.849, -0.108> <0.729, 9.849, -0.142> 
		<0.756, 9.945, -0.090> <0.781, 9.922, -0.090> <0.792, 9.905, -0.108> <0.792, 9.905, -0.142> 
		<0.844, 10.029, -0.095> <0.851, 10.011, -0.095> <0.866, 9.991, -0.120> <0.866, 9.991, -0.140> 
		<0.922, 10.074, -0.106> <0.929, 10.055, -0.106> <0.935, 10.040, -0.122> <0.935, 10.040, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.729, 9.849, -0.142> <0.729, 9.849, -0.176> <0.708, 9.869, -0.205> <0.683, 9.892, -0.205> 
		<0.792, 9.905, -0.142> <0.792, 9.905, -0.176> <0.781, 9.922, -0.194> <0.756, 9.945, -0.194> 
		<0.866, 9.991, -0.140> <0.866, 9.991, -0.160> <0.851, 10.010, -0.185> <0.844, 10.029, -0.185> 
		<0.935, 10.040, -0.142> <0.935, 10.040, -0.162> <0.929, 10.055, -0.178> <0.922, 10.074, -0.178> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.130, 10.173, -0.152> <0.999, 10.148, -0.144> <0.909, 10.107, -0.142> 
		<1.138, 10.153, -0.152> <1.043, 10.124, -0.148> <0.999, 10.148, -0.124> <0.909, 10.107, -0.122> 
		<1.016, 10.097, -0.144> <1.016, 10.097, -0.124> <0.922, 10.074, -0.106> <0.915, 10.092, -0.106> 
		<0.935, 10.040, -0.142> <0.935, 10.040, -0.122> <0.929, 10.055, -0.106> <0.922, 10.074, -0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> 
		<1.134, 10.163, -0.141> <1.047, 10.114, -0.137> <1.047, 10.114, -0.137> <1.138, 10.153, -0.152> 
		<1.008, 10.123, -0.118> <1.015, 10.104, -0.118> <1.016, 10.097, -0.124> <1.016, 10.097, -0.144> 
		<0.922, 10.074, -0.106> <0.929, 10.055, -0.106> <0.935, 10.040, -0.122> <0.935, 10.040, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.138, 10.153, -0.152> <1.016, 10.097, -0.144> <0.935, 10.040, -0.142> 
		<1.130, 10.173, -0.152> <1.043, 10.124, -0.148> <1.016, 10.097, -0.164> <0.935, 10.040, -0.162> 
		<0.999, 10.148, -0.144> <0.999, 10.148, -0.164> <0.922, 10.074, -0.178> <0.929, 10.055, -0.178> 
		<0.909, 10.107, -0.142> <0.909, 10.107, -0.162> <0.915, 10.092, -0.178> <0.922, 10.074, -0.178> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> 
		<1.134, 10.163, -0.163> <1.047, 10.114, -0.158> <1.047, 10.114, -0.158> <1.138, 10.153, -0.152> 
		<1.008, 10.122, -0.170> <1.015, 10.104, -0.170> <1.016, 10.097, -0.164> <1.016, 10.097, -0.144> 
		<0.922, 10.074, -0.178> <0.929, 10.055, -0.178> <0.935, 10.040, -0.162> <0.935, 10.040, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.134, 10.163, -0.163> <1.008, 10.122, -0.170> <0.922, 10.074, -0.178> 
		<1.134, 10.163, -0.141> <1.043, 10.124, -0.148> <1.015, 10.104, -0.170> <0.929, 10.055, -0.178> 
		<1.008, 10.123, -0.118> <1.015, 10.104, -0.118> <0.935, 10.040, -0.142> <0.935, 10.040, -0.162> 
		<0.922, 10.074, -0.106> <0.929, 10.055, -0.106> <0.935, 10.040, -0.122> <0.935, 10.040, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.134, 10.163, -0.163> <1.008, 10.122, -0.170> <0.922, 10.074, -0.178> 
		<1.134, 10.163, -0.141> <1.043, 10.124, -0.148> <1.001, 10.141, -0.170> <0.915, 10.092, -0.178> 
		<1.008, 10.123, -0.118> <1.001, 10.141, -0.118> <0.909, 10.107, -0.142> <0.909, 10.107, -0.162> 
		<0.922, 10.074, -0.106> <0.915, 10.092, -0.106> <0.909, 10.107, -0.122> <0.909, 10.107, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> 
		<1.130, 10.173, -0.152> <1.039, 10.135, -0.158> <1.039, 10.135, -0.158> <1.134, 10.163, -0.163> 
		<0.999, 10.148, -0.144> <0.999, 10.148, -0.164> <1.001, 10.141, -0.170> <1.008, 10.122, -0.170> 
		<0.909, 10.107, -0.142> <0.909, 10.107, -0.162> <0.915, 10.092, -0.178> <0.922, 10.074, -0.178> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> <1.225, 10.201, -0.156> 
		<1.134, 10.163, -0.141> <1.039, 10.135, -0.137> <1.039, 10.135, -0.137> <1.130, 10.173, -0.152> 
		<1.008, 10.123, -0.118> <1.001, 10.141, -0.118> <0.999, 10.148, -0.124> <0.999, 10.148, -0.144> 
		<0.922, 10.074, -0.106> <0.915, 10.092, -0.106> <0.909, 10.107, -0.122> <0.909, 10.107, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.614, 13.102, -0.176> <-0.593, 13.129, -0.176> <-0.544, 13.157, -0.176> <-0.544, 13.191, -0.176> 
		<-0.603, 13.109, -0.271> <-0.582, 13.136, -0.271> <-0.539, 13.160, -0.221> <-0.538, 13.194, -0.220> 
		<-0.469, 13.106, -0.247> <-0.495, 13.144, -0.247> <-0.473, 13.177, -0.249> <-0.498, 13.216, -0.249> 
		<-0.373, 13.105, -0.241> <-0.399, 13.144, -0.241> <-0.433, 13.195, -0.241> <-0.458, 13.234, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.614, 13.102, -0.176> <-0.614, 13.102, -0.176> <-0.614, 13.102, -0.176> <-0.614, 13.102, -0.176> 
		<-0.625, 13.095, -0.084> <-0.614, 13.102, -0.180> <-0.614, 13.102, -0.180> <-0.603, 13.109, -0.271> 
		<-0.483, 13.094, -0.095> <-0.478, 13.097, -0.140> <-0.475, 13.102, -0.201> <-0.469, 13.106, -0.247> 
		<-0.391, 13.094, -0.089> <-0.386, 13.097, -0.135> <-0.379, 13.102, -0.196> <-0.373, 13.105, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.614, 13.102, -0.176> <-0.625, 13.095, -0.084> <-0.483, 13.094, -0.095> <-0.391, 13.094, -0.089> 
		<-0.593, 13.129, -0.176> <-0.604, 13.121, -0.084> <-0.509, 13.132, -0.095> <-0.417, 13.132, -0.089> 
		<-0.544, 13.157, -0.176> <-0.549, 13.153, -0.132> <-0.490, 13.166, -0.096> <-0.450, 13.184, -0.089> 
		<-0.544, 13.191, -0.176> <-0.549, 13.187, -0.132> <-0.516, 13.204, -0.096> <-0.476, 13.222, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, 13.102, -0.154> <-0.257, 13.102, -0.154> <-0.257, 13.102, -0.154> <-0.257, 13.102, -0.154> 
		<-0.250, 13.106, -0.210> <-0.257, 13.101, -0.153> <-0.257, 13.101, -0.153> <-0.263, 13.097, -0.097> 
		<-0.317, 13.105, -0.238> <-0.323, 13.102, -0.192> <-0.328, 13.097, -0.131> <-0.334, 13.094, -0.085> 
		<-0.373, 13.105, -0.241> <-0.379, 13.102, -0.196> <-0.386, 13.097, -0.135> <-0.391, 13.094, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, 13.102, -0.154> <-0.307, 13.144, -0.154> <-0.387, 13.189, -0.154> <-0.425, 13.243, -0.154> 
		<-0.263, 13.097, -0.097> <-0.314, 13.140, -0.097> <-0.391, 13.187, -0.121> <-0.429, 13.241, -0.122> 
		<-0.334, 13.094, -0.085> <-0.359, 13.132, -0.085> <-0.421, 13.197, -0.084> <-0.446, 13.235, -0.084> 
		<-0.391, 13.094, -0.089> <-0.417, 13.132, -0.089> <-0.450, 13.184, -0.089> <-0.476, 13.222, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, 13.102, -0.154> <-0.250, 13.106, -0.210> <-0.317, 13.105, -0.238> <-0.373, 13.105, -0.241> 
		<-0.307, 13.144, -0.154> <-0.301, 13.148, -0.210> <-0.343, 13.144, -0.238> <-0.399, 13.144, -0.241> 
		<-0.387, 13.189, -0.154> <-0.383, 13.192, -0.189> <-0.400, 13.210, -0.235> <-0.433, 13.195, -0.241> 
		<-0.425, 13.243, -0.154> <-0.421, 13.246, -0.190> <-0.425, 13.248, -0.235> <-0.458, 13.234, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> 
		<-0.538, 13.194, -0.220> <-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> <-0.549, 13.187, -0.132> 
		<-0.498, 13.216, -0.249> <-0.504, 13.212, -0.203> <-0.510, 13.208, -0.142> <-0.516, 13.204, -0.096> 
		<-0.458, 13.234, -0.241> <-0.463, 13.230, -0.196> <-0.470, 13.226, -0.135> <-0.476, 13.222, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 13.191, -0.176> <-0.543, 13.278, -0.175> <-0.606, 13.387, -0.172> <-0.613, 13.474, -0.171> 
		<-0.538, 13.194, -0.220> <-0.538, 13.281, -0.219> <-0.602, 13.387, -0.195> <-0.609, 13.474, -0.194> 
		<-0.498, 13.216, -0.249> <-0.530, 13.290, -0.238> <-0.572, 13.398, -0.218> <-0.588, 13.477, -0.211> 
		<-0.458, 13.234, -0.241> <-0.490, 13.308, -0.231> <-0.549, 13.401, -0.215> <-0.565, 13.480, -0.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 13.191, -0.176> <-0.549, 13.187, -0.132> <-0.516, 13.204, -0.096> <-0.476, 13.222, -0.089> 
		<-0.543, 13.278, -0.175> <-0.549, 13.275, -0.131> <-0.546, 13.281, -0.106> <-0.506, 13.299, -0.099> 
		<-0.606, 13.387, -0.172> <-0.609, 13.386, -0.149> <-0.585, 13.394, -0.119> <-0.563, 13.397, -0.116> 
		<-0.613, 13.474, -0.171> <-0.616, 13.474, -0.148> <-0.599, 13.476, -0.126> <-0.576, 13.478, -0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, 13.222, -0.089> <-0.476, 13.222, -0.089> <-0.476, 13.222, -0.089> <-0.476, 13.222, -0.089> 
		<-0.470, 13.226, -0.135> <-0.441, 13.239, -0.129> <-0.441, 13.239, -0.129> <-0.446, 13.235, -0.084> 
		<-0.463, 13.230, -0.196> <-0.431, 13.245, -0.190> <-0.425, 13.244, -0.157> <-0.429, 13.241, -0.122> 
		<-0.458, 13.234, -0.241> <-0.425, 13.248, -0.235> <-0.421, 13.246, -0.190> <-0.425, 13.243, -0.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, 13.222, -0.089> <-0.446, 13.235, -0.084> <-0.429, 13.241, -0.122> <-0.425, 13.243, -0.154> 
		<-0.506, 13.299, -0.099> <-0.476, 13.312, -0.094> <-0.475, 13.305, -0.123> <-0.471, 13.307, -0.155> 
		<-0.563, 13.397, -0.116> <-0.540, 13.399, -0.113> <-0.515, 13.407, -0.135> <-0.512, 13.407, -0.158> 
		<-0.576, 13.478, -0.123> <-0.554, 13.481, -0.120> <-0.532, 13.484, -0.136> <-0.529, 13.484, -0.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.425, 13.243, -0.154> <-0.421, 13.246, -0.190> <-0.425, 13.248, -0.235> <-0.458, 13.234, -0.241> 
		<-0.471, 13.307, -0.155> <-0.467, 13.310, -0.191> <-0.457, 13.322, -0.225> <-0.490, 13.308, -0.231> 
		<-0.512, 13.407, -0.158> <-0.509, 13.408, -0.181> <-0.526, 13.404, -0.212> <-0.549, 13.401, -0.215> 
		<-0.529, 13.484, -0.159> <-0.525, 13.485, -0.182> <-0.542, 13.483, -0.204> <-0.565, 13.480, -0.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 13.474, -0.171> <-0.618, 13.546, -0.170> <-0.605, 13.644, -0.166> <-0.585, 13.713, -0.170> 
		<-0.609, 13.474, -0.194> <-0.615, 13.546, -0.193> <-0.603, 13.643, -0.184> <-0.582, 13.712, -0.187> 
		<-0.588, 13.477, -0.211> <-0.600, 13.542, -0.205> <-0.580, 13.642, -0.201> <-0.566, 13.707, -0.200> 
		<-0.565, 13.480, -0.207> <-0.577, 13.545, -0.201> <-0.563, 13.637, -0.198> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 13.474, -0.171> <-0.616, 13.474, -0.148> <-0.599, 13.476, -0.126> <-0.576, 13.478, -0.123> 
		<-0.618, 13.546, -0.170> <-0.621, 13.546, -0.147> <-0.611, 13.542, -0.131> <-0.588, 13.545, -0.128> 
		<-0.605, 13.644, -0.166> <-0.607, 13.645, -0.147> <-0.592, 13.645, -0.122> <-0.574, 13.639, -0.119> 
		<-0.585, 13.713, -0.170> <-0.587, 13.714, -0.150> <-0.576, 13.710, -0.131> <-0.558, 13.705, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.576, 13.478, -0.123> <-0.554, 13.481, -0.120> <-0.532, 13.484, -0.136> <-0.529, 13.484, -0.159> 
		<-0.588, 13.545, -0.128> <-0.565, 13.548, -0.125> <-0.545, 13.545, -0.137> <-0.542, 13.546, -0.160> 
		<-0.574, 13.639, -0.119> <-0.556, 13.633, -0.117> <-0.535, 13.632, -0.137> <-0.532, 13.631, -0.156> 
		<-0.558, 13.705, -0.128> <-0.540, 13.699, -0.125> <-0.525, 13.694, -0.142> <-0.523, 13.693, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.529, 13.484, -0.159> <-0.525, 13.485, -0.182> <-0.542, 13.483, -0.204> <-0.565, 13.480, -0.207> 
		<-0.542, 13.546, -0.160> <-0.539, 13.546, -0.183> <-0.554, 13.548, -0.198> <-0.577, 13.545, -0.201> 
		<-0.532, 13.631, -0.156> <-0.530, 13.631, -0.174> <-0.547, 13.631, -0.196> <-0.563, 13.637, -0.198> 
		<-0.523, 13.693, -0.161> <-0.520, 13.693, -0.178> <-0.532, 13.696, -0.195> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.461, 13.960, -0.189> <-0.504, 13.809, -0.169> <-0.523, 13.693, -0.161> 
		<-0.480, 13.966, -0.192> <-0.506, 13.852, -0.180> <-0.502, 13.809, -0.187> <-0.520, 13.693, -0.178> 
		<-0.551, 13.826, -0.175> <-0.549, 13.825, -0.193> <-0.549, 13.702, -0.198> <-0.532, 13.696, -0.195> 
		<-0.585, 13.713, -0.170> <-0.582, 13.712, -0.187> <-0.566, 13.707, -0.200> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.469, 13.963, -0.201> <-0.514, 13.854, -0.191> <-0.514, 13.854, -0.191> <-0.480, 13.966, -0.192> 
		<-0.524, 13.816, -0.197> <-0.541, 13.821, -0.199> <-0.549, 13.825, -0.193> <-0.551, 13.826, -0.175> 
		<-0.549, 13.702, -0.198> <-0.566, 13.707, -0.200> <-0.582, 13.712, -0.187> <-0.585, 13.713, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.480, 13.966, -0.192> <-0.551, 13.826, -0.175> <-0.585, 13.713, -0.170> 
		<-0.461, 13.960, -0.189> <-0.506, 13.852, -0.180> <-0.554, 13.827, -0.156> <-0.587, 13.714, -0.150> 
		<-0.504, 13.809, -0.169> <-0.507, 13.810, -0.150> <-0.558, 13.705, -0.128> <-0.576, 13.710, -0.131> 
		<-0.523, 13.693, -0.161> <-0.525, 13.694, -0.142> <-0.540, 13.699, -0.125> <-0.558, 13.705, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.472, 13.963, -0.180> <-0.517, 13.855, -0.170> <-0.517, 13.855, -0.170> <-0.480, 13.966, -0.192> 
		<-0.531, 13.819, -0.143> <-0.549, 13.825, -0.146> <-0.554, 13.827, -0.156> <-0.551, 13.826, -0.175> 
		<-0.558, 13.705, -0.128> <-0.576, 13.710, -0.131> <-0.587, 13.714, -0.150> <-0.585, 13.713, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.469, 13.963, -0.201> <-0.524, 13.816, -0.197> <-0.549, 13.702, -0.198> 
		<-0.472, 13.963, -0.180> <-0.506, 13.852, -0.178> <-0.507, 13.811, -0.194> <-0.532, 13.696, -0.195> 
		<-0.531, 13.819, -0.143> <-0.513, 13.814, -0.141> <-0.523, 13.693, -0.159> <-0.520, 13.693, -0.178> 
		<-0.558, 13.705, -0.128> <-0.540, 13.699, -0.125> <-0.525, 13.694, -0.142> <-0.523, 13.693, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.461, 13.960, -0.189> <-0.496, 13.848, -0.188> <-0.496, 13.848, -0.188> <-0.469, 13.963, -0.201> 
		<-0.504, 13.809, -0.169> <-0.502, 13.809, -0.187> <-0.507, 13.811, -0.194> <-0.524, 13.816, -0.197> 
		<-0.523, 13.693, -0.161> <-0.520, 13.693, -0.178> <-0.532, 13.696, -0.195> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.469, 13.963, -0.201> <-0.524, 13.816, -0.197> <-0.549, 13.702, -0.198> 
		<-0.472, 13.963, -0.180> <-0.506, 13.852, -0.178> <-0.541, 13.821, -0.199> <-0.566, 13.707, -0.200> 
		<-0.531, 13.819, -0.143> <-0.549, 13.825, -0.146> <-0.585, 13.713, -0.168> <-0.582, 13.712, -0.187> 
		<-0.558, 13.705, -0.128> <-0.576, 13.710, -0.131> <-0.587, 13.714, -0.150> <-0.585, 13.713, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.461, 13.960, -0.189> <-0.498, 13.849, -0.167> <-0.498, 13.849, -0.167> <-0.472, 13.963, -0.180> 
		<-0.504, 13.809, -0.169> <-0.507, 13.810, -0.150> <-0.513, 13.814, -0.141> <-0.531, 13.819, -0.143> 
		<-0.523, 13.693, -0.161> <-0.525, 13.694, -0.142> <-0.540, 13.699, -0.125> <-0.558, 13.705, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.570, 13.435, -0.172> <-0.570, 13.435, -0.172> <-0.570, 13.435, -0.172> <-0.570, 13.435, -0.172> 
		<-0.570, 13.438, -0.198> <-0.570, 13.435, -0.173> <-0.570, 13.435, -0.173> <-0.570, 13.431, -0.147> 
		<-0.568, 13.465, -0.214> <-0.568, 13.461, -0.188> <-0.567, 13.456, -0.153> <-0.567, 13.453, -0.127> 
		<-0.564, 13.490, -0.210> <-0.563, 13.486, -0.184> <-0.563, 13.481, -0.149> <-0.563, 13.477, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.570, 13.435, -0.172> <-0.570, 13.438, -0.198> <-0.568, 13.465, -0.214> <-0.564, 13.490, -0.210> 
		<-0.617, 13.452, -0.172> <-0.617, 13.455, -0.197> <-0.613, 13.473, -0.209> <-0.609, 13.498, -0.204> 
		<-0.680, 13.475, -0.170> <-0.679, 13.477, -0.184> <-0.676, 13.495, -0.197> <-0.670, 13.507, -0.195> 
		<-0.728, 13.491, -0.170> <-0.727, 13.493, -0.183> <-0.722, 13.504, -0.193> <-0.716, 13.516, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.570, 13.435, -0.172> <-0.617, 13.452, -0.172> <-0.680, 13.475, -0.170> <-0.728, 13.491, -0.170> 
		<-0.570, 13.431, -0.147> <-0.617, 13.448, -0.146> <-0.681, 13.473, -0.157> <-0.729, 13.489, -0.156> 
		<-0.567, 13.453, -0.127> <-0.614, 13.462, -0.132> <-0.678, 13.487, -0.140> <-0.725, 13.498, -0.144> 
		<-0.563, 13.477, -0.122> <-0.610, 13.487, -0.128> <-0.672, 13.499, -0.138> <-0.719, 13.510, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.563, 13.477, -0.122> <-0.563, 13.477, -0.122> <-0.563, 13.477, -0.122> <-0.563, 13.477, -0.122> 
		<-0.563, 13.481, -0.149> <-0.560, 13.500, -0.146> <-0.560, 13.500, -0.146> <-0.560, 13.496, -0.119> 
		<-0.563, 13.486, -0.184> <-0.560, 13.506, -0.180> <-0.558, 13.509, -0.162> <-0.558, 13.506, -0.141> 
		<-0.564, 13.490, -0.210> <-0.560, 13.510, -0.207> <-0.558, 13.511, -0.181> <-0.558, 13.509, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.563, 13.477, -0.122> <-0.610, 13.487, -0.128> <-0.672, 13.499, -0.138> <-0.719, 13.510, -0.142> 
		<-0.560, 13.496, -0.119> <-0.607, 13.506, -0.125> <-0.667, 13.511, -0.136> <-0.713, 13.522, -0.140> 
		<-0.558, 13.506, -0.141> <-0.602, 13.514, -0.142> <-0.663, 13.525, -0.149> <-0.708, 13.533, -0.150> 
		<-0.558, 13.509, -0.160> <-0.602, 13.516, -0.161> <-0.662, 13.526, -0.162> <-0.707, 13.535, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 13.509, -0.160> <-0.602, 13.516, -0.161> <-0.662, 13.526, -0.162> <-0.707, 13.535, -0.163> 
		<-0.558, 13.511, -0.181> <-0.602, 13.519, -0.181> <-0.661, 13.528, -0.176> <-0.706, 13.537, -0.176> 
		<-0.560, 13.510, -0.207> <-0.606, 13.518, -0.201> <-0.664, 13.519, -0.193> <-0.710, 13.528, -0.189> 
		<-0.564, 13.490, -0.210> <-0.609, 13.498, -0.204> <-0.670, 13.507, -0.195> <-0.716, 13.516, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.728, 13.491, -0.170> <-0.727, 13.493, -0.183> <-0.722, 13.504, -0.193> <-0.716, 13.516, -0.191> 
		<-0.762, 13.502, -0.169> <-0.761, 13.504, -0.183> <-0.759, 13.512, -0.189> <-0.753, 13.524, -0.187> 
		<-0.807, 13.518, -0.167> <-0.806, 13.520, -0.177> <-0.802, 13.532, -0.187> <-0.800, 13.542, -0.185> 
		<-0.841, 13.525, -0.169> <-0.841, 13.526, -0.179> <-0.839, 13.536, -0.187> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.728, 13.491, -0.170> <-0.762, 13.502, -0.169> <-0.807, 13.518, -0.167> <-0.841, 13.525, -0.169> 
		<-0.729, 13.489, -0.156> <-0.763, 13.500, -0.156> <-0.807, 13.517, -0.157> <-0.842, 13.523, -0.159> 
		<-0.725, 13.498, -0.144> <-0.761, 13.506, -0.147> <-0.804, 13.526, -0.144> <-0.840, 13.531, -0.149> 
		<-0.719, 13.510, -0.142> <-0.755, 13.518, -0.145> <-0.802, 13.536, -0.142> <-0.838, 13.541, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.719, 13.510, -0.142> <-0.755, 13.518, -0.145> <-0.802, 13.536, -0.142> <-0.838, 13.541, -0.148> 
		<-0.713, 13.522, -0.140> <-0.749, 13.530, -0.143> <-0.800, 13.547, -0.141> <-0.837, 13.551, -0.146> 
		<-0.708, 13.533, -0.150> <-0.746, 13.541, -0.150> <-0.796, 13.559, -0.150> <-0.835, 13.560, -0.153> 
		<-0.707, 13.535, -0.163> <-0.745, 13.542, -0.163> <-0.796, 13.560, -0.161> <-0.835, 13.562, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 13.535, -0.163> <-0.745, 13.542, -0.163> <-0.796, 13.560, -0.161> <-0.835, 13.562, -0.164> 
		<-0.706, 13.537, -0.176> <-0.744, 13.544, -0.177> <-0.795, 13.562, -0.171> <-0.834, 13.563, -0.174> 
		<-0.710, 13.528, -0.189> <-0.747, 13.535, -0.185> <-0.798, 13.552, -0.184> <-0.836, 13.556, -0.184> 
		<-0.716, 13.516, -0.191> <-0.753, 13.524, -0.187> <-0.800, 13.542, -0.185> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.972, 13.539, -0.182> <-0.897, 13.535, -0.172> <-0.841, 13.525, -0.169> 
		<-0.970, 13.550, -0.180> <-0.914, 13.544, -0.175> <-0.897, 13.536, -0.182> <-0.841, 13.526, -0.179> 
		<-0.893, 13.563, -0.168> <-0.893, 13.565, -0.178> <-0.838, 13.546, -0.185> <-0.839, 13.536, -0.187> 
		<-0.835, 13.562, -0.164> <-0.834, 13.563, -0.174> <-0.836, 13.556, -0.184> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.971, 13.545, -0.187> <-0.915, 13.539, -0.181> <-0.915, 13.539, -0.181> <-0.972, 13.539, -0.182> 
		<-0.895, 13.551, -0.184> <-0.896, 13.541, -0.186> <-0.897, 13.536, -0.182> <-0.897, 13.535, -0.172> 
		<-0.838, 13.546, -0.185> <-0.839, 13.536, -0.187> <-0.841, 13.526, -0.179> <-0.841, 13.525, -0.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.970, 13.550, -0.180> <-0.893, 13.563, -0.168> <-0.835, 13.562, -0.164> 
		<-0.972, 13.539, -0.182> <-0.914, 13.544, -0.175> <-0.893, 13.562, -0.158> <-0.835, 13.560, -0.153> 
		<-0.897, 13.535, -0.172> <-0.897, 13.533, -0.162> <-0.838, 13.541, -0.148> <-0.837, 13.551, -0.146> 
		<-0.841, 13.525, -0.169> <-0.842, 13.523, -0.159> <-0.840, 13.531, -0.149> <-0.838, 13.541, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.972, 13.539, -0.182> <-0.915, 13.538, -0.170> <-0.915, 13.538, -0.170> <-0.971, 13.544, -0.176> 
		<-0.897, 13.535, -0.172> <-0.897, 13.533, -0.162> <-0.898, 13.537, -0.157> <-0.896, 13.547, -0.156> 
		<-0.841, 13.525, -0.169> <-0.842, 13.523, -0.159> <-0.840, 13.531, -0.149> <-0.838, 13.541, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.971, 13.545, -0.187> <-0.895, 13.551, -0.184> <-0.838, 13.546, -0.185> 
		<-0.971, 13.544, -0.176> <-0.914, 13.544, -0.175> <-0.893, 13.561, -0.183> <-0.836, 13.556, -0.184> 
		<-0.896, 13.547, -0.156> <-0.894, 13.557, -0.155> <-0.835, 13.562, -0.164> <-0.834, 13.563, -0.174> 
		<-0.838, 13.541, -0.148> <-0.837, 13.551, -0.146> <-0.835, 13.560, -0.153> <-0.835, 13.562, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.970, 13.550, -0.180> <-0.913, 13.550, -0.180> <-0.913, 13.550, -0.180> <-0.971, 13.545, -0.187> 
		<-0.893, 13.563, -0.168> <-0.893, 13.565, -0.178> <-0.893, 13.561, -0.183> <-0.895, 13.551, -0.184> 
		<-0.835, 13.562, -0.164> <-0.834, 13.563, -0.174> <-0.836, 13.556, -0.184> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.971, 13.545, -0.187> <-0.895, 13.551, -0.184> <-0.838, 13.546, -0.185> 
		<-0.971, 13.544, -0.176> <-0.914, 13.544, -0.175> <-0.896, 13.541, -0.186> <-0.839, 13.536, -0.187> 
		<-0.896, 13.547, -0.156> <-0.898, 13.537, -0.157> <-0.841, 13.525, -0.169> <-0.841, 13.526, -0.179> 
		<-0.838, 13.541, -0.148> <-0.840, 13.531, -0.149> <-0.842, 13.523, -0.159> <-0.841, 13.525, -0.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.971, 13.544, -0.176> <-0.913, 13.549, -0.168> <-0.913, 13.549, -0.168> <-0.970, 13.550, -0.180> 
		<-0.896, 13.547, -0.156> <-0.894, 13.557, -0.155> <-0.893, 13.562, -0.158> <-0.893, 13.563, -0.168> 
		<-0.838, 13.541, -0.148> <-0.837, 13.551, -0.146> <-0.835, 13.560, -0.153> <-0.835, 13.562, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.614, 13.102, -0.176> <-0.593, 13.129, -0.176> <-0.544, 13.157, -0.176> <-0.544, 13.191, -0.176> 
		<-0.603, 13.109, -0.271> <-0.582, 13.136, -0.271> <-0.539, 13.160, -0.221> <-0.538, 13.194, -0.220> 
		<-0.469, 13.106, -0.247> <-0.495, 13.144, -0.247> <-0.473, 13.177, -0.249> <-0.498, 13.216, -0.249> 
		<-0.373, 13.105, -0.241> <-0.399, 13.144, -0.241> <-0.433, 13.195, -0.241> <-0.458, 13.234, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.614, 13.102, -0.176> <-0.614, 13.102, -0.176> <-0.614, 13.102, -0.176> <-0.614, 13.102, -0.176> 
		<-0.625, 13.095, -0.084> <-0.614, 13.102, -0.180> <-0.614, 13.102, -0.180> <-0.603, 13.109, -0.271> 
		<-0.483, 13.094, -0.095> <-0.478, 13.097, -0.140> <-0.475, 13.102, -0.201> <-0.469, 13.106, -0.247> 
		<-0.391, 13.094, -0.089> <-0.386, 13.097, -0.135> <-0.379, 13.102, -0.196> <-0.373, 13.105, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.614, 13.102, -0.176> <-0.625, 13.095, -0.084> <-0.483, 13.094, -0.095> <-0.391, 13.094, -0.089> 
		<-0.593, 13.129, -0.176> <-0.604, 13.121, -0.084> <-0.509, 13.132, -0.095> <-0.417, 13.132, -0.089> 
		<-0.544, 13.157, -0.176> <-0.549, 13.153, -0.132> <-0.490, 13.166, -0.096> <-0.450, 13.184, -0.089> 
		<-0.544, 13.191, -0.176> <-0.549, 13.187, -0.132> <-0.516, 13.204, -0.096> <-0.476, 13.222, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, 13.102, -0.154> <-0.257, 13.102, -0.154> <-0.257, 13.102, -0.154> <-0.257, 13.102, -0.154> 
		<-0.250, 13.106, -0.210> <-0.257, 13.101, -0.153> <-0.257, 13.101, -0.153> <-0.263, 13.097, -0.097> 
		<-0.317, 13.105, -0.238> <-0.323, 13.102, -0.192> <-0.328, 13.097, -0.131> <-0.334, 13.094, -0.085> 
		<-0.373, 13.105, -0.241> <-0.379, 13.102, -0.196> <-0.386, 13.097, -0.135> <-0.391, 13.094, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, 13.102, -0.154> <-0.307, 13.144, -0.154> <-0.387, 13.189, -0.154> <-0.425, 13.243, -0.154> 
		<-0.263, 13.097, -0.097> <-0.314, 13.140, -0.097> <-0.391, 13.187, -0.121> <-0.429, 13.241, -0.122> 
		<-0.334, 13.094, -0.085> <-0.359, 13.132, -0.085> <-0.421, 13.197, -0.084> <-0.446, 13.235, -0.084> 
		<-0.391, 13.094, -0.089> <-0.417, 13.132, -0.089> <-0.450, 13.184, -0.089> <-0.476, 13.222, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, 13.102, -0.154> <-0.250, 13.106, -0.210> <-0.317, 13.105, -0.238> <-0.373, 13.105, -0.241> 
		<-0.307, 13.144, -0.154> <-0.301, 13.148, -0.210> <-0.343, 13.144, -0.238> <-0.399, 13.144, -0.241> 
		<-0.387, 13.189, -0.154> <-0.383, 13.192, -0.189> <-0.400, 13.210, -0.235> <-0.433, 13.195, -0.241> 
		<-0.425, 13.243, -0.154> <-0.421, 13.246, -0.190> <-0.425, 13.248, -0.235> <-0.458, 13.234, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> 
		<-0.538, 13.194, -0.220> <-0.544, 13.191, -0.176> <-0.544, 13.191, -0.176> <-0.549, 13.187, -0.132> 
		<-0.498, 13.216, -0.249> <-0.504, 13.212, -0.203> <-0.510, 13.208, -0.142> <-0.516, 13.204, -0.096> 
		<-0.458, 13.234, -0.241> <-0.463, 13.230, -0.196> <-0.470, 13.226, -0.135> <-0.476, 13.222, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 13.191, -0.176> <-0.543, 13.278, -0.175> <-0.606, 13.387, -0.172> <-0.613, 13.474, -0.171> 
		<-0.538, 13.194, -0.220> <-0.538, 13.281, -0.219> <-0.602, 13.387, -0.195> <-0.609, 13.474, -0.194> 
		<-0.498, 13.216, -0.249> <-0.530, 13.290, -0.238> <-0.572, 13.398, -0.218> <-0.588, 13.477, -0.211> 
		<-0.458, 13.234, -0.241> <-0.490, 13.308, -0.231> <-0.549, 13.401, -0.215> <-0.565, 13.480, -0.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 13.191, -0.176> <-0.549, 13.187, -0.132> <-0.516, 13.204, -0.096> <-0.476, 13.222, -0.089> 
		<-0.543, 13.278, -0.175> <-0.549, 13.275, -0.131> <-0.546, 13.281, -0.106> <-0.506, 13.299, -0.099> 
		<-0.606, 13.387, -0.172> <-0.609, 13.386, -0.149> <-0.585, 13.394, -0.119> <-0.563, 13.397, -0.115> 
		<-0.613, 13.474, -0.171> <-0.616, 13.474, -0.148> <-0.599, 13.476, -0.126> <-0.576, 13.478, -0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, 13.222, -0.089> <-0.476, 13.222, -0.089> <-0.476, 13.222, -0.089> <-0.476, 13.222, -0.089> 
		<-0.470, 13.226, -0.135> <-0.441, 13.239, -0.129> <-0.441, 13.239, -0.129> <-0.446, 13.235, -0.084> 
		<-0.463, 13.230, -0.196> <-0.431, 13.245, -0.190> <-0.425, 13.244, -0.157> <-0.429, 13.241, -0.122> 
		<-0.458, 13.234, -0.241> <-0.425, 13.248, -0.235> <-0.421, 13.246, -0.190> <-0.425, 13.243, -0.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, 13.222, -0.089> <-0.446, 13.235, -0.084> <-0.429, 13.241, -0.122> <-0.425, 13.243, -0.154> 
		<-0.506, 13.299, -0.099> <-0.476, 13.312, -0.094> <-0.475, 13.305, -0.123> <-0.471, 13.307, -0.155> 
		<-0.563, 13.397, -0.115> <-0.540, 13.400, -0.112> <-0.515, 13.407, -0.135> <-0.512, 13.407, -0.158> 
		<-0.576, 13.478, -0.123> <-0.554, 13.481, -0.120> <-0.532, 13.484, -0.136> <-0.529, 13.484, -0.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.425, 13.243, -0.154> <-0.421, 13.246, -0.190> <-0.425, 13.248, -0.235> <-0.458, 13.234, -0.241> 
		<-0.471, 13.307, -0.155> <-0.467, 13.310, -0.191> <-0.457, 13.322, -0.225> <-0.490, 13.308, -0.231> 
		<-0.512, 13.407, -0.158> <-0.509, 13.408, -0.181> <-0.526, 13.404, -0.212> <-0.549, 13.401, -0.215> 
		<-0.529, 13.484, -0.159> <-0.525, 13.485, -0.182> <-0.542, 13.483, -0.204> <-0.565, 13.480, -0.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 13.474, -0.171> <-0.618, 13.546, -0.170> <-0.605, 13.644, -0.166> <-0.585, 13.713, -0.170> 
		<-0.609, 13.474, -0.194> <-0.615, 13.546, -0.193> <-0.603, 13.643, -0.184> <-0.582, 13.712, -0.187> 
		<-0.588, 13.477, -0.211> <-0.600, 13.542, -0.205> <-0.580, 13.642, -0.201> <-0.566, 13.707, -0.200> 
		<-0.565, 13.480, -0.207> <-0.577, 13.545, -0.201> <-0.563, 13.637, -0.198> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 13.474, -0.171> <-0.616, 13.474, -0.148> <-0.599, 13.476, -0.126> <-0.576, 13.478, -0.123> 
		<-0.618, 13.546, -0.170> <-0.621, 13.546, -0.147> <-0.611, 13.542, -0.132> <-0.588, 13.545, -0.129> 
		<-0.605, 13.644, -0.166> <-0.607, 13.645, -0.148> <-0.590, 13.644, -0.126> <-0.574, 13.639, -0.124> 
		<-0.585, 13.713, -0.170> <-0.587, 13.714, -0.152> <-0.575, 13.710, -0.135> <-0.558, 13.705, -0.133> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.576, 13.478, -0.123> <-0.554, 13.481, -0.120> <-0.532, 13.484, -0.136> <-0.529, 13.484, -0.159> 
		<-0.588, 13.545, -0.129> <-0.565, 13.548, -0.126> <-0.545, 13.545, -0.137> <-0.542, 13.546, -0.160> 
		<-0.574, 13.639, -0.124> <-0.557, 13.633, -0.121> <-0.535, 13.632, -0.138> <-0.532, 13.631, -0.156> 
		<-0.558, 13.705, -0.133> <-0.541, 13.699, -0.130> <-0.525, 13.694, -0.143> <-0.523, 13.693, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.529, 13.484, -0.159> <-0.525, 13.485, -0.182> <-0.542, 13.483, -0.204> <-0.565, 13.480, -0.207> 
		<-0.542, 13.546, -0.160> <-0.539, 13.546, -0.183> <-0.554, 13.548, -0.198> <-0.577, 13.545, -0.201> 
		<-0.532, 13.631, -0.156> <-0.530, 13.631, -0.174> <-0.547, 13.631, -0.196> <-0.563, 13.637, -0.198> 
		<-0.523, 13.693, -0.161> <-0.520, 13.692, -0.178> <-0.532, 13.696, -0.195> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.461, 13.960, -0.189> <-0.504, 13.809, -0.169> <-0.523, 13.693, -0.161> 
		<-0.480, 13.966, -0.192> <-0.506, 13.852, -0.180> <-0.502, 13.809, -0.187> <-0.520, 13.692, -0.178> 
		<-0.551, 13.826, -0.175> <-0.549, 13.825, -0.193> <-0.549, 13.702, -0.198> <-0.532, 13.696, -0.195> 
		<-0.585, 13.713, -0.170> <-0.582, 13.712, -0.187> <-0.566, 13.707, -0.200> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.469, 13.963, -0.201> <-0.514, 13.854, -0.191> <-0.514, 13.854, -0.191> <-0.480, 13.966, -0.192> 
		<-0.524, 13.816, -0.197> <-0.541, 13.821, -0.199> <-0.549, 13.825, -0.193> <-0.551, 13.826, -0.175> 
		<-0.549, 13.702, -0.198> <-0.566, 13.707, -0.200> <-0.582, 13.712, -0.187> <-0.585, 13.713, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.480, 13.966, -0.192> <-0.551, 13.826, -0.175> <-0.585, 13.713, -0.170> 
		<-0.461, 13.960, -0.189> <-0.506, 13.852, -0.180> <-0.554, 13.827, -0.158> <-0.587, 13.714, -0.152> 
		<-0.504, 13.809, -0.169> <-0.507, 13.810, -0.151> <-0.558, 13.705, -0.133> <-0.575, 13.710, -0.135> 
		<-0.523, 13.693, -0.161> <-0.525, 13.694, -0.143> <-0.541, 13.699, -0.130> <-0.558, 13.705, -0.133> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.472, 13.963, -0.181> <-0.517, 13.855, -0.171> <-0.517, 13.855, -0.171> <-0.480, 13.966, -0.192> 
		<-0.531, 13.819, -0.148> <-0.548, 13.825, -0.150> <-0.554, 13.827, -0.158> <-0.551, 13.826, -0.175> 
		<-0.558, 13.705, -0.133> <-0.575, 13.710, -0.135> <-0.587, 13.714, -0.152> <-0.585, 13.713, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.469, 13.963, -0.201> <-0.524, 13.816, -0.197> <-0.549, 13.702, -0.198> 
		<-0.472, 13.963, -0.181> <-0.506, 13.852, -0.180> <-0.507, 13.811, -0.194> <-0.532, 13.696, -0.195> 
		<-0.531, 13.819, -0.148> <-0.514, 13.814, -0.145> <-0.523, 13.693, -0.161> <-0.520, 13.692, -0.178> 
		<-0.558, 13.705, -0.133> <-0.541, 13.699, -0.130> <-0.525, 13.694, -0.143> <-0.523, 13.693, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.461, 13.960, -0.189> <-0.496, 13.848, -0.188> <-0.496, 13.848, -0.188> <-0.469, 13.963, -0.201> 
		<-0.504, 13.809, -0.169> <-0.502, 13.809, -0.187> <-0.507, 13.811, -0.194> <-0.524, 13.816, -0.197> 
		<-0.523, 13.693, -0.161> <-0.520, 13.692, -0.178> <-0.532, 13.696, -0.195> <-0.549, 13.702, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.469, 13.963, -0.201> <-0.524, 13.816, -0.197> <-0.549, 13.702, -0.198> 
		<-0.472, 13.963, -0.181> <-0.506, 13.852, -0.180> <-0.541, 13.821, -0.199> <-0.566, 13.707, -0.200> 
		<-0.531, 13.819, -0.148> <-0.548, 13.825, -0.150> <-0.585, 13.713, -0.170> <-0.582, 13.712, -0.187> 
		<-0.558, 13.705, -0.133> <-0.575, 13.710, -0.135> <-0.587, 13.714, -0.152> <-0.585, 13.713, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> <-0.435, 14.074, -0.202> 
		<-0.461, 13.960, -0.189> <-0.498, 13.849, -0.169> <-0.498, 13.849, -0.169> <-0.472, 13.963, -0.181> 
		<-0.504, 13.809, -0.169> <-0.507, 13.810, -0.151> <-0.514, 13.814, -0.145> <-0.531, 13.819, -0.148> 
		<-0.523, 13.693, -0.161> <-0.525, 13.694, -0.143> <-0.541, 13.699, -0.130> <-0.558, 13.705, -0.133> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.570, 13.435, -0.172> <-0.570, 13.435, -0.172> <-0.570, 13.435, -0.172> <-0.570, 13.435, -0.172> 
		<-0.570, 13.438, -0.198> <-0.570, 13.435, -0.173> <-0.570, 13.435, -0.173> <-0.570, 13.431, -0.147> 
		<-0.568, 13.465, -0.214> <-0.568, 13.461, -0.188> <-0.567, 13.456, -0.153> <-0.567, 13.453, -0.127> 
		<-0.564, 13.490, -0.210> <-0.563, 13.486, -0.184> <-0.563, 13.481, -0.149> <-0.563, 13.477, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.570, 13.435, -0.172> <-0.570, 13.438, -0.198> <-0.568, 13.465, -0.214> <-0.564, 13.490, -0.210> 
		<-0.617, 13.452, -0.172> <-0.617, 13.455, -0.197> <-0.613, 13.473, -0.209> <-0.609, 13.498, -0.204> 
		<-0.680, 13.475, -0.170> <-0.679, 13.477, -0.184> <-0.676, 13.495, -0.197> <-0.670, 13.507, -0.195> 
		<-0.728, 13.491, -0.170> <-0.727, 13.493, -0.183> <-0.722, 13.504, -0.193> <-0.716, 13.516, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.570, 13.435, -0.172> <-0.617, 13.452, -0.172> <-0.680, 13.475, -0.170> <-0.728, 13.491, -0.170> 
		<-0.570, 13.431, -0.147> <-0.617, 13.448, -0.146> <-0.681, 13.473, -0.157> <-0.729, 13.489, -0.156> 
		<-0.567, 13.453, -0.127> <-0.614, 13.462, -0.132> <-0.678, 13.487, -0.140> <-0.725, 13.498, -0.144> 
		<-0.563, 13.477, -0.122> <-0.610, 13.487, -0.128> <-0.672, 13.499, -0.138> <-0.719, 13.510, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.563, 13.477, -0.122> <-0.563, 13.477, -0.122> <-0.563, 13.477, -0.122> <-0.563, 13.477, -0.122> 
		<-0.563, 13.481, -0.149> <-0.560, 13.500, -0.146> <-0.560, 13.500, -0.146> <-0.560, 13.496, -0.119> 
		<-0.563, 13.486, -0.184> <-0.560, 13.506, -0.180> <-0.558, 13.509, -0.162> <-0.558, 13.506, -0.141> 
		<-0.564, 13.490, -0.210> <-0.560, 13.510, -0.207> <-0.558, 13.511, -0.181> <-0.558, 13.509, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.563, 13.477, -0.122> <-0.610, 13.487, -0.128> <-0.672, 13.499, -0.138> <-0.719, 13.510, -0.142> 
		<-0.560, 13.496, -0.119> <-0.607, 13.506, -0.125> <-0.667, 13.511, -0.136> <-0.713, 13.522, -0.140> 
		<-0.558, 13.506, -0.141> <-0.602, 13.514, -0.142> <-0.663, 13.525, -0.149> <-0.708, 13.533, -0.150> 
		<-0.558, 13.509, -0.160> <-0.602, 13.516, -0.161> <-0.662, 13.526, -0.162> <-0.707, 13.535, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 13.509, -0.160> <-0.602, 13.516, -0.161> <-0.662, 13.526, -0.162> <-0.707, 13.535, -0.163> 
		<-0.558, 13.511, -0.181> <-0.602, 13.519, -0.181> <-0.661, 13.528, -0.176> <-0.706, 13.537, -0.176> 
		<-0.560, 13.510, -0.207> <-0.606, 13.518, -0.201> <-0.664, 13.519, -0.193> <-0.710, 13.528, -0.189> 
		<-0.564, 13.490, -0.210> <-0.609, 13.498, -0.204> <-0.670, 13.507, -0.195> <-0.716, 13.516, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.728, 13.491, -0.170> <-0.727, 13.493, -0.183> <-0.722, 13.504, -0.193> <-0.716, 13.516, -0.191> 
		<-0.762, 13.502, -0.169> <-0.761, 13.504, -0.183> <-0.759, 13.512, -0.189> <-0.753, 13.524, -0.187> 
		<-0.807, 13.518, -0.167> <-0.806, 13.520, -0.177> <-0.802, 13.532, -0.187> <-0.800, 13.542, -0.185> 
		<-0.841, 13.525, -0.169> <-0.841, 13.526, -0.179> <-0.839, 13.536, -0.187> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.728, 13.491, -0.170> <-0.762, 13.502, -0.169> <-0.807, 13.518, -0.167> <-0.841, 13.525, -0.169> 
		<-0.729, 13.489, -0.156> <-0.763, 13.500, -0.156> <-0.807, 13.517, -0.157> <-0.842, 13.523, -0.159> 
		<-0.725, 13.498, -0.144> <-0.761, 13.506, -0.147> <-0.804, 13.526, -0.144> <-0.840, 13.531, -0.149> 
		<-0.719, 13.510, -0.142> <-0.755, 13.518, -0.145> <-0.802, 13.536, -0.142> <-0.838, 13.541, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.719, 13.510, -0.142> <-0.755, 13.518, -0.145> <-0.802, 13.536, -0.142> <-0.838, 13.541, -0.148> 
		<-0.713, 13.522, -0.140> <-0.749, 13.530, -0.143> <-0.800, 13.547, -0.141> <-0.837, 13.551, -0.146> 
		<-0.708, 13.533, -0.150> <-0.746, 13.541, -0.150> <-0.796, 13.559, -0.150> <-0.835, 13.560, -0.153> 
		<-0.707, 13.535, -0.163> <-0.745, 13.542, -0.163> <-0.796, 13.560, -0.161> <-0.835, 13.562, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 13.535, -0.163> <-0.745, 13.542, -0.163> <-0.796, 13.560, -0.161> <-0.835, 13.562, -0.164> 
		<-0.706, 13.537, -0.176> <-0.744, 13.544, -0.177> <-0.795, 13.562, -0.171> <-0.834, 13.563, -0.174> 
		<-0.710, 13.528, -0.189> <-0.747, 13.535, -0.185> <-0.798, 13.552, -0.184> <-0.836, 13.556, -0.184> 
		<-0.716, 13.516, -0.191> <-0.753, 13.524, -0.187> <-0.800, 13.542, -0.185> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.972, 13.539, -0.182> <-0.897, 13.535, -0.172> <-0.841, 13.525, -0.169> 
		<-0.970, 13.550, -0.180> <-0.914, 13.544, -0.175> <-0.897, 13.536, -0.182> <-0.841, 13.526, -0.179> 
		<-0.893, 13.563, -0.168> <-0.893, 13.565, -0.178> <-0.838, 13.546, -0.185> <-0.839, 13.536, -0.187> 
		<-0.835, 13.562, -0.164> <-0.834, 13.563, -0.174> <-0.836, 13.556, -0.184> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.971, 13.545, -0.187> <-0.915, 13.539, -0.181> <-0.915, 13.539, -0.181> <-0.972, 13.539, -0.182> 
		<-0.895, 13.551, -0.184> <-0.896, 13.541, -0.186> <-0.897, 13.536, -0.182> <-0.897, 13.535, -0.172> 
		<-0.838, 13.546, -0.185> <-0.839, 13.536, -0.187> <-0.841, 13.526, -0.179> <-0.841, 13.525, -0.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.970, 13.550, -0.180> <-0.893, 13.563, -0.168> <-0.835, 13.562, -0.164> 
		<-0.972, 13.539, -0.182> <-0.914, 13.544, -0.175> <-0.893, 13.562, -0.158> <-0.835, 13.560, -0.153> 
		<-0.897, 13.535, -0.172> <-0.897, 13.533, -0.162> <-0.838, 13.541, -0.148> <-0.837, 13.551, -0.146> 
		<-0.841, 13.525, -0.169> <-0.842, 13.523, -0.159> <-0.840, 13.531, -0.149> <-0.838, 13.541, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.972, 13.539, -0.182> <-0.915, 13.538, -0.170> <-0.915, 13.538, -0.170> <-0.971, 13.544, -0.176> 
		<-0.897, 13.535, -0.172> <-0.897, 13.533, -0.162> <-0.898, 13.537, -0.157> <-0.896, 13.547, -0.156> 
		<-0.841, 13.525, -0.169> <-0.842, 13.523, -0.159> <-0.840, 13.531, -0.149> <-0.838, 13.541, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.971, 13.545, -0.187> <-0.895, 13.551, -0.184> <-0.838, 13.546, -0.185> 
		<-0.971, 13.544, -0.176> <-0.914, 13.544, -0.175> <-0.893, 13.561, -0.183> <-0.836, 13.556, -0.184> 
		<-0.896, 13.547, -0.156> <-0.894, 13.557, -0.155> <-0.835, 13.562, -0.164> <-0.834, 13.563, -0.174> 
		<-0.838, 13.541, -0.148> <-0.837, 13.551, -0.146> <-0.835, 13.560, -0.153> <-0.835, 13.562, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.970, 13.550, -0.180> <-0.913, 13.550, -0.180> <-0.913, 13.550, -0.180> <-0.971, 13.545, -0.187> 
		<-0.893, 13.563, -0.168> <-0.893, 13.565, -0.178> <-0.893, 13.561, -0.183> <-0.895, 13.551, -0.184> 
		<-0.835, 13.562, -0.164> <-0.834, 13.563, -0.174> <-0.836, 13.556, -0.184> <-0.838, 13.546, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-0.971, 13.545, -0.187> <-0.895, 13.551, -0.184> <-0.838, 13.546, -0.185> 
		<-0.971, 13.544, -0.176> <-0.914, 13.544, -0.175> <-0.896, 13.541, -0.186> <-0.839, 13.536, -0.187> 
		<-0.896, 13.547, -0.156> <-0.898, 13.537, -0.157> <-0.841, 13.525, -0.169> <-0.841, 13.526, -0.179> 
		<-0.838, 13.541, -0.148> <-0.840, 13.531, -0.149> <-0.842, 13.523, -0.159> <-0.841, 13.525, -0.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> <-1.028, 13.545, -0.188> 
		<-0.971, 13.544, -0.176> <-0.913, 13.549, -0.168> <-0.913, 13.549, -0.168> <-0.970, 13.550, -0.180> 
		<-0.896, 13.547, -0.156> <-0.894, 13.557, -0.155> <-0.893, 13.562, -0.158> <-0.893, 13.563, -0.168> 
		<-0.838, 13.541, -0.148> <-0.837, 13.551, -0.146> <-0.835, 13.560, -0.153> <-0.835, 13.562, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, 13.664, -0.179> <-0.518, 13.677, -0.163> <-0.466, 13.695, -0.142> <-0.427, 13.708, -0.127> 
		<-0.562, 13.656, -0.159> <-0.523, 13.669, -0.143> <-0.471, 13.696, -0.132> <-0.431, 13.709, -0.117> 
		<-0.562, 13.685, -0.141> <-0.527, 13.691, -0.133> <-0.473, 13.711, -0.121> <-0.438, 13.718, -0.111> 
		<-0.559, 13.707, -0.141> <-0.524, 13.713, -0.133> <-0.477, 13.720, -0.124> <-0.442, 13.727, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.550, 13.721, -0.180> <-0.551, 13.734, -0.169> <-0.557, 13.723, -0.141> <-0.559, 13.707, -0.141> 
		<-0.517, 13.728, -0.167> <-0.518, 13.740, -0.156> <-0.522, 13.729, -0.133> <-0.524, 13.713, -0.133> 
		<-0.474, 13.735, -0.150> <-0.478, 13.737, -0.140> <-0.480, 13.729, -0.127> <-0.477, 13.720, -0.124> 
		<-0.441, 13.742, -0.137> <-0.445, 13.743, -0.128> <-0.446, 13.737, -0.117> <-0.442, 13.727, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.427, 13.708, -0.127> <-0.402, 13.716, -0.117> <-0.369, 13.729, -0.108> <-0.344, 13.734, -0.097> 
		<-0.431, 13.709, -0.117> <-0.407, 13.717, -0.107> <-0.372, 13.730, -0.100> <-0.347, 13.735, -0.089> 
		<-0.438, 13.718, -0.111> <-0.410, 13.724, -0.104> <-0.377, 13.740, -0.094> <-0.350, 13.743, -0.084> 
		<-0.442, 13.727, -0.114> <-0.414, 13.733, -0.107> <-0.378, 13.748, -0.096> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.427, 13.708, -0.127> <-0.423, 13.706, -0.136> <-0.423, 13.713, -0.147> <-0.426, 13.722, -0.150> 
		<-0.402, 13.716, -0.117> <-0.398, 13.715, -0.127> <-0.397, 13.720, -0.136> <-0.401, 13.730, -0.139> 
		<-0.369, 13.729, -0.108> <-0.366, 13.728, -0.115> <-0.364, 13.735, -0.125> <-0.365, 13.743, -0.127> 
		<-0.344, 13.734, -0.097> <-0.341, 13.733, -0.104> <-0.339, 13.739, -0.112> <-0.340, 13.747, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.426, 13.722, -0.150> <-0.430, 13.732, -0.153> <-0.437, 13.741, -0.147> <-0.441, 13.742, -0.137> 
		<-0.401, 13.730, -0.139> <-0.404, 13.739, -0.142> <-0.409, 13.746, -0.136> <-0.413, 13.748, -0.127> 
		<-0.365, 13.743, -0.127> <-0.366, 13.751, -0.129> <-0.372, 13.761, -0.123> <-0.375, 13.762, -0.115> 
		<-0.340, 13.747, -0.113> <-0.341, 13.754, -0.115> <-0.344, 13.762, -0.110> <-0.347, 13.763, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, 13.742, -0.137> <-0.445, 13.743, -0.128> <-0.446, 13.737, -0.117> <-0.442, 13.727, -0.114> 
		<-0.413, 13.748, -0.127> <-0.417, 13.749, -0.117> <-0.418, 13.743, -0.110> <-0.414, 13.733, -0.107> 
		<-0.375, 13.762, -0.115> <-0.378, 13.763, -0.108> <-0.379, 13.756, -0.097> <-0.378, 13.748, -0.096> 
		<-0.347, 13.763, -0.102> <-0.350, 13.764, -0.095> <-0.352, 13.758, -0.087> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.252, 13.754, -0.054> <-0.305, 13.764, -0.083> <-0.347, 13.763, -0.102> 
		<-0.251, 13.745, -0.052> <-0.292, 13.749, -0.073> <-0.308, 13.766, -0.076> <-0.350, 13.764, -0.095> 
		<-0.303, 13.742, -0.079> <-0.306, 13.743, -0.072> <-0.351, 13.751, -0.086> <-0.352, 13.758, -0.087> 
		<-0.344, 13.734, -0.097> <-0.347, 13.735, -0.089> <-0.350, 13.743, -0.084> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.253, 13.750, -0.049> <-0.293, 13.745, -0.068> <-0.293, 13.745, -0.068> <-0.251, 13.745, -0.052> 
		<-0.309, 13.755, -0.071> <-0.308, 13.747, -0.069> <-0.306, 13.743, -0.072> <-0.303, 13.742, -0.079> 
		<-0.351, 13.751, -0.086> <-0.350, 13.743, -0.084> <-0.347, 13.735, -0.089> <-0.344, 13.734, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.251, 13.745, -0.052> <-0.303, 13.742, -0.079> <-0.344, 13.734, -0.097> 
		<-0.252, 13.754, -0.054> <-0.292, 13.749, -0.073> <-0.301, 13.741, -0.087> <-0.341, 13.733, -0.104> 
		<-0.305, 13.764, -0.083> <-0.302, 13.763, -0.091> <-0.340, 13.747, -0.113> <-0.339, 13.739, -0.112> 
		<-0.347, 13.763, -0.102> <-0.344, 13.762, -0.110> <-0.341, 13.754, -0.115> <-0.340, 13.747, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.250, 13.749, -0.057> <-0.289, 13.744, -0.076> <-0.289, 13.744, -0.076> <-0.251, 13.745, -0.052> 
		<-0.300, 13.752, -0.092> <-0.299, 13.744, -0.090> <-0.301, 13.741, -0.087> <-0.303, 13.742, -0.079> 
		<-0.340, 13.747, -0.113> <-0.339, 13.739, -0.112> <-0.341, 13.733, -0.104> <-0.344, 13.734, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.253, 13.750, -0.049> <-0.309, 13.755, -0.071> <-0.351, 13.751, -0.086> 
		<-0.250, 13.749, -0.057> <-0.292, 13.749, -0.073> <-0.310, 13.763, -0.073> <-0.352, 13.758, -0.087> 
		<-0.300, 13.752, -0.092> <-0.301, 13.760, -0.093> <-0.347, 13.763, -0.102> <-0.350, 13.764, -0.095> 
		<-0.340, 13.747, -0.113> <-0.341, 13.754, -0.115> <-0.344, 13.762, -0.110> <-0.347, 13.763, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.252, 13.754, -0.054> <-0.294, 13.754, -0.070> <-0.294, 13.754, -0.070> <-0.253, 13.750, -0.049> 
		<-0.305, 13.764, -0.083> <-0.308, 13.766, -0.076> <-0.310, 13.763, -0.073> <-0.309, 13.755, -0.071> 
		<-0.347, 13.763, -0.102> <-0.350, 13.764, -0.095> <-0.352, 13.758, -0.087> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.253, 13.750, -0.049> <-0.309, 13.755, -0.071> <-0.351, 13.751, -0.086> 
		<-0.250, 13.749, -0.057> <-0.292, 13.749, -0.073> <-0.308, 13.747, -0.069> <-0.350, 13.743, -0.084> 
		<-0.300, 13.752, -0.092> <-0.299, 13.744, -0.090> <-0.344, 13.734, -0.097> <-0.347, 13.735, -0.089> 
		<-0.340, 13.747, -0.113> <-0.339, 13.739, -0.112> <-0.341, 13.733, -0.104> <-0.344, 13.734, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.252, 13.754, -0.054> <-0.291, 13.753, -0.078> <-0.291, 13.753, -0.078> <-0.250, 13.749, -0.057> 
		<-0.305, 13.764, -0.083> <-0.302, 13.763, -0.091> <-0.301, 13.760, -0.093> <-0.300, 13.752, -0.092> 
		<-0.347, 13.763, -0.102> <-0.344, 13.762, -0.110> <-0.341, 13.754, -0.115> <-0.340, 13.747, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.545, 13.664, -0.167> <-0.509, 13.677, -0.155> <-0.463, 13.695, -0.139> <-0.427, 13.708, -0.127> 
		<-0.549, 13.656, -0.149> <-0.514, 13.670, -0.137> <-0.467, 13.697, -0.129> <-0.431, 13.709, -0.117> 
		<-0.557, 13.687, -0.137> <-0.522, 13.693, -0.129> <-0.473, 13.711, -0.121> <-0.438, 13.718, -0.111> 
		<-0.559, 13.707, -0.141> <-0.524, 13.713, -0.133> <-0.477, 13.720, -0.124> <-0.442, 13.727, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.550, 13.721, -0.180> <-0.555, 13.735, -0.171> <-0.561, 13.723, -0.144> <-0.559, 13.707, -0.141> 
		<-0.517, 13.728, -0.167> <-0.522, 13.741, -0.159> <-0.526, 13.729, -0.136> <-0.524, 13.713, -0.133> 
		<-0.474, 13.735, -0.150> <-0.478, 13.737, -0.140> <-0.480, 13.729, -0.127> <-0.477, 13.720, -0.124> 
		<-0.441, 13.742, -0.137> <-0.445, 13.743, -0.128> <-0.446, 13.737, -0.117> <-0.442, 13.727, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.427, 13.708, -0.127> <-0.402, 13.716, -0.118> <-0.369, 13.729, -0.108> <-0.344, 13.734, -0.097> 
		<-0.431, 13.709, -0.117> <-0.406, 13.718, -0.108> <-0.372, 13.730, -0.100> <-0.347, 13.735, -0.089> 
		<-0.438, 13.718, -0.111> <-0.410, 13.724, -0.104> <-0.377, 13.740, -0.094> <-0.350, 13.743, -0.084> 
		<-0.442, 13.727, -0.114> <-0.414, 13.733, -0.107> <-0.378, 13.748, -0.096> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.427, 13.708, -0.127> <-0.423, 13.706, -0.136> <-0.423, 13.713, -0.147> <-0.426, 13.722, -0.150> 
		<-0.402, 13.716, -0.118> <-0.398, 13.715, -0.127> <-0.397, 13.720, -0.136> <-0.401, 13.730, -0.139> 
		<-0.369, 13.729, -0.108> <-0.366, 13.728, -0.115> <-0.364, 13.735, -0.125> <-0.365, 13.743, -0.127> 
		<-0.344, 13.734, -0.097> <-0.341, 13.733, -0.104> <-0.339, 13.739, -0.112> <-0.340, 13.747, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.426, 13.722, -0.150> <-0.430, 13.732, -0.153> <-0.437, 13.741, -0.147> <-0.441, 13.742, -0.137> 
		<-0.401, 13.730, -0.139> <-0.404, 13.739, -0.142> <-0.409, 13.746, -0.136> <-0.413, 13.748, -0.127> 
		<-0.365, 13.743, -0.127> <-0.366, 13.751, -0.129> <-0.372, 13.761, -0.123> <-0.375, 13.762, -0.115> 
		<-0.340, 13.747, -0.113> <-0.341, 13.754, -0.115> <-0.344, 13.762, -0.110> <-0.347, 13.763, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, 13.742, -0.137> <-0.445, 13.743, -0.128> <-0.446, 13.737, -0.117> <-0.442, 13.727, -0.114> 
		<-0.413, 13.748, -0.127> <-0.417, 13.749, -0.117> <-0.418, 13.743, -0.110> <-0.414, 13.733, -0.107> 
		<-0.375, 13.762, -0.115> <-0.378, 13.763, -0.108> <-0.379, 13.756, -0.097> <-0.378, 13.748, -0.096> 
		<-0.347, 13.763, -0.102> <-0.350, 13.764, -0.095> <-0.352, 13.758, -0.087> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.252, 13.754, -0.054> <-0.305, 13.764, -0.083> <-0.347, 13.763, -0.102> 
		<-0.251, 13.745, -0.052> <-0.292, 13.749, -0.073> <-0.308, 13.766, -0.076> <-0.350, 13.764, -0.095> 
		<-0.303, 13.742, -0.079> <-0.306, 13.743, -0.072> <-0.351, 13.751, -0.086> <-0.352, 13.758, -0.087> 
		<-0.344, 13.734, -0.097> <-0.347, 13.735, -0.089> <-0.350, 13.743, -0.084> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.253, 13.750, -0.049> <-0.293, 13.745, -0.068> <-0.293, 13.745, -0.068> <-0.251, 13.745, -0.052> 
		<-0.309, 13.755, -0.071> <-0.308, 13.747, -0.069> <-0.306, 13.743, -0.072> <-0.303, 13.742, -0.079> 
		<-0.351, 13.751, -0.086> <-0.350, 13.743, -0.084> <-0.347, 13.735, -0.089> <-0.344, 13.734, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.251, 13.745, -0.052> <-0.303, 13.742, -0.079> <-0.344, 13.734, -0.097> 
		<-0.252, 13.754, -0.054> <-0.292, 13.749, -0.073> <-0.301, 13.741, -0.087> <-0.341, 13.733, -0.104> 
		<-0.305, 13.764, -0.083> <-0.302, 13.763, -0.091> <-0.340, 13.747, -0.113> <-0.339, 13.739, -0.112> 
		<-0.347, 13.763, -0.102> <-0.344, 13.762, -0.110> <-0.341, 13.754, -0.115> <-0.340, 13.747, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.250, 13.749, -0.057> <-0.289, 13.744, -0.076> <-0.289, 13.744, -0.076> <-0.251, 13.745, -0.052> 
		<-0.300, 13.752, -0.092> <-0.299, 13.744, -0.090> <-0.301, 13.741, -0.087> <-0.303, 13.742, -0.079> 
		<-0.340, 13.747, -0.113> <-0.339, 13.739, -0.112> <-0.341, 13.733, -0.104> <-0.344, 13.734, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.253, 13.750, -0.049> <-0.309, 13.755, -0.071> <-0.351, 13.751, -0.086> 
		<-0.250, 13.749, -0.057> <-0.292, 13.749, -0.073> <-0.310, 13.763, -0.073> <-0.352, 13.758, -0.087> 
		<-0.300, 13.752, -0.092> <-0.301, 13.760, -0.093> <-0.347, 13.763, -0.102> <-0.350, 13.764, -0.095> 
		<-0.340, 13.747, -0.113> <-0.341, 13.754, -0.115> <-0.344, 13.762, -0.110> <-0.347, 13.763, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.252, 13.754, -0.054> <-0.294, 13.754, -0.070> <-0.294, 13.754, -0.070> <-0.253, 13.750, -0.049> 
		<-0.305, 13.764, -0.083> <-0.308, 13.766, -0.076> <-0.310, 13.763, -0.073> <-0.309, 13.755, -0.071> 
		<-0.347, 13.763, -0.102> <-0.350, 13.764, -0.095> <-0.352, 13.758, -0.087> <-0.351, 13.751, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.253, 13.750, -0.049> <-0.309, 13.755, -0.071> <-0.351, 13.751, -0.086> 
		<-0.250, 13.749, -0.057> <-0.292, 13.749, -0.073> <-0.308, 13.747, -0.069> <-0.350, 13.743, -0.084> 
		<-0.300, 13.752, -0.092> <-0.299, 13.744, -0.090> <-0.344, 13.734, -0.097> <-0.347, 13.735, -0.089> 
		<-0.340, 13.747, -0.113> <-0.339, 13.739, -0.112> <-0.341, 13.733, -0.104> <-0.344, 13.734, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> <-0.211, 13.750, -0.033> 
		<-0.252, 13.754, -0.054> <-0.291, 13.753, -0.078> <-0.291, 13.753, -0.078> <-0.250, 13.749, -0.057> 
		<-0.305, 13.764, -0.083> <-0.302, 13.763, -0.091> <-0.301, 13.760, -0.093> <-0.300, 13.752, -0.092> 
		<-0.347, 13.763, -0.102> <-0.344, 13.762, -0.110> <-0.341, 13.754, -0.115> <-0.340, 13.747, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.418, 13.260, -0.213> <-1.418, 13.260, -0.213> <-1.418, 13.260, -0.213> <-1.418, 13.260, -0.213> 
		<-1.394, 13.269, -0.238> <-1.417, 13.260, -0.214> <-1.417, 13.260, -0.214> <-1.441, 13.250, -0.189> 
		<-1.375, 13.307, -0.244> <-1.399, 13.297, -0.219> <-1.430, 13.284, -0.184> <-1.454, 13.274, -0.158> 
		<-1.372, 13.338, -0.228> <-1.395, 13.328, -0.202> <-1.427, 13.315, -0.168> <-1.451, 13.305, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.418, 13.260, -0.213> <-1.394, 13.269, -0.238> <-1.375, 13.307, -0.244> <-1.372, 13.338, -0.228> 
		<-1.466, 13.296, -0.247> <-1.443, 13.306, -0.272> <-1.427, 13.330, -0.274> <-1.423, 13.361, -0.258> 
		<-1.530, 13.347, -0.291> <-1.517, 13.351, -0.303> <-1.500, 13.376, -0.308> <-1.494, 13.390, -0.297> 
		<-1.579, 13.382, -0.325> <-1.566, 13.387, -0.338> <-1.550, 13.402, -0.339> <-1.544, 13.415, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.418, 13.260, -0.213> <-1.466, 13.296, -0.247> <-1.530, 13.347, -0.291> <-1.579, 13.382, -0.325> 
		<-1.441, 13.250, -0.189> <-1.489, 13.287, -0.222> <-1.543, 13.342, -0.278> <-1.592, 13.377, -0.313> 
		<-1.454, 13.274, -0.158> <-1.497, 13.302, -0.200> <-1.554, 13.356, -0.253> <-1.598, 13.385, -0.293> 
		<-1.451, 13.305, -0.142> <-1.493, 13.333, -0.184> <-1.548, 13.370, -0.242> <-1.592, 13.399, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.451, 13.305, -0.142> <-1.451, 13.305, -0.142> <-1.451, 13.305, -0.142> <-1.451, 13.305, -0.142> 
		<-1.427, 13.315, -0.168> <-1.425, 13.338, -0.156> <-1.425, 13.338, -0.156> <-1.449, 13.328, -0.130> 
		<-1.395, 13.328, -0.202> <-1.393, 13.353, -0.189> <-1.407, 13.352, -0.167> <-1.425, 13.344, -0.147> 
		<-1.372, 13.338, -0.228> <-1.369, 13.363, -0.215> <-1.390, 13.359, -0.185> <-1.408, 13.351, -0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.451, 13.305, -0.142> <-1.493, 13.333, -0.184> <-1.548, 13.370, -0.242> <-1.592, 13.399, -0.282> 
		<-1.449, 13.328, -0.130> <-1.491, 13.356, -0.172> <-1.543, 13.383, -0.231> <-1.586, 13.412, -0.271> 
		<-1.425, 13.344, -0.147> <-1.470, 13.369, -0.183> <-1.526, 13.403, -0.237> <-1.571, 13.428, -0.273> 
		<-1.408, 13.351, -0.165> <-1.453, 13.376, -0.201> <-1.513, 13.407, -0.250> <-1.558, 13.432, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.408, 13.351, -0.165> <-1.453, 13.376, -0.201> <-1.513, 13.407, -0.250> <-1.558, 13.432, -0.285> 
		<-1.390, 13.359, -0.185> <-1.434, 13.383, -0.221> <-1.500, 13.412, -0.262> <-1.545, 13.437, -0.297> 
		<-1.369, 13.363, -0.215> <-1.421, 13.386, -0.245> <-1.489, 13.404, -0.286> <-1.539, 13.429, -0.317> 
		<-1.372, 13.338, -0.228> <-1.423, 13.361, -0.258> <-1.494, 13.390, -0.297> <-1.544, 13.415, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.579, 13.382, -0.325> <-1.566, 13.387, -0.338> <-1.550, 13.402, -0.339> <-1.544, 13.415, -0.328> 
		<-1.613, 13.407, -0.349> <-1.600, 13.411, -0.362> <-1.590, 13.422, -0.364> <-1.585, 13.436, -0.353> 
		<-1.660, 13.442, -0.379> <-1.650, 13.445, -0.389> <-1.635, 13.462, -0.391> <-1.634, 13.475, -0.384> 
		<-1.693, 13.461, -0.408> <-1.684, 13.465, -0.418> <-1.674, 13.478, -0.421> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.579, 13.382, -0.325> <-1.613, 13.407, -0.349> <-1.660, 13.442, -0.379> <-1.693, 13.461, -0.408> 
		<-1.592, 13.377, -0.313> <-1.626, 13.402, -0.337> <-1.669, 13.438, -0.369> <-1.703, 13.457, -0.399> 
		<-1.598, 13.385, -0.293> <-1.631, 13.408, -0.324> <-1.677, 13.447, -0.350> <-1.709, 13.464, -0.385> 
		<-1.592, 13.399, -0.282> <-1.625, 13.421, -0.313> <-1.675, 13.459, -0.344> <-1.707, 13.477, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.592, 13.399, -0.282> <-1.625, 13.421, -0.313> <-1.675, 13.459, -0.344> <-1.707, 13.477, -0.379> 
		<-1.586, 13.412, -0.271> <-1.620, 13.435, -0.302> <-1.673, 13.472, -0.337> <-1.706, 13.489, -0.372> 
		<-1.571, 13.428, -0.273> <-1.609, 13.449, -0.303> <-1.659, 13.489, -0.339> <-1.696, 13.503, -0.375> 
		<-1.558, 13.432, -0.285> <-1.596, 13.454, -0.315> <-1.649, 13.493, -0.349> <-1.687, 13.507, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.558, 13.432, -0.285> <-1.596, 13.454, -0.315> <-1.649, 13.493, -0.349> <-1.687, 13.507, -0.385> 
		<-1.545, 13.437, -0.297> <-1.583, 13.458, -0.328> <-1.639, 13.496, -0.359> <-1.677, 13.510, -0.394> 
		<-1.539, 13.429, -0.317> <-1.579, 13.450, -0.342> <-1.632, 13.487, -0.378> <-1.671, 13.503, -0.408> 
		<-1.544, 13.415, -0.328> <-1.585, 13.436, -0.353> <-1.634, 13.475, -0.384> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.816, 13.522, -0.527> <-1.747, 13.492, -0.455> <-1.693, 13.461, -0.408> 
		<-1.814, 13.536, -0.520> <-1.761, 13.510, -0.469> <-1.737, 13.496, -0.465> <-1.684, 13.465, -0.418> 
		<-1.743, 13.528, -0.438> <-1.734, 13.532, -0.448> <-1.672, 13.491, -0.414> <-1.674, 13.478, -0.421> 
		<-1.687, 13.507, -0.385> <-1.677, 13.510, -0.394> <-1.671, 13.503, -0.408> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.810, 13.531, -0.529> <-1.757, 13.505, -0.478> <-1.757, 13.505, -0.478> <-1.816, 13.522, -0.527> 
		<-1.732, 13.515, -0.460> <-1.733, 13.502, -0.467> <-1.737, 13.496, -0.465> <-1.747, 13.492, -0.455> 
		<-1.672, 13.491, -0.414> <-1.674, 13.478, -0.421> <-1.684, 13.465, -0.418> <-1.693, 13.461, -0.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.814, 13.536, -0.520> <-1.743, 13.528, -0.438> <-1.687, 13.507, -0.385> 
		<-1.816, 13.522, -0.527> <-1.761, 13.510, -0.469> <-1.753, 13.524, -0.428> <-1.696, 13.503, -0.375> 
		<-1.747, 13.492, -0.455> <-1.757, 13.488, -0.446> <-1.707, 13.477, -0.379> <-1.706, 13.489, -0.372> 
		<-1.693, 13.461, -0.408> <-1.703, 13.457, -0.399> <-1.709, 13.464, -0.385> <-1.707, 13.477, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.816, 13.522, -0.527> <-1.768, 13.501, -0.467> <-1.768, 13.501, -0.467> <-1.820, 13.527, -0.519> 
		<-1.747, 13.492, -0.455> <-1.757, 13.488, -0.446> <-1.760, 13.492, -0.440> <-1.759, 13.505, -0.433> 
		<-1.693, 13.461, -0.408> <-1.703, 13.457, -0.399> <-1.709, 13.464, -0.385> <-1.707, 13.477, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.810, 13.531, -0.529> <-1.732, 13.515, -0.460> <-1.672, 13.491, -0.414> 
		<-1.820, 13.527, -0.519> <-1.761, 13.510, -0.469> <-1.730, 13.527, -0.454> <-1.671, 13.503, -0.408> 
		<-1.759, 13.505, -0.433> <-1.757, 13.517, -0.427> <-1.687, 13.507, -0.385> <-1.677, 13.510, -0.394> 
		<-1.707, 13.477, -0.379> <-1.706, 13.489, -0.372> <-1.696, 13.503, -0.375> <-1.687, 13.507, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.814, 13.536, -0.520> <-1.755, 13.519, -0.471> <-1.755, 13.519, -0.471> <-1.810, 13.531, -0.529> 
		<-1.743, 13.528, -0.438> <-1.734, 13.532, -0.448> <-1.730, 13.527, -0.454> <-1.732, 13.515, -0.460> 
		<-1.687, 13.507, -0.385> <-1.677, 13.510, -0.394> <-1.671, 13.503, -0.408> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.810, 13.531, -0.529> <-1.732, 13.515, -0.460> <-1.672, 13.491, -0.414> 
		<-1.820, 13.527, -0.519> <-1.761, 13.510, -0.469> <-1.733, 13.502, -0.467> <-1.674, 13.478, -0.421> 
		<-1.759, 13.505, -0.433> <-1.760, 13.492, -0.440> <-1.693, 13.461, -0.408> <-1.684, 13.465, -0.418> 
		<-1.707, 13.477, -0.379> <-1.709, 13.464, -0.385> <-1.703, 13.457, -0.399> <-1.693, 13.461, -0.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.820, 13.527, -0.519> <-1.766, 13.514, -0.460> <-1.766, 13.514, -0.460> <-1.814, 13.536, -0.520> 
		<-1.759, 13.505, -0.433> <-1.757, 13.517, -0.427> <-1.753, 13.524, -0.428> <-1.743, 13.528, -0.438> 
		<-1.707, 13.477, -0.379> <-1.706, 13.489, -0.372> <-1.696, 13.503, -0.375> <-1.687, 13.507, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.418, 13.260, -0.213> <-1.418, 13.260, -0.213> <-1.418, 13.260, -0.213> <-1.418, 13.260, -0.213> 
		<-1.394, 13.269, -0.238> <-1.417, 13.260, -0.214> <-1.417, 13.260, -0.214> <-1.441, 13.250, -0.189> 
		<-1.375, 13.307, -0.244> <-1.399, 13.297, -0.219> <-1.430, 13.284, -0.184> <-1.454, 13.274, -0.158> 
		<-1.372, 13.338, -0.228> <-1.395, 13.328, -0.202> <-1.427, 13.315, -0.168> <-1.451, 13.305, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.418, 13.260, -0.213> <-1.394, 13.269, -0.238> <-1.375, 13.307, -0.244> <-1.372, 13.338, -0.228> 
		<-1.466, 13.296, -0.247> <-1.443, 13.306, -0.272> <-1.427, 13.330, -0.274> <-1.423, 13.361, -0.258> 
		<-1.530, 13.347, -0.291> <-1.517, 13.351, -0.303> <-1.500, 13.376, -0.308> <-1.494, 13.390, -0.297> 
		<-1.579, 13.382, -0.325> <-1.566, 13.387, -0.338> <-1.550, 13.402, -0.339> <-1.544, 13.415, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.418, 13.260, -0.213> <-1.466, 13.296, -0.247> <-1.530, 13.347, -0.291> <-1.579, 13.382, -0.325> 
		<-1.441, 13.250, -0.189> <-1.489, 13.287, -0.222> <-1.543, 13.342, -0.278> <-1.592, 13.377, -0.313> 
		<-1.454, 13.274, -0.158> <-1.497, 13.302, -0.200> <-1.554, 13.356, -0.253> <-1.598, 13.385, -0.293> 
		<-1.451, 13.305, -0.142> <-1.493, 13.333, -0.184> <-1.548, 13.370, -0.242> <-1.592, 13.399, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.451, 13.305, -0.142> <-1.451, 13.305, -0.142> <-1.451, 13.305, -0.142> <-1.451, 13.305, -0.142> 
		<-1.427, 13.315, -0.168> <-1.425, 13.338, -0.156> <-1.425, 13.338, -0.156> <-1.449, 13.328, -0.130> 
		<-1.395, 13.328, -0.202> <-1.393, 13.353, -0.189> <-1.407, 13.352, -0.167> <-1.425, 13.344, -0.147> 
		<-1.372, 13.338, -0.228> <-1.369, 13.363, -0.215> <-1.390, 13.359, -0.185> <-1.408, 13.351, -0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.451, 13.305, -0.142> <-1.493, 13.333, -0.184> <-1.548, 13.370, -0.242> <-1.592, 13.399, -0.282> 
		<-1.449, 13.328, -0.130> <-1.491, 13.356, -0.172> <-1.543, 13.383, -0.231> <-1.586, 13.412, -0.271> 
		<-1.425, 13.344, -0.147> <-1.470, 13.369, -0.183> <-1.526, 13.403, -0.237> <-1.571, 13.428, -0.273> 
		<-1.408, 13.351, -0.165> <-1.453, 13.376, -0.201> <-1.513, 13.407, -0.250> <-1.558, 13.432, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.408, 13.351, -0.165> <-1.453, 13.376, -0.201> <-1.513, 13.407, -0.250> <-1.558, 13.432, -0.285> 
		<-1.390, 13.359, -0.185> <-1.434, 13.383, -0.221> <-1.500, 13.412, -0.262> <-1.545, 13.437, -0.297> 
		<-1.369, 13.363, -0.215> <-1.421, 13.386, -0.245> <-1.489, 13.404, -0.286> <-1.539, 13.429, -0.317> 
		<-1.372, 13.338, -0.228> <-1.423, 13.361, -0.258> <-1.494, 13.390, -0.297> <-1.544, 13.415, -0.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.579, 13.382, -0.325> <-1.566, 13.387, -0.338> <-1.550, 13.402, -0.339> <-1.544, 13.415, -0.328> 
		<-1.613, 13.407, -0.349> <-1.600, 13.411, -0.362> <-1.590, 13.422, -0.364> <-1.585, 13.436, -0.353> 
		<-1.660, 13.442, -0.379> <-1.650, 13.445, -0.389> <-1.635, 13.462, -0.391> <-1.634, 13.475, -0.384> 
		<-1.693, 13.461, -0.408> <-1.684, 13.465, -0.418> <-1.674, 13.478, -0.421> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.579, 13.382, -0.325> <-1.613, 13.407, -0.349> <-1.660, 13.442, -0.379> <-1.693, 13.461, -0.408> 
		<-1.592, 13.377, -0.313> <-1.626, 13.402, -0.337> <-1.669, 13.438, -0.369> <-1.703, 13.457, -0.399> 
		<-1.598, 13.385, -0.293> <-1.631, 13.408, -0.324> <-1.677, 13.447, -0.350> <-1.709, 13.464, -0.385> 
		<-1.592, 13.399, -0.282> <-1.625, 13.421, -0.313> <-1.675, 13.459, -0.344> <-1.707, 13.477, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.592, 13.399, -0.282> <-1.625, 13.421, -0.313> <-1.675, 13.459, -0.344> <-1.707, 13.477, -0.379> 
		<-1.586, 13.412, -0.271> <-1.620, 13.435, -0.302> <-1.673, 13.472, -0.337> <-1.706, 13.489, -0.372> 
		<-1.571, 13.428, -0.273> <-1.609, 13.449, -0.303> <-1.659, 13.489, -0.339> <-1.696, 13.503, -0.375> 
		<-1.558, 13.432, -0.285> <-1.596, 13.454, -0.315> <-1.649, 13.493, -0.349> <-1.687, 13.507, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.558, 13.432, -0.285> <-1.596, 13.454, -0.315> <-1.649, 13.493, -0.349> <-1.687, 13.507, -0.385> 
		<-1.545, 13.437, -0.297> <-1.583, 13.458, -0.328> <-1.639, 13.496, -0.359> <-1.677, 13.510, -0.394> 
		<-1.539, 13.429, -0.317> <-1.579, 13.450, -0.342> <-1.632, 13.487, -0.378> <-1.671, 13.503, -0.408> 
		<-1.544, 13.415, -0.328> <-1.585, 13.436, -0.353> <-1.634, 13.475, -0.384> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.816, 13.522, -0.527> <-1.747, 13.492, -0.455> <-1.693, 13.461, -0.408> 
		<-1.814, 13.536, -0.520> <-1.761, 13.510, -0.469> <-1.737, 13.496, -0.465> <-1.684, 13.465, -0.418> 
		<-1.743, 13.528, -0.438> <-1.734, 13.532, -0.448> <-1.672, 13.491, -0.414> <-1.674, 13.478, -0.421> 
		<-1.687, 13.507, -0.385> <-1.677, 13.510, -0.394> <-1.671, 13.503, -0.408> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.810, 13.531, -0.529> <-1.757, 13.505, -0.478> <-1.757, 13.505, -0.478> <-1.816, 13.522, -0.527> 
		<-1.732, 13.515, -0.460> <-1.733, 13.502, -0.467> <-1.737, 13.496, -0.465> <-1.747, 13.492, -0.455> 
		<-1.672, 13.491, -0.414> <-1.674, 13.478, -0.421> <-1.684, 13.465, -0.418> <-1.693, 13.461, -0.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.814, 13.536, -0.520> <-1.743, 13.528, -0.438> <-1.687, 13.507, -0.385> 
		<-1.816, 13.522, -0.527> <-1.761, 13.510, -0.469> <-1.753, 13.524, -0.428> <-1.696, 13.503, -0.375> 
		<-1.747, 13.492, -0.455> <-1.757, 13.488, -0.446> <-1.707, 13.477, -0.379> <-1.706, 13.489, -0.372> 
		<-1.693, 13.461, -0.408> <-1.703, 13.457, -0.399> <-1.709, 13.464, -0.385> <-1.707, 13.477, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.816, 13.522, -0.527> <-1.768, 13.501, -0.467> <-1.768, 13.501, -0.467> <-1.820, 13.527, -0.519> 
		<-1.747, 13.492, -0.455> <-1.757, 13.488, -0.446> <-1.760, 13.492, -0.440> <-1.759, 13.505, -0.433> 
		<-1.693, 13.461, -0.408> <-1.703, 13.457, -0.399> <-1.709, 13.464, -0.385> <-1.707, 13.477, -0.379> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.810, 13.531, -0.529> <-1.732, 13.515, -0.460> <-1.672, 13.491, -0.414> 
		<-1.820, 13.527, -0.519> <-1.761, 13.510, -0.469> <-1.730, 13.527, -0.454> <-1.671, 13.503, -0.408> 
		<-1.759, 13.505, -0.433> <-1.757, 13.517, -0.427> <-1.687, 13.507, -0.385> <-1.677, 13.510, -0.394> 
		<-1.707, 13.477, -0.379> <-1.706, 13.489, -0.372> <-1.696, 13.503, -0.375> <-1.687, 13.507, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.814, 13.536, -0.520> <-1.755, 13.519, -0.471> <-1.755, 13.519, -0.471> <-1.810, 13.531, -0.529> 
		<-1.743, 13.528, -0.438> <-1.734, 13.532, -0.448> <-1.730, 13.527, -0.454> <-1.732, 13.515, -0.460> 
		<-1.687, 13.507, -0.385> <-1.677, 13.510, -0.394> <-1.671, 13.503, -0.408> <-1.672, 13.491, -0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.810, 13.531, -0.529> <-1.732, 13.515, -0.460> <-1.672, 13.491, -0.414> 
		<-1.820, 13.527, -0.519> <-1.761, 13.510, -0.469> <-1.733, 13.502, -0.467> <-1.674, 13.478, -0.421> 
		<-1.759, 13.505, -0.433> <-1.760, 13.492, -0.440> <-1.693, 13.461, -0.408> <-1.684, 13.465, -0.418> 
		<-1.707, 13.477, -0.379> <-1.709, 13.464, -0.385> <-1.703, 13.457, -0.399> <-1.693, 13.461, -0.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> <-1.869, 13.548, -0.579> 
		<-1.820, 13.527, -0.519> <-1.766, 13.514, -0.460> <-1.766, 13.514, -0.460> <-1.814, 13.536, -0.520> 
		<-1.759, 13.505, -0.433> <-1.757, 13.517, -0.427> <-1.753, 13.524, -0.428> <-1.743, 13.528, -0.438> 
		<-1.707, 13.477, -0.379> <-1.706, 13.489, -0.372> <-1.696, 13.503, -0.375> <-1.687, 13.507, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.987, 13.646, -0.182> <-1.999, 13.704, -0.160> <-2.014, 13.780, -0.129> <-2.025, 13.838, -0.108> 
		<-1.977, 13.638, -0.153> <-1.989, 13.695, -0.131> <-2.017, 13.774, -0.115> <-2.028, 13.832, -0.094> 
		<-2.018, 13.643, -0.128> <-2.020, 13.694, -0.117> <-2.038, 13.774, -0.099> <-2.041, 13.824, -0.086> 
		<-2.049, 13.651, -0.128> <-2.051, 13.702, -0.117> <-2.052, 13.770, -0.103> <-2.055, 13.821, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.067, 13.667, -0.183> <-2.085, 13.669, -0.168> <-2.071, 13.657, -0.128> <-2.049, 13.651, -0.128> 
		<-2.070, 13.714, -0.165> <-2.087, 13.716, -0.150> <-2.073, 13.708, -0.117> <-2.051, 13.702, -0.117> 
		<-2.073, 13.777, -0.141> <-2.075, 13.772, -0.127> <-2.065, 13.767, -0.108> <-2.052, 13.770, -0.103> 
		<-2.076, 13.825, -0.123> <-2.079, 13.819, -0.109> <-2.069, 13.817, -0.095> <-2.055, 13.821, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.025, 13.838, -0.108> <-2.032, 13.874, -0.094> <-2.044, 13.924, -0.081> <-2.046, 13.960, -0.065> 
		<-2.028, 13.832, -0.094> <-2.034, 13.868, -0.080> <-2.046, 13.920, -0.070> <-2.048, 13.956, -0.055> 
		<-2.041, 13.824, -0.086> <-2.044, 13.865, -0.076> <-2.061, 13.914, -0.061> <-2.060, 13.953, -0.048> 
		<-2.055, 13.821, -0.090> <-2.058, 13.861, -0.080> <-2.072, 13.914, -0.064> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.025, 13.838, -0.108> <-2.022, 13.843, -0.121> <-2.032, 13.845, -0.136> <-2.046, 13.841, -0.140> 
		<-2.032, 13.874, -0.094> <-2.029, 13.880, -0.108> <-2.037, 13.883, -0.121> <-2.051, 13.879, -0.125> 
		<-2.044, 13.924, -0.081> <-2.042, 13.928, -0.091> <-2.052, 13.931, -0.106> <-2.063, 13.931, -0.108> 
		<-2.046, 13.960, -0.065> <-2.044, 13.964, -0.076> <-2.052, 13.968, -0.086> <-2.063, 13.968, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.046, 13.841, -0.140> <-2.059, 13.838, -0.144> <-2.073, 13.830, -0.137> <-2.076, 13.825, -0.123> 
		<-2.051, 13.879, -0.125> <-2.065, 13.876, -0.129> <-2.076, 13.871, -0.121> <-2.079, 13.865, -0.108> 
		<-2.063, 13.931, -0.108> <-2.075, 13.931, -0.110> <-2.089, 13.925, -0.102> <-2.092, 13.921, -0.091> 
		<-2.063, 13.968, -0.089> <-2.074, 13.968, -0.091> <-2.086, 13.965, -0.084> <-2.088, 13.961, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.076, 13.825, -0.123> <-2.079, 13.819, -0.109> <-2.069, 13.817, -0.095> <-2.055, 13.821, -0.090> 
		<-2.079, 13.865, -0.108> <-2.081, 13.860, -0.094> <-2.072, 13.858, -0.084> <-2.058, 13.861, -0.080> 
		<-2.092, 13.921, -0.091> <-2.094, 13.917, -0.081> <-2.084, 13.914, -0.066> <-2.072, 13.914, -0.064> 
		<-2.088, 13.961, -0.073> <-2.090, 13.957, -0.063> <-2.082, 13.953, -0.052> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.057, 14.093, -0.004> <-2.082, 14.020, -0.046> <-2.088, 13.961, -0.073> 
		<-2.044, 14.093, -0.001> <-2.058, 14.036, -0.031> <-2.084, 14.016, -0.036> <-2.090, 13.957, -0.063> 
		<-2.050, 14.018, -0.040> <-2.052, 14.014, -0.030> <-2.071, 13.953, -0.050> <-2.082, 13.953, -0.052> 
		<-2.046, 13.960, -0.065> <-2.048, 13.956, -0.055> <-2.060, 13.953, -0.048> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.052, 14.091, 0.003> <-2.053, 14.034, -0.024> <-2.053, 14.034, -0.024> <-2.044, 14.093, -0.001> 
		<-2.069, 14.013, -0.029> <-2.057, 14.013, -0.026> <-2.052, 14.014, -0.030> <-2.050, 14.018, -0.040> 
		<-2.071, 13.953, -0.050> <-2.060, 13.953, -0.048> <-2.048, 13.956, -0.055> <-2.046, 13.960, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.093, -0.001> <-2.050, 14.018, -0.040> <-2.046, 13.960, -0.065> 
		<-2.057, 14.093, -0.004> <-2.058, 14.036, -0.031> <-2.048, 14.022, -0.051> <-2.044, 13.964, -0.076> 
		<-2.082, 14.020, -0.046> <-2.080, 14.024, -0.057> <-2.063, 13.968, -0.089> <-2.052, 13.968, -0.086> 
		<-2.088, 13.961, -0.073> <-2.086, 13.965, -0.084> <-2.074, 13.968, -0.091> <-2.063, 13.968, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.049, 14.095, -0.009> <-2.050, 14.038, -0.036> <-2.050, 14.038, -0.036> <-2.044, 14.093, -0.001> 
		<-2.063, 14.025, -0.058> <-2.051, 14.025, -0.056> <-2.048, 14.022, -0.051> <-2.050, 14.018, -0.040> 
		<-2.063, 13.968, -0.089> <-2.052, 13.968, -0.086> <-2.044, 13.964, -0.076> <-2.046, 13.960, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.052, 14.091, 0.003> <-2.069, 14.013, -0.029> <-2.071, 13.953, -0.050> 
		<-2.049, 14.095, -0.009> <-2.058, 14.036, -0.031> <-2.080, 14.013, -0.031> <-2.082, 13.953, -0.052> 
		<-2.063, 14.025, -0.058> <-2.074, 14.025, -0.060> <-2.088, 13.961, -0.073> <-2.090, 13.957, -0.063> 
		<-2.063, 13.968, -0.089> <-2.074, 13.968, -0.091> <-2.086, 13.965, -0.084> <-2.088, 13.961, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.057, 14.093, -0.004> <-2.065, 14.034, -0.027> <-2.065, 14.034, -0.027> <-2.052, 14.091, 0.003> 
		<-2.082, 14.020, -0.046> <-2.084, 14.016, -0.036> <-2.080, 14.013, -0.031> <-2.069, 14.013, -0.029> 
		<-2.088, 13.961, -0.073> <-2.090, 13.957, -0.063> <-2.082, 13.953, -0.052> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.052, 14.091, 0.003> <-2.069, 14.013, -0.029> <-2.071, 13.953, -0.050> 
		<-2.049, 14.095, -0.009> <-2.058, 14.036, -0.031> <-2.057, 14.013, -0.026> <-2.060, 13.953, -0.048> 
		<-2.063, 14.025, -0.058> <-2.051, 14.025, -0.056> <-2.046, 13.960, -0.065> <-2.048, 13.956, -0.055> 
		<-2.063, 13.968, -0.089> <-2.052, 13.968, -0.086> <-2.044, 13.964, -0.076> <-2.046, 13.960, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.057, 14.093, -0.004> <-2.063, 14.039, -0.038> <-2.063, 14.039, -0.038> <-2.049, 14.095, -0.009> 
		<-2.082, 14.020, -0.046> <-2.080, 14.024, -0.057> <-2.074, 14.025, -0.060> <-2.063, 14.025, -0.058> 
		<-2.088, 13.961, -0.073> <-2.086, 13.965, -0.084> <-2.074, 13.968, -0.091> <-2.063, 13.968, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.985, 13.664, -0.165> <-1.997, 13.716, -0.148> <-2.014, 13.785, -0.125> <-2.025, 13.838, -0.108> 
		<-1.976, 13.656, -0.139> <-1.988, 13.708, -0.122> <-2.017, 13.780, -0.112> <-2.028, 13.832, -0.094> 
		<-2.020, 13.650, -0.122> <-2.022, 13.701, -0.111> <-2.038, 13.774, -0.099> <-2.041, 13.824, -0.086> 
		<-2.049, 13.651, -0.128> <-2.051, 13.702, -0.117> <-2.052, 13.770, -0.103> <-2.055, 13.821, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.067, 13.667, -0.183> <-2.087, 13.663, -0.171> <-2.071, 13.652, -0.133> <-2.049, 13.651, -0.128> 
		<-2.070, 13.714, -0.165> <-2.090, 13.711, -0.153> <-2.073, 13.703, -0.122> <-2.051, 13.702, -0.117> 
		<-2.073, 13.777, -0.141> <-2.075, 13.772, -0.127> <-2.065, 13.767, -0.108> <-2.052, 13.770, -0.103> 
		<-2.076, 13.825, -0.123> <-2.079, 13.819, -0.109> <-2.069, 13.817, -0.095> <-2.055, 13.821, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.025, 13.838, -0.108> <-2.032, 13.874, -0.095> <-2.044, 13.924, -0.081> <-2.046, 13.960, -0.065> 
		<-2.028, 13.832, -0.094> <-2.035, 13.869, -0.082> <-2.046, 13.920, -0.070> <-2.048, 13.956, -0.055> 
		<-2.041, 13.824, -0.086> <-2.044, 13.865, -0.076> <-2.061, 13.914, -0.061> <-2.060, 13.953, -0.048> 
		<-2.055, 13.821, -0.090> <-2.058, 13.861, -0.080> <-2.072, 13.914, -0.064> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.025, 13.838, -0.108> <-2.022, 13.843, -0.121> <-2.032, 13.845, -0.136> <-2.046, 13.841, -0.140> 
		<-2.032, 13.874, -0.095> <-2.030, 13.880, -0.109> <-2.037, 13.883, -0.121> <-2.051, 13.879, -0.125> 
		<-2.044, 13.924, -0.081> <-2.042, 13.928, -0.091> <-2.052, 13.931, -0.106> <-2.063, 13.931, -0.108> 
		<-2.046, 13.960, -0.065> <-2.044, 13.964, -0.076> <-2.052, 13.968, -0.086> <-2.063, 13.968, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.046, 13.841, -0.140> <-2.059, 13.838, -0.144> <-2.073, 13.830, -0.137> <-2.076, 13.825, -0.123> 
		<-2.051, 13.879, -0.125> <-2.065, 13.876, -0.129> <-2.076, 13.871, -0.121> <-2.079, 13.865, -0.108> 
		<-2.063, 13.931, -0.108> <-2.075, 13.931, -0.110> <-2.089, 13.925, -0.102> <-2.092, 13.921, -0.091> 
		<-2.063, 13.968, -0.089> <-2.074, 13.968, -0.091> <-2.086, 13.965, -0.084> <-2.088, 13.961, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.076, 13.825, -0.123> <-2.079, 13.819, -0.109> <-2.069, 13.817, -0.095> <-2.055, 13.821, -0.090> 
		<-2.079, 13.865, -0.108> <-2.081, 13.860, -0.094> <-2.072, 13.858, -0.084> <-2.058, 13.861, -0.080> 
		<-2.092, 13.921, -0.091> <-2.094, 13.917, -0.081> <-2.084, 13.914, -0.066> <-2.072, 13.914, -0.064> 
		<-2.088, 13.961, -0.073> <-2.090, 13.957, -0.063> <-2.082, 13.953, -0.052> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.057, 14.093, -0.004> <-2.082, 14.020, -0.046> <-2.088, 13.961, -0.073> 
		<-2.044, 14.093, -0.001> <-2.058, 14.036, -0.031> <-2.084, 14.016, -0.036> <-2.090, 13.957, -0.063> 
		<-2.050, 14.018, -0.040> <-2.052, 14.014, -0.030> <-2.071, 13.953, -0.050> <-2.082, 13.953, -0.052> 
		<-2.046, 13.960, -0.065> <-2.048, 13.956, -0.055> <-2.060, 13.953, -0.048> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.052, 14.091, 0.003> <-2.053, 14.034, -0.024> <-2.053, 14.034, -0.024> <-2.044, 14.093, -0.001> 
		<-2.069, 14.013, -0.029> <-2.057, 14.013, -0.026> <-2.052, 14.014, -0.030> <-2.050, 14.018, -0.040> 
		<-2.071, 13.953, -0.050> <-2.060, 13.953, -0.048> <-2.048, 13.956, -0.055> <-2.046, 13.960, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.093, -0.001> <-2.050, 14.018, -0.040> <-2.046, 13.960, -0.065> 
		<-2.057, 14.093, -0.004> <-2.058, 14.036, -0.031> <-2.048, 14.022, -0.051> <-2.044, 13.964, -0.076> 
		<-2.082, 14.020, -0.046> <-2.080, 14.024, -0.057> <-2.063, 13.968, -0.089> <-2.052, 13.968, -0.086> 
		<-2.088, 13.961, -0.073> <-2.086, 13.965, -0.084> <-2.074, 13.968, -0.091> <-2.063, 13.968, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.049, 14.095, -0.009> <-2.050, 14.038, -0.036> <-2.050, 14.038, -0.036> <-2.044, 14.093, -0.001> 
		<-2.063, 14.025, -0.058> <-2.051, 14.025, -0.056> <-2.048, 14.022, -0.051> <-2.050, 14.018, -0.040> 
		<-2.063, 13.968, -0.089> <-2.052, 13.968, -0.086> <-2.044, 13.964, -0.076> <-2.046, 13.960, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.052, 14.091, 0.003> <-2.069, 14.013, -0.029> <-2.071, 13.953, -0.050> 
		<-2.049, 14.095, -0.009> <-2.058, 14.036, -0.031> <-2.080, 14.013, -0.031> <-2.082, 13.953, -0.052> 
		<-2.063, 14.025, -0.058> <-2.074, 14.025, -0.060> <-2.088, 13.961, -0.073> <-2.090, 13.957, -0.063> 
		<-2.063, 13.968, -0.089> <-2.074, 13.968, -0.091> <-2.086, 13.965, -0.084> <-2.088, 13.961, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.057, 14.093, -0.004> <-2.065, 14.034, -0.027> <-2.065, 14.034, -0.027> <-2.052, 14.091, 0.003> 
		<-2.082, 14.020, -0.046> <-2.084, 14.016, -0.036> <-2.080, 14.013, -0.031> <-2.069, 14.013, -0.029> 
		<-2.088, 13.961, -0.073> <-2.090, 13.957, -0.063> <-2.082, 13.953, -0.052> <-2.071, 13.953, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.052, 14.091, 0.003> <-2.069, 14.013, -0.029> <-2.071, 13.953, -0.050> 
		<-2.049, 14.095, -0.009> <-2.058, 14.036, -0.031> <-2.057, 14.013, -0.026> <-2.060, 13.953, -0.048> 
		<-2.063, 14.025, -0.058> <-2.051, 14.025, -0.056> <-2.046, 13.960, -0.065> <-2.048, 13.956, -0.055> 
		<-2.063, 13.968, -0.089> <-2.052, 13.968, -0.086> <-2.044, 13.964, -0.076> <-2.046, 13.960, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> <-2.044, 14.150, 0.026> 
		<-2.057, 14.093, -0.004> <-2.063, 14.039, -0.038> <-2.063, 14.039, -0.038> <-2.049, 14.095, -0.009> 
		<-2.082, 14.020, -0.046> <-2.080, 14.024, -0.057> <-2.074, 14.025, -0.060> <-2.063, 14.025, -0.058> 
		<-2.088, 13.961, -0.073> <-2.086, 13.965, -0.084> <-2.074, 13.968, -0.091> <-2.063, 13.968, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.258, 13.982, -0.189> <-2.277, 13.986, -0.214> <-2.303, 13.992, -0.248> <-2.322, 13.997, -0.274> 
		<-2.263, 13.996, -0.183> <-2.282, 14.000, -0.209> <-2.308, 13.996, -0.244> <-2.326, 14.001, -0.270> 
		<-2.287, 13.991, -0.180> <-2.298, 13.995, -0.204> <-2.321, 13.995, -0.241> <-2.333, 13.999, -0.264> 
		<-2.299, 13.981, -0.181> <-2.310, 13.984, -0.205> <-2.324, 13.989, -0.238> <-2.336, 13.993, -0.261> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.290, 13.953, -0.192> <-2.301, 13.953, -0.189> <-2.308, 13.973, -0.182> <-2.299, 13.981, -0.181> 
		<-2.303, 13.959, -0.213> <-2.315, 13.959, -0.211> <-2.319, 13.976, -0.206> <-2.310, 13.984, -0.205> 
		<-2.320, 13.967, -0.242> <-2.325, 13.972, -0.238> <-2.327, 13.982, -0.235> <-2.324, 13.989, -0.238> 
		<-2.333, 13.973, -0.264> <-2.338, 13.977, -0.260> <-2.340, 13.986, -0.259> <-2.336, 13.993, -0.261> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.322, 13.997, -0.274> <-2.333, 13.999, -0.290> <-2.343, 14.009, -0.318> <-2.359, 14.005, -0.330> 
		<-2.326, 14.001, -0.270> <-2.338, 14.004, -0.286> <-2.347, 14.012, -0.315> <-2.363, 14.008, -0.326> 
		<-2.333, 13.999, -0.264> <-2.343, 14.002, -0.283> <-2.353, 14.011, -0.310> <-2.369, 14.007, -0.323> 
		<-2.336, 13.993, -0.261> <-2.346, 13.995, -0.280> <-2.357, 14.006, -0.309> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.322, 13.997, -0.274> <-2.317, 13.992, -0.278> <-2.315, 13.983, -0.280> <-2.319, 13.977, -0.277> 
		<-2.333, 13.999, -0.290> <-2.328, 13.995, -0.295> <-2.327, 13.987, -0.297> <-2.331, 13.981, -0.294> 
		<-2.343, 14.009, -0.318> <-2.339, 14.006, -0.321> <-2.338, 13.997, -0.323> <-2.341, 13.992, -0.322> 
		<-2.359, 14.005, -0.330> <-2.356, 14.002, -0.333> <-2.355, 13.995, -0.335> <-2.359, 13.990, -0.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.319, 13.977, -0.277> <-2.322, 13.971, -0.274> <-2.328, 13.969, -0.268> <-2.333, 13.973, -0.264> 
		<-2.331, 13.981, -0.294> <-2.334, 13.975, -0.291> <-2.340, 13.973, -0.287> <-2.345, 13.978, -0.283> 
		<-2.341, 13.992, -0.322> <-2.345, 13.988, -0.321> <-2.351, 13.986, -0.316> <-2.355, 13.989, -0.312> 
		<-2.359, 13.990, -0.334> <-2.362, 13.985, -0.333> <-2.368, 13.984, -0.330> <-2.372, 13.988, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.333, 13.973, -0.264> <-2.338, 13.977, -0.260> <-2.340, 13.986, -0.259> <-2.336, 13.993, -0.261> 
		<-2.345, 13.978, -0.283> <-2.350, 13.982, -0.279> <-2.349, 13.989, -0.278> <-2.346, 13.995, -0.280> 
		<-2.355, 13.989, -0.312> <-2.358, 13.993, -0.309> <-2.360, 14.001, -0.308> <-2.357, 14.006, -0.309> 
		<-2.372, 13.988, -0.327> <-2.376, 13.991, -0.323> <-2.376, 13.998, -0.322> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.467, 13.964, -0.381> <-2.409, 13.983, -0.356> <-2.372, 13.988, -0.327> 
		<-2.463, 13.969, -0.382> <-2.422, 13.979, -0.358> <-2.413, 13.987, -0.353> <-2.376, 13.991, -0.323> 
		<-2.401, 13.995, -0.359> <-2.405, 13.999, -0.356> <-2.373, 14.002, -0.322> <-2.376, 13.998, -0.322> 
		<-2.359, 14.005, -0.330> <-2.363, 14.008, -0.326> <-2.369, 14.007, -0.323> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> 
		<-2.467, 13.968, -0.380> <-2.423, 13.984, -0.357> <-2.423, 13.984, -0.357> <-2.463, 13.969, -0.382> 
		<-2.410, 13.994, -0.354> <-2.407, 13.999, -0.354> <-2.405, 13.999, -0.356> <-2.401, 13.995, -0.359> 
		<-2.373, 14.002, -0.322> <-2.369, 14.007, -0.323> <-2.363, 14.008, -0.326> <-2.359, 14.005, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.463, 13.969, -0.382> <-2.401, 13.995, -0.359> <-2.359, 14.005, -0.330> 
		<-2.467, 13.964, -0.381> <-2.422, 13.979, -0.358> <-2.398, 13.992, -0.362> <-2.356, 14.002, -0.333> 
		<-2.409, 13.983, -0.356> <-2.405, 13.980, -0.359> <-2.359, 13.990, -0.334> <-2.355, 13.995, -0.335> 
		<-2.372, 13.988, -0.327> <-2.368, 13.984, -0.330> <-2.362, 13.985, -0.333> <-2.359, 13.990, -0.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> 
		<-2.463, 13.965, -0.383> <-2.418, 13.980, -0.361> <-2.418, 13.980, -0.361> <-2.463, 13.969, -0.382> 
		<-2.400, 13.985, -0.362> <-2.397, 13.990, -0.363> <-2.398, 13.992, -0.362> <-2.401, 13.995, -0.359> 
		<-2.359, 13.990, -0.334> <-2.355, 13.995, -0.335> <-2.356, 14.002, -0.333> <-2.359, 14.005, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.467, 13.968, -0.380> <-2.410, 13.994, -0.354> <-2.373, 14.002, -0.322> 
		<-2.463, 13.965, -0.383> <-2.422, 13.979, -0.358> <-2.414, 13.989, -0.353> <-2.376, 13.998, -0.322> 
		<-2.400, 13.985, -0.362> <-2.404, 13.980, -0.361> <-2.372, 13.988, -0.327> <-2.376, 13.991, -0.323> 
		<-2.359, 13.990, -0.334> <-2.362, 13.985, -0.333> <-2.368, 13.984, -0.330> <-2.372, 13.988, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> 
		<-2.467, 13.964, -0.381> <-2.426, 13.978, -0.356> <-2.426, 13.978, -0.356> <-2.467, 13.968, -0.380> 
		<-2.409, 13.983, -0.356> <-2.413, 13.987, -0.353> <-2.414, 13.989, -0.353> <-2.410, 13.994, -0.354> 
		<-2.372, 13.988, -0.327> <-2.376, 13.991, -0.323> <-2.376, 13.998, -0.322> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.467, 13.968, -0.380> <-2.410, 13.994, -0.354> <-2.373, 14.002, -0.322> 
		<-2.463, 13.965, -0.383> <-2.422, 13.979, -0.358> <-2.407, 13.999, -0.354> <-2.369, 14.007, -0.323> 
		<-2.400, 13.985, -0.362> <-2.397, 13.990, -0.363> <-2.360, 14.005, -0.330> <-2.363, 14.008, -0.326> 
		<-2.359, 13.990, -0.334> <-2.355, 13.995, -0.335> <-2.356, 14.002, -0.333> <-2.359, 14.005, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> <-2.507, 13.954, -0.404> 
		<-2.467, 13.964, -0.381> <-2.422, 13.975, -0.360> <-2.422, 13.975, -0.360> <-2.463, 13.965, -0.383> 
		<-2.409, 13.983, -0.356> <-2.405, 13.980, -0.359> <-2.404, 13.980, -0.361> <-2.400, 13.985, -0.362> 
		<-2.372, 13.988, -0.327> <-2.368, 13.984, -0.330> <-2.362, 13.985, -0.333> <-2.359, 13.990, -0.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.265, 13.989, -0.196> <-2.282, 13.991, -0.220> <-2.305, 13.994, -0.251> <-2.322, 13.997, -0.274> 
		<-2.270, 14.002, -0.191> <-2.287, 14.004, -0.215> <-2.310, 13.998, -0.246> <-2.326, 14.001, -0.270> 
		<-2.291, 13.993, -0.182> <-2.302, 13.996, -0.207> <-2.321, 13.995, -0.241> <-2.333, 13.999, -0.264> 
		<-2.299, 13.981, -0.181> <-2.310, 13.984, -0.205> <-2.324, 13.989, -0.238> <-2.336, 13.993, -0.261> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.290, 13.953, -0.192> <-2.300, 13.951, -0.187> <-2.306, 13.971, -0.180> <-2.299, 13.981, -0.181> 
		<-2.303, 13.959, -0.213> <-2.313, 13.957, -0.209> <-2.317, 13.975, -0.204> <-2.310, 13.984, -0.205> 
		<-2.320, 13.967, -0.242> <-2.325, 13.972, -0.238> <-2.327, 13.982, -0.235> <-2.324, 13.989, -0.238> 
		<-2.333, 13.973, -0.264> <-2.338, 13.977, -0.260> <-2.340, 13.986, -0.259> <-2.336, 13.993, -0.261> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.322, 13.997, -0.274> <-2.333, 13.999, -0.291> <-2.349, 14.003, -0.312> <-2.359, 14.005, -0.330> 
		<-2.326, 14.001, -0.270> <-2.338, 14.003, -0.286> <-2.353, 14.006, -0.309> <-2.363, 14.008, -0.326> 
		<-2.333, 13.999, -0.264> <-2.343, 14.002, -0.283> <-2.360, 14.005, -0.304> <-2.369, 14.007, -0.323> 
		<-2.336, 13.993, -0.261> <-2.346, 13.995, -0.280> <-2.363, 14.000, -0.303> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.322, 13.997, -0.274> <-2.317, 13.992, -0.278> <-2.315, 13.983, -0.280> <-2.319, 13.977, -0.277> 
		<-2.333, 13.999, -0.291> <-2.328, 13.994, -0.295> <-2.327, 13.987, -0.297> <-2.331, 13.981, -0.294> 
		<-2.349, 14.003, -0.312> <-2.345, 14.000, -0.315> <-2.344, 13.992, -0.317> <-2.347, 13.987, -0.316> 
		<-2.359, 14.005, -0.330> <-2.356, 14.002, -0.333> <-2.355, 13.995, -0.335> <-2.359, 13.990, -0.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.319, 13.977, -0.277> <-2.322, 13.971, -0.274> <-2.328, 13.969, -0.268> <-2.333, 13.973, -0.264> 
		<-2.331, 13.981, -0.294> <-2.334, 13.975, -0.291> <-2.340, 13.973, -0.287> <-2.345, 13.978, -0.283> 
		<-2.347, 13.987, -0.316> <-2.351, 13.982, -0.315> <-2.358, 13.980, -0.310> <-2.362, 13.984, -0.307> 
		<-2.359, 13.990, -0.334> <-2.362, 13.985, -0.333> <-2.368, 13.984, -0.330> <-2.372, 13.988, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.333, 13.973, -0.264> <-2.338, 13.977, -0.260> <-2.340, 13.986, -0.259> <-2.336, 13.993, -0.261> 
		<-2.345, 13.978, -0.283> <-2.350, 13.982, -0.279> <-2.349, 13.989, -0.278> <-2.346, 13.995, -0.280> 
		<-2.362, 13.984, -0.307> <-2.365, 13.987, -0.304> <-2.366, 13.995, -0.303> <-2.363, 14.000, -0.303> 
		<-2.372, 13.988, -0.327> <-2.376, 13.991, -0.323> <-2.376, 13.998, -0.322> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.430, 14.010, -0.442> <-2.398, 13.998, -0.375> <-2.372, 13.988, -0.327> 
		<-2.427, 14.016, -0.443> <-2.402, 14.006, -0.394> <-2.402, 14.001, -0.372> <-2.376, 13.991, -0.323> 
		<-2.389, 14.010, -0.378> <-2.393, 14.014, -0.375> <-2.373, 14.002, -0.322> <-2.376, 13.998, -0.322> 
		<-2.359, 14.005, -0.330> <-2.363, 14.008, -0.326> <-2.369, 14.007, -0.323> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> 
		<-2.431, 14.015, -0.441> <-2.402, 14.010, -0.392> <-2.402, 14.010, -0.392> <-2.427, 14.016, -0.443> 
		<-2.399, 14.008, -0.373> <-2.395, 14.013, -0.373> <-2.393, 14.014, -0.375> <-2.389, 14.010, -0.378> 
		<-2.373, 14.002, -0.322> <-2.369, 14.007, -0.323> <-2.363, 14.008, -0.326> <-2.359, 14.005, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.427, 14.016, -0.443> <-2.389, 14.010, -0.378> <-2.359, 14.005, -0.330> 
		<-2.430, 14.010, -0.442> <-2.402, 14.006, -0.394> <-2.385, 14.007, -0.381> <-2.356, 14.002, -0.333> 
		<-2.398, 13.998, -0.375> <-2.394, 13.994, -0.379> <-2.359, 13.990, -0.334> <-2.355, 13.995, -0.335> 
		<-2.372, 13.988, -0.327> <-2.368, 13.984, -0.330> <-2.362, 13.985, -0.333> <-2.359, 13.990, -0.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> 
		<-2.426, 14.011, -0.444> <-2.398, 14.007, -0.396> <-2.398, 14.007, -0.396> <-2.427, 14.016, -0.443> 
		<-2.389, 14.000, -0.381> <-2.385, 14.004, -0.381> <-2.385, 14.007, -0.381> <-2.389, 14.010, -0.378> 
		<-2.359, 13.990, -0.334> <-2.355, 13.995, -0.335> <-2.356, 14.002, -0.333> <-2.359, 14.005, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.431, 14.015, -0.441> <-2.399, 14.008, -0.373> <-2.373, 14.002, -0.322> 
		<-2.426, 14.011, -0.444> <-2.402, 14.006, -0.394> <-2.402, 14.004, -0.372> <-2.376, 13.998, -0.322> 
		<-2.389, 14.000, -0.381> <-2.392, 13.995, -0.380> <-2.372, 13.988, -0.327> <-2.376, 13.991, -0.323> 
		<-2.359, 13.990, -0.334> <-2.362, 13.985, -0.333> <-2.368, 13.984, -0.330> <-2.372, 13.988, -0.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> 
		<-2.430, 14.010, -0.442> <-2.406, 14.005, -0.391> <-2.406, 14.005, -0.391> <-2.431, 14.015, -0.441> 
		<-2.398, 13.998, -0.375> <-2.402, 14.001, -0.372> <-2.402, 14.004, -0.372> <-2.399, 14.008, -0.373> 
		<-2.372, 13.988, -0.327> <-2.376, 13.991, -0.323> <-2.376, 13.998, -0.322> <-2.373, 14.002, -0.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.431, 14.015, -0.441> <-2.399, 14.008, -0.373> <-2.373, 14.002, -0.322> 
		<-2.426, 14.011, -0.444> <-2.402, 14.006, -0.394> <-2.395, 14.013, -0.373> <-2.369, 14.007, -0.323> 
		<-2.389, 14.000, -0.381> <-2.385, 14.004, -0.381> <-2.360, 14.005, -0.330> <-2.363, 14.008, -0.326> 
		<-2.359, 13.990, -0.334> <-2.355, 13.995, -0.335> <-2.356, 14.002, -0.333> <-2.359, 14.005, -0.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> <-2.456, 14.020, -0.492> 
		<-2.430, 14.010, -0.442> <-2.401, 14.001, -0.395> <-2.401, 14.001, -0.395> <-2.426, 14.011, -0.444> 
		<-2.398, 13.998, -0.375> <-2.394, 13.994, -0.379> <-2.392, 13.995, -0.380> <-2.389, 14.000, -0.381> 
		<-2.372, 13.988, -0.327> <-2.368, 13.984, -0.330> <-2.362, 13.985, -0.333> <-2.359, 13.990, -0.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 13.211, -0.240> <0.498, 13.229, -0.260> <0.448, 13.249, -0.280> <0.448, 13.271, -0.305> 
		<0.510, 13.288, -0.183> <0.489, 13.306, -0.202> <0.445, 13.285, -0.253> <0.444, 13.307, -0.279> 
		<0.376, 13.271, -0.193> <0.402, 13.295, -0.223> <0.380, 13.319, -0.246> <0.405, 13.344, -0.276> 
		<0.280, 13.269, -0.195> <0.305, 13.293, -0.224> <0.339, 13.326, -0.264> <0.365, 13.351, -0.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 13.211, -0.240> <0.519, 13.211, -0.240> <0.519, 13.211, -0.240> <0.519, 13.211, -0.240> 
		<0.526, 13.137, -0.295> <0.518, 13.214, -0.238> <0.518, 13.214, -0.238> <0.510, 13.288, -0.183> 
		<0.385, 13.148, -0.285> <0.381, 13.185, -0.257> <0.380, 13.234, -0.221> <0.376, 13.271, -0.193> 
		<0.293, 13.146, -0.286> <0.289, 13.183, -0.259> <0.284, 13.232, -0.222> <0.280, 13.269, -0.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 13.211, -0.240> <0.526, 13.137, -0.295> <0.385, 13.148, -0.285> <0.293, 13.146, -0.286> 
		<0.498, 13.229, -0.260> <0.505, 13.155, -0.315> <0.411, 13.172, -0.314> <0.318, 13.170, -0.316> 
		<0.448, 13.249, -0.280> <0.452, 13.214, -0.306> <0.392, 13.196, -0.338> <0.352, 13.203, -0.355> 
		<0.448, 13.271, -0.305> <0.452, 13.236, -0.332> <0.418, 13.221, -0.368> <0.378, 13.228, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 13.203, -0.247> <0.161, 13.203, -0.247> <0.161, 13.203, -0.247> <0.161, 13.203, -0.247> 
		<0.156, 13.248, -0.213> <0.161, 13.202, -0.248> <0.161, 13.202, -0.248> <0.166, 13.157, -0.281> 
		<0.224, 13.267, -0.196> <0.228, 13.231, -0.223> <0.231, 13.181, -0.260> <0.235, 13.144, -0.287> 
		<0.280, 13.269, -0.195> <0.284, 13.232, -0.222> <0.289, 13.183, -0.259> <0.293, 13.146, -0.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 13.203, -0.247> <0.211, 13.230, -0.280> <0.291, 13.258, -0.316> <0.329, 13.293, -0.357> 
		<0.166, 13.157, -0.281> <0.216, 13.184, -0.314> <0.294, 13.231, -0.335> <0.332, 13.266, -0.376> 
		<0.235, 13.144, -0.287> <0.261, 13.169, -0.317> <0.322, 13.209, -0.368> <0.348, 13.233, -0.398> 
		<0.293, 13.146, -0.286> <0.318, 13.170, -0.316> <0.352, 13.203, -0.355> <0.378, 13.228, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 13.203, -0.247> <0.156, 13.248, -0.213> <0.224, 13.267, -0.196> <0.280, 13.269, -0.195> 
		<0.211, 13.230, -0.280> <0.206, 13.275, -0.246> <0.249, 13.292, -0.225> <0.305, 13.293, -0.224> 
		<0.291, 13.258, -0.316> <0.288, 13.286, -0.294> <0.307, 13.332, -0.278> <0.339, 13.326, -0.264> 
		<0.329, 13.293, -0.357> <0.326, 13.321, -0.335> <0.332, 13.357, -0.308> <0.365, 13.351, -0.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.448, 13.271, -0.305> <0.448, 13.271, -0.305> <0.448, 13.271, -0.305> <0.448, 13.271, -0.305> 
		<0.444, 13.307, -0.279> <0.448, 13.272, -0.305> <0.448, 13.272, -0.305> <0.452, 13.236, -0.332> 
		<0.405, 13.344, -0.276> <0.409, 13.307, -0.303> <0.414, 13.258, -0.340> <0.418, 13.221, -0.368> 
		<0.365, 13.351, -0.293> <0.368, 13.314, -0.321> <0.374, 13.265, -0.357> <0.378, 13.228, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.448, 13.271, -0.305> <0.448, 13.328, -0.372> <0.502, 13.396, -0.458> <0.517, 13.452, -0.524> 
		<0.444, 13.307, -0.279> <0.444, 13.364, -0.345> <0.499, 13.414, -0.443> <0.514, 13.470, -0.509> 
		<0.405, 13.344, -0.276> <0.437, 13.384, -0.339> <0.470, 13.439, -0.437> <0.493, 13.485, -0.500> 
		<0.365, 13.351, -0.293> <0.396, 13.391, -0.356> <0.447, 13.439, -0.440> <0.470, 13.485, -0.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.448, 13.271, -0.305> <0.452, 13.236, -0.332> <0.418, 13.221, -0.368> <0.378, 13.228, -0.385> 
		<0.448, 13.328, -0.372> <0.452, 13.292, -0.398> <0.448, 13.278, -0.419> <0.408, 13.286, -0.437> 
		<0.502, 13.396, -0.458> <0.504, 13.378, -0.473> <0.480, 13.362, -0.498> <0.457, 13.362, -0.502> 
		<0.517, 13.452, -0.524> <0.519, 13.434, -0.539> <0.502, 13.420, -0.554> <0.479, 13.420, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.378, 13.228, -0.385> <0.378, 13.228, -0.385> <0.378, 13.228, -0.385> <0.378, 13.228, -0.385> 
		<0.374, 13.265, -0.357> <0.344, 13.270, -0.370> <0.344, 13.270, -0.370> <0.348, 13.233, -0.398> 
		<0.368, 13.314, -0.321> <0.336, 13.320, -0.335> <0.329, 13.295, -0.355> <0.332, 13.266, -0.376> 
		<0.365, 13.351, -0.293> <0.332, 13.357, -0.308> <0.326, 13.321, -0.335> <0.329, 13.293, -0.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.378, 13.228, -0.385> <0.348, 13.233, -0.398> <0.332, 13.266, -0.376> <0.329, 13.293, -0.357> 
		<0.408, 13.286, -0.437> <0.378, 13.291, -0.450> <0.378, 13.308, -0.425> <0.375, 13.334, -0.406> 
		<0.457, 13.362, -0.502> <0.434, 13.362, -0.506> <0.411, 13.384, -0.497> <0.408, 13.402, -0.482> 
		<0.479, 13.420, -0.558> <0.456, 13.420, -0.562> <0.435, 13.434, -0.553> <0.433, 13.452, -0.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.329, 13.293, -0.357> <0.326, 13.321, -0.335> <0.332, 13.357, -0.308> <0.365, 13.351, -0.293> 
		<0.375, 13.334, -0.406> <0.372, 13.363, -0.384> <0.364, 13.397, -0.370> <0.396, 13.391, -0.356> 
		<0.408, 13.402, -0.482> <0.406, 13.420, -0.467> <0.424, 13.439, -0.444> <0.447, 13.439, -0.440> 
		<0.433, 13.452, -0.538> <0.430, 13.470, -0.523> <0.447, 13.485, -0.507> <0.470, 13.485, -0.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 13.452, -0.524> <0.529, 13.499, -0.578> <0.524, 13.568, -0.651> <0.540, 13.615, -0.704> 
		<0.514, 13.470, -0.509> <0.527, 13.517, -0.563> <0.522, 13.581, -0.638> <0.538, 13.628, -0.692> 
		<0.493, 13.485, -0.500> <0.513, 13.523, -0.553> <0.502, 13.595, -0.627> <0.522, 13.635, -0.679> 
		<0.470, 13.485, -0.503> <0.490, 13.523, -0.557> <0.485, 13.590, -0.625> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 13.452, -0.524> <0.519, 13.434, -0.539> <0.502, 13.420, -0.554> <0.479, 13.420, -0.558> 
		<0.529, 13.499, -0.578> <0.532, 13.482, -0.593> <0.521, 13.468, -0.601> <0.498, 13.468, -0.605> 
		<0.524, 13.568, -0.651> <0.525, 13.554, -0.664> <0.511, 13.536, -0.681> <0.492, 13.531, -0.678> 
		<0.540, 13.615, -0.704> <0.542, 13.601, -0.718> <0.530, 13.584, -0.728> <0.512, 13.579, -0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.479, 13.420, -0.558> <0.456, 13.420, -0.562> <0.435, 13.434, -0.553> <0.433, 13.452, -0.538> 
		<0.498, 13.468, -0.605> <0.475, 13.468, -0.609> <0.455, 13.476, -0.599> <0.453, 13.494, -0.584> 
		<0.492, 13.531, -0.678> <0.474, 13.525, -0.675> <0.456, 13.542, -0.662> <0.454, 13.556, -0.649> 
		<0.512, 13.579, -0.725> <0.494, 13.574, -0.722> <0.479, 13.583, -0.707> <0.478, 13.597, -0.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.433, 13.452, -0.538> <0.430, 13.470, -0.523> <0.447, 13.485, -0.507> <0.470, 13.485, -0.503> 
		<0.453, 13.494, -0.584> <0.450, 13.511, -0.569> <0.467, 13.523, -0.560> <0.490, 13.523, -0.557> 
		<0.454, 13.556, -0.649> <0.453, 13.569, -0.637> <0.468, 13.585, -0.622> <0.485, 13.590, -0.625> 
		<0.478, 13.597, -0.694> <0.476, 13.610, -0.682> <0.488, 13.625, -0.674> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.596, 13.760, -0.875> <0.519, 13.670, -0.774> <0.478, 13.597, -0.694> 
		<0.614, 13.765, -0.878> <0.564, 13.695, -0.800> <0.517, 13.683, -0.762> <0.476, 13.610, -0.682> 
		<0.563, 13.682, -0.780> <0.561, 13.695, -0.768> <0.505, 13.630, -0.677> <0.488, 13.625, -0.674> 
		<0.540, 13.615, -0.704> <0.538, 13.628, -0.692> <0.522, 13.635, -0.679> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.604, 13.770, -0.870> <0.572, 13.705, -0.795> <0.572, 13.705, -0.795> <0.614, 13.765, -0.878> 
		<0.538, 13.694, -0.760> <0.555, 13.699, -0.763> <0.561, 13.695, -0.768> <0.563, 13.682, -0.780> 
		<0.505, 13.630, -0.677> <0.522, 13.635, -0.679> <0.538, 13.628, -0.692> <0.540, 13.615, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.614, 13.765, -0.878> <0.563, 13.682, -0.780> <0.540, 13.615, -0.704> 
		<0.596, 13.760, -0.875> <0.564, 13.695, -0.800> <0.565, 13.668, -0.793> <0.542, 13.601, -0.718> 
		<0.519, 13.670, -0.774> <0.521, 13.656, -0.787> <0.512, 13.579, -0.725> <0.530, 13.584, -0.728> 
		<0.478, 13.597, -0.694> <0.479, 13.583, -0.707> <0.494, 13.574, -0.722> <0.512, 13.579, -0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.606, 13.754, -0.884> <0.574, 13.690, -0.810> <0.574, 13.690, -0.810> <0.614, 13.765, -0.878> 
		<0.543, 13.655, -0.797> <0.561, 13.660, -0.800> <0.565, 13.668, -0.793> <0.563, 13.682, -0.780> 
		<0.512, 13.579, -0.725> <0.530, 13.584, -0.728> <0.542, 13.601, -0.718> <0.540, 13.615, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.604, 13.770, -0.870> <0.538, 13.694, -0.760> <0.505, 13.630, -0.677> 
		<0.606, 13.754, -0.884> <0.564, 13.694, -0.801> <0.521, 13.689, -0.758> <0.488, 13.625, -0.674> 
		<0.543, 13.655, -0.797> <0.525, 13.649, -0.794> <0.478, 13.596, -0.695> <0.476, 13.610, -0.682> 
		<0.512, 13.579, -0.725> <0.494, 13.574, -0.722> <0.479, 13.583, -0.707> <0.478, 13.597, -0.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.596, 13.760, -0.875> <0.553, 13.700, -0.792> <0.553, 13.700, -0.792> <0.604, 13.770, -0.870> 
		<0.519, 13.670, -0.774> <0.517, 13.683, -0.762> <0.521, 13.689, -0.758> <0.538, 13.694, -0.760> 
		<0.478, 13.597, -0.694> <0.476, 13.610, -0.682> <0.488, 13.625, -0.674> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.604, 13.770, -0.870> <0.538, 13.694, -0.760> <0.505, 13.630, -0.677> 
		<0.606, 13.754, -0.884> <0.564, 13.694, -0.801> <0.555, 13.699, -0.763> <0.522, 13.635, -0.679> 
		<0.543, 13.655, -0.797> <0.561, 13.660, -0.800> <0.540, 13.614, -0.705> <0.538, 13.628, -0.692> 
		<0.512, 13.579, -0.725> <0.530, 13.584, -0.728> <0.542, 13.601, -0.718> <0.540, 13.615, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.596, 13.760, -0.875> <0.555, 13.685, -0.807> <0.555, 13.685, -0.807> <0.606, 13.754, -0.884> 
		<0.519, 13.670, -0.774> <0.521, 13.656, -0.787> <0.525, 13.649, -0.794> <0.543, 13.655, -0.797> 
		<0.478, 13.597, -0.694> <0.479, 13.583, -0.707> <0.494, 13.574, -0.722> <0.512, 13.579, -0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.474, 13.429, -0.492> <0.474, 13.429, -0.492> <0.474, 13.429, -0.492> <0.474, 13.429, -0.492> 
		<0.475, 13.450, -0.478> <0.474, 13.429, -0.492> <0.474, 13.429, -0.492> <0.473, 13.407, -0.506> 
		<0.473, 13.480, -0.487> <0.472, 13.458, -0.502> <0.471, 13.428, -0.521> <0.470, 13.406, -0.536> 
		<0.469, 13.493, -0.509> <0.468, 13.471, -0.523> <0.467, 13.441, -0.543> <0.466, 13.419, -0.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.474, 13.429, -0.492> <0.475, 13.450, -0.478> <0.473, 13.480, -0.487> <0.469, 13.493, -0.509> 
		<0.522, 13.438, -0.507> <0.522, 13.460, -0.492> <0.519, 13.479, -0.498> <0.515, 13.493, -0.520> 
		<0.586, 13.447, -0.526> <0.585, 13.458, -0.519> <0.582, 13.480, -0.523> <0.576, 13.487, -0.534> 
		<0.632, 13.460, -0.540> <0.632, 13.471, -0.532> <0.627, 13.486, -0.535> <0.621, 13.492, -0.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.474, 13.429, -0.492> <0.522, 13.438, -0.507> <0.586, 13.447, -0.526> <0.632, 13.460, -0.540> 
		<0.473, 13.407, -0.506> <0.521, 13.416, -0.520> <0.586, 13.436, -0.534> <0.633, 13.448, -0.547> 
		<0.470, 13.406, -0.536> <0.517, 13.415, -0.540> <0.582, 13.432, -0.556> <0.628, 13.445, -0.562> 
		<0.466, 13.419, -0.557> <0.513, 13.429, -0.562> <0.577, 13.439, -0.566> <0.622, 13.451, -0.572> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.466, 13.419, -0.557> <0.466, 13.419, -0.557> <0.466, 13.419, -0.557> <0.466, 13.419, -0.557> 
		<0.467, 13.441, -0.543> <0.464, 13.451, -0.559> <0.464, 13.451, -0.559> <0.463, 13.429, -0.573> 
		<0.468, 13.471, -0.523> <0.465, 13.482, -0.541> <0.462, 13.469, -0.555> <0.461, 13.452, -0.566> 
		<0.469, 13.493, -0.509> <0.466, 13.504, -0.526> <0.462, 13.485, -0.545> <0.462, 13.468, -0.556> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.466, 13.419, -0.557> <0.513, 13.429, -0.562> <0.577, 13.439, -0.566> <0.622, 13.451, -0.572> 
		<0.463, 13.429, -0.573> <0.510, 13.439, -0.578> <0.571, 13.445, -0.576> <0.616, 13.458, -0.582> 
		<0.461, 13.452, -0.566> <0.506, 13.457, -0.573> <0.567, 13.464, -0.577> <0.611, 13.473, -0.584> 
		<0.462, 13.468, -0.556> <0.507, 13.473, -0.562> <0.567, 13.475, -0.570> <0.611, 13.484, -0.577> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.462, 13.468, -0.556> <0.507, 13.473, -0.562> <0.567, 13.475, -0.570> <0.611, 13.484, -0.577> 
		<0.462, 13.485, -0.545> <0.507, 13.490, -0.551> <0.566, 13.487, -0.562> <0.610, 13.495, -0.569> 
		<0.466, 13.504, -0.526> <0.511, 13.504, -0.537> <0.570, 13.493, -0.544> <0.615, 13.499, -0.555> 
		<0.469, 13.493, -0.509> <0.515, 13.493, -0.520> <0.576, 13.487, -0.534> <0.621, 13.492, -0.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.632, 13.460, -0.540> <0.632, 13.471, -0.532> <0.627, 13.486, -0.535> <0.621, 13.492, -0.545> 
		<0.663, 13.468, -0.549> <0.663, 13.479, -0.541> <0.661, 13.489, -0.543> <0.655, 13.496, -0.553> 
		<0.705, 13.480, -0.564> <0.705, 13.489, -0.558> <0.700, 13.503, -0.561> <0.698, 13.509, -0.570> 
		<0.733, 13.498, -0.568> <0.733, 13.506, -0.562> <0.731, 13.518, -0.565> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.632, 13.460, -0.540> <0.663, 13.468, -0.549> <0.705, 13.480, -0.564> <0.733, 13.498, -0.568> 
		<0.633, 13.448, -0.547> <0.664, 13.457, -0.556> <0.705, 13.471, -0.570> <0.733, 13.489, -0.574> 
		<0.628, 13.445, -0.562> <0.662, 13.454, -0.567> <0.702, 13.467, -0.585> <0.731, 13.486, -0.586> 
		<0.622, 13.451, -0.572> <0.656, 13.460, -0.577> <0.700, 13.473, -0.594> <0.729, 13.492, -0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.622, 13.451, -0.572> <0.656, 13.460, -0.577> <0.700, 13.473, -0.594> <0.729, 13.492, -0.594> 
		<0.616, 13.458, -0.582> <0.650, 13.467, -0.587> <0.698, 13.479, -0.602> <0.727, 13.497, -0.603> 
		<0.611, 13.473, -0.584> <0.647, 13.479, -0.590> <0.693, 13.493, -0.605> <0.726, 13.509, -0.605> 
		<0.611, 13.484, -0.577> <0.646, 13.490, -0.583> <0.693, 13.502, -0.600> <0.726, 13.518, -0.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.611, 13.484, -0.577> <0.646, 13.490, -0.583> <0.693, 13.502, -0.600> <0.726, 13.518, -0.599> 
		<0.610, 13.495, -0.569> <0.646, 13.502, -0.575> <0.693, 13.511, -0.594> <0.726, 13.527, -0.594> 
		<0.615, 13.499, -0.555> <0.649, 13.503, -0.563> <0.696, 13.514, -0.578> <0.728, 13.529, -0.582> 
		<0.621, 13.492, -0.545> <0.655, 13.496, -0.553> <0.698, 13.509, -0.570> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.828, 13.576, -0.573> <0.777, 13.526, -0.575> <0.733, 13.498, -0.568> 
		<0.826, 13.582, -0.582> <0.785, 13.548, -0.580> <0.777, 13.534, -0.569> <0.733, 13.506, -0.562> 
		<0.772, 13.541, -0.599> <0.772, 13.549, -0.593> <0.729, 13.524, -0.573> <0.731, 13.518, -0.565> 
		<0.726, 13.518, -0.599> <0.726, 13.527, -0.594> <0.728, 13.529, -0.582> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.827, 13.584, -0.575> <0.786, 13.550, -0.573> <0.786, 13.550, -0.573> <0.828, 13.576, -0.573> 
		<0.774, 13.545, -0.579> <0.776, 13.539, -0.570> <0.777, 13.534, -0.569> <0.777, 13.526, -0.575> 
		<0.729, 13.524, -0.573> <0.731, 13.518, -0.565> <0.733, 13.506, -0.562> <0.733, 13.498, -0.568> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.826, 13.582, -0.582> <0.772, 13.541, -0.599> <0.726, 13.518, -0.599> 
		<0.828, 13.576, -0.573> <0.785, 13.548, -0.580> <0.772, 13.532, -0.605> <0.726, 13.509, -0.605> 
		<0.777, 13.526, -0.575> <0.777, 13.517, -0.580> <0.729, 13.492, -0.594> <0.727, 13.497, -0.603> 
		<0.733, 13.498, -0.568> <0.733, 13.489, -0.574> <0.731, 13.486, -0.586> <0.729, 13.492, -0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.828, 13.576, -0.573> <0.786, 13.541, -0.579> <0.786, 13.541, -0.579> <0.827, 13.574, -0.581> 
		<0.777, 13.526, -0.575> <0.777, 13.517, -0.580> <0.778, 13.516, -0.586> <0.776, 13.522, -0.595> 
		<0.733, 13.498, -0.568> <0.733, 13.489, -0.574> <0.731, 13.486, -0.586> <0.729, 13.492, -0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.827, 13.584, -0.575> <0.774, 13.545, -0.579> <0.729, 13.524, -0.573> 
		<0.827, 13.574, -0.581> <0.785, 13.548, -0.580> <0.772, 13.550, -0.587> <0.728, 13.529, -0.582> 
		<0.776, 13.522, -0.595> <0.774, 13.527, -0.603> <0.726, 13.518, -0.599> <0.726, 13.527, -0.594> 
		<0.729, 13.492, -0.594> <0.727, 13.497, -0.603> <0.726, 13.509, -0.605> <0.726, 13.518, -0.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.826, 13.582, -0.582> <0.784, 13.556, -0.582> <0.784, 13.556, -0.582> <0.827, 13.584, -0.575> 
		<0.772, 13.541, -0.599> <0.772, 13.549, -0.593> <0.772, 13.550, -0.587> <0.774, 13.545, -0.579> 
		<0.726, 13.518, -0.599> <0.726, 13.527, -0.594> <0.728, 13.529, -0.582> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.827, 13.584, -0.575> <0.774, 13.545, -0.579> <0.729, 13.524, -0.573> 
		<0.827, 13.574, -0.581> <0.785, 13.548, -0.580> <0.776, 13.539, -0.570> <0.731, 13.518, -0.565> 
		<0.776, 13.522, -0.595> <0.778, 13.516, -0.586> <0.733, 13.498, -0.568> <0.733, 13.506, -0.562> 
		<0.729, 13.492, -0.594> <0.731, 13.486, -0.586> <0.733, 13.489, -0.574> <0.733, 13.498, -0.568> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.827, 13.574, -0.581> <0.784, 13.547, -0.588> <0.784, 13.547, -0.588> <0.826, 13.582, -0.582> 
		<0.776, 13.522, -0.595> <0.774, 13.527, -0.603> <0.772, 13.532, -0.605> <0.772, 13.541, -0.599> 
		<0.729, 13.492, -0.594> <0.727, 13.497, -0.603> <0.726, 13.509, -0.605> <0.726, 13.518, -0.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 13.211, -0.240> <0.498, 13.229, -0.260> <0.448, 13.249, -0.280> <0.448, 13.271, -0.305> 
		<0.510, 13.288, -0.183> <0.489, 13.306, -0.202> <0.445, 13.285, -0.253> <0.444, 13.307, -0.279> 
		<0.376, 13.271, -0.193> <0.402, 13.295, -0.223> <0.380, 13.319, -0.246> <0.405, 13.344, -0.276> 
		<0.280, 13.269, -0.195> <0.305, 13.293, -0.224> <0.339, 13.326, -0.264> <0.365, 13.351, -0.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 13.211, -0.240> <0.519, 13.211, -0.240> <0.519, 13.211, -0.240> <0.519, 13.211, -0.240> 
		<0.526, 13.137, -0.295> <0.518, 13.214, -0.238> <0.518, 13.214, -0.238> <0.510, 13.288, -0.183> 
		<0.385, 13.148, -0.285> <0.381, 13.185, -0.257> <0.380, 13.234, -0.221> <0.376, 13.271, -0.193> 
		<0.293, 13.146, -0.286> <0.289, 13.183, -0.259> <0.284, 13.232, -0.222> <0.280, 13.269, -0.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 13.211, -0.240> <0.526, 13.137, -0.295> <0.385, 13.148, -0.285> <0.293, 13.146, -0.286> 
		<0.498, 13.229, -0.260> <0.505, 13.155, -0.315> <0.411, 13.172, -0.314> <0.318, 13.170, -0.316> 
		<0.448, 13.249, -0.280> <0.452, 13.214, -0.306> <0.392, 13.196, -0.338> <0.352, 13.203, -0.355> 
		<0.448, 13.271, -0.305> <0.452, 13.236, -0.332> <0.418, 13.221, -0.368> <0.378, 13.228, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 13.203, -0.247> <0.161, 13.203, -0.247> <0.161, 13.203, -0.247> <0.161, 13.203, -0.247> 
		<0.156, 13.248, -0.213> <0.161, 13.202, -0.248> <0.161, 13.202, -0.248> <0.166, 13.157, -0.281> 
		<0.224, 13.267, -0.196> <0.228, 13.231, -0.223> <0.231, 13.181, -0.260> <0.235, 13.144, -0.287> 
		<0.280, 13.269, -0.195> <0.284, 13.232, -0.222> <0.289, 13.183, -0.259> <0.293, 13.146, -0.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 13.203, -0.247> <0.211, 13.230, -0.280> <0.291, 13.258, -0.316> <0.329, 13.293, -0.357> 
		<0.166, 13.157, -0.281> <0.216, 13.184, -0.314> <0.294, 13.231, -0.335> <0.332, 13.266, -0.376> 
		<0.235, 13.144, -0.287> <0.261, 13.169, -0.317> <0.322, 13.209, -0.368> <0.348, 13.233, -0.398> 
		<0.293, 13.146, -0.286> <0.318, 13.170, -0.316> <0.352, 13.203, -0.355> <0.378, 13.228, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 13.203, -0.247> <0.156, 13.248, -0.213> <0.224, 13.267, -0.196> <0.280, 13.269, -0.195> 
		<0.211, 13.230, -0.280> <0.206, 13.275, -0.246> <0.249, 13.292, -0.225> <0.305, 13.293, -0.224> 
		<0.291, 13.258, -0.316> <0.288, 13.286, -0.294> <0.307, 13.332, -0.278> <0.339, 13.326, -0.264> 
		<0.329, 13.293, -0.357> <0.326, 13.321, -0.335> <0.332, 13.357, -0.308> <0.365, 13.351, -0.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.448, 13.271, -0.305> <0.448, 13.271, -0.305> <0.448, 13.271, -0.305> <0.448, 13.271, -0.305> 
		<0.444, 13.307, -0.279> <0.448, 13.272, -0.305> <0.448, 13.272, -0.305> <0.452, 13.236, -0.332> 
		<0.405, 13.344, -0.276> <0.409, 13.307, -0.303> <0.414, 13.258, -0.340> <0.418, 13.221, -0.368> 
		<0.365, 13.351, -0.293> <0.368, 13.314, -0.321> <0.374, 13.265, -0.357> <0.378, 13.228, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.448, 13.271, -0.305> <0.448, 13.328, -0.372> <0.502, 13.396, -0.458> <0.517, 13.452, -0.524> 
		<0.444, 13.307, -0.279> <0.444, 13.364, -0.345> <0.499, 13.414, -0.443> <0.514, 13.470, -0.509> 
		<0.405, 13.344, -0.276> <0.437, 13.384, -0.339> <0.470, 13.439, -0.437> <0.493, 13.485, -0.500> 
		<0.365, 13.351, -0.293> <0.396, 13.391, -0.356> <0.447, 13.439, -0.440> <0.470, 13.485, -0.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.448, 13.271, -0.305> <0.452, 13.236, -0.332> <0.418, 13.221, -0.368> <0.378, 13.228, -0.385> 
		<0.448, 13.328, -0.372> <0.452, 13.292, -0.398> <0.448, 13.278, -0.419> <0.408, 13.286, -0.437> 
		<0.502, 13.396, -0.458> <0.504, 13.378, -0.473> <0.480, 13.361, -0.499> <0.457, 13.361, -0.503> 
		<0.517, 13.452, -0.524> <0.519, 13.434, -0.539> <0.502, 13.420, -0.554> <0.479, 13.420, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.378, 13.228, -0.385> <0.378, 13.228, -0.385> <0.378, 13.228, -0.385> <0.378, 13.228, -0.385> 
		<0.374, 13.265, -0.357> <0.344, 13.270, -0.370> <0.344, 13.270, -0.370> <0.348, 13.233, -0.398> 
		<0.368, 13.314, -0.321> <0.336, 13.320, -0.335> <0.329, 13.295, -0.355> <0.332, 13.266, -0.376> 
		<0.365, 13.351, -0.293> <0.332, 13.357, -0.308> <0.326, 13.321, -0.335> <0.329, 13.293, -0.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.378, 13.228, -0.385> <0.348, 13.233, -0.398> <0.332, 13.266, -0.376> <0.329, 13.293, -0.357> 
		<0.408, 13.286, -0.437> <0.378, 13.291, -0.450> <0.378, 13.308, -0.425> <0.375, 13.334, -0.406> 
		<0.457, 13.361, -0.503> <0.434, 13.361, -0.507> <0.411, 13.384, -0.497> <0.408, 13.402, -0.482> 
		<0.479, 13.420, -0.558> <0.456, 13.420, -0.562> <0.435, 13.434, -0.553> <0.433, 13.452, -0.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.329, 13.293, -0.357> <0.326, 13.321, -0.335> <0.332, 13.357, -0.308> <0.365, 13.351, -0.293> 
		<0.375, 13.334, -0.406> <0.372, 13.363, -0.384> <0.364, 13.397, -0.370> <0.396, 13.391, -0.356> 
		<0.408, 13.402, -0.482> <0.406, 13.420, -0.467> <0.424, 13.439, -0.444> <0.447, 13.439, -0.440> 
		<0.433, 13.452, -0.538> <0.430, 13.470, -0.523> <0.447, 13.485, -0.507> <0.470, 13.485, -0.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 13.452, -0.524> <0.529, 13.499, -0.578> <0.524, 13.568, -0.651> <0.540, 13.615, -0.704> 
		<0.514, 13.470, -0.509> <0.527, 13.517, -0.563> <0.522, 13.581, -0.638> <0.538, 13.628, -0.692> 
		<0.493, 13.485, -0.500> <0.513, 13.523, -0.553> <0.502, 13.595, -0.627> <0.522, 13.635, -0.679> 
		<0.470, 13.485, -0.503> <0.490, 13.523, -0.557> <0.485, 13.590, -0.625> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 13.452, -0.524> <0.519, 13.434, -0.539> <0.502, 13.420, -0.554> <0.479, 13.420, -0.558> 
		<0.529, 13.499, -0.578> <0.532, 13.482, -0.593> <0.521, 13.469, -0.601> <0.498, 13.468, -0.604> 
		<0.524, 13.568, -0.651> <0.525, 13.555, -0.663> <0.509, 13.539, -0.678> <0.492, 13.534, -0.675> 
		<0.540, 13.615, -0.704> <0.542, 13.602, -0.717> <0.529, 13.587, -0.724> <0.512, 13.582, -0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.479, 13.420, -0.558> <0.456, 13.420, -0.562> <0.435, 13.434, -0.553> <0.433, 13.452, -0.538> 
		<0.498, 13.468, -0.604> <0.475, 13.468, -0.608> <0.455, 13.476, -0.599> <0.453, 13.494, -0.584> 
		<0.492, 13.534, -0.675> <0.475, 13.529, -0.672> <0.456, 13.543, -0.661> <0.454, 13.556, -0.649> 
		<0.512, 13.582, -0.722> <0.495, 13.577, -0.719> <0.479, 13.584, -0.706> <0.478, 13.597, -0.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.433, 13.452, -0.538> <0.430, 13.470, -0.523> <0.447, 13.485, -0.507> <0.470, 13.485, -0.503> 
		<0.453, 13.494, -0.584> <0.450, 13.511, -0.569> <0.467, 13.523, -0.560> <0.490, 13.523, -0.557> 
		<0.454, 13.556, -0.649> <0.453, 13.569, -0.637> <0.468, 13.585, -0.622> <0.485, 13.590, -0.625> 
		<0.478, 13.597, -0.694> <0.476, 13.610, -0.682> <0.488, 13.625, -0.674> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.596, 13.760, -0.875> <0.519, 13.670, -0.774> <0.478, 13.597, -0.694> 
		<0.614, 13.765, -0.878> <0.564, 13.695, -0.800> <0.517, 13.683, -0.762> <0.476, 13.610, -0.682> 
		<0.563, 13.682, -0.780> <0.561, 13.695, -0.768> <0.505, 13.630, -0.677> <0.488, 13.625, -0.674> 
		<0.540, 13.615, -0.704> <0.538, 13.628, -0.692> <0.522, 13.635, -0.679> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.604, 13.770, -0.870> <0.572, 13.705, -0.795> <0.572, 13.705, -0.795> <0.614, 13.765, -0.878> 
		<0.538, 13.694, -0.760> <0.555, 13.699, -0.763> <0.561, 13.695, -0.768> <0.563, 13.682, -0.780> 
		<0.505, 13.630, -0.677> <0.522, 13.635, -0.679> <0.538, 13.628, -0.692> <0.540, 13.615, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.614, 13.765, -0.878> <0.563, 13.682, -0.780> <0.540, 13.615, -0.704> 
		<0.596, 13.760, -0.875> <0.564, 13.695, -0.800> <0.565, 13.669, -0.792> <0.542, 13.602, -0.717> 
		<0.519, 13.670, -0.774> <0.521, 13.657, -0.786> <0.512, 13.582, -0.722> <0.529, 13.587, -0.724> 
		<0.478, 13.597, -0.694> <0.479, 13.584, -0.706> <0.495, 13.577, -0.719> <0.512, 13.582, -0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.606, 13.755, -0.883> <0.574, 13.691, -0.809> <0.574, 13.691, -0.809> <0.614, 13.765, -0.878> 
		<0.543, 13.658, -0.794> <0.560, 13.663, -0.797> <0.565, 13.669, -0.792> <0.563, 13.682, -0.780> 
		<0.512, 13.582, -0.722> <0.529, 13.587, -0.724> <0.542, 13.602, -0.717> <0.540, 13.615, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.604, 13.770, -0.870> <0.538, 13.694, -0.760> <0.505, 13.630, -0.677> 
		<0.606, 13.755, -0.883> <0.564, 13.695, -0.800> <0.521, 13.689, -0.758> <0.488, 13.625, -0.674> 
		<0.543, 13.658, -0.794> <0.526, 13.653, -0.791> <0.478, 13.597, -0.694> <0.476, 13.610, -0.682> 
		<0.512, 13.582, -0.722> <0.495, 13.577, -0.719> <0.479, 13.584, -0.706> <0.478, 13.597, -0.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.596, 13.760, -0.875> <0.553, 13.700, -0.792> <0.553, 13.700, -0.792> <0.604, 13.770, -0.870> 
		<0.519, 13.670, -0.774> <0.517, 13.683, -0.762> <0.521, 13.689, -0.758> <0.538, 13.694, -0.760> 
		<0.478, 13.597, -0.694> <0.476, 13.610, -0.682> <0.488, 13.625, -0.674> <0.505, 13.630, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.604, 13.770, -0.870> <0.538, 13.694, -0.760> <0.505, 13.630, -0.677> 
		<0.606, 13.755, -0.883> <0.564, 13.695, -0.800> <0.555, 13.699, -0.763> <0.522, 13.635, -0.679> 
		<0.543, 13.658, -0.794> <0.560, 13.663, -0.797> <0.540, 13.615, -0.704> <0.538, 13.628, -0.692> 
		<0.512, 13.582, -0.722> <0.529, 13.587, -0.724> <0.542, 13.602, -0.717> <0.540, 13.615, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> <0.646, 13.830, -0.952> 
		<0.596, 13.760, -0.875> <0.555, 13.686, -0.806> <0.555, 13.686, -0.806> <0.606, 13.755, -0.883> 
		<0.519, 13.670, -0.774> <0.521, 13.657, -0.786> <0.526, 13.653, -0.791> <0.543, 13.658, -0.794> 
		<0.478, 13.597, -0.694> <0.479, 13.584, -0.706> <0.495, 13.577, -0.719> <0.512, 13.582, -0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.474, 13.429, -0.492> <0.474, 13.429, -0.492> <0.474, 13.429, -0.492> <0.474, 13.429, -0.492> 
		<0.475, 13.450, -0.478> <0.474, 13.429, -0.492> <0.474, 13.429, -0.492> <0.473, 13.407, -0.506> 
		<0.473, 13.480, -0.487> <0.472, 13.458, -0.502> <0.471, 13.428, -0.521> <0.470, 13.406, -0.536> 
		<0.469, 13.493, -0.509> <0.468, 13.471, -0.523> <0.467, 13.441, -0.543> <0.466, 13.419, -0.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.474, 13.429, -0.492> <0.475, 13.450, -0.478> <0.473, 13.480, -0.487> <0.469, 13.493, -0.509> 
		<0.522, 13.438, -0.507> <0.522, 13.460, -0.492> <0.519, 13.479, -0.498> <0.515, 13.493, -0.520> 
		<0.586, 13.447, -0.526> <0.585, 13.458, -0.519> <0.582, 13.480, -0.523> <0.576, 13.487, -0.534> 
		<0.632, 13.460, -0.540> <0.632, 13.471, -0.532> <0.627, 13.486, -0.535> <0.621, 13.492, -0.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.474, 13.429, -0.492> <0.522, 13.438, -0.507> <0.586, 13.447, -0.526> <0.632, 13.460, -0.540> 
		<0.473, 13.407, -0.506> <0.521, 13.416, -0.520> <0.586, 13.436, -0.534> <0.633, 13.448, -0.547> 
		<0.470, 13.406, -0.536> <0.517, 13.415, -0.540> <0.582, 13.432, -0.556> <0.628, 13.445, -0.562> 
		<0.466, 13.419, -0.557> <0.513, 13.429, -0.562> <0.577, 13.439, -0.566> <0.622, 13.451, -0.572> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.466, 13.419, -0.557> <0.466, 13.419, -0.557> <0.466, 13.419, -0.557> <0.466, 13.419, -0.557> 
		<0.467, 13.441, -0.543> <0.464, 13.451, -0.559> <0.464, 13.451, -0.559> <0.463, 13.429, -0.573> 
		<0.468, 13.471, -0.523> <0.465, 13.482, -0.541> <0.462, 13.469, -0.555> <0.461, 13.452, -0.566> 
		<0.469, 13.493, -0.509> <0.466, 13.504, -0.526> <0.462, 13.485, -0.545> <0.462, 13.468, -0.556> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.466, 13.419, -0.557> <0.513, 13.429, -0.562> <0.577, 13.439, -0.566> <0.622, 13.451, -0.572> 
		<0.463, 13.429, -0.573> <0.510, 13.439, -0.578> <0.571, 13.445, -0.576> <0.616, 13.458, -0.582> 
		<0.461, 13.452, -0.566> <0.506, 13.457, -0.573> <0.567, 13.464, -0.577> <0.611, 13.473, -0.584> 
		<0.462, 13.468, -0.556> <0.507, 13.473, -0.562> <0.567, 13.475, -0.570> <0.611, 13.484, -0.577> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.462, 13.468, -0.556> <0.507, 13.473, -0.562> <0.567, 13.475, -0.570> <0.611, 13.484, -0.577> 
		<0.462, 13.485, -0.545> <0.507, 13.490, -0.551> <0.566, 13.487, -0.562> <0.610, 13.495, -0.569> 
		<0.466, 13.504, -0.526> <0.511, 13.504, -0.537> <0.570, 13.493, -0.544> <0.615, 13.499, -0.555> 
		<0.469, 13.493, -0.509> <0.515, 13.493, -0.520> <0.576, 13.487, -0.534> <0.621, 13.492, -0.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.632, 13.460, -0.540> <0.632, 13.471, -0.532> <0.627, 13.486, -0.535> <0.621, 13.492, -0.545> 
		<0.663, 13.468, -0.549> <0.663, 13.479, -0.541> <0.661, 13.489, -0.543> <0.655, 13.496, -0.553> 
		<0.705, 13.480, -0.564> <0.705, 13.489, -0.558> <0.700, 13.503, -0.561> <0.698, 13.509, -0.570> 
		<0.733, 13.498, -0.568> <0.733, 13.506, -0.562> <0.731, 13.518, -0.565> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.632, 13.460, -0.540> <0.663, 13.468, -0.549> <0.705, 13.480, -0.564> <0.733, 13.498, -0.568> 
		<0.633, 13.448, -0.547> <0.664, 13.457, -0.556> <0.705, 13.471, -0.570> <0.733, 13.489, -0.574> 
		<0.628, 13.445, -0.562> <0.662, 13.454, -0.567> <0.702, 13.467, -0.585> <0.731, 13.486, -0.586> 
		<0.622, 13.451, -0.572> <0.656, 13.460, -0.577> <0.700, 13.473, -0.594> <0.729, 13.492, -0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.622, 13.451, -0.572> <0.656, 13.460, -0.577> <0.700, 13.473, -0.594> <0.729, 13.492, -0.594> 
		<0.616, 13.458, -0.582> <0.650, 13.467, -0.587> <0.698, 13.479, -0.602> <0.727, 13.497, -0.603> 
		<0.611, 13.473, -0.584> <0.647, 13.479, -0.590> <0.693, 13.493, -0.605> <0.726, 13.509, -0.605> 
		<0.611, 13.484, -0.577> <0.646, 13.490, -0.583> <0.693, 13.502, -0.600> <0.726, 13.518, -0.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.611, 13.484, -0.577> <0.646, 13.490, -0.583> <0.693, 13.502, -0.600> <0.726, 13.518, -0.599> 
		<0.610, 13.495, -0.569> <0.646, 13.502, -0.575> <0.693, 13.511, -0.594> <0.726, 13.527, -0.594> 
		<0.615, 13.499, -0.555> <0.649, 13.503, -0.563> <0.696, 13.514, -0.578> <0.728, 13.529, -0.582> 
		<0.621, 13.492, -0.545> <0.655, 13.496, -0.553> <0.698, 13.509, -0.570> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.828, 13.576, -0.573> <0.777, 13.526, -0.575> <0.733, 13.498, -0.568> 
		<0.826, 13.582, -0.582> <0.785, 13.548, -0.580> <0.777, 13.534, -0.569> <0.733, 13.506, -0.562> 
		<0.772, 13.541, -0.599> <0.772, 13.549, -0.593> <0.729, 13.524, -0.573> <0.731, 13.518, -0.565> 
		<0.726, 13.518, -0.599> <0.726, 13.527, -0.594> <0.728, 13.529, -0.582> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.827, 13.584, -0.575> <0.786, 13.550, -0.573> <0.786, 13.550, -0.573> <0.828, 13.576, -0.573> 
		<0.774, 13.545, -0.579> <0.776, 13.539, -0.570> <0.777, 13.534, -0.569> <0.777, 13.526, -0.575> 
		<0.729, 13.524, -0.573> <0.731, 13.518, -0.565> <0.733, 13.506, -0.562> <0.733, 13.498, -0.568> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.826, 13.582, -0.582> <0.772, 13.541, -0.599> <0.726, 13.518, -0.599> 
		<0.828, 13.576, -0.573> <0.785, 13.548, -0.580> <0.772, 13.532, -0.605> <0.726, 13.509, -0.605> 
		<0.777, 13.526, -0.575> <0.777, 13.517, -0.580> <0.729, 13.492, -0.594> <0.727, 13.497, -0.603> 
		<0.733, 13.498, -0.568> <0.733, 13.489, -0.574> <0.731, 13.486, -0.586> <0.729, 13.492, -0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.828, 13.576, -0.573> <0.786, 13.541, -0.579> <0.786, 13.541, -0.579> <0.827, 13.574, -0.581> 
		<0.777, 13.526, -0.575> <0.777, 13.517, -0.580> <0.778, 13.516, -0.586> <0.776, 13.522, -0.595> 
		<0.733, 13.498, -0.568> <0.733, 13.489, -0.574> <0.731, 13.486, -0.586> <0.729, 13.492, -0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.827, 13.584, -0.575> <0.774, 13.545, -0.579> <0.729, 13.524, -0.573> 
		<0.827, 13.574, -0.581> <0.785, 13.548, -0.580> <0.772, 13.550, -0.587> <0.728, 13.529, -0.582> 
		<0.776, 13.522, -0.595> <0.774, 13.527, -0.603> <0.726, 13.518, -0.599> <0.726, 13.527, -0.594> 
		<0.729, 13.492, -0.594> <0.727, 13.497, -0.603> <0.726, 13.509, -0.605> <0.726, 13.518, -0.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.826, 13.582, -0.582> <0.784, 13.556, -0.582> <0.784, 13.556, -0.582> <0.827, 13.584, -0.575> 
		<0.772, 13.541, -0.599> <0.772, 13.549, -0.593> <0.772, 13.550, -0.587> <0.774, 13.545, -0.579> 
		<0.726, 13.518, -0.599> <0.726, 13.527, -0.594> <0.728, 13.529, -0.582> <0.729, 13.524, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.827, 13.584, -0.575> <0.774, 13.545, -0.579> <0.729, 13.524, -0.573> 
		<0.827, 13.574, -0.581> <0.785, 13.548, -0.580> <0.776, 13.539, -0.570> <0.731, 13.518, -0.565> 
		<0.776, 13.522, -0.595> <0.778, 13.516, -0.586> <0.733, 13.498, -0.568> <0.733, 13.506, -0.562> 
		<0.729, 13.492, -0.594> <0.731, 13.486, -0.586> <0.733, 13.489, -0.574> <0.733, 13.498, -0.568> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> <0.869, 13.610, -0.575> 
		<0.827, 13.574, -0.581> <0.784, 13.547, -0.588> <0.784, 13.547, -0.588> <0.826, 13.582, -0.582> 
		<0.776, 13.522, -0.595> <0.774, 13.527, -0.603> <0.772, 13.532, -0.605> <0.772, 13.541, -0.599> 
		<0.729, 13.492, -0.594> <0.727, 13.497, -0.603> <0.726, 13.509, -0.605> <0.726, 13.518, -0.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.178, 13.267, -0.280> <1.243, 13.257, -0.295> <1.329, 13.242, -0.319> <1.395, 13.233, -0.329> 
		<1.171, 13.280, -0.311> <1.235, 13.270, -0.325> <1.329, 13.256, -0.330> <1.395, 13.247, -0.340> 
		<1.192, 13.330, -0.291> <1.250, 13.309, -0.308> <1.337, 13.284, -0.325> <1.398, 13.268, -0.337> 
		<1.207, 13.349, -0.267> <1.265, 13.328, -0.284> <1.340, 13.295, -0.311> <1.401, 13.278, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.207, 13.349, -0.267> <1.265, 13.328, -0.284> <1.340, 13.295, -0.311> <1.401, 13.278, -0.323> 
		<1.218, 13.363, -0.249> <1.276, 13.342, -0.266> <1.343, 13.305, -0.297> <1.403, 13.289, -0.309> 
		<1.231, 13.347, -0.205> <1.285, 13.331, -0.226> <1.349, 13.299, -0.272> <1.405, 13.286, -0.288> 
		<1.222, 13.323, -0.209> <1.277, 13.308, -0.230> <1.348, 13.285, -0.261> <1.405, 13.272, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.395, 13.233, -0.329> <1.450, 13.225, -0.338> <1.526, 13.220, -0.333> <1.581, 13.211, -0.343> 
		<1.394, 13.218, -0.318> <1.449, 13.211, -0.327> <1.525, 13.209, -0.324> <1.580, 13.200, -0.335> 
		<1.396, 13.215, -0.298> <1.448, 13.209, -0.305> <1.526, 13.205, -0.304> <1.576, 13.197, -0.319> 
		<1.399, 13.226, -0.283> <1.451, 13.220, -0.291> <1.522, 13.214, -0.294> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.395, 13.233, -0.329> <1.395, 13.247, -0.340> <1.398, 13.268, -0.337> <1.401, 13.278, -0.323> 
		<1.450, 13.225, -0.338> <1.450, 13.239, -0.349> <1.449, 13.254, -0.347> <1.452, 13.264, -0.333> 
		<1.526, 13.220, -0.333> <1.528, 13.232, -0.341> <1.530, 13.254, -0.341> <1.526, 13.263, -0.330> 
		<1.581, 13.211, -0.343> <1.582, 13.223, -0.352> <1.580, 13.240, -0.352> <1.576, 13.249, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 13.278, -0.323> <1.403, 13.289, -0.309> <1.405, 13.286, -0.288> <1.405, 13.272, -0.277> 
		<1.452, 13.264, -0.333> <1.454, 13.275, -0.319> <1.453, 13.275, -0.301> <1.452, 13.260, -0.290> 
		<1.526, 13.263, -0.330> <1.522, 13.272, -0.319> <1.522, 13.265, -0.299> <1.521, 13.253, -0.290> 
		<1.576, 13.249, -0.341> <1.573, 13.258, -0.330> <1.569, 13.252, -0.314> <1.567, 13.241, -0.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.405, 13.272, -0.277> <1.405, 13.257, -0.266> <1.402, 13.237, -0.269> <1.399, 13.226, -0.283> 
		<1.452, 13.260, -0.290> <1.452, 13.246, -0.280> <1.454, 13.230, -0.277> <1.451, 13.220, -0.291> 
		<1.521, 13.253, -0.290> <1.520, 13.242, -0.282> <1.518, 13.222, -0.283> <1.522, 13.214, -0.294> 
		<1.567, 13.241, -0.305> <1.566, 13.230, -0.297> <1.568, 13.214, -0.299> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.751, 13.181, -0.382> <1.650, 13.218, -0.332> <1.567, 13.241, -0.305> 
		<1.755, 13.172, -0.393> <1.677, 13.198, -0.360> <1.648, 13.207, -0.323> <1.566, 13.230, -0.297> 
		<1.658, 13.197, -0.358> <1.657, 13.186, -0.350> <1.572, 13.206, -0.309> <1.568, 13.214, -0.299> 
		<1.581, 13.211, -0.343> <1.580, 13.200, -0.335> <1.576, 13.197, -0.319> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.753, 13.171, -0.383> <1.678, 13.187, -0.362> <1.678, 13.187, -0.362> <1.755, 13.172, -0.393> 
		<1.652, 13.192, -0.333> <1.656, 13.184, -0.344> <1.657, 13.186, -0.350> <1.658, 13.197, -0.358> 
		<1.572, 13.206, -0.309> <1.576, 13.197, -0.319> <1.580, 13.200, -0.335> <1.581, 13.211, -0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.755, 13.172, -0.393> <1.658, 13.197, -0.358> <1.581, 13.211, -0.343> 
		<1.751, 13.181, -0.382> <1.677, 13.198, -0.360> <1.659, 13.209, -0.367> <1.582, 13.223, -0.352> 
		<1.650, 13.218, -0.332> <1.651, 13.230, -0.340> <1.577, 13.249, -0.341> <1.580, 13.240, -0.352> 
		<1.567, 13.241, -0.305> <1.569, 13.252, -0.314> <1.573, 13.258, -0.330> <1.576, 13.249, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.754, 13.184, -0.393> <1.679, 13.200, -0.371> <1.679, 13.200, -0.371> <1.755, 13.172, -0.393> 
		<1.656, 13.226, -0.358> <1.660, 13.217, -0.369> <1.659, 13.209, -0.367> <1.658, 13.197, -0.358> 
		<1.576, 13.249, -0.341> <1.580, 13.240, -0.352> <1.582, 13.223, -0.352> <1.581, 13.211, -0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.753, 13.171, -0.383> <1.652, 13.192, -0.333> <1.572, 13.206, -0.309> 
		<1.754, 13.184, -0.393> <1.677, 13.199, -0.361> <1.649, 13.201, -0.323> <1.568, 13.214, -0.299> 
		<1.656, 13.226, -0.358> <1.652, 13.235, -0.347> <1.567, 13.241, -0.305> <1.566, 13.230, -0.297> 
		<1.576, 13.249, -0.341> <1.573, 13.258, -0.330> <1.569, 13.252, -0.314> <1.567, 13.241, -0.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.751, 13.181, -0.382> <1.674, 13.196, -0.350> <1.674, 13.196, -0.350> <1.753, 13.171, -0.383> 
		<1.650, 13.218, -0.332> <1.648, 13.207, -0.323> <1.649, 13.201, -0.323> <1.652, 13.192, -0.333> 
		<1.567, 13.241, -0.305> <1.566, 13.230, -0.297> <1.568, 13.214, -0.299> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.753, 13.171, -0.383> <1.652, 13.192, -0.333> <1.572, 13.206, -0.309> 
		<1.754, 13.184, -0.393> <1.677, 13.199, -0.361> <1.656, 13.184, -0.344> <1.576, 13.197, -0.319> 
		<1.656, 13.226, -0.358> <1.660, 13.217, -0.369> <1.581, 13.211, -0.344> <1.580, 13.200, -0.335> 
		<1.576, 13.249, -0.341> <1.580, 13.240, -0.352> <1.582, 13.223, -0.352> <1.581, 13.211, -0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.751, 13.181, -0.382> <1.675, 13.209, -0.360> <1.675, 13.209, -0.360> <1.754, 13.184, -0.393> 
		<1.650, 13.218, -0.332> <1.651, 13.230, -0.340> <1.652, 13.235, -0.347> <1.656, 13.226, -0.358> 
		<1.567, 13.241, -0.305> <1.569, 13.252, -0.314> <1.573, 13.258, -0.330> <1.576, 13.249, -0.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.366, 13.249, -0.300> <1.366, 13.249, -0.300> <1.366, 13.249, -0.300> <1.366, 13.249, -0.300> 
		<1.367, 13.232, -0.290> <1.366, 13.249, -0.300> <1.366, 13.249, -0.300> <1.364, 13.266, -0.309> 
		<1.387, 13.221, -0.283> <1.385, 13.239, -0.293> <1.383, 13.262, -0.306> <1.381, 13.280, -0.315> 
		<1.407, 13.224, -0.282> <1.405, 13.242, -0.291> <1.402, 13.266, -0.305> <1.400, 13.284, -0.314> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.366, 13.249, -0.300> <1.367, 13.232, -0.290> <1.387, 13.221, -0.283> <1.407, 13.224, -0.282> 
		<1.377, 13.231, -0.332> <1.379, 13.214, -0.322> <1.392, 13.207, -0.316> <1.412, 13.211, -0.315> 
		<1.392, 13.209, -0.377> <1.393, 13.201, -0.371> <1.406, 13.192, -0.364> <1.416, 13.195, -0.360> 
		<1.405, 13.190, -0.407> <1.406, 13.181, -0.402> <1.415, 13.176, -0.395> <1.424, 13.179, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.366, 13.249, -0.300> <1.377, 13.231, -0.332> <1.392, 13.209, -0.377> <1.405, 13.190, -0.407> 
		<1.364, 13.266, -0.309> <1.376, 13.249, -0.342> <1.391, 13.218, -0.382> <1.404, 13.198, -0.413> 
		<1.381, 13.280, -0.315> <1.387, 13.259, -0.345> <1.403, 13.230, -0.387> <1.412, 13.208, -0.415> 
		<1.400, 13.284, -0.314> <1.406, 13.262, -0.344> <1.412, 13.233, -0.384> <1.421, 13.211, -0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, 13.284, -0.314> <1.400, 13.284, -0.314> <1.400, 13.284, -0.314> <1.400, 13.284, -0.314> 
		<1.402, 13.266, -0.305> <1.417, 13.268, -0.304> <1.417, 13.268, -0.304> <1.415, 13.286, -0.314> 
		<1.405, 13.242, -0.291> <1.420, 13.245, -0.291> <1.423, 13.258, -0.296> <1.422, 13.272, -0.304> 
		<1.407, 13.224, -0.282> <1.422, 13.227, -0.281> <1.424, 13.245, -0.289> <1.423, 13.259, -0.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, 13.284, -0.314> <1.406, 13.262, -0.344> <1.412, 13.233, -0.384> <1.421, 13.211, -0.412> 
		<1.415, 13.286, -0.314> <1.421, 13.264, -0.343> <1.421, 13.236, -0.380> <1.430, 13.214, -0.409> 
		<1.422, 13.272, -0.304> <1.427, 13.254, -0.333> <1.432, 13.228, -0.373> <1.439, 13.209, -0.401> 
		<1.423, 13.259, -0.297> <1.428, 13.241, -0.326> <1.432, 13.219, -0.367> <1.440, 13.200, -0.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 13.259, -0.297> <1.428, 13.241, -0.326> <1.432, 13.219, -0.367> <1.440, 13.200, -0.396> 
		<1.424, 13.245, -0.289> <1.429, 13.228, -0.319> <1.433, 13.211, -0.362> <1.441, 13.192, -0.390> 
		<1.422, 13.227, -0.281> <1.428, 13.213, -0.314> <1.425, 13.198, -0.357> <1.433, 13.182, -0.388> 
		<1.407, 13.224, -0.282> <1.412, 13.211, -0.315> <1.416, 13.195, -0.360> <1.424, 13.179, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.405, 13.190, -0.407> <1.406, 13.181, -0.402> <1.415, 13.176, -0.395> <1.424, 13.179, -0.391> 
		<1.414, 13.177, -0.428> <1.415, 13.168, -0.422> <1.421, 13.164, -0.418> <1.430, 13.167, -0.415> 
		<1.428, 13.160, -0.456> <1.429, 13.153, -0.452> <1.437, 13.149, -0.445> <1.445, 13.150, -0.444> 
		<1.438, 13.142, -0.470> <1.439, 13.135, -0.466> <1.446, 13.130, -0.462> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.405, 13.190, -0.407> <1.414, 13.177, -0.428> <1.428, 13.160, -0.456> <1.438, 13.142, -0.470> 
		<1.404, 13.198, -0.413> <1.413, 13.185, -0.433> <1.427, 13.167, -0.460> <1.437, 13.148, -0.474> 
		<1.412, 13.208, -0.415> <1.418, 13.192, -0.435> <1.435, 13.176, -0.463> <1.443, 13.155, -0.477> 
		<1.421, 13.211, -0.412> <1.427, 13.195, -0.432> <1.443, 13.178, -0.462> <1.451, 13.156, -0.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.421, 13.211, -0.412> <1.427, 13.195, -0.432> <1.443, 13.178, -0.462> <1.451, 13.156, -0.476> 
		<1.430, 13.214, -0.409> <1.437, 13.198, -0.429> <1.450, 13.179, -0.461> <1.459, 13.158, -0.475> 
		<1.439, 13.209, -0.401> <1.445, 13.194, -0.424> <1.459, 13.174, -0.454> <1.466, 13.153, -0.471> 
		<1.440, 13.200, -0.396> <1.446, 13.185, -0.419> <1.460, 13.168, -0.450> <1.467, 13.146, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.440, 13.200, -0.396> <1.446, 13.185, -0.419> <1.460, 13.168, -0.450> <1.467, 13.146, -0.467> 
		<1.441, 13.192, -0.390> <1.446, 13.177, -0.413> <1.461, 13.161, -0.446> <1.468, 13.139, -0.463> 
		<1.433, 13.182, -0.388> <1.440, 13.170, -0.412> <1.453, 13.151, -0.443> <1.462, 13.133, -0.461> 
		<1.424, 13.179, -0.391> <1.430, 13.167, -0.415> <1.445, 13.150, -0.444> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.476, 13.065, -0.511> <1.455, 13.112, -0.493> <1.438, 13.142, -0.470> 
		<1.485, 13.066, -0.510> <1.469, 13.099, -0.493> <1.455, 13.105, -0.489> <1.439, 13.135, -0.466> 
		<1.476, 13.116, -0.491> <1.477, 13.109, -0.487> <1.454, 13.131, -0.461> <1.446, 13.130, -0.462> 
		<1.467, 13.146, -0.467> <1.468, 13.139, -0.463> <1.462, 13.133, -0.461> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.481, 13.062, -0.508> <1.465, 13.095, -0.491> <1.465, 13.095, -0.491> <1.476, 13.065, -0.511> 
		<1.466, 13.105, -0.486> <1.458, 13.104, -0.486> <1.455, 13.105, -0.489> <1.455, 13.112, -0.493> 
		<1.454, 13.131, -0.461> <1.446, 13.130, -0.462> <1.439, 13.135, -0.466> <1.438, 13.142, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.485, 13.066, -0.510> <1.476, 13.116, -0.491> <1.467, 13.146, -0.467> 
		<1.476, 13.065, -0.511> <1.469, 13.099, -0.493> <1.476, 13.123, -0.495> <1.466, 13.153, -0.471> 
		<1.455, 13.112, -0.493> <1.454, 13.119, -0.497> <1.451, 13.156, -0.476> <1.459, 13.158, -0.475> 
		<1.438, 13.142, -0.470> <1.437, 13.148, -0.474> <1.443, 13.155, -0.477> <1.451, 13.156, -0.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.476, 13.065, -0.511> <1.464, 13.102, -0.495> <1.464, 13.102, -0.495> <1.480, 13.069, -0.513> 
		<1.455, 13.112, -0.493> <1.454, 13.119, -0.497> <1.457, 13.121, -0.499> <1.465, 13.123, -0.498> 
		<1.438, 13.142, -0.470> <1.437, 13.148, -0.474> <1.443, 13.155, -0.477> <1.451, 13.156, -0.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.481, 13.062, -0.508> <1.466, 13.105, -0.486> <1.454, 13.131, -0.461> 
		<1.480, 13.069, -0.513> <1.469, 13.099, -0.493> <1.474, 13.106, -0.485> <1.462, 13.133, -0.461> 
		<1.465, 13.123, -0.498> <1.472, 13.124, -0.497> <1.467, 13.146, -0.467> <1.468, 13.139, -0.463> 
		<1.451, 13.156, -0.476> <1.459, 13.158, -0.475> <1.466, 13.153, -0.471> <1.467, 13.146, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.485, 13.066, -0.510> <1.473, 13.096, -0.490> <1.473, 13.096, -0.490> <1.481, 13.062, -0.508> 
		<1.476, 13.116, -0.491> <1.477, 13.109, -0.487> <1.474, 13.106, -0.485> <1.466, 13.105, -0.486> 
		<1.467, 13.146, -0.467> <1.468, 13.139, -0.463> <1.462, 13.133, -0.461> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.481, 13.062, -0.508> <1.466, 13.105, -0.486> <1.454, 13.131, -0.461> 
		<1.480, 13.069, -0.513> <1.469, 13.099, -0.493> <1.458, 13.104, -0.486> <1.446, 13.130, -0.462> 
		<1.465, 13.123, -0.498> <1.457, 13.121, -0.499> <1.438, 13.142, -0.470> <1.439, 13.135, -0.466> 
		<1.451, 13.156, -0.476> <1.443, 13.155, -0.477> <1.437, 13.148, -0.474> <1.438, 13.142, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.480, 13.069, -0.513> <1.472, 13.103, -0.494> <1.472, 13.103, -0.494> <1.485, 13.066, -0.510> 
		<1.465, 13.123, -0.498> <1.472, 13.124, -0.497> <1.476, 13.123, -0.495> <1.476, 13.116, -0.491> 
		<1.451, 13.156, -0.476> <1.459, 13.158, -0.475> <1.466, 13.153, -0.471> <1.467, 13.146, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.178, 13.267, -0.280> <1.178, 13.267, -0.280> <1.178, 13.267, -0.280> <1.178, 13.267, -0.280> 
		<1.180, 13.239, -0.260> <1.178, 13.267, -0.280> <1.178, 13.267, -0.280> <1.177, 13.295, -0.300> 
		<1.196, 13.234, -0.223> <1.195, 13.263, -0.243> <1.194, 13.302, -0.271> <1.192, 13.330, -0.291> 
		<1.211, 13.253, -0.198> <1.210, 13.282, -0.219> <1.208, 13.321, -0.247> <1.207, 13.349, -0.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.178, 13.267, -0.280> <1.180, 13.239, -0.260> <1.196, 13.234, -0.223> <1.211, 13.253, -0.198> 
		<1.243, 13.257, -0.295> <1.245, 13.229, -0.275> <1.253, 13.226, -0.248> <1.268, 13.245, -0.224> 
		<1.329, 13.242, -0.319> <1.328, 13.228, -0.308> <1.337, 13.223, -0.279> <1.340, 13.234, -0.265> 
		<1.395, 13.233, -0.329> <1.394, 13.218, -0.318> <1.396, 13.215, -0.298> <1.399, 13.226, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.178, 13.267, -0.280> <1.243, 13.257, -0.295> <1.329, 13.242, -0.319> <1.395, 13.233, -0.329> 
		<1.177, 13.295, -0.300> <1.242, 13.284, -0.315> <1.329, 13.256, -0.330> <1.395, 13.247, -0.340> 
		<1.192, 13.330, -0.291> <1.250, 13.309, -0.308> <1.337, 13.285, -0.325> <1.398, 13.268, -0.337> 
		<1.207, 13.349, -0.267> <1.265, 13.328, -0.284> <1.340, 13.295, -0.311> <1.401, 13.278, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.207, 13.349, -0.267> <1.207, 13.349, -0.267> <1.207, 13.349, -0.267> <1.207, 13.349, -0.267> 
		<1.208, 13.321, -0.247> <1.219, 13.335, -0.229> <1.219, 13.335, -0.229> <1.218, 13.363, -0.249> 
		<1.210, 13.282, -0.219> <1.222, 13.298, -0.200> <1.222, 13.321, -0.208> <1.221, 13.344, -0.224> 
		<1.211, 13.253, -0.198> <1.223, 13.269, -0.179> <1.223, 13.301, -0.193> <1.222, 13.323, -0.209> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.207, 13.349, -0.267> <1.265, 13.328, -0.284> <1.340, 13.295, -0.311> <1.401, 13.278, -0.323> 
		<1.218, 13.363, -0.249> <1.276, 13.342, -0.266> <1.343, 13.306, -0.297> <1.403, 13.289, -0.309> 
		<1.221, 13.344, -0.224> <1.276, 13.328, -0.244> <1.349, 13.299, -0.272> <1.405, 13.286, -0.288> 
		<1.222, 13.323, -0.209> <1.277, 13.308, -0.230> <1.348, 13.285, -0.261> <1.405, 13.272, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.222, 13.323, -0.209> <1.277, 13.308, -0.230> <1.348, 13.285, -0.261> <1.405, 13.272, -0.277> 
		<1.223, 13.301, -0.193> <1.278, 13.285, -0.213> <1.348, 13.271, -0.251> <1.405, 13.257, -0.266> 
		<1.223, 13.269, -0.179> <1.280, 13.261, -0.204> <1.343, 13.244, -0.251> <1.402, 13.237, -0.269> 
		<1.211, 13.253, -0.198> <1.268, 13.245, -0.224> <1.340, 13.234, -0.265> <1.399, 13.226, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.395, 13.233, -0.329> <1.394, 13.218, -0.318> <1.396, 13.215, -0.298> <1.399, 13.226, -0.283> 
		<1.450, 13.225, -0.338> <1.449, 13.211, -0.327> <1.446, 13.209, -0.313> <1.449, 13.219, -0.299> 
		<1.526, 13.220, -0.333> <1.525, 13.209, -0.324> <1.526, 13.205, -0.304> <1.522, 13.214, -0.294> 
		<1.581, 13.211, -0.343> <1.580, 13.200, -0.335> <1.576, 13.197, -0.319> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.395, 13.233, -0.329> <1.450, 13.225, -0.338> <1.526, 13.220, -0.333> <1.581, 13.211, -0.343> 
		<1.395, 13.247, -0.340> <1.450, 13.239, -0.349> <1.528, 13.231, -0.341> <1.582, 13.222, -0.351> 
		<1.398, 13.268, -0.337> <1.449, 13.253, -0.347> <1.529, 13.252, -0.339> <1.580, 13.238, -0.350> 
		<1.401, 13.278, -0.323> <1.452, 13.264, -0.333> <1.526, 13.260, -0.328> <1.576, 13.246, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, 13.278, -0.323> <1.452, 13.264, -0.333> <1.526, 13.260, -0.328> <1.576, 13.246, -0.339> 
		<1.403, 13.289, -0.309> <1.454, 13.275, -0.319> <1.522, 13.268, -0.318> <1.573, 13.254, -0.329> 
		<1.405, 13.286, -0.288> <1.453, 13.275, -0.301> <1.522, 13.264, -0.298> <1.569, 13.252, -0.313> 
		<1.405, 13.272, -0.277> <1.452, 13.260, -0.290> <1.521, 13.253, -0.290> <1.567, 13.241, -0.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.405, 13.272, -0.277> <1.452, 13.260, -0.290> <1.521, 13.253, -0.290> <1.567, 13.241, -0.305> 
		<1.405, 13.257, -0.266> <1.452, 13.246, -0.280> <1.520, 13.242, -0.282> <1.566, 13.230, -0.297> 
		<1.402, 13.237, -0.269> <1.452, 13.230, -0.285> <1.518, 13.222, -0.283> <1.568, 13.214, -0.299> 
		<1.399, 13.226, -0.283> <1.449, 13.219, -0.299> <1.522, 13.214, -0.294> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.755, 13.172, -0.393> <1.658, 13.197, -0.358> <1.581, 13.211, -0.343> 
		<1.751, 13.181, -0.382> <1.677, 13.198, -0.360> <1.657, 13.186, -0.350> <1.580, 13.200, -0.335> 
		<1.650, 13.218, -0.332> <1.648, 13.207, -0.323> <1.572, 13.206, -0.309> <1.576, 13.197, -0.319> 
		<1.567, 13.241, -0.305> <1.566, 13.230, -0.297> <1.568, 13.214, -0.299> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.753, 13.171, -0.383> <1.678, 13.187, -0.362> <1.678, 13.187, -0.362> <1.755, 13.172, -0.393> 
		<1.652, 13.192, -0.333> <1.656, 13.184, -0.344> <1.657, 13.186, -0.350> <1.658, 13.197, -0.358> 
		<1.572, 13.206, -0.309> <1.576, 13.197, -0.319> <1.580, 13.200, -0.335> <1.581, 13.211, -0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.751, 13.181, -0.382> <1.650, 13.218, -0.332> <1.567, 13.241, -0.305> 
		<1.755, 13.172, -0.393> <1.677, 13.198, -0.360> <1.651, 13.229, -0.340> <1.569, 13.252, -0.313> 
		<1.658, 13.197, -0.358> <1.659, 13.208, -0.367> <1.576, 13.246, -0.339> <1.573, 13.254, -0.329> 
		<1.581, 13.211, -0.343> <1.582, 13.222, -0.351> <1.580, 13.238, -0.350> <1.576, 13.246, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.755, 13.172, -0.393> <1.679, 13.199, -0.371> <1.679, 13.199, -0.371> <1.754, 13.183, -0.392> 
		<1.658, 13.197, -0.358> <1.659, 13.208, -0.367> <1.659, 13.215, -0.367> <1.655, 13.223, -0.356> 
		<1.581, 13.211, -0.343> <1.582, 13.222, -0.351> <1.580, 13.238, -0.350> <1.576, 13.246, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.753, 13.171, -0.383> <1.652, 13.192, -0.333> <1.572, 13.206, -0.309> 
		<1.754, 13.183, -0.392> <1.677, 13.198, -0.360> <1.649, 13.201, -0.323> <1.568, 13.214, -0.299> 
		<1.655, 13.223, -0.356> <1.652, 13.232, -0.346> <1.567, 13.241, -0.305> <1.566, 13.230, -0.297> 
		<1.576, 13.246, -0.339> <1.573, 13.254, -0.329> <1.569, 13.252, -0.313> <1.567, 13.241, -0.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.751, 13.181, -0.382> <1.674, 13.196, -0.350> <1.674, 13.196, -0.350> <1.753, 13.171, -0.383> 
		<1.650, 13.218, -0.332> <1.648, 13.207, -0.323> <1.649, 13.201, -0.323> <1.652, 13.192, -0.333> 
		<1.567, 13.241, -0.305> <1.566, 13.230, -0.297> <1.568, 13.214, -0.299> <1.572, 13.206, -0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.753, 13.171, -0.383> <1.652, 13.192, -0.333> <1.572, 13.206, -0.309> 
		<1.754, 13.183, -0.392> <1.677, 13.198, -0.360> <1.656, 13.184, -0.344> <1.576, 13.197, -0.319> 
		<1.655, 13.223, -0.356> <1.659, 13.215, -0.367> <1.581, 13.211, -0.343> <1.580, 13.200, -0.335> 
		<1.576, 13.246, -0.339> <1.580, 13.238, -0.350> <1.582, 13.222, -0.351> <1.581, 13.211, -0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> <1.830, 13.156, -0.415> 
		<1.754, 13.183, -0.392> <1.675, 13.208, -0.359> <1.675, 13.208, -0.359> <1.751, 13.181, -0.382> 
		<1.655, 13.223, -0.356> <1.652, 13.232, -0.346> <1.651, 13.229, -0.340> <1.650, 13.218, -0.332> 
		<1.576, 13.246, -0.339> <1.573, 13.254, -0.329> <1.569, 13.252, -0.313> <1.567, 13.241, -0.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.366, 13.249, -0.300> <1.366, 13.249, -0.300> <1.366, 13.249, -0.300> <1.366, 13.249, -0.300> 
		<1.367, 13.232, -0.290> <1.366, 13.249, -0.300> <1.366, 13.249, -0.300> <1.364, 13.266, -0.309> 
		<1.387, 13.221, -0.283> <1.385, 13.239, -0.293> <1.383, 13.262, -0.306> <1.381, 13.280, -0.315> 
		<1.407, 13.224, -0.282> <1.405, 13.242, -0.291> <1.402, 13.266, -0.305> <1.400, 13.284, -0.314> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.366, 13.249, -0.300> <1.367, 13.232, -0.290> <1.387, 13.221, -0.283> <1.407, 13.224, -0.282> 
		<1.377, 13.231, -0.332> <1.379, 13.214, -0.322> <1.392, 13.207, -0.316> <1.412, 13.211, -0.315> 
		<1.392, 13.209, -0.377> <1.393, 13.201, -0.371> <1.406, 13.192, -0.364> <1.416, 13.195, -0.360> 
		<1.405, 13.190, -0.407> <1.406, 13.181, -0.402> <1.415, 13.176, -0.395> <1.424, 13.179, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.366, 13.249, -0.300> <1.377, 13.231, -0.332> <1.392, 13.209, -0.377> <1.405, 13.190, -0.407> 
		<1.364, 13.266, -0.309> <1.376, 13.249, -0.342> <1.391, 13.218, -0.382> <1.404, 13.198, -0.413> 
		<1.381, 13.280, -0.315> <1.387, 13.259, -0.345> <1.403, 13.230, -0.387> <1.412, 13.208, -0.415> 
		<1.400, 13.284, -0.314> <1.406, 13.262, -0.344> <1.412, 13.233, -0.384> <1.421, 13.211, -0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, 13.284, -0.314> <1.400, 13.284, -0.314> <1.400, 13.284, -0.314> <1.400, 13.284, -0.314> 
		<1.402, 13.266, -0.305> <1.417, 13.268, -0.304> <1.417, 13.268, -0.304> <1.415, 13.286, -0.314> 
		<1.405, 13.242, -0.291> <1.420, 13.245, -0.291> <1.423, 13.258, -0.296> <1.422, 13.272, -0.304> 
		<1.407, 13.224, -0.282> <1.422, 13.227, -0.281> <1.424, 13.245, -0.289> <1.423, 13.259, -0.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, 13.284, -0.314> <1.406, 13.262, -0.344> <1.412, 13.233, -0.384> <1.421, 13.211, -0.412> 
		<1.415, 13.286, -0.314> <1.421, 13.264, -0.343> <1.421, 13.236, -0.380> <1.430, 13.214, -0.409> 
		<1.422, 13.272, -0.304> <1.427, 13.254, -0.333> <1.432, 13.228, -0.373> <1.439, 13.209, -0.401> 
		<1.423, 13.259, -0.297> <1.428, 13.241, -0.326> <1.432, 13.219, -0.367> <1.440, 13.200, -0.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 13.259, -0.297> <1.428, 13.241, -0.326> <1.432, 13.219, -0.367> <1.440, 13.200, -0.396> 
		<1.424, 13.245, -0.289> <1.429, 13.228, -0.319> <1.433, 13.211, -0.362> <1.441, 13.192, -0.390> 
		<1.422, 13.227, -0.281> <1.428, 13.213, -0.314> <1.425, 13.198, -0.357> <1.433, 13.182, -0.388> 
		<1.407, 13.224, -0.282> <1.412, 13.211, -0.315> <1.416, 13.195, -0.360> <1.424, 13.179, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.405, 13.190, -0.407> <1.406, 13.181, -0.402> <1.415, 13.176, -0.395> <1.424, 13.179, -0.391> 
		<1.414, 13.177, -0.428> <1.415, 13.168, -0.422> <1.421, 13.164, -0.418> <1.430, 13.167, -0.415> 
		<1.428, 13.160, -0.456> <1.429, 13.153, -0.452> <1.437, 13.149, -0.445> <1.445, 13.150, -0.444> 
		<1.438, 13.142, -0.470> <1.439, 13.135, -0.466> <1.446, 13.130, -0.462> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.405, 13.190, -0.407> <1.414, 13.177, -0.428> <1.428, 13.160, -0.456> <1.438, 13.142, -0.470> 
		<1.404, 13.198, -0.413> <1.413, 13.185, -0.433> <1.427, 13.167, -0.460> <1.437, 13.148, -0.474> 
		<1.412, 13.208, -0.415> <1.418, 13.192, -0.435> <1.435, 13.176, -0.463> <1.443, 13.155, -0.477> 
		<1.421, 13.211, -0.412> <1.427, 13.195, -0.432> <1.443, 13.178, -0.462> <1.451, 13.156, -0.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.421, 13.211, -0.412> <1.427, 13.195, -0.432> <1.443, 13.178, -0.462> <1.451, 13.156, -0.476> 
		<1.430, 13.214, -0.409> <1.437, 13.198, -0.429> <1.450, 13.179, -0.461> <1.459, 13.158, -0.475> 
		<1.439, 13.209, -0.401> <1.445, 13.194, -0.424> <1.459, 13.174, -0.454> <1.466, 13.153, -0.471> 
		<1.440, 13.200, -0.396> <1.446, 13.185, -0.419> <1.460, 13.168, -0.450> <1.467, 13.146, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.440, 13.200, -0.396> <1.446, 13.185, -0.419> <1.460, 13.168, -0.450> <1.467, 13.146, -0.467> 
		<1.441, 13.192, -0.390> <1.446, 13.177, -0.413> <1.461, 13.161, -0.446> <1.468, 13.139, -0.463> 
		<1.433, 13.182, -0.388> <1.440, 13.170, -0.412> <1.453, 13.151, -0.443> <1.462, 13.133, -0.461> 
		<1.424, 13.179, -0.391> <1.430, 13.167, -0.415> <1.445, 13.150, -0.444> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.476, 13.065, -0.511> <1.455, 13.112, -0.493> <1.438, 13.142, -0.470> 
		<1.485, 13.066, -0.510> <1.469, 13.099, -0.493> <1.455, 13.105, -0.489> <1.439, 13.135, -0.466> 
		<1.476, 13.116, -0.491> <1.477, 13.109, -0.487> <1.454, 13.131, -0.461> <1.446, 13.130, -0.462> 
		<1.467, 13.146, -0.467> <1.468, 13.139, -0.463> <1.462, 13.133, -0.461> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.481, 13.062, -0.508> <1.465, 13.095, -0.491> <1.465, 13.095, -0.491> <1.476, 13.065, -0.511> 
		<1.466, 13.105, -0.486> <1.458, 13.104, -0.486> <1.455, 13.105, -0.489> <1.455, 13.112, -0.493> 
		<1.454, 13.131, -0.461> <1.446, 13.130, -0.462> <1.439, 13.135, -0.466> <1.438, 13.142, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.485, 13.066, -0.510> <1.476, 13.116, -0.491> <1.467, 13.146, -0.467> 
		<1.476, 13.065, -0.511> <1.469, 13.099, -0.493> <1.476, 13.123, -0.495> <1.466, 13.153, -0.471> 
		<1.455, 13.112, -0.493> <1.454, 13.119, -0.497> <1.451, 13.156, -0.476> <1.459, 13.158, -0.475> 
		<1.438, 13.142, -0.470> <1.437, 13.148, -0.474> <1.443, 13.155, -0.477> <1.451, 13.156, -0.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.476, 13.065, -0.511> <1.464, 13.102, -0.495> <1.464, 13.102, -0.495> <1.480, 13.069, -0.513> 
		<1.455, 13.112, -0.493> <1.454, 13.119, -0.497> <1.457, 13.121, -0.499> <1.465, 13.123, -0.498> 
		<1.438, 13.142, -0.470> <1.437, 13.148, -0.474> <1.443, 13.155, -0.477> <1.451, 13.156, -0.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.481, 13.062, -0.508> <1.466, 13.105, -0.486> <1.454, 13.131, -0.461> 
		<1.480, 13.069, -0.513> <1.469, 13.099, -0.493> <1.474, 13.106, -0.485> <1.462, 13.133, -0.461> 
		<1.465, 13.123, -0.498> <1.472, 13.124, -0.497> <1.467, 13.146, -0.467> <1.468, 13.139, -0.463> 
		<1.451, 13.156, -0.476> <1.459, 13.158, -0.475> <1.466, 13.153, -0.471> <1.467, 13.146, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.485, 13.066, -0.510> <1.473, 13.096, -0.490> <1.473, 13.096, -0.490> <1.481, 13.062, -0.508> 
		<1.476, 13.116, -0.491> <1.477, 13.109, -0.487> <1.474, 13.106, -0.485> <1.466, 13.105, -0.486> 
		<1.467, 13.146, -0.467> <1.468, 13.139, -0.463> <1.462, 13.133, -0.461> <1.454, 13.131, -0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.481, 13.062, -0.508> <1.466, 13.105, -0.486> <1.454, 13.131, -0.461> 
		<1.480, 13.069, -0.513> <1.469, 13.099, -0.493> <1.458, 13.104, -0.486> <1.446, 13.130, -0.462> 
		<1.465, 13.123, -0.498> <1.457, 13.121, -0.499> <1.438, 13.142, -0.470> <1.439, 13.135, -0.466> 
		<1.451, 13.156, -0.476> <1.443, 13.155, -0.477> <1.437, 13.148, -0.474> <1.438, 13.142, -0.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> <1.493, 13.032, -0.529> 
		<1.480, 13.069, -0.513> <1.472, 13.103, -0.494> <1.472, 13.103, -0.494> <1.485, 13.066, -0.510> 
		<1.465, 13.123, -0.498> <1.472, 13.124, -0.497> <1.476, 13.123, -0.495> <1.476, 13.116, -0.491> 
		<1.451, 13.156, -0.476> <1.459, 13.158, -0.475> <1.466, 13.153, -0.471> <1.467, 13.146, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.439, 13.311, -0.261> <1.503, 13.327, -0.275> <1.587, 13.346, -0.299> <1.651, 13.363, -0.309> 
		<1.427, 13.321, -0.291> <1.491, 13.336, -0.306> <1.582, 13.360, -0.310> <1.646, 13.376, -0.320> 
		<1.428, 13.375, -0.272> <1.489, 13.378, -0.288> <1.579, 13.388, -0.305> <1.641, 13.397, -0.317> 
		<1.434, 13.398, -0.248> <1.496, 13.401, -0.264> <1.577, 13.399, -0.291> <1.639, 13.407, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.434, 13.398, -0.248> <1.496, 13.401, -0.264> <1.577, 13.399, -0.291> <1.639, 13.407, -0.303> 
		<1.439, 13.415, -0.230> <1.500, 13.418, -0.247> <1.576, 13.410, -0.277> <1.638, 13.418, -0.289> 
		<1.457, 13.405, -0.186> <1.513, 13.412, -0.206> <1.583, 13.407, -0.253> <1.641, 13.416, -0.268> 
		<1.458, 13.380, -0.190> <1.514, 13.387, -0.210> <1.588, 13.393, -0.242> <1.646, 13.403, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.651, 13.363, -0.309> <1.705, 13.377, -0.318> <1.777, 13.402, -0.313> <1.831, 13.414, -0.323> 
		<1.656, 13.350, -0.299> <1.710, 13.364, -0.307> <1.780, 13.392, -0.305> <1.834, 13.404, -0.315> 
		<1.659, 13.348, -0.278> <1.709, 13.362, -0.286> <1.782, 13.388, -0.285> <1.831, 13.400, -0.300> 
		<1.658, 13.359, -0.264> <1.708, 13.373, -0.271> <1.775, 13.395, -0.274> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.651, 13.363, -0.309> <1.646, 13.376, -0.320> <1.641, 13.397, -0.317> <1.639, 13.407, -0.303> 
		<1.705, 13.377, -0.318> <1.700, 13.391, -0.329> <1.693, 13.403, -0.327> <1.691, 13.414, -0.313> 
		<1.777, 13.402, -0.313> <1.773, 13.414, -0.321> <1.767, 13.435, -0.321> <1.760, 13.442, -0.310> 
		<1.831, 13.414, -0.323> <1.827, 13.426, -0.332> <1.819, 13.441, -0.332> <1.812, 13.448, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.639, 13.407, -0.303> <1.638, 13.418, -0.289> <1.641, 13.416, -0.268> <1.646, 13.403, -0.258> 
		<1.691, 13.414, -0.313> <1.690, 13.425, -0.299> <1.688, 13.424, -0.281> <1.693, 13.411, -0.271> 
		<1.760, 13.442, -0.310> <1.753, 13.448, -0.299> <1.756, 13.442, -0.279> <1.759, 13.431, -0.270> 
		<1.812, 13.448, -0.321> <1.805, 13.454, -0.310> <1.803, 13.448, -0.294> <1.807, 13.437, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.646, 13.403, -0.258> <1.651, 13.390, -0.247> <1.656, 13.369, -0.250> <1.658, 13.359, -0.264> 
		<1.693, 13.411, -0.271> <1.698, 13.397, -0.260> <1.706, 13.384, -0.257> <1.708, 13.373, -0.271> 
		<1.759, 13.431, -0.270> <1.762, 13.420, -0.262> <1.769, 13.401, -0.264> <1.775, 13.395, -0.274> 
		<1.807, 13.437, -0.285> <1.810, 13.426, -0.277> <1.818, 13.412, -0.279> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <1.998, 13.453, -0.362> <1.891, 13.448, -0.312> <1.807, 13.437, -0.285> 
		<2.005, 13.446, -0.373> <1.923, 13.439, -0.340> <1.894, 13.437, -0.304> <1.810, 13.426, -0.277> 
		<1.906, 13.432, -0.338> <1.910, 13.421, -0.330> <1.824, 13.406, -0.289> <1.818, 13.412, -0.279> 
		<1.831, 13.414, -0.323> <1.834, 13.404, -0.315> <1.831, 13.400, -0.300> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<2.004, 13.444, -0.363> <1.929, 13.430, -0.342> <1.929, 13.430, -0.342> <2.005, 13.446, -0.373> 
		<1.903, 13.425, -0.314> <1.910, 13.419, -0.324> <1.910, 13.421, -0.330> <1.906, 13.432, -0.338> 
		<1.824, 13.406, -0.289> <1.831, 13.400, -0.300> <1.834, 13.404, -0.315> <1.831, 13.414, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.005, 13.446, -0.373> <1.906, 13.432, -0.338> <1.831, 13.414, -0.323> 
		<1.998, 13.453, -0.362> <1.923, 13.439, -0.340> <1.903, 13.443, -0.347> <1.827, 13.426, -0.332> 
		<1.891, 13.448, -0.312> <1.887, 13.459, -0.320> <1.812, 13.448, -0.321> <1.819, 13.441, -0.332> 
		<1.807, 13.437, -0.285> <1.803, 13.448, -0.294> <1.805, 13.454, -0.310> <1.812, 13.448, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<2.000, 13.456, -0.372> <1.925, 13.443, -0.351> <1.925, 13.443, -0.351> <2.005, 13.446, -0.373> 
		<1.893, 13.458, -0.338> <1.900, 13.451, -0.349> <1.903, 13.443, -0.347> <1.906, 13.432, -0.338> 
		<1.812, 13.448, -0.321> <1.819, 13.441, -0.332> <1.827, 13.426, -0.332> <1.831, 13.414, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.004, 13.444, -0.363> <1.903, 13.425, -0.314> <1.824, 13.406, -0.289> 
		<2.000, 13.456, -0.372> <1.923, 13.440, -0.341> <1.897, 13.431, -0.303> <1.818, 13.412, -0.279> 
		<1.893, 13.458, -0.338> <1.886, 13.464, -0.327> <1.806, 13.438, -0.286> <1.810, 13.426, -0.277> 
		<1.812, 13.448, -0.321> <1.805, 13.454, -0.310> <1.803, 13.448, -0.294> <1.807, 13.437, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<1.998, 13.453, -0.362> <1.921, 13.437, -0.330> <1.921, 13.437, -0.330> <2.004, 13.444, -0.363> 
		<1.891, 13.448, -0.312> <1.894, 13.437, -0.304> <1.897, 13.431, -0.303> <1.903, 13.425, -0.314> 
		<1.807, 13.437, -0.285> <1.810, 13.426, -0.277> <1.818, 13.412, -0.279> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.004, 13.444, -0.363> <1.903, 13.425, -0.314> <1.824, 13.406, -0.289> 
		<2.000, 13.456, -0.372> <1.923, 13.440, -0.341> <1.910, 13.419, -0.324> <1.831, 13.400, -0.300> 
		<1.893, 13.458, -0.338> <1.900, 13.451, -0.349> <1.830, 13.415, -0.324> <1.834, 13.404, -0.315> 
		<1.812, 13.448, -0.321> <1.819, 13.441, -0.332> <1.827, 13.426, -0.332> <1.831, 13.414, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<1.998, 13.453, -0.362> <1.918, 13.449, -0.340> <1.918, 13.449, -0.340> <2.000, 13.456, -0.372> 
		<1.891, 13.448, -0.312> <1.887, 13.459, -0.320> <1.886, 13.464, -0.327> <1.893, 13.458, -0.338> 
		<1.807, 13.437, -0.285> <1.803, 13.448, -0.294> <1.805, 13.454, -0.310> <1.812, 13.448, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.618, 13.367, -0.280> <1.610, 13.382, -0.289> <1.620, 13.402, -0.296> <1.637, 13.412, -0.295> 
		<1.626, 13.352, -0.271> <1.618, 13.367, -0.280> <1.629, 13.397, -0.290> <1.646, 13.408, -0.289> 
		<1.649, 13.349, -0.263> <1.662, 13.358, -0.262> <1.665, 13.390, -0.275> <1.658, 13.402, -0.282> 
		<1.665, 13.360, -0.262> <1.679, 13.368, -0.261> <1.674, 13.386, -0.269> <1.667, 13.398, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.618, 13.367, -0.280> <1.618, 13.367, -0.280> <1.618, 13.367, -0.280> <1.618, 13.367, -0.280> 
		<1.610, 13.382, -0.289> <1.618, 13.367, -0.280> <1.618, 13.367, -0.280> <1.626, 13.352, -0.271> 
		<1.620, 13.402, -0.296> <1.629, 13.386, -0.286> <1.640, 13.365, -0.273> <1.649, 13.349, -0.263> 
		<1.637, 13.412, -0.295> <1.645, 13.396, -0.285> <1.657, 13.375, -0.272> <1.665, 13.360, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.637, 13.412, -0.295> <1.637, 13.412, -0.295> <1.637, 13.412, -0.295> <1.637, 13.412, -0.295> 
		<1.649, 13.420, -0.294> <1.658, 13.404, -0.284> <1.658, 13.404, -0.284> <1.645, 13.396, -0.285> 
		<1.661, 13.409, -0.284> <1.667, 13.397, -0.276> <1.670, 13.384, -0.271> <1.657, 13.375, -0.272> 
		<1.667, 13.398, -0.277> <1.674, 13.386, -0.269> <1.679, 13.368, -0.261> <1.665, 13.360, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.439, 13.311, -0.261> <1.439, 13.311, -0.261> <1.439, 13.311, -0.261> <1.439, 13.311, -0.261> 
		<1.451, 13.286, -0.241> <1.440, 13.311, -0.261> <1.440, 13.311, -0.261> <1.428, 13.336, -0.281> 
		<1.469, 13.288, -0.203> <1.456, 13.314, -0.224> <1.440, 13.349, -0.251> <1.428, 13.375, -0.272> 
		<1.475, 13.312, -0.179> <1.463, 13.338, -0.200> <1.446, 13.372, -0.227> <1.434, 13.398, -0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.439, 13.311, -0.261> <1.451, 13.286, -0.241> <1.469, 13.288, -0.203> <1.475, 13.312, -0.179> 
		<1.503, 13.327, -0.275> <1.515, 13.302, -0.255> <1.523, 13.302, -0.229> <1.530, 13.326, -0.205> 
		<1.587, 13.346, -0.299> <1.592, 13.333, -0.288> <1.602, 13.332, -0.260> <1.600, 13.343, -0.246> 
		<1.651, 13.363, -0.309> <1.656, 13.350, -0.299> <1.659, 13.348, -0.278> <1.658, 13.359, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.439, 13.311, -0.261> <1.503, 13.327, -0.275> <1.587, 13.346, -0.299> <1.651, 13.363, -0.309> 
		<1.428, 13.336, -0.281> <1.491, 13.352, -0.295> <1.582, 13.360, -0.310> <1.646, 13.376, -0.320> 
		<1.428, 13.375, -0.272> <1.489, 13.378, -0.288> <1.578, 13.389, -0.306> <1.641, 13.397, -0.317> 
		<1.434, 13.398, -0.248> <1.496, 13.401, -0.264> <1.577, 13.400, -0.291> <1.639, 13.407, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.434, 13.398, -0.248> <1.434, 13.398, -0.248> <1.434, 13.398, -0.248> <1.434, 13.398, -0.248> 
		<1.446, 13.372, -0.227> <1.451, 13.389, -0.209> <1.451, 13.389, -0.209> <1.439, 13.415, -0.230> 
		<1.463, 13.338, -0.200> <1.468, 13.356, -0.180> <1.459, 13.378, -0.188> <1.449, 13.399, -0.205> 
		<1.475, 13.312, -0.179> <1.480, 13.330, -0.160> <1.468, 13.360, -0.174> <1.458, 13.380, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.434, 13.398, -0.248> <1.496, 13.401, -0.264> <1.577, 13.400, -0.291> <1.639, 13.407, -0.303> 
		<1.439, 13.415, -0.230> <1.500, 13.418, -0.247> <1.575, 13.410, -0.277> <1.638, 13.418, -0.289> 
		<1.449, 13.399, -0.205> <1.506, 13.405, -0.225> <1.583, 13.407, -0.253> <1.641, 13.416, -0.268> 
		<1.458, 13.380, -0.190> <1.514, 13.387, -0.210> <1.588, 13.393, -0.242> <1.646, 13.403, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.458, 13.380, -0.190> <1.514, 13.387, -0.210> <1.588, 13.393, -0.242> <1.646, 13.403, -0.258> 
		<1.468, 13.360, -0.174> <1.524, 13.367, -0.194> <1.593, 13.380, -0.231> <1.651, 13.390, -0.247> 
		<1.480, 13.330, -0.160> <1.535, 13.345, -0.185> <1.599, 13.354, -0.232> <1.656, 13.369, -0.250> 
		<1.475, 13.312, -0.179> <1.530, 13.326, -0.205> <1.600, 13.343, -0.246> <1.658, 13.359, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.651, 13.363, -0.309> <1.656, 13.350, -0.299> <1.659, 13.348, -0.278> <1.658, 13.359, -0.264> 
		<1.705, 13.377, -0.318> <1.710, 13.364, -0.307> <1.708, 13.361, -0.293> <1.706, 13.372, -0.279> 
		<1.777, 13.402, -0.313> <1.780, 13.392, -0.304> <1.782, 13.388, -0.285> <1.775, 13.395, -0.274> 
		<1.831, 13.414, -0.323> <1.834, 13.404, -0.315> <1.831, 13.400, -0.300> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.651, 13.363, -0.309> <1.705, 13.377, -0.318> <1.777, 13.402, -0.313> <1.831, 13.414, -0.323> 
		<1.646, 13.376, -0.320> <1.700, 13.391, -0.329> <1.774, 13.413, -0.321> <1.827, 13.425, -0.332> 
		<1.641, 13.397, -0.317> <1.693, 13.403, -0.327> <1.767, 13.433, -0.319> <1.819, 13.439, -0.330> 
		<1.639, 13.407, -0.303> <1.691, 13.414, -0.313> <1.761, 13.439, -0.309> <1.813, 13.445, -0.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.639, 13.407, -0.303> <1.691, 13.414, -0.313> <1.761, 13.439, -0.309> <1.813, 13.445, -0.319> 
		<1.638, 13.418, -0.289> <1.690, 13.425, -0.299> <1.754, 13.445, -0.298> <1.806, 13.451, -0.309> 
		<1.641, 13.416, -0.268> <1.688, 13.424, -0.281> <1.756, 13.441, -0.279> <1.803, 13.447, -0.293> 
		<1.646, 13.403, -0.258> <1.693, 13.411, -0.271> <1.759, 13.431, -0.270> <1.807, 13.437, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.646, 13.403, -0.258> <1.693, 13.411, -0.271> <1.759, 13.431, -0.270> <1.807, 13.437, -0.285> 
		<1.651, 13.390, -0.247> <1.698, 13.397, -0.260> <1.762, 13.420, -0.262> <1.810, 13.426, -0.277> 
		<1.656, 13.369, -0.250> <1.705, 13.383, -0.265> <1.769, 13.401, -0.264> <1.818, 13.412, -0.279> 
		<1.658, 13.359, -0.264> <1.706, 13.372, -0.279> <1.775, 13.395, -0.274> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.005, 13.446, -0.373> <1.906, 13.432, -0.338> <1.831, 13.414, -0.323> 
		<1.998, 13.453, -0.362> <1.923, 13.439, -0.340> <1.909, 13.421, -0.330> <1.834, 13.404, -0.315> 
		<1.891, 13.448, -0.312> <1.894, 13.437, -0.303> <1.824, 13.406, -0.289> <1.831, 13.400, -0.300> 
		<1.807, 13.437, -0.285> <1.810, 13.426, -0.277> <1.818, 13.412, -0.279> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<2.004, 13.444, -0.363> <1.929, 13.430, -0.342> <1.929, 13.430, -0.342> <2.005, 13.446, -0.373> 
		<1.903, 13.425, -0.314> <1.910, 13.419, -0.324> <1.909, 13.421, -0.330> <1.906, 13.432, -0.338> 
		<1.824, 13.406, -0.289> <1.831, 13.400, -0.300> <1.834, 13.404, -0.315> <1.831, 13.414, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <1.998, 13.453, -0.362> <1.891, 13.448, -0.312> <1.807, 13.437, -0.285> 
		<2.005, 13.446, -0.373> <1.923, 13.439, -0.340> <1.887, 13.458, -0.320> <1.803, 13.447, -0.293> 
		<1.906, 13.432, -0.338> <1.903, 13.442, -0.347> <1.813, 13.445, -0.319> <1.806, 13.451, -0.309> 
		<1.831, 13.414, -0.323> <1.827, 13.425, -0.332> <1.819, 13.439, -0.330> <1.813, 13.445, -0.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<2.005, 13.446, -0.373> <1.925, 13.442, -0.351> <1.925, 13.442, -0.351> <2.000, 13.456, -0.372> 
		<1.906, 13.432, -0.338> <1.903, 13.442, -0.347> <1.901, 13.449, -0.347> <1.894, 13.455, -0.336> 
		<1.831, 13.414, -0.323> <1.827, 13.425, -0.332> <1.819, 13.439, -0.330> <1.813, 13.445, -0.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.004, 13.444, -0.363> <1.903, 13.425, -0.314> <1.824, 13.406, -0.289> 
		<2.000, 13.456, -0.372> <1.923, 13.439, -0.340> <1.897, 13.431, -0.303> <1.818, 13.412, -0.279> 
		<1.894, 13.455, -0.336> <1.887, 13.461, -0.326> <1.807, 13.437, -0.285> <1.810, 13.426, -0.277> 
		<1.813, 13.445, -0.319> <1.806, 13.451, -0.309> <1.803, 13.447, -0.293> <1.807, 13.437, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<1.998, 13.453, -0.362> <1.921, 13.437, -0.330> <1.921, 13.437, -0.330> <2.004, 13.444, -0.363> 
		<1.891, 13.448, -0.312> <1.894, 13.437, -0.303> <1.897, 13.431, -0.303> <1.903, 13.425, -0.314> 
		<1.807, 13.437, -0.285> <1.810, 13.426, -0.277> <1.818, 13.412, -0.279> <1.824, 13.406, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.004, 13.444, -0.363> <1.903, 13.425, -0.314> <1.824, 13.406, -0.289> 
		<2.000, 13.456, -0.372> <1.923, 13.439, -0.340> <1.910, 13.419, -0.324> <1.831, 13.400, -0.300> 
		<1.894, 13.455, -0.336> <1.901, 13.449, -0.347> <1.831, 13.414, -0.323> <1.834, 13.404, -0.315> 
		<1.813, 13.445, -0.319> <1.819, 13.439, -0.330> <1.827, 13.425, -0.332> <1.831, 13.414, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> <2.080, 13.460, -0.395> 
		<2.000, 13.456, -0.372> <1.918, 13.449, -0.339> <1.918, 13.449, -0.339> <1.998, 13.453, -0.362> 
		<1.894, 13.455, -0.336> <1.887, 13.461, -0.326> <1.887, 13.458, -0.320> <1.891, 13.448, -0.312> 
		<1.813, 13.445, -0.319> <1.806, 13.451, -0.309> <1.803, 13.447, -0.293> <1.807, 13.437, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.618, 13.367, -0.280> <1.610, 13.382, -0.289> <1.620, 13.402, -0.296> <1.637, 13.412, -0.295> 
		<1.626, 13.352, -0.271> <1.618, 13.367, -0.280> <1.629, 13.397, -0.290> <1.646, 13.408, -0.289> 
		<1.649, 13.349, -0.263> <1.662, 13.358, -0.262> <1.665, 13.390, -0.275> <1.658, 13.402, -0.282> 
		<1.665, 13.360, -0.262> <1.679, 13.368, -0.261> <1.674, 13.386, -0.269> <1.667, 13.398, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.618, 13.367, -0.280> <1.618, 13.367, -0.280> <1.618, 13.367, -0.280> <1.618, 13.367, -0.280> 
		<1.610, 13.382, -0.289> <1.618, 13.367, -0.280> <1.618, 13.367, -0.280> <1.626, 13.352, -0.271> 
		<1.620, 13.402, -0.296> <1.629, 13.386, -0.286> <1.640, 13.365, -0.273> <1.649, 13.349, -0.263> 
		<1.637, 13.412, -0.295> <1.645, 13.396, -0.285> <1.657, 13.375, -0.272> <1.665, 13.360, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.637, 13.412, -0.295> <1.637, 13.412, -0.295> <1.637, 13.412, -0.295> <1.637, 13.412, -0.295> 
		<1.649, 13.420, -0.294> <1.658, 13.404, -0.284> <1.658, 13.404, -0.284> <1.645, 13.396, -0.285> 
		<1.661, 13.409, -0.284> <1.667, 13.397, -0.276> <1.670, 13.384, -0.271> <1.657, 13.375, -0.272> 
		<1.667, 13.398, -0.277> <1.674, 13.386, -0.269> <1.679, 13.368, -0.261> <1.665, 13.360, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.894, 13.219, -0.261> <0.906, 13.284, -0.275> <0.909, 13.372, -0.298> <0.933, 13.434, -0.309> 
		<0.881, 13.212, -0.291> <0.892, 13.276, -0.306> <0.895, 13.373, -0.309> <0.919, 13.434, -0.320> 
		<0.831, 13.235, -0.272> <0.854, 13.292, -0.288> <0.869, 13.382, -0.305> <0.898, 13.438, -0.317> 
		<0.813, 13.250, -0.248> <0.835, 13.307, -0.264> <0.858, 13.385, -0.291> <0.888, 13.441, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.813, 13.250, -0.248> <0.835, 13.307, -0.264> <0.858, 13.385, -0.291> <0.888, 13.441, -0.303> 
		<0.799, 13.261, -0.230> <0.822, 13.318, -0.247> <0.848, 13.388, -0.277> <0.877, 13.444, -0.289> 
		<0.816, 13.273, -0.186> <0.832, 13.327, -0.206> <0.854, 13.394, -0.253> <0.880, 13.446, -0.268> 
		<0.839, 13.264, -0.190> <0.856, 13.318, -0.210> <0.868, 13.393, -0.242> <0.895, 13.445, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.933, 13.434, -0.309> <0.951, 13.481, -0.318> <1.013, 13.526, -0.312> <1.029, 13.573, -0.323> 
		<0.947, 13.433, -0.299> <0.965, 13.480, -0.307> <1.022, 13.520, -0.304> <1.038, 13.567, -0.315> 
		<0.950, 13.435, -0.278> <0.977, 13.472, -0.286> <1.024, 13.520, -0.284> <1.038, 13.562, -0.300> 
		<0.940, 13.438, -0.264> <0.967, 13.475, -0.271> <1.015, 13.521, -0.273> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.933, 13.434, -0.309> <0.919, 13.434, -0.320> <0.898, 13.438, -0.317> <0.888, 13.441, -0.303> 
		<0.951, 13.481, -0.318> <0.937, 13.481, -0.328> <0.924, 13.485, -0.328> <0.913, 13.488, -0.313> 
		<1.013, 13.526, -0.312> <1.003, 13.533, -0.321> <0.980, 13.540, -0.319> <0.971, 13.541, -0.308> 
		<1.029, 13.573, -0.323> <1.020, 13.580, -0.332> <1.004, 13.588, -0.332> <0.994, 13.589, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.888, 13.441, -0.303> <0.877, 13.444, -0.289> <0.880, 13.446, -0.268> <0.895, 13.445, -0.258> 
		<0.913, 13.488, -0.313> <0.903, 13.491, -0.299> <0.902, 13.489, -0.282> <0.917, 13.489, -0.271> 
		<0.971, 13.541, -0.308> <0.961, 13.542, -0.297> <0.967, 13.541, -0.276> <0.976, 13.534, -0.268> 
		<0.994, 13.589, -0.321> <0.985, 13.590, -0.310> <0.987, 13.584, -0.294> <0.997, 13.577, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.895, 13.445, -0.258> <0.909, 13.444, -0.247> <0.929, 13.441, -0.250> <0.940, 13.438, -0.264> 
		<0.917, 13.489, -0.271> <0.931, 13.488, -0.260> <0.956, 13.478, -0.257> <0.967, 13.475, -0.271> 
		<0.976, 13.534, -0.268> <0.985, 13.527, -0.260> <1.006, 13.522, -0.263> <1.015, 13.521, -0.273> 
		<0.997, 13.577, -0.285> <1.006, 13.570, -0.277> <1.020, 13.564, -0.279> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.037, 13.721, -0.362> <1.026, 13.638, -0.310> <0.997, 13.577, -0.285> 
		<1.047, 13.720, -0.373> <1.030, 13.658, -0.340> <1.035, 13.631, -0.302> <1.006, 13.570, -0.277> 
		<1.051, 13.635, -0.338> <1.060, 13.628, -0.330> <1.029, 13.563, -0.289> <1.020, 13.564, -0.279> 
		<1.029, 13.573, -0.323> <1.038, 13.567, -0.315> <1.038, 13.562, -0.300> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.047, 13.717, -0.363> <1.039, 13.654, -0.342> <1.039, 13.654, -0.342> <1.047, 13.720, -0.373> 
		<1.051, 13.629, -0.314> <1.060, 13.628, -0.325> <1.060, 13.628, -0.330> <1.051, 13.635, -0.338> 
		<1.029, 13.563, -0.289> <1.038, 13.562, -0.300> <1.038, 13.567, -0.315> <1.029, 13.573, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.047, 13.720, -0.373> <1.051, 13.635, -0.338> <1.029, 13.573, -0.323> 
		<1.037, 13.721, -0.362> <1.030, 13.658, -0.340> <1.041, 13.642, -0.347> <1.020, 13.580, -0.332> 
		<1.026, 13.638, -0.310> <1.016, 13.645, -0.319> <0.994, 13.589, -0.321> <1.004, 13.588, -0.332> 
		<0.997, 13.577, -0.285> <0.987, 13.584, -0.294> <0.985, 13.590, -0.310> <0.994, 13.589, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.036, 13.725, -0.372> <1.029, 13.662, -0.351> <1.029, 13.662, -0.351> <1.047, 13.720, -0.373> 
		<1.022, 13.645, -0.336> <1.031, 13.644, -0.347> <1.041, 13.642, -0.347> <1.051, 13.635, -0.338> 
		<0.994, 13.589, -0.321> <1.004, 13.588, -0.332> <1.020, 13.580, -0.332> <1.029, 13.573, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.047, 13.717, -0.363> <1.051, 13.629, -0.314> <1.029, 13.563, -0.289> 
		<1.036, 13.725, -0.372> <1.029, 13.659, -0.341> <1.042, 13.630, -0.304> <1.020, 13.564, -0.279> 
		<1.022, 13.645, -0.336> <1.012, 13.646, -0.325> <0.996, 13.577, -0.286> <1.006, 13.570, -0.277> 
		<0.994, 13.589, -0.321> <0.985, 13.590, -0.310> <0.987, 13.584, -0.294> <0.997, 13.577, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.037, 13.721, -0.362> <1.030, 13.655, -0.330> <1.030, 13.655, -0.330> <1.047, 13.717, -0.363> 
		<1.026, 13.638, -0.310> <1.035, 13.631, -0.302> <1.042, 13.630, -0.304> <1.051, 13.629, -0.314> 
		<0.997, 13.577, -0.285> <1.006, 13.570, -0.277> <1.020, 13.564, -0.279> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.047, 13.717, -0.363> <1.051, 13.629, -0.314> <1.029, 13.563, -0.289> 
		<1.036, 13.725, -0.372> <1.029, 13.659, -0.341> <1.060, 13.628, -0.325> <1.038, 13.562, -0.300> 
		<1.022, 13.645, -0.336> <1.031, 13.644, -0.347> <1.029, 13.574, -0.324> <1.038, 13.567, -0.315> 
		<0.994, 13.589, -0.321> <1.004, 13.588, -0.332> <1.020, 13.580, -0.332> <1.029, 13.573, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.037, 13.721, -0.362> <1.019, 13.663, -0.340> <1.019, 13.663, -0.340> <1.036, 13.725, -0.372> 
		<1.026, 13.638, -0.310> <1.016, 13.645, -0.319> <1.012, 13.646, -0.325> <1.022, 13.645, -0.336> 
		<0.997, 13.577, -0.285> <0.987, 13.584, -0.294> <0.985, 13.590, -0.310> <0.994, 13.589, -0.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.916, 13.405, -0.280> <0.899, 13.404, -0.289> <0.885, 13.421, -0.296> <0.883, 13.440, -0.295> 
		<0.933, 13.406, -0.271> <0.916, 13.405, -0.280> <0.893, 13.428, -0.290> <0.890, 13.447, -0.289> 
		<0.945, 13.426, -0.263> <0.942, 13.442, -0.262> <0.914, 13.457, -0.275> <0.900, 13.456, -0.282> 
		<0.942, 13.445, -0.262> <0.940, 13.461, -0.261> <0.921, 13.463, -0.269> <0.907, 13.462, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.916, 13.405, -0.280> <0.916, 13.405, -0.280> <0.916, 13.405, -0.280> <0.916, 13.405, -0.280> 
		<0.899, 13.404, -0.289> <0.916, 13.405, -0.280> <0.916, 13.405, -0.280> <0.933, 13.406, -0.271> 
		<0.885, 13.421, -0.296> <0.903, 13.423, -0.286> <0.927, 13.424, -0.273> <0.945, 13.426, -0.263> 
		<0.883, 13.440, -0.295> <0.900, 13.442, -0.285> <0.924, 13.444, -0.272> <0.942, 13.445, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.883, 13.440, -0.295> <0.883, 13.440, -0.295> <0.883, 13.440, -0.295> <0.883, 13.440, -0.295> 
		<0.880, 13.455, -0.294> <0.898, 13.456, -0.284> <0.898, 13.456, -0.284> <0.900, 13.442, -0.285> 
		<0.895, 13.461, -0.284> <0.909, 13.462, -0.276> <0.922, 13.460, -0.271> <0.924, 13.444, -0.272> 
		<0.907, 13.462, -0.277> <0.921, 13.463, -0.269> <0.940, 13.461, -0.261> <0.942, 13.445, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.894, 13.219, -0.261> <0.894, 13.219, -0.261> <0.894, 13.219, -0.261> <0.894, 13.219, -0.261> 
		<0.922, 13.220, -0.241> <0.895, 13.219, -0.261> <0.895, 13.219, -0.261> <0.867, 13.219, -0.281> 
		<0.927, 13.236, -0.203> <0.899, 13.236, -0.224> <0.860, 13.235, -0.251> <0.831, 13.235, -0.272> 
		<0.908, 13.252, -0.179> <0.880, 13.251, -0.200> <0.842, 13.250, -0.227> <0.813, 13.250, -0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.894, 13.219, -0.261> <0.922, 13.220, -0.241> <0.927, 13.236, -0.203> <0.908, 13.252, -0.179> 
		<0.906, 13.284, -0.275> <0.934, 13.284, -0.255> <0.937, 13.292, -0.229> <0.918, 13.308, -0.205> 
		<0.909, 13.372, -0.298> <0.924, 13.371, -0.288> <0.929, 13.380, -0.258> <0.918, 13.383, -0.244> 
		<0.933, 13.434, -0.309> <0.947, 13.433, -0.299> <0.950, 13.435, -0.278> <0.940, 13.438, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.894, 13.219, -0.261> <0.906, 13.284, -0.275> <0.909, 13.372, -0.298> <0.933, 13.434, -0.309> 
		<0.867, 13.219, -0.281> <0.878, 13.283, -0.295> <0.895, 13.373, -0.309> <0.919, 13.434, -0.320> 
		<0.831, 13.235, -0.272> <0.854, 13.292, -0.288> <0.868, 13.383, -0.306> <0.898, 13.438, -0.317> 
		<0.813, 13.250, -0.248> <0.835, 13.307, -0.264> <0.858, 13.386, -0.292> <0.888, 13.441, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.813, 13.250, -0.248> <0.813, 13.250, -0.248> <0.813, 13.250, -0.248> <0.813, 13.250, -0.248> 
		<0.842, 13.250, -0.227> <0.828, 13.262, -0.209> <0.828, 13.262, -0.209> <0.799, 13.261, -0.230> 
		<0.880, 13.251, -0.200> <0.865, 13.263, -0.180> <0.841, 13.264, -0.188> <0.819, 13.264, -0.205> 
		<0.908, 13.252, -0.179> <0.893, 13.264, -0.160> <0.861, 13.265, -0.174> <0.839, 13.264, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.813, 13.250, -0.248> <0.835, 13.307, -0.264> <0.858, 13.386, -0.292> <0.888, 13.441, -0.303> 
		<0.799, 13.261, -0.230> <0.822, 13.318, -0.247> <0.847, 13.389, -0.277> <0.877, 13.444, -0.289> 
		<0.819, 13.264, -0.205> <0.835, 13.318, -0.225> <0.854, 13.394, -0.253> <0.880, 13.446, -0.268> 
		<0.839, 13.264, -0.190> <0.856, 13.318, -0.210> <0.868, 13.393, -0.242> <0.895, 13.445, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.839, 13.264, -0.190> <0.856, 13.318, -0.210> <0.868, 13.393, -0.242> <0.895, 13.445, -0.258> 
		<0.861, 13.265, -0.174> <0.878, 13.319, -0.194> <0.883, 13.392, -0.231> <0.909, 13.444, -0.247> 
		<0.893, 13.264, -0.160> <0.903, 13.320, -0.185> <0.908, 13.386, -0.230> <0.929, 13.441, -0.250> 
		<0.908, 13.252, -0.179> <0.918, 13.308, -0.205> <0.918, 13.383, -0.244> <0.940, 13.438, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.933, 13.434, -0.309> <0.947, 13.433, -0.299> <0.950, 13.435, -0.278> <0.940, 13.438, -0.264> 
		<0.951, 13.481, -0.318> <0.965, 13.480, -0.307> <0.966, 13.476, -0.293> <0.956, 13.479, -0.278> 
		<1.013, 13.526, -0.312> <1.022, 13.520, -0.304> <1.024, 13.520, -0.284> <1.015, 13.521, -0.273> 
		<1.029, 13.573, -0.323> <1.038, 13.567, -0.315> <1.038, 13.562, -0.300> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.933, 13.434, -0.309> <0.951, 13.481, -0.318> <1.013, 13.526, -0.312> <1.029, 13.573, -0.323> 
		<0.919, 13.434, -0.320> <0.937, 13.481, -0.328> <1.004, 13.533, -0.320> <1.020, 13.580, -0.332> 
		<0.898, 13.438, -0.317> <0.924, 13.485, -0.327> <0.982, 13.538, -0.317> <1.006, 13.586, -0.330> 
		<0.888, 13.441, -0.303> <0.914, 13.488, -0.313> <0.973, 13.539, -0.306> <0.997, 13.587, -0.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.888, 13.441, -0.303> <0.914, 13.488, -0.313> <0.973, 13.539, -0.306> <0.997, 13.587, -0.319> 
		<0.877, 13.444, -0.289> <0.903, 13.491, -0.299> <0.964, 13.540, -0.296> <0.988, 13.588, -0.309> 
		<0.880, 13.446, -0.268> <0.902, 13.489, -0.282> <0.967, 13.540, -0.276> <0.988, 13.583, -0.293> 
		<0.895, 13.445, -0.258> <0.917, 13.489, -0.271> <0.976, 13.534, -0.268> <0.997, 13.577, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.895, 13.445, -0.258> <0.917, 13.489, -0.271> <0.976, 13.534, -0.268> <0.997, 13.577, -0.285> 
		<0.909, 13.444, -0.247> <0.931, 13.488, -0.260> <0.985, 13.527, -0.260> <1.006, 13.570, -0.277> 
		<0.929, 13.441, -0.250> <0.945, 13.482, -0.264> <1.006, 13.522, -0.263> <1.020, 13.564, -0.279> 
		<0.940, 13.438, -0.264> <0.956, 13.479, -0.278> <1.015, 13.521, -0.273> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.047, 13.720, -0.373> <1.051, 13.635, -0.338> <1.029, 13.573, -0.323> 
		<1.037, 13.721, -0.362> <1.030, 13.658, -0.340> <1.060, 13.628, -0.330> <1.038, 13.567, -0.315> 
		<1.026, 13.638, -0.310> <1.034, 13.631, -0.302> <1.029, 13.563, -0.289> <1.038, 13.562, -0.300> 
		<0.997, 13.577, -0.285> <1.006, 13.570, -0.277> <1.020, 13.564, -0.279> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.047, 13.717, -0.363> <1.039, 13.654, -0.342> <1.039, 13.654, -0.342> <1.047, 13.720, -0.373> 
		<1.051, 13.629, -0.314> <1.060, 13.628, -0.325> <1.060, 13.628, -0.330> <1.051, 13.635, -0.338> 
		<1.029, 13.563, -0.289> <1.038, 13.562, -0.300> <1.038, 13.567, -0.315> <1.029, 13.573, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.037, 13.721, -0.362> <1.026, 13.638, -0.310> <0.997, 13.577, -0.285> 
		<1.047, 13.720, -0.373> <1.030, 13.658, -0.340> <1.017, 13.644, -0.318> <0.988, 13.583, -0.293> 
		<1.051, 13.635, -0.338> <1.042, 13.641, -0.347> <0.997, 13.587, -0.319> <0.988, 13.588, -0.309> 
		<1.029, 13.573, -0.323> <1.020, 13.580, -0.332> <1.006, 13.586, -0.330> <0.997, 13.587, -0.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.047, 13.720, -0.373> <1.030, 13.661, -0.351> <1.030, 13.661, -0.351> <1.037, 13.724, -0.372> 
		<1.051, 13.635, -0.338> <1.042, 13.641, -0.347> <1.033, 13.643, -0.345> <1.025, 13.644, -0.335> 
		<1.029, 13.573, -0.323> <1.020, 13.580, -0.332> <1.006, 13.586, -0.330> <0.997, 13.587, -0.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.047, 13.717, -0.363> <1.051, 13.629, -0.314> <1.029, 13.563, -0.289> 
		<1.037, 13.724, -0.372> <1.030, 13.658, -0.340> <1.042, 13.630, -0.304> <1.020, 13.564, -0.279> 
		<1.025, 13.644, -0.335> <1.016, 13.645, -0.324> <0.997, 13.577, -0.285> <1.006, 13.570, -0.277> 
		<0.997, 13.587, -0.319> <0.988, 13.588, -0.309> <0.988, 13.583, -0.293> <0.997, 13.577, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.037, 13.721, -0.362> <1.030, 13.655, -0.330> <1.030, 13.655, -0.330> <1.047, 13.717, -0.363> 
		<1.026, 13.638, -0.310> <1.034, 13.631, -0.302> <1.042, 13.630, -0.304> <1.051, 13.629, -0.314> 
		<0.997, 13.577, -0.285> <1.006, 13.570, -0.277> <1.020, 13.564, -0.279> <1.029, 13.563, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.047, 13.717, -0.363> <1.051, 13.629, -0.314> <1.029, 13.563, -0.289> 
		<1.037, 13.724, -0.372> <1.030, 13.658, -0.340> <1.060, 13.628, -0.325> <1.038, 13.562, -0.300> 
		<1.025, 13.644, -0.335> <1.033, 13.643, -0.345> <1.029, 13.573, -0.323> <1.038, 13.567, -0.315> 
		<0.997, 13.587, -0.319> <1.006, 13.586, -0.330> <1.020, 13.580, -0.332> <1.029, 13.573, -0.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> <1.054, 13.783, -0.395> 
		<1.037, 13.724, -0.372> <1.020, 13.662, -0.339> <1.020, 13.662, -0.339> <1.037, 13.721, -0.362> 
		<1.025, 13.644, -0.335> <1.016, 13.645, -0.324> <1.017, 13.644, -0.318> <1.026, 13.638, -0.310> 
		<0.997, 13.587, -0.319> <0.988, 13.588, -0.309> <0.988, 13.583, -0.293> <0.997, 13.577, -0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.916, 13.405, -0.280> <0.899, 13.404, -0.289> <0.885, 13.421, -0.296> <0.883, 13.440, -0.295> 
		<0.933, 13.406, -0.271> <0.916, 13.405, -0.280> <0.893, 13.428, -0.290> <0.890, 13.447, -0.289> 
		<0.945, 13.426, -0.263> <0.942, 13.442, -0.262> <0.914, 13.457, -0.275> <0.900, 13.456, -0.282> 
		<0.942, 13.445, -0.262> <0.940, 13.461, -0.261> <0.921, 13.463, -0.269> <0.907, 13.462, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.916, 13.405, -0.280> <0.916, 13.405, -0.280> <0.916, 13.405, -0.280> <0.916, 13.405, -0.280> 
		<0.899, 13.404, -0.289> <0.916, 13.405, -0.280> <0.916, 13.405, -0.280> <0.933, 13.406, -0.271> 
		<0.885, 13.421, -0.296> <0.903, 13.423, -0.286> <0.927, 13.424, -0.273> <0.945, 13.426, -0.263> 
		<0.883, 13.440, -0.295> <0.900, 13.442, -0.285> <0.924, 13.444, -0.272> <0.942, 13.445, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.883, 13.440, -0.295> <0.883, 13.440, -0.295> <0.883, 13.440, -0.295> <0.883, 13.440, -0.295> 
		<0.880, 13.455, -0.294> <0.898, 13.456, -0.284> <0.898, 13.456, -0.284> <0.900, 13.442, -0.285> 
		<0.895, 13.461, -0.284> <0.909, 13.462, -0.276> <0.922, 13.460, -0.271> <0.924, 13.444, -0.272> 
		<0.907, 13.462, -0.277> <0.921, 13.463, -0.269> <0.940, 13.461, -0.261> <0.942, 13.445, -0.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, 13.131, -0.266> <0.063, 13.168, -0.277> <0.016, 13.215, -0.295> <-0.018, 13.253, -0.303> 
		<0.097, 13.120, -0.289> <0.062, 13.156, -0.300> <0.009, 13.206, -0.303> <-0.025, 13.245, -0.311> 
		<0.060, 13.099, -0.274> <0.035, 13.139, -0.287> <-0.009, 13.193, -0.300> <-0.036, 13.233, -0.309> 
		<0.042, 13.095, -0.256> <0.017, 13.135, -0.268> <-0.016, 13.188, -0.289> <-0.043, 13.228, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 13.095, -0.256> <0.017, 13.135, -0.268> <-0.016, 13.188, -0.289> <-0.043, 13.228, -0.298> 
		<0.029, 13.091, -0.242> <0.003, 13.131, -0.255> <-0.022, 13.183, -0.278> <-0.050, 13.223, -0.287> 
		<0.029, 13.107, -0.208> <0.003, 13.142, -0.224> <-0.023, 13.189, -0.260> <-0.049, 13.226, -0.271> 
		<0.045, 13.117, -0.211> <0.019, 13.152, -0.226> <-0.016, 13.198, -0.251> <-0.042, 13.234, -0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 13.253, -0.303> <-0.046, 13.285, -0.310> <-0.075, 13.336, -0.306> <-0.107, 13.364, -0.314> 
		<-0.011, 13.262, -0.295> <-0.039, 13.293, -0.301> <-0.067, 13.340, -0.300> <-0.099, 13.368, -0.308> 
		<-0.011, 13.264, -0.279> <-0.036, 13.295, -0.285> <-0.067, 13.341, -0.285> <-0.096, 13.366, -0.296> 
		<-0.018, 13.259, -0.268> <-0.042, 13.290, -0.274> <-0.071, 13.336, -0.277> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 13.253, -0.303> <-0.025, 13.245, -0.311> <-0.036, 13.233, -0.309> <-0.043, 13.228, -0.298> 
		<-0.046, 13.285, -0.310> <-0.053, 13.276, -0.318> <-0.061, 13.269, -0.317> <-0.067, 13.263, -0.306> 
		<-0.075, 13.336, -0.306> <-0.083, 13.332, -0.313> <-0.096, 13.320, -0.312> <-0.100, 13.313, -0.304> 
		<-0.107, 13.364, -0.314> <-0.115, 13.359, -0.321> <-0.125, 13.351, -0.321> <-0.129, 13.344, -0.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.043, 13.228, -0.298> <-0.050, 13.223, -0.287> <-0.049, 13.226, -0.271> <-0.042, 13.234, -0.263> 
		<-0.067, 13.263, -0.306> <-0.074, 13.258, -0.295> <-0.073, 13.257, -0.282> <-0.066, 13.266, -0.273> 
		<-0.100, 13.313, -0.304> <-0.104, 13.307, -0.295> <-0.101, 13.310, -0.280> <-0.093, 13.314, -0.273> 
		<-0.129, 13.344, -0.312> <-0.133, 13.338, -0.304> <-0.128, 13.338, -0.291> <-0.120, 13.342, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.042, 13.234, -0.263> <-0.036, 13.243, -0.255> <-0.024, 13.254, -0.257> <-0.018, 13.259, -0.268> 
		<-0.066, 13.266, -0.273> <-0.059, 13.274, -0.265> <-0.049, 13.284, -0.263> <-0.042, 13.290, -0.274> 
		<-0.093, 13.314, -0.273> <-0.086, 13.318, -0.267> <-0.074, 13.330, -0.269> <-0.071, 13.336, -0.277> 
		<-0.120, 13.342, -0.284> <-0.113, 13.346, -0.278> <-0.103, 13.354, -0.280> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.241, 13.447, -0.344> <-0.169, 13.392, -0.305> <-0.120, 13.342, -0.284> 
		<-0.237, 13.453, -0.352> <-0.185, 13.408, -0.327> <-0.161, 13.396, -0.299> <-0.113, 13.346, -0.278> 
		<-0.158, 13.409, -0.326> <-0.151, 13.412, -0.320> <-0.100, 13.360, -0.288> <-0.103, 13.354, -0.280> 
		<-0.107, 13.364, -0.314> <-0.099, 13.368, -0.308> <-0.096, 13.366, -0.296> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.235, 13.452, -0.344> <-0.179, 13.414, -0.328> <-0.179, 13.414, -0.328> <-0.237, 13.453, -0.352> 
		<-0.154, 13.406, -0.308> <-0.150, 13.412, -0.316> <-0.151, 13.412, -0.320> <-0.158, 13.409, -0.326> 
		<-0.100, 13.360, -0.288> <-0.096, 13.366, -0.296> <-0.099, 13.368, -0.308> <-0.107, 13.364, -0.314> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.237, 13.453, -0.352> <-0.158, 13.409, -0.326> <-0.107, 13.364, -0.314> 
		<-0.241, 13.447, -0.344> <-0.185, 13.408, -0.327> <-0.167, 13.404, -0.333> <-0.115, 13.359, -0.321> 
		<-0.169, 13.392, -0.305> <-0.177, 13.388, -0.312> <-0.129, 13.345, -0.312> <-0.125, 13.351, -0.321> 
		<-0.120, 13.342, -0.284> <-0.128, 13.338, -0.291> <-0.133, 13.338, -0.304> <-0.129, 13.344, -0.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.244, 13.447, -0.352> <-0.188, 13.409, -0.335> <-0.188, 13.409, -0.335> <-0.237, 13.453, -0.352> 
		<-0.175, 13.393, -0.325> <-0.171, 13.399, -0.334> <-0.167, 13.404, -0.333> <-0.158, 13.409, -0.326> 
		<-0.129, 13.344, -0.312> <-0.125, 13.351, -0.321> <-0.115, 13.359, -0.321> <-0.107, 13.364, -0.314> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.235, 13.452, -0.344> <-0.154, 13.406, -0.308> <-0.100, 13.360, -0.288> 
		<-0.244, 13.447, -0.352> <-0.186, 13.408, -0.327> <-0.158, 13.400, -0.300> <-0.103, 13.354, -0.280> 
		<-0.175, 13.393, -0.325> <-0.179, 13.387, -0.317> <-0.121, 13.342, -0.285> <-0.113, 13.346, -0.278> 
		<-0.129, 13.344, -0.312> <-0.133, 13.338, -0.304> <-0.128, 13.338, -0.291> <-0.120, 13.342, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.241, 13.447, -0.344> <-0.183, 13.407, -0.319> <-0.183, 13.407, -0.319> <-0.235, 13.452, -0.344> 
		<-0.169, 13.392, -0.305> <-0.161, 13.396, -0.299> <-0.158, 13.400, -0.300> <-0.154, 13.406, -0.308> 
		<-0.120, 13.342, -0.284> <-0.113, 13.346, -0.278> <-0.103, 13.354, -0.280> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.235, 13.452, -0.344> <-0.154, 13.406, -0.308> <-0.100, 13.360, -0.288> 
		<-0.244, 13.447, -0.352> <-0.186, 13.408, -0.327> <-0.150, 13.412, -0.316> <-0.096, 13.366, -0.296> 
		<-0.175, 13.393, -0.325> <-0.171, 13.399, -0.334> <-0.107, 13.363, -0.314> <-0.099, 13.368, -0.308> 
		<-0.129, 13.344, -0.312> <-0.125, 13.351, -0.321> <-0.115, 13.359, -0.321> <-0.107, 13.364, -0.314> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.241, 13.447, -0.344> <-0.192, 13.403, -0.326> <-0.192, 13.403, -0.326> <-0.244, 13.447, -0.352> 
		<-0.169, 13.392, -0.305> <-0.177, 13.388, -0.312> <-0.179, 13.387, -0.317> <-0.175, 13.393, -0.325> 
		<-0.120, 13.342, -0.284> <-0.128, 13.338, -0.291> <-0.133, 13.338, -0.304> <-0.129, 13.344, -0.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 13.229, -0.280> <-0.015, 13.218, -0.288> <-0.032, 13.218, -0.293> <-0.045, 13.225, -0.292> 
		<-0.001, 13.241, -0.273> <-0.008, 13.230, -0.280> <-0.032, 13.225, -0.288> <-0.046, 13.232, -0.288> 
		<-0.008, 13.257, -0.267> <-0.019, 13.263, -0.267> <-0.041, 13.252, -0.276> <-0.047, 13.242, -0.282> 
		<-0.021, 13.264, -0.267> <-0.032, 13.270, -0.266> <-0.042, 13.259, -0.272> <-0.048, 13.250, -0.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 13.229, -0.280> <-0.008, 13.229, -0.280> <-0.008, 13.229, -0.280> <-0.008, 13.229, -0.280> 
		<-0.015, 13.218, -0.288> <-0.008, 13.230, -0.280> <-0.008, 13.230, -0.280> <-0.001, 13.241, -0.273> 
		<-0.032, 13.218, -0.293> <-0.025, 13.229, -0.285> <-0.015, 13.245, -0.275> <-0.008, 13.257, -0.267> 
		<-0.045, 13.225, -0.292> <-0.038, 13.236, -0.284> <-0.028, 13.252, -0.274> <-0.021, 13.264, -0.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 13.225, -0.292> <-0.045, 13.225, -0.292> <-0.045, 13.225, -0.292> <-0.045, 13.225, -0.292> 
		<-0.055, 13.230, -0.291> <-0.048, 13.242, -0.284> <-0.048, 13.242, -0.284> <-0.038, 13.236, -0.284> 
		<-0.053, 13.242, -0.283> <-0.047, 13.251, -0.277> <-0.039, 13.258, -0.273> <-0.028, 13.252, -0.274> 
		<-0.048, 13.250, -0.278> <-0.042, 13.259, -0.272> <-0.032, 13.270, -0.266> <-0.021, 13.264, -0.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, 13.131, -0.266> <0.098, 13.131, -0.266> <0.098, 13.131, -0.266> <0.098, 13.131, -0.266> 
		<0.111, 13.149, -0.250> <0.098, 13.132, -0.265> <0.098, 13.132, -0.265> <0.086, 13.114, -0.281> 
		<0.103, 13.160, -0.221> <0.090, 13.142, -0.237> <0.073, 13.117, -0.258> <0.060, 13.099, -0.274> 
		<0.084, 13.155, -0.203> <0.072, 13.137, -0.218> <0.055, 13.113, -0.240> <0.042, 13.095, -0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, 13.131, -0.266> <0.111, 13.149, -0.250> <0.103, 13.160, -0.221> <0.084, 13.155, -0.203> 
		<0.063, 13.168, -0.277> <0.076, 13.186, -0.261> <0.072, 13.191, -0.241> <0.054, 13.186, -0.222> 
		<0.016, 13.215, -0.295> <0.023, 13.223, -0.287> <0.020, 13.230, -0.265> <0.013, 13.225, -0.254> 
		<-0.018, 13.253, -0.303> <-0.011, 13.262, -0.295> <-0.011, 13.264, -0.279> <-0.018, 13.259, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.098, 13.131, -0.266> <0.063, 13.168, -0.277> <0.016, 13.215, -0.295> <-0.018, 13.253, -0.303> 
		<0.086, 13.114, -0.281> <0.051, 13.151, -0.292> <0.009, 13.206, -0.303> <-0.025, 13.245, -0.311> 
		<0.060, 13.099, -0.274> <0.035, 13.139, -0.287> <-0.009, 13.193, -0.300> <-0.036, 13.233, -0.309> 
		<0.042, 13.095, -0.256> <0.017, 13.135, -0.268> <-0.016, 13.188, -0.289> <-0.043, 13.228, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 13.095, -0.256> <0.042, 13.095, -0.256> <0.042, 13.095, -0.256> <0.042, 13.095, -0.256> 
		<0.055, 13.113, -0.240> <0.042, 13.109, -0.226> <0.042, 13.109, -0.226> <0.029, 13.091, -0.242> 
		<0.072, 13.137, -0.218> <0.057, 13.133, -0.203> <0.046, 13.119, -0.210> <0.036, 13.104, -0.222> 
		<0.084, 13.155, -0.203> <0.070, 13.151, -0.188> <0.055, 13.132, -0.198> <0.045, 13.117, -0.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 13.095, -0.256> <0.017, 13.135, -0.268> <-0.016, 13.188, -0.289> <-0.043, 13.228, -0.298> 
		<0.029, 13.091, -0.242> <0.003, 13.131, -0.255> <-0.023, 13.183, -0.279> <-0.050, 13.223, -0.287> 
		<0.036, 13.104, -0.222> <0.010, 13.140, -0.238> <-0.023, 13.189, -0.260> <-0.049, 13.226, -0.271> 
		<0.045, 13.117, -0.211> <0.019, 13.152, -0.226> <-0.016, 13.198, -0.251> <-0.042, 13.234, -0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 13.117, -0.211> <0.019, 13.152, -0.226> <-0.016, 13.198, -0.251> <-0.042, 13.234, -0.263> 
		<0.055, 13.132, -0.198> <0.029, 13.167, -0.214> <-0.009, 13.206, -0.243> <-0.036, 13.243, -0.255> 
		<0.070, 13.151, -0.188> <0.039, 13.183, -0.207> <0.006, 13.220, -0.243> <-0.024, 13.254, -0.257> 
		<0.084, 13.155, -0.203> <0.054, 13.186, -0.222> <0.013, 13.225, -0.254> <-0.018, 13.259, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 13.253, -0.303> <-0.011, 13.262, -0.295> <-0.011, 13.264, -0.279> <-0.018, 13.259, -0.268> 
		<-0.046, 13.285, -0.310> <-0.039, 13.293, -0.301> <-0.036, 13.292, -0.290> <-0.043, 13.287, -0.280> 
		<-0.075, 13.336, -0.306> <-0.067, 13.340, -0.300> <-0.067, 13.341, -0.285> <-0.071, 13.336, -0.277> 
		<-0.107, 13.364, -0.314> <-0.099, 13.368, -0.308> <-0.096, 13.366, -0.296> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 13.253, -0.303> <-0.046, 13.285, -0.310> <-0.075, 13.336, -0.306> <-0.107, 13.364, -0.314> 
		<-0.025, 13.245, -0.311> <-0.053, 13.276, -0.318> <-0.083, 13.332, -0.313> <-0.114, 13.360, -0.320> 
		<-0.036, 13.233, -0.309> <-0.060, 13.269, -0.317> <-0.094, 13.320, -0.310> <-0.124, 13.352, -0.319> 
		<-0.043, 13.228, -0.298> <-0.067, 13.264, -0.306> <-0.098, 13.315, -0.302> <-0.127, 13.346, -0.311> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.043, 13.228, -0.298> <-0.067, 13.264, -0.306> <-0.098, 13.315, -0.302> <-0.127, 13.346, -0.311> 
		<-0.050, 13.223, -0.287> <-0.074, 13.258, -0.295> <-0.102, 13.309, -0.294> <-0.131, 13.340, -0.303> 
		<-0.049, 13.226, -0.271> <-0.073, 13.257, -0.282> <-0.101, 13.310, -0.279> <-0.128, 13.338, -0.291> 
		<-0.042, 13.234, -0.263> <-0.066, 13.266, -0.273> <-0.093, 13.314, -0.273> <-0.120, 13.342, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.042, 13.234, -0.263> <-0.066, 13.266, -0.273> <-0.093, 13.314, -0.273> <-0.120, 13.342, -0.284> 
		<-0.036, 13.243, -0.255> <-0.059, 13.274, -0.265> <-0.086, 13.318, -0.267> <-0.113, 13.346, -0.278> 
		<-0.024, 13.254, -0.257> <-0.049, 13.282, -0.269> <-0.074, 13.330, -0.269> <-0.103, 13.354, -0.280> 
		<-0.018, 13.259, -0.268> <-0.043, 13.287, -0.280> <-0.071, 13.336, -0.277> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.237, 13.453, -0.352> <-0.158, 13.409, -0.326> <-0.107, 13.364, -0.314> 
		<-0.241, 13.447, -0.344> <-0.185, 13.408, -0.327> <-0.151, 13.412, -0.320> <-0.099, 13.368, -0.308> 
		<-0.169, 13.392, -0.305> <-0.161, 13.396, -0.299> <-0.100, 13.360, -0.288> <-0.096, 13.366, -0.296> 
		<-0.120, 13.342, -0.284> <-0.113, 13.346, -0.278> <-0.103, 13.354, -0.280> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.235, 13.452, -0.344> <-0.179, 13.414, -0.328> <-0.179, 13.414, -0.328> <-0.237, 13.453, -0.352> 
		<-0.154, 13.406, -0.308> <-0.150, 13.412, -0.316> <-0.151, 13.412, -0.320> <-0.158, 13.409, -0.326> 
		<-0.100, 13.360, -0.288> <-0.096, 13.366, -0.296> <-0.099, 13.368, -0.308> <-0.107, 13.364, -0.314> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.241, 13.447, -0.344> <-0.169, 13.392, -0.305> <-0.120, 13.342, -0.284> 
		<-0.237, 13.453, -0.352> <-0.185, 13.408, -0.327> <-0.177, 13.388, -0.311> <-0.128, 13.338, -0.291> 
		<-0.158, 13.409, -0.326> <-0.166, 13.405, -0.333> <-0.127, 13.346, -0.311> <-0.131, 13.340, -0.303> 
		<-0.107, 13.364, -0.314> <-0.114, 13.360, -0.320> <-0.124, 13.352, -0.319> <-0.127, 13.346, -0.311> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.237, 13.453, -0.352> <-0.187, 13.409, -0.335> <-0.187, 13.409, -0.335> <-0.243, 13.448, -0.351> 
		<-0.158, 13.409, -0.326> <-0.166, 13.405, -0.333> <-0.170, 13.400, -0.332> <-0.173, 13.394, -0.324> 
		<-0.107, 13.364, -0.314> <-0.114, 13.360, -0.320> <-0.124, 13.352, -0.319> <-0.127, 13.346, -0.311> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.235, 13.452, -0.344> <-0.154, 13.406, -0.308> <-0.100, 13.360, -0.288> 
		<-0.243, 13.448, -0.351> <-0.185, 13.408, -0.327> <-0.158, 13.400, -0.300> <-0.103, 13.354, -0.280> 
		<-0.173, 13.394, -0.324> <-0.177, 13.389, -0.316> <-0.120, 13.342, -0.284> <-0.113, 13.346, -0.278> 
		<-0.127, 13.346, -0.311> <-0.131, 13.340, -0.303> <-0.128, 13.338, -0.291> <-0.120, 13.342, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.241, 13.447, -0.344> <-0.183, 13.407, -0.319> <-0.183, 13.407, -0.319> <-0.235, 13.452, -0.344> 
		<-0.169, 13.392, -0.305> <-0.161, 13.396, -0.299> <-0.158, 13.400, -0.300> <-0.154, 13.406, -0.308> 
		<-0.120, 13.342, -0.284> <-0.113, 13.346, -0.278> <-0.103, 13.354, -0.280> <-0.100, 13.360, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.235, 13.452, -0.344> <-0.154, 13.406, -0.308> <-0.100, 13.360, -0.288> 
		<-0.243, 13.448, -0.351> <-0.185, 13.408, -0.327> <-0.150, 13.412, -0.316> <-0.096, 13.366, -0.296> 
		<-0.173, 13.394, -0.324> <-0.170, 13.400, -0.332> <-0.107, 13.364, -0.314> <-0.099, 13.368, -0.308> 
		<-0.127, 13.346, -0.311> <-0.124, 13.352, -0.319> <-0.114, 13.360, -0.320> <-0.107, 13.364, -0.314> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> <-0.292, 13.491, -0.369> 
		<-0.243, 13.448, -0.351> <-0.191, 13.403, -0.326> <-0.191, 13.403, -0.326> <-0.241, 13.447, -0.344> 
		<-0.173, 13.394, -0.324> <-0.177, 13.389, -0.316> <-0.177, 13.388, -0.311> <-0.169, 13.392, -0.305> 
		<-0.127, 13.346, -0.311> <-0.131, 13.340, -0.303> <-0.128, 13.338, -0.291> <-0.120, 13.342, -0.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 13.229, -0.280> <-0.015, 13.218, -0.288> <-0.032, 13.218, -0.293> <-0.045, 13.225, -0.292> 
		<-0.001, 13.241, -0.273> <-0.008, 13.230, -0.280> <-0.032, 13.225, -0.288> <-0.046, 13.232, -0.288> 
		<-0.008, 13.257, -0.267> <-0.019, 13.263, -0.267> <-0.041, 13.252, -0.276> <-0.047, 13.242, -0.282> 
		<-0.021, 13.264, -0.267> <-0.032, 13.270, -0.266> <-0.042, 13.259, -0.272> <-0.048, 13.250, -0.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 13.229, -0.280> <-0.008, 13.229, -0.280> <-0.008, 13.229, -0.280> <-0.008, 13.229, -0.280> 
		<-0.015, 13.218, -0.288> <-0.008, 13.230, -0.280> <-0.008, 13.230, -0.280> <-0.001, 13.241, -0.273> 
		<-0.032, 13.218, -0.293> <-0.025, 13.229, -0.285> <-0.015, 13.245, -0.275> <-0.008, 13.257, -0.267> 
		<-0.045, 13.225, -0.292> <-0.038, 13.236, -0.284> <-0.028, 13.252, -0.274> <-0.021, 13.264, -0.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 13.225, -0.292> <-0.045, 13.225, -0.292> <-0.045, 13.225, -0.292> <-0.045, 13.225, -0.292> 
		<-0.055, 13.230, -0.291> <-0.048, 13.242, -0.284> <-0.048, 13.242, -0.284> <-0.038, 13.236, -0.284> 
		<-0.053, 13.242, -0.283> <-0.047, 13.251, -0.277> <-0.039, 13.258, -0.273> <-0.028, 13.252, -0.274> 
		<-0.048, 13.250, -0.278> <-0.042, 13.259, -0.272> <-0.032, 13.270, -0.266> <-0.021, 13.264, -0.267> 
	}

	texture { txTrunks }
}

// Layer 2
#declare oFlowers =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.515, 14.254, -0.197> <-2.518, 14.254, -0.195> <-2.525, 14.251, -0.195> <-2.527, 14.248, -0.196> 
		<-2.507, 14.252, -0.201> <-2.511, 14.252, -0.199> <-2.530, 14.244, -0.198> <-2.531, 14.241, -0.199> 
		<-2.499, 14.246, -0.209> <-2.511, 14.240, -0.208> <-2.522, 14.235, -0.207> <-2.534, 14.230, -0.206> 
		<-2.494, 14.240, -0.214> <-2.506, 14.234, -0.213> <-2.522, 14.227, -0.212> <-2.534, 14.221, -0.210> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.534, 14.221, -0.210> <-2.534, 14.211, -0.216> <-2.531, 14.195, -0.221> <-2.526, 14.186, -0.228> 
		<-2.522, 14.227, -0.212> <-2.522, 14.216, -0.217> <-2.516, 14.202, -0.223> <-2.511, 14.193, -0.229> 
		<-2.506, 14.234, -0.213> <-2.499, 14.226, -0.219> <-2.493, 14.212, -0.225> <-2.491, 14.202, -0.231> 
		<-2.494, 14.240, -0.214> <-2.487, 14.232, -0.220> <-2.478, 14.219, -0.226> <-2.476, 14.209, -0.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.526, 14.186, -0.228> <-2.523, 14.181, -0.232> <-2.516, 14.178, -0.242> <-2.509, 14.178, -0.245> 
		<-2.511, 14.193, -0.229> <-2.508, 14.188, -0.234> <-2.508, 14.179, -0.245> <-2.502, 14.179, -0.248> 
		<-2.491, 14.202, -0.231> <-2.490, 14.196, -0.235> <-2.485, 14.189, -0.247> <-2.490, 14.184, -0.249> 
		<-2.476, 14.209, -0.233> <-2.475, 14.203, -0.237> <-2.479, 14.195, -0.245> <-2.484, 14.190, -0.247> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.473, 14.267, -0.226> <-2.475, 14.269, -0.223> <-2.479, 14.268, -0.218> <-2.482, 14.265, -0.216> 
		<-2.470, 14.263, -0.233> <-2.472, 14.265, -0.230> <-2.485, 14.261, -0.214> <-2.487, 14.259, -0.213> 
		<-2.469, 14.253, -0.242> <-2.478, 14.251, -0.232> <-2.486, 14.249, -0.223> <-2.494, 14.247, -0.213> 
		<-2.469, 14.245, -0.247> <-2.477, 14.243, -0.237> <-2.489, 14.240, -0.223> <-2.497, 14.238, -0.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.497, 14.238, -0.213> <-2.501, 14.227, -0.214> <-2.502, 14.210, -0.213> <-2.503, 14.199, -0.218> 
		<-2.489, 14.240, -0.223> <-2.492, 14.229, -0.224> <-2.492, 14.213, -0.226> <-2.493, 14.202, -0.231> 
		<-2.477, 14.243, -0.237> <-2.476, 14.233, -0.242> <-2.475, 14.216, -0.245> <-2.478, 14.205, -0.247> 
		<-2.469, 14.245, -0.247> <-2.468, 14.235, -0.252> <-2.465, 14.219, -0.258> <-2.468, 14.208, -0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.503, 14.199, -0.218> <-2.504, 14.192, -0.221> <-2.504, 14.185, -0.232> <-2.501, 14.184, -0.238> 
		<-2.493, 14.202, -0.231> <-2.493, 14.195, -0.234> <-2.501, 14.183, -0.239> <-2.498, 14.182, -0.245> 
		<-2.478, 14.205, -0.247> <-2.480, 14.198, -0.249> <-2.484, 14.187, -0.259> <-2.489, 14.183, -0.255> 
		<-2.468, 14.208, -0.260> <-2.470, 14.200, -0.262> <-2.478, 14.192, -0.262> <-2.483, 14.188, -0.259> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.463, 14.263, -0.273> <-2.462, 14.266, -0.270> <-2.462, 14.267, -0.263> <-2.463, 14.265, -0.260> 
		<-2.466, 14.256, -0.278> <-2.465, 14.259, -0.276> <-2.465, 14.263, -0.255> <-2.466, 14.261, -0.252> 
		<-2.471, 14.244, -0.282> <-2.471, 14.247, -0.269> <-2.471, 14.249, -0.257> <-2.471, 14.252, -0.244> 
		<-2.473, 14.236, -0.283> <-2.473, 14.238, -0.270> <-2.473, 14.242, -0.252> <-2.473, 14.244, -0.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.473, 14.244, -0.239> <-2.476, 14.234, -0.233> <-2.478, 14.219, -0.226> <-2.482, 14.208, -0.226> 
		<-2.473, 14.242, -0.252> <-2.476, 14.232, -0.246> <-2.478, 14.216, -0.243> <-2.482, 14.204, -0.242> 
		<-2.473, 14.238, -0.270> <-2.476, 14.227, -0.271> <-2.478, 14.211, -0.267> <-2.482, 14.200, -0.264> 
		<-2.473, 14.236, -0.283> <-2.476, 14.224, -0.284> <-2.478, 14.207, -0.284> <-2.482, 14.197, -0.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.482, 14.208, -0.226> <-2.485, 14.201, -0.225> <-2.492, 14.192, -0.230> <-2.493, 14.188, -0.236> 
		<-2.482, 14.204, -0.242> <-2.485, 14.197, -0.241> <-2.494, 14.187, -0.236> <-2.496, 14.183, -0.242> 
		<-2.482, 14.200, -0.264> <-2.484, 14.193, -0.261> <-2.494, 14.182, -0.262> <-2.496, 14.181, -0.255> 
		<-2.482, 14.197, -0.280> <-2.484, 14.190, -0.277> <-2.492, 14.184, -0.270> <-2.493, 14.182, -0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.484, 14.245, -0.312> <-2.482, 14.248, -0.312> <-2.477, 14.251, -0.307> <-2.476, 14.251, -0.303> 
		<-2.490, 14.238, -0.312> <-2.488, 14.241, -0.312> <-2.474, 14.250, -0.298> <-2.473, 14.249, -0.295> 
		<-2.496, 14.227, -0.307> <-2.488, 14.233, -0.299> <-2.480, 14.238, -0.291> <-2.471, 14.244, -0.283> 
		<-2.499, 14.219, -0.303> <-2.490, 14.225, -0.295> <-2.479, 14.233, -0.284> <-2.470, 14.238, -0.275> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.470, 14.238, -0.275> <-2.469, 14.231, -0.266> <-2.466, 14.219, -0.254> <-2.469, 14.210, -0.248> 
		<-2.479, 14.233, -0.284> <-2.478, 14.226, -0.274> <-2.477, 14.212, -0.265> <-2.479, 14.202, -0.258> 
		<-2.490, 14.225, -0.295> <-2.494, 14.215, -0.290> <-2.493, 14.201, -0.281> <-2.494, 14.193, -0.272> 
		<-2.499, 14.219, -0.303> <-2.502, 14.209, -0.298> <-2.504, 14.194, -0.292> <-2.504, 14.186, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.469, 14.210, -0.248> <-2.471, 14.204, -0.243> <-2.479, 14.196, -0.239> <-2.484, 14.191, -0.241> 
		<-2.479, 14.202, -0.258> <-2.481, 14.196, -0.254> <-2.485, 14.190, -0.241> <-2.490, 14.185, -0.243> 
		<-2.494, 14.193, -0.272> <-2.494, 14.188, -0.267> <-2.502, 14.179, -0.258> <-2.499, 14.180, -0.251> 
		<-2.504, 14.186, -0.283> <-2.505, 14.181, -0.277> <-2.505, 14.178, -0.265> <-2.502, 14.179, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.568, 14.209, -0.293> <-2.569, 14.210, -0.296> <-2.564, 14.211, -0.302> <-2.560, 14.211, -0.303> 
		<-2.568, 14.206, -0.284> <-2.568, 14.207, -0.288> <-2.555, 14.211, -0.303> <-2.551, 14.210, -0.304> 
		<-2.563, 14.203, -0.273> <-2.554, 14.205, -0.283> <-2.546, 14.207, -0.292> <-2.538, 14.209, -0.302> 
		<-2.558, 14.199, -0.266> <-2.549, 14.201, -0.276> <-2.538, 14.204, -0.289> <-2.529, 14.206, -0.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.529, 14.206, -0.299> <-2.518, 14.202, -0.296> <-2.505, 14.193, -0.291> <-2.497, 14.189, -0.283> 
		<-2.538, 14.204, -0.289> <-2.527, 14.200, -0.286> <-2.515, 14.191, -0.278> <-2.507, 14.187, -0.270> 
		<-2.549, 14.201, -0.276> <-2.543, 14.196, -0.267> <-2.532, 14.187, -0.259> <-2.522, 14.183, -0.254> 
		<-2.558, 14.199, -0.266> <-2.552, 14.194, -0.257> <-2.542, 14.184, -0.247> <-2.532, 14.181, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.497, 14.189, -0.283> <-2.492, 14.187, -0.278> <-2.488, 14.186, -0.266> <-2.490, 14.185, -0.259> 
		<-2.507, 14.187, -0.270> <-2.502, 14.184, -0.265> <-2.490, 14.185, -0.258> <-2.491, 14.183, -0.251> 
		<-2.522, 14.183, -0.254> <-2.515, 14.181, -0.250> <-2.507, 14.181, -0.239> <-2.500, 14.181, -0.241> 
		<-2.532, 14.181, -0.241> <-2.526, 14.179, -0.238> <-2.514, 14.180, -0.235> <-2.507, 14.181, -0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.527, 14.223, -0.321> <-2.525, 14.226, -0.324> <-2.518, 14.229, -0.324> <-2.515, 14.229, -0.322> 
		<-2.531, 14.217, -0.315> <-2.529, 14.220, -0.318> <-2.510, 14.228, -0.320> <-2.507, 14.228, -0.318> 
		<-2.533, 14.210, -0.305> <-2.521, 14.216, -0.306> <-2.510, 14.221, -0.307> <-2.498, 14.226, -0.308> 
		<-2.533, 14.204, -0.298> <-2.521, 14.210, -0.299> <-2.504, 14.217, -0.300> <-2.492, 14.223, -0.301> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.492, 14.223, -0.301> <-2.485, 14.218, -0.293> <-2.476, 14.209, -0.282> <-2.474, 14.202, -0.273> 
		<-2.504, 14.217, -0.300> <-2.497, 14.213, -0.292> <-2.491, 14.202, -0.281> <-2.489, 14.195, -0.271> 
		<-2.521, 14.210, -0.299> <-2.520, 14.202, -0.289> <-2.514, 14.191, -0.279> <-2.509, 14.186, -0.269> 
		<-2.533, 14.204, -0.298> <-2.532, 14.197, -0.288> <-2.529, 14.185, -0.277> <-2.524, 14.179, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.474, 14.202, -0.273> <-2.472, 14.198, -0.266> <-2.476, 14.194, -0.256> <-2.482, 14.190, -0.252> 
		<-2.489, 14.195, -0.271> <-2.487, 14.191, -0.265> <-2.482, 14.190, -0.252> <-2.487, 14.186, -0.248> 
		<-2.509, 14.186, -0.269> <-2.506, 14.183, -0.263> <-2.506, 14.179, -0.249> <-2.499, 14.181, -0.247> 
		<-2.524, 14.179, -0.268> <-2.521, 14.176, -0.262> <-2.514, 14.177, -0.252> <-2.507, 14.179, -0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.579, 14.213, -0.247> <-2.582, 14.213, -0.250> <-2.582, 14.212, -0.257> <-2.579, 14.211, -0.260> 
		<-2.573, 14.213, -0.240> <-2.576, 14.213, -0.243> <-2.576, 14.209, -0.264> <-2.573, 14.207, -0.267> 
		<-2.562, 14.211, -0.234> <-2.562, 14.208, -0.247> <-2.562, 14.206, -0.259> <-2.562, 14.203, -0.272> 
		<-2.554, 14.208, -0.231> <-2.554, 14.205, -0.244> <-2.554, 14.202, -0.261> <-2.554, 14.199, -0.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.554, 14.199, -0.274> <-2.543, 14.194, -0.277> <-2.530, 14.184, -0.279> <-2.519, 14.180, -0.277> 
		<-2.554, 14.202, -0.261> <-2.543, 14.197, -0.264> <-2.530, 14.187, -0.263> <-2.519, 14.183, -0.260> 
		<-2.554, 14.205, -0.244> <-2.543, 14.201, -0.240> <-2.530, 14.192, -0.238> <-2.519, 14.188, -0.239> 
		<-2.554, 14.208, -0.231> <-2.543, 14.204, -0.227> <-2.530, 14.195, -0.222> <-2.519, 14.191, -0.222> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.519, 14.180, -0.277> <-2.512, 14.178, -0.275> <-2.501, 14.179, -0.269> <-2.498, 14.180, -0.263> 
		<-2.519, 14.183, -0.260> <-2.512, 14.181, -0.259> <-2.497, 14.180, -0.262> <-2.494, 14.181, -0.255> 
		<-2.519, 14.188, -0.239> <-2.512, 14.185, -0.239> <-2.497, 14.186, -0.236> <-2.494, 14.184, -0.243> 
		<-2.519, 14.191, -0.222> <-2.512, 14.188, -0.223> <-2.501, 14.187, -0.229> <-2.498, 14.186, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.557, 14.232, -0.206> <-2.561, 14.232, -0.207> <-2.566, 14.229, -0.211> <-2.566, 14.226, -0.214> 
		<-2.548, 14.231, -0.204> <-2.552, 14.232, -0.205> <-2.566, 14.223, -0.218> <-2.565, 14.220, -0.221> 
		<-2.536, 14.229, -0.206> <-2.544, 14.223, -0.215> <-2.552, 14.218, -0.222> <-2.561, 14.212, -0.231> 
		<-2.527, 14.225, -0.208> <-2.536, 14.219, -0.216> <-2.547, 14.212, -0.228> <-2.556, 14.206, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.556, 14.206, -0.236> <-2.550, 14.198, -0.243> <-2.541, 14.185, -0.249> <-2.531, 14.179, -0.252> 
		<-2.547, 14.212, -0.228> <-2.541, 14.203, -0.234> <-2.531, 14.192, -0.238> <-2.521, 14.186, -0.242> 
		<-2.536, 14.219, -0.216> <-2.525, 14.214, -0.218> <-2.514, 14.203, -0.222> <-2.506, 14.196, -0.228> 
		<-2.527, 14.225, -0.208> <-2.517, 14.220, -0.210> <-2.503, 14.210, -0.211> <-2.496, 14.203, -0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.531, 14.179, -0.252> <-2.525, 14.176, -0.255> <-2.513, 14.176, -0.258> <-2.506, 14.178, -0.255> 
		<-2.521, 14.186, -0.242> <-2.514, 14.183, -0.244> <-2.506, 14.178, -0.255> <-2.499, 14.180, -0.252> 
		<-2.506, 14.196, -0.228> <-2.502, 14.191, -0.232> <-2.489, 14.189, -0.238> <-2.490, 14.185, -0.244> 
		<-2.496, 14.203, -0.217> <-2.491, 14.198, -0.221> <-2.487, 14.194, -0.231> <-2.488, 14.190, -0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.525, 14.266, -0.218> <-2.527, 14.267, -0.217> <-2.532, 14.265, -0.216> <-2.533, 14.262, -0.217> 
		<-2.517, 14.262, -0.221> <-2.520, 14.263, -0.220> <-2.535, 14.256, -0.218> <-2.536, 14.254, -0.219> 
		<-2.510, 14.254, -0.226> <-2.518, 14.250, -0.225> <-2.527, 14.246, -0.224> <-2.535, 14.242, -0.224> 
		<-2.505, 14.247, -0.228> <-2.514, 14.243, -0.228> <-2.525, 14.238, -0.227> <-2.534, 14.234, -0.226> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.534, 14.234, -0.226> <-2.532, 14.221, -0.229> <-2.527, 14.204, -0.231> <-2.521, 14.193, -0.235> 
		<-2.525, 14.238, -0.227> <-2.523, 14.225, -0.230> <-2.516, 14.209, -0.232> <-2.510, 14.198, -0.236> 
		<-2.514, 14.243, -0.228> <-2.506, 14.233, -0.231> <-2.499, 14.216, -0.233> <-2.496, 14.204, -0.238> 
		<-2.505, 14.247, -0.228> <-2.498, 14.236, -0.232> <-2.488, 14.221, -0.234> <-2.485, 14.209, -0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.521, 14.193, -0.235> <-2.518, 14.187, -0.237> <-2.512, 14.182, -0.244> <-2.506, 14.181, -0.246> 
		<-2.510, 14.198, -0.236> <-2.507, 14.192, -0.238> <-2.506, 14.181, -0.246> <-2.500, 14.181, -0.248> 
		<-2.496, 14.204, -0.238> <-2.494, 14.198, -0.240> <-2.488, 14.190, -0.248> <-2.491, 14.185, -0.249> 
		<-2.485, 14.209, -0.238> <-2.483, 14.203, -0.241> <-2.484, 14.195, -0.246> <-2.488, 14.190, -0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.495, 14.276, -0.239> <-2.496, 14.278, -0.237> <-2.500, 14.277, -0.233> <-2.501, 14.275, -0.232> 
		<-2.491, 14.270, -0.244> <-2.492, 14.272, -0.242> <-2.503, 14.269, -0.230> <-2.504, 14.267, -0.229> 
		<-2.489, 14.259, -0.249> <-2.495, 14.258, -0.242> <-2.501, 14.256, -0.235> <-2.507, 14.255, -0.228> 
		<-2.487, 14.251, -0.252> <-2.493, 14.249, -0.244> <-2.501, 14.247, -0.235> <-2.507, 14.246, -0.228> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 14.246, -0.228> <-2.508, 14.233, -0.227> <-2.506, 14.215, -0.225> <-2.504, 14.202, -0.228> 
		<-2.501, 14.247, -0.235> <-2.502, 14.234, -0.234> <-2.498, 14.217, -0.234> <-2.497, 14.204, -0.237> 
		<-2.493, 14.249, -0.244> <-2.490, 14.237, -0.248> <-2.486, 14.219, -0.248> <-2.487, 14.206, -0.249> 
		<-2.487, 14.251, -0.252> <-2.484, 14.238, -0.255> <-2.479, 14.221, -0.257> <-2.479, 14.208, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.504, 14.202, -0.228> <-2.504, 14.196, -0.230> <-2.503, 14.188, -0.236> <-2.500, 14.185, -0.241> 
		<-2.497, 14.204, -0.237> <-2.496, 14.197, -0.239> <-2.500, 14.185, -0.241> <-2.497, 14.183, -0.246> 
		<-2.487, 14.206, -0.249> <-2.487, 14.200, -0.250> <-2.487, 14.188, -0.257> <-2.491, 14.184, -0.253> 
		<-2.479, 14.208, -0.258> <-2.479, 14.202, -0.259> <-2.484, 14.192, -0.259> <-2.487, 14.188, -0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.487, 14.273, -0.272> <-2.487, 14.275, -0.271> <-2.487, 14.276, -0.265> <-2.487, 14.275, -0.263> 
		<-2.488, 14.265, -0.276> <-2.488, 14.267, -0.275> <-2.488, 14.271, -0.258> <-2.488, 14.269, -0.256> 
		<-2.490, 14.253, -0.278> <-2.490, 14.255, -0.268> <-2.490, 14.256, -0.259> <-2.490, 14.258, -0.250> 
		<-2.490, 14.244, -0.278> <-2.490, 14.246, -0.268> <-2.490, 14.248, -0.256> <-2.490, 14.250, -0.246> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.490, 14.250, -0.246> <-2.491, 14.238, -0.241> <-2.488, 14.221, -0.235> <-2.489, 14.208, -0.233> 
		<-2.490, 14.248, -0.256> <-2.491, 14.236, -0.250> <-2.488, 14.219, -0.247> <-2.489, 14.206, -0.245> 
		<-2.490, 14.246, -0.268> <-2.491, 14.233, -0.268> <-2.488, 14.215, -0.265> <-2.489, 14.203, -0.261> 
		<-2.490, 14.244, -0.278> <-2.491, 14.231, -0.278> <-2.488, 14.213, -0.276> <-2.489, 14.200, -0.272> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.489, 14.208, -0.233> <-2.490, 14.202, -0.233> <-2.494, 14.192, -0.235> <-2.495, 14.188, -0.240> 
		<-2.489, 14.206, -0.245> <-2.490, 14.199, -0.244> <-2.495, 14.188, -0.239> <-2.496, 14.184, -0.244> 
		<-2.489, 14.203, -0.261> <-2.490, 14.196, -0.259> <-2.495, 14.184, -0.260> <-2.496, 14.182, -0.254> 
		<-2.489, 14.200, -0.272> <-2.490, 14.194, -0.270> <-2.494, 14.186, -0.265> <-2.495, 14.184, -0.259> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.503, 14.260, -0.300> <-2.502, 14.263, -0.301> <-2.498, 14.265, -0.297> <-2.497, 14.264, -0.294> 
		<-2.506, 14.252, -0.300> <-2.505, 14.254, -0.300> <-2.494, 14.262, -0.289> <-2.493, 14.260, -0.287> 
		<-2.508, 14.240, -0.296> <-2.502, 14.245, -0.290> <-2.496, 14.249, -0.284> <-2.490, 14.253, -0.278> 
		<-2.509, 14.232, -0.292> <-2.503, 14.236, -0.286> <-2.494, 14.242, -0.278> <-2.488, 14.246, -0.272> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.488, 14.246, -0.272> <-2.485, 14.236, -0.264> <-2.480, 14.221, -0.255> <-2.480, 14.209, -0.249> 
		<-2.494, 14.242, -0.278> <-2.491, 14.232, -0.270> <-2.487, 14.216, -0.263> <-2.487, 14.204, -0.257> 
		<-2.503, 14.236, -0.286> <-2.503, 14.224, -0.282> <-2.499, 14.208, -0.275> <-2.497, 14.197, -0.267> 
		<-2.509, 14.232, -0.292> <-2.509, 14.220, -0.288> <-2.507, 14.203, -0.282> <-2.505, 14.192, -0.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.480, 14.209, -0.249> <-2.480, 14.204, -0.246> <-2.484, 14.195, -0.242> <-2.488, 14.190, -0.243> 
		<-2.487, 14.204, -0.257> <-2.487, 14.199, -0.254> <-2.488, 14.191, -0.243> <-2.492, 14.186, -0.244> 
		<-2.497, 14.197, -0.267> <-2.497, 14.192, -0.263> <-2.501, 14.182, -0.256> <-2.498, 14.181, -0.251> 
		<-2.505, 14.192, -0.274> <-2.504, 14.187, -0.271> <-2.504, 14.182, -0.262> <-2.501, 14.182, -0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.563, 14.234, -0.287> <-2.563, 14.236, -0.289> <-2.560, 14.237, -0.294> <-2.557, 14.236, -0.294> 
		<-2.561, 14.229, -0.279> <-2.562, 14.231, -0.282> <-2.551, 14.234, -0.294> <-2.549, 14.233, -0.295> 
		<-2.556, 14.223, -0.271> <-2.549, 14.225, -0.278> <-2.544, 14.226, -0.285> <-2.538, 14.227, -0.292> 
		<-2.551, 14.218, -0.265> <-2.545, 14.219, -0.273> <-2.537, 14.221, -0.282> <-2.531, 14.222, -0.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.531, 14.222, -0.289> <-2.520, 14.215, -0.286> <-2.508, 14.203, -0.282> <-2.500, 14.195, -0.275> 
		<-2.537, 14.221, -0.282> <-2.526, 14.214, -0.279> <-2.516, 14.201, -0.273> <-2.507, 14.193, -0.266> 
		<-2.545, 14.219, -0.273> <-2.538, 14.211, -0.265> <-2.527, 14.198, -0.259> <-2.518, 14.191, -0.254> 
		<-2.551, 14.218, -0.265> <-2.544, 14.209, -0.258> <-2.535, 14.196, -0.250> <-2.525, 14.189, -0.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.500, 14.195, -0.275> <-2.496, 14.191, -0.271> <-2.491, 14.188, -0.262> <-2.492, 14.186, -0.256> 
		<-2.507, 14.193, -0.266> <-2.503, 14.189, -0.262> <-2.492, 14.186, -0.257> <-2.493, 14.184, -0.251> 
		<-2.518, 14.191, -0.254> <-2.513, 14.187, -0.251> <-2.505, 14.183, -0.241> <-2.499, 14.183, -0.243> 
		<-2.525, 14.189, -0.245> <-2.520, 14.185, -0.242> <-2.511, 14.183, -0.239> <-2.505, 14.183, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.533, 14.244, -0.307> <-2.532, 14.246, -0.309> <-2.527, 14.249, -0.309> <-2.524, 14.248, -0.308> 
		<-2.535, 14.237, -0.302> <-2.535, 14.240, -0.304> <-2.519, 14.246, -0.305> <-2.517, 14.246, -0.304> 
		<-2.535, 14.228, -0.294> <-2.526, 14.232, -0.294> <-2.518, 14.236, -0.295> <-2.509, 14.240, -0.296> 
		<-2.533, 14.222, -0.288> <-2.524, 14.225, -0.289> <-2.513, 14.231, -0.290> <-2.504, 14.235, -0.291> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.504, 14.235, -0.291> <-2.496, 14.227, -0.284> <-2.487, 14.214, -0.276> <-2.483, 14.204, -0.267> 
		<-2.513, 14.231, -0.290> <-2.505, 14.223, -0.283> <-2.498, 14.209, -0.275> <-2.494, 14.199, -0.266> 
		<-2.524, 14.225, -0.289> <-2.522, 14.215, -0.281> <-2.514, 14.201, -0.273> <-2.508, 14.193, -0.265> 
		<-2.533, 14.222, -0.288> <-2.530, 14.211, -0.280> <-2.525, 14.196, -0.272> <-2.519, 14.188, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.483, 14.204, -0.267> <-2.481, 14.200, -0.263> <-2.482, 14.194, -0.254> <-2.486, 14.190, -0.251> 
		<-2.494, 14.199, -0.266> <-2.492, 14.195, -0.262> <-2.486, 14.190, -0.251> <-2.490, 14.186, -0.248> 
		<-2.508, 14.193, -0.265> <-2.505, 14.189, -0.261> <-2.505, 14.182, -0.250> <-2.499, 14.182, -0.247> 
		<-2.519, 14.188, -0.264> <-2.516, 14.184, -0.260> <-2.510, 14.181, -0.252> <-2.504, 14.182, -0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.571, 14.237, -0.254> <-2.573, 14.238, -0.256> <-2.573, 14.237, -0.262> <-2.571, 14.235, -0.263> 
		<-2.565, 14.234, -0.248> <-2.567, 14.235, -0.250> <-2.567, 14.232, -0.266> <-2.565, 14.230, -0.268> 
		<-2.555, 14.229, -0.243> <-2.555, 14.227, -0.253> <-2.555, 14.225, -0.261> <-2.555, 14.223, -0.271> 
		<-2.548, 14.224, -0.240> <-2.548, 14.222, -0.250> <-2.548, 14.220, -0.262> <-2.548, 14.218, -0.272> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.548, 14.218, -0.272> <-2.538, 14.209, -0.273> <-2.526, 14.196, -0.273> <-2.515, 14.188, -0.270> 
		<-2.548, 14.220, -0.262> <-2.538, 14.211, -0.264> <-2.526, 14.198, -0.261> <-2.515, 14.191, -0.259> 
		<-2.548, 14.222, -0.250> <-2.538, 14.215, -0.246> <-2.526, 14.202, -0.243> <-2.515, 14.194, -0.243> 
		<-2.548, 14.224, -0.240> <-2.538, 14.217, -0.236> <-2.526, 14.204, -0.231> <-2.515, 14.196, -0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.515, 14.188, -0.270> <-2.510, 14.185, -0.269> <-2.501, 14.183, -0.265> <-2.498, 14.183, -0.259> 
		<-2.515, 14.191, -0.259> <-2.510, 14.187, -0.257> <-2.498, 14.183, -0.259> <-2.495, 14.182, -0.254> 
		<-2.515, 14.194, -0.243> <-2.510, 14.190, -0.243> <-2.498, 14.187, -0.239> <-2.495, 14.184, -0.244> 
		<-2.515, 14.196, -0.231> <-2.510, 14.192, -0.231> <-2.501, 14.189, -0.234> <-2.498, 14.187, -0.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.555, 14.250, -0.224> <-2.558, 14.251, -0.225> <-2.562, 14.249, -0.229> <-2.561, 14.246, -0.230> 
		<-2.547, 14.248, -0.223> <-2.549, 14.249, -0.223> <-2.560, 14.241, -0.234> <-2.560, 14.239, -0.235> 
		<-2.536, 14.242, -0.223> <-2.542, 14.238, -0.230> <-2.548, 14.234, -0.235> <-2.554, 14.230, -0.241> 
		<-2.529, 14.236, -0.224> <-2.535, 14.232, -0.230> <-2.544, 14.227, -0.238> <-2.550, 14.222, -0.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.550, 14.222, -0.244> <-2.543, 14.212, -0.248> <-2.534, 14.196, -0.251> <-2.524, 14.188, -0.253> 
		<-2.544, 14.227, -0.238> <-2.537, 14.216, -0.242> <-2.526, 14.201, -0.243> <-2.517, 14.193, -0.245> 
		<-2.535, 14.232, -0.230> <-2.525, 14.224, -0.230> <-2.515, 14.209, -0.231> <-2.507, 14.200, -0.235> 
		<-2.529, 14.236, -0.224> <-2.519, 14.228, -0.224> <-2.507, 14.214, -0.224> <-2.499, 14.205, -0.227> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.524, 14.188, -0.253> <-2.520, 14.183, -0.254> <-2.510, 14.181, -0.256> <-2.504, 14.181, -0.254> 
		<-2.517, 14.193, -0.245> <-2.512, 14.188, -0.246> <-2.504, 14.181, -0.254> <-2.498, 14.181, -0.252> 
		<-2.507, 14.200, -0.235> <-2.503, 14.195, -0.237> <-2.491, 14.190, -0.240> <-2.492, 14.186, -0.245> 
		<-2.499, 14.205, -0.227> <-2.495, 14.200, -0.229> <-2.490, 14.194, -0.236> <-2.491, 14.189, -0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.533, 14.278, -0.234> <-2.534, 14.279, -0.234> <-2.539, 14.277, -0.233> <-2.539, 14.275, -0.234> 
		<-2.526, 14.272, -0.236> <-2.527, 14.273, -0.235> <-2.539, 14.268, -0.234> <-2.539, 14.266, -0.235> 
		<-2.519, 14.261, -0.238> <-2.525, 14.258, -0.238> <-2.531, 14.256, -0.237> <-2.537, 14.253, -0.237> 
		<-2.514, 14.253, -0.239> <-2.520, 14.250, -0.239> <-2.528, 14.247, -0.238> <-2.534, 14.244, -0.237> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.534, 14.244, -0.237> <-2.530, 14.229, -0.239> <-2.523, 14.210, -0.238> <-2.516, 14.196, -0.240> 
		<-2.528, 14.247, -0.238> <-2.524, 14.232, -0.239> <-2.516, 14.213, -0.239> <-2.509, 14.200, -0.241> 
		<-2.520, 14.250, -0.239> <-2.512, 14.237, -0.240> <-2.504, 14.219, -0.240> <-2.499, 14.204, -0.242> 
		<-2.514, 14.253, -0.239> <-2.506, 14.240, -0.241> <-2.496, 14.222, -0.241> <-2.491, 14.208, -0.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.516, 14.196, -0.240> <-2.513, 14.191, -0.241> <-2.508, 14.184, -0.245> <-2.502, 14.182, -0.247> 
		<-2.509, 14.200, -0.241> <-2.506, 14.194, -0.242> <-2.504, 14.182, -0.246> <-2.499, 14.180, -0.248> 
		<-2.499, 14.204, -0.242> <-2.496, 14.198, -0.243> <-2.489, 14.189, -0.248> <-2.491, 14.184, -0.248> 
		<-2.491, 14.208, -0.243> <-2.489, 14.202, -0.243> <-2.487, 14.193, -0.247> <-2.490, 14.187, -0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.512, 14.285, -0.249> <-2.513, 14.286, -0.248> <-2.516, 14.286, -0.244> <-2.516, 14.284, -0.244> 
		<-2.508, 14.277, -0.252> <-2.509, 14.279, -0.252> <-2.517, 14.277, -0.242> <-2.517, 14.275, -0.241> 
		<-2.504, 14.265, -0.255> <-2.508, 14.264, -0.250> <-2.513, 14.263, -0.245> <-2.517, 14.262, -0.240> 
		<-2.501, 14.256, -0.256> <-2.505, 14.255, -0.251> <-2.511, 14.253, -0.244> <-2.516, 14.252, -0.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.516, 14.252, -0.239> <-2.513, 14.237, -0.237> <-2.508, 14.218, -0.234> <-2.505, 14.203, -0.235> 
		<-2.511, 14.253, -0.244> <-2.509, 14.238, -0.242> <-2.503, 14.219, -0.241> <-2.499, 14.204, -0.242> 
		<-2.505, 14.255, -0.251> <-2.501, 14.240, -0.252> <-2.495, 14.221, -0.251> <-2.492, 14.206, -0.250> 
		<-2.501, 14.256, -0.256> <-2.496, 14.241, -0.257> <-2.489, 14.222, -0.257> <-2.487, 14.207, -0.257> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.505, 14.203, -0.235> <-2.503, 14.197, -0.236> <-2.502, 14.188, -0.239> <-2.498, 14.184, -0.243> 
		<-2.499, 14.204, -0.242> <-2.498, 14.198, -0.242> <-2.500, 14.185, -0.242> <-2.496, 14.182, -0.246> 
		<-2.492, 14.206, -0.250> <-2.491, 14.200, -0.250> <-2.489, 14.188, -0.255> <-2.491, 14.183, -0.252> 
		<-2.487, 14.207, -0.257> <-2.486, 14.201, -0.256> <-2.487, 14.191, -0.257> <-2.489, 14.186, -0.254> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, 14.282, -0.273> <-2.507, 14.284, -0.272> <-2.507, 14.285, -0.267> <-2.507, 14.284, -0.266> 
		<-2.506, 14.273, -0.275> <-2.506, 14.275, -0.274> <-2.506, 14.278, -0.261> <-2.506, 14.276, -0.260> 
		<-2.505, 14.260, -0.275> <-2.505, 14.262, -0.268> <-2.505, 14.263, -0.262> <-2.505, 14.264, -0.255> 
		<-2.503, 14.251, -0.274> <-2.503, 14.252, -0.267> <-2.503, 14.254, -0.259> <-2.503, 14.256, -0.252> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.503, 14.256, -0.252> <-2.501, 14.241, -0.247> <-2.496, 14.222, -0.241> <-2.494, 14.207, -0.239> 
		<-2.503, 14.254, -0.259> <-2.501, 14.240, -0.254> <-2.496, 14.221, -0.249> <-2.494, 14.205, -0.247> 
		<-2.503, 14.252, -0.267> <-2.501, 14.237, -0.266> <-2.496, 14.218, -0.262> <-2.494, 14.203, -0.258> 
		<-2.503, 14.251, -0.274> <-2.501, 14.236, -0.273> <-2.496, 14.216, -0.271> <-2.494, 14.202, -0.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.494, 14.207, -0.239> <-2.493, 14.201, -0.238> <-2.494, 14.191, -0.238> <-2.495, 14.186, -0.242> 
		<-2.494, 14.205, -0.247> <-2.493, 14.199, -0.246> <-2.494, 14.188, -0.241> <-2.495, 14.183, -0.244> 
		<-2.494, 14.203, -0.258> <-2.493, 14.197, -0.257> <-2.494, 14.185, -0.258> <-2.495, 14.181, -0.252> 
		<-2.494, 14.202, -0.267> <-2.493, 14.196, -0.265> <-2.494, 14.187, -0.261> <-2.495, 14.183, -0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.517, 14.273, -0.292> <-2.517, 14.275, -0.292> <-2.514, 14.278, -0.289> <-2.513, 14.276, -0.288> 
		<-2.518, 14.264, -0.291> <-2.518, 14.266, -0.291> <-2.510, 14.272, -0.283> <-2.509, 14.270, -0.282> 
		<-2.518, 14.252, -0.287> <-2.514, 14.255, -0.283> <-2.509, 14.258, -0.279> <-2.505, 14.260, -0.275> 
		<-2.517, 14.243, -0.284> <-2.512, 14.246, -0.280> <-2.506, 14.250, -0.274> <-2.502, 14.253, -0.270> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.502, 14.253, -0.270> <-2.497, 14.240, -0.263> <-2.490, 14.222, -0.256> <-2.487, 14.208, -0.250> 
		<-2.506, 14.250, -0.274> <-2.502, 14.237, -0.267> <-2.495, 14.218, -0.261> <-2.493, 14.204, -0.256> 
		<-2.512, 14.246, -0.280> <-2.510, 14.231, -0.276> <-2.504, 14.213, -0.269> <-2.500, 14.200, -0.263> 
		<-2.517, 14.243, -0.284> <-2.514, 14.228, -0.280> <-2.509, 14.209, -0.275> <-2.505, 14.196, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.487, 14.208, -0.250> <-2.486, 14.202, -0.248> <-2.487, 14.194, -0.244> <-2.490, 14.188, -0.245> 
		<-2.493, 14.204, -0.256> <-2.491, 14.199, -0.253> <-2.489, 14.190, -0.244> <-2.492, 14.184, -0.245> 
		<-2.500, 14.200, -0.263> <-2.498, 14.194, -0.260> <-2.500, 14.182, -0.255> <-2.497, 14.181, -0.250> 
		<-2.505, 14.196, -0.268> <-2.504, 14.191, -0.265> <-2.502, 14.184, -0.259> <-2.499, 14.182, -0.254> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.560, 14.255, -0.283> <-2.561, 14.257, -0.284> <-2.557, 14.257, -0.288> <-2.556, 14.256, -0.288> 
		<-2.557, 14.249, -0.276> <-2.558, 14.250, -0.278> <-2.550, 14.252, -0.288> <-2.548, 14.251, -0.288> 
		<-2.551, 14.240, -0.270> <-2.547, 14.241, -0.275> <-2.543, 14.242, -0.280> <-2.538, 14.243, -0.285> 
		<-2.546, 14.233, -0.265> <-2.542, 14.234, -0.271> <-2.536, 14.235, -0.277> <-2.532, 14.236, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.532, 14.236, -0.282> <-2.522, 14.225, -0.279> <-2.510, 14.209, -0.274> <-2.501, 14.198, -0.268> 
		<-2.536, 14.235, -0.277> <-2.526, 14.224, -0.274> <-2.515, 14.208, -0.268> <-2.507, 14.196, -0.262> 
		<-2.542, 14.234, -0.271> <-2.534, 14.222, -0.264> <-2.524, 14.206, -0.258> <-2.514, 14.195, -0.253> 
		<-2.546, 14.233, -0.265> <-2.539, 14.221, -0.259> <-2.529, 14.204, -0.252> <-2.519, 14.194, -0.247> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.501, 14.198, -0.268> <-2.498, 14.193, -0.266> <-2.493, 14.188, -0.259> <-2.493, 14.185, -0.254> 
		<-2.507, 14.196, -0.262> <-2.503, 14.192, -0.259> <-2.493, 14.186, -0.256> <-2.493, 14.183, -0.250> 
		<-2.514, 14.195, -0.253> <-2.510, 14.190, -0.251> <-2.504, 14.183, -0.243> <-2.498, 14.181, -0.244> 
		<-2.519, 14.194, -0.247> <-2.515, 14.189, -0.245> <-2.507, 14.185, -0.242> <-2.502, 14.183, -0.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.539, 14.262, -0.297> <-2.539, 14.264, -0.298> <-2.534, 14.266, -0.298> <-2.533, 14.265, -0.298> 
		<-2.539, 14.254, -0.293> <-2.539, 14.256, -0.294> <-2.527, 14.261, -0.295> <-2.526, 14.260, -0.294> 
		<-2.536, 14.243, -0.286> <-2.530, 14.246, -0.286> <-2.524, 14.249, -0.287> <-2.518, 14.252, -0.287> 
		<-2.534, 14.235, -0.282> <-2.527, 14.238, -0.282> <-2.519, 14.242, -0.283> <-2.513, 14.245, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.513, 14.245, -0.283> <-2.505, 14.233, -0.277> <-2.495, 14.217, -0.270> <-2.490, 14.204, -0.263> 
		<-2.519, 14.242, -0.283> <-2.511, 14.231, -0.276> <-2.503, 14.213, -0.269> <-2.497, 14.201, -0.262> 
		<-2.527, 14.238, -0.282> <-2.523, 14.225, -0.275> <-2.514, 14.208, -0.268> <-2.507, 14.196, -0.261> 
		<-2.534, 14.235, -0.282> <-2.529, 14.222, -0.275> <-2.522, 14.204, -0.268> <-2.515, 14.193, -0.261> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.490, 14.204, -0.263> <-2.487, 14.199, -0.260> <-2.486, 14.192, -0.253> <-2.489, 14.187, -0.250> 
		<-2.497, 14.201, -0.262> <-2.495, 14.196, -0.259> <-2.488, 14.189, -0.251> <-2.490, 14.184, -0.248> 
		<-2.507, 14.196, -0.261> <-2.505, 14.191, -0.258> <-2.503, 14.182, -0.250> <-2.497, 14.181, -0.248> 
		<-2.515, 14.193, -0.261> <-2.512, 14.188, -0.258> <-2.507, 14.183, -0.251> <-2.501, 14.182, -0.249> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.565, 14.257, -0.260> <-2.567, 14.258, -0.261> <-2.567, 14.257, -0.266> <-2.565, 14.256, -0.266> 
		<-2.559, 14.252, -0.254> <-2.561, 14.253, -0.256> <-2.561, 14.251, -0.268> <-2.559, 14.249, -0.269> 
		<-2.550, 14.244, -0.250> <-2.550, 14.243, -0.257> <-2.550, 14.241, -0.263> <-2.550, 14.240, -0.270> 
		<-2.544, 14.237, -0.248> <-2.544, 14.236, -0.254> <-2.544, 14.234, -0.263> <-2.544, 14.233, -0.270> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.544, 14.233, -0.270> <-2.534, 14.221, -0.270> <-2.523, 14.204, -0.268> <-2.512, 14.193, -0.265> 
		<-2.544, 14.234, -0.263> <-2.534, 14.222, -0.263> <-2.523, 14.206, -0.260> <-2.512, 14.195, -0.257> 
		<-2.544, 14.236, -0.254> <-2.534, 14.225, -0.250> <-2.523, 14.208, -0.247> <-2.512, 14.197, -0.246> 
		<-2.544, 14.237, -0.248> <-2.534, 14.226, -0.244> <-2.523, 14.210, -0.239> <-2.512, 14.199, -0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.512, 14.193, -0.265> <-2.508, 14.189, -0.264> <-2.500, 14.184, -0.261> <-2.497, 14.182, -0.256> 
		<-2.512, 14.195, -0.257> <-2.508, 14.190, -0.256> <-2.498, 14.183, -0.257> <-2.494, 14.181, -0.252> 
		<-2.512, 14.197, -0.246> <-2.508, 14.192, -0.245> <-2.498, 14.186, -0.241> <-2.494, 14.183, -0.245> 
		<-2.512, 14.199, -0.238> <-2.508, 14.194, -0.237> <-2.500, 14.189, -0.238> <-2.497, 14.185, -0.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.554, 14.267, -0.239> <-2.556, 14.268, -0.239> <-2.559, 14.266, -0.242> <-2.559, 14.264, -0.243> 
		<-2.547, 14.262, -0.237> <-2.548, 14.263, -0.237> <-2.557, 14.257, -0.245> <-2.556, 14.255, -0.246> 
		<-2.537, 14.253, -0.237> <-2.541, 14.250, -0.241> <-2.546, 14.247, -0.245> <-2.550, 14.244, -0.249> 
		<-2.531, 14.246, -0.236> <-2.535, 14.243, -0.240> <-2.541, 14.239, -0.246> <-2.545, 14.236, -0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.545, 14.236, -0.250> <-2.538, 14.223, -0.252> <-2.528, 14.205, -0.252> <-2.519, 14.193, -0.253> 
		<-2.541, 14.239, -0.246> <-2.534, 14.226, -0.248> <-2.523, 14.208, -0.247> <-2.513, 14.196, -0.247> 
		<-2.535, 14.243, -0.240> <-2.525, 14.231, -0.240> <-2.515, 14.214, -0.239> <-2.506, 14.201, -0.240> 
		<-2.531, 14.246, -0.236> <-2.521, 14.234, -0.235> <-2.509, 14.217, -0.233> <-2.501, 14.205, -0.235> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.519, 14.193, -0.253> <-2.515, 14.188, -0.253> <-2.507, 14.182, -0.254> <-2.501, 14.181, -0.252> 
		<-2.513, 14.196, -0.247> <-2.509, 14.191, -0.248> <-2.503, 14.182, -0.253> <-2.497, 14.180, -0.250> 
		<-2.506, 14.201, -0.240> <-2.503, 14.196, -0.241> <-2.492, 14.189, -0.242> <-2.492, 14.184, -0.245> 
		<-2.501, 14.205, -0.235> <-2.497, 14.199, -0.236> <-2.492, 14.192, -0.239> <-2.492, 14.187, -0.243> 
	}

	texture { txFlowers }
}

// Layer 3
#declare oLeaves =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.493, 14.131, -0.161> <-0.492, 14.127, -0.165> <-0.488, 14.125, -0.171> <-0.488, 14.122, -0.176> 
		<-0.489, 14.128, -0.160> <-0.489, 14.124, -0.164> <-0.485, 14.122, -0.171> <-0.485, 14.119, -0.176> 
		<-0.482, 14.127, -0.160> <-0.482, 14.123, -0.164> <-0.480, 14.119, -0.170> <-0.480, 14.116, -0.174> 
		<-0.478, 14.124, -0.160> <-0.478, 14.121, -0.164> <-0.476, 14.116, -0.169> <-0.476, 14.113, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.493, 14.131, -0.161> <-0.489, 14.128, -0.160> <-0.482, 14.127, -0.160> <-0.478, 14.124, -0.160> 
		<-0.493, 14.136, -0.155> <-0.490, 14.133, -0.154> <-0.484, 14.135, -0.152> <-0.480, 14.133, -0.151> 
		<-0.491, 14.145, -0.149> <-0.488, 14.142, -0.149> <-0.484, 14.143, -0.144> <-0.481, 14.144, -0.140> 
		<-0.491, 14.151, -0.145> <-0.487, 14.148, -0.144> <-0.485, 14.152, -0.136> <-0.483, 14.152, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.493, 14.131, -0.161> <-0.498, 14.136, -0.162> <-0.503, 14.145, -0.164> <-0.507, 14.151, -0.166> 
		<-0.492, 14.127, -0.165> <-0.498, 14.132, -0.166> <-0.502, 14.143, -0.168> <-0.507, 14.149, -0.169> 
		<-0.488, 14.125, -0.171> <-0.498, 14.134, -0.172> <-0.505, 14.143, -0.173> <-0.514, 14.152, -0.173> 
		<-0.488, 14.122, -0.176> <-0.497, 14.131, -0.177> <-0.508, 14.144, -0.176> <-0.517, 14.153, -0.176> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.493, 14.131, -0.161> <-0.493, 14.136, -0.155> <-0.491, 14.145, -0.149> <-0.491, 14.151, -0.145> 
		<-0.498, 14.136, -0.162> <-0.499, 14.141, -0.156> <-0.502, 14.152, -0.151> <-0.501, 14.158, -0.146> 
		<-0.503, 14.145, -0.164> <-0.504, 14.152, -0.154> <-0.508, 14.162, -0.149> <-0.512, 14.171, -0.140> 
		<-0.507, 14.151, -0.166> <-0.508, 14.158, -0.156> <-0.517, 14.171, -0.147> <-0.521, 14.179, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.478, 14.124, -0.160> <-0.478, 14.121, -0.164> <-0.476, 14.116, -0.169> <-0.476, 14.113, -0.173> 
		<-0.475, 14.122, -0.160> <-0.474, 14.119, -0.164> <-0.473, 14.114, -0.168> <-0.473, 14.111, -0.172> 
		<-0.471, 14.118, -0.159> <-0.471, 14.114, -0.162> <-0.469, 14.110, -0.168> <-0.469, 14.108, -0.171> 
		<-0.467, 14.116, -0.158> <-0.467, 14.113, -0.162> <-0.466, 14.109, -0.167> <-0.465, 14.106, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.478, 14.124, -0.160> <-0.475, 14.122, -0.160> <-0.471, 14.118, -0.159> <-0.467, 14.116, -0.158> 
		<-0.480, 14.133, -0.151> <-0.476, 14.130, -0.151> <-0.472, 14.123, -0.154> <-0.468, 14.121, -0.153> 
		<-0.481, 14.144, -0.140> <-0.477, 14.139, -0.144> <-0.474, 14.134, -0.146> <-0.469, 14.129, -0.147> 
		<-0.483, 14.152, -0.132> <-0.479, 14.147, -0.135> <-0.475, 14.140, -0.142> <-0.469, 14.135, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.467, 14.116, -0.158> <-0.462, 14.113, -0.157> <-0.454, 14.112, -0.156> <-0.449, 14.111, -0.155> 
		<-0.468, 14.121, -0.153> <-0.463, 14.119, -0.152> <-0.459, 14.119, -0.152> <-0.453, 14.117, -0.151> 
		<-0.469, 14.129, -0.147> <-0.466, 14.127, -0.148> <-0.459, 14.126, -0.144> <-0.456, 14.125, -0.142> 
		<-0.469, 14.135, -0.143> <-0.467, 14.132, -0.143> <-0.463, 14.132, -0.138> <-0.460, 14.131, -0.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.467, 14.116, -0.158> <-0.467, 14.113, -0.162> <-0.466, 14.109, -0.167> <-0.465, 14.106, -0.170> 
		<-0.462, 14.113, -0.157> <-0.462, 14.110, -0.161> <-0.457, 14.106, -0.164> <-0.457, 14.103, -0.168> 
		<-0.454, 14.112, -0.156> <-0.452, 14.108, -0.159> <-0.449, 14.104, -0.162> <-0.445, 14.099, -0.164> 
		<-0.449, 14.111, -0.155> <-0.446, 14.106, -0.158> <-0.440, 14.101, -0.159> <-0.436, 14.097, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.465, 14.106, -0.170> <-0.469, 14.108, -0.171> <-0.473, 14.111, -0.172> <-0.476, 14.113, -0.173> 
		<-0.465, 14.104, -0.173> <-0.468, 14.105, -0.174> <-0.473, 14.109, -0.175> <-0.476, 14.111, -0.176> 
		<-0.466, 14.100, -0.177> <-0.470, 14.102, -0.178> <-0.474, 14.107, -0.179> <-0.477, 14.109, -0.180> 
		<-0.466, 14.099, -0.180> <-0.470, 14.100, -0.181> <-0.474, 14.105, -0.182> <-0.477, 14.108, -0.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.465, 14.106, -0.170> <-0.465, 14.104, -0.173> <-0.466, 14.100, -0.177> <-0.466, 14.099, -0.180> 
		<-0.457, 14.103, -0.168> <-0.456, 14.100, -0.171> <-0.460, 14.098, -0.175> <-0.460, 14.096, -0.179> 
		<-0.445, 14.099, -0.164> <-0.447, 14.099, -0.168> <-0.451, 14.099, -0.173> <-0.451, 14.096, -0.177> 
		<-0.436, 14.097, -0.161> <-0.439, 14.096, -0.165> <-0.445, 14.097, -0.171> <-0.445, 14.095, -0.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, 14.113, -0.173> <-0.480, 14.116, -0.174> <-0.485, 14.119, -0.176> <-0.488, 14.122, -0.176> 
		<-0.476, 14.111, -0.176> <-0.479, 14.113, -0.177> <-0.484, 14.117, -0.180> <-0.487, 14.120, -0.180> 
		<-0.477, 14.109, -0.180> <-0.481, 14.111, -0.182> <-0.487, 14.113, -0.184> <-0.490, 14.116, -0.185> 
		<-0.477, 14.108, -0.184> <-0.481, 14.110, -0.185> <-0.487, 14.111, -0.188> <-0.490, 14.114, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.488, 14.122, -0.176> <-0.497, 14.131, -0.177> <-0.508, 14.144, -0.176> <-0.517, 14.153, -0.176> 
		<-0.487, 14.120, -0.180> <-0.497, 14.129, -0.181> <-0.503, 14.136, -0.180> <-0.511, 14.146, -0.180> 
		<-0.490, 14.116, -0.185> <-0.494, 14.120, -0.186> <-0.499, 14.131, -0.183> <-0.502, 14.136, -0.183> 
		<-0.490, 14.114, -0.189> <-0.493, 14.118, -0.190> <-0.495, 14.124, -0.190> <-0.498, 14.129, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.490, 14.114, -0.189> <-0.493, 14.118, -0.190> <-0.495, 14.124, -0.190> <-0.498, 14.129, -0.190> 
		<-0.489, 14.112, -0.194> <-0.492, 14.115, -0.195> <-0.494, 14.122, -0.192> <-0.496, 14.126, -0.192> 
		<-0.484, 14.110, -0.199> <-0.489, 14.115, -0.197> <-0.495, 14.121, -0.198> <-0.500, 14.126, -0.198> 
		<-0.482, 14.108, -0.203> <-0.487, 14.113, -0.201> <-0.496, 14.119, -0.202> <-0.502, 14.124, -0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.490, 14.114, -0.189> <-0.489, 14.112, -0.194> <-0.484, 14.110, -0.199> <-0.482, 14.108, -0.203> 
		<-0.487, 14.111, -0.188> <-0.486, 14.109, -0.193> <-0.481, 14.106, -0.200> <-0.479, 14.104, -0.204> 
		<-0.481, 14.110, -0.185> <-0.481, 14.106, -0.194> <-0.478, 14.103, -0.201> <-0.477, 14.100, -0.210> 
		<-0.477, 14.108, -0.184> <-0.477, 14.104, -0.192> <-0.476, 14.099, -0.204> <-0.475, 14.096, -0.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.477, 14.108, -0.184> <-0.477, 14.104, -0.192> <-0.476, 14.099, -0.204> <-0.475, 14.096, -0.213> 
		<-0.474, 14.105, -0.182> <-0.474, 14.102, -0.191> <-0.472, 14.099, -0.200> <-0.472, 14.096, -0.209> 
		<-0.470, 14.100, -0.181> <-0.470, 14.098, -0.187> <-0.469, 14.099, -0.195> <-0.468, 14.098, -0.201> 
		<-0.466, 14.099, -0.180> <-0.465, 14.097, -0.186> <-0.464, 14.096, -0.194> <-0.464, 14.095, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.466, 14.099, -0.180> <-0.465, 14.097, -0.186> <-0.464, 14.096, -0.194> <-0.464, 14.095, -0.200> 
		<-0.460, 14.096, -0.179> <-0.459, 14.094, -0.184> <-0.454, 14.090, -0.191> <-0.454, 14.089, -0.197> 
		<-0.451, 14.096, -0.177> <-0.450, 14.089, -0.187> <-0.446, 14.084, -0.194> <-0.442, 14.076, -0.202> 
		<-0.445, 14.095, -0.175> <-0.444, 14.088, -0.185> <-0.437, 14.076, -0.195> <-0.433, 14.068, -0.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.109, 13.573, -0.198> <-1.106, 13.568, -0.198> <-1.099, 13.565, -0.202> <-1.096, 13.561, -0.203> 
		<-1.105, 13.573, -0.196> <-1.102, 13.569, -0.196> <-1.095, 13.565, -0.199> <-1.091, 13.561, -0.201> 
		<-1.099, 13.576, -0.196> <-1.095, 13.572, -0.196> <-1.089, 13.567, -0.197> <-1.086, 13.563, -0.197> 
		<-1.094, 13.578, -0.194> <-1.091, 13.574, -0.194> <-1.086, 13.569, -0.194> <-1.083, 13.564, -0.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.109, 13.573, -0.198> <-1.105, 13.573, -0.196> <-1.099, 13.576, -0.196> <-1.094, 13.578, -0.194> 
		<-1.114, 13.579, -0.198> <-1.110, 13.580, -0.196> <-1.106, 13.585, -0.196> <-1.102, 13.587, -0.194> 
		<-1.118, 13.588, -0.201> <-1.114, 13.589, -0.199> <-1.113, 13.595, -0.197> <-1.112, 13.599, -0.195> 
		<-1.122, 13.595, -0.202> <-1.118, 13.596, -0.200> <-1.120, 13.604, -0.197> <-1.120, 13.608, -0.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.109, 13.573, -0.198> <-1.115, 13.572, -0.202> <-1.122, 13.572, -0.210> <-1.128, 13.572, -0.215> 
		<-1.106, 13.568, -0.198> <-1.112, 13.567, -0.202> <-1.120, 13.569, -0.210> <-1.125, 13.569, -0.215> 
		<-1.099, 13.565, -0.202> <-1.110, 13.564, -0.207> <-1.120, 13.564, -0.214> <-1.132, 13.565, -0.220> 
		<-1.096, 13.561, -0.203> <-1.107, 13.560, -0.209> <-1.122, 13.561, -0.216> <-1.133, 13.561, -0.222> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.109, 13.573, -0.198> <-1.114, 13.579, -0.198> <-1.118, 13.588, -0.201> <-1.122, 13.595, -0.202> 
		<-1.115, 13.572, -0.202> <-1.120, 13.578, -0.202> <-1.129, 13.585, -0.206> <-1.132, 13.592, -0.207> 
		<-1.122, 13.572, -0.210> <-1.130, 13.582, -0.208> <-1.139, 13.589, -0.211> <-1.149, 13.596, -0.211> 
		<-1.128, 13.572, -0.215> <-1.135, 13.582, -0.213> <-1.151, 13.589, -0.215> <-1.161, 13.597, -0.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.094, 13.578, -0.194> <-1.091, 13.574, -0.194> <-1.086, 13.569, -0.194> <-1.083, 13.564, -0.195> 
		<-1.090, 13.579, -0.193> <-1.087, 13.575, -0.193> <-1.082, 13.570, -0.192> <-1.079, 13.565, -0.193> 
		<-1.086, 13.579, -0.189> <-1.083, 13.575, -0.189> <-1.078, 13.570, -0.190> <-1.075, 13.567, -0.191> 
		<-1.082, 13.580, -0.188> <-1.079, 13.577, -0.188> <-1.075, 13.572, -0.189> <-1.072, 13.568, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.094, 13.578, -0.194> <-1.090, 13.579, -0.193> <-1.086, 13.579, -0.189> <-1.082, 13.580, -0.188> 
		<-1.102, 13.587, -0.194> <-1.098, 13.588, -0.193> <-1.090, 13.584, -0.190> <-1.087, 13.586, -0.188> 
		<-1.112, 13.599, -0.195> <-1.105, 13.596, -0.194> <-1.100, 13.594, -0.192> <-1.093, 13.593, -0.190> 
		<-1.120, 13.608, -0.195> <-1.113, 13.605, -0.194> <-1.104, 13.600, -0.193> <-1.097, 13.599, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.082, 13.580, -0.188> <-1.077, 13.582, -0.186> <-1.070, 13.587, -0.185> <-1.066, 13.590, -0.184> 
		<-1.087, 13.586, -0.188> <-1.082, 13.588, -0.187> <-1.078, 13.591, -0.186> <-1.073, 13.593, -0.185> 
		<-1.093, 13.593, -0.190> <-1.089, 13.593, -0.189> <-1.085, 13.599, -0.187> <-1.082, 13.601, -0.185> 
		<-1.097, 13.599, -0.191> <-1.094, 13.599, -0.190> <-1.092, 13.604, -0.187> <-1.090, 13.606, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.082, 13.580, -0.188> <-1.079, 13.577, -0.188> <-1.075, 13.572, -0.189> <-1.072, 13.568, -0.189> 
		<-1.077, 13.582, -0.186> <-1.074, 13.579, -0.186> <-1.067, 13.577, -0.185> <-1.064, 13.573, -0.186> 
		<-1.070, 13.587, -0.185> <-1.065, 13.584, -0.185> <-1.060, 13.582, -0.184> <-1.054, 13.580, -0.182> 
		<-1.066, 13.590, -0.184> <-1.060, 13.587, -0.183> <-1.052, 13.587, -0.181> <-1.047, 13.585, -0.179> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.072, 13.568, -0.189> <-1.075, 13.567, -0.191> <-1.079, 13.565, -0.193> <-1.083, 13.564, -0.195> 
		<-1.070, 13.566, -0.190> <-1.073, 13.564, -0.191> <-1.077, 13.563, -0.194> <-1.081, 13.561, -0.195> 
		<-1.067, 13.561, -0.189> <-1.071, 13.559, -0.191> <-1.076, 13.558, -0.195> <-1.080, 13.557, -0.197> 
		<-1.066, 13.558, -0.191> <-1.069, 13.556, -0.192> <-1.074, 13.556, -0.196> <-1.078, 13.554, -0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.072, 13.568, -0.189> <-1.070, 13.566, -0.190> <-1.067, 13.561, -0.189> <-1.066, 13.558, -0.191> 
		<-1.064, 13.573, -0.186> <-1.062, 13.570, -0.186> <-1.062, 13.564, -0.187> <-1.060, 13.561, -0.188> 
		<-1.054, 13.580, -0.182> <-1.055, 13.576, -0.184> <-1.056, 13.571, -0.187> <-1.053, 13.567, -0.188> 
		<-1.047, 13.585, -0.179> <-1.047, 13.581, -0.181> <-1.051, 13.574, -0.186> <-1.048, 13.570, -0.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.083, 13.564, -0.195> <-1.086, 13.563, -0.197> <-1.091, 13.561, -0.201> <-1.096, 13.561, -0.203> 
		<-1.081, 13.561, -0.195> <-1.084, 13.560, -0.198> <-1.089, 13.557, -0.202> <-1.093, 13.557, -0.204> 
		<-1.080, 13.557, -0.197> <-1.083, 13.555, -0.199> <-1.088, 13.551, -0.202> <-1.092, 13.550, -0.204> 
		<-1.078, 13.554, -0.198> <-1.081, 13.552, -0.200> <-1.085, 13.547, -0.203> <-1.089, 13.547, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.096, 13.561, -0.203> <-1.107, 13.560, -0.209> <-1.122, 13.561, -0.216> <-1.133, 13.561, -0.222> 
		<-1.093, 13.557, -0.204> <-1.104, 13.556, -0.210> <-1.113, 13.558, -0.214> <-1.124, 13.558, -0.220> 
		<-1.092, 13.550, -0.204> <-1.096, 13.549, -0.207> <-1.107, 13.555, -0.213> <-1.111, 13.556, -0.216> 
		<-1.089, 13.547, -0.205> <-1.093, 13.546, -0.208> <-1.098, 13.549, -0.213> <-1.102, 13.550, -0.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.089, 13.547, -0.205> <-1.093, 13.546, -0.208> <-1.098, 13.549, -0.213> <-1.102, 13.550, -0.216> 
		<-1.086, 13.543, -0.207> <-1.090, 13.543, -0.210> <-1.095, 13.547, -0.212> <-1.099, 13.548, -0.216> 
		<-1.080, 13.541, -0.209> <-1.087, 13.543, -0.211> <-1.093, 13.542, -0.216> <-1.100, 13.541, -0.219> 
		<-1.076, 13.539, -0.211> <-1.083, 13.541, -0.213> <-1.092, 13.538, -0.217> <-1.099, 13.537, -0.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.089, 13.547, -0.205> <-1.086, 13.543, -0.207> <-1.080, 13.541, -0.209> <-1.076, 13.539, -0.211> 
		<-1.085, 13.547, -0.203> <-1.082, 13.544, -0.204> <-1.075, 13.540, -0.208> <-1.071, 13.538, -0.210> 
		<-1.081, 13.552, -0.200> <-1.077, 13.545, -0.204> <-1.070, 13.540, -0.207> <-1.065, 13.533, -0.210> 
		<-1.078, 13.554, -0.198> <-1.073, 13.546, -0.201> <-1.066, 13.537, -0.206> <-1.061, 13.530, -0.210> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.078, 13.554, -0.198> <-1.073, 13.546, -0.201> <-1.066, 13.537, -0.206> <-1.061, 13.530, -0.210> 
		<-1.074, 13.556, -0.196> <-1.070, 13.548, -0.199> <-1.064, 13.541, -0.204> <-1.059, 13.534, -0.207> 
		<-1.069, 13.556, -0.192> <-1.066, 13.551, -0.194> <-1.063, 13.547, -0.201> <-1.060, 13.543, -0.204> 
		<-1.066, 13.558, -0.191> <-1.062, 13.553, -0.193> <-1.059, 13.548, -0.198> <-1.056, 13.544, -0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.066, 13.558, -0.191> <-1.062, 13.553, -0.193> <-1.059, 13.548, -0.198> <-1.056, 13.544, -0.202> 
		<-1.060, 13.561, -0.188> <-1.057, 13.556, -0.191> <-1.048, 13.552, -0.193> <-1.045, 13.548, -0.196> 
		<-1.053, 13.567, -0.188> <-1.046, 13.557, -0.190> <-1.038, 13.552, -0.191> <-1.029, 13.545, -0.191> 
		<-1.048, 13.570, -0.187> <-1.041, 13.561, -0.188> <-1.027, 13.553, -0.187> <-1.017, 13.545, -0.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 13.780, 0.012> <-0.146, 13.778, 0.013> <-0.154, 13.780, 0.010> <-0.159, 13.779, 0.011> 
		<-0.142, 13.777, 0.009> <-0.147, 13.776, 0.009> <-0.155, 13.777, 0.007> <-0.161, 13.777, 0.007> 
		<-0.144, 13.778, 0.002> <-0.149, 13.776, 0.002> <-0.156, 13.774, 0.001> <-0.162, 13.773, 0.002> 
		<-0.146, 13.776, -0.002> <-0.151, 13.774, -0.002> <-0.157, 13.772, -0.003> <-0.163, 13.771, -0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 13.780, 0.012> <-0.142, 13.777, 0.009> <-0.144, 13.778, 0.002> <-0.146, 13.776, -0.002> 
		<-0.133, 13.782, 0.012> <-0.135, 13.780, 0.008> <-0.133, 13.781, 0.002> <-0.134, 13.779, -0.002> 
		<-0.125, 13.788, 0.009> <-0.126, 13.786, 0.005> <-0.122, 13.786, 0.000> <-0.119, 13.785, -0.003> 
		<-0.118, 13.792, 0.008> <-0.119, 13.789, 0.004> <-0.111, 13.789, -0.000> <-0.108, 13.789, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 13.780, 0.012> <-0.138, 13.784, 0.018> <-0.136, 13.793, 0.023> <-0.134, 13.798, 0.028> 
		<-0.146, 13.778, 0.013> <-0.144, 13.783, 0.018> <-0.140, 13.792, 0.024> <-0.138, 13.797, 0.028> 
		<-0.154, 13.780, 0.010> <-0.148, 13.787, 0.020> <-0.144, 13.794, 0.028> <-0.138, 13.801, 0.037> 
		<-0.159, 13.779, 0.011> <-0.154, 13.786, 0.020> <-0.146, 13.795, 0.031> <-0.140, 13.802, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 13.780, 0.012> <-0.133, 13.782, 0.012> <-0.125, 13.788, 0.009> <-0.118, 13.792, 0.008> 
		<-0.138, 13.784, 0.018> <-0.131, 13.787, 0.017> <-0.121, 13.794, 0.020> <-0.115, 13.797, 0.018> 
		<-0.136, 13.793, 0.023> <-0.123, 13.795, 0.023> <-0.114, 13.801, 0.025> <-0.102, 13.805, 0.028> 
		<-0.134, 13.798, 0.028> <-0.121, 13.800, 0.027> <-0.107, 13.807, 0.034> <-0.095, 13.810, 0.037> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.146, 13.776, -0.002> <-0.151, 13.774, -0.002> <-0.157, 13.772, -0.003> <-0.163, 13.771, -0.002> 
		<-0.147, 13.774, -0.006> <-0.152, 13.773, -0.006> <-0.158, 13.770, -0.006> <-0.163, 13.769, -0.005> 
		<-0.149, 13.770, -0.010> <-0.153, 13.769, -0.010> <-0.160, 13.768, -0.010> <-0.165, 13.767, -0.010> 
		<-0.150, 13.769, -0.014> <-0.154, 13.767, -0.013> <-0.160, 13.766, -0.014> <-0.165, 13.765, -0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.146, 13.776, -0.002> <-0.147, 13.774, -0.006> <-0.149, 13.770, -0.010> <-0.150, 13.769, -0.014> 
		<-0.134, 13.779, -0.002> <-0.136, 13.778, -0.006> <-0.142, 13.773, -0.010> <-0.143, 13.772, -0.014> 
		<-0.119, 13.785, -0.003> <-0.125, 13.782, -0.006> <-0.130, 13.779, -0.009> <-0.134, 13.776, -0.014> 
		<-0.108, 13.789, -0.003> <-0.114, 13.786, -0.007> <-0.124, 13.782, -0.009> <-0.128, 13.779, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 13.769, -0.014> <-0.151, 13.767, -0.019> <-0.152, 13.767, -0.027> <-0.153, 13.765, -0.033> 
		<-0.143, 13.772, -0.014> <-0.144, 13.770, -0.019> <-0.144, 13.770, -0.023> <-0.145, 13.769, -0.029> 
		<-0.134, 13.776, -0.014> <-0.136, 13.775, -0.017> <-0.134, 13.773, -0.024> <-0.134, 13.772, -0.028> 
		<-0.128, 13.779, -0.015> <-0.130, 13.778, -0.017> <-0.126, 13.776, -0.022> <-0.126, 13.774, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 13.769, -0.014> <-0.154, 13.767, -0.013> <-0.160, 13.766, -0.014> <-0.165, 13.765, -0.013> 
		<-0.151, 13.767, -0.019> <-0.156, 13.766, -0.019> <-0.161, 13.763, -0.023> <-0.166, 13.762, -0.022> 
		<-0.152, 13.767, -0.027> <-0.157, 13.764, -0.029> <-0.162, 13.762, -0.031> <-0.166, 13.760, -0.035> 
		<-0.153, 13.765, -0.033> <-0.158, 13.763, -0.035> <-0.163, 13.760, -0.041> <-0.167, 13.757, -0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.165, 13.765, -0.013> <-0.165, 13.767, -0.010> <-0.163, 13.769, -0.005> <-0.163, 13.771, -0.002> 
		<-0.169, 13.764, -0.013> <-0.168, 13.766, -0.009> <-0.167, 13.769, -0.005> <-0.166, 13.770, -0.002> 
		<-0.173, 13.762, -0.012> <-0.173, 13.764, -0.007> <-0.171, 13.768, -0.003> <-0.170, 13.770, 0.001> 
		<-0.177, 13.763, -0.011> <-0.176, 13.764, -0.007> <-0.174, 13.768, -0.002> <-0.174, 13.770, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.165, 13.765, -0.013> <-0.169, 13.764, -0.013> <-0.173, 13.762, -0.012> <-0.177, 13.763, -0.011> 
		<-0.166, 13.762, -0.022> <-0.169, 13.761, -0.022> <-0.174, 13.761, -0.018> <-0.178, 13.761, -0.017> 
		<-0.166, 13.760, -0.035> <-0.170, 13.760, -0.031> <-0.173, 13.762, -0.027> <-0.178, 13.761, -0.026> 
		<-0.167, 13.757, -0.044> <-0.170, 13.758, -0.041> <-0.174, 13.761, -0.033> <-0.179, 13.760, -0.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.163, 13.771, -0.002> <-0.162, 13.773, 0.002> <-0.161, 13.777, 0.007> <-0.159, 13.779, 0.011> 
		<-0.166, 13.770, -0.002> <-0.165, 13.773, 0.002> <-0.166, 13.776, 0.008> <-0.164, 13.779, 0.011> 
		<-0.170, 13.770, 0.001> <-0.170, 13.772, 0.005> <-0.170, 13.774, 0.012> <-0.169, 13.777, 0.015> 
		<-0.174, 13.770, 0.002> <-0.173, 13.773, 0.006> <-0.175, 13.774, 0.012> <-0.174, 13.777, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 13.779, 0.011> <-0.154, 13.786, 0.020> <-0.146, 13.795, 0.031> <-0.140, 13.802, 0.040> 
		<-0.164, 13.779, 0.011> <-0.159, 13.786, 0.021> <-0.153, 13.791, 0.027> <-0.148, 13.798, 0.035> 
		<-0.169, 13.777, 0.015> <-0.168, 13.780, 0.019> <-0.159, 13.789, 0.024> <-0.157, 13.792, 0.026> 
		<-0.174, 13.777, 0.015> <-0.173, 13.780, 0.019> <-0.168, 13.785, 0.021> <-0.166, 13.789, 0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.174, 13.777, 0.015> <-0.173, 13.780, 0.019> <-0.168, 13.785, 0.021> <-0.166, 13.789, 0.024> 
		<-0.179, 13.777, 0.015> <-0.177, 13.780, 0.019> <-0.172, 13.784, 0.020> <-0.170, 13.788, 0.023> 
		<-0.185, 13.778, 0.012> <-0.180, 13.781, 0.017> <-0.178, 13.786, 0.022> <-0.175, 13.789, 0.028> 
		<-0.189, 13.778, 0.011> <-0.184, 13.781, 0.015> <-0.182, 13.786, 0.024> <-0.178, 13.790, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.174, 13.777, 0.015> <-0.179, 13.777, 0.015> <-0.185, 13.778, 0.012> <-0.189, 13.778, 0.011> 
		<-0.175, 13.774, 0.012> <-0.180, 13.774, 0.012> <-0.188, 13.775, 0.009> <-0.193, 13.776, 0.008> 
		<-0.173, 13.773, 0.006> <-0.183, 13.773, 0.007> <-0.191, 13.773, 0.006> <-0.201, 13.774, 0.007> 
		<-0.174, 13.770, 0.002> <-0.183, 13.771, 0.003> <-0.196, 13.772, 0.004> <-0.205, 13.772, 0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.174, 13.770, 0.002> <-0.183, 13.771, 0.003> <-0.196, 13.772, 0.004> <-0.205, 13.772, 0.006> 
		<-0.174, 13.768, -0.002> <-0.184, 13.769, -0.001> <-0.193, 13.770, 0.000> <-0.203, 13.771, 0.001> 
		<-0.176, 13.764, -0.007> <-0.182, 13.764, -0.006> <-0.189, 13.769, -0.005> <-0.195, 13.770, -0.004> 
		<-0.177, 13.763, -0.011> <-0.183, 13.763, -0.010> <-0.190, 13.766, -0.009> <-0.196, 13.768, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.177, 13.763, -0.011> <-0.183, 13.763, -0.010> <-0.190, 13.766, -0.009> <-0.196, 13.768, -0.008> 
		<-0.178, 13.761, -0.017> <-0.184, 13.761, -0.016> <-0.193, 13.761, -0.020> <-0.199, 13.762, -0.019> 
		<-0.178, 13.761, -0.026> <-0.190, 13.759, -0.025> <-0.199, 13.758, -0.028> <-0.210, 13.755, -0.030> 
		<-0.179, 13.760, -0.033> <-0.190, 13.758, -0.031> <-0.205, 13.752, -0.037> <-0.216, 13.749, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.008, 13.868, -0.162> <2.002, 13.868, -0.162> <1.996, 13.864, -0.165> <1.990, 13.864, -0.166> 
		<2.006, 13.865, -0.159> <2.001, 13.865, -0.159> <1.994, 13.861, -0.162> <1.988, 13.860, -0.163> 
		<2.005, 13.858, -0.159> <2.000, 13.857, -0.158> <1.993, 13.855, -0.159> <1.987, 13.855, -0.159> 
		<2.004, 13.854, -0.156> <1.998, 13.853, -0.156> <1.991, 13.852, -0.156> <1.986, 13.852, -0.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.008, 13.868, -0.162> <2.006, 13.865, -0.159> <2.005, 13.858, -0.159> <2.004, 13.854, -0.156> 
		<2.016, 13.869, -0.162> <2.014, 13.865, -0.159> <2.017, 13.859, -0.159> <2.015, 13.855, -0.157> 
		<2.025, 13.866, -0.165> <2.024, 13.863, -0.162> <2.028, 13.859, -0.160> <2.031, 13.856, -0.158> 
		<2.033, 13.866, -0.166> <2.032, 13.862, -0.164> <2.040, 13.860, -0.161> <2.043, 13.857, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.008, 13.868, -0.162> <2.011, 13.873, -0.167> <2.015, 13.878, -0.175> <2.018, 13.882, -0.181> 
		<2.002, 13.868, -0.162> <2.005, 13.873, -0.167> <2.011, 13.877, -0.175> <2.013, 13.881, -0.181> 
		<1.996, 13.864, -0.165> <2.001, 13.873, -0.172> <2.007, 13.880, -0.179> <2.013, 13.889, -0.186> 
		<1.990, 13.864, -0.166> <1.996, 13.872, -0.173> <2.005, 13.883, -0.182> <2.012, 13.892, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.008, 13.868, -0.162> <2.016, 13.869, -0.162> <2.025, 13.866, -0.165> <2.033, 13.866, -0.166> 
		<2.011, 13.873, -0.167> <2.018, 13.874, -0.167> <2.029, 13.876, -0.172> <2.037, 13.876, -0.173> 
		<2.015, 13.878, -0.175> <2.027, 13.879, -0.174> <2.038, 13.882, -0.178> <2.050, 13.886, -0.179> 
		<2.018, 13.882, -0.181> <2.030, 13.883, -0.179> <2.045, 13.891, -0.183> <2.057, 13.895, -0.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.004, 13.854, -0.156> <1.998, 13.853, -0.156> <1.991, 13.852, -0.156> <1.986, 13.852, -0.156> 
		<2.002, 13.850, -0.155> <1.997, 13.850, -0.154> <1.991, 13.849, -0.154> <1.985, 13.849, -0.154> 
		<2.000, 13.847, -0.151> <1.995, 13.847, -0.150> <1.989, 13.845, -0.151> <1.984, 13.845, -0.151> 
		<1.999, 13.843, -0.149> <1.994, 13.843, -0.148> <1.988, 13.842, -0.149> <1.984, 13.841, -0.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.004, 13.854, -0.156> <2.002, 13.850, -0.155> <2.000, 13.847, -0.151> <1.999, 13.843, -0.149> 
		<2.015, 13.855, -0.157> <2.014, 13.852, -0.155> <2.007, 13.848, -0.151> <2.006, 13.844, -0.149> 
		<2.031, 13.856, -0.158> <2.025, 13.852, -0.156> <2.020, 13.849, -0.154> <2.016, 13.844, -0.151> 
		<2.043, 13.857, -0.158> <2.037, 13.854, -0.157> <2.027, 13.850, -0.155> <2.023, 13.845, -0.152> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.999, 13.843, -0.149> <1.998, 13.838, -0.146> <1.998, 13.830, -0.144> <1.998, 13.825, -0.142> 
		<2.006, 13.844, -0.149> <2.005, 13.839, -0.147> <2.006, 13.835, -0.146> <2.005, 13.829, -0.144> 
		<2.016, 13.844, -0.151> <2.014, 13.842, -0.150> <2.016, 13.835, -0.146> <2.017, 13.832, -0.144> 
		<2.023, 13.845, -0.152> <2.021, 13.842, -0.151> <2.024, 13.838, -0.147> <2.025, 13.835, -0.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.999, 13.843, -0.149> <1.994, 13.843, -0.148> <1.988, 13.842, -0.149> <1.984, 13.841, -0.149> 
		<1.998, 13.838, -0.146> <1.993, 13.838, -0.146> <1.988, 13.833, -0.145> <1.983, 13.833, -0.145> 
		<1.998, 13.830, -0.144> <1.993, 13.828, -0.143> <1.988, 13.825, -0.142> <1.984, 13.821, -0.140> 
		<1.998, 13.825, -0.142> <1.992, 13.822, -0.141> <1.988, 13.816, -0.138> <1.983, 13.812, -0.136> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.984, 13.841, -0.149> <1.984, 13.845, -0.151> <1.985, 13.849, -0.154> <1.986, 13.852, -0.156> 
		<1.980, 13.841, -0.150> <1.980, 13.845, -0.151> <1.982, 13.849, -0.155> <1.983, 13.852, -0.157> 
		<1.975, 13.842, -0.149> <1.975, 13.846, -0.151> <1.978, 13.850, -0.156> <1.978, 13.854, -0.158> 
		<1.971, 13.842, -0.150> <1.972, 13.846, -0.152> <1.974, 13.850, -0.157> <1.975, 13.853, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.984, 13.841, -0.149> <1.980, 13.841, -0.150> <1.975, 13.842, -0.149> <1.971, 13.842, -0.150> 
		<1.983, 13.833, -0.145> <1.979, 13.833, -0.145> <1.974, 13.836, -0.146> <1.971, 13.836, -0.148> 
		<1.984, 13.821, -0.140> <1.980, 13.824, -0.142> <1.977, 13.828, -0.145> <1.972, 13.827, -0.146> 
		<1.983, 13.812, -0.136> <1.980, 13.815, -0.138> <1.977, 13.821, -0.143> <1.972, 13.821, -0.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.986, 13.852, -0.156> <1.987, 13.855, -0.159> <1.988, 13.860, -0.163> <1.990, 13.864, -0.166> 
		<1.983, 13.852, -0.157> <1.984, 13.855, -0.160> <1.984, 13.860, -0.164> <1.986, 13.863, -0.167> 
		<1.978, 13.854, -0.158> <1.979, 13.857, -0.161> <1.978, 13.863, -0.164> <1.979, 13.866, -0.167> 
		<1.975, 13.853, -0.160> <1.975, 13.857, -0.162> <1.973, 13.862, -0.165> <1.975, 13.865, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.990, 13.864, -0.166> <1.996, 13.872, -0.173> <2.005, 13.883, -0.182> <2.012, 13.892, -0.189> 
		<1.986, 13.863, -0.167> <1.991, 13.872, -0.174> <1.997, 13.878, -0.179> <2.004, 13.886, -0.186> 
		<1.979, 13.866, -0.167> <1.981, 13.870, -0.171> <1.991, 13.875, -0.177> <1.994, 13.877, -0.181> 
		<1.975, 13.865, -0.168> <1.977, 13.869, -0.172> <1.982, 13.871, -0.176> <1.985, 13.873, -0.180> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.975, 13.865, -0.168> <1.977, 13.869, -0.172> <1.982, 13.871, -0.176> <1.985, 13.873, -0.180> 
		<1.970, 13.865, -0.169> <1.972, 13.868, -0.173> <1.978, 13.870, -0.176> <1.981, 13.872, -0.179> 
		<1.965, 13.860, -0.171> <1.970, 13.865, -0.174> <1.973, 13.870, -0.180> <1.976, 13.876, -0.183> 
		<1.961, 13.858, -0.173> <1.966, 13.863, -0.175> <1.969, 13.871, -0.181> <1.973, 13.877, -0.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.975, 13.865, -0.168> <1.970, 13.865, -0.169> <1.965, 13.860, -0.171> <1.961, 13.858, -0.173> 
		<1.973, 13.862, -0.165> <1.969, 13.862, -0.166> <1.962, 13.857, -0.170> <1.957, 13.855, -0.171> 
		<1.975, 13.857, -0.162> <1.966, 13.857, -0.165> <1.959, 13.854, -0.168> <1.950, 13.853, -0.171> 
		<1.975, 13.853, -0.160> <1.966, 13.853, -0.163> <1.954, 13.852, -0.167> <1.945, 13.851, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.975, 13.853, -0.160> <1.966, 13.853, -0.163> <1.954, 13.852, -0.167> <1.945, 13.851, -0.170> 
		<1.974, 13.850, -0.157> <1.965, 13.850, -0.160> <1.957, 13.849, -0.164> <1.948, 13.848, -0.168> 
		<1.972, 13.846, -0.152> <1.966, 13.846, -0.155> <1.961, 13.845, -0.161> <1.955, 13.845, -0.164> 
		<1.971, 13.842, -0.150> <1.966, 13.842, -0.153> <1.959, 13.841, -0.158> <1.954, 13.840, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.971, 13.842, -0.150> <1.966, 13.842, -0.153> <1.959, 13.841, -0.158> <1.954, 13.840, -0.161> 
		<1.971, 13.836, -0.148> <1.965, 13.836, -0.150> <1.957, 13.831, -0.151> <1.951, 13.831, -0.154> 
		<1.972, 13.827, -0.146> <1.960, 13.827, -0.147> <1.951, 13.823, -0.148> <1.940, 13.819, -0.148> 
		<1.972, 13.821, -0.144> <1.960, 13.821, -0.145> <1.945, 13.813, -0.143> <1.934, 13.810, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.551, 12.985, -0.587> <1.551, 12.990, -0.584> <1.547, 12.996, -0.582> <1.547, 13.002, -0.580> 
		<1.548, 12.985, -0.584> <1.548, 12.989, -0.581> <1.544, 12.997, -0.579> <1.543, 13.002, -0.577> 
		<1.541, 12.985, -0.583> <1.540, 12.990, -0.580> <1.539, 12.996, -0.575> <1.538, 13.000, -0.573> 
		<1.537, 12.985, -0.580> <1.536, 12.989, -0.577> <1.535, 12.995, -0.573> <1.535, 12.999, -0.570> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.551, 12.985, -0.587> <1.548, 12.985, -0.584> <1.541, 12.985, -0.583> <1.537, 12.985, -0.580> 
		<1.552, 12.979, -0.592> <1.548, 12.979, -0.588> <1.542, 12.976, -0.590> <1.538, 12.976, -0.587> 
		<1.549, 12.972, -0.600> <1.546, 12.972, -0.597> <1.542, 12.967, -0.598> <1.539, 12.964, -0.597> 
		<1.549, 12.967, -0.605> <1.545, 12.967, -0.602> <1.543, 12.958, -0.605> <1.540, 12.954, -0.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.551, 12.985, -0.587> <1.557, 12.986, -0.593> <1.561, 12.987, -0.602> <1.565, 12.988, -0.608> 
		<1.551, 12.990, -0.584> <1.556, 12.990, -0.589> <1.560, 12.991, -0.600> <1.565, 12.992, -0.606> 
		<1.547, 12.996, -0.582> <1.556, 12.996, -0.591> <1.563, 12.996, -0.601> <1.572, 12.995, -0.610> 
		<1.547, 13.002, -0.580> <1.555, 13.001, -0.589> <1.566, 12.999, -0.602> <1.575, 12.998, -0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.551, 12.985, -0.587> <1.552, 12.979, -0.592> <1.549, 12.972, -0.600> <1.549, 12.967, -0.605> 
		<1.557, 12.986, -0.593> <1.557, 12.979, -0.597> <1.559, 12.973, -0.607> <1.559, 12.968, -0.613> 
		<1.561, 12.987, -0.602> <1.562, 12.976, -0.608> <1.565, 12.970, -0.617> <1.569, 12.961, -0.625> 
		<1.565, 12.988, -0.608> <1.566, 12.977, -0.614> <1.574, 12.967, -0.626> <1.578, 12.958, -0.633> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.537, 12.985, -0.580> <1.536, 12.989, -0.577> <1.535, 12.995, -0.573> <1.535, 12.999, -0.570> 
		<1.533, 12.985, -0.578> <1.533, 12.989, -0.575> <1.532, 12.994, -0.570> <1.532, 12.999, -0.568> 
		<1.530, 12.985, -0.573> <1.530, 12.989, -0.570> <1.528, 12.994, -0.567> <1.528, 12.998, -0.564> 
		<1.526, 12.985, -0.571> <1.526, 12.988, -0.568> <1.525, 12.993, -0.565> <1.524, 12.997, -0.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.537, 12.985, -0.580> <1.533, 12.985, -0.578> <1.530, 12.985, -0.573> <1.526, 12.985, -0.571> 
		<1.538, 12.976, -0.587> <1.535, 12.976, -0.585> <1.531, 12.979, -0.578> <1.527, 12.979, -0.576> 
		<1.539, 12.964, -0.597> <1.535, 12.967, -0.592> <1.532, 12.971, -0.588> <1.527, 12.972, -0.583> 
		<1.540, 12.954, -0.605> <1.536, 12.958, -0.600> <1.533, 12.965, -0.593> <1.528, 12.967, -0.588> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.526, 12.985, -0.571> <1.521, 12.984, -0.569> <1.513, 12.983, -0.567> <1.508, 12.982, -0.565> 
		<1.527, 12.979, -0.576> <1.522, 12.978, -0.573> <1.518, 12.978, -0.573> <1.512, 12.977, -0.571> 
		<1.527, 12.972, -0.583> <1.525, 12.973, -0.581> <1.518, 12.969, -0.579> <1.515, 12.968, -0.578> 
		<1.528, 12.967, -0.588> <1.525, 12.968, -0.586> <1.521, 12.963, -0.585> <1.518, 12.961, -0.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.526, 12.985, -0.571> <1.526, 12.988, -0.568> <1.525, 12.993, -0.565> <1.524, 12.997, -0.563> 
		<1.521, 12.984, -0.569> <1.521, 12.987, -0.566> <1.516, 12.991, -0.561> <1.516, 12.995, -0.559> 
		<1.513, 12.983, -0.567> <1.511, 12.986, -0.563> <1.508, 12.990, -0.559> <1.504, 12.992, -0.555> 
		<1.508, 12.982, -0.565> <1.505, 12.985, -0.561> <1.499, 12.987, -0.556> <1.496, 12.989, -0.551> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.524, 12.997, -0.563> <1.528, 12.998, -0.564> <1.532, 12.999, -0.568> <1.535, 12.999, -0.570> 
		<1.524, 13.000, -0.561> <1.528, 13.001, -0.562> <1.532, 13.002, -0.566> <1.535, 13.003, -0.568> 
		<1.525, 13.004, -0.557> <1.529, 13.005, -0.559> <1.533, 13.006, -0.564> <1.537, 13.007, -0.567> 
		<1.525, 13.008, -0.556> <1.529, 13.009, -0.558> <1.533, 13.009, -0.563> <1.537, 13.010, -0.566> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.524, 12.997, -0.563> <1.524, 13.000, -0.561> <1.525, 13.004, -0.557> <1.525, 13.008, -0.556> 
		<1.516, 12.995, -0.559> <1.516, 12.998, -0.557> <1.519, 13.003, -0.555> <1.519, 13.007, -0.554> 
		<1.504, 12.992, -0.555> <1.507, 12.996, -0.555> <1.511, 13.001, -0.555> <1.510, 13.005, -0.553> 
		<1.496, 12.989, -0.551> <1.498, 12.994, -0.551> <1.504, 12.999, -0.554> <1.504, 13.004, -0.551> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.535, 12.999, -0.570> <1.538, 13.000, -0.573> <1.543, 13.002, -0.577> <1.547, 13.002, -0.580> 
		<1.535, 13.003, -0.568> <1.538, 13.003, -0.571> <1.543, 13.006, -0.575> <1.546, 13.006, -0.578> 
		<1.537, 13.007, -0.567> <1.540, 13.008, -0.569> <1.546, 13.011, -0.571> <1.549, 13.011, -0.575> 
		<1.537, 13.010, -0.566> <1.540, 13.012, -0.568> <1.546, 13.015, -0.570> <1.549, 13.015, -0.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.547, 13.002, -0.580> <1.555, 13.001, -0.589> <1.566, 12.999, -0.602> <1.575, 12.998, -0.611> 
		<1.546, 13.006, -0.578> <1.555, 13.005, -0.587> <1.561, 13.004, -0.595> <1.569, 13.003, -0.604> 
		<1.549, 13.011, -0.575> <1.553, 13.012, -0.579> <1.558, 13.007, -0.590> <1.560, 13.007, -0.595> 
		<1.549, 13.015, -0.573> <1.552, 13.016, -0.577> <1.554, 13.014, -0.584> <1.557, 13.014, -0.588> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.549, 13.015, -0.573> <1.552, 13.016, -0.577> <1.554, 13.014, -0.584> <1.557, 13.014, -0.588> 
		<1.548, 13.020, -0.571> <1.551, 13.020, -0.575> <1.553, 13.017, -0.581> <1.555, 13.017, -0.586> 
		<1.544, 13.025, -0.570> <1.548, 13.023, -0.575> <1.554, 13.024, -0.581> <1.559, 13.023, -0.586> 
		<1.541, 13.029, -0.569> <1.546, 13.027, -0.574> <1.555, 13.028, -0.580> <1.560, 13.027, -0.585> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.549, 13.015, -0.573> <1.548, 13.020, -0.571> <1.544, 13.025, -0.570> <1.541, 13.029, -0.569> 
		<1.546, 13.015, -0.570> <1.545, 13.019, -0.568> <1.540, 13.027, -0.566> <1.538, 13.031, -0.565> 
		<1.540, 13.012, -0.568> <1.540, 13.021, -0.566> <1.537, 13.028, -0.563> <1.537, 13.037, -0.561> 
		<1.537, 13.010, -0.566> <1.537, 13.020, -0.563> <1.535, 13.032, -0.560> <1.535, 13.041, -0.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.537, 13.010, -0.566> <1.537, 13.020, -0.563> <1.535, 13.032, -0.560> <1.535, 13.041, -0.557> 
		<1.533, 13.009, -0.563> <1.533, 13.018, -0.561> <1.532, 13.028, -0.559> <1.531, 13.037, -0.556> 
		<1.529, 13.009, -0.558> <1.529, 13.015, -0.557> <1.528, 13.023, -0.558> <1.528, 13.029, -0.558> 
		<1.525, 13.008, -0.556> <1.525, 13.014, -0.555> <1.524, 13.022, -0.555> <1.524, 13.028, -0.555> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.525, 13.008, -0.556> <1.525, 13.014, -0.555> <1.524, 13.022, -0.555> <1.524, 13.028, -0.555> 
		<1.519, 13.007, -0.554> <1.519, 13.013, -0.552> <1.514, 13.020, -0.548> <1.514, 13.026, -0.548> 
		<1.510, 13.005, -0.553> <1.510, 13.016, -0.547> <1.506, 13.023, -0.543> <1.502, 13.032, -0.536> 
		<1.504, 13.004, -0.551> <1.504, 13.014, -0.546> <1.497, 13.025, -0.535> <1.493, 13.034, -0.528> 
	}

	texture { txLeaves }
}

// Layer 7
#declare oLeaf =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.028, 0.003, -0.595> <0.029, 0.003, -0.590> <0.029, 0.007, -0.583> <0.030, 0.009, -0.578> 
		<0.024, 0.002, -0.593> <0.025, 0.002, -0.587> <0.025, 0.007, -0.580> <0.026, 0.008, -0.575> 
		<0.018, 0.005, -0.590> <0.019, 0.006, -0.585> <0.019, 0.007, -0.578> <0.020, 0.007, -0.573> 
		<0.014, 0.006, -0.588> <0.015, 0.006, -0.583> <0.015, 0.006, -0.575> <0.016, 0.007, -0.570> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.028, 0.003, -0.595> <0.024, 0.002, -0.593> <0.018, 0.005, -0.590> <0.014, 0.006, -0.588> 
		<0.027, 0.003, -0.603> <0.023, 0.002, -0.600> <0.017, 0.005, -0.602> <0.013, 0.005, -0.600> 
		<0.024, 0.006, -0.613> <0.020, 0.006, -0.610> <0.015, 0.006, -0.613> <0.011, 0.005, -0.615> 
		<0.022, 0.007, -0.620> <0.018, 0.007, -0.618> <0.013, 0.006, -0.625> <0.009, 0.005, -0.627> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.028, 0.003, -0.595> <0.034, 0.004, -0.600> <0.041, 0.009, -0.605> <0.047, 0.011, -0.610> 
		<0.029, 0.003, -0.590> <0.035, 0.004, -0.594> <0.042, 0.009, -0.601> <0.047, 0.012, -0.606> 
		<0.029, 0.007, -0.583> <0.038, 0.009, -0.591> <0.047, 0.011, -0.599> <0.056, 0.012, -0.608> 
		<0.030, 0.009, -0.578> <0.040, 0.010, -0.586> <0.051, 0.012, -0.598> <0.060, 0.013, -0.607> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.028, 0.003, -0.595> <0.027, 0.003, -0.603> <0.024, 0.006, -0.613> <0.022, 0.007, -0.620> 
		<0.034, 0.004, -0.600> <0.033, 0.004, -0.607> <0.035, 0.006, -0.619> <0.033, 0.008, -0.626> 
		<0.041, 0.009, -0.605> <0.038, 0.007, -0.617> <0.041, 0.008, -0.629> <0.042, 0.007, -0.641> 
		<0.047, 0.011, -0.610> <0.044, 0.009, -0.622> <0.049, 0.008, -0.638> <0.051, 0.006, -0.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.014, 0.006, -0.588> <0.015, 0.006, -0.583> <0.015, 0.006, -0.575> <0.016, 0.007, -0.570> 
		<0.011, 0.006, -0.586> <0.011, 0.006, -0.580> <0.011, 0.006, -0.574> <0.013, 0.007, -0.569> 
		<0.006, 0.004, -0.582> <0.007, 0.004, -0.577> <0.007, 0.006, -0.571> <0.008, 0.006, -0.566> 
		<0.003, 0.005, -0.580> <0.003, 0.005, -0.576> <0.004, 0.006, -0.570> <0.005, 0.006, -0.565> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.014, 0.006, -0.588> <0.011, 0.006, -0.586> <0.006, 0.004, -0.582> <0.003, 0.005, -0.580> 
		<0.013, 0.005, -0.600> <0.009, 0.005, -0.598> <0.005, 0.004, -0.589> <0.002, 0.005, -0.588> 
		<0.011, 0.005, -0.615> <0.008, 0.006, -0.609> <0.006, 0.006, -0.603> <0.001, 0.006, -0.597> 
		<0.009, 0.005, -0.627> <0.006, 0.005, -0.621> <0.005, 0.007, -0.610> <-0.000, 0.007, -0.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.005, -0.580> <-0.003, 0.005, -0.578> <-0.010, 0.008, -0.576> <-0.016, 0.009, -0.575> 
		<0.002, 0.005, -0.588> <-0.004, 0.005, -0.585> <-0.008, 0.007, -0.585> <-0.013, 0.008, -0.583> 
		<0.001, 0.006, -0.597> <-0.002, 0.006, -0.595> <-0.009, 0.007, -0.595> <-0.013, 0.007, -0.595> 
		<-0.000, 0.007, -0.605> <-0.002, 0.007, -0.602> <-0.008, 0.006, -0.604> <-0.012, 0.006, -0.604> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.005, -0.580> <0.003, 0.005, -0.576> <0.004, 0.006, -0.570> <0.005, 0.006, -0.565> 
		<-0.003, 0.005, -0.578> <-0.002, 0.005, -0.573> <-0.005, 0.007, -0.567> <-0.004, 0.007, -0.562> 
		<-0.010, 0.008, -0.576> <-0.012, 0.008, -0.571> <-0.014, 0.009, -0.565> <-0.017, 0.009, -0.560> 
		<-0.016, 0.009, -0.575> <-0.017, 0.010, -0.569> <-0.023, 0.010, -0.563> <-0.026, 0.010, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.006, -0.565> <0.008, 0.006, -0.566> <0.013, 0.007, -0.569> <0.016, 0.007, -0.570> 
		<0.006, 0.007, -0.562> <0.009, 0.007, -0.563> <0.014, 0.007, -0.565> <0.017, 0.007, -0.567> 
		<0.007, 0.006, -0.557> <0.011, 0.006, -0.558> <0.016, 0.007, -0.562> <0.021, 0.008, -0.563> 
		<0.009, 0.007, -0.553> <0.013, 0.007, -0.555> <0.018, 0.009, -0.559> <0.022, 0.009, -0.560> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.006, -0.565> <0.006, 0.007, -0.562> <0.007, 0.006, -0.557> <0.009, 0.007, -0.553> 
		<-0.004, 0.007, -0.562> <-0.004, 0.007, -0.559> <0.001, 0.007, -0.555> <0.002, 0.008, -0.551> 
		<-0.017, 0.009, -0.560> <-0.013, 0.010, -0.557> <-0.007, 0.010, -0.555> <-0.006, 0.011, -0.550> 
		<-0.026, 0.010, -0.558> <-0.022, 0.011, -0.555> <-0.014, 0.012, -0.554> <-0.012, 0.013, -0.549> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.016, 0.007, -0.570> <0.020, 0.007, -0.573> <0.026, 0.008, -0.575> <0.030, 0.009, -0.578> 
		<0.017, 0.007, -0.567> <0.021, 0.008, -0.569> <0.028, 0.009, -0.570> <0.031, 0.010, -0.573> 
		<0.021, 0.008, -0.563> <0.025, 0.008, -0.565> <0.032, 0.008, -0.566> <0.035, 0.009, -0.568> 
		<0.022, 0.009, -0.560> <0.026, 0.009, -0.562> <0.033, 0.009, -0.561> <0.036, 0.010, -0.564> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 0.009, -0.578> <0.040, 0.010, -0.586> <0.051, 0.012, -0.598> <0.060, 0.013, -0.607> 
		<0.031, 0.010, -0.573> <0.041, 0.011, -0.581> <0.047, 0.012, -0.589> <0.056, 0.014, -0.598> 
		<0.035, 0.009, -0.568> <0.040, 0.010, -0.571> <0.045, 0.013, -0.582> <0.048, 0.014, -0.586> 
		<0.036, 0.010, -0.564> <0.041, 0.011, -0.566> <0.044, 0.014, -0.572> <0.047, 0.015, -0.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.036, 0.010, -0.564> <0.041, 0.011, -0.566> <0.044, 0.014, -0.572> <0.047, 0.015, -0.576> 
		<0.037, 0.011, -0.559> <0.041, 0.013, -0.562> <0.043, 0.014, -0.568> <0.046, 0.016, -0.572> 
		<0.036, 0.015, -0.554> <0.040, 0.015, -0.560> <0.047, 0.017, -0.564> <0.052, 0.017, -0.569> 
		<0.036, 0.018, -0.549> <0.040, 0.017, -0.556> <0.049, 0.018, -0.561> <0.055, 0.018, -0.566> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.036, 0.010, -0.564> <0.037, 0.011, -0.559> <0.036, 0.015, -0.554> <0.036, 0.018, -0.549> 
		<0.033, 0.009, -0.561> <0.034, 0.011, -0.557> <0.033, 0.016, -0.549> <0.033, 0.018, -0.545> 
		<0.026, 0.009, -0.562> <0.030, 0.012, -0.553> <0.030, 0.016, -0.546> <0.033, 0.019, -0.537> 
		<0.022, 0.009, -0.560> <0.025, 0.012, -0.552> <0.029, 0.016, -0.540> <0.032, 0.020, -0.532> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.022, 0.009, -0.560> <0.025, 0.012, -0.552> <0.029, 0.016, -0.540> <0.032, 0.020, -0.532> 
		<0.018, 0.009, -0.559> <0.021, 0.011, -0.550> <0.024, 0.016, -0.542> <0.028, 0.019, -0.534> 
		<0.013, 0.007, -0.555> <0.015, 0.009, -0.550> <0.019, 0.014, -0.545> <0.021, 0.017, -0.540> 
		<0.009, 0.007, -0.553> <0.011, 0.009, -0.548> <0.014, 0.014, -0.542> <0.016, 0.017, -0.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.009, 0.007, -0.553> <0.011, 0.009, -0.548> <0.014, 0.014, -0.542> <0.016, 0.017, -0.538> 
		<0.002, 0.008, -0.551> <0.005, 0.010, -0.546> <0.003, 0.014, -0.537> <0.005, 0.017, -0.532> 
		<-0.006, 0.011, -0.550> <-0.003, 0.013, -0.539> <-0.004, 0.016, -0.530> <-0.005, 0.017, -0.518> 
		<-0.012, 0.013, -0.549> <-0.009, 0.014, -0.538> <-0.013, 0.016, -0.522> <-0.014, 0.018, -0.510> 
	}
	
	texture { txLeaves }
}                       

// Layer 8
#declare oFlower =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.010, 0.068, 0.064> <0.007, 0.069, 0.066> <-0.000, 0.069, 0.067> <-0.003, 0.067, 0.065> 
		<0.016, 0.063, 0.059> <0.013, 0.065, 0.061> <-0.008, 0.065, 0.063> <-0.011, 0.063, 0.061> 
		<0.021, 0.055, 0.050> <0.008, 0.055, 0.051> <-0.004, 0.055, 0.052> <-0.018, 0.055, 0.053> 
		<0.023, 0.049, 0.044> <0.010, 0.048, 0.045> <-0.008, 0.048, 0.047> <-0.021, 0.048, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.021, 0.048, 0.048> <-0.025, 0.040, 0.041> <-0.030, 0.025, 0.033> <-0.029, 0.016, 0.025> 
		<-0.008, 0.048, 0.047> <-0.012, 0.040, 0.040> <-0.013, 0.025, 0.032> <-0.012, 0.016, 0.024> 
		<0.010, 0.048, 0.045> <0.013, 0.040, 0.038> <0.012, 0.025, 0.030> <0.010, 0.016, 0.022> 
		<0.023, 0.049, 0.044> <0.026, 0.040, 0.037> <0.029, 0.025, 0.029> <0.026, 0.016, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.029, 0.016, 0.025> <-0.028, 0.011, 0.020> <-0.023, 0.006, 0.010> <-0.016, 0.004, 0.007> 
		<-0.012, 0.016, 0.024> <-0.012, 0.011, 0.019> <-0.016, 0.004, 0.007> <-0.009, 0.002, 0.003> 
		<0.010, 0.016, 0.022> <0.008, 0.011, 0.017> <0.011, 0.004, 0.004> <0.004, 0.002, 0.002> 
		<0.026, 0.016, 0.021> <0.025, 0.011, 0.016> <0.018, 0.006, 0.007> <0.011, 0.004, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.053, 0.067, 0.034> <0.053, 0.069, 0.038> <0.048, 0.069, 0.043> <0.045, 0.067, 0.044> 
		<0.054, 0.062, 0.027> <0.054, 0.064, 0.030> <0.040, 0.065, 0.046> <0.037, 0.063, 0.047> 
		<0.051, 0.054, 0.017> <0.042, 0.055, 0.027> <0.035, 0.055, 0.036> <0.026, 0.055, 0.046> 
		<0.048, 0.047, 0.011> <0.040, 0.048, 0.021> <0.028, 0.048, 0.035> <0.020, 0.049, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 0.049, 0.045> <0.012, 0.040, 0.043> <0.003, 0.025, 0.041> <-0.002, 0.017, 0.035> 
		<0.028, 0.048, 0.035> <0.020, 0.040, 0.033> <0.014, 0.025, 0.029> <0.008, 0.016, 0.023> 
		<0.040, 0.048, 0.021> <0.036, 0.039, 0.014> <0.030, 0.024, 0.009> <0.023, 0.016, 0.006> 
		<0.048, 0.047, 0.011> <0.045, 0.039, 0.004> <0.041, 0.024, -0.003> <0.033, 0.015, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.017, 0.035> <-0.006, 0.011, 0.031> <-0.009, 0.007, 0.021> <-0.007, 0.005, 0.014> 
		<0.008, 0.016, 0.023> <0.005, 0.011, 0.019> <-0.007, 0.004, 0.013> <-0.005, 0.002, 0.006> 
		<0.023, 0.016, 0.006> <0.018, 0.010, 0.003> <0.010, 0.004, -0.007> <0.004, 0.002, -0.004> 
		<0.033, 0.015, -0.007> <0.029, 0.010, -0.009> <0.017, 0.006, -0.011> <0.011, 0.004, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.061, 0.065, -0.013> <0.063, 0.067, -0.010> <0.064, 0.067, -0.003> <0.062, 0.066, 0.000> 
		<0.056, 0.060, -0.019> <0.058, 0.062, -0.016> <0.060, 0.063, 0.005> <0.058, 0.061, 0.008> 
		<0.046, 0.053, -0.024> <0.047, 0.053, -0.010> <0.048, 0.054, 0.002> <0.049, 0.054, 0.015> 
		<0.040, 0.046, -0.026> <0.041, 0.047, -0.012> <0.043, 0.047, 0.005> <0.044, 0.048, 0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.044, 0.048, 0.019> <0.037, 0.039, 0.023> <0.029, 0.025, 0.028> <0.021, 0.017, 0.028> 
		<0.043, 0.047, 0.005> <0.036, 0.039, 0.010> <0.028, 0.025, 0.012> <0.019, 0.016, 0.011> 
		<0.041, 0.047, -0.012> <0.034, 0.038, -0.015> <0.025, 0.023, -0.013> <0.017, 0.015, -0.011> 
		<0.040, 0.046, -0.026> <0.032, 0.037, -0.028> <0.024, 0.023, -0.030> <0.016, 0.014, -0.027> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.021, 0.017, 0.028> <0.015, 0.011, 0.028> <0.005, 0.007, 0.023> <0.002, 0.005, 0.016> 
		<0.019, 0.016, 0.011> <0.014, 0.011, 0.011> <0.001, 0.005, 0.015> <-0.002, 0.002, 0.009> 
		<0.017, 0.015, -0.011> <0.012, 0.010, -0.009> <-0.001, 0.004, -0.011> <-0.003, 0.002, -0.004> 
		<0.016, 0.014, -0.027> <0.011, 0.009, -0.025> <0.002, 0.005, -0.018> <-0.001, 0.004, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.034, 0.063, -0.052> <0.037, 0.065, -0.052> <0.043, 0.065, -0.047> <0.044, 0.064, -0.044> 
		<0.026, 0.059, -0.053> <0.029, 0.061, -0.053> <0.045, 0.061, -0.039> <0.046, 0.060, -0.036> 
		<0.016, 0.051, -0.050> <0.026, 0.052, -0.041> <0.035, 0.052, -0.033> <0.045, 0.053, -0.025> 
		<0.010, 0.045, -0.047> <0.020, 0.045, -0.038> <0.034, 0.046, -0.026> <0.044, 0.046, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.044, 0.046, -0.018> <0.042, 0.038, -0.009> <0.040, 0.024, -0.000> <0.033, 0.016, 0.006> 
		<0.034, 0.046, -0.026> <0.032, 0.038, -0.018> <0.027, 0.024, -0.011> <0.021, 0.015, -0.005> 
		<0.020, 0.045, -0.038> <0.013, 0.037, -0.034> <0.008, 0.023, -0.027> <0.004, 0.015, -0.019> 
		<0.010, 0.045, -0.047> <0.003, 0.036, -0.043> <-0.005, 0.022, -0.038> <-0.009, 0.014, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.033, 0.016, 0.006> <0.029, 0.011, 0.009> <0.018, 0.007, 0.013> <0.011, 0.005, 0.011> 
		<0.021, 0.015, -0.005> <0.016, 0.010, -0.001> <0.011, 0.004, 0.011> <0.004, 0.003, 0.008> 
		<0.004, 0.015, -0.019> <0.001, 0.010, -0.014> <-0.010, 0.004, -0.006> <-0.006, 0.002, 0.000> 
		<-0.009, 0.014, -0.030> <-0.011, 0.009, -0.025> <-0.013, 0.005, -0.014> <-0.010, 0.004, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.057, 0.063, -0.033> <-0.057, 0.065, -0.037> <-0.052, 0.065, -0.042> <-0.049, 0.063, -0.043> 
		<-0.058, 0.059, -0.025> <-0.058, 0.061, -0.029> <-0.044, 0.060, -0.045> <-0.041, 0.059, -0.045> 
		<-0.055, 0.052, -0.015> <-0.046, 0.052, -0.025> <-0.038, 0.052, -0.034> <-0.030, 0.051, -0.044> 
		<-0.052, 0.046, -0.008> <-0.043, 0.046, -0.019> <-0.032, 0.045, -0.032> <-0.023, 0.045, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.023, 0.045, -0.042> <-0.015, 0.036, -0.040> <-0.006, 0.022, -0.037> <-0.001, 0.014, -0.030> 
		<-0.032, 0.045, -0.032> <-0.024, 0.037, -0.030> <-0.017, 0.023, -0.024> <-0.011, 0.015, -0.018> 
		<-0.043, 0.046, -0.019> <-0.040, 0.037, -0.011> <-0.033, 0.023, -0.005> <-0.026, 0.015, -0.001> 
		<-0.052, 0.046, -0.008> <-0.048, 0.038, -0.001> <-0.044, 0.024, 0.008> <-0.036, 0.016, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.014, -0.030> <0.003, 0.009, -0.026> <0.006, 0.005, -0.015> <0.004, 0.004, -0.008> 
		<-0.011, 0.015, -0.018> <-0.008, 0.009, -0.013> <0.004, 0.004, -0.007> <0.002, 0.002, 0.000> 
		<-0.026, 0.015, -0.001> <-0.021, 0.010, 0.002> <-0.013, 0.004, 0.013> <-0.007, 0.002, 0.010> 
		<-0.036, 0.016, 0.012> <-0.032, 0.010, 0.015> <-0.020, 0.006, 0.017> <-0.014, 0.005, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.014, 0.062, -0.062> <-0.011, 0.064, -0.065> <-0.004, 0.064, -0.065> <-0.000, 0.063, -0.063> 
		<-0.020, 0.058, -0.057> <-0.017, 0.060, -0.059> <0.004, 0.060, -0.061> <0.007, 0.058, -0.059> 
		<-0.025, 0.051, -0.047> <-0.011, 0.051, -0.048> <0.001, 0.051, -0.049> <0.014, 0.052, -0.050> 
		<-0.027, 0.045, -0.041> <-0.013, 0.045, -0.042> <0.004, 0.045, -0.043> <0.018, 0.045, -0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.018, 0.045, -0.044> <0.022, 0.037, -0.037> <0.027, 0.023, -0.029> <0.026, 0.015, -0.020> 
		<0.004, 0.045, -0.043> <0.009, 0.037, -0.036> <0.010, 0.023, -0.027> <0.009, 0.015, -0.018> 
		<-0.013, 0.045, -0.042> <-0.016, 0.037, -0.034> <-0.015, 0.023, -0.025> <-0.013, 0.015, -0.017> 
		<-0.027, 0.045, -0.041> <-0.030, 0.037, -0.033> <-0.032, 0.023, -0.024> <-0.029, 0.015, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 0.015, -0.020> <0.025, 0.010, -0.014> <0.020, 0.006, -0.004> <0.014, 0.004, -0.000> 
		<0.009, 0.015, -0.018> <0.009, 0.010, -0.013> <0.013, 0.004, -0.000> <0.006, 0.002, 0.003> 
		<-0.013, 0.015, -0.017> <-0.011, 0.010, -0.011> <-0.013, 0.004, 0.002> <-0.006, 0.002, 0.005> 
		<-0.029, 0.015, -0.015> <-0.028, 0.009, -0.010> <-0.021, 0.006, -0.000> <-0.014, 0.004, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.065, 0.065, 0.013> <-0.068, 0.067, 0.010> <-0.068, 0.066, 0.003> <-0.066, 0.064, -0.000> 
		<-0.060, 0.061, 0.019> <-0.062, 0.063, 0.017> <-0.064, 0.062, -0.004> <-0.062, 0.060, -0.007> 
		<-0.051, 0.054, 0.025> <-0.052, 0.053, 0.011> <-0.053, 0.053, -0.001> <-0.054, 0.052, -0.014> 
		<-0.044, 0.047, 0.027> <-0.046, 0.047, 0.014> <-0.047, 0.046, -0.004> <-0.048, 0.046, -0.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.048, 0.046, -0.017> <-0.041, 0.037, -0.021> <-0.033, 0.023, -0.025> <-0.024, 0.014, -0.024> 
		<-0.047, 0.046, -0.004> <-0.040, 0.037, -0.008> <-0.031, 0.023, -0.009> <-0.023, 0.015, -0.008> 
		<-0.046, 0.047, 0.014> <-0.038, 0.038, 0.017> <-0.029, 0.024, 0.017> <-0.021, 0.016, 0.014> 
		<-0.044, 0.047, 0.027> <-0.037, 0.039, 0.030> <-0.028, 0.025, 0.033> <-0.020, 0.016, 0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, 0.014, -0.024> <-0.019, 0.009, -0.023> <-0.009, 0.005, -0.018> <-0.005, 0.004, -0.011> 
		<-0.023, 0.015, -0.008> <-0.018, 0.010, -0.007> <-0.005, 0.004, -0.011> <-0.001, 0.002, -0.004> 
		<-0.021, 0.016, 0.014> <-0.016, 0.010, 0.013> <-0.003, 0.005, 0.016> <-0.000, 0.002, 0.009> 
		<-0.020, 0.016, 0.031> <-0.015, 0.011, 0.030> <-0.005, 0.007, 0.023> <-0.003, 0.005, 0.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.038, 0.067, 0.055> <-0.041, 0.069, 0.054> <-0.047, 0.068, 0.050> <-0.048, 0.066, 0.046> 
		<-0.030, 0.063, 0.056> <-0.033, 0.064, 0.055> <-0.049, 0.064, 0.042> <-0.050, 0.062, 0.039> 
		<-0.019, 0.055, 0.053> <-0.030, 0.055, 0.044> <-0.039, 0.054, 0.036> <-0.049, 0.054, 0.028> 
		<-0.013, 0.049, 0.050> <-0.024, 0.048, 0.042> <-0.037, 0.048, 0.030> <-0.047, 0.047, 0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, 0.047, 0.022> <-0.045, 0.038, 0.014> <-0.043, 0.024, 0.006> <-0.036, 0.015, 0.001> 
		<-0.037, 0.048, 0.030> <-0.035, 0.039, 0.022> <-0.030, 0.024, 0.016> <-0.024, 0.016, 0.011> 
		<-0.024, 0.048, 0.042> <-0.016, 0.039, 0.039> <-0.011, 0.025, 0.033> <-0.007, 0.016, 0.026> 
		<-0.013, 0.049, 0.050> <-0.006, 0.040, 0.047> <0.002, 0.025, 0.043> <0.006, 0.017, 0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.036, 0.015, 0.001> <-0.032, 0.010, -0.003> <-0.021, 0.006, -0.006> <-0.014, 0.004, -0.004> 
		<-0.024, 0.016, 0.011> <-0.019, 0.010, 0.008> <-0.013, 0.004, -0.003> <-0.006, 0.002, -0.001> 
		<-0.007, 0.016, 0.026> <-0.004, 0.011, 0.021> <0.007, 0.005, 0.014> <0.004, 0.002, 0.007> 
		<0.006, 0.017, 0.036> <0.009, 0.011, 0.032> <0.010, 0.007, 0.021> <0.007, 0.005, 0.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.006, 0.086, 0.045> <0.005, 0.088, 0.047> <-0.001, 0.088, 0.047> <-0.003, 0.086, 0.046> 
		<0.011, 0.079, 0.042> <0.010, 0.081, 0.043> <-0.007, 0.081, 0.044> <-0.009, 0.079, 0.043> 
		<0.015, 0.070, 0.035> <0.005, 0.070, 0.036> <-0.004, 0.070, 0.037> <-0.013, 0.069, 0.037> 
		<0.016, 0.062, 0.031> <0.007, 0.062, 0.032> <-0.006, 0.062, 0.033> <-0.016, 0.062, 0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 0.062, 0.034> <-0.019, 0.050, 0.029> <-0.022, 0.032, 0.025> <-0.021, 0.021, 0.019> 
		<-0.006, 0.062, 0.033> <-0.009, 0.050, 0.028> <-0.010, 0.032, 0.024> <-0.009, 0.021, 0.018> 
		<0.007, 0.062, 0.032> <0.009, 0.050, 0.027> <0.008, 0.033, 0.022> <0.007, 0.021, 0.016> 
		<0.016, 0.062, 0.031> <0.018, 0.050, 0.026> <0.020, 0.033, 0.021> <0.019, 0.021, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.021, 0.021, 0.019> <-0.021, 0.015, 0.016> <-0.017, 0.009, 0.008> <-0.012, 0.006, 0.006> 
		<-0.009, 0.021, 0.018> <-0.009, 0.015, 0.015> <-0.013, 0.006, 0.006> <-0.007, 0.003, 0.003> 
		<0.007, 0.021, 0.016> <0.006, 0.015, 0.014> <0.008, 0.006, 0.004> <0.003, 0.003, 0.002> 
		<0.019, 0.021, 0.015> <0.018, 0.015, 0.013> <0.013, 0.009, 0.006> <0.008, 0.006, 0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.038, 0.085, 0.024> <0.038, 0.087, 0.026> <0.034, 0.087, 0.031> <0.032, 0.085, 0.031> 
		<0.038, 0.079, 0.018> <0.038, 0.081, 0.020> <0.027, 0.081, 0.033> <0.025, 0.079, 0.033> 
		<0.036, 0.069, 0.011> <0.030, 0.069, 0.019> <0.024, 0.069, 0.026> <0.018, 0.070, 0.033> 
		<0.034, 0.061, 0.008> <0.028, 0.061, 0.015> <0.020, 0.061, 0.025> <0.014, 0.062, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.014, 0.062, 0.032> <0.007, 0.050, 0.031> <0.002, 0.033, 0.030> <-0.002, 0.021, 0.026> 
		<0.020, 0.061, 0.025> <0.014, 0.050, 0.024> <0.010, 0.033, 0.021> <0.006, 0.021, 0.017> 
		<0.028, 0.061, 0.015> <0.025, 0.049, 0.010> <0.021, 0.032, 0.007> <0.016, 0.020, 0.005> 
		<0.034, 0.061, 0.008> <0.032, 0.049, 0.003> <0.029, 0.032, -0.002> <0.024, 0.020, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.021, 0.026> <-0.004, 0.015, 0.024> <-0.007, 0.009, 0.016> <-0.005, 0.006, 0.011> 
		<0.006, 0.021, 0.017> <0.004, 0.015, 0.015> <-0.006, 0.006, 0.011> <-0.004, 0.003, 0.005> 
		<0.016, 0.020, 0.005> <0.013, 0.015, 0.003> <0.008, 0.006, -0.005> <0.003, 0.003, -0.002> 
		<0.024, 0.020, -0.004> <0.021, 0.014, -0.006> <0.013, 0.008, -0.007> <0.007, 0.006, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.043, 0.084, -0.010> <0.044, 0.086, -0.008> <0.045, 0.086, -0.002> <0.044, 0.084, -0.000> 
		<0.039, 0.078, -0.015> <0.040, 0.080, -0.013> <0.042, 0.080, 0.004> <0.041, 0.078, 0.006> 
		<0.032, 0.068, -0.017> <0.033, 0.068, -0.008> <0.034, 0.068, 0.001> <0.035, 0.069, 0.011> 
		<0.028, 0.060, -0.019> <0.029, 0.060, -0.009> <0.030, 0.061, 0.004> <0.031, 0.061, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.061, 0.013> <0.026, 0.050, 0.017> <0.021, 0.033, 0.021> <0.014, 0.021, 0.021> 
		<0.030, 0.061, 0.004> <0.025, 0.049, 0.008> <0.020, 0.032, 0.009> <0.013, 0.021, 0.009> 
		<0.029, 0.060, -0.009> <0.023, 0.049, -0.011> <0.018, 0.031, -0.009> <0.012, 0.020, -0.007> 
		<0.028, 0.060, -0.019> <0.022, 0.048, -0.020> <0.017, 0.031, -0.021> <0.011, 0.019, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.014, 0.021, 0.021> <0.011, 0.015, 0.021> <0.004, 0.009, 0.018> <0.001, 0.006, 0.012> 
		<0.013, 0.021, 0.009> <0.010, 0.015, 0.009> <0.001, 0.006, 0.013> <-0.002, 0.004, 0.008> 
		<0.012, 0.020, -0.007> <0.009, 0.014, -0.006> <-0.001, 0.006, -0.008> <-0.003, 0.003, -0.002> 
		<0.011, 0.019, -0.019> <0.008, 0.014, -0.018> <0.001, 0.008, -0.013> <-0.001, 0.005, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.024, 0.083, -0.038> <0.026, 0.085, -0.038> <0.030, 0.085, -0.034> <0.031, 0.083, -0.032> 
		<0.017, 0.076, -0.039> <0.019, 0.078, -0.039> <0.032, 0.079, -0.028> <0.033, 0.077, -0.026> 
		<0.010, 0.067, -0.036> <0.018, 0.067, -0.030> <0.025, 0.067, -0.024> <0.032, 0.068, -0.018> 
		<0.007, 0.059, -0.034> <0.014, 0.059, -0.027> <0.024, 0.060, -0.019> <0.031, 0.060, -0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.060, -0.013> <0.030, 0.049, -0.006> <0.028, 0.032, 0.000> <0.023, 0.020, 0.005> 
		<0.024, 0.060, -0.019> <0.022, 0.048, -0.013> <0.019, 0.031, -0.008> <0.014, 0.020, -0.003> 
		<0.014, 0.059, -0.027> <0.008, 0.048, -0.024> <0.005, 0.031, -0.020> <0.002, 0.020, -0.013> 
		<0.007, 0.059, -0.034> <0.001, 0.048, -0.031> <-0.004, 0.030, -0.027> <-0.007, 0.019, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.023, 0.020, 0.005> <0.021, 0.015, 0.007> <0.013, 0.009, 0.010> <0.008, 0.006, 0.009> 
		<0.014, 0.020, -0.003> <0.012, 0.015, -0.001> <0.008, 0.006, 0.009> <0.002, 0.004, 0.007> 
		<0.002, 0.020, -0.013> <0.001, 0.014, -0.010> <-0.008, 0.006, -0.005> <-0.005, 0.003, 0.001> 
		<-0.007, 0.019, -0.021> <-0.008, 0.014, -0.018> <-0.010, 0.008, -0.010> <-0.008, 0.005, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.042, 0.083, -0.024> <-0.042, 0.084, -0.027> <-0.038, 0.084, -0.031> <-0.036, 0.082, -0.032> 
		<-0.042, 0.077, -0.018> <-0.042, 0.079, -0.020> <-0.031, 0.078, -0.033> <-0.029, 0.076, -0.033> 
		<-0.040, 0.067, -0.010> <-0.034, 0.067, -0.018> <-0.028, 0.067, -0.025> <-0.022, 0.067, -0.032> 
		<-0.038, 0.060, -0.006> <-0.032, 0.060, -0.014> <-0.024, 0.059, -0.023> <-0.017, 0.059, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 0.059, -0.031> <-0.011, 0.048, -0.029> <-0.005, 0.031, -0.027> <-0.001, 0.019, -0.021> 
		<-0.024, 0.059, -0.023> <-0.017, 0.048, -0.021> <-0.013, 0.031, -0.018> <-0.009, 0.020, -0.012> 
		<-0.032, 0.060, -0.014> <-0.029, 0.048, -0.007> <-0.025, 0.031, -0.003> <-0.019, 0.020, 0.000> 
		<-0.038, 0.060, -0.006> <-0.035, 0.048, -0.000> <-0.032, 0.032, 0.006> <-0.027, 0.020, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.019, -0.021> <0.001, 0.014, -0.018> <0.004, 0.008, -0.011> <0.003, 0.006, -0.005> 
		<-0.009, 0.020, -0.012> <-0.007, 0.014, -0.009> <0.003, 0.006, -0.005> <0.001, 0.003, 0.001> 
		<-0.019, 0.020, 0.000> <-0.016, 0.014, 0.002> <-0.011, 0.006, 0.011> <-0.005, 0.004, 0.008> 
		<-0.027, 0.020, 0.009> <-0.024, 0.015, 0.011> <-0.016, 0.009, 0.013> <-0.010, 0.006, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.010, 0.082, -0.045> <-0.009, 0.084, -0.047> <-0.003, 0.084, -0.047> <-0.001, 0.082, -0.046> 
		<-0.015, 0.076, -0.041> <-0.014, 0.078, -0.042> <0.003, 0.078, -0.044> <0.005, 0.076, -0.043> 
		<-0.019, 0.067, -0.034> <-0.009, 0.067, -0.035> <0.000, 0.067, -0.035> <0.010, 0.067, -0.036> 
		<-0.020, 0.059, -0.029> <-0.010, 0.059, -0.030> <0.002, 0.059, -0.031> <0.012, 0.059, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.012, 0.059, -0.032> <0.015, 0.048, -0.026> <0.019, 0.031, -0.021> <0.018, 0.020, -0.014> 
		<0.002, 0.059, -0.031> <0.006, 0.048, -0.025> <0.007, 0.031, -0.020> <0.006, 0.020, -0.013> 
		<-0.010, 0.059, -0.030> <-0.012, 0.048, -0.024> <-0.012, 0.031, -0.018> <-0.010, 0.020, -0.011> 
		<-0.020, 0.059, -0.029> <-0.022, 0.048, -0.023> <-0.024, 0.031, -0.017> <-0.022, 0.020, -0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.018, 0.020, -0.014> <0.018, 0.014, -0.010> <0.015, 0.008, -0.002> <0.009, 0.006, 0.001> 
		<0.006, 0.020, -0.013> <0.006, 0.014, -0.009> <0.010, 0.006, 0.000> <0.005, 0.003, 0.003> 
		<-0.010, 0.020, -0.011> <-0.009, 0.014, -0.008> <-0.011, 0.006, 0.002> <-0.005, 0.003, 0.004> 
		<-0.022, 0.020, -0.010> <-0.021, 0.014, -0.007> <-0.016, 0.008, 0.000> <-0.011, 0.006, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.048, 0.084, 0.009> <-0.049, 0.086, 0.007> <-0.049, 0.085, 0.001> <-0.048, 0.083, -0.001> 
		<-0.044, 0.078, 0.014> <-0.045, 0.080, 0.012> <-0.046, 0.079, -0.004> <-0.045, 0.077, -0.006> 
		<-0.037, 0.068, 0.018> <-0.037, 0.068, 0.008> <-0.038, 0.068, -0.001> <-0.039, 0.067, -0.011> 
		<-0.033, 0.061, 0.019> <-0.033, 0.060, 0.010> <-0.034, 0.060, -0.003> <-0.035, 0.060, -0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.060, -0.013> <-0.030, 0.048, -0.015> <-0.024, 0.031, -0.018> <-0.018, 0.019, -0.017> 
		<-0.034, 0.060, -0.003> <-0.029, 0.048, -0.006> <-0.024, 0.031, -0.006> <-0.017, 0.020, -0.005> 
		<-0.033, 0.060, 0.010> <-0.027, 0.049, 0.012> <-0.022, 0.032, 0.012> <-0.016, 0.020, 0.011> 
		<-0.033, 0.061, 0.019> <-0.027, 0.049, 0.022> <-0.021, 0.032, 0.024> <-0.015, 0.021, 0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 0.019, -0.017> <-0.015, 0.014, -0.016> <-0.007, 0.008, -0.013> <-0.004, 0.005, -0.007> 
		<-0.017, 0.020, -0.005> <-0.014, 0.014, -0.004> <-0.004, 0.006, -0.008> <-0.002, 0.003, -0.002> 
		<-0.016, 0.020, 0.011> <-0.013, 0.015, 0.010> <-0.003, 0.006, 0.013> <-0.001, 0.004, 0.007> 
		<-0.015, 0.021, 0.023> <-0.012, 0.015, 0.022> <-0.005, 0.009, 0.018> <-0.003, 0.006, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.028, 0.085, 0.039> <-0.030, 0.087, 0.039> <-0.035, 0.087, 0.035> <-0.035, 0.085, 0.033> 
		<-0.021, 0.079, 0.040> <-0.023, 0.081, 0.039> <-0.036, 0.081, 0.029> <-0.037, 0.079, 0.027> 
		<-0.014, 0.069, 0.038> <-0.022, 0.069, 0.031> <-0.028, 0.069, 0.026> <-0.036, 0.069, 0.019> 
		<-0.010, 0.062, 0.036> <-0.018, 0.061, 0.030> <-0.027, 0.061, 0.022> <-0.035, 0.061, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.061, 0.015> <-0.033, 0.049, 0.010> <-0.032, 0.032, 0.005> <-0.026, 0.020, 0.001> 
		<-0.027, 0.061, 0.022> <-0.026, 0.049, 0.016> <-0.022, 0.032, 0.012> <-0.017, 0.020, 0.009> 
		<-0.018, 0.061, 0.030> <-0.012, 0.050, 0.028> <-0.008, 0.032, 0.024> <-0.005, 0.021, 0.019> 
		<-0.010, 0.062, 0.036> <-0.005, 0.050, 0.034> <0.001, 0.033, 0.032> <0.004, 0.021, 0.027> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.026, 0.020, 0.001> <-0.024, 0.014, -0.001> <-0.016, 0.008, -0.004> <-0.010, 0.006, -0.002> 
		<-0.017, 0.020, 0.009> <-0.015, 0.015, 0.007> <-0.011, 0.006, -0.002> <-0.005, 0.003, -0.000> 
		<-0.005, 0.021, 0.019> <-0.004, 0.015, 0.016> <0.005, 0.006, 0.011> <0.002, 0.004, 0.006> 
		<0.004, 0.021, 0.027> <0.005, 0.015, 0.024> <0.007, 0.009, 0.016> <0.005, 0.006, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.102, 0.031> <0.003, 0.104, 0.032> <-0.002, 0.104, 0.032> <-0.003, 0.102, 0.032> 
		<0.007, 0.094, 0.029> <0.007, 0.095, 0.029> <-0.006, 0.095, 0.030> <-0.007, 0.094, 0.030> 
		<0.010, 0.082, 0.024> <0.003, 0.082, 0.025> <-0.004, 0.082, 0.025> <-0.010, 0.082, 0.026> 
		<0.011, 0.073, 0.022> <0.004, 0.073, 0.023> <-0.005, 0.073, 0.023> <-0.012, 0.073, 0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.012, 0.073, 0.024> <-0.014, 0.058, 0.020> <-0.016, 0.037, 0.018> <-0.015, 0.023, 0.014> 
		<-0.005, 0.073, 0.023> <-0.007, 0.058, 0.020> <-0.008, 0.037, 0.017> <-0.007, 0.023, 0.013> 
		<0.004, 0.073, 0.023> <0.006, 0.058, 0.019> <0.005, 0.037, 0.016> <0.004, 0.023, 0.012> 
		<0.011, 0.073, 0.022> <0.012, 0.058, 0.018> <0.014, 0.038, 0.015> <0.013, 0.023, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.015, 0.023, 0.014> <-0.015, 0.017, 0.012> <-0.013, 0.009, 0.007> <-0.009, 0.005, 0.005> 
		<-0.007, 0.023, 0.013> <-0.007, 0.017, 0.011> <-0.011, 0.006, 0.006> <-0.006, 0.002, 0.003> 
		<0.004, 0.023, 0.012> <0.004, 0.017, 0.011> <0.007, 0.006, 0.004> <0.002, 0.002, 0.003> 
		<0.013, 0.023, 0.012> <0.012, 0.017, 0.010> <0.010, 0.009, 0.005> <0.005, 0.005, 0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 0.102, 0.016> <0.026, 0.103, 0.017> <0.022, 0.103, 0.021> <0.021, 0.102, 0.021> 
		<0.026, 0.093, 0.012> <0.026, 0.095, 0.013> <0.018, 0.095, 0.023> <0.017, 0.094, 0.023> 
		<0.025, 0.081, 0.007> <0.020, 0.081, 0.013> <0.016, 0.082, 0.018> <0.012, 0.082, 0.023> 
		<0.023, 0.072, 0.005> <0.019, 0.072, 0.010> <0.013, 0.072, 0.017> <0.009, 0.073, 0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.009, 0.073, 0.022> <0.004, 0.058, 0.022> <0.001, 0.038, 0.022> <-0.002, 0.023, 0.019> 
		<0.013, 0.072, 0.017> <0.009, 0.058, 0.017> <0.006, 0.037, 0.016> <0.003, 0.023, 0.012> 
		<0.019, 0.072, 0.010> <0.017, 0.058, 0.007> <0.015, 0.037, 0.006> <0.011, 0.022, 0.004> 
		<0.023, 0.072, 0.005> <0.022, 0.057, 0.002> <0.020, 0.037, -0.001> <0.016, 0.022, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.023, 0.019> <-0.003, 0.017, 0.018> <-0.006, 0.009, 0.013> <-0.004, 0.005, 0.008> 
		<0.003, 0.023, 0.012> <0.002, 0.017, 0.011> <-0.005, 0.006, 0.010> <-0.003, 0.002, 0.005> 
		<0.011, 0.022, 0.004> <0.009, 0.016, 0.003> <0.006, 0.006, -0.003> <0.002, 0.002, -0.001> 
		<0.016, 0.022, -0.003> <0.014, 0.016, -0.003> <0.009, 0.008, -0.005> <0.005, 0.004, -0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 0.101, -0.008> <0.030, 0.102, -0.007> <0.031, 0.103, -0.002> <0.030, 0.101, -0.001> 
		<0.026, 0.092, -0.011> <0.027, 0.094, -0.010> <0.028, 0.095, 0.003> <0.028, 0.093, 0.004> 
		<0.022, 0.080, -0.013> <0.022, 0.081, -0.006> <0.023, 0.081, 0.001> <0.023, 0.081, 0.007> 
		<0.019, 0.071, -0.013> <0.020, 0.072, -0.007> <0.021, 0.072, 0.002> <0.021, 0.072, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.021, 0.072, 0.009> <0.017, 0.058, 0.012> <0.014, 0.038, 0.015> <0.010, 0.023, 0.015> 
		<0.021, 0.072, 0.002> <0.017, 0.057, 0.005> <0.013, 0.037, 0.007> <0.009, 0.023, 0.007> 
		<0.020, 0.072, -0.007> <0.016, 0.057, -0.007> <0.012, 0.037, -0.006> <0.008, 0.022, -0.004> 
		<0.019, 0.071, -0.013> <0.015, 0.057, -0.014> <0.012, 0.036, -0.015> <0.007, 0.022, -0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.010, 0.023, 0.015> <0.008, 0.017, 0.015> <0.002, 0.009, 0.014> <0.000, 0.005, 0.010> 
		<0.009, 0.023, 0.007> <0.007, 0.017, 0.007> <0.001, 0.006, 0.011> <-0.001, 0.002, 0.007> 
		<0.008, 0.022, -0.004> <0.006, 0.016, -0.004> <-0.000, 0.006, -0.006> <-0.002, 0.002, -0.001> 
		<0.007, 0.022, -0.013> <0.005, 0.016, -0.012> <0.001, 0.008, -0.009> <-0.001, 0.004, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.016, 0.100, -0.028> <0.017, 0.101, -0.028> <0.021, 0.102, -0.024> <0.021, 0.100, -0.023> 
		<0.011, 0.092, -0.028> <0.012, 0.093, -0.028> <0.022, 0.094, -0.019> <0.022, 0.092, -0.018> 
		<0.006, 0.080, -0.025> <0.012, 0.080, -0.021> <0.017, 0.080, -0.017> <0.022, 0.080, -0.012> 
		<0.004, 0.071, -0.024> <0.009, 0.071, -0.020> <0.016, 0.071, -0.014> <0.021, 0.072, -0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.021, 0.072, -0.009> <0.020, 0.057, -0.004> <0.020, 0.037, 0.000> <0.016, 0.023, 0.004> 
		<0.016, 0.071, -0.014> <0.015, 0.057, -0.009> <0.013, 0.037, -0.005> <0.010, 0.022, -0.002> 
		<0.009, 0.071, -0.020> <0.005, 0.056, -0.017> <0.003, 0.036, -0.014> <0.001, 0.022, -0.009> 
		<0.004, 0.071, -0.024> <0.000, 0.056, -0.021> <-0.003, 0.036, -0.019> <-0.005, 0.022, -0.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.016, 0.023, 0.004> <0.015, 0.017, 0.005> <0.010, 0.009, 0.008> <0.005, 0.005, 0.007> 
		<0.010, 0.022, -0.002> <0.008, 0.016, -0.000> <0.007, 0.006, 0.007> <0.002, 0.002, 0.006> 
		<0.001, 0.022, -0.009> <0.000, 0.016, -0.007> <-0.006, 0.006, -0.004> <-0.004, 0.002, 0.001> 
		<-0.005, 0.022, -0.014> <-0.006, 0.016, -0.012> <-0.008, 0.008, -0.007> <-0.006, 0.004, -0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.030, 0.100, -0.018> <-0.030, 0.101, -0.019> <-0.027, 0.101, -0.023> <-0.026, 0.100, -0.023> 
		<-0.031, 0.092, -0.013> <-0.031, 0.093, -0.014> <-0.022, 0.093, -0.024> <-0.021, 0.091, -0.024> 
		<-0.029, 0.080, -0.007> <-0.024, 0.080, -0.013> <-0.020, 0.080, -0.018> <-0.016, 0.080, -0.023> 
		<-0.027, 0.071, -0.005> <-0.023, 0.071, -0.010> <-0.017, 0.071, -0.017> <-0.013, 0.071, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 0.071, -0.022> <-0.008, 0.056, -0.020> <-0.004, 0.036, -0.018> <-0.001, 0.022, -0.014> 
		<-0.017, 0.071, -0.017> <-0.013, 0.056, -0.015> <-0.010, 0.036, -0.012> <-0.007, 0.022, -0.008> 
		<-0.023, 0.071, -0.010> <-0.021, 0.057, -0.005> <-0.018, 0.037, -0.002> <-0.014, 0.022, 0.001> 
		<-0.027, 0.071, -0.005> <-0.025, 0.057, 0.000> <-0.024, 0.037, 0.004> <-0.019, 0.022, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.022, -0.014> <0.000, 0.016, -0.013> <0.003, 0.008, -0.007> <0.001, 0.004, -0.002> 
		<-0.007, 0.022, -0.008> <-0.005, 0.016, -0.006> <0.002, 0.006, -0.004> <0.000, 0.002, 0.001> 
		<-0.014, 0.022, 0.001> <-0.012, 0.016, 0.002> <-0.009, 0.006, 0.009> <-0.005, 0.002, 0.007> 
		<-0.019, 0.022, 0.007> <-0.017, 0.016, 0.008> <-0.012, 0.009, 0.010> <-0.008, 0.005, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.099, -0.033> <-0.007, 0.101, -0.033> <-0.002, 0.101, -0.034> <-0.002, 0.099, -0.033> 
		<-0.012, 0.091, -0.029> <-0.011, 0.093, -0.030> <0.002, 0.093, -0.031> <0.003, 0.091, -0.030> 
		<-0.014, 0.080, -0.024> <-0.007, 0.080, -0.024> <-0.001, 0.080, -0.025> <0.006, 0.080, -0.026> 
		<-0.015, 0.071, -0.021> <-0.008, 0.071, -0.022> <0.001, 0.071, -0.022> <0.008, 0.071, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.008, 0.071, -0.023> <0.010, 0.056, -0.018> <0.013, 0.036, -0.014> <0.012, 0.022, -0.009> 
		<0.001, 0.071, -0.022> <0.004, 0.056, -0.018> <0.004, 0.036, -0.014> <0.004, 0.022, -0.008> 
		<-0.008, 0.071, -0.022> <-0.009, 0.056, -0.017> <-0.009, 0.036, -0.012> <-0.007, 0.022, -0.007> 
		<-0.015, 0.071, -0.021> <-0.016, 0.056, -0.016> <-0.017, 0.036, -0.012> <-0.016, 0.022, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.012, 0.022, -0.009> <0.012, 0.016, -0.007> <0.011, 0.008, -0.001> <0.006, 0.005, 0.001> 
		<0.004, 0.022, -0.008> <0.004, 0.016, -0.006> <0.008, 0.006, 0.000> <0.003, 0.002, 0.003> 
		<-0.007, 0.022, -0.007> <-0.007, 0.016, -0.005> <-0.009, 0.006, 0.002> <-0.005, 0.002, 0.004> 
		<-0.016, 0.022, -0.007> <-0.015, 0.016, -0.005> <-0.013, 0.008, 0.001> <-0.008, 0.004, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 0.101, 0.005> <-0.035, 0.102, 0.005> <-0.035, 0.102, -0.000> <-0.035, 0.100, -0.001> 
		<-0.031, 0.093, 0.010> <-0.032, 0.094, 0.009> <-0.033, 0.094, -0.004> <-0.032, 0.092, -0.005> 
		<-0.026, 0.081, 0.012> <-0.027, 0.081, 0.005> <-0.027, 0.081, -0.001> <-0.028, 0.080, -0.008> 
		<-0.024, 0.072, 0.013> <-0.024, 0.072, 0.007> <-0.025, 0.071, -0.002> <-0.025, 0.071, -0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 0.071, -0.009> <-0.021, 0.057, -0.011> <-0.018, 0.036, -0.012> <-0.013, 0.022, -0.011> 
		<-0.025, 0.071, -0.002> <-0.021, 0.057, -0.004> <-0.017, 0.037, -0.004> <-0.012, 0.022, -0.003> 
		<-0.024, 0.072, 0.007> <-0.020, 0.057, 0.009> <-0.016, 0.037, 0.009> <-0.012, 0.022, 0.008> 
		<-0.024, 0.072, 0.013> <-0.019, 0.058, 0.015> <-0.015, 0.037, 0.018> <-0.011, 0.023, 0.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 0.022, -0.011> <-0.011, 0.016, -0.011> <-0.006, 0.008, -0.009> <-0.003, 0.004, -0.004> 
		<-0.012, 0.022, -0.003> <-0.010, 0.016, -0.002> <-0.004, 0.006, -0.006> <-0.002, 0.002, -0.001> 
		<-0.012, 0.022, 0.008> <-0.010, 0.016, 0.008> <-0.003, 0.006, 0.011> <-0.001, 0.002, 0.007> 
		<-0.011, 0.023, 0.017> <-0.009, 0.017, 0.016> <-0.004, 0.009, 0.014> <-0.002, 0.005, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.020, 0.102, 0.027> <-0.021, 0.103, 0.027> <-0.025, 0.103, 0.023> <-0.025, 0.101, 0.022> 
		<-0.015, 0.094, 0.027> <-0.017, 0.095, 0.027> <-0.027, 0.095, 0.019> <-0.027, 0.093, 0.018> 
		<-0.011, 0.082, 0.026> <-0.016, 0.081, 0.022> <-0.021, 0.081, 0.017> <-0.026, 0.081, 0.013> 
		<-0.008, 0.073, 0.025> <-0.013, 0.072, 0.021> <-0.020, 0.072, 0.015> <-0.025, 0.072, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 0.072, 0.011> <-0.024, 0.057, 0.007> <-0.023, 0.037, 0.004> <-0.019, 0.022, 0.001> 
		<-0.020, 0.072, 0.015> <-0.019, 0.057, 0.011> <-0.016, 0.037, 0.009> <-0.013, 0.022, 0.007> 
		<-0.013, 0.072, 0.021> <-0.009, 0.058, 0.019> <-0.007, 0.037, 0.018> <-0.004, 0.023, 0.014> 
		<-0.008, 0.073, 0.025> <-0.004, 0.058, 0.024> <-0.000, 0.038, 0.023> <0.002, 0.023, 0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.019, 0.022, 0.001> <-0.018, 0.016, 0.000> <-0.013, 0.008, -0.002> <-0.008, 0.004, -0.000> 
		<-0.013, 0.022, 0.007> <-0.011, 0.016, 0.006> <-0.009, 0.006, -0.001> <-0.005, 0.002, 0.001> 
		<-0.004, 0.023, 0.014> <-0.003, 0.017, 0.012> <0.004, 0.006, 0.010> <0.001, 0.002, 0.006> 
		<0.002, 0.023, 0.019> <0.003, 0.017, 0.018> <0.005, 0.009, 0.013> <0.003, 0.005, 0.009> 
	}

	texture { txFlowers }
}
