////////////////////////////////
// "Lake Garden"
// - by Miroslav Hundak, 1999.
// - for IRTC >Garden< round
////////////////////////////////

// Scene MODIFY
global_settings {
	ambient_light color rgb 1
	max_trace_level 10
	number_of_waves 10
}

#declare TEXTURE_PREVIEW = 0;	// default = 0
#declare DO_THE_FOG = 1;		// default = 1
#declare CAMERA = 1;			// Camera SELECT, default =1
#declare SPATCH_LIGHTS = 0; 	// Selects sPatch generated lights instead of scene lights, default = 0

// Object SELECT
#declare WATER = 1;
#declare ISLANDS = 1;
#declare ROCKS = 1;
#declare CLIFF = 1;
#declare FAAR = 1;
#declare FALL = 1;
#declare BRIDGES = 1;
#declare SPRAY = 1;
#declare WAPOUR = 1;
#declare TREES = 1;
#declare FLOWER = 1;
#declare BRIDGE_TEST = 0;	// ! only for testing - not normaly in scene !

// Includes
#include "x.inc"		// ! always comes first !
#include "bridge.inc"
#include "ground.inc"
#include "trees.inc"

// Scene SETUP

#switch(CAMERA)
#case(1)
camera {
	location <0, 1.8, -8.8>
	look_at <0, 1.8, 0>
	angle 80
}
#break
#case(2)
camera {
	location <0, 6, -16>
	look_at <0, 12, 0>
	angle 30
}
#break
#end

#if(SPATCH_LIGHTS = 0)
light_source { <20000, 50000, -20000> color rgb <1, 1, 1> }
#else
light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }
#end

#if(DO_THE_FOG)
fog {
	fog_type 2
	distance 100
	color rgb <0.8, 0.8, 1>*1
	fog_offset 0
	fog_alt 30
	turbulence 0.25
}
#end

sky_sphere {
	pigment {
		gradient y
		color_map {
			[ 0 color rgb <0.2, 0.5, 1> ]
			[ 0.2 color rgb <0, 0.4, 0.8> ]
			[ 0.5 color rgb <0.1, 0.1, 0.6> ]
		}
	}
	pigment {
		gradient y
		pigment_map {
			[ 0 color rgbt <1, 1, 1, 1> ]
			[ 0.1 color rgbt <1, 1, 1, 1> ]
			[ 0.4 bozo color_map {
				[ 0 color rgbt <1, 1, 1, 1> ]
				[ 0.2 color rgbt <1, 1, 1, 1> ]
				[ 0.6 color rgbt <1, 1, 1, 0.5> ]
				[ 1 color rgbt <1, 1, 1, 0.25> ]
				}   
				turbulence 0.5
				scale <3, 1, 1>*1/30
			]
		}
	} 
}

// Object SETUP
#if(WATER)
plane { y, 0 texture { txWater_3 } }
#end
 
#if(ISLANDS) object { oIslands } #end
#if(ROCKS) object { oRocks } #end
#if(CLIFF) object { oCliff } #end
#if(FAAR) object { oFaar } #end
#if(FALL) object { oFall } #end

#if(BRIDGES)
object { oBridge scale 1/6 translate <-4.45, 0.4, -0.3> }
object { oBridge scale 1/6 translate <4.4, 0.4, -0.3> }
object { oBridge scale 1/6 translate <-0.3, 1, -8.3> }
#end

#if(TREES)
union {
	object { oTrunks }
	object { oFlowers }
	object { oLeaves }
	object { oLeaf }
	object { oFlower }
	scale 0.45
	translate y*0.8
}
#end

#if(FLOWER) object { oFlower scale 1 translate <-0.2, 0, -4.6> } #end

#if(BRIDGE_TEST)
object { oBridge scale 1/2 translate <0, 0, 0> }
#end

#if(SPRAY)
box { 1, -1
	pigment { color rgbt <1, 1, 1, 1> }
	interior {
		media {
			scattering { 2, color rgb <1, 1, 1> }
			intervals 10
			samples 1, 10
			confidence 0.9999
			variance 1/1000
			density {
				boxed
				ramp_wave
				turbulence 0.5
				color_map {
					[0.0 color rgb <0, 0, 0>]
					[0.1 color rgb <0.8, 0.8, 0.8>]
					[1.0 color rgb <1, 1, 1>]
				}
			}
			scale 0.5
		}
	}
	scale <1, 4.3, 2.5>*4
	translate <-18, 0, 30>
	hollow
}
#end

#if(WAPOUR)
box { 2, -2
	pigment { color rgbt <1, 1, 1, 1> }
	interior {
		media {
			emission color rgb <0.3, 0.3, 0.3>
			intervals 10
			samples 1, 10
			confidence 0.9999
			variance 1/1000
			density {
				boxed
				ramp_wave
				turbulence 1
				color_map {
					[0 color rgb <0, 0, 0>]
					[0.5 color rgb <0.15, 0.15, 0.15>]
					[1 color rgb <0, 0, 0>]
				}
			}
			scale 0.5
		}
	}
	scale <4, 2, 10>*4
	translate <-18, 0, 30>
	hollow
}
#end
