// ===========================================================================
//
// IRTC 'Gardens' - gravel.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// Include a mesh object for the basic gravel shape and define a placement
// macro. The trace_gravel flag controls if the mesh and macro are defined.
// Valid values are:
//
// Value   Effect
// ------ -------
//     0 - Don't define
//     1 - Define
//
// ===========================================================================

#declare r1 = seed (100);

#if (trace_gravel > 0)
	//
	// Are we using mesh or mesh2 objects?
	//

	#if (use_mesh2 = 1)
		#include "gravel_mesh2.inc"
	#else
		#include "gravel_mesh.inc"
	#end

	#macro put_gravel (gravel_location)
		#local col_choice = rand(r1);

		#if (col_choice < 0.15)
			#local gravel_colour = rgb <176/255,132/255,121/255>;
		#else
			#if (col_choice < 0.3)
				#local gravel_colour = rgb <192/255,134/255,122/255>;
			#else
				#if (col_choice < 0.45)
					#local gravel_colour = rgb <190/255,177/255,135/255>;
				#else
					#if (col_choice < 0.6)
						#local gravel_colour = Gray60;
					#else
						#if (col_choice < 0.75)
							#local gravel_colour = Gray90;
						#else
							#local gravel_colour = Gray80;
						#end
					#end
				#end
			#end
		#end

		#local gravel_colour = gravel_colour * (1 - ((0.5 - rand(r1)) / 50));

		object
		{
			gravel_mesh
			scale <0.8 + (rand(r1) / 2.5), 0.8 + (rand(r1) / 2.5), 0.8 + (rand(r1) * 1.2)>
			texture
			{
				pigment
				{
					color gravel_colour
				}
				normal
				{
					granite 0.25
					scale 0.075
				}
			}

			rotate y*(360 * rand(r1))
			rotate x*(360 * rand(r1))
			rotate z*(360 * rand(r1))
			translate gravel_location
		}

	#end
#end

