// ===========================================================================
//
// IRTC 'Gardens' - bricks.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file defines a macro which is used to add paving bricks to the scene.
// The macro (and brick texture) are defined according to the value of the
// trace_bricks flag. Valid values are:
//
// Value   Effect
// ------ -------
//     0 - Don't define macro and texture.
//     1 - Define macro and texture
//
// ===========================================================================

#include "stones.inc"

#if (trace_bricks > 0)
	#declare stonet = seed (2);

	#declare t_stone = texture
	{
		T_Grnt14
		normal
		{
			granite
		}
		scale .5
	}
	texture
	{
		pigment
		{
			granite
			color_map
			{
				[0.0 Clear]
				[0.9 Gold filter 0.5]
				[1.0 DarkTan filter 0.75]
			}
		}
		normal
		{
			crackle 10
			turbulence 0.5
			lambda 3
		}
		scale 3.5
	}

	#declare brick_stone = superellipsoid
	{
		<0.1, 0.1>
		scale 7.5
	}

	#macro place_brick (brick_location)
		object
		{
			brick_stone
			scale <0.95 + (rand(stonet) / 10),0.95 + (rand(stonet) / 10),0.95 + (rand(stonet) / 10)>
			texture
			{
				t_stone
				rotate <360*rand(stonet),360*rand(stonet),360*rand(stonet)>
				translate <100*rand(stonet),100*rand(stonet),100*rand(stonet)>
				scale 7.5
			}
			rotate <-1 + (rand(stonet) * 2),-1 + (rand(stonet) * 2),-1 + (rand(stonet) * 2)>
			translate <-0.25 + (rand(stonet) / 2),-0.25 + (rand(stonet) / 2),-0.25 + (rand(stonet) / 2)>
			translate brick_location
		}
	#end
#end

