// ===========================================================================
//
// IRTC 'Gardens' - add_gravel.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file adds several pieces of gravel to the scene. Gravel is added
// around the base of the sundial and in the border area between the grass and
// the paved area. The trace_gravel flag controls if the gravel is traced. The
// following values are valid:
//
// Value   Effect
// ------ -------
//     0 - No gravel is added
//     1 - Gravel is added
//
// ===========================================================================

#include "gravel.inc"

#declare gravel_random = seed (100);

#if (trace_gravel > 0)
	//
	// Add gravel around the sundial.
	//

	#declare nBrinX = 25;
	#declare nBrinZ = 25;

	#declare cX = -nBrinX;
	#while (cX<nBrinX)
		#declare cZ = -nBrinZ;
		#while (cZ<nBrinZ)
			#declare mvX = 1-rand(gravel_random)-rand(gravel_random);
			#declare mvZ = 1-rand(gravel_random)-rand(gravel_random);

			put_gravel (<(cX +mvX), 1.9, (cZ+mvZ)>)

			#declare cZ = cZ+1;
		#end
		#declare cX = cX+1;
	#end

	//
	// Now add gravel between grass and brick.
	//

	#declare cX = 4*17;
	#while (cX<26*17)
		#declare cZ = 325;
		#while (cZ<335)
			#declare mvX = 1-rand(gravel_random)-rand(gravel_random);
			#declare mvZ = 1-rand(gravel_random)-rand(gravel_random);

			put_gravel (<(cX +mvX), 7, (cZ+mvZ)>)

			#declare cZ = cZ+1;
		#end
		#declare cX = cX+1;
	#end
#end

