// ===========================================================================
//
// IRTC 'Gardens' - add_grass.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This include file adds grass to the 'Spring Blossom' image created for the
// IRTC 'Gardens' round. The work done by this file depends upon the value of
// trace_grass. The following table gives details:
//
// Value   Effect
// ------ -------
//     0 - No grass
//     1 - Simple grass blade, 1/2 density grass patches
//     2 - Full defined grass blade
//     3 - Extra grass patches which only add a handful of blades
//
// ===========================================================================

#include "grass.inc"

#if (trace_grass > 0)
	put_grass_patch (-3.5, 1.5, 90)
	put_grass_patch (-3.5, 0.5, 90)
	put_grass_patch (-3.5, -0.5, 90)

	put_grass_patch (-2.5, 3.5, 270)
	put_grass_patch (-2.5, 2.5, 270)
	put_grass_patch (-2.5, 1.5, 270)
	put_grass_patch (-2.5, 0.5, 270)
	put_grass_patch (-2.5, -0.5, 270)
	put_grass_patch (-2.5, -1.5, 270)

	put_grass_patch (-1.5, 5.5, 90)
	put_grass_patch (-1.5, 4.5, 90)
	put_grass_patch (-1.5, 3.5, 90)
	put_grass_patch (-1.5, 2.5, 90)
	put_grass_patch (-1.5, 1.5, 90)
	put_grass_patch (-1.5, 0.5, 90)
	put_grass_patch (-1.5, -0.5, 90)
	put_grass_patch (-1.5, -1.5, 90)
	put_grass_patch (-1.5, -2.5, 90)

	put_grass_patch (-0.5, 7.5, 270)
	put_grass_patch (-0.5, 6.5, 270)
	put_grass_patch (-0.5, 5.5, 270)
	put_grass_patch (-0.5, 4.5, 270)
	put_grass_patch (-0.5, 3.5, 270)
	put_grass_patch (-0.5, 2.5, 270)
	put_grass_patch (-0.5, 1.5, 270)
	put_grass_patch (-0.5, -1.5, 270)
	put_grass_patch (-0.5, -2.5, 270)

	put_grass_patch (0.5, 9.5, 90)
	put_grass_patch (0.5, 8.5, 90)
	put_grass_patch (0.5, 7.5, 90)
	put_grass_patch (0.5, 6.5, 90)
	put_grass_patch (0.5, 5.5, 90)
	put_grass_patch (0.5, 4.5, 90)
	put_grass_patch (0.5, 3.5, 90)
	put_grass_patch (0.5, 2.5, 90)
	put_grass_patch (0.5, 1.5, 90)
	put_grass_patch (0.5, -1.5, 90)
	put_grass_patch (0.5, -2.5, 90)
	put_grass_patch (0.5, -3.5, 90)

	put_grass_patch (1.5, 11.5, 270)
	put_grass_patch (1.5, 10.5, 270)
	put_grass_patch (1.5, 9.5, 270)
	put_grass_patch (1.5, 8.5, 270)
	put_grass_patch (1.5, 7.5, 270)
	put_grass_patch (1.5, 6.5, 270)
	put_grass_patch (1.5, 5.5, 270)
	put_grass_patch (1.5, 4.5, 270)
	put_grass_patch (1.5, 3.5, 270)
	put_grass_patch (1.5, 2.5, 270)
	put_grass_patch (1.5, 1.5, 270)
	put_grass_patch (1.5, 0.5, 270)
	put_grass_patch (1.5, -0.5, 270)
	put_grass_patch (1.5, -1.5, 270)
	put_grass_patch (1.5, -2.5, 270)
	put_grass_patch (1.5, -3.5, 270)

	put_grass_patch (2.5, 12.5, 90)
	put_grass_patch (2.5, 11.5, 90)
	put_grass_patch (2.5, 10.5, 90)
	put_grass_patch (2.5, 9.5, 90)
	put_grass_patch (2.5, 8.5, 90)
	put_grass_patch (2.5, 7.5, 90)
	put_grass_patch (2.5, 6.5, 90)
	put_grass_patch (2.5, 5.5, 90)
	put_grass_patch (2.5, 4.5, 90)
	put_grass_patch (2.5, 3.5, 90)
	put_grass_patch (2.5, 2.5, 90)
	put_grass_patch (2.5, 1.5, 90)
	put_grass_patch (2.5, 0.5, 90)
	put_grass_patch (2.5, -0.5, 90)
	put_grass_patch (2.5, -1.5, 90)
	put_grass_patch (2.5, -2.5, 90)

	put_grass_patch (3.5, 12.5, 270)
	put_grass_patch (3.5, 11.5, 270)
	put_grass_patch (3.5, 10.5, 270)
	put_grass_patch (3.5, 9.5, 270)
	put_grass_patch (3.5, 8.5, 270)
	put_grass_patch (3.5, 7.5, 270)
	put_grass_patch (3.5, 6.5, 270)
	put_grass_patch (3.5, 5.5, 270)
	put_grass_patch (3.5, 4.5, 270)
	put_grass_patch (3.5, 3.5, 270)
	put_grass_patch (3.5, 2.5, 270)
	put_grass_patch (3.5, 1.5, 270)
	put_grass_patch (3.5, 0.5, 270)
	put_grass_patch (3.5, -0.5, 270)
	put_grass_patch (3.5, -1.5, 270)
	put_grass_patch (3.5, -2.5, 270)

	put_grass_patch (4.5, 12.5, 90)
	put_grass_patch (4.5, 11.5, 90)
	put_grass_patch (4.5, 10.5, 90)
	put_grass_patch (4.5, 9.5, 90)
	put_grass_patch (4.5, 8.5, 90)
	put_grass_patch (4.5, 7.5, 90)
	put_grass_patch (4.5, 6.5, 90)
	put_grass_patch (4.5, 5.5, 90)
	put_grass_patch (4.5, 4.5, 90)
	put_grass_patch (4.5, 3.5, 90)
	put_grass_patch (4.5, 2.5, 90)
	put_grass_patch (4.5, 1.5, 90)
	put_grass_patch (4.5, 0.5, 90)
	put_grass_patch (4.5, -0.5, 90)
	put_grass_patch (4.5, -1.5, 90)

	put_grass_patch (5.5, 12.5, 270)
	put_grass_patch (5.5, 11.5, 270)
	put_grass_patch (5.5, 10.5, 270)
	put_grass_patch (5.5, 9.5, 270)
	put_grass_patch (5.5, 8.5, 270)
	put_grass_patch (5.5, 7.5, 270)
	put_grass_patch (5.5, 6.5, 270)
	put_grass_patch (5.5, 5.5, 270)
	put_grass_patch (5.5, 4.5, 270)
	put_grass_patch (5.5, 3.5, 270)
	put_grass_patch (5.5, 2.5, 270)
	put_grass_patch (5.5, 1.5, 270)
	put_grass_patch (5.5, 0.5, 270)
	put_grass_patch (5.5, -0.5, 270)

	put_grass_patch (6.5, 12.5, 90)
	put_grass_patch (6.5, 11.5, 90)
	put_grass_patch (6.5, 10.5, 90)
	put_grass_patch (6.5, 9.5, 90)
	put_grass_patch (6.5, 8.5, 90)
	put_grass_patch (6.5, 7.5, 90)
	put_grass_patch (6.5, 6.5, 90)
	put_grass_patch (6.5, 5.5, 90)
	put_grass_patch (6.5, 4.5, 90)
	put_grass_patch (6.5, 3.5, 90)
	put_grass_patch (6.5, 2.5, 90)
	put_grass_patch (6.5, 1.5, 90)
	put_grass_patch (6.5, 0.5, 90)

	put_grass_patch (7.5, 12.5, 270)
	put_grass_patch (7.5, 11.5, 270)
	put_grass_patch (7.5, 10.5, 270)
	put_grass_patch (7.5, 9.5, 270)
	put_grass_patch (7.5, 8.5, 270)
	put_grass_patch (7.5, 7.5, 270)
	put_grass_patch (7.5, 6.5, 270)
	put_grass_patch (7.5, 5.5, 270)
	put_grass_patch (7.5, 4.5, 270)
	put_grass_patch (7.5, 3.5, 270)
	put_grass_patch (7.5, 2.5, 270)
	put_grass_patch (7.5, 1.5, 270)

	put_grass_patch (8.5, 12.5, 90)
	put_grass_patch (8.5, 11.5, 90)
	put_grass_patch (8.5, 10.5, 90)
	put_grass_patch (8.5, 9.5, 90)
	put_grass_patch (8.5, 8.5, 90)
	put_grass_patch (8.5, 7.5, 90)
	put_grass_patch (8.5, 6.5, 90)
	put_grass_patch (8.5, 5.5, 90)
	put_grass_patch (8.5, 4.5, 90)
	put_grass_patch (8.5, 3.5, 90)
	put_grass_patch (8.5, 2.5, 90)
	put_grass_patch (8.5, 1.5, 90)

	put_grass_patch (9.5, 12.5, 270)
	put_grass_patch (9.5, 11.5, 270)
	put_grass_patch (9.5, 10.5, 270)
	put_grass_patch (9.5, 9.5, 270)
	put_grass_patch (9.5, 8.5, 270)
	put_grass_patch (9.5, 7.5, 270)
	put_grass_patch (9.5, 6.5, 270)
	put_grass_patch (9.5, 5.5, 270)
	put_grass_patch (9.5, 4.5, 270)
	put_grass_patch (9.5, 3.5, 270)
	put_grass_patch (9.5, 2.5, 270)

	put_grass_patch (10.5, 12.5, 90)
	put_grass_patch (10.5, 11.5, 90)
	put_grass_patch (10.5, 10.5, 90)
	put_grass_patch (10.5, 9.5, 90)
	put_grass_patch (10.5, 8.5, 90)
	put_grass_patch (10.5, 7.5, 90)
	put_grass_patch (10.5, 6.5, 90)
	put_grass_patch (10.5, 5.5, 90)
	put_grass_patch (10.5, 4.5, 90)
	put_grass_patch (10.5, 3.5, 90)

	put_grass_patch (11.5, 12.5, 270)
	put_grass_patch (11.5, 11.5, 270)
	put_grass_patch (11.5, 10.5, 270)
	put_grass_patch (11.5, 9.5, 270)
	put_grass_patch (11.5, 8.5, 270)
	put_grass_patch (11.5, 7.5, 270)
	put_grass_patch (11.5, 6.5, 270)
	put_grass_patch (11.5, 5.5, 270)
	put_grass_patch (11.5, 4.5, 270)

	put_grass_patch (12.5, 12.5, 90)
	put_grass_patch (12.5, 11.5, 90)
	put_grass_patch (12.5, 10.5, 90)
	put_grass_patch (12.5, 9.5, 90)
	put_grass_patch (12.5, 8.5, 90)
	put_grass_patch (12.5, 7.5, 90)
	put_grass_patch (12.5, 6.5, 90)
	put_grass_patch (12.5, 5.5, 90)

	put_grass_patch (13.5, 12.5, 270)
	put_grass_patch (13.5, 11.5, 270)
	put_grass_patch (13.5, 10.5, 270)
	put_grass_patch (13.5, 9.5, 270)
	put_grass_patch (13.5, 8.5, 270)
	put_grass_patch (13.5, 7.5, 270)
	put_grass_patch (13.5, 6.5, 270)
	put_grass_patch (13.5, 5.5, 270)

	put_grass_patch (14.5, 12.5, 90)
	put_grass_patch (14.5, 11.5, 90)
	put_grass_patch (14.5, 10.5, 90)
	put_grass_patch (14.5, 9.5, 90)
	put_grass_patch (14.5, 8.5, 90)
	put_grass_patch (14.5, 7.5, 90)
	put_grass_patch (14.5, 6.5, 90)

	put_grass_patch (15.5, 12.5, 270)
	put_grass_patch (15.5, 11.5, 270)
	put_grass_patch (15.5, 10.5, 270)
	put_grass_patch (15.5, 9.5, 270)
	put_grass_patch (15.5, 8.5, 270)
	put_grass_patch (15.5, 7.5, 270)

	put_grass_patch (16.5, 12.5, 90)
	put_grass_patch (16.5, 11.5, 90)
	put_grass_patch (16.5, 10.5, 90)
	put_grass_patch (16.5, 9.5, 90)
	put_grass_patch (16.5, 8.5, 90)

	put_grass_patch (17.5, 12.5, 270)
	put_grass_patch (17.5, 11.5, 270)
	put_grass_patch (17.5, 10.5, 270)
	put_grass_patch (17.5, 9.5, 270)

	put_grass_patch (18.5, 11.5, 90)
	put_grass_patch (18.5, 10.5, 90)
	put_grass_patch (18.5, 9.5, 90)

	put_grass_patch (19.5, 10.5, 270)

	//
	// The following grass patches only add one or two blades
	// of grass to the image and can only be discerned when
	// they are the only objects displayed. Only trace then
	// if we have really, really been asked to... (doing this
	// saves 22500 objects in the image.
	//

	#if (trace_grass > 2)
		put_grass_patch (-4.5, 0.5, 270)
		put_grass_patch (-3.5, 2.5, 90)
		put_grass_patch (-2.5, 4.5, 270)
		put_grass_patch (-0.5, -3.5, 270)
		put_grass_patch (0.5, -4.5, 90)
		put_grass_patch (2.5, -3.5, 90)
		put_grass_patch (6.5, -0.5, 90)
		put_grass_patch (7.5, 0.5, 270)
		put_grass_patch (12.5, 4.5, 90)
	#end
#end

