// ===========================================================================
//
// IRTC 'Gardens' - add_bricks.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This include file adds several bricks to the scene. If does this by calling
// a placement macro defined in the 'bricks.inc' file. The addition of bricks
// is controlled by the trace_bricks flag. Valid values are as follows:
//
// Value   Effect
// ------ -------
//     0 - No bricks are added
//     1 - All the bricks are added to the scene
//
// ===========================================================================

#include "bricks.inc"

#if (trace_bricks > 0)
	#declare vheight = 10;

	#local linex = 5;
	#while (linex < 26)
		place_brick (<linex*17, vheight, (14.5*25) - 20>)
		#local linex = linex + 1;
	#end

	#local linex = 4;
	#while (linex < 20)
		place_brick (<(17/3) + (linex*17), vheight, ((14.5*25) - 20) + 17>)
		#local linex = linex + 1;
	#end

	#local linex = 5;
	#while (linex < 18)
		place_brick (<((17/3)*2) +linex*17, vheight, ((14.5*25) - 20) + (17*2)>)
		#local linex = linex + 1;
	#end

	#local linex = 6;
	#while (linex < 17)
		place_brick (<linex*17, vheight, ((14.5*25) - 20) + (17*3)>)
		#local linex = linex + 1;
	#end

	#local linex = 7;
	#while (linex < 16)
		place_brick (<(17/3)+linex*17, vheight, ((14.5*25) - 20) + (17*4)>)
		#local linex = linex + 1;
	#end

	#local linex = 7;
	#while (linex < 15)
		place_brick (<((17/3)*2) + (linex*17), vheight, ((14.5*25) - 20) + (17*5)>)
		#local linex = linex + 1;
	#end

	#local linex = 8;
	#while (linex < 14)
		place_brick (<linex*17, vheight, ((14.5*25) - 20) + (17*6)>)
		#local linex = linex + 1;
	#end

	#local linex = 8;
	#while (linex < 12)
		place_brick (<(17/3)+linex*17, vheight, ((14.5*25) - 20) + (17*7)>)
		#local linex = linex + 1;
	#end

	#local linex = 8;
		#while (linex < 11)
		place_brick (<((17/3)*2) + (linex*17), vheight, ((14.5*25) - 20) + (17*8)>)
		#local linex = linex + 1;
	#end

	//
	// Now add the lump of concreate the stones are set into,..
	//

	superellipsoid
	{
		<0.1, 0.1>
		scale <1000, 7, 100>
		translate <0, vheight, 100 + ((14.5*25) - 20 - 7)>
		texture
		{
			Headstone_texture
			normal
			{
				granite
			}
		}
	}
#end

