// ===========================================================================
//
// IRTC 'Gardens' - add_blossom.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This include file defines a blossom object than randomly distributes
// several of them around the scene. The trace_blossom flag defines if the
// blossom is defined and included in the scene. Valid values are:
//
// Value   Effect
// ------ -------
//     0 - No Blossom is defined or added
//     1 - Blossom is defined and added to the scene
//
// ===========================================================================

#include "blossom.inc"

#if (trace_blossom > 0)
	#declare put_blossom_rand = seed (100);
	#declare blossom_height = 10.5;
	#declare blossom_count = 0;

	#while (blossom_count < 150)
		#declare x_loc = -100 + (575 * rand (put_blossom_rand));
		#declare z_loc = -100 + (400 * rand (put_blossom_rand));

		#if (((x_loc < -25) | (x_loc > 25)) & ((z_loc < -25) | (z_loc > 25)))
			put_blossom (<x_loc, blossom_height, z_loc>)
		#end

		#declare blossom_count = blossom_count + 1;
	#end
#end

