//WYS35.pov    18/12/99        Ian and Ethel MacKay  ( C )

#include "colors.inc"
#include "stones1.inc"

 // scale 2 units = 1 foot approx

global_settings {
                  max_trace_level 10
                }
                                                                          0-
background { color rgb < 0.4, 0.4, 0.8 > }

light_source { < 1000, 1500, -1000 > color White  }   
light_source { < -1000, 200, -100 > color Gray50  shadowless }   

 
camera {
        location < 0, -2, -90 >  
        look_at   < 2, 4, 0 >          
        angle 45
       }
// ********* SKY
sphere { 0, 1
       pigment { 
                gradient y
                color_map {
                          [ 0.0 color rgb < 0.6, 0.5, 0.6 > ] 
                          [ 0.2 color rgb < 0.4, 0.4, 0.8 > ]
                          [ 1.0 color rgb < 0.4, 0.4, 0.8 > ]
                          }
               }
       finish { ambient 0.4 }
       scale 10000
       }
                          
// ******** CLOUDS
#declare Mclouds =
                union {
plane { y, 500                          
            pigment { 
                     gradient z
                     turbulence 0.7
                     color_map {
                               [ 0.0 color Clear ]
                               [ 0.3 color Clear ]
                               [ 0.35 color rgbt < 0.8, 0.7, 0.7, 0.5 > ]
                               [ 0.45 color rgbt < 0.8, 0.7, 0.7, 0.5 > ]
                               [ 0.55 color Clear ]
                               [ 1.0 color Clear ]
                               }
                          scale < 1000, 1, 1000 >
                     }
             finish { ambient 0.4 }
        }
plane { y, 510                          // CLOUDS
            pigment { 
                     gradient z
                     turbulence 0.7
                     color_map {
                               [ 0.0 color Clear ]
                               [ 0.3 color Clear ]
                               [ 0.35 color rgbt < 0.98, 0.87, 0.87, 0.5 > ]
                               [ 0.45 color rgbt < 0.98, 0.87, 0.87, 0.5 > ]
                               [ 0.55 color Clear ]
                               [ 1.0 color Clear ]
                               }
                          scale < 1000, 1, 1000 >
                     }
             finish { ambient 0.6 }
           }
        }
object { Mclouds rotate 30*y  translate 260*z  }

// ******* LAKE  
#declare Hole =
prism {
      cubic_spline
      0,
      1,
      14,
      < -30, 60 >,< -50, 100 >,< -30, 140 >,< 50, 145 >,< 90, 120 >,
      < 100, 80 >,< 40, 0 >,< 27, 40 >,< 50, 70 >,< -12, 100 >,
      < -28, 70 >,< -30, 60 >,< -50, 100 >,< -30, 140 >
      texture {
         pigment { 
                gradient x
                turbulence 1.0
                color_map {    
                          [ 0.0 color rgb < 0.3, 0.4, 0.1 > ]
                          [ 0.2 color rgb < 0.3, 0.3, 0.1 > ] 
                          [ 0.23 color rgb < 0.3, 0.2, 0 > ]  
                          [ 0.3 color rgb < 0.5, 0.4, 0.1 > ]  
                          [ 0.43 color rgb < 0.3, 0.1, 0 > ]  
                          [ 0.6 color rgb < 0.5, 0.5, 0.1 > ]  
                          [ 0.85 color rgb < 0.3, 0.2, 0 > ]  
                          [ 0.9 color rgb < 0.5, 0.4, 0.1 > ]  
                          [ 1.0 color rgb < 0.3, 0.2, 0 > ]  
                          }
                   scale 30
              }
      finish { ambient 0.2 }
      }
      texture {
               pigment {
                       gradient y
                       color_map {
                                  [ 0.0 color Clear ]
                                  [ 0.8 color Clear ]
                                  [ 0.8 color White ]
                                  [ 0.81 color White ]
                                  [ 0.81 color Clear ]
                                  [ 1.0 color Clear ]
                                  }
                       }
               }
      scale < 1, 10, 1 >
      translate -19*y
      }
difference {                               // lake basin & lawn
           box { < -500, -10, -200 >,< 500, -20, 2000 > 
              texture {
                pigment { 
                        granite 
                        color_map {
                                  [ 0.0 color rgb < 0.3, 0.5, 0.2 > ]
                                  [ 0.2 color rgb < 0.2, 0.5, 0.2 > ]
                                  [ 0.2 color rgb < 0.3, 0.6, 0.2 > ]
                                  [ 0.4 color rgb < 0.3, 0.6, 0.2 > ]
                                  [ 0.4 color rgb < 0.3, 0.5, 0.2 > ]
                                  [ 0.6 color rgb < 0.3, 0.5, 0.2 > ]
                                  [ 0.6 color rgb < 0.3, 0.6, 0.2 > ]
                                  [ 0.8 color rgb < 0.3, 0.6, 0.2 > ]
                                  [ 1.0 color rgb < 0.2, 0.4, 0.2 > ]
                                  }
                      }
                normal { wrinkles scale 4 }
                finish { ambient 0.2 }
                      }
             texture {
               pigment { color Clear }    
               normal { bumps 2 scale 0.5 }
                     }
               }
           object { Hole }
           }
plane { y, -11                      // lake surface
       pigment { color rgbt < 0.2, 0.2, 0.3, 0.75 > }
       normal { ripples scale 10 turbulence 0.5 }
       finish { ambient 0.2
                reflection 0.5
              }
      }
// ************GAZEBO
#declare Single =                                       // roof tile
                box { < -1.25, -1.25, -1.15 >,< 1.25, 1.25, 1.15 >
                   pigment { color rgb < 0.3, 0.4, 0.3 > }
                   finish { ambient 0.2 }
                 }

#declare Line =                                         // line of tiles
           union {
                 object { Single }
                 object { Single translate 2.4*z }
                 object { Single translate 4.8*z } 
                 object { Single translate 7.2*z }
                 object { Single translate 9.6*z } 
                 object { Single translate 12*z }
                 object { Single translate 14.4*z }
                 object { Single translate 16.8*z } 
                 object { Single translate -2.4*z }
                 object { Single translate -4.8*z } 
                 object { Single translate -7.2*z }
                 object { Single translate -9.6*z } 
                 object { Single translate -12*z }
                 object { Single translate -14.4*z }
                 object { Single translate -16.8*z }    
                   rotate -5*z
                   translate -12*x
                 }
#declare Slates =                         // panel of roof tiles
            union {
                   object { Line }
                   object { Line translate 1.155*z rotate -12*z }
                   object { Line rotate -24*z }
                   object { Line translate 1.155*z rotate -36*z }
                   object { Line rotate -48*z }
                   object { Line translate 1.155*z rotate -60*z }
                   object { Line rotate -72*z }
                   object { Line translate 1.155*z rotate -84*z }
                  }
#declare Segmt =                             // segment of roof
            object { Slates
                    clipped_by {
                               box { < -5.35, 0, -5.35 >,< 5.35, 15, 5.35 >
                                     rotate 45*y
                                     scale < 1.73, 1, 1 >
                                     translate -13*x
                                   }
                               }
                    }
#declare Dome =                            // roof of six segments
           union {
                  object { Segmt }
                  object { Segmt rotate 60*y }
                  object { Segmt rotate 120*y } 
                  object { Segmt rotate 180*y } 
                  object { Segmt rotate -60*y } 
                  object { Segmt rotate -120*y } 
                  scale < 1, 0.76, 1 >
                 }
#declare Colmn =                              // columns
           union {
                    cylinder { < 0, 0, 0 >,< 0, 15, 0 >,0.8 }      
                    cylinder { < 0, 0, 0 >,< 0, 6, 0 >,1.1 }  
                    torus { 1.1, 0.3 }
                    torus { 1.1, 0.3 
                           translate 6*y
                          }
                    torus { 0.8, 0.3 
                           translate 15*y
                          }   
                     translate 10*x     
                     texture { T_Stone12 scale 3 }
                 }  
                  
#declare Balus =              // balusters
           union {
            sphere { < 0, 0, 0 >,3
                      scale < 0.17, 1, 0.17 >
                   }
            torus { 0.4, 0.2
                   translate -2.8*y 
                  }
            torus { 0.4, 0.2
                   translate 2.8*y 
                  }
             translate 10*x
             texture { T_Stone12 scale 3 } 
            }
#declare Rail =                          // all balusters
         union {  
                object { Balus rotate 14*y translate 3*y }
                object { Balus rotate 22*y translate 3*y } 
                object { Balus rotate 30*y translate 3*y } 
                object { Balus rotate 38*y translate 3*y } 
                object { Balus rotate 46*y translate 3*y }  
               }

#declare Railing =                            // handrail
          union {
                object { Rail rotate 60*y translate -5*y }
                object { Rail rotate 120*y translate -5*y } 
                object { Rail rotate 180*y translate -5*y } 
                object { Rail rotate 240*y translate -5*y } 
                torus { 10, 0.5
                         scale < 1, 0.5, 1 >
                         clipped_by {
                                    box { < -12, -1, -12 >,< 6, 1, 12 > }
                                    }
                         translate 1*y
                         texture { T_Stone12 scale 3 } 
                      }
                }
#declare Steps =
                union { 
                       box { < 11.5, -6, -1 >,< 14.5, -7, 1 > }
                       box { < 11.5, -7, -1 >,< 16.5, -8, 1 > } 
                       box { < 11.5, -8, -1 >,< 18.5, -9, 1 > } 
                       box { < 11.5, -9, -1 >,< 20.5, -10, 1 > }  
                         texture { T_Grnt25 scale 0.25 }
                       }
#declare Stairs =
               union {
                     object { Steps }
                     object { Steps rotate 5*y }
                     object { Steps rotate 10*y }  
                     object { Steps rotate 15*y }  
                     object { Steps rotate 20*y }  
                     object { Steps rotate 25*y }  
                     object { Steps rotate 30*y }  
                     object { Steps rotate 35*y }
                     object { Steps rotate 40*y }  
                     object { Steps rotate 45*y }  
                     object { Steps rotate 50*y }  
                     object { Steps rotate 55*y }  
                     object { Steps rotate -5*y }
                     object { Steps rotate -10*y }  
                     object { Steps rotate -15*y }  
                     object { Steps rotate -20*y }  
                     object { Steps rotate -25*y }  
                     object { Steps rotate -30*y }  
                     object { Steps rotate -35*y }
                     object { Steps rotate -40*y }  
                     object { Steps rotate -45*y }  
                     object { Steps rotate -50*y }  
                     object { Steps rotate -55*y }  
                     
                     }
#declare Gaz =                            // Gazebo 
           union {
                  object { Stairs }
                object { Railing }
                object { Colmn translate -5*y }
                object { Colmn rotate 60*y translate -5*y }
                object { Colmn rotate -60*y translate -5*y } 
                object { Colmn rotate 120*y translate -5*y } 
                object { Colmn rotate -120*y translate -5*y } 
                object { Colmn rotate 180*y translate -5*y } 
                difference {
                cylinder { < 0, 10, 0 >,< 0, 12, 0 >,11.5 }
                cylinder { < 0, 9, 0 >,< 0, 13, 0 >,9.5 }   
                            texture { T_Grnt25 scale 0.5 }
                           }
                cylinder { < 0, -5, 0 >,< 0, -6, 0 >,12.5 
                            texture { T_Stone12 scale 3 } 
                         }
                cylinder { < 0, -6, 0 >,< 0, -9, 0 >,11.5 
                            texture { T_Grnt25 scale 0.5 }
                         }
                cylinder { < 0, -9, 0 >,< 0, -10, 0 >,12.5 
                            texture { T_Stone12 scale 3 }  
                         }  
                object { Dome rotate 30*y translate 11*y }         
                }

object { Gaz translate < -12, 0, 70 > }

// **********WILLOW 
#declare Will =
              union {
                     torus { 1, 0.075
                            rotate 90*x
                            clipped_by {    
                                  box { < -1.5, 0, -1 >,< 1.5, 1.5, 1 > }
                                       }
                            scale < 0.6, 2, 0.6 >
                            translate < -0.5, -1, 0 >
                           }
                     sphere { < 0, 0, 0 >,1 }
                     cone { < 0, 0, 0 >,0.5,< 0, -5, 0 >,0.0 
                             translate -0.5*x }
                     cone { < 0, 0, 0 >,0.5,< 0, -4, 0 >,0.0 }
                     cone { < 0, 0, 0 >,0.5,< 0, -3, 0 >,0.0 
                             translate 0.5*x }
                     scale < 1, 1, 0.2 >           
         pigment { 
                 bozo
                 turbulence 0.9
                 color_map {
                           [ 0 color rgbt < 1, 1, 1, 1 > ]
                           [ 0.19 color rgbt < 1, 1, 1, 1 > ]  
                           [ 0.19 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]   
                           [ 0.3 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]  
                           [ 0.3 color rgbt < 1, 1, 1, 1 > ]  
                           [ 0.39 color rgbt < 1, 1, 1, 1 > ] 
                           [ 0.39 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]   
                           [ 0.5 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]  
                           [ 0.5 color rgbt < 1, 1, 1, 1 > ]   
                           [ 0.56 color rgbt < 1, 1, 1, 1 > ]  
                           [ 0.56 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]   
                           [ 0.7 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]  
                           [ 0.7 color rgbt < 1, 1, 1, 1 > ]  
                           [ 0.78 color rgbt < 1, 1, 1, 1 > ]   
                           [ 0.78 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]  
                           [ 0.86 color rgbt < 0.4, 0.6, 0.2, 0.1 > ]  
                           [ 0.86 color rgbt < 1, 1, 1, 1 > ]   
                           [ 1.0 color rgbt < 1, 1, 1, 1 > ]  
                           }
                   scale < 0.25, 2, 0.25 >
                 }
           normal { bumps 0.9 scale 0.005 }
           finish { ambient 0.3 }
        }
#declare Brnch =
           cone { < 0, 0, 0 >,0.4,< 0, 12, 0 >,0.1
                   pigment { color rgb < 0.3, 0.5, 0.2 > }
                   finish { ambient 0.2 }
                }
#declare Trunk =
    union {
           cone { < -1.1, 13, 0 >,0.34,< 0, 16, 0 >,0.3  }
           cone { < -1.3, 11, 0 >,0.4,< -1.1, 13, 0 >,0.34 }
           cone { < -1.5, 8, -0.1 >,0.46,< -1.3, 11, 0 >,0.4 } 
           cone { < -1.4, 5, 0.2 >,0.53,< -1.5, 8, -0.1 >,0.46  }
           cone { < -1, 3, 0.3 >,0.6,< -1.4, 5, 0.2 >,0.53 } 
           cone { < 0, 0, 0 >,1,< -1, 3, 0.3 >,0.65  }
                   pigment { color rgb < 0.3, 0.5, 0.2 > }
                   finish { ambient 0.2 }
          }

#declare Weepy =        
        union {
object { Will scale 5 translate < -8, 10, 0 > }
object { Will scale 4 translate < -3, 14, 0 > rotate 30*y } 
object { Will scale 5 translate < -8, 8, 0 > rotate -30*y } 
object { Will scale 4 translate < -5, 13, 0 > rotate 45*y } 
object { Will scale 5 translate < -2, 10, 0 > rotate -65*y } 
              }                  
#declare Willow =              
         union {
object { Weepy translate < -10, 5, 0 > }              
object { Weepy rotate 140*y translate < -10, 8, 0 > }              
object { Weepy scale < 1, 0.6, 0.6 > rotate -140*y translate < -5, 7, 0 > }              
object { Will scale 0.5 translate < 0, 4, 0 > }
object { Brnch rotate 45*z translate < -6, 4, 0 > }
object { Brnch rotate -45*z translate < -6, 4, 0 > }
object { Brnch rotate < 30, 20, 0 > translate < -6, 4, 0 > } 
object { Trunk rotate 15*z translate < -2, -10, 0 > }
        translate -10*y
               }
object { Willow scale 0.8 translate < 13, 5, 160 > }
object { Willow scale 0.6 rotate 120*y translate < 30, 0, 160 > }
object { Willow  rotate 160*y translate < -50, 5, 90 > }   

 // *********WYSTERIA
#declare Pet =
         union {
             disc { < 0, 0, 0 >,< 1, 0, 0 >,1
                   clipped_by {
                           box { < -1, -0.5, -1 >,< 1, 1.1, 1 > }
                              }
                   rotate -45*z
                   translate  -0.75*x
                  }
             disc { < 0, 0, 0 >,< 0, 1, 0 >,1
                   clipped_by {
                           box { < -1, -1, -1.1 >,< 1.1, 1, 0 > }
                              }
                   rotate -30*x
                  }
             disc { < 0, 0, 0 >,< 0, 1, 0 >,1
                   clipped_by {
                           box { < -1, -1, 0 >,< 1.1, 1, 1.1 > }
                              }
                   rotate 30*x
                  }
             pigment { color rgbt < 0.8, 0.8, 1, 0.15 > }
             finish { ambient 0.25 }
             }


#declare Stem =
             torus { 4, 0.1
                    rotate 90*x
                    clipped_by {
                               box { < -5, 0, -1 >,< -1, 5, 1 > }
                               }
                    scale < 1, 1.25, 1 >
                    translate 4*x
                    pigment { color rgb < 0.2, 0.6, 0.2 > }
                    finish { ambient 0.2 }
                    }
#declare Twist =
             torus { 4, 0.2
                    rotate 90*x
                    clipped_by {
                               box { < -4, 0, -1 >,< 4, 5, 1 > }
                               }
                    scale < 4, 1, 1 >  
                    pigment { color rgb < 0.2, 0.6, 0.2 > }
                    finish { ambient 0.2 }
                    }
#declare Vine =
             union {
                   object { Twist }
                   object { Twist rotate 180*x translate 32*x }
                   }

#declare Top =
      union {
             object { Pet rotate < 0, 15, -4 > translate < 1.5, -1.8, 0 > }
             object { Pet scale 1.25
                      rotate < 0, -15, -12 > translate < 2.3, -3, 0 > } 
             object { Pet scale 1.5
                      rotate < 0, 15, -35 > translate < 2.9, -5, 0 > } 
             object { Pet scale 1.5
                      rotate < 0, -15, -50 > translate < 2.7, -7.5, 0 > } 
            }

#declare Mid =
        union {   
             object { Pet scale 1.3
                      rotate < 0, 15, -62 > translate < 2.3, -2.4, 0 > } 
             object { Pet scale < 1.2, 1, 1 >
                      rotate < 0, -15, -68 > translate < 2, -4.4, 0 > } 
             object { Pet scale < 1, 0.5, 0.5 >
                      rotate < 0, 15, -73 > translate < 1, -6.4 0 > } 
              }
#declare Bot =
         union {
             object { Pet scale < 0.9, 0.5, 0.4 >
                      rotate < 0, -10, -77 > translate < 0.9, -1.8, 0 > } 
             object { Pet scale < 0.7, 0.5, 0.4 >
                      rotate < 0, 5, -80 > translate < 0.7, -3.5, 0 > } 
             object { Pet scale < 0.5, 0.4, 0.3 >
                      rotate < 0, 0, -85 > translate < 0.5, -6, 0 > } 
             }

#declare Btop =
           union {
                  object { Top }
                  object { Top rotate 45*y translate -1*y }    
                  object { Top rotate 90*y }    
                  object { Top rotate 135*y translate -1*y }    
                  object { Top rotate 180*y }    
                  object { Top rotate -45*y translate -1*y }    
                  object { Top rotate -90*y }    
                  object { Top rotate -135*y translate -1*y }    
                  cone { < 0, 0, 0 >,0.08,< 0, -1.1, 0 >,0.06         
                    pigment { color rgb < 0.2, 0.6, 0.2 > }
                    finish { ambient 0.2 }
                       }   
                 }
#declare Bmid =
           union {
                  object { Mid }
                  object {  Mid rotate 45*y translate -1*y }    
                  object {  Mid rotate 90*y }    
                  object {  Mid rotate 135*y translate -1*y }    
                  object {  Mid rotate 180*y }    
                  object {  Mid rotate -45*y translate -1*y }    
                  object {  Mid rotate -90*y }    
                  object {  Mid rotate -135*y translate -1*y }    
                 }
#declare Bbot =
           union {
                  object { Bot }
                  object { Bot rotate 45*y translate -1*y }    
                  object { Bot rotate 90*y }    
                  object { Bot rotate 135*y translate -1*y }    
                  object { Bot rotate 180*y }    
                  object { Bot rotate -45*y translate -1*y }    
                  object { Bot rotate -90*y }    
                  object { Bot rotate -135*y translate -1*y }    
                 }

#declare Abunch =             // straight bunch
         union { 
               object { Btop }
               object { Bmid translate -7.5*y }
               object { Bbot translate -14*y }
               object { Stem rotate -90*y }
               }
#declare Bbunch =                   // curved bunch
         union {    
               object { Btop }
               object { Bmid rotate 10*z translate -7.5*y }
               object { Bbot rotate 25*z translate < 1.5, -14, 0 > }
               object { Stem }
               }
#declare Clust =
         union {
             object { Abunch }
             object { Bbunch rotate -25*z translate < -4.5, 2, 4 > }                  
             object { Bbunch rotate < 0, 180, 25 > translate < 4.5, -2, 4 > }                  
                      translate < 0, -4, -4 >
               }
#declare Bclust =
         union {
             object { Abunch }
             object { Bbunch scale < 1, 1.25, 1 >
                      rotate -25*z translate < -4.5, 2, 4 > }                  
             object { Bbunch scale < 0.8, 1.25, 0.8 > 
                      rotate < 0, 180, 25 > translate < 4.5, 2, 4 > }                  
                      translate < 0, -4, -4 >
               }

#declare Agroup =
            union {
                    object { Vine }   
                    object { Clust translate -16*x }
                  }
#declare Bgroup =
            union {
                    object { Vine }   
                    object { Bclust translate -16*x }
                  }
#declare Super =
      union {
object { Agroup }
object { Agroup translate < 10, 12, -6 > }  
object { Agroup translate < -6, 10, -6 > } 
object { Agroup translate < -12, -6, -6 > }  
object { Bgroup translate < 18, 8, -4 > }
object { Bgroup translate < -25, 12, 8 > }
object { Agroup translate < -5, 16, -6 > }  
object { Agroup translate < 6, 14, 6 > } 
           }
#declare Mega =                  
                  union {
object { Super }
object { Super translate < 25, 20, -10 > }
object { Super translate < 40, 0, 0 > }
                        }
#declare Wysteria =
            union {
object { Mega rotate 90*y translate < -80, 20, -25 > }
object { Mega translate < -50, 10, 0 > }
object { Mega translate < 0, 30, 20 > }
object { Mega translate < 25, 20, -20 > }       
object { Super translate < 90, 0, -10 > }
object { Super translate < 120, -20, -10 > }  
object { Super translate < 100, 20, -20 > }
object { Clust translate < 80, 29, 0 > }    
                 }
 
#declare Stick =
          texture {
                   pigment { color rgb < 0.6, 0.3, 0.2 > }
                   normal { wrinkles scale < 0.25, 10, 0.25 > }
                   finish { ambient 0.2 }
                  }

#declare Wunk =  
       
             torus { 10, 2
                    rotate 90*z
                    clipped_by {
                               box { < -15, -15, 0 >,< 15, 15, 15 > }
                               }
                    scale < 1, 8, 1 >  
                    pigment { color rgb < 0.2, 0.6, 0.2 > }
                    finish { ambient 0.2 }
                    }
// ********VINE
#declare Vino =
          union {
                 cone { < 3, 0, 0 >,0.1,< 5, 0, 0 >,0.08 }
                 disc { < 4, 1, 0 >,< 1, 0, 0 >,1      
                          scale < 1, 1, 0.3 >
                          rotate 60*x
                      }
                 disc { < 4, 1, 0 >,< 1, 0, 0 >,1      
                          scale < 1, 1, 0.3 >
                          rotate 180*x
                      }
                 disc { < 4, 1, 0 >,< 1, 0, 0 >,1      
                          scale < 1, 1, 0.3 >
                          rotate -60*x
                      }
                 disc { < 5, 1, 0 >,< 1, 0, 0 >,1      
                          scale < 1, 1, 0.3 >
                      }
                 disc { < 5, 1, 0 >,< 1, 0, 0 >,1      
                          scale < 1, 1, 0.3 >
                          rotate 120*x
                      }
                 disc { < 5, 1, 0 >,< 1, 0, 0 >,1      
                          scale < 1, 1, 0.3 >
                          rotate -120*x
                      }
                 pigment { color rgb < 0.3, 0.5, 0.2 > }
                 finish { ambient 0.2 }
                 }
#declare Gvino =
             union {
                   object { Vino }
                   object { Vino rotate 25*y }
                   object { Vino rotate 62*y }
                   object { Vino rotate 85*y }
                   object { Vino rotate -35*y }
                   object { Vino rotate -60*y }
                   object { Vino rotate -95*y }
                   rotate -30*x
                   }
#declare Rvino =
             union {
                   object { Vino rotate 180*y }
                   object { Vino rotate -125*y }
                   object { Vino rotate -162*y }
                   object { Vino rotate -105*y }
                   object { Vino rotate 135*y }
                   object { Vino rotate 160*y }
                   object { Vino rotate 95*y }
                   rotate -30*x
                   }


#declare Vin =
         union {
             torus { 3, 0.1
                     rotate -30*x
                     clipped_by {
                               box { < 0, -3, -3 >,< 3, 3, 3 > } 
                                }
                     scale < 1, 4, 1 >
                     pigment { color rgb < 0.8, 0.6, 0.4 > }
                     finish { ambient 0.2 }
                    }
              object { Gvino }
               }
#declare Von =
          union {
             torus { 3.45, 0.1
                     rotate -30*x
                     clipped_by {
                               box { < 0, -3, -3 >,< -3, 3, 3 > } 
                                }
                     scale < 1, 4, 1 >
                     pigment { color rgb < 0.8, 0.6, 0.4 > }
                     finish { ambient 0.2 }
                    }
               object { Rvino }
                  }
#declare Vine =
        union {
object { Vin  translate 10*y }
object { Vin rotate 180*y translate 15*y } 
object { Vin  translate 5.5*y }
object { Vin rotate 180*y translate 10.5*y } 
object { Vin rotate 90*y  translate 3*y }
object { Vin rotate -90*y translate 8*y } 

object { Von  translate 14*y }
object { Von rotate 120*y translate 25*y } 
object { Von  translate 3.5*y }
object { Von rotate 120*y translate 13.5*y } 
object { Von rotate 60*y  translate 6*y }
object { Von rotate -60*y translate 12*y } 

object { Vin  translate 20*y }
object { Vin rotate 180*y translate 25*y } 
object { Vin  translate 15.5*y }
object { Vin rotate 180*y translate 20.5*y } 
object { Vin rotate 90*y  translate 13*y }
object { Vin rotate -90*y translate 18*y } 

object { Von  translate 24*y }
object { Von rotate 120*y translate 35*y } 
object { Von  translate 23.5*y }
object { Von rotate 120*y translate 313.5*y } 
object { Von rotate 60*y  translate 26*y }
object { Von rotate -60*y translate 32*y } 
                rotate 75*y
            }


#declare Pgol =
      union {
object { Wunk translate < 82, -15, -25 > }
object { Vine translate < -100, -95, 0 > }
object { Vine rotate -50*y translate < -100, -85, 0 > }  

cylinder { < -110, 35, 0 >,< 85, 35, 0 >,2.5 texture { Stick rotate 90*z } }
cylinder { < 80, 37, 0 >,< 80, -120, 0 >,2.5 texture { Stick } } 
cylinder { < -100, 37, 0 >,< -100, -120, 0 >,2.5 texture { Stick } }  
cylinder { < -100, 40, 10 >,< -100, 40, -150 >,2.5 }
             
cylinder { < 70, 40, 10 >,< 70, 40, -150 >,2.5  } 
cylinder { < -15, 40, 10 >,< -15, 40, -150 >,2.5  }  
cylinder { < 28, 40, 10 >,< 28, 40, -150 >,2.5  } 
cylinder { < -57, 40, 10 >,< -57, 40, -150 >,2.5  }  
            texture { Stick rotate 90*x }  
            }
object { Pgol scale 0.17 rotate 15*y translate < 4, 6, -50 > }
object { Wysteria scale 0.13 rotate 15*y translate < 1, 7, -52 > } 


#declare Marker =
           cylinder { < 0, 0.1, 0 >,< 0, -0.1, 0 >,2  
                    texture { T_Stone12 scale 5 }  
                    }
 
object { Marker translate < 10, -10, 50 > }   
object { Marker translate < 12.5, -10, 45 > }  
object { Marker translate < 15, -10, 40 > }   
object { Marker translate < 17.5, -10, 35 > }  
object { Marker translate < 20, -10, 30 > }   
object { Marker translate < 21.5, -10, 25 > }  
object { Marker translate < 21, -10, 20 > }   
object { Marker translate < 21.5, -10, 15 > }  
object { Marker translate < 22, -10, 10 > }
object { Marker translate < 23, -10, 5 > }  
object { Marker translate < 22, -10, 0 > }   
object { Marker translate < 21.5, -10, -5 > }  
object { Marker translate < 21, -10, -10 > }   
object { Marker translate < 20.5, -10, -15 > }  
object { Marker translate < 18, -10, -20 > }   
object { Marker translate < 15, -10, -25 > }  
object { Marker translate < 12, -10, -30 > }   
object { Marker translate < 10, -10, -35 > }  
object { Marker translate < 7, -10, -40 > }   
object { Marker translate < 3.5, -10, -45 > }  
object { Marker translate < 0, -10, -50 > }   
object { Marker translate < -2.5, -10, -55 > }  
object { Marker translate < -5, -10, -60 > }   


// **************PINE
// LEAVES
#declare Shape =
          union {
           sphere { 0, 1 scale < 0.3, 1, 0.65 > }
           sphere { 0, 0.15 translate < -0.15, 0.8, 0 > }
           sphere { 0, 0.15 translate < -0.23, 0.6, 0.2 > }  
           sphere { 0, 0.15 translate < -0.23, 0.5, -0.2 > }  
           sphere { 0, 0.15 translate < -0.3, 0.2, 0 > }  
           sphere { 0, 0.15 translate < -0.23, -0.5, -0.2 > }  
           sphere { 0, 0.15 translate < -0.3, -0.2, 0 > }  
           
                   pigment { 
                         granite   
                         color_map {
                                   [ 0.0 color rgb < 0.2, 0.4, 0.1 > ]
                                   [ 0.18 color rgb < 0.2, 0.4, 0.1 > ]
                                   [ 0.2 color Clear ]
                                   [ 0.3 color Clear ] 
                                   [ 0.33 color rgb < 0.4, 0.4, 0.1 > ]
                                   [ 0.5 color rgb < 0.4, 0.4, 0.1 > ]
                                   [ 0.5 color Clear ] 
                                   [ 0.66 color Clear ] 
                                   [ 0.66 color rgb < 0.2, 0.6, 0.1 > ]
                                   [ 0.78 color rgb < 0.2, 0.6, 0.1 > ]
                                   [ 0.78 color Clear ] 
                                   [ 1.0 color Clear ]
                                    }  
                              }
                   finish { ambient 0.2 }   
               }

#declare Tips  =
          union {
            object { Shape }
            cone { < 0, 0, 0 >,0.025,< 0, -2, 0 >,0.05
                   pigment { color rgb < 0.2, 0.4, 0.2 > }
                   finish { ambient 0.2 }
                 }
             translate 2*y
             rotate -60*z
         }
#declare Fuss =
            union {
                  object { Tips }
                  object { Tips  translate -0.24*y rotate 60*y }
                  object { Tips  rotate 120*y }
                  object { Tips  translate -0.24*y rotate 180*y }
                  object { Tips   rotate -60*y }
                  object { Tips  translate -0.24*y rotate -120*y } 
                  }
#declare Mino =
            union {
                   object { Fuss }
                   object { Fuss scale 0.75 rotate 30*y translate 1.25*y }
                   object { Fuss scale 0.57  translate 2.25*y }
                   object { Fuss scale 0.19 rotate 30*y translate 3*y }
                   object { Fuss scale 0.12  translate 3.3*y }
                   object { Fuss scale 0.05 rotate 30*y translate 3.6*y }
                   object { Fuss scale 1.2  translate -1.25*y }
                   object { Fuss scale 1.3 rotate 30*y translate -2.5*y }
                   object { Fuss scale 1.4  translate -3.3*y }
                   object { Fuss scale 1.5 rotate 30*y translate -4*y }
                   cone { < 0, -4.5, 0 >,0.15,< 0, 3.6, 0 >,0.025
                           pigment { color rgb < 0.2, 0.4, 0.2 > }
                           finish { ambient 0.2 }
                        }   
                        translate 4.5*y
                   }
#declare Pine =
           union {
object { Mino }
object { Mino rotate 15*y translate 0.6*y }
                 }

// *************** LAMBERTIANA

// LEAVES
#declare Pips  =
          union {
           sphere { 0, 1
                scale < 0.25, 1, 0.75 > 
                texture {
                   pigment { 
                         granite   
                         color_map {
                                   [ 0.0 color rgb < 0.4, 0.7, 0.1 > ]
                                   [ 0.2 color rgb < 0.4, 0.7, 0.1 > ]
                                   [ 0.2 color Clear ]
                                   [ 0.3 color Clear ] 
                                   [ 0.3 color rgb < 0.4, 0.7, 0.1 > ]
                                   [ 0.5 color rgb < 0.4, 0.7, 0.1 > ]
                                   [ 0.5 color Clear ] 
                                   [ 0.6 color Clear ] 
                                   [ 0.6 color rgb < 0.4, 0.7, 0.1 > ]
                                   [ 0.8 color rgb < 0.4, 0.7, 0.1 > ]
                                   [ 0.8 color Clear ] 
                                   [ 1.0 color Clear ]
                                    }  
                            scale 0.5        
                              }
                   finish { ambient 0.2 }   
                }   
            }
            cone { < 0, 0, 0 >,0.025,< 0, -2, 0 >,0.05
                   pigment { color rgb < 0.2, 0.4, 0.2 > }
                   finish { ambient 0.2 }
                 }
             translate 2*y
             rotate -45*z
         }
#declare Tuss =
            union {
                  object { Pips }
                  object { Pips  translate -0.24*y rotate 60*y }
                  object { Pips  rotate 120*y }
                  object { Pips  translate -0.24*y rotate 180*y }
                  object { Pips   rotate -60*y }
                  object { Pips  translate -0.24*y rotate -120*y } 
                  }
#declare Core =
            union {
                   object { Tuss }
                   object { Tuss scale 0.75 rotate 30*y translate 1.25*y }
                   object { Tuss scale 0.57  translate 2.25*y }
                   object { Tuss scale 0.19 rotate 30*y translate 3*y }
                   object { Tuss scale 0.12  translate 3.3*y }
                   object { Tuss scale 0.08 rotate 30*y translate 3.6*y }
                   object { Tuss scale 1.2  translate -1.25*y }
                   object { Tuss scale 1.3 rotate 30*y translate -2.5*y }
                   object { Tuss scale 1.4  translate -3.3*y }
                   object { Tuss scale 1.5 rotate 30*y translate -4*y }
                   cone { < 0, -4.5, 0 >,0.15,< 0, 3.6, 0 >,0.025
                           pigment { color rgb < 0.2, 0.4, 0.2 > }
                           finish { ambient 0.2 }
                        }   
                        translate 4.5*y
                   }
#declare Lamber =
             union {
object { Core scale < 1.5, 0.8, 1.5 > }
object { Core  scale < 1.5, 0.8, 1.5 > rotate 15*y translate 0.6*y }
                   }

// ********* LINE of TREES
object { Lamber scale 3 translate < -90, -10, 170 > }
object { Lamber scale 2.7 translate < -45, -10, 170 > }     
object { Lamber scale 3.2translate < 60, -10, 170 > }     
object { Lamber scale 3.2translate < 100, -10, 170 > }     



object { Pine scale 8 translate < 70, -10, 240 > }  
object { Pine rotate 90*y scale 9.5 translate < 100, -10, 280 > } 
object { Pine scale 10 translate < 50, -10, 260 > }  
object { Pine rotate 90*y scale 9.5 translate < 10, -10, 280 > } 
object { Pine scale 8 translate < -50, -10, 300 > }  
object { Pine rotate 90*y scale 9.5 translate < -30, -10, 200 > } 
object { Pine rotate 90*y scale 9.5 translate < -100, -10, 280 > } 
object { Pine scale 8 translate < -12, -10, 300 > }  
object { Pine rotate 90*y scale 9.5 translate < 130, -10, 200 > } 
object { Pine rotate 45*y scale 7 translate < -140, -10, 240 > } 


//*********AFLEUR
#declare Clump =          // blue flowers
             union { 
                  sphere { 0, 0.5 }
                  sphere { 0, 0.35 translate -0.6*x } 
                  sphere { 0, 0.45 translate 0.5*x } 
                    pigment {
                             granite 
                             turbulence 0.75
                             color_map {
                                        [ 0.0 color Clear ]
                                        [ 0.45 color Clear ]
                                        [ 0.45 color rgb < 0.2, 0.2, 1 > ]
                                        [ 0.55 color White ]
                                        [ 0.575 color White ]
                                        [ 0.65 color rgb < 0.2, 0.2, 1 > ]
                                        [ 0.65 color Clear ]
                                        [ 1.0 color Clear ]
                                        }
                          scale 0.5
                             }
                    finish { ambient 0.3 }   
                      }
#declare Lump =                  // yellow-green leaves
             union { 
                  sphere { 0, 0.4 }
                  sphere { 0, 0.25 translate -0.6*x } 
                  sphere { 0, 0.35 translate 0.5*x } 
                    pigment {
                             granite 
                             color_map {
                                        [ 0.0 color Clear ]
                                        [ 0.1 color Clear ]
                                        [ 0.1 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.2 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.2 color Clear ]
                                        [ 0.3 color Clear ]
                                        [ 0.3 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.4 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.4 color Clear ]
                                        [ 0.5 color Clear ]
                                        [ 0.5 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.6 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.6 color Clear ]
                                        [ 0.7 color Clear ]
                                        [ 0.7 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.8 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.8 color Clear ]
                                        [ 1.0 color Clear ]
                                        }   
                             }
                    finish { ambient 0.2 }   
                      }

#declare Afleur =
              union {
                     object { Clump }
                     object { Lump }
                     }
//**********BFLEUR
#declare Bunch =             // yellow flowers
             union { 
                  sphere { 0, 0.5 scale < 0.8, 1.1, 0.8 > }
                  sphere { 0, 0.35 scale < 0.8, 1.1, 0.8 > translate -0.3*x } 
                  sphere { 0, 0.45 scale < 0.8, 1.1, 0.8 > translate 0.3*x } 
                    pigment {
                             granite 
                             turbulence 0.75
                             color_map {
                                        [ 0.0 color Clear ]
                                        [ 0.5 color Clear ]
                                        [ 0.5 color rgb < 0.8, 0.6, 0.1 > ]
                                        [ 0.6 color rgb < 0.8, 0.6, 0.1 > ] 
                                        [ 0.6 color Yellow ]
                                        [ 0.65 color Yellow ]
                                        [ 0.65 color rgb < 0.8, 0.6, 0.1 > ]
                                        [ 0.7 color rgb < 0.8, 0.6, 0.1 > ] 
                                        [ 0.7 color Clear ]
                                        [ 1.0 color Clear ]
                                        } 
                          scale 0.1
                             }
                    finish { ambient 0.3 }   
                      }
#declare Blump =              // blue-green leaves
             union { 
                  sphere { 0, 0.4 scale < 0.8, 1.1, 0.8 > }
                  sphere { 0, 0.25 scale < 0.8, 1.1, 0.8 > translate -0.3*x } 
                  sphere { 0, 0.35 scale < 0.8, 1.1, 0.8 > translate 0.3*x } 

                    pigment {
                             granite 
                             color_map {
                                        [ 0.0 color Clear ]
                                        [ 0.1 color Clear ]
                                        [ 0.1 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.2 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.2 color Clear ]
                                        [ 0.3 color Clear ]
                                        [ 0.3 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.4 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.4 color Clear ]
                                        [ 0.5 color Clear ]
                                        [ 0.5 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.6 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.6 color Clear ]
                                        [ 0.7 color Clear ]
                                        [ 0.7 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.8 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.8 color Clear ]
                                        [ 1.0 color Clear ]
                                        }   
                             }
                    finish { ambient 0.2 }   
                      }

#declare Bfleur =
              union {
                     object { Bunch }
                     object { Blump }
                     }
//**********CFLEUR     (  red spears  )
#declare Spear =
        union {
           torus { 2, 0.0075                      // stem
                  rotate 90*x
                  clipped_by {
                          box { < -2.5, 0.5, -1 >,< 0, -0.5, 1 > }
                             }
                  translate  2.2*x   
                    pigment { color rgb < 0, 0.25, 0 > }
                  }
                    
           torus { 2, 0.08                         // flowers
                  rotate 90*x
                  clipped_by {
                          box { < -2.5, 0.5, -1 >,< 0, 1.5, 1 > }
                             }
                  translate 2.2*x
                    pigment {
                             granite 
                             turbulence 0.75
                             color_map {
                                        [ 0.0 color Clear ]
                                        [ 0.4 color Clear ]
                                        [ 0.4 color rgb < 1, 0.4, 0 > ]
                                        [ 0.7 color rgb < 1, 0.4, 0 > ] 
                                        [ 0.75 color Clear ]
                                        [ 1.0 color Clear ]
                                        } 
                          scale 0.4
                             }
                    finish { ambient 0.3 }   
                      }
                  scale 0.75
                 }
#declare Spray =              // blue-green leaves
             union { 
                  sphere { 0, 0.4 scale < 0.6, 2, 0.6 > }
                  sphere { 0, 0.25 scale < 0.6, 2, 0.6 > translate -0.3*x } 
                  sphere { 0, 0.35 scale < 0.6, 2, 0.6 > translate 0.3*x } 

                    pigment {
                             granite 
                             color_map {
                                        [ 0.0 color Clear ]
                                        [ 0.1 color Clear ]
                                        [ 0.1 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.2 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.2 color Clear ]
                                        [ 0.3 color Clear ]
                                        [ 0.3 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.4 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.4 color Clear ]
                                        [ 0.5 color Clear ]
                                        [ 0.5 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.6 color rgb < 0.1, 0.6, 0.25 > ]
                                        [ 0.6 color Clear ]
                                        [ 0.7 color Clear ]
                                        [ 0.7 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.8 color rgb < 0.1, 0.6, 0.5 > ]
                                        [ 0.8 color Clear ]
                                        [ 1.0 color Clear ]
                                        }   
                               scale < 1, 3, 1 >         
                             }
                    finish { ambient 0.2 }   
                      }

#declare Cfleur =
              union {
                     object { Spear }
                     object { Spear rotate < 0, 60, -6 > translate 0.3*y }
                     object { Spear rotate < 0, -80, -3 > translate 0.2*y }  
                     object { Spear rotate < 0, 120, 9 > }  
                     object { Spear rotate < 0, -160, 12 > translate 0.2*y }  
                     object { Spray }
                     scale < 0.6, 0.5, 0.6 >
                     }
//**********GARDEN SECTION
#declare Grdn =
        union {
object { Afleur  }
object { Bfleur scale < 2, 3, 2 > translate 1.2*z } 
            translate -10*z
              }
#declare Sgrdn =
        union {
object { Afleur  }
object { Cfleur scale < 2, 3, 2 > translate 1.2*z } 
            translate -10*z
              }

#declare Kgrdn =
            union {
object { Grdn }
object { Sgrdn rotate -9*y }
object { Grdn scale < 1, 1.2, 1 > rotate -18*y } 
object { Grdn rotate -27*y } 
object { Sgrdn rotate -36*y } 
object { Grdn scale < 1, 1.2, 1 > rotate -45*y } 
object { Grdn rotate -54*y } 
object { Sgrdn scale < 1, 1.2, 1 > rotate -63*y }
object { Grdn rotate -72*y } 
object { Grdn rotate -81*y } 
          scale 1.65
          translate -10*y      
                   }
#declare Lgrdn = 
            union {
object { Kgrdn }
object { Kgrdn rotate 90*y }
object { Kgrdn rotate 180*y }   
object { Kgrdn rotate -90*y }   
          
                  }
object { Lgrdn translate < -8, 0, -20 > }
object { Lgrdn rotate 45*y translate < -45, 0, 35 > }  

//********** SWAN
#declare Curv =                             // neck curve
              torus { 0.4, 0.2
                      rotate 90*x
                      clipped_by {
                               box { < -1.5, -0.05, -1 >,< 1.5, 1.5, 1 > }
                                 }
                     pigment { color White }
                     finish { ambient 0.2 }
                     }   
#declare Aswan =
            union {
                  sphere { 0, 2                      // body
                           scale < 1, 0.5, 0.5 >
                           rotate 10*z
                         }
                  union {                                           // head
                         cylinder { < -0.4, 0, 0 >,< -0.4, 0.2, 0 >,0.22 
                                    pigment { color Black }  
                                  }   
                         sphere { < -0.4, 0, 0 >,0.18
                                 pigment { color Red }
                                }
                              rotate -35*z translate < -1.35, 3, 0 > 
                            }
                  sphere { 0, 0.4                             // bill
                           scale < 1, 0.2, 0.7 >
                           rotate 55*z
                           translate < -1.8, 3, 0 >
                           pigment { color Red }
                          }
                  union {                                       // l wing
                        cone { < 0, 0, 0 >,0.0,< 3, 1, 0 >,1 }     
                        cone { < 0, 0, 0 >,0.0,< 3.5, 0.6, 0.15 >,1 }  
                           scale < 1, 1, 0.1 >
                           rotate 15*y
                           translate -1.9*x
                        }
                  union {                                       // r wing
                        cone { < 0, 0, 0 >,0.0,< 3, 1, 0 >,1 }     
                        cone { < 0, 0, 0 >,0.0,< 3.5, 0.6, -0.15 >,1 }  
                           scale < 1, 1, 0.1 >
                           rotate -15*y
                           translate -1.9*x
                        }
                  cone { < 0, 0, 0 >,0.0,< 2.05, 0.8, 0 >,0.3    // tail
                           scale < 1, 1, 0.1 >
                       }
                  cone { < 0, 0.25, 0 >,0.0,< 1.75, 1, 0 >,0.3    // tail  
                           scale < 1, 1, 0.1 >
                           pigment { color White }
                       }

                  object { Curv rotate 135*z translate < -1.8, 0.5, 0 > }
                  cylinder { < -2.1, 0.8, 0 >,< -0.97, 2.9, 0 >,0.2 }
                  object { Curv rotate -35*z translate < -1.35, 3, 0 > } 
                         pigment { color White }
                         finish { ambient 0.2 }
                  }

object { Aswan translate < 76, -10.76, 116 > }
object { Aswan rotate -120*y translate < 69, -10.76, 117 > }  

// ********** PARK BENCH

//******PARASOL
#declare Seg =
             union {
                    sphere { 0, 1.25
                            scale < 0.2, 1, 0.15 >
                            }
                    sphere { 0, 0.35
                            scale < 0.5, 1, 0.2 >
                            translate 1.4*y
                           }
                    torus { 0.38, 0.05
                            scale < 0.5, 1, 0.2 > 
                            translate 1.6*y
                          }
                           rotate 3*z
                           clipped_by {
                                    box { < -1.5, -2, -1 >,< 0, 1.55, 1 > }
                                      }
                           pigment { color rgb < 1, 0.9, 0.7 > }
                           normal { bumps scale 0.005 }
                           finish { ambient 0.2 } 
                   }        
#declare Parasol =                   
               union {
                      object { Seg }                   
                      object { Seg rotate 60*y }
                      object { Seg rotate 120*y } 
                      object { Seg rotate 180*y }
                      object { Seg rotate -60*y } 
                      object { Seg rotate -120*y }  
                      cone { < 0, -1.75, 0 >,0.02,< 0, 2.5, 0 >,0.05
                             pigment { color rgb < 0.65, 0.5, 0.4 > }
                             finish { ambient 0.2 }
                           }
                      cone { < 0, 2, 0 >,0.055,< 0, 2.5, 0 >,0.07
                             pigment { color rgb < 0.95, 0.8, 0.5 > }
                             finish { ambient 0.2 }
                           } 
                           rotate < 0, 30, -25 >
                     }



//*********HAT
#declare Brim =
              cylinder { < 0, 0, -5 >,< 0, 0, 5 >,2.2
                       clipped_by {
                                    cylinder { < 0, 0, 0 >,< 0, 5, 0 >,1.3 } 
                                  }
                       translate -2.2*y
                           pigment { color rgb < 1, 0.9, 0.7 > }
                           normal { bumps scale 0.005 } 
                           finish { ambient 0.2 } 
                   }        
#declare Deco =                   
              union {
                     sphere { 0, 0.2 }
                     sphere { 0, 0.1 translate 0.1*y } 
                     sphere { 0, 0.12 translate < 0.025, 0.1, 0.025 > } 
                     sphere { 0, 0.12 translate < 0.025, 0.1, -0.025 > } 
                     sphere { 0, 0.12 translate < -0.025, 0.1, 0.025 > }
                       clipped_by {
                               box { < -0.3, -0.2, -0.3 >,< 0.3, 0, 0.3 > }
                                  }
                       scale 1.2
                       pigment { color rgb < 1, 0.8, 0.3 > }
                       finish { ambient 0.2 }
                    }
#declare Ribbon =
             
              cylinder { < 0, 0, -5 >,< 0, 0, 5 >,2.5
                       clipped_by {
                             box { < 0, 0, 0.1 >,< -1.8, 2.6, -0.1 > }
                                  }
                       translate -2.49*y
                             pigment { color rgb < 0.8, 0, 0.6 > }
                             finish { ambient 0.2 }
                        }  
#declare Crown =
             union {
                   object { Ribbon }
                   object { Ribbon 
                            scale < 0.75, 1, 1 >
                            rotate 20*y
                            translate < -0.25, 0.1, -0.1 >
                          } 
                   object { Deco translate < -0.72, 0.2, 0 > }
                   object { Deco translate < -0.72, 0.3, -0.3 > }
                   object { Deco translate < -0.52, 0.3, -0.4 > }
                   sphere { 0, 0.5
                           scale < 1, 0.05, 1 >
                           translate 0.3*y
                          }
                   cylinder { < 0, 0, 0 >,< 0, 0.35, 0 >,0.5 }
                   cylinder { < 0, 0, 0 >,< 0, 0.2, 0 >,0.52 
                             pigment { color rgb < 0.8, 0, 0.6 > }
                             finish { ambient 0.2 }
                             } 

                           pigment { color rgb < 1, 0.9, 0.7 > }
                           normal { bumps scale 0.005 } 
                           finish { ambient 0.2 } 
                   }        


#declare Hat =
           union {
                  object { Brim }
                  object { Crown }  
                  rotate 60*z
                  }


#declare Bench =
          texture {
                    pigment { color rgb < 0.56, 0.35, 0.1 > }
                    normal { bumps scale < 0.01, 1, 1 > }
                    finish { ambient 0.25 }
                  }
#declare One =                                        // a leg
           box { < -0.25, 0, -0.25 >,< 0.25, 3.5, 0.25 >
                texture { Bench rotate 90*x }
               }
#declare Two  =                                        // an end rail
           box { < -0.2, 0, -0.24 >,< 3.5, 0.5, 0.24 >
                texture { Bench rotate 90*y }    
               }
#declare Three =                                         // arm rest       
           box { < -0.75, 3.5, -0.275 >,< 3.75, 3.75, 0.275 >
                texture { Bench rotate 90*y }    
               }
#declare Four =                                 // brace rail
           box { < -0.25, 0, -0.2 >,< 0.25, 0.5, 15.2 >
                texture { Bench }    
               }
#declare Five =                                 // seat rail
           box { < -0.21, 2.5, -0.24 >,< 0.21, 2.75, 15.24 >
                texture { Bench }    
               }
#declare Six =                                     // seat
           union {
                  object { Five }
                  object { Five translate 0.5*x } 
                  object { Five translate 1*x } 
                  object { Five translate 1.5*x }
                  object { Five translate 2*x } 
                  object { Five translate 2.5*x } 
                  object { Five translate 3*x } 
                  }
#declare Slat =
              box { < -0.08, 0.5, 0.25 >,< 0.08, 2.5, 0.75 >  
                   texture { Bench rotate 90*x }    
               }
              
#declare Back =
            union {
                  box { < -0.12, 0, 0.25 >,< 0.12, 0.5, 14.75 > }
                  box { < -0.12, 2.5, 0.25 >,< 0.12, 3, 14.75 > }  
                  object { Slat scale < 1.2, 1, 1 > }
                  object { Slat translate  1*z } 
                  object { Slat translate  2*z }
                  object { Slat translate  3*z }   
                  object { Slat translate  4*z }   
                  object { Slat translate  5*z }   
                  object { Slat translate  6*z }   
                  object { Slat translate  7*z }   
                  object { Slat translate  8*z } 
                  object { Slat translate  9*z }
                  object { Slat translate  10*z }   
                  object { Slat translate  11*z }   
                  object { Slat translate  12*z }   
                  object { Slat translate  13*z }   
                  object { Slat  scale < 1.2, 1, 1 > translate  14*z }   
                  rotate -20*z
                  translate < 3.25, 2.75, 0 > 
                       texture { Bench }    
               }
                  
                  

#declare End =
           union {
                  object { One }
                  object { One translate 3.5*x }
                  object { Two translate 0.75*y }
                  object { Two translate 2*y }   
                  object { Three  }
                 }
#declare Seat =
          union {
object { End }
object { End translate 15*z }
object { Four translate < 1.5, 0.75, 0 > }
object { Six }
object { Back} 
object { Parasol  rotate -90*y translate < 1, 1.5, -1.35 > } 
object { Hat rotate -25*y translate < -0.5, 3.45, -0.25 > }  
                }

object { Seat rotate 9*y translate < 16, -10, -48 > }

//**********BUSH
#declare Rise =
           union {
                 cone { < 0, 0, 0 >,0.1,< 0, 1, 0.1 >,0.09 }
                 cone { < 0, 1, 0.1 >,0.09,< 0, 2, 0 >,0.08 } 
                 cone { < 0, 2, 0 >,0.08,< 0, 3, 0 >,0.07 } 
                  pigment { color rgb < 0.8, 0.7, 0.7 > }
                  finish { ambient 0.2 }
                }
#declare Rlif =
              disc { < 0, 0, 0 >,< 1, 1, 0 >,0.15
                      scale < 1, 1, 0.5 >
                      translate 0.25*x
                  pigment { color rgb < 0.35, 0.5, 0.2 > }
                  finish { ambient 0.2 }
                }
#declare Rfol =
              union {
                   object { Rlif }
                   object { Rlif rotate 30*y translate 0.2*y }
                   object { Rlif rotate 60*y translate -0.2*y }   
                   object { Rlif rotate 120*y translate 0.2*y }   
                   object { Rlif rotate -120*y translate -0.2*y }  
                   object { Rlif rotate -60*y translate 0.2*y }   
                   object { Rlif rotate -30*y translate -0.2*y }   
                      rotate -30*z
                   }
#declare Mfol =
              union {
                   object { Rfol }
                   object { Rfol rotate 30*y translate 0.5*y }
                   object { Rfol rotate 60*y translate -0.5*y }   
                   object { Rfol rotate 120*y translate 0.5*y }   
                   object { Rfol rotate -120*y translate -0.5*y }  
                   object { Rfol rotate -60*y translate 0.5*y }   
                   object { Rfol rotate -30*y translate -0.5*y }   
                   }

#declare Bit =
            union {
                 object { Mfol translate < 1, 3.35, 0.2 > }
                 object { Mfol translate < 2, 4, -0.2 > } 
                 object { Mfol translate < 2.5, 4.5, 0.2 > } 
                 object { Mfol translate < 1.5, 4, 1 > } 
                 cone { < 0, 3, 0 >,0.07,< 1, 3.35, 0.2 >,0.06 }
                 cone { < 1, 3.35, 0.2 >,0.06,< 2, 4, -0.2 >,0.05 } 
                 cone { < 2, 4, -0.2 >,0.05,< 2.5, 4.5, 0 >,0.04 } 
                 cone { < 1, 3.35, 0.2 >,0.06,< 1.5, 4, 1 >,0.05 }
                 cone { < 2, 4, -0.2 >,0.05,< 2.5, 4.5, -0.8 >,0.04 } 
                 cone { < 0, 3, 0 >,0.07,< 0.5, 3.8, -1 >,0.06 } 
                  pigment { color rgb < 0.8, 0.7, 0.7 > }
                  finish { ambient 0.2 }
                }
#declare Ball =
            union {
                   object { Bit }
                   object { Bit scale < 0.8, 1.2, 1 > rotate 100*y }
                   object { Bit scale < 1.1, 1, 1.1 > rotate 160*y } 
                   object { Bit scale < 1.2, 1.1, 1.2 > rotate -100*y } 
                   }
#declare Part =
           union {
                  object { Rise }
                  object { Ball }
                  }
#declare Bush =
           union {
object { Part }
object { Part scale 0.6 rotate 90*y translate 2.3*y }
                 }
object { Bush translate < -5, -10, -20 > }                  
object { Bush rotate 90*y translate < -11, -10, -20 > }      

                  

                  

                      
                      
                      
                      

                      







                                


                  

                  

                  

                  

                  

                      
                      
                      
                      

                      

