
/*
default {
  texture {
    pigment { rgb <1,0,0> }
  }
}
*/

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//background { color <0.000,0.000,0.000> }

// final view camera
camera {  
  location  <    226.612,    -606.640,     114.279>
  direction <        0.0,         0.0,      4.4962> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   <    389.596,     -52.438,      21.317>
}


/*  
//  Temp View camera
camera { 
  location  <    358,    -78,      10>
  direction <        0.0,         0.0,      1.7796> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   < 358,                -38,           10> 
}

*/
light_source {   // Light1
  <639.873, -439.158, 289.869> *3
  color rgb <1.000, 1.000, 1.000>
}


#include "blbkyard.inc"           


//**************************************** Dirt Rocks ***********************************************

#declare DirtRock1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <2.621367, 4.544947, 4.661429>
  rotate 178.060654*z
  translate  <385.069165, -43.940679, -0.556648>
}
#declare DirtRock2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <2.045784, 3.546995, 3.637901>
  rotate 105.048332*z
  translate  <417.792191, -24.306864, -0.556648>
}
#declare DirtRock3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.564007, 5.777494, 2.955549>
  rotate 178.060654*z
  translate  <437.426006, -45.031446, -0.556648>
}
#declare DirtRock4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate 165.640305*z
  translate  <436.335238, -15.580724, -0.556648>
}
#declare DirtRock5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate -176.039169*z
  translate  <450.059821, -24.306864, -0.556648>
}
#declare DirtRock6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate 144.985016*z
  translate  <352.34614, -51.576051, -0.556648>
}
#declare DirtRock7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate 178.060654*z
  //translate  <367.616885, -26.488399, -0.556648>
  translate <0, 0, 0>
}        

#declare DirtRock8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate -17.551769*z
  translate  <415.610656, -65.756029, -0.556648>
}
#declare DirtRock9 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate 178.060654*z
  translate  <424.336796, -49.394516, -0.556648>
}
#declare DirtRock10 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <-2.297059, -5.646755, -2.955549>
  rotate <-180.0, 0.0, 178.060654>
  translate  <332.712325, -49.394516, -0.556648>
}
#declare DirtRock11 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate -165.249756*z
  translate  <473.421333, -49.394516, -0.556648>
}
#declare DirtRock12 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate 167.297089*z
  translate  <458.34758, -64.612358, -0.556648>
}
#declare DirtRock13 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    Dirt1
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate -151.101959*z
  translate  <308.71544, -53.757586, -0.556648>
}
union { 
  object { DirtRock1 }
  object { DirtRock2 }
  object { DirtRock3 }
  object { DirtRock4 }
  object { DirtRock5 }
  object { DirtRock6 }
  object { DirtRock7 }
  object { DirtRock8 }
  object { DirtRock9 }
  object { DirtRock10 }
  object { DirtRock11 }
  object { DirtRock12 }
  object { DirtRock13 }
}


//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< pile of rocky looking rocks >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  

#declare Rock1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016529, -0.240328, -0.500000>, <-0.138765, -0.220850, -0.514198>, <-0.345101, -0.289915, -0.390996>, <-0.456225, -0.289915, -0.279872>, 
      <0.011811, -0.332519, -0.214555>, <-0.143483, -0.313041, -0.228753>, <-0.187571, -0.395434, -0.152837>, <-0.298695, -0.395434, -0.041714>, 
      <0.021350, -0.310421, 0.208343>, <0.088026, -0.312403, 0.224391>, <-0.034922, -0.402227, 0.305864>, <0.009650, -0.419944, 0.256807>, 
      <0.016529, -0.240328, 0.500000>, <0.083205, -0.242309, 0.516048>, <0.158120, -0.354842, 0.536425>, <0.202693, -0.372559, 0.487369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <-0.001137, -0.022208, 0.568762>, <0.015368, -0.223443, 0.570259>, <0.016529, -0.240328, 0.500000>, 
      <0.059650, -0.023031, 0.524871>, <0.058514, -0.045240, 0.593633>, <0.082044, -0.225424, 0.586307>, <0.083205, -0.242309, 0.516048>, 
      <0.153734, -0.112021, 0.544351>, <0.191132, -0.137072, 0.600890>, <0.203949, -0.343593, 0.591161>, <0.158120, -0.354842, 0.536425>, 
      <0.186164, -0.132231, 0.487369>, <0.223562, -0.157282, 0.543908>, <0.248521, -0.361310, 0.542104>, <0.202693, -0.372559, 0.487369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033058, 0.082645, -0.500000>, <0.034617, 0.059977, -0.594320>, <0.018055, -0.210514, -0.592311>, <0.016529, -0.240328, -0.500000>, 
      <-0.086362, 0.111905, -0.529623>, <-0.084803, 0.089238, -0.623944>, <-0.137239, -0.191036, -0.606509>, <-0.138765, -0.220850, -0.514198>, 
      <-0.261842, 0.014211, -0.439474>, <-0.322009, -0.000558, -0.511335>, <-0.394200, -0.257027, -0.465225>, <-0.345101, -0.289915, -0.390996>, 
      <-0.353500, 0.000000, -0.353500>, <-0.413667, -0.014769, -0.425361>, <-0.505324, -0.257027, -0.354101>, <-0.456225, -0.289915, -0.279872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033058, 0.082645, -0.500000>, <0.028218, 0.153015, -0.207190>, <0.004737, 0.092555, 0.213427>, <0.000000, 0.000000, 0.500000>, 
      <-0.086362, 0.111905, -0.529623>, <-0.091202, 0.182276, -0.236813>, <0.064387, 0.069524, 0.238298>, <0.059650, -0.023031, 0.524871>, 
      <-0.261842, 0.014211, -0.439474>, <-0.070104, 0.061275, -0.210472>, <-0.002731, -0.007215, 0.307803>, <0.153734, -0.112021, 0.544351>, 
      <-0.353500, 0.000000, -0.353500>, <-0.161763, 0.047065, -0.124497>, <0.029699, -0.027425, 0.250821>, <0.186164, -0.132231, 0.487369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.186164, -0.132231, -0.219631>, <0.156038, -0.096093, -0.325112>, <0.142117, 0.055922, -0.472947>, <0.033058, 0.082645, -0.500000>, 
      <0.047285, -0.017335, -0.090556>, <0.017160, 0.018804, -0.196037>, <0.137277, 0.126293, -0.180137>, <0.028218, 0.153015, -0.207190>, 
      <-0.181358, 0.126739, 0.117926>, <-0.095686, 0.126739, 0.203599>, <-0.100602, 0.133227, 0.169506>, <0.004737, 0.092555, 0.213427>, 
      <-0.327545, 0.066116, 0.273179>, <-0.241873, 0.066116, 0.358851>, <-0.105339, 0.040672, 0.456079>, <0.000000, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202693, -0.372559, -0.219631>, <0.153121, -0.352855, -0.314086>, <0.123723, -0.253773, -0.490200>, <0.016529, -0.240328, -0.500000>, 
      <0.250347, -0.352797, -0.270241>, <0.200775, -0.333093, -0.364696>, <0.125249, -0.223959, -0.582511>, <0.018055, -0.210514, -0.592311>, 
      <0.231436, -0.169686, -0.261707>, <0.201310, -0.133547, -0.367188>, <0.143676, 0.033255, -0.567267>, <0.034617, 0.059977, -0.594320>, 
      <0.186164, -0.132231, -0.219631>, <0.156038, -0.096093, -0.325112>, <0.142117, 0.055922, -0.472947>, <0.033058, 0.082645, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, -0.356030, 0.353500>, <-0.434405, -0.289096, 0.428694>, <-0.412707, 0.030799, 0.363622>, <-0.327545, 0.066116, 0.273179>, 
      <-0.265581, -0.356030, 0.441419>, <-0.346486, -0.289096, 0.516613>, <-0.327035, 0.030799, 0.449294>, <-0.241873, 0.066116, 0.358851>, 
      <-0.104304, -0.236737, 0.470917>, <-0.105466, -0.219852, 0.541176>, <-0.106475, 0.018464, 0.524842>, <-0.105339, 0.040672, 0.456079>, 
      <0.016529, -0.240328, 0.500000>, <0.015368, -0.223443, 0.570259>, <-0.001137, -0.022208, 0.568762>, <0.000000, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, -0.356030, 0.353500>, <-0.265581, -0.356030, 0.441419>, <-0.104304, -0.236737, 0.470917>, <0.016529, -0.240328, 0.500000>, 
      <-0.203378, -0.480229, 0.213975>, <-0.115459, -0.480229, 0.301893>, <-0.099484, -0.306830, 0.179260>, <0.021350, -0.310421, 0.208343>, 
      <0.044671, -0.438091, -0.051810>, <-0.004900, -0.418387, -0.146265>, <0.119005, -0.345963, -0.204755>, <0.011811, -0.332519, -0.214555>, 
      <0.202693, -0.372559, -0.219631>, <0.153121, -0.352855, -0.314086>, <0.123723, -0.253773, -0.490200>, <0.016529, -0.240328, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.483471, -0.240328, 0.000000>, <-0.464647, -0.252443, 0.116063>, <-0.437082, -0.356030, 0.269918>, <-0.353500, -0.356030, 0.353500>, 
      <-0.251356, -0.342162, 0.036591>, <-0.232533, -0.354277, 0.152654>, <-0.286959, -0.480229, 0.130393>, <-0.203378, -0.480229, 0.213975>, 
      <0.100163, -0.411256, 0.088343>, <0.100163, -0.411256, -0.026454>, <0.097130, -0.458943, 0.048147>, <0.044671, -0.438091, -0.051810>, 
      <0.349193, -0.372559, 0.133869>, <0.349193, -0.372559, 0.019072>, <0.255152, -0.393411, -0.119674>, <0.202693, -0.372559, -0.219631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.483471, -0.240328, 0.000000>, <-0.251356, -0.342162, 0.036591>, <0.100163, -0.411256, 0.088343>, <0.349193, -0.372559, 0.133869>, 
      <-0.497113, -0.231548, -0.084110>, <-0.264998, -0.333382, -0.047519>, <0.100163, -0.411256, 0.203139>, <0.349193, -0.372559, 0.248665>, 
      <-0.516796, -0.289915, -0.219301>, <-0.359266, -0.395434, 0.018857>, <0.084229, -0.449589, 0.174725>, <0.277272, -0.402204, 0.405287>, 
      <-0.456225, -0.289915, -0.279872>, <-0.298695, -0.395434, -0.041714>, <0.009650, -0.419944, 0.256807>, <0.202693, -0.372559, 0.487369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.212182, -0.132231, 0.127175>, <0.287424, -0.165242, 0.139037>, <0.429918, -0.360016, 0.148626>, <0.349193, -0.372559, 0.133869>, 
      <0.212182, -0.132231, 0.022841>, <0.287424, -0.165242, 0.034702>, <0.429918, -0.360016, 0.033830>, <0.349193, -0.372559, 0.019072>, 
      <0.213378, -0.164877, -0.124346>, <0.258650, -0.202331, -0.166422>, <0.302806, -0.373649, -0.170283>, <0.255152, -0.393411, -0.119674>, 
      <0.186164, -0.132231, -0.219631>, <0.231436, -0.169686, -0.261707>, <0.250347, -0.352797, -0.270241>, <0.202693, -0.372559, -0.219631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.212182, -0.132231, 0.127175>, <0.212182, -0.132231, 0.235515>, <0.237374, -0.164145, 0.397388>, <0.186164, -0.132231, 0.487369>, 
      <0.287424, -0.165242, 0.139037>, <0.287424, -0.165242, 0.247376>, <0.274772, -0.189196, 0.453927>, <0.223562, -0.157282, 0.543908>, 
      <0.429918, -0.360016, 0.148626>, <0.429918, -0.360016, 0.263423>, <0.323100, -0.390955, 0.460023>, <0.248521, -0.361310, 0.542104>, 
      <0.349193, -0.372559, 0.133869>, <0.349193, -0.372559, 0.248665>, <0.277272, -0.402204, 0.405287>, <0.202693, -0.372559, 0.487369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.495929, 0.010371, 0.098297>, <-0.397497, 0.066116, 0.203227>, <-0.327545, 0.066116, 0.273179>, 
      <-0.570274, -0.010920, -0.012847>, <-0.566203, -0.000549, 0.085450>, <-0.482659, 0.030799, 0.293671>, <-0.412707, 0.030799, 0.363622>, 
      <-0.548972, -0.211591, -0.010326>, <-0.530148, -0.223707, 0.105737>, <-0.517987, -0.289096, 0.345112>, <-0.434405, -0.289096, 0.428694>, 
      <-0.483471, -0.240328, 0.000000>, <-0.464647, -0.252443, 0.116063>, <-0.437082, -0.356030, 0.269918>, <-0.353500, -0.356030, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.285459, 0.033337, 0.039221>, <0.012214, -0.044501, 0.095652>, <0.212182, -0.132231, 0.127175>, 
      <-0.495929, 0.010371, 0.098297>, <-0.281388, 0.043708, 0.137518>, <0.012214, -0.044501, -0.008682>, <0.212182, -0.132231, 0.022841>, 
      <-0.397497, 0.066116, 0.203227>, <-0.251310, 0.126739, 0.047975>, <0.074499, -0.049980, 0.004730>, <0.213378, -0.164877, -0.124346>, 
      <-0.327545, 0.066116, 0.273179>, <-0.181358, 0.126739, 0.117926>, <0.047285, -0.017335, -0.090556>, <0.186164, -0.132231, -0.219631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.570274, -0.010920, -0.012847>, <-0.548972, -0.211591, -0.010326>, <-0.483471, -0.240328, 0.000000>, 
      <-0.504724, -0.012034, -0.114066>, <-0.574998, -0.022954, -0.126913>, <-0.562613, -0.202811, -0.094436>, <-0.497113, -0.231548, -0.084110>, 
      <-0.436698, -0.012899, -0.275462>, <-0.496865, -0.027668, -0.347323>, <-0.565894, -0.257027, -0.293530>, <-0.516796, -0.289915, -0.219301>, 
      <-0.353500, 0.000000, -0.353500>, <-0.413667, -0.014769, -0.425361>, <-0.505324, -0.257027, -0.354101>, <-0.456225, -0.289915, -0.279872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.504724, -0.012034, -0.114066>, <-0.436698, -0.012899, -0.275462>, <-0.353500, 0.000000, -0.353500>, 
      <-0.285459, 0.033337, 0.039221>, <-0.290183, 0.021303, -0.074845>, <-0.244961, 0.034166, -0.046459>, <-0.161763, 0.047065, -0.124497>, 
      <0.012214, -0.044501, 0.095652>, <0.012214, -0.044501, 0.203991>, <0.080909, -0.059339, 0.160840>, <0.029699, -0.027425, 0.250821>, 
      <0.212182, -0.132231, 0.127175>, <0.212182, -0.132231, 0.235515>, <0.237374, -0.164145, 0.397388>, <0.186164, -0.132231, 0.487369>
    }
  }
  material {
    GraniteRock
  }
  scale 7.164356
  rotate <-5.72267, 0.0, 78.565605>
  translate  <332.397218, -20.955405, -0.97649>
}
#declare Rock2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016529, -0.240328, -0.500000>, <-0.138765, -0.220850, -0.514198>, <-0.250790, -0.301704, -0.396890>, <-0.361914, -0.431382, -0.315239>, 
      <0.011811, -0.462197, -0.244028>, <-0.143483, -0.442719, -0.258225>, <-0.187571, -0.525112, -0.182310>, <-0.298695, -0.525112, -0.071186>, 
      <0.021350, -0.310421, 0.208343>, <0.088026, -0.312403, 0.224391>, <-0.034922, -0.402227, 0.305864>, <0.009650, -0.419944, 0.256807>, 
      <0.016529, -0.293378, 0.370322>, <0.083205, -0.295360, 0.386370>, <0.158120, -0.407892, 0.406747>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.053050, 0.370322>, <-0.001137, -0.075259, 0.439084>, <0.015368, -0.276493, 0.440581>, <0.016529, -0.293378, 0.370322>, 
      <0.059650, -0.076082, 0.395193>, <0.058514, -0.098290, 0.463955>, <0.082044, -0.278474, 0.456629>, <0.083205, -0.295360, 0.386370>, 
      <0.153734, -0.165071, 0.414673>, <0.143980, -0.190122, 0.471212>, <0.133215, -0.396643, 0.390749>, <0.158120, -0.407892, 0.406747>, 
      <0.139012, -0.185282, 0.357691>, <0.105676, -0.210332, 0.343496>, <0.177788, -0.414360, 0.341693>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033058, 0.082645, -0.500000>, <0.034617, 0.059977, -0.594320>, <0.018055, -0.210514, -0.592311>, <0.016529, -0.240328, -0.500000>, 
      <-0.086362, 0.111905, -0.529623>, <-0.084803, 0.089238, -0.623944>, <-0.137239, -0.191036, -0.606509>, <-0.138765, -0.220850, -0.514198>, 
      <-0.261842, 0.014211, -0.439474>, <-0.227697, -0.012347, -0.517229>, <-0.299888, -0.268816, -0.471119>, <-0.250790, -0.301704, -0.396890>, 
      <-0.259189, -0.011789, -0.359394>, <-0.319356, -0.026558, -0.431255>, <-0.411012, -0.398494, -0.389467>, <-0.361914, -0.431382, -0.315239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033058, 0.082645, -0.500000>, <0.028218, 0.153015, -0.207190>, <0.004737, 0.021822, 0.183955>, <0.000000, -0.053050, 0.370322>, 
      <-0.086362, 0.111905, -0.529623>, <-0.091202, 0.182276, -0.236813>, <0.064387, 0.010579, 0.208826>, <0.059650, -0.076082, 0.395193>, 
      <-0.261842, 0.014211, -0.439474>, <-0.070104, 0.061275, -0.210472>, <-0.002731, -0.036687, 0.290120>, <0.153734, -0.165071, 0.414673>, 
      <-0.259189, -0.011789, -0.359394>, <-0.161763, 0.047065, -0.124497>, <0.029699, -0.027425, 0.250821>, <0.139012, -0.185282, 0.357691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.139012, -0.132231, -0.219631>, <0.156038, -0.096093, -0.325112>, <0.142117, 0.055922, -0.472947>, <0.033058, 0.082645, -0.500000>, 
      <0.047285, -0.017335, -0.090556>, <0.017160, 0.018804, -0.196037>, <0.137277, 0.126293, -0.180137>, <0.028218, 0.153015, -0.207190>, 
      <-0.181358, 0.061900, 0.082560>, <-0.095686, 0.067795, 0.174126>, <-0.100602, 0.074283, 0.134139>, <0.004737, 0.021822, 0.183955>, 
      <-0.327545, 0.042538, 0.243706>, <-0.241873, 0.013066, 0.229173>, <-0.105339, -0.012378, 0.326401>, <0.000000, -0.053050, 0.370322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202693, -0.502237, -0.249103>, <0.153121, -0.482533, -0.343559>, <0.123723, -0.253773, -0.490200>, <0.016529, -0.240328, -0.500000>, 
      <0.250347, -0.482475, -0.299713>, <0.200775, -0.462771, -0.394168>, <0.125249, -0.223959, -0.582511>, <0.018055, -0.210514, -0.592311>, 
      <0.184284, -0.169686, -0.261707>, <0.154158, -0.133547, -0.367188>, <0.143676, 0.033255, -0.567267>, <0.034617, 0.059977, -0.594320>, 
      <0.139012, -0.132231, -0.219631>, <0.156038, -0.096093, -0.325112>, <0.142117, 0.055922, -0.472947>, <0.033058, 0.082645, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, -0.409081, 0.223822>, <-0.434405, -0.342146, 0.299016>, <-0.412707, -0.022251, 0.233944>, <-0.327545, 0.042538, 0.243706>, 
      <-0.265581, -0.409081, 0.311741>, <-0.346486, -0.342146, 0.386935>, <-0.327035, -0.022251, 0.319616>, <-0.241873, 0.013066, 0.229173>, 
      <-0.104304, -0.289787, 0.341239>, <-0.105466, -0.272902, 0.411498>, <-0.106475, -0.034586, 0.395164>, <-0.105339, -0.012378, 0.326401>, 
      <0.016529, -0.293378, 0.370322>, <0.015368, -0.276493, 0.440581>, <-0.001137, -0.075259, 0.439084>, <0.000000, -0.053050, 0.370322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, -0.409081, 0.223822>, <-0.265581, -0.409081, 0.311741>, <-0.104304, -0.289787, 0.341239>, <0.016529, -0.293378, 0.370322>, 
      <-0.203378, -0.480229, 0.213975>, <-0.115459, -0.480229, 0.301893>, <-0.099484, -0.306830, 0.179260>, <0.021350, -0.310421, 0.208343>, 
      <0.044671, -0.567769, -0.081282>, <-0.004900, -0.548065, -0.175737>, <0.119005, -0.475642, -0.234228>, <0.011811, -0.462197, -0.244028>, 
      <0.202693, -0.502237, -0.249103>, <0.153121, -0.482533, -0.343559>, <0.123723, -0.253773, -0.490200>, <0.016529, -0.240328, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389160, -0.252117, -0.005894>, <-0.370336, -0.393910, 0.080696>, <-0.437082, -0.356030, 0.269918>, <-0.353500, -0.409081, 0.223822>, 
      <-0.251356, -0.471840, 0.007119>, <-0.232533, -0.483955, 0.123182>, <-0.286959, -0.609907, 0.100921>, <-0.203378, -0.480229, 0.213975>, 
      <0.100163, -0.540934, 0.058870>, <0.100163, -0.540934, -0.055926>, <0.097130, -0.588621, 0.018675>, <0.044671, -0.567769, -0.081282>, 
      <0.142449, -0.473221, 0.104397>, <0.095297, -0.455085, -0.010400>, <0.091933, -0.483192, -0.149146>, <0.202693, -0.502237, -0.249103>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389160, -0.252117, -0.005894>, <-0.251356, -0.471840, 0.007119>, <0.100163, -0.540934, 0.058870>, <0.142449, -0.473221, 0.104397>, 
      <-0.402801, -0.243337, -0.090004>, <-0.264998, -0.463060, -0.076991>, <0.100163, -0.411256, 0.203139>, <0.102551, -0.339916, 0.248665>, 
      <-0.422485, -0.431382, -0.254668>, <-0.264955, -0.536901, -0.016510>, <0.084229, -0.579267, 0.145253>, <0.135815, -0.404475, 0.275609>, 
      <-0.361914, -0.431382, -0.315239>, <-0.298695, -0.525112, -0.071186>, <0.009650, -0.419944, 0.256807>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.165030, -0.132231, 0.127175>, <0.240272, -0.165242, 0.139037>, <0.103480, -0.438914, 0.119154>, <0.142449, -0.473221, 0.104397>, 
      <0.165030, -0.132231, 0.022841>, <0.240272, -0.165242, 0.034702>, <0.038193, -0.467931, 0.004358>, <0.095297, -0.455085, -0.010400>, 
      <0.166226, -0.164877, -0.124346>, <0.211498, -0.202331, -0.166422>, <0.168604, -0.496073, -0.199756>, <0.091933, -0.483192, -0.149146>, 
      <0.139012, -0.132231, -0.219631>, <0.184284, -0.169686, -0.261707>, <0.250347, -0.482475, -0.299713>, <0.202693, -0.502237, -0.249103>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.165030, -0.132231, 0.127175>, <0.165030, -0.132231, 0.235515>, <0.190222, -0.217195, 0.267710>, <0.139012, -0.185282, 0.357691>, 
      <0.240272, -0.165242, 0.139037>, <0.240272, -0.165242, 0.247376>, <0.156886, -0.242246, 0.253515>, <0.105676, -0.210332, 0.343496>, 
      <0.103480, -0.438914, 0.119154>, <0.150632, -0.309236, 0.263423>, <0.134492, -0.375090, 0.330345>, <0.177788, -0.414360, 0.341693>, 
      <0.142449, -0.473221, 0.104397>, <0.102551, -0.339916, 0.248665>, <0.135815, -0.404475, 0.275609>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.495929, 0.010371, 0.098297>, <-0.397497, 0.066116, 0.203227>, <-0.327545, 0.042538, 0.243706>, 
      <-0.475963, -0.022709, -0.018742>, <-0.471892, -0.012338, 0.079556>, <-0.482659, -0.010462, 0.281882>, <-0.412707, -0.022251, 0.233944>, 
      <-0.454661, -0.223380, -0.016220>, <-0.530148, -0.223707, 0.105737>, <-0.517987, -0.342146, 0.215434>, <-0.434405, -0.342146, 0.299016>, 
      <-0.389160, -0.252117, -0.005894>, <-0.370336, -0.393910, 0.080696>, <-0.437082, -0.356030, 0.269918>, <-0.353500, -0.409081, 0.223822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.285459, 0.033337, 0.039221>, <0.012214, -0.044501, 0.095652>, <0.165030, -0.132231, 0.127175>, 
      <-0.495929, 0.010371, 0.098297>, <-0.281388, 0.043708, 0.137518>, <0.012214, -0.044501, -0.008682>, <0.165030, -0.132231, 0.022841>, 
      <-0.397497, 0.066116, 0.203227>, <-0.251310, 0.050111, 0.071553>, <0.074499, -0.049980, 0.004730>, <0.166226, -0.164877, -0.124346>, 
      <-0.327545, 0.042538, 0.243706>, <-0.181358, 0.061900, 0.082560>, <0.047285, -0.017335, -0.090556>, <0.139012, -0.132231, -0.219631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.475963, -0.022709, -0.018742>, <-0.454661, -0.223380, -0.016220>, <-0.389160, -0.252117, -0.005894>, 
      <-0.410413, -0.023823, -0.119961>, <-0.480687, -0.034743, -0.132808>, <-0.468302, -0.214600, -0.100330>, <-0.402801, -0.243337, -0.090004>, 
      <-0.342386, -0.024688, -0.281356>, <-0.402553, -0.039457, -0.353217>, <-0.471583, -0.398494, -0.328897>, <-0.422485, -0.431382, -0.254668>, 
      <-0.259189, -0.011789, -0.359394>, <-0.319356, -0.026558, -0.431255>, <-0.411012, -0.398494, -0.389467>, <-0.361914, -0.431382, -0.315239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.410413, -0.023823, -0.119961>, <-0.342386, -0.024688, -0.281356>, <-0.259189, -0.011789, -0.359394>, 
      <-0.285459, 0.033337, 0.039221>, <-0.290183, 0.021303, -0.074845>, <-0.244961, 0.034166, -0.046459>, <-0.161763, 0.047065, -0.124497>, 
      <0.012214, -0.044501, 0.095652>, <0.012214, -0.044501, 0.203991>, <0.080909, -0.059339, 0.160840>, <0.029699, -0.027425, 0.250821>, 
      <0.165030, -0.132231, 0.127175>, <0.165030, -0.132231, 0.235515>, <0.190222, -0.217195, 0.267710>, <0.139012, -0.185282, 0.357691>
    }
  }
  material {
    GraniteRock
    scale 0.5
  }
  scale 14.196776
  rotate <90.0, -0.0, 75.374504>
  translate  <340.539564, -13.840045, 5.436931>
}
#declare Rock3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.612360, -0.820225, -0.270137>, <0.329780, -0.980545, -0.500000>, <0.314509, -0.410873, -0.444409>, 
      <0.612360, -0.820225, 0.270137>, <0.612360, -0.820225, 0.000000>, <0.472952, -0.751469, -0.500000>, <0.255532, -0.591149, -0.500000>, 
      <0.329780, -0.849148, 0.383764>, <0.964848, 0.144726, 0.222045>, <0.112360, -0.320225, 0.000000>, <0.112360, -0.320225, -0.270137>, 
      <0.112360, -0.678720, 0.378711>, <0.255532, -0.591149, 0.500000>, <0.112360, -0.072592, 0.598629>, <0.112360, -0.320225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.612360, -0.820225, -0.270137>, <0.329780, -0.980545, -0.500000>, <0.314509, -0.410873, -0.444409>, 
      <0.612360, -0.820225, 0.270137>, <0.612360, -0.820225, 0.000000>, <0.207425, -1.176312, -0.500000>, <-0.009995, -1.015992, -0.500000>, 
      <0.329780, -0.849148, 0.383764>, <0.207425, -1.176312, 0.500000>, <0.000000, -0.500000, 0.000000>, <0.000000, -0.500000, -0.230858>, 
      <0.112360, -0.678720, 0.378711>, <-0.009995, -0.970508, 0.429248>, <0.000000, -0.500000, 0.230858>, <0.000000, -0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.612360, -0.820225, 0.270137>, <0.329780, -0.849148, 0.383764>, <0.112360, -0.678720, 0.378711>, 
      <0.612360, -0.820225, 0.000000>, <0.014237, -0.587573, 0.113471>, <0.207425, -1.176312, 0.500000>, <-0.009995, -0.970508, 0.429248>, 
      <0.612360, -0.820225, 0.000000>, <0.014237, -0.587573, 0.113471>, <0.212478, -0.656676, 0.230858>, <0.000000, -0.500000, 0.230858>, 
      <0.612360, -0.820225, 0.000000>, <0.472442, -1.044093, 0.000000>, <0.212478, -0.656676, 0.000000>, <0.000000, -0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.612360, -0.820225, -0.270137>, <0.329780, -0.980545, -0.500000>, <0.314509, -0.410873, -0.444409>, 
      <0.612360, -0.820225, 0.000000>, <0.472442, -1.044093, -0.270137>, <0.207425, -1.176312, -0.500000>, <-0.009995, -1.015992, -0.500000>, 
      <0.612360, -0.820225, 0.000000>, <0.472442, -1.044093, -0.270137>, <0.212478, -0.656676, -0.230858>, <0.000000, -0.500000, -0.230858>, 
      <0.612360, -0.820225, 0.000000>, <0.472442, -1.044093, 0.000000>, <0.212478, -0.656676, 0.000000>, <0.000000, -0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.612360, -0.820225, -0.270137>, <0.329780, -0.980545, -0.500000>, <0.314509, -0.410873, -0.444409>, 
      <0.612360, -0.820225, 0.000000>, <0.755532, -0.591149, -0.270137>, <0.472952, -0.751469, -0.500000>, <0.255532, -0.591149, -0.500000>, 
      <0.612360, -0.820225, 0.000000>, <0.755532, -0.591149, -0.270137>, <0.329780, -0.480544, -0.270137>, <0.112360, -0.320225, -0.270137>, 
      <0.612360, -0.820225, 0.000000>, <0.755532, -0.591149, 0.000000>, <0.329780, -0.480544, 0.000000>, <0.112360, -0.320225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.755532, -0.591149, 0.000000>, <0.329780, -0.480544, 0.000000>, <0.112360, -0.320225, 0.000000>, 
      <0.472442, -1.044093, 0.000000>, <0.615614, -0.815018, 0.000000>, <0.329780, -0.480544, -0.270137>, <0.112360, -0.320225, -0.270137>, 
      <0.212478, -0.656676, 0.000000>, <0.212478, -0.656676, -0.230858>, <0.133177, -0.786917, -0.500000>, <0.255532, -0.591149, -0.500000>, 
      <0.000000, -0.500000, 0.000000>, <0.000000, -0.500000, -0.230858>, <-0.009995, -1.015992, -0.500000>, <0.314509, -0.410873, -0.444409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.612360, -0.820225, 0.270137>, <0.329780, -0.849148, 0.383764>, <0.112360, -0.678720, 0.378711>, 
      <0.612360, -0.820225, 0.000000>, <0.755532, -0.591149, 0.270137>, <0.964848, 0.144726, 0.222045>, <0.255532, -0.591149, 0.500000>, 
      <0.612360, -0.820225, 0.000000>, <0.755532, -0.591149, 0.270137>, <0.329780, -0.480544, 0.270137>, <0.112360, -0.072592, 0.598629>, 
      <0.612360, -0.820225, 0.000000>, <0.755532, -0.591149, 0.000000>, <0.329780, -0.480544, 0.000000>, <0.112360, -0.320225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612360, -0.820225, 0.000000>, <0.472442, -1.044093, 0.000000>, <0.212478, -0.656676, 0.000000>, <0.000000, -0.500000, 0.000000>, 
      <0.755532, -0.591149, 0.000000>, <0.615614, -0.815018, 0.000000>, <0.212478, -0.656676, 0.230858>, <0.000000, -0.500000, 0.230858>, 
      <0.329780, -0.480544, 0.000000>, <0.329780, -0.480544, 0.270137>, <0.133177, -0.786917, 0.500000>, <-0.009995, -0.970508, 0.429248>, 
      <0.112360, -0.320225, 0.000000>, <0.112360, -0.072592, 0.598629>, <0.255532, -0.591149, 0.500000>, <0.112360, -0.678720, 0.378711>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.435206>, <-0.237916, -0.561940, 0.500000>, <0.112360, -0.678720, 0.378711>, 
      <-0.500000, 0.000000, -0.435206>, <-0.500000, 0.000000, 0.000000>, <-0.360271, -0.590935, 0.363549>, <-0.009995, -0.970508, 0.429248>, 
      <-0.237916, -0.561940, -0.500000>, <-0.360271, -0.757708, -0.500000>, <0.000000, -0.500000, 0.000000>, <0.000000, -0.500000, 0.230858>, 
      <0.314509, -0.410873, -0.444409>, <-0.009995, -1.015992, -0.500000>, <0.000000, -0.500000, -0.230858>, <0.000000, -0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.435206>, <-0.237916, -0.561940, 0.500000>, <0.112360, -0.678720, 0.378711>, 
      <-0.500000, 0.000000, -0.435206>, <-0.500000, 0.000000, 0.000000>, <-0.094744, -0.332865, 0.500000>, <0.255532, -0.591149, 0.500000>, 
      <-0.237916, -0.561940, -0.500000>, <0.585825, -0.157669, -0.500000>, <0.112360, -0.320225, 0.000000>, <0.112360, -0.072592, 0.598629>, 
      <0.314509, -0.410873, -0.444409>, <0.255532, -0.591149, -0.500000>, <0.112360, -0.320225, -0.270137>, <0.112360, -0.320225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, -0.435206>, <-0.237916, -0.561940, -0.500000>, <0.314509, -0.410873, -0.444409>, 
      <-0.360082, 0.223869, 0.000000>, <-0.360082, 0.223869, -0.435206>, <-0.020496, -0.722260, -0.500000>, <0.329780, -0.980545, -0.500000>, 
      <-0.100118, -0.163549, 0.000000>, <0.683319, 0.215196, 0.000000>, <0.755532, -0.591149, -0.270137>, <0.612360, -0.820225, -0.270137>, 
      <0.112360, -0.320225, 0.000000>, <0.329780, -0.480544, 0.000000>, <0.755532, -0.591149, 0.000000>, <0.612360, -0.820225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, 0.000000>, <-0.100118, -0.163549, 0.000000>, <0.112360, -0.320225, 0.000000>, 
      <-0.500000, 0.000000, 0.435206>, <-0.360082, 0.223869, 0.435206>, <0.683319, 0.215196, 0.000000>, <0.329780, -0.480544, 0.000000>, 
      <-0.237916, -0.561940, 0.500000>, <-0.020496, -0.722260, 0.500000>, <0.755532, -0.591149, 0.270137>, <0.755532, -0.591149, 0.000000>, 
      <0.112360, -0.678720, 0.378711>, <0.329780, -0.849148, 0.383764>, <0.612360, -0.820225, 0.270137>, <0.612360, -0.820225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, 0.000000>, <-0.100118, -0.163549, 0.000000>, <0.112360, -0.320225, 0.000000>, 
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, -0.435206>, <0.324395, 0.159890, -0.270137>, <0.112360, -0.320225, -0.270137>, 
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, -0.435206>, <0.585825, -0.157669, -0.500000>, <0.255532, -0.591149, -0.500000>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, -0.435206>, <-0.237916, -0.561940, -0.500000>, <0.314509, -0.410873, -0.444409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.435206>, <-0.237916, -0.561940, 0.500000>, <0.112360, -0.678720, 0.378711>, 
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, 0.435206>, <-0.094744, -0.332865, 0.500000>, <0.255532, -0.591149, 0.500000>, 
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, 0.435206>, <-0.100118, -0.315161, 0.128632>, <0.112360, -0.072592, 0.598629>, 
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, 0.000000>, <-0.100118, -0.163549, 0.000000>, <0.112360, -0.320225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, -0.435206>, <-0.237916, -0.561940, -0.500000>, <0.314509, -0.410873, -0.444409>, 
      <-0.643172, -0.229075, 0.000000>, <-0.643172, -0.188646, -0.612086>, <-0.020496, -0.722260, -0.500000>, <0.329780, -0.980545, -0.500000>, 
      <-0.217420, -0.339680, 0.000000>, <-0.004942, -0.496356, 0.000000>, <0.472442, -1.044093, -0.270137>, <0.612360, -0.820225, -0.270137>, 
      <0.000000, -0.500000, 0.000000>, <0.212478, -0.656676, 0.000000>, <0.472442, -1.044093, 0.000000>, <0.612360, -0.820225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.435206>, <-0.237916, -0.561940, 0.500000>, <0.112360, -0.678720, 0.378711>, 
      <-0.643172, -0.229075, 0.000000>, <-0.643172, -0.229075, 0.435206>, <-0.020496, -0.722260, 0.500000>, <0.329780, -0.849148, 0.383764>, 
      <-0.217420, -0.339680, 0.000000>, <-0.004942, -0.496356, 0.000000>, <0.014237, -0.587573, 0.113471>, <0.612360, -0.820225, 0.270137>, 
      <0.000000, -0.500000, 0.000000>, <0.212478, -0.656676, 0.000000>, <0.472442, -1.044093, 0.000000>, <0.612360, -0.820225, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.435206>, <-0.237916, -0.561940, 0.500000>, <0.112360, -0.678720, 0.378711>, 
      <-0.500000, 0.000000, 0.000000>, <-0.643172, -0.229075, 0.435206>, <-0.360271, -0.590935, 0.363549>, <-0.009995, -0.970508, 0.429248>, 
      <-0.500000, 0.000000, 0.000000>, <-0.643172, -0.229075, 0.435206>, <-0.217420, -0.339680, 0.230858>, <0.000000, -0.500000, 0.230858>, 
      <-0.500000, 0.000000, 0.000000>, <-0.643172, -0.229075, 0.000000>, <-0.217420, -0.339680, 0.000000>, <0.000000, -0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.360082, 0.223869, 0.000000>, <-0.100118, -0.163549, 0.000000>, <0.112360, -0.320225, 0.000000>, 
      <-0.643172, -0.229075, 0.000000>, <-0.503254, 0.298017, -0.298170>, <-0.100118, -0.315161, 0.128632>, <0.112360, -0.072592, 0.598629>, 
      <-0.217420, -0.339680, 0.000000>, <-0.217420, -0.339680, 0.230858>, <0.133177, -0.786917, 0.500000>, <0.255532, -0.591149, 0.500000>, 
      <0.000000, -0.500000, 0.000000>, <0.000000, -0.500000, 0.230858>, <-0.009995, -0.970508, 0.429248>, <0.112360, -0.678720, 0.378711>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, -0.435206>, <-0.237916, -0.561940, -0.500000>, <0.314509, -0.410873, -0.444409>, 
      <-0.500000, 0.000000, 0.000000>, <-0.643172, -0.188646, -0.612086>, <-0.360271, -0.757708, -0.500000>, <-0.009995, -1.015992, -0.500000>, 
      <-0.500000, 0.000000, 0.000000>, <-0.643172, -0.188646, -0.612086>, <-0.217420, -0.339680, -0.230858>, <0.000000, -0.500000, -0.230858>, 
      <-0.500000, 0.000000, 0.000000>, <-0.643172, -0.229075, 0.000000>, <-0.217420, -0.339680, 0.000000>, <0.000000, -0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.643172, -0.229075, 0.000000>, <-0.217420, -0.339680, 0.000000>, <0.000000, -0.500000, 0.000000>, 
      <-0.360082, 0.223869, 0.000000>, <-0.503254, 0.298017, -0.298170>, <-0.217420, -0.339680, -0.230858>, <0.000000, -0.500000, -0.230858>, 
      <-0.100118, -0.163549, 0.000000>, <0.324395, 0.159890, -0.270137>, <0.133177, -0.786917, -0.500000>, <-0.009995, -1.015992, -0.500000>, 
      <0.112360, -0.320225, 0.000000>, <0.112360, -0.320225, -0.270137>, <0.255532, -0.591149, -0.500000>, <0.314509, -0.410873, -0.444409>
    }
  }
  material {
    GraniteRock
  }
  scale -6.323027
  rotate <90.819702, -38.950623, -0.515289>
  translate  <341.247685, -23.808443, -0.883465>
}
#declare Rock5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    SlateRock
  }
  scale 5.0
  translate  <349.878922, -9.05083, 0.0>
}
#declare Rock6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.411314, 0.620571, -0.070899>, <-0.623359, 0.593444, -0.020866>, <-1.048231, 0.676489, 0.293614>, <-0.980281, 0.405659, 0.336125>, 
      <-0.169333, 0.651528, -0.127995>, <-0.381377, 0.624401, -0.077963>, <-0.848278, 0.681865, 0.809077>, <-0.780328, 0.411034, 0.851588>, 
      <0.341992, 0.893806, -0.042679>, <0.613580, 0.923115, 0.044586>, <0.508168, 0.561147, 0.957626>, <0.231206, 0.525715, 1.022976>, 
      <0.419535, 0.584739, 0.005834>, <0.691123, 0.614049, 0.093098>, <1.042179, 0.629464, 0.831624>, <0.765217, 0.594032, 0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.411314, 0.620571, -0.070899>, <-0.623359, 0.593444, -0.020866>, <-1.048231, 0.676489, 0.293614>, <-0.980281, 0.405659, 0.336125>, 
      <-0.411314, 0.620571, -0.070899>, <-0.381377, 0.624401, -0.077963>, <-1.205473, 0.672262, -0.111744>, <-1.137523, 0.401432, -0.069233>, 
      <-0.411314, 0.620571, -0.070899>, <-0.381377, 0.624401, -0.077963>, <-0.069804, 0.849365, -0.174994>, <0.007739, 0.540298, -0.126481>, 
      <-0.411314, 0.620571, -0.070899>, <-0.169333, 0.651528, -0.127995>, <0.341992, 0.893806, -0.042679>, <0.419535, 0.584739, 0.005834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.411314, 0.620571, -0.070899>, <-0.183616, 0.706245, 0.040719>, <0.141003, 0.910814, 0.131139>, <0.347680, 0.906152, 0.301162>, 
      <-0.623359, 0.593444, -0.020866>, <-0.395661, 0.679118, 0.090752>, <0.324389, 0.906677, 0.282002>, <0.531067, 0.902015, 0.452025>, 
      <-1.048231, 0.676489, 0.293614>, <-0.848278, 0.681865, 0.809077>, <0.183166, 0.741186, 0.935385>, <0.717178, 0.809502, 0.809384>, 
      <-0.980281, 0.405659, 0.336125>, <-0.780328, 0.411034, 0.851588>, <0.231206, 0.525715, 1.022976>, <0.765217, 0.594032, 0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.411314, 0.620571, -0.070899>, <-0.169333, 0.651528, -0.127995>, <0.341992, 0.893806, -0.042679>, <0.419535, 0.584739, 0.005834>, 
      <-0.183616, 0.706245, 0.040719>, <0.058366, 0.737202, -0.016377>, <0.613580, 0.923115, 0.044586>, <0.691123, 0.614049, 0.093098>, 
      <0.141003, 0.910814, 0.131139>, <0.324389, 0.906677, 0.282002>, <0.994140, 0.844935, 0.744034>, <1.042179, 0.629464, 0.831624>, 
      <0.347680, 0.906152, 0.301162>, <0.531067, 0.902015, 0.452025>, <0.717178, 0.809502, 0.809384>, <0.765217, 0.594032, 0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.158867, -0.321765, 0.007207>, <0.523161, 0.171715, 0.070664>, <0.419535, 0.584739, 0.005834>, 
      <-0.164507, -0.363135, 0.083508>, <-0.174068, -0.364358, 0.085764>, <0.111365, 0.127274, -0.061651>, <0.007739, 0.540298, -0.126481>, 
      <-0.164507, -0.363135, 0.083508>, <-0.174068, -0.364358, 0.085764>, <-1.030834, -0.023804, -0.002486>, <-1.137523, 0.401432, -0.069233>, 
      <-0.164507, -0.363135, 0.083508>, <-0.497442, -0.405728, 0.162065>, <-0.873591, -0.019577, 0.402872>, <-0.980281, 0.405659, 0.336125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.158867, -0.321765, 0.007207>, <0.523161, 0.171715, 0.070664>, <0.419535, 0.584739, 0.005834>, 
      <-0.497442, -0.405728, 0.162065>, <-0.174068, -0.364358, 0.085764>, <0.794749, 0.201024, 0.157929>, <0.691123, 0.614049, 0.093098>, 
      <-0.873591, -0.019577, 0.402872>, <-0.673638, -0.014201, 0.918335>, <0.508168, 0.561147, 0.957626>, <1.042179, 0.629464, 0.831624>, 
      <-0.980281, 0.405659, 0.336125>, <-0.780328, 0.411034, 0.851588>, <0.231206, 0.525715, 1.022976>, <0.765217, 0.594032, 0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <-0.497442, -0.405728, 0.162065>, <-0.873591, -0.019577, 0.402872>, <-0.980281, 0.405659, 0.336125>, 
      <0.059070, -0.295967, 0.276292>, <-0.273865, -0.338560, 0.354849>, <-0.673638, -0.014201, 0.918335>, <-0.780328, 0.411034, 0.851588>, 
      <0.400633, -0.324675, 0.568527>, <0.538984, -0.182241, 0.689578>, <0.278244, 0.314734, 1.108741>, <0.231206, 0.525715, 1.022976>, 
      <0.580751, -0.139241, 0.726122>, <0.719102, 0.003193, 0.847172>, <0.812256, 0.383050, 0.982740>, <0.765217, 0.594032, 0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.059070, -0.295967, 0.276292>, <0.400633, -0.324675, 0.568527>, <0.580751, -0.139241, 0.726122>, 
      <0.158867, -0.321765, 0.007207>, <0.382445, -0.254597, 0.199991>, <0.538984, -0.182241, 0.689578>, <0.719102, 0.003193, 0.847172>, 
      <0.523161, 0.171715, 0.070664>, <0.794749, 0.201024, 0.157929>, <1.089218, 0.418482, 0.917390>, <0.812256, 0.383050, 0.982740>, 
      <0.419535, 0.584739, 0.005834>, <0.691123, 0.614049, 0.093098>, <1.042179, 0.629464, 0.831624>, <0.765217, 0.594032, 0.896974>
    }
  }
  material {
    SlateRock
    scale 0.5
    translate <-1.747472, -1.894079, -0.050537>
  }
  scale 7.411125
  rotate <-163.949585, -18.132156, -132.751907>
  translate  <328.992496, -19.106475, 3.286123>
}
#declare Rock7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.440876, 0.476858, 0.930903>, <-0.201331, 0.532515, 1.075815>, <0.151910, 0.610292, 1.256260>, <0.436327, 0.632947, 1.264779>, 
      <-0.440876, 0.476858, 0.930903>, <-0.064005, 0.310599, 1.328335>, <0.334081, 0.392647, 1.289424>, <0.618498, 0.415302, 1.297943>, 
      <-0.440876, 0.476858, 0.930903>, <-0.064005, 0.310599, 1.328335>, <0.509406, -0.151936, 0.698967>, <0.844197, -0.092364, 0.826393>, 
      <-0.440876, 0.476858, 0.930903>, <-0.303550, 0.254943, 1.183423>, <0.245960, -0.198814, 0.598696>, <0.580751, -0.139241, 0.726122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.347680, 0.906152, 0.301162>, <0.134204, 0.919416, 0.126749>, <-0.262411, 0.724507, -0.115867>, <-0.485991, 0.637068, 0.020275>, 
      <0.347680, 0.906152, 0.301162>, <-0.010883, 0.862675, 0.215095>, <-0.427242, 0.660044, -0.015499>, <-0.650821, 0.572605, 0.120643>, 
      <0.347680, 0.906152, 0.301162>, <-0.010883, 0.862675, 0.215095>, <-0.092851, 0.788894, 0.428775>, <-0.257089, 0.717556, 0.432182>, 
      <0.347680, 0.906152, 0.301162>, <0.202593, 0.849411, 0.389508>, <0.028296, 0.788352, 0.592242>, <-0.135942, 0.717015, 0.595648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.858708, 0.261788, 0.005969>, <-0.160683, 0.380743, -0.072356>, <0.220358, 0.443146, 0.063418>, 
      <-1.106709, 0.274432, 0.331326>, <-0.951046, 0.549070, -0.012193>, <-0.247181, 0.649856, -0.089369>, <0.133860, 0.712259, 0.046405>, 
      <-1.106709, 0.274432, 0.331326>, <-0.951046, 0.549070, -0.012193>, <-0.500447, 0.635230, 0.023193>, <-0.271874, 0.664289, -0.022951>, 
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.858708, 0.261788, 0.005969>, <-0.160683, 0.380743, -0.072356>, <0.220358, 0.443146, 0.063418>, 
      <-1.106709, 0.274432, 0.331326>, <-1.025686, 0.270301, 0.225031>, <-0.359054, 0.390857, 0.187890>, <0.021988, 0.453260, 0.323663>, 
      <-1.106709, 0.274432, 0.331326>, <-1.025686, 0.270301, 0.225031>, <-0.795943, 0.623190, 0.563346>, <-0.564680, 0.676923, 0.703247>, 
      <-1.106709, 0.274432, 0.331326>, <-1.273687, 0.282945, 0.550388>, <-0.672139, 0.423125, 0.791002>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>, 
      <-1.273687, 0.282945, 0.550388>, <-1.366025, 0.570227, 0.532226>, <-0.500447, 0.635230, 0.023193>, <-0.271874, 0.664289, -0.022951>, 
      <-0.672139, 0.423125, 0.791002>, <-0.795943, 0.623190, 0.563346>, <-0.064510, 0.722372, 0.306650>, <0.133860, 0.712259, 0.046405>, 
      <-0.440876, 0.476858, 0.930903>, <-0.564680, 0.676923, 0.703247>, <0.021988, 0.453260, 0.323663>, <0.220358, 0.443146, 0.063418>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-1.273687, 0.282945, 0.550388>, <-0.672139, 0.423125, 0.791002>, <-0.440876, 0.476858, 0.930903>, 
      <-0.815479, 0.407207, 0.410623>, <-0.982457, 0.415720, 0.629684>, <-0.432594, 0.478782, 0.935913>, <-0.201331, 0.532515, 1.075815>, 
      <-0.438334, 0.585670, 0.601920>, <-0.280345, 0.584964, 0.815099>, <-0.017248, 0.812391, 1.225465>, <0.151910, 0.610292, 1.256260>, 
      <-0.135942, 0.717015, 0.595648>, <0.022048, 0.716309, 0.808827>, <0.267169, 0.835046, 1.233984>, <0.436327, 0.632947, 1.264779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.815479, 0.407207, 0.410623>, <-0.438334, 0.585670, 0.601920>, <-0.135942, 0.717015, 0.595648>, 
      <-1.106709, 0.274432, 0.331326>, <-0.907817, 0.694489, 0.392461>, <-0.559481, 0.586211, 0.438453>, <-0.257089, 0.717556, 0.432182>, 
      <-1.106709, 0.274432, 0.331326>, <-0.907817, 0.694489, 0.392461>, <-0.879394, 0.543546, 0.166787>, <-0.650821, 0.572605, 0.120643>, 
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.858708, 0.261788, 0.005969>, <-0.160683, 0.380743, -0.072356>, <0.220358, 0.443146, 0.063418>, 
      <-0.815479, 0.407207, 0.410623>, <-0.567478, 0.394563, 0.085266>, <-0.247181, 0.649856, -0.089369>, <0.133860, 0.712259, 0.046405>, 
      <-0.438334, 0.585670, 0.601920>, <-0.559481, 0.586211, 0.438453>, <-0.436704, 0.599827, 0.077417>, <-0.271874, 0.664289, -0.022951>, 
      <-0.135942, 0.717015, 0.595648>, <-0.257089, 0.717556, 0.432182>, <-0.650821, 0.572605, 0.120643>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>, 
      <-0.815479, 0.407207, 0.410623>, <-0.907817, 0.694489, 0.392461>, <-0.490984, 0.695447, -0.069722>, <-0.262411, 0.724507, -0.115867>, 
      <-0.438334, 0.585670, 0.601920>, <-0.274097, 0.657007, 0.598513>, <-0.010883, 0.862675, 0.215095>, <0.134204, 0.919416, 0.126749>, 
      <-0.135942, 0.717015, 0.595648>, <0.028296, 0.788352, 0.592242>, <0.202593, 0.849411, 0.389508>, <0.347680, 0.906152, 0.301162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.714734, 0.361456, 1.047013>, <0.703403, -0.002669, 0.855666>, <0.580751, -0.139241, 0.726122>, 
      <0.669290, 0.565286, 0.964155>, <0.734995, 0.379263, 1.159719>, <0.966849, 0.044208, 0.955937>, <0.844197, -0.092364, 0.826393>, 
      <0.669290, 0.565286, 0.964155>, <0.734995, 0.379263, 1.159719>, <0.733969, 0.424499, 1.301402>, <0.618498, 0.415302, 1.297943>, 
      <0.669290, 0.565286, 0.964155>, <0.689551, 0.583092, 1.076861>, <0.551798, 0.642145, 1.268238>, <0.436327, 0.632947, 1.264779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.620023, 0.786261, 0.874327>, <0.536083, 0.894446, 0.455090>, <0.347680, 0.906152, 0.301162>, 
      <0.689551, 0.583092, 1.076861>, <0.640285, 0.804068, 0.987033>, <0.390996, 0.837705, 0.543435>, <0.202593, 0.849411, 0.389508>, 
      <0.551798, 0.642145, 1.268238>, <0.382640, 0.844243, 1.237442>, <0.186285, 0.787647, 0.805421>, <0.028296, 0.788352, 0.592242>, 
      <0.436327, 0.632947, 1.264779>, <0.267169, 0.835046, 1.233984>, <0.022048, 0.716309, 0.808827>, <-0.135942, 0.717015, 0.595648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.714734, 0.361456, 1.047013>, <0.703403, -0.002669, 0.855666>, <0.580751, -0.139241, 0.726122>, 
      <0.689551, 0.583092, 1.076861>, <0.734995, 0.379263, 1.159719>, <0.368613, -0.062242, 0.728240>, <0.245960, -0.198814, 0.598696>, 
      <0.551798, 0.642145, 1.268238>, <0.267381, 0.619490, 1.259719>, <-0.064005, 0.310599, 1.328335>, <-0.303550, 0.254943, 1.183423>, 
      <0.436327, 0.632947, 1.264779>, <0.151910, 0.610292, 1.256260>, <-0.201331, 0.532515, 1.075815>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.714734, 0.361456, 1.047013>, <0.703403, -0.002669, 0.855666>, <0.580751, -0.139241, 0.726122>, 
      <0.616116, 0.518555, 0.668369>, <0.661560, 0.314726, 0.751227>, <0.368613, -0.062242, 0.728240>, <0.245960, -0.198814, 0.598696>, 
      <0.503504, 0.489517, 0.164309>, <0.305133, 0.499630, 0.424555>, <-0.427355, 0.455008, 0.955767>, <-0.303550, 0.254943, 1.183423>, 
      <0.220358, 0.443146, 0.063418>, <0.021988, 0.453260, 0.323663>, <-0.564680, 0.676923, 0.703247>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.689551, 0.583092, 1.076861>, <0.551798, 0.642145, 1.268238>, <0.436327, 0.632947, 1.264779>, 
      <0.616116, 0.518555, 0.668369>, <0.636378, 0.536362, 0.781075>, <0.267381, 0.619490, 1.259719>, <0.151910, 0.610292, 1.256260>, 
      <0.503504, 0.489517, 0.164309>, <0.305133, 0.499630, 0.424555>, <-0.325135, 0.732580, 0.848159>, <-0.201331, 0.532515, 1.075815>, 
      <0.220358, 0.443146, 0.063418>, <0.021988, 0.453260, 0.323663>, <-0.564680, 0.676923, 0.703247>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.620023, 0.786261, 0.874327>, <0.536083, 0.894446, 0.455090>, <0.347680, 0.906152, 0.301162>, 
      <0.616116, 0.518555, 0.668369>, <0.566850, 0.739531, 0.578541>, <0.322607, 0.907710, 0.280677>, <0.134204, 0.919416, 0.126749>, 
      <0.503504, 0.489517, 0.164309>, <0.417006, 0.758629, 0.147296>, <-0.048294, 0.751728, -0.159093>, <-0.262411, 0.724507, -0.115867>, 
      <0.220358, 0.443146, 0.063418>, <0.133860, 0.712259, 0.046405>, <-0.271874, 0.664289, -0.022951>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.059070, -0.295967, 0.276292>, <0.415468, -0.323282, 0.551552>, <0.580751, -0.139241, 0.726122>, 
      <0.096270, -0.329982, 0.030862>, <0.319847, -0.262813, 0.223647>, <0.080677, -0.382854, 0.424126>, <0.245960, -0.198814, 0.598696>, 
      <0.325705, 0.115389, 0.084139>, <0.127335, 0.125503, 0.344384>, <-0.427355, 0.455008, 0.955767>, <-0.303550, 0.254943, 1.183423>, 
      <0.220358, 0.443146, 0.063418>, <0.021988, 0.453260, 0.323663>, <-0.564680, 0.676923, 0.703247>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.059070, -0.295967, 0.276292>, <0.415468, -0.323282, 0.551552>, <0.580751, -0.139241, 0.726122>, 
      <0.096270, -0.329982, 0.030862>, <0.319847, -0.262813, 0.223647>, <0.538120, -0.186710, 0.681096>, <0.703403, -0.002669, 0.855666>, 
      <0.325705, 0.115389, 0.084139>, <0.608851, 0.161760, 0.185030>, <0.661560, 0.314726, 0.751227>, <0.714734, 0.361456, 1.047013>, 
      <0.220358, 0.443146, 0.063418>, <0.503504, 0.489517, 0.164309>, <0.616116, 0.518555, 0.668369>, <0.669290, 0.565286, 0.964155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.096270, -0.329982, 0.030862>, <0.325705, 0.115389, 0.084139>, <0.220358, 0.443146, 0.063418>, 
      <-0.164507, -0.363135, 0.083508>, <-0.243492, -0.373177, 0.099454>, <-0.055336, 0.052986, -0.051635>, <-0.160683, 0.380743, -0.072356>, 
      <-0.164507, -0.363135, 0.083508>, <-0.243492, -0.373177, 0.099454>, <-0.721453, -0.165241, 0.032966>, <-0.858708, 0.261788, 0.005969>, 
      <-0.164507, -0.363135, 0.083508>, <-0.504269, -0.406330, 0.152099>, <-0.969454, -0.152597, 0.358323>, <-1.106709, 0.274432, 0.331326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.096270, -0.329982, 0.030862>, <0.325705, 0.115389, 0.084139>, <0.220358, 0.443146, 0.063418>, 
      <-0.504269, -0.406330, 0.152099>, <-0.243492, -0.373177, 0.099454>, <0.127335, 0.125503, 0.344384>, <0.021988, 0.453260, 0.323663>, 
      <-0.969454, -0.152597, 0.358323>, <-1.136432, -0.144084, 0.577385>, <-0.795943, 0.623190, 0.563346>, <-0.564680, 0.676923, 0.703247>, 
      <-1.106709, 0.274432, 0.331326>, <-1.273687, 0.282945, 0.550388>, <-0.672139, 0.423125, 0.791002>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <-0.504269, -0.406330, 0.152099>, <-0.969454, -0.152597, 0.358323>, <-1.106709, 0.274432, 0.331326>, 
      <0.059070, -0.295967, 0.276292>, <-0.280691, -0.339162, 0.344883>, <-1.136432, -0.144084, 0.577385>, <-1.273687, 0.282945, 0.550388>, 
      <0.415468, -0.323282, 0.551552>, <0.080677, -0.382854, 0.424126>, <-0.534813, 0.201210, 1.043521>, <-0.672139, 0.423125, 0.791002>, 
      <0.580751, -0.139241, 0.726122>, <0.245960, -0.198814, 0.598696>, <-0.303550, 0.254943, 1.183423>, <-0.440876, 0.476858, 0.930903>
    }
  }
  material {
    SlateRock
  }
  scale 5.0
  translate  <352.342796, -16.248634, -4.746621>
}
#declare Rock8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    SlateRock
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate -21.70285*z
  translate  <329.248452, -9.450715, 0.506597>
}
#declare Rock9 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.440876, 0.476858, 0.930903>, <-0.201331, 0.532515, 1.075815>, <0.151910, 0.610292, 1.256260>, <0.436327, 0.632947, 1.264779>, 
      <-0.440876, 0.476858, 0.930903>, <-0.064005, 0.310599, 1.328335>, <0.334081, 0.392647, 1.289424>, <0.618498, 0.415302, 1.297943>, 
      <-0.440876, 0.476858, 0.930903>, <-0.064005, 0.310599, 1.328335>, <0.509406, -0.151936, 0.698967>, <0.844197, -0.092364, 0.826393>, 
      <-0.440876, 0.476858, 0.930903>, <-0.303550, 0.254943, 1.183423>, <0.245960, -0.198814, 0.598696>, <0.580751, -0.139241, 0.726122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.347680, 0.906152, 0.301162>, <0.134204, 0.919416, 0.126749>, <-0.262411, 0.724507, -0.115867>, <-0.485991, 0.637068, 0.020275>, 
      <0.347680, 0.906152, 0.301162>, <-0.010883, 0.862675, 0.215095>, <-0.427242, 0.660044, -0.015499>, <-0.650821, 0.572605, 0.120643>, 
      <0.347680, 0.906152, 0.301162>, <-0.010883, 0.862675, 0.215095>, <-0.092851, 0.788894, 0.428775>, <-0.257089, 0.717556, 0.432182>, 
      <0.347680, 0.906152, 0.301162>, <0.202593, 0.849411, 0.389508>, <0.028296, 0.788352, 0.592242>, <-0.135942, 0.717015, 0.595648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.858708, 0.261788, 0.005969>, <-0.160683, 0.380743, -0.072356>, <0.220358, 0.443146, 0.063418>, 
      <-1.106709, 0.274432, 0.331326>, <-0.951046, 0.549070, -0.012193>, <-0.247181, 0.649856, -0.089369>, <0.133860, 0.712259, 0.046405>, 
      <-1.106709, 0.274432, 0.331326>, <-0.951046, 0.549070, -0.012193>, <-0.500447, 0.635230, 0.023193>, <-0.271874, 0.664289, -0.022951>, 
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.858708, 0.261788, 0.005969>, <-0.160683, 0.380743, -0.072356>, <0.220358, 0.443146, 0.063418>, 
      <-1.106709, 0.274432, 0.331326>, <-1.025686, 0.270301, 0.225031>, <-0.359054, 0.390857, 0.187890>, <0.021988, 0.453260, 0.323663>, 
      <-1.106709, 0.274432, 0.331326>, <-1.025686, 0.270301, 0.225031>, <-0.795943, 0.623190, 0.563346>, <-0.564680, 0.676923, 0.703247>, 
      <-1.106709, 0.274432, 0.331326>, <-1.273687, 0.282945, 0.550388>, <-0.672139, 0.423125, 0.791002>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>, 
      <-1.273687, 0.282945, 0.550388>, <-1.366025, 0.570227, 0.532226>, <-0.500447, 0.635230, 0.023193>, <-0.271874, 0.664289, -0.022951>, 
      <-0.672139, 0.423125, 0.791002>, <-0.795943, 0.623190, 0.563346>, <-0.064510, 0.722372, 0.306650>, <0.133860, 0.712259, 0.046405>, 
      <-0.440876, 0.476858, 0.930903>, <-0.564680, 0.676923, 0.703247>, <0.021988, 0.453260, 0.323663>, <0.220358, 0.443146, 0.063418>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-1.273687, 0.282945, 0.550388>, <-0.672139, 0.423125, 0.791002>, <-0.440876, 0.476858, 0.930903>, 
      <-0.815479, 0.407207, 0.410623>, <-0.982457, 0.415720, 0.629684>, <-0.432594, 0.478782, 0.935913>, <-0.201331, 0.532515, 1.075815>, 
      <-0.438334, 0.585670, 0.601920>, <-0.280345, 0.584964, 0.815099>, <-0.017248, 0.812391, 1.225465>, <0.151910, 0.610292, 1.256260>, 
      <-0.135942, 0.717015, 0.595648>, <0.022048, 0.716309, 0.808827>, <0.267169, 0.835046, 1.233984>, <0.436327, 0.632947, 1.264779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.815479, 0.407207, 0.410623>, <-0.438334, 0.585670, 0.601920>, <-0.135942, 0.717015, 0.595648>, 
      <-1.106709, 0.274432, 0.331326>, <-0.907817, 0.694489, 0.392461>, <-0.559481, 0.586211, 0.438453>, <-0.257089, 0.717556, 0.432182>, 
      <-1.106709, 0.274432, 0.331326>, <-0.907817, 0.694489, 0.392461>, <-0.879394, 0.543546, 0.166787>, <-0.650821, 0.572605, 0.120643>, 
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-0.858708, 0.261788, 0.005969>, <-0.160683, 0.380743, -0.072356>, <0.220358, 0.443146, 0.063418>, 
      <-0.815479, 0.407207, 0.410623>, <-0.567478, 0.394563, 0.085266>, <-0.247181, 0.649856, -0.089369>, <0.133860, 0.712259, 0.046405>, 
      <-0.438334, 0.585670, 0.601920>, <-0.559481, 0.586211, 0.438453>, <-0.436704, 0.599827, 0.077417>, <-0.271874, 0.664289, -0.022951>, 
      <-0.135942, 0.717015, 0.595648>, <-0.257089, 0.717556, 0.432182>, <-0.650821, 0.572605, 0.120643>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.106709, 0.274432, 0.331326>, <-1.199047, 0.561714, 0.313164>, <-0.714564, 0.608009, 0.066419>, <-0.485991, 0.637068, 0.020275>, 
      <-0.815479, 0.407207, 0.410623>, <-0.907817, 0.694489, 0.392461>, <-0.490984, 0.695447, -0.069722>, <-0.262411, 0.724507, -0.115867>, 
      <-0.438334, 0.585670, 0.601920>, <-0.274097, 0.657007, 0.598513>, <-0.010883, 0.862675, 0.215095>, <0.134204, 0.919416, 0.126749>, 
      <-0.135942, 0.717015, 0.595648>, <0.028296, 0.788352, 0.592242>, <0.202593, 0.849411, 0.389508>, <0.347680, 0.906152, 0.301162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.714734, 0.361456, 1.047013>, <0.703403, -0.002669, 0.855666>, <0.580751, -0.139241, 0.726122>, 
      <0.669290, 0.565286, 0.964155>, <0.734995, 0.379263, 1.159719>, <0.966849, 0.044208, 0.955937>, <0.844197, -0.092364, 0.826393>, 
      <0.669290, 0.565286, 0.964155>, <0.734995, 0.379263, 1.159719>, <0.733969, 0.424499, 1.301402>, <0.618498, 0.415302, 1.297943>, 
      <0.669290, 0.565286, 0.964155>, <0.689551, 0.583092, 1.076861>, <0.551798, 0.642145, 1.268238>, <0.436327, 0.632947, 1.264779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.620023, 0.786261, 0.874327>, <0.536083, 0.894446, 0.455090>, <0.347680, 0.906152, 0.301162>, 
      <0.689551, 0.583092, 1.076861>, <0.640285, 0.804068, 0.987033>, <0.390996, 0.837705, 0.543435>, <0.202593, 0.849411, 0.389508>, 
      <0.551798, 0.642145, 1.268238>, <0.382640, 0.844243, 1.237442>, <0.186285, 0.787647, 0.805421>, <0.028296, 0.788352, 0.592242>, 
      <0.436327, 0.632947, 1.264779>, <0.267169, 0.835046, 1.233984>, <0.022048, 0.716309, 0.808827>, <-0.135942, 0.717015, 0.595648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.714734, 0.361456, 1.047013>, <0.703403, -0.002669, 0.855666>, <0.580751, -0.139241, 0.726122>, 
      <0.689551, 0.583092, 1.076861>, <0.734995, 0.379263, 1.159719>, <0.368613, -0.062242, 0.728240>, <0.245960, -0.198814, 0.598696>, 
      <0.551798, 0.642145, 1.268238>, <0.267381, 0.619490, 1.259719>, <-0.064005, 0.310599, 1.328335>, <-0.303550, 0.254943, 1.183423>, 
      <0.436327, 0.632947, 1.264779>, <0.151910, 0.610292, 1.256260>, <-0.201331, 0.532515, 1.075815>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.714734, 0.361456, 1.047013>, <0.703403, -0.002669, 0.855666>, <0.580751, -0.139241, 0.726122>, 
      <0.616116, 0.518555, 0.668369>, <0.661560, 0.314726, 0.751227>, <0.368613, -0.062242, 0.728240>, <0.245960, -0.198814, 0.598696>, 
      <0.503504, 0.489517, 0.164309>, <0.305133, 0.499630, 0.424555>, <-0.427355, 0.455008, 0.955767>, <-0.303550, 0.254943, 1.183423>, 
      <0.220358, 0.443146, 0.063418>, <0.021988, 0.453260, 0.323663>, <-0.564680, 0.676923, 0.703247>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.689551, 0.583092, 1.076861>, <0.551798, 0.642145, 1.268238>, <0.436327, 0.632947, 1.264779>, 
      <0.616116, 0.518555, 0.668369>, <0.636378, 0.536362, 0.781075>, <0.267381, 0.619490, 1.259719>, <0.151910, 0.610292, 1.256260>, 
      <0.503504, 0.489517, 0.164309>, <0.305133, 0.499630, 0.424555>, <-0.325135, 0.732580, 0.848159>, <-0.201331, 0.532515, 1.075815>, 
      <0.220358, 0.443146, 0.063418>, <0.021988, 0.453260, 0.323663>, <-0.564680, 0.676923, 0.703247>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669290, 0.565286, 0.964155>, <0.620023, 0.786261, 0.874327>, <0.536083, 0.894446, 0.455090>, <0.347680, 0.906152, 0.301162>, 
      <0.616116, 0.518555, 0.668369>, <0.566850, 0.739531, 0.578541>, <0.322607, 0.907710, 0.280677>, <0.134204, 0.919416, 0.126749>, 
      <0.503504, 0.489517, 0.164309>, <0.417006, 0.758629, 0.147296>, <-0.048294, 0.751728, -0.159093>, <-0.262411, 0.724507, -0.115867>, 
      <0.220358, 0.443146, 0.063418>, <0.133860, 0.712259, 0.046405>, <-0.271874, 0.664289, -0.022951>, <-0.485991, 0.637068, 0.020275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.059070, -0.295967, 0.276292>, <0.415468, -0.323282, 0.551552>, <0.580751, -0.139241, 0.726122>, 
      <0.096270, -0.329982, 0.030862>, <0.319847, -0.262813, 0.223647>, <0.080677, -0.382854, 0.424126>, <0.245960, -0.198814, 0.598696>, 
      <0.325705, 0.115389, 0.084139>, <0.127335, 0.125503, 0.344384>, <-0.427355, 0.455008, 0.955767>, <-0.303550, 0.254943, 1.183423>, 
      <0.220358, 0.443146, 0.063418>, <0.021988, 0.453260, 0.323663>, <-0.564680, 0.676923, 0.703247>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.059070, -0.295967, 0.276292>, <0.415468, -0.323282, 0.551552>, <0.580751, -0.139241, 0.726122>, 
      <0.096270, -0.329982, 0.030862>, <0.319847, -0.262813, 0.223647>, <0.538120, -0.186710, 0.681096>, <0.703403, -0.002669, 0.855666>, 
      <0.325705, 0.115389, 0.084139>, <0.608851, 0.161760, 0.185030>, <0.661560, 0.314726, 0.751227>, <0.714734, 0.361456, 1.047013>, 
      <0.220358, 0.443146, 0.063418>, <0.503504, 0.489517, 0.164309>, <0.616116, 0.518555, 0.668369>, <0.669290, 0.565286, 0.964155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.096270, -0.329982, 0.030862>, <0.325705, 0.115389, 0.084139>, <0.220358, 0.443146, 0.063418>, 
      <-0.164507, -0.363135, 0.083508>, <-0.243492, -0.373177, 0.099454>, <-0.055336, 0.052986, -0.051635>, <-0.160683, 0.380743, -0.072356>, 
      <-0.164507, -0.363135, 0.083508>, <-0.243492, -0.373177, 0.099454>, <-0.721453, -0.165241, 0.032966>, <-0.858708, 0.261788, 0.005969>, 
      <-0.164507, -0.363135, 0.083508>, <-0.504269, -0.406330, 0.152099>, <-0.969454, -0.152597, 0.358323>, <-1.106709, 0.274432, 0.331326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <0.096270, -0.329982, 0.030862>, <0.325705, 0.115389, 0.084139>, <0.220358, 0.443146, 0.063418>, 
      <-0.504269, -0.406330, 0.152099>, <-0.243492, -0.373177, 0.099454>, <0.127335, 0.125503, 0.344384>, <0.021988, 0.453260, 0.323663>, 
      <-0.969454, -0.152597, 0.358323>, <-1.136432, -0.144084, 0.577385>, <-0.795943, 0.623190, 0.563346>, <-0.564680, 0.676923, 0.703247>, 
      <-1.106709, 0.274432, 0.331326>, <-1.273687, 0.282945, 0.550388>, <-0.672139, 0.423125, 0.791002>, <-0.440876, 0.476858, 0.930903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164507, -0.363135, 0.083508>, <-0.504269, -0.406330, 0.152099>, <-0.969454, -0.152597, 0.358323>, <-1.106709, 0.274432, 0.331326>, 
      <0.059070, -0.295967, 0.276292>, <-0.280691, -0.339162, 0.344883>, <-1.136432, -0.144084, 0.577385>, <-1.273687, 0.282945, 0.550388>, 
      <0.415468, -0.323282, 0.551552>, <0.080677, -0.382854, 0.424126>, <-0.534813, 0.201210, 1.043521>, <-0.672139, 0.423125, 0.791002>, 
      <0.580751, -0.139241, 0.726122>, <0.245960, -0.198814, 0.598696>, <-0.303550, 0.254943, 1.183423>, <-0.440876, 0.476858, 0.930903>
    }
  }
  material {
    SlateRock
  }
  scale <3.338696, 1.797314, 2.105591>
  rotate -20.31086*z
  translate  <337.246255, -21.202055, 0.959726>
}
#declare Rock10 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016529, -0.240328, -0.500000>, <-0.138765, -0.220850, -0.514198>, <-0.250790, -0.301704, -0.396890>, <-0.361914, -0.431382, -0.315239>, 
      <0.011811, -0.462197, -0.244028>, <-0.143483, -0.442719, -0.258225>, <-0.187571, -0.525112, -0.182310>, <-0.298695, -0.525112, -0.071186>, 
      <0.021350, -0.310421, 0.208343>, <0.088026, -0.312403, 0.224391>, <-0.034922, -0.402227, 0.305864>, <0.009650, -0.419944, 0.256807>, 
      <0.016529, -0.293378, 0.370322>, <0.083205, -0.295360, 0.386370>, <0.158120, -0.407892, 0.406747>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.053050, 0.370322>, <-0.001137, -0.075259, 0.439084>, <0.015368, -0.276493, 0.440581>, <0.016529, -0.293378, 0.370322>, 
      <0.059650, -0.076082, 0.395193>, <0.058514, -0.098290, 0.463955>, <0.082044, -0.278474, 0.456629>, <0.083205, -0.295360, 0.386370>, 
      <0.153734, -0.165071, 0.414673>, <0.143980, -0.190122, 0.471212>, <0.133215, -0.396643, 0.390749>, <0.158120, -0.407892, 0.406747>, 
      <0.139012, -0.185282, 0.357691>, <0.105676, -0.210332, 0.343496>, <0.177788, -0.414360, 0.341693>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033058, 0.082645, -0.500000>, <0.034617, 0.059977, -0.594320>, <0.018055, -0.210514, -0.592311>, <0.016529, -0.240328, -0.500000>, 
      <-0.086362, 0.111905, -0.529623>, <-0.084803, 0.089238, -0.623944>, <-0.137239, -0.191036, -0.606509>, <-0.138765, -0.220850, -0.514198>, 
      <-0.261842, 0.014211, -0.439474>, <-0.227697, -0.012347, -0.517229>, <-0.299888, -0.268816, -0.471119>, <-0.250790, -0.301704, -0.396890>, 
      <-0.259189, -0.011789, -0.359394>, <-0.319356, -0.026558, -0.431255>, <-0.411012, -0.398494, -0.389467>, <-0.361914, -0.431382, -0.315239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033058, 0.082645, -0.500000>, <0.028218, 0.153015, -0.207190>, <0.004737, 0.021822, 0.183955>, <0.000000, -0.053050, 0.370322>, 
      <-0.086362, 0.111905, -0.529623>, <-0.091202, 0.182276, -0.236813>, <0.064387, 0.010579, 0.208826>, <0.059650, -0.076082, 0.395193>, 
      <-0.261842, 0.014211, -0.439474>, <-0.070104, 0.061275, -0.210472>, <-0.002731, -0.036687, 0.290120>, <0.153734, -0.165071, 0.414673>, 
      <-0.259189, -0.011789, -0.359394>, <-0.161763, 0.047065, -0.124497>, <0.029699, -0.027425, 0.250821>, <0.139012, -0.185282, 0.357691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.139012, -0.132231, -0.219631>, <0.156038, -0.096093, -0.325112>, <0.142117, 0.055922, -0.472947>, <0.033058, 0.082645, -0.500000>, 
      <0.047285, -0.017335, -0.090556>, <0.017160, 0.018804, -0.196037>, <0.137277, 0.126293, -0.180137>, <0.028218, 0.153015, -0.207190>, 
      <-0.181358, 0.061900, 0.082560>, <-0.095686, 0.067795, 0.174126>, <-0.100602, 0.074283, 0.134139>, <0.004737, 0.021822, 0.183955>, 
      <-0.327545, 0.042538, 0.243706>, <-0.241873, 0.013066, 0.229173>, <-0.105339, -0.012378, 0.326401>, <0.000000, -0.053050, 0.370322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202693, -0.502237, -0.249103>, <0.153121, -0.482533, -0.343559>, <0.123723, -0.253773, -0.490200>, <0.016529, -0.240328, -0.500000>, 
      <0.250347, -0.482475, -0.299713>, <0.200775, -0.462771, -0.394168>, <0.125249, -0.223959, -0.582511>, <0.018055, -0.210514, -0.592311>, 
      <0.184284, -0.169686, -0.261707>, <0.154158, -0.133547, -0.367188>, <0.143676, 0.033255, -0.567267>, <0.034617, 0.059977, -0.594320>, 
      <0.139012, -0.132231, -0.219631>, <0.156038, -0.096093, -0.325112>, <0.142117, 0.055922, -0.472947>, <0.033058, 0.082645, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, -0.409081, 0.223822>, <-0.434405, -0.342146, 0.299016>, <-0.412707, -0.022251, 0.233944>, <-0.327545, 0.042538, 0.243706>, 
      <-0.265581, -0.409081, 0.311741>, <-0.346486, -0.342146, 0.386935>, <-0.327035, -0.022251, 0.319616>, <-0.241873, 0.013066, 0.229173>, 
      <-0.104304, -0.289787, 0.341239>, <-0.105466, -0.272902, 0.411498>, <-0.106475, -0.034586, 0.395164>, <-0.105339, -0.012378, 0.326401>, 
      <0.016529, -0.293378, 0.370322>, <0.015368, -0.276493, 0.440581>, <-0.001137, -0.075259, 0.439084>, <0.000000, -0.053050, 0.370322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, -0.409081, 0.223822>, <-0.265581, -0.409081, 0.311741>, <-0.104304, -0.289787, 0.341239>, <0.016529, -0.293378, 0.370322>, 
      <-0.203378, -0.480229, 0.213975>, <-0.115459, -0.480229, 0.301893>, <-0.099484, -0.306830, 0.179260>, <0.021350, -0.310421, 0.208343>, 
      <0.044671, -0.567769, -0.081282>, <-0.004900, -0.548065, -0.175737>, <0.119005, -0.475642, -0.234228>, <0.011811, -0.462197, -0.244028>, 
      <0.202693, -0.502237, -0.249103>, <0.153121, -0.482533, -0.343559>, <0.123723, -0.253773, -0.490200>, <0.016529, -0.240328, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389160, -0.252117, -0.005894>, <-0.370336, -0.393910, 0.080696>, <-0.437082, -0.356030, 0.269918>, <-0.353500, -0.409081, 0.223822>, 
      <-0.251356, -0.471840, 0.007119>, <-0.232533, -0.483955, 0.123182>, <-0.286959, -0.609907, 0.100921>, <-0.203378, -0.480229, 0.213975>, 
      <0.100163, -0.540934, 0.058870>, <0.100163, -0.540934, -0.055926>, <0.097130, -0.588621, 0.018675>, <0.044671, -0.567769, -0.081282>, 
      <0.142449, -0.473221, 0.104397>, <0.095297, -0.455085, -0.010400>, <0.091933, -0.483192, -0.149146>, <0.202693, -0.502237, -0.249103>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389160, -0.252117, -0.005894>, <-0.251356, -0.471840, 0.007119>, <0.100163, -0.540934, 0.058870>, <0.142449, -0.473221, 0.104397>, 
      <-0.402801, -0.243337, -0.090004>, <-0.264998, -0.463060, -0.076991>, <0.100163, -0.411256, 0.203139>, <0.102551, -0.339916, 0.248665>, 
      <-0.422485, -0.431382, -0.254668>, <-0.264955, -0.536901, -0.016510>, <0.084229, -0.579267, 0.145253>, <0.135815, -0.404475, 0.275609>, 
      <-0.361914, -0.431382, -0.315239>, <-0.298695, -0.525112, -0.071186>, <0.009650, -0.419944, 0.256807>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.165030, -0.132231, 0.127175>, <0.240272, -0.165242, 0.139037>, <0.103480, -0.438914, 0.119154>, <0.142449, -0.473221, 0.104397>, 
      <0.165030, -0.132231, 0.022841>, <0.240272, -0.165242, 0.034702>, <0.038193, -0.467931, 0.004358>, <0.095297, -0.455085, -0.010400>, 
      <0.166226, -0.164877, -0.124346>, <0.211498, -0.202331, -0.166422>, <0.168604, -0.496073, -0.199756>, <0.091933, -0.483192, -0.149146>, 
      <0.139012, -0.132231, -0.219631>, <0.184284, -0.169686, -0.261707>, <0.250347, -0.482475, -0.299713>, <0.202693, -0.502237, -0.249103>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.165030, -0.132231, 0.127175>, <0.165030, -0.132231, 0.235515>, <0.190222, -0.217195, 0.267710>, <0.139012, -0.185282, 0.357691>, 
      <0.240272, -0.165242, 0.139037>, <0.240272, -0.165242, 0.247376>, <0.156886, -0.242246, 0.253515>, <0.105676, -0.210332, 0.343496>, 
      <0.103480, -0.438914, 0.119154>, <0.150632, -0.309236, 0.263423>, <0.134492, -0.375090, 0.330345>, <0.177788, -0.414360, 0.341693>, 
      <0.142449, -0.473221, 0.104397>, <0.102551, -0.339916, 0.248665>, <0.135815, -0.404475, 0.275609>, <0.131959, -0.425609, 0.286957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.495929, 0.010371, 0.098297>, <-0.397497, 0.066116, 0.203227>, <-0.327545, 0.042538, 0.243706>, 
      <-0.475963, -0.022709, -0.018742>, <-0.471892, -0.012338, 0.079556>, <-0.482659, -0.010462, 0.281882>, <-0.412707, -0.022251, 0.233944>, 
      <-0.454661, -0.223380, -0.016220>, <-0.530148, -0.223707, 0.105737>, <-0.517987, -0.342146, 0.215434>, <-0.434405, -0.342146, 0.299016>, 
      <-0.389160, -0.252117, -0.005894>, <-0.370336, -0.393910, 0.080696>, <-0.437082, -0.356030, 0.269918>, <-0.353500, -0.409081, 0.223822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.285459, 0.033337, 0.039221>, <0.012214, -0.044501, 0.095652>, <0.165030, -0.132231, 0.127175>, 
      <-0.495929, 0.010371, 0.098297>, <-0.281388, 0.043708, 0.137518>, <0.012214, -0.044501, -0.008682>, <0.165030, -0.132231, 0.022841>, 
      <-0.397497, 0.066116, 0.203227>, <-0.251310, 0.050111, 0.071553>, <0.074499, -0.049980, 0.004730>, <0.166226, -0.164877, -0.124346>, 
      <-0.327545, 0.042538, 0.243706>, <-0.181358, 0.061900, 0.082560>, <0.047285, -0.017335, -0.090556>, <0.139012, -0.132231, -0.219631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.475963, -0.022709, -0.018742>, <-0.454661, -0.223380, -0.016220>, <-0.389160, -0.252117, -0.005894>, 
      <-0.410413, -0.023823, -0.119961>, <-0.480687, -0.034743, -0.132808>, <-0.468302, -0.214600, -0.100330>, <-0.402801, -0.243337, -0.090004>, 
      <-0.342386, -0.024688, -0.281356>, <-0.402553, -0.039457, -0.353217>, <-0.471583, -0.398494, -0.328897>, <-0.422485, -0.431382, -0.254668>, 
      <-0.259189, -0.011789, -0.359394>, <-0.319356, -0.026558, -0.431255>, <-0.411012, -0.398494, -0.389467>, <-0.361914, -0.431382, -0.315239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405689, -0.011789, -0.005894>, <-0.410413, -0.023823, -0.119961>, <-0.342386, -0.024688, -0.281356>, <-0.259189, -0.011789, -0.359394>, 
      <-0.285459, 0.033337, 0.039221>, <-0.290183, 0.021303, -0.074845>, <-0.244961, 0.034166, -0.046459>, <-0.161763, 0.047065, -0.124497>, 
      <0.012214, -0.044501, 0.095652>, <0.012214, -0.044501, 0.203991>, <0.080909, -0.059339, 0.160840>, <0.029699, -0.027425, 0.250821>, 
      <0.165030, -0.132231, 0.127175>, <0.165030, -0.132231, 0.235515>, <0.190222, -0.217195, 0.267710>, <0.139012, -0.185282, 0.357691>
    }
  }
  material {
    GraniteRock
    scale 0.5
  }
  scale <8.148001, 7.401688, 3.459737>
  rotate <90.0, -0.0, 75.374504>
  translate  <352.228, -23.888, 1.291>
}
#declare Rock11 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, 0.506017, 0.497283>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, <-0.803653, 0.500000, 0.499269>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.270137>, <0.819635, 0.000000, 0.000000>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.589747, -0.002384, 0.497283>, <0.589747, -0.510786, 0.497283>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, -0.514905>, 
      <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, <-0.803653, -0.500000, 0.499269>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <0.589747, -0.510786, 0.497283>, <0.319635, -0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.270137>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <0.589747, -0.508158, -0.502717>, <0.319635, -0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, -0.270137>, <-0.154804, -0.505728, -0.521432>, <-0.803653, -0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, -0.270137>, <0.589747, -0.002384, -0.502717>, <0.319635, 0.000000, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <0.589747, 0.503389, -0.502717>, <0.319635, 0.505773, -0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, -0.270137>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>, 
      <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, 0.494272, -0.521432>, <-0.803653, 0.500000, -0.514905>, 
      <-0.154804, -0.505728, -0.015658>, <-0.154804, -0.505728, -0.521432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.000000, 0.270137>, <0.589747, -0.002384, 0.497283>, <0.319635, 0.000000, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <0.589747, 0.506017, 0.497283>, <0.319635, 0.508401, 0.500000>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.270137>, <-0.154804, 0.494272, 0.492743>, <-0.803653, 0.500000, 0.499269>, 
      <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, <-0.154804, 0.494272, -0.015658>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, <-0.154804, -0.505728, -0.015658>, <-0.803653, -0.500000, -0.009132>, 
      <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>, <-0.154804, -0.505728, 0.492743>, <-0.803653, -0.500000, 0.499269>, 
      <-0.154804, 0.494272, -0.015658>, <-0.154804, 0.494272, 0.492743>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, -0.503640, -0.497570>, <-0.803653, -0.500000, -0.006504>, <-0.803653, -0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, <-0.803653, -0.500000, -0.514905>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, -0.232859>, <-0.056156, 0.007731, 0.003429>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <0.077989, 0.002133, -0.497570>, <0.077989, 0.507906, -0.497570>, <-0.803653, 0.500000, -0.006504>, <-0.803653, 0.500000, 0.499269>, 
      <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, <-0.803653, 0.500000, -0.514905>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.145621, 0.503019, -0.005692>, <-0.496771, 0.497291, -0.012219>, <0.819635, 0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, -0.232859>, <0.077989, 0.507906, -0.497570>, <0.319635, 0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <0.083368, 0.510487, 0.502377>, <0.319635, 0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.245097>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.348102, -0.000251, -0.500286>, <0.589747, -0.002384, -0.502717>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, -0.270137>, <0.819635, 0.000000, -0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.353481, -0.000299, 0.499660>, <0.589747, -0.002384, 0.497283>, 
      <-1.148904, -0.496952, -0.005659>, <-0.500055, -0.502680, -0.012186>, <0.819635, -0.648907, 0.270137>, <0.819635, 0.000000, 0.270137>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, 0.245097>, <0.083368, 0.002086, 0.502377>, <0.319635, 0.000000, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <0.083368, -0.506316, 0.502377>, <0.319635, -0.508401, 0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.245097>, <-1.148904, -0.496952, 0.502742>, <-0.803653, -0.500000, 0.499269>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, 0.502709>, <-0.803653, 0.500000, 0.499269>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, 0.502742>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.007731, -0.232859>, <0.077989, 0.002133, -0.497570>, <0.319635, 0.000000, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <0.077989, -0.503640, -0.497570>, <0.319635, -0.505773, -0.500000>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, -0.232859>, <-1.148904, -0.496952, -0.511432>, <-0.803653, -0.500000, -0.514905>, 
      <-0.056156, 0.007731, 0.008809>, <-0.056156, -0.337550, 0.008809>, <-1.148904, -0.496952, -0.005659>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056156, 0.007731, 0.008809>, <-0.056156, 0.349730, 0.008809>, <-1.145621, 0.503019, -0.005692>, <-0.803653, 0.500000, -0.009132>, 
      <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.004448, 0.008809>, <-1.145621, 0.503019, -0.511466>, <-0.803653, 0.500000, -0.514905>, 
      <-1.148904, -0.496952, -0.005659>, <-1.148904, -0.496952, -0.511432>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <0.041185, -0.517149, -0.222369>, <-0.154804, -0.505728, -0.015658>, 
      <-0.605406, 0.488447, -0.218225>, <0.043444, 0.482719, -0.224751>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.952915, -0.508374, -0.212370>, <-1.148904, -0.496952, -0.005659>, 
      <-0.605406, 0.488447, -0.218225>, <-0.947373, 0.491466, -0.214785>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>, 
      <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.605406, 0.488447, -0.723998>, <-0.803653, 0.500000, -0.514905>, 
      <-0.607664, -0.511421, -0.215843>, <-0.607664, -0.511421, -0.721616>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>, 
      <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.003169, -0.502966>, <-0.607664, -0.511421, 0.292559>, <-0.803653, -0.500000, 0.499269>, 
      <-0.605406, 0.488447, -0.218225>, <-0.605406, 0.488447, 0.290177>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-1.339997, 0.514346, 0.199318>, <-1.145621, 0.503019, -0.005692>, 
      <-1.010935, -0.487921, 0.209489>, <-1.356185, -0.484873, 0.212962>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.349181, 0.505599, 0.189352>, <-0.154804, 0.494272, -0.015658>, 
      <-1.010935, -0.487921, 0.209489>, <-0.362086, -0.493648, 0.202963>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, 0.704280>, <-0.803653, 0.500000, 0.499269>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, 0.717891>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>, 
      <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.018800, 0.293830>, <-0.998030, 0.511327, -0.309895>, <-0.803653, 0.500000, -0.514905>, 
      <-1.010935, -0.487921, 0.209489>, <-1.010935, -0.487921, -0.296284>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, 0.311677, 0.324145>, <-0.799782, 0.499775, -0.013214>, <-0.605406, 0.488447, -0.218225>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, 0.320308, 0.293830>, <-0.998030, 0.511327, 0.195878>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <-0.292883, 0.093379, 0.402119>, <-0.080819, 0.081021, 0.178453>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <-0.762256, 0.028941, 0.324145>, <-0.762256, -0.272567, 0.324145>, <-0.814946, -0.499342, 0.002778>, <-0.607664, -0.511421, -0.215843>, 
      <-1.295694, 0.037571, 0.293830>, <-1.295694, -0.263937, 0.293830>, <-1.010935, -0.487921, 0.209489>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.762256, -0.272567, 0.324145>, <-1.295694, -0.263937, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, -0.307088, 0.402119>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.232299, -0.296517, -0.485466>, <-0.540227, -0.291535, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, -0.340855, -0.209013>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.059612, -0.209013>, <-0.232299, -0.011436, -0.485466>, <-0.540227, -0.006454, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232299, 0.276931, -0.485466>, <-0.540227, 0.281913, -0.502966>, 
      <0.074486, 0.071970, 0.014652>, <0.286551, 0.432930, -0.209013>, <-0.232738, 0.482418, -0.197046>, <-0.605406, 0.488447, -0.218225>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.207895, -0.517889, -0.193124>, <-0.607664, -0.511421, -0.215843>, 
      <-0.430986, 0.493971, 0.012047>, <-0.232738, 0.482418, -0.197046>, <-0.540227, -0.003169, -0.502966>, <-0.540227, -0.291535, -0.502966>, 
      <-0.803653, 0.500000, -0.009132>, <-0.605406, 0.488447, -0.218225>, <-0.540227, 0.281913, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.093379, 0.402119>, <-0.762256, 0.028941, 0.324145>, <-1.295694, 0.037571, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.762256, 0.311677, 0.324145>, <-1.295694, 0.320308, 0.293830>, 
      <0.074486, 0.071970, 0.014652>, <-0.292883, 0.466696, 0.402119>, <-0.625363, 0.505298, 0.217057>, <-0.998030, 0.511327, 0.195878>, 
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.611165, -0.494389, 0.232208>, <-1.010935, -0.487921, 0.209489>, 
      <-0.430986, 0.493971, 0.012047>, <-0.625363, 0.505298, 0.217057>, <-1.295694, 0.018800, 0.293830>, <-1.295694, -0.263937, 0.293830>, 
      <-0.803653, 0.500000, -0.009132>, <-0.998030, 0.511327, 0.195878>, <-1.295694, 0.320308, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <0.244966, -0.512196, 0.007061>, <-0.154804, -0.505728, -0.015658>, 
      <-0.430986, 0.493971, 0.012047>, <0.217863, 0.488243, 0.005520>, <0.819635, 0.000000, 0.000000>, <0.819635, -0.648907, 0.000000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.154804, 0.494272, -0.015658>, <0.819635, 0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.749134, -0.503420, 0.017060>, <-1.148904, -0.496952, -0.005659>, 
      <-0.430986, 0.493971, 0.012047>, <-0.772953, 0.496989, 0.015486>, <-0.056156, 0.004448, 0.008809>, <-0.056156, -0.337550, 0.008809>, 
      <-0.803653, 0.500000, -0.009132>, <-1.145621, 0.503019, -0.005692>, <-0.056156, 0.349730, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, 0.445288, 0.014652>, <-0.430986, 0.493971, 0.012047>, <-0.803653, 0.500000, -0.009132>, 
      <0.074486, -0.328496, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.430986, 0.493971, -0.493726>, <-0.803653, 0.500000, -0.514905>, 
      <-0.403884, -0.506468, 0.013587>, <-0.403884, -0.506468, -0.492186>, <0.319635, 0.000000, -0.500000>, <0.319635, 0.505773, -0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, -0.514905>, <0.319635, -0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074486, 0.071970, 0.014652>, <0.074486, -0.328496, 0.014652>, <-0.403884, -0.506468, 0.013587>, <-0.803653, -0.500000, -0.009132>, 
      <0.074486, 0.445288, 0.014652>, <0.074486, 0.044821, 0.014652>, <-0.403884, -0.506468, 0.521988>, <-0.803653, -0.500000, 0.499269>, 
      <-0.430986, 0.493971, 0.012047>, <-0.430986, 0.493971, 0.520448>, <0.319635, 0.000000, 0.500000>, <0.319635, -0.508401, 0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, 0.499269>, <0.319635, 0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, -0.284510, -0.527645>, <-0.814946, -0.499342, 0.002778>, <-1.010935, -0.487921, 0.209489>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, -0.291535, -0.502966>, <-0.607664, -0.511421, -0.215843>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.293138, 0.081508, -0.395491>, <-1.419501, 0.088872, -0.262216>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-0.974482, 0.000572, -0.527645>, <-0.974482, 0.288938, -0.527645>, <-0.799782, 0.499775, -0.013214>, <-0.998030, 0.511327, 0.195878>, 
      <-0.540227, -0.006454, -0.502966>, <-0.540227, 0.281913, -0.502966>, <-0.605406, 0.488447, -0.218225>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.437997, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.142124, 0.505476, -0.028367>, <-0.769456, 0.499447, -0.007189>, <0.286551, 0.432930, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, 0.500000, -0.009132>, <-0.430986, 0.493971, 0.012047>, <0.074486, 0.445288, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.718565, 0.106300, 0.053210>, <-1.718565, 0.445360, 0.053210>, <-0.769456, 0.499447, -0.007189>, <-0.430986, 0.493971, 0.012047>, 
      <-1.479178, 0.040540, 0.283402>, <-0.945741, 0.031909, 0.313717>, <-0.292883, 0.466696, 0.402119>, <0.074486, 0.445288, 0.014652>, 
      <-1.295694, 0.037571, 0.293830>, <-0.762256, 0.028941, 0.324145>, <-0.292883, 0.093379, 0.402119>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.974482, 0.288938, -0.527645>, <-0.540227, 0.281913, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.420568, -0.395491>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.479178, 0.323276, 0.283402>, <-1.295694, 0.320308, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.445360, 0.053210>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, -0.280328, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.666555, -0.004410, -0.510145>, <-0.232299, -0.011436, -0.485466>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <0.286551, -0.340855, -0.209013>, <0.286551, 0.059612, -0.209013>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, -0.280328, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-0.945741, 0.031909, 0.313717>, <-0.762256, 0.028941, 0.324145>, 
      <-1.182257, -0.493875, -0.030648>, <-0.782487, -0.500343, -0.007929>, <-0.292883, -0.307088, 0.402119>, <-0.292883, 0.093379, 0.402119>, 
      <-0.803653, -0.500000, -0.009132>, <-0.403884, -0.506468, 0.013587>, <0.074486, -0.328496, 0.014652>, <0.074486, 0.071970, 0.014652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.718565, 0.106300, 0.053210>, <-1.479178, 0.040540, 0.283402>, <-1.295694, 0.037571, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.479178, -0.260968, 0.283402>, <-1.295694, -0.263937, 0.293830>, 
      <-1.592203, 0.098936, -0.080066>, <-1.718565, -0.272964, 0.053210>, <-1.389538, -0.481795, 0.187973>, <-1.010935, -0.487921, 0.209489>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.336500, 0.516803, 0.176643>, <-0.998030, 0.511327, 0.195878>, 
      <-1.182257, -0.493875, -0.030648>, <-1.389538, -0.481795, 0.187973>, <-1.295694, 0.018800, 0.293830>, <-1.295694, 0.320308, 0.293830>, 
      <-0.803653, -0.500000, -0.009132>, <-1.010935, -0.487921, 0.209489>, <-1.295694, -0.263937, 0.293830>, <-1.295694, 0.037571, 0.293830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.293138, 0.081508, -0.395491>, <-0.974482, 0.000572, -0.527645>, <-0.540227, -0.006454, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.974482, -0.284510, -0.527645>, <-0.540227, -0.291535, -0.502966>, 
      <-1.592203, 0.098936, -0.080066>, <-1.293138, -0.297756, -0.395491>, <-0.986268, -0.505296, -0.237359>, <-0.607664, -0.511421, -0.215843>, 
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.943876, 0.493923, -0.237460>, <-0.605406, 0.488447, -0.218225>, 
      <-1.182257, -0.493875, -0.030648>, <-0.986268, -0.505296, -0.237359>, <-0.540227, -0.003169, -0.502966>, <-0.540227, 0.281913, -0.502966>, 
      <-0.803653, -0.500000, -0.009132>, <-0.607664, -0.511421, -0.215843>, <-0.540227, -0.291535, -0.502966>, <-0.540227, -0.006454, -0.502966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.484091, 0.508495, -0.024928>, <-1.145621, 0.503019, -0.005692>, 
      <-1.182257, -0.493875, -0.030648>, <-1.527507, -0.490827, -0.027175>, <-0.056156, 0.004448, 0.008809>, <-0.056156, 0.349730, 0.008809>, 
      <-0.803653, -0.500000, -0.009132>, <-1.148904, -0.496952, -0.005659>, <-0.056156, -0.337550, 0.008809>, <-0.056156, 0.007731, 0.008809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-0.493274, 0.499748, -0.034894>, <-0.154804, 0.494272, -0.015658>, 
      <-1.182257, -0.493875, -0.030648>, <-0.533407, -0.499603, -0.037174>, <0.819635, 0.000000, 0.000000>, <0.819635, 0.648907, 0.000000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.154804, -0.505728, -0.015658>, <0.819635, -0.648907, 0.000000>, <0.819635, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, 0.437997, -0.080066>, <-1.142124, 0.505476, -0.028367>, <-0.803653, 0.500000, -0.009132>, 
      <-1.592203, -0.280328, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.142124, 0.505476, 0.480034>, <-0.803653, 0.500000, 0.499269>, 
      <-1.182257, -0.493875, -0.030648>, <-1.182257, -0.493875, 0.477753>, <0.319635, 0.000000, 0.500000>, <0.319635, 0.508401, 0.500000>, 
      <-0.803653, -0.500000, -0.009132>, <-0.803653, -0.500000, 0.499269>, <0.319635, -0.508401, 0.500000>, <0.319635, 0.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.592203, 0.098936, -0.080066>, <-1.592203, -0.280328, -0.080066>, <-1.182257, -0.493875, -0.030648>, <-0.803653, -0.500000, -0.009132>, 
      <-1.592203, 0.437997, -0.080066>, <-1.592203, 0.058733, -0.080066>, <-1.182257, -0.493875, -0.536421>, <-0.803653, -0.500000, -0.514905>, 
      <-1.142124, 0.505476, -0.028367>, <-1.142124, 0.505476, -0.534141>, <0.319635, 0.000000, -0.500000>, <0.319635, -0.505773, -0.500000>, 
      <-0.803653, 0.500000, -0.009132>, <-0.803653, 0.500000, -0.514905>, <0.319635, 0.505773, -0.500000>, <0.319635, 0.000000, -0.500000>
    }
  }
  material {
    SlateRock
  }
  scale <1.662061, 2.881695, 2.955549>
  rotate 178.060654*z
  translate  <329.440022, -26.488399, -0.556648>
}       

//*************************************** pile of rocks **********************************
union { 
  object { Rock1 }
  object { Rock2 }
  object { Rock3 }
  superellipsoid { // Rock4
    <1.07, 1.12>
    material {
      SlateRock
    }
    scale <1.684803, 2.372131, 0.619022>
    translate  <346.568929, -18.566193, 0.0>
  }
  object { Rock5 }
  object { Rock6 }
  object { Rock7 }
  object { Rock8 }
  object { Rock9 }
  object { Rock10 }
  object { Rock11 }
}


//********************************************** ground *********************************************

box { 
  <-1, -1, -1>, <1, 1, 1>
  material {
    Dirt1
    scale 0.001
  }
  scale <171.806198, 152.285492, 1.0>
  translate  <375.773629, -115.93434, -1.658126>
}


//******************************************** pavers ***********************************************
union { 
  box { // Paver2
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <389.016102, -195.391464, -1.519637>
  }
  box { // Paver3
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <466.889631, -180.05088, -1.519637>
  }
  box { // Paver4
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <404.58159, -179.77717, -1.519637>
  }
  box { // Paver5
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 7.5, 1.5>
    rotate -90.0*z
    translate  <466.98559, -125.049032, -1.519637>
  }
  box { // Paver6
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <482.544646, -164.190123, -1.519637>
  }
  box { // Paver7
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <498.247978, -148.436292, -1.519637>
  }
  box { // Paver10
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <451.378952, -132.816607, -1.519637>
  }
  box { // Paver12
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <427.786292, -187.882454, -1.519637>
  }
  box { // Paver11
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <443.36611, -172.20293, -1.519637>
  }
  box { // Paver13
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <474.73959, -140.697133, -1.519637>
  }
  box { // Paver14
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <459.043761, -156.441879, -1.519637>
  }
  box { // Paver16
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <381.264428, -172.005391, -2.062766>
  }
  box { // Paver17
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <412.356969, -140.680827, -1.519637>
  }
  box { // Paver18
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <381.086271, -234.791678, -1.519637>
  }
  box { // Paver19
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <428.052799, -125.068398, -1.519637>
  }
  box { // Paver20
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <490.567737, -125.052093, -1.519637>
  }
  box { // Paver21
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <396.734937, -218.759824, -1.519637>
  }
  box { // Paver22
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <412.30618, -203.295471, -1.519637>
  }
  box { // Paver15
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <396.711929, -156.293256, -1.519637>
  }
  box { // Paver24
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate <-1.332673, -0.0, -0.0>
    translate  <334.641252, -156.154195, -1.519637>
  }
  box { // Paver23
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <334.170629, -219.04923, -1.519637>
  }
  box { // Paver26
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <349.785937, -203.318269, -1.519637>
  }
  box { // Paver25
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <350.211462, -140.545175, -1.519637>
  }
  box { // Paver27
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <365.632927, -187.615714, -1.519637>
  }
  box { // Paver28
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <365.737273, -125.052093, -1.519637>
  }
  box { // Paver29
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate <0.953582, -0.0, -0.0>
    translate  <318.64, -171.76, -1.245>
  }
  box { // Paver9
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <435.708258, -148.635686, -1.519637>
  }
  box { // Paver30
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -1.998371*x
    translate  <303.212243, -187.760009, -1.519637>
  }
  box { // Paver8
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <420.120928, -163.983499, -1.519637>
  }
  box { // Paver34
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <342.13299, -179.655319, -1.519637>
  }
  box { // Paver32
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <451.077789, -195.862721, -1.519637>
  }
  box { // Paver36
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate <3.6801, 0.0, -90.0>
    translate  <373.259938, -211.122749, -1.299612>
  }
  box { // Paver37
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <373.532353, -148.429071, -1.519637>
  }
  box { // Paver38
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <389.112172, -132.883738, -1.519637>
  }
  box { // Paver35
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate <0.0, -1.400335, -90.0>
    translate  <326.567394, -195.680142, -1.519637>
  }
  box { // Paver39
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 7.5, 1.5>
    rotate -90.0*z
    translate  <404.5833, -125.073343, -1.519637>
  }
  box { // Paver40
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <358.001287, -164.040012, -1.519637>
  }
  box { // Paver41
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <318.956963, -234.785534, -1.519637>
  }
  box { // Paver42
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <264.149955, -133.083789, -1.519637>
  }
  box { // Paver43
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 7.5, 1.5>
    rotate -90.0*z
    translate  <279.975743, -125.133388, -1.519637>
  }
  box { // Paver44
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <247.922524, -211.450979, -1.519637>
  }
  box { // Paver45
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <263.874765, -195.85063, -1.519637>
  }
  box { // Paver33
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <310.964555, -211.392346, -1.519637>
  }
  box { // Paver48
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <311.17548, -148.548802, -1.519637>
  }
  box { // Paver47
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <295.287503, -164.36119, -1.519637>
  }
  box { // Paver50
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 7.5, 1.5>
    rotate <0, -0.9636, -90.0>
    translate  <342.49, -125.063734, -1.69>
  }
  box { // Paver51
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <295.29202, -227.060363, -1.519637>
  }
  box { // Paver52
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <232.642692, -164.509075, -1.519637>
  }
  box { // Paver53
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <240.445402, -125.268358, -1.519637>
  }
  box { // Paver54
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <271.587467, -219.384786, -1.519637>
  }
  box { // Paver55
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <240.377734, -188.102867, -1.519637>
  }
  box { // Paver56
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <256.050269, -172.290479, -1.519637>
  }
  box { // Paver49
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <326.993499, -132.736414, -1.519637>
  }
  box { // Paver58
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <287.753975, -140.801039, -1.519637>
  }
  box { // Paver59
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate <0.689502, 0.0, -0.0>
    translate  <303.640838, -124.988651, -1.519637>
  }
  box { // Paver60
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <287.467523, -203.504729, -1.519637>
  }
  box { // Paver61
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <287.207096, -266.36336, -1.519637>
  }
  box { // Paver62
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <224.444797, -203.635548, -1.519637>
  }
  box { // Paver57
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <271.72732, -156.685613, -1.519637>
  }
  box { // Paver46
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <279.475115, -179.898388, -1.519637>
  }
  box { // Paver31
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <357.62513, -226.805428, -1.519637>
  }
  box { // Paver63
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <240.022948, -250.896048, -1.519637>
  }
  box { // Paver64
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <303.071938, -250.623963, -1.519637>
  }
  box { // Paver65
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <350.056339, -266.156862, -1.519637>
  }
  box { // Paver66
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <365.539438, -250.165376, -1.519637>
  }
  box { // Paver67
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <505.974499, -171.8648, -1.519637>
  }
  box { // Paver68
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <255.715964, -235.008671, -1.519637>
  }
  box { // Paver69
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <490.362513, -187.740338, -1.519637>
  }
  box { // Paver70
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <474.69932, -203.428436, -1.519637>
  }
  box { // Paver71
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <458.901012, -218.983839, -1.519637>
  }
  box { // Paver72
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    translate  <443.512286, -234.460422, -1.519637>
  }
  box { // Paver73
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <248.304641, -148.748119, -1.519637>
  }
  box { // Paver74
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <404.428206, -242.518615, -1.519637>
  }
  box { // Paver75
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <279.343535, -242.889481, -1.519637>
  }
  box { // Paver76
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <388.917146, -258.075533, -1.519637>
  }
  box { // Paver77
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <232.134264, -227.060681, -1.519637>
  }
  box { // Paver78
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <342.178685, -242.555959, -1.519637>
  }
  box { // Paver79
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <326.526908, -258.401408, -1.519637>
  }
  box { // Paver80
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <263.497685, -258.656348, -1.519637>
  }
  box { // Paver81
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <420.090738, -226.638787, -1.519637>
  }
  box { // Paver82
    <-1, -1, -1>, <1, 1, 1>
    scale <15.302051, 7.5, 1.5>
    rotate -90.0*z
    translate  <435.628417, -211.1125, -1.519637>
  }
  material {
    RoughPavers
  }
  translate  <7.232349, 30.658237, 0.019305>
}


//**************************************** Corrugated Iron Sheets *************************************
#declare OldSheetOfIron8 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  49  // control points
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>,
  <14.999872, -0.100348>,
  <18.750074, 1.900387>,
  <22.499661, -0.099478>,
  <26.249525, 1.901714>,
  <30.000401, -0.100235>,
  <33.749647, 1.901163>,
  <37.499886, -0.100622>,
  <41.249593, 1.900444>,
  <45.000361, -0.100055>,
  <48.7498, 1.89985>,
  <52.499632, -0.102168>,
  <56.249301, 1.901452>,
  <59.999756, -0.100461>,
  <63.749075, 1.901533>,
  <67.499741, -0.100621>,
  <71.249597, 1.900752>,
  <75.000033, -0.099882>,
  <78.749779, 1.900467>,
  <82.499613, -0.100467>,
  <86.249616, 2.001712>,
  <82.499121, -0.000048>,
  <78.750012, 2.000259>,
  <75.000188, -0.000579>,
  <71.249976, 2.000243>,
  <67.499295, 0.000116>,
  <63.749826, 2.000174>,
  <59.999121, 0.000899>,
  <56.249806, 2.00093>,
  <52.499702, -0.000043>,
  <48.749961, 1.999948>,
  <44.999314, -0.000059>,
  <41.250484, 2.001107>,
  <37.500052, -0.000717>,
  <33.749185, 2.001442>,
  <29.999799, 0.00124>,
  <26.24993, 1.999975>,
  <22.499932, -0.000036>,
  <18.750389, 2.000585>,
  <15.000113, 0.000386>,
  <11.249268, 1.999838>,
  <7.499888, -0.000052>,
  <3.750031, 2.001056>,
  <0.000314, -0.00047>,
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>
  rotate -x*90
  material {
    NewCorrugatedIron1
    scale 20.0
  }
  scale <1.0, 1.0, 160.0>
  rotate 180.0*z
  translate  <613.612316, 2.539987, 0.0>
}
#declare OldSheetOfIron7 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  49  // control points
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>,
  <14.999872, -0.100348>,
  <18.750074, 1.900387>,
  <22.499661, -0.099478>,
  <26.249525, 1.901714>,
  <30.000401, -0.100235>,
  <33.749647, 1.901163>,
  <37.499886, -0.100622>,
  <41.249593, 1.900444>,
  <45.000361, -0.100055>,
  <48.7498, 1.89985>,
  <52.499632, -0.102168>,
  <56.249301, 1.901452>,
  <59.999756, -0.100461>,
  <63.749075, 1.901533>,
  <67.499741, -0.100621>,
  <71.249597, 1.900752>,
  <75.000033, -0.099882>,
  <78.749779, 1.900467>,
  <82.499613, -0.100467>,
  <86.249616, 2.001712>,
  <82.499121, -0.000048>,
  <78.750012, 2.000259>,
  <75.000188, -0.000579>,
  <71.249976, 2.000243>,
  <67.499295, 0.000116>,
  <63.749826, 2.000174>,
  <59.999121, 0.000899>,
  <56.249806, 2.00093>,
  <52.499702, -0.000043>,
  <48.749961, 1.999948>,
  <44.999314, -0.000059>,
  <41.250484, 2.001107>,
  <37.500052, -0.000717>,
  <33.749185, 2.001442>,
  <29.999799, 0.00124>,
  <26.24993, 1.999975>,
  <22.499932, -0.000036>,
  <18.750389, 2.000585>,
  <15.000113, 0.000386>,
  <11.249268, 1.999838>,
  <7.499888, -0.000052>,
  <3.750031, 2.001056>,
  <0.000314, -0.00047>,
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>
  rotate -x*90
  material {
    NewCorrugatedIron1
    scale 20.0
  }
  scale <1.0, 1.0, 160.0>
  rotate 180.0*z
  translate  <538.61261, 2.439456, 0.0>
}
#declare OldSheetOfIron6 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  49  // control points
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>,
  <14.999872, -0.100348>,
  <18.750074, 1.900387>,
  <22.499661, -0.099478>,
  <26.249525, 1.901714>,
  <30.000401, -0.100235>,
  <33.749647, 1.901163>,
  <37.499886, -0.100622>,
  <41.249593, 1.900444>,
  <45.000361, -0.100055>,
  <48.7498, 1.89985>,
  <52.499632, -0.102168>,
  <56.249301, 1.901452>,
  <59.999756, -0.100461>,
  <63.749075, 1.901533>,
  <67.499741, -0.100621>,
  <71.249597, 1.900752>,
  <75.000033, -0.099882>,
  <78.749779, 1.900467>,
  <82.499613, -0.100467>,
  <86.249616, 2.001712>,
  <82.499121, -0.000048>,
  <78.750012, 2.000259>,
  <75.000188, -0.000579>,
  <71.249976, 2.000243>,
  <67.499295, 0.000116>,
  <63.749826, 2.000174>,
  <59.999121, 0.000899>,
  <56.249806, 2.00093>,
  <52.499702, -0.000043>,
  <48.749961, 1.999948>,
  <44.999314, -0.000059>,
  <41.250484, 2.001107>,
  <37.500052, -0.000717>,
  <33.749185, 2.001442>,
  <29.999799, 0.00124>,
  <26.24993, 1.999975>,
  <22.499932, -0.000036>,
  <18.750389, 2.000585>,
  <15.000113, 0.000386>,
  <11.249268, 1.999838>,
  <7.499888, -0.000052>,
  <3.750031, 2.001056>,
  <0.000314, -0.00047>,
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>
  rotate -x*90
  material {
    NewCorrugatedIron1
    scale 20.0
  }
  scale <1.0, 1.0, 160.0>
  rotate 180.0*z
  translate  <463.613446, 2.339501, 0.0>
}
#declare OldSheetOfIron5 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  49  // control points
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>,
  <14.999872, -0.100348>,
  <18.750074, 1.900387>,
  <22.499661, -0.099478>,
  <26.249525, 1.901714>,
  <30.000401, -0.100235>,
  <33.749647, 1.901163>,
  <37.499886, -0.100622>,
  <41.249593, 1.900444>,
  <45.000361, -0.100055>,
  <48.7498, 1.89985>,
  <52.499632, -0.102168>,
  <56.249301, 1.901452>,
  <59.999756, -0.100461>,
  <63.749075, 1.901533>,
  <67.499741, -0.100621>,
  <71.249597, 1.900752>,
  <75.000033, -0.099882>,
  <78.749779, 1.900467>,
  <82.499613, -0.100467>,
  <86.249616, 2.001712>,
  <82.499121, -0.000048>,
  <78.750012, 2.000259>,
  <75.000188, -0.000579>,
  <71.249976, 2.000243>,
  <67.499295, 0.000116>,
  <63.749826, 2.000174>,
  <59.999121, 0.000899>,
  <56.249806, 2.00093>,
  <52.499702, -0.000043>,
  <48.749961, 1.999948>,
  <44.999314, -0.000059>,
  <41.250484, 2.001107>,
  <37.500052, -0.000717>,
  <33.749185, 2.001442>,
  <29.999799, 0.00124>,
  <26.24993, 1.999975>,
  <22.499932, -0.000036>,
  <18.750389, 2.000585>,
  <15.000113, 0.000386>,
  <11.249268, 1.999838>,
  <7.499888, -0.000052>,
  <3.750031, 2.001056>,
  <0.000314, -0.00047>,
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>
  rotate -x*90
  material {
    NewCorrugatedIron1
    scale 20.0
  }
  scale <1.0, 1.0, 160.0>
  rotate 180.0*z
  translate  <388.613518, 2.239398, 0.0>
}
#declare OldSheetOfIron4 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  49  // control points
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>,
  <14.999872, -0.100348>,
  <18.750074, 1.900387>,
  <22.499661, -0.099478>,
  <26.249525, 1.901714>,
  <30.000401, -0.100235>,
  <33.749647, 1.901163>,
  <37.499886, -0.100622>,
  <41.249593, 1.900444>,
  <45.000361, -0.100055>,
  <48.7498, 1.89985>,
  <52.499632, -0.102168>,
  <56.249301, 1.901452>,
  <59.999756, -0.100461>,
  <63.749075, 1.901533>,
  <67.499741, -0.100621>,
  <71.249597, 1.900752>,
  <75.000033, -0.099882>,
  <78.749779, 1.900467>,
  <82.499613, -0.100467>,
  <86.249616, 2.001712>,
  <82.499121, -0.000048>,
  <78.750012, 2.000259>,
  <75.000188, -0.000579>,
  <71.249976, 2.000243>,
  <67.499295, 0.000116>,
  <63.749826, 2.000174>,
  <59.999121, 0.000899>,
  <56.249806, 2.00093>,
  <52.499702, -0.000043>,
  <48.749961, 1.999948>,
  <44.999314, -0.000059>,
  <41.250484, 2.001107>,
  <37.500052, -0.000717>,
  <33.749185, 2.001442>,
  <29.999799, 0.00124>,
  <26.24993, 1.999975>,
  <22.499932, -0.000036>,
  <18.750389, 2.000585>,
  <15.000113, 0.000386>,
  <11.249268, 1.999838>,
  <7.499888, -0.000052>,
  <3.750031, 2.001056>,
  <0.000314, -0.00047>,
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>
  rotate -x*90
  material {
    NewCorrugatedIron1
    scale 20.0
  }
  scale <1.0, 1.0, 160.0>
  rotate 180.0*z
  translate  <313.61402, 2.140173, 0.0>
}
#declare OldSheetOfIron3 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  49  // control points
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>,
  <14.999872, -0.100348>,
  <18.750074, 1.900387>,
  <22.499661, -0.099478>,
  <26.249525, 1.901714>,
  <30.000401, -0.100235>,
  <33.749647, 1.901163>,
  <37.499886, -0.100622>,
  <41.249593, 1.900444>,
  <45.000361, -0.100055>,
  <48.7498, 1.89985>,
  <52.499632, -0.102168>,
  <56.249301, 1.901452>,
  <59.999756, -0.100461>,
  <63.749075, 1.901533>,
  <67.499741, -0.100621>,
  <71.249597, 1.900752>,
  <75.000033, -0.099882>,
  <78.749779, 1.900467>,
  <82.499613, -0.100467>,
  <86.249616, 2.001712>,
  <82.499121, -0.000048>,
  <78.750012, 2.000259>,
  <75.000188, -0.000579>,
  <71.249976, 2.000243>,
  <67.499295, 0.000116>,
  <63.749826, 2.000174>,
  <59.999121, 0.000899>,
  <56.249806, 2.00093>,
  <52.499702, -0.000043>,
  <48.749961, 1.999948>,
  <44.999314, -0.000059>,
  <41.250484, 2.001107>,
  <37.500052, -0.000717>,
  <33.749185, 2.001442>,
  <29.999799, 0.00124>,
  <26.24993, 1.999975>,
  <22.499932, -0.000036>,
  <18.750389, 2.000585>,
  <15.000113, 0.000386>,
  <11.249268, 1.999838>,
  <7.499888, -0.000052>,
  <3.750031, 2.001056>,
  <0.000314, -0.00047>,
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>
  rotate -x*90
  material {
    NewCorrugatedIron1
    scale 20.0
  }
  scale <1.0, 1.0, 160.0>
  rotate 180.0*z
  translate  <238.614604, 2.04068, 0.0>
} 


//******************************************** permapine post ******************************************
#declare PermapinePost = difference {
  cylinder {
    <0,0,1>, <0,0,0>, 1 
    material {
      Permapine
      scale <2.555141, 2.610682, 1.0>
    }
    scale <5.0, 5.0, 135.0>
    translate  <335.0, -5.0, 0.0>
  }    
  
  // bit to cut out where the bolt goes
  box {
    <-1, -1, -1>, <1, 1, 1>
    material {
      InsidePermapine
      scale <1.0, 1.0, 10.0>
    }
    scale <5.408823, 1.0, 3.22222>
    translate  <335.176357, -10.378082, 37.914032>
  }
  rotate 0.058246*z
  translate  <-19.99999, -0.020332, 0.0>
}


// ********************************* all the fence bits joined together ******************************
// sheets of iron 
union { 
  object { OldSheetOfIron8 }
  object { OldSheetOfIron7 }
  object { OldSheetOfIron6 }
  object { OldSheetOfIron5 }
  object { OldSheetOfIron4 }
  object { OldSheetOfIron3 }       
 
 //top rail
  box { 
    <-1, -1, -1>, <1, 1, 1>
    material {
      ReallyOldWood
      scale <1.0, 0.929087, 1.055717>
    }
    scale <395.0, 2.25, 3.5>
    rotate 0.058246*z
    translate  <395.002083, -1.848446, 123.0>
  }
 
 //bottom rail
  box { 
    <-1, -1, -1>, <1, 1, 1>
    material {
      ReallyOldWood
      scale <1.0, 0.929087, 1.055717>
    }
    scale <395.0, 2.25, 3.5>
    rotate 0.058246*z
    translate  <395.002084, -1.849447, 38.498535>
  }          
  
 //the other permapine post that you can't see anyway
  cylinder { 
    <0,0,1>, <0,0,0>, 1 
    material {
      Permapine
    }
    scale <5.0, 5.0, 135.0>
    rotate 0.058246*z
    translate  <545.004801, -4.445956, 0.0>
  }                     
  
  // the one you can see
  object { PermapinePost }
  rotate -0.058246*z
  translate  <20.0, 0.0, -1.0>
}
                                                                                        
                                                                                        
//************************************* bolt and washer ********************************

#declare Washer = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    NewCorrugatedIron1
  }
  scale <1.404246, 1.404246, 0.1042>
  translate  -0.102088*z
}
#declare FenceBolt = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.495579>,
  <-0.004782, -1.130776>,
  <1.0, -0.495579>,
  <1.0, 0.495579>,
  <-0.001807, 1.087184>,
  <-1.0, 0.508034>,
  <-1.0, -0.495579>
  rotate -x*90
  material {
    NewCorrugatedIron
  }
  scale <0.804777, 0.804777, 0.566535>
  rotate <0.0, -0.0, -30.6231>
}


union {
  object { Washer }
  object { FenceBolt }
  rotate 90.0*x
  translate  <335.038939, -9.498, 38.011415>
}

//********************************************** graffiti **********************************************
#declare SheetOfIron2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  49  // control points
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>,
  <14.999872, -0.100348>,
  <18.750074, 1.900387>,
  <22.499661, -0.099478>,
  <26.249525, 1.901714>,
  <30.000401, -0.100235>,
  <33.749647, 1.901163>,
  <37.499886, -0.100622>,
  <41.249593, 1.900444>,
  <45.000361, -0.100055>,
  <48.7498, 1.89985>,
  <52.499632, -0.102168>,
  <56.249301, 1.901452>,
  <59.999756, -0.100461>,
  <63.749075, 1.901533>,
  <67.499741, -0.100621>,
  <71.249597, 1.900752>,
  <75.000033, -0.099882>,
  <78.749779, 1.900467>,
  <82.499613, -0.100467>,
  <86.249616, 2.001712>,
  <82.499121, -0.000048>,
  <78.750012, 2.000259>,
  <75.000188, -0.000579>,
  <71.249976, 2.000243>,
  <67.499295, 0.000116>,
  <63.749826, 2.000174>,
  <59.999121, 0.000899>,
  <56.249806, 2.00093>,
  <52.499702, -0.000043>,
  <48.749961, 1.999948>,
  <44.999314, -0.000059>,
  <41.250484, 2.001107>,
  <37.500052, -0.000717>,
  <33.749185, 2.001442>,
  <29.999799, 0.00124>,
  <26.24993, 1.999975>,
  <22.499932, -0.000036>,
  <18.750389, 2.000585>,
  <15.000113, 0.000386>,
  <11.249268, 1.999838>,
  <7.499888, -0.000052>,
  <3.750031, 2.001056>,
  <0.000314, -0.00047>,
  <3.749528, 1.900571>,
  <7.499741, -0.099684>,
  <11.248726, 1.901057>
  rotate -x*90
  hollow
  scale <1.0, 1.0, 80.0>
  rotate 180.0*z
  translate  <154.242526, 0.337425, 20.0>
}
#declare BdL = difference {
  text {   // BL
    ttf      "C:\WINDOWS\Fonts\Markp.ttf",
    "B.L",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      OldSprayPaint
    }
    scale <27.949751, 25.639772, 5.945677>
    rotate <90.0, 56.750252, 0.0>
    translate  <109.98573, 1.940546, 73.149328>
  }

  box { // NaughtyWordCuttOffBit
    <-1, -1, -1>, <1, 1, 1>
    scale <12.549893, 3.694975, 13.319887>
    rotate 50.982994*y
    translate  <108.94823, -0.954281, 87.563938>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <350.631125, -0.061067, 2.309979>
}
#declare Words2 = union {
  text {   // 1999
    ttf      "C:\WINDOWS\Fonts\Markp.ttf",
    "'99",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      OldSprayPaint
    }
    scale <24.990997, 24.990997, 5.792594>
    rotate <90.0, 47.790649, 0.0>
    translate  <439.493394, 1.816201, 59.559834>
  }

  object { BdL }
  hollow
  rotate 0.0*z
  translate  <-351.527998, 0.054861, 0.0>
}
intersection { // Graffiti
  object { SheetOfIron2 }
  object { Words2 }
  material {
    OldSprayPaint
  }
  translate  <344.372552, 1.488093, -2.309979>
}

//*********************************************** plant pot ********************************************
#declare Pot = lathe {
  linear_spline
  11  // control points
  <-0.016336, -0.012739>,
  <10.020519, -0.022293>,
  <10.563276, 10.355561>,
  <10.983614, 20.090886>,
  <12.296149, 20.075986>,
  <12.379764, 18.391892>,
  <12.719495, 18.376409>,
  <12.598187, 20.420674>,
  <10.758457, 20.420445>,
  <9.801418, 0.252877>,
  <-0.073483, 0.246344>
  rotate <90,0,90>
  material {
    BlackPlastic
    scale 10.0
  }
}
#declare PotDirt = lathe {
  linear_spline
  4  // control points
  <0.023953, 18.561753>,
  <10.675119, 18.464079>,
  <9.801418, 0.252877>,
  <-0.073483, 0.246344>
  rotate <90,0,90>
  material {
    PotDirtTex
    scale 40.0
  }
  translate  <-0.000067, 0.000105, 0.0>
}
union { // PlantPot
  object { Pot }
  object { PotDirt }
  translate  <473.437912, -37.132385, -0.891068>
}

//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Weeds, plants etc. >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
          
#include "weeds.inc"
#include "moreweeds.inc"



//Thistle weeds in pavers             
object {ThistleWeed1 
        rotate <0, 0, 90>
        translate < 326, -102, 0>
        } 
        
object {ThistleWeed2 
        scale 0.6
        rotate <-20, 0, 180>        
        translate <302, -181, 0>
        }                   
        
object {ThistleWeed1
        scale 0.9
        translate <372, -165,0>
        }                            

//grass weeds in pavers
object { Weed4
         translate <403.9, -196, 0>
        }           
object {Weed1
        scale 0.2
        translate <436, -102, 0>
        }      
object {Weed2
        scale 0.3
        translate <341, -149, -0.6>
        }        
object {Weed3
        scale 0.3
        translate <349, -196, 0>
        }   
        
// medium grass weed in dirt
object { Weed4            
         scale 2  //0.8
         rotate <0, 0, 135>
         translate <390, -37, -0.6>
        }                 

      
//Big grass weeds

object {BigWeed1    
        rotate <10, 10, 0>
        translate <346.8, -12.67, -0.66>
        }       
object {Weed1
        scale <1, 1, 2>
        translate <346.8, -12.67, -2>
        }   
object {BigWeed2    
        rotate <10, 10, -20>
        translate <331.7, -11.5, -2>
        }             
  
            
//random weeds 
#declare Rw1 = seed(13);   
#declare Rw2 = seed(12);
#declare Xmax = 513;
#declare Xmin =250;
#declare Ymax = -5;  
#declare Ymin = -85;  

#declare WeedCount = 0;
#while (WeedCount < 10)  
        
        #declare Xpos =  int((rand(Rw1)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(Rw1)*((Ymax - Ymin-1)+.9999999999))+Ymin);
        #declare RotateZ = int((rand(Rw2)*((360 - 0) + 1)) + 0);
              
        object { Weed3                          
                 scale 0.3    
                 rotate <0, 0, RotateZ>
                 translate  <Xpos, Ypos, -0.5>                     
                }        
                   
        
        #declare Xpos =  int((rand(Rw1)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(Rw1)*((Ymax - Ymin-1)+.9999999999))+Ymin);
        #declare RotateZ = int((rand(Rw2)*((360 - 0) + 1)) + 0);
                
        object { Weed1                          
                 scale 0.2   
                 rotate <0, 0, RotateZ>
                 translate  <Xpos, Ypos, -0.5>                     
                }
                                   
        #declare WeedCount = WeedCount + 1;           
        
#end    


#declare WeedCount = 0;
#while (WeedCount < 10)  
        
        #declare Xpos =  int((rand(Rw1)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(Rw1)*((Ymax - Ymin-1)+.9999999999))+Ymin);
        #declare RotateZ = int((rand(Rw2)*((360 - 0) + 1)) + 0);
                
        object { Weed1                          
                 scale 0.3      
                 rotate <0, 0, RotateZ>
                 translate  <Xpos, Ypos, -0.5>                     
                }        
                   
        #declare WeedCount = WeedCount + 1;           
        
#end                

//lots of little weeds
#declare Rw3 = seed(20);
#declare WeedCount = 0;
#while (WeedCount < 5)  
        
        #declare Xpos =  int((rand(Rw3)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(Rw3)*((Ymax - Ymin-1)+.9999999999))+Ymin);
        #declare RotateZ = int((rand(Rw2)*((360 - 0) + 1)) + 0);
                
        object { Weed1                          
                 scale 0.4
                 rotate <0, 0, RotateZ>
                 translate  <Xpos, Ypos, -0.5>                     
                }        
                   
        #declare WeedCount = WeedCount + 1;           
        
#end    



           
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< lots of little random dirt rocks >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 
#declare RockCount = 1;
#declare R1 = seed(0);                                                     

#declare Ymax = -5;
#declare Ymin = -85;
#declare Xmax = 530;
#declare Xmin = 250;

#while (RockCount < 11)          
        #declare Xpos =  int((rand(R1)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(R1)*((Ymax - Ymin-1)+.9999999999))+Ymin);        
        
        object { DirtRock7  
                rotate < 0, 0, RockCount * 30 >
                translate < Xpos, Ypos, -0.5>                   
                }

         #declare RockCount = RockCount + 1;
        
#end    


#declare RockCount = 1
#while (RockCount < 11)        
        #declare Xpos =  int((rand(R1)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(R1)*((Ymax - Ymin-1)+.9999999999))+Ymin);        
        
        object { DirtRock7  
                rotate < 0, 0, RockCount * 30 >
                scale 0.5
                translate < Xpos, Ypos, -0.5>                   
                }
                   
        #declare RockCount = RockCount + 1;
        
#end

//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< lots and lots and lots of random little round rocks >>>>>>>>>>>>>>>>>>>>>                                            
#declare R2 = seed(1);
#declare RockCount = 0;
#while (RockCount < 1000)  
        
        #declare Xpos =  int((rand(R2)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(R2)*((Ymax - Ymin-1)+.9999999999))+Ymin);
        
        sphere { <Xpos, Ypos, -0.67>, 0.4
                material { Dirt1 }   }        
                   
        #declare RockCount = RockCount + 1;
        
#end        
      
#declare RockCount = 0;           
#while (RockCount < 30)  
        
        #declare Xpos =  int((rand(R2)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(R2)*((Ymax - Ymin-1)+.9999999999))+Ymin);
        
        sphere { <Xpos, Ypos, -0.66>, 0.7   
                 scale <1, 1, 0.8>
                material { Dirt1 }   }        
                   
        #declare RockCount = RockCount + 1;
        
#end                        
                      
                      
                      
#declare RockCount = 0;
#while (RockCount < 30)  
        
        #declare Xpos =  int((rand(R2)*((Xmax-Xmin-1)+.9999999999))+Xmin);
        #declare Ypos =  int((rand(R2)*((Ymax - Ymin-1)+.9999999999))+Ymin);
        
        sphere { <Xpos, Ypos, -0.86>, 1
                 scale <1, 1, 0.6>
                 material { Dirt1 }   }        
                   
        #declare RockCount = RockCount + 1;
        
#end


//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< smoke packet rubbish >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

#include "smokepacket.inc"
         
object {SmokePacket 
        rotate <0, 0, 30>
        translate<320, -200, 0.0>
        }       
         

//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< beer bottles >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

#include "bottle.inc"

object { Bottle       //bottle in plant pot lying down
        rotate <-75, 0, -90>
        translate <472, -37, 17>
        }
        

object { Bottle   //bottle in plant pot standing up   
        rotate <10, 0, 0>
        translate <470, -30, 10>
        }

object { Bottle    //bottle in plant pot upside down
        rotate <180, 0, -90>
        translate <477, -32, 26 >
        }
        
        
object { Bottle    //bottle on ground
        rotate <90, 180, 0>
        translate <460, -36, 2 >
        }


/*************************************** paper *********************************************************/
#include"rubbish.inc"

object { PaperRubbish  
           rotate <90, 0, 90>
           scale 8                     
           translate<360, -40, -1>
        }
 
 
  /*************************************** ball ********************************************************/
 
 #include "ball.inc"
 
 object { Ball   
        scale 2
        translate < 430, -80, 6 >
        }
 
 
 /**************************************** broom ******************************************************/       
 /*
 #include "broom.inc"
 
  object { Broom 
          rotate <0, 0, 135>
          translate < 350, -140, 0 >
          }
   */        
/************************************** fog ***********************************************************/
  fog {
    fog_type 1 // 1=constant, 2=ground_fog
    distance 150     
    color rgbt<0.8, 0.8, 0.8, 0.95>    
    turbulence 0.2
    turb_depth 0.3

// omega OMEGA
// lambda LAMBDA
// octaves OCTAVES
// fog_offset FOG_OFFSET
// fog_alt FOG_ALT
  }
  