//Leafy plants include

#debug ".leafies.inc\n"

#declare redleaf = sphere {
	0, 1
	scale <2, 1.5, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.7>, <0, 0, -1.1>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "coleus2.tga"
				once
			}
		}
		finish {
			ambient 0.2
			diffuse 0.8
		}
		normal {
			bump_map {
				tga "coleus2.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*50
	translate <0, -0.4, 1>
}

#declare yellowleaf = sphere {
	0, 1
	scale <2, 1.5, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.7>, <0, 0, -1.1>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "coleus1.tga"
				once
			}
		}
		finish {
			ambient 0.2
			diffuse 0.8
		}
		normal {
			bump_map {
				tga "coleus1.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*50
	translate <0, -0.4, 1>
}

#macro leafy (plantheight, randomness, startrad, leafcolor)

#local points = int(plantheight*1.5);
#local stemspline = spline {
	cubic_spline
	0, <0, 0, 0>
	#local counter = 1;
	#while (counter <= points)
	counter/points, <0,(plantheight*(counter/points)),0>+<rand(r1)*randomness, rand(r1)*randomness, rand(r1)*randomness>
	#local counter = counter + 1;
	#end
}

blob {
threshold 0.6
#local counter = 0;
#while (counter <= 1)
sphere {
	0, (1.5-counter)*startrad, 1
	scale <1, 5, 1>
	translate stemspline(counter)
}
#local counter = counter + (0.1/points);
#end
#ifndef(zbuffer)
texture { stemtexture }
#end
}

#local counter = 0;
#while(counter <= 1)
union {
object {
	#switch(leafcolor)
	#case(rouge)
	redleaf
	#break;
	#case(yellow)
	yellowleaf
	#break;
	#end
	rotate x*(20-(counter*20))
}
object {
	#switch(leafcolor)
	#case(rouge)
	redleaf
	#break;
	#case(yellow)
	yellowleaf
	#break;
	#end
	rotate x*(20-(counter*20))
	rotate y*90
}
object {
	#switch(leafcolor)
	#case(rouge)
	redleaf
	#break;
	#case(yellow)
	yellowleaf
	#break;
	#end
	rotate x*(20-(counter*20))
	rotate y*180
}
object {
	#switch(leafcolor)
	#case(rouge)
	redleaf
	#break;
	#case(yellow)
	yellowleaf
	#break;
	#end
	rotate x*(20-(counter*20))
	rotate y*270
}
scale 0.7-(counter*0.4)
rotate y*rand(r1)*360
translate stemspline(counter)
}
#local counter = counter + (1/(plantheight*4));
#end

#end


//Make some leafies

#declare counter = -14;
#while (counter <= -8)
union {
leafy(0.6+(rand(r1)*0.4), 0.2+(rand(r1)*0.2), 0.03, rouge)
translate <-3.3+((rand(r1)-0.5)*0.3), -0.05, counter>
}
union {
leafy(0.6+(rand(r1)*0.4), 0.2+(rand(r1)*0.2), 0.03, yellow)
translate <-3.3+((rand(r1)-0.5)*0.3), -0.05, counter+1>
}
union {
leafy(0.6+(rand(r1)*0.4), 0.2+(rand(r1)*0.2), 0.03, yellow)
translate <3.3+((rand(r1)-0.5)*0.3), -0.05, counter>
}
union {
leafy(0.6+(rand(r1)*0.4), 0.2+(rand(r1)*0.2), 0.03, rouge)
translate <3.3+((rand(r1)-0.5)*0.3), -0.05, counter+1>
}
#declare counter = counter + 2;
#end