#debug ".fountain.inc\n"

#declare stillwatertexture = texture {
	pigment {
		color rgbt<0.3, 0.35, 0.55, 0.4>
	}
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.7
		specular 5
		roughness 0.05
		reflection 0.3
	}
	#else
	finish {
		ambient 0.3
		diffuse 0.7
		specular 5
		roughness 0.05
		reflection 0.3
	}
	#end
	normal {
		crackle 0.5
		scale 0.2
		turbulence 0.3
	}
}


#declare fallingwatertexture = texture {
	pigment {
		color rgbt<0.95, 0.96, 1, 0.9>
	}
	finish {
		ambient 0.5
		diffuse 0.5
		specular 0.6
		roughness 0.02
	}
}

/*
#declare fallingwatertexture = texture {
	pigment { color rgb 1 }
}
*/

#declare fountainbody = union {
lathe {
	quadratic_spline
	52,
	<-0.5, 0.1>, <0, 0.1>, <1.2, 0>, <1.3, 0.1>, <0.7, 0.3>,
	<0.3, 0.6>, <0.35, 0.7>, <0.3, 0.8>, <0.35, 0.9>, <0.3, 1.0>, <0.4, 1.1>,
	<0.7, 1.3>, <1.2, 1.5>, <1.7, 1.7>, <1.9, 2.0>,
	<1.8, 2.0>, <1.5, 1.8>, <1.0, 1.6>, <0.5, 1.6>, <0.4, 1.8>, <0.3, 2.0>,
	<0.35, 2.1>, <0.28, 2.2>, <0.33, 2.3>, <0.25, 2.4>, <0.3, 2.5>, <0.25, 2.6>,
	<0.3, 2.7>, <0.28, 2.8>, <0.33, 2.9>, <0.5, 3.0>, <1.1, 3.2>,
	<1.2, 3.3>, <1.1, 3.3>, <1.0, 3.2>, <0.5, 3.0>, <0.3, 3.2>, <0.25, 3.3>,
	<0.2, 3.4>, <0.25, 3.5>, <0.2, 3.6>, <0.25, 3.7>, <0.22, 3.8>, <0.28, 3.9>,
	<0.4, 4.0>, <0.8, 4.1>, <0.9, 4.2>, <0.8, 4.2>, <0.7, 4.1>,
	<0.3, 4.0>, <0.0, 4.0>, <-0.5, 4.0>
}
difference {
sphere {
	<0, 4.3, 0>, 0.33
}
cylinder {
	<0, 4.8, 0>, <0, 3.7, 0>, 0.1
}
}
#ifndef(zbuffer)
texture {
	pigment {
		color rgb<0.6, 0.58, 0.52>
	}
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.85
		specular 0.08
		roughness 0.2
	}
	#else
	finish {
		ambient 0.2
		diffuse 0.95
		specular 0.08
		roughness 0.2
	}
	#end
	normal {
		average
		normal_map {
			#declare normalcount = 1;
			#while (normalcount < 10)
			[ 1 bozo 5 scale 0.1/normalcount ]
			#declare normalcount = normalcount + 1;
			#end
		}
	}
}
#end
}

//Water

#declare stillwater = union {
disc {
	<0, 1.98, 0>, y, 1.85
	texture { stillwatertexture }
}
disc {
	<0, 3.29, 0>, y, 1.15
	texture { stillwatertexture }
}
disc {
	<0, 4.19, 0>, y, 0.85
	texture { stillwatertexture }
}
}

//Falling Water

#declare r2 = seed(19);

#declare fallingwater =
blob {
threshold 0.6

//Bubbling at Top
#declare number = 0;
#while (number < 40)
#declare staticrand = rand(r2);
#declare number2 = -10;
#while (number2 < 90)
sphere {
	<0, 0.4, 0>, 0.07+(rand(r1)*0.03), 1
	rotate z*number2
	rotate y*staticrand*360
	translate y*4.3
}
#declare number2 = number2 + 3;
#end
#declare number = number + 1;
#end

//Upper Fountain
#declare number = 0;
#while (number < 100)
#declare staticrand = rand(r2);
#declare number2 = -10;
#declare scalefactor = 0;
#while (number2 < 90)
sphere {
	<0, 0.9, 0>, 0.08+(rand(r1)*0.03)+scalefactor, 1
	rotate z*number2
	scale <0.2, 1, 1>
	translate x*-0.95
	rotate y*staticrand*360
	translate y*3.25
}
#declare number2 = number2 + 3;
#declare scalefactor = scalefactor - 0.0012;
#end
#declare number = number + 1;
#end

//Lower Fountain
#declare number = 0;
#while (number < 120)
#declare staticrand = rand(r2);
#declare number2 = -10;
#declare scalefactor = 0;
#while (number2 < 90)
sphere {
	<0, 1.4, 0>, 0.1+(rand(r1)*0.04)+scalefactor, 1
	rotate z*number2
	scale <0.2, 1, 1>
	translate x*-1.25
	rotate y*staticrand*360
	translate y*1.9
}
#declare number2 = number2 + 2;
#declare scalefactor = scalefactor - 0.001;
#end
#declare number = number + 1;
#end

texture { fallingwatertexture }
interior { ior 1.33 }
photons { reflection off refraction off }
}

/*
#declare froth = union {
#declare counter = 0;
#declare detail = 50;
#while (counter < detail)
sphere {
	0, 0.05
	translate <(rand(r1)-0.5)*0.4, rand(r1)*1.2, 1.7+(rand(r1)*0.3)>
	rotate y*rand(r1)*360
	translate y*1.98
	texture { fallingwatertexture }
}
#declare counter = counter + 1;
#end
}
*/

#declare fountain = union {
object { fountainbody }
object { stillwater }
object { fallingwater }
}

object { fountain }