/* Fence include file */

#debug ".fence.inc\n"

#declare whitepaint = texture {
	pigment {
		color rgb 0.9
	}
	finish {
		ambient 0.1
		diffuse 0.7
		specular 0.3
		roughness 0.1
		metallic
		reflection 0.1
	}
	normal {
		average
		normal_map {
			[ 1 bozo 2 scale <0.02, 0.2, 0.02> ]
			[ 1 bozo 2 scale <0.02, 0.2, 0.02>*0.75 ]
			[ 1 bozo 2 scale <0.02, 0.2, 0.02>*0.5 ]
		}
	}
}

#declare basicfencepost = difference {
box {
	<0.06, 3, 0.04>, <-0.06, 0, 0>
}
box {
	<0.2, 1, 0.2>, <0, 0, -0.1>
	rotate z*10
	translate <0.1, 2.5, 0>
}
box {
	<0, 1, 0.2>, <-0.2, 0, -0.1>
	rotate z*-10
	translate <-0.1, 2.5, 0>
}
box {
	1, -1
	rotate z*45
	scale <0.03, 0.10, 0.1>
	translate <0, 2.6, 0>
}
box {
	1, -1
	rotate z*45
	scale <0.02, 0.04, 0.1>
	translate <0, 2.75, 0>
}
box {
	1, -1
	rotate z*45
	scale <0.02, 0.04, 0.1>
	translate <0, 2.45, 0>
}
texture { whitepaint }
}

#declare lcomponent = difference {
superellipsoid {
	<0.2, 0.2>
	scale <0.15, 0.52, 0.15>
	translate y*0.5
}
cylinder {
	<0.15, 0.8, 0.15>, <0.15, 0.2, 0.15>, 0.07
}
sphere {
	<0.15, 0.8, 0.15>, 0.07
}
sphere {
	<0.15, 0.2, 0.15>, 0.07
}
cylinder {
	<0.15, 0.8, -0.15>, <0.15, 0.2, -0.15>, 0.07
}
sphere {
	<0.15, 0.8, -0.15>, 0.07
}
sphere {
	<0.15, 0.2, -0.15>, 0.07
}
cylinder {
	<-0.15, 0.8, 0.15>, <-0.15, 0.2, 0.15>, 0.07
}
sphere {
	<-0.15, 0.8, 0.15>, 0.07
}
sphere {
	<-0.15, 0.2, 0.15>, 0.07
}
cylinder {
	<-0.15, 0.8, -0.15>, <-0.15, 0.2, -0.15>, 0.07
}
sphere {
	<-0.15, 0.8, -0.15>, 0.07
}
sphere {
	<-0.15, 0.2, -0.15>, 0.07
}
}

#declare ornamentalend = blob {
	threshold 0.6
	#declare counter = 0;
	#while (counter < 360)
	sphere {
		<0, 0.3, 0>, 0.08, 1
		rotate x*counter
		translate x*0.1
	}
	#declare counter = counter + 15;
	#end
	#declare counter = 0;
	#while (counter < 360)
	sphere {
		<0, 0.3, 0>, 0.08, 1
		rotate x*counter
		translate x*-0.1
	}
	#declare counter = counter + 15;
	#end
	#declare counter = 0;
	#while (counter < 360)
	sphere {
		<0, 0.3, 0>, 0.08, 1
		rotate z*counter
		translate z*0.1
	}
	#declare counter = counter + 15;
	#end
	#declare counter = 0;
	#while (counter < 360)
	sphere {
		<0, 0.3, 0>, 0.08, 1
		rotate z*counter
		translate z*-0.1
	}
	#declare counter = counter + 15;
	#end
	#declare counter = 0;
	#while (counter < 360)
	sphere {
		<0.3, 0, 0>, 0.08, 1
		rotate y*counter
		translate y*0.1
	}
	#declare counter = counter + 15;
	#end
	#declare counter = 0;
	#while (counter < 360)
	sphere {
		<0.3, 0, 0>, 0.08, 1
		rotate y*counter
		translate y*-0.1
	}
	#declare counter = counter + 15;
	#end
}

#declare largefencepost = union {
object { lcomponent scale <1.3, 1, 1.3> }
object { lcomponent scale <1.2, 1, 1.2> translate y*1 }
object { lcomponent scale <1.1, 1, 1.1> translate y*2 }
object { lcomponent translate y*3 }
object { ornamentalend translate y*4.35 }
texture { whitepaint }
}

#declare fenceunit = union {
object { basicfencepost translate <-0.5, -0.7, 0> }
object { basicfencepost translate <0, -0.8, 0> }
object { basicfencepost translate <0.5, -0.7, 0> }
object { basicfencepost translate <1, -0.6, 0> }
}

#declare unitcount = 0;
#while (unitcount < 4)
object { fenceunit translate <-7-(unitcount*2), -0.5, 2.5> }
#declare unitcount = unitcount + 1;
#end

#declare unitcount = 0;
#while (unitcount < 4)
object { fenceunit translate <6.5+(unitcount*2), -0.5, 2.5> }
#declare unitcount = unitcount + 1;
#end

box {
	<-6, 1.06, 2.58>, <-15, 0.94, 2.54>
	texture { whitepaint rotate z*90 }
}

box {
	<15, 1.06, 2.58>, <6, 0.94, 2.54>
	texture { whitepaint rotate z*90 }
}

object { largefencepost
	rotate y*-30
	translate z*5.5
	rotate y*30
}

object { largefencepost
	rotate y*30
	translate z*5.5
	rotate y*-30
}

//End of file