#include "colors.inc"
#include "textures.inc"
#include "metals.inc"


camera
{
  location <0.0, 0.0, -10.0>
  look_at <0.0, 0.0, 0.0>
}

light_source
{
  <0.0, 20.0, -50.0>
  color rgb <2.0, 2.0, 2.0>
  /*spotlight
  point_at <0.0, 0.0, 0.0>
  radius 4.0
  tightness 0.5
  falloff 5.5*/
}

box
{
  <-8.0, -6.0, 0.0>
  <8.0, 6.0, 0.001>
  texture
  {
    pigment
    {
      image_map
      {
        tga "MCDO.tga"
        map_type 0
        interpolate 2
        once
      }
    }
    scale <16.0, 12.0, 1.0>
    translate <-8.0, -6.0, 0.0>
  }
  scale <0.83, 0.83, 1.0>
}

#include "title.pov"

#declare LargeurFlaque = 3.5
#declare HauteurFlaque = 0.04

difference
{
  blob
  {
    #declare NSPHERE = 200
    #declare COUNT = 1
    #declare R1 = seed(100)
    #declare R2 = seed(101)
    #declare R3 = seed(102)
    threshold 0.3
    #while (COUNT<NSPHERE)
      #declare X = LargeurFlaque*(rand(R1)-0.5)*cos(pi*rand(R2))
      #declare Y = LargeurFlaque*(rand(R1)-0.5)*sin(pi*rand(R2))
      #declare Z = 10.0*HauteurFlaque*0.5*(1.0+rand(R3))
      sphere { <X, Y, 0.0>, Z, 1.0 }
      #declare COUNT = COUNT+1
    #end
    sturm
    scale <1.0, 1.0, 0.3>
  }
  box { <-LargeurFlaque, -LargeurFlaque, HauteurFlaque> <LargeurFlaque, LargeurFlaque, 5.0*HauteurFlaque> }
  texture
  {
    pigment { rgbf <1.0, 0.0, 0.0, 0.8> }
    finish
    {
      ambient 0.0
      diffuse 0.0
      reflection 0.25
      refraction 1.0
      ior 1.33
      specular 1.0
      roughness 0.001
      fade_distance 5.0
      fade_power 1.0
    }
  }
  translate <4.2, 3.5, 0.0>
}


text
{
  ttf "c:\WINDOWS\FONTS\TIMES.TTF"
  "- Soon In Your Plate -"
  0.1, 0.0
  texture
  {
    pigment { Gray }
    finish { reflection 0.3 }
  }
  scale <0.35, 0.35, 1.0>
  translate <-1.6, -4.8, 0.0>
}
