// A blue fireplug
// Created for the IRTC topic "Landmarks"
// By Mark Wagner 8/99
// I did this just because

// Uses Chris Colefax's Link Include File
// Flowers based on those in Derek Owens's Plants Include Files

//Must be rendered with -UR or Remove_Bounds=off

//#version 3.1; //For use in UVPov 5.4
#declare included = true;

#include "colors.inc"
#include "stones.inc"
#include "textures.inc"
#include "Fdefines.inc"
#include "dalmatin.inc"
#include "plants.inc"
                      
//Standard cameras
#declare top1 = camera{
	location y*100
	look_at 0
	angle 30
}
#declare top2 = camera{
	location y*50
	look_at <0,0,-17>
	angle 25
}

#declare camera1 = camera{
	location <15,10,14>
	look_at <0,0,0>
	angle 20
}

#declare camera2 = camera{
	location <20,10,13>
	look_at <0,0,0>
}

#declare cam3 = camera{
	location <10,30,10>
	look_at <-10,0,-30>
}

#declare sidecam1 = camera{
	location y*3+x*-6
	look_at <-6,3,-17>
	angle 45
}

#declare plugcam1 = camera{
	location <20,10,13>
	look_at <0,1,-16>
}
#declare plugcam2 = camera{
	location <10,5,6.5>
	look_at <-2,1,-16>
	angle 25
}

#declare phd = .6;
global_settings{ 
	number_of_waves 1
/*	photons{
		gather 20, 100
		radius 0.1*phd, 2, 0.1*phd
		autostop 0
		jitter .4
		expand_thresholds 0.2, 40
	}*/
}

//light_source{ y*100000000 White rotate x*50 rotate y*108 }

light_source{ y*100000000 White rotate x*30 rotate y*340 }
light_source{ <0,20,-50> rgb .4 } //fill light for side of house -- simulates diffuse interreflection from house next door
plane{ y,.601 bounded_by{ box{ <-.1,19.9,-50.1>,<.1,20.1,-49.9> } } } //Keep fill light from hitting ground
plane{ z,-42 bounded_by{ box{ <-.1,19.9,-50.1>,<.1,20.1,-49.9> } } } //Keep fill light from hitting foreground objects
//Scene settings
camera{ plugcam2 }
#declare Plug = on;		//Show the fireplug
#declare TheDog = on;	//Show the dog
#declare Street = on;	//Show the street
#declare Sidewalk = on;	//Show sidewalk
#declare Grass = on;	//Show grass
#declare Plants = on;	//Show other plants
#declare House = on;	//Show the house
#declare Normals = on;	//Turn some normals off for speed

//plane{ y, 0 pigment{ Green } }

sky_sphere{ pigment{ SummerSky } }
plane{ y,5000 pigment{P_Cloud1 scale 10000} finish{ambient 1 diffuse 2} hollow no_shadow }

//The blue fireplug           
#declare Bolt1 = union{
	cylinder{ y*-.2, y*.1, .04 }
	prism{
		linear_spline
		linear_sweep
		.1,.15,7,
		<.075,0>,<.035,.07>,<-.035,.07>,
		<-.075,0>,<-.035,-.07>,<.035,-.07>,<.075,0>
	}
	prism{
		linear_spline
		linear_sweep
		-.15,-.1,7,
		<.075,0>,<.035,.07>,<-.035,.07>,
		<-.075,0>,<-.035,-.07>,<.035,-.07>,<.075,0>
		rotate y*25
	}
}

#declare Cap1 = union{
	cylinder{ <.3,1.65,0>,<.5,1.65,0>,.2 }
	cylinder{ <.51,1.65,0>,<.52,1.65,0>,.25 }
	cylinder{ <.52,1.65,0>,<.6,1.65,0>,.225 }
	intersection{
		torus{ .125,.1 }
		box{ <-.4,0,-.4>,<.4,.2,.4> }
		rotate z*-90
		translate y*1.65+x*.6
	}
	cylinder{ <.6,1.65,0>,<.7,1.65,0>,.125 }
	cylinder{ <.7,1.65,0>,<.75,1.65,0>,.1}
	box{ <.75,1.61,-.04>,<.82,1.69,.04> }
}

#declare fillet1 = difference{ //Fillet on base
	cylinder{ 0, y*-.1, .45 } 
	torus{ .45,.05 }	
}


#declare Fireplug = union{
	superellipsoid{ <1, .1> rotate x*90 scale <.55,.1,.55> translate y*.08 } //Base
	object{ fillet1 translate y*.23 }
	//Bolts holding base onto water pipe
	#declare counter = 0;
	#while( counter < 10 )
		object{ Bolt1 rotate y*rand(0)*60 translate x*.48+y*.08 rotate y*counter*36 }
		#declare counter = counter + 1;
	#end 
	difference{
		cylinder{ y*.15,y*1.2, .4 }
		#declare num = 12;
		#declare counter = 0;
		#while( counter < 360 )
			cylinder{ y*.25, y*1.15, .013 translate x*.4 rotate y*counter }
			#declare counter = counter + (360/num);
		#end
	}
	object{ fillet1 scale <1,-1,1> translate y*1.15 }
	superellipsoid{ <1, .1> rotate x*90 scale <.55,.05,.55> translate y*1.25 } //Connector
	superellipsoid{ <1, .1> rotate x*90 scale <.55,.05,.55> translate y*1.15 } //Connector
	object{ fillet1 translate y*1.35 }
	//Bolts holding top to base
	#declare counter = 0;
	#while( counter < 10 )
		object{ Bolt1 rotate y*rand(0)*60 translate x*.48+y*1.2 rotate y*counter*36 }
		#declare counter = counter + 1;
	#end 
	difference{ //Fillet on base
		cylinder{ 0, y*-.1, .45 } 
		torus{ .45,.05 }
		translate y*.23
	}
	difference{ //Top
		union{
			cylinder{ y*1.3, y*1.9, .4 }
			cylinder{ y*1.9,y*2.1, .2 }
			torus{ .2,.2 translate y*1.9 }
		}
		#declare counter = 0;
		#while(counter < 360)
			cylinder{ y*1.6, y*2, .013 translate x*.4 rotate y*counter }
			intersection{
				torus{.49,.03}
				box{ y*.1,<.5,-.1,.5>}
				rotate x*-90
				translate y*1.7
				rotate y*counter
			}
			#declare counter = counter + (360/num);
		#end				
	}
	cylinder{y*2.1,y*2.15,.1} //Valve
	box{ <-.04,2.15,-.04>,<.04,2.23,.04> rotate y*17 }
	object{Cap1}
	object{Cap1 scale <-1,1,1>}
}

#if(Plug)
	//Blue fire hydrant in middle of block
	object{ Fireplug 
//		pigment{ rgb <0,.1,1> }
		//Red original paint
		texture{
			pigment{ rgb <1,0,0> }
			finish{
				diffuse .85
				ambient .25
				specular .3
			}
		}
		//Blue spraypaint
		texture{
			pigment{
				gradient y
				turbulence <.2,.3,.2>
				color_map{
					[0.0 rgbt <1,1,1,1>]
					[.15 rgbt <1,1,1,1>]
					[.25 rgb  <0,.1,1>]
				}
			scale <1,4,1>
			}
			normal{
				crackle .03
				scale .05
			}
			finish{
				diffuse .75
				ambient .10
				phong .1
				phong_size 2
				specular .05
				roughness .02
				reflection .05
			}
			translate y*-.8
		}
		scale <.92,1,.92>
		translate z*-16+y*.3 
	}
#end

//Street
#if(Street)
	union{
	box{ <-500,-.4,-13>,<500,0,13>}
	cylinder{ <-500,-.1,-13>,<500,-.1,-13>,.1}
	pigment{
		gradient z
		color_map{
			[0 rgb .3]
			[(1/120)*10.0 rgb .3]
			[(1/120)*10.0 rgb 2]
			[(1/120)*11.5 rgb 2]
			[(1/120)*11.5 rgb .3]
			[(1/120)*58.5 rgb .3]
			[(1/120)*58.5 rgb <1,1,0>]
			[(1/120)*59.5 rgb <1,1,0>]
			[(1/120)*59.5 rgb .3]
			[(1/120)*60.5 rgb .3]
			[(1/120)*60.5 rgb <1,1,0>]
			[(1/120)*61.5 rgb <1,1,0>]
			[(1/120)*61.5 rgb .3]			
			[(1/120)*109.5 rgb .3]
			[(1/120)*109.5 rgb 2]
			[(1/120)*111.0 rgb 2]
			[(1/120)*111.0 rgb .3]
		}
		scale 30
		translate z*-15 //center
	}
	#if(Normals)
	normal{
		crackle .3
		scale .05
	}
	#end
	finish{
		ambient 0
		diffuse .3
	}
}
#end

//The sidewalks
#if(Sidewalk)
	#declare Walk = union{
		//Far-off, low-detail sidewalk
		box{ <-500,0,17>,<-52.5,.4,21> }
		box{ <500,0,17>,<52.5,.4,21> }
		
		//Close-up, detailed sidewalk
		#declare counter = -50;
		#while(counter <= 50)
			box{ <-2.48,0,17>,<2.48,.4,21> translate x*counter }
			#declare counter = counter + 5;
		#end
		
		//Far-off, low-detail curb
		box{ <-500,-.4,15>,<-60,.4,14.6> }
		box{ <500,-.4,15>,<60,.4,14.6> }

		//High-res curb
		#declare counter = -50;
		#while(counter <= 50)
			superellipsoid{ <.05,.05> scale <10,.4,.2> translate x*counter+z*14.8 }
			#declare counter = counter + 20;
		#end
		//Gutter (with gap for drain)
		box{ <-500,-.4,13>,<-4,-.1,15> }
		box{ <500,-.4,13>,<-2.5,-.1,15> }
		difference{ 
			box{ <-500,-.1,14.6>,<500,0,14.5>}
			cylinder{ <-501,0,14.5>,<501,0,14.5>,.1}
			box{ <-4,-.5,13>,<-2.5,0,15> }
		}
		//Storm drain
		difference{
			box{ <-4,-.2,13>,<-2.5,-.105,14.6> }
			#declare counter = 13.125;
			#while( counter < 14.6 )
				union{
					cylinder{ <-2.75,-.21,0>,<-2.75,-.09,0>,.0625}
					cylinder{ <-3.75,-.21,0>,<-3.75,-.09,0>,.0625}
					box{ <-2.75,-.21,-.0625>,<-3.75,-.09,.0625>}
					translate z*counter
				}
				#declare counter = counter + .25;
			#end
			texture{RustedIron}
		}
		texture{Concrete1 scale .03}
	}
	
	object{ Walk }
	object{ Walk scale <1,1,-1> }

#end

#if(Grass)
	#declare GrassBatch = union{
		//Far-off, faked grass
		box{ <-500,0,0>,<-51,.5,2> /*pigment{Jade}*/ }
		box{ <500,0,0>,<51,.5,2> /*pigment{Jade}*/ }
		//Realistic grass
		union{
			#declare counter = -50;
			#while(counter <= 50)
				object{GrassSquare translate x*counter+y*.25 }
				object{GrassSquare translate z*1+x*counter+y*.25 }
				#declare counter = counter + 1;
			#end
//			pigment{ Jade rotate y*45}	

/*			finish{
				ambient .4
				diffuse 0
			}*/
		}
	}
	union{
		//Grass near street
//		object{GrassBatch translate z*15 }
		object{GrassBatch translate z*-17}
		//Front lawn
		#declare counter = -23;
		#while(counter > -40)
			object{GrassBatch translate z*counter}	
			#declare counter = counter - 1;
		#end
		//Side lawn
		#declare counter = -40;
		#while(counter > -60)
		    #declare counter2 = -5;
		    #while(counter2 < 5)
		    	object{GrassSquare translate x*counter2+z*counter+y*.25}
		    	#declare counter2 = counter2 + 1;
		    #end
			#declare counter = counter - 1;
		#end
		texture{GrassText}
	}
#end

#if(TheDog) 
	union{
		//The dog near the fire hydrant
		object{ 
			Dalmatian1
			scale 3.5
		}
		//and the leash
		union{
			//collar
			union{
				difference{
					cylinder{ y*0,y*.1, .252  }
					cylinder{ y*-.01,y*.11, .25 }
				}
				difference{
					box{ <-.005,0,-.29>,<.005,.1,-.45> }
					cylinder{ <-.01,.05,-.375>,<.01,.05,-.375>,.03}
				}
				pigment{ rgb<1,0,0> }
				finish{ 
					ambient .25
					diffuse .8
				}
				rotate x*35
				translate z*.58+y*2.08 
			}
			//leash
			#declare link_point1 = y*2.33604876585+z*.301496805209; //y*2.385+x*0+z*.335;
			#declare link_point2 = y*3.5+z*-5;
			#declare link_size = .05;
			#declare link_object = union{
				cylinder{<-.52,0,-.1>,<.52,0,-.1>,.1}
				box{<-.52,-.1,-.1>,<.52,.1,.1>}
				cylinder{<-.52,0,.1>,<.52,0,.1>,.1}
				pigment{ rgb .2 }
				finish{ ambient .1 diffuse .4 reflection .3 }
			}
			#declare total_link_twist = 800;
			#declare rotate_links = false;
			#include "link.inc"
		}
		scale 1.4
		rotate y*73
		translate z*-18.5+y*.385+x*-7 
	}
#end

#declare Window = union{
	//Trim
	box{ <-10.5,4.5,-42>,<-16.5,4.65,-42.5> texture{BoardText pigment{MediumTurquoise} } }
	box{ <-10.5,4.46,-42>,<-16.5,3.5,-42.1> texture{BoardText pigment{MediumTurquoise} } }
    box{ <-10.5,4.53,-42>,<-10.65,7.81,-42.5> texture{BoardText pigment{MediumTurquoise} } }
    box{ <-16.5,4.53,-42>,<-16.35,7.81,-42.5> texture{BoardText pigment{MediumTurquoise} } }
	box{ <-10.5,8,-42>,<-16.5,7.85,-42.5> texture{BoardText pigment{MediumTurquoise} } }
	//Window
	union{
		//Frame
		difference{
//			box{ <0,0,0>,<.1,3.2,5.7> }
			box{ <.46,.4,0>,<.48,.8,-.8> }
			box{ <.45,.425,-.025>,<.49,.775,-.3875> }
			box{ <.45,.425,-.4125>,<.49,.775,-.775> }
			pigment{ rgb <.1,.1,.1> quick_color rgb <1,1,0>}			
			finish{ diffuse .3 phong .5 phong_size 70 specular .8 }			
		}
		//Glass
		box{ 
			<.465,.425,-.025>,<.475,.775,-.775>
			texture{
				pigment{ rgb <.98,1.0,.99> }
				finish{
					ambient .1
					diffuse .1
					reflection .9
					specular 1
					roughness .002
				}
				normal{ ripples .05 scale 8 }
			}
/*			photons{
				separation 0.02*phd
				reflection on
				refraction off
			}*/
		}
		translate x*-.47+y*-.4
		scale <5,8,7.125>
		rotate y*90      
		translate x*-10.65+y*4.65+z*-42.3
	}

}

#declare r4 = seed(7386);

#if(House)
	//Foundation
//	difference{
		box{ 
			<-7.05,-.5,-42.05>,<-50.95,1.5,-61.95> 
			texture{ Concrete2 } 
		}
//	}

	//Corner
	box{ <-7,1.5,-42>,<-7.5,10,-42.2> texture{ BoardText } }
	box{ <-7,1.5,-42.2>,<-7.2,10,-42.7> texture{ BoardText } }

	//Walls
	#declare counter = 1.5;
	#while(counter < 10)
		//Front Wall
		#if( (counter > 4) & (counter < 8.5) ) //Leave holes for windows
			union{
				box{ <-7.5,0,0>,<-10.5,.9,-0.1> }
				box{ <-16.5,0,0>,<-20.5,.9,-.1> }
				box{ <-26.5,0,0>,<-50.5,.9,-.1> }

				texture{ BoardText translate x*(-50+rand(r4)) }
				rotate x*-10
				translate y*counter+z*-42
			}
		#else 
			box{
				<-7.5,0,0>,<-50.5,.9,-0.1>
				texture{ BoardText translate x*-51}
				rotate x*-10
				translate y*counter+z*-42
			}
		#end
		//Side wall
		box{
			<0,0,-42.7>,<-.1,.9,-61.3>
			texture{ BoardText rotate y*90 /*translate z*rand(r4)*2-1*/} //Break up patterning
			rotate z*10
			translate y*counter+x*-7
		}
		#declare counter = counter + .75;	
	#end
	//Front Windows
	object{ Window }
	object{ Window translate x*-10 }
	
#end

#if(Plants)
	//Border around garden
	union{
		box{<-5.25,0,-40>,<-60,.6,-40.02> }
	    cylinder{ <-5.25,.62,-40.01>,<-60,.62,-40.01>,.05 }
		box{<-5,0,-40.25>,<-5.02,.6,-60> }
		cylinder{ <-5.01,.62,-40.25>,<-5.01,.62,-60>,.05 }
		intersection{
			union{
				cylinder{ <-5.25,0,-40.25>,<-5.25,.6,-40.25>,.25 }
				torus{ .25,.05 translate <-5.25,.62,-40.25> }
			}
			box{ <-5.25,0,-40.25>,<-4.94,.73,-39.94> }
		}
		pigment{ rgb <.1,.1,.1> }
		finish{
			ambient 0
			diffuse .4
			specular .5
		}
	}
	//Dirt for flowerbed
	union{
		box{<-5.25,0,-40.02>,<-60,.6,-42.05>}
		box{<-5.02,0,-40.25>,<-7.05,.6,-60> }
		cylinder{ <-5.25,0,-40.25>,<-5.25,.6,-40.25>,.20 }
//		pigment{ rgb <.55,.26,.16> }
		pigment{
			granite
			color_map{
				[.40 rgb <.55,.26,.16>]
				[.45 rgb <1,1,1>]
				[.50 rgb <.55,.26,.16>]
			}
		}
		normal{
/*			bozo
			turbulence .4
			slope_map{
				[0  <0,0>  ]
				[.3 <10,1> ]
				[.45 <10,0> ]
				[.7 <10,0> ]
				[.8 <10,-1>]
				[0  <0,0>  ]
			}*/
			wrinkles
			scale .1
		}
		finish{
			ambient .2
			diffuse .8
		}
	}
	#declare r3 = seed(23948);
	#declare P_List = array[4]
	
	#declare P_List[0] = texture{ pigment{rgb < 1,.4, 0> } finish{ ambient .3 diffuse 1.3 } }
	#declare P_List[1] = texture{ pigment{rgb < 1, 1, 0> } finish{ ambient .3 diffuse 1.4 } }
	#declare P_List[2] = texture{ pigment{rgb < 1, 0, 0> } finish{ ambient .3 diffuse 1.5 } }
	#declare P_List[3] = texture{ pigment{rgb < 1,.7, 0> } }

	//Front flowers
	#declare counter = 0;
	union{ //unioned for speed
	#while(counter < 400)
		#declare PetalColor = texture{ P_List[int(rand(r3)*4)] };
		#declare XPOS = -(rand(r3)*25 + 5.25);
		#declare ZPOS = -(rand(r3)*1.9+40.1);
		object{ DO_Flower3() scale <5,3+(rand(r3)*.2),5> /*rotate x*(sin((ZPOS+42)/2)*15)*/ translate x*XPOS+y*.2+z*ZPOS }
		#declare counter = counter + 1;
	#end
	}
	//Side flowers
	#declare counter = 0;
	union{
	#while(counter < 170)
		#declare PetalColor = texture{ P_List[int(rand(r3)*4)] };	
		object{ DO_Flower3() scale <5,3+(rand(r3)*.2),5> translate x*-((rand(r3)*2) + 5.25)+y*.3+z*-(rand(r3)*15+40) }
		#declare counter = counter + 1;
	#end
	}

#end
