// "Too fat?" - Juha Leppl aka Jide
// This is my submission to the Unbeliavable round of IRTC 1999.
// Sorry about the lack of real commenting but that's just how I work :)

#include "pcm.mcr"

// Click on, click off, click on, click off
#declare Reflection=on;
#declare Arealights=on;
#declare Hairy_legs_and_accessories=on;
#declare Dustbunnies="not in my bathroom!"

// Measuring declares, just for fun :)
#declare m=1;
#declare cm=m/100;
#declare mm=cm/10;
#declare a_lot=1e+24;
#declare not_that_much=1e-24;
#declare foot="a bodypart"

global_settings { 
  assumed_gamma 1.0 
  radiosity {
    count 400                
    error_bound 0.3          
    gray_threshold 0.33       
    distance_maximum cm      
    low_error_factor 0.5
    nearest_count 8
    minimum_reuse 0.015      
    brightness 3.3           
    recursion_limit 1              
  }
}

background { color rgb<0.666,0.7215,1> }

camera {
  location <1.05*m,1*m,-0.21*m>
  angle 75
  look_at <1.04999*m,0.2*m,-0.2*m> 
}

#declare Lamp1=
difference {
  sphere { <0,0,0>,10*cm }
  plane { -y,0 translate y*2.1 }
  pigment { color rgb<0.9960,1,0.9333> }
  finish { ambient 1 diffuse 0 }
  no_shadow
}

light_source {
  <1.55*m,2*m,-1.5*m> 
  color rgb 0.9 
  looks_like {Lamp1} 
  #if(Arealights)
  area_light
  <-1.5*cm,0,-1.5*cm>,<1.5*cm,0,1.5*cm>,3,3
  adaptive 1 jitter
  #end
  fade_power 1 fade_distance 2*m 
}

light_source {
  <2*m,1.7*m,-0.2*m>
  color rgb 0.65
  #if(Arealights)
  area_light
  <-20*cm,0,-cm>,<20*cm,0,cm>,5,2
  adaptive 1 jitter
  #end
  fade_power 1 fade_distance 1.8*m
}
  
light_source { <0.9*m,0.85*m,-5*cm> color rgb 0.5 shadowless }

#macro RBox(Min,Max,Rad) //notice that this is a bit buggy macro, you have to give the cordinates as min, max
  #local P0=Min+Rad;
  #local P1=<Min.x+Rad,Min.y+Rad,Max.z-Rad>;
  #local P2=<Max.x-Rad,Min.y+Rad,Max.z-Rad>;
  #local P3=<Max.x-Rad,Min.y+Rad,Min.z+Rad>;
  #local P4=<Min.x+Rad,Max.y-Rad,Min.z+Rad>;
  #local P5=<Min.x+Rad,Max.y-Rad,Max.z-Rad>;
  #local P6=Max-Rad;
  #local P7=<Max.x-Rad,Max.y-Rad,Min.z+Rad>;
  merge {
    difference {
      box { Min, Max }
      box { Min-.1,<Max.x+.1,Min.y+Rad,Min.z+Rad> }
      box { Min-.1,<Min.x+Rad,Min.y+Rad,Max.z+.1> }
      box { <Max.x+.1,Min.y-.1,Min.z-.1>,<Max.x-Rad,Min.y+Rad,Max.z+.1> }
      box { <Max.x+.1,Min.y-.1,Max.z+.1>,<Min.x-.1,Min.y+Rad,Max.z-Rad> }
      box { <Min.x-.1,Max.y+.1,Min.z-.1>,<Max.x+.1,Max.y-Rad,Min.z+Rad> }
      box { <Min.x-.1,Max.y+.1,Min.z-.1>,<Min.x+Rad,Max.y-Rad,Max.z+.1> }
      box { <Max.x+.1,Max.y+.1,Min.z-.1>,<Max.x-Rad,Max.y-Rad,Max.z+.1> }
      box { <Max.x+.1,Max.y+.1,Max.z+.1>,<Min.x-.1,Max.y-Rad,Max.z-Rad> }
      box { Min-.1,<Min.x+Rad,Max.y+.1,Min.z+Rad> }
      box { <Max.x+.1,Min.y-.1,Min.z-.1>,<Max.x-Rad,Max.y+.1,Min.z+Rad> }
      box { <Min.x-.1,Min.y-.1,Max.z+.1>,<Min.x+Rad,Max.y+.1,Max.z-Rad> }
      box { <Max.x+.1,Min.y-.1,Max.z+.1>,<Max.x-Rad,Max.y+.1,Max.z-Rad> }
    }
    union {
      sphere { P0, Rad }
      sphere { P1, Rad }
      sphere { P2, Rad }
      sphere { P3, Rad }
      sphere { P4, Rad }
      sphere { P5, Rad }
      sphere { P6, Rad }
      sphere { P7, Rad }
    }
    union {
      cylinder { P0, P1, Rad }
      cylinder { P1, P2, Rad }
      cylinder { P2, P3, Rad }
      cylinder { P3, P0, Rad }
      cylinder { P4, P5, Rad }
      cylinder { P5, P6, Rad }
      cylinder { P6, P7, Rad }
      cylinder { P7, P4, Rad }
      cylinder { P0, P4, Rad }
      cylinder { P1, P5, Rad }
      cylinder { P2, P6, Rad }
      cylinder { P3, P7, Rad }
    }      
    //bounded_by { box { Min, Max }}
  }  
#end

union { // The floor
  plane { y,0 }
  box { <-10*cm,0,0>,<2.3*m,20*cm,10*cm> }
  difference {
    box { <-10*cm,-mm,mm>,<2.3*m,cm,-cm> }
    cylinder { <-11*cm,cm,-cm>,<2.31*m,cm,-cm>,cm }
  }
    box { <-10*cm,0,10.2*cm>,<0,20*cm,-2.5*m> }
  difference {
    box { <-10*cm,-mm,10*cm>,<cm,cm,-2.11*m> }
    cylinder { <cm,cm,11*cm>,<cm,cm,-2.12*m>,cm }
  }
  texture {
    pigment {
      bozo
      turbulence 0.7 omega 0.2 lambda 2.5
      color_map {
        [0 0.5 color rgb<0.7137,0.8784,0.9803> color rgb<0.7137,0.8784,0.9803>]
        [0.5 1 color rgb<0.8156,0.9607,1> color rgb<0.8156,0.9607,1>]
      }
    }
    finish { diffuse 0.5 phong 0.05 phong_size 70 } 
    scale <0.03,0.01,0.01>
  }
  bounded_by { box { <-10*cm,0,-2.1*m>,<2.3*m,20*cm,10*cm> }}
}
union { // The walls
  box { <-11*cm,20*cm,11*cm>,<2.31*m,2.1*m,-0.5*cm> }
  difference {
    box { <-11*cm,20*cm,11*cm>,<0.5*cm,2.1*m,-2.11*m> }
    box { <-12*cm,1.3*m,-30*cm>,<cm,1.8*m,-0.7*m> pigment { color rgb 0.7 }}
  }
  box { <2.31*m,0,11*cm>,<2.4*m,2.1*m,-2.11*m> }
  box { <-11*cm,2.1*m,-2.11*m>,<2.4*m,2.2*m,11*cm> }
  pigment { color rgb 1 }
  normal { granite 0.1 scale 0.01 }
}
union { 
  #declare X=0.5*cm; #while(X<2.3*m+(0.5*cm))
    #declare Y=20*cm; #while(Y<2.1*m)
      object { 
        RBox(<X+(0.25*cm),Y+(0.25*cm),-0.8*cm>,<X+(14.75*cm),Y+(14.75*cm),cm>,0.5*cm) 
        #if(Y<0.7*m) pigment { color rgb <0.75,0.75,1> } #else pigment { color rgb 1 } #end
        normal { bumps 0.05 turbulence 0.5 scale 0.5 }
        finish { ambient 0.2 diffuse 0.7 #if(Reflection)reflection_min 0 reflection_max 0.03#end specular 1 roughness 1/100 brilliance 0.75 }
      }
    #declare Y=Y+(15*cm); #end
  #declare X=X+(15*cm); #end
  #declare Z=-2.1*m-(0.5*cm); #while (Z<-0.5*cm)
    #declare Y=20*cm; #while(Y<2.1*m)
      #if(Z<-0.7*m | Y<1.3*m | Z>=-0.3*m | Y>=1.8*m)
        object {
          RBox(<-cm,Y+(0.25*cm),Z+(0.25*cm)>,<0.8*cm,Y+(14.75*cm),Z+(14.75*cm)>,0.5*cm)
          #if(Y<0.7*m) pigment { color rgb <0.75,0.75,1> } #else pigment { color rgb 1 } #end
          normal { bumps 0.05 turbulence 0.5 scale 0.5 }
          finish { ambient 0.2 diffuse 0.7 #if(Reflection)reflection_min 0 reflection_max 0.03#end specular 1 roughness 1/100 brilliance 0.75 }
        }
      #end
    #declare Y=Y+(15*cm); #end
  #declare Z=Z+(15*cm); #end
}

// The scale
union {
  union {
    difference {
      object{ RBox(<0,-m,-35*cm>,<30*cm,36*cm,0>,4*cm) scale <1,0.2,1> }
      plane { y,0 translate y*3*cm }
      plane { 
        -y,0 
        translate y*7*cm 
        pigment { color rgb<0.1019,0.9607,0.9843> } 
        normal { gradient z 0.1 scale 0.015 sine_wave } 
      } // To bump_map the grooves
    }
    difference {
      object { RBox(<0.3*cm,0,-34.7*cm>,<29.7*cm,10*cm,0.3*cm>,3.5*cm) }
      plane { -y,0 translate y*3*cm }
    }
    pigment { color rgb<0.1019,0.9607,0.9843> }
  }
  union {
    difference {
      difference {
        sphere { <0,0,0>,11*cm scale <1,3/24,1> translate <15*cm,7.2*cm,-cm> }
        plane { -z,0 translate -z*3.2*cm }
      }
      difference {
        cylinder { <15*cm,7.3*cm,-3.2*cm>,<15*cm,9*cm,-3.2*cm>,7.8*cm }
        plane { -z,0 translate -z*3.8*cm }
        pigment { color rgb 0 }
      }
    }
    difference {
      sphere { <0,0,0>,11.001*cm scale <1,3/42,1> translate <15*cm,7.2*cm,-cm>}
      sphere { <0,0,0>,10.999*cm scale <1,3/42,1> translate <15*cm,7.2*cm,-cm> }
      plane { -z,0 translate -z*3.2*cm }
      plane { y,0 translate y*7.2*cm }      
      pigment { image_map { gif "scamm.gif" interpolate 2 transmit 0,1 } rotate x*90 scale <0.155,0.12,0.12> translate <-8.2*cm,0,1.5*cm>} 
    } 
    pigment { color rgb<0.4235,0.5294,0.9490> }
  }
  box { <-4*cm,0,-7*cm>,<4*cm,0.1*cm,-4*cm> pigment { image_map { gif "toofat.gif" interpolate 4 } rotate x*90 scale <0.08,1,0.03> translate <-4*cm,0,-7*cm> } finish { ambient 1 diffuse 0 } translate <15*cm,7.6*cm,-1.5*cm> }
  rotate -y*6 translate <0.9*m,0,-15*cm>
}

#declare WhitePaint=
texture {
  pigment { color rgb<0.98078,1,0.9921> }
  normal { bumps 0.1 scale 0.01 }
  finish { ambient 0.1 diffuse 0.5 phong 0.2 phong_size 50 }
}

#declare Rust=
texture {
  pigment {
    granite
    color_map {
      [0 color rgb<0.4509,0.3686,0.2235>]
      [0.5 color rgb<0.2941,0.2509,0.1960>]
      [1 color rgb<0.3264,0.2627,0.2588>]
    }
  }
  normal { granite -0.4 }
  finish {ambient 0.1 diffuse 0.7 brilliance 1.5 crand 0.01 }
  scale 0.01
}

// Some water pipes
object { 
  read_mesh("wpipes.pcm") 
  texture {
    bozo
    turbulence 0.4 omega 0.2
    texture_map {
      [0 WhitePaint ]
      [0.96 WhitePaint ]
      [0.96 Rust ]
    }
    scale 0.05
    translate -2
  }
  scale <1,1,-1>
}


#if(Hairy_legs_and_accessories)
union {
  union {
    object {
      read_mesh("socks.pcm") // Don't smell 'em
      pigment {
        gradient y
        color_map {
          [0 color rgb 0.9]
          [0.65 color rgb 0.9]
          [0.65 color rgb<0.9921,0,0>]
          [0.7 color rgb<0.9921,0,0>]
          [0.7 color rgb 0.9]
          [0.75 color rgb 0.9]
          [0.75 color rgb<0.9921,0,0>]
          [0.8 color rgb<0.9921,0,0>]
          [0.8 color rgb 0.9]
          [0.85 color rgb 0.9]
          [0.85 color rgb 0.05]
          [0.9 color rgb 0.05]
          [0.9 color rgb 0.9]
          [1 color rgb 0.9]
        }
        scale 0.2
      }
      normal { quilted -0.3 control0 1 control1 1 scale 0.0008 }
    }
    object {
      read_mesh("clothes.pcm")
      pigment { color rgb 0 }
    }
    rotate y*-4
    translate <0.99*m,7*cm,-43*cm>
  }
  #include "pcmhair.mcr"
  // Various declarations for Chris Colefax's hair macro
  #declare hair_radius=0.01;
  #declare hair_thickness=0.0004;
  #declare hair_thickess_curvature=0.7;
  #declare hair_length=0.02;
  #declare hair_object_count=2750;
  #declare hair_seed=1981;
  #declare hair_arc=0.7;
  #declare hair_rotate_to_surface=-true;
  #declare hairs_per_patch=1;
  #declare hair_rotation_turb=<0.2,0.1,0.2>;
  smooth_triangle_hairs_object()
  #declare hair_object = 
  object { 
    hair_object 
    pigment { color rgb<0.9843,0.9294,0.7176> } 
    finish { ambient 0.2 diffuse 0.5 specular 0.5 roughness 1/150 brilliance 0.5 }
    no_shadow
  }
  #declare hair_mesh_transform=transform { rotate -y*4 translate <0.99*m,7*cm,-43*cm> }
  union { 
    read_mesh("lleg.pcm") // Generated by Warp's mesh compressor
    #declare hair_rotate_to_surface=true;
    read_mesh("rleg.pcm") // Same here
    pigment { 
      bozo
      turbulence 0.2 omega 0.8
      color_map {
        [0 color rgb<0.9960,0.9254,0.7882>]
        [0.3 color rgb<0.9960,0.9254,0.7882>]
        [1 color rgb<0.9137,0.8411,0.6992>]
      }
      scale 0.001
    }
  }
}
#end

// A lil' tablethingy
union {
  RBox(<3*cm,0,-57*cm>,<45*cm,0.55*m,-54*cm>,0.2*cm)
  RBox(<3*cm,0,-13*cm>,<44.9*cm,0.55*m,-10*cm>,0.2*cm)
  RBox(<3*cm,0,-53.9*cm>,<6*cm,0.55*m,-13.1*cm>,0.2*cm)
  RBox(<6.1*cm,11*cm,-53.9*cm>,<44.5*cm,14*cm,-13.1*cm>,0.2*cm)
  RBox(<43*cm,0.2*cm,-53.9*cm>,<43.5*cm,10.8*cm,-13.1*cm>,0.2*cm)
  RBox(<2*cm,0.5505*m,-57.5*cm>,<47*cm,0.58*m,-9.5*cm>,0.2*cm)
  union {
    difference { 
      RBox(<0,14*cm,-47.5*cm>,<3*cm,54.7*cm,0>,0.2*cm) 
      box { <2*cm,48.5*cm,-48*cm>,<3.1*cm,50*cm,0.1*cm> }
      box { <2*cm,45*cm,-48*cm>,<3.1*cm,46.5*cm,0.1*cm> }
    }
    union {
      box { <3*cm,53*cm,-44*cm>,<4.5*cm,52.5*cm,-45*cm> }
      cylinder { <3*cm,52.75*cm,-44*cm>,<4.5*cm,52.75*cm,-44*cm>,0.25*cm }
      cylinder { <3*cm,52.75*cm,-45*cm>,<4.5*cm,52.75*cm,-45*cm>,0.25*cm }
      difference {
        union {
          difference {
            cylinder { <4.5*cm,52*cm,-44*cm>,<4.5*cm,52*cm,-45*cm>,cm }
            cylinder { <4.5*cm,52*cm,-43.9*cm>,<4.5*cm,52*cm,-45.1*cm>,0.5*cm }
          }        
          torus { 0.75*cm,0.25*cm rotate x*90 translate <4.5*cm,52*cm,-44*cm> }
          torus { 0.75*cm,0.25*cm rotate x*90 translate <4.5*cm,52*cm,-45*cm> }          
        }
        plane { y,0 translate y*52*cm }
        plane { x,0 translate x*4.5*cm }
      }
      box { <5*cm,52*cm,-44*cm>,<5.5*cm,48*cm,-45*cm> }
      cylinder { <5.25*cm,52*cm,-44*cm>,<5.25*cm,48*cm,-44*cm>,0.25*cm }
      cylinder { <5.25*cm,52*cm,-45*cm>,<5.25*cm,48*cm,-45*cm>,0.25*cm }
      difference {
        union {
          difference {
            cylinder { <4.5*cm,48*cm,-44*cm>,<4.5*cm,48*cm,-45*cm>,cm }
            cylinder { <4.5*cm,48*cm,-43.9*cm>,<4.5*cm,48*cm,-45.1*cm>,0.5*cm }
          }        
          torus { 0.75*cm,0.25*cm rotate x*90 translate <4.5*cm,48*cm,-44*cm> }
          torus { 0.75*cm,0.25*cm rotate x*90 translate <4.5*cm,48*cm,-45*cm> }          
        }
        plane { -y,0 translate y*48*cm }
        plane { x,0 translate x*4.5*cm }
      }
      box { <3*cm,47.5*cm,-44*cm>,<4.5*cm,47*cm,-45*cm> }
      cylinder { <3*cm,47.25*cm,-44*cm>,<4.5*cm,47.25*cm,-44*cm>,0.25*cm }
      cylinder { <3*cm,47.25*cm,-45*cm>,<4.5*cm,47.25*cm,-45*cm>,0.25*cm }
      pigment { color rgb<0.7843,0.6862,0.5568> }
      finish { ambient 0.1 diffuse 0.5 reflection 0.3 specular 1 roughness 1/2000 metallic }
    }  
    rotate -y*10 translate <45.1*cm,0,-10*cm> 
  } 
  translate <3*cm,0,-2*cm>
  pigment { color rgb 1 }
  finish { ambient 0.2 diffuse 0.75 brilliance 0.7 }
}

// A cabinet or sumtin'
union {
  RBox(<1.5*m,0,-47.5*cm>,<1.53*m,0.7*m,-5*cm>,0.3*cm)
  RBox(<1.531*m,0,-7*cm>,<2.219*m,0.675*m,-5.1*cm>,0.3*cm)
  RBox(<1.531*m,0,-45*cm>,<2.219*m,8*cm,-42*cm>,0.3*cm)
  RBox(<1.531*m,8.1*cm,-47*cm>,<2.219*m,10*cm,-7.1*cm>,0.3*cm)
  RBox(<2.22*m,0,-47.5*cm>,<2.25*m,0.7*m,-5*cm>,0.3*cm)
  RBox(<1.531*m,0.675*m,-47.4*cm>,<2.19*m,0.699*m,-5*cm>,0.3*cm)
  RBox(<1.505*m,8.5*cm,-50*cm>,<1.873*m,0.698*m,-48*cm>,0.3*cm)
  RBox(<1.877*m,8.5*cm,-50*cm>,<2.22*m,0.699*m,-48*cm>,0.3*cm)
  pigment { color rgb 1 }
  finish { ambient 0.2 diffuse 0.75 brilliance 0.7 }
}

// A roll of toiletpaper and a toiletpaper holder
union {
  union {
    box{ <0,-2*mm,-1.5*cm>,<5*cm,1.2*cm,0.75*cm> }
    union {
      cylinder { <0,0.5*cm,-1*cm>,<-2*cm,0.5*cm,-1*cm>,0.5*cm }
      difference {
        torus { 1.5*cm,0.5*cm }
        plane { -x,0 }
        plane { z,0 }
        rotate -x*90
        translate <-2*cm,-cm,-1*cm>
      }
      cylinder { <-3.5*cm,-cm,-1*cm>,<-3.5*cm,-5.5*cm,-1*cm>,0.5*cm }
      difference {
        torus { 1.5*cm,0.5*cm }
        plane { -x,0 }
        plane { z,0 }
        rotate x*90
        translate <-2*cm,-5.5*cm,-1*cm>
      }
      cylinder { <-2*cm,-7*cm,-1*cm>,<6.5*cm,-7*cm,-1*cm>,0.5*cm }
      difference {
        torus { cm,0.5*cm }
        plane { -x,0 }
        plane { z,0 }
        rotate x*90
        rotate y*180
        translate <6.5*cm,-6*cm,-1*cm>
      }
      translate <0,-.5*cm,cm>
      rotate x*30
      translate <0,0.5*cm,-cm> 
    }
    pigment { color rgb 1 }
    finish { ambient 0.1 diffuse 0.6 phong 0.5 phong_size 100 }
  }
  union {
    difference {
      cylinder { <-1.8*cm,-6.7*cm,-4.5*cm>,<6.5*cm,-6.7*cm,-4.5*cm>,1.35*cm }
      cylinder { <-2*cm,-6.7*cm,-4.5*cm>,<7*cm,-6.7*cm,-4.5*cm>,1.25*cm }
      pigment { color rgb<0.7843,0.5921,0.5176> }
    }
    union {
      difference {
        cylinder {
          <-1.81*cm,-6.7*cm,-4.5*cm>,<6.51*cm,-6.7*cm,-4.5*cm>,4*cm
          uv_mapping
          pigment { color rgb 1 }
          finish { ambient 0.2 diffuse 0.6 brilliance 0.8 }
          normal {
            bump_map {
              gif "tpbump.gif"
              bump_size 1
              interpolate 4
            }
            scale 4.4*cm
            translate x*1.8*cm
          }
        }
      cylinder { <-1.82*cm,-6.7*cm,-4.5*cm>,<6.52*cm,-6.7*cm,-4.5*cm>,1.35*cm }
      box { 
        <-1.8*cm,0,-10*cm>,<7*cm,-15*cm,0> 
        pigment {
          wood 
          color_map {
            [0 0.1 color rgb 1 color rgb 0.7]
            [0.2 0.3 color rgb 1 color rgb 0.65]
            [0.4 0.5 color rgb 1 color rgb 0.8]
            [0.6 0.7 color rgb 1 color rgb 0.65]
            [0.8 0.9 color rgb 1 color rgb 0.75]
            [1 color rgb 0.8]              
          } 
          scale 0.007 rotate y*90 translate <0,-6.7*cm,-4.5*cm>
        }
        finish { ambient 0.2 diffuse 0.6 brilliance 0.8 }
        inverse
      }
    }
    box { 
      <-1.81*cm,-6.7*cm,-8.5*cm>,<6.51*cm,-17*cm,-8.49*cm> }
      uv_mapping
      pigment { color rgb 1 }
      finish { ambient 0.1 diffuse 0.5 brilliance 0.9 }
      normal {
        bump_map {
          gif "tpbump.gif"
          bump_size 1
          interpolate 4
        }
        scale 0.5
        translate <1.8*cm,-7*cm,0>
      }
    }
    pigment { color rgb 1 }
    finish { ambient 0.1 diffuse 0.5 brilliance 0.8 }
  }
  translate <0.8*m,0.63*m,-0.5*cm>
}