//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 5 lights, 12 materials and 39 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 01/31/1999    (31.01.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.000,     -20.000,       5.000>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,       5.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <     -0.508,      -3.811,       5.028> // Attached to Spotlight001
  direction <        0.0,         0.0,      0.2571> // Aperture is 2.19 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -0.508,      -2.945,       4.528> // Following Spotlight001
}

*/

/*
camera {  //  Camera SpotCam002
  location  <     -0.508,      -3.811,       5.028> // Attached to Spotlight002
  direction <        0.0,         0.0,      0.2571> // Aperture is 2.19 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -0.508,      -2.945,       5.528> // Following Spotlight002
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light003
  <-3.000, 6.000, 8.500>
  color rgb <0.000, 0.000, 1.000>
}

light_source {   // Light002
  <-3.000, 6.000, 2.138>
  color rgb <1.000, 0.000, 0.000>
}

light_source {   // Light001
  <0.000, 10.182, 5.002>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Spotlight Spotlight002
  <-0.508, -3.811, 5.028>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-0.508, -2.079, 6.028>
    falloff    62.783  // outer radius (in deg)
    radius     43.409  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Spotlight001
  <-0.508, -3.811, 5.028>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-0.508, -2.079, 4.028>
    falloff    62.783  // outer radius (in deg)
    radius     43.409  // inner radius
    tightness  0.000
}


//
// ********  MATERIALS  *******
//

#include "mirrorworld.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

union { // CSG002
  torus { // Torus013
    1.875, 0.125  rotate -x*90
    rotate <180.0, 0.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus014
    1.875, 0.125  rotate -x*90
    rotate <180.0, -20.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus015
    1.875, 0.125  rotate -x*90
    rotate <180.0, -40.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus016
    1.875, 0.125  rotate -x*90
    rotate <180.0, -80.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus017
    1.875, 0.125  rotate -x*90
    rotate <180.0, -60.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus018
    1.875, 0.125  rotate -x*90
    rotate -80.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus019
    1.875, 0.125  rotate -x*90
    rotate -60.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus020
    1.875, 0.125  rotate -x*90
    rotate -40.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus021
    1.875, 0.125  rotate -x*90
    rotate -20.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus022
    1.875, 0.125  rotate -x*90
    translate  <7.8, 8.5, 0.75>
  }
  material {
    TopRingsoffire
  }
  rotate <0.0, 2.215792, -23.340954>
  translate  <-4.0, 2.83, 7.0>
}


union { // CSG001
  torus { // Torus012
    1.875, 0.125  rotate -x*90
    rotate <180.0, 0.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus011
    1.875, 0.125  rotate -x*90
    rotate <180.0, -20.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus010
    1.875, 0.125  rotate -x*90
    rotate <180.0, -40.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus008
    1.875, 0.125  rotate -x*90
    rotate <180.0, -80.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus009
    1.875, 0.125  rotate -x*90
    rotate <180.0, -60.0, 180.0>
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus007
    1.875, 0.125  rotate -x*90
    rotate -80.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus006
    1.875, 0.125  rotate -x*90
    rotate -60.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus005
    1.875, 0.125  rotate -x*90
    rotate -40.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus004
    1.875, 0.125  rotate -x*90
    rotate -20.0*y
    translate  <7.8, 8.5, 0.75>
  }
  torus { // Torus003
    1.875, 0.125  rotate -x*90
    translate  <7.8, 8.5, 0.75>
  }
  material {
    Ringsoffire
  }
  rotate <0.0, 2.215792, -23.340954>
  translate  <-4.0, 2.83, 2.0>
}


#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <0.000, -20.000, 5.000>;  // using camera 'StdCam'
#declare lookat = <0.000, 0.000, 5.000>;
#declare light_loc = <-3.00000, 6.00000, 8.50000>;  // using light source 'Light003'

#declare flare_size = 1.000;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sunset1.flr"
#include "NKFlare\nkflare.inc"


#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <0.000, -20.000, 5.000>;  // using camera 'StdCam'
#declare lookat = <0.000, 0.000, 5.000>;
#declare light_loc = <-3.00000, 6.00000, 2.13771>;  // using light source 'Light002'

#declare flare_size = 1.000;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sunset1.flr"
#include "NKFlare\nkflare.inc"






sphere { // Sphere004
  <0,0,0>,1
  material {
    TopShinySphere
  }
  translate  <3.5, 0.0, 9.0>
}


sphere { // Sphere003
  <0,0,0>,1
  material {
    TopShinySphere
  }
  translate  <-3.5, 0.0, 9.0>
}


sphere { // Sphere002
  <0,0,0>,1
  material {
    ShinySphere
  }
  translate  <3.5, 0.0, 1.0>
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    ShinySphere
  }
  translate  <-3.5, 0.0, 1.0>
}




//
// Include file contains 'RotSweep002'
//
#include "mirrorworld.in1"
object {   // RotSweep002
  RotSweep002_Raw
  material {
    TopBlueMetal
  }
  scale 0.682378
  rotate -180.0*y
  translate  <0.0, -0.05, 5.7>
}


//
// Include file contains 'RotSweep001'
//
#include "mirrorworld.in2"
object {   // RotSweep001
  RotSweep001_Raw
  material {
    BlueMetal
  }
  scale 0.682378
  translate  <0.0, -0.05, 4.3>
}


torus { // Torus002
  1.5, 0.5  rotate -x*90
  material {
    TopTorusWater
  }
  translate  8.0*z
}


torus { // Torus001
  1.5, 0.5  rotate -x*90
  material {
    TorusWater
  }
  translate  2.0*z
}






cone { // Cone002
  <0,0,0>, 0.0, <0,0,1>, 1.0
  material {
    TopStreakySteelMetal
  }
  scale <1.0, 1.0, 4.0>
  rotate <-180.0, -180.0, 0.0>
  translate  6.0*z
}


cone { // Cone001
  <0,0,0>, 0.0, <0,0,1>, 1.0
  material {
    Streaky_Steel_Metal
  }
  scale <1.0, 1.0, 4.0>
  rotate -180.0*x
  translate  <0.0, -0.039196, 4.0>
}


plane { // Plane002
  z,0
  material {
    Topgrass
  }
  translate  10.0*z
}


plane { // Plane001
  z,0
  material {
    Grass
  }
}


