#declare flag_texture = texture {
pigment {
image_map {
png "c:\USNAMFLG"
}
scale 2
rotate 90*x
}
normal {ripples scale 30 frequency 15 turbulence .5 bump_size .75
phase clock*1 scale .5}
finish { ambient 0 diffuse 1 phong 0}
}

#declare flag_segments = 400;            // number of segments in approximation
#declare flag_ripples = 16;            // self explanatory
#declare max_angle = 20;                 // controls "depth" of ripples and orientation
//of flag
#declare min_angle = -25;
#declare flag_aspect = 1;         // width/height ratio of flag
#declare flag_clock_offset = clock;      // the animation counter

#declare flag_step = 2 * flag_aspect / (flag_segments + 1);
#declare angle_range = max_angle - min_angle;
#declare flag_pos = <0,0,0>;
#declare USNAMFlag =
intersection {
union {
#declare flag_count = 0;
#while (flag_count <= flag_segments)
  #declare flag_clock = flag_count / (flag_segments / flag_ripples) +
flag_clock_offset;
  #declare flag_clock = flag_clock - int (flag_clock);
  #if (flag_clock < 0.5)
    #declare flag_angle = 2 * flag_clock * angle_range + min_angle;
  #else
    #declare flag_angle = 2 * (1-flag_clock) * angle_range + min_angle;
  #end
  box {
    <0,0,-1>,<flag_step,0.00125,1>
    //texture { flag_texture translate <-flag_count * flag_step,0,0> }
    rotate <0,0,flag_angle>
    translate flag_pos
  }
  #declare flag_pos = flag_pos + vrotate (<flag_step,0,0>,
<0,0,flag_angle>);
#declare flag_count = flag_count + 1;
#end
translate -1.5*x 
rotate -30*y     
scale <6,4,6>
}
box {0,1
scale <2,2,2>
translate <0,-1,-1>
}
texture {flag_texture translate <0,0,-1>}
rotate 90*z
matrix < 0, 0, 1,
             0, 0, -.5,
             0, 0, 1,
             0, 0, 1 >
rotate -90*z      
scale <1,1,1>
}
#declare Flag =
union {
#declare Count = 0;
#while (Count < 360)
cylinder {0,y,1
scale <.05,10,.05>
translate <0,0,.05>
rotate Count*y
pigment {rgb <.5,.4,.2>}
}                   
#declare Count = Count + 30;
#end             
sphere {0,1
scale .25
translate 10*y
pigment {rgb <1,.8,0>}
finish {ambient .01 diffuse .5 phong .5}
}
union {USNAMFlag scale 1.5 rotate <-90,0,0> translate <0,6,-.475> }
}

