// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: This is a night scene with fountains.
// Date: 
// Auth: John Coppens

// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "golds.inc"
#include "textures.inc"      

#declare f_filter_max = 0.5;
#declare f_filter_min = 0.1;
#declare f_refl_max = 0.1;
#declare f_refl_min = 0.6;

#declare PoolLevel = -0.1;

#declare UWindowTexture = // Upper level windows 
  texture {
    pigment {
      color rgb <0.6, 0.3, 0.8>
    }
    finish {
      reflection rgb <0.9, 0.7, 0.01>
    }
  }

#declare GWindowTexture = // Ground level windows
  texture {
    pigment {
      color Black
    }
    finish {
      reflection 0.7
    }
  }                            
  
#declare WindowBrdrTexture =
  texture {
    pigment {
      color Black
    }
    finish {
      phong 0.3
    }
  }

//Mobile camera near 0,0
//camera
//{
//  location  <-0.5, 1, 0.0>
//  look_at   <-0.5, 0, 0.0>
//}              

//camera  // General camera 1
//{
//  location  <-8.0 , 2.0, -7.0>
//  look_at   <25.0 , 1.8, 10.0>
//}

camera  // General camera 2
{
  location  <-6.0 , 2.0, -9.0>
  look_at   <25.0 , 1.8, 20.0>
}

light_source
{
  0*x
  color 1.3
  translate <10, 10, -15>
}


plane {
  y,-0.15
  texture {
    pigment {
      hexagon 
        color rgb <0.4, 0.4, 0.5> 
        color rgb <0.5, 0.6, 0.5> 
        color rgb <0.7, 0.7, 0.6> 
      scale 0.5
    }     
    finish {
      phong 0.1
    }
    normal {
      bumps 0.3 scale 0.01
    }     
  }
} 

//Definition of the Fountains
#macro Fountain(Fname) 
union {
  cylinder {
    <0.1, -0.1, 0> <0.1, 0, 0> 0.05
    pigment { color Black }
  }
  height_field
  {
    gif Fname
    water_level 0.01
    texture {
      pigment { 
        gradient y       //this is the PATTERN_TYPE
          color_map {
            [0.01   color White filter f_filter_max]
            [1.00   color White filter f_filter_min]
          }
      }     
      finish {
        phong 0.3
      }
    }
    interior {
      ior 1.5
    }
    scale <4, 0.01, 10>
    rotate <-90, 0, 0>  
  }
  no_shadow 
}  
#end

//Fountain 1
Fountain("fount1.gif")

//Fountain 2
object {
  Fountain("fount3.gif")
  translate <0, 0, 3>
}

//Fountain 2
object {
  Fountain("fount2.gif")
  translate <0, 0, -3>
}

//Fountain 4
object {
  Fountain("fount4.gif")
  translate <0, 0, 6>
}

//Border around the marble
//Corner stone - normalized
#declare HalfStone =
  difference {
    union {
      box { <-0.15, 0.15, -0.15> <0.15, -0.2, 0.15> }
      cylinder{ <-0.15, 0.15, 0.0> <0.15, 0.15, 0.0> 0.15 }
    }
    box {<-1, 1, 0> <1, -1, 2> rotate <0, -45, 0> }
  }       
#declare CornerStone =
  union {
    object { HalfStone }
    object { HalfStone scale <-1, 1, 1> rotate <0, 90, 0> }
  }
  
union {
  object { CornerStone translate <-4.15, 0, -6.65> }
  object { CornerStone rotate <0, -90, 0> translate < 4.15, 0.0, -6.65> }
  object { CornerStone rotate <0,  90, 0> translate <-4.15, 0.0,  9.65> }
  object { CornerStone rotate <0, 180, 0> translate < 4.15, 0.0,  9.65> }
  box { <-4.0, 0.15, -6.5> < 4.0, -0.2, -6.8> }
  box { <-4.0, 0.15,  9.5> < 4.0, -0.2,  9.8> }
  box { <-4.0, 0.15, -6.5> <-4.3, -0.2,  9.5> }
  box { < 4.0, 0.15, -6.65> <4.3, -0.2,  9.5> }
  cylinder { <-4.0, 0.15, -6.65> <4.0, 0.15, -6.65> 0.15 }
  cylinder { <-4.0, 0.15,  9.65> <4.0, 0.15,  9.65> 0.15 }
  cylinder { <-4.15, 0.15, -6.5> <-4.15, 0.15, 9.5> 0.15 }
  cylinder { <4.15, 0.15, -6.5> <4.15, 0.15, 9.5> 0.15 } 
  texture {
    pigment {
      granite
      turbulence 0.7
      color_map {
        [0.0  color Gray20]
        [1.0  color Gray40]
      }     
      scale 0.1
    }              
    normal { bumps 0.05 scale 0.01 }
    finish { phong 0.5 }
  }
}
        
//Marble
  // Marble surface
difference {
  box {
    <-4, 0, -6.5> <4, -0.04, 9.5>
  }
  union {
    box { <-1.96, 0.01, -4.46> <1.96, -0.4, 7.46> }     // hole
    box { <-4, -0.5, -4.46> <4, 0.01, -4.45> } // cuts in marble top
    box { <-4, -0.5, -1.46> <4, 0.01, -1.45> }
    box { <-4, -0.5,  1.46> <4, 0.01,  1.45> }
    box { <-4, -0.5,  4.46> <4, 0.01,  4.45> }
    box { <-4, -0.5,  7.46> <4, 0.01,  7.45> }
  }  
  texture {
    pigment {
      marble
      turbulence 1.0
      color_map {
        [0.0  color Gray20]
        [1.0  color Gray70]
      }  
      scale <0.04, 1, 0.04>
    }  
    finish {
      reflection 0.7
    }
  }
}   
  //Marble below border
difference {
  box {
    <-4, -0.04, -6.5> <4, -0.5, 9.5>
  }
  box {
    <-2, 0.01, -4.5> <2, -0.4, 7.5>
  }
  texture {
    pigment {
      marble
      turbulence 1.0
      color_map {
        [0.0  color Gray20]
        [1.0  color Gray70]
      }  
      scale <0.04, 1, 0.04>   
      rotate <45, 45, 0>
    }  
    finish {
      reflection 0.9
    }
  }
}

//Pool 
box {
  <-2, PoolLevel, -4.5> <2, PoolLevel-0.1, 7.5>
  texture {  
    pigment {
      color rgb <0.8, 1.0, 1.0> 
    }
    finish {    
      reflection 1.0
    }
    normal { bumps 0.02 scale 0.15 }
  }
}
union {  
  cylinder { <0.15, PoolLevel-0.45,  6> <2.0, PoolLevel-0.43,  6> 0.44 }
  cylinder { <0.15, PoolLevel-0.45,  3> <2.0, PoolLevel-0.43,  3> 0.44 }
  cylinder { <0.15, PoolLevel-0.45,  0> <2.0, PoolLevel-0.43,  0> 0.44 }
  cylinder { <0.15, PoolLevel-0.45, -3> <2.0, PoolLevel-0.43, -3> 0.44 }

  texture {
    pigment { color rgb <0.08, 0.10, 0.10> }
  }
  finish {
    reflection 1.0
  }
  normal { bumps 0.02 scale 0.03 }
}

//Building elements
//  Floor window
#declare FloorWindow =
  union {
    difference {                                        //Window border
      box { <0,      0.0,  -2.0>  <0.05,  3,    2.0> }
      box { <-0.001, 0.05, -1.95> <0.051, 2.95, 1.95> }
      texture { WindowBrdrTexture }
    }                                                   
    box {                                               //Window pane
      <0.02, 0.05, -1.95> <0.03, 2.95, 1.95>
      texture { GWindowTexture }
    }
  }                                        
  
//Building          
  union {
    //Cement block
    box {
      < 10.5, 3.0, -21> <25.5, 21.0, 20>
      texture {
        pigment {
          color Gray70
        }
        finish {
          Dull
        }
      }
    }
                
    //Windows  
    #declare Floor=0;
    #while (Floor < 4.5)
      #declare Count=-10;
      #while (Count < 10.5)
        box {
          <10.4, 4+Floor*3, 0.04+Count*2> <10.41, 6.9+Floor*3, 1.96+Count*2>
          texture {
            pigment {
              color rgb <0.8, 0.5, 0.4>
            }
            finish { reflection 0.8 }
            normal { bumps 0.002 scale 1 }
          }
        }
        #declare Count=Count+1;
      #end
      #declare Floor=Floor+1;
    #end
  
    //Ground floor windows
    #declare Count=-5;
    #while (Count < -1)
      object { FloorWindow translate <11.4, 0, 2+Count*4> }
      #declare Count=Count+1;
    #end
    #declare Count=1;
    #while (Count < 5)
      object { FloorWindow translate <11.4, 0, 2+Count*4> }
      #declare Count=Count+1;
    #end
    object { FloorWindow translate <17.4, 0, 2> }  
    light_source { <15.4, 2.9, 2> color rgb <0.8, 0.8, 0.6> }
    object { FloorWindow translate <17.4, 0, -2> }
    light_source { <15.4, 2.9, -2> color rgb <0.8, 0.8, 0.6> }
    box { <11.4, 0, 0.04-4> <17.41, 3, 0.05-4>
      texture { GWindowTexture }
    }
    box { <11.4, 0, 4> <17.41, 3, 4.01>
      texture { GWindowTexture }
    }
  }    
    
//Sidewalk  
box {
  <8, 0, -21> <29.5, -0.5, 21>
  texture {
    pigment {
      marble
      turbulence 1.0
      color_map {
        [0.0  color Gray30]
        [1.0  color Gray50]
      }  
      scale <0.04, 1, 0.04>   
    }  
    finish {
      reflection 0.9
    }
  }  
}
//End of the building POV HQ
	 
// Create an infinite sphere around scene
sky_sphere
{
  pigment
  {
    gradient y     
//    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] } // Day colors
    color_map { [0.0 color red 0.1 green 0.05] 
                [0.6 color red 0.3 green 0.2]
                [0.995 color red 1 green 0.4]
                [0.999 color red 2.4 green 0.4]
                [1 color red 2.5 green 0.4] } // night colors
    rotate <0, 0, 82> 
    rotate <0, 35, 0>
  }
}

text
{
  ttf             
  "d:\win95\fonts\times.ttf",  
  "POV-Ray Headquarters", 
  0.1,             
  0               // inter-character spacing
  texture { T_Gold_2C 
    finish { ambient 0.3 } }
  rotate <0, 90, 0>
  translate <10.3, 3.1, 5>
} 

//Another building to have something reflecting
union {
  #declare Floor=0;
  #while (Floor < 12)
    #declare Section=0;
    #while (Section < 12)
      cylinder {
        <0.0, 3.5+Floor*3, 0.0> <0.0, 6.4+Floor*3, 0.0> 6
        translate <6.0, 0.0, 0.0>
        rotate <0.0, 30*Section, 0.0>
      }
      #declare Section=Section+1;
    #end
    #declare Floor=Floor+1;
  #end
  texture {
    pigment {
      color rgb <0.4, 0.5, 0.5>
    }
    finish {
      reflection 0.5
//    phong 0.2
    }
  } 
  translate <-50, 0, 70>
}  
union {
  #declare Section=0;
  #while (Section < 12)
    cylinder {
      <0.0, 0.0, 0.0> <0.0, 3.5, 0.0> 5.5
      translate <5.5, 0.0, 0.0>
      rotate <0.0, 30*Section, 0.0>
    }
    #declare Section=Section+1;
  #end
  texture {
    pigment { color Gray70 }
  }
  translate <-50, 0, 70>
}

//Some mountains to liven up the horizon
height_field {
  gif "Nisky-mt.gif"
  texture {
    pigment { 
      gradient y       //this is the PATTERN_TYPE
        color_map {
          [0.10   color Green 0.5]
          [0.50   color Gray30]
          [0.70   color Gray50]
          [0.80   color White]
          [1.00   color White]
        }
    }
  }
  scale <6000, 500, 500>
  translate <-2000, -200, 1000> 
  rotate <0, -30, 0>
}
