// Escher Perpetual Waterfall
// B. Wilkins
// October 1998

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "fish.inc"

#declare BACKGROUND_ON = 1
#if(BACKGROUND_ON = 1)
	background {color SeaGreen}
#end

#declare COL_HEIGHT = 10
#declare WATER_LEVEL = -8

#declare STEP_COLUMN = difference
{
	union
	{
		#declare COUNT = 20
		#declare I = 0
		#while(I<COUNT)
			cylinder
			{
				<0,0,-.8>
				<0,COL_HEIGHT,-.8>
				0.2
				rotate <0,I*(360/COUNT),0>
			}
			#declare I = I + 1
		#end
	}

	#declare COUNT = COL_HEIGHT
	#declare I = 0
	#while(I<COUNT)
		torus
		{
			1 .05
			pigment {Gray90}
			translate <0,I,0>
		}
		#declare I = I + (COL_HEIGHT/COUNT)
	#end

	pigment
	{
		crackle
		color_map
		{
			[0.0	rgb <0.3,0.3,0.3>]
			[0.05	rgb <0.5,0.5,0.5>]
			[0.05	rgb <.5,.5,.5>]
			[1.0	rgb <.7,.7,.7>]
		}
		scale .25
		turbulence .25
	}
}

#declare ESCHER_WATER_FALL = union
{
	#declare X_STEP_LEN = 3
	#declare Y_STEP_LEN = .25
	#declare Z_STEP_LEN = 3
	#declare X_LEN = X_STEP_LEN
	#declare Z_LEN = Z_STEP_LEN
	#declare X = 0
	#declare Y = 0
	#declare Z = 0
	#declare CURB_SIZE = .25
	#declare CURB_HEIGHT = .5

	#declare WALLS_ON = 1
	#declare FISH_ON = 1
	#declare WATER_ON = 1

	#declare WATER_COLOUR = rgb <.4,.5,1>
	#declare BRICK_TEXTURE = texture
	{
		pigment
		{
			crackle
			color_map
			{
				[0.0	rgb <0.3,0.3,0.3>]
				[0.05	rgb <0.5,0.5,0.5>]
				[0.05	rgb <.5,.5,.5>]
				[1.0	rgb <.7,.7,.7>]
			}
		}
	}

	#declare MOSSSEED = seed(3)
	#declare MOSS = sphere
	{
		<0,0,0>
		1

		texture
		{
			pigment
			{
				gradient y
				color_map
				{
					[0.0	rgbt <0,1,0,1>]
					[1.0	rgb <0,0.6,0>]
				}
				translate <0,-.5,0>
				scale 2
			}
		}
		normal {ripples 1 frequency 1.5 turbulence 2}
		finish {crand .1}
		scale <.5,1,.1>
	}
	object {MOSS}

	#declare FISHSEED = seed(7) // 4
	#declare FISH = object
	{
		spot_fish
		scale .25
		translate <0,2,0>
	}

	#declare CURB_PIG = pigment
	{
		spotted
		color_map
		{
			[0.0	Gray40]
			[0.2	Gray40]
			[0.5	rgb <0,.4,0>]
			[0.8	Gray40]
			[1.0	Gray40]
		}
		scale .2
	}

	#declare STEP_CORNER = union
	{
		// step and curbs
		box
		{
			<0,0,0>
			<X_STEP_LEN,Y_STEP_LEN,Z_STEP_LEN>
			pigment {CURB_PIG}
		}
		box
		{
			<0,0,Z_STEP_LEN-CURB_SIZE>
			<X_STEP_LEN,Y_STEP_LEN+CURB_HEIGHT,Z_STEP_LEN>
			pigment {CURB_PIG}
		}
		box
		{
			<0,0,0>
			<CURB_SIZE,Y_STEP_LEN+CURB_HEIGHT,Z_STEP_LEN>
			pigment {CURB_PIG}
		}

		// water
		box
		{
			<0,Y_STEP_LEN,0+CURB_SIZE>
			<X_STEP_LEN,Y_STEP_LEN*2,Z+Z_STEP_LEN-CURB_SIZE>
			pigment {WATER_COLOUR}
			normal {ripples 4 frequency 1.5 turbulence 2 scale <1,30,1>}
			finish {specular .35 reflection .10}
		}

		// water roll
		cylinder
		{
			<X+CURB_SIZE,Y+(2*Y_STEP_LEN),Z> // X+XL
			<X+X_LEN-CURB_SIZE,Y+(2*Y_STEP_LEN),Z> // Z+ZL
			Y_STEP_LEN
			pigment {WATER_COLOUR}
			normal {ripples 4 frequency 1.5 turbulence 5 scale <1,30,1>}
			finish {specular .7 reflection .75}
		}

		// cols
		object {STEP_COLUMN translate <X+1,Y-COL_HEIGHT,Z+Z_LEN-1>}

	}

	#declare SIDES = 4
	#declare I = 0
	#while(I<SIDES)
		#if(I = 0)
			#declare STEP_COUNT = 1
		#end
		#if(I = 1)
			#declare STEP_COUNT = 2
		#end
		#if(I = 2)
			#declare STEP_COUNT = 3
		#end
		#if(I = 3)
			#declare STEP_COUNT = 4
		#end
		#declare J = 0
		#while(J<STEP_COUNT)
			// the step
			box
			{
				<X+CURB_SIZE,Y,Z+CURB_SIZE>
				<X+X_LEN-CURB_SIZE,Y+Y_STEP_LEN,Z+Z_LEN-CURB_SIZE>
				pigment {White}
			}

			#if(WATER_ON = 1)
				//water
				box
				{
					<X,Y+Y_STEP_LEN,Z+CURB_SIZE>
					<X+X_LEN,Y+Y_STEP_LEN+Y_STEP_LEN,Z+Z_LEN-CURB_SIZE>
					pigment {WATER_COLOUR}
					normal
					{
						ripples 4 frequency 1.5
						turbulence 1.5
						scale <1,30,1>
					}
					finish {specular .32 reflection .10}  // water highlights
				}
			#end

			// wall
			#if(WALLS_ON = 1)
				difference
				{
					box
					{
						<X,Y,Z>
						<X+X_LEN,WATER_LEVEL,Z+Z_LEN>
						texture {BRICK_TEXTURE}
					}
					#if((I = 0) | (I=2))
						cylinder
						{
							<X+(X_LEN/2),WATER_LEVEL,Z-1>
							<X+(X_LEN/2),WATER_LEVEL,Z+Z_LEN+1>
							(X_LEN/2)-.25
							texture {BRICK_TEXTURE}
						}
					#end
					#if((I = 1) | (I=3))
						cylinder
						{
							<X-1,WATER_LEVEL,Z+(Z_LEN/2)>
							<X+X_LEN+1,WATER_LEVEL,Z+(Z_LEN/2)>
							(Z_LEN/2)-.25
							texture {BRICK_TEXTURE}
						}
					#end
				}
			#end

			#if((I = 0) | (I = 2))
				// curbs
				box
				{
					<X,Y,Z>
					<X+X_LEN,Y+Y_STEP_LEN+CURB_HEIGHT,Z+CURB_SIZE>
					pigment {CURB_PIG}
				}
				box
				{
					<X,Y,Z+Z_LEN-CURB_SIZE>
					<X+X_LEN,Y+Y_STEP_LEN+CURB_HEIGHT,Z+Z_LEN>
					pigment {CURB_PIG}
				}

				// water roll
				#if(I=0)
					intersection
					{
						cylinder
						{
							<X,Y+(2*Y_STEP_LEN),Z+CURB_SIZE>
							<X,Y+(2*Y_STEP_LEN),Z+Z_LEN-CURB_SIZE>
							Y_STEP_LEN
							pigment {WATER_COLOUR}
							normal {ripples 4 frequency 1.5 turbulence 5 scale <1,30,1>}
							finish {specular .7 reflection .75}
						}
						box
						{
							<X,Y,Z>
							<X+Y_STEP_LEN+.1,Y+(2*Y_STEP_LEN)+.1,Z+Z_LEN>
							pigment {WATER_COLOUR}
							normal {ripples 4 frequency 1.5 turbulence 5 scale <1,30,1>}
							finish {specular .7 reflection .75}
						}
					}

					#if(FISH_ON = 1)
						object {FISH rotate <0,0,rand(FISHSEED)*-90> translate <X+(X_LEN/2),Y,Z+.75>}
						object {FISH rotate <0,180,rand(FISHSEED)*90> translate <X+(X_LEN/2),Y,Z+Z_LEN-.75>}
					#end
				#else
					cylinder
					{
						<X+X_LEN,Y+(2*Y_STEP_LEN),Z+CURB_SIZE> //X+XL
						<X+X_LEN,Y+(2*Y_STEP_LEN),Z+Z_LEN-CURB_SIZE> //X+XL
						Y_STEP_LEN
						pigment {WATER_COLOUR}
						normal {ripples 4 frequency 1.5 turbulence 5 scale <1,30,1>}
						finish {specular .7 reflection .75}
					}

					#if(FISH_ON = 1)
						object {FISH rotate <0,0,rand(FISHSEED)*-90> translate <X+(X_LEN/2),Y,Z+.75>}
						object {FISH rotate <0,180,rand(FISHSEED)*90> translate <X+(X_LEN/2),Y,Z+Z_LEN-.75>}
					#end
				#end
			#end

			#if((I = 1) | (I = 3))
				// curbs
				box
				{
					<X,Y,Z>
					<X+CURB_SIZE,Y+Y_STEP_LEN+CURB_HEIGHT,Z+Z_LEN>
					pigment {CURB_PIG}
				}
				box
				{
					<X+X_LEN-CURB_SIZE,Y,Z>
					<X+X_LEN,Y+Y_STEP_LEN+CURB_HEIGHT,Z+Z_LEN>
					pigment {CURB_PIG}
				}

				// water roll
				#if(I=1)
					cylinder
					{
						<X+CURB_SIZE,Y+(2*Y_STEP_LEN),Z+Z_LEN>
						<X+X_LEN-CURB_SIZE,Y+(2*Y_STEP_LEN),Z+Z_LEN>
						Y_STEP_LEN
						pigment {WATER_COLOUR}
						normal {ripples 4 frequency 1.5 turbulence 1.5 scale <1,30,1>}
						finish {specular .7 reflection .75}
					}

					#if(FISH_ON = 1)
						object {FISH rotate <0,90,0> rotate <rand(FISHSEED)*-90,0,0> translate <X+.75,Y,Z+(Z_LEN/2)>}
						object {FISH rotate <0,-90,0> rotate <rand(FISHSEED)*90,0,0> translate <X+X_LEN-.75,Y,Z+(Z_LEN/2)>}
					#end
				#else
					cylinder
					{
						<X+CURB_SIZE,Y+(2*Y_STEP_LEN),Z>
						<X+X_LEN-CURB_SIZE,Y+(2*Y_STEP_LEN),Z>
						Y_STEP_LEN
						pigment {WATER_COLOUR}
						normal {ripples 4 frequency 1.5 turbulence 1.5 scale <1,30,1>}
						finish {specular .7 reflection .75}
					}

					#if(FISH_ON = 1)
						#declare FISHROT = rand(FISHSEED)
						#if(FISHROT > .2)
							object {FISH rotate <0,90,0> rotate <FISHROT*-90,0,0> translate <X+.75,Y,Z+(Z_LEN/2)>}
							object {FISH rotate <0,-90,0> rotate <rand(FISHSEED)*90,0,0> translate <X+X_LEN-.75,Y,Z+(Z_LEN/2)>}
						#end
					#end
				#end
			#end

			// change the position
			#if(I = 0)
				#declare X = X + X_LEN
			#end
			#if(I = 2)
				#declare X = X - X_LEN
			#end
			#if(I = 1)
				#declare Z = Z - Z_LEN
			#end
			#if(I = 3)
				#declare Z = Z + Z_LEN
			#end
			#declare Y = Y - Y_STEP_LEN

			#declare J = J + 1
		#end  // end of number of steps

		#declare J = 0

		#declare I = I + 1

		#if(I = 1)
			object {STEP_CORNER rotate <0,90,0> translate <X,Y,Z+Z_LEN>}
			#declare Z_LEN = X_STEP_LEN
			#declare X_LEN = Z_STEP_LEN
			#declare Z = Z - Z_LEN
		#end
		#if(I = 2)
			object {STEP_CORNER rotate <0,180,0> translate <X+X_LEN,Y,Z+Z_LEN>}
			#declare X_LEN = X_STEP_LEN
			#declare Z_LEN = Z_STEP_LEN
			#declare X = X - X_LEN
			#declare Z = (Z + X_LEN) - Z_LEN  // add on 1st because took off when i=1
		#end
		#if(I = 3)
			object {STEP_CORNER rotate <0,270,0> translate <X+X_LEN,Y,Z>}
			#declare Z_LEN = X_STEP_LEN
			#declare X_LEN = Z_STEP_LEN
			#declare X = (X + Z_LEN) - X_LEN
			#declare Z = Z + X_LEN
		#end
		#if(I = 4)
			object {STEP_CORNER rotate <0,0,0> scale <1.25/*1.25*/,1,1 /*1.2*/> translate <X,Y,Z>}
		#end
		#declare Y = Y - Y_STEP_LEN // due to corners
	#end // end of side

	object {MOSS scale <2,1.5,1> translate <-3,-1.85,-8.95>}
	object {MOSS scale <1,1,1> rotate <0,90,0> translate <6,-0.75,-5>}
	object {MOSS scale <1,1,1> rotate <0,90,0> rotate <-45,0,0> translate <3.1,-0.45,-2.5>}
}


#declare REFLECTIVE_LAKE = 1
#if(REFLECTIVE_LAKE = 0)
	plane
	{
		y,WATER_LEVEL
		pigment {Blue}
	}
#else
	plane
	{
		y,WATER_LEVEL
		pigment {rgb <0,0,.45>}
		normal {bumps 0.035}
		finish {reflection .5 specular .25}
	}
#end

#declare ESCHER_ON = 1
#if(ESCHER_ON = 1)
	object {ESCHER_WATER_FALL rotate <0,45,0> translate <0,0,7.5>}
#else
	box
	{
		<6,0,6>
		<-9,WATER_LEVEL,-9>
		pigment {Red}
		rotate <0,45,0>
		translate <0,0,7.5>
	}
#end

#declare CLIFF_ON = 1
#if(CLIFF_ON = 1)
	height_field
	{
		gif "cliff.gif"
		smooth

		translate <-.5,-0.0001,-.5>
		scale <150,30,80>

		texture
		{
			pigment
			{
				gradient y
				color_map
				{
					[0.0	color rgb <0.16,0.34,0.16>]
					[0.025	color Gray50]
					[0.8	color Gray70]
					[1.0	color Gray90]
				}
				scale 30
			}
			finish {crand .25}
		}

		texture
		{
			pigment
			{
				spotted
				color_map
				{
					[0.0	rgbt <.16,.16,.16,1>]
					[0.5	rgbt <.16,.16,.16,.5>]
					[1.0	rgbt <.16,.16,.16,1>]
				}
				scale .5
			}
			scale 30
		}

		texture
		{
			pigment
			{
				gradient y
				color_map
				{
					[0.0	rgbt <.16,.35,.16,1>]
					[0.1	rgbt <.16,.35,.16,1>]
					[0.1	rgb <1,1,1>]
					[0.104	rgb <1,1,1>]
					[0.104	rgbt <.16,.35,.16,1>]
					[1.0	rgbt <.16,.35,.16,1>]
				}
				scale 30
				rotate <0,0,5>
				turbulence 3/30
				translate <0,-1.6,0>
			}
		}

		translate <0,WATER_LEVEL,25>
	}
#end

#declare SKY_ON = 1
#if(SKY_ON = 1)
	sky_sphere {S_Cloud3}
#end

#declare XSF = .5 // Xtra Scale Factor

#declare REEDS_ON = 1
#if(REEDS_ON = 1)
	#declare PSEED = seed(15)
	#declare ROW_COUNT = 3
	#declare ROW = 0
	#while(ROW<ROW_COUNT)
		#declare SF = 1
		#declare YROT = 10
		#while(YROT < 90)
			#declare BR_REED = 1
			#include "reeds.inc"
			object {reeds scale SF*XSF translate <-ROW,WATER_LEVEL,30+ROW> rotate <0,YROT,0>}
			#declare SF = min(2,SF+.25)
			#declare YROT = YROT + ((rand(PSEED)*2.5)+2.5)*XSF
		#end
		#declare ROW = ROW + 1
	#end

	#declare ROW_COUNT = 3
	#declare ROW = 0
	#declare SF = 1
	#while(ROW<ROW_COUNT)
		#declare YROT = 20
		#while(YROT < 55)
		#if(SF = 1)
			#declare BR_REED = 1
		#else
			#declare BR_REED = 0
		#end
			#include "reeds.inc"
			object {reeds scale SF*XSF translate <ROW,WATER_LEVEL,(29-(ROW*1.5))+(rand(PSEED)*.25)> rotate <0,YROT,0>}
			#declare YROT = YROT + ((rand(PSEED)*2.5)+1.5)*XSF
		#end
		#declare ROW = ROW + 1
		#declare SF = max(.5,SF-.2)
	#end
#end

#declare LILYS_ON = 1
#if(LILYS_ON = 1)
	#declare PINK_LILY = 0
	#include "water_lily.inc"
	#declare ROWS = 5
	#declare COUNT = 8
	#declare LILYSEED = seed(20)
	#declare XT = 11
	#declare ZT = -4.75
	object {giant_water_lily_leaf scale XSF rotate <0,-45+180,0> translate <XT+(1.4*XSF),WATER_LEVEL,ZT>}
	#declare RN = 0
	#while(RN < ROWS)
		#declare X = XT
		#declare Z = ZT
		#declare LN = 0
		#while(LN<COUNT)
			#declare RV1 = rand(LILYSEED)
			#declare RV2 = rand(LILYSEED)
			#if(RV1 < 0.5)
				#declare RV1 = RV1 * -1
			#else
				#declare RV1 = RV1 / 2
			#end
			#declare RV1 = RV1/4
			#if(RV2 < 0.5)
				object {giant_water_lily_leaf scale XSF rotate <0,(RV2*-45)+180,0> translate <X+(RV1*XSF),WATER_LEVEL,Z+(RV1*XSF)>}
				#if(RV2 < 0.3)
					#if(RV2 < 0.15)
						#declare PINK_LILY = 1
						#include "water_lily.inc"
						object {water_lily_flower scale XSF translate <X+(RV1*XSF),WATER_LEVEL,Z+(RV1*XSF)>}
						#declare PINK_LILY = 0
						#include "water_lily.inc"
					#else
						object {water_lily_flower scale XSF translate <X+(RV1*XSF),WATER_LEVEL,Z+(RV1*XSF)>}
					#end
				#end
			#else
				object {water_lily_leaf scale XSF rotate <0,(RV2*-45)+180,0> translate <X+(RV1*XSF),WATER_LEVEL,Z+(RV1*XSF)>}
			#end
			#declare X = X + (3 + RV1)*XSF
			#declare Z = Z + (1.6 + RV1)*XSF
			#declare LN = LN + 1
		#end
		#declare XT = XT - (1.6*XSF)
		#declare COUNT = COUNT - 1
		#declare RN = RN + 1
	#end
#end

// bits and bobs
#declare PINK_LILY = 0
#include "water_lily.inc"
object {giant_water_lily_leaf scale XSF translate <-8,WATER_LEVEL,-3>}
object {giant_water_lily_leaf scale XSF translate <-10,WATER_LEVEL,-5>}
#declare PINK_LILY = 1
#include "water_lily.inc"
object {giant_water_lily_leaf scale XSF translate <-12,WATER_LEVEL,-1>}
object {water_lily_flower scale XSF translate <-12,WATER_LEVEL,-1>}

object {FISH translate <-22,WATER_LEVEL,20>}

// light and camera

light_source {<0,2000,-2000> color White shadowless}
light_source {<-54,100,-42> color White}

camera
{
//	location <0,30,0> // overhead
	location <0,11,-15> // final
	look_at <0,0,0>
}
