
#include "RobotHand31.inc"

// Glenn's Robot POV-Ray Object File
// first concept 22-Jul-98 last update 29-Aug-98
// Based on Glenn's "BlobMan.inc"
// copyright Glenn McCarter 1998
// This file does not render.  #include "Robot31.inc" in another .pov file
//
// Objects:
// "Robot"
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system
// Origin at base of neck
// +X is towards the back of the person.
// Sorry, this system does not incorporate inverse kinematics.
// For POV-Ray version 3.1+

//================================================================
//      Remove this section -- only used for test renders!
//================================================================

/*
#include "GRuler.inc"
//#include "Colors.inc"
//#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-13, -10, 7> // origin closeup
//  look_at   <0.000, 0.000, 0.000>
//  location  <-33, -0, 7> // head front view
//  look_at   <0.000, 0.000, 4.000>
//  location  <2, -30, 4> // head side view
//  look_at   <2, 0, 4>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-25, -22, 7> // 3/4 head view
//  look_at   <0.000, 0.000, 4.000>
//  location  <0, -66, 0> // overall side view
//  look_at   <0, 0, -6>
//  location  <-60, 0, 4> // overall front view
//  look_at   <0, 0, -4>
  location  <-52, -48, 8> // 3/4 overall view
  look_at   <0.000, 0.000, -8.000>
  location  <-18, -55, 8> // render view
  look_at   <-8, 0, -4>
	angle 40
}
camera { Render_Cam }
//object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb60Watt translate <40,-80,70> }
object {StdBulb100Watt translate <-100,-40,80> }
*/

//===============================================
//             Variable Declarations
//===============================================

#ifndef ( Pose )
// Pose Angles ( in order )
#declare HPan     = 32;   // head, positive = towards his left
#declare HTiltFwd = 15;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 20;   // twists the hand, positive = palms up
#declare REAng    = 70;  // elbow
#declare RAFwd    = 43;   // total arm
#declare RARot    = 12;   // claps hands
#declare RAOut    = 12;   // opens underarm
#declare RAFwd2   = 0;    // total arm
#declare RARot2   = 0;    // claps hands
#declare RKnee    = 0;    // duh
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 0;    // leg angle
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 20;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle
#declare LETwist  = 140;  // twists the hand, positive = palms up
#declare LEAng    = 36;   // elbow
#declare LAFwd    = 12;   // total arm
#declare LARot    = 12;   // claps hands
#declare LAOut    = 70;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = -20;  // claps hands
#declare LKnee    = 0;    // duh
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 0;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle

// RightHand Pose Angles ( in order )
#end

//===============================================
//             Textures
//===============================================

#declare SuitTex = // Police Blue
	texture {
		pigment {color rgb<.15,.15,.6> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .3 roughness .03 }
	}
//#declare ClothTex = texture { SuitTex }

#declare ClothTex =
	texture {
		pigment {color rgb<1.0,.94,.65>*.6 }
		normal {
			crackle 0.5
			scale <.2,.2,.2>
		}
		finish { ambient .3 specular .3 roughness .03 reflection .45 }
	}
#declare RobotHeadTex =
	texture {
		pigment { color rgb<.92,.85,.76> } // coppery
		normal {
			crackle 0.4
			scale <.08,.08,.08>
		}
		finish { ambient .12 specular .8 metallic roughness .02 reflection .2 }
	}


//===============================================
//       Objects
//===============================================


#declare TorsoHalf =
	union {
		sphere { // upper shoulders
			<0,0,0>,9
			scale <.4,1,.4>
			texture { ClothTex }
		}
		cylinder { //torso
			<0,0,0>,<0,0,-8>,9
			scale <.4,1,1>
			texture { ClothTex }
		}
		sphere { // lower end
			<0,0,0>,9
			scale <.4,1,.3>
			translate <0,0,-8>
			texture { ClothTex }
		}
		rotate <10,0,0>
		clipped_by { box {<-6,0,6>,<6,-12,-30>}}
	}

#declare Torso = //center where neck&shoulder join each other
	union {
		object { TorsoHalf }
		object { TorsoHalf transform InverseY }
	}
#declare LHand = // points straight down
	object { LeftHand
//	object { LeftHandWithGunFiring
			rotate <0,-90,0> // point downwards
			rotate <0,LWCock,LWAng> // wrist angles
			translate <-0.0,0.6,-1.6> // drop down, move to touch sleeve
		}
#declare LLowerArm =
	union {
		object { LHand }
		cone { //lower sleeve except cuff
			<0,0,2>,1.82,<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,0>
		}
		cylinder {
			<0,-2.4,11>,<0,2.4,11>,2.5
			texture { ClothTex }
		}
		cylinder { //lower sleeve outer cuff
			<0,0,0>,<0,0,2.1>,1.9
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,0>
		}
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,0>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare LeftArm = //origin at shoulder
	union {
		object { LLowerArm rotate <0,0,LETwist> rotate <0,LEAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		difference {
			cylinder { //shoulder endcap
				<0,-3,11>,<0,3,11>,3.0
				texture { ClothTex }
			}
			cylinder { //shoulder cutout
				<0,-4,11>,<0,-2.3,11>,1.6
				texture { ClothTex }
			}
			rotate <0,0,35> // stupid kludge for better appearance
		} // end difference
		translate <0,0,-11> // origin at shoulder
	}

#declare RHand = // points straight down
	object { RightHand
		rotate <0,-90,0> // point downwards
		translate <0.0,-0.6,-1.0> // drop down, move to touch sleeve
	}
#declare RLowerArm =
	union {
		object { RHand }
		cylinder {
			<0,-2.4,11>,<0,2.4,11>,2.5
			texture { ClothTex }
		}
		cone { //lower sleeve outer cuff
			<0,0,0>,1.9,<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,0>
		}
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,0>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare RightArm = //origin at shoulder
	union {
		object { RLowerArm rotate <0,0,-RETwist> rotate <0,REAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		difference {
			cylinder { //shoulder endcap
				<0,-3,11>,<0,3,11>,3.0
				texture { ClothTex }
			}
			cylinder { //shoulder cutout
				<0,2.3,11>,<0,4,11>,1.6
				texture { ClothTex }
			}
		} // end difference
		translate <0,0,-11> // origin at shoulder
	}

#declare RLowerLeg =
	union {
		sphere { // knee end
			<0,0,17>,2.5
			texture { ClothTex }
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare LLowerLeg =
	union {
		sphere { // knee end
			<0,0,17>,2.5
			texture { ClothTex }
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare RightLeg = // origin at pelvis joint
	union {
		object { RLowerLeg rotate <0,0,-RLTwist> rotate <0,-RKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
			texture { ClothTex }
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,15>,3.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		difference {
			cylinder { // pelvis end
				<0,-3.5,15>,<0,3.5,15>,3.5
				texture { ClothTex }
			}
			cylinder { // cutout
				<0,2.5,15>,<0,4,15>,2.0
				texture { ClothTex }
			}
		} // end difference
		translate <0,0,-15> // origin at pelvis joint
	}

#declare LeftLeg = // origin at pelvis joint
	union {
		object { LLowerLeg rotate <0,0,-LLTwist> rotate <0,-LKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
			texture { ClothTex }
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,15>,3.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		difference {
			cylinder { // pelvis end
				<0,-3.5,15>,<0,3.5,15>,3.5
				texture { ClothTex }
			}
			cylinder { // cutout
				<0,-2.5,15>,<0,-4,15>,2.0
				texture { ClothTex }
			}
		} // end difference
		translate <0,0,-15> // origin at pelvis joint
	}

#declare Hips =
	union {
		sphere { // top of cyl
			<0,0,0>,3
			scale <.8,1,.4>
			translate <0,0,8>
			texture { ClothTex }
		}
		cylinder { // main part
			<0,0,0>,<0,0,8>,3
			scale <.8,1,1>
			translate <0,0,0>
			texture { ClothTex }
		}
		sphere { // bottom of cyl
			<0,0,0>,3
			scale <.8,1,.4>
			translate <0,0,0>
			texture { ClothTex }
		}
	} // end union

#declare LowerTorso =
	union {
		object { Hips translate <0,0,0> rotate <-HipTude/2,0,0>}
		object { LeftLeg
			rotate <-LLOut,-LLAng,0>
			translate <0,-4,0>
		}
		object { RightLeg
			rotate <RLOut,RLAng,0>
			translate <0,4,0>
		}
	} // end union

#declare RobotHead =
	union {
		difference {
			sphere { // head
				<0,0,0>,4
				scale <1.2,1,.7>
			}
			box { // eye slit
				<-8,-8,0>,<-2,8,.7>
				translate <0,0,1>
			}
		} // end difference
		cylinder { // neck
			<0,0,-9>,<0,0,0>,2.5
		}
		texture { RobotHeadTex }
		translate <0,0,6>
	}


#declare Robot = //center at base of neck
	union {
		object { RobotHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Torso rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}
		object { LowerTorso
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
		bounded_by { box { <-30,-30,-6*Feet>,<30,30,18> } }
	}


//object { Robot }

//sphere {<0,0,-3>,3 pigment { White } }
