
// Glenn's POV-Ray Object File - NanoTron
// created 27-Jul-98
// last update 30-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "NanoTron.inc" in another .pov file
// This file requires a bitmap "Atom.png"
//
// Objects:
// NanoTron(HingeAngle)
//
// NanoTron, a device for manipulation of individual atoms.
// The version here is a state-of-the-art "pocket" model,
// a general assembler, with self-contained power source,
// on-board feed stocks, and 8cc chamber size.
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// For POV-Ray version 3.1+

//===============================================
//             Variables
//===============================================

#declare mm= 1/25.4;


//===============================================
//             Textures
//===============================================

#declare DarkPlastic =
	texture {
		pigment { rgb<.06,.08,.11> }
		finish { ambient .2 specular .7 roughness .005 }
	}

#declare DisplayFilmTex =
	texture {
		pigment { rgbt<1,1,1,1> }
		finish { ambient .2 specular .7 roughness .005 }
	}

#declare ClearBox =
	texture {
		pigment { rgbt<1,1,1.13,.92> }
		finish { ambient .1 specular .87 roughness .005 }
	}

#declare PedestalTex =
	texture {
		pigment { rgb<.51,.51,.51> }
		finish { ambient .2 specular .7 roughness .005 }
	}
#declare BlueChrome =
	texture {
		pigment { color rgb <0.29, 0.31, 0.53> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .01
			reflection 0.15
		}
	}


//===============================================
//             Objects
//===============================================

//------------- Lid Assembly --------------------

#declare Logo =
	union {
		box { // base
			<0,0,0>,<-.75,-1,.1>
			texture { pigment { color rgb<.14,.17,.20> } normal { bumps .4 scale .08 } }
		}
		height_field {
			png "LogoHF1.png" // extends into +Y
			water_level .01 // eliminate background
			transform InverseY // pop out into -Y
			rotate <90,0,-90> // face down
			translate <0.25,-0.12,0> // center on base
			texture { BlueChrome }
		}
	}


#declare Lid = // origin at center face, face down
	union {
		difference { // lid
			object { RoundedHalfBox(.2) // top
				scale <3,6,.4>
				translate <0,0,.2> // face sits on Z=0 plane
			}
			box { // imager cutout hole
				<-1.08,-1.45,-2>,<0.08,-2.55,2>
			}
			box { // display cutout
				<0,0,-2>,<2.2,3.2,0.2>
				translate <-1.1,-1.1,0>
			}
			box { // cutout for microphone
				<-.1,-0.13,-.1>,<2.2,0.13,.07>
				translate <-1.5,2.5,0>
			}
			box { // cutout for microphone
				<2.1,-0.18,-.1>,<2.45,0.18,.07>
				translate <-1.5,2.5,0>
			}
			cylinder { // cutout for microphone
				<2.45,0,-.1>,<2.45,0,.07>,.18
				translate <-1.5,2.5,0>
			}
			box { // cutout for slider
				<-.10,-1.0,-.1>,<.10,1.0,.10>
				translate <1.32,1.0,0>
			}
		} // end difference
		box { // display
			//sits on xy plane, at z=0
			#local ImageWidth = 3;
			#local ImageHeight = 2;
			<0,0,0>,<ImageWidth,ImageHeight,.001>
//			texture { PaperWhite } // test
			texture {
				pigment {
						image_map { // image is always projected from -z, with front facing +z
						png "Atom.png"
						once
						}
				}
				finish { ambient .9 }
				scale <ImageWidth,ImageHeight,1>
			}
			rotate <180,0,-90> // orient to lid
			translate <1.0,2.0,0.15>
		}
		box { // display cover film
			<0,0,-0.08>,<2.2,3.2,0>
			translate <-1.1,-1.1,0.2>
			texture { DisplayFilmTex }
		}
		box { // latch
			<-.03,-.09,-.15>,<.03,.09,.10>
			translate <-1.4,0,0>
		}
		box { // slider
			<-.08,-.3,-.05>,<.08,.3,.10>
			translate <1.32,.7,0>
		}
		cylinder { // slider rib
			<-.08,0,-.05>,<.08,0,-.05>,.03
			translate <1.32,.7,0>
		}
		cylinder { // slider rib
			<-.08,0,-.05>,<.08,0,-.05>,.03
			translate <1.32,.7-.17,0>
		}
		cylinder { // slider rib
			<-.08,0,-.05>,<.08,0,-.05>,.03
			translate <1.32,.7+.17,0>
		}
		object { Logo translate <1.10,-1.5,-0.08> }
	} // end union


//------------- Base Assembly --------------------

#declare ImagerLight =
  light_source {
    <0,0,0>
    color rgb <.96, .95, 1>*1.8
    spotlight
    point_at <0,0,-10>
    radius 15    // degrees fully lit (*2)
    falloff 30   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .01
        texture {
          pigment { color rgb<.96,.95,1> }
          finish { ambient .65 diffuse .2 }
        }
      }
    }
  }

#declare InteriorStuff =
	union {
		difference {
			box { // platform
				<-.1,-.1,0>,<.1,.1,.2>
			}
			cylinder { <-.2,0,.10>,<.2,0,.10>,.07 }
			cylinder { <.15,-.2,.10>,<.15,.2,.10>,.07 }
			texture { pigment { color rgb<.35,.38,.47> } }
		} // end difference
		box {
			<-.02,-.02,.2>,<.02,.02,.28>
			texture { pigment { color rgb<.55,.58,.97> } }
		}
		cylinder {
			<0,0,.2>,<0,0,.25>,.01
			translate <-.05,.04,0>
			texture { pigment { color rgb<.55,.58,.97> } }
		}
	}

#declare Imager =
	union {
		object { InteriorStuff translate <0,0,.1> }
		object { ImagerLight rotate <-35,-35,0> translate <-.43,.43,.60> }
		difference {
			object { RoundedHalfBox(.15) // base
				scale <1.12,1.12,.1> translate <0,0,.05>
			}
			difference { // channel for seal area
				box { <-.55,-.55,.05>,<.55,.55,.2> } // outer
				box { <-.45,-.45,0>,<.45,.45,.3> } // inner
			} // end difference
			texture { PedestalTex }
		} // end difference
		difference {
			object { RoundedHalfBox(.10) // vaccuum cover
				scale <1,1,.7> translate <0,0,.3>
				texture { ClearBox }
			}
			box { <-.45,-.45,-1>,<.45,.45,.65> texture { ClearBox } }
		} // end difference
		cylinder { <0,-0.08,0>,<0,.08,0>,.05 translate <.5,-.35,.1> texture { PedestalTex } } // hinge
		cylinder { <0,-0.08,0>,<0,.08,0>,.05 translate <.5, .35,.1> texture { PedestalTex } } // hinge
	}

#declare Base = // centered on XY plane, face at Z=0.4
	union {
		difference {
			object { RoundedHalfBox(.2) // main base
				scale <3,6,.4>
				rotate x*180 // rounded corners on bottom
				translate <0,0,.2> // set on ground
			}
			box { // cutout for image
				<0,0,.34>,<2.2,3.2,.5>
				translate <-1.1,-1.1,0>
			}
			box { // cutout for microphone
				<-.1,-0.13,-.24>,<2.2,0.13,.1>
				translate <-1.5,2.5,0.4>
			}
		} // end difference
		box { // display
			//sits on xy plane, at z=0
			#local ImageWidth = 3;
			#local ImageHeight = 2;
			<0,0,0>,<ImageWidth,ImageHeight,.001>
			texture {
				pigment {
						image_map { // image is always projected from -z, with front facing +z
						png "Display.png"
						once
						}
				}
				finish { ambient .26 }
				scale <ImageWidth,ImageHeight,1>
			}
			rotate <0,0,-90> // orient to base
			translate <-1.0,2.0,0.35>
		}
		object { Imager translate <-.5,-2.0,0.4> }
	}

#declare Microphone =
	union {
		cylinder { // main
			<0,0,0>,<0,0,1.5>,.06
		}
		box { // top
			<0,0,-.14>,<.2,.2,0>
			translate <-.1,-.1,1.5>
		}
		difference {
			cylinder { // mike
				<0,0,0>,<0,0,.33>,.10
				translate <0,0,1.5>
				texture { pigment { color rgb<.55,.58,.67> } }
			}
			cylinder { <-.2,0,0>,<.2,0,0>,.04 rotate z*0 translate <0,0,1.60> } // hole
			cylinder { <-.2,0,0>,<.2,0,0>,.04 rotate z*0 translate <0,0,1.70> } // hole
		} // end difference
		difference {
			sphere { // mike
				<0,0,0>,.10
				scale <1,1,.5>
				translate <0,0,1.83>
			}
			cylinder { // vertical hole
				<0,0,0>,<0,0,.4>,.04 translate <0,0,1.5>
			}
			texture { pigment { color rgb<.45,.48,.57> } }
		} // end difference
	}


#macro NanoTron(HingeAngle,MikeAngle)
	union {
		object { Base }
		object { Microphone rotate <0,90-MikeAngle,0> translate <-1.5,2.5,0.3> }
		object { Lid
			translate <-1.5,0,.2>
			rotate y*HingeAngle // open the lid
			translate <1.5,0,.4>
		}
		texture { DarkPlastic }
		translate <0,0,0.15> // set up on feet
	}
#end
